dojo.provide('xg.shared.SendMessageLink');

/**
 * An anchor tag that opens the Send Message box in the Ningbar.
 */
dojo.widget.defineWidget('xg.shared.SendMessageLink', dojo.widget.HtmlWidget, {
    _screenName: '<required>',
    fillInTemplate: function(args, frag) {
        var a = this.getFragNodeRef(frag);
        dojo.event.connect(a, 'onclick', dojo.lang.hitch(this, function(event) {
            dojo.event.browser.stopEvent(event);
            var alerter = ning.Bar.open('user').getAlerter();
            var closeAfter = function(funcName) {
                var func = alerter[funcName];
                alerter[funcName] = function(message, details, after, keepOpen) {
                    func.call(alerter, message, details, function() {
                        if (after) {
                            after();
                        }
                        ning.Bar.close('user');
                    }, keepOpen)
                }
            }
            closeAfter('showAlert');
            closeAfter('showWarning');
            closeAfter('showError');
            ning.social.openSendMessageBox(alerter, this._screenName);
            top.window.scrollTo(0, 0);
        }));
    }
});
