dojo.provide('xg.shared.PagePicker');

dojo.require('dojo.json');

/**
 * A <select> element that goes to another page when you choose one of its items.
 */
dojo.widget.defineWidget('xg.shared.PagePicker', dojo.widget.HtmlWidget, {
    /** JSON array of objects, each with the following properties: displayText, url, selected */
    _options: '<required>',
    /**
     * Initializes the widget.
     */
    fillInTemplate: function(args, frag) {
        var oldSelect = this.getFragNodeRef(frag);
        var options = dojo.json.evalJson(this._options);
        // Setting select's innerHTML is problematic in IE6. We use replaceChild instead. See Neil Crosby, "Problems creating a SELECT box using the DOM in Internet Explorer 6",
        // http://www.workingwith.me.uk/blog/software/web_browser/internet_explorer/problems_create_a_select_box_using_the_dom_in  [Jon Aquino 2007-01-18]
        var selectHtml = '<select>';
        var selectedIndex;
        for (var i = 0; i < options.length; i++) {
            if (options[i].selected) { selectedIndex = i; }
            selectHtml += '<option>' + dojo.string.escape('html', options[i].displayText) + '</option>';
        }
        selectHtml += '</select>';
        var select = dojo.html.createNodesFromText(selectHtml)[0];
        oldSelect.parentNode.replaceChild(select, oldSelect);
        select.selectedIndex = selectedIndex;
        dojo.event.connect(select, 'onchange', dojo.lang.hitch(this, function(event) {
            dojo.event.browser.stopEvent(event);
            window.location = options[select.selectedIndex].url;
        }));
        dojo.style.show(select.parentNode);
    }
});

