dojo.provide('xg.shared.FriendLink');

dojo.require('xg.shared.util');
dojo.require('xg.profiles.embed.thumbnail');
dojo.require("dojo.fx.*");

/* currently only setup to work for remove as friend  but can be expanded*/
dojo.widget.defineWidget('xg.shared.FriendLink', dojo.widget.HtmlWidget, {
    _url: '<required>',
    _user: '<required>',
    _id: '',
    fillInTemplate: function(args, frag) {
        if (this._id) {
            var a = dojo.byId(this._id);
        } else {
            var a = this.getFragNodeRef(frag);
        }
        dojo.style.show(a);
        a.className = "desc removefriend";
        a.innerHTML = xg.shared.nls.html('removeAsFriend');
        dojo.event.connect(a, 'onclick', dojo.lang.hitch(this, function(event) {
            dojo.event.browser.stopEvent(event);
            this.confirmDialog(a);
        }));
    },
    post: function(a) {
        this.posting = true;
        dojo.io.bind({
            url: this._url,
            method: 'post',
            encoding: 'utf-8',
            preventCache: true,
            load: dojo.lang.hitch(this, function(type, data, event){
                this.posting = false;
                if (data == 1) {
                    xg.profiles.embed.thumbnail.loadFromMap();
                    dojo.fx.html.highlight(a, 1000, '#ffee7d');
                } else {
                    // error returned
                    a.className = "desc removefriend";
                    a.innerHTML = xg.shared.nls.html('removeAsFriend');
                }
            })
        });
    },
    confirmDialog: function(a) {
        xg.shared.util.confirm({
            title: xg.shared.nls.html('removeFriendTitle'),
            bodyHtml: '<p>' + dojo.string.escape('html', xg.shared.nls.html('removeFriendConfirm')) + '</p>',
            onOk: dojo.lang.hitch(this, function(event) {
                a.className = "desc working disabled";
                if (this.posting) { return; }
                this.post(a);
            }),
            okButtonText: this._confirmOkButtonText
        });
    }
});