dojo.provide("xg.shared.BazelImagePicker");

dojo.require('dojo.html.*');
dojo.require('dojo.event.browser');
dojo.require('dojo.dom');
dojo.require('xg.index.util.FormHelper');

dojo.widget.defineWidget(
    // widget name and class
    "xg.shared.BazelImagePicker",

    // superclass
    dojo.widget.HtmlWidget,

    // properties and methods
    {
        // parameters
        fieldname:          'image',
        onChange:           function() { },
        allowTile:          1,
        showUseNoImage:     1,
        defaultTile:        0,
        cssClass:           'swatch_group',
        trimUploadsOnSubmit: 1,
        currentImage:       '',
        currentImagePath:   '',
        open: false,
        swatchWidth:'45px',
        swatchHeight:'21px',

        // nls
        nls: {
            uploadAPhoto: xg.shared.nls.html('uploadAPhoto'),
            uploadAPhotoEllipsis: xg.shared.nls.html('uploadAPhotoEllipsis'),
            cancel: xg.shared.nls.html('cancel'),
            useExistingImage: xg.shared.nls.html('useExistingImage'),
            existingImage: xg.shared.nls.html('existingImage'),
            useThemeImage: xg.shared.nls.html('useThemeImage'),
            themeImage: xg.shared.nls.html('themeImage'),
            noImage: xg.shared.nls.html('noImage'),
            uploadImageFromComputer: xg.shared.nls.html('uploadImageFromComputer'),
            tileThisImage: xg.shared.nls.html('tileThisImage'),
            done: xg.shared.nls.html('done'),
            currentImage: xg.shared.nls.html('currentImage'),
            noo: xg.shared.nls.html('noo'),
            none: xg.shared.nls.html('none')
        },


        // attach points
        swatchGroup:        null,
        imagePickerDiv:     null,
        tileCheckboxSpan:   null,
        tileCheckbox:       null,
        actionKeepButton:   null,
        actionThemeButton:  null,
        actionRemoveButton: null,
        actionAddButton:    null,
        currentImageSpan:   null,
        themeImageSpan:     null,
        themeImage:         null,
        fileInput:          null,
        swatchImagePreview: null,
        swatchText:         null,
        currentImagePreview: null,
        themeImagePreview:  null,
        lastAction:         null,
        lastTile:           null,
        useNoImageSpan:     null,

        // settings
        widgetType:     "BazelImagePicker",
        templatePath: dojo.uri.dojoUri("/xn_resources/widgets/shared/js/html/BazelImagePicker.tpl"),

        // methods
        fillInTemplate: function() {
            if (this.allowTile == 0) {
                dojo.html.hide(this.tileCheckboxSpan);
            }
            if (this.showUseNoImage == 0) {
                dojo.html.hide(this.useNoImageSpan);
            }
            if (this.currentImagePath) {
                dojo.html.show(this.currentImageSpan);
            }
            else {
                dojo.html.hide(this.currentImageSpan);
				if (this.showUseNoImage == 0) {
					dojo.html.hide(this.actionAddButton);
				}
            }
            dojo.html.hide(this.themeImageSpan);
        },

        postCreate: function() {
            var form = dojo.dom.getFirstAncestorByTag(this.actionRemoveButton, 'form');

            if (this.trimUploadsOnSubmit == 1) {
            dojo.event.connect(form, 'onsubmit', this, 'onSubmit');
            }
            if (this.defaultTile == 1) {
                this.tileCheckbox.checked = true;
            }
            if (this.currentImagePath) {
                this.updateAttachPointFromImageUrl(this.currentImagePreview, this.currentImagePath);
                this.actionKeepButton.checked = true;
            }
            else {
                this.actionRemoveButton.checked = true;
            }
            this.updateSwatch();
        },

        showhide: function(evt) {
            dojo.event.browser.stopEvent(evt);
            if (this.open) {
                this._hide();
            }
            else {
                this._show();
            }
        },

        _show: function() {
            //  Close all other pickers
            dojo.lang.forEach(dojo.widget.manager.getWidgetsByType(this.widgetType),
                    function (w) {
                        if (w.open) {
                            w._hide();
                        }
                    });

            //  Save current settings for potential cancel
            if (this.actionKeepButton.checked) {
                this.lastAction = 'keep';
            }
            else if (this.actionThemeButton.checked) {
                this.lastAction = 'remove';
            }
            else if (this.actionRemoveButton.checked) {
                this.lastAction = 'remove';
            }
            else {
                this.lastAction = 'add';
            }
            this.lastTile = this.tileCheckbox.checked;

            //  Open the picker
            this.imagePickerDiv.style.left = '0px';
            this.imagePickerDiv.style.zIndex = '100';
            dojo.html.show(this.imagePickerDiv);
            if (dojo.render.html.ie) {
                this._fixIeZIndexBug();
            }
            xg.index.util.FormHelper.scrollIntoView(this.imagePickerDiv);
            this.open = true;
        },

        _hide: function() {
            if (dojo.render.html.safari) {
                // Safari ignores form fields with display:none [Jon Aquino 2007-02-17]
                this.imagePickerDiv.style.zIndex = '-9999';
                this.imagePickerDiv.style.left = '-9999px';
            } else {
                dojo.html.hide(this.imagePickerDiv);
            }
            if (dojo.render.html.ie) {
                this._fixIeZIndexBug();
            }
            this.updateSwatch();
            this.open = false;
        },

        _fixIeZIndexBug: function() {
            if (dojo.html.isDisplayed(this.imagePickerDiv)) {
                //  show iframe
                //  Dynamically set the z-index of the swatch group, for IE
                this.swatchGroup.style.zIndex = '99';
                this.IeIframe.style.width = dojo.style.getInnerWidth(this.imagePickerDiv)
                        - dojo.style.getPaddingWidth(this.imagePickerDiv);
                this.IeIframe.style.height = dojo.style.getInnerHeight(this.imagePickerDiv)
                        - dojo.style.getPaddingHeight(this.imagePickerDiv);
                dojo.html.show(this.IeIframe);
            }
            else {
                // hide iframe
                this.swatchGroup.style.zIndex = '';
                dojo.html.hide(this.IeIframe);
            }
        },

        doCancel: function(evt) {
            //  Restore previous settings
            switch (this.lastAction) {
                case 'keep':
                    this.actionKeepButton.checked = true;
                    break;
                case 'theme':
                    this.actionThemeButton.checked = true;
                    break;
                case 'remove':
                    this.actionRemoveButton.checked = true;
                    break;
                case 'add':
                    this.actionAddButton.checked = true;
                    break;
            }
            this.tileCheckbox.checked = this.lastTile;
            this._hide();
        },

        selectAddAction: function(evt) {
            this.actionAddButton.checked = true;
        },

        updateSwatch: function() {
            //  Update swatch preview based on selected action
            if (this.actionKeepButton.checked) {
                dojo.html.hide(this.swatchText);
                this.swatchImagePreview.src = this.currentImagePreview.src;
                dojo.html.show(this.swatchImagePreview);
            }
            else if (this.actionThemeButton.checked) {
                dojo.html.hide(this.swatchText);
                this.swatchImagePreview.src = this.themeImagePreview.src;
                dojo.html.show(this.swatchImagePreview);
            }
            else if (this.actionRemoveButton.checked) {
                dojo.html.hide(this.swatchImagePreview);
                this.swatchText.innerHTML = '<strong>' + this.nls.none + '</strong>';
                this.swatchText.className = 'swatch none';
                dojo.html.show(this.swatchText);
            }
            else {
                dojo.html.hide(this.swatchImagePreview);
                this.swatchText.innerHTML = '<strong>' + this.nls.noo + '</strong>';
                this.swatchText.className = 'swatch new';
                dojo.html.show(this.swatchText);
            }
            this.onChange();
        },

        setImage: function(url) {
            this.actionThemeButton.checked  = true;
            this.themeImage.value = url;
            this.themeImagePreview.src = url;
            dojo.html.show(this.themeImageSpan);
            this.updateSwatch();
        },

        clearImage: function() {
            this.actionRemoveButton.checked = true;
            dojo.html.hide(this.themeImageSpan);
            this.updateSwatch();
        },

        onSubmit: function(evt) {
            if (this.actionAddButton.checked != true) {
                dojo.dom.removeNode(this.fileInput);
            }
        },

        updateAttachPointFromImageUrl: function(attachPoint, imageUrl) {
            attachPoint.src = imageUrl;
            var dims = { 'height': null, 'width': null };
            dojo.lang.forEach(['height','width'], function (dim) {
                var rx = new RegExp(dim + '=(\\d+)');
                var res = imageUrl.match(rx);
                if (res && res[1]) {
                    dims[dim] = res[1];
                }
            }, false);
            if ((dims.height !== null) && (dims.width !== null)) {
                var aspectRatio = dims.width / dims.height;
                if (dims.width > 100) {
                    attachPoint.width = 100;
                    attachPoint.height = parseInt(attachPoint.width / aspectRatio);
                } else {
                    attachPoint.width = dims.width;
                    attachPoint.height = dims.height;
                }
            } else {
                attachPoint.width = 100;
            }

        }
    }
);
