dojo.provide('xg.shared.AutoUpdatingText');

dojo.require('xg.shared.util');
dojo.require("dojo.lang");

/**
 * An element that listens for dojo.io.bind calls to certain URLs;
 * if an "html" property is in the returned data, the element's innerHTML is set to it.
 */
dojo.widget.defineWidget('xg.shared.AutoUpdatingText', dojo.widget.HtmlWidget, {
    /** Space-delimited set of URLs to listen for */
    _urls: '',
    /** Fade color after the innerHTML is updated */
    _highlightColor: '',
    /** @deprecated Use _urls instead */
    _url: '',
    fillInTemplate: function(args, frag) {
        var node = this.getFragNodeRef(frag);
        var urls = new Array();
        if (this._urls && this._urls.length > 0) {
            urls = this._urls.split(' ');
        } else {
            urls.push(this._url);
        }
        dojo.event.connect('before', dojo.io, 'bind', dojo.lang.hitch(this, function(kwArgs) {
            var url_match = false;
            for (var i=0; i < urls.length; i++){
                if (urls[i].indexOf(kwArgs.url) >= 0){
                    url_match = true;
                    break;
                }
            }
            if ('url' in kwArgs && url_match) {
                dojo.event.connect(kwArgs, 'load', dojo.lang.hitch(this, function(type, data, event) {
                    if (dojo.lang.has(data, "html")) {
                        dojo.require("dojo.fx.*");
                        node.innerHTML = data.html;
                        dojo.style.setShowing(node, data.html);
                        xg.shared.util.fixImagesInIE(node.getElementsByTagName('img'));
                        if (this._highlightColor.length > 0) { dojo.fx.html.highlight(node, 2000, this._highlightColor); }
                    }
                }));
            }
        }));
    }
});
