dojo.provide('xg.profiles.friend.list'); 
dojo.require('dojo.html');
dojo.require('ning.social');
dojo.require('xg.shared.util');
dojo.require('dojo.fx.*');

xg.profiles.friend.list = {
    doSendFriendRequest: function(a, evt) {
        dojo.event.browser.stopEvent(evt);
        var parts = a.id.split('-');
        if (parts.length == 2) {
            var profile_id = parts[1];
            var node = a.parentNode;
            var previousMessage = node.innerHTML;
            node.innerHTML = '<em class="friend-pending desc">' + xg.profiles.nls.html('sendingFriendRequest') + '</em>';
            var callbacks = {
                'success' : function() {
                    node.innerHTML = '<strong class="friend-pending desc">' + xg.profiles.nls.html('requestSent') + '</strong>';
                    dojo.fx.html.highlight(node, 500, '#ff9');
                },
                'error' : dojo.lang.hitch(this, function(msg) {
                    xg.shared.util.alert(msg);
                    node.innerHTML = previousMessage;
                    a = node.getElementsByTagName('a')[0];
                    dojo.event.connect(a, 'onclick', function(evt) {
                        xg.profiles.friend.list.doSendFriendRequest(a, evt);
                    });
                })
            };
            ning.social.sendFriendRequest(profile_id, callbacks);
        }
    }
};

xg.addOnRequire(function() {
    // Wire up all 'addfriend' links to add friend code
    dojo.lang.forEach(dojo.html.getElementsByClass('addfriend', null, 'a'), function(a) {
        if (! dojo.html.hasClass(a, 'nojs')) {
            dojo.event.connect(a, 'onclick', function(evt) {
                xg.profiles.friend.list.doSendFriendRequest(a, evt);
            });
        }
    }, true);
});
