dojo.provide('xg.profiles.embed.thumbnail');

dojo.require('xg.shared.util');
dojo.require('xg.shared.FriendLink');
dojo.require('dojo.fx.*');

xg.profiles.embed.thumbnail = {
    /* Where the initial list of users we care about is set */
    map: { },

    /* Update widgets with info from a query */
    populate: function(data) {
        var relationships = { }
        if (data && data.contacts && data.contacts.values) {
            dojo.lang.forEach(data.contacts.values, function(contact) {
                relationships[contact.id] = contact.contactRelationship;
            }, true);
        }
        dojo.lang.forEach(dojo.widget.byType('ProfileThumbnail'), function(widget) {
            var target = widget.getTarget();
            if (relationships[target]) {
                widget.setRelationship(relationships[target]);
            }
            else if (ning.CurrentProfile && (ning.CurrentProfile.id == target)) {
                widget.setRelationship('self');
            }
            else {
                widget.setRelationship('none');
            }
        }, true);
    },

    /* Do the query to load everything in the map */
    loadFromMap: function() {
        if (ning.CurrentProfile) {
            var tmp = [ ];
            for (var target in xg.profiles.embed.thumbnail.map) { tmp.push(target); }
            if (tmp.length) {
                var url = '/xn/rest/1.0/profile:' + encodeURIComponent(ning.CurrentProfile.id) + "/contact(id in ['" + tmp.join("','")+ "'])?end=" + tmp.length + "&xn_auth=no";
                dojo.io.bind({'url': xg.shared.util.safeBindUrl(url),
                              'method': 'get',
                              'mimetype': 'text/json',
                              encoding: 'utf-8',
                              'preventCache' : true,
                              'load': function(type,data,evt) { xg.profiles.embed.thumbnail.populate(data); }
                });
            }
        }
        // Current user is not signed in, just populate the nodes with emptiness
        else {
            xg.profiles.embed.thumbnail.populate();
        }
    },

    /* Add a new person to the map. Called by the widget's satisfyPropertySets method */
    addToMap: function(target) {
        xg.profiles.embed.thumbnail.map[target] = true;
    }
};

/* The widget to display appropriate relationship links */
dojo.widget.defineWidget('xg.profiles.embed.thumbnail.ProfileThumbnail', dojo.widget.HtmlWidget, {
    _target: '<required>',
    /** Whether the current user is a member of the network */
    _currentUserIsMember: true,
    hasValidTarget: false,
    /** Whether this widget contains other widgets */
    isContainer: true,
    /* Put this widget's target in the map */
    satisfyPropertySets: function(args) {
        // Throw error if  _target isn't defined and not <required>
        if ((! args._target) || (args._target.length == 0) || (args._target == '<required>')) {
            throw new Exception("No _target specified for ProfileThumbnail widget",'foo');
        }
        xg.profiles.embed.thumbnail.addToMap(args._target);
        this.hasValidTarget = true;
    },

    /* Accessor for the target user that this widget cares about */
    getTarget: function() { return this._target; },

    /* Returns the DOM node holding the relationship status, if one exists */
    getRelationshipNode: function() {
        return dojo.html.getElementsByClass('relationship', this.domNode, 'dd')[0];
    },

    /* Generate correct links for the HTML display */
    appropriateHref: function() {
        return (ning.CurrentProfile) ? 'javascript:void(0)' : xg.global.requestBase + '/main/index/sign?target=' + encodeURIComponent(window.location.href);
    },
    addAsFriendHtml: function() { return '<a class="addfriend desc" href="' + this.appropriateHref() + '">' + xg.profiles.nls.html('addAsFriend') + '</a>' },
    
    /* link for removing friendship */
    unfriendUrl: function(user) {
        return '/profiles/profile/unfriend?user='+ user + '&json=yes';
    },
    removeAsFriendHtml: function(user) { return '<a class="removefriend desc" id="removeFriend" href="' + this.unfriendUrl(user) + 
                        '" href="#">' + xg.profiles.nls.html('removeAsFriend') + '</a>' },

    /* Actions that can happen through the displayed HTML */
    addAsFriend: function(evt) {
        // todo: Use xg_add_as_friend_link for the "Add as friend" link. [Jon Aquino 2007-03-21]
        dojo.event.browser.stopEvent(evt);
        var node = this.getRelationshipNode();
        if (node) {
            var previousMessage = node.innerHTML;
            node.innerHTML = xg.profiles.nls.html('sendingFriendRequest');
            var callbacks = {
                'success' : function() {
                    node.innerHTML = xg.profiles.nls.html('requestSent');
                    dojo.fx.html.highlight(node, 500, '#ff9');
                },
                'error' : dojo.lang.hitch(this, function(msg) {
                    xg.shared.util.alert(msg);
                    node.innerHTML = previousMessage;
                    this.activateLinks();
                })
            };
        }
        ning.social.sendFriendRequest(this.getTarget(), callbacks);
    },

    /* Activate the links that may have been added to the display */
    activateLinks: function() {
        dojo.lang.forEach(this.domNode.getElementsByTagName('a'), dojo.lang.hitch(this, function(a) {
            if ((a.href == 'javascript:void(0)') && dojo.html.hasClass(a, 'addfriend')) {
                dojo.event.connect(a, 'onclick', dojo.lang.hitch(this, function(evt) { this.addAsFriend(evt); }));
            }
        }), true);
        if (dojo.byId('removeFriend')) {
            var anchor = dojo.byId('removeFriend');
            dojo.widget.createWidget("FriendLink", {_url : anchor.href, _id : 'removeFriend'});
            xg.shared.util.parseWidgets(anchor);
            anchor.href = '#';
        }
    },

    /* Adjust the widget for the given relationship */
    setRelationship: function(relationship) {
        // Don't do anything if the target is invalid
        if (! this.hasValidTarget) { return; }
        var node = this.getRelationshipNode();
        if (node) {
            var line1;
            if (! this._currentUserIsMember) {
                line1 = '';
            }
            else if (relationship == 'self') {
                line1 = xg.profiles.nls.html('thisIsYou');
            }
            else if (relationship == 'friend') {
                if (this.isProfilePage()) {
                    line1 = this.removeAsFriendHtml(node.innerHTML);
                } else {
                    line1 = xg.profiles.nls.html('isYourFriend');
                }
            }
            else if (relationship == 'pending') {
                line1 = xg.profiles.nls.html('requestSent');
            }
            else if (relationship == 'blocked') {
                line1 = xg.profiles.nls.html('isBlocked');
            }
            else {
                line1 = this.addAsFriendHtml();
            }
            node.innerHTML = line1;
            dojo.style.setDisplay(node, line1.length > 0);
        }
        this.activateLinks();
    },
    
    /* determine if this is a profile page */
    isProfilePage: function() {
        if (document.location.href.indexOf('/profile/') > -1) {
            return true;
        } else {
            return false;
        }
        
    }
});

/* On page load, get the relationship info for the users in the map */
xg.addOnRequire(xg.profiles.embed.thumbnail.loadFromMap);