dojo.provide('xg.page.page.PageEditor');
dojo.require('xg.index.util.FormHelper');

/**
 * A form for editing the text of a page.
 */
// Based on CommentEditor.  [Jon Aquino 2007-01-26]
dojo.widget.defineWidget('xg.page.page.PageEditor', dojo.widget.HtmlWidget, {
    /** The caption for the form */
    _heading: '<required>',
    /** The label for the textarea */
    _label: '<required>',
    /** Comma-delimited string of tags on this page for the current user */
    _tags: '',
    /** The URL to submit to */
    _url: '<required>',
    /** The maximum number of characters allowed for the title. */
    _maxTitleLength: '<required>',
    /** The maximum number of characters allowed for the description. */
    _maxDescriptionLength: '<required>',
    /** The maximum number of characters allowed for the tags field. */
    _maxTagsLength: '<required>',
    /** The error message to show if the person hasn't entered anything */
    _emptyDescriptionErrorMessage: '<required>',
    /**
     * Initializes the widget.
     */
    fillInTemplate: function(args, frag) {
        var editLink = this.getFragNodeRef(frag);
        this.initClickHandler(editLink);
        dojo.style.show(editLink);
    },
    /**
     * Sets up the event handler for the Edit link.
     *
     * @param HTMLElement editLink  The Edit anchor tag
     */
    initClickHandler: function(editLink) {
        dojo.event.connect(editLink, 'onclick', dojo.lang.hitch(this, function(event) {
            dojo.event.browser.stopEvent(event);
            var pageDiv = dojo.dom.getAncestors(editLink, function(node) { return dojo.html.hasClass(node, 'wpage'); }, true);
            dojo.style.hide(pageDiv);
            var container = dojo.html.createNodesFromText(dojo.string.trim(' \
                    <div class="wpage"> \
                        <form id="' + this.widgetId + '_form" action="' + dojo.string.escape('html', this._url) + '" method="post"> \
                            <dl class="errordesc msg" id="' + this.widgetId + '_form_notify" style="display: none; clear: none !important"></dl> \
                            <fieldset> \
                                <legend>' + dojo.string.escape('html', this._heading) + '</legend> \
                                <div class="form_body"> \
                                    <dl> \
                                        <dt><label for="' + this.widgetId + '_title">' + xg.page.nls.html('discussionTitle') + '</label></dt> \
                                        <dd><input id="' + this.widgetId + '_title" name="title" type="text" class="textfield" size="67" style="width:474px;" maxlength="' + this._maxTitleLength + '" /></dd> \
                                    </dl> \
                                    <dl> \
                                        <dt><label for="' + this.widgetId + '_textarea">' + dojo.string.escape('html', this._label) + '</label></dt> \
                                        <dd><textarea id="' + this.widgetId + '_textarea" name="description" rows="20" style="width:474px;" cols="65"></textarea></dd> \
                                    </dl> \
                                    <dl> \
                                        <dt><label for="' + this.widgetId + '_tags">' + xg.page.nls.html('tags') + '</label></dt> \
                                        <dd><input id="' + this.widgetId + '_tags" name="tags" type="text" class="textfield" style="width:474px;" size="67" maxlength="' + this._maxTagsLength + '" /></dd> \
                                    </dl> \
                                    <p class="buttongroup"> \
                                        <input type="submit" class="button submit" value="' + xg.page.nls.html('save') + '"> \
                                        <input type="button" class="button" value="' + xg.page.nls.html('cancel') + '"> \
                                    </p> \
                                </div> \
                            </fieldset> \
                        </form>\
                    </div>'))[0];
            dojo.dom.insertAfter(container, pageDiv);
            var form = container.getElementsByTagName('form')[0];
            form.title.value = dojo.html.renderedTextContent(dojo.byId('xg_body').getElementsByTagName('h1')[0]);
            form.description.value = dojo.html.getElementsByClass('description', pageDiv, 'div')[0].innerHTML.replace(/<br ?.?>\n/gi, "\n");
            form.tags.value = this._tags;
            form.description.focus();
            xg.index.util.FormHelper.scrollIntoView(form);
            this.initValidation(form);
            var buttons = dojo.html.getElementsByClass('button', container, 'input');
            dojo.event.connect(buttons[1], 'onclick', dojo.lang.hitch(this, function(event) {
                dojo.dom.removeNode(container);
                dojo.style.show(pageDiv);
            }));
        }));
    },
    /**
     * Sets up input validation.
     *
     * @param HTMLElement form  The form element to validate
     */
    initValidation: function(form) {
        dojo.event.connect(form, 'onsubmit', dojo.lang.hitch(this, function(event) {
            dojo.event.browser.stopEvent(event);
            if (! xg.index.util.FormHelper.runValidation(form, dojo.lang.hitch(this, function() { return this.validate(form); } ))) { return; }
            form.submit();
        }));
    },
    /**
     * Checks the input for errors.
     *
     * @param HTMLElement form  The form element to validate
     * @return object  Field name => HTML error message
     */
    validate: function(form) {
        var errors = {};
        if (dojo.string.trim(form.description.value).length > this._maxDescriptionLength) {
            errors.description = xg.page.nls.html('numberOfCharactersExceedsMaximum', dojo.string.trim(form.description.value).length, this._maxDescriptionLength);
        }
        if (dojo.string.trim(form.title.value).length == 0) {
            errors.title = dojo.string.escape('html', xg.page.nls.html('pleaseEnterTitle'));
        }
        if (dojo.string.trim(form.description.value).length == 0) {
            errors.description = dojo.string.escape('html', this._emptyDescriptionErrorMessage);
        }
        return errors;
    }
});
