dojo.provide('xg.index.feature.list');

dojo.require('xg.index.util.FormHelper');
dojo.require('dojo.html.*');
dojo.require('dojo.lfx.*');
dojo.require('dojo.string.*');
dojo.require('dojo.event.*');
dojo.require('xg.index.feature.BazelFeature');

xg.index.feature.list = {
    submitForm: function(evt) {
        if (evt) { dojo.event.browser.stopEvent(evt); }
        var errors = { };
        var errorCount = 0;
        // validate each feature title
        var elements = dojo.byId('xg_features_form').elements;
        for (var n = 0; n < elements.length; n++) {
            if (dojo.string.endsWith(elements[n].name, '_title')
                    && !elements[n].disabled) {
                var featureName = elements[n].name.substring(0, elements[n].name.length - 6);
                elements[n].value = dojo.string.trim(elements[n].value);
                var displayName = dojo.widget.byId('xg_feature_' + featureName).displayName;
                if (elements[n].value.length === 0) {
                    errors[elements[n].name] = xg.index.nls.html('pleaseEnterTitleForFeature', displayName);
                    errorCount++;
                }
            }
        }
        if (errorCount) {
            xg.index.util.FormHelper.showErrorMessages(dojo.byId('xg_features_form'), errors, xg.index.nls.html('thereIsAProblemWithTheInformation'));
        }
        else {
            dojo.byId('xg_features_form').submit();
        }
    },

    setMainFeature: function(name) {
        dojo.byId('xg_features_form').mainFeature.value = name;
        //  Show all widgets as NOT the main feature
        dojo.lang.forEach(dojo.widget.manager.getWidgetsByType('BazelFeature'), function (w) {
            w.unsetMainFeature();
        });
        //  Get the dojo widget instance for the new main feature
        var newMainWidget = dojo.widget.byId('xg_feature_' + name);
        if (newMainWidget) {
            var newMainLi = newMainWidget.li;
            //  Move it to the top if it isn't there already
            if (newMainLi != newMainLi.parentNode.firstChild) {
                //var clone = newMainLi.cloneNode(true);
                //newMainLi.parentNode.replaceChild(clone, newMainLi);
                //dojo.html.setOpacity(newMainLi, 0.0);
                //newMainLi.style.height = "1px";
                var container = dojo.byId('xg_feature_list');
                newMainLi.parentNode.removeChild(newMainLi);
                container.insertBefore(newMainLi, container.firstChild);
                //newMainWidget.setMainFeature();
                //dojo.lfx.fadeOut(clone, 500, null).play();
                //dojo.lfx.wipeOut(clone, 500, null, function(){
                //    dojo.dom.removeNode(clone);
                //}).play();
                //dojo.lfx.fadeIn(newMainLi, 500, null).play();
                //dojo.lfx.wipeIn(newMainLi, 500, null).play();
            }
            //  Show it as the main feature
            newMainWidget.setMainFeature();
        }
        xg.index.feature.list.updatePreview(name);
    },

    updatePreview: function(name) {
        if (name == 'profiles') {
            //  One feature center, two left
            dojo.html.show('xg_preview_feature_center_1_long');
            dojo.html.hide('xg_preview_feature_center_1');
            dojo.html.hide('xg_preview_feature_center_2');
            dojo.html.show('xg_preview_feature_left_1');
            dojo.html.show('xg_preview_feature_left_2');
        }
        else {
            //  Two features center, one left, center name changes
            dojo.html.show('xg_preview_feature_center_1');
            dojo.html.show('xg_preview_feature_center_2');
            dojo.html.hide('xg_preview_feature_center_1_long');
            if (name == 'photo') {
                dojo.byId('xg_preview_feature_center_1_label').innerHTML = xg.index.nls.html('photos');
                dojo.html.hide('xg_preview_feature_left_1');
                dojo.html.show('xg_preview_feature_left_2');
            }
            else {
                dojo.byId('xg_preview_feature_center_1_label').innerHTML = xg.index.nls.html('videos');
                dojo.html.show('xg_preview_feature_left_1');
                dojo.html.hide('xg_preview_feature_left_2');
            }
        }
    },

    addModule: function(name) {
        var module = dojo.byId('xg_feature_' + name);
        var clone = module.cloneNode(true);
        module.parentNode.replaceChild(clone, module);
        dojo.html.setOpacity(module, 0.0);
        module.style.height = "1px";
        dojo.byId('xg_feature_list_enabled').appendChild(module);
        dojo.widget.byId('xg_feature_' + name).enable();
        dojo.lfx.fadeOut(clone, 500, null).play();
        dojo.lfx.wipeOut(clone, 500, null, function(){
            dojo.dom.removeNode(clone);
        }).play();
        dojo.lfx.fadeIn(module, 500, null).play();
        dojo.lfx.wipeIn(module, 500, null).play();
    },

    removeModule: function(name) {
        var module = dojo.byId('xg_feature_' + name);
        var clone = module.cloneNode(true);
        module.parentNode.replaceChild(clone, module);
        dojo.html.setOpacity(module, 0.0);
        module.style.height = "1px";
        dojo.byId('xg_feature_list_disabled').appendChild(module);
        dojo.widget.byId('xg_feature_' + name).disable();
        dojo.lfx.fadeOut(clone, 500, null).play();
        dojo.lfx.wipeOut(clone, 500, null, function(){
            dojo.dom.removeNode(clone);
        }).play();
        dojo.lfx.fadeIn(module, 500, null).play();
        dojo.lfx.wipeIn(module, 500, null).play();
    },

    handleLaunchBarSubmit: function(url, evt) {
        dojo.event.browser.stopEvent(evt);
        var form = dojo.byId('xg_features_form');
        if (form.successTarget && url) {
            form.successTarget.value = url;
        }
        xg.index.feature.list.submitForm();
    }

};

xg.addOnRequire(function() {
    var form = dojo.byId('xg_features_form');
    xg.index.feature.list.setMainFeature(form.mainFeature.value);
    dojo.event.connect(form, 'onsubmit', xg.index.feature.list, 'submitForm');
});


