dojo.provide('xg.index.feature.add');
dojo.require('dojo.dnd.*');
dojo.require('dojo.json');
dojo.require('xg.shared.util');

xg.index.feature.add = {
    availableFeatureList: [],
    highlightedTarget: null,
    successfulDrop: 0,
    
    //  Make note of the initial set of features and their properties for later
    //    updates to this list
    recordAvailableFeatures: function() {
        xg.index.feature.add.availableFeatureList = [];
        var ul = dojo.byId('xg_add_features_source');
        var lis = ul.getElementsByTagName("li");
        for(var x=0; x<lis.length; x++){
            xg.index.feature.add.availableFeatureList.push(lis[x]);
        }
    },

    //  Updates the list of available features on the left to indicate which are
    //    now available to be dragged to the page
    updateFeatureList: function() {
        //  Count embeds in the layout
        var currentEmbeds = {};
        var columns = 3;
        for (var col = 1; col <= columns; col++) {
            dojo.lang.forEach(dojo.byId('xg_add_features_preview_col' + col).getElementsByTagName('li'),
                    function(li) {
                        var name = li.getAttribute('xg_feature_name');
                        if (name) {
                            if (currentEmbeds[name]) {
                                currentEmbeds[name]++;
                            }
                            else {
                                currentEmbeds[name] = 1;
                            }
                        }
                    });
        }
        dojo.lang.forEach(dojo.byId('xg_add_features_preview_sidebar').getElementsByTagName('li'),
                function(li) {
                    var name = li.getAttribute('xg_feature_name');
                    if (name) {
                        if (currentEmbeds[name]) {
                            currentEmbeds[name]++;
                        }
                        else {
                            currentEmbeds[name] = 1;
                        }
                    }
                });

        //  Clear feature list
        var dl = dojo.byId('xg_add_features_source');
        dojo.dom.removeChildren(dl);

        // z-index set explicitly on both the containing relative block and the 
        // contained absolute pop-up in a manner derived from:
        //      http://www.aplus.co.yu/lab/z-pos/index5.php
        // to suit the vagaries of Internet Explorer [bakert 2007-09-07]
        var nodeZindex = 1000;
        var popupZindex = 100;
        //  Replace features not yet at their limit
        dojo.lang.forEach(xg.index.feature.add.availableFeatureList, function(li) {
            var name = li.getAttribute('xg_feature_name');
            var limit = li.getAttribute('xg_embed_limit');
            var width = li.getAttribute('xg_width_option');
            if (typeof(currentEmbeds[name]) == 'undefined' || currentEmbeds[name] < limit) {
                var node = li.cloneNode(true);
                new dojo.dnd.HtmlDragSource(node, width);
                dojo.dom.insertAtPosition(node, dl, 'last');
                node.style.zIndex = nodeZindex--;
                dojo.lang.forEach(dojo.html.getElementsByClass('context_help_popup', node), function(chp) {   
                    chp.style.zIndex = popupZindex--;
                });
            }
        });

        // Now parse the widgets in the list to enable the tooltip help.
        xg.shared.util.parseWidgets(dl);
        //  Show the feature list if we haven't yet
        dojo.html.show(dl);
    },

    onDrop: function(evt) {
        xg.index.feature.add.successfulDrop = 1;
        xg.index.feature.add.moveDraggableBelowFixed();
        xg.index.feature.add.hideContextHelp();
        xg.index.feature.add.updateFeatureList();
    },

    onDropTrash: function(evt) {
        xg.index.feature.add.successfulDrop = 1;
        var ul = dojo.byId('xg_add_features_trash');
        var lis = ul.getElementsByTagName("li");
        for(var x=0; x<lis.length; x++){
            ul.removeChild(lis[x]);
        }
        xg.index.feature.add.updateFeatureList();
    },

    hideContextHelp: function(evt) {
        var cols = ['xg_add_features_preview_col1', 'xg_add_features_preview_col2', 'xg_add_features_preview_col3',
                'xg_add_features_preview_sidebar'];
        for (var x=0; x<cols.length; x++) {
            dojo.lang.forEach(dojo.html.getElementsByClass('context_help', dojo.byId(cols[x])), function(node) {
                dojo.style.setVisibility(node, false);
            });
        }
    },

    moveDraggableBelowFixed: function(evt) {
        // If we ever have fixed items in any other column we will need to do this to them, too.
        var sidebar = dojo.byId('xg_add_features_preview_sidebar');
        while (! xg.index.feature.add.inCorrectOrder(sidebar.getElementsByTagName('li'))) {
            var items = sidebar.getElementsByTagName('li');
            var firstOutOfOrder = xg.index.feature.add.firstOutOfOrder(items);
            var nextElement = dojo.dom.nextElement(firstOutOfOrder);
            if (firstOutOfOrder && nextElement) {
                dojo.dom.removeNode(nextElement);
                dojo.dom.insertBefore(nextElement, firstOutOfOrder);
            }
        }
    },
    
    inCorrectOrder: function(items) {
        return(xg.index.feature.add.firstOutOfOrder(items) == null);
    },
    
    firstOutOfOrder: function(items) {
        for (var i = 0; i < items.length; i++) {
            if (dojo.html.hasClass(items[i], 'noedit')) { continue; }
            // ads are a special case and can be dragged anywhere except above the login box.
            if (xg.index.feature.add.isFeature(items[i], '_ads') && i != 0) { continue; }
            var fixedBelow = false;
            for (var j = i + 1; j < items.length; j++) {
                if (dojo.html.hasClass(items[j], 'noedit')) { fixedBelow = true; }
            }
            if (! fixedBelow) { return null; }
            return items[i];
        }
        return null;
    },
    
    isFeature: function(element, featureName) {
        return (element && dojo.html.hasAttribute(element, 'xg_feature_name') && (dojo.html.getAttribute(element, 'xg_feature_name') == featureName));
    },

    aroundEnterTarget: function(invocation) {
        var retval = invocation.proceed();
        xg.index.feature.add.highlightedTarget = invocation.object.domNode;
        var sidebar = dojo.byId('xg_add_features_preview_sidebar');
        if (xg.index.feature.add.highlightedTarget == sidebar) {
            dojo.style.setVisibility(dojo.byId('xg_add_features_allpagesnote'), true);
        }
        if (retval) {
            dojo.html.addClass(invocation.object.domNode, 'drop');
        }
        else {
            dojo.html.addClass(invocation.object.domNode, 'nodrop');
        }
        return retval;
    },

    onLeaveTarget: function(evt) {
        dojo.html.removeClass(xg.index.feature.add.highlightedTarget, 'drop');
        dojo.html.removeClass(xg.index.feature.add.highlightedTarget, 'nodrop');
        dojo.style.setVisibility(dojo.byId('xg_add_features_allpagesnote'), false);
    },

    skip: function() {
        var form = dojo.byId('xg_add_features_form');
        form.xg_feature_layout.value = '';
        form.submit();
    },

    handleLaunchBarSubmit: function(url, evt) {
        dojo.event.browser.stopEvent(evt);
        var form = dojo.byId('xg_add_features_form');
        if (form.successTarget && url) {
            form.successTarget.value = url;
        }
        xg.index.feature.add.submitForm();
    },

    submitForm: function() {
        //  Accumulate an object describing the feature layout chosen
        var feature_layout = {};
        feature_layout['iteration'] = dojo.byId('xg_add_features_form').xg_layout_iteration.value;
        for (var col = 1; col <= 3; col++) {
            var n = 0;
            feature_layout['col' + col] = new Array();
            dojo.lang.forEach(dojo.byId('xg_add_features_preview_col' + col).getElementsByTagName('li'),
                    function(li) {
                var object = {};
                dojo.lang.forEach(li.attributes, function(attr) {
                    var attrName = (attr.localName ? attr.localName : attr.name);
                    var attrValue = (attr.nodeValue ? attr.nodeValue : dojo.html.getAttribute(li, attrName));
                    if (attrValue && attrName.substr(0, 3) == 'xg_') {
                        object[attrName] = attrValue;
                    }
                });
                feature_layout['col' + col][n++] = object;
            });
        }
        n = 0;
        feature_layout['sidebar'] = new Array();
        dojo.lang.forEach(dojo.byId('xg_add_features_preview_sidebar').getElementsByTagName('li'),
                function(li) {
            var object = {};
            dojo.lang.forEach(li.attributes, function(attr) {
                var attrName = (attr.localName ? attr.localName : attr.name);
                var attrValue = (attr.nodeValue ? attr.nodeValue : dojo.html.getAttribute(li, attrName));
                if (attrValue && attrName.substr(0, 3) == 'xg_') {
                    object[attrName] = attrValue;
                }
            });
            feature_layout['sidebar'][n++] = object;
        });
        
        //  Serialize the layout object into a field for submission
        var form = dojo.byId('xg_add_features_form');
        
        form.xg_feature_layout.value = dojo.json.serialize(feature_layout);
        form.successfulDrop.value = xg.index.feature.add.successfulDrop;
        
        xg.index.feature.testAddHook();
        form.submit();
    }

};

/** Hook for Squish regression tests */
xg.index.feature.testAddHook = function() { };

xg.addOnRequire(function() {
    
    xg.index.feature.add.recordAvailableFeatures();
    xg.index.feature.add.updateFeatureList();

    var widths = {};
    dojo.lang.forEach(xg.index.feature.add.availableFeatureList, function(li) {
        widths[li.getAttribute('xg_feature_name')] = li.getAttribute('xg_width_option');
    });
    for (var col = 1; col <= 3; col++) {
        dojo.lang.forEach(dojo.byId('xg_add_features_preview_col' + col).getElementsByTagName('li'),
                function(li) {
            if (li.className.indexOf('noedit') != -1) { return; }
            if (widths[li.getAttribute('xg_feature_name')]) {
                new dojo.dnd.HtmlDragSource(li, widths[li.getAttribute('xg_feature_name')]);
            }
            else {
                //  Don't know the available widths - constrain to current width
                new dojo.dnd.HtmlDragSource(li, 'w' + (col == 2 ? '2' : '1'));
            }
        });
    }
    dojo.lang.forEach(dojo.byId('xg_add_features_preview_sidebar').getElementsByTagName('li'),
            function(li) {
        if (li.className.indexOf('noedit') != -1) { return; }
        if (widths[li.getAttribute('xg_feature_name')]) {
            new dojo.dnd.HtmlDragSource(li, widths[li.getAttribute('xg_feature_name')]);
        }
        else {
            //  Don't know the available widths - constrain to current width
            new dojo.dnd.HtmlDragSource(li, 'w1');
        }
    });

    var dt = new dojo.dnd.HtmlDropTarget(dojo.byId('xg_add_features_preview_col1'), ['w1', 'w12']);
    dojo.event.connect(dt, 'onDrop', xg.index.feature.add, 'onDrop');
    //dojo.event.connect(dt, 'onDragOver', xg.index.feature.add, 'onEnterTarget');
    dojo.event.connect('around', dt, 'onDragOver', xg.index.feature.add, 'aroundEnterTarget');
    dojo.event.connect(dt, 'onDragOut', xg.index.feature.add, 'onLeaveTarget');

    dt = new dojo.dnd.HtmlDropTarget(dojo.byId('xg_add_features_preview_col2'), ['w2', 'w12']);
    dojo.event.connect(dt, 'onDrop', xg.index.feature.add, 'onDrop');
    //dojo.event.connect(dt, 'onDragOver', xg.index.feature.add, 'onEnterTarget');
    dojo.event.connect('around', dt, 'onDragOver', xg.index.feature.add, 'aroundEnterTarget');
    dojo.event.connect(dt, 'onDragOut', xg.index.feature.add, 'onLeaveTarget');

    dt = new dojo.dnd.HtmlDropTarget(dojo.byId('xg_add_features_preview_col3'), ['w1', 'w12']);
    dojo.event.connect(dt, 'onDrop', xg.index.feature.add, 'onDrop');
    //dojo.event.connect(dt, 'onDragOver', xg.index.feature.add, 'onEnterTarget');
    dojo.event.connect('around', dt, 'onDragOver', xg.index.feature.add, 'aroundEnterTarget');
    dojo.event.connect(dt, 'onDragOut', xg.index.feature.add, 'onLeaveTarget');

    dt = new dojo.dnd.HtmlDropTarget(dojo.byId('xg_add_features_preview_sidebar'), ['w1', 'w12']);
    dojo.event.connect(dt, 'onDrop', xg.index.feature.add, 'onDrop');
    //dojo.event.connect(dt, 'onDragOver', xg.index.feature.add, 'onEnterTarget');
    dojo.event.connect('around', dt, 'onDragOver', xg.index.feature.add, 'aroundEnterTarget');
    dojo.event.connect(dt, 'onDragOut', xg.index.feature.add, 'onLeaveTarget');

    dt = new dojo.dnd.HtmlDropTarget(dojo.byId('xg_add_features_trash'), '*');
    dojo.event.connect(dt, 'onDrop', xg.index.feature.add, 'onDropTrash');
    //dojo.event.connect(dt, 'onDragOver', xg.index.feature.add, 'onEnterTarget');
    dojo.event.connect('around', dt, 'onDragOver', xg.index.feature.add, 'aroundEnterTarget');
    dojo.event.connect(dt, 'onDragOut', xg.index.feature.add, 'onLeaveTarget');

    var form = dojo.byId('xg_add_features_form');
    dojo.event.connect(form, 'onsubmit', xg.index.feature.add, 'submitForm');
    
    // preload mouseover images
    dojo.lang.forEach(['column_drop', 'column_nodrop', 'trash_drop', 'allpagesnote'], function(name){
        var preloader = new Image();
        preloader.src = '/xn_resources/widgets/index/gfx/features/' + name + '.gif';
	});
});
