dojo.provide('xg.index.appearance.edit');

dojo.require('xg.shared.BazelColorPicker');
dojo.require('xg.shared.BazelImagePicker');
dojo.require('dojo.html.*');
dojo.require('dojo.style');
dojo.require('dojo.graphics.color');

xg.index.appearance.edit = {
    lastStyle: null,
    themeName: null,
    themeCustomized: false,

    fontFamilies: {
        'Andale Mono': '"Andale Mono", "Courier New", Courier, monospace',
        'Helvetica Neue': '"Helvetica Neue", Arial, Helvetica, sans-serif',
        'Arial Black': '"Arial Black", sans-serif',
        'Comic Sans MS': '"Comic Sans MS", sans-serif',
        'Courier New': '"Courier New", Courier, "Andale Mono", monospace',
        'Futura': 'Futura, "Avant Garde", "Century Gothic", "Gill Sans MT", sans-serif',
        'Georgia': 'Georgia, "Times New Roman", Times, serif',
        'Gill Sans': '"Gill Sans", "Gill Sans MT", "Gill", "Century Gothic", sans-serif',
        'Impact': 'Impact, sans-serif',
        'Lucida Grande': '"Lucida Grande", "Lucida Sans Unicode", Arial, clean, sans-serif',
        'Times New Roman': '"Times New Roman", Times, Georgia, serif',
        'Trebuchet MS': '"Trebuchet MS", sans-serif',
        'Verdana': 'Verdana, Helvetica, Arial, sans-serif'
    },

    updatePreview: function() {
        if (xg.index.appearance.edit.lastStyle) {
            xg.index.appearance.edit.lastStyle.parentNode.removeChild(xg.index.appearance.edit.lastStyle);
        }
        af = document.xg_appearance_form;
        style  = '#preview {background-color:' + af.siteBgColor.value + '; background-image:; background-repeat:;} ';
        style += '#preview .preview_link {color:' + af.siteLinkColor.value + ';} ';
        style += '#preview .preview_bar, #preview .preview_foot {background-color:' + af.ningbarColor.value + ';} ';
        style += '#preview .preview_head {background-color:' + af.headBgColor.value + '; background-image:; background-repeat:;} ';
        style += '#preview .selected {color:' + af.siteLinkColor.value + ';} ';
        style += '#preview .preview_body {background-color:' + af.pageBgColor.value + '; background-image:; background-repeat:;} ';
        style += '#preview .preview_sitename {color:' + af.pageHeaderTextColor.value + ';} ';
        style += '#preview .preview_pagetitle {color:' + af.moduleBodyTextColor.value + ';} ';
        style += '#preview .preview_module_head {background-color:' + af.moduleHeadBgColor.value + ';} ';
        style += '#preview .preview_options span {background-color:' + af.moduleHeadBgColor.value + ';} ';
        style += '#preview .preview_module_body {color:' + af.moduleBodyTextColor.value + ';} ';
        xg.index.appearance.edit.lastStyle = dojo.html.insertCssText(style);
        xg.index.appearance.edit.showThemeCustomized();
    },

    updateHeadingFontPreview: function() {
        var af = document.xg_appearance_form;
        var font = af.headingFont.options[af.headingFont.selectedIndex].text;
        var family = xg.index.appearance.edit.fontFamilies[font];
        dojo.byId('xg_preview_heading_text').style.fontFamily = family;
        xg.index.appearance.edit.showThemeCustomized();
    },

    updateBodyFontPreview: function() {
        var af = document.xg_appearance_form;
        var font = af.textFont.options[af.textFont.selectedIndex].text;
        var family = xg.index.appearance.edit.fontFamilies[font];
        dojo.byId('xg_preview_body_text').style.fontFamily = family;
        xg.index.appearance.edit.showThemeCustomized();
    },
    
    applyTheme: function(name) {
        dojo.io.bind({
            url         : '/index.php/main/appearance/getThemeSettings?theme='
                    + name + '&xn_out=json',
            preventCache: true,
            encoding    : 'utf-8',
            mimetype    : 'text/javascript',
            load        : dojo.lang.hitch(this, function(type, data, event){
                var af = document.xg_appearance_form;
                if (data.colors) {
                    //  Set all colors to the colors in the theme
                    var widgets = dojo.widget.manager.getWidgetsByType('BazelColorPicker');
                    for(var n = 0; n < widgets.length; n++) {
                        if (data.colors[widgets[n].fieldname]) {
                            widgets[n]._pickColorQuick(data.colors[widgets[n].fieldname]);
                        }
                    }
                }
                if (data.fonts) {
                    //  Set all fonts
                    if (data.fonts.textFont) {
                        dojo.byId('xg_selectTextFont').value = data.fonts.textFont;
                    }
                    if (data.fonts.headingFont) {
                        dojo.byId('xg_selectHeadingFont').value = data.fonts.headingFont;
                    }
                }
                if (data.images) {
                    //  Set all images
                    var widgets = dojo.widget.manager.getWidgetsByType('BazelImagePicker');
                    for(var n = 0; n < widgets.length; n++) {
                        var fieldName = widgets[n].fieldname;
                        if (data.images[fieldName]) {
                            widgets[n].setImage(data.images[fieldName]);
                        }
                        else if (fieldName !== 'logoImage') {
                            widgets[n].clearImage();
                        }
                        widgets[n].tileCheckbox.checked = data.imageRepeat[fieldName];
                    }
                }
                xg.index.appearance.edit.updatePreview();

                //  Indicate the theme applied above the preview
                if (name.length > 0) {
                    xg.index.appearance.edit.themeName = name;
                    xg.index.appearance.edit.themeCustomized = false;
                }
                else {
                    xg.index.appearance.edit.themeName = ning.CurrentApp.name;
                    xg.index.appearance.edit.themeCustomized = false;
                }
                var themeName = dojo.byId('xg_theme_name');
                if (themeName) {
                    themeName.innerHTML = xg.index.appearance.edit.themeName;
                    dojo.html.show(dojo.byId('xg_theme_name'));
                }

                if (data.customCss) {
                    af.customCss.value = data.customCss;
                }
                else {
                    af.customCss.value = '';
                }
            })
        });
    },

    showThemeCustomized: function() {
        //  Label the theme as customized if one has been chosen
        if (xg.index.appearance.edit.themeName && !xg.index.appearance.edit.themeCustomized) {
            xg.index.appearance.edit.themeCustomized = true;
            var themeName = dojo.byId('xg_theme_name');
            if (themeName) {
                themeName.innerHTML = xg.index.appearance.edit.themeName
                        + ' (' + xg.index.nls.html('customized') + ')';
            }
        }
    },

    xg_showThemeSettings: function(a) {
        this.showTab(dojo.byId('xg_theme_settings_div'));
        this.hideTab(dojo.byId('xg_custom_css_div'));
        var themeTab = dojo.byId('xg_theme_settings_tab');
        var cssTab = dojo.byId('xg_custom_css_tab');
        themeTab.className = 'this';
        themeTab.innerHTML = '<span>' + xg.index.nls.html('themeSettings') + '</span>';
        cssTab.className = '';
        cssTab.innerHTML = '<a href="javascript:void(0);"'
                + ' onClick="xg.index.appearance.edit.xg_showCustomCss(this)">' + xg.index.nls.html('addYourOwnCss') + '</a>';
        themeTab = null;
        cssTab = null;
    },

    xg_showCustomCss: function(a) {
        this.hideTab(dojo.byId('xg_theme_settings_div'));
        this.showTab(dojo.byId('xg_custom_css_div'));
        var themeTab = dojo.byId('xg_theme_settings_tab');
        var cssTab = dojo.byId('xg_custom_css_tab');
        themeTab.className = '';
        themeTab.innerHTML = '<a href="javascript:void(0);"'
                + ' onClick="xg.index.appearance.edit.xg_showThemeSettings(this)">' + xg.index.nls.html('themeSettings') + '</a>';
        cssTab.className = 'this';
        cssTab.innerHTML = '<span>' + xg.index.nls.html('addYourOwnCss') + '</span>';
        themeTab = null;
        cssTab = null;
    },

    /**
     * Hides the given tab div.
     *
     * @param HTMLDivElement div  The tab body to hide
     */
    hideTab: function(div) {
        if (dojo.render.html.safari) {
            // Safari ignores form fields with display:none [Jon Aquino 2007-02-17]
            div.style.position = 'absolute';
            div.style.left = '-9999px';
            if (div.id == 'xg_theme_settings_div') { dojo.html.hide(dojo.byId('preview').parentNode); }
        } else {
            dojo.html.hide(div);
        }
    },

    /**
     * Shows the given tab div.
     *
     * @param HTMLDivElement div  The tab body to show
     */
    showTab: function(div) {
        div.style.position = 'static';
        div.style.left = '0px';
        if (div.id == 'xg_theme_settings_div') { dojo.html.show(dojo.byId('preview').parentNode); }
        dojo.html.show(div);
    },

    fixSafariHideBug: function() {
        if (dojo.render.html.safari) {
            var div = dojo.byId('xg_custom_css_div');
            div.style.position = 'absolute';
            div.style.left = '-9999px';
            dojo.html.show(div);
        }
    },

    submitForm: function() {
        dojo.byId('xg_appearance_form').submit();
    },

    handleLaunchBarSubmit: function(url, evt) {
        dojo.event.browser.stopEvent(evt);
        var form = dojo.byId('xg_appearance_form');
        if (form.successTarget && url) {
            form.successTarget.value = url;
        }
        xg.index.appearance.edit.submitForm();
    }

};

xg.addOnRequire(function() {
    xg.index.appearance.edit.fixSafariHideBug();
    xg.index.appearance.edit.updatePreview();
    xg.index.appearance.edit.updateHeadingFontPreview();
    xg.index.appearance.edit.updateBodyFontPreview();
    var form = dojo.byId('xg_appearance_form');
    dojo.event.connect(form, 'onsubmit', xg.index.appearance.edit, 'submitForm');
});


