dojo.provide('xg.index.admin.manage');

xg.index.admin.manage = {
    onlineHtml: '<img src="/xn_resources/widgets/index/gfx/icon/online.gif" alt="' + xg.index.nls.html('thisSiteIsOnline') + '" /> '
            + xg.index.nls.html('onlineSiteCanBeViewed')
            + '<small>(<a href="javascript:void(0)">' + xg.index.nls.html('takeOffline') + '</a>)</small>',
    offlineHtml: '<img src="/xn_resources/widgets/index/gfx/icon/offline.gif" alt="' + xg.index.nls.html('thisSiteIsOffline') + '" /> '
            + xg.index.nls.html('offlineOnlyYouCanView')
            + '<small>(<a href="javascript:void(0)">' + xg.index.nls.html('takeOnline') + '</a>)</small>',

    displayOnline: function(evt) {
        var statusContainer = dojo.byId('xg_manage_online_status_container');
        dojo.html.hide(statusContainer);
        var statusLi = dojo.byId('xg_manage_online_status');
        statusLi.innerHTML = this.onlineHtml;

        var anchor = statusLi.getElementsByTagName("a")[0];
        dojo.event.connect(anchor, "onclick", this, "takeOffline");
        dojo.html.show(statusContainer);
    },

    takeOnline: function(evt) {
        dojo.event.browser.stopEvent(evt);
        this.displayOnline();
        dojo.io.bind({
            url: dojo.string.paramString("/xn/rest/1.0/application:%{app_id}?xn_method=PUT", {app_id: ning.CurrentApp.id}),
            method: "POST",
            mimetype: "text/json",
            encoding: "utf-8",
            content:  {
                application_online: true
            }
        });
    },

    displayOffline: function(evt) {
        var statusContainer = dojo.byId('xg_manage_online_status_container');
        dojo.html.hide(statusContainer);
        var statusLi = dojo.byId('xg_manage_online_status');
        statusLi.innerHTML = this.offlineHtml;

        var anchor = statusLi.getElementsByTagName("a")[0];
        dojo.event.connect(anchor, "onclick", this, "takeOnline");
        dojo.html.show(statusContainer);
    },

    takeOffline: function(evt) {
        dojo.event.browser.stopEvent(evt);
        this.displayOffline();
        dojo.io.bind({
            url: dojo.string.paramString("/xn/rest/1.0/application:%{app_id}?xn_method=PUT", {app_id: ning.CurrentApp.id}),
            method: "POST",
            mimetype: "text/json",
            encoding: "utf-8",
            content:  {
                application_online: false
            }
        });
    }
};

xg.addOnRequire(function() {
    if (dojo.byId('xg_manage_online_status_container')) {
        if (ning.CurrentApp.online) {
            xg.index.admin.manage.displayOnline();
        }
        else {
            xg.index.admin.manage.displayOffline();
        }
    }
});


