dojo.provide('xg.groups.embed.BannedMessage');

dojo.require('xg.shared.util');
dojo.require('xg.shared.SendMessageLink');

/**
 * A message explaining why the current user is banned
 */
dojo.widget.defineWidget('xg.groups.embed.BannedMessage', dojo.widget.HtmlWidget, {

    /** Username of the person who created the group */
    _groupCreator: '',

    /**
     * Initializes the widget.
     */
    fillInTemplate: function(args, frag) {
        var div = this.getFragNodeRef(frag);
        div.appendChild(dojo.html.createNodesFromText('<p><small><a href="#">' + xg.groups.nls.html('whyNot') + '</a></small></p>')[0]);
        var clicked = false;
        dojo.event.connect(div.getElementsByTagName('a')[0], 'onclick', dojo.lang.hitch(this, function(event) {
            dojo.event.browser.stopEvent(event);
            if (clicked) { return; }
            clicked = true;
            var p = dojo.html.createNodesFromText('<p>' + xg.groups.nls.html('groupCreatorDetermines', 'href="#" dojoType="SendMessageLink" _screenName="' + dojo.string.escape('html', this._groupCreator) + '"') + '</p>')[0];
            div.appendChild(p);
            xg.shared.util.parseWidgets(p);
        }));
    }

});

