dojo.provide('xg.forum.category.edit');

dojo.require('xg.shared.util');
dojo.require('dojo.lfx.html');
dojo.require('xg.index.util.FormHelper');
dojo.require('dojo.dnd.HtmlDropTarget');
dojo.require('dojo.json');

/**
 * Behavior for the Manage Categories page.
 */
xg.forum.category.edit = {
    /**
     * Adds a category editor to the category container.
     *
     * @param fieldsetBefore  (optional) The fieldset after which to insert the new fieldset
     */
    addCategory: function(fieldsetBefore) {
        dojo.style.hide(dojo.byId('no_categories_section'));
        dojo.style.show(dojo.byId('category_container').parentNode);
        // Set radio-button names in string passed to createNodesFromText, as IE doesn't allow
        // us to change the name. See "NAME Attribute", http://msdn.microsoft.com/workshop/author/dhtml/reference/properties/name_2.asp
        // [Jon Aquino 2007-04-16]
        var n = xg.forum.category.edit.n = xg.forum.category.edit.n ? xg.forum.category.edit.n + 1 : 1;
        var fieldset = dojo.html.createNodesFromText(dojo.byId('category_editor_template').value.replace(/members_can_add_topics_[a-z0-9]*/ig, 'members_can_add_topics_' + n))[0];
        dojo.style.setOpacity(fieldset, 0);
        if (fieldsetBefore) {
            dojo.dom.insertAfter(fieldset, fieldsetBefore);
        } else {
            dojo.byId('category_container').appendChild(fieldset);
        }
        xg.shared.util.fixImagesInIE(fieldset.getElementsByTagName('img'));
        xg.shared.util.parseWidgets(fieldset);
        // BAZ-5468 Need to set this explicitly for Safari 3 even though it's in the template.
        var FIRST_RADIO_BUTTON_POSITION = 1;
        fieldset.getElementsByTagName('input')[FIRST_RADIO_BUTTON_POSITION].checked = true;
        xg.index.util.FormHelper.scrollIntoView(fieldset);
        dojo.lfx.html.fadeIn(fieldset, 500, null, function() {
            fieldset.getElementsByTagName('input')[0].focus();
        }).play();
    },
    /**
     * Removes a category editor
     *
     * @param fieldset  the fieldset element to remove
     */
    removeCategory: function(fieldset) {
        dojo.lfx.html.fadeOut(fieldset, 500, null, dojo.lang.hitch(this, function() {
            fieldset.parentNode.removeChild(fieldset);
            if (dojo.html.getElementsByClass('category', dojo.byId('category_container')).length == 0) {
                dojo.style.hide(dojo.byId('category_container').parentNode);
                dojo.style.show(dojo.byId('no_categories_section'));
            }
        })).play();
    }
};

(function() {

    dojo.event.connect(dojo.byId('no_categories_section').getElementsByTagName('button')[0], 'onclick', function(event) {
        dojo.event.browser.stopEvent(event);
        xg.forum.category.edit.addCategory();
    });

    var dropTarget = new dojo.dnd.HtmlDropTarget(dojo.byId('category_container'), '*');
    dropTarget.createDropIndicator = function() {
        this.dropIndicator = document.createElement("div");
        dojo.html.addClass(this.dropIndicator, 'fieldset_drop_indicator');
        this.dropIndicator.style.left = dojo.style.getAbsoluteX(this.domNode, true) + "px";
    };

    var form = dojo.byId('xg_body').getElementsByTagName('form')[0];
    dojo.event.connect(form, 'onsubmit', function(event) {
        var data = [];
        dojo.lang.forEach(dojo.html.getElementsByClass('category', dojo.byId('category_container')), function(categoryNode) {
            var categoryEditor = dojo.widget.manager.getWidgetByNode(categoryNode);
            data.push(categoryEditor.createCategory());
        });
        form.data.value = dojo.json.serialize(data);
    });

})();
