dojo.provide('xg.events.EventEmbedModule');

dojo.require('xg.shared.util');
dojo.require('xg.events.Scroller'); // A Scroller may be returned by the Ajax request [Jon Aquino 2008-04-04]

/**
 * Events embed block on main page.
 */
dojo.widget.defineWidget('xg.events.EventEmbedModule', dojo.widget.HtmlWidget, {
    isContainer: true,
    _url: '',            // URL for saving data
    fillInTemplate: function(args, frag) {
        this.module         = this.getFragNodeRef(frag);
        this.edit            = this.module.getElementsByTagName('p')[0];
        this.form            = this.module.getElementsByTagName('form')[0];

        dojo.html.show(this.edit);
        dojo.event.connect(this.edit.firstChild, 'onclick', dojo.lang.hitch(this, function(event) {
            dojo.event.browser.stopEvent(event);
            this.form.offsetHeight ? this.hideForm() : this.showForm();
        }));

        dojo.html.show(this.form);
        this.formHeight = this.form.offsetHeight;
        this.form.style.height = 0;
        dojo.html.hide(this.form);

        dojo.event.connect(this.form,'onsubmit',dojo.lang.hitch(this, this.save));
        dojo.event.connect(this.form.save,'onclick',dojo.lang.hitch(this, this.save));
        dojo.event.connect(this.form.cancel,'onclick',dojo.lang.hitch(this, this.cancel));
    },
    showForm: function() {
        dojo.html.show(this.form);
        xg.shared.util.showModuleForm(this.form,this.formHeight,this.edit.firstChild);
    },
    hideForm: function() {
        xg.shared.util.hideModuleForm(this.form,this.formHeight,this.edit.firstChild);
    },
    save: function(event) {
        dojo.event.browser.stopEvent(event);
        var content = {}, el = this.form.elements;
        for (var i = 0; i<el.length;i++) {
            if (el[i].name) {
                content[el[i].name] = el[i].value;
            }
        }
        dojo.io.bind({
            url: this._url,
            method: 'post',
            mimetype: 'text/javascript',
            preventCache: true,
            encoding: 'utf-8',
            content: content,
            load: dojo.lang.hitch(this,  function(type, js, event){
                var ch = this.module.childNodes;
                for (var i = ch.length-1;i>=0;i--) {
                    if (ch[i].nodeType == 1 && ch[i].tagName == 'DIV' && ch[i].className.match(/xg_module_body|xg_module_foot/)) {
                        this.module.removeChild(ch[i]);
                    }
                }
                var div = document.createElement('DIV');
                div.innerHTML = js.moduleBodyAndFooter;
                var moduleBody = dojo.html.getElementsByClass('xg_module_body', div)[0];
                this.module.appendChild(moduleBody);
                xg.shared.util.parseWidgets(moduleBody);
                var moduleFooter = dojo.html.getElementsByClass('xg_module_foot', div)[0];
                if (moduleFooter) { this.module.appendChild(moduleFooter); }
            })
        });
        this.hideForm();
    },
    cancel: function(event) {
        dojo.event.browser.stopEvent(event);
        this.hideForm();
    }
});
