<?php
class Profiles_FriendController extends W_Controller {

    public function action_feed() {
        $this->_widget->includeFileOnce('/lib/helpers/Profiles_UserHelper.php');
        $this->_widget->includeFileOnce('/lib/helpers/Profiles_FeedHelper.php');
        if (! isset($_GET['user'])) {
            throw new Exception("No user specified");
        }
        $this->setCaching(array('profiles-friend-feed-' . md5(XG_HttpHelper::currentUrl())), 1800);
        if ($_GET['test_caching']) { var_dump('Not cached'); }
        $friendInfo = Profiles_UserHelper::findFriendsOf($_GET['user'], 0, 5);
        $this->profile = XG_Cache::profiles($_GET['user']);
        $this->friends = $friendInfo['friends'];
        $screenNames = array();
        foreach ($this->friends as $friend) {
            $screenNames[$friend->contributorName] = $friend->contributorName;
        }
        $this->profiles = XG_Cache::profiles($screenNames);
        header('Content-Type: application/atom+xml');
    }

    public function action_list() {
        if ($_GET['my']) {
            XG_SecurityHelper::redirectToSignInPageIfSignedOut(XG_HttpHelper::currentUrl());
            return $this->redirectTo(XG_HttpHelper::addParameters(XG_HttpHelper::currentUrl(), array('my' => null, 'user' => XN_Profile::current()->screenName)));
        }
        $screenName = $_GET['user'] ? User::loadByProfileAddress($_GET['user'])->title : null;
        if (isset($screenName)) {
            $this->profile = XG_Cache::profiles($screenName);
            $this->tab = 'profile';
        } else {
            $this->tab = 'members';
        }
    }

    /**
     * Displays a grid of avatars.
     *
     * @param $profile                  XN_Profile  Profile of the person whose friends to display, or null to display all network members
     */
    public function action_listColumn($profile) {
        $screenName = ($profile ? $profile->screenName : null);
        $myFriends = mb_strlen($screenName) && $screenName == $this->_user->screenName;
        // Cache listColumn rather than list, to avoid caching the sidebar [Jon Aquino 2008-01-22]
        // But not if user is an admin - we don't want to cache the Feature links [Jon Aquino 2008-03-03]
        // And not if you are viewing your own friends - we don't want to cache the title: My Friends vs. Joe's Friends [Jon Aquino 2008-03-14]
        if (! $_GET['q'] && ! XG_SecurityHelper::userIsAdmin() && ! $myFriends) {
            $this->setCaching(array(
                    'profiles-friend-listColumn-' . md5(XG_HttpHelper::currentUrl()),
                    XG_CacheExpiryHelper::promotedObjectsChangedCondition('User'),
                    XG_CacheExpiryHelper::userBannedCondition(),
                    XG_CacheExpiryHelper::userUnbannedCondition()), 300);
        }
        $this->_widget->includeFileOnce('/lib/helpers/Profiles_FriendListHelper.php');
        $this->_widget->includeFileOnce('/lib/helpers/Profiles_UserSort.php');
        XG_App::includeFileOnce('/lib/XG_PaginationHelper.php');
        XG_App::includeFileOnce('/lib/XG_QueryHelper.php');
        $this->pageSize = 21;
        $this->page = isset($_GET['page']) ? (integer) $_GET['page'] : 1;
        if ($this->page < 1) { $this->page = 1; }
        if (! $profile && $this->page == 1) {
            W_Cache::getWidget('profiles')->includeFileOnce('/lib/helpers/Profiles_UserHelper.php');
            $featuredMembers = Profiles_UserHelper::getPromotedUsers(6);
            $this->showViewAllFeaturedUrl = count($featuredMembers) === 6;
            $this->featuredMembers = array_slice($featuredMembers, 0, 5);
        }
        $this->start = ($this->page - 1) * $this->pageSize;
        $this->end = $this->start + $this->pageSize;
        $this->searchTerm = $_GET['q'];
        $currentSort = Profiles_UserSort::get($_GET['sort'] ? $_GET['sort'] : 'mostRecent');
        $helper = new Profiles_FriendListHelper();
        $this->userInfo = $this->userInfoForListAction($this->searchTerm, $screenName, $this->start, $this->end, $currentSort, $helper);
        list($upperLinks, $lowerLinks) = $this->navigationLinks($myFriends && $this->userInfo['users']);
        XG_Cache::profiles($this->userInfo['users']); //Prime the cache
        if ($myFriends) {
            $this->pageTitle = xg_text('MY_FRIENDS_N', $this->userInfo['numUsers']);
        } else if (mb_strlen($screenName)) {
            $this->pageTitle = xg_text('XS_FRIENDS_N', ucfirst(xg_username($profile)), $this->userInfo['numUsers']);
        } else {
            $this->pageTitle = $currentSort->getPageTitle($this->userInfo['numUsers']);
        }
        $sortOptions = array();
        if (! $this->useSearchQuery($this->searchTerm, $screenName, $helper)) {
            $sortOptions = $this->sortOptions(array('mostRecent', 'alphabetical', 'random'), $currentSort, XG_HttpHelper::currentUrl());
        }
        XG_App::includeFileOnce('/lib/XG_HttpHelper.php');
        $this->searchUrl = XG_HttpHelper::addParameters($this->_buildUrl('friend', 'list'), array('user' => $screenName));
        $this->listColumnProperArgs = array('pageTitle' => $this->pageTitle, 'users' => $this->userInfo['users'],
                'numUsers' => $this->userInfo['numUsers'], 'searchUrl' => $this->searchUrl,
                'searchUrl' => $this->searchUrl, 'pageSize' => $this->pageSize,
                'emptyMessage' => $this->emptyMessage, 'inviteUrl' => $this->inviteUrl,
                'manageUrl' => $this->manageUrl, 'sortOptions' => $sortOptions,
                'showViewAllFeaturedUrl' => $this->showViewAllFeaturedUrl,
                'upperLinks' => $upperLinks, 'lowerLinks' => $lowerLinks,
                'searchButtonText' => mb_strlen($screenName) ? xg_text('SEARCH_FRIENDS_NO_COLON') : xg_text('SEARCH_MEMBERS'));
    }

    /**
     * Returns options for the sort drop-down.
     *
     * @param $sortIds array  strings identifying the sorts
     * @param $currentSort Profiles_UserSort  logic for sorting User objects.
     * @param $currentUrl string  URL for the current page
     * @return array  array of arrays, each with displayText, url, and selected;
     *         or null to hide the Sort By drop-down
     */
    protected function sortOptions($sortIds, $currentSort, $currentUrl) {
        $sortOptions = array();
        foreach ($sortIds as $sortName) {
            $sort = Profiles_UserSort::get($sortName);
            $sortOptions[] = array(
                    'displayText' => $sort->getDisplayText(),
                    'url' => XG_HttpHelper::addParameters($currentUrl, array('sort' => $sort->getId(), 'page' => null)),
                    'selected' => $sort->getId() == $currentSort->getId());
        }
        return $sortOptions;
    }

    /**
     * Displays a grid of avatars. Called by the groups widget.  Not actually visited by other routines in FriendController
     * - the listColumnProper template is called with renderPartial instead for efficiency reasons.
     *
     * @param $args array  configuration parameters:
     *     pageTitle - title of the page
     *     users - User objects for display
     *     numUsers - total number of users on all pages
     *     searchUrl - URL for searches (with query parameters and with 'q' as value of search performed)
     *     pageSize - number of avatars per page
     *     emptyMessage - message to display if there are no avatars
     *     inviteUrl - URL for the "Invite More People" link, or null to hide the link
     *     manageUrl - URL for the "Manage Members" link, or null to hide the link
     *     searchButtonText - the text that appears for the search button.
     */
    public function action_listColumnProper($args) {
        foreach ($args as $key => $value) { $this->{$key} = $value; }
    }

    /**
     * Create a block relationship between the current user and the specified user
     *   Called via a dojo PostLink
     */
    public function action_block() {
        $this->_widget->includeFileOnce('/lib/helpers/Profiles_UserHelper.php');
        if (!isset($_GET['blocked'])) {
            error_log('in profiles/friend/block, \'blocked\' not specified!');
            return;
        }
        Profiles_UserHelper::createMessageBlock($this->_user->screenName, $_GET['blocked']);
    }

    /**
     * Returns the User objects for the list action.
     *
     * @param $q string  search terms, or null if there are none
     * @param $screenName string  username of the person whose friends to display, or null to display all network members
     * @param $start integer  start index for the query (inclusive)
     * @param $end integer  end index for the query (exclusive)
     * @param $sort Profiles_UserSort  logic for sorting User objects
     * @param $helper Profiles_FriendListHelper  facade for services used by the list action
     * @return array 'users' => the User objects, 'numUsers' => the total number of User objects
     */
    protected function userInfoForListAction($q, $screenName, $start, $end, $sort, $helper) {
        if ($this->useSearchQuery($q, $screenName, $helper)) {
            return $this->listWithSearchQuery($q, $start, $end, $helper);
        } else {
            return $this->listWithContentQuery($q, $screenName, $start, $end, $sort, $helper);
        }
    }

    /**
     * Returns whether to use a Search query or a Content query for the list action.
     *
     * @param $q string  search terms, or null if there are none
     * @param $screenName string  username of the person whose friends to display, or null to display all network members
     * @param $helper Profiles_FriendListHelper  facade for services used by the list action
     * @return boolean  true to use a Search query; false to use a Content query
     */
    private function useSearchQuery($q, $screenName, $helper) {
        return isset($q) && ! isset($screenName) && $helper->getSearchMethod() == 'search';
    }

    /**
     * @param $q string  search terms, or null if there are none
     * @param $start integer  start index for the query (inclusive)
     * @param $end integer  end index for the query (exclusive)
     * @param $sort Profiles_UserSort  logic for sorting User objects
     * @param $helper Profiles_FriendListHelper  facade for services used by the list action
     */
    protected function listWithContentQuery($q, $screenName, $start, $end, $sort, $helper) {
        $cacheUserQuery = true;
        $filters = array();
        // Searching for all members or just friends of a particular user?
        if (isset($screenName)) {
            $cacheUserQuery = false; // Don't cache the friends query
            $filters['contributorName'] = array('in', XN_Query::FRIENDS($screenName));
            $this->emptyMessage = xg_text('NO_FRIENDS_ON_SITE');
        } else {
            $this->emptyMessage = xg_text('SITE_HAS_NO_MEMBERS');
        }
        if (isset($q)) {
            $cacheUserQuery = false; // Don't cache search queries, as q is not constrained [Jon Aquino 2007-04-21]
            $filters['my->searchText'] = array('likeic', $q);
            if (isset($screenName)) {
                $this->emptyMessage = xg_text('NO_FRIENDS_ON_SITE_THAT_MATCH');
            } else {
                $this->emptyMessage = xg_text('SORRY_NO_MEMBERS_MATCHING_X_WERE_FOUND', $q);
            }
        }
        return $sort->findUsers($filters, $start, $end, $cacheUserQuery, $helper);
    }

    /**
     * @param $q string  search terms, or null if there are none
     * @param $start integer  start index for the query (inclusive)
     * @param $end integer  end index for the query (exclusive)
     * @param $helper Profiles_FriendListHelper  facade for services used by the list action
     */
    protected function listWithSearchQuery($q, $start, $end, $helper) {
        $query = $helper->createQuery('Search')
                ->begin($start)->end($end)
                ->filter('type', 'like', 'User')
                ->filter('my.approved', '!like', 'N')
                ->filter('fulltext', 'like', $q);
        XG_QueryHelper::addExcludeFromPublicSearchFilter($query, true);
        User::addBlockedFilter($query, true); // Exclude blocked/banned users (BAZ-4024)
        User::addPendingFilter($query, true); // Exclude pending users (BAZ-4427)
        $query->alwaysReturnTotalCount(true);
        $this->emptyMessage = xg_text('SORRY_NO_MEMBERS_MATCHING_X_WERE_FOUND', $q);
        try {
            $ids = array();
            foreach ($query->execute() as $searchResult) { $ids[] = $searchResult->id; }
            return array('numUsers' => $query->getTotalCount(), 'users' => $helper->content($ids));
        } catch (Exception $e) {
            error_log("Friend search query ({$q}) failed with: " . $e->getCode());
            return array('numUsers' => 0, 'users' => array());
        }
    }

    /**
     * Displays promoted users (only).
     */
    public function action_listFeatured() {
        $this->_widget->includeFileOnce('/lib/helpers/Profiles_FriendListHelper.php');
        $this->_widget->includeFileOnce('/lib/helpers/Profiles_UserSort.php');
        XG_App::includeFileOnce('/lib/XG_PaginationHelper.php');
        list($this->upperLinks, $this->lowerLinks) = $this->navigationLinks();
        $this->pageSize = 21;
        $start = XG_PaginationHelper::computeStart($_GET['page'], $this->pageSize);
        $currentSort = Profiles_UserSort::get($_GET['sort'] ? $_GET['sort'] : 'mostRecentlyFeatured');
        $userInfo = $currentSort->findUsers(array('promoted' => true), $start, $start + $this->pageSize, true, new Profiles_FriendListHelper());
        $this->searchUrl = $this->_buildUrl('friend','list');
        $this->users = $userInfo['users'];
        XG_Cache::profiles($this->users);
        $this->numUsers = $userInfo['numUsers'];
        $this->pageTitle = xg_text('FEATURED_MEMBERS');
        $this->sortOptions = $this->sortOptions(array('mostRecentlyFeatured', 'alphabetical', 'random'), $currentSort, XG_HttpHelper::currentUrl());
    }

    /**
     * Gets an array of two strings (upperLinks, lowerLinks) that contain the HTML for the upper and lower navigation on member list pages.
     *
     * @param   $showSendMessageLink    boolean Whether to show "send message to friends" link or not.
     * @return                          array   (upperLinks, lowerLinks) strings of HTML.
     */
    public function navigationLinks($showSendMessageLink=false) {
        list($upperLinks, $lowerLinks) = array("", "");
        $inviteUrl = XG_App::canSeeInviteLinks($this->_user) ? '/invite' : null;
        if ($inviteUrl) {
            $upperLinks .= ' <strong><a href="' . $inviteUrl . '" class="add bigdesc">' . xg_html('INVITE_MORE_PEOPLE') . '</a></strong>';
        }
        $sendMessageUrl = $showSendMessageLink ? W_Cache::getWidget('main')->buildUrl('message', 'new') : null;
        if ($sendMessageUrl) {
            $lowerLinks .= ' <strong><a href="' . $sendMessageUrl . '" class="sendmessage desc">' . xg_html('SEND_MESSAGE_TO_FRIENDS') . '</a></strong>';
        }
        $manageUrl = XG_SecurityHelper::userIsAdmin() ? W_Cache::getWidget('main')->buildUrl('membership', 'listMembers') : null;
        if ($manageUrl) {
            //TODO: Remove inline style [Thomas David Baker 2008-03-21]
            $lowerLinks .= ' <strong><a href="' . $manageUrl . '" class="friends desc" style="margin-left: 10px">' . xg_html('MANAGE_MEMBERS') . '</a></strong>';
        }
        return array($upperLinks, $lowerLinks);
    }

}
