<?php

class Groups_CommentHelper {

    /** Number of comments per page when viewing a group page. */
    const COMMENTS_PER_PAGE = 10;

    /**
     * Can the specified user delete the specified comment?
     *
     * @param $user XN_Profile
     * @param $comment Comment
     * @return boolean
     */
    public static function userCanDeleteComment($user, $comment) {
        return (XG_SecurityHelper::userIsAdmin($user) || ($user->screenName == $comment->my->attachedToAuthor) || ($user->screenName == $comment->contributorName));
    }


}
