<?php

XG_App::includeFileOnce('/lib/XG_SequencedjobController.php');

/**
 * Dispatches requests for sequenced jobs. A sequenced job is an XN_Job that
 * will create a new XN_Job if it cannot complete its work. This results in a
 * sequence (or "chain") of jobs.
 *
 * @see XG_SequencedjobController
 */
class Groups_SequencedjobController extends XG_SequencedjobController {

    /**
     * A sequenced job that updates groups with null activity scores, setting them to 0.
     * Also sets lastActivityOn to the Group's updatedDate.
     */
    public function action_initializeActivityAttributes() {
        $this->initializeActivityAttributes(XN_Query::create('Content'));
    }

    /**
     * A sequenced job that updates groups with null activity scores, setting them to 0.
     * Also sets lastActivityOn to the Group's updatedDate.
     */
    protected function initializeActivityAttributes($query) {
        $query->filter('owner');
        $query->filter('type', '=', 'Group');
        $query->filter('my.activityScore', '=', null);
        $query->end(20);
        $groups = $query->execute();
        foreach ($groups as $group) {
            $group->my->activityScore = 0;
            $group->my->set('lastActivityOn', $group->updatedDate, XN_Attribute::DATE);
            $group->save();
        }
        $this->setContinueJob(count($groups) > 0);
    }

}
