<?php
XG_App::includeFileOnce('/lib/XG_CryptoHelper.php');

$xark = (isset($_POST['xark']) ? $_POST['xark'] : $_GET['xark']);
$values = XG_CryptoHelper::decrypt(XG_CryptoHelper::appPublicKey(), $xark);
$user = mb_strtolower($_REQUEST['user']);
$viewer = mb_strtolower($values['viewer']);
$owner = mb_strtolower($values['owner']);
$op = $_POST['op'];
//TODO: are these coming across like this, or are they in a separately encrypted var?  They can't be added to xark because proxy doesn't have app's private key.
$key = $_POST['key'];
$value = $_POST['value'];
$app = $_POST['app'];

echo "//$user\n";
echo "//$viewer\n";
echo "//$owner\n";

if (time() > $values['expires']) {
  returnErrorResponse();
  return;
}

if ($user != $viewer && $user != $owner) {
  returnErrorResponse();
  return;
}

$loggedInUser = XN_Profile::current();

header('Content-Type: text/json');  //TODO is this problematic for IE?  We use text/plain elsewhere to get around a text/json problem with IE but perhaps it does not apply here?

if (isset($user) && $user !== '') {
    // from XARK
    $isOwnedByCurrentUser = ($owner == $user && $user == $viewer);

	if ($op == 'update-app-data') {
		if ($user != $viewer) {
			returnErrorResponse();
			return;
		}
		updateAppData($user, $app, $key, $value);
	} else if ($op == 'insert-activity') {
		if ($user != $viewer) {
			returnErrorResponse();
			return;
		}
		insertActivity($user, $viewer, $_POST['description'], $_POST['title'], $_POST['link']);
	    returnOkResponse();
	} else if ($op == 'install-app') {
        installApp($isOwnedByCurrentUser, $user, $app);
        // TODO no returnOkResponse() for install-app?
	} else if ($op == 'uninstall-app') {
	    uninstallApp($isOwnedByCurrentUser, $user, $app);
	    returnOkResponse();
	}
} else if ($op != 'get-app-data') {
    //user not logged in
    returnOkResponse();
}

// I presume this means get the data for a particular user... -bmc
if ($op == 'get-app-data') {
    if ($user != $viewer && $user != $owner) {
        returnErrorResponse();
        return;
    }
    $contentQuery = getGadgetAppDataQuery($user, $app);
    $results = $contentQuery->execute();
    $resultData = array();
    if ($contentQuery->getTotalCount() > 0) {
        $content = $contentQuery->uniqueResult();
        $resultData = unserialize($content->my->data);
        $json = new Services_JSON();
		echo $json->encode($resultData);
	}
	else {//if ($loggedInUser->isLoggedIn()) {
		// TODO for now create the object here -- later we must do this ONLY in install-app
		$key = 'xnowner';
		$value = $user;//date('r',time());
		updateAppData($user, $app, $key, $value);
	}/*
	else if (!$loggedInUser->isLoggedIn()) {
		returnOkResponse();
	}*/
}

//TODO if an app is removed without uninstall-app being called and then we put it back later the data will still be there.
// So we could pass an arg here telling us whether we should delete old data and start anew.
function updateAppData($user, $app, $key, $value) {
	$content = null;
	$resultData = null;
	
	//TODO add cleanup if more than one object found
	$contentQuery = getGadgetAppDataQuery($user, $app);
	$results = $contentQuery->execute();

	if (! $results) {
		//for now create the object here -- later we must do this ONLY in install-app
		$objkey = getObjKey($user, $app);
		$content = new XN_Content('GadgetAppData');
		$content->isPrivate = true;
		$content->title = $objkey;
		$resultData = array();
	} else {
		$content = $results[0];
		$resultData = unserialize($content->my->data);
	}
	
	if ($resultData[$key] != $value || $createObject) { //update only if data was added or changed
		$resultData[$key] = $value;
		$content->my->data = serialize($resultData);
		$content->save();
	} else {
		error_log ('api: Data unchanged from what\'s stored, skipping write (' . $key . ' = ' . $value . ')');
	}

    if ($resultData[$key] != $value || $createObject) { //update only if data was added or changed
        $resultData[$key] = $value;
        $content->my->data = serialize($resultData);
        $content->save();
    }

    $resultData['xncreated'] = $content->createdDate;

	if ($createObject) {
		returnOkResponse();
	} else {
		$json = new Services_JSON();
		echo $json->encode($resultData);
	}
}

function insertActivity($user, $description, $title, $link) {
    XG_App::includeFileOnce('/lib/XG_ActivityHelper.php');
	$item = XG_ActivityHelper::logActivityIfEnabled(XG_ActivityHelper::CATEGORY_GADGET, XG_ActivityHelper::SUBCATEGORY_MESSAGE, $user, null, $description, null, $title, $link);
}

function installApp($isOwnedByCurrentUser, $user, $app) {
    if ($isOwnedByCurrentUser) {
    	$contentQuery = getGadgetAppDataQuery($user, $app);
    	$results = $contentQuery->execute();
    	if ($contentQuery->getTotalCount() == 0) {
    		$key = 'xnowner';
    		$value = $user;
    		updateAppData($user, $app, $key, $value);
    	}
    }
}

function uninstallApp($isOwnedByCurrentUser, $user, $app) {
    if ($isOwnedByCurrentUser) {
		$contentQuery = getGadgetAppDataQuery($user, $app);
		$results = $contentQuery->execute();
		if ($contentQuery->getTotalCount() > 0) {
			$content = $contentQuery->uniqueResult();
			if ($content->contributor->screenName == $user) {
				XN_Content::delete($content);
			}
		}
	}
}

function returnOkResponse() {
    $json = new Services_JSON();
    $dataArray = array();
    $dataArray['result'] = 'ok';
    echo $json->encode($dataArray);
}

function returnErrorResponse() {
    $json = new Services_JSON();
    $dataArray = array();
    $dataArray['result'] = 'error';
    echo $json->encode($dataArray);
}

function getObjKey($user, $app) {
    return $user . '-' . $app;
}

function getGadgetAppDataQuery($user, $app) {
	$objkey = getObjKey($user, $app);
	$contentQuery = XN_Query::create('Content');
	$contentQuery->filter('owner');
	$contentQuery->filter('type', '=', 'GadgetAppData');
	$contentQuery->filter('title', '=', $objkey);
	// Always return the oldest if there is more than one to prevent data loss.
	// TODO add cleanup to remove all but the oldest.
	$contentQuery->begin(0);
	$contentQuery->end(1);
	$contentQuery->order('createdDate', 'asc');
	return $contentQuery;
}
?>
