<?php xg_header(W_Cache::current('W_Widget')->dir, $title = xg_text('POPULAR_CONTRIBUTORS')); ?>
<div id="xg_body">
    <div class="xg_colgroup">
        <div class="xg_3col first-child">
            <%= $this->renderPartial('fragment_navigation', '_shared') %>
            <h1><%= xnhtmlentities($title) %> <%= $this->totalCount > count($this->users) ? xg_html('USER_COUNT', $this->totalCount) : '' %></h1>
            <%= XG_GroupHelper::groupLink() %>
            <?php
            if (count($this->users) == 0 && ! mb_strlen($this->searchTerm) && Forum_SecurityHelper::currentUserCanSeeAddTopicLinks()) { ?>
                <div class="xg_module">
                    <div class="xg_module_head notitle"></div>
                    <div class="xg_module_body">
                        <p><%= xg_html('NOBODY_HAS_ADDED_DISCUSSIONS_ADD') %></p>
                        <p class="buttongroup">
                            <a <%= XG_JoinPromptHelper::promptToJoin(Topic::newTopicUrl()) %> class="button"><%= xg_html('START_DISCUSSION') %></a>
                        </p>
                    </div>
                </div><!--/.xg_module-->
            <?php
            } elseif (count($this->users) == 0 && ! mb_strlen($this->searchTerm)) { ?>
                <div class="xg_module">
                    <div class="xg_module_head notitle"></div>
                    <div class="xg_module_body">
                        <p><%= xg_html('NOBODY_HAS_ADDED_DISCUSSIONS') %></p>
                    </div>
                </div><!--/.xg_module-->
            <?php
            } else { ?>
                <div class="xg_module">
                    <div class="xg_module_head notitle"></div>
                    <div class="xg_module_body">
                        <form action="<%= xnhtmlentities($this->_buildUrl('user', 'list')) %>" method="get">
                            <%= XG_GroupHelper::hiddenFieldForGetForm() %>
                            <p class="right clear">
                                <label for="search_contributors" style="margin-right:0;">
                                    <%= xg_html('SEARCH_PEOPLE') %>
                                    <input id="search_contributors" name="q" type="text" class="textfield" value="<?php echo xnhtmlentities($this->searchTerm) ?>">
                                    <input type="submit" class="button" value="<%= xg_html('SEARCH') %>" />
                                </label>
                            </p>
                        </form>
                        <br class="clear" />
                        <?php
                        if (count($this->users) == 0) { ?>
                            <div><p><%= xg_html('WE_COULD_NOT_FIND_ANYONE_MATCHING') %></p></div>
                        <?php
                        } ?>
                        <div class="vcards">
                            <?php
                            foreach ($this->users as $user) { ?>
                                <dl class="vcard left">
                                    <dt><%= xg_avatar(XG_Cache::profiles($user->title), 54) %>  <a href="<%= xnhtmlentities(User::quickProfileUrl($user->title)) %>"><%= xnhtmlentities(xg_username(XG_Cache::profiles($user->title))) %></a></dt>
                                    <dd>
                                        <a href="<%= $this->_buildUrl('topic', 'listForContributor', '?user=' . $user->title) %>"><%= xg_html('VIEW_DISCUSSIONS') %></a>
                                    </dd>
                                </dl>
                            <?php
                            } ?>
                        </div>
                        <p class="clear right"><a href="<%= W_Cache::getWidget('profiles')->buildUrl('friend', 'list') %>"><%= xg_html('VIEW_ALL_PEOPLE_ON_X', xnhtmlentities(XN_Application::load()->name)) %> &#187;</a></p>
                        <%= XG_PaginationHelper::outputPagination($this->totalCount, $this->pageSize); %>
                    </div>
                </div><!--/.xg_module-->
            <?php
            } ?>
        </div><!--/xg_3col-->
        <div class="xg_1col last-child">
            <?php xg_sidebar($this); ?>
        </div><!--/xg_col-->
    </div><!--/xg_colgroup-->
</div><!--/#xg_body-->
<?php xg_footer(); ?>



