<?php
/*  $Id: $
 *
 *  Renders embed module content
 *
 *  Parameters:
 *      $events         XG_PagingList<Event>
 *      $settings       hash
 *      $columns        int
 *      $calendar       hash<yyyy-mm:days>
 *      $viewAllUrl
 *      $profileName    string      screenName of the profile module owner. NULL for homepage module
 *      $embed          XG_Embed    stores the module data
 */
$opts           = array('showImage'=>0, 'showExtra'=>0, 'showWrap'=>1, 'showRsvp'=>0);
$showCalendar   = 0;
$wrapDate       = 0;
switch($settings['display']) {
    case 'detail':
        $css                = 'body_detail';
        $opts['showExtra']  = 1;
        $opts['imageSize']  = 96;
        $opts['showImage']  = $columns != 1;
        $wrapDate           = $columns != 1;
        break;

    case 'list':
        $css                = 'body_list';
        $opts['showExtra']  = 0;
        $opts['imageSize']  = 36;
        $opts['showImage']  = $columns != 1;
        $wrapDate           = $columns != 1;
        break;

    case 'calendar':
        $css                = 'body_calendar';
        $opts['showWrap']   = 0;
        $showCalendar       = 1;
        break;
}
?>
<div class="xg_module_body <%=$css%>">
    <?php if (0 == count($events)) {
        if ($settings['count'] == 0) {
            echo '<p>' . xg_html('NO_EVENTS_TO_DISPLAY').'<br />'.xg_html('BOX_WILL_NOT_SHOW_UNTIL_SELECT_EVENTS') . '</p>';
        } elseif ($settings['from'] == 'featured') {
            echo '<h3>' . xg_html('THERE_ARE_NO_FEATURED_EVENTS') . '</h3>';
            echo '<p>' . xg_html('START_FEATURING_EVENTS', 'href="' . xnhtmlentities(W_Cache::getWidget('main')->buildRelativeUrl('admin','customization','#a1-11')) .'"') . '</p>';
        } elseif (Events_SecurityHelper::currentUserCanCreateEvent()) {
            echo '<p><a href="',$this->_buildUrl('event','new'),'" class="desc add">',xg_html('CREATE_EVENT'),'</a></p>';
        } else {
            echo '<p>' . xg_html('NO_EVENTS_TO_DISPLAY') . '</p>';
        }
    } elseif ($showCalendar) {?>
        <?php if ($calendar) { $this->renderPartial('fragment_calendar', '_shared', array('calendar' => $calendar, 'embed' => 1, 'showUser'=>$profileName)); }?>
        <div class="textbox">
            <ul class="clist">
                <?php foreach ($events as $event) {  $opts['event'] = $event; $this->renderPartial('fragment_listItem','_shared',$opts); }?>
            </ul>
        </div>
    <?php } elseif ($wrapDate) {
        $wrap   = 0;
        $today  = xg_date('Y-m-d');
        $prev   = '';
        foreach ($events as $event) {
            $d = mb_substr($event->my->startDate,0,10);
            if ($wrapDate && $prev != $d) {
                if ($wrap) {
                    echo '</ul></div>';
                }
                $wrap   = 1;
                $date   = strtotime($d);
                echo '<div class="wrap"><h3 class="dategroup">',
                    $d==$today ? xg_html('TODAY') : date(xg_html('EVENT_TM_FMT2'),$date) . '<span class="">'.date('l',$date).'</span>',
                    '</h3><ul class="clist">';
                $prev = $d;
            }
            $opts['event'] = $event; $this->renderPartial('fragment_listItem','_shared',$opts);
        }
        if ($wrap) {
            echo '</ul>';
            echo '</div>';
        }
    } else {?>
        <ul class="clist">
            <?php foreach ($events as $event) {  $opts['event'] = $event; $this->renderPartial('fragment_listItem','_shared',$opts); }?>
        </ul>
    <?php }?>
</div>
<?php
if (count($events)) {
    $showAddEventLink = Events_SecurityHelper::currentUserCanCreateEvent() && XG_SecurityHelper::currentUserCanSeeAddContentLink($embed, true); ?>
    <div class="xg_module_foot">
        <ul>
            <?php
            if ($showAddEventLink) { ?>
                <li class="left"><a class="add desc" href="<%=xnhtmlentities($this->_buildUrl('event', 'new', array('cancelTarget' => XG_HttpHelper::currentUrl())))%>"><%= xg_html('ADD_AN_EVENT') %></a></li>
            <?php
            } ?>
            <li class="right"><a href="<%=$viewAllUrl%>"><%=xg_html('VIEW_ALL')%></a></li>
        </ul>
    </div>
<?php
}?>
