<?php
XG_App::includeFileOnce('/lib/XG_Layout.php');
/**
* Primary dispatcher for the Events widget.
*/
class Events_IndexController extends W_Controller {
	protected $ok;
    /**
     * Displays the Events main page
     *
     * Expected GET variables:
     *     page - page number (optional)
     */
    public function action_index() {
        $this->forwardTo('listUpcoming','event');
    }
    /**
	 *  /xn/detail handler
     */
	public function action_detail($object) { # void
		$this->forwardTo('show','event',array($object));
    }

    /**
     * Called by an XN_Task.
     */
    public function action_asyncJob() { # void
        // TODO: Set HTTP status code to 500 on failure? [Jon Aquino 2008-03-21]
        EventWidget::init();
        $this->ok = 0;
		register_shutdown_function(array($this,'_trackFailures'));
        Events_EventHelper::dispatchJob($_REQUEST);
      	$this->ok = 1;
    }

    //
	public function _trackFailures () { # void
		if (!$this->ok) {
			error_log("asyncJob failure:".var_export($_REQUEST,TRUE));
		}
    }
}
?>