<?php
XG_App::includeFileOnce('/lib/XG_Layout.php');
/**
 * Dispatches requests pertaining to "embeds", which are reusable
 * page components.
 */
class Events_EmbedController extends W_Controller {

    /** Prefix for URL parameters. */
    public $prefix          = 'xg_module_events';

    /**
     * Constructor.
     *
     * @param   $widget     W_BaseWidget    The Events widget
     */
    public function __construct(W_BaseWidget $widget) {
        parent::__construct($widget);
        W_Cache::getWidget('events')->includeFileOnce('/lib/helpers/Events_TemplateHelper.php');
        W_Cache::getWidget('events')->includeFileOnce('/lib/helpers/Events_SecurityHelper.php');
        EventWidget::init();
    }

    /**
     * Displays a module that spans 1 column.
     *
     * @param $args array  Contains the object that stores the module data ('embed' => XG_Embed)
     */
    public function action_embed1($args) { $this->renderEmbed($args['embed'], 1); }

    /**
     * Displays a module that spans 2 columns.
     *
     * @param $args array  Contains the object that stores the module data ('embed' => XG_Embed)
     */
    public function action_embed2($args) { $this->renderEmbed($args['embed'], 2); }

    /**
     * Configures the embed module
     * The new HTML will be in the moduleBodyAndFooter property of the JSON output.
     *
     * Expected GET parameters:
     *     id - The embed instance ID, used to retrieve the module data
     *     columnCount - The number of columns that the module spans
     */
    public function action_setValues() {
        XG_App::includeFileOnce('/lib/XG_Embed.php');
        XG_HttpHelper::trimGetAndPostValues();
        $embed = XG_Embed::load($_REQUEST['id']);
        if (! $embed->isOwnedByCurrentUser() && !XG_SecurityHelper::userIsAdmin()) { throw new Exception('Not embed owner.'); }
        $columnCount    = $_REQUEST['columnCount'];
        $this->isOwner  = $embed->isOwnedByCurrentUser();
        $this->profileName = ($embed->getType() == 'homepage') ? NULL : $embed->getOwnerName();

        $this->settings = array(
            'display'   => $_REQUEST["{$this->prefix}_display_$columnCount"],
            'from'      => $_REQUEST["{$this->prefix}_from_$columnCount"],
            'count'     => $_REQUEST["{$this->prefix}_count_$columnCount"],
        );
        $this->_fetchEvents();

        foreach ($this->settings as $k=>$v) {
            $embed->set($k,$v);
        }

        ob_start();
        $this->renderPartial('fragment_block','embed', array(
            'events'    => $this->events,
            'settings'  => $this->settings,
            'calendar'  => $this->calendar,
            'columns'   => $columnCount,
            'profileName'=> $this->profileName,
            'viewAllUrl' => $this->viewAllUrl,
            'embed'      => $embed,
        ));
        $this->moduleBodyAndFooter = trim(ob_get_clean());
    }
//** Implementation
    /**
     * Displays a module that spans the given number of columns.
     *
     * @param $embed XG_Embed  Stores the module data.
     * @param $columnCount integer  The number of columns that the module will span
     */
    protected function renderEmbed($embed, $columnCount) {
        $this->embed    = $embed;
        $this->isOwner  = $embed->isOwnedByCurrentUser();
        $this->columns  = $columnCount;
        $this->profileName = ($embed->getType() == 'homepage') ? NULL : $embed->getOwnerName();
        $this->settings = $this->profileName ? array('display' => 'list', 'from' => 'attending', 'count' => 4,) : array('display' => 'list', 'from' => 'upcoming', 'count' => 6,);

        foreach(array('display','from','count') as $k) {
            if (NULL !== ($v = $embed->get($k))) {
                $this->settings[$k] = $v;
            }
        }
        $this->_fetchEvents();

        if ($this->isOwner) {
            XG_App::includeFileOnce('/lib/XG_Form.php');
            $values = array();
            foreach ($this->settings as $k=>$v) {
                $values["{$this->prefix}_{$k}_{$columnCount}"] = $v;
            }
            $this->form         = new XG_Form($values);
            $this->setValuesUrl = $this->_buildUrl('embed', 'setValues', array('id' => $embed->getLocator(), 'xn_out' => 'json', 'columnCount' => $columnCount));
        }
        $this->render('embed');
    }

    /**
     * Initializes $this->events and other instance variables,
     * according to the current settings.
     */
    protected function _fetchEvents() { # XG_PagingList<Event>
        $cnt = max(0, intval($this->settings['count']));
        if ( !$cnt || ( $this->profileName && !Events_SecurityHelper::currentUserCanSeeUserEvents($this->profileName) ) ) {
            $this->calendar = array();
            $this->events = new XG_PagingList(0,'');
            return;
        }
        switch ($this->settings['display']) {
            case 'detail':
            case 'list':
                break;
            case 'calendar':
                $ym = xg_date('Y-m');
                $this->calendar = $this->profileName ? EventAttendee::getCalendar($this->profileName,$ym,$ym) : EventCalendar::getCalendar($ym,$ym);
                break;
        }
        if ($this->profileName) {
            $this->viewAllUrl = $this->_buildUrl('event','listUserEvents',array('user'=>$this->profileName));
            $this->events = ($this->settings['from'] == 'all')
                ? EventAttendee::getUpcomingEvents($this->profileName, $cnt, true)
                : EventAttendee::getAttendingEvents($this->profileName, $cnt, true);
        } else {
            $this->viewAllUrl = $this->_buildUrl('event','listUpcoming');
            $this->events = ($this->settings['from'] == 'featured')
                ? Event::getFeaturedEvents($cnt, true)
                : Event::getUpcomingEvents($cnt);
        }
        return;
    }
}
?>
