<?php

class Admin_IndexController extends W_Controller {

    protected function _before() {
        XG_SecurityHelper::redirectIfNotAdmin();
    }

    /**
     * Menu for (some) admin items.
     */
    public function action_index() {}

    /**
     * Content Manager
     */
    public function action_manage() {
        XG_App::includeFileOnce(XN_INCLUDE_PREFIX .'/XNC/ContentManager.php', false);
        $mgr = new XNC_ContentManager();
        echo '<html><head><ning:head/>' . XG_App::sectionMarker() . '</head>';
        echo '<body id="userContent">';
        $mgr->go();
    }

    public function action_clearLog() {
        $myFile = NF_ERROR_LOG;
        $fh = fopen($myFile, 'w') or die("can't open file");
        fwrite($fh, '');
        fclose($fh);
        error_log('Log cleared');
          header('Location: /admin/index/log/');
          exit;
    }

    /**
     * Error Log viewer
     */
    public function action_log() {
        // Default to 10kb of the log file.
        $maxChunk = 1024 * 10;
        // Display the last $maxChunk of the file or what the chunk specifies
        // Chunk should be positive
        $chunk = min(0, isset($_GET['chunk']) ? intval($_GET['chunk']) : 0);
        // Chunk should be <= $maxChunk
        $chunk = max($chunk, $maxChunk);
        if (! is_readable(NF_ERROR_LOG)) {
            $this->error(xg_text('CANNOT_READ_ERROR_LOG'));
            return;
        }
        $fp = @fopen(NF_ERROR_LOG,'r');
        if (! $fp) {
             $this->error(xg_text('CANNOT_OPEN_ERROR_LOG'));
             return;
        }
        if (filesize(NF_ERROR_LOG) > $chunk) {
            if (fseek($fp,-$chunk,SEEK_END) == -1) {
                $this->error(xg_text('CANNOT_SCAN_ERROR_LOG'));
                return;
            }
        }
        // Advance to the next newline in the error log
        $partial_line = fgets($fp, $chunk);
        if ($partial_line === false) {
            $this->error(xg_text('CANNOT_READ_ERROR_LOG'));
            return;
        } elseif (mb_strlen($partial_line) == $chunk) {
            $buf = $partial_line;
        } else {
            $buf = fread($fp, $chunk);
            if ($buf === false) {
                $this->error(xg_text('CANNOT_READ_ERROR_LOG'));
                return;
            }
        }
        fclose($fp);
        // This produces an array in which elements alternate between log
        // message times and the messages themselves
        $this->parts = preg_split('/^(\[\d\d-...-\d\d\d\d \d\d:\d\d:\d\d\])/um',
            $buf, -1, PREG_SPLIT_DELIM_CAPTURE|PREG_SPLIT_NO_EMPTY);
    } // action_log()

    public function action_testBaz5031() {
        $this->redirectTo('simulateBaz5031');
    }

    public function action_simulateBaz5031() {
        if (! mb_strlen($_GET['test_thumbnail_failure_probability'])) {
            echo '<form><i>This simulation calls XG_UserHelper::setThumbnailFromProfile($profile). If it encounters bad avatar data, it will try again, up to 3 times.</i> <br /><br />Probability of bad avatar data: <input name="test_thumbnail_failure_probability" value="100" size="3" /> %<br /><input type="submit" value="Submit"></form>';
            return;
        }
        XG_UserHelper::setThumbnailFromProfile($this->_user);
        User::load($this->_user)->save();
        echo 'Avatar:</br>';
        echo '<img src="' . xnhtmlentities(User::load($this->_user)->my->thumbnailUrl) . '" />';
    }

    /**
     * Displays a form for entering screen names of users to fix.
     *
     * Expected GET variables:
     *     screenNamesFixed - the usernames of users that were just fixed
     */
    public function action_fixAvatars() {
        $this->screenNamesFixed = $_GET['screenNamesFixed'];
    }

    /**
     * Processes the form for entering screen names of users to fix.
     *
     * Expected POST variables:
     *     screenNames - comma-delimited list of usernames
     */
    public function action_doFixAvatars() {
        if ($_SERVER['REQUEST_METHOD'] != 'POST') { return $this->redirectTo('fixAvatars'); }
        foreach (explode(',', $_POST['screenNames']) as $screenName) {
            if (! XG_UserHelper::isThumbnailDataOk(User::load(trim($screenName)))) {
                XG_UserHelper::setThumbnailFromProfile(XN_Profile::load(trim($screenName)));
                User::load(trim($screenName))->save();
            }
        }
        $this->redirectTo('fixAvatars', 'index', array('screenNamesFixed' => $_POST['screenNames']));
    }

    public function action_listSets() {
        $sets = XN_ProfileSet::listSets();
        foreach ($sets as $setName) {
            $set = XN_ProfileSet::load($setName);
            $numMembers = $set->size;
            $members = array();
            $start = 0;
            while (count($members) < $numMembers) {
                $members = array_merge($members, $set->members($start, 100));
                $start += 100;
            }
            natcasesort($members);
            echo "$setName($numMembers): (" . implode($members, ', ') , ") <br />\n";
        }
    }

    public function action_checkSearchability() {
        XG_App::includeFileOnce('/lib/XG_ShapeHelper.php');
        $this->resetModels = XG_ShapeHelper::setStandardIndexingForSearchableModels();
    }

    /**
     * Clears feeds from the action cache
     */
    public function action_clearFeedActionCache() {
        XG_App::includeFileOnce('/lib/XG_FeedHelper.php');
        XN_Cache::invalidate(XG_FeedHelper::FEED_CACHE_LABEL);
        print "invalidated";
    }

    /**
     * Displays a table of messages, for testing.
     *
	 * @param	$type[]		list		Selected items
	 * @param	$opts[]		hash		Options.
	 * @param	$display	bool		Display messages
	 * @param	$send		bool		Send messages
     */
	public function action_testMessages() {
		W_Cache::getWidget('admin')->includeFileOnce('/lib/helpers/Admin_MessageHelper.php');
		$this->types = Admin_MessageHelper::getAllTypes();
		$this->selected = array_flip((array)$_REQUEST['type']);
		$this->opts = (array)$_REQUEST['opts'];
		$this->command = $_REQUEST['send'] ? 'send' : ($_REQUEST['display'] ? 'display' : '');
	}

    /** Call denormalizing function to make Members sortable by status and GroupMembership objects searchable. */
    public function action_manualSortAndSearchUpdate() {
        W_Cache::getWidget('main')->includeFileOnce('/lib/helpers/Index_MembershipHelper.php');
        $this->memberStatusRemaining = Index_MembershipHelper::addMemberStatus();
        $this->groupMemberSearchRemaining = GroupMembership::denormalizeFullName();
    }
}
