<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/test/test_header.php';
XG_App::includeFileOnce('/widgets/video/lib/helpers/Video_TagHelper.php');
XG_App::includeFileOnce('/widgets/video/lib/helpers/Video_VideoHelper.php');
XG_App::includeFileOnce('/lib/XG_TagHelper.php');

class Video_TagHelperTest extends UnitTestCase {

    public function testGetTagsForObjectAndAuthor() {
        $food = XN_Content::create('Food');
        $food->save();
        XN_Tag::addTags($food, 'blue, red');
        $tagNames = XG_TagHelper::implode(XN_Tag::tagNamesFromTags(Video_TagHelper::getTagsForObjectAndAuthor($food->id, XN_Profile::current()->screenName)));
        $this->assertTrue('blue, red' == $tagNames || 'red, blue' == $tagNames, 'Expected blue, red; found ' . $tagNames);
        $tagNames = XG_TagHelper::implode(XN_Tag::tagNamesFromTags(Video_TagHelper::getTagsForObjectAndAuthor($food->id, 'AAAAA')));
        $this->assertTrue('' == $tagNames || '' == $tagNames, 'Expected empty string; found ' . $tagNames);
    }

    public function testSetTagStringForUser() {
        $food = XN_Content::create('Food');
        $food->save();
        Video_VideoHelper::setTagStringForUser(XN_Profile::current(), $food, 'green, pink');
        $tagNames = XG_TagHelper::implode(XN_Tag::tagNamesFromTags(Video_TagHelper::getTagsForObjectAndAuthor($food->id, XN_Profile::current()->screenName)));
        $this->assertTrue('green, pink' == $tagNames || 'pink, green' == $tagNames, 'Expected green, pink; found ' . $tagNames);
        Video_VideoHelper::setTagStringForUser(XN_Profile::current(), $food, 'red, blue');
        $tagNames = XG_TagHelper::implode(XN_Tag::tagNamesFromTags(Video_TagHelper::getTagsForObjectAndAuthor($food->id, XN_Profile::current()->screenName)));
        $this->assertTrue('blue, red' == $tagNames || 'red, blue' == $tagNames, 'Expected blue, red; found ' . $tagNames);
    }

    public function testGetFilteredTags() {
        $this->assertEqual(array('tags' => array(), 'numTags' => 0), Video_TagHelper::getFilteredTags(array(), 0, 100, 'ABCDEFG'));
    }

    public function tearDown() {
        XG_TestHelper::deleteTestObjects();
    }

}

require $_SERVER['DOCUMENT_ROOT'] . '/test/test_footer.php';
