<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/test/test_header.php';

class Syntax24Test extends UnitTestCase {

    public function testTrimUploadsOnSubmitIsSet() {
        foreach(XG_TestHelper::globr(NF_APP_BASE, '*.php') as $file) {
            if (strpos($file, 'test/') !== false) { continue; }
            $contents = file_get_contents($file);
            if (strpos($contents, 'dojoType="BazelImagePicker"') == false) { continue; }
            $contents = str_replace("\r", '', str_replace("\n", '', $contents));
            $this->assertPattern('@(dojoType="BazelImagePicker").*(trimUploadsOnSubmit)@ui', $contents, $file);
        }
    }

    public function testDoNotEscapeEventDescription() {
        foreach(XG_TestHelper::globr(NF_APP_BASE . '/widgets/events', '*.php') as $file) {
            if (strpos($file, 'test/') !== false) { continue; }
            $contents = file_get_contents($file);
            if (strpos($contents, 'description') == false) { continue; }
            $this->assertNoPattern('@xnhtmlentities.*description@ui', $contents, $file);
        }
    }

    public function testDoNotPutMyInFrontOfIsPrivate() {
        foreach(XG_TestHelper::globr(NF_APP_BASE, '*.php') as $file) {
            if (strpos($file, 'test/') !== false) { continue; }
            $contents = file_get_contents($file);
            $this->assertNoPattern('@my->isPrivate@ui', $contents, $file);
        }
    }

    public function testUseStringInsteadOfUrl() {
        // XN_Attribute::URL is deprecated. Use XN_Attribute::STRING instead. [Jon Aquino 2008-04-04]
        foreach(XG_TestHelper::globr(NF_APP_BASE, '*.php') as $file) {
            if (strpos($file, 'test/') !== false) { continue; }
            $contents = file_get_contents($file);
            $this->assertNoPattern('@XN_Attribute::URL@ui', $contents, $file);
        }
    }

    public function testCheckAreQueriesEnabled() {
        // addPromotedFilter() calls should be accompanied by an areQueriesEnabled()
        // check (BAZ-6713) [Jon Aquino 2008-04-05]
        foreach(XG_TestHelper::globr(NF_APP_BASE, '*.php') as $file) {
            if (strpos($file, 'test/') !== false) { continue; }
            if (strpos($file, 'XG_PromotionHelper.php') !== false) { continue; }
            if (strpos($file, 'Groups_Filter.php') !== false) { continue; }
            if (strpos($file, 'Forum_Filter.php') !== false) { continue; }
            if (strpos($file, 'Photo_Context.php') !== false) { continue; }
            if (strpos($file, 'Photo_PhotoHelper.php') !== false) { continue; }
            $contents = file_get_contents($file);
            if (mb_strpos($contents, 'addPromotedFilter') === false) { continue; }
            $contents = str_replace("\r", ' ', str_replace("\n", ' ', $contents));
            preg_match_all('@.{200,200}addPromotedFilter@ui', $contents, $matches);
            foreach ($matches[0] as $match) {
                $this->assertPattern('@areQueriesEnabled@ui', $file . ' ' . $match);
            }
        }
    }

    public function testAddSearchFilterShouldBeCalledWithAddExcludeFromPublicSearchFilter() {
        // Most addSearchFilter calls should be accompanied by a call to addExcludeFromPublicSearchFilter [Jon Aquino 2008-04-12]
        foreach(XG_TestHelper::globr(NF_APP_BASE, '*.php') as $file) {
            if (strpos($file, 'test/') !== false) { continue; }
            if (strpos($file, 'XG_QueryHelper.php') !== false) { continue; }
            if (strpos($file, 'Photo_AlbumHelper.php') !== false) { continue; }
            if (strpos($file, 'Photo_PhotoHelper.php') !== false) { continue; }
            if (strpos($file, 'Video_VideoHelper.php') !== false) { continue; }
            $contents = file_get_contents($file);
            if (mb_strpos($contents, 'addSearchFilter') === false) { continue; }
            $contents = str_replace("\r", '', str_replace("\n", '', $contents));
            preg_match_all('@addSearchFilter.{0,100}@', $contents, $matches);
            foreach ($matches[0] as $match) {
                $this->assertPattern('@addExcludeFromPublicSearchFilter@ui', $match, $file);
            }
        }
    }

}

require $_SERVER['DOCUMENT_ROOT'] . '/test/test_footer.php';
