<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/test/test_header.php';

class Syntax13Test extends UnitTestCase {

    public function testRemoveErrorLogCalls() {
        $allowedLines = array (
          'error_log("Couldn\'t add {$profile->screenName} to USERS profile set: {$e->getMessage()}");' => 'x',
          'error_log(\'User \'.$this->_user->screenName.\' tried to delete content: \'.$content->id.\' (15409628259620867)\');' => 'x',
          'error_log(var_export($_SERVER, true));' => 'x',
          'error_log("Forum Topic search query ({$_GET[\'q\']}) failed with: " . $e->getCode());' => 'x',
          'error_log("Group search query ({$_GET[\'q\']}) failed with: " . $e->getCode());' => 'x',
          'error_log($e->getMessage());' => 'x',
          'error_log(\'Add content error: \' . $e->getMessage());' => 'x',
          'error_log(\'Save content error: \' . $e->getMessage());' => 'x',
          'error_log(\'not a post\');' => 'x',
          'error_log(\'bad ID \' . $_GET[\'id\']);' => 'x',
          'error_log("Waiting to read unavailable user CSS file " . $filename . "...");' => 'x',
          'error_log("Timed out attempting to read user CSS file " . $filename);' => 'x',
          'error_log("/xn/detail problem: " . $e->getMessage());' => 'x',
          'error_log("Couldn\'t generate actiovity log item after profile question change: " . $e->getMessage());' => 'x',
          'error_log("Couldn\'t update User searchability after profile question change: " . $e->getMessage());' => 'x',
          'error_log(\'Setting admin status for \' . $user->contributorName . \' to \' . ($operation == \'promote\' ? \'TRUE\' : \'FALSE\'));' => 'x',
          'error_log("Friend status is {$contact->relationship} between {$_POST[\'from\']} and {$_POST[\'to\']}");' => 'x',
          'error_log("App-wide search query ({$this->term}) failed with " . $e->getCode());' => 'x',
          'error_log(\'Could not find object to share (id \' . $id . \')!\');' => 'x',
          'error_log(\'Unrecognized type: \' . $item->type . \' at \' . __FILE__ . \':\' . __LINE__);' => 'x',
          'error_log("Couldn\'t remove comment: $idForError -- {$e->getMessage()}");' => 'x',
          'error_log($e->getTraceAsString());' => 'x',
          'error_log("Couldn\'t approve comment: $idOrComment -- {$e->getMessage()}");' => 'x',
          'error_log("Can\'t send invitation: " . $e->getMessage());' => 'x',
          'error_log("Can\'t accept invitation with key {$invitation->my->key} by $screenName:" . $e->getMessage());' => 'x',
          'error_log("Can\'t load remembered invitation with key \'$invitationKey\': {$e->getMessage()}");' => 'x',
          'error_log($e->getErrorsAsString());' => 'x',
          'error_log("User::isMember(): can\'t load User object for $screenName: " . $e->getMessage());' => 'x',
          'error_log(\'(4648228798249686) action_updateFromPlayer, rating failed:\'.$e->getMessage());' => 'x',
          'error_log(\'error removing artwork (9069659071564521): \'.$e->getMessage());' => 'x',
          'error_log(\'file_get_contents failed: \' . $url);' => 'x',
          'error_log("$this->prefix addContent error: {$e->getMessage()}");' => 'x',
          'error_log($message);' => 'x',
          'error_log("Failed to send message {$msg->summary} to $screenName: {$ex->getMessage()}");' => 'x',
          'error_log("Can\'t edit: {$e->getMessage()}");' => 'x',
          'error_log("Can\'t save edit: " . $e->getMessage());' => 'x',
          'error_log("Can\'t retrieve post: " . $e->getMessage());' => 'x',
          'error_log("Can\'t show post: " . $e->getMessage());' => 'x',
          'error_log("Can\'t list posts: " . $e->getMessage());' => 'x',
          'error_log("Feed error: " . $e->getMessage());' => 'x',
          'error_log(\'File upload error: \' . $e->getMessage());' => 'x',
          '// error_log("remove($user,$limit,$changed,$remaining) 4: {$chattersOnUser[\'numComments\']}, " . count($chattersOnUser[\'comments\']));' => 'x',
          '// error_log("remove($user,$limit,$changed,$remaining) 5: {$blogPosts[\'numPosts\']}, " . count($blogPosts[\'posts\']));' => 'x',
          '// error_log("remove($user,$limit,$changed,$remaining) end");' => 'x',
          'error_log(\'Chatter notification: \' . $e->getMessage());' => 'x',
          'error_log("Can\'t render comment list: " . $e->getMessage());' => 'x',
          'error_log("No screenName parameter supplied for comment thread");' => 'x',
          'error_log("Can\'t display friend feed: " . $e->getMessage());' => 'x',
          'error_log("Can\'t display friend/user list: " . $e->getMessage());' => 'x',
          'error_log(\'in profiles/friend/block, \\\'blocked\\\' not specified!\');' => 'x',
          'error_log("Friend search query ({$q}) failed with: " . $e->getCode());' => 'x',
          'error_log("Can\'t save layout: " . $e->getMessage());' => 'x',
          'error_log("Content error: " . $e->getErrorsAsString());' => 'x',
          'error_log("Exception in PUT to $url: " . $e->getMessage);' => 'x',
          'error_log("Failed to send message {$msg->summary()} to $screenName: {$ex->getMessage()}");' => 'x',
          'error_log(\'no previewFrame: \'.$e->getMessage());' => 'x',
          'error_log(\'BAZ-2332\');' => 'x',
          'error_log(\'BAZ-4672\');' => 'x',
          'error_log(\'Current URL: \' . XG_HttpHelper::currentURL());' => 'x',
          'error_log(\'Referrer: \' . $_SERVER[\'HTTP_REFERER\']);' => 'x',
          'error_log(\'Unknown sort by field: \' . $field);' => 'x',
          'error_log(\'Log cleared\');' => 'x',
          'error_log(\'exitWith500 \' . XN_Profile::current()->screenName . \' \' . $json->encode($_POST));' => 'x',
          'error_log (\'api: Data unchanged from what\\\'s stored, skipping write (\' . $key . \' = \' . $value . \')\');' => 'x',
          'error_log("Failed to change fullName to $fullName on all GroupMembership objects belonging to $screenName because they belong to more than $max groups.");' => 'x',
          'if ($nodeList->length > 1) { error_log("More than one node matching $rawEmbed in profile page layout - not updating"); return; }' => 'x',
          'if (! $nodeList->item(0)) { error_log("$rawEmbed not found in existing profile page layout."); return; }' => 'x',
          'error_log("asyncJob:".var_export($_REQUEST,TRUE));' => 'x',
          'error_log("asyncJob: done in ".sprintf(\'%.4f\',microtime(true)-$start));' => 'x',
          'error_log(\'BAZ-6796 @ Current user: \' . XN_Profile::current()->screenName . \' @ Current URL: \' . XG_HttpHelper::currentURL() . \' @ Referrer: \' . $_SERVER[\'HTTP_REFERER\']);' => 'x',
        );
        foreach(XG_TestHelper::globr(NF_APP_BASE, '*.php') as $file) {
            if (strpos($file, '/widgets/') === false) { continue; }
            $contents = file_get_contents($file);
            if (strpos($contents, 'error_log') === false) { continue; }
            $i = 0;
            foreach (explode("\n", $contents) as $line) {
                $i++;
                if ($allowedLines[trim($line)]) { continue; }
                if (strpos($line, 'asyncJob failure') !== false) { continue; }
                if (strpos($line, 'asyncJob $callback') !== false) { continue; }
                if (strpos($line, 'BAZ-7028') !== false) { continue; }
                $this->assertTrue(strpos($line, 'error_log') === false, $line . ' - ' . $file . ' line ' . $i);
            }
        }
    }

    public function testCheckMembershipBeforeJoinGroupOnSaveOrDelete() {
        foreach(XG_TestHelper::globr(NF_APP_BASE, '*.php') as $file) {
            if (strpos($file, 'test/') !== false) { continue; }
            $contents = file_get_contents($file);
            if (strpos($contents, 'XG_JoinPromptHelper::joinGroupOn') === false) { continue; }
            $previousLine = '';
            $i = 0;
            foreach (explode("\n", $contents) as $line) {
                $i++;
                if ((preg_match('@XG_JoinPromptHelper::joinGroupOn(?:Save|Delete)\(\);@', $line, $matches)) &&
                    (! preg_match('@XG_SecurityHelper::redirectIfNotMember\((\$[^\)]+)?\);@', $previousLine))) {
                $this->fail("{$matches[0]} without preceding XG_SecurityHelper::redirectIfNotMember() in $file@$i");
                    }
                $previousLine = $line;
            }
        }
    }

    public function testEliminateSystemPageUrls() {
        // Waiting for David Warner and Tim to verify the matrix in
        // http://home.ninginc.com/display/PRODUCT/Basic+Flows+-+Bazel+-+Links+to+System+Pages  [Jon Aquino 2007-09-20]
        $searches = array('feedback.html?currentUrl=http://', 'ning.Bar.open(\'clone\');', 'currentUrl=', 'view=', 'editAccount=', 'appUrl=', 'http://www.ning.com/', 'op=', 'sop=');
        foreach(XG_TestHelper::globr(NF_APP_BASE, '*.*') as $file) {
            if (strpos($file, 'Contact_Vcard_Parse.php') !== false) { continue; }
            if (strpos($file, 'test/') !== false) { continue; }
            if (strpos($file, 'TEMP_') !== false) { continue; }
            if (strpos($file, 'php') === false && strpos($file, 'js') === false) { continue; }
            $contents = file_get_contents($file);
            $contents = str_replace('<conversion xmlns="http://www.ning.com/atom/1.0">', '', $contents);
            $contents = str_replace('http://www.ning.com/help/feedback/other.html', '', $contents);
            $contents = str_replace('/home/apps/edit?appUrl=', '', $contents);
            $contents = str_replace('addAtTop=', '', $contents);
            $contents = str_replace('crop=', '', $contents);
            $contents = str_replace('/home/apps/premium?appUrl=', '', $contents);
            $contents = str_replace('/home/apps/create?appUrl=', '', $contents);
            $contents = str_replace('/?page_id=139&appUrl=', '', $contents);
            $contents = str_replace('http://www.ning.com/help/faq-creating-network.html', '', $contents);
            // Don't supply currentUrl to feedback.html - it has no effect [Jon Aquino 2007-09-22]
            $contents = str_replace('http://www.ning.com/help/feedback.html"' /* " at the end */, '', $contents);
            $contents = str_replace('http://www.ning.com/help/', '', $contents);
            $contents = str_replace('http://www.ning.com/about/businesses.html', '', $contents);
            $contents = str_replace('http://www.ning.com/about/dmca-notice.html', '', $contents);
            $contents = str_replace('http://www.ning.com/about/businesses.html', '', $contents);
            $found = false;
            foreach ($searches as $search) {
                if (strpos($contents, $search) !== false) {
                    $found = true;
                    break;
                }
            }
            if (! $found) { continue; }
            $i = 0;
            foreach (explode("\n", $contents) as $line) {
                $i++;
                if (strpos($line, 'op=set&') !== false && strpos($file, 'gadget') !== false) { continue; }
                $found = false;
                foreach ($searches as $search) {
                    if (strpos($line, $search) !== false) {
                        $found = true;
                        break;
                    }
                }
                $this->assertFalse($found, $line . ' - ' . $file . ' line ' . $i);
            }
        }
    }


    public function testRemoveNetworkName() {
        // Remove "NetworkName" and "Network Name" [Jon Aquino 2007-09-20]
        $searches = array('NetworkName', 'Network Name');
        foreach(XG_TestHelper::globr(NF_APP_BASE, '*.*') as $file) {
            if (strpos($file, 'test/') !== false) { continue; }
            if (strpos($file, 'php') === false && strpos($file, 'js') === false) { continue; }
            $contents = file_get_contents($file);
            if (strpos($contents, 'NetworkName') === false && strpos($contents, 'Network Name') === false) { continue; }
            $contents = preg_replace('@//.*@', '', $contents);
            $contents = preg_replace('@\'NETWORK_NAME\'\s*=>.*@', '', $contents);
            $i = 0;
            foreach (explode("\n", $contents) as $line) {
                $i++;
                if (strpos($line, 'FACEBOOK_INSTR_SETUP_11') !== false) { continue; }
                $this->assertFalse(preg_match('@\bNetworkName\b|\bNetwork Name\b@', $line), $line . ' - ' . $file . ' line ' . $i);
            }
        }
    }

}

require $_SERVER['DOCUMENT_ROOT'] . '/test/test_footer.php';
