<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/test/test_header.php';
XG_App::includeFileOnce('/widgets/profiles/lib/helpers/Profiles_UserSort.php');

class Profiles_UserSortTest extends UnitTestCase {

    public function testComputeChunkSizeAndStartIndexes1() {
        $sort = new TestRandomUserSort(array());
        list($chunkSize, $startIndexes) = $sort->computeChunkSizeAndStartIndexes(1);
        $this->assertEqual(1, $chunkSize);
        $this->assertEqual(array(0), $startIndexes);
        $this->assertEqual(array(), $sort->randArgs);
    }

    public function testComputeChunkSizeAndStartIndexes2() {
        $sort = new TestRandomUserSort(array());
        list($chunkSize, $startIndexes) = $sort->computeChunkSizeAndStartIndexes(50);
        $this->assertEqual(50, $chunkSize);
        $this->assertEqual(array(0), $startIndexes);
        $this->assertEqual(array(), $sort->randArgs);
    }

    public function testComputeChunkSizeAndStartIndexes3() {
        $sort = new TestRandomUserSort(array());
        list($chunkSize, $startIndexes) = $sort->computeChunkSizeAndStartIndexes(51);
        $this->assertEqual(50, $chunkSize);
        $this->assertEqual(array(0, 50), $startIndexes);
        $this->assertEqual(array(), $sort->randArgs);
    }

    public function testComputeChunkSizeAndStartIndexes4() {
        $sort = new TestRandomUserSort(array());
        list($chunkSize, $startIndexes) = $sort->computeChunkSizeAndStartIndexes(100);
        $this->assertEqual(50, $chunkSize);
        $this->assertEqual(array(0, 50), $startIndexes);
        $this->assertEqual(array(), $sort->randArgs);
    }

    public function testComputeChunkSizeAndStartIndexes5() {
        $sort = new TestRandomUserSort(array(0, 0, 0, 0, 0));
        list($chunkSize, $startIndexes) = $sort->computeChunkSizeAndStartIndexes(101);
        $this->assertEqual(20, $chunkSize);
        $this->assertEqual(array(0, 20, 40, 60, 80), $startIndexes);
        $this->assertEqual(array(array(0, 0), array(0, 0), array(0, 0), array(0, 0), array(0, 0)), $sort->randArgs);
    }

    public function testComputeChunkSizeAndStartIndexes6() {
        $sort = new TestRandomUserSort(array(0, 0, 0, 0, 0));
        list($chunkSize, $startIndexes) = $sort->computeChunkSizeAndStartIndexes(104);
        $this->assertEqual(20, $chunkSize);
        $this->assertEqual(array(0, 20, 40, 60, 80), $startIndexes);
        $this->assertEqual(array(array(0, 0), array(0, 0), array(0, 0), array(0, 0), array(0, 0)), $sort->randArgs);
    }

    public function testComputeChunkSizeAndStartIndexes7() {
        $sort = new TestRandomUserSort(array(0, 0, 0, 0, 0));
        list($chunkSize, $startIndexes) = $sort->computeChunkSizeAndStartIndexes(105);
        $this->assertEqual(20, $chunkSize);
        $this->assertEqual(array(0, 21, 42, 63, 84), $startIndexes);
        $this->assertEqual(array(array(0, 1), array(0, 1), array(0, 1), array(0, 1), array(0, 1)), $sort->randArgs);
    }

    public function testComputeChunkSizeAndStartIndexes8() {
        $sort = new TestRandomUserSort(array(1, 1, 1, 1, 1));
        list($chunkSize, $startIndexes) = $sort->computeChunkSizeAndStartIndexes(105);
        $this->assertEqual(20, $chunkSize);
        $this->assertEqual(array(1, 22, 43, 64, 85), $startIndexes);
        $this->assertEqual(array(array(0, 1), array(0, 1), array(0, 1), array(0, 1), array(0, 1)), $sort->randArgs);
    }

    public function testGetId() {
        $this->assertEqual('random', Profiles_UserSort::get('random')->getId());
        $this->assertEqual('alphabetical', Profiles_UserSort::get('alphabetical')->getId());
        $this->assertEqual('mostRecent', Profiles_UserSort::get('mostRecent')->getId());
    }

    public function testGetPageTitle() {
        $this->assertEqual('Random Members', Profiles_UserSort::get('random')->getPageTitle(5));
        $this->assertEqual('Members (5)', Profiles_UserSort::get('alphabetical')->getPageTitle(5));
        $this->assertEqual('Latest Members (5)', Profiles_UserSort::get('mostRecent')->getPageTitle(5));
    }

}

class TestRandomUserSort extends Profiles_RandomUserSort {
    private $randomValues;
    public $randArgs = array();
    public function __construct($randomValues) {
        $this->randomValues = $randomValues;
    }
    public function computeChunkSizeAndStartIndexes($n) {
        return parent::computeChunkSizeAndStartIndexes($n);
    }
    protected function rand($min, $max) {
        $this->randArgs[] = array($min, $max);
        return array_shift($this->randomValues);
    }
}

require $_SERVER['DOCUMENT_ROOT'] . '/test/test_footer.php';



