<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/test/test_header.php';
XG_App::includeFileOnce('/lib/XG_HttpHelper.php');

class XG_HttpHelperTest extends UnitTestCase {

    public function setUp() {
        static $host;
        if (! $host) { $host = $_SERVER['HTTP_HOST']; }
        $_SERVER['HTTP_HOST'] = $host;
    }

    public function testHasParameter() {
        $this->assertEqual(true, XG_HttpHelper::hasParameter('http://example.org?x=0', 'x'));
        $this->assertEqual(false, XG_HttpHelper::hasParameter('http://example.org?x=0', 'y'));
        $this->assertEqual(false, XG_HttpHelper::hasParameter('http://example.org?x=0&y=', 'y'));
        $this->assertIdentical('0', XG_HttpHelper::getParameter('http://example.org?x=0', 'x'));
        $this->assertIdentical(null, XG_HttpHelper::getParameter('http://example.org?x=0', 'y'));
        $this->assertIdentical('', XG_HttpHelper::getParameter('http://example.org?x=0&y=', 'y'));
		$this->assertIdentical(':', XG_HttpHelper::getParameter('http://example.org?x=0&y=%3A', 'y'));
    }

    public function testAddParameters() {
        $this->assertEqual('http://google.com?a=1&b=2', XG_HttpHelper::addParameters('http://google.com', array('a' => '1', 'b' => '2')));
    }

    public function testRemoveParameters() {
        $this->assertEqual('http://google.com?a=1&c=3&e=5', XG_HttpHelper::removeParameters('http://google.com?a=1&b=2&c=3&d=4&e=5', array('b', 'd')));
        $this->assertEqual('http://google.com?a=1&b=2&c=3&d=4&e=5', XG_HttpHelper::removeParameters('http://google.com?a=1&b=2&c=3&d=4&e=5', array()));
        $this->assertEqual('http://google.com?b=2&c=3&d=4&e=5', XG_HttpHelper::removeParameters('http://google.com?a=1&b=2&c=3&d=4&e=5', array('a')));
        $this->assertEqual('http://google.com', XG_HttpHelper::removeParameters('http://google.com?a=1&b=2&c=3&d=4&e=5', array('a', 'b', 'c', 'd', 'e', 'z', 'z')));
    }

    public function testCurrentUrl() {
        $_SERVER['HTTP_HOST'] = 'example.com';
        $_SERVER['REQUEST_URI'] = '/index.php/pizza';
        $this->assertEqual('http://example.com/pizza', XG_HttpHelper::currentUrl());

        $group = Group::create('Food Lovers');
        $group->my->url = 'foodlovers';
        $group->save();

        $_SERVER['HTTP_HOST'] = 'example.com';
        $_SERVER['REQUEST_URI'] = '/index.php/groups/invitation/new?groupUrl=foodlovers&';
        $this->assertEqual('http://example.com/group/foodlovers/invitation/new', XG_HttpHelper::currentUrl());

        $_SERVER['HTTP_HOST'] = 'example.com';
        $_SERVER['REQUEST_URI'] = '/index.php/forum/topic/show?groupUrl=foodlovers&id=656995%3ATopic%3A2386';
        $this->assertEqual('http://example.com/group/foodlovers/forum/topic/show?id=656995%3ATopic%3A2386', XG_HttpHelper::currentUrl());
    }

    public function testIsHomepage() {
        $this->assertEqual(false, XG_HttpHelper::isHomepage(null));
        $this->assertEqual(false, XG_HttpHelper::isHomepage(''));
        $this->assertEqual(true, XG_HttpHelper::isHomepage('/'));
        $this->assertEqual(false, XG_HttpHelper::isHomepage('/profiles'));
        $this->assertEqual(false, XG_HttpHelper::isHomepage('/profiles?x=5'));
        $this->assertEqual(true, XG_HttpHelper::isHomepage('/main'));
        $this->assertEqual(true, XG_HttpHelper::isHomepage('/main?x=5'));
        $this->assertEqual(true, XG_HttpHelper::isHomepage('/main/index'));
        $this->assertEqual(true, XG_HttpHelper::isHomepage('/main/index?x=5'));
        $this->assertEqual(false, XG_HttpHelper::isHomepage('/main/foo'));
        $this->assertEqual(true, XG_HttpHelper::isHomepage('/main/index/index'));
        $this->assertEqual(true, XG_HttpHelper::isHomepage('/main/index/index?x=5'));
        $this->assertEqual(false, XG_HttpHelper::isHomepage('/main/index/foo'));
        $this->assertEqual(false, XG_HttpHelper::isHomepage('/main/index/index/index'));
        $this->assertEqual(true, XG_HttpHelper::isHomepage('http://' . $_SERVER['HTTP_HOST']));
        $this->assertEqual(true, XG_HttpHelper::isHomepage('http://' . $_SERVER['HTTP_HOST'] . '/'));
        $this->assertEqual(true, XG_HttpHelper::isHomepage('http://' . $_SERVER['HTTP_HOST'] . '/?x=5'));
        $this->assertEqual(false, XG_HttpHelper::isHomepage('http://' . $_SERVER['HTTP_HOST'] . '/photo'));
        $this->assertEqual(false, XG_HttpHelper::isHomepage('http://' . $_SERVER['HTTP_HOST'] . '/photos'));
        $this->assertEqual(true, XG_HttpHelper::isHomepage('http://' . $_SERVER['HTTP_HOST'] . '/main'));
        $this->assertEqual(false, XG_HttpHelper::isHomepage('http://example.org/main'));
    }

    public function testIsMyPage() {
        $this->assertEqual(false, XG_HttpHelper::isMyPage(null));
        $this->assertEqual(false, XG_HttpHelper::isMyPage(''));
        $this->assertEqual(false, XG_HttpHelper::isMyPage('/'));
        $this->assertEqual(true, XG_HttpHelper::isMyPage('/profiles'));
        $this->assertEqual(true, XG_HttpHelper::isMyPage('/profiles?x=5'));
        $this->assertEqual(true, XG_HttpHelper::isMyPage('/profiles/'));
        $this->assertEqual(true, XG_HttpHelper::isMyPage('/profiles/?x=5'));
        $this->assertEqual(false, XG_HttpHelper::isMyPage('/profiles/profile'));
        $this->assertEqual(true, XG_HttpHelper::isMyPage('/profiles/profile/' . XN_Profile::current()->screenName));
        $this->assertEqual(true, XG_HttpHelper::isMyPage('/profiles/profile/' . XN_Profile::current()->screenName . '?x=5'));
        $this->assertEqual(true, XG_HttpHelper::isMyPage('/profiles/profile/' . User::profileAddress(XN_Profile::current()->screenName)));
        $this->assertEqual(true, XG_HttpHelper::isMyPage('/profiles/profile/' . User::profileAddress(XN_Profile::current()->screenName) . '?x=5'));
        $this->assertEqual(false, XG_HttpHelper::isMyPage('/profiles/profile/023740'));
        $this->assertEqual(true, XG_HttpHelper::isMyPage('/profiles/profile/show?id=' . XN_Profile::current()->screenName));
        $this->assertEqual(true, XG_HttpHelper::isMyPage('/profiles/profile/show?id=' . XN_Profile::current()->screenName . '&x=5'));
        $this->assertEqual(true, XG_HttpHelper::isMyPage('/profiles/profile/show?id=' . User::profileAddress(XN_Profile::current()->screenName)));
        $this->assertEqual(true, XG_HttpHelper::isMyPage('/profiles/profile/show?id=' . User::profileAddress(XN_Profile::current()->screenName) . '&x=5'));
        $this->assertEqual(false, XG_HttpHelper::isMyPage('/profiles/profile/show?id=023740'));
        $this->assertEqual(true, XG_HttpHelper::isMyPage('/profiles/profile/show?screenName=' . XN_Profile::current()->screenName));
        $this->assertEqual(true, XG_HttpHelper::isMyPage('/profiles/profile/show?screenName=' . XN_Profile::current()->screenName . '&x=5'));
        $this->assertEqual(false, XG_HttpHelper::isMyPage('/profiles/profile/show?screenName=023740'));
        $this->assertEqual(true, XG_HttpHelper::isMyPage('http://' . $_SERVER['HTTP_HOST'] . '/profiles/profile/' . XN_Profile::current()->screenName));
        $this->assertEqual(true, XG_HttpHelper::isMyPage('http://' . $_SERVER['HTTP_HOST'] . '/profiles/profile/' . XN_Profile::current()->screenName . '?x=5'));
        $this->assertEqual(false, XG_HttpHelper::isMyPage('http://' . $_SERVER['HTTP_HOST'] . '/profiles/profile/023740'));
        $this->assertEqual(false, XG_HttpHelper::isMyPage('http://example.org/profiles/profile/' . XN_Profile::current()->screenName));
    }

    public function testProfileUrl() {
        $user = XN_Content::create('User');
        $user->title = 'Joe';
        $user->save();
        User::insertIntoUserMap(array($user));
        $this->assertEqual('http://' . $_SERVER['HTTP_HOST'] . '/xn/detail/u_Joe', XG_HttpHelper::profileUrl($user));
        $user->my->profileAddress = 'MrCool';
        $this->assertEqual('http://' . $_SERVER['HTTP_HOST'] . '/xn/detail/u_Joe', XG_HttpHelper::profileUrl($user));
    }

    public function tearDown() {
        XG_TestHelper::deleteTestObjects();
    }

}

require $_SERVER['DOCUMENT_ROOT'] . '/test/test_footer.php';
