<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/test/test_header.php';

class XG_GroupHelper4Test extends UnitTestCase {

    public function setUp() {
        XG_TestHelper::setCurrentWidget('forum');
        unset($_GET['groupId']);
    }

    public function testIsGroupAdmin() {
        $this->assertFalse(XG_GroupHelper::isGroupAdmin());
        $this->assertFalse(XG_GroupHelper::isGroupAdmin(XN_Profile::current()->screenName));
        $this->assertFalse(XG_GroupHelper::isGroupAdmin('sally'));
        $this->assertFalse(XG_GroupHelper::isGroupAdmin('tony'));
        $this->assertFalse(XG_GroupHelper::isGroupAdmin('joe'));
        $group = Group::create('Food Lovers');
        $group->save();
        $_GET['groupId'] = $group->id;
        Group::setStatus($group, 'sally', 'admin');
        Group::setStatus($group, 'tony', 'member');
        $this->assertFalse(XG_GroupHelper::isGroupAdmin());
        $this->assertFalse(XG_GroupHelper::isGroupAdmin(XN_Profile::current()->screenName));
        $this->assertTrue(XG_GroupHelper::isGroupAdmin('sally'));
        $this->assertFalse(XG_GroupHelper::isGroupAdmin('tony'));
        $this->assertFalse(XG_GroupHelper::isGroupAdmin('joe'));
    }

    public function testCurrentGroup() {
        $this->assertNull(XG_GroupHelper::currentGroup());
        $group = Group::create('Food Lovers');
        $group->save();
        $_GET['groupId'] = $group->id;
        $this->assertEqual('Food Lovers', XG_GroupHelper::currentGroup()->title);
    }

    public function testAfterSave() {
        $group = Group::create('Food Lovers');
        $group->save();
        Group::setStatus($group, XN_Profile::current()->screenName, 'admin');
        $this->assertTrue(Group::userIsMember($group, XN_Profile::current()->screenName));
        $this->assertTrue(Group::userIsAdmin($group, XN_Profile::current()->screenName));
        Group::setStatus($group, XN_Profile::current()->screenName, 'banned');
        $this->assertFalse(Group::userIsMember($group, XN_Profile::current()->screenName));
        $this->assertFalse(Group::userIsAdmin($group, XN_Profile::current()->screenName));
        $_GET['groupId'] = $group->id;
        $topic = Topic::create('Lasagna', 'test');
        $topic->save();
        $this->assertFalse(Group::userIsMember($group, XN_Profile::current()->screenName));
        $this->assertFalse(Group::userIsAdmin($group, XN_Profile::current()->screenName));
        Group::setStatus($group, XN_Profile::current()->screenName, 'nonmember');
        $_GET['groupId'] = $group->id;
        $topic = Topic::create('Lasagna', 'test');
        $topic->save();
        $this->assertFalse(Group::userIsMember($group, XN_Profile::current()->screenName));
        $this->assertFalse(Group::userIsAdmin($group, XN_Profile::current()->screenName));
    }

    public function tearDown() {
        XG_TestHelper::deleteTestObjects();
    }

}

require $_SERVER['DOCUMENT_ROOT'] . '/test/test_footer.php';
