<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/test/test_header.php';
XG_App::includeFileOnce('/lib/XG_ContactHelper.php');
XG_App::includeFileOnce('/widgets/video/lib/helpers/Video_UserHelper.php');
XG_App::includeFileOnce('/widgets/photo/lib/helpers/Photo_UserHelper.php');
XG_App::includeFileOnce('/widgets/profiles/lib/helpers/Profiles_UserHelper.php');
Mock::generate('TestRest');

class XG_ContactHelperTest extends UnitTestCase {

    private $mockRest;

    public function setUp() {
        $this->mockRest = new ExceptionMockDecorator(new MockTestRest());
    }

    public function tearDown() {
        TestRest::setInstance(null);
        XG_TestHelper::deleteTestObjects();
    }

    public function testGetFriendStatusFor() {
        $result = XG_ContactHelper::getFriendStatusFor(XN_Profile::current()->screenName, array(XN_Profile::current()->screenName));
        $this->assertTrue(is_array($result));
        $this->assertEqual(0, count($result));
        $result = XG_ContactHelper::getFriendStatusFor(XN_Profile::current()->screenName, array(User::loadOrCreate(XN_Profile::current()->screenName)));
        $this->assertTrue(is_array($result));
        $this->assertEqual(0, count($result));
        $this->assertNull(XG_ContactHelper::getFriendStatusFor(XN_Profile::current()->screenName, XN_Profile::current()->screenName));

        $result = Profiles_UserHelper::getFriendStatusFor(XN_Profile::current()->screenName, array(XN_Profile::current()->screenName));
        $this->assertTrue(is_array($result));
        $this->assertEqual(0, count($result));
        $result = Profiles_UserHelper::getFriendStatusFor(XN_Profile::current()->screenName, array(User::loadOrCreate(XN_Profile::current()->screenName)));
        $this->assertTrue(is_array($result));
        $this->assertEqual(0, count($result));
        $this->assertNull(Profiles_UserHelper::getFriendStatusFor(XN_Profile::current()->screenName, XN_Profile::current()->screenName));

        $result = Photo_UserHelper::getFriendStatusFor(XN_Profile::current(), array(XN_Profile::current()->screenName));
        $this->assertTrue(is_array($result));
        $this->assertEqual(0, count($result));
        $result = Photo_UserHelper::getFriendStatusFor(XN_Profile::current(), array(User::loadOrCreate(XN_Profile::current()->screenName)));
        $this->assertTrue(is_array($result));
        $this->assertEqual(0, count($result));
        $this->assertNull(Photo_UserHelper::getFriendStatusFor(XN_Profile::current(), XN_Profile::current()->screenName));

        $result = Video_UserHelper::getFriendStatusFor(XN_Profile::current(), array(XN_Profile::current()->screenName));
        $this->assertTrue(is_array($result));
        $this->assertEqual(0, count($result));
        $result = Video_UserHelper::getFriendStatusFor(XN_Profile::current(), array(User::loadOrCreate(XN_Profile::current()->screenName)));
        $this->assertTrue(is_array($result));
        $this->assertEqual(0, count($result));
        $this->assertNull(Video_UserHelper::getFriendStatusFor(XN_Profile::current(), XN_Profile::current()->screenName));
    }

}

require $_SERVER['DOCUMENT_ROOT'] . '/test/test_footer.php';



