<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/test/test_header.php';

class XG_AuthorizationHelperTest extends UnitTestCase {

    public function testAddSourceParameter() {
        $this->assertEqual(null, TestAuthorizationHelper::addSourceParameter(''));
        $this->assertEqual(null, TestAuthorizationHelper::addSourceParameter(null));
        $url = 'http://example.org?foo=bar';
        $this->assertEqual($url . '&source=' . urlencode(XG_HttpHelper::currentUrl()), TestAuthorizationHelper::addSourceParameter($url));
        $url = 'http://example.org?foo=bar';
        $this->assertEqual($url, TestAuthorizationHelper::addSourceParameter($url, 'http://devbazjon.xnqx.ningops.net/main/authorization/signUp'));
        $url = 'http://example.org?foo=bar&source=' . urlencode('http://example.org');
        $this->assertEqual($url, TestAuthorizationHelper::addSourceParameter($url));
        $url = 'http://example.org?foo=bar&source2=' . urlencode('http://example.org');
        $this->assertEqual($url . '&source=' . urlencode(XG_HttpHelper::currentUrl()), TestAuthorizationHelper::addSourceParameter($url));
    }

    public function testSignUpNingUserUrl() {
        $this->assertEqual('/main/authorization/signUpNingUser?target=' . urlencode('http://example.org?source=' . urlencode(XG_HttpHelper::currentUrl())),
                preg_replace('@^.*?Test.php@', '', XG_AuthorizationHelper::signUpNingUserUrl('http://example.org', null)));
        $this->assertEqual('/main/authorization/signUpNingUser?target=' . urlencode('http://example.org?source=' . urlencode(XG_HttpHelper::currentUrl())) . '&emailAddress=' . urlencode('jon@example.org'),
                preg_replace('@^.*?Test.php@', '', XG_AuthorizationHelper::signUpNingUserUrl('http://example.org', null, 'jon@example.org')));
        $this->assertEqual('/main/authorization/signUpNingUser?target=' . urlencode('http://devbazjon.xnqx.ningops.net/main/authorization/signUp?source=' . urlencode(XG_HttpHelper::currentUrl())),
                preg_replace('@^.*?Test.php@', '', XG_AuthorizationHelper::signUpNingUserUrl('http://devbazjon.xnqx.ningops.net/main/authorization/signUp', null)));
    }

    public function testSignUpUrl() {
        $this->assertEqual('/main/authorization/signUp?target=' . urlencode('http://example.org?source=' . urlencode(XG_HttpHelper::currentUrl())),
                preg_replace('@^.*?Test.php@', '', XG_AuthorizationHelper::signUpUrl('http://example.org', null)));
        $this->assertEqual('/main/authorization/signUp?target=' . urlencode('http://example.org?source=' . urlencode(XG_HttpHelper::currentUrl())) . '&emailAddress=' . urlencode('jon@example.org'),
                preg_replace('@^.*?Test.php@', '', XG_AuthorizationHelper::signUpUrl('http://example.org', null, 'jon@example.org')));
        $this->assertEqual('/main/authorization/signUp?target=' . urlencode('http://devbazjon.xnqx.ningops.net/main/authorization/signUp?source=' . urlencode(XG_HttpHelper::currentUrl())),
                preg_replace('@^.*?Test.php@', '', XG_AuthorizationHelper::signUpUrl('http://devbazjon.xnqx.ningops.net/main/authorization/signUp', null)));
    }

    public function testSignInUrl() {
        $this->assertEqual('/main/authorization/signIn?target=' . urlencode('http://example.org?source=' . urlencode(XG_HttpHelper::currentUrl())),
                preg_replace('@^.*?Test.php@', '', XG_AuthorizationHelper::signInUrl('http://example.org', null)));
        $this->assertEqual('/main/authorization/signIn?target=' . urlencode('http://devbazjon.xnqx.ningops.net/main/authorization/signUp?source=' . urlencode(XG_HttpHelper::currentUrl())),
                preg_replace('@^.*?Test.php@', '', XG_AuthorizationHelper::signInUrl('http://devbazjon.xnqx.ningops.net/main/authorization/signUp', null)));
    }

}

class TestAuthorizationHelper extends XG_AuthorizationHelper {
    public static function addSourceParameter($url, $currentUrl = null) {
        return parent::addSourceParameter($url, $currentUrl);
    }
}

require $_SERVER['DOCUMENT_ROOT'] . '/test/test_footer.php';
