<?php
/**
 * Pre-creates new shapes and new attributes.
 * Generated by diffShapes.php
 */

$shape = XN_Shape::load('Event');
if ($shape) {
    $shape->setAttribute('title', array('type' => 'string', 'indexing' => 'text'));
    $shape->setAttribute('description', array('type' => 'string', 'indexing' => 'text'));
    $shape->setAttribute('private', array('type' => 'boolean', 'indexing' => 'term'));
    $shape->save();
}

$shape = XN_Shape::load('Note');
if ($shape) {
    $shape->setAttribute('title', array('type' => 'string', 'indexing' => 'text'));
    $shape->setAttribute('description', array('type' => 'string', 'indexing' => 'text'));
    $shape->setAttribute('private', array('type' => 'boolean', 'indexing' => 'term'));
    $shape->save();
}

try {
    $shape = XN_Shape::create('Event');
    $shape->searchable = true;
    $shape->setAttribute('title', array('type' => 'string', 'indexing' => 'text'));
    $shape->setAttribute('description', array('type' => 'string', 'indexing' => 'text'));
    $shape->setAttribute('private', array('type' => 'boolean', 'indexing' => 'term'));
    $shape->setAttribute('my.city', array('type' => 'string', 'indexing' => 'text'));
    $shape->setAttribute('my.contactInfo', array('type' => 'string', 'indexing' => 'text'));
    $shape->setAttribute('my.disableRsvp', array('type' => 'number'));
    $shape->setAttribute('my.endDate', array('type' => 'string'));
    $shape->setAttribute('my.eventType', array('type' => 'string'));
    $shape->setAttribute('my.eventTypeOrig', array('type' => 'string', 'indexing' => 'text'));
    $shape->setAttribute('my.excludeFromPublicSearch', array('type' => 'string', 'indexing' => 'phrase'));
    $shape->setAttribute('my.hideEndDate', array('type' => 'number'));
    $shape->setAttribute('my.isClosed', array('type' => 'number'));
    $shape->setAttribute('my.location', array('type' => 'string', 'indexing' => 'text'));
    $shape->setAttribute('my.mozzle', array('type' => 'string', 'indexing' => 'text'));
    $shape->setAttribute('my.organizedBy', array('type' => 'string', 'indexing' => 'text'));
    $shape->setAttribute('my.photoId', array('type' => 'string'));
    $shape->setAttribute('my.photoUrl', array('type' => 'string'));
    $shape->setAttribute('my.privacy', array('type' => 'number'));
    $shape->setAttribute('my.showGuestList', array('type' => 'number'));
    $shape->setAttribute('my.startDate', array('type' => 'string'));
    $shape->setAttribute('my.street', array('type' => 'string', 'indexing' => 'text'));
    $shape->setAttribute('my.website', array('type' => 'string', 'indexing' => 'text'));
    $shape->setAttribute('my.xg_events_commentCount', array('type' => 'number'));
    $shape->setAttribute('my.xg_main_promotedOn', array('type' => 'date'));
    $shape->save();
} catch(Exception $e) {
    // Shape already exists
}

try {
    $shape = XN_Shape::create('EventAttendee');
    $shape->setAttribute('my.activityLogId', array('type' => 'string'));
    $shape->setAttribute('my.eventEndDate', array('type' => 'string'));
    $shape->setAttribute('my.eventId', array('type' => 'string'));
    $shape->setAttribute('my.eventStartDate', array('type' => 'string'));
    $shape->setAttribute('my.eventType', array('type' => 'string'));
    $shape->setAttribute('my.inviter', array('type' => 'string'));
    $shape->setAttribute('my.mozzle', array('type' => 'string'));
    $shape->setAttribute('my.screenName', array('type' => 'string'));
    $shape->setAttribute('my.status', array('type' => 'number'));
    $shape->save();
} catch(Exception $e) {
    // Shape already exists
}

try {
    $shape = XN_Shape::create('EventCalendar');
    $shape->setAttribute('my.eventCounts', array('type' => 'string'));
    $shape->setAttribute('my.month', array('type' => 'string'));
    $shape->setAttribute('my.mozzle', array('type' => 'string'));
    $shape->save();
} catch(Exception $e) {
    // Shape already exists
}

try {
    $shape = XN_Shape::create('EventWidget');
    $shape->setAttribute('my.eventMaxDate', array('type' => 'string'));
    $shape->setAttribute('my.eventMinDate', array('type' => 'string'));
    $shape->setAttribute('my.eventTypes', array('type' => 'string'));
    $shape->setAttribute('my.mozzle', array('type' => 'string'));
    $shape->save();
} catch(Exception $e) {
    // Shape already exists
}

try {
    $shape = XN_Shape::create('Note');
    $shape->searchable = true;
    $shape->setAttribute('title', array('type' => 'string', 'indexing' => 'text'));
    $shape->setAttribute('description', array('type' => 'string', 'indexing' => 'text'));
    $shape->setAttribute('private', array('type' => 'boolean', 'indexing' => 'term'));
    $shape->setAttribute('my.excludeFromPublicSearch', array('type' => 'string', 'indexing' => 'phrase'));
    $shape->setAttribute('my.lastUpdatedBy', array('type' => 'string'));
    $shape->setAttribute('my.mozzle', array('type' => 'string', 'indexing' => 'phrase'));
    $shape->setAttribute('my.noteKey', array('type' => 'string'));
    $shape->setAttribute('my.version', array('type' => 'number'));
    $shape->setAttribute('my.visibility', array('type' => 'string', 'indexing' => 'phrase'));
    $shape->setAttribute('my.xg_main_promotedOn', array('type' => 'date'));
    $shape->save();
} catch(Exception $e) {
    // Shape already exists
}

$shape = XN_Shape::load('User');
if ($shape) {
    $shape->setAttribute('my.emailAdminMessagesPref', array('type' => 'string'));
    $shape->setAttribute('my.emailEventBroadcastPref', array('type' => 'string'));
    $shape->setAttribute('my.xg_events_calendar', array('type' => 'string'));
    $shape->setAttribute('my.xg_events_eventTypes', array('type' => 'string'));
    $shape->setAttribute('my.activityEvents', array('type' => 'string'));
    $shape->setAttribute('my.viewEventsPermission', array('type' => 'string'));
    $shape->save();
}

echo 'Done';
