<?php

define('NF_APP_BASE',$_SERVER['DOCUMENT_ROOT']);
/* Load our custom App class */
XG_App::includeFileOnce('/lib/XG_App.php'); //TODO this include doesn't make any sense.  XG_App must be included to be able to use it!
/* Content and profile caching */
XG_App::includeFileOnce('/lib/XG_Cache.php');
/* Query result caching */
XG_App::includeFileOnce('/lib/XG_Query.php');

define('F8_DIRECTORY',NF_APP_BASE.'/xn_resources/ext/facebook');
define('F8_CALLBACK_DIRECTORY',NF_APP_BASE.'/ext/facebook');
define('F8_PRIVATE_DIRECTORY',NF_APP_BASE.'/xn_private/ext/facebook');
define('F8_LOG',F8_DIRECTORY.'/xn_private/xn_volatile/f8-error.log');


class XG_FacebookHelper {

    public static function generateEmbedCode($codetype) {
        //TODO
        $_GET['internalView'] = 'true';
        $applicationUrl = W_Cache::getWidget('main')->config['appSubdomain'];

        if ($codetype == 'video') {
            //video doesn't use feeds-- video is included in the config file
            XG_FacebookHelper::updateEmbedFeed($codetype);
        }
        else if ($codetype == 'photo') {
            $_GET['x'] = W_Cache::getWidget('photo')->privateConfig['embeddableAccessCode'];

            // list($retval, $output) array with 2 elements -- the feed is second, return type first
            $playerConfig = W_Cache::getWidget('photo')->capture('photo','showPlayerConfig');
            $playerConfig = $playerConfig[1];
            $configCodeTarget = F8_DIRECTORY . '/photo/fbconfig.xml';
            file_put_contents($configCodeTarget, $playerConfig);

            $fbmlEmbed = '<fb:swf';
            $fbmlEmbed = $fbmlEmbed . ' imgsrc="http://static.ning.com/' . $applicationUrl . '/widgets/index/gfx/facebook/' . $codetype . '-still.png" ';
            //$fbmlEmbed = $fbmlEmbed . ' imgsrc="http://static.ning.com/' . $applicationUrl . '/ext/facebook/' . $codetype . '/preload.png" ';
            $fbmlEmbed = $fbmlEmbed . 'swfsrc="http://static.ning.com/' . $applicationUrl . '/widgets/' . $codetype . '/slideshowplayer/slideshowplayer.swf" ';

            $configUrl = urlencode('http://static.ning.com/' . $applicationUrl . '/ext/facebook/' . $codetype . '/fbconfig.xml?flash=true');
            $feedUrl = urlencode('http://static.ning.com/' . $applicationUrl . '/ext/facebook/' . $codetype . '/feed.xml?photo_width=380&photo_height=306'); //photos have same width of height
            $fullsizeFeedUrl = urlencode('http://static.ning.com/' . $applicationUrl . '/ext/facebook/' . $codetype . '/feed_large.xml?');
            $fullsizeUrl = urlencode('http://' . $_SERVER['HTTP_HOST'].'/photo/photo/slideshow?feed_url='.$fullsizeFeedUrl);
            $flashvars = 'config_url=' . $configUrl.'&autoplay=on';
            $flashvars = $flashvars .  '&feed_url=' .$feedUrl . '&fullsize_url='.$fullsizeUrl;
            $fbmlEmbed = $fbmlEmbed . ' flashvars="' .$flashvars . '"';
            $fbmlEmbed = $fbmlEmbed . ' width="380" height="335" scale="noscale"></fb:swf>';

            $configCodeTarget = F8_DIRECTORY . '/photo/fbembed.html';

            file_put_contents($configCodeTarget, $fbmlEmbed);
        }
        else if ($codetype == 'music') {


            $fbmlEmbed = '<fb:swf';
            $fbmlEmbed = $fbmlEmbed . ' imgsrc="http://static.ning.com/' . $applicationUrl . '/widgets/index/gfx/facebook/' . $codetype . '-still.png" ';
            //$fbmlEmbed = $fbmlEmbed . ' imgsrc="http://static.ning.com/' . $applicationUrl . '/ext/facebook/' . $codetype . '/preload.png" ';
            $fbmlEmbed = $fbmlEmbed . 'swfsrc="http://static.ning.com/' . $applicationUrl . '/widgets/' . $codetype . '/swf/xspf_player.swf" ';

            //must add ?flash=true to the URLs called from within the embed because flash adds & variables
            $placeholderUrl = urlencode('http://static.ning.com/' . $applicationUrl . '/widgets/' . $codetype . '/gfx/placeholder.png?flash=true');
            // Use xg_akamai_url to make the domain the same as that of the swf (static.ning.com); otherwise XML.load will fail [Jon Aquino 2007-07-06]
            $flashvars = 'configXmlUrl=' . urlencode(xg_akamai_url('/xn_resources/instances/music/playlist/music-config.xml'));
            $flashvars = $flashvars . '&placeholder_url=' . $placeholderUrl;
            $feedUrl = urlencode('http://static.ning.com/' . $applicationUrl . '/ext/facebook/' . $codetype . '/feed.xspf?flash=true');
            $flashvars = $flashvars . '&playlist_url=' . $feedUrl;
            $flashvars = $flashvars . '&autoplay=on';
            $flashvars = $flashvars .  '&xn_app_url=http://' . $_SERVER['HTTP_HOST'] . '&display_add_links=off&display_logo=true&';

            $fbmlEmbed = $fbmlEmbed . ' flashvars="' .$flashvars . '"';
            $fbmlEmbed = $fbmlEmbed . ' width="180" height="238" scale="noscale"></fb:swf>';

            $configCodeTarget = F8_DIRECTORY . '/music/fbembed.html';

            file_put_contents($configCodeTarget, $fbmlEmbed);
        }

        XG_FacebookHelper::generateEmbedCanvas($codetype);
    }


    public static function generateEmbedCanvasAppInclude($codetype) {
        $applicationUrl = W_Cache::getWidget('main')->config['appSubdomain'];
        $fbApiKey = W_Cache::getWidget('main')->config['facebookApiKey-' . $codetype];
        $fbSecret = W_Cache::getWidget('main')->config['facebookApiSecret-' . $codetype];

        $appIncludeCodeTarget = F8_PRIVATE_DIRECTORY . '/' . $codetype . '/appinclude.php';
        $appInclCode = '<?php';
        $appInclCode = $appInclCode . ' define(\'NF_APP_BASE\',$_SERVER[\'DOCUMENT_ROOT\']);';
        $appInclCode = $appInclCode . ' require_once NF_APP_BASE . \'/lib/ext/facebook/facebook.php\';';
        $appInclCode = $appInclCode . ' $appapikey = \'' . $fbApiKey .'\';';
        $appInclCode = $appInclCode . ' $appsecret = \'' . $fbSecret .'\';';
        $appInclCode = $appInclCode . ' $facebook = new Facebook($appapikey, $appsecret);';
        $appInclCode = $appInclCode . ' $user = $facebook->require_login();';

        $appInclCode = $appInclCode . ' $appcallbackurl = \'http://' . $applicationUrl . '.ning.com/ext/facebook/' . $codetype . '/\';';


        $appInclCode = $appInclCode . ' try {  if (!$facebook->api_client->users_isAppAdded()) {    $facebook->redirect($facebook->get_add_url());  } } ';
        $appInclCode = $appInclCode . ' catch (Exception $ex) {   $facebook->set_user(null, null);  $facebook->redirect($appcallbackurl); }';

        file_put_contents($appIncludeCodeTarget, $appInclCode);
    }

    public static function generateEmbedCanvas($codetype) {
        $applicationUrl = W_Cache::getWidget('main')->config['appSubdomain'];
        $fbApiKey = W_Cache::getWidget('main')->config['facebookApiKey-' . $codetype];
        $fbSecret = W_Cache::getWidget('main')->config['facebookApiSecret-' . $codetype];

        $embedCodeSource = F8_DIRECTORY . '/' . $codetype . '/fbembed.html';
        $canvasCodeTarget = F8_CALLBACK_DIRECTORY . '/' . $codetype . '/index.php';

        $embedcode = file_get_contents(F8_DIRECTORY . '/' . $codetype . '/fbembed.html');

        $code = $code . '<?php ';
        $code = $code . ' define(\'NF_APP_BASE\',$_SERVER[\'DOCUMENT_ROOT\']);';
        $code = $code . 'require_once NF_APP_BASE . \'/xn_private/ext/facebook/' . $codetype .  '/appinclude.php\';';
        $code = $code . '?>';
        $code = $code . ' ';
        $code = $code . '<center>';
        $code = $code . '<!-- this file is automatically generated by wrapping fbembed.html with center..../center. Do not edit, changes will be overwritten -->';
        $code = $code . $embedcode;
        $code = $code . '</center>';

        file_put_contents($canvasCodeTarget, $code);
    }

    public static function updateEmbedFeed($codetype) {
        $_GET['internalView'] = 'true';
        $dispType = XG_App::getFacebookDisplayType($codetype);

        $applicationUrl = W_Cache::getWidget('main')->config['appSubdomain'];


        if ($codetype == 'video') {
            //video doesn't use feeds-- video is included in the config file
            $_GET['x'] = W_Cache::getWidget('video')->privateConfig['embeddableAccessCode'];

            $dispType = XG_App::getFacebookDisplayType('video');

            if ($dispType == null || $dispType == 'default') { //default is recent
                $videoQuery = W_Cache::getWidget('video')->capture('video','getMostRecentLocalVideo');
            }
            else if ($dispType == 'promoted') {
                $videoQuery = W_Cache::getWidget('video')->capture('video','getMostRecentPromotedLocalVideo');
            }
            else if ($dispType == 'rated') {
                $videoQuery = W_Cache::getWidget('video')->capture('video','getHighestRatedLocalVideo');
            }
            $_GET['id'] = $videoQuery[0]->id;


            // list($retval, $output) array with 2 elements -- the feed is second, return type first
            $playerConfig = W_Cache::getWidget('video')->capture('video','showPlayerConfig');
            $playerConfig = $playerConfig[1];
            $configCodeTarget = F8_DIRECTORY . '/video/fbconfig.xml';
            file_put_contents($configCodeTarget, $playerConfig);

            $fbmlEmbed = '<fb:swf';
            $fbmlEmbed = $fbmlEmbed . ' imgsrc="http://static.ning.com/' . $applicationUrl . '/widgets/index/gfx/facebook/' . $codetype . '-still.png" ';
            //$fbmlEmbed = $fbmlEmbed . ' imgsrc="http://static.ning.com/' . $applicationUrl . '/ext/facebook/' . $codetype . '/preload.png" ';
            $fbmlEmbed = $fbmlEmbed . 'swfsrc="http://static.ning.com/' . $applicationUrl . '/widgets/' . $codetype . '/flvplayer/flvplayer.swf" ';

            $configUrl = urlencode('http://static.ning.com/' . $applicationUrl . '/ext/facebook/' . $codetype . '/fbconfig.xml?flash=true');
            $flashvars = 'config_url=' . $configUrl;
            $flashvars = $flashvars .  '&autoplay=on&embed_btn=on&share_btn=on&app_link=on&fullscreen_btn=off&';

            $fbmlEmbed = $fbmlEmbed . ' flashvars="' .$flashvars . '"';
            $fbmlEmbed = $fbmlEmbed . ' width="380" height="318" scale="noscale"></fb:swf>';

            $configCodeTarget = F8_DIRECTORY . '/video/fbembed.html';

            file_put_contents($configCodeTarget, $fbmlEmbed);

        }
        else if ($codetype == 'photo') {
            $_GET['x'] = W_Cache::getWidget('photo')->privateConfig['embeddableAccessCode'];

            if ($dispType == null || $dispType == 'default') { //default is main recent
                //no action right now
            }
            else if ($dispType == 'promoted') {
                $_GET['promoted'] = 'true';
            }
            else if ($dispType == 'popular') {
                $_GET['popular'] = 'true';
            }
            $_GET['photo_width'] = 380;
            $_GET['photo_height'] = 306;
            $feed = W_Cache::getWidget('photo')->capture('photo','slideshowFeed');
            $feed = $feed[1];
            $embedCodeTarget = F8_DIRECTORY . '/photo/feed.xml';
            file_put_contents($embedCodeTarget, $feed);
            
            //fulsize slideshow static feed
            $_GET['photo_width'] = 800;
            $_GET['photo_height'] = 600;
            $feed = W_Cache::getWidget('photo')->capture('photo','slideshowFeed');
            $feed = $feed[1];
            $embedCodeTarget = F8_DIRECTORY . '/photo/feed_large.xml';
            file_put_contents($embedCodeTarget, $feed);
        }
        else if ($codetype == 'music') {
            $_GET['x'] = W_Cache::getWidget('music')->privateConfig['embeddableAccessCode'];
            $_REQUEST['fmt'] = 'xspf';


            if ($dispType == null || $dispType == 'default') { //default is recent
                $feed = W_Cache::getWidget('music')->capture('track','list');
            }
            else if ($dispType == 'promoted') {
                $feed = W_Cache::getWidget('music')->capture('track','listPromoted');
            }
            else if ($dispType == 'rated') {
                $feed = W_Cache::getWidget('music')->capture('track','listHighestRated');
            }

            $feed = $feed[1];
            $embedCodeTarget = F8_DIRECTORY . '/music/feed.xspf';
            file_put_contents($embedCodeTarget, $feed);
        }
    }

    public static function disablePlayer($playertype) {
        XG_App::disableFacebookEmbed($playertype);
    }

    public static function setFacebookDisplayType($embedType, $displayType) {
        XG_App::setFacebookDisplayType($embedType, $displayType);
    }

    //typically playertype will come from _GET and will be one of 'video', 'photo', 'music'
    //should be called AFTER setupPlayer
    public static function enableEmbedAndCanvas($playertype, $fbKey, $fbSecret, $fbAppUrl) {
        //--sets the value of the config variable to 1 and adds the key and the secret
        XG_App::enableFacebookEmbed($playertype, $fbKey, $fbSecret, $fbAppUrl);

        //--generates canvas  code into F8_DIRECTORY . '/video/canvas.html' by wrapping fbembed.html with <html><head></head><body>EMBEDCODE</body></html>
        //depends on having called XG_FacebookHelper::generateEmbedCode($playertype);
        XG_FacebookHelper::generateEmbedCanvasAppInclude($playertype);
    }

    public static function setupPlayer($playertype) {
        @mkdir((F8_DIRECTORY . '/' . $playertype), 0750, TRUE);
        @mkdir((F8_CALLBACK_DIRECTORY . '/' . $playertype), 0750, TRUE);
        @mkdir((F8_PRIVATE_DIRECTORY . '/' . $playertype), 0740, TRUE);

        //--generates embed code into F8_DIRECTORY . '/video/fbembed.html'
        XG_FacebookHelper::generateEmbedCode($playertype);
    }

    //requires a previous call to setupPlayer(...)
    public static function getDefaultPlayerEmbedCode($playertype) {
        //--gets embed code from F8_DIRECTORY . '/video/fbembed.html'
        $embedcode = file_get_contents(F8_DIRECTORY . '/' . $playertype . '/fbembed.html');
        return $embedcode;
    }

    public static function updateEmbedFeeds()
    {


        if (XG_App::appIsFacebookEmbedEnabled('video')) {
            XG_FacebookHelper::updateEmbedFeed('video');
            //		echo '<br/>';
            //echo 'Updating feeds for video.';
        }

        if (XG_App::appIsFacebookEmbedEnabled('photo')) {
            XG_FacebookHelper::updateEmbedFeed('photo');
            //		echo '<br/>';
            //		echo 'Updating feeds for photo slideshow.';
        }

        if (XG_App::appIsFacebookEmbedEnabled('music')) {
            XG_FacebookHelper::updateEmbedFeed('music');
            //		echo '<br/>';
            //		echo 'Updating feeds for photo music.';
        }

        //echo '</body></html>';
    }




}