
<?php

XG_App::includeFileOnce('/lib/XG_AbstractMessageCatalog.php');

/**
 * Texts for the pl_PL
 */
class XG_MessageCatalog_pl_PL extends XG_AbstractMessageCatalog {


    /**
     * Returns a localized version of a string. The first argument is the message name, e.g., 'ADD_A_PHOTO'.
     * Subsequent arguments are substitution values (if the message contains sprintf format elements).
     *
     * @param array $args the message name, plus optional substitution values
     * @return string the localized string
     * @see xg_html()
     */
    public static function text($args) {
        $s = $args[0];
        static $a = array();
        if (! $a) {
            $a['N_SECONDS_AGO']['1'] = '1 sekundę temu ';
            $a['N_SECONDS_AGO']['n'] = '%s sekund temu ';
            $a['N_MINUTES_AGO']['1'] = '1 minutę temu ';
            $a['N_MINUTES_AGO']['n'] = '%s minut temu ';
            $a['N_HOURS_AGO']['1'] = '1 godzinę temu ';
            $a['N_HOURS_AGO']['n'] = '%s godzin temu ';
            $a['N_VIDEOS']['1'] = '<strong>1</strong> plik wideo ';
            $a['N_VIDEOS']['n'] = '<strong>%s</strong> pliki wideo ';
            $a['N_VIEWS']['1'] = '1 widok ';
            $a['N_VIEWS']['n'] = '%s widoki ';
            $a['N_COMMENTS']['1'] = '<span class="comment-count">1</span> komentarz ';
            $a['N_COMMENTS']['n'] = '<span class="comment-count">%s</span> komentarze ';
            $a['VIDEO_IS_FAVORITE_OF']['1'] = 'Ten plik wideo należy do <strong>ulubionych <strong>1 osoby</strong>. ';
            $a['VIDEO_IS_FAVORITE_OF']['n'] = 'Ten plik wideo należy do <strong>ulubionych <strong>%s osób</strong>. ';
            $a['Y_ADDED_X_VIDEOS']['1'] = 'Użytkownik %2$s dodał plik wideo: ';
            $a['Y_ADDED_X_VIDEOS']['n'] = 'Użytkownik %2$s dodał %s pliki wideo. ';
            $a['YOU_ADDED_X_VIDEOS']['1'] = 'Został dodany Twój plik wideo: ';
            $a['YOU_ADDED_X_VIDEOS']['n'] = 'Dodałeś %s pliki wideo. ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['1'] = 'Na %2$s znajduje się 1 plik wideo. ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['n'] = 'Na %2$s znajduje się %1$s plików wideo. ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['1'] = 'Na %2$s znajduje się 1 <a href="%3$s">plik wideo</a>. ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['n'] = 'Na %2$s znajduje się 1 <a href="%3$s">plik wideo</a>. ';
            $a['N_PHOTOS_FROM_ALBUM']['1'] = '1 zdjęcie z tego albumu zostało usunięte lub oznaczone jako prywatne, więc nie może zostać wyświetlone. ';
            $a['N_PHOTOS_FROM_ALBUM']['n'] = '%s zdjęć z tego albumu zostało usuniętych lub oznaczonych jako prywatne, więc nie mogą zostać wyświetlone. ';
            $a['N_PHOTOS']['1'] = '<strong>1</strong> zdjęcie ';
            $a['N_PHOTOS']['n'] = '<strong>%s</strong> zdjęcia ';
            $a['N_PHOTOS_2']['1'] = '1 zdjęcie ';
            $a['N_PHOTOS_2']['n'] = '%s zdjęcia ';
            $a['PROBLEM_UPLOADING_FILES']['1'] = 'Wystąpił problem przy przekazywaniu następującego pliku: ';
            $a['PROBLEM_UPLOADING_FILES']['n'] = 'Wystąpił problem przy przekazywaniu następujących plików: ';
            $a['PHOTO_IS_FAVORITE_OF']['1'] = 'To zdjęcie należy do <strong>ulubionych/strong> <strong>1 osoby</strong>. ';
            $a['PHOTO_IS_FAVORITE_OF']['n'] = 'To zdjęcie należy do <strong>ulubionych <strong>%s osób</strong>. ';
            $a['RATING_Y_AFTER_X_VOTES']['1'] = '<strong>Ocena:</strong> %2$s po 1 głosie ';
            $a['RATING_Y_AFTER_X_VOTES']['n'] = '<strong>Ocena:</strong> %2$s po %s głosach ';
            $a['Y_AFTER_X_VOTES']['1'] = '%2$s po 1 głosie ';
            $a['Y_AFTER_X_VOTES']['n'] = '%2$s po %s głosach ';
            $a['N_PEOPLE']['1'] = '1 osoba ';
            $a['N_PEOPLE']['n'] = '%s osoby ';
            $a['N_OF_5_STARS']['1'] = '1/5 gwiazdka ';
            $a['N_OF_5_STARS']['n'] = '%s/5 gwiazdki/gwiazdek ';
            $a['YOUR_RATING_X_STARS']['1'] = 'Twoja ocena: 1 gwiazdka ';
            $a['YOUR_RATING_X_STARS']['n'] = 'Twoja ocena: %s gwiazdki/gwiazdek ';
            $a['Y_ADDED_X_PHOTOS']['1'] = 'Użytkownik %2$s dodał zdjęcie: ';
            $a['Y_ADDED_X_PHOTOS']['n'] = 'Użytkownik %2$s dodał %s zdjęć. ';
            $a['YOU_ADDED_X_PHOTOS']['1'] = 'Dodałeś zdjęcie: ';
            $a['YOU_ADDED_X_PHOTOS']['n'] = 'Dodałeś %s zdjęć. ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['1'] = 'Na %2$s znajduje się 1 zdjęcie. ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['n'] = 'Na %2$s znajduje się %1$s zdjęć. ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['1'] = 'Na %1$s znajduje się <a href="%3$s">zdjęcie</a>. ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['n'] = 'Na %2$s znajdują się %1$s <a href="%3$s">zdjęcia</a>. ';
            $a['N_INVITATIONS_RESENT']['1'] = 'Wysłano 1 zaproszenie. ';
            $a['N_INVITATIONS_RESENT']['n'] = 'Wysłano %s zaproszeń. ';
            $a['AND_X_OTHER_PEOPLE']['1'] = 'i 1 dodatkowa osoba ';
            $a['AND_X_OTHER_PEOPLE']['n'] = 'i %s dodatkowych osób ';
            $a['N_COMMENTS_ON_PAGE']['1'] = '<strong>1</strong> Komentarz do profilu ';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s</strong> Komentarze do profilu ';
            $a['N_BLOG_COMMENTS']['1'] = '<strong>1</strong> komentarz na blogu ';
            $a['N_BLOG_COMMENTS']['n'] = '<strong>%s</strong> komentarze na blogu ';
            $a['N_YEARS_OLD']['1'] = 'Roczny ';
            $a['N_YEARS_OLD']['n'] = '%s-letni ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['1'] = 'Masz 1 żądanie przyjaciela! ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['n'] = 'Masz %s żądań przyjaciół! ';
            $a['COMMENT_WALL_N_COMMENTS']['1'] = 'Sciana komentarzy (1 komentarz) ';
            $a['COMMENT_WALL_N_COMMENTS']['n'] = 'Ściana komentarzy (%s komentarzy) ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['1'] = '1 nowy uczestnik przyłączył się w ubiegłym tygodniu ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['n'] = '%s nowi uczestnicy przyłączyli się w ubiegłym tygodniu ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['1'] = '1 <a href="%2$s">nowy uczestnik </a> przyłączył się w ubiegłym tygodniu ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['n'] = '%1$s <a href="%2$s">nowi uczestnicy </a> przyłączyli się w ubiegłym tygodniu ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['1'] = 'Na %2$s jest 1 uczestnik. ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['n'] = 'Na %2$s jest %1$s uczestników. ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['1'] = 'Na %2$s jest 1 <a href="%3$s">uczestnik</a>. ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['n'] = 'Na %2$s jest %1$s <a href="%3$s">uczestników</a>. ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['1'] = 'Na %2$s jest 1 post blogu. ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['n'] = 'Na %2$s jest %1$s postów blogu. ';
            $a['N_NEW_MEMBERS']['1'] = '<strong>1</strong> nowy uczestnik ';
            $a['N_NEW_MEMBERS']['n'] = '<strong>%s</strong> nowych uczestników ';
            $a['N_REPLIES']['1'] = '1 odpowiedź ';
            $a['N_REPLIES']['n'] = '%s odpowiedzi ';
            $a['N_MINUTES']['1'] = 'Pozostała 1 minuta na edycję komentarza. ';
            $a['N_MINUTES']['n'] = 'Pozostało %s minut na edycję komentarza. ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['1'] = 'Na %2$s znajduje się 1 temat forum. ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['n'] = 'Na %2$s znajduje się %1$s tematów forum. ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['1'] = 'Na %2$s znajduje się 1 <a href="%3$s">temat forum </a>. ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['n'] = 'Na %2$s znajduje się %1$s <a href="%3$s">tematów forum </a>. ';
            $a['N_INVITES']['1'] = 'Zaproś użytkownika %s ';
            $a['N_INVITES']['n'] = 'Użytkownik %s zaprasza ';
            $a['N_MEMBERS']['1'] = '1 uczestnik ';
            $a['N_MEMBERS']['n'] = '%s uczestników ';
            $a['N_MEMBERS_PARENTHESIZED']['1'] = '(1 uczestnik) ';
            $a['N_MEMBERS_PARENTHESIZED']['n'] = '(%s uczestników) ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['1'] = 'Na %2$s jest 1 grupa. ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['n'] = 'Na %2$s jest %1$s grup. ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['1'] = 'Na %2$s jest %1$s <a href="%3$s">grupa</a>. ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['n'] = 'Na %2$s jest %1$s <a href="%3$s">grup</a>. ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['1'] = 'Nie można wyświetlić 1 utworu z tej listy odtwarzania, ponieważ został usunięty lub nie jest już udostępniany. ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['n'] = 'Nie można wyświetlić %s utworów z tej listy odtwarzania, ponieważ zostały usunięte lub nie są już udostępniane. ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['1'] = 'Do %2$s dodano nowy utwór. ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['n'] = 'Do %2$s dodano %1$s nowych utworów. ';
            $a['Y_ADDED_X_SONGS']['1'] = 'Użytkownik %2$s dodał utwór: ';
            $a['Y_ADDED_X_SONGS']['n'] = 'Użytkownik %2$s dodał %s utworów. ';
            $a['YOU_ADDED_X_SONGS']['1'] = 'Dodałeś utwór: ';
            $a['YOU_ADDED_X_SONGS']['n'] = 'Dodałeś %s utworów. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['1'] = 'Dodano 1 utwór do listy odtwarzania. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['n'] = 'Dodano %s utworów do listy odtwarzania. ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['1'] = 'Na %2$s jest 1 utwór. ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['n'] = 'Na %2$s jest %1$s utworów. ';
        }
        if ($a[$args[0]]) {
            $args[0] = $a[$args[0]][$args[1]] ? $a[$args[0]][$args[1]] : $a[$args[0]]['n'];
            return @call_user_func_array('sprintf', $args);
        }
        $text = self::$messages[$s];
        if ($text) { $args[0] = $text; }
        return @call_user_func_array('sprintf', $args);
    }

    /**
     * Message names and texts. Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;
     */
    private static $messages = array(
        'BROWSING' => 'Przeglądanie',
        'MORE_VIDEOS' => 'Więcej plików wideo',
        'NETWORK_DOES_NOT_HAVE_VIDEOS' => 'W tej sieci nie ma jeszcze plików wideo.',
        'NETWORK_DOES_NOT_HAVE_FEATURED_VIDEOS' => 'W tej sieci nie ma jeszcze zamieszczonych plików wideo.',
        'PERSON_DOES_NOT_HAVE_VIDEOS' => 'Ta osoba nie ma jeszcze żadnych plików wideo.',
        'COPY_TO_CLIPBOARD' => 'Skopiuj do Schowka',
        'COPIED_TO_CLIPBOARD' => 'Skopiowano do Schowka!',
        'NO_VIDEOS_TO_DISPLAY' => 'Nie wyświetlasz obecnie żadnych plików wideo.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_VIDEO' => 'To pole nie pojawi się u innych osób, chyba że wybierzesz co najmniej jeden plik wideo.',
        'WATERMARK_LOGO' => 'Znak wodny',
        'CHOOSE_HEADER_OR_WATERMARK' => 'Dla używanego odtwarzacza wideo można wybrać nagłówek lub znak wodny.',
        'CUSTOMIZE_EMBED_INSTRUCTIONS' => 'Znak jest wyświetlany w górnej części używanego odtwarzacza %s.  Jeśli nie zostanie dodany znak, zamiast niego wyświetlana będzie nazwa sieci.  Znak użytkownika powinien mieć . format jpg, . gif lub . png.  Znaki o rozmiarze ponad 20 pikseli zostaną odpowiednio dopasowane.',
        'CUSTOMIZE_WATERMARK_INSTRUCTIONS' => 'Znak wodny jest wyświetlany nad górnym prawym rogiem klipu wideo.',
        'HEADER_LOGO' => 'Znak nagłówka',
        'WATERMARK' => 'Znak wodny',
        'CUSTOMIZE_YOUR_VIDEO_PLAYER' => 'Dostosuj swój odtwarzacz wideo!',
        'VIDEO_PLAYER' => 'Odtwarzacz wideo',
        'HEADER' => 'Nagłówek',
        'SAVE_CHANGES' => 'Zapisz zmiany',
        'THUMBNAIL' => 'Miniatura',
        'CONVERSION_FAILED' => 'Konwersja nie powiodła się.',
        'CONVERSION_IN_PROGRESS' => 'Konwersja w toku.',
        'MAP' => 'Mapa',
        'WHAT_IS_THIS' => 'Co to jest?',
        'EDIT_VIDEO_INFORMATION' => 'Edytuj informacje wideo',
        'ALL_VIDEOS' => 'Wszystkie pliki wideo',
        'VIDEOS_HOME' => 'Strona główna wideo',
        'MY_VIDEOS' => 'Moje wideo',
        'MY_FRIENDS_VIDEOS' => 'Pliki wideo przyjaciół',
        'MY_FAVORITES' => 'Moje ulubione',
        'XS_FAVORITES' => 'Ulubione użytkownika %s',
        'ADD_A_VIDEO' => 'Dodaj plik wideo',
        'JUST_NOW' => 'Teraz',
        '1_DAY_AGO' => '1 dzień temu',
        'M_J' => 'M j',
        'ME' => 'Ja',
        'X_SAID' => 'Użytkownik %s powiedział…',
        'DELETE_COMMENT' => 'Usuń komentarz',
        'YOU_HAVE_NOT_ADDED_VIDEOS' => 'Nie dodałeś jeszcze żadnych plików wideo!',
        'ADD_VIDEOS_AND_SHARE' => 'Dodawaj i udostępniaj pliki wideo przyjaciołom, rodzinie i reszcie świata!',
        'THERE_ARE_NO_VIDEOS' => 'W Twojej sieci społecznej nie ma obecnie żadnych plików wideo.',
        'THIS_BOX_WILL_NOT_SHOW' => 'To pole nie wyświetli się innym osobom, jeśli nie ma żadnych plików wideo do pokazania. Chcesz dodać plik wideo?',
        'ADD_VIDEOS' => 'Dodaj pliki wideo',
        'VIEW_VIDEOS' => 'Przeglądaj pliki wideo',
        'YIKES' => 'Oj!',
        'A_PROBLEM_SEEMS' => 'Chyba mamy problem.',
        'FOR_FURTHER_ASSISTANCE' => 'Aby uzyskać dalszą pomoc, <a %s>skontaktuj się z nami</a>.',
        'OR_YOU_CAN_GO' => 'Zamiast tego możesz cofnąć się do <a %s>strony głównej %s</a> lub przejść do <a %s>innych sieci społecznych Ning</a>.',
        'TAGS' => 'Znaczniki:',
        'POPULAR_TAGS' => 'Popularne znaczniki',
        'MY_FRIENDS' => 'Moi przyjaciele',
        'VIEW_ALL_MY_FRIENDS' => 'Przeglądaj wszystkich moich przyjaciół',
        'VIEW_ALL_XS_FRIENDS' => 'Przeglądaj wszystkich przyjaciół użytkownika %s',
        'WE_COULD_NOT_FIND_ANYONE_MATCHING' => 'Przepraszamy, ale nie możemy znaleźć osoby odpowiadającej podanym kryteriom.',
        'VIEW_POPULAR_CONTRIBUTORS' => 'Wyświetl popularnych współautorów',
        'POPULAR_CONTRIBUTORS' => 'Popularni współautorzy',
        'VIEW_MORE_CONTRIBUTORS' => 'Wyświetl innych współautorów',
        'ADD_AS_FRIEND' => 'Dodaj jako przyjaciela',
        'SEND_A_MESSAGE' => 'Wyślij wiadomość',
        'IS_YOUR_FRIEND' => 'Jest Twoim przyjacielem',
        'IS_BLOCKED' => 'Jest zablokowany',
        'SORT_BY' => 'Sortuj według:',
        'CLOSE' => 'Zamknij',
        'USER_COUNT' => '(%d)',
        'NOBODY_HAS_ADDED_VIDEOS' => 'Nie dodano jeszcze żadnych plików wideo!  Dodaj kilka plików wideo, aby rozpocząć.',
        'SEARCH_PEOPLE' => 'Wyszukaj osoby:',
        'INVITE_YOUR_FRIENDS_TO' => 'Zaproś przyjaciół do %s.',
        'INVITE' => 'Zaproś',
        'INVITE_TAB_TEXT' => 'Zaproś',
        'YOU_HAVE_NOT_ADDED_FRIENDS' => 'Żadni przyjaciele nie zostali jeszcze przez Ciebie dodani do %s.',
        'SEARCH_FRIENDS' => 'Wyszukaj przyjaciół:',
        'ADD_YOUR_FIRST_VIDEO' => 'Dodaj swój pierwszy plik wideo',
        'USE_HTML_EMBED_CODE' => 'Użyj osadzonego kodu HTML',
        'UPLOAD_A_VIDEO_FROM' => 'Przekaż plik wideo ze swojego komputera. Akceptujemy wszystkie popularne formaty!',
        'WE_SUPPORT_MOV' => 'Obsługujemy formaty plików .mov, .mpg, .avi, .3gp i .wmv. Wielkość pliku nie może przekraczać 100 MB.',
        'NEED_HELP_HERE_ARE' => 'Potrzebujesz pomocy?  Instrukcje serwisów <a %s>YouTube</a> i <a %s>Google Video</a>.',
        'ADD_TITLE_AND_DESCRIPTION' => 'Dodaj tytuł i opis',
        'DESCRIPTION_COLON' => 'Opis:',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_1' => 'Dodawaj tytuły, opisy i inne informacje do przekazanych plików wideo.',
        'EVERYTHING_IS_OPTIONAL' => 'Każdy z parametrów jest opcjonalny;  jeśli nie chcesz niczego dodać, kliknij przycisk „Pomiń ten krok” po prawej stronie.',
        'EACH_VIDEO_MAY_BE_100MB' => 'Wielkość poszczególnych plików wideo nie może przekraczać 100 MB. Obsługujemy pliki wideo w formatach .mov, .mpg, .avi, .wmv i .3gp.',
        'I_HAVE_RIGHT_TO_UPLOAD_VIDEO' => 'Mam prawo przekazać ten plik wideo zgodnie z <a %s>Warunkami serwisu</a>.',
        'VIDEO_UPLOADER_REQUIRES_JAVA' => 'Masowe przekazywanie plików wideo wymaga najnowszej wersji oprogramowania Java. <strong><a %s>Kliknij tutaj, aby pobrać oprogramowanie Java</a></strong> lub <strong><a %s>wróć do prostego przekazywania</a></strong>.',
        'UPLOAD_A_VIDEO_FROM_YOUR_COMPUTER' => 'Przekaż plik wideo ze swojego komputera',
        'HAVE_LOT_OF_VIDEOS' => 'Masz dużo plików wideo, które chcesz udostępnić?',
        'TRY_BULK_VIDEO_UPLOADER' => 'Wypróbuj masowe przekazywanie plików wideo',
        'VIDEOS_SUCCESSFULLY_UPLOADED' => 'Twoje pliki wideo zostały pomyślnie przekazane.',
        'VIDEOS_UPLOADED_AWAITING' => 'Twoje pliki wideo zostały pomyślnie przekazane i oczekują na zatwierdzenie autora %s.',
        'ADD_VIDEOS_OR_PHOTOS_TO_APPNAME' => 'Dodawaj pliki wideo lub zdjęcia do %s bezpośrednio z telefonu, wysyłając je na unikalny adres e-mail.',
        'GRAB_HTML_EMBED' => 'Uzyskaj \'osadzony\' kod HTML z popularnej witryny wideo i dodaj plik wideo do tej sieci społecznej.',
        'GOOGLE' => 'Google',
        'YOUTUBE' => 'YouTube',
        'HAVING_PROBLEMS_WITH_VIDEO_UPLOADER' => 'Masz problemy z masowym przekazywaniem plików wideo?  <strong><a %s>Wróć do prostego przekazywania</a></strong>.',
        'ADD_VIDEOS_FROM_YOUTUBE' => 'Dodawaj pliki wideo z serwisu YouTube lub Google',
        'TAGS_NO_COLON' => 'Znaczniki',
        'NO_VIDEOS_TAGGED_X_CHECK' => 'Brak plików wideo oznaczonych „%1$s”. Sprawdź <a %2$s>dyskusje oznaczone „%1$s”</a>, <a %4$s>posty blogu oznaczone „%1$s”</a> lub <a %3$s>zdjęcia oznaczone „%1$s”</a>. Lub dodaj i oznacz własne pliki wideo!',
        'UPLOAD_VIDEOS_FROM' => 'Przekazuj pliki wideo ze swojego komputera',
        'YOUR_VIDEO_UPLOAD_TO_X_DID_NOT_COMPLETE_DUE_TO_A_CONVERSION_ERROR' => 'Przekazywanie Twojego pliku wideo na %s nie powiodło się z powodu błędu konwersji.',
        'FOR_FURTHER_ASSISTANCE_2' => 'Aby uzyskać dalszą pomoc, skontaktuj się z nami pod adresem:',
        'TO_HELP_TROUBLESHOOT_PROVIDE_THIS_VIDEO_ID_X' => 'Aby pomóc rozwiązać problem, podaj ten identyfikator pliku wideo: %s',
        'YOUR_VIDEO_WAS_SUCCESSFULLY_UPLOADED_TO_X' => 'Twój plik wideo został pomyślnie przekazany na %s.',
        'TO_VIEW_THE_VIDEO_VISIT' => 'Aby obejrzeć ten plik wideo, odwiedź:',
        'YOUR_VIDEO_X_ON_Y_HAS_A_NEW_COMMENT' => 'Na %2$s jest nowy komentarz dotyczący Twojego pliku wideo „%1$s”.',
        'YOUR_VIDEO_ON_X_HAS_A_NEW_COMMENT' => 'Jest nowy komentarz dotyczący Twojego pliku wideo na %s.',
        'ADD_VIDEOS_BY_PHONE_OR' => 'Dodawaj pliki wideo telefonicznie lub pocztą elektroniczną',
        'FEATURING_ELLIPSIS' => 'Zamieszczanie…',
        'NOW_FEATURED_ON_MAIN' => 'Zamieszczony na głównej',
        'DONT_FEATURE' => 'Nie zamieszczaj',
        'UNFEATURING_ELLIPSIS' => 'Trwa usuwanie z głównej...',
        'REMOVED_FROM_MAIN' => 'Usunięto z głównej',
        'ADDED_EXCLAMATION' => 'Dodano!',
        'ERROR' => 'Błąd',
        'ADDING_ELLIPSIS' => 'Trwa dodawanie...',
        'TRACK_COULD_NOT_BE_LOADED' => 'Nie można przekazać utworu',
        'INVALID_URL' => 'Nieprawidłowy adres URL',
        'NORMAL_PLAYBACK_ON' => 'Normalne odtwarzanie: włączone',
        'REPEAT_PLAYBACK_ON' => 'Ponowne odtwarzanie: włączone',
        'SHUFFLE_PLAYBACK_ON' => 'Odtwarzanie losowe: włączone',
        'OPEN_POPUP_WINDOW' => 'Wyświetl okno podręczne',
        'LOADING_PLAYLIST_ELLIPSIS' => 'Trwa ładowanie listy odtwarzania...',
        'EACH_PHOTO_MAY_BE_UP_TO_10MB' => 'Wielkość poszczególnych zdjęć nie może przekraczać 10 MB. Obsługujemy zdjęcia w formatach .jpg, .gif i .png.',
        'I_HAVE_RIGHT_TO_UPLOAD_PHOTOS' => 'Mam prawo przekazać te zdjęcia zgodnie z <a %s>Warunkami serwisu</a>.',
        'PHOTO_UPLOADER_REQUIRES_JAVA' => 'Masowe przekazywanie zdjęć wymaga najnowszej wersji oprogramowania Java. <strong><a %s>Kliknij tutaj, aby pobrać oprogramowanie Java</a></strong> lub <strong><a %s>wróć do prostego przekazywania</a></strong>.',
        'TRY_BULK_PHOTO_UPLOADER' => 'Wypróbuj masowe przekazywanie zdjęć',
        'HAVE_LOT_OF_PHOTOS' => 'Masz dużo zdjęć, które chcesz udostępnić?',
        'PHOTOS_SUCCESSFULLY_UPLOADED' => 'Twoje zdjęcia zostały pomyślnie przekazane.',
        'PHOTOS_UPLOADED_AWAITING' => 'Twoje zdjęcia zostały pomyślnie przekazane i oczekują na zatwierdzenie autora %s.',
        'FLICKR' => 'Flickr',
        'ADD_PHOTOS_FROM_FLICKR' => 'Dodaj zdjęcia z serwisu Flickr',
        'ADD_PHOTOS_OR_VIDEOS_TO_APPNAME' => 'Dodawaj zdjęcia lub pliki wideo do %s bezpośrednio z telefonu, wysyłając je na unikalny adres e-mail.',
        'HAVING_PROBLEMS_WITH_PHOTO_UPLOADER' => 'Masz problemy z masowym przekazywaniem zdjęć?  <strong><a %s>Wróć do prostego przekazywania</a></strong>.',
        'VIEW_SLIDESHOW' => 'Przeglądaj pokaz slajdów',
        'NO_PHOTOS_TAGGED_X_CHECK' => 'Brak zdjęć oznaczonych „%1$s”. Sprawdź <a %2$s>dyskusje oznaczone „%1$s”</a>, <a %4$s>posty blogu oznaczone „%1$s”</a> lub <a %3$s>pliki wideo oznaczone „%1$s”</a>. Lub dodaj i oznacz własne zdjęcia!',
        'UPLOAD_PHOTOS_FROM_YOUR_COMPUTER' => 'Przekazuj zdjęcia ze swojego komputera',
        'YOUR_PHOTO_X_HAS_A_NEW_COMMENT_ON_Y' => 'Na %2$s jest nowy komentarz dotyczący Twojego zdjęcia „%1$s”.',
        'YOUR_PHOTO_HAS_A_NEW_COMMENT_ON_X' => 'Jest nowy komentarz dotyczący Twojego zdjęcia na %s.',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Kliknij przycisk \'Edytuj\', aby umieścić tekst, HTML, wideo, zdjęcia lub <a %1$s>elementy widget innych firm</a> w tym polu.  To kolejny sposób, w jaki możesz nadać stronie %2$s bardziej indywidualny charakter.',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y_ELLIPSIS' => 'Nowe %1$s oczekuje na zatwierdzenie na %2$s...',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y' => 'Nowe %1$s oczekuje na zatwierdzenie na %2$s.',
        'YOU_HAVE_A_NEW_X_TITLE_TO_APPROVE_ON_Y' => 'Nowe %1$s „%2$s” oczekuje na zatwierdzenie na %3$s.',
        'TO_APPROVE_THIS_X_VISIT' => 'Aby zatwierdzić to %s, odwiedź:',
        'YOUR_X_ON_Y_HAS_BEEN_APPROVED_ELLIPSIS' => 'Twoje %1$s na %2$s zostało zatwierdzone...',
        'YOUR_TYPE_ON_X_HAS_A_NEW_COMMENT_ELLIPSIS' => 'Na %2$s jest nowy komentarz dotyczący Twojego %1$s...',
        'CLICK_HERE_TO_JOIN' => 'Aby się przyłączyć, kliknij tutaj:',
        'X_WANTS_YOU_TO_CHECK_OUT_Y_ON_Z' => '%1$s zachęca Cię do sprawdzenia „%2$s” na %3$s!',
        'YOUR_X_HAS_BEEN_APPROVED_ON_Y' => 'Twoje %s zostało zatwierdzone na %s.',
        'YOUR_X_Y_HAS_BEEN_APPROVED_ON_Z' => 'Twoje %1$s „%2$s” zostało zatwierdzone na %3$s.',
        'TO_VIEW_YOUR_X_VISIT' => 'Aby przeglądać swoje %s, odwiedź:',
        'TO_VIEW_THIS_X_VISIT' => 'Aby przeglądać te %s, odwiedź:',
        'TO_VIEW_IT_VISIT' => 'Aby je przejrzeć, odwiedź:',
        'X_REPORTED_THE_FOLLOWING_ISSUE_ON_Y_ELLIPSIS' => '%1$s zgłosił następujący problem dotyczący %2$s...',
        'USER_HAS_SENT_YOU_A_MESSAGE_ON_X' => '%1$s wysłał do Ciebie wiadomość dotyczącą %2$s.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X' => '%1$s zgłosił chęć przyłączenia się do %2$s na %3$s.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X_ELLIPSIS' => 'Użytkownik %1$s zażądał uczestnictwa w grupie %2$s na %3$s',
        'TO_APPROVE_OR_DENY_USER_REQUEST' => 'Aby zatwierdzić lub odrzucić prośbę %, odwiedź:',
        'X_ADDED_A_COMMENT_TO_THE_BLOG_POST_Y_ON_Z' => '%1$s dodał komentarz do postu blogu „%2$s” na %3$s.',
        'X_ADDED_A_COMMENT_TO_A_BLOG_POST_ON_Y_ELLIPSIS' => '%1$s dodał komentarz do postu blogu na %2$s...',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X' => 'Nowy uczestnik oczekuje na zatwierdzenie na %s.',
        'WELCOME_TO_THE_GROUP_X_ON_Y' => 'Witamy w grupie „%1$s” na %2$s',
        'COME_JOIN_ME_ON_X' => 'Przyłącz się do %s!',
        'PLEASE_SELECT_A_MEMBER' => 'Wybierz co najmniej jednego członka',
        'LOADING_YOUR_FRIENDS' => 'Trwa przekazywanie Twoich przyjaciół...',
        'YOUR_MESSAGE_HAS_BEEN_SENT_TITLE_CASE' => 'Twoja wiadomość została wysłana',
        'TO_SEND_ANOTHER_MESSAGE' => 'Aby wysłać kolejną wiadomość, wpisz poniżej jej treść.',
        'PLEASE_CHOOSE_FRIENDS' => 'Wybierz przyjaciół, zanim wyślesz swoją wiadomość.',
        'RESEND_INVITATION' => 'Ponownie wyślij zaproszenie',
        'CHOOSE_FRIENDS' => 'Wybierz przyjaciół...',
        'ALL_FRIENDS' => 'Wszyscy przyjaciele',
        'ALL_FRIENDS_ON_APPNAME' => 'Wszyscy przyjaciele na %s',
        'SHARE_WITH_FRIENDS' => 'Udostępnij przyjaciołom',
        'SHARE_THIS_WITH_FRIENDS' => 'Udostępnij tę pozycję swoim przyjaciołom',
        'COMPOSE_MESSAGE' => 'Ułóż wiadomość',
        'INVITATION_LINK_ONLY_VISIBLE' => 'To łącze zaproszenia jest widoczne tylko dla autora i administratorów sieci. Członkowie, którzy przyłączą się za pomocą tego łącza, automatycznie zostaną przyjaciółmi autora sieci.',
        'WE_ARE_LOADING_ADDRESSES' => 'Trwa przekazywanie Twoich adresów...',
        'SELECT_ALL_NONE' => 'Zaznacz wszystko/ nic',
        'INVITE_TO_APPNAME' => 'Zaproś do \'%s\'',
        'INVITE_YOUR_FRIENDS_TO_APPNAME' => 'Zaproś swoich przyjaciół do \'%s\'',
        'ALREADY_MEMBER_OF_NETWORK' => '(Jest już członkiem tej sieci)',
        'OR_SHARE_THIS_INVITATION_LINK' => 'Lub udostępnij to łącze zaproszenia:',
        'CLICK_TO_MAIL' => '<a %s>Kliknij tutaj, aby wysłać wiadomość</a>.',
        'MESSAGE_HAS_BEEN_SENT' => 'Twoja wiadomość została wysłana',
        'YOU_CAN_SHARE_THIS' => 'Możesz udostępnić większej liczbie osób poniżej lub <a %s>wrócić do poprzedniej strony</a>.',
        'VCARD_IMPORT_UNAVAILABLE' => 'Przepraszamy, ale usługa importowania kart vCard jest obecnie niedostępna.',
        'CSV_IMPORT_UNAVAILABLE' => 'Przepraszamy, ale usługa importowania plików CSV jest obecnie niedostępna.',
        'ERROR_OCCURRED' => 'Przepraszamy, ale wystąpił błąd.',
        'IMPORT_FAILED' => 'Przepraszamy, ale importowanie nie powiodło się.',
        'LOGIN_FAILED' => 'Przepraszamy, ale logowanie nie powiodło się.',
        'UNABLE_TO_FIND_EMAIL' => 'Przepraszamy, ale nie możemy znaleźć pola e-mail.',
        'CANNOT_READ_VCARDS' => 'Przepraszamy, ale nie potrafimy odczytać tych kart vCard.',
        'SORRY_WE_DO_NOT_SUPPORT' => 'Przepraszamy, ale nie obsługujemy internetowej książki adresowej dla Twojego adresu e-mail. Kliknij \'Książka adresowa programu pocztowego\' poniżej, aby użyć adresów ze swojego komputera.',
        'NO_ADDRESSES_FOUND' => 'Nie znaleziono adresu',
        'WE_DID_NOT_FIND_ADDRESSES' => 'Nie znaleźliśmy żadnych adresów w zaimportowanej książce adresowej.',
        'WANT_TO_INVITE_MORE_FRIENDS' => 'Chcesz zaprosić więcej przyjaciół? Importuj informacje kontaktowe z internetowej książki adresowej lub programu pocztowego.',
        'IMPORT_FROM_WEB_ADDRESS_BOOK' => 'Importuj z internetowej książki adresowej',
        'IMPORT_FROM_ADDRESS_BOOK_APPLICATION' => 'Importuj z książki adresowej programu pocztowego',
        'MICROSOFT_OUTLOOK_APPLE_ADDRESS_BOOK' => 'Microsoft Outlook, Apple Address Book, .CSV itp.',
        'SET_NEW_PASSWORD' => 'Utwórz nowe hasło dla swojego konta Ning.',
        'PRIVACY_POLICY' => 'Polityka prywatności',
        'APPLY_FOR_MEMBERSHIP_SIGN_IN' => 'Zapisz się już dziś. Już jesteś członkiem? <a %s>Kliknij tutaj, aby zarejestrować się w</a>.',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK_ON_Y' => '%1$s przedstawił następującą opinię na temat %2$s:',
        'TRACK_STATISTICS' => 'Śledź statystykę',
        'FEATURED_MEMBERS' => 'Zamieszczeni członkowie',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS_IF_YOU_THINK' => 'Przepraszamy, %s, nie masz dostępu do %s, ponieważ zostałeś zablokowany.  Jeśli myślisz, że zostałeś zablokowany przez pomyłkę, skontaktuj się z administratorem.',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS' => 'Przepraszamy, %s, nie masz dostępu do %s, ponieważ zostałeś zablokowany.',
        'CHECK_OUT_X_ON_Y_ELLIPSIS' => 'Sprawdź „%1$s” na %2$s...',
        'CHECK_OUT_THIS_X_ON_Y_ELLIPSIS' => 'Sprawdź %1$s na %2$s...',
        'SORRY_NO_MEMBERS_MATCHING_X_WERE_FOUND' => 'Przepraszamy, ale nie znaleziono członków pasujących do „%s”.',
        'WHO_CAN_COMMENT_ON_POST' => 'Kto może komentować ten artykuł?',
        'SEND_MESSAGE_TO_FRIENDS' => 'Wyślij wiadomość do przyjaciół',
        'PREVIOUS_POST' => '← Poprzedni artykuł',
        'NEXT_POST' => 'Następny artykuł →',
        'PREVIOUS_POSTS' => '←  Poprzednie artykuły',
        'NEXT_POSTS' => 'Następne artykuły →',
        'NO_BLOG_POSTS_TAGGED_X_CHECK' => 'Brak postów blogu oznaczonych „%1$s”. Sprawdź <a %2$s>dyskusje oznaczone „%1$s”</a>, <a %4$s>zdjęcia oznaczone „%1$s”</a> lub <a %3$s>pliki wideo oznaczone „%1$s”</a>. Lub dodaj i oznacz własne posty blogu!',
        'ALL_POSTS_TAGGED_X_FOR_M_Y' => 'Wszystkie artykuły oznaczone <em>\'%s\'</em> dla %s %s',
        'ALL_POSTS_TAGGED_X' => 'Wszystkie artykuły oznaczone <em>\'%s\'</em>',
        'MY_BLOG_POSTS_FOR_M_Y' => 'Posty mojego blogu dla %s %s',
        'MY_BLOG_POSTS' => 'Posty mojego blogu',
        'PICK_VALID_ALL_FRIENDS_NOTIFICATION' => 'Dokonaj odpowiedniego wyboru powiadomień o wiadomościach wysłanych do wszystkich przyjaciół',
        'PRIVACY_CONTENT_CONTROL' => 'Kontrola prywatności i zawartości',
        'ENABLE_MUSIC_DOWNLOAD_LINKS' => 'Aktywuj łącza pobierania odtwarzacza muzyki',
        'WELCOME_MEMBER_N_OF_APPNAME_INVITE' => 'Witamy %1$s! Jesteś członkiem #%2$s z %3$s. <a %4$s>Zaproś przyjaciół</a>.',
        'YOU_COMMENTED_ON_PHOTO_TITLE' => 'Skomentowałeś zdjęcie <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_PHOTO_TITLE' => '%s skomentował zdjęcie <a %s>%s</a>',
        'YOU_COMMENTED_ON_VIDEO_TITLE' => 'Skomentowałeś plik wideo <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_VIDEO_TITLE' => '%s skomentował plik wideo <a %s>%s</a>',
        'NOTIFY_BLOG_PING_SERVICES' => 'Czy chcesz powiadamiać usługi śledzenia blogu innej firmy, kiedy dodasz nowy artykuł?',
        'YES_NOTIFY_BLOG_SERVICES' => 'Tak -- Powiadamiaj <a %s>usługi aktualizacji strony</a>, kiedy dodam nowy post blogu',
        'THERE_ARE_NO_FEATURED_MEMBERS' => 'Nie zamieszczono żadnych członków w Twojej sieci społecznej.',
        'START_FEATURING_MEMBERS_CLICK_Y' => 'Rozpocznij zamieszczanie członków w miejscu, gdzie znajduje się funkcja Zamieść. Aby dowiedzieć się więcej o zamieszczeniu, <a %s>kliknij tutaj</a>.',
        'THIS_IS_YOUR_PAGE' => 'To jest Twoja strona:',
        'MESSAGES_SENT_TO_ALL_FRIENDS' => 'Wiadomości wysłane do wszystkich przyjaciół',
        'TO_STOP_FOLLOWING_THIS_X_GO_TO' => 'Aby zatrzymać śledzenie tego %s, idź do:',
        'SHOW_ALL' => 'Pokaż wszystko',
        'CHOOSE_GADGETS' => 'Wybierz jeden z tych wspaniałych gadżetów OpenSocial, aby dodać do profilu swojej strony! Tutaj możesz <a %s>przeglądać i oceniać gadżety </a>, a tutaj <a %s>dowiedzieć się więcej o OpenSocial </a>.',
        'GADGETS_UNAVAILABLE' => 'Gadżety są chwilowo niedostępne',
        'APOLOGIES_GADGETS_UNAVAILABLE' => 'Przepraszamy – gadżety są chwilowo niedostępne.',
        'BOX_WILL_NOT_SHOW_GADGET' => 'To pole nie pojawia się w przypadku innych osób, jeśli nie wybrałeś gadżetu.',
        'CLICK_EDIT_TO_SPECIFY_GADGET_OR_VISIT_GADGET_GALLERY' => 'Kliknij przycisk Edytuj, aby określić adres URL gadżetu dla tego pola lub odwiedź <a %s>Katalog gadżetów</a>.',
        'PROBLEM_OCCURRED_RETRIEVING_GADGET' => 'Wystąpił problem pobierania tego źródła adresu URL gadżetu.',
        'ADD_GADGET_TO_YOUR_PAGE' => 'Dodaj ten gadżet do swojego profilu',
        'GADGETS_BETA' => 'Gadżety (Beta)',
        'TRY_OUT_OPENSOCIAL_GADGETS_WARNING_EXPERIMENTAL' => 'Wypróbuj gadżety OpenSocial. Ostrzeżenie: ta funkcja jest eksperymentalna.',
        'ADD_TO_MY_PAGE' => 'Dodaj do Mojej strony',
        'GADGETS' => 'Gadżety',
        'GADGETS_TAB_TEXT' => 'Gadżety',
        'GADGET' => 'Gadżet',
        'GADGETS_IS_IN_BETA' => 'Gadżety znajdują się w katalogu Beta.',
        'SORRY_GADGET_UNAVAILABLE' => 'Przepraszamy, ale ten gadżet jest niedostępny. Sprawdź, czy masz prawidłowy adres URL. Jeśli nadal masz kłopoty, <a %s>daj nam znać</a>.',
        'VIEW_ALL_N_CATEGORIES' => 'Przeglądaj wszystkie %s kategorie',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_ADD' => 'Brak dyskusji oznaczonych „%1$s”. Sprawdź <a %2$s>zdjęcia oznaczone „%1$s”</a>, <a %4$s>posty blogu oznaczone „%1$s”</a> lub <a %3$s>pliki wideo oznaczone „%1$s”</a>. Lub dodaj i oznacz własne dyskusje!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK' => 'Brak dyskusji oznaczonych „%1$s”. Sprawdź <a %2$s>zdjęcia oznaczone „%1$s”</a>, <a %4$s>posty blogu oznaczone „%1$s”</a> lub <a %3$s>pliki wideo oznaczone „%1$s”</a>.',
        'ALREADY_MEMBER_OF_GROUP' => '(Jest już uczestnikiem tej grupy)',
        'INVITE_YOUR_FRIENDS_TO_GROUPNAME' => 'Zaproś swoich przyjaciół do \'%s\'',
        'COME_JOIN_ME_ON_X_ON_Y' => 'Przyłącz się do mnie w %1$s w %2$s.',
        'COME_JOIN_ME_ON_X_ON_Y_ELLIPSIS' => 'Przyłącz się do mnie w %1$s w %2$s...',
        'INVITE_TO_GROUP' => 'Zaproś do \'%s\'',
        'YOU_CAN_ADD_100_SONGS' => 'Możesz dodać w sumie 100 utworów, a każdy może być wielkości do 20 MB. Obsługujemy utwory w formacie .mp3.',
        'I_HAVE_RIGHT_TO_UPLOAD_SONGS' => 'Mam prawo przekazać te utwory zgodnie z <a %s">Warunkami serwisu</a>.',
        'MUSIC_UPLOADER_REQUIRES_JAVA' => 'Masowe przekazywanie muzyki wymaga najnowszej wersji oprogramowania Java. <strong><a %s>Kliknij tutaj, aby pobrać oprogramowanie Java</a></strong> lub <strong><a %s>wróć do prostego przekazywania</a></strong>.',
        'HAVE_LOT_OF_MUSIC' => 'Masz dużo muzyki, którą chcesz udostępnić?',
        'TRY_BULK_MUSIC_UPLOADER' => 'Wypróbuj masowe przekazywanie muzyki',
        'SONGS_SUCCESSFULLY_UPLOADED' => 'Twoje utwory zostały pomyślnie przekazane.',
        'SORRY_YOU_CAN_ONLY_HAVE_N_TRACKS' => 'Przepraszamy, ale można mieć tylko %s utworów na liście odtwarzania. Usuń część utworów, zanim dodasz kolejne.',
        'ADD_MUSIC_FROM_WEBSITE' => 'Dodaj muzykę z innej strony internetowej',
        'HAVING_PROBLEMS_WITH_MUSIC_UPLOADER' => 'Masz problemy z przekazywaniem muzyki?  <strong><a %s>Wróć do prostego przekazywania</a></strong>.',
        'UPLOAD_MUSIC_FROM_YOUR_COMPUTER' => 'Przekazuj muzykę ze swojego komputera',
        'ADD_MUSIC' => 'Dodaj muzykę',
        'FACEBOOK_INSTR_SETUP_APP_PERMISSION' => 'Kliknij <strong>Użytkownicy</strong> i <strong>Wszystkie strony</strong>.',
        'SKIP_THIS_STEP' => 'Pomiń ten krok',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_2' => 'Dodaj tytuł, opis i inne informacje do tego pliku wideo.',
        'CANCEL_AND_RETURN_TO_VIDEO' => 'Anuluj i powróć do pliku wideo',
        'TITLE' => 'Tytuł:',
        'TAGS_ARE_SHORT_DESCRIPTIONS' => 'Znaczniki są krótkimi opisami pomocnymi przy wyszukiwaniu plików wideo użytkownika.  Oddziel znaczniki przecinkami lub umieść znaczniki wielowyrazowe w cudzysłowie, np. „San Francisco”.',
        'WHO_CAN_VIEW_VIDEO' => 'Kto może oglądać ten plik wideo?',
        'MOST_POPULAR' => 'Najpopularniejsze',
        'HIGHEST_RATED' => 'Najwyżej oceniane',
        'MOST_RECENT' => 'Najnowsze',
        'MOST_FAVORITED' => 'Najbardziej ulubione',
        'MOST_POPULAR_VIDEOS' => 'Najpopularniejsze pliki wideo',
        'HIGHEST_RATED_VIDEOS' => 'Najwyżej oceniane pliki wideo',
        'MOST_RECENT_VIDEOS' => 'Najnowsze pliki wideo',
        'MOST_FAVORITED_VIDEOS' => 'Najbardziej ulubione pliki wideo',
        'ANYONE' => 'Wszyscy',
        'JUST_MY_FRIENDS' => 'Tylko moi przyjaciele',
        'JUST_ME' => 'Tylko ja',
        'VIEWABLE_BY_FRIENDS' => 'Do oglądania przez <strong>przyjaciół</strong>',
        'PRIVATE_VIDEO' => '<strong>Prywatny</strong> plik wideo',
        'VIEWABLE_BY_EVERYONE' => 'Do oglądania przez <strong>wszystkich</strong>',
        'LOCATION' => 'Lokalizacja:',
        'NO_LOCATION' => 'Bez lokalizacji',
        'CLICK_ON_LOCATION' => 'Kliknij lokalizację na mapie:',
        'FIND_AN_ADDRESS' => 'Znajdź adres:',
        'LOCATE' => 'Zlokalizuj',
        'YOU_CAN_ADD_YOUR_OWN_VIDEO' => 'Możesz <a %s>dodać swoje pliki wideo</a> do %s!',
        'ADD_PLAYER_LOGO_OR_WATERMARK' => 'Dodaj obrazek logo lub znaku wodnego do swojego sieciowego odtwarzacza wideo.  <a %s>Ustaw teraz! </a>',
        'APPROVE' => 'Zatwierdź',
        'DELETE' => 'Usuń',
        'APPLY_TO_VIDEOS_ADDED_BY' => 'Zastosuj do wszystkich plików wideo dodanych przez użytkownika %s',
        'NO_TITLE' => 'Bez tytułu',
        'ADDED_BY_STRONG_X' => 'Dodane przez użytkownika <strong>%s</strong>',
        'NO_DESCRIPTION' => 'Bez opisu',
        'BY_X' => 'dokonanego przez użytkownika %s',
        'YOU_HAVE_FINISHED_MODERATING' => 'Nie pełnisz już funkcji moderatora',
        'NO_VIDEOS_AWAITING_APPROVAL' => 'Nie ma obecnie plików wideo oczekujących na zatwierdzenie.  Jeśli się nudzisz, może obejrzysz <a %s>najnowsze pliki wideo </a>?',
        'NO_ONE_HAS_ADDED_ANY_VIDEOS' => 'Nikt nie dodał plików wideo do Twojej sieci społecznej.  Bądź pierwszą osobą, która dodała plik wideo!',
        'ADDED_ON_DATE_BY_X' => 'Dodane %s przez użytkownika %s.',
        'REMOVE_FROM_FAVORITES' => 'Usuń z Ulubionych',
        'REMOVE_VIDEO_FROM_FAVORITES' => 'Czy usunąć ten plik wideo z Ulubionych?',
        'COLLECTED_BY_X' => 'Zebrane prze użytkownika %s',
        'ADD_FAVORITES' => 'Dodaj Ulubione',
        'YOU_CAN_MARK_VIDEO' => 'Możesz oznaczyć dowolne pliki wideo jako ulubione.  Wystarczy kliknąć ikonę „Dodaj do Ulubionych”, kiedy pojawi się na pliku wideo.',
        'VIEW_RECENT_VIDEOS' => 'Przeglądaj najnowsze pliki wideo',
        'X_HAS_NOT_ADDED_FAVORITES' => 'Użytkownik %s nie dodał jeszcze niczego do ulubionych.',
        'APPROVE_VIDEOS' => 'Zatwierdź pliki wideo',
        'YOUR_SITE_REQUIRES_YOU' => 'Chcesz, aby Twoje zdjęcia i pliki wideo w sieci społecznej były moderowane przed ich publikacją.  Aby zmienić to ustawienie <a %s>kliknij tutaj, aby przejść do strony Prywatność </a> i wyłączyć opcję \'Zatwierdzaj nowe zdjęcia i pliki wideo\'.',
        'YOUR_SITE_ALLOWS_USERS' => 'Nie chcesz, aby Twoje zdjęcia i pliki wideo w sieci społecznej były moderowane przed ich publikacją.  Aby zmienić to ustawienie <a %s>kliknij tutaj, aby przejść do strony Prywatność </a> i włączyć opcję \'Zatwierdzaj nowe zdjęcia i pliki wideo\'.',
        'APPROVE_ALL_VIDEOS' => 'Czy zatwierdzić wszystkie pliki wideo?',
        'ARE_YOU_SURE_APPROVE_ALL_VIDEOS' => 'Czy na pewno chcesz zatwierdzić wszystkie pliki wideo?  Może to potrwać kilka minut.',
        'APPROVING' => 'Zatwierdzanie…',
        'APPROVE_ALL' => 'Zatwierdź wszystkie',
        'DELETE_ALL_VIDEOS' => 'Czy usunąć wszystkie pliki wideo?',
        'ARE_YOU_SURE_DELETE_ALL_VIDEOS' => 'Czy na pewno chcesz usunąć wszystkie niezatwierdzone pliki wideo?  Może to potrwać kilka minut.',
        'DELETING' => 'Usuwanie…',
        'DELETE_ALL' => 'Usuń wszystkie',
        'XS_VIDEOS' => 'Pliki wideo użytkownika %s',
        'DELETE_ALL_XS_VIDEOS_Q' => 'Czy usunąć wszystkie pliki wideo użytkownika %s?',
        'DELETE_ALL_XS_VIDEOS' => 'Usuń wszystkie pliki wideo użytkownika %s',
        'ARE_YOU_SURE_DELETE_ALL_XS_VIDEOS' => 'Czy na pewno chcesz usunąć wszystkie pliki wideo użytkownika %s?  Proces może potrwać kilka minut.',
        'DELETE_THIS_VIDEO_Q' => 'Czy usunąć ten plik wideo?',
        'ARE_YOU_SURE_DELETE_THIS_VIDEO' => 'Czy na pewno chcesz usunąć ten plik wideo?  Proces może potrwać kilka minut.',
        'YOU_HAVE_NOT_ADDED_VIDEOS_2' => 'Nie zostały jeszcze dodane żadne Twoje pliki wideo.  Dodaj pliki wideo, aby rozpocząć!',
        'X_HAS_NOT_ADDED_VIDEOS' => 'Użytkownik %s nie dodał jeszcze żadnego pliku wideo.',
        'YOUR_FRIENDS_DO_NOT_HAVE_VIDEOS' => 'Twoi przyjaciele nie dodali jeszcze żadnych plików wideo.',
        'ALL_VIDEOS_TAGGED_X' => 'Wszystkie pliki wideo oznaczone \'%s\'',
        'ALL_VIDEOS_TAGGED_X_2' => 'Wszystkie pliki wideo oznaczone <em>\'%s\'</em>',
        'NO_VIDEOS_TAGGED_X_CHECK_OUT' => 'Nie ma plików wideo oznaczonych „%1$s”.  Sprawdź <a %2$s> dyskusje oznaczone „%1$s”</a> lub <a %3$s>zdjęcia oznaczone „%1$s”</a>.  Możesz także dodawać i oznaczać własne pliki wideo!',
        'FILES_MUST_BE_100MB' => 'Plik nie może być większy niż 100 MB.  Zapewniamy obsługę formatów plików . mov, . mpg, . avi, . 3gp i . wmv.',
        'NEED_HELP' => 'Potrzebujesz pomocy?',
        'HERE_ARE_INSTRUCTIONS' => 'Instrukcje serwisów <a %s>YouTube</a> i <a %s>Google Video</a>.',
        'PERSON_IN_CHARGE' => 'Osoba odpowiedzialna za %s chce obejrzeć Twój dorobek przed pokazaniem go innym osobom.',
        'LEAVE_WINDOW_OPEN' => 'Nie zamykaj tego okna do zakończenia procesu przekazywania.',
        'KEEP_PAGE_OPEN' => 'Nie zamykaj tej strony, aby umożliwić nam dokończenie przekazywania pliku wideo. Powiadomimy Cię o jego zatwierdzeniu!',
        'MEANWHILE_FEEL_FREE' => 'Tymczasem możesz <a %s>otworzyć nowe okno przeglądarki </a> i dalej korzystać z %s.  Po zakończeniu przekazywania możesz w tym oknie dodać tytuł i opis do swojego pliku wideo.',
        'VIDEO_IS_WAITING_FOR_APPROVAL' => 'Ten plik wideo <strong>oczekuje na zatwierdzenie</strong> przez autora %s.',
        'LOADING' => 'Trwa ładowanie…',
        'EDIT_VIDEO' => 'Edytuj plik wideo',
        'DELETE_VIDEO' => 'Usuń plik wideo',
        'YOU_NEED_TO_BE_MEMBER' => 'Aby dodawać komentarze, musisz być uczestnikiem sieci %s!',
        'SIGN_UP_OR_SIGN_IN' => '<a %s>Przyłącz się do tej sieci </a>',
        'ADD_A_COMMENT' => 'Dodaj komentarz',
        'LEAVE_A_COMMENT_FOR_USERNAME' => 'Pozostaw komentarz dla użytkownika %s',
        'MORE' => 'Więcej',
        'PREVIOUS' => 'Wstecz',
        'NEXT' => 'Dalej',
        'ABOUT_THIS_VIDEO' => 'Plik wideo - informacje',
        'ABOUT_YOUR_VIDEO' => 'Plik wideo - informacje',
        'ADDED_ON_DATE_BY' => 'Dodano <strong>%s</strong> przez:',
        'VIEWS' => 'Widoki:',
        'COMMENTS' => 'Komentarze',
        'COMMENTS_COLON' => 'Komentarze:',
        'LOCATION_OF_VIDEO' => 'Lokalizacja pliku wideo:',
        'RELATED_VIDEOS' => 'Powiązane pliki wideo',
        'ALL_VIDEOS_TAGGED_X_X' => 'Wszystkie pliki wideo oznaczone %s (%s)',
        'XS_VIDEOS_X' => 'Pliki wideo użytkownika %s (%s)',
        'XS_FAVORITES_X' => 'Ulubione użytkownika %s (%s)',
        'VIDEO_DETAILS' => 'Szczegóły pliku wideo',
        'NEITHER_FILE_NOR_EMBED_CODE' => 'Nie określono żadnego pliku ani kodu osadzonego.',
        'VIDEO_UPLOADED_ON_X' => 'Plik wideo przekazany na %s',
        'PROBLEM_OCCURRED_CONVERTING_VIDEO' => 'Wystąpił problem podczas konwersji pliku wideo na format Flash: %s',
        'STATUS_N' => 'Stan %s',
        'YOUR_VIDEO_TITLED_X_COULD_NOT' => 'Twój plik wideo pod tytułem „%s” nie mógł zostać dodany do %s.',
        'YOUR_VIDEO_COULD_NOT_BE_ADDED' => 'Twój plik wideo nie mógł zostać dodany do %s.',
        'YOU_JUST_TRIED_TO_SEND_VIDEO' => 'Dokonano już próby przesłania do %s.  Niestety, nie jesteś uczestnikiem %s i nie możemy dostarczyć tego pliku wideo.',
        'VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'Przekazywanie Twojego pliku wideo na %s nie powiodło się',
        'YOUR_VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'Przekazanie Twojego pliku nie zakończyło się na %s.',
        'YOUR_VIDEO_ENCOUNTERED_A_PROBLEM' => 'Wystąpił problem z Twoim plikiem podczas jego przekazywania na %s.',
        'THE_PROBLEM_WAS_X' => 'Problem: %s',
        'ID' => 'Identyfikator:',
        'VIDEO_TRANSCODING_FAILED_FOR_X' => 'Transkodowanie wideo dla pliku wideo %s w %s nie powiodło się.',
        'X_UPLOADED_A_VIDEO_THAT_FAILED' => 'Użytkownik %s przekazał plik wideo, którego transkodowanie nie powiodło się.',
        'ERROR_MESSAGE' => 'Komunikat o błędzie:',
        'APPLICATION_NAME' => 'Nazwa aplikacji:',
        'APPLICATION_ID' => 'Identyfikator aplikacji:',
        'VIDEO_ID' => 'Identyfikator pliku wideo:',
        'VIDEO_UPLOAD_COMPLETE_ON_X' => 'Przekazywanie Twojego pliku wideo na %s powiodło się',
        'YOUR_VIDEO_UPLOAD_COMPLETE_ON_X' => 'Zakończono przekazywanie Twojego pliku wideo na %s',
        'YOUR_VIDEO_WAS_UPLOADED' => 'Twój plik wideo został pomyślnie przekazany na %s!',
        'THAT_VIDEO_IS_AWAITING_APPROVAL' => 'Plik wideo oczekuje na zatwierdzenie.',
        'THIS_VIDEO_IS_BEING_PROCESSED' => 'Plik wideo jest wciąż przetwarzany.',
        'ADD_VIDEO' => 'Dodaj plik wideo',
        'VIDEO_BY_X' => 'Plik wideo utworzony przez %s',
        'THERE_IS_NEW_COMMENT_ON_VIDEO_X' => 'Na %s znajduje się nowy komentarz dotyczący Twojego pliku wideo „%s”.',
        'THERE_IS_NEW_COMMENT_ON_VIDEO' => 'Na %s znajduje się nowy komentarz dotyczący Twoich plików wideo.',
        'SOMEBODY_COMMENTED_VIDEO_ADDED_TO_X' => 'Ktoś skomentował plik wideo dodany przez Ciebie do %s.',
        'SOMEBODY_UPLOADED_VIDEO_TO_X' => 'Ktoś przekazał plik wideo do %s.',
        'MORE_WAYS_TO_ADD_VIDEOS' => 'Inne sposoby dodawania plików wideo…',
        'FROM_YOUTUBE_OR_GOOGLE' => '… z serwisów YouTube lub Google',
        'GRAB_THE_HTML_EMBED_CODE' => 'Uzyskaj \'osadzony\' kod HTML z popularnej witryny wideo i dodaj plik wideo do tej sieci społecznej.',
        'ADD_A_VIDEO_FROM_YOUTUBE' => 'Dodaj plik wideo z serwisu YouTube lub Google',
        'PASTE_IN_EMBED' => 'Wklej \'osadzony\' kod tego pliku wideo tutaj:',
        'ADD_VIDEOS_BY_PHONE_OR_EMAIL' => 'Dodaj plik wideo telefonicznie lub pocztą elektroniczną',
        'VIDEO' => 'plik wideo',
        'THERE_ARE_NO_VIDEOS_THAT_MATCH' => 'Brak plików wideo pasujących do ustawień wybranych przez użytkownika.',
        'CLICK_EDIT_AND_CHANGE_SETTINGS' => 'Kliknij polecenie \'Edytuj\' i zmień ustawienia, jeśli chcesz, aby to okno było widoczne dla innych osób.',
        'PLAY_AGAIN' => 'Odtwórz ponownie',
        'SHARE' => 'Udostępnij',
        'EMBED' => 'Osadź',
        'REWIND' => 'Cofnij',
        'CHANGE_SIZE' => 'Zmień rozmiar',
        'FULLSCREEN' => 'Pełny ekran',
        'EXIT_FULLSCREEN' => 'Zamknij Pełny ekran',
        'HIDE' => 'Zamknij',
        'COPY_AND_PASTE_LINK' => 'Skopiuj i wklej to łącze do wiadomości e-mail lub wiadomości komunikatora:',
        'FIND_MORE_VIDEOS_LIKE_THIS' => 'Znajdź więcej podobnych plików wideo na <em>%s</em>',
        'SEE_VIDEO_ON_NETWORK' => 'Obejrzyj ten plik wideo na %s',
        'GET_EMBED_CODE' => 'Uzyskaj osadzony kod',
        'MORE_PHOTOS' => 'Więcej zdjęć',
        'THIS_ALBUM' => 'Ten album',
        'NETWORK_DOES_NOT_HAVE_PHOTOS' => 'W tej sieci nie ma jeszcze żadnych zdjęć.',
        'PERSON_DOES_NOT_HAVE_PHOTOS' => 'Ta osoba nie posiada jeszcze żadnych zdjęć.',
        'ALBUM_DOES_NOT_HAVE_PHOTOS' => 'Ten album nie zawiera jeszcze żadnych zdjęć.',
        'FIND_MORE_PHOTOS_LIKE_THIS' => 'Znajdź więcej podobnych zdjęć na <em>%s</em>',
        'NO_PHOTOS_AVAILABLE' => 'W tym albumie nie ma obecnie żadnych dostępnych zdjęć.  <a %s>Kliknij tutaj, aby obejrzeć wszystkie albumy</a>.',
        'ALBUM_PHOTOS_NOT_VISIBLE_TO_OTHERS' => 'Ten album nie jest widoczny dla innych osób w sieci, ponieważ jego zdjęcia są widoczne tylko dla Ciebie lub muszą być jeszcze zatwierdzone.',
        'CUSTOMIZE_YOUR_SLIDESHOW_PLAYER' => 'Dostosuj swój odtwarzacz do pokazu slajdów!',
        'ADD_SLIDESHOW_LOGO' => 'Dodaj logo do pokazu slajdów w swojej sieci społecznej.  <a %s>Ustaw teraz! </a>',
        'PHOTO_BY_X' => 'Zdjęcie wykonane przez %s',
        'UPLOAD_PHOTOS' => 'Przekaż zdjęcia',
        'PLAYER_COLOR' => 'Kolor odtwarzacza',
        'SLIDESHOW_PLAYER' => 'odtwarzacz pokazu slajdów',
        'SLIDESHOW' => 'pokaz slajdów',
        'FILTER' => 'Filtr',
        'SAVE_ALBUM' => 'Zapisz album',
        'APPLY_THIS_INFO_TO_PHOTOS' => 'Zastosuj informację do następujących zdjęć',
        'CLICK_TO_ADD_A_DESCRIPTION' => 'kliknij, aby dodać opis',
        'CHECK' => 'Sprawdź',
        'YOU_NEED_TO_BE_X' => 'Musisz być %s, aby to zrobić.',
        'ALL_PHOTOS' => 'Wszystkie zdjęcia',
        'POPULAR_PHOTOS' => 'Popularne zdjęcia',
        'FEATURED_PHOTOS' => 'Zamieszczone zdjęcia',
        'PHOTOS_HOME' => 'Domowe zdjęcia',
        'ALL_ALBUMS' => 'Wszystkie albumy',
        'MY_PHOTOS' => 'Moje zdjęcia',
        'MY_ALBUMS' => 'Moje albumy',
        'ADD_PHOTOS' => 'Dodaj zdjęcia',
        'ADD_PHOTOS_SENTENCE_CASE' => 'Dodaj zdjęcia',
        'EDIT' => 'Edytuj',
        'CHOOSE_PHOTOS' => 'Wybierz zdjęcia',
        'ADD_PHOTOS_BY_DRAGGING' => '<strong>Dodaj zdjęcia, przeciągając je</strong> do albumu po prawej stronie.  Usuń je, przeciągając je z powrotem.',
        'TITLE_YOUR_ALBUM' => '<strong>Zatytułuj album. </strong> Dodaj okładkę i opis.',
        'SAVE_YOUR_ALBUM' => 'Zapisz album!',
        'CHOOSE_FROM' => 'Wybierz z:',
        'EVERYONES_PHOTOS' => 'Wspólne zdjęcia',
        'TAGGED' => 'Oznaczone:',
        'OLDER_PHOTOS' => 'Starsze zdjęcia',
        'MORE_RECENT_PHOTOS' => 'Najnowsze zdjęcia',
        'YOUR_ALBUM' => 'Twój album',
        'DRAG_ALBUM_COVER_HERE' => 'Przeciągnij okładkę albumu tutaj',
        'ALBUM_TITLE' => 'Tytuł albumu:',
        'ALBUM' => 'album',
        'DRAG_PHOTOS_HERE' => 'Przeciągnij zdjęcia tutaj',
        'PREVIOUS_ALBUM_PAGE' => 'Poprzednia strona albumu',
        'NEXT_ALBUM_PAGE' => 'Następna strona albumu',
        'ADDED_ON_DATE' => 'Dodano dnia %s',
        'VIEW_AS_SLIDESHOW' => 'Przeglądaj jako pokaz slajdów',
        'CREATED_BY_ME' => 'Utworzone przez <a %s>Ja</a>',
        'CREATED_BY_X' => 'Utworzone przez %s',
        'OUR_APOLOGIES' => 'Przepraszamy',
        'ADD_PHOTOS_TO_ALBUM' => 'Dodaj więcej zdjęć do albumu, wybierając poniższe opcje.',
        'YOU_CAN_ADD_PHOTOS' => 'Możesz już <a %s>dodawać zdjęcia do albumu</a>.',
        'SITE_IS_GETTING_STARTED' => 'Sieć społeczna jest właśnie uruchamiana!',
        'NO_ONE_CREATED_ALBUMS' => 'Prawdopodobnie nie istnieją jeszcze żadne albumy.  Możesz <a %s>teraz utworzyć album</a>.',
        'EDIT_YOUR_ALBUM' => 'Edytuj album',
        'ALBUMS_WITH_THIS_PHOTO' => 'Wszystkie albumy zawierające to zdjęcie',
        'ALBUMS_WITH_X' => 'Wszystkie albumy zawierające \'%s\'',
        'ALBUMS_WITH_X_2' => 'Wszystkie albumy zawierające <em>\'%s\'</em>',
        'NO_ALBUMS_CONTAINING_PHOTO' => 'Brak albumów zawierających to zdjęcie.  Możesz <a %s>utworzyć nowy album</a>.',
        'XS_ALBUMS' => 'Albumy %s',
        'CREATE_AN_ALBUM' => 'Utwórz album',
        'YOU_HAVE_NOT_CREATED_ALBUMS' => 'Nie utworzono jeszcze żadnych albumów zdjęć.  Możesz <a %s>teraz utworzyć album</a>.',
        'X_HAS_NOT_CREATED_ALBUMS' => '%s nie utworzył jeszcze żadnych albumów zdjęć.',
        'MAKE_AN_ALBUM' => 'Utwórz album',
        'ABOUT_THIS_ALBUM' => 'Informacje o albumie',
        'ABOUT_YOUR_ALBUM' => 'Informacje o albumie',
        'EDIT_ALBUM' => 'Edytuj album',
        'DELETE_THIS_ALBUM' => 'Czy usunąć ten album?',
        'DELETE_ALBUM' => 'Usuń album',
        'START_SLIDESHOW' => 'Rozpocznij pokaz slajdów',
        'ALBUM_IS_NOW_EMPTY' => 'Album jest pusty.',
        'YOU_ARE_GETTING_STARTED' => 'Właśnie zaczynasz!',
        'YOU_HAVE_NOT_ADDED_PHOTOS' => 'Nie dodano jeszcze żadnych zdjęć!',
        'ADD_PHOTOS_AND_SHARE' => 'Dodawaj i udostępniaj zdjęcia przyjaciołom, rodzinie i reszcie świata!',
        'ADD_A_PHOTO' => 'Dodaj zdjęcie',
        'NO_PHOTOS_ON_SITE' => 'W Twojej sieci społecznej nie ma obecnie żadnych zdjęć.',
        'BOX_WILL_NOT_SHOW_PHOTOS' => 'To pole nie wyświetli się innym osobom, jeśli nie ma żadnych zdjęć do pokazania. Chcesz dodać zdjęcie?',
        'VIEW_EMBED_CODE' => 'Wyświetl osadzony kod',
        'VIEW_PHOTOS' => 'Przeglądaj zdjęcia',
        'ADD_YOUR_FIRST_PHOTOS' => 'Dodaj pierwsze zdjęcia',
        'YOU_CAN_ADD_YOUR_OWN_PHOTOS' => 'Możesz <a %s>dodawać własne zdjęcia</a> do %s!',
        'UPLOAD_PHOTOS_FROM' => 'Przekaż zdjęcia z tego komputer:',
        'ADD_TITLE_AND_DESCRIPTION_FOR_PHOTOS' => 'Dodawaj tytuły i opisy zdjęć',
        'EDIT_PHOTO_INFORMATION' => 'Edytuj informacje o zdjęciach',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_1' => 'Dodawaj tytuły, opisy i inne informacje do przekazanych zdjęć.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_2' => 'Dodaj tytuł, opis i inne informacje dla tego zdjęcia.',
        'CANCEL_AND_RETURN_TO_PHOTO' => 'Anuluj i powróć do zdjęcia',
        'WHO_CAN_VIEW_PHOTO' => 'Kto może oglądać to zdjęcie?',
        'CAN_BE_VIEWED_BY' => 'Osoby mogące wyświetlać to zdjęcie:',
        'BY_ME' => '<a %s>Ja</a>',
        'RSS_FEED_LABEL' => '<a %s>Źródło danych RSS</a>  %s',
        'NO_PHOTOS_AWAITING_APPROVAL' => 'Nie ma obecnie żadnych zdjęć oczekujących na zatwierdzenie.  Jeśli chcesz się czymś zająć, obejrzyj <a %s>najnowsze zdjęcia</a>?',
        'APPROVE_ALL_PHOTOS' => 'Czy zatwierdzić wszystkie zdjęcia?',
        'ARE_YOU_SURE_APPROVE_ALL_PHOTOS' => 'Czy na pewno zatwierdzić wszystkie zdjęcia?  Może to potrwać kilka minut.',
        'DELETE_ALL_PHOTOS' => 'Czy usunąć wszystkie zdjęcia?',
        'ARE_YOU_SURE_DELETE_ALL_PHOTOS' => 'Czy na pewno usunąć wszystkie niezatwierdzone zdjęcia?  Może to potrwać kilka minut.',
        'KEEP_WINDOW_OPEN_PHOTOS_APPROVED' => 'Nie zamykaj okna przeglądarki podczas zatwierdzania zdjęć.  Proces może potrwać kilka minut.',
        'KEEP_WINDOW_OPEN_PHOTOS_DELETED' => 'Nie zamykaj okna przeglądarki podczas usuwania zdjęć.  Proces może potrwać kilka minut.',
        'APPLY_TO_PHOTOS_ADDED_BY' => 'Zastosuj do wszystkich zdjęć dodanych przez %s',
        'NO_ONE_HAS_ADDED_ANY_PHOTOS' => 'Nie dodano żadnych zdjęć do Twojej sieci społecznej.  Możesz być pierwszą osobą, która <a %s>doda zdjęcia. </a>',
        'UNTITLED' => 'Brak tytułu',
        'A_PROBLEM_OCCURRED' => 'Wystąpił problem',
        'PHOTOS_EXCEEDED_LIMIT' => 'Prawdopodobnie przekroczono limit wielkości jednego zdjęcia, który wynosi 10 MB.',
        'GET_A_SLIDESHOW_OF' => 'Uruchom pokaz slajdów %s',
        'GET_A_SLIDESHOW' => 'Uruchom pokaz slajdów!',
        'GET_SLIDESHOW_OF_PHOTOS' => 'Uruchom pokaz slajdów zawierający te zdjęcia',
        'COPY_AND_PASTE_SLIDESHOW' => 'Skopiuj i wklej poniższy kod, aby umieścić pokaz slajdów zawierający te zdjęcia na swojej stronie internetowej, na stronie MySpace lub w innej sieci Ning.',
        'COPY_AND_PASTE_SLIDESHOW_OF_ALBUM' => 'Skopiuj i wklej poniższy kod, aby umieścić pokaz slajdów tego albumu na swojej stronie internetowej, na stronie MySpace lub w innej sieci Ning.',
        'LARGE_VERSION' => 'Duża wersja',
        'SMALL_VERSION' => 'Mała wersja',
        'VIEW_SLIDESHOW_FULL_SIZE' => 'Przegląd pełnowymiarowego pokazu slajdów',
        'PHOTOS' => 'Zdjęcia',
        'XS_PHOTOS' => 'Zdjęcia %s',
        'XS_PHOTO' => 'Zdjęcie %s',
        'YOU_CAN_MARK_PHOTO' => 'Możesz oznaczyć dowolne zdjęcia jako ulubione.  Wystarczy kliknąć ikonę „Dodaj do Ulubionych”, kiedy pojawi się na zdjęciu.',
        'VIEW_RECENT_PHOTOS' => 'Przeglądaj najnowsze zdjęcia',
        'APPROVE_PHOTOS' => 'Zatwierdź zdjęcia',
        'DELETE_ALL_XS_PHOTOS_Q' => 'Czy usunąć wszystkie zdjęcia %s?',
        'ARE_YOU_SURE_DELETE_ALL_XS_PHOTOS' => 'Czy na pewno usunąć wszystkie zdjęcia %s?  Proces może potrwać kilka minut.',
        'REMOVE_X_AND_ALL_CONTENT' => 'Usuń %1$s i całą zawartość %1$s ze swojej sieci społecznej',
        'SUCCESS' => 'Zadanie wykonane z powodzeniem.',
        'DELETING_CONTENT' => 'Trwa usuwanie zawartości…',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED' => 'Nie zamykaj okna przeglądarki podczas usuwania zawartości.  Proces może potrwać kilka minut.',
        'KEEP_WINDOW_OPEN_MEMBERS_DELETED' => 'Nie zamykaj okna przeglądarki podczas usuwania uczestników.  Proces może potrwać kilka minut.',
        'DELETE_ALL_XS_PHOTOS' => 'Usuń wszystkie zdjęcia %s',
        'CREATE_A_NEW_ALBUM' => 'Utwórz nowy album',
        'VIEW_ALL_XS_ALBUMS' => 'Przeglądaj wszystkie albumy %s',
        'YOU_HAVE_NOT_ADDED_PHOTOS_2' => 'Nie dodałeś jeszcze żadnych zdjęć.  Dodaj kilka zdjęć, aby rozpocząć!',
        'X_HAS_NOT_ADDED_PHOTOS' => 'Nie ma jeszcze żadnych zdjęć dodanych przez %s.',
        'MY_FRIENDS_PHOTOS' => 'Zdjęcia moich przyjaciół',
        'VIEW_PHOTOS_IN_SLIDESHOW' => 'Przeglądaj zdjęcia jako pokaz slajdów!',
        'YOUR_FRIENDS_DO_NOT_HAVE_PHOTOS' => 'Twoi przyjaciele nie mają jeszcze żadnych zdjęć',
        'ALL_PHOTOS_TAGGED_X' => 'Wszystkie zdjęcia oznaczone \'%s\'',
        'ALL_PHOTOS_TAGGED_X_2' => 'Wszystkie zdjęcia oznaczone <em>\'%s\'</em>',
        'NO_PHOTOS_TAGGED_X_CHECK_OUT' => 'Nie ma zdjęć oznaczonych „%1$s”.  Sprawdź <a %2$s>dyskusje oznaczone  „%1$s”</a> lub <a %3$s>wideo oznaczone „%1$s”</a>.  Możesz także dodawać i oznaczać własne zdjęcia!',
        'SELECT_YOUR_PHOTOS' => 'Wybierz swoje zdjęcia',
        'PHOTO_MAY_BE_10MB' => 'Każde zdjęcie może mieć nawet 10 MB, choć przekazywanie mniejszych zdjęć przebiega szybciej. Obsługujemy zdjęcia w formatach .jpg, .gif i .png.',
        'KEEP_PAGE_OPEN_PHOTOS' => 'Nie zamykaj tej strony, aby umożliwić nam dokończenie przekazywania zdjęć. Powiadomimy Cię o ich zatwierdzeniu!',
        'MEANWHILE_FEEL_FREE_PHOTOS' => 'Tymczasem możesz <a %s>otworzyć nowe okno przeglądarki </a> i dalej korzystać z %s.  Po zakończeniu przekazywania, w tym oknie można będzie dodawać tytuły i opisy zdjęć.',
        'PHOTO_IS_WAITING_FOR_APPROVAL' => 'To zdjęcie <strong>oczekuje na zatwierdzenie</strong> przez autora %s.',
        'ADD_TO_FAVORITES' => 'Dodaj do Ulubionych',
        'EDIT_PHOTO' => 'Edytuj zdjęcie',
        'DELETE_PHOTO' => 'Usuń zdjęcie',
        'ABOUT_THIS_PHOTO' => 'Informacje o zdjęciu',
        'LOCATION_OF_PHOTO' => 'Lokalizacja zdjęcia:',
        'ALBUMS_FEATURING_PHOTO' => 'Albumy zawierające to zdjęcie',
        'VIEW_ALBUMS_WITH_PHOTO' => 'Przeglądaj wszystkie albumy zawierające to zdjęcie',
        'RETURN_TO_X' => 'Wróć do %s',
        'RETURN_TO_PHOTOS_HOME' => 'Wróć do strony głównej zdjęć',
        'WE_COULD_NOT_FIND_ANYONE' => 'Przepraszamy, ale nie udało się nikogo znaleźć',
        'NOBODY_HAS_ADDED_PHOTOS' => 'Nie dodano jeszcze żadnych zdjęć!  Dodaj kilka zdjęć, aby rozpocząć.',
        'DEFAULT_TITLE' => 'Tytuł',
        'DEFAULT_DESCRIPTION' => 'Opis',
        'UPLOAD_LIMIT_EXCEEDED' => 'Przekroczony limit wielkości przekazywanych plików.',
        'SLOW_DOWN_THERE_CHIEF' => 'Przepraszamy',
        'I_DO_NOT_KNOW_USER' => 'Przepraszam, ale nie znam tej osoby.',
        'I_DO_NOT_HAVE_PHOTO' => 'Przepraszam, ale nie mam tego zdjęcia.',
        'I_DO_NOT_HAVE_ALBUM' => 'Przepraszam, ale nie mam tego albumu.',
        'ALBUM_BY_X_ON_X' => 'Albumy utworzone przez %s na %s',
        'SENT' => 'Wysłane!',
        'I_HAVE_RECENTLY_ADDED' => 'Ostatnio dodane przeze mnie',
        'FROM_THE_BAZEL' => 'Z tej sieci',
        'RECENTLY_ADDED' => 'Ostatnio dodane',
        'RECENT_PUBLIC_PHOTOS_ON_X' => 'Najnowsze publiczne zdjęcia na %s',
        'X_ALL_PHOTOS' => '%s - Wszystkie zdjęcia',
        'NO_TAG_WAS_SPECIFIED' => 'Nie określono znacznika',
        'PUBLIC_PHOTOS_TAGGED_WITH_X' => 'Zdjęcia publiczne oznaczone za pomocą %s na %s',
        'XS_PUBLIC_PHOTOS_ON_X' => 'Zdjęcia publiczne %s na %s',
        'WE_DO_NOT_KNOW_USER' => 'Nie znamy tej osoby.',
        'XS_FRIENDS_PHOTOS' => 'Zdjęcia przyjaciół %s',
        'XS_FAVORITE_PHOTOS_ON_X' => 'Ulubione zdjęcia %s na %s',
        'PHOTO_UPLOADED_ON_X' => 'Zdjęcia przekazane na %s',
        'FILE_EXCEEDED_MAXIMUM_SIZE' => 'Przekroczono maksymalny rozmiar pliku',
        'PART_OF_FILE_WAS_UPLOADED' => 'Przekazano tylko część pliku',
        'NO_FILE_WAS_UPLOADED' => 'Przekazywanie nie powiodło się;  prawdopodobnie nazwa pliku była nieprawidłowa',
        'PROBLEM_OCCURRED_DURING_UPLOAD' => 'Wystąpił problem podczas przekazywania.',
        'ALPHABETICAL' => 'Alfabetyczny',
        'MOST_VIEWS' => 'Najczęściej przeglądany',
        'RATING_NOT_RATED_YET' => '<strong>Ocena:</strong> brak oceny',
        'NOT_RATED_YET' => 'Brak oceny',
        'HMM_SOMETHING_WENT_AWRY' => 'Hmm… wystąpił błąd',
        'YOUR_PHOTO_TITLED_X_COULD_NOT' => 'Nie można dodać zdjęcia zatytułowanego „%s” do %s',
        'YOUR_PHOTO_COULD_NOT_BE_ADDED' => 'Nie można dodać zdjęcia do %s',
        'YOU_JUST_TRIED_TO_SEND' => 'Właśnie usiłowano wysłać zdjęcie do %s.  Niestety nie należysz do %s i nie możemy dostarczyć tego zdjęcia.',
        'ONLY_MY_FRIENDS' => 'Tylko moi przyjaciele',
        'ANYBODY' => 'Wszyscy',
        'ONLY_MY_FRIENDS_CAN_SEE_PHOTO' => 'Tylko moi przyjaciele mogą oglądać to zdjęcie',
        'ONLY_XS_FRIENDS_CAN_SEE_PHOTO' => 'Tylko przyjaciele %s mogą oglądać to zdjęcie',
        'ONLY_I_CAN_SEE_PHOTO' => 'Tylko ja mogę oglądać to zdjęcie',
        'ONLY_X_CAN_SEE_PHOTO' => 'Tylko %s może oglądać to zdjęcie',
        'EVERYONE_CAN_SEE_PHOTO' => 'Wszyscy mogą oglądać to zdjęcie',
        'PRIVATE_PHOTO' => 'Zdjęcie <strong>prywatne</strong>',
        'HOWDY_STRANGER' => 'Witaj Gościu!',
        'YOU_NEED_TO_BE_SIGNED_IN' => 'Musisz zarejestrować się w sieci Ning, aby móc to zrobić.',
        'JUST_CLICK_ON_SIGN_IN' => 'Wystarczy kliknąć „Zarejestruj się” powyżej, a jeśli nie masz jeszcze konta w sieci Ning, kliknij „Zapisz się”.',
        'YOU_NEED_TO_BE_' => 'Musisz być %s, aby to zrobić.',
        'YOU_NEED_TO_BE_OWNER' => 'Musisz być autorem sieci, aby to zrobić.',
        'THAT_PHOTO_IS_AWAITING_APPROVAL' => 'To zdjęcie oczekuje na zatwierdzenie.',
        'YOU_NEED_TO_BE_A_FRIEND' => 'Musisz być przyjacielem %s, aby to zrobić.',
        'MOST_ACTIVE' => 'Najbardziej aktywny',
        'HOW_IT_WORKS' => 'Zasady działania',
        'MORE_WAYS_TO_ADD_PHOTOS' => 'Inne sposoby dodawania zdjęć…',
        'BY_PHONE_OR_EMAIL' => '… telefonicznie lub pocztą elektroniczną',
        'FROM_FLICKR' => '… z serwisu Flickr',
        'FROM_YOUR_COMPUTER' => '… z tego komputera',
        'ADD_PHOTOS_FROM_YOUR_FLICKR' => 'Dodawaj zdjęcia z konta w serwisie Flickr.',
        'MORE_INFORMATION' => 'Więcej informacji',
        'ADD_PHOTOS_BY_PHONE_OR_EMAIL' => 'Dodawaj zdjęcia telefonicznie lub pocztą elektroniczną',
        'SEND_ONE_PHOTO_OR_VIDEO' => 'Wyślij jedno zdjęcie lub wideo pocztą elektroniczną.  Temat wiadomości e-mail będzie tytułem zdjęcia lub wideo, a treść będzie opisem.',
        'CLICK_HERE_TO_GET_A_NEW_UNIQUE' => 'Kliknij, aby otrzymać nowy adres e-mail',
        'UPLOAD_PHOTOS_FROM_YOUR' => 'Przekaż zdjęcia z tego komputera.',
        'PHOTO' => 'zdjęcie',
        'YOUVE_SET_THE_NUMBER_OF_PHOTOS' => 'Obecnie nie wyświetlasz żadnych zdjęć.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_PHOTO' => 'To pole nie pojawi się u innych osób, chyba że wybierzesz co najmniej jedno zdjęcie.',
        'THERE_IS_NEW_COMMENT_ON_PHOTO_X' => 'Pojawił się nowy komentarz na temat Twojego zdjęcia „%s” na %s',
        'THERE_IS_NEW_COMMENT_ON_PHOTO' => 'Pojawił się nowy komentarz na temat jednego z Twoich zdjęć na %s',
        'SOMEBODY_COMMENTED_PHOTO_ADDED_TO_X' => 'skomentowano dodane przez Ciebie zdjęcie do %s',
        'SOMEBODY_UPLOADED_PHOTO_TO_X' => 'przekazano zdjęcie do %s',
        'ADD_PHOTOS_OR_VIDEOS_TO_X' => 'Dodawaj zdjęcia lub wideo do %s bezpośrednio z telefonu, wysyłając je na adres e-mail.',
        'DO_YOU_REALLY_WANT_TO_REMOVE' => 'Czy na pewno chcesz usunąć ten element z ulubionych?',
        'DELETE_THIS_PHOTO_Q' => 'Czy usunąć to zdjęcie?',
        'ARE_YOU_SURE_DELETE_THIS_PHOTO' => 'Czy na pewno usunąć to zdjęcie?  Proces może potrwać kilka minut.',
        'PHOTO_SLIDESHOW' => 'Pokaz slajdów',
        'THUMBNAILS' => 'Miniatury',
        'DETAIL' => 'Szczegół',
        'TAG' => 'Znacznik',
        'RATE' => 'Oceń',
        'ALL_SIZES' => 'Wszystkie rozmiary',
        'ADD_TO_ALBUM' => 'Dodaj do albumu',
        'ROTATE_PHOTO' => 'Obróć zdjęcie',
        'ABOUT_YOUR_PHOTO' => 'Informacje o zdjęciu',
        'SEE_PHOTOS_ON_NETWORK' => 'Pokaż te zdjęcia na %s',
        'EMBED_CODE' => 'Osadzony kod',
        'IMPORT_PHOTOS_FLICKR' => 'Pozyskaj swoje zdjęcia z serwisu Flickr',
        'CLICK_HERE_TO_CONTINUE_TO_FLICKR' => 'Kliknij tutaj, aby przejść do serwisu Flickr',
        'TO_GET_YOUR_PHOTOS_FROM_FLICKR' => 'Aby pozyskać zdjęcia z serwisu Flickr, najpierw pozwól, aby %S połączył się z Twoim kontem Flickr.',
        'IMPORT_PHOTOS' => 'Importuj zdjęcia',
        'GET_MY' => 'Pozyskaj moje',
        'GET_PHOTOS' => 'Pozyskaj zdjęcia',
        'MOST_RECENT_PHOTOS' => 'najnowsze zdjęcia',
        'GET_ALL_MY_FLICKR' => 'Pozyskaj wszystkie moje zdjęcia z serwisu Flickr (może to potrwać jakiś czas)',
        'GET_ALL_MY_TAGGED' => 'Pozyskaj wszystkie moje oznaczone zdjęcia',
        'GET_PHOTOS_FROM_SET' => 'Pozyskaj moje zdjęcia z zestawu:',
        'GET_STARTED_BY_IMPORT' => 'Automatycznie pozyskamy Twoje tytuły, znaczniki i informacje dotyczące mapowania. <br/>Ile czasu to zajmie? </p> <p><ul style="padding-top:10px; "><li>10 zdjęć: <em>mniej niż 30 sekund</em>. </li><li>50 zdjęć: <em>około 2 minut</em>. </li><li>200 zdjęć: <em>około 6 minut</em>. </li><li>500 zdjęć: <em>około 15 minut</em>. </li></ul>',
        'IF_YOURE_NOT_SIGNED_IN' => 'Wymagana jest rejestracja w serwisie Flickr.  Po zakończeniu rejestracji, kliknij przycisk „OK, zgadzam się”.',
        'GET_MY_FLICKR_PHOTOS_DESCRIPTIONS' => 'Pozyskaj także opisy (zajmie to dwukrotnie więcej czasu).',
        'PLEASE_KEEP_THIS_PAGE_OPEN_WHILE_IMPORT' => 'Nie zamykaj tej strony, aby umożliwić nam dokończenie importowania zdjęć.',
        'GET_MY_FLICKR_PHOTOS_ORIGINALS' => 'Pozyskaj pełnowymiarowe wersje wszystkich zdjęć (spowoduje to znaczne wydłużenie czasu importowania i nie jest zalecane, kiedy liczba zdjęć przekracza 20).',
        'MAKE_YOUR_X_PAGE_YOUR_OWN' => 'Kliknij przycisk „Edytuj”, aby umieścić tekst, wideo, zdjęcia lub inne elementy widget w tym polu.  To kolejny sposób, w jaki możesz nadać stronie %s bardziej indywidualny charakter.',
        'BOX_WILL_NOT_SHOW_UNTIL_UPDATE_CONTENT' => 'To pole nie pojawi się u innych osób, dopóki nie zaktualizujesz jego zawartości.',
        'YOUR_X_BOX' => 'Twoje pole %s',
        'ABOUT_WIDGETS' => 'Informacje o elementach widget',
        'HELP' => 'Pomoc',
        'WIDGETS' => 'Elementy widget',
        'LOOKING_TO_ADD_FUNCTIONALITY' => 'Chcesz zwiększyć funkcjonalność swojej sieci społecznej?  Możesz dodać kalendarz, lokalną prognozę pogody, odliczanie czasu do zaplanowanych wydarzeń lub kamerę internetową.  Elementy widget ułatwiają dodawanie kolejnych funkcji do dowolnych pól tekstowych w sieci.',
        'GETTING_STARTED' => 'Wprowadzenie',
        'BELOW_IS_LIST_OF_WIDGET' => 'Poniżej znajdziesz <a %s>listę dostawców elementów widget</a>, z których możesz skorzystać.  Wybraliśmy kilka elementów widget z witryny <a %s>yourminis. com</a>, aby pomóc Ci zacząć.  Skonfiguruj element widget poniżej, skopiuj osadzony kod i wklej go bezpośrednio w pole tekstowe.  Dalej!',
        'CALENDAR' => 'Kalendarz',
        'CALENDAR_WIDGET_ALLOWS_SEARCH' => 'Element widget Kalendarz nie tylko wyświetla datę, ale także umożliwia wyszukiwanie i dodawanie zdarzeń w formacie iCal (używanym przez Kalendarz Google i wielu innych dostawców kalendarzy internetowych).',
        'USE_EDIT_WIDGET_BUTTON_CALENDAR' => 'Użyj &#8220; edytuj element widget&#8221;  , aby wybrać funkcję &#8220; szukaj zdarzeń &#8221; , po czym wprowadź szukany termin (np. wakacje, zespół sportowy, itp. ). Następnie wybierz wyniki wyszukiwania, aby dodać zdarzenia do kalendarza.  Możesz także ręcznie wprowadzić adres istniejącego źródła zdarzeń iCal.',
        'CUSTOMIZATION' => 'Dostosowywanie',
        'YOU_CAN_CUSTOMIZE_WIDGET' => 'Możesz dostosować wygląd elementu widget, ustawiając na nim kursor myszy i klikając ikonę wyboru kolorów, aby zmienić tło, styl elementu i poziom przezroczystości.  Kiedy skończysz, kliknij łącze &#8220; kopiuj do sieci &#8221;, a następnie przycisk &#8220; kopiuj osadzony kod&#8221;.    Uzyskaj osadzony kod    Kiedy skopiujesz kod, wróć do dowolnego pola tekstowego w sieci, wklej kod i zapisz zmiany.  Gotowe!',
        'GET_MORE_WIDGETS_FROM_YOURMINIS' => 'Pozyskaj więcej elementów widget z witryny yourminis. com>>',
        'WEATHER' => 'Pogoda',
        'WEATHER_WIDGET_DISPLAYS' => 'Element widget Pogoda wyświetla lokalną prognozę pogody z kanału Weather Channel.',
        'USE_EDIT_WIDGET_BUTTON_WEATHER' => 'Użyj &#8220; edytuj element widget&#8221;  , aby wskazać swoją lokalizację i wybrać skalę Fahrenheita lub Celsjusza.  Możesz wyświetlić prognozę pogody na dany dzień lub na pięć dni.',
        'COUNTDOWN' => 'Odliczanie',
        'COUNTDOWN_WIDGET_LETS_YOU' => 'Element widget Odliczanie umożliwia utworzenie odmierzania czasu do określonego zdarzenia.  Klikając przycisk &#8220; edytuj element widget&#8221;  , możesz wprowadzić datę, godzinę i tytuł lub obraz zdarzenia, do którego chcesz odliczać pozostały czas.',
        'WEBCAM' => 'Kamera internetowa',
        'WEBCAM_WIDGET_ALLOWS_YOU' => 'Element widget Kamera internetowa umożliwia aktywne monitorowanie dowolnych publicznie dostępnych kamer internetowych.  Użyj &#8220; edytuj element widget&#8221;  , aby wybrać z listy wstępnie zdefiniowane kamery internetowe lub wprowadź ręcznie ich adresy URL.',
        'MORE_WIDGETS' => 'Więcej elementów widget',
        'NEED_MORE_OPTIONS' => 'Potrzebujesz dodatkowych opcji?  Polecamy następujące strony internetowe, na których można znaleźć więcej elementów widget:',
        'MODERATION_DENIED_ON_X' => 'Moderowanie niedozwolone na %s na %s',
        'MODERATION_DENIED_ON_A_X' => 'Moderowanie niedozwolone na %s z Twoich %s',
        'YOU_HAVE_NEW_X_TO_MODERATE' => 'Masz nowy %s do moderowania na %s',
        'NEW_X_TO_MODERATE' => 'Masz nowy %s do moderowania.',
        'MODERATION_APPROVED_ON_X' => 'Moderowanie zatwierdzone na %s na %s',
        'MODERATION_APPROVED_ON_A_X' => 'Moderowanie zatwierdzone na %s z Twoich %s',
        'JOIN' => 'Przyłącz się',
        'WELCOME' => 'Witamy',
        'WELCOME_TO_X' => 'Witamy w %s',
        'WELCOME_TO_X_ELLIPSIS' => 'Witamy w %s…',
        'RSS_LINK' => '<a %s>RSS</a>',
        'NEW_FEATURES_GROUPS_MUSIC' => '<h3 style="margin-top:0">Nowe funkcje! </h3>
            <ul><li><strong>Grupy</strong> &ndash;  Pozwól uczestnikom na tworzenie grup w Twojej sieci</li>
                <li><strong>Odtwarzacz muzyczny</strong> &ndash;  Dodawaj muzykę i podcasty do swojej sieci</li></ul>
            <p><a href="%s" class="desc add">Kliknij tutaj, aby dodać funkcje</a></p>',
        'NEW_FEATURES_ACTIVITY_BADGES' => '<h3 style="margin-top:0">Nowe funkcje! </h3>
            <ul><li><strong>Ostatnia czynność</strong> &ndash;  Śledź ostatnią czynność uczestnika w swojej sieci</li>
                <li><strong>Oznaczenia i elementy widget</strong> &ndash;  Promuj swoją sieć w Internecie za pomocą niestandardowych oznaczeń i elementów widget</li></ul>
            <p><a href="%s" class="desc add">Kliknij tutaj, aby dodać/edytować funkcje</a></p>',
        'YOUR_TYPE_NAME_HAS_NEW_COMMENT_APPNAME' => 'Twój %2$s, %1$s, ma nowy komentarz dodany przez kogoś na %3$s!',
        'YOUR_TYPE_HAS_NEW_COMMENT_APPNAME' => 'Twój %1$s ma nowy komentarz dodany przez kogoś na %2$s!',
        'HERE_IS_LINK' => 'Użyj tego łącza, aby przyłączyć się do: <a %s>%s</a>',
        'THANKS_VALEDICTION' => 'Dziękuję,',
        'THANKS' => 'Dziękuję!',
        'YOU_CHANGED_YOUR_EMAIL_ON_X' => 'Twój adres e-mail został zmieniony na %s.',
        'YOU_CHANGED_YOUR_EMAIL_ON_X_ELLIPSIS' => 'Twój adres e-mail został zmieniony na %s…',
        'CLICK_HERE_TO_SIGN_IN_WITH_YOUR_NEW_EMAIL_ADDRESS' => 'Kliknij tutaj, aby zarejestrować się z nowym adresem e-mail:',
        'IF_DID_NOT_CHANGE_EMAIL_ADDRESS' => 'Kliknij tutaj, jeśli Twój adres e-mail nie uległ zmianie:',
        'TO_STOP_BEING_NOTIFIED_OF_NEW_DISCUSSIONS_GO_TO' => 'Jeśli nie chcesz otrzymywać więcej powiadomień o nowych dyskusjach, przejdź do:',
        'X_STARTED_DISCUSSION_ON_APPNAME_ELLIPSIS' => '%1$s rozpoczął nową dyskusję dotyczącą %2$s…',
        'X_STARTED_THE_DISCUSSION_Y' => '%1$s rozpoczął dyskusję „%2$s”.',
        'TO_VIEW_THIS_DISCUSSION_GO_TO' => 'Aby przejrzeć tę dyskusję, przejdź do:',
        'X_HAS_INVITED_YOU_TO_JOIN_Y' => '%s zaprosił Cię do przystąpienia do %s!',
        'X_WANTS_YOU_TO_CHECK_OUT_Y' => '%s zachęca Cię do sprawdzenia „%s” na %s!',
        'CHECK_OUT_TITLE_ON_APPNAME' => 'Sprawdź „%s” na %s!',
        'ABOUT_X' => 'Informacje o %s',
        'YOU_HAVE_RECEIVED_BECAUSE_X' => 'Otrzymujesz tę wiadomość e-mail, ponieważ %s',
        'IF_YOU_NO_LONGER_WISH_FROM_X_CLICK_Y' => 'Jeśli nie chcesz otrzymywać więcej powiadomień e-mail od %s, <a %s>kliknij tutaj</a>.',
        'CLICK_HERE' => 'Kliknij tutaj',
        'YOU_CAN_CONTACT_US' => 'Możesz kierować do nas pytania lub uwagi dotyczące swojej prywatności na stronie http://help.ning.com/?page_id=27 .',
        'MESSAGE_TO_ALL_MEMBERS_OF_X' => 'Komunikat do wszystkich uczestników %s',
        'CLICK_TO_CHECK_OUT' => 'Kliknij tutaj, aby to sprawdzić!',
        'CLICK_TO_APPROVE_X' => 'Kliknij tutaj, aby zatwierdzić/ usunąć %s',
        'YOUR_X_HAS_BEEN_APPROVED' => 'Twój %s został zatwierdzony na %s!',
        'YOUR_X_WAS_NOT_APPROVED' => 'Twój %s nie został zatwierdzony na %s.',
        'CLICK_TO_VIEW_X' => 'Kliknij tutaj, aby przeglądać %s!',
        'CLICK_TO_VIEW_IT' => 'Kliknij tutaj, aby to przejrzeć!',
        'TO_VIEW_USER_PROFILE_VISIT' => 'Aby przeglądać profil %s, odwiedź:',
        'YOU_ADDED_CONTENT' => 'dodałeś zawartość do %s, moderowanej sieci społecznej',
        'X_REPORTED_AN_ISSUE_ON_Y_ELLIPSIS' => '%1$s zgłosił problem dotyczący %2$s...',
        'X_REPORTED_THE_FOLLOWING_ISSUE' => '%s zgłosił następujący problem.',
        'URL_REPORTED_COLON' => 'Zgłoszony adres URL:',
        'ISSUE_COLON' => 'Problem:',
        'ADDITIONAL_INFORMATION_COLON' => 'Informacje dodatkowe:',
        'SEND_AN_INVITATION_TO_X' => 'Wyślij zaproszenie do %s',
        'SOMEBODY_REQUESTED_JOIN_X' => 'zgłoszono chęć przystąpienia do %s',
        'WANT_TO_ADD_A_WELCOME_MESSAGE_FOR_X_ON_THEIR_PROFILE_GO_TO' => 'Czy chcesz dodać wiadomość powitalną dla %s w ich profilu?   Przejdź do:',
        'USER_HAS_SENT_YOU_A_MESSAGE' => 'Użytkownik %s wysłał do Ciebie wiadomość.',
        'TO_READ_THIS_MESSAGE_VISIT' => 'Aby ją przeczytać, odwiedź:',
        'X_HAS_SENT_YOU_A_MESSAGE_ON_Y_ELLIPSIS' => '%s wysłał do Ciebie wiadomość dotyczącą %s…',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ELLIPSIS' => '%s dodał Ciebie jako przyjaciela…',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ON_Y' => '%s dodał Ciebie jako przyjaciela na %s...',
        'X_HAS_ACCEPTED_YOUR_FRIEND_REQUEST' => '%s przyjął żądanie Twojego przyjaciela dotyczące %s!',
        'TO_ACCEPT_THIS_FRIEND_REQUEST_VISIT' => 'Aby przyjąć żądanie tego przyjaciela, odwiedź:',
        'VIEW_XS_PAGE_ON_Y' => 'Przeglądaj stronę %s na %s',
        'MEMBER_OF_X_ACCEPTED' => 'uczestnik %s przyjął żądanie Twojego przyjaciela',
        'IF_NO_LONGER_WISH_FRIEND_NOTIFICATION_EMAIL_FROM_X_CLICK_Y' => 'Jeśli nie chcesz otrzymywać więcej powiadomień e-mail o żądaniach przyjaciół od %s, <a %s>kliknij tutaj</a>.',
        'YOU_RECEIVED_INVITATION_FROM_X' => 'Otrzymujesz to zaproszenie od uczestnika %1$s.  Jeśli nie chcesz otrzymywać więcej zaproszeń od %1$s, skontaktuj się z nami, odwiedzając stronę http://help.ning.com/?page_id=27 .',
        'ON_X_COLON' => 'Na %s:',
        'ON_X' => 'na %s',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP' => 'Użytkownik %s zażądał uczestnictwa w grupie %s.',
        'USER_HAS_INVITED_YOU_TO_JOIN_THE_GROUP_X' => 'Użytkownik %1$s zaprosił Cię do przyłączenia się do grupy „%2$s”',
        'VISIT_GROUP_AT' => 'Odwiedź %s pod adresem:',
        'ABOUT_GROUP' => 'Informacje o %s',
        'A_MESSAGE_FROM_USERNAME_TO_GROUPNAME_ON_APPNAME' => 'Wiadomość od %s do wszystkich uczestników %s na %s!',
        'YOU_CAN_SIGN_IN_USING_EMAIL_HERE' => 'Możesz się zarejestrować, podając swój adres e-mail tutaj:',
        'USERNAME_COMMENTED_ON_BLOG_POST_TITLE_APPNAME' => 'Użytkownik %s skomentował post blogu \'%s\\ na %s',
        'SEND_X_A_MESSAGE_HERE' => 'Wyślij do %s wiadomość tutaj:',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X_ELLIPSIS' => 'Nowy uczestnik oczekuje na zatwierdzenie na %s…',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE' => 'Nowy uczestnik oczekuje na zatwierdzenie.',
        'TO_APPROVE_XS_PROFILE_VISIT' => 'Aby zatwierdzić profil %s, odwiedź:',
        'CANT_CLICK_CUT_AND_PASTE' => 'Czy nie możesz kliknąć powyższego łącza?  Wystarczy skopiować i wkleić adres URL w pasku przeglądarki internetowej.',
        'CLICK_HERE_TO_JOIN_COLON' => 'Aby się przyłączyć, kliknij tutaj:',
        'CLICK_HERE_TO_JOIN_BANG' => 'Aby się przyłączyć, kliknij tutaj!',
        'YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED_ELLIPSIS' => 'Twoje uczestnictwo %s zostało zatwierdzone…',
        'CONGRATULATIONS_BANG_YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED' => 'Gratulacje!   Twoje uczestnictwo %s zostało zatwierdzone.',
        'YOU_CAN_NOW_SIGN_IN_USING_YOUR_EMAIL_ADDRESS_HERE' => 'Teraz możesz się zarejestrować, podając swój adres e-mail tutaj:',
        'VISIT_X_AT_Y' => 'Odwiedź %1$s pod adresem: %2$s',
        'TO_CONTROL_WHICH_EMAILS_YOUR_RECEIVE_ON_X_GO_TO' => 'Aby kontrolować wiadomości e-mail otrzymywane na %1$s, przejdź do:',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_ELLIPSIS' => 'Zablokowany uczestnik wysłał Ci wiadomość na %s…',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_USERNAME_WRITES' => 'Zablokowany uczestnik wysłał Ci wiadomość na %1$s.   %2$s pisze:',
        'WELCOME_TO_THE_GROUP_X' => 'Witamy w grupie „%s”',
        'WELCOME_TO_GROUP_X_ON_Y_ELLIPSIS' => 'Witamy w %1$s na %2$s…',
        'TO_VIEW_THIS_GROUP_VISIT' => 'Aby przeglądać tę grupę, odwiedź:',
        'X_INVITES_YOU_TO_JOIN_Y' => '%1$s zaprasza Cię do przyłączenia się do %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y' => '%1$s jest teraz uczestnikiem %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y_ELLIPSIS' => '%1$s jest teraz uczestnikiem %2$s…',
        'SOMEBODY' => 'Ktoś',
        'TO_VIEW_YOUR_NEW_COMMENT_VISIT' => 'Aby wyświetlić nowy komentarz, odwiedź:',
        'TO_VIEW_THE_NEW_COMMENT_VISIT' => 'Aby wyświetlić nowy komentarz, odwiedź:',
        'TO_VIEW_THE_NEW_REPLY_VISIT' => 'Aby wyświetlić nową odpowiedź, odwiedź:',
        'WELCOME_TO_X_THANK_YOU_FOR_JOINING' => 'Witamy w %s!  Dziękujemy za przyłączenie się.',
        'NAME_COLON' => 'Imię i nazwisko:',
        'EMAIL_COLON' => 'E-mail:',
        'AGE_COLON' => 'Wiek:',
        'GENDER_COLON' => 'Płeć:',
        'LOCATION_COLON' => 'Lokalizacja:',
        'COUNTRY_COLON' => 'Kraj:',
        'GET_NETWORK_BADGE' => 'Oznaczenie %s',
        'SPREAD_WORD_GET_BADGE' => 'Rozpowszechnij.  Pozyskaj oznaczenie %s dla swojej witryny internetowej lub strony MySpace.  (<a %s>Pozyskaj kod</a>)',
        'SPREAD_WORD_GET_BADGE_SHORT' => 'Rozpowszechnij.  <a href="%s">Pozyskaj oznaczenie %s</a>',
        'SHOW_ALLEGIANCE_GET_BADGE' => 'Okaż lojalność.  Pozyskaj oznaczenie %s, aby umieścić je na swojej stronie internetowej lub na stronie MySpace.  (<a %s>Pozyskaj kod</a>)',
        'USER_COMMENTED_ON_A_TYPE_ON_APPNAME' => 'Użytkownik %1$s skomentował %2$s „%4$s” na %3$s',
        'UNABLE_TO_EXTRACT_EMAIL_ADDRESSES' => 'Przepraszamy, ale nie możemy wyodrębnić adresu e-mail z pliku.',
        'ADMINISTRATORS' => 'Administratorzy',
        'YOUR_INVITATION_HAS_EXPIRED' => 'Twoje zaproszenie straciło ważność',
        'SORRY_INVITATION_EXPIRED' => 'Przepraszamy, ale Twoje zaproszenie straciło ważność.   Potrzebujesz nowego zaproszenia, aby przyłączyć się do %s.',
        'DISABLE_INVITATION_LINK' => 'Czy wyłączyć łącze zaproszenia?',
        'CREATING_LINK_WILL_DISABLE' => 'Utworzenie nowego łącza zaproszenia wyłączy obecne łącze.  Czy na pewno chcesz utworzyć nowe łącze?',
        'SHARE_LINK_WITH_PEOPLE' => 'Udostępnij to łącze osobom, które chcesz zaprosić do tej sieci:',
        'CREATE_INVITATION_LINK' => 'Utwórz nowe łącze zaproszenia',
        'PLEASE_SELECT_SECOND_PART' => 'Wybierz drugą część swojego adresu e-mail, np. gmail. com.',
        'AT_SYMBOL_NOT_ALLOWED' => 'Symbol @ nie może wystąpić w pierwszej części adresu e-mail.',
        'SORRY_WE_DONT_SUPPORT' => 'Przepraszamy, ale nie obsługujemy internetowej książki adresowej dla podanego adresu e-mail.  Kliknij  \'program pocztowy\' poniżej, aby użyć adresów z komputera.',
        'PLEASE_ENTER_PASSWORD_FOR_EMAIL' => 'Wprowadź swoje hasło dla %s.',
        'IMPORTING_ADDRESS_BOOK' => 'Importowanie książki adresowej',
        'LEAVE_WINDOW_WHILE_GET' => '<strong>Nie zamykaj tego okna,</strong> kiedy pozyskujemy adresy e-mail Twoich przyjaciół.  Gotowe. Teraz możesz zdecydować, których przyjaciół chcesz zaprosić.',
        'SHARE_THIS_LINK' => 'Udostępnij to łącze:',
        'SEND_WITH_EMAIL_PROGRAM' => 'Wyślij je za pomocą programu komputerowego do obsługi poczty elektronicznej:',
        'EMAIL_THIS' => 'Wyślij pocztą elektroniczną',
        'IS_YOUR_FRIEND_PARENTHESIZED' => '(Twój przyjaciel)',
        'CLEAR' => 'Przezroczysty',
        'SEARCH_FRIENDS_TO_INVITE' => 'Szukaj przyjaciół, których chcesz zaprosić:',
        'YOUR_INVITATIONS_HAVE_BEEN_SENT' => 'Twoje zaproszenia zostały wysłane',
        'WANT_TO_INVITE_MORE' => 'Czy chcesz zaprosić więcej przyjaciół?  Zaproś więcej przyjaciół, importując informacje kontaktowe z internetowej książki adresowej lub programu pocztowego.',
        'MESSAGE_TOO_LONG' => 'Wiadomość jest zbyt długa. Użyj mniej niż %s znaków.',
        'FOLLOWING_DO_NOT_SEEM_VALID' => 'Poniższe adresy e-mail nie są prawidłowe.  Zaproszenia nie były wysłane.  Popraw adresy e-mail i spróbuj ponownie.',
        'PLEASE_ENTER_EMAIL_ADDRESSES' => 'Wprowadź jeden lub więcej adresów e-mail.',
        'ENTER_EMAIL_ADDRESSES' => 'Wprowadź adresy e-mail',
        'SEPARATE_MULTIPLE_ADDRESSES' => 'Oddzielaj kolejne adresy przecinkami',
        'YOUR_MESSAGE_OPTIONAL' => '<label>Twoja wiadomość</label> (opcja)',
        'SEND_INVITATIONS' => 'Wyślij zaproszenia',
        'WEB_ADDRESS_BOOK' => 'Internetowa książka adresowa',
        'YAHOO_MAIL_HOTMAIL' => 'Yahoo Mail, Hotmail, GMail lub AOL Mail',
        'YOUR_EMAIL_ADDRESS' => 'Twój adres e-mail',
        'IMPORT_ADDRESS_BOOK' => 'Importuj książkę adresową',
        'DONT_WORRY_WE_WONT_SAVE' => 'Nie ma powodu do niepokoju, nie zapiszemy Twojego hasła i będziesz miał okazję wybrać, do których przyjaciół wysłać e-mail.',
        'EMAIL_APPLICATION' => 'Program pocztowy',
        'MICROSOFT_OUTLOOK_APPLE_MAIL' => 'Microsoft Outlook, Apple Mail, . CSV, itd.',
        'UPLOAD_CSV_OR_VCF' => 'Przekaż plik . csv lub . plik vcf wyeksportowany z Microsoft Outlook lub książki adresowej Apple.',
        'BROWSE_FOR_FILE' => 'Przeglądaj plik',
        'UPLOAD' => 'Przekaż',
        'SELECT_ELLIPSIS' => 'zaznacz....',
        'OTHER_ELLIPSIS' => 'inne...',
        'DONT_WORRY_YOULL_GET_CHANCE' => 'Nie ma powodu do niepokoju, będziesz miał okazję wybrać, do których przyjaciół wysłać wiadomość e-mail.',
        'MEMBERSHIP_BY_INVITATION_ONLY' => 'Członkostwo jedynie przez zaproszenie',
        'IF_YOU_ARE_ADMIN' => 'Jeżeli jesteś administratorem, <a %s>kliknij tutaj w celu rejestracji</a>.',
        'NAME_MUST_BE_SHORTER' => 'Nazwa musi zawierać mniej niż %s znaków',
        'CITY_NAME_MUST_BE_SHORTER' => 'Nazwa miasta musi zawierać mniej niż %s znaków',
        'EMAIL_ALREADY_REGISTERED' => 'Ten adres e-mail został już zarejestrowany.  Wybierz inny.',
        'EMAIL_NOT_VALID' => 'Adres e-mail nie jest prawidłowy.',
        'USERNAME_INVITED_YOU_TO_APPNAME' => '%s zaprosił Cię do %s',
        'YOU_ARE_SIGNING_UP_WITH' => 'Rejestrujesz się przy użyciu identyfikatora Ning.',
        'NOW_ENTER_PASSWORD' => 'Aby kontynuować, wprowadź teraz swoje hasło.',
        'OR_SIGN_IN' => 'lub <a %s>Zarejestruj się</a>',
        'CHANGE_ADDRESS' => 'Zmień adres',
        'CHANGE_PAGE_ADDRESS' => 'Zmień adres strony',
        'PAGE_ADDRESS_TAKEN' => 'Przepraszamy - ta nazwa już istnieje.  Wybierz inny.',
        'PAGE_ADDRESS_NOT_VALID' => 'W swoim adresie możesz jedynie używać liter A-Z, cyfr i podkreśleń (_).',
        'ADD_BY_PHONE' => 'Dodaj przez telefon',
        'PAGE_ADDRESS' => 'Adres strony',
        'PHOTO_MUST_BE_TYPE' => 'Twoje zdjęcie musi być zapisane . format jpg, . gif lub . w postaci pliku png.',
        'USEFUL_ADDRESSES' => 'Pomocne adresy',
        'MY_DETAILS' => 'Szczegółowe informacje o mnie',
        'NONE_I_DO_NOT_WANT' => 'Brak: nie chcę otrzymywać wiadomości e-mail od %s',
        'CHANGE_PASSWORD' => 'Zmień hasło',
        'PROFILE_SAVED' => 'Zmiany zostały pomyśnie zapisane.',
        'UPDATE_EMAIL_ADDRESS' => 'Uaktualnij adres e-mail',
        'EDIT_EMAIL_ADDRESS' => 'Edytuj swój adres e-mail',
        'MY_SETTINGS' => 'Moje ustawienia',
        'ABOUT_ME' => 'Informacje o mnie',
        'SELECT' => 'Zaznacz...',
        'CITY' => 'Miejscowość',
        'COUNTRY' => 'Kraj',
        'DATE_OF_BIRTH' => 'Data urodzenia',
        'DO_NOT_DISPLAY' => 'Nie wyświetlaj',
        'GENDER' => 'Płeć',
        'CREATE_YOUR_PROFILE' => 'Utwórz swój profil',
        'SYSTEM_REQUIREMENTS' => 'Wymagania systemowe',
        'WE_SUPPORT_INTERNET_EXPLORER' => 'Nasz serwis współpracuje z przeglądarką Internet Explorer 6 i 7, Firefox 2.0 oraz Safari 2.0. Jeśli używasz innej przeglądarki (np. dostarczonej przez swego usługodawcę internetowego) może ona nie być zgodna.',
        'MAKE_SURE_COOKIES' => 'Upewnij się, że w Twojej przeglądarce włączona jest obsługa plików cookie i JavaScript.',
        'WHAT_IS_MY_EMAIL' => 'Jaki jest mój adres e-mail?',
        'IF_JOINED_BEFORE_OCTOBER' => 'Jeśli przyłączyłeś się przed 5 października 2007, możesz zostać poproszony o \'Ning ID\'.  Prosimy o zarejestrowanie się przy użyciu adresu e-mail, który podałeś przy rejestracji, jednakże nadal możesz wprowadzić w tym polu swój identyfikator Ning.',
        'CLICK_HERE_TO_RESET_PASSWORD' => 'Kliknij tutaj, aby zresetować hasło.',
        'STILL_HAVING_PROBLEMS' => 'Czy problemy nadal występują?',
        'VISIT_NING_HELP_CENTER' => 'Odwiedź <a %s>Ning Help Center</a> w celu uzyskania więcej informacji dotyczących diagnozowania problemów i pomocy technicznej.',
        'PROBLEMS_SIGNING_UP_OR_SIGNING_IN' => 'Problemy z zapisaniem się lub rejestracją',
        'WE_SENT_YOU_EMAIL' => 'Wysłaliśmy wiadomość e-mail zawierającą łącza do resetowania hasła.',
        'RESET_PASSWORD_EMAIL_SUBJECT' => 'Resetowanie hasła',
        'RESET_PASSWORD_EMAIL_BODY' => '%1$s,

Otrzymaliśmy prośbę o zmianę Twojego hasła w %2$s.

Kliknij poniższe łącze w celu ustawienia nowego hasła:

#{URL}

Jeśli nie chcesz zmienić swojego hasła, możesz zignorować tę wiadomość e-mail.

Dziękujemy,
Zespół "%2$s"

-----
%2$s używa identyfikatora Ning w celu uwierzytelniania użytkowników.',
        'SET_PASSWORD' => 'Ustaw hasło',
        'NEW_PASSWORD' => 'Nowe hasło',
        'CREATE_NEW_PASSWORD' => 'Utwórz nowe hasło',
        'CHOOSE_NEW_PASSWORD' => 'Wybierz nowe hasło',
        'HELLO_USERNAME_SIGN_OUT' => '<strong>Witamy, %s</strong> (<a %s>Wyrejestruj się</a>)',
        'NO_ACCOUNT_WITH_EMAIL_X' => 'Nie ma konta z adresem e-mail %s',
        'PLEASE_ENTER_CODE' => 'Wprowadź kod znajdujący się po prawej stronie.',
        'PROBLEMS_SIGNING_UP' => 'Problemy z rejestracją?',
        'BY_SIGNING_UP_YOU_AGREE' => 'Rejestracja oznacza akceptację <a %s>Warunków użytkowania</a> oraz <a %s> polityki &nbsp; prywatności </a>.',
        'FEEDBACK' => 'Opinia',
        'TERMS_OF_SERVICE' => 'Warunki użytkowania',
        'PROBLEM_SIGNING_UP' => 'Wystąpił problem podczas rejestracji',
        'ALREADY_MEMBER_SIGN_IN' => 'Czy jesteś członkiem?  <a %s>Kliknij tutaj, aby się zarejestrować</a>.',
        'MEMBERSHIP_TO_APPNAME_BY_INVITATION_ONLY' => 'Członkostwo w %s jest możliwe jedynie przez zaproszenie',
        'SORRY_BUT_ADMINISTRATOR_REQUIRES_INVITATION' => 'Przepraszamy, ale za postanowieniem administratora, wymagane jest zaproszenie w celu przyłączenia się do %s.  Jeżeli posiadasz zaproszenie, kliknij łącze w wiadomości e-mail w celu przyłączenia się.',
        'PROBLEM_SIGNING_IN' => 'Wystąpił problem z rejestracją',
        'WE_USE_NING_ID' => 'Używamy identyfikatora Ning w celu uwierzytelniania użytkowników.  <a %s>Co to jest identyfikator Ning? </a>',
        'PROBLEMS_SIGNING_IN' => 'Problemy z rejestracją?',
        'SIGN_IN_OR_SIGN_UP' => '<input %s value="Zarejestruj się" /> &#160; lub&#160;  <strong><a %s>Zapisz się</a></strong>',
        'SIGN_IN_TO_APPNAME' => 'Zapisz się do %s',
        'WHAT_IS_A_NING_ID' => 'Co to jest identyfikator Ning?',
        'LARR_BACK' => '←  <a %s>Powrót</a>',
        'NING_ID_LETS_YOU_CHOOSE' => 'System identyfikacji Ning pozwala na jednorazowe wybranie adresu e-mail oraz hasła i używanie ich w celu przyłączenia się lub zapisania do jakiejkolwiek sieci społecznej korzystającej z identyfikatora Ning.',
        'WHEN_YOU_CREATE_NING_ID' => 'W czasie tworzenia identyfikatora Ning, możesz również dodać do swojego konta Ning podstawowe informacje i zdjęcie.  Informacje te są następnie wpisywane za każdym razem, gdy przyłączasz się do nowej sieci społecznej używającej identyfikatora Ning, w celu uwierzytelniania użytkowników.  Umożliwia to również utrzymywanie kontaktu z przyjaciółmi i śledzenie wiadomości we wszystkich sieciach społecznych, które z niego korzystają.',
        'SIGN_IN_WITH_NING_ID_WHENEVER' => 'Możesz się zarejestrować przy użyciu swojego adresu e-mail Ning i hasła, kiedykolwiek zobaczysz ten symbol: %s',
        'HELLO_USER' => 'Witamy, %s',
        'TEXT_FOR_HEADER_TAB' => 'Ten tekst jest przeznaczony dla części nagłówkowej',
        'BASED_ON' => 'W oparciu o',
        'ARE_YOU_SURE_DELETE_LANGUAGE' => 'Czy na pewno chcesz usunąć ten język?',
        'DELETE_LANGUAGE' => 'Usuń język',
        'TEXT_RESET_TO_ORIGINAL_VERSION' => 'Tekst został zresetowany do wersji oryginalnej.',
        'UPLOAD_LANGUAGE_FILE' => 'Przekaż plik językowy',
        'ADD_TO_LANGUAGE' => 'Dodaj do języka:',
        'IF_YOU_CREATED_TRANSLATION' => 'Jeżeli wykonałeś nowe tłumaczenie w innej sieci społecznej Ning, możesz tutaj zaimportować swoją pracę.  Zawartość pliku będzie dodana do języka, który wybierzesz.  Twój język nie figuruje na liście?  <a %s>Można łatwo dodać nowy</a>.',
        'EXAMPLES_SWEDISH_FINLAND' => 'Przykłady: szwedzki (Finlandia), filipiński, hiszpański (Portoryko)',
        'START_FROM_SCRATCH_CREATE' => 'Zacznij od nowa!  Wykonaj nowe tłumaczenie dla swojej sieci - podaj nazwę nowego języka oraz język, który ma posłużyć jako źródło tłumaczenia.',
        'KEY_MISSING_TEXT' => 'Wpisz: <span %s>Brakujący tekst</span> <span %s>Zmieniony tekst</span>',
        'SHOW_ALL_TEXT' => 'Pokaż cały tekst',
        'SHOW_MISSING_TEXT' => 'Pokaż brakujący tekst',
        'SHOW_CHANGED_TEXT' => 'Pokaż zmieniony tekst',
        'EXAMPLES_TABS_MEMBERS_FRIENDS' => 'Przykłady: Zakładki, Członkowie, Przyjaciele',
        'RESET_TEXT_TO_ORIGINAL_VERSION' => 'Zresetuj tekst do wersji oryginalnej',
        'ORIGINAL_TEXT_X' => 'Tekst oryginalny ・%s',
        'EDIT_LANGUAGE_ON_NETWORK' => 'Edytuj język w Twojej sieci',
        'CUSTOMIZE_TEXT_ON_NETWORK_INCLUDING' => 'Dostosuj do własnych potrzeb jakikolwiek tekst w Twojej sieci, łącznie z nazwami zakładek, stopek wiadomości e-mail, komunikatów o błędzie i innych elementów.',
        'ACTIVE_LANGUAGE_IS_X' => '<em>Językiem aktywnym dla Twojej sieci jest %1$s</em>.  <a %2$s>Zmień aktywny język</a>',
        'CURRENT_LANGUAGE_OPTIONS' => 'Aktualne opcje językowe',
        'ACTIVE' => 'Aktywny',
        'MY_LANGUAGES' => 'Moje języki',
        'CREATE_NEW_TRANSLATION' => 'Wykonaj nowe tłumaczenie',
        'DONT_SEE_LANGUAGE_LISTED_CREATE' => 'Twój język nie figuruje na powyższej liście?  <strong><a %s>Wykonaj nowe tłumaczenie dla Twojej sieci</a></strong>.',
        'ADVANCED_IMPORT' => 'Import zaawansowany',
        'IF_YOU_TRANSLATED_A_LANGUAGE' => 'Jeżeli przetłumaczyłeś język w istniejącej sieci społecznej, możesz <strong><a %s>zaimportować swój plik językowy</a></strong> i użyć go w tej sieci.',
        'LANGUAGE_EDITOR' => 'Edytor języka',
        'PUBLIC' => 'Publiczne',
        'GRANDFATHERED_PRIVACY_SETTING' => 'Twoje aktualne ustawienia dotyczące prywatności - sieć publiczna, gdzie osoby niebędące członkami mogą widzieć jedynie ekran logowania, nie są już dostępne.   Twoje ustawienie dotyczące prywatności nie zostało zmienione, ale jeśli dokonasz tutaj jakichkolwiek zmian, nie będziesz mógł wrócić do poprzednich ustawień.   Aktualnym odpowiednikiem jest prywatna sieć, do której każdy może się zapisać i zostać członkiem.',
        'NO_MISSING_ITEMS' => 'Nie ma brakujących elementów  ・to tłumaczenie jest w 100%% zakończone.  <a %s>Przejrzyj wszystkie elementy. </a>',
        'NO_CHANGED_ITEMS' => 'Brak zmienionych elementów.',
        'COULD_NOT_FIND_ITEMS_MATCHING' => 'Przepraszamy  ・nie mogliśmy znaleźć żadnych pasujących elementów <em>%s</em>.  <a %s>Przejrzyj wszystkie elementy. </a>',
        'FILE_N' => '%s',
        'TRANSLATION_FILE_HAS_FILENAME_LIKE' => 'Plik tłumaczeniowy Ning ma nazwę <code>en_US. txt</code>.  <a %s>Dowiedz się więcej tutaj. </a>',
        'SELECT_TRANSLATION_FILE' => 'Wybierz plik tłumaczenia:',
        'USE_THIS_TRANSLATION' => 'Użyj tego tłumaczenia',
        'FOLLOWING_ARE_MISSING_FROM_RULES' => 'Zauważ, że w poniższych regułach brakuje następujących elementów: %s',
        'ALL' => 'Wszystkie',
        'MISSING' => 'Brakujące',
        'VIEW' => 'Widok',
        'TRANSLATION_CHANGES_SAVED' => 'Zmiany zostały zapisane.  To tłumaczenie jest %s%% skończone.',
        'TRANSLATION_CHANGES_SAVED_MAKE_CURRENT' => 'Zmiany zostały zapisane.  To tłumaczenie jest %s%% skończone.  Czy chciałbyś użyć tego języka jako aktualnego języka dla Twojej sieci?',
        'TRANSLATION_UPLOAD_SUCCESSFUL' => 'Przekazywanie zostało zakończone pomyślnie.  To tłumaczenie jest %s%% skończone.',
        'TRANSLATION_UPLOAD_SUCCESSFUL_MAKE_CURRENT' => 'Przekazywanie zostało zakończone pomyślnie.  To tłumaczenie jest %s%% skończone.  Czy chciałbyś użyć tego języka jako aktualnego języka dla Twojej sieci?',
        'X_IS_CURRENT_LANGUAGE' => '%s jest teraz językiem Twojej sieci.',
        'SAVE_PAGE' => 'Zapisz stronę',
        'LANGUAGE_NAME_TAKEN' => 'Przepraszamy - ta nazwa już istnieje.  Wybierz inną nazwę.',
        'ENTER_NAME_FOR_TRANSLATION' => 'Wprowadź nazwę dla swojego nowego tłumaczenia, np. portugalski (Portugalia)',
        'CREATE' => 'Utwórz',
        'LANGUAGE_NAME' => 'Nazwa języka',
        'SAVE_ITEMS_ON_PAGE' => 'Zapisz elementy na tej stronie',
        'NEW_TRANSLATION' => 'Nowe tłumaczenie',
        'MISMATCHED_CURLY_BRACKETS' => 'Niedopasowane nawiasy klamrowe',
        'MISMATCHED_SQUARE_BRACKETS' => 'Niedopasowane nawiasy kwadratowe',
        'MISMATCHED_PARENTHESES' => 'Niedopasowane nawiasy okrągłe',
        'ERROR_PROCESSING_SPECIAL_RULES' => 'Nastąpił błąd w czasie przetwarzania kodu dotyczącego specjalnych reguł.',
        'ERROR_PROCESSING_TAB_NAMES' => 'Nastąpił błąd w czasie przetwarzania kodu dotyczącego nazw zakładek.',
        'SPECIAL_RULES' => 'Specjalne reguły',
        'TAB_NAMES' => 'Nazwy zakładek',
        'SOURCE' => 'Źródło',
        'LANGUAGE_EDITOR_X' => 'Edytor języka: %s',
        'BACK_TO_LANGUAGE_EDITOR' => '←  Wróć do edytora języka',
        'CUSTOMIZE_YOUR_NETWORKS_TEXT' => 'Dostosuj do swoich potrzeb tekst i komunikaty sieci lub utwórz nowy język.',
        'STOPWORDS' => 'o | są | jak | jako | w | przy | u | na | com | de | en | dla | do | z | jak | i | jest | ta | przed | po | lub | albo | że | za | ten | to | był | co | kiedy | gdzie | kto | będzie | wraz | oraz | tamta | www',
        'STOPWORDS_ARE' => '<a %s>Słowa przestankowe</a> stanowią opcjonalną listę słów wyławianych z opisu sieci w czasie tworzenia znacznika meta na górze każdej strony.  Opcjonalne.',
        'I_AM_MEMBER' => 'Jestem członkiem:',
        'VIEW_PAGE_ON_APPNAME' => 'Przejrzyj moją stronę na <em>%s</em>',
        'VISIT_APPNAME' => 'Odwiedź <em>%s</em>',
        'JOIN_US' => 'Przyłącz się',
        'CREATED_BY_COLON' => 'Utworzone przez:',
        'GET_MORE_BADGES' => 'Zdobądź więcej oznaczeń',
        'SHOW_LOGO' => 'Pokaż logo',
        'GALLERY' => 'Galeria',
        'BADGES' => 'Oznaczenia',
        'MEMBER_BADGE' => 'Oznaczenie uczestnika',
        'WEAR_IT_WITH_PRIDE' => 'Noś je z dumą!  Zdobądź oznaczenie członka %s, które możesz wyświetlić na swojej stronie internetowej lub na stronie  MySpace.',
        'NETWORK_BADGE_LARGE' => 'Oznaczenie sieci (duże)',
        'SPREAD_THE_WORD_NETWORK_BADGE_LARGE' => 'Rozgłoś wiadomość!  Zdobądź oznaczenie %s, które czynnie uaktualnia informacje dotyczące najbardziej popularnych członków sieci. Dodaj je do swojej strony lub strony MySpace.',
        'NETWORK_BADGE_SMALL' => 'Oznaczenie sieci (małe)',
        'SPREAD_THE_WORD_NETWORK_BADGE_SMALL' => 'Rozgłoś wiadomość!  Zdobądź oznaczenie %s, które możesz wyświetlić na swojej stronie internetowej lub na stronie MySpace.',
        'PHOTO_SLIDESHOW_PROPER' => 'Pokaz slajdów',
        'DISPLAY_SELECTION_OF_PHOTOS' => 'Wyświetl wybrane zdjęcia na stronieinternetowej lub na stronie MySpace za pomocą naszego doskonałego odtwarzacza do pokazu slajdów.',
        'MUSIC_PLAYER' => 'Odtwarzacz plików muzycznych',
        'PLAY_MUSIC_ON_WEBSITE' => 'Odtwórz muzykę na swojej stronie internetowej lub stronie MySpace za pomocą naszego doskonałego odtwarzacza plików muzycznych.',
        'ADD_A_VIDEO_MORE_OPTIONS' => 'Dodaj plik wideo do swojej strony lub strony MySpace.  Potrzebujesz więcej opcji?  <a href="%s">Przejrzyj wszystkie pliki wideo</a> w %s.',
        'LARGE_N_PIXELS_WIDE' => 'Duże – szerokość %d pikseli',
        'MEDIUM_N_PIXELS_WIDE' => 'Średnie – szerokość %d pikseli',
        'SMALL_N_PIXELS_WIDE' => 'Małe – szerokość %d pikseli',
        'MY_MOST_RECENT' => 'Moje najnowsze',
        'APP_ICON' => 'Ikona App',
        'MEMBERSHIP_TO_X_IS_BY_INVITATION' => 'Członkostwo w %s jest możliwe jedynie przez zaproszenie',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK' => '%s przedstawił następującą opinię:',
        'X_PROVIDED_FEEDBACK_ON_Y_ELLIPSIS' => '%1$s przedstawił opinię dotyczącą %2$s...',
        'THANK_YOU_YOUR_MESSAGE_HAS_BEEN_SENT' => 'Dziękujemy.   Twoja wiadomość została wysłana.',
        'X_WOULD_LIKE_TO_JOIN_X' => '%s chciałby przyłączyć się do %s!',
        'X_HAS_REQUESTED_AN_INVITATION' => '%s poprosił o zaproszenie do %s',
        'YOUR_REQUEST_HAS_BEEN_SENT' => 'Twoja prośba została przesłana do autora sieci.',
        'TO_UNBAN_USERNAME_GO_TO' => 'Aby odblokować %s, przejdź do:',
        'SEND_REQUEST' => 'Wyślij prośbę',
        'SEARCH' => 'Wyszukaj',
        'SEARCH_AGAIN' => 'Wyszukaj ponownie',
        'SEND_BROADCAST_MESSAGE' => 'Wyślij komunikat emisji',
        'VERIFICATION_IMAGE' => 'Kod weryfikacyjny z obrazka',
        'UNDER_CONSTRUCTION' => 'W trakcie budowy',
        'PROFILE_INFORMATION_SAVED' => 'Informacja o profilu została zapisana',
        'YOUR_SITES_DIRECTORY_PROFILE' => 'Informacja o profilu  w katalogu sieci została zapisana.',
        'NO_ACCOUNT_WITH_EMAIL' => 'Brak konta z tym adresem e-mail.',
        'INVALID_PASSWORD_CHECK_CAPS_LOCK' => 'Nieprawidłowe hasło.   Czy klawisz Caps Lock jest włączony?',
        'OOPS_THAT' => 'Niestety ・nie udało się.',
        'OOPS_THAT_DID_NOT_WORK' => 'Niestety ・nie udało się.   Chcesz spróbować ponownie?',
        'OOPS_THAT_DID_NOT_WORK_ERROR_CODE' => 'Niestety ・nie udało się (%s).',
        'NOT_FOUND' => 'Nie znaleziono',
        'YOUR_SITES_FEATURE_LIST' => 'Lista funkcji Twojej sieci została zapisana.',
        'ONE_LINE_ANSWER' => 'Odpowiedź w jednym wierszu',
        'LONGER_ANSWER' => 'Dłuższa odpowiedź',
        'MULTIPLE_CHOICE' => 'Wielokrotny wybór',
        'DATE' => 'Data',
        'WEBSITE_ADDRESS' => 'Adres strony internetowej',
        'EVERYTHING' => 'Wszystko',
        'JUST_THE_HOMEPAGE' => 'Tylko strona główna',
        'JUST_THE_SIGN_UP_PAGE' => 'Tylko strona rejestracji',
        'YOUR_CHANGES_HAVE_BEEN_SAVED' => 'Zmiany zostały zapisane.',
        'JOIN_ME_ON_X' => 'Przyłącz się do %s!',
        'NOT_ALLOWED' => 'Niedozwolone',
        'COME_JOIN_ME_ON_X_ELLIPSIS' => 'Przyłącz się do %s...',
        'X_NOT_VALID_EMAIL' => '%s nie jest prawidłowym adresem e-mail lub identyfikatorem Ning',
        'USER_BANNED_FROM_NETWORK' => '%1$s został zablokowany w tej sieci.  <a %2$s>Wyślij %1$s komunikat</a>',
        'USER_ALREADY_NETWORK_MEMBER' => '%1$s jest już członkiem tej sieci.  <a %2$s>Wyślij %1$s komunikat</a>',
        'YOU_CAN_SEND_AT_MOST_X' => 'Możesz wysłać najwyżej %s od razu.',
        'PLEASE_ENTER_YOUR_FRIENDS' => 'Wprowadź adresy e-mail swoich przyjaciół lub identyfikatory Ning',
        'THERE_HAS_BEEN_AN_ERROR' => 'Wystąpił błąd',
        'INVITATIONS_HAVE_BEEN_SENT' => 'Twoje zaproszenia zostały wysłane.',
        'SEARCH_RESULTS' => 'Wyniki wyszukiwania',
        'INVITE_YOUR_FRIENDS' => 'Zaproś swoich przyjaciół',
        'SEND_INVITATIONS_FOR_FRIENDS' => 'Wyślij zaproszenia do swoich przyjaciół, aby przyłączyli się do',
        'INVITATION' => 'Zaproszenie',
        'ADD_FROM_ADDRESS' => 'Dodaj z książki adresowej',
        'TO' => 'Do:',
        'SEND_TO' => 'Wyślij do',
        'SUBJECT' => 'Temat',
        'YOUR_MESSAGE' => 'Twój komunikat',
        'SEND' => 'Wyślij',
        'REPORT_AN_ISSUE' => 'Zgłoś problem',
        'TYPE_OF_ISSUE' => 'Rodzaj problemu',
        'ADULT' => 'Dla dorosłych',
        'ABUSIVE' => 'Obelżywa treść',
        'BUG' => 'Usterka',
        'FRAUD' => 'Oszustwo',
        'SPAM' => 'Spam',
        'OTHER' => 'Inne',
        'DESCRIBE_YOUR_ISSUE' => 'Opisz problem',
        'SEND_REPORT' => 'Wyślij raport',
        'ADDED_BY_X_AT_X' => 'Dodane przez <a %s>%s</a> w %s w dniu %s',
        'ADDED_BY_USER_TO_GROUP_AT_DATE' => 'Dodane przez <a %s>%s</a> do %s w %s w dniu %s',
        'G_IA' => 'g:ia',
        'F_JS_Y' => 'F jS, Y',
        'CLICK_TO_VIEW' => 'Kliknij, aby przejrzeć',
        'COMMENT_FOR' => 'Komentarz dla:',
        'COMMENT_ON' => 'Komentarz na temat:',
        'ACTION_BUTTON_FEATURE' => 'Funkcja',
        'FEATURE_THIS_ON_YOUR' => 'Zamieść to na stronie głównej',
        'ACTION_BUTTON_REMOVE' => 'Usuń',
        'REMOVE' => 'Usuń',
        'REMOVE_THIS_FROM_YOUR' => 'Usuń to ze strony głównej',
        'FEATURE_ON_HOME' => 'Zamieść na stronie głównej',
        'REMOVE_FROM_HOME' => 'Usuń ze strony głównej',
        'ITEM_WILL_APPEAR' => 'Ten element ukaże się teraz w wybranych modułach na stronie głównej',
        'ITEM_WILL_NO_LONGER_APPEAR' => 'Ten element nie będzie już się ukazywał w wybranych modułach na stronie głównej',
        'ADD_CONTENT' => 'Dodaj zawartość',
        'BROUGHT_TO_YOU_BY' => '%s zaprezentowane przez %s © %s',
        'GIVE_US_YOUR_FEEDBACK' => 'Przekaż nam swoją opinię',
        'FOR_ADDITIONAL_QUESTIONS_OR_TO_CONTACT_NING_PLEASE_CLICK_HERE' => 'W razie dodatkowych pytań lub w celu skontaktowania się z Ning, kliknij tutaj:',
        'SEND_FEEDBACK' => 'Wyślij opinię',
        'SIGN_OUT' => 'wyrejestruj',
        'SIGN_OUT_TITLE' => 'Wyrejestruj',
        'EDIT_MY_PROFILE' => 'Edytuj pytania dotyczące profilu',
        'INVITE_MORE' => 'Zaproś więcej',
        'USE_THIS_FORM_TO_SEND_FEEDBACK_TO_NC' => 'Użyj tego formularza w celu wysłania opinii do <a %s>%s</a>, autora <a %s>%s</a>.',
        'YOUR_FEEDBACK' => 'Twoja opinia',
        'NETWORK_INFORMATION' => 'Informacja o sieci',
        'ABOUT_YOUR_SITE' => 'Informacja o Twojej sieci',
        'WELCOME_TO_YOUR_SITE' => 'Witamy w Twojej sieci społecznej!',
        'EDIT_YOUR_NETWORKS_INFO' => 'Edytuj swoją nazwę sieci, opis i inne informacje.',
        'TAGLINE' => 'Slogan',
        'APPEARS_IN_HEADER' => 'Ukazuje się w nagłówku Twojej sieci',
        'APPEARS_IN_EMAILS' => 'Ukazuje się w wiadomościach e-mail i gdzie indziej',
        'NETWORK_NAME' => 'Nazwa sieci',
        'DESCRIPTION' => 'Opis',
        'KEYWORDS' => 'Słowa kluczowe',
        'LANGUAGE' => 'Język',
        'SEPARATE_EACH_KEYWORD' => 'Rozdziel każde słowo kluczowe przecinkiem',
        'ICON' => 'Ikona',
        'UPLOAD_A_PHOTO_WHICH_WILL_BE_RESIZED' => 'Przekaż zdjęcie (GIF, JPG lub PNG), które będzie przeskalowane do rozmiaru kwadratu.  Wyświetlenie zdjęcia może potrwać kilka minut.',
        'SAVE_SETTINGS' => 'Zapisz Ustawienia',
        'SUCCESS_EXCLAMATION' => 'Zadanie wykonane pomyślnie!',
        'FEATURES' => 'Funkcje',
        'ADD_FEATURES' => 'Dodaj Funkcje do swojej sieci',
        'ORGANIZE_FEATURES' => 'Organizuj główną stronę przeciągając funkcje z poniższej listy, następnie rozmieszczając je w dowolny sposób.',
        'SKIP_FEATURES' => 'Kliknij przycisk <a href="%s">Pomiń ten krok</a>, aby kontynuować z układem i funkcjami domyślnymi.',
        'FEATURES_FOR_ALL_PAGES' => 'Funkcje dodane do tego okna pojawią się na wszystkich stronach Twojej sieci.',
        'CUSTOMIZE_SITE_BY_ADDING' => 'Dostosuj sieć społeczną dodając nowe funkcje lub usuwając już istniejące.',
        'ADJUST_YOUR_SITES_COLORS' => 'Dostosuj kolory, obrazy i ogólny styl sieci.',
        'APPEARANCE' => 'Wygląd',
        'PROFILE_QUESTIONS' => 'Pytania profilowe',
        'EDIT_QUESTIONS_THAT_MEMBERS_ANSWER' => 'Edytuj pytania, na które uczestnicy odpowiadają mówiąc o sobie.',
        'MESSAGE_SENT' => 'Wiadomość wysłana!',
        'YOUR_MESSAGE_HAS_BEEN_SENT' => 'Twoja wiadomość została wysłana do wszystkich uczestników sieci.',
        'YOUR_MESSAGE_HAS_BEEN_SENT_GROUP' => 'Twoja wiadomość została wysłana do wszystkich uczestników grupy.',
        'YOUR_MESSAGE_IS_BEING_SENT' => 'Trwa wysyłanie wiadomości.  Prosimy poczekać, operacja może potrwać kilka minut.',
        'BROADCAST_MESSAGE' => 'Komunikat emisji',
        'TRACK_VISITORS_AND_TRENDS' => 'Śledź gości i tendencje swojej sieci społecznej.',
        'EDIT_SOURCE_CODE' => 'Edytuj kod źródłowy',
        'TAKE_FULL_CONTROL' => 'Kontroluj działanie sieci edytując kod źródłowy.',
        'DELETE_THIS_SITE' => 'Usuń swoją sieć społeczną',
        'MAIN_PAGE' => 'Strona główna',
        'MAIN' => 'Strona główna',
        'MAIN_TAB_TEXT' => 'Stona główna',
        'MANAGE' => 'Zarządzaj',
        'MANAGE_TAB_TEXT' => 'Zarządzaj',
        'PAGE_TITLE' => 'Tytuł strony',
        'LOREM_IPSUM_1' => 'Lorem <span %s>ipsum dolor</span> sit amet, consectetuer adipiscing elit.  Nunc scelerisque blandit dolor.  Vestibulum ante ipsum primis in faucibus orci luctus.',
        'LOREM_IPSUM_2' => 'Lorem ipsum dolor sit amet, consectetuer adipiscing',
        'LOREM_IPSUM_3' => 'Lorem ipsum dolor sit amet, <span class="preview_link">consectetuer</span> adipiscing',
        'EDIT_THE_APPEARANCE' => 'Edytuj wygląd swojej strony',
        'CHOOSE_A_THEME' => 'Wybierz kompozycję swojej sieci społecznej',
        'NOW_CUSTOMIZE_SITE' => 'Teraz dostosuj swoją sieć społeczną...',
        'THEME_SETTINGS' => 'Ustawienia kompozycji',
        'ADVANCED' => 'Zaawansowane',
        'TOP_BAR_AND_FOOTER' => 'Górny pasek i stopka',
        'HEADER_AND_NAVIGATION' => 'Nagłówek i nawigacja',
        'ADD_A_LOGO' => 'Dodaj logo',
        'THIS_IMAGE_WILL_REPLACE' => 'Ten obraz zastąpi tekst nazwy sieci',
        'TABS' => 'Karty',
        'TAB' => 'Karta',
        'SITE' => 'Sieć',
        'SIDES' => 'Strony',
        'BODY' => 'Treść',
        'SHOW_NING_LOGO' => 'Pokazać logo Ning?',
        'LAUNCH' => 'URUCHOM!',
        'NING_ID' => 'ID Ning',
        'PASSWORD' => 'Hasło',
        'RETYPE_PASSWORD' => 'Wpisz ponownie hasło',
        'TYPE_CODE_ON_RIGHT' => 'Wpisz kod<br />po prawej stronie',
        'JOIN_X' => 'Dołącz do %s',
        'SIGN_UP_FOR_X' => 'Zapisz się w %s',
        'HAS_INVITED_YOU_TO_X' => 'zaprosił/a Cię, abyś dołączył do %s.',
        'CONTENT_AWAITING_APPROVAL' => 'Oczekiwanie na zatwierdzenie',
        'NEW_MEMBER' => 'Nowy uczestnik?',
        'JOIN_X_NOW' => 'Dołącz do %s teraz!',
        'HIDE_THIS_MESSAGE' => 'Ukryj tę wiadomość',
        'PAGE_NOT_FOUND' => 'Nie odnaleziono strony',
        'THIS_PAGE_WAS_NOT_FOUND' => 'Przepraszamy ・nie znaleziono tej strony',
        'FOLLOW_THESE_LINKS_TO' => 'Użyj tych łączy do kilku potwierdzonych stron:',
        'ALTERNATIVELY_YOU_CAN_SEARCH' => 'Możesz też przeszukać tę sieć społeczną:',
        'IF_YOU_GET_THIS_MESSAGE' => 'Jeśli otrzymasz ponownie tę informację, <a %s>poinformuj nas o tym. </a>',
        'GROUP_MEMBERS' => 'Uczestnicy grupy',
        'VIDEOS' => 'Wideo',
        'BLOG' => 'Blog',
        'ACCOUNT' => 'Konto',
        'WE_ARE_SORRY_WE_ARE_HAVING' => 'Przepraszamy, wystąpił problem z tą stroną.',
        'FOLLOW_LINK_TO_HOMEPAGE' => 'Użyj <a %s>tego łącza</a> do głównej strony.',
        'REQUEST_AN_INVITATION' => 'Poproś o zaproszenie',
        'NAME' => 'Imię i nazwisko:',
        'EMAIL_ADDRESS' => 'Adres e-mail',
        'MESSAGE_OPTIONAL' => 'Wiadomość (opcja)',
        'SORRY_HOWEVER_ITS_EASY' => '<strong>Przepraszamy! </strong>  Łatwo jest jednak uruchomić własną sieć społeczną.',
        'GET_YOUR_OWN_BAZEL' => 'Utwórz własną sieć społeczną!',
        'SITE_IS_NOT_READY' => 'Ta sieć społeczna nie jest jeszcze gotowa!',
        'BAZEL_IS_BEING_SET_UP' => 'Ta sieć społeczna jest wciąż tworzona!',
        'SIGN_IN' => 'Zarejestruj',
        'FORGOT_YOUR_PASSWORD' => 'Zapomniałeś hasła?',
        'FORGOT_YOUR_PASSWORD_TITLE' => 'Zapomniałeś hasła?',
        'ENTER_EMAIL_AND_CLICK_RESET_PASSWORD' => 'Wprowadź swój adres e-mail i kliknij \'Resetuj hasło\'.  Otrzymasz wiadomość e-mail z łączem, aby zresetować swoje hasło.',
        'RESET_PASSWORD' => 'Resetuj hasło',
        'EXPLORE' => 'Eksploruj',
        'SIGN_UP' => 'Zapisz się',
        'CONFIRM_PASSWORD' => 'Potwierdź hasło',
        'VERIFICATION' => 'Potwierdź, że jesteś <br />tą osobą',
        'YOUR_PHOTO' => 'Twoje zdjęcie',
        'SUMMARY' => 'Podsumowanie',
        'YOUR_SITE_IS_READY' => 'Twoja sieć społeczna jest gotowa do uruchomienia!   Dla wszystkich pominiętych przez Ciebie kroków zostaną zastosowane ustawienia domyślne.  Wróć, aby dokonać zmian lub kliknij \'Uruchom! \', aby uruchomić swoją sieć.',
        'WHEN_YOU_ARE_FINISHED' => 'Po zakończeniu kliknij \\Przeglądaj układ\', aby zobaczyć swoje dzieło!',
        'COMPLETE' => 'zakończony',
        'INCOMPLETE' => 'niezakończony',
        'VIEW_LAYOUT' => 'Przeglądaj układ',
        'CLEAR_CONTENTS' => 'Wyczyść zawartość',
        'ADD_MODULE' => 'Dodaj moduł...',
        'ADD_COLUMNS' => 'Dodaj kolumny...',
        'PUBLIC_ANYBODY_CAN_JOIN' => '<strong>Publiczny</strong> ・Każdy może dołączyć',
        'PRIVATE_ONLY_INVITED' => '<strong>Prywatny</strong> ・Tylko osoby zaproszone mogą przeglądać i dołączyć',
        'INVITATIONS' => 'Zaproszenia',
        'MEMBERS_CAN_INVITE' => 'Uczestnicy mogą zapraszać innych do przyłączenia się.',
        'QUESTION_TITLE' => 'Tytuł pytania',
        'ANSWER_TYPE' => 'Rodzaj odpowiedzi',
        'REQUIRED' => 'Wymagana',
        'PRIVATE' => 'Prywatna',
        'CHOICES' => 'Wybory',
        'SEPARATE_EACH_CHOICE' => 'Oddzielaj każdy wybór przecinkiem',
        'CAN_PICK_MORE' => 'Można wybrać więcej niż jeden',
        'ADD_ANOTHER_QUESTION' => 'Dodaj kolejne pytanie',
        'WHAT_INFORMATION' => 'Na jakie pytania mają odpowiedzieć uczestnicy, gdy dołączają do Twojej sieci?  Możesz poniżej zmienić kolejność pytań.  Po prostu kliknij pytanie i przeciągnij je tam, gdzie chcesz, żeby było.',
        'IF_YOU_SELECT_REQUIRED_MEMBERS_WILL' => 'Jeśli wybierzesz opcję "Wymagana", uczestnicy będą musieli odpowiedzieć na pytanie, aby dołączyć.  Jeśli wybierzesz opcję "Prywatna", odpowiedź będzie widoczna tylko dla Ciebie i innych administratorów.',
        'WE_COULD_NOT_FIND_ANYTHING' => 'Nie mogliśmy znaleźć niczego, co odpowiada "%s".  Chcesz odszukać coś innego?',
        'GET_CUSTOM_URL' => 'Zdobądź swój własny adres URL, dodaj miejsce przechowywania i przepustowość lub uruchom własne reklamy.',
        'VIEW_STATISTICS' => 'Przeglądaj Statystyki',
        'ADD_TRACKING_CODE' => '<a %s>Dodaj własny kod śledzenia</a>.',
        'TRACKING_CODE' => 'Kod śledzenia',
        'ANY_JAVASCRIPT_CODE' => 'Każdy kod JavaScript, który wklejasz tutaj jest  umieszczany na dole każdej strony Twojej sieci.  Można tego używać do systemów zewnętrznego szukania strony, jak program Google Analytics.',
        'ANALYTICS_LEARN_MORE' => 'Aby dowiedzieć się więcej na temat programu Google Analytics i skonfigurować swoje konto, <a %s>kliknij tutaj</a>.',
        'RESOURCES' => 'Zasoby',
        'LINKS' => 'Łącza',
        'PAGE' => 'Strona',
        'BACKGROUND' => 'Tło',
        'TEXT' => 'Tekst',
        'HEADING_TEXT' => 'Tekst nagłówka',
        'FONT' => 'Czcionka',
        'AABBCC' => 'AaBbCc',
        'COLOR' => 'Kolor',
        'LINK_COLOR' => 'Kolor łącza',
        'BODY_TEXT' => 'Tekst podstawowy',
        'MIDDLE' => 'Środek',
        'FEATURE_BOXES' => 'Pola funkcji',
        'TITLEBAR_TEXT_COLOR' => 'Kolor tekstu paska tytułu',
        'TITLEBAR_BACKGROUND' => 'Tło paska tytułu',
        'UPLOADING_CONTENT' => 'Przekazywanie zawartości...',
        'WHEN_UPLOADING_IS_COMPLETE' => 'Po zakończeniu przekazywania można sprawdzić sieć.',
        'FINISH' => 'Zakończ',
        'FLICKR_IMPORT_SETUP' => 'Konfiguracja importowania z programu Flickr',
        'FLICKR_API_KEY' => 'Twój klucz',
        'FLICKR_SECRET' => 'Twój sekret',
        'FLICKR_KEY_ERROR' => 'Wystąpił błąd wprowadzonego przez Ciebie klucza lub sekretu programu Flickr.   Sprawdź i wprowadź je ponownie',
        'FLICKR_INTRO' => 'Chcesz, aby Twoi uczestnicy importowali swoje zdjęcia z programu Flickr?  Trafiłeś w odpowiednie miejsce.  Jeśli masz już klucz i sekret API programu Flickr API, możesz <a %s>przejść dalej</a>.  Nie jesteś pewny co to znaczy?  Postępuj zgodnie z poniższymi krokami, a w ciągu kilka minut zarejestrujesz się i zaczniesz pracę.',
        'FLICKR_GET_ACCOUNT' => 'Jeśli nie masz jeszcze konta w programie Flickr, pobierz go <a %s>tutaj</a>.',
        'FLICKR_STEP1_TITLE' => 'Krok 1: Pobierz klucz API programu Flickr',
        'FLICKR_STEP1_APPLY_SCREEN' => 'Poproś o swój ekran klucza API w programie Flickr',
        'FLICKR_STEP1_API_SCREEN' => 'Ekran klucza API w programie Flickr',
        'FLICKR_STEP1_INTRO' => 'Zaloguj się do programu Flickr i<a %s>poproś o nowy klucz API</a> (otwiera się w nowym oknie).',
        'FLICKR_STEP1_A' => 'Wpisz <strong>imię i nazwisko:</strong> oraz <strong>adres e-mail</strong>.',
        'FLICKR_STEP1_B' => 'W opcji <strong>Ten klucz jest do&hellip; </strong> wybierz <em>zastosowanie niekomercyjne</em>.',
        'FLICKR_STEP1_C' => 'Opisz swoją sieć społeczną w polu <strong>Opisz aplikację, którą chcesz utworzyć</strong>.',
        'FLICKR_STEP1_D' => 'Zaznacz oba pola wyboru.',
        'FLICKR_STEP1_APPLY' => 'Po zakończeniu kliknij przycisk <strong>Zastosuj</strong>.',
        'FLICKR_STEP1_E' => 'Przejdziesz do ekranu wyświetlającego Twój nowy klucz API.  Kliknij łącze <strong>Kliknij tutaj</strong>, aby skonfigurować uwierzytelnienie użytkownika tego klucza.',
        'FLICKR_STEP2_TITLE' => 'Krok 2: Skonfiguruj swój klucz',
        'FLICKR_STEP2_SETUP_SCREEN' => 'Ekran konfiguracji uwierzytelnienia klucza API  w programie Flickr',
        'FLICKR_STEP2_F' => 'Wklej następujący adres internetowy w polu <strong>Wywołaj adres URL</strong>:',
        'FLICKR_STEP2_SAVE_CHANGES' => 'Po zakończeniu kliknij przycisk <strong>Zapisz zmiany</strong>.',
        'FLICKR_STEP3_TITLE' => 'Krok 3: Wprowadź swoje dane',
        'FLICKR_STEP3_KEYS_SCREEN' => 'Ekran informacji o kluczu API w programie Flickr',
        'FLICKR_STEP3_CONGRATULATIONS' => 'Gratulacje!  Zakończyłeś konfigurację w programie Flickr.',
        'FLICKR_STEP3_COMPLETE' => 'Aby zakończyć konfigurację %s, skopiuj i wklej swój klucz i sekret w następujące pola:',
        'COMPLETE_SETUP' => 'Konfiguracja zakończona',
        'SETUP_YOUR_SITE_TO' => 'Skonfiguruj swoją sieć społeczną, aby importować zdjęcia z programu Flickr.',
        'FLICKR_IMPORTING' => 'Importowanie z programu Flickr',
        'YOU_NEED_TO_SET_UP_FLICKR' => 'Musisz skonfigurować swoją sieć społeczną, aby inni mogli importować swoje zdjęcia z programu Flickr.  Potrwa to tylko kilka minut, więc może <a %s>skonfigurujesz ją teraz? </a>',
        'DONT_SHOW_THIS_AGAIN_FLICKR' => 'Nie pokazuj tego ponownie.',
        'YOUVE_SIGNED_OUT_OF_X' => 'Wypisałeś się pomyślnie z %s.  Zapraszamy ponownie!',
        'CREATED_THIS_SOCIAL_NETWORK' => 'utworzył tę sieć społeczną na stronie <a href=\'http://www.ning.com\'>Ning</a>.',
        'CREATE_YOUR_OWN' => 'Utwórz bezpłatnie swoją sieć społeczną na stronie Ning!',
        'DRAG_HERE_TO_REMOVE_FEATURE' => 'Przeciągnij tutaj, aby usunąć funkcje',
        'LAYOUT' => 'Układ',
        'DRAG' => 'Przeciągnij',
        'HERE' => 'Tutaj',
        'YOU' => 'Ty',
        'ADS' => 'Reklamy',
        'MEMBERS' => 'Uczestnicy',
        'HELLO_USERNAME' => 'Witaj Nazwa użytkownika',
        'CREATED_BY' => 'Utworzony przez',
        'SAVE_FEATURES' => 'Zapisz funkcje',
        'FORUM' => 'Forum',
        'CATEGORIES' => 'Kategorie',
        'FORUM_CATEGORIES' => 'Kategorie forum',
        'A_THREADED_DISCUSSION_FORUM' => 'Wątkowe forum dyskusyjne',
        'ALLOW_MEMBERS_TO_CREATE_GROUPS' => 'Zezwalaj uczestnikom tworzyć własne grupy zainteresowań w Twojej sieci',
        'FEATURE_POSTS_FROM_YOUR_BLOG' => 'Zaznaczaj artykuły z Twojego bloga lub z blogów innych uczestników',
        'TEXT_BOX' => 'Pole tekstowe',
        'PUT_ANY_TEXT_WIDGET_OR_HTML' => 'Wstaw na głównej stronie jakikolwiek tekst, element widget lub HTML',
        'A_LIST_OF_MEMBERS' => 'Lista uczestników Twojej sieci społecznej',
        'ALLOW_USERS_PHOTOS' => 'Zezwalaj innym przekazywać i udostępniać zdjęcia',
        'ADD_FEEDS_FROM_ACROSS_THE_WEB' => 'Dodawaj źródła z całej sieci',
        'INFORMATION_ABOUT_THE_USER' => 'Informacje o zarejestrowanej osobie',
        'ALLOW_USERS_VIDEOS' => 'Zezwalaj innym dodawać i udostępniać pliki wideo',
        'SHOW_NETWORK_DESCRIPTION' => 'Pokaż opis swojej sieci',
        'PROMOTE_NETWORK_WITH_BADGES' => 'Promuj swoją sieć w Internecie używając niestandardowych oznaczeń i elementów widget',
        'MONETIZE_WITH_ADS' => 'Opłacaj swoją sieć z reklam',
        'LET_MEMBERS_KNOW_WHO_CREATED_NETWORK' => 'Niech uczestnicy wiedzą kto utworzył tę sieć',
        'FOLLOW_LATEST_ACTIVITY' => 'Monituj ostatnią aktywność uczestników w Twojej sieci',
        'FAQ_FOR_NETWORK_CREATORS' => 'FAQ dla autorów sieci',
        'ANSWERS_TO_FAQS' => 'Odpowiedzi na najczęściej zadawane pytania dotyczącej dostosowywania swojej sieci społecznej.',
        'MEET_OTHER_LIKEMINDED' => 'Spotkaj autorów sieci myślących podobnie, dziel się pomysłami i zdobywaj wsparcie od grupy Ning.',
        'CUSTOMIZE_THE_APPEARANCE_NETWORK' => 'Dostosuj wygląd sieci społecznej, dodając własne arkusze stylów kaskadowych (CSS) w polu po lewej stronie.  (<a href="%s">Co to jest CSS? </a>)',
        'CUSTOMIZE_THE_APPEARANCE_PAGE' => 'Dostosuj wygląd swojej strony, dodając własne arkusze stylów kaskadowych (CSS) w polu po lewej stronie.  (<a href="%s">Co to jest CSS? </a>)',
        'CSS_ON_YOUR_SOCIAL_NETWORK' => 'CSS w Twojej sieci społecznej',
        'CSS_ON_YOUR_PAGE' => 'CSS na Twojej stronie',
        'ADDING_YOUR_OWN_CSS_NETWORK' => 'Dodawanie własnych stylów CSS daje pełną kontrolę nad czcionkami, kolorem, rozmieszczeniem elementów i ogólnym stylem Twojej sieci.',
        'ADDING_YOUR_OWN_CSS_PAGE' => 'Dodawanie własnych stylów CSS do swojej strony daje pełną kontrolę nad czcionkami, kolorem, rozmieszczeniem elementów i ogólnym stylem Twojej strony.',
        'CSS_STYLES_WILL_OVERRIDE' => 'Style CSS, które dodajesz tutaj zastąpią istniejące style CSS, które wybrałeś wcześniej.',
        'NEED_HELP_FIGURING_OUT_CSS' => 'Potrzebujesz pomocy ze znalezieniem nazwy określonej klasy CSS w swojej sieci?  Polecamy funkcję "Inspekcja" darmowego rozszerzenia <a href="%s">Firebug</a> (dla przeglądarki Firefox).',
        'WANT_TO_LEARN_MORE' => 'Chcesz wiedzieć więcej?  Sprawdź naszą sekcję <a href="%s">Zaawansowane dostosowywanie</a>.',
        'APPLY_XS_THEME' => 'Zastosuj kompozycję %s\'s',
        'X_ALREADY_REGISTERED_Y_TO_RESET' => 'Jest już zarejestrowany ID Ning z adresem e-mail %s.  Zarejestruj się poniżej wpisując swój ID Ning lub adres e-mail.  Jeśli zapomniałeś hasła, <a href="%s">kliknij tutaj, aby zresetować swoje hasło</a>.',
        'INVITED' => 'Zaproszony',
        'REQUESTED_INVITE' => 'Zgłoszone zaproszenie',
        'BAN_FROM_NETWORK' => 'Blokuj w sieci',
        'REMOVE_BAN' => 'Usuń blokadę',
        'CANCEL_INVITATION' => 'Anuluj zaproszenie',
        'IGNORE' => 'Ignoruj',
        'PROMOTE_TO_ADMINISTRATOR' => 'Podwyższaj poziom do administratora',
        'DEMOTE_FROM_ADMINISTRATOR' => 'Obniżaj poziom z administratora',
        'STATUS' => 'Stan',
        'DATE_JOINED' => 'Data dołączenia',
        'DATE_INVITED' => 'Data zaproszenia',
        'DATE_REQUESTED' => 'Data zgłoszenia',
        'DATE_APPLIED' => 'Data przyjęcia',
        'NETWORK_CREATOR' => 'Autor sieci',
        'NETWORK_ADMINISTRATOR' => 'Administrator',
        'ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Administratorzy mają podobny poziom kontroli jak autor sieci.',
        'DOWNLOAD_ALL_MEMBER_DATA' => 'Eksportuj wszystkie dane uczestników (. CSV)',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Twoje dane członkowskie zostały eksportowane. Kliknij <a %s>to łącze</a>, aby zapisać je na pulpicie.',
        'CLICK_GO_TO_START_EXPORT' => 'Kliknij Przejdź, aby rozpocząć eksportowanie.   Jeśli masz wielu uczestników, proces może potrwać kilka minut.',
        'MEMBER' => 'Uczestnik',
        'INVITED_BY_X' => 'Zaproszony przez %s',
        'DONE' => 'Gotowe',
        'YOU_HAVE_BEEN_BANNED_FROM_APPNAME' => 'Zostałeś zablokowany w %s',
        'MESSAGE_TO_ADMINISTRATOR' => 'Wiadomość do administratora',
        'SORRY_USERNAME' => 'Przepraszamy, %s',
        'PENDING' => 'Oczekiwanie',
        'ACCEPT' => 'Akceptuj',
        'PENDING_APPROVAL' => 'Oczekiwanie na zatwierdzenie',
        'ACCEPT_MEMBERSHIP' => 'Akceptuj członkostwo',
        'DECLINE_MEMBERSHIP' => 'Odrzuć członkostwo',
        'NO_PAGE_YET' => 'Brak strony',
        'YOUR_MEMBERSHIP_TO_X_IS_PENDING_APPROVAL' => 'Twoje członkostwo w %s oczekuje zatwierdzenia przez administratorów.',
        'MEMBERSHIP_PENDING_APPROVAL' => 'Oczekiwanie na potwierdzenie członkostwa',
        'YOUR_PROFILE_IS_PENDING_APPROVAL' => 'Twój profil oczekuje zatwierdzenia',
        'YOUR_PROFILE_DETAILS_MUST_BE_APPROVED_ON_X' => 'Dane Twojego profilu muszą zostać zatwierdzone przez administratora zanim zostaniesz uczestnikiem %s.  Po zatwierdzeniu profilu otrzymasz wiadomość e-mail.',
        'CONTINUE_ARROW' => 'Continue →',
        'LARR_BACK_TO_PENDING_MEMBERS' => '← Z powrotem do oczekujących uczestników',
        'X_IS_AWAITING_APPROVAL_TO_BECOME_MEMBER_OF_Y' => '%s oczekuje zatwierdzenia, aby stać się uczestnikiem %s.',
        'VIEW_PAGE' => 'Przeglądaj stronę',
        'MESSAGE' => 'Wiadomość',
        'SEND_MESSAGE' => 'Wyślij wiadomość',
        'MANAGE_FORUM_CATEGORIES' => 'Zarządzaj kategoriami forum',
        'START_DISCUSSIONS' => 'Rozpocznij dyskusje',
        'WELCOME_TO_YOUR_NEW_SOCIAL_NETWORK' => 'Witamy w Twojej nowej sieci społecznej',
        'NOW_ALL_YOU_NEED_TO_DO_IS_INVITE_YOUR_FRIENDS' => 'Teraz pozostało Ci już tylko <a %s>zaprosić przyjaciół</a>!',
        'CONTRIBUTE' => 'Weź udział.',
        'CUSTOMIZE_APPEARANCE_BADGES' => '<strong>Dostosuj. </strong> Dostosuj <a %1$s>wygląd sieci</a> i zaprojektuj <a %2$s>oznaczenia i elementy widgets</a>.',
        'CONTROL_MANAGE_PAGE' => '<strong>Kontroluj. </strong>  Strona <a %s>zarządzania</a> jest stroną domową hosta opcji konfiguracji.',
        'CREATE_GROUPS' => 'Utwórz grupy',
        'INVITE_MORE_PEOPLE' => 'Zaproś więcej osób',
        'VIEW_THREAD' => 'Przeglądaj wątek',
        'COMMENT_THREAD' => 'Komentuj wątek',
        'COMMENT_BACK' => 'Tył komentarza',
        'HELLO_YOU_NEED_TO_ENABLE_JAVASCRIPT' => 'Witaj. Aby korzystać z tej sieci, musisz włączyć obsługę JavaScript.',
        'PLEASE_CHECK_YOUR_BROWSER_SETTINGS' => 'Sprawdź ustawienia przeglądarki lub skontaktuj się z administratorem systemu.',
        'MANAGE_MEMBERS_ADMINS_INVITED' => 'Zarządzaj uczestnikami, administratorami, zaproszonymi i zablokowanymi osobami.',
        'MANAGE_MEMBERS' => 'Zarządzaj uczestnikami',
        'MANAGE_INVITED_PEOPLE' => 'Zarządzaj zaproszonymi osobami',
        'NETWORK_SETTINGS' => 'Ustawienia sieci',
        'PROMOTE_YOUR_NETWORK' => 'Promuj swoją sieć',
        'NING_RESOURCES' => 'Zasoby Ning',
        'ADD_PREMIUM_SERVICES' => 'Dodaj usługi Premium',
        'REQUEST_SOURCE_CODE' => 'Żądaj dostępu do kodu źródłowego',
        'REQUEST_A_COPY_OF_THE_SOURCE_CODE' => 'Programiści: zażądaj dostępu do kodu źródłowego obsługującego Twoją sieć.',
        'JOIN_NETWORK_CREATORS' => 'Przyłącz się do autorów sieci',
        'SEND_MESSAGE_TO_ALL_THIS' => 'Wyślij wiadomość do wszystkich uczestników  tej sieci.',
        'CREATE_ANOTHER_NETWORK' => 'Utwórz inną sieć',
        'HAVE_ANOTHER_GREAT_IDEA' => 'Masz wspaniały pomysł na sieć społeczną?',
        'ALLOW_FACEBOOK_USERS_TO' => 'Zezwalaj użytkownikom Facebook umieszczać na stronach swoich profilów elementy widget Twojej strony.',
        'BADGES_AND_WIDGETS' => 'Oznaczenia i elementy widget',
        'CUSTOMIZE_WIDGETS_AND_BADGES' => 'Dostosuj widok Twoich elementów widget i oznaczeń sieci.',
        'GET_BADGES' => 'Zdobądź oznaczenia',
        'CUSTOM_TEXT' => 'Dostosuj tekst',
        'IM_A_MEMBER_OF' => 'Jestem członkiem:',
        'DONT_DISPLAY_ANY_BRANDING' => 'Nie wyświetlaj żadnych znaków towarowych',
        'WATERMARK_OR_LOGO_IMAGE' => 'Znak wodny lub logo:',
        'NETWORK_BRANDING_BADGES' => 'Znaki towarowe sieci: Oznaczenia',
        'NETWORK_BRANDING_WIDGETS' => 'Znaki towarowe sieci: elementy widget',
        'LOGO_IMAGE' => 'Obraz logo',
        'SMALL_NETWORK_BADGE' => 'Małe oznaczenie sieci',
        'LARGE_NETWORK_BADGE' => 'Duże oznaczenie sieci',
        'REFRESH' => 'Odśwież',
        'HTML_EMBED_CODE' => 'Osadzony kod HTML:',
        'CUSTOMIZE' => 'Dostosuj',
        'SHARE_TITLE' => 'Udostępniaj \'%s\'',
        'SHARE_TYPE' => 'Udostępniaj %s',
        'YOUR_MESSAGE_SENT' => 'Twoja wiadomość została pomyślnie wysłana.',
        'YOUR_MESSAGES_SENT' => 'Twoja wiadomość została pomyślnie wysłana.',
        'YOU_CAN_SHARE_TYPE_TWO_WAYS' => 'Możesz udostępniać %s na dwa sposoby&#8230;',
        'CHECK_OUT_THIS_TYPE_TITLE' => 'Sprawdź %s: "%s"',
        'CHECK_OUT_THIS_TYPE' => 'Sprawdź %s',
        'PHOTO_ALBUM' => 'album zdjęć',
        'CUSTOMIZE_YOUR_BADGES_AND_WIDGETS' => 'Oznacz swoje oznaczenia i elementy widget własnym kolorem i wybranymi obrazami.  Pojawienie się Twoich zmian na innych stronach internetowych może potrwać do 4 godzin.',
        'BACKGROUND_IMAGE_AND_COLOR' => 'Obraz i kolor tła',
        'USE_THIS_FORM_TO_REPORT_ISSUE_TO_NC' => 'Użyj tego formularza, aby zgłosić problem <a %s>%s</a>, autor <a %s>%s</a>.',
        'SORRY_NCS_CANNOT_CHANGE_EMAIL' => 'Przepraszamy, autorzy sieci nie mogą zmieniać adresów e-mail w sieciach, których nie są właścicielami.',
        'SORRY_NCS_CANNOT_CHANGE_PASSWORD' => 'Przepraszamy, autorzy sieci nie mogą zmieniać haseł w sieciach, których nie są właścicielami.',
        'GO' => 'Przejdź',
        'LARGE_THUMBNAILS' => 'Duże miniatury',
        'SMALL_THUMBNAILS' => 'Małe miniatury',
        'RECENTLY_JOINED' => 'Najnowsze',
        'MOST_POPULAR_MEMBERS' => 'Najpopularniejsze',
        'NO_MEMBERS_TO_DISPLAY' => 'Obecnie nie masz żadnych uczestników',
        'BOX_WILL_NOT_SHOW_MEMBERS' => 'To pole nie pojawia się w przypadku innych osób, jeśli nie zaznaczyłeś przynajmniej jednego wiersza.',
        'DETAIL_VIEW' => 'Widok szczegółowy',
        'TITLES_ONLY' => 'Tylko tytuły',
        'RECENTLY_ADDED_POSTS' => 'Ostatnio dodane',
        'POPULAR_POSTS' => 'Najwięcej komentarzy',
        'PROMOTED_POSTS' => 'Zamieszczone',
        'BOX_WILL_NOT_SHOW_BLOG_POST' => 'To pole nie pojawia się w przypadku innych osób, jeśli nie zaznaczyłeś przynajmniej jednego artykułu.',
        'KEEP_WINDOW_OPEN_UPLOAD' => 'Podczas przekazywania okno przeglądarki powinno być otwarte.',
        'CANCEL_UPLOAD' => 'Anuluj przekazywanie',
        'YOU_DO_NOT_HAVE_POSTS' => 'Nie napisałeś jeszcze żadnych artykułów.',
        'YOU_DO_NOT_HAVE_COMMENTS' => 'Nie masz żadnych komentarzy do zatwierdzenia.',
        'REQUIRED_FIELD' => '(Wymagane pole)',
        'BLOG_POST_BY_X' => 'Post blogu %s',
        'HELLO' => 'Witaj,',
        'ADDED_BY_X' => 'Dodany przez %s',
        'CLICK_TO_ADD_A_TITLE' => 'kliknij, aby dodać tytuł',
        'DELETE_BLOG_POST' => 'Usuń artykuł',
        'DELETE_THIS_BLOG_POST_Q' => 'Usuń ten post blogu?',
        'ARE_YOU_SURE_DELETE_THIS_BLOG_POST' => 'Na pewno chcesz usunąć  ten post blogu?  Proces może potrwać kilka minut.',
        'SPINNER' => 'Spinner',
        'PLEASE_ENTER_SOMETHING_FOR_X' => 'Wprowadź coś dla: %s',
        'PLEASE_SELECT_OPTION_FOR_X' => 'Zaznacz opcję dla: %s',
        'PLEASE_PROVIDE_VALID_DATE_FOR_X' => 'Wprowadź prawidłową datę dla: %s',
        'PLEASE_PROVIDE_DATE_FOR_X' => 'Wprowadź datę dla: %s',
        'XS_BLOG_POSTS_FOR_M_Y' => '%s\'s Posty blogu dla %s %s',
        'FEATURED_BLOG_POSTS_FOR_M_Y' => 'Charakterystyczne posty blogu dla %s %s',
        'BLOG_POSTS_FOR_M_Y' => 'Posty blogu dla %s %s',
        'FEATURED_BLOG_POSTS' => 'Charakterystyczne posty blogu',
        'EVERYONES_POSTS' => 'Posty blogu wszystkich',
        'PUBLISHED_N_OF_N' => 'Opublikowano %d z %d',
        'DOWNLOAD_X' => 'Pobierz %s',
        'UPLOAD_DID_NOT_WORK' => 'Przepraszamy, przekazywanie nie powiodło się',
        'F_J_Y' => 'F j, Y',
        'M_J_Y' => 'M. j, Y',
        'XS_POSTS' => '%s\'s Artykuły',
        'USERNAMES_COMMENTS' => '%s\'s Komentarze',
        'ADD_COMMENT' => 'Dodaj komentarz',
        'XS_PAGE' => '%s\'s Strona',
        'XS_BLOG' => '%s\'s Blog',
        'XS_FRIENDS' => '%s\'s Przyjaciele',
        'VIEW_XS_ELLIPSIS' => 'Widok %s...',
        'DRAFT_BRACKETS' => '[ Wersja robocza ]',
        'FEATURED' => 'Zamieszczone',
        'MY_POSTS' => 'Moje artykuły',
        'MY_POSTS_ONLY' => 'Tylko moje artykuły',
        'OWNER_POSTS_ONLY' => 'Tylko artykuły autora',
        'JANUARY' => 'Styczeń',
        'FEBRUARY' => 'Luty',
        'MARCH' => 'Marzec',
        'APRIL' => 'Kwiecień',
        'MAY' => 'Maj',
        'JUNE' => 'Czerwiec',
        'JULY' => 'Lipiec',
        'AUGUST' => 'Sierpień',
        'SEPTEMBER' => 'Wrzesień',
        'OCTOBER' => 'Październik',
        'NOVEMBER' => 'Listopad',
        'DECEMBER' => 'Grudzień',
        'MY_COMMENTS' => 'Moje komentarze',
        'AM' => 'AM',
        'PM' => 'PM',
        'MY_PAGE' => 'Moja strona',
        'MY_PAGE_TAB_TEXT' => 'Moja strona',
        'BLOG_POSTS' => 'Posty blogu',
        'MY_BLOG' => 'Mój blog',
        'MONTH' => 'Miesiąc',
        'DAY' => 'Dzień',
        'PICK_VALID_DEFAULT_VISIBILITY' => 'Dokonaj odpowiedniego wyboru domyślnej widoczności',
        'PICK_VALID_WHO_CAN_COMMENT' => 'Dokonaj odpowiedniego wyboru osób, które mogą wprowadzać komentarze',
        'PICK_VALID_BLOG_COMMENT_MODERATION' => 'Dokonaj odpowiedniego wyboru moderacji komentarzy blogu',
        'PICK_VALID_ACTIVITY_NOTIFICATION' => 'Dokonaj odpowiedniego wyboru powiadomienia o aktywności',
        'PICK_VALID_MODERATION_NOTIFICATION' => 'Dokonaj odpowiedniego wyboru powiadomienia o moderacji',
        'PICK_VALID_APPROVAL_NOTIFICATION' => 'Dokonaj odpowiedniego wyboru powiadomienia o zatwierdzeniu',
        'PICK_VALID_INVITEE_NOTIFICATION' => 'Dokonaj odpowiedniego wyboru powiadomienia o przyłączeniu się osób zaproszonych',
        'PICK_VALID_NEVER_NOTIFICATION' => 'Dokonaj odpowiedniego wyboru, żeby nigdy nie otrzymywać powiadomień',
        'PICK_VALID_FRIEND_REQUEST_NOTIFICATION' => 'Dokonaj odpowiedniego wyboru powiadomień o żądaniu przyjaciela',
        'PICK_VALID_NEW_MESSAGE_NOTIFICATION' => 'Dokonaj odpowiedniego wyboru powiadomień o nowych wiadomościach',
        'APPROVE_COMMENT' => 'Zatwierdź komentarz',
        'MANAGE_BLOG' => 'Zarządzaj blogiem',
        'COMMENTS_POSTED_ON_BLOG' => 'Komentarze wysłane na bloga',
        'COMMENT' => 'Komentarz',
        'COMMENTER' => 'Komentator',
        'POST' => 'ARTYKUŁ',
        'M_J_Y_G_IA' => 'M j, Y, g:ia',
        'POST_HAS_BEEN_DELETED' => 'Artykuł został usunięty',
        'COMMENTS_ARE_CLOSED' => 'Komentarze są zamknięte dla tego postu blogu',
        'NO_COMMENTS' => 'Brak komentarzy',
        'FLAG' => 'Flaga',
        'POST_TITLE' => 'Tytuł artykułu',
        'DRAFT_PARENTHESES' => '(Wersja robocza)',
        'SCHEDULED_TO_PUBLISH_ON' => 'Wyznaczony do publikacji: %s',
        'EDIT_2' => 'edycja',
        'NONE' => 'Brak',
        'N_NEW' => '%s Nowy',
        'NO_POSTS' => 'Brak artykułów',
        'ADD_NEW_BLOG_POST' => 'Dodaj nowy post blogu',
        'HAPPY' => 'Szczęśliwy',
        'SAD' => 'Smutny',
        'COOL' => 'Opanowany',
        'EVIL' => 'Zły',
        'MAD' => 'Szalony',
        'ENVIOUS' => 'Zazdrosny',
        'ENTRY' => 'Wpis',
        'WHAT_DATE_FOR_YOUR_POST' => 'Kiedy Twój artykuł ma zostać wysłany?',
        'NOW' => 'Teraz',
        'CHOOSE_DATE_AND_TIME' => 'Wybierz dzień i godzinę (jeśli wybierasz przyszłą datę, Twój artykuł będzie opublikowany w tym czasie)',
        'PRIVACY_AND_COMMENTS' => 'Prywatność i komentarze',
        'WHO_CAN_VIEW_POST' => 'Kto może przeglądać ten post?',
        'EVERYONE' => 'Wszyscy',
        'ALLOW_COMMENTS' => 'Zezwalać na pisanie komentarzy do tego artykułu?',
        'YES' => 'Tak',
        'NO' => 'Nie',
        'COMMENT_MODERATION' => 'Moderacja komentarza',
        'YOU_ARE_MODERATING_BLOG_COMMENTS' => 'Obecnie moderujesz komentarza blogu.',
        'YOU_ARE_NOT_MODERATING_BLOG_COMMENTS' => 'Nie moderujesz obecnie komentarzy blogu.',
        'SAVE_AS_DRAFT' => 'Zapisz jako wersję roboczą',
        'PREVIEW' => 'Przeglądaj',
        'PUBLISH_POST' => 'Publikuj artykuł',
        'THIS_IS_PREVIEW_OF_BLOG_POST' => 'To jest podgląd tego, jak będzie wyglądał Twój post blogu po publikacji.  Kliknij Wróć do edycji artykułu lub Publikuj, jeśli artykuł jest gotowy!',
        'BACK' => 'Wróć',
        'PUBLISH' => 'Publikuj!',
        'BLOG_POST' => 'Post blogu',
        'PROFILE' => 'Profil',
        'THIS_IS_UNPUBLISHED_DRAFT' => 'To jest nieopublikowana wersja robocza',
        'WILL_BE_PUBLISHED_ON_X' => 'Zostanie opublikowany %s <small>%s</small>',
        'POSTED_ON_X' => 'Wysłany <strong>%s</strong> <small>%s</small>',
        'POSTED_ON_X_BY' => 'Wysłany <strong>%s</strong> <small>%s</small> przez:',
        'ABOUT_THIS_POST' => 'O tym artykule',
        'ABOUT_YOUR_POST' => 'O Twoim artykule',
        'ADDED_BY' => 'Dodane przez:',
        'JUST_FRIENDS' => 'Po prostu przyjaciele',
        'RECENT_POSTS' => 'Ostatnie artykuły',
        'THERE_ARE_NO_RECENT_POSTS' => 'Ostatnio nie zamieszczono żadnych artykułów.',
        'YOUR_COMMENT_HAS_BEEN_ADDED_BUT' => 'Twój komentarz musi być zatwierdzony zanim będzie widoczny dla wszystkich.',
        'AT_TIME_ON_DATE_USERNAME_SAID' => 'Przy %s na %s, %s powiedział...',
        'X_DOES_NOT_HAVE_ANY_FRIENDS' => '%s nie ma jeszcze żadnych przyjaciół w tej sieci społecznej.',
        'YOU_DO_NOT_HAVE_ANY_FRIENDS' => 'Nie masz jeszcze żadnych przyjaciół w tej sieci społecznej.',
        'EDIT_PAGE_APPEARANCE' => 'Edytuj widok strony',
        'VIEW_PAGE_AS_OTHERS' => 'Pokaż stronę jak inni ją widzą',
        'ADD_BLOG_POST' => 'Dodaj post blogu',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED_2' => 'Podczas usuwania całej zawartości %s okno przeglądarki powinno być otwarte.  Proces może potrwać kilka minut.',
        'BAN_MEMBER_FROM_NETWORK' => 'Zablokuj uczestnika w sieci',
        'BAN_USERNAME' => 'Zablokować %s?',
        'BLOCK' => 'blokować',
        'CREATE_NEW_BLOG_POST' => 'Utwórz nowy post blogu!',
        'EDIT_POST' => 'Edytuj artykuł',
        'EDIT_POST_COLON' => 'Edytuj artykuł:',
        'CONTINUE_READING' => 'Kontynuuj czytanie...',
        'POSTED_BY_ME_LINK_ON_X_AT_X' => 'Posted by <a %s>me</a> on %s at %s  —',
        'POSTED_BY_X_ON_X_AT_X' => 'Posted by %s on %s at %s  —',
        'POSTED_BY_ME_ON_X_AT_X' => 'Posted by me on %s at %s  —',
        'ADD' => 'Dodaj',
        'SUBSCRIBE' => 'Subskrybuj',
        'VIEW_ARCHIVES' => 'Przeglądaj archiwa',
        'YOUR_SETTINGS_HAVE_BEEN_SAVED' => 'Twoje ustawienia zostały zapisane.',
        'PLEASE_CORRECT_THE_FOLLOWING' => 'Popraw następujące pozycje:',
        'PRIVACY' => 'Prywatność',
        'NETWORK_PRIVACY' => 'Prywatność sieci',
        'THIS_NETWORK_VISIBLE_TO_EVERYONE' => 'Ta sieć jest <strong>widoczna dla każdego</strong>.',
        'ANYONE_CAN_SIGN_UP_VISITORS_CAN' => 'Każdy może się zapisać, aby zostać uczestnikiem.  Goście mogą...',
        'SEE_EVERYTHING' => 'Przeglądaj wszystko',
        'SEE_JUST_THE_MAIN_PAGE' => 'Przeglądaj tylko główną stronę',
        'SEE_JUST_THE_SIGN_UP_PAGE' => 'Przeglądaj tylko stronę do zapisywania się',
        'THIS_NETWORK_VISIBLE_MEMBERS_ONLY' => 'Ta sieć jest <strong>widoczna tylko dla uczestników</strong>.',
        'WHO_CAN_SIGN_UP' => 'Kto może zapisać się, aby zostać uczestnikiem?',
        'MODERATION' => 'Kontrola zawartości',
        'APPROVE_MEMBERS_BEFORE_JOIN' => 'Zatwierdzaj nowych uczestników zanim się przyłączą',
        'APPROVE_PHOTOS_VIDEOS' => 'Zatwierdzaj zdjęcia i pliki wideo zanim się pokażą',
        'SHOW_LATEST_ACTIVITY_ON_YOUR_NETWORK' => 'Pokaż ostatnią czynność w swojej sieci!',
        'PUT_A_CONSTANTLY_UPDATED_STREAM' => 'Umieść stały zaktualizowany strumień czynności na głównej stronie swojej sieci.',
        'CLICK_HERE_TO_ADD_LATEST_ACTIVITY' => 'Kliknij tutaj, aby dodać Ostatnią czynność do swojej sieci.',
        'THESE_OPTIONS_ARE_DISABLED_ACTIVITY' => 'Te opcje nie są aktywne, ponieważ nie masz w sieci Ostatniej czynności.',
        'ACTIVITY' => 'Czynność',
        'DISPLAY_PREFERENCES' => 'Wyświetlaj preferencje',
        'NEW_CONTENT' => 'Nowa zawartość',
        'NEW_COMMENTS' => 'Nowe komentarze',
        'NEW_MEMBERS' => 'Nowi uczestnicy',
        'MEMBER_UPDATES' => 'Aktualizacje uczestników',
        'WHAT_DISPLAYS_LATEST_ACTIVITY' => 'Co wyświetla się w ostatniej czynności dotyczącej Twojej sieci?',
        'LATEST_ACTIVITY' => 'Ostatnia czynność',
        'X_COMMENTED_ON_POST_TITLE' => '%1$s odpowiedział w dyskusji %2$s',
        'X_LINK_COMMENTED_ON_POST_LINK_TITLE' => '%1$s <a %2$s>odpowiedział</a> w dyskusji <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_POST_LINK_TITLE' => '<a %1$s>Odpowiedziałeś</a> w dyskusji <a %2$s>%3$s</a>',
        'X_COMMENTED_ON_BLOG_POST_TITLE' => '%1$s skomentował post blogu %2$s',
        'X_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '%1$s <a %2$s>skomentował</a> post blogu <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '<a %1$s>Skomentowałeś</a> post blogu <a %2$s>%3$s</a>',
        'X_STARTED_A_DISCUSSION_Y' => '%s rozpoczął dyskusję pod nazwą %s',
        'YOU_STARTED_A_DISCUSSION_Y' => 'Rozpocząłeś dyskusję pod nazwą %s',
        'X_ADDED_THE_BLOG_POST_Y' => '%s dodał post blogu \'%s\'',
        'YOU_ADDED_THE_BLOG_POST_Y' => 'Dodałeś post blogu \'%s\'',
        'X_JOINED_THE_GROUP_Y' => '%s przyłączył się do grupy %s',
        'YOU_JOINED_THE_GROUP_X' => 'Przyłączyłeś się do grupy %s',
        'X_JOINED_Y_GROUPS' => '%s przyłączył się do grup %s',
        'YOU_JOINED_X_GROUPS' => 'Przyłączyłeś się do grup %s',
        'X_JOINED_APPNAME' => '%s dołączył do %s. <a %s>Zostaw komentarz</a> dla %s.',
        'WELCOME_MEMBER_N_OF_APPNAME' => 'Witamy, %1$s!  Jesteś uczestnikiem #%2$s z %3$s.',
        'WELCOME_MEMBER_N_OF_APPNAME_FIND' => 'Witamy, %1$s!  Jesteś uczestnikiem #%2$s z %3$s.  <a %4$s>Znajdź teraz przyjaciół</a>.',
        'X_IS_MEMBER_N_OF_APPNAME' => '%1$s jest uczestnikiem #%2$s of %3$s.',
        'XS_PROFILE_CHANGED' => 'Zmienił się profil %s',
        'YOUR_PROFILE_CHANGED' => 'Zmienił się Twój profil',
        'X_LEFT_A_COMMENT_FOR_Y' => '%s zostawił komentarz dla %s',
        'YOU_LEFT_A_COMMENT_FOR_X' => 'Zostawiłeś komentarz dla %s',
        'X_LEFT_A_COMMENT_FOR_YOU' => '%s zostawił komentarz dla Ciebie',
        'X_CREATED_A_GROUP_Y' => '%s utworzył grupę pod nazawą %s',
        'YOU_CREATED_A_GROUP_Y' => 'Utworzyłeś grupę pod nazwą %s',
        'X_CREATED_Y_NEW_GROUPS' => '%s utworzył %s nowe grupy',
        'X_STARTED_Y_FORUM_POSTS' => '%s rozpoczął %s nowe dyskusje na forum',
        'YOU_STARTED_Y_FORUM_POSTS' => 'Rozpocząłeś %s nowe dyskusje na forum',
        'X_ADDED_Y_BLOG_POSTS' => '%s dodał %s nowe posty blogu',
        'YOU_ADDED_Y_BLOG_POSTS' => 'Dodałeś %s nowe posty blogu',
        'VIEW_XS_BLOG_POSTS' => 'Przeglądaj posty blogów %s',
        'VIEW_YOUR_BLOG_POSTS' => 'Przeglądaj swoje posty blogu',
        'APPNAME_HAS_NEW_PROFILE_QUESTIONS' => '%s ma <a %s>nowe pytania profilu</a>',
        'APPNAME_NOW_HAS_MUSIC' => '%s ma teraz odtwarzacz muzyczny',
        'APPNAME_NOW_HAS_GROUPS' => '%s ma teraz <a %s>grupy</a>',
        'APPNAME_NOW_HAS_VIDEO' => '%s ma teraz <a %s>pliki wideo</a>',
        'APPNAME_NOW_HAS_FORUM' => '%s ma teraz <a %s>forum</a>',
        'APPNAME_NOW_HAS_PHOTO' => '%s ma teraz <a %s>zdjęcia</a>',
        'DID_YOU_KNOW' => 'Wiedziałeś, że',
        'ANNOUNCEMENT' => 'Anons',
        'CONGRATULATIONS' => 'Gratulacje',
        'YOU_CREATED_APPNAME' => 'Utworzyłeś sieć %s.',
        'USER_CREATED_APPNAME' => '%s utworzył sieć %s.',
        'ADD_MESSAGES_ACTIVITY_FEED' => 'Dodawaj wiadomości i wybieraj, co ma się wyświetlać w źródle aktywności Twojej sieci.',
        'WHICH_OF_YOUR_ACTIONS_DISPLAY_ACTIVITY' => 'Która z Twoich czynności powinna wyświetlać się <br />w Ostatnia czynność?',
        'NEW_CONTENT_I_ADD' => 'Nowa zawartość, którą dodaję',
        'NEW_COMMENTS_I_ADD' => 'Nowe komentarze, które dodaję',
        'WHEN_I_UPDATE_MY_PROFILE' => 'Kiedy aktualizuję profil',
        'THE_LATEST_ACTIVITY_WILL_NEVER' => 'Ostatnia czynność nigdy nie spowoduje wyświetlenia wiadomości, które wysyłasz, stron lub uczestników, których przeglądasz, zaproszeń, które odrzucasz, osób, które przywróciłeś do statusu przyjaciela lub odrzuciłeś albo rzeczy, które usuwasz.',
        'YOU_HAVENT_DONE_ANYTHING_RECENTLY' => 'Nic ostatnio nie robiłeś. Chcesz coś uruchomić?',
        'YOUVE_TURNED_OFF_THE_ACTIVITY_DISPLAY_CLICK' => 'Wyłączyłeś wyświetlanie Twojej aktywności.  <a %s>Kliknij tutaj, aby ją ponownie włączyć. </a>',
        'THE_NETWORK_CREATOR_HAS_TURNED_OFF_THE_ACTIVITY' => 'Autor sieci wyłączył wyświetlanie całej aktywności.',
        'NO_ACTIVITY_TO_DISPLAY' => 'Nie wyświetlane są obecnie żadne czynności.',
        'BOX_WILL_NOT_SHOW_ACTIVITY' => 'To pole nie wyświetli się innym osobom, jeśli nie zaznaczysz przynajmniej jednej czynności.',
        'NOTHING_IS_HAPPENING_ON_YOUR_NETWORK' => 'Brak czynności. Chcesz coś uruchomić?',
        'MY_ACTIVITY_PREFERENCES' => 'Preferencje mojej czynności',
        'DELETE_ACTIVITY_ITEM' => 'Usuń wiadomość o czynności',
        'DELETE_THIS_ACTIVITY_MESSAGE_Q' => 'Usunąć tę wiadomość o czynności?',
        'THIS_WILL_PREVENT_ACTIVITY' => 'To zapobiegnie przeglądaniu tej wiadomości o czynności przez wszystkich',
        'X_HAS_POSTED_THE_MOST_PHOTOS' => '%1$s wysłał najwięcej %2$szdjęć%3$s',
        'X_IS_THE_MOST_POPULAR_PHOTO' => '%s jest obecnie najpopularniejszym zdjęciem',
        'X_HAS_POSTED_THE_MOST_VIDEOS' => '%1$s wysłał najwięcej %2$splików wideo%3$s',
        'X_IS_THE_MOST_POPULAR_VIDEO' => '%s jest obecnie najpopularniejszym plikiem wideo',
        'X_HAS_POSTED_THE_MOST_MUSIC' => '%s wysłał najwięcej utworów',
        'X_IS_THE_MOST_POPULAR_MUSIC' => '%s jest obecnie najpopularniejszym utworem',
        'X_IS_THE_MOST_POPULAR_TOPIC' => '%s jest obecnie najpopularniejszym forum',
        'X_IS_THE_MOST_POPULAR_BLOG_POST' => '%s jest obecnie najpopularniejszym postem blogu',
        'XS_LATEST_ACTIVITY_ON_APPNAME' => '%s\'s Ostatnia czynność na %s',
        'LATEST_ACTIVITY_ON_APPNAME' => 'Ostatnia czynność na %s',
        'ADD_MESSAGE_TO_LATEST_ACTIVITY' => 'Dodaj wiadomość do Ostatniej czynności',
        'ADD_FACTS_ABOUT_THE_NETWORK_ELLIPSIS' => 'Dodaj informacje o sieci...',
        'ADD_MESSAGE' => 'Dodaj wiadomość',
        'ELLIPSIS_OR_WRITE_YOUR_OWN_MESSAGE' => '...lub napisz swoją własną wiadomość',
        'NETWORK' => 'Sieć',
        'WHO_CAN_VIEW_YOUR_PHOTOS_VIDEOS' => 'Kto może domyślnie przeglądać Twoje zdjęcia, pliki wideo,<br/> i posty blogu?',
        'YOU_CAN_OVERRIDE_WHEN_YOU_ADD' => 'Możesz zastąpić to ustawienie w przypadku zdjęcia, pliku wideo lub postu blogu - w momencie gdy dodasz dany element.',
        'MODERATE_COMMENTS_ON_BLOG' => 'Chcesz zatwierdzić komentarze<br />zanim pojawią się w Twoim blogu?',
        'YES_LET_ME_APPROVE' => 'Tak ・Pozwól mi najpierw zatwierdzać komentarze',
        'NO_PUBLISH_COMMENTS' => 'Nie ・Publikuj komentarze natychmiast',
        'WHO_CAN_COMMENT_ON_PHOTOS_VIDEOS' => 'Kto może komentować Twoje zdjęcia,<br/> pliki wideo i blog?',
        'SAVE' => 'Zapisz',
        'EMAIL' => 'Adres e-mail',
        'YOUR_PRIVACY_IS_IMPORTANT' => 'Twoja prywatność jest dla nas ważna.  Jeśli masz jakieś pytania dotyczące powiadomień elektronicznych, wyślij nam informację przez <a href="http://help.ning.com/?page_id=27">Centrum pomocy</a>.',
        'ADD_PHOTOS_AND_VIDEOS_TO_X_BY_SENDING' => 'Dodawaj zdjęcia i pliki wideo do %s wysyłając je na niniejszy adres e-mail:',
        'ADD_PHOTOS_AND_VIDEOS_TO_APPNAME_FROM_PHONE' => 'Dodawaj zdjęcia i pliki wideo do %s ze swego telefonu wysyłając je na niniejszy adres e-mail:',
        'GENERATE_NEW_EMAIL_ADDRESS' => 'Generuj nowy adres e-mail',
        'SUPPORTS_TEXT_EMBEDDED' => 'Obsługuje teksty, osadzone pliki wideo, zdjęcia i elementy widget',
        'POST_COMMENT' => 'Wyślij komentarz',
        'YOU_NEED_TO_BE_MEMBER_COMMENTS' => 'Aby dodawać komentarze, musisz być uczestnikiem sieci %s!',
        'MONTHLY_ARCHIVES' => 'Miesięczne archiwum',
        'NO_FRIENDS_ON_SITE' => 'Nie masz jeszcze przyjaciół w tej sieci społecznej.',
        'NO_FRIENDS_ON_SITE_THAT_MATCH' => 'Nie masz przyjaciół w tej sieci społecznej, którzy odpowiadają Twoim kryteriom wyszukiwania.',
        'MEMBERS_TAB_TEXT' => 'Uczestnicy',
        'SITE_HAS_NO_MEMBERS' => 'Niniejsza sieć społeczna nie ma jeszcze żadnych uczestników!',
        'SITE_HAS_NO_MEMBERS_THAT_MATCH' => 'Niniejsza sieć społeczna nie ma jeszcze żadnych uczestników, którzy odpowiadają Twoim kryteriom wyszukiwania.',
        'NO_COMMENTS_YET' => 'Brak komentarzy!',
        'VIEW_ALL_COMMENTS' => 'Przeglądaj wszystkie komentarze',
        'YOU_HAVE_NOT_ADDED_BLOG_POSTS' => 'Nie dodałeś jeszcze żadnych postów blogu!',
        'YOU_CAN_WRITE_ABOUT_ANYTHING' => 'Możesz pisać, o czym chcesz, rozmawiać i osadzać swoje ulubione pliki wideo, zdjęcia i muzykę.',
        'WRITE_YOUR_FIRST_ENTRY' => 'Napisz swój pierwszy wpis!',
        'THERE_ARE_NO_BLOG_POSTS' => 'W Twojej sieci społecznej nie ma obecnie żadnych postów blogu.',
        'THERE_ARE_NO_FEATURED_X' => 'Nie zamieszczono żadnych %s w Twojej sieci społecznej.',
        'THERE_ARE_NO_X_THAT_MATCH_SETTINGS' => 'Brak %s, które odpowiadają wybranym przez Ciebie ustawieniom.',
        'START_FEATURING_X_CLICK_Y' => 'Rozpocznij zamieszczanie %s tam, gdzie widzisz opcję zamieszczania.  Aby dowiedzieć się więcej na temat zamieszczania, <a %s>kliknij tutaj</a>.',
        'THIS_BOX_WILL_NOT_SHOW_BLOG_POSTS' => 'To pole nie wyświetli się innym osobom, jeśli nie ma żadnych postów blogu do pokazania. Chcesz dodać post?',
        'YOUR_FRIEND' => 'Twój przyjaciel',
        'REQUEST_SENT' => 'Żądanie zostało wysłane!',
        'BLOCKED' => 'Zablokowany',
        'BANNED' => 'Zablokowany',
        'ADD_YOUR_FIRST_BLOG_POST' => 'Dodaj swój pierwszy post blogu',
        'MY_FIRST_BLOG_POST' => 'Mój pierwszy post blogu!',
        'TELL_THE_PEOPLE_ON' => 'Powiedz ludziom na %s więcej na swój temat.  Pytania oznaczone <span %s>kłódką</span> są prywatne i widoczne tylko dla administratorów.',
        'CHOOSE_A_THEME_FOR_PAGE' => 'Wybierz kompozycję swojej strony',
        'NOW_CUSTOMIZE_PAGE' => 'Teraz dostosuj swoją stronę...',
        'NO_POSTS_TO_DISPLAY' => 'Brak artykułów do wyświetlenia.',
        'YOU_ARE_DISPLAYING_NO_POSTS' => 'Obecnie nie wyświetlasz żadnych artykułów.',
        'DATE_COLON' => 'Data:',
        'TIME_COLON' => 'Godzina:',
        'CHANGE' => 'Zmień',
        'UPLOAD_A_PHOTO' => 'Przekaż zdjęcie',
        'OPTIONS' => 'Opcje',
        'PIXELS' => 'Piksele',
        'CANCEL' => 'Anuluj',
        'UPLOAD_A_FILE' => 'Przekaż plik:',
        'TO_INSERT_A_FILE' => 'Aby wstawić plik, kliknij powyższy przycisk "Przeglądaj" lub "Wybierz", aby zlokalizować plik na swoim komputerze.',
        'UPLOADING' => 'Przekazywanie...',
        'OK' => 'OK',
        'POPULAR_MEMBERS' => 'Popularni uczestnicy',
        'INVITE_FRIENDS' => 'Zaproś przyjaciół',
        'VIEW_ALL' => 'Przeglądaj wszystkich',
        'REMOVE_X' => 'Usuń %s',
        'ARE_YOU_SURE_BAN_X_AND_CONTENT' => 'Na pewno chcesz zablokować%1$s w swojej sieci społecznej i usunąć całą zawartość którą dodał %1$s,?  Proces może potrwać kilka minut.',
        'REMOVING_X' => 'Usuwanie %s',
        'ARE_YOU_SURE_BAN_MEMBERS_AND_CONTENT' => 'Na pewno chcesz zablokować zaznaczonych uczestników w swojej grupie społecznej i usunąć całą zawartość, którą dodali?  Proces może potrwać kilka minut.',
        'ARE_YOU_SURE_BAN_MEMBERS' => 'Na pewno chcesz zablokować zaznaczonych uczestników w swojej sieci?  Proces może potrwać kilka minut.',
        'BAN' => 'Blokuj',
        'REMOVING_MEMBERS' => 'Usuwanie uczestników',
        'FEMALE' => 'Kobieta',
        'MALE' => 'Mężczyzna',
        'UNITED_STATES' => 'Stany Zjednoczone',
        'AND' => 'i',
        'FROM' => 'z',
        'GENDER_M' => 'Mężczyzna',
        'GENDER_F' => 'Kobieta',
        'XS_PAGE_ON_Y' => '%s\'s Strona %s',
        'SEARCH_MEMBERS' => 'Wyszukaj uczestników',
        'SOMEBODY_COMMENTED_BLOGPOST_ADDED_TO_X' => 'ktoś skomentował post blogu, który dodałeś do %s',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE' => 'Masz nowy komentarz na swojej stronie.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X' => 'Masz nowy komentarz na swojej stronie %s.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X_ELLIPSIS' => 'Masz nowy komentarz na swojej stronie %s...',
        'A_BLOG_POST' => 'Post blogu',
        'NOW_THAT_YOU_JOINED_INVITE' => 'Teraz kiedy już przyłączyłeś się, <strong><a %s>zaproś swoich przyjaciół</a></strong>!',
        'THIS_IS_YOUR_PROFILE' => 'To jest Twój profil:',
        'START_BY_CUSTOMIZING_ITS_APPEARANCE' => 'Rozpocznij <a %s>dostosowując jego wygląd</a>.',
        'USE_IT_TO_KEEP_A_BLOG_AND_DISPLAY_YOUR_PROFILE_ANSWERS' => 'Używaj go do <a %1$s>pisania blogu</a>, I wyświetlaj <a %2$s>odpowiedzi Twojego profilu</a>.',
        'START_CONTRIBUTING' => 'Rozpocznij wkład:',
        'UPLOAD_VIDEOS' => 'Przekaż pliki wideo',
        'CONTRIBUTE_TO_DISCUSSIONS' => 'Angażuj się w dyskusje',
        'JOIN_GROUPS' => 'Przyłącz się do grup',
        'ADD_A_BLOG_POST' => 'Dodaj post blogu',
        'CLICK_TO_ACCEPT_FRIENDS' => 'Kliknij tutaj, aby przeglądać prośby Twoich przyjaciół.',
        'LEAVE_X' => 'Opuść %s',
        'LEAVE_X_Q' => 'Opuść%s?',
        'ARE_YOU_SURE_LEAVE_X' => 'Na pewno chcesz opuścić %s i usunąć całą swoją zawartość?  Proces może potrwać kilka minut.',
        'BACK_TO_USERNAMES_PAGE' => '&#8592;  Wróć do strony %s',
        'BACK_TO_MY_PAGE' => '&#8592;  Wróć do Mojej strony',
        'COMMENT_WALL' => 'Ściana komentarzy',
        'ONLINE' => 'W trybie online',
        'MEMBER_IS_ONLINE' => 'Uczestnik jest on-line',
        'ONLINE_NOW' => 'Wejdź on-line teraz',
        'CHOOSE_WHO_CAN_SEE_JOIN_AND_CONTRIBUTE' => 'Wybierz osoby, które mogą przeglądać, przyłączać się i angażować w Twoją sieć.',
        'EMAIL_NOTIFICATIONS' => 'Powiadomienia elektroniczne',
        'WHAT_NETWORK_ACTIVITY_EMAIL_FOR' => 'Dla jakiej aktywności sieci chcesz otrzymywać powiadomienie elektroniczne?',
        'NETWORK_MESSAGES' => 'Wiadomości sieciowe',
        'MEMBER_ACTIVITY' => 'Aktywność uczestnika',
        'APPROVAL' => 'Zatwierdzenie',
        'FRIEND_REQUESTS' => 'Prośby przyjaciół',
        'PEOPLE_IVE_INVITED_JOIN' => 'Osoby, które zaprosiłem, aby przyłączyły się do tej sieci',
        'MESSAGES_SENT_TO_ME' => 'Wiadomości wysłane do mnie',
        'MESSAGES_SENT_TO_GROUPS' => 'Wiadomości wysłane do grup, do których należę',
        'MESSAGES_SENT_TO_NETWORK' => 'Wiadomości wysłane do całej sieci',
        'I_HAVE_NEW_COMMENTS' => 'Mam nowe komentarze do zatwierdzenia',
        'I_HAVE_NEW_NETWORK_CONTENT' => 'Mam nową zawartość sieci do zatwierdzenia',
        'CONTENT_ACTIVITY' => 'Aktywność zawartości',
        'ACTIVITY_ON_THINGS_IVE_ADDED' => 'Aktywność rzeczy, które dodałem',
        'AUTO_FOLLOW_DISCUSSIONS_I_REPLY_TO' => 'Automatycznie śledź dyskusje, w których odpowiadam',
        'THINGS_IVE_ADDED_APPROVED' => 'Zatwierdzono rzeczy, które dodałem',
        'NOTIFICATIONS' => 'Powiadomienia',
        'EMAIL_ME_WHEN_PEOPLE_REPLY' => 'Wyślij do mnie wiadomość e-mail, kiedy ktoś odpowie',
        'DO_NOT_EMAIL_ME_WHEN_PEOPLE_REPLY' => 'Nie wysyłaj do mnie wiadomości e-mail, kiedy ktoś odpowie',
        'TO_STOP_FOLLOWING_THIS_X_CLICK_Y' => 'Aby zatrzymać śledzenie tego %s, <a %s>kliknij tutaj</a>.',
        'YOU_ARE_NO_LONGER_FOLLOWING_THIS_X' => 'Już nie śledzisz tego %s.',
        'NOTIFY' => 'Powiadom',
        'STOP_NOTIFYING' => 'Zatrzymaj powiadamianie',
        'EMAIL_WHEN_NEW_DISCUSSIONS' => 'Wyślij do mnie wiadomość e-mail, gdy pojawią się nowe dyskusje',
        'DO_NOT_EMAIL_WHEN_NEW_DISCUSSIONS' => 'Nie wysyłaj mi wiadomości e-mail, gdy pojawią się nowe dyskusje',
        'STOP_FOLLOWING_ALL' => 'Zatrzymaj śledzenie wszystkich dyskusji i komentarzy blogu',
        'CHANGE_MY_PHOTO' => 'Zmień Moje zdjęcie',
        'COUNTRY_AF' => 'Afganistan',
        'COUNTRY_AX' => 'Wyspy Alandzkie',
        'COUNTRY_AL' => 'Albania',
        'COUNTRY_DZ' => 'Algieria',
        'COUNTRY_AS' => 'Samoa Amerykańskie',
        'COUNTRY_AD' => 'Andora',
        'COUNTRY_AO' => 'Angola',
        'COUNTRY_AI' => 'Anguilla',
        'COUNTRY_AQ' => 'Antarktyda',
        'COUNTRY_AG' => 'Antigua i Barbuda',
        'COUNTRY_AR' => 'Argentyna',
        'COUNTRY_AM' => 'Armenia',
        'COUNTRY_AW' => 'Aruba',
        'COUNTRY_AU' => 'Australia',
        'COUNTRY_AT' => 'Austria',
        'COUNTRY_AZ' => 'Azerbejdżan',
        'COUNTRY_BS' => 'Wyspy Bahama',
        'COUNTRY_BH' => 'Bahrajn',
        'COUNTRY_BD' => 'Bangladesz',
        'COUNTRY_BB' => 'Barbados',
        'COUNTRY_BY' => 'Białoruś',
        'COUNTRY_BE' => 'Belgia',
        'COUNTRY_BZ' => 'Belize',
        'COUNTRY_BJ' => 'Benin',
        'COUNTRY_BM' => 'Bermudy',
        'COUNTRY_BT' => 'Bhutan',
        'COUNTRY_BO' => 'Boliwia',
        'COUNTRY_BA' => 'Bośnia i Hercegowina',
        'COUNTRY_BW' => 'Botswana',
        'COUNTRY_BV' => 'Wyspa Bouveta',
        'COUNTRY_BR' => 'Brazylia',
        'COUNTRY_IO' => 'Brytyjskie Terytorium Oceanu Indyjskiego',
        'COUNTRY_BN' => 'Brunei Darussalam',
        'COUNTRY_BG' => 'Bułgaria',
        'COUNTRY_BF' => 'Burkina Faso',
        'COUNTRY_BI' => 'Burundi',
        'COUNTRY_KH' => 'Kambodża',
        'COUNTRY_CM' => 'Kamerun',
        'COUNTRY_CA' => 'Kanada',
        'COUNTRY_CV' => 'Republika Zielonego Przylądka',
        'COUNTRY_KY' => 'Kajmany',
        'COUNTRY_CF' => 'Republika Środkowoafrykańska',
        'COUNTRY_TD' => 'Czad',
        'COUNTRY_CL' => 'Czile',
        'COUNTRY_CN' => 'Chiny, kontynentalne',
        'COUNTRY_CX' => 'Wyspa Bożego Narodzenia',
        'COUNTRY_CC' => 'Wyspy Kokosowe',
        'COUNTRY_CO' => 'Kolumbia',
        'COUNTRY_KM' => 'Komory',
        'COUNTRY_CG' => 'Kongo, Republika',
        'COUNTRY_CD' => 'Kongo, Republika Demokratyczna',
        'COUNTRY_CK' => 'Wyspy Cooka',
        'COUNTRY_CR' => 'Kostaryka',
        'COUNTRY_CI' => 'Wybrzeże Kości Słoniowej',
        'COUNTRY_HR' => 'Chorwacja',
        'COUNTRY_CU' => 'Kuba',
        'COUNTRY_CY' => 'Cypr',
        'COUNTRY_CZ' => '"Czechy, Republika Czeska"',
        'COUNTRY_DK' => 'Dania',
        'COUNTRY_DJ' => 'Dżibuti',
        'COUNTRY_DM' => 'Dominika',
        'COUNTRY_DO' => '"Republika Dominikańska, Dominikana"',
        'COUNTRY_EC' => 'Ekwador',
        'COUNTRY_EG' => 'Egipt',
        'COUNTRY_SV' => 'Salwador',
        'COUNTRY_GQ' => 'Gwinea Równikowa',
        'COUNTRY_ER' => 'Erytrea',
        'COUNTRY_EE' => 'Estonia',
        'COUNTRY_ET' => 'Etiopia',
        'COUNTRY_EU' => 'Unia Europejska',
        'COUNTRY_FK' => 'Falklandy',
        'COUNTRY_FO' => 'Wyspy Owcze',
        'COUNTRY_FJ' => 'Wyspa Fiji',
        'COUNTRY_FI' => 'Finlandia',
        'COUNTRY_FR' => 'Francja',
        'COUNTRY_GF' => 'Gujana Francuska',
        'COUNTRY_PF' => 'Polinezja Francuska',
        'COUNTRY_TF' => 'Francuskie Terytoria Południowe',
        'COUNTRY_GA' => 'Gabon',
        'COUNTRY_GM' => 'Gambia',
        'COUNTRY_GE' => 'Gruzja',
        'COUNTRY_DE' => 'Niemcy',
        'COUNTRY_GH' => 'Ghana',
        'COUNTRY_GI' => 'Gibraltar',
        'COUNTRY_GR' => 'Grecja',
        'COUNTRY_GL' => 'Grenlandia',
        'COUNTRY_GD' => 'Grenada',
        'COUNTRY_GP' => 'Gwadelupa',
        'COUNTRY_GU' => 'Guam',
        'COUNTRY_GT' => 'Gwatemala',
        'COUNTRY_GN' => 'Gwinea',
        'COUNTRY_GW' => 'Gwinea Bissau',
        'COUNTRY_GY' => 'Gujana',
        'COUNTRY_HT' => 'Haiti',
        'COUNTRY_HM' => 'Wyspy Heard i McDonalda',
        'COUNTRY_HN' => 'Honduras',
        'COUNTRY_HK' => 'Hong Kong',
        'COUNTRY_HU' => 'Węgry',
        'COUNTRY_IS' => 'Islandia',
        'COUNTRY_IN' => 'Indie',
        'COUNTRY_ID' => 'Indonezja',
        'COUNTRY_IR' => 'Iran, Republika Islamska',
        'COUNTRY_IQ' => 'Irak',
        'COUNTRY_IE' => 'Irlandia',
        'COUNTRY_IL' => 'Izrael',
        'COUNTRY_IT' => 'Włochy',
        'COUNTRY_JM' => 'Jamajka',
        'COUNTRY_JP' => 'Japonia',
        'COUNTRY_JO' => 'Jordania',
        'COUNTRY_KZ' => 'Kazachstan',
        'COUNTRY_KE' => '"Kenia, Republika Kenii"',
        'COUNTRY_KI' => 'Kiribati',
        'COUNTRY_KP' => 'Korea, Republika Ludowo-Demokratyczna',
        'COUNTRY_KR' => 'Republika Korei',
        'COUNTRY_KW' => 'Kuwejt',
        'COUNTRY_KG' => 'Kirgistan',
        'COUNTRY_LA' => 'Ludowo-Demokratyczna Republika Laosu',
        'COUNTRY_LV' => 'Łotwa',
        'COUNTRY_LB' => 'Liban',
        'COUNTRY_LS' => 'Lesotho',
        'COUNTRY_LR' => 'Liberia',
        'COUNTRY_LY' => 'Libijska Arabska Dżamahirija',
        'COUNTRY_LI' => 'Liechtenstein',
        'COUNTRY_LT' => 'Litwa',
        'COUNTRY_LU' => 'Luksemburg',
        'COUNTRY_MO' => 'Macao',
        'COUNTRY_MK' => 'Macedonia, Była Jugosłowiańska Republika',
        'COUNTRY_MG' => 'Madagaskar',
        'COUNTRY_MW' => 'Malawi',
        'COUNTRY_MY' => 'Malezja',
        'COUNTRY_MV' => 'Malediwy',
        'COUNTRY_ML' => 'Mali',
        'COUNTRY_MT' => 'Malta',
        'COUNTRY_MH' => 'Wyspy Marshalla',
        'COUNTRY_MQ' => 'Martynika',
        'COUNTRY_MR' => 'Mauretania',
        'COUNTRY_MU' => 'Mauritius',
        'COUNTRY_YT' => 'Mayotte',
        'COUNTRY_MX' => 'Meksyk',
        'COUNTRY_FM' => 'Mikronezja, Federacja',
        'COUNTRY_MD' => 'Mołdawia, Republika',
        'COUNTRY_MC' => 'Monako',
        'COUNTRY_MN' => 'Mongolia',
        'COUNTRY_MS' => 'Montserrat',
        'COUNTRY_MA' => 'Maroko',
        'COUNTRY_MZ' => 'Mozambik',
        'COUNTRY_MM' => 'Myanmar',
        'COUNTRY_NA' => 'Namibia',
        'COUNTRY_NR' => 'Nauru',
        'COUNTRY_NP' => 'Nepal',
        'COUNTRY_NL' => 'Holandia',
        'COUNTRY_AN' => 'Antyle Niderlandzkie',
        'COUNTRY_NC' => 'Nowa Kaledonia',
        'COUNTRY_NZ' => 'Nowa Zelandia',
        'COUNTRY_NI' => 'Nikaragua',
        'COUNTRY_NE' => 'Niger',
        'COUNTRY_NG' => 'Nigeria',
        'COUNTRY_NU' => 'Niue',
        'COUNTRY_NF' => 'Wyspa Norfolk',
        'COUNTRY_MP' => 'Mariany Północne',
        'COUNTRY_NO' => 'Norwegia',
        'COUNTRY_OM' => 'Oman',
        'COUNTRY_PK' => 'Pakistan',
        'COUNTRY_PW' => 'Palau',
        'COUNTRY_PS' => 'Terytorium palestyńskie, okupowane',
        'COUNTRY_PA' => 'Panama',
        'COUNTRY_PG' => 'Papua-Nowa Gwinea',
        'COUNTRY_PY' => 'Paragwaj',
        'COUNTRY_PE' => 'Peru',
        'COUNTRY_PH' => 'Filipiny',
        'COUNTRY_PN' => 'Pitcairn',
        'COUNTRY_PL' => 'Polska',
        'COUNTRY_PT' => 'Portugalia',
        'COUNTRY_PR' => 'Portoryko',
        'COUNTRY_QA' => 'Katar',
        'COUNTRY_RE' => 'Reunion',
        'COUNTRY_RO' => 'Rumunia',
        'COUNTRY_RU' => 'Federacja rosyjska',
        'COUNTRY_RW' => 'Ruanda',
        'COUNTRY_SH' => 'Św. Helena',
        'COUNTRY_KN' => 'Saint Christopher (St Kitts) i Nevis',
        'COUNTRY_LC' => 'Św. Lucia',
        'COUNTRY_PM' => 'Saint-Pierre i Miquelon',
        'COUNTRY_VC' => 'Saint Vincent i Grenadiny',
        'COUNTRY_WS' => 'Samoa',
        'COUNTRY_SM' => 'San Marino',
        'COUNTRY_ST' => 'Wyspy Św. Tomasza i Książęca',
        'COUNTRY_SA' => 'Arabia Saudyjska',
        'COUNTRY_SN' => 'Senegal',
        'COUNTRY_CS' => 'Serbia i Montenegro',
        'COUNTRY_SC' => 'Seszele',
        'COUNTRY_SL' => 'Sierra Leone',
        'COUNTRY_SG' => 'Singapur',
        'COUNTRY_SK' => 'Słowacja',
        'COUNTRY_SI' => 'Słowenia',
        'COUNTRY_SB' => 'Wyspy Salomona',
        'COUNTRY_SO' => 'Somalia',
        'COUNTRY_ZA' => 'Południowa Afryka',
        'COUNTRY_GS' => 'Wyspy Południowej Georgi i południowe Sandwiche',
        'COUNTRY_ES' => 'Hiszpania',
        'COUNTRY_LK' => 'Sri Lanka',
        'COUNTRY_SD' => 'Sudan',
        'COUNTRY_SR' => 'Suriname',
        'COUNTRY_SJ' => 'Svalbard i Jan Mayen',
        'COUNTRY_SZ' => 'Suazi',
        'COUNTRY_SE' => 'Szwecja',
        'COUNTRY_CH' => 'Szwajcaria',
        'COUNTRY_SY' => 'Syrian Arab Republic',
        'COUNTRY_TW' => 'Tajwan',
        'COUNTRY_TJ' => 'Tadżikistan',
        'COUNTRY_TZ' => 'Tanzania, Zjednoczona Republika',
        'COUNTRY_TH' => 'Tajlandia',
        'COUNTRY_TL' => 'Timor Wschodni',
        'COUNTRY_TG' => 'Togo',
        'COUNTRY_TK' => 'Tokelau',
        'COUNTRY_TO' => 'Tonga',
        'COUNTRY_TT' => 'Trinidad i Tobago',
        'COUNTRY_TN' => 'Tunezja',
        'COUNTRY_TR' => 'Turcja',
        'COUNTRY_TM' => 'Turkmenistan',
        'COUNTRY_TC' => 'Wyspy Turks i Caicoa',
        'COUNTRY_TV' => 'Tuvalu',
        'COUNTRY_UG' => 'Uganda',
        'COUNTRY_UA' => 'Ukraina',
        'COUNTRY_AE' => 'Zjednoczone Emiraty Arabskie',
        'COUNTRY_GB' => 'Królestwo Zjednoczone',
        'COUNTRY_US' => 'Stany Zjednoczone',
        'COUNTRY_UM' => 'Odległe Mniejsze Wyspy Stanów Zjednoczonych',
        'COUNTRY_UY' => 'Uruguay',
        'COUNTRY_UZ' => 'Uzbekistan',
        'COUNTRY_VU' => 'Vanuatu',
        'COUNTRY_VA' => 'Państwo-Miasto Watykan',
        'COUNTRY_VE' => 'Wenezuela',
        'COUNTRY_VN' => 'Wietnam',
        'COUNTRY_VG' => 'Wyspy Dziewicze, Brytyjskie',
        'COUNTRY_VI' => 'Wyspy Dziewicze, U.S.',
        'COUNTRY_WF' => 'Wallis i Futuna',
        'COUNTRY_EH' => 'Zachodnia Sahara',
        'COUNTRY_YE' => 'Jemen',
        'COUNTRY_ZM' => 'Zambia',
        'COUNTRY_ZW' => 'Zimbabwe',
        'ERROR_LOG' => 'Dziennik błędów',
        'CANNOT_READ_ERROR_LOG' => 'Nie można przeczytać dziennika błędów',
        'CANNOT_OPEN_ERROR_LOG' => 'Nie można otworzyć dziennika błędów',
        'CANNOT_SCAN_ERROR_LOG' => 'Nie można przeskanować dziennika błędów',
        'MODELS_RESET' => 'Resetowanie modeli:',
        'NO_MODELS_RESET' => 'Brak resetowania modeli.',
        'NO_FEED_TO_DISPLAY' => 'Nie wyświetlasz obecnie żadnych elementów.',
        'BOX_WILL_NOT_SHOW_FEED' => 'To pole nie wyświetli się innym osobom, jeśli nie wybierzesz przynajmniej jednego elementu.',
        'CLICK_EDIT_TO_SPECIFY_FEED' => 'Kliknij przycisk Edytuj, aby określić źródło RSS dla tego pola.',
        'PROBLEM_OCCURRED_RETRIEVING_FEED' => 'Wystąpił problem pobierania tego źródła RSS.',
        'MORE_ELLIPSIS' => 'Więcej...',
        'RSS' => 'Źródło RSS',
        'WE_ARE_SORRY_SITE_HAS_ISSUE' => 'Przepraszamy, wystąpił błąd na stronie.',
        'PLEASE_TRY_REFRESHING' => 'Spróbuj odświeżyć stronę za 30 sekund lub <a %s>poinformuj nas</a>, jeśli ponownie otrzymasz tę wiadomość.',
        'NO_DISCUSSIONS_TAGGED_X' => 'Nie oznaczono żadnych dyskusji "%1$s".',
        'PAGE_TITLE_COLON' => 'Tytuł strony:',
        'PAGE_CONTENT' => 'Zawartość:',
        'CREATE_PAGE' => 'Utwórz stronę',
        'CREATE_NEW_PAGE' => 'Utwórz nową stronę',
        'YOUR_COMMENT' => 'Twój komentarz',
        'ADD_YOUR_COMMENT' => 'Dodaj Twój komentarz',
        'DELETE_PAGE' => 'Usuń tę stronę',
        'DELETE_THIS_PAGE_Q' => 'Usunąć tę stronę?',
        'ARE_YOU_SURE_DELETE_THIS_PAGE' => 'Czy na pewno chcesz usunąć tę stronę (w tym wszystkie komentarze)?  Proces może potrwać kilka minut.',
        'SEARCH_PAGES' => 'Wyszukuj strony',
        'ALL_PAGES' => 'Wszystkie strony',
        'SUBSCRIBE_TO_PAGES' => 'Subskrybuj te strony',
        'NOBODY_HAS_ADDED_PAGES' => 'Nikt jeszcze nie dodał żadnych stron!',
        'ADD_PAGES_CALL_TO_ACTION' => 'Utwórz stronę, aby rozpocząć.',
        'CREATE_A_PAGE' => 'Utwórz stronę',
        'PLEASE_ENTER_PAGE_CONTENT' => 'Wprowadź zawartość strony',
        'SEARCH_RESULTS_FOR_X' => 'Wyszukaj wyniki dla <em>%s</em>',
        'EDIT_YOUR_PAGE' => 'Edytuj Twoją stronę',
        'UPDATE_PAGE' => 'Aktualizuj stronę',
        'CLOSE_DISCUSSION' => 'Zamknij dyskusję',
        'REOPEN_DISCUSSION' => 'Ponownie otwórz dyskusję',
        'CLOSING_DISCUSSION_PREVENTS' => 'Zamknięcie dyskusji uniemożliwia dalsze odpowiedzi',
        'NO_DISCUSSION_TO_DISPLAY' => 'Obecnie nie wyświetlasz żadnych dyskusji.',
        'BOX_WILL_NOT_SHOW_DISCUSSION' => 'To pole nie wyświetli się innym osobom, jeśli nie zaznaczysz przynajmniej jednej dyskusji.',
        'NEWEST_DISCUSSIONS' => 'Najnowsze dyskusje',
        'LATEST_REPLIES' => 'Ostatnie odpowiedzi',
        'REPLIES_CLOSED_FOR_DISCUSSION' => 'Odpowiedzi są zamknięte dla tej dyskusji.',
        'SORRY_DISCUSSION_CLOSED' => 'Przepraszamy, ale ta dyskusja została właśnie zamknięta dla dalszych odpowiedzi.',
        'MOST_REPLIES' => 'Większość odpowiedzi',
        'OWNER_DISCUSSIONS_ONLY' => 'Tylko dyskusje autora',
        'MY_DISCUSSIONS_ONLY' => 'Tylko moje dyskusje',
        'DISCUSSION_DELETED' => 'Dyskusja usunięta',
        'DISCUSSION_HAS_BEEN_DELETED' => 'Ta dyskusja nie jest już dostępna.',
        'REPLY_DELETED' => 'Odpowiedź usunięta',
        'REPLY_HAS_BEEN_DELETED' => 'Ta odpowiedź została usunięta.  <a %s>Wróć do dyskusji. </a>',
        'VIEW_ALL_DISCUSSIONS' => 'Przeglądaj wszystkie dyskusje',
        'ADD_CATEGORIES' => 'Dodaj kategorie',
        'CATEGORY' => 'Kategoria:',
        'NO_DISCUSSIONS_IN_CATEGORY' => 'W tej kategorii nie ma jeszcze żadnych dyskusji.',
        'ADD_MANAGE_CATEGORIES' => 'Dodawaj/Zarządzaj kategoriami',
        'UNTITLED_CATEGORY' => 'Kategoria bez tytułu',
        'SAMPLE_TITLE' => 'Przykładowy tytuł',
        'UNCATEGORIZED' => 'Bez kategorii',
        'EXISTING_DISCUSSIONS' => 'Istniejące dyskusje, którym nie przypisano kategorii.',
        'YOU_HAVE_NOT_ADDED_CATEGORIES' => 'Nie ma w tej chwili żadnych kategorii.  Dodaj kategorię, aby rozpocząć!',
        'ADD_A_CATEGORY' => 'Dodaj kategorię',
        'ADD_ANOTHER_CATEGORY' => 'Dodaj następną kategorię',
        'MANAGE_CATEGORIES' => 'Zarządzaj kategoriami',
        'CATEGORY_TITLE' => 'Tytuł kategorii',
        'ALLOW_MEMBERS_TO_START_DISCUSSIONS' => 'Zezwalaj uczestnikom na rozpoczynanie dyskusji w tej kategorii',
        'ONLY_I_CAN_START_DISCUSSIONS' => 'Tylko ja mogę rozpoczynać dyskusje w tej kategorii',
        'ALLOW_MEMBERS_TO_REPLY' => 'Zezwalaj uczestnikom na odpowiadanie',
        'SUGGESTIONS' => 'Sugestie:',
        'TRY_DIFFERENT_KEYWORDS' => 'Spróbuj różnych lub bardziej ogólnych słów kluczowych',
        'VIEW_DISCUSSIONS_OR_START_DISCUSSION' => '<a %s>Przeglądaj wszystkie dyskusje</a> lub <a %s>Rozpocznij nową dyskusję</a>',
        'MAKE_SURE_WORDS_SPELLED' => 'Upewnij się, że wszystkie słowa zostały prawidłowo napisane',
        'REPLY_WAS_DELETED' => 'Ta odpowiedź została usunięta',
        'TAGS_X' => '<strong>Znaczniki:</strong> %s',
        'SEND_PRIVATE_MESSAGE' => 'Wyślij prywatną wiadomość',
        'PERMALINK_TO_REPLY' => 'Permalink do tej odpowiedzi',
        'PERMALINK' => 'Permalink',
        'WE_COULD_NOT_FIND_ANY_DISCUSSIONS' => 'Przepraszamy, nie znaleźliśmy żadnych dyskusji odpowiadających Twoim kryteriom wyszukiwania.',
        'DISCUSSIONS_MATCHING_X' => 'Dyskusje pasujące do <em>\'%s\'</em>',
        'SEARCH_DISCUSSIONS' => 'Wyszukuj dyskusje',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS_2' => 'Nie dodałeś jeszcze żadnych dyskusji!',
        'ADD_DISCUSSIONS_AND_SHARE' => 'Dodawaj dyskusje i udostępniaj je przyjaciołom, rodzinie i reszcie świata!',
        'DISCUSSION' => 'Dyskusja',
        'DISCUSSIONS' => 'Dyskusje',
        'KEEP_PAGE_OPEN_FORUM' => 'Strona powinna być otwarta, aby można było ukończyć przekazywanie Twoich plików na forum.',
        'MEANWHILE_FEEL_FREE_FORUM' => 'Tymczasem możesz <a %s>otworzyć nowe okno przeglądarki </a> i dalej korzystać z %s.',
        'START_A_NEW_DISCUSSION' => 'Rozpocznij nową dyskusję',
        'DISCUSSION_TITLE' => 'Tytuł dyskusji:',
        'FIRST_POST' => 'Artykuł:',
        'UPLOAD_FILES' => 'Dołącz plik(i):',
        'START_DISCUSSION' => 'Rozpocznij dyskusję',
        'EDIT_DISCUSSION' => 'Edytuj dyskusję',
        'START_A_DISCUSSION' => 'Rozpocznij dyskusję',
        'ALL_DISCUSSIONS' => 'Strona główna forum',
        'CONTRIBUTORS' => 'Współautorzy',
        'MY_DISCUSSIONS' => 'Moje dyskusje',
        'READ_MORE' => 'Czytaj więcej',
        'STARTED_T_BY' => 'Rozpoczęta <strong>%s</strong> przez:',
        'ADDED_BY_X_T' => 'Dodana przez %s %s',
        'STARTED_BY_X_T' => 'Rozpoczęta przez %s %s',
        'REPLY_BY_X_T' => 'Odpowiedział <strong>%s</strong> %s',
        'STARTED_BY_X_LAST_REPLY_LINK_BY_X_T' => 'Rozpoczęta przez %s.  Ostatnia <a %s>odpowiedź</a> od %s %s.',
        'STARTED_DISCUSSION_LAST_REPLY_LINK_BY_X_T' => '<strong>Rozpoczął tę dyskusję. </strong> Ostatnia <a %s>odpowiedź</a> od %s %s.',
        'STARTED_DISCUSSION_T' => '<strong>Rozpoczął tę dyskusję</strong> %s',
        'ADDED_REPLY_T' => '<strong>Dodał odpowiedź</strong> %s',
        'ADDED_POST_T' => '<strong>Dodał artykuł</strong> %s',
        'STARTED_BY_X_ON' => 'Rozpoczęta przez %s on %s',
        'STARTED_DISCUSSION_ON' => '<strong>Rozpoczął tę dyskusję</strong> %s',
        'STARTED_ON' => '<strong>Rozpoczął</strong> %s',
        'ADDED_REPLY_ON' => '<strong>Dodał odpowiedź</strong> %s',
        'ADDED_POST_ON' => '<strong>Dodał artykuł</strong> %s',
        'XS_DISCUSSIONS' => 'Dyskusje %s',
        'XS_DISCUSSIONS_LOWERCASE' => 'Dyskusje %s',
        'VIEW_XS_DISCUSSIONS' => 'Przeglądaj dyskusje %s',
        'VIEW_YOUR_DISCUSSIONS' => 'Przeglądaj swoje dyskusje',
        'TAGGED_X' => 'Oznaczona: %s',
        'SUBSCRIBE_TO_DISCUSSIONS' => 'Subskrybuj te dyskusje',
        'SUBSCRIBE_TO_DISCUSSION' => 'Subskrybuj tę dyskusję',
        'SUBSCRIBE_TO_XS_DISCUSSIONS' => 'Subskrybuj dyskusje %s',
        'ALL_DISCUSSIONS_TAGGED_X' => 'Wszystkie dyskusje oznaczone <em>\'%s\'</em>',
        'SUBSCRIBE_TO_DISCUSSIONS_TAGGED_X' => 'Subskrybuj dyskusje oznaczone \'%s\'',
        'N_KB' => '%s KB',
        'N_MB' => '%s MB',
        'UPLOADING_FILES' => 'Przekazywanie plików',
        'ATTACHMENTS' => 'Załączniki',
        'YOUR_POST' => 'Twój artykuł:',
        'YOUR_REPLY' => 'Twoja odpowiedź:',
        'WOULD_YOU_LIKE_TO_UPLOAD_FILES' => 'Chcesz przekazać pliki?',
        'ADD_YOUR_REPLY' => 'Dodaj Twoją odpowiedź',
        'REPLIES_TO_THIS_DISCUSSION' => 'Odpowiedzi do tej dyskusji',
        'POSTED_BY_X_ON' => 'Wysłana przez %s %s',
        'PLEASE_ENTER_TITLE' => 'Wprowadź tytuł dyskusji',
        'PLEASE_ENTER_FIRST_POST' => 'Wpisz pierwszy artykuł w tej dyskusji.',
        'REPLY_TO_THIS' => 'Odpowiedz na to',
        'DELETE_ATTACHMENT' => 'Usuń załącznik',
        'DELETE_ATTACHMENT_Q' => 'Usunąć ten załącznik?',
        'DELETE_REPLY' => 'Usuń odpowiedź',
        'DELETE_THIS_DISCUSSION_Q' => 'Usunąć tę dyskusję?',
        'ARE_YOU_SURE_DELETE_THIS_DISCUSSION' => 'Czy na pewno chcesz usunąć tę dyskusję (w tym wszystkie odpowiedzi)?  Proces może potrwać kilka minut.',
        'DELETE_DISCUSSION' => 'Usuń dyskusję',
        'NOBODY_HAS_ADDED_DISCUSSIONS' => 'Nikt jeszcze nie dodał żadnej dyskusji.',
        'NOBODY_HAS_ADDED_DISCUSSIONS_ADD' => 'Nikt jeszcze nie dodał żadnej dyskusji!  Dodaj dyskusję, aby rozpocząć.',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS' => 'Nie dodałeś jeszcze żadnych dyskusji.  Dodaj dyskusję, aby rozpocząć!',
        'YOU_HAVE_NOT_STARTED_DISCUSSIONS' => 'Nie rozpocząłeś jeszcze żadnej dyskusji.',
        'YOU_HAVE_NOT_ADDED_TO_DISCUSSIONS' => 'Nie dodałeś jeszcze żadnej dyskusji.',
        'X_HAS_NOT_ADDED_DISCUSSIONS' => '%s nie dodał jeszcze żadnej dyskusji.',
        'X_HAS_NOT_STARTED_DISCUSSIONS' => '%s nie rozpoczął jeszcze żadnej dyskusji.',
        'X_HAS_NOT_ADDED_TO_DISCUSSIONS' => '%s nie dodał jeszcze żadnej dyskusji.',
        'VIEW_DISCUSSIONS' => 'Przeglądaj dyskusje',
        'VIEW_ALL_PEOPLE_ON_X' => 'Przeglądaj wszystkie osoby na %s',
        'THERE_ARE_NO_DISCUSSIONS' => 'Obecnie nie ma żadnych dyskusji w Twojej sieci.',
        'GROUP_HAS_NO_DISCUSSIONS' => 'Ta grupa nie posiada jeszcze żadnych dyskusji.',
        'VIEW_DISCUSSIONS_IN_GROUP_FORUM' => 'Przeglądaj dyskusje na <a %s>%s forum</a>!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT_ADD' => 'Nie oznaczono żadnych dyskusji "%1$s".  Sprawdź <a %2$s>oznaczone zdjęcia "%1$s"</a> lub <a %3$s>oznaczone pliki wideo "%1$s"</a>.  Lub dodaj i oznacz swoje dyskusje!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT' => 'Nie oznaczono żadnych dyskusji "%1$s".  Sprawdź <a %2$s>oznaczone zdjęcia "%1$s"</a> lub <a %3$s>oznaczone pliki wideo "%1$s"</a>.',
        'THIS_BOX_WILL_NOT_SHOW_DISCUSSIONS' => 'To pole nie wyświetli się innym osobom, jeśli nie będzie żadnych dyskusji do wyświetlenia. Chcesz rozpocząć dyskusję?',
        'DISCUSSIONS_I_STARTED' => 'Dyskusje, które rozpocząłem',
        'DISCUSSIONS_X_STARTED' => 'Dyskusje %s rozpoczęte',
        'DISCUSSIONS_I_REPLIED_TO' => 'Dyskusje, na które odpowiedziałem',
        'DISCUSSIONS_X_REPLIED_TO' => 'Dyskusje, na które %s odpowiedział',
        'PLEASE_WRITE_SOMETHING_FOR_POST' => 'Napisz coś do swojego artykułu.',
        'PLEASE_WRITE_SOMETHING_FOR_REPLY' => 'Napisz coś do swojej odpowiedzi.',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION_X' => 'Nadszedł nowy komentarz do Twojej dyskusji "%s" na %s',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION' => 'Nadszedł nowy komentarz do jednej z Twoich dyskusji na %s',
        'SOMEBODY_COMMENTED_DISCUSSION_ADDED_TO_X' => 'ktoś napisał komentarz do dyskusji, którą rozpocząłeś na %s',
        'ABOUT_YOUR_DISCUSSION' => 'O Twojej dyskusji',
        'ABOUT_THIS_DISCUSSION' => 'O tej dyskusji',
        'USER_REPLIED_TO_A_DISCUSSION_ON_Y' => '%s odpowiedział w dyskusji na %s',
        'USER_REPLIED_TO_DISCUSSION_TITLE_ON_APPNAME' => '%s odpowiedział w dyskusji "%s" na %s',
        'PROBLEM_WITH_ICON' => 'Wystąpił problem z plikiem ikony',
        'GROUP_ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Administratorzy grupy mają podobny poziom kontroli jak autor grupy.',
        'CREATE_NEW_GROUP' => 'Utwórz nową grupę',
        'CREATE_A_NEW_GROUP' => 'Utwórz nową grupę',
        'CREATE_A_GROUP' => 'Utwórz grupę',
        'VIEW_GROUPS' => 'Przeglądaj grupy',
        'CREATE_GROUP' => 'Utwórz grupę',
        'PLEASE_ENTER_NAME_FOR_GROUP' => 'Wybierz nazwę dla swojej grupy.',
        'PLEASE_ENTER_URL_FOR_GROUP' => 'Wybierz adres www dla swojej grupy.',
        'URL_CAN_CONTAIN_ONLY_LETTERS' => 'Adres www może zawierać tylko litery i cyfry (bez spacji).',
        'NAME_TAKEN' => 'Przepraszamy - ta nazwa już istnieje.  Wybierz inną nazwę.',
        'URL_TAKEN' => 'Przepraszamy - ten adres www już istnieje.  Wybierz inny adres www.',
        'GROUP_INFORMATION' => 'Informacja o grupie',
        'EXTERNAL_WEBSITE' => 'Zewnętrzna strona internetowa',
        'DO_YOU_HAVE_EXISTING_WEBSITE' => 'Czy masz istniejącą stronę grupy gdzieś indziej?',
        'URL' => 'adres URL',
        'GROUPS' => 'Grupy',
        'SEARCH_GROUPS' => 'Wyszukaj grupy',
        'NOBODY_HAS_CREATED_GROUPS' => 'Nikt jeszcze nie utworzył żadnych grup.',
        'NOBODY_HAS_CREATED_GROUPS_ADD' => 'Nikt jeszcze nie utworzył żadnych grup!  Utwórz grupę, aby rozpocząć.',
        'MY_GROUPS' => 'Moje grupy',
        'FEATURED_GROUPS' => 'Zamieszczone grupy',
        'YOU_CAN_CREATE_GROUP' => 'Możesz <a %s>utworzyć nową grupę</a> na %s!',
        'GROUP_FORUM' => '%s Forum',
        'USER_CREATED_GROUP' => '%s utworzył tę grupę na %s.',
        'GROUP_MEMBERS_COUNT' => '%s Uczestnicy (%d)',
        'WE_ARE_SORRY_NOT_ALLOWED_JOIN_GROUP' => 'Przepraszamy, nie możesz przyłączyć się do tej grupy.',
        'JOIN_GROUP_NOW' => 'Dołącz do %s teraz!',
        'USER_HAS_INVITED_YOU_TO_JOIN_GROUP' => '%s zaprosił Cię, abyś się przyłączył do %s',
        'DECLINE' => 'Odrzuć',
        'WELCOME_TO_GROUP' => 'Witamy w %s',
        'YOU_CAN_PARTICIPATE_IN_GROUP' => 'Teraz możesz uczestniczyć w %s forum.',
        'SEND_MESSAGE_TO_GROUP' => 'Wyślij wiadomość do grupy',
        'LEAVE_THIS_GROUP' => 'Opuść grupę',
        'EDIT_GROUP_INFO' => 'Edytuj informacje o tej grupie',
        'EDIT_GROUP_INFORMATION' => 'Edytuj informacje o grupie',
        'MANAGE_GROUP_MEMBERS' => 'Zarządzaj uczestnikami grupy',
        'GROUP_HAS_NO_MEMBERS' => 'Do tej grupy nie należą jeszcze żadni uczestnicy!',
        'GROUP_HAS_NO_MEMBERS_THAT_MATCH' => 'Do tej grupy nie należą jeszcze żadni uczestnicy odpowiadający kryteriom wyszukiwania.',
        'USERS_GROUPS' => '%s\'s Grupy',
        'YOU_HAVE_NOT_CREATED_GROUPS' => 'Nie utworzyłeś jeszcze żadnych grup.',
        'USER_HAS_NOT_CREATED_GROUPS' => '%s nie utworzył jeszcze żadnych grup.',
        'THERE_ARE_NO_FEATURED_GROUPS' => 'W Twojej sieci społecznej nie umieszczono żadnych grup.',
        'START_FEATURING_GROUPS' => 'Rozpocznij zamieszczanie grup tam, gdzie widzisz opcję funkcji.  Aby dowiedzieć się więcej na temat zamieszczania, <a %s>kliknij tutaj</a>.',
        'NO_GROUPS_TO_DISPLAY' => 'Nie posiadasz obecnie żadnych grup.',
        'BOX_WILL_NOT_SHOW_GROUPS' => 'To pole nie wyświetli się innym osobom, jeśli nie zaznaczysz przynajmniej jednej grupy.',
        'YOU_HAVE_NOT_CREATED_GROUPS_2' => 'Nie utworzyłeś jeszcze żadnej grupy!',
        'CREATE_GROUPS_AND_SHARE' => 'Utwórz grupy i udostępniaj je przyjaciołom, rodzinie i reszcie świata!',
        'THERE_ARE_NO_GROUPS' => 'Obecnie w twojej sieci nie ma żadnych grup.',
        'THIS_BOX_WILL_NOT_SHOW_GROUPS' => 'To pole nie wyświetli się innym osobom, jeśli nie ma żadnych grup do wyświetlenia. Chcesz utworzyć grupę?',
        'GROUPS_MATCHING_SEARCH_TERM' => 'Grupy pasujące <em>\'%s\'</em>',
        'WE_COULD_NOT_FIND_ANY_GROUPS' => 'Przepraszamy – nie znaleźliśmy żadnych grup odpowiadających kryteriom wyszukiwania.',
        'VIEW_GROUPS_OR_CREATE_GROUP' => '<a %s>Przeglądaj wszystkie grupy</a> lub <a %s>Utwórz nową grupę</a>',
        'VIEW_ALL_GROUPS' => 'Przeglądaj wszystkie grupy',
        'DELETE_GROUP' => 'Usuń grupę',
        'DELETE_GROUP_Q' => 'Jesteś pewien, że chcesz usunąć tę grupę?',
        'GROUP_INVITATIONS' => 'Zaproszenia grupowe',
        'YOU_HAVE_BEEN_INVITED_TO_JOIN' => 'Zostałeś zaproszony do przyłączenia się:',
        'VISIT' => 'Odwiedź',
        'WHO_CAN_JOIN_GROUP' => 'Kto może przyłączyć się do tej grupy?',
        'PRIVACY_CANNOT_BE_CHANGED' => 'Nie można zmienić prywatności po utworzeniu grupy.',
        'ONLY_INVITED_PEOPLE' => 'Tylko osoby zaproszone',
        'ALLOW_PEOPLE_TO_REQUEST' => 'Zezwalaj osobom prosić o zaproszenie',
        'ANYONE_CAN_JOIN_GROUP' => 'Każdy może przyłączyć się do tej grupy',
        'ONLY_INVITED_PEOPLE_CAN_JOIN_GROUP' => 'Tylko osoby zaproszone mogą przyłączyć się do tej grupy',
        'WHY_NOT_CREATE_GROUP' => 'Chcesz <a %s>utworzyć własną grupę</a>?',
        'PLEASE_ENTER_NAME' => 'Wprowadź swoją nazwę',
        'PLEASE_ENTER_EMAIL_ADDRESS' => 'Wprowadź swój adres e-mail.',
        'PLEASE_ENTER_PAGE_ADDRESS' => 'Wprowadź nowy adres strony.',
        'PLEASE_ENTER_PASSWORD' => 'Wprowadź swoje hasło.',
        'CREATE_ACCOUNT_OR_SIGN_IN' => '<a %s>Kliknij tutaj, aby utworzyć nowe konto</a> lub spróbuj zarejestrować się ponownie poniżej.',
        'CREATE_ACCOUNT_OR_JOIN' => '<a %s>Kliknij tutaj, aby utworzyć nowe konto</a> lub spróbuj połączyć się ze swoim ID Ning ponownie poniżej.',
        'CHOOSE_SHORTER_PASSWORD' => 'Wybierz krótsze hasło.',
        'CHOOSE_SHORTER_NAME' => 'Wybierz krótszą nazwę.',
        'ENTER_SHORTER_CITY_NAME' => 'Wprowadź krótszą nazwę miasta.',
        'PLEASE_ENTER_PASSWORD_AGAIN' => 'Wprowadź ponownie swoje hasło w polu "Wpisz ponownie hasło".',
        'PLEASE_ENTER_CURRENT_PASSWORD' => 'Wprowadź swoje bieżące hasło.',
        'PLEASE_ENTER_NEW_PASSWORD' => 'Wprowadź swoje nowe hasło.',
        'PLEASE_ENTER_NEW_PASSWORD_AGAIN' => 'Wprowadź swoje nowe hasło ponownie w polu "Potwiedź hasło".',
        'CURRENT_PASSWORD' => 'Bieżące hasło',
        'PASSWORDS_DO_NOT_MATCH' => 'Hasła nie pasują do siebie.',
        'NEW_AND_CONFIRMATION_PASSWORDS' => 'Nowe hasło i potwierdzenie hasła nie pasują do siebie.',
        'YOUR_REQUEST_HAS_BEEN_SENT_TO_GROUP_CREATOR' => 'Twoja prośba została wysłana do autora grupy.',
        'X_IS_NOT_VALID_EMAIL_ADDRESS' => '%s nie jest prawidłowym adresem e-mail',
        'COME_JOIN_ME_ON_GROUP' => 'Przyłącz się do mnie %s!',
        'INVITE_PEOPLE_TO_GROUP' => 'Zapraszaj ludzi do %s',
        'INVITE_FRIENDS_TO_GROUP' => 'Zapraszaj przyjaciół do %s',
        'SEND_INVITATIONS_TO_JOIN_GROUP' => 'Wysyłaj zaproszenia innym osobom, aby przyłączyli się do %s.',
        'GROUPNAME_MEMBERS' => '%s Uczestnicy',
        'GROUP_CREATOR' => 'Autor grypy',
        'GROUP_ADMINISTRATOR' => 'Administrator grupy',
        'DATE_BANNED' => 'Data zablokowana',
        'BAN_FROM_GROUP' => 'Zablokuj w grupie',
        'ARE_YOU_SURE_BAN_MEMBER_FROM_GROUP' => 'Jesteś pewny, że chcesz zablokować zaznaczonych uczestników w swojej grupie?  Proces może potrwać kilka minut.',
        'ALSO_DELETE_FORUM_POSTINGS' => 'Usuń również ich artykuły i odpowiedzi na forum.',
        'GROUP_WEB_ADDRESS' => 'Adres sieciowy grupy',
        'GROUP' => 'Grupa',
        'BACK_TO_GROUP' => '←  Wróć do %s',
        'USER_BANNED_FROM_GROUP' => '%1$s został zablokowany w grupie.  <a %2$s>Wyślij %1$s komunikat</a>',
        'USER_ALREADY_GROUP_MEMBER' => '%1$s jest już uczestnikiem tej grupy.  <a %2$s>Wyślij %1$s komunikat</a>',
        'GROUP_ADMIN_DISCUSSIONS' => 'Dyskusje administratorów grupy',
        'BACK_TO_NETWORK_GROUPS' => 'Wróć do %s grup',
        'MOST_MEMBERS' => 'Większość uczestników',
        'THIS_SETS_URL_OF_GROUP' => 'Ustala adres URL Twojej grupy:<br />http://%s/<strong>adresgrupysieciowej</strong>',
        'LIKE_WHAT_YOU_SEE' => 'Tak jak widzisz na %s?  Przyłącz się teraz!',
        'LIKE_WHAT_YOU_SEE_GROUP' => 'Tak jak widzisz w %s?  Przyłącz się teraz!',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => 'Utworzyłeś grupę %1$s. Możesz rozpocząć dyskusję na forum %1$s lub zaprosić inne osoby, aby się przyłączyły.',
        'YOU_ARE_MEMBER_OF_GROUP_AND_CAN_INVITE' => 'Jesteś teraz uczestnikiem %1$s.  Możesz wziąć udział w forum %1$s lub zaprosić inne osoby, aby się przyłączyły.',
        'NETWORK_DOES_NOT_HAVE_MUSIC' => 'Ta sieć nie ma jeszcze muzyki.',
        'PERSON_DOES_NOT_HAVE_MUSIC' => 'Ta osoba nie ma jeszcze muzyki.',
        'FIND_MORE_MUSIC_LIKE_THIS' => 'Znajdź więcej takiej muzyki na <em>%s</em>',
        'TRACKS' => 'Ścieżki',
        'ADD_MUSIC_TRACKS' => 'Dodaj muzykę',
        'CHOOSE_MUSIC_TRACKS' => 'Wybierz utwory do dodania',
        'YOU_CAN_ADD_UP_TO_MP3' => 'Możesz dodawać na raz 4 pliki MP3.',
        'UPLOAD_TRACKS' => 'Przekaż utwory',
        'ADD_TRACKS' => 'Dodaj utwory',
        'ENTER_THE_URL_MP3_TO_ADD' => 'Wprowadź adres URL każdego pliku MP3, który chcesz dodać:',
        'EACH_MP3_FILE_MAY_BE_UP_TO' => 'Możesz przekazać do 100 plików MP3!  Każdy plik MP3 może mieć rozmiar do 20 MB, ale mniejsze pliki będą szybciej przekazane.',
        'BE_NICE' => 'Bądź uczciwy',
        'PLEASE_UPLOAD_ONLY_TRACKS' => 'Przekazuj utwory tylko wtedy, gdy masz na to pozwolenie artysty lub posiadacza praw autorskich.',
        'PLEASE_LINK_ONLY_TRACKS' => 'Łącz się tylko z muzyką, która została autoryzowana do rozpowszechniania w sieci.',
        'MORE_WAY_TO_ADD_MUSIC' => 'Inne sposoby, aby dodać muzykę...',
        'ELLIP_FROM_ANOTHER_WEBSITE' => '...z innej strony internetowej',
        'ADD_MUSIC_FROM_ANY_WEBSITE' => 'Dodawaj muzykę ze strony internetowej, wklejając łącze pliku MP3.',
        'KEEP_PAGE_OPEN_MUSIC' => 'Strona powinna być otwarta, aby zakończyć przekazywanie Twoich utworów. Powiadomimy Cię, gdy utwory zostaną zatwierdzone!',
        'MEANWHILE_FEEL_FREE_MUSIC' => 'Tymczasem możesz <a %s>otworzyć nowe okno przeglądarki </a> i dalej korzystać z %s.  Po zakończeniu przekazywania będziesz mógł w tym oknie dodać tytuły i opisy do swoich utworów.',
        'TRACKS_EXCEEDED_LIMIT' => 'Pliki przekroczyły ograniczenie 10 MB na utwór.',
        'EDIT_TRACK_INFORMATION' => 'Edytuj informacje o utworze',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_1' => 'Dodaj tytuł, opis i inne informacje do utworów, które właśnie przekazałeś.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_2' => 'Dodaj tytuł, opis i inne informacje do tego utworu.',
        'CANCEL_AND_RETURN_TO_PLAYLIST' => '« Usuń i wróć do listy odtwarzania',
        'TRACK_TITLE' => 'Tytuł utworu',
        'TRACK_ARTIST' => 'Artysta',
        'TRACK_ALBUM' => 'Album',
        'ENABLE_DOWNLOAD_LINK' => 'Udostępnij łącze pobierania',
        'ALLOW_PEOPLE_TO_ADD_TRACK_TO_PROFILE' => 'Zezwalaj, aby inne osoby umieszczały ten utwór na swoich stronach',
        'TRACK_ARTWORK' => 'Grafika',
        'EDIT_PLAYLIST' => 'Edytuj listę odtwarzania',
        'DRAG_TO_CHANGE_ORDER_PLAYLIST' => 'Aby zmienić kolejność Twojej listy odtwarzania, kliknij utwór i przeciągnij go w miejsce, gdzie ma być odtwarzany.',
        'ADD_MUSIC_ELLIPSIS' => 'Dodaj muzykę ...',
        'ELLIPSIS_FROM_YOUR_COMPUTER' => '… z tego komputera',
        'UPLOAD_MP3_FROM_YOUR_COMPUTER' => 'Przekaż pliki MP3 z twojego komputera.',
        'DELETE_THIS_TRACK_Q' => 'Usunąć ten utwór?',
        'DELETE_TRACK' => 'Usuń utwór',
        'ARE_YOU_SURE_DELETE_THIS_TRACK' => 'Czy na pewno chcesz usunąć ten utwór?',
        'PLAY' => 'odtwórz',
        'GENRE' => 'Gatunek',
        'YEAR' => 'Rok',
        'LABEL' => 'Etykieta',
        'EXPLICIT_LYRICS' => 'Wulgarne słownictwo',
        'ARTIST_SITE' => 'Strona artysty',
        'HOSTING_SITE' => 'Strona hosta',
        'LABEL_SITE' => 'Strona etykiety',
        'LICENSE' => 'Licencja',
        'SELECT_LICENSE' => '— Select license —',
        'LICENSE_NAME' => 'Nazwa licencji',
        'LICENSE_URL' => 'Adres URL licencji',
        'MUSIC' => 'Muzyka',
        'ALLOW_PEOPLE_TO_UPLOAD_AND_SHARE_AUDIO' => 'Zezwalaj innych osobom przekazywać i udostępniać pliki audio',
        'PLAYLIST' => 'Lista odtwarzania',
        'PODCAST' => 'Podcast',
        'MOST_RECENT_TRACKS' => 'Najnowsze',
        'FEATURED_TRACKS' => 'Zamieszczone',
        'HIGHEST_RATED_TRACKS' => 'Najwyżej oceniane',
        'NO_TRACKS_TO_PLAY' => 'Obecnie nie ma żadnej muzyki w Twojej sieci.',
        'BOX_WILL_NOT_SHOW_TRACKS' => 'To pole nie wyświetli się innym osobom, jeśli nie ma żadnego utworu ani podcastu do odtwarzania. Chcesz dodać utwór lub podcast?',
        'NO_TRACKS_ON_PLAYLIST' => 'Na liście odtwarzania nie ma obecnie żadnych utworów.',
        'PLAYER_WILL_NOT_SHOW_TRACKS' => 'Ten odtwarzacz nie wyświetli się innym osobom, jeśli nie ma żadnego utworu ani podcastu do odtwarzania. Chcesz dodać utwór lub podcast?',
        'NO_FEATURED_TRACKS' => 'W Twojej sieci nie umieszczono żadnych utworów.',
        'START_FEATURING_TRACKS' => 'Rozpocznij zamieszczanie utworów gdy usłyszysz utwór do umieszczenia na stronie głównej.',
        'VIEW_MUSICPLAYER' => 'Przeglądaj odtwarzacz muzyczny',
        'MY_PLAYLIST' => 'Moja lista odtwarzania',
        'NETWORK_PLAYLIST' => 'Lista odtwarzania sieci',
        'COPYRIGHT' => '© Wszelkie prawa zastrzeżone',
        'CC_BY_X' => 'Uznanie Creative Commons %s',
        'CC_BY_SA_X' => 'Uznanie Creative Commons Udostępniaj podobnie %s',
        'CC_BY_ND_X' => 'Uznanie Creative Commons Brak pochodnych %s',
        'CC_BY_NC_X' => 'Uznanie Creative Commons Niekomercyjny %s',
        'CC_BY_NC_SA_X' => 'Uznanie Creative Commons Niekomercyjny, udostępniaj podobnie %s',
        'CC_BY_NC_ND_X' => 'Uznanie Creative Commons Niekomercyjny, brak pochodnych %s',
        'PUBLICDOMAIN' => 'Domena publiczna',
        'FACEBOOK_CONFIRM_DISABLE' => 'Na pewno?',
        'FACEBOOK_PLAYER_DISABLE' => 'Wyłącz',
        'FACEBOOK_MUSIC_PLAYER_TITLE' => 'Odtwarzacz plików muzycznych',
        'FACEBOOK_MUSIC_PLAYER_DESC' => 'Zezwalaj wszystkim na dodawanie aplikacji do ich stron profilów w programie Facebook, która odtwarza Twoją wybraną muzykę.',
        'FACEBOOK_MUSIC_BUTTON' => 'Utwórz aplikacje muzyczną &raquo;',
        'FACEBOOK_MUSIC_PLAYER_ENABLED' => 'Odtwarzacz muzyczny programu Facebook już włączony.',
        'FACEBOOK_VIDEO_PLAYER_TITLE' => 'Odtwarzacz wideo',
        'FACEBOOK_VIDEO_PLAYER_DESC' => 'Zezwalaj wszystkim na dodawanie aplikacji do ich stron profilu w programie Facebook, która odtwarza plik wideo z Twojej sieci.',
        'FACEBOOK_VIDEO_BUTTON' => 'Utwórz aplikację wideo &raquo;',
        'FACEBOOK_VIDEO_PLAYER_ENABLED' => 'Odtwarzacz muzyczny programu Facebook już włączony.',
        'FACEBOOK_SLIDESHOW_PLAYER_TITLE' => 'Pokaz slajdów',
        'FACEBOOK_SLIDESHOW_PLAYER_DESC' => 'Zezwalaj wszystkim na dodawanie aplikacji do ich stron profilu w programie Facebook, która odtwarza pokaz slajdów z Twojej sieci.',
        'FACEBOOK_SLIDESHOW_BUTTON' => 'Utwórz aplikację pokazu slajdów &raquo;',
        'FACEBOOK_SLIDESHOW_PLAYER_ENABLED' => 'Pokaz slajdów programu Facebook już włączony.',
        'FACEBOOK_PLATFORM_LOGO' => 'Logo platformy Facebook',
        'FACEBOOK_QUICK_INTRO_1' => 'Facebook, popularna strona sieci społecznych, pozwala zewnętrznym programistom tworzyć aplikacje, które można dodawać do stron profilów uczestników programu Facebook.  Dodatkowo poza funkcją dodawania do strony profilu, aplikacji tych można używać, aby przyciągnąć użytkowników programu Facebook do innych stron internetowych.',
        'FACEBOOK_QUICK_INTRO_2' => 'Dzięki Ning, nie musisz być programistą, aby promować swoją sieć społeczną w programie Facebook.  Wykonaliśmy cały lifting i Twoja sieć jest domyślnie zintegrowana z aplikacją Facebook.  Wystarczy wybrać z poniższych opcji, a Twoja sieć społeczna w jednej chwili będzie zintegrowana z programem Facebook.',
        'FACEBOOK_ADD_DEVELOPER_BUTTON' => 'Dodaj przycisk programisty',
        'FACEBOOK_SETUP_NEW_APP_BUTTON' => 'Konfiguruj przycisk nowej aplikacji',
        'FACEBOOK_YOUR_APPLICATIONS' => 'Twoje aplikacje Facebook',
        'FACEBOOK_EMBEDDING' => 'Promocja programu Facebook',
        'FACEBOOK_SETUP' => 'Promocja programu Facebook',
        'FACEBOOK_PROMOTING' => 'Promowanie aplikacji w programie Facebook',
        'FACEBOOK_VIEW_APP' => 'Przeglądaj aplikację',
        'FACEBOOK_ADD_THE' => 'Dodaj',
        'FACEBOOK_RECENT' => 'Najnowsze',
        'FACEBOOK_RECENTLY_FEATURED' => 'Ostatnio zamieszczone',
        'FACEBOOK_RECENTLY_ADDED' => 'Ostatnio dodane',
        'FACEBOOK_PROMOTED' => 'Zamieszczone',
        'FACEBOOK_RATED' => 'Najwyżej oceniane',
        'FACEBOOK_POPULAR' => 'Popularne',
        'FACEBOOK_MUSIC_WIDGET' => 'Element widget muzyki',
        'FACEBOOK_VIDEO_WIDGET' => 'Element widget plików wideo',
        'FACEBOOK_PHOTO_WIDGET' => 'Element widget zdjęć',
        'FACEBOOK_INSTR_FIRST_STEPS' => 'Pierwsze kroki',
        'FACEBOOK_INSTR_CLICK_HERE_TO_GO_TO_FACEBOOK' => 'Kliknij tutaj, aby przejść do programu Facebook i uruchomić tworzenie swojej aplikacji.',
        'FACEBOOK_INSTR_OPEN_FACEBOOK_IN_NEW_WINDOW' => 'Spowoduje to otwarcie programu Facebook w nowym oknie.  Jeśli nie jesteś jeszcze zalogowany w programie Facebook, będziesz musiał zalogować się teraz.',
        'FACEBOOK_INSTR_FIRST_STEPS_1' => 'Jeśli nie utworzyłeś aplikacji w programie Facebook, będziesz poproszony o dodanie aplikacji Programisty programu Facebook.  Po wykonaniu tego, aplikacja informuje "Nie masz żadnych aplikacji. " Kliknij przycisk <strong>Utwórz</strong>.',
        'FACEBOOK_INSTR_FIRST_STEPS_2' => 'Jeśli już utworzyłeś aplikację w programie Facebook, przejdziesz do aplikacji Programisty programu Facebook.  Kliknij przycisk <strong>Konfiguruj nową aplikację</strong>.',
        'FACEBOOK_INSTR_FIRST_STEPS_NEXT' => 'Następnie: Instrukcje dotyczące konfiguracji Twojej %s aplikacji, aby działała w programie Facebook.',
        'FACEBOOK_INSTR_SETUP' => 'Instrukcje dotyczące konfiguracji',
        'FACEBOOK_INSTR_SETUP_1' => 'Wspaniale!  Teraz szczegóły.  Program Facebook potrzebuje kilku podstawowych informacji, aby uruchomić Twoją aplikację.  Wystarczy postępować zgodnie z poniższymi krokami.',
        'FACEBOOK_INSTR_SETUP_REQ_FIELDS' => 'Pola wymagane',
        'FACEBOOK_INSTR_SETUP_2' => 'Wybierz <strong>Nazwę aplikacji</strong>.',
        'FACEBOOK_INSTR_SETUP_3' => 'Pamiętaj, aby zaznaczyć, że przeczytałeś warunki programu Facebook.',
        'FACEBOOK_INSTR_SETUP_4' => 'Otwórz sekcję <em>Pola opcjonalne</em>.',
        'FACEBOOK_INSTR_SETUP_BASE_OPT' => 'Podstawowe opcje',
        'FACEBOOK_INSTR_SETUP_5' => 'Umieść swój adres e-mail w polu <strong>E-mail wsparcia technicznego</strong>.',
        'FACEBOOK_INSTR_SETUP_6' => 'Wklej następujący adres internetowy w polu <strong>Wywołaj adres URL</strong>:',
        'FACEBOOK_INSTR_SETUP_7_EXAMPLE_X' => 'Wybierz <strong>Adres URL strony Canvas</strong> (np. <em>%s</em>).',
        'FACEBOOK_INSTR_SETUP_8' => 'Zaznacz <strong>Tak</strong> dla pola <em>Czy można dodać Twoją aplikację do programu Facebook</em>.',
        'FACEBOOK_INSTR_SETUP_INST_OPT' => 'Opcje instalacji',
        'FACEBOOK_INSTR_SETUP_APP_DESC' => 'Napisz <strong>Opis aplikacji</strong>.',
        'FACEBOOK_INSTR_SETUP_9' => 'Wklej poniższy kod w pole <strong>Domyślne FBML</strong>:',
        'FACEBOOK_INSTR_SETUP_9B_WIDE' => 'W przypadku <strong>Domyślnej kolumny pola profilu</strong>, zaznacz <strong>Szeroka</strong>.',
        'FACEBOOK_INSTR_SETUP_9B_NARROW' => 'W przypadku <strong>Domyślnej kolumny pola profilu </strong>, zaznacz <strong>Wąska</strong>.',
        'FACEBOOK_INSTR_SETUP_10' => 'W polu <strong>Adres URL nawigacji strony</strong> wprowadź swój <em>Adres URL strony Canvasem> (zgodnie z krokiem &#8216; f&#8217;  powyżej).  Pamiętaj, aby zawrzeć część adresu URL http://apps.facebook.com/.',
        'FACEBOOK_INSTR_SETUP_11' => 'Napisz tekst dla <strong>Akcja załącznika</strong>.  To pojawia się kiedy wysyłasz komuś wiadomość w programie Facebook i chcesz zawrzeć jedną ze swoich aplikacji.  Jeśli Twoją aplikacją jest pokaz slajdów, możesz wprowadzić zdjęcia z nazwy sieci.  Jeśli Twoją aplikacją jest odtwarzacz muzyczny, możesz wprowadzić pliki wideo z nazwy sieci.',
        'FACEBOOK_INSTR_SETUP_12' => 'Wklej następujący adres internetowy w polu <strong>Wywołaj adres URL</strong>:',
        'FACEBOOK_INSTR_APPLICATION_SETUP_PAGE' => 'Strona konfiguracji aplikacji Facebook',
        'FACEBOOK_INSTR_SETUP_DONE' => 'Po zakończeniu, kliknij przycisk <strong>Prześlij</strong>.',
        'FACEBOOK_INSTR_SETUP_NEXT' => 'Następnie: Pobieranie klucza API i klucza tajnego.',
        'FACEBOOK_API_INFO_TITLE' => 'Informacja API programu Facebook',
        'FACEBOOK_API_INFO_DESC' => 'Aby zakończyć konfigurację, musisz wprowadzić w poniższych polach swój klucz i klucz tajny API oraz adres URL swojej aplikacji.',
        'FACEBOOK_API_INFO_FIND_KEY' => 'Możesz znaleźć swój klucz i klucz tajny API na stronie <a %s>Moje aplikacje w programie Facebook</a> (otwiera się w nowym oknie) pod tytułem aplikacji, którą właśnie utworzyłeś.',
        'FACEBOOK_API_INFO_MY_APPLICATIONS_PAGE' => 'Strona Moje aplikacje (wyróżnia lokalizację informacji API)',
        'FACEBOOK_API_INFO_KEY' => 'Klucz API',
        'FACEBOOK_API_INFO_SECRET' => 'Klucz tajny API',
        'FACEBOOK_URL_INFO_TITLE' => 'Adres URL aplikacji Facebook',
        'FACEBOOK_URL_INFO_DESC' => 'Adres URL aplikacji jest taki sam jak <strong>Adres URL strony Canvas</strong>, który  zdefiniowałeś na poprzedniej stronie (w kroku &#8216; f&#8217; ).',
        'FACEBOOK_MUSIC_SHOULD_PLAY_FROM' => 'Aplikacje muzyczne programu Facebook powinny odtwarzać:',
        'FACEBOOK_VIDEO_SHOULD_PLAY_FROM' => 'Aplikacje wideo programu Facebook powinny odtwarzać pliki wideo tzn.:',
        'FACEBOOK_PHOTO_SHOULD_PLAY_FROM' => 'Aplikacje pokazu slajdów programu Facebook powinny odtwarzać zdjęcia z:',
        'FACEBOOK_PROMOTING_ON' => 'Promocja w programie Facebook',
        'FACEBOOK_SETUP_INSTR' => 'Instrukcje dotyczące konfiguracji',
        'FACEBOOK_API_INFO' => 'Informacja API',
        'FACEBOOK_DISABLE' => 'Wyłącz tę aplikację',
        'FACEBOOK_TO_YOUR_FACEBOOK_PROFILE' => 'do swojego profilu w programie Facebook',
        'FACEBOOK_BACK_TO_EMBEDDING' => 'Wróć do Promocji programu Facebook',
        'FACEBOOK_EMBEDDING_DESC' => 'Zezwalaj użytkownikom Facebook umieszczać elementy widget i oznaczenia Twojej sieci na stronach swojego profilu.',
        'FACEBOOK_PROMOTE' => 'Aby wypromować nową aplikację w najlepszy możliwy sposób, zalecamy postępować zgodnie z poniższymi krokami.  Dostęp do tych opcji możliwy jest ze strony Facebook <strong><a %s>Moje aplikacje</a></strong> (łącze otwiera się w nowym oknie).',
        'FACEBOOK_PROMOTE_TITLE_ABOUT_PAGE' => 'Podaj informacje o stronie',
        'FACEBOOK_PROMOTE_TEXT_ABOUT_PAGE' => 'Pozwól użytkownikom Facebook dowiedzieć się czego dotyczy Twoja aplikacja, zapewniając przejrzysty opis.  Aby edytować te informacje, kliknij łącze <strong>Edytuj informacje o stronie</strong> obok aplikacji, którą modyfikujesz.',
        'FACEBOOK_PROMOTE_TITLE_SUBMIT' => 'Złóż aplikację w katalogu Facebook',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_1' => 'Promuj swoją nową aplikację dodając ją do katalogu Facebook.',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_2' => 'Aby złożyć aplikację, kliknij łącze <strong>Złóż aplikację</strong> obok aplikacji, którą modyfikujesz.  Na następnej stronie możesz edytować Opis aplikacji i również dodać logo swojej aplikacji.',
        'FACEBOOK_PROMOTE_TITLE_PROFILE' => 'Dodaj aplikację do swojego profilu Facebook',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_1' => 'Pokazuj swoją aplikację dodając ją do swojego profilu programu Facebook, a potem poczekaj i obserwuj jak Twoi przyjaciele robią to samo.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_2' => 'Kliknij łącze <strong>Przeglądaj informacje o stronie</strong> obok aplikacji, którą chcesz dodać do swojego profilu, następnie na następnej stronie wybierz przycisk Dodaj aplikację.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_3' => 'Twoja aplikacja znajduje się teraz na dole strony Twojego profilu programu Facebook!',
        'FACEBOOK_PROMOTE_MY_APPLICATIONS_PAGE' => 'Strona Moje aplikacje w programie Facebook',
        'FACEBOOK_MY_APPS' => 'Moje aplikacje',
        'FORUM_TAB_TEXT' => 'Forum',
        'VIDEOS_TAB_TEXT' => 'Wideo',
        'PHOTOS_TAB_TEXT' => 'Zdjęcia',
        'GROUPS_TAB_TEXT' => 'Grupy',
    );

    /**
     * If the given widget title is the default English title for the widget,
     * translate it into the current language.
     *
     * @param string $widgetTitle  The title of the widget
     * @return string  A translated title if the title is the English default; otherwise, the title unchanged
     */
    public static function translateDefaultWidgetTitle($widgetTitle) {

        return $widgetTitle;
    }

}