<?php

XG_App::includeFileOnce('/lib/XG_AbstractMessageCatalog.php');

/**
 * Texts for the Norway locale.
 */
class XG_MessageCatalog_no_NO extends XG_AbstractMessageCatalog {


    /**
     * Returns a localized version of a string. The first argument is the message name, e.g., 'ADD_A_PHOTO'.
     * Subsequent arguments are substitution values (if the message contains sprintf format elements).
     *
     * @param array $args the message name, plus optional substitution values
     * @return string the localized string
     * @see xg_html()
     */
    public static function text($args) {
        $s = $args[0];
        static $a = array();
        if (! $a) {
            $a['N_SECONDS_AGO']['1'] = 'For ett sekund siden ';
            $a['N_SECONDS_AGO']['n'] = 'For %s sekunder siden ';
            $a['N_MINUTES_AGO']['1'] = 'For ett minutt siden ';
            $a['N_MINUTES_AGO']['n'] = 'For %s minutter siden ';
            $a['N_HOURS_AGO']['1'] = 'For én time siden ';
            $a['N_HOURS_AGO']['n'] = 'For %s timer siden ';
            $a['N_VIDEOS']['1'] = '<strong>én</strong> video ';
            $a['N_VIDEOS']['n'] = '<strong>%s</strong> videoer ';
            $a['N_VIEWS']['1'] = 'Én visning ';
            $a['N_VIEWS']['n'] = '%s visninger ';
            $a['N_COMMENTS']['1'] = '<span class="comment-count">én</span> kommentar ';
            $a['N_COMMENTS']['n'] = '<span class="comment-count">%s</span> kommentarer ';
            $a['VIDEO_IS_FAVORITE_OF']['1'] = 'Denne videoen er <strong>favoritten</strong> til <strong>én person</strong>. ';
            $a['VIDEO_IS_FAVORITE_OF']['n'] = 'Denne vidoen er <strong>favoritten</strong> til <strong>%s personer</strong>. ';
            $a['Y_ADDED_X_VIDEOS']['1'] = '%2$s la til én video: ';
            $a['Y_ADDED_X_VIDEOS']['n'] = '%2$s la til %s videoer. ';
            $a['YOU_ADDED_X_VIDEOS']['1'] = 'Du la til en video: ';
            $a['YOU_ADDED_X_VIDEOS']['n'] = 'Du la til %s videoer. ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['1'] = 'Det finnes én video på %2$s ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['n'] = 'Det finnes %1$s videoer på %2$s ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['1'] = 'Det finnes én <a href="%3$s">video</a> på %2$s ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['n'] = 'Det finnes %1$s <a href="%3$s">videoer</a> på %2$s ';
            $a['N_PHOTOS_FROM_ALBUM']['1'] = 'Ett bilde i dette albumet har blitt slettet eller klassifisert som privat, så det kan ikke vises. ';
            $a['N_PHOTOS_FROM_ALBUM']['n'] = '%s bilder i dette albumet har blitt slettet eller klassifisert som private, så de kan ikke vises. ';
            $a['N_PHOTOS']['1'] = '<strong>Ett</strong> bilde ';
            $a['N_PHOTOS']['n'] = '<strong>%s</strong> bilder ';
            $a['N_PHOTOS_2']['1'] = 'Ett bilde ';
            $a['N_PHOTOS_2']['n'] = '%s bilder ';
            $a['PROBLEM_UPLOADING_FILES']['1'] = 'Det oppsto et problem under opplastingen av følgende fil: ';
            $a['PROBLEM_UPLOADING_FILES']['n'] = 'Det oppsto et problem under opplastingen av følgende fil: ';
            $a['PHOTO_IS_FAVORITE_OF']['1'] = 'Dette bildet er <strong>favoritten</strong> til <strong>én person</strong>. ';
            $a['PHOTO_IS_FAVORITE_OF']['n'] = 'Dette bildet er <strong>favoritten</strong> til <strong>%s personer</strong>. ';
            $a['RATING_Y_AFTER_X_VOTES']['1'] = '<strong>Rangering:</strong> %2$s etter én stemme ';
            $a['RATING_Y_AFTER_X_VOTES']['n'] = '<strong>Rangering:</strong> %2$s etter %s stemmer ';
            $a['Y_AFTER_X_VOTES']['1'] = '%2$s etter én stemme ';
            $a['Y_AFTER_X_VOTES']['n'] = '%2$s etter %s stemmer ';
            $a['N_PEOPLE']['1'] = 'Én person ';
            $a['N_PEOPLE']['n'] = '%s personer ';
            $a['N_OF_5_STARS']['1'] = '1/5 stjerne ';
            $a['N_OF_5_STARS']['n'] = '%s/5 stjerner ';
            $a['YOUR_RATING_X_STARS']['1'] = 'Din rangering: én stjerne ';
            $a['YOUR_RATING_X_STARS']['n'] = 'Din rangering: %s stjerner ';
            $a['Y_ADDED_X_PHOTOS']['1'] = '%2$s la til et bilde: ';
            $a['Y_ADDED_X_PHOTOS']['n'] = '%2$s la til %s bilder. ';
            $a['YOU_ADDED_X_PHOTOS']['1'] = 'Du la til et bilde: ';
            $a['YOU_ADDED_X_PHOTOS']['n'] = 'Du la til %s bilder. ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['1'] = 'Det finnes ett bilde på %2$s ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['n'] = 'Det finnes %1$s bilder på %2$s ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['1'] = 'Det finnes %1$s <a href="%3$s">bilde</a> på %2$s ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['n'] = 'Det finnes %1$s <a href="%3$s">bilder</a> på %2$s ';
            $a['N_INVITATIONS_RESENT']['1'] = '1 invitasjon er sendt på nytt. ';
            $a['N_INVITATIONS_RESENT']['n'] = '%s invitasjoner er sendt på nytt. ';
            $a['AND_X_OTHER_PEOPLE']['1'] = 'og 1 annen person ';
            $a['AND_X_OTHER_PEOPLE']['n'] = 'og %s andre personer ';
            $a['N_COMMENTS_ON_PAGE']['1'] = '<strong>Én</strong> profilkommentar ';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s</strong> profilkommentarer ';
            $a['N_BLOG_COMMENTS']['1'] = '<strong>Én</strong> kommentar til bloggen ';
            $a['N_BLOG_COMMENTS']['n'] = '<strong>%s</strong> kommentarer til bloggen ';
            $a['N_YEARS_OLD']['1'] = 'Ett år gammel ';
            $a['N_YEARS_OLD']['n'] = '%s år gammel ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['1'] = 'Du har én venneforespørsel! ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['n'] = 'Du har %s venneforespørsler! ';
            $a['COMMENT_WALL_N_COMMENTS']['1'] = 'Kommentarvegg (1 kommentar) ';
            $a['COMMENT_WALL_N_COMMENTS']['n'] = 'Kommentarvegg (%s kommentarer) ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['1'] = 'Én person har blitt medlem den siste uken ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['n'] = '%s personer har blitt medlem den siste uken ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['1'] = 'Èn <a href="%2$s">person</a> har blitt medlem den siste uken ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['n'] = '%1$s <a href="%2$s">personer</a> har blitt medlem den siste uken ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['1'] = '%2$s har ett medlem ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['n'] = '%2$s har %1$s medlemmer ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['1'] = '%2$s har ett <a href="%3$s">medlem</a> ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['n'] = '%2$s har %1$s <a href="%3$s">medlemmer</a> ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['1'] = '%2$s har ett blogg-innlegg ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['n'] = '%2$s har %1$s blogg-innlegg ';
            $a['N_NEW_MEMBERS']['1'] = '<strong>Ett</strong> nytt medlem ';
            $a['N_NEW_MEMBERS']['n'] = '<strong>%s</strong> nye medlemmer ';
            $a['N_REPLIES']['1'] = 'Ett svar ';
            $a['N_REPLIES']['n'] = '%s svar ';
            $a['N_MINUTES']['1'] = 'Du har ett minutt igjen til å redigere kommentaren din. ';
            $a['N_MINUTES']['n'] = 'Du har %s minutter igjen til å redigere kommentaren din. ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['1'] = '%2$s har ett forum-tema ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['n'] = '%2$s har %1$s forum-tema ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['1'] = '%2$s har ett <a href="%3$s">forum-tema</a> ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['n'] = '%2$s har %1$s <a href="%3$s">forum-tema</a> ';
            $a['N_INVITES']['1'] = '%s invitasjon ';
            $a['N_INVITES']['n'] = '%s invitasjoner ';
            $a['N_MEMBERS']['1'] = 'Ett medlem ';
            $a['N_MEMBERS']['n'] = '%s medlemmer ';
            $a['N_MEMBERS_PARENTHESIZED']['1'] = '(Ett medlem) ';
            $a['N_MEMBERS_PARENTHESIZED']['n'] = '(%s medlemmer) ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['1'] = '%2$s har én gruppe ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['n'] = '%2$s har %1$s grupper ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['1'] = '%2$s har %1$s <a href="%3$s">gruppe</a> ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['n'] = '%2$s har %1$s <a href="%3$s">grupper</a> ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['1'] = 'Én sang på denne spillelisten kan ikke vises fordi den har blitt slettet eller ikke lenger deles med andre. ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['n'] = '%s sanger på denne spillelisten kan ikke vises fordi de har blitt slettet eller ikke lenger deles med andre. ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['1'] = 'En ny sang har blitt lagt til på %2$s ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['n'] = '%1$s nye sanger har blitt lagt til på %2$s ';
            $a['Y_ADDED_X_SONGS']['1'] = '%2$s la til en sang: ';
            $a['Y_ADDED_X_SONGS']['n'] = '%2$s la til %s sanger. ';
            $a['YOU_ADDED_X_SONGS']['1'] = 'Du la til en sang: ';
            $a['YOU_ADDED_X_SONGS']['n'] = 'Du la til %s sanger. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['1'] = 'Én sang ble lagt til på denne spillelisten. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['n'] = '%s sanger ble lagt til på denne spillelisten. ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['1'] = '%2$s har én sang. ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['n'] = '%2$s har %1$s sanger ';
        }
        if ($a[$args[0]]) {
            $args[0] = $a[$args[0]][$args[1]] ? $a[$args[0]][$args[1]] : $a[$args[0]]['n'];
            return @call_user_func_array('sprintf', $args);
        }
        $text = self::$messages[$s];
        if ($text) { $args[0] = $text; }
        return @call_user_func_array('sprintf', $args);
    }

    /**
     * Message names and texts. Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;
     */
    private static $messages = array(
        'BROWSING' => 'Blar gjennom',
        'MORE_VIDEOS' => 'Flere videoer',
        'NETWORK_DOES_NOT_HAVE_VIDEOS' => 'Dette nettverket har ingen videoer ennå.',
        'NETWORK_DOES_NOT_HAVE_FEATURED_VIDEOS' => 'Dette nettverket har ingen fremhevede videoer ennå.',
        'PERSON_DOES_NOT_HAVE_VIDEOS' => 'Denne personen har ingen videoer ennå.',
        'COPY_TO_CLIPBOARD' => 'Kopier til utklippstavlen',
        'COPIED_TO_CLIPBOARD' => 'Kopiert til utklippstavlen!',
        'NO_VIDEOS_TO_DISPLAY' => 'Foreløpig viser du ingen videoer.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_VIDEO' => 'Dette vinduet vil ikke vises for andre med mindre du velger minst én video.',
        'WATERMARK_LOGO' => 'Vannmerkelogo',
        'CHOOSE_HEADER_OR_WATERMARK' => 'Du kan velge enten en overskrift eller en vannmerkelogo for videospilleren din.',
        'CUSTOMIZE_EMBED_INSTRUCTIONS' => 'Logoen vil vises øverst på %sen din.  Hvis du ikke legger til en logo vil nettverksnavnet vises isteden.  Logoen din må være i . jpg-, . gif- eller . png-format.  Logoer som er høyere enn 20 piksler vil endres slik at de passer.',
        'CUSTOMIZE_WATERMARK_INSTRUCTIONS' => 'Vannmerkelogoen vil vises ovenfor hjørnet nederst til høyre på videoklippet.',
        'HEADER_LOGO' => 'Overskriftslogo',
        'WATERMARK' => 'Vannmerke',
        'CUSTOMIZE_YOUR_VIDEO_PLAYER' => 'Skreddersy videospilleren din!',
        'VIDEO_PLAYER' => 'Videospiller',
        'HEADER' => 'Overskrift',
        'SAVE_CHANGES' => 'Lagre endringer',
        'THUMBNAIL' => 'Miniatyrbilde',
        'CONVERSION_FAILED' => 'Konvertering mislyktes',
        'CONVERSION_IN_PROGRESS' => 'Konvertering pågår',
        'MAP' => 'Kart',
        'WHAT_IS_THIS' => 'Hva er dette?',
        'EDIT_VIDEO_INFORMATION' => 'Rediger videoinformasjon',
        'ALL_VIDEOS' => 'Alle videoer',
        'VIDEOS_HOME' => 'Videoer - hjem',
        'MY_VIDEOS' => 'Mine videoer',
        'MY_FRIENDS_VIDEOS' => 'Mine venners videoer',
        'MY_FAVORITES' => 'Mine favoritter',
        'XS_FAVORITES' => '%ss favoritter',
        'ADD_A_VIDEO' => 'Legg til en video',
        'JUST_NOW' => 'akkurat nå',
        '1_DAY_AGO' => 'For én dag siden',
        'M_J' => 'M j',
        'ME' => 'Meg',
        'X_SAID' => '%s sa...',
        'DELETE_COMMENT' => 'Slett kommentar',
        'YOU_HAVE_NOT_ADDED_VIDEOS' => 'Du har ikke lagt til noen videoer ennå!',
        'ADD_VIDEOS_AND_SHARE' => 'Legg til videoer og del dem med venner, familie og resten av verden!',
        'THERE_ARE_NO_VIDEOS' => 'Foreløpig har ditt sosiale nettverk ingen videoer.',
        'THIS_BOX_WILL_NOT_SHOW' => 'Dette vinduet vil ikke vises for andre med mindre det finnes videoer som kan vises.  Hvorfor ikke legge til en?',
        'ADD_VIDEOS' => 'Legge til videoer',
        'VIEW_VIDEOS' => 'Vis videoer',
        'YIKES' => 'Å nei!',
        'A_PROBLEM_SEEMS' => 'Det ser ut til at det har oppstått problem.',
        'FOR_FURTHER_ASSISTANCE' => 'For mer hjelp, <a %s>ta kontakt med oss</a>.',
        'OR_YOU_CAN_GO' => 'Eller du kan gå tilbake til <a %s>%ss hovedside</a> eller bla gjennom <a %s>andre Ning sosiale nettverk</a>',
        'TAGS' => 'Merker:',
        'POPULAR_TAGS' => 'Populære merker',
        'MY_FRIENDS' => 'Mine venner',
        'VIEW_ALL_MY_FRIENDS' => 'Vis alle vennene mine',
        'VIEW_ALL_XS_FRIENDS' => 'Vis alle %ss venner',
        'WE_COULD_NOT_FIND_ANYONE_MATCHING' => 'Vi beklager – vi kunne ikke finne noen som passet til søket ditt.',
        'VIEW_POPULAR_CONTRIBUTORS' => 'Vis populære bidragsytere',
        'POPULAR_CONTRIBUTORS' => 'Populære bidragsytere',
        'VIEW_MORE_CONTRIBUTORS' => 'Vis flere bidragsytere',
        'ADD_AS_FRIEND' => 'Legg til som venn',
        'SEND_A_MESSAGE' => 'Send en melding',
        'IS_YOUR_FRIEND' => 'Er din venn',
        'IS_BLOCKED' => 'Er blokkert',
        'SORT_BY' => 'Sorter etter:',
        'CLOSE' => 'Lukk',
        'USER_COUNT' => '(%d)',
        'NOBODY_HAS_ADDED_VIDEOS' => 'Ingen har lagt til noen videoer ennå!  Legg til noen videoer for å komme i gang.',
        'SEARCH_PEOPLE' => 'Søk blant personer:',
        'INVITE_YOUR_FRIENDS_TO' => 'Inviter vennene dine til %s.',
        'INVITE' => 'Inviter',
        'INVITE_TAB_TEXT' => 'Inviter',
        'YOU_HAVE_NOT_ADDED_FRIENDS' => 'Du har ikke lagt til noen venner på %s ennå.',
        'SEARCH_FRIENDS' => 'Søk blant venner:',
        'ADD_YOUR_FIRST_VIDEO' => 'Legg til din første video',
        'USE_HTML_EMBED_CODE' => 'Bruk HTML embed-koden',
        'UPLOAD_A_VIDEO_FROM' => 'Last opp en video fra datamaskinen. Vi godtar alle de vanligste formatene!',
        'WE_SUPPORT_MOV' => 'Vi støtter filformatene mov, mpg, avi, 3gp og wmv. Filstørrelsen kan være maksimum 100 MB.',
        'NEED_HELP_HERE_ARE' => 'Trenger du hjelp?  Her er instruksjonene for <a %s>YouTube-</a> og <a %s>Google-video</a>.',
        'ADD_TITLE_AND_DESCRIPTION' => 'Legg til tittel og beskrivelse',
        'DESCRIPTION_COLON' => 'Beskrivelse:',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_1' => 'Legg til tittel, beskrivelse og annen informasjon til videoen du akkurat har lastet opp.',
        'EVERYTHING_IS_OPTIONAL' => 'Alt er valgfritt;  hvis du ikke vil legge til noe, kan du bare klikke på "Hopp over dette trinnet" på høyre side.',
        'SKIP_THIS_STEP' => 'Hopp over dette trinnet',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_2' => 'Legg til tittel, beskrivelse og annen informasjon for denne videoen.',
        'CANCEL_AND_RETURN_TO_VIDEO' => 'Avbryt og gå tilbake til videoen',
        'TITLE' => 'Tittel:',
        'TAGS_ARE_SHORT_DESCRIPTIONS' => 'Merker er korte beskrivelser som lar deg finne videoene dine.  Adskill merker med komma eller sett merker som består av mer enn ett ord i anførselstegn, for eksempel "San Francisco".',
        'WHO_CAN_VIEW_VIDEO' => 'Hvem kan se denne videoen?',
        'MOST_POPULAR' => 'Mest populær',
        'HIGHEST_RATED' => 'Rangert høyest  ',
        'MOST_RECENT' => 'Nyest',
        'MOST_FAVORITED' => 'Oftest lagt til som favoritt',
        'MOST_POPULAR_VIDEOS' => 'Mest populære videoer',
        'HIGHEST_RATED_VIDEOS' => 'Høyest rangerte videoer',
        'MOST_RECENT_VIDEOS' => 'Nyeste videoer',
        'MOST_FAVORITED_VIDEOS' => 'Videoer oftest lagt til som favoritt',
        'ANYONE' => 'Hvem som helst',
        'JUST_MY_FRIENDS' => 'Bare vennene mine',
        'JUST_ME' => 'Bare meg',
        'VIEWABLE_BY_FRIENDS' => 'Kan sees av <strong>venner</strong>',
        'PRIVATE_VIDEO' => '<strong>Privat</strong> video',
        'VIEWABLE_BY_EVERYONE' => 'Kan sees av <strong>alle</strong>',
        'LOCATION' => 'Sted:',
        'NO_LOCATION' => 'Ikke noe sted',
        'CLICK_ON_LOCATION' => 'Klikk på et sted på kartet:',
        'FIND_AN_ADDRESS' => 'Finn adresse:',
        'LOCATE' => 'Finn',
        'YOU_CAN_ADD_YOUR_OWN_VIDEO' => 'Du kan <a %s>legge til din egen video</a> på %s!',
        'ADD_PLAYER_LOGO_OR_WATERMARK' => 'Legg til en logo eller vannmerkebilde til ditt nettverks videospiller.  <a %s>Sett det opp nå! </a>',
        'APPROVE' => 'Godkjenn',
        'DELETE' => 'Slett',
        'APPLY_TO_VIDEOS_ADDED_BY' => 'Bruk på alle videoer som er lagt til av %s',
        'NO_TITLE' => 'Ingen tittel',
        'ADDED_BY_STRONG_X' => 'Lagt til av <strong>%s</strong>',
        'NO_DESCRIPTION' => 'Ingen beskrivelse',
        'BY_X' => 'Av %s',
        'YOU_HAVE_FINISHED_MODERATING' => 'Du er ferdig med å moderere',
        'NO_VIDEOS_AWAITING_APPROVAL' => 'Foreløpig er det ingen videoer i påvente av godkjenning.  Hvis du ser etter noe å gjøre, hvorfor ikke sjekke ut de <a %s>siste videoene</a>?',
        'NO_ONE_HAS_ADDED_ANY_VIDEOS' => 'Ingen har lagt til videoer til ditt sosiale nettverk.  Vær den første til å legge ut en video!',
        'ADDED_ON_DATE_BY_X' => 'Lagt til %s av %s.',
        'REMOVE_FROM_FAVORITES' => 'Fjern fra favoritter',
        'REMOVE_VIDEO_FROM_FAVORITES' => 'Fjern denne videoen fra dine favoritter?',
        'COLLECTED_BY_X' => 'Samlet inn av %s',
        'ADD_FAVORITES' => 'Legg til favoritter',
        'YOU_CAN_MARK_VIDEO' => 'Du kan merke hvilken som helst video som favoritt.  Det er bare å klikke på ikonet "Legg til i favoritter" når du ser det på en video.',
        'VIEW_RECENT_VIDEOS' => 'Vis nye videoer',
        'X_HAS_NOT_ADDED_FAVORITES' => '%s har ikke lagt til noen favoritter ennå.',
        'APPROVE_VIDEOS' => 'Godkjenn videoer',
        'YOUR_SITE_REQUIRES_YOU' => 'Du har bedt om å moderere bilder og videoer på ditt sosiale nettverk før de legges ut.  For å endre denne innstillingen, <a %s>klikk her for å gå til personvernsiden</a> og slå av \'Godkjenne nye bilder og videoer\'.',
        'YOUR_SITE_ALLOWS_USERS' => 'Du har bedt om ikke å moderere bilder og videoer på ditt sosiale nettverk før de legges ut.  For å endre denne innstillingen, <a %s>klikk her for å gå til personvernsiden</a> og slå på \'Godkjenne nye bilder og videoer\'.',
        'APPROVE_ALL_VIDEOS' => 'Godkjenne alle videoer?',
        'ARE_YOU_SURE_APPROVE_ALL_VIDEOS' => 'Er du sikker på at du vil godkjenne alle videoer?  Dette kan ta et par minutter.',
        'APPROVING' => 'Godkjenner...',
        'APPROVE_ALL' => 'Godkjenn alle',
        'DELETE_ALL_VIDEOS' => 'Slette alle videoer?',
        'ARE_YOU_SURE_DELETE_ALL_VIDEOS' => 'Er du sikker på at du vil slette alle videoer som ikke har blitt godkjent?  Dette kan ta et par minutter.',
        'DELETING' => 'Sletter...',
        'DELETE_ALL' => 'Slett alle',
        'XS_VIDEOS' => '%ss videoer',
        'DELETE_ALL_XS_VIDEOS_Q' => 'Slette alle %ss videoer?',
        'DELETE_ALL_XS_VIDEOS' => 'Slett alle %ss videoer',
        'ARE_YOU_SURE_DELETE_ALL_XS_VIDEOS' => 'Er du sikker på at du vil slette alle %ss videoer?  Dette kan ta et par minutter.',
        'DELETE_THIS_VIDEO_Q' => 'Slette denne videoen?',
        'ARE_YOU_SURE_DELETE_THIS_VIDEO' => 'Er du sikker på at du vil slette denne videoen?  Dette kan ta et par minutter.',
        'YOU_HAVE_NOT_ADDED_VIDEOS_2' => 'Du har ikke lagt til noen videoer ennå.  Legg til noen videoer for å komme i gang!',
        'X_HAS_NOT_ADDED_VIDEOS' => '%s har ikke lagt til noen videoer ennå.',
        'YOUR_FRIENDS_DO_NOT_HAVE_VIDEOS' => 'Vennene dine  har ingen videoer ennå.',
        'ALL_VIDEOS_TAGGED_X' => 'Alle videoer merket \'%s\'',
        'ALL_VIDEOS_TAGGED_X_2' => 'Alle videoer merket <em>\'%s\'</em>',
        'NO_VIDEOS_TAGGED_X_CHECK_OUT' => 'Det er ingen videoer merket "%1$s".  Sjekk ut <a %2$s>diskusjoner merket "%1$s"</a> eller <a %3$s>bilder merket "%1$s"</a>.  Eller legg til og merk dine egne videoer!',
        'FILES_MUST_BE_100MB' => 'Filer må være 100MB eller mindre.  Vi støtter .mov-, .mpg-, .avi-, .3gp- og .wmv-filformat.',
        'NEED_HELP' => 'Trenger du hjelp?',
        'HERE_ARE_INSTRUCTIONS' => 'Her er instruksjonene for <a %s>YouTube-</a> og <a %s>Google-video</a>.',
        'PERSON_IN_CHARGE' => 'Personen som er ansvarlig for %s vil se verket ditt før det vises til resten av verden.',
        'LEAVE_WINDOW_OPEN' => 'La dette vinduet være åpent mens opplastingsprosessen pågår.',
        'KEEP_PAGE_OPEN' => 'La denne siden være åpen slik at vi kan fullføre opplastingen av videoen din. Vi vil gi deg beskjed så snart den har blitt godkjent!',
        'MEANWHILE_FEEL_FREE' => 'I mellomtiden kan du godt <a %s>åpne et nytt nettleservindu</a> og fortsette å bruke %s.  Når opplastingen er ferdig kan du legge til tittel og beskrivelse av videoen din i dette vinduet.',
        'VIDEO_IS_WAITING_FOR_APPROVAL' => 'Denne videoen <strong>påventer godkjenning</strong> av %ss oppretter.',
        'LOADING' => 'Laster...',
        'EDIT_VIDEO' => 'Rediger video',
        'DELETE_VIDEO' => 'Slett video',
        'YOU_NEED_TO_BE_MEMBER' => 'Du må være medlem av %s for å kunne legge til kommentarer!',
        'SIGN_UP_OR_SIGN_IN' => '<a %sBli med i dette nettverket</a>',
        'ADD_A_COMMENT' => 'Legg til en kommentar',
        'LEAVE_A_COMMENT_FOR_USERNAME' => 'Legg igjen en kommentar til %s',
        'MORE' => 'Mer',
        'PREVIOUS' => 'Forrige',
        'NEXT' => 'Neste',
        'ABOUT_THIS_VIDEO' => 'Om denne videoen',
        'ABOUT_YOUR_VIDEO' => 'Om denne videoen',
        'ADDED_ON_DATE_BY' => 'Lagt til <strong>%s</strong> av:',
        'VIEWS' => 'Visninger:',
        'COMMENTS' => 'Kommentarer',
        'COMMENTS_COLON' => 'Kommentarer:',
        'LOCATION_OF_VIDEO' => 'Hvor du kan finne denne videoen:',
        'RELATED_VIDEOS' => 'Relaterte videoer',
        'ALL_VIDEOS_TAGGED_X_X' => 'Alle videoer merket %s (%s)',
        'XS_VIDEOS_X' => '%ss videoer (%s)',
        'XS_FAVORITES_X' => '%ss favoritter (%s)',
        'VIDEO_DETAILS' => 'Videodetaljer',
        'NEITHER_FILE_NOR_EMBED_CODE' => 'Verken fil eller embed-kode har blitt spesifisert.',
        'VIDEO_UPLOADED_ON_X' => 'Video lastet opp på %s',
        'PROBLEM_OCCURRED_CONVERTING_VIDEO' => 'Et problem oppsto under konverteringen av denne videoen til Flash-format: %s',
        'STATUS_N' => 'Status %s',
        'YOUR_VIDEO_TITLED_X_COULD_NOT' => 'Videoen din "%s" kunne ikke legges til på %s',
        'YOUR_VIDEO_COULD_NOT_BE_ADDED' => 'Videoen din kunne ikke legges til på %s',
        'YOU_JUST_TRIED_TO_SEND_VIDEO' => 'Du forsøkte akkurat å sende inn en video til %s.  Dessverre er du ikke medlem av %s og vi kan ikke levere denne videoen.',
        'YOUR_VIDEO_WAS_SUCCESSFULLY_UPLOADED_TO_X' => 'Opplastingen av videoen til %s var vellykket.',
        'VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'Videoopplastingen på %s ble ikke fullført',
        'YOUR_VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'opplastingen av videoen din ble ikke fullført for %s.',
        'YOUR_VIDEO_ENCOUNTERED_A_PROBLEM' => 'Det oppsto et problem under opplastingen av videoen din til %s',
        'THE_PROBLEM_WAS_X' => 'Problemet var: %s',
        'FOR_FURTHER_ASSISTANCE_2' => 'Hvis du vil ha mer hjelp, går du til:',
        'ID' => 'ID:',
        'VIDEO_TRANSCODING_FAILED_FOR_X' => 'Videotranskodingen mislyktes for %s-videoen i %s',
        'X_UPLOADED_A_VIDEO_THAT_FAILED' => '%s lastet opp en video som ikke kunne transkodes.',
        'ERROR_MESSAGE' => 'Feilmelding:',
        'APPLICATION_NAME' => 'Navn på programmet:',
        'APPLICATION_ID' => 'Program-ID:',
        'VIDEO_ID' => 'Video-ID:',
        'VIDEO_UPLOAD_COMPLETE_ON_X' => 'Videoopplastingen på %s er fullført',
        'YOUR_VIDEO_UPLOAD_COMPLETE_ON_X' => 'opplasting av videoen din til %s er fullført',
        'YOUR_VIDEO_WAS_UPLOADED' => 'Opplastingen av videoen til %s var vellykket!',
        'THAT_VIDEO_IS_AWAITING_APPROVAL' => 'Videoen påventer godkjenning.',
        'THIS_VIDEO_IS_BEING_PROCESSED' => 'Denne videoen er fortsatt under behandling.',
        'ADD_VIDEO' => 'Legg til video',
        'VIDEO_BY_X' => '%ss video',
        'THERE_IS_NEW_COMMENT_ON_VIDEO_X' => 'Det er lagt til en ny kommentar på videoen din, "%s", på %s',
        'THERE_IS_NEW_COMMENT_ON_VIDEO' => 'Det er lagt til en ny kommentar på en av videoene dine på %s',
        'SOMEBODY_COMMENTED_VIDEO_ADDED_TO_X' => 'noen har kommentert en video du har lagt til på %s',
        'SOMEBODY_UPLOADED_VIDEO_TO_X' => 'noen har lastet opp en video på %s',
        'MORE_WAYS_TO_ADD_VIDEOS' => 'Flere måter å legge til videoer på...',
        'FROM_YOUTUBE_OR_GOOGLE' => '...fra YouTube eller Google',
        'GRAB_THE_HTML_EMBED_CODE' => 'Ta HTML \'embed\'-koden fra en hvilken som helst populær videoside og legg til den videoen på dette sosiale nettverket.',
        'ADD_A_VIDEO_FROM_YOUTUBE' => 'Legg til en video fra YouTube eller Google',
        'PASTE_IN_EMBED' => 'Lim inn \'embed\'-koden for videoen her:',
        'ADD_VIDEOS_BY_PHONE_OR_EMAIL' => 'Legg til video via telefon eller e-post',
        'VIDEO' => 'video',
        'THERE_ARE_NO_VIDEOS_THAT_MATCH' => 'Ingen videoer passer til de innstillingene du har valgt.',
        'CLICK_EDIT_AND_CHANGE_SETTINGS' => 'Klikk \'Rediger\' og endre innstillingene hvis du vil at dette vinduet skal vises for andre.',
        'PLAY_AGAIN' => 'Spill igjen',
        'SHARE' => 'Del',
        'EMBED' => 'Embed',
        'REWIND' => 'Spol tilbake',
        'CHANGE_SIZE' => 'Endre størrelse',
        'FULLSCREEN' => ' Fullskjerm  ',
        'EXIT_FULLSCREEN' => 'Gå ut av fullskjermen',
        'HIDE' => 'Lukk',
        'COPY_AND_PASTE_LINK' => 'Kopier og lim inn denne lenka i en e-post eller lynmelding:',
        'FIND_MORE_VIDEOS_LIKE_THIS' => 'Finn flere videoer som denne på <em>%s</em>',
        'SEE_VIDEO_ON_NETWORK' => 'Se denne videoen på %s',
        'GET_EMBED_CODE' => 'Skaff embed-kode',
        'MORE_PHOTOS' => 'Flere bilder',
        'THIS_ALBUM' => 'Dette albumet',
        'NETWORK_DOES_NOT_HAVE_PHOTOS' => 'Dette nettverket har ingen bilder ennå.',
        'PERSON_DOES_NOT_HAVE_PHOTOS' => 'Denne personen har ingen bilder ennå.',
        'ALBUM_DOES_NOT_HAVE_PHOTOS' => 'Dette albumet har ingen bilder ennå.',
        'FIND_MORE_PHOTOS_LIKE_THIS' => 'Finn flere bilder som dette på <em>%s</em>',
        'NO_PHOTOS_AVAILABLE' => 'Foreløpig er det ingen bilder tilgjengelig i dette albumet.  <a %s>Klikk her for å se alle albumene</a>.',
        'ALBUM_PHOTOS_NOT_VISIBLE_TO_OTHERS' => 'Dette albumet kan ikke vises for andre på dette nettverket fordi bildene kun kan vises for deg, eller fordi de ikke har blitt godkjent ennå.',
        'CUSTOMIZE_YOUR_SLIDESHOW_PLAYER' => 'Tilpass lysbildeshowviseren din!',
        'ADD_SLIDESHOW_LOGO' => 'Legg til en logo til ditt sosiale nettverks lysbildeshow.  <a %s>Sett det opp nå! </a>',
        'PHOTO_BY_X' => 'Bilde tatt av %s',
        'UPLOAD_PHOTOS' => 'Last opp bilder',
        'PLAYER_COLOR' => 'Farge på spilleren',
        'SLIDESHOW_PLAYER' => 'lysbildeshowavspiller',
        'SLIDESHOW' => ' lysbildeshow  ',
        'FILTER' => 'Filter',
        'SAVE_ALBUM' => 'Lagre album',
        'APPLY_THIS_INFO_TO_PHOTOS' => 'Bruk denne informasjonen for følgende bilder',
        'CLICK_TO_ADD_A_DESCRIPTION' => 'klikk her for å legge til en beskrivelse',
        'CHECK' => 'Kontroller',
        'YOU_NEED_TO_BE_X' => 'Du må være %s for å kunne gjøre det.',
        'ALL_PHOTOS' => 'Alle bilder',
        'POPULAR_PHOTOS' => 'Populære bilder',
        'FEATURED_PHOTOS' => 'Fremhevede bilder',
        'PHOTOS_HOME' => 'Bilder - hjem',
        'ALL_ALBUMS' => 'Alle album',
        'MY_PHOTOS' => 'Mine bilder',
        'MY_ALBUMS' => 'Mine album',
        'ADD_PHOTOS' => 'Legg til bilder',
        'ADD_PHOTOS_SENTENCE_CASE' => 'Legg til bilder',
        'EDIT' => 'Rediger',
        'CHOOSE_PHOTOS' => 'Velg bilder',
        'ADD_PHOTOS_BY_DRAGGING' => '<strong>Legg til bilder ved å dra dem</strong> til albumet ditt på høyre side.  Fjern dem ved å dra dem tilbake.',
        'TITLE_YOUR_ALBUM' => '<strong>Legg inn en tittel på albumet ditt. </strong> Velg et forsidebilde og gi en beskrivelse.',
        'SAVE_YOUR_ALBUM' => 'Lagre albumet ditt!',
        'CHOOSE_FROM' => 'Velg mellom:',
        'EVERYONES_PHOTOS' => 'Bilder fra alle',
        'TAGGED' => 'Merket:',
        'OLDER_PHOTOS' => 'Eldre bilder',
        'MORE_RECENT_PHOTOS' => 'Nyere bilder',
        'YOUR_ALBUM' => 'Ditt album',
        'DRAG_ALBUM_COVER_HERE' => 'Dra forsidebildet hit',
        'ALBUM_TITLE' => 'Tittel på albumet:',
        'ALBUM' => ' album  ',
        'DRAG_PHOTOS_HERE' => 'Dra bildene dine hit',
        'PREVIOUS_ALBUM_PAGE' => 'Forrige albumside',
        'NEXT_ALBUM_PAGE' => 'Neste albumside',
        'ADDED_ON_DATE' => 'Lagt til %s',
        'VIEW_AS_SLIDESHOW' => 'Vis som lysbildeshow',
        'CREATED_BY_ME' => 'Opprettet av <a %s>meg</a>',
        'CREATED_BY_X' => 'Opprettet av %s',
        'OUR_APOLOGIES' => 'Vi beklager',
        'ADD_PHOTOS_TO_ALBUM' => 'Legg til flere bilder til dette albumet ved å velge fra alternativene nedenfor.',
        'YOU_CAN_ADD_PHOTOS' => 'Du kan <a %s>legge til bilder til dette albumet nå</a>.',
        'SITE_IS_GETTING_STARTED' => 'Dette sosiale nettverket har akkurat kommet i gang!',
        'NO_ONE_CREATED_ALBUMS' => 'Det ser ikke ut til at noen har opprettet noe album ennå.  Du kan <a %s>opprette et album nå</a>.',
        'EDIT_YOUR_ALBUM' => 'Rediger albumet ditt',
        'ALBUMS_WITH_THIS_PHOTO' => 'Alle album som inneholder dette bildet',
        'ALBUMS_WITH_X' => 'Alle album som inneholder \'%s\'',
        'ALBUMS_WITH_X_2' => 'Alle album som inneholder <em>\'%s\'</em>',
        'NO_ALBUMS_CONTAINING_PHOTO' => 'Det finnes ingen album som inneholder dette bildet.  Du kan <a %s>opprette et nytt album</a>.',
        'XS_ALBUMS' => '%ss album',
        'CREATE_AN_ALBUM' => 'Opprett et album',
        'YOU_HAVE_NOT_CREATED_ALBUMS' => 'Du har ikke opprettet noe fotoalbum ennå.  Du kan <a %s>opprette et album nå</a>.',
        'X_HAS_NOT_CREATED_ALBUMS' => '%s har ikke opprettet noe album ennå.',
        'MAKE_AN_ALBUM' => 'Lag et album',
        'ABOUT_THIS_ALBUM' => 'Om dette albumet',
        'ABOUT_YOUR_ALBUM' => 'Om albumet ditt',
        'EDIT_ALBUM' => 'Rediger album',
        'DELETE_THIS_ALBUM' => 'Slette dette albumet?',
        'DELETE_ALBUM' => 'Slett album',
        'START_SLIDESHOW' => 'Start lysbildeshow',
        'ALBUM_IS_NOW_EMPTY' => 'Dette albumet er nå tomt.',
        'YOU_ARE_GETTING_STARTED' => 'Du er akkurat kommet i gang!',
        'YOU_HAVE_NOT_ADDED_PHOTOS' => 'Du har ikke lagt til noen bilder ennå!',
        'ADD_PHOTOS_AND_SHARE' => 'Legg til bilder og del dem med venner, familie eller resten av verden!',
        'ADD_A_PHOTO' => 'Legg til et bilde',
        'NO_PHOTOS_ON_SITE' => 'Foreløpig har ditt sosiale nettverk ingen bilder.',
        'BOX_WILL_NOT_SHOW_PHOTOS' => 'Dette vinduet vil ikke være synlig for andre før det finnes bilder som kan vises.  Hvorfor ikke legge til en?',
        'VIEW_EMBED_CODE' => 'Vis embed-kode',
        'VIEW_SLIDESHOW' => 'Vis lysbildeshow',
        'VIEW_PHOTOS' => 'Vis bilder',
        'ADD_YOUR_FIRST_PHOTOS' => 'Legg til dine første bilder',
        'YOU_CAN_ADD_YOUR_OWN_PHOTOS' => 'Du kan <a %s>legge til dine egne bilder</a> til %s!',
        'UPLOAD_PHOTOS_FROM' => 'Last opp bilder fra datamaskinen din:',
        'ADD_TITLE_AND_DESCRIPTION_FOR_PHOTOS' => 'Legg til tittel og beskrivelse av bildene dine',
        'EDIT_PHOTO_INFORMATION' => 'Rediger bildeinformasjon',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_1' => 'Legg til tittel, beskrivelse og annen informasjon til bildene du akkurat har lastet opp.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_2' => 'Legg til tittel, beskrivelse og annen informasjon for dette bildet.',
        'CANCEL_AND_RETURN_TO_PHOTO' => 'Avbryt og gå tilbake til bildet',
        'WHO_CAN_VIEW_PHOTO' => 'Hvem kan se dette bildet?',
        'CAN_BE_VIEWED_BY' => 'Kan sees av:',
        'BY_ME' => 'av <a %s>meg</a>',
        'RSS_FEED_LABEL' => '<a %s>RSS-feed</a> - %s',
        'NO_PHOTOS_AWAITING_APPROVAL' => 'Det er foreløpig ingen bilder i påvente av godkjenning.  Hvis du ser etter noe å gjøre, hvorfor sjekker du ikke ut de <a %s>siste bildene</a>?',
        'APPROVE_ALL_PHOTOS' => 'Godkjenne alle bilder?',
        'ARE_YOU_SURE_APPROVE_ALL_PHOTOS' => 'Er du sikker på at du vil godkjenne alle bildene?  Dette kan ta et par minutter.',
        'DELETE_ALL_PHOTOS' => 'Slette alle bilder?',
        'ARE_YOU_SURE_DELETE_ALL_PHOTOS' => 'Er du sikker på at du vil slette alle bilder som ikke har blitt godkjent?  Dette kan ta et par minutter.',
        'KEEP_WINDOW_OPEN_PHOTOS_APPROVED' => 'La nettleservinduet være åpent mens bildene godkjennes.  Dette kan ta et par minutter.',
        'KEEP_WINDOW_OPEN_PHOTOS_DELETED' => 'La nettleservinduet være åpent mens bildene slettes.  Dette kan ta et par minutter.',
        'APPLY_TO_PHOTOS_ADDED_BY' => 'Bruk på alle bilder lagt til av %s',
        'NO_ONE_HAS_ADDED_ANY_PHOTOS' => 'Ingen har lagt til noen bilder til ditt sosiale nettverk.  Du kan være den første til å <a %s>legge til bilder. </a>',
        'UNTITLED' => 'Uten tittel',
        'A_PROBLEM_OCCURRED' => 'Et problem oppsto',
        'PHOTOS_EXCEEDED_LIMIT' => 'Bildet(ene) har oversteget grensen på 10 MB per bilde.',
        'GET_A_SLIDESHOW_OF' => 'Lag et lysbildeshow med  %s',
        'GET_A_SLIDESHOW' => 'Lag et lysbildeshow!',
        'GET_SLIDESHOW_OF_PHOTOS' => 'Lag et lysbildeshow med disse bildene',
        'COPY_AND_PASTE_SLIDESHOW' => 'Kopier og lim inn koden nedenfor for å gjøre et lysbildeshow med disse bildene tilgjengelig på nettsiden eller MySpace-siden din, eller på andre Ning-nettverk.',
        'COPY_AND_PASTE_SLIDESHOW_OF_ALBUM' => 'Kopier og lim inn koden nedenfor for å gjøre et lysbildeshow med dette albumet tilgjengelig på nettsiden eller MySpace-siden dn eller på andre Ning-nettverk.',
        'LARGE_VERSION' => 'Stor versjon',
        'SMALL_VERSION' => 'Liten versjon',
        'VIEW_SLIDESHOW_FULL_SIZE' => 'Vis dette lysbildeshowet i full størrelse',
        'PHOTOS' => 'Bilder',
        'XS_PHOTOS' => '%ss bilder',
        'XS_PHOTO' => '%ss bilde',
        'YOU_CAN_MARK_PHOTO' => 'Du kan merke hvilket som helst bilde som en favoritt.  Det er bare å klikke på ikonet "Legg til i favoritter" når du ser det på et bilde.',
        'VIEW_RECENT_PHOTOS' => 'Se nyere bilder',
        'APPROVE_PHOTOS' => 'Godkjenn bilder',
        'DELETE_ALL_XS_PHOTOS_Q' => 'Slette alle bildene til %s?',
        'ARE_YOU_SURE_DELETE_ALL_XS_PHOTOS' => 'Er du sikker på at du vil slette alle bildene tatt av %s?  Dette kan ta et par minutter.',
        'REMOVE_X_AND_ALL_CONTENT' => 'Fjern %1$s og alt av %1$ss innhold fra ditt sosiale nettverk',
        'SUCCESS' => 'Det gikk bra.',
        'DELETING_CONTENT' => 'Sletter innhold...',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED' => 'La nettleservinduet være åpent mens innholdet slettes.  Dette kan ta et par minutter.',
        'KEEP_WINDOW_OPEN_MEMBERS_DELETED' => 'La nettleservinduet være åpent mens medlemmer slettes.  Dette kan ta et par minutter.',
        'DELETE_ALL_XS_PHOTOS' => 'Slett alle bildene til %s',
        'CREATE_A_NEW_ALBUM' => 'Opprett et nytt album',
        'VIEW_ALL_XS_ALBUMS' => 'Se alle albumene til %s\\',
        'YOU_HAVE_NOT_ADDED_PHOTOS_2' => 'Du har ikke lagt til noen bilder ennå.  Legg til noen bilder for å komme i gang!',
        'X_HAS_NOT_ADDED_PHOTOS' => '%s har ikke lagt til noen bilder ennå.',
        'MY_FRIENDS_PHOTOS' => 'Mine venners bilder',
        'VIEW_PHOTOS_IN_SLIDESHOW' => 'Se disse bildene som et lysbildeshow!',
        'YOUR_FRIENDS_DO_NOT_HAVE_PHOTOS' => 'Vennene dine har ikke lagt til noen bilder ennå',
        'ALL_PHOTOS_TAGGED_X' => 'Alle bilder merket som \'%s\'',
        'ALL_PHOTOS_TAGGED_X_2' => 'Alle bilder merket som <em>\'%s\'</em>',
        'NO_PHOTOS_TAGGED_X_CHECK_OUT' => 'Det er ikke noen bilder merket som "%1$s".  Sjekk ut <a %2$s>diskusjonene merket som "%1$s"</a> eller <a %3$s>videoene merket som "%1$s"</a>.  Eller legg til og merk dine egne bilder!',
        'SELECT_YOUR_PHOTOS' => 'Velg bildene dine',
        'PHOTO_MAY_BE_10MB' => 'Hvert bilde kan ha en størrelse på opptil 10 MB, men mindre bilder vil lastes opp raskere. Vi støtter bilder i filformatene jpg, bmp og png.',
        'KEEP_PAGE_OPEN_PHOTOS' => 'La denne siden være åpen slik at vi kan bli ferdig med opplastingen av bildene dine. Vi vil gi beskjed når de har blitt godkjent!',
        'MEANWHILE_FEEL_FREE_PHOTOS' => 'I mellomtiden kan du godt <a %s>åpne et nytt nettleservindu</a> og fortsette å bruke %s.  Når opplastingen er ferdig vil du kunne legge til titler og beskrivelser av bildene dine i dette vinduet.',
        'PHOTO_IS_WAITING_FOR_APPROVAL' => 'Dette bildet <strong>venter på godkjenning</strong> fra oppretteren av %s.',
        'ADD_TO_FAVORITES' => 'Legg til i favoritter',
        'EDIT_PHOTO' => 'Rediger bilde',
        'DELETE_PHOTO' => 'Slett bilde',
        'ABOUT_THIS_PHOTO' => 'Om dette bildet',
        'LOCATION_OF_PHOTO' => 'Hvor du kan finne dette bildet:',
        'ALBUMS_FEATURING_PHOTO' => 'Album som inneholder dette bildet',
        'VIEW_ALBUMS_WITH_PHOTO' => 'Se alle album som inneholder dette bildet',
        'RETURN_TO_X' => 'Gå tilbake til %s',
        'RETURN_TO_PHOTOS_HOME' => 'Gå tilbake til Bilder - hjem',
        'WE_COULD_NOT_FIND_ANYONE' => 'Vi beklager – vi kunne ikke finne noen',
        'NOBODY_HAS_ADDED_PHOTOS' => 'Ingen har lagt til bilder ennå!  Legg til noen bilder for å komme i gang.',
        'DEFAULT_TITLE' => 'Tittel',
        'DEFAULT_DESCRIPTION' => 'Beskrivelse',
        'UPLOAD_LIMIT_EXCEEDED' => 'Grensen for størrelsen på filer som kan lastes opp har blitt oversteget.',
        'SLOW_DOWN_THERE_CHIEF' => 'Vi beklager',
        'I_DO_NOT_KNOW_USER' => 'Beklager, jeg kjenner ikke denne personen.',
        'I_DO_NOT_HAVE_PHOTO' => 'Beklager, jeg har ikke dette bildet.',
        'I_DO_NOT_HAVE_ALBUM' => 'Beklager, jeg har ikke dette albumet.',
        'ALBUM_BY_X_ON_X' => 'Album opprettet av %s på %s',
        'SENT' => 'Sendt!',
        'I_HAVE_RECENTLY_ADDED' => 'Jeg har nylig lagt til',
        'FROM_THE_BAZEL' => 'Fra dette nettverket',
        'RECENTLY_ADDED' => 'Nylig lagt til',
        'RECENT_PUBLIC_PHOTOS_ON_X' => 'Nyere offentlige bilder på %s',
        'X_ALL_PHOTOS' => '%s – alle bilder',
        'NO_TAG_WAS_SPECIFIED' => 'Intet merke ble spesifisert',
        'PUBLIC_PHOTOS_TAGGED_WITH_X' => 'Offentlige bilder merket som %s på %s',
        'XS_PUBLIC_PHOTOS_ON_X' => '%ss offentlige bilder på %s',
        'WE_DO_NOT_KNOW_USER' => 'Vi kjenner ikke denne personen.',
        'XS_FRIENDS_PHOTOS' => 'Bildene til %ss venner',
        'XS_FAVORITE_PHOTOS_ON_X' => '%ss favorittbilder på %s',
        'PHOTO_UPLOADED_ON_X' => 'Bilder lastet opp på %s',
        'FILE_EXCEEDED_MAXIMUM_SIZE' => 'Denne filen overstiger maksimumsstørrelsen',
        'PART_OF_FILE_WAS_UPLOADED' => 'Kun en del av denne filen ble lastet opp',
        'NO_FILE_WAS_UPLOADED' => 'Opplastingen mislyktes;  filnavnet kan ha vært galt',
        'PROBLEM_OCCURRED_DURING_UPLOAD' => 'Et problem oppsto under opplastingen.',
        'ALPHABETICAL' => 'Alfabetisk',
        'MOST_VIEWS' => 'Flest visninger',
        'RATING_NOT_RATED_YET' => '<strong>Rangering:/strong> Har ikke blitt rangert ennå',
        'NOT_RATED_YET' => 'Har ikke blitt rangert ennå',
        'HMM_SOMETHING_WENT_AWRY' => 'Hmm... noe har gått galt',
        'YOUR_PHOTO_TITLED_X_COULD_NOT' => 'Bildene dine ved navn "%s" kunne ikke legges til på %s',
        'YOUR_PHOTO_COULD_NOT_BE_ADDED' => 'Bildene dine kunne ikke legges til på %s',
        'YOU_JUST_TRIED_TO_SEND' => 'Du forsøkte nettopp å sende inn et bilde til %s.  Dessverre er du ikke medlem av %s og vi kan ikke levere dette bildet.',
        'ONLY_MY_FRIENDS' => 'Bare vennene mine',
        'ANYBODY' => 'Hvem som helst',
        'ONLY_MY_FRIENDS_CAN_SEE_PHOTO' => 'Dette bildet kan bare sees av vennene mine',
        'ONLY_XS_FRIENDS_CAN_SEE_PHOTO' => 'Dette bildet kan bare sees av %ss venner',
        'ONLY_I_CAN_SEE_PHOTO' => 'Dette bildet kan bare sees av meg',
        'ONLY_X_CAN_SEE_PHOTO' => 'Dette bildet kan bare sees av %s',
        'EVERYONE_CAN_SEE_PHOTO' => 'Dette bildet kan sees av alle',
        'PRIVATE_PHOTO' => '<strong>Privat</strong> bilde',
        'HOWDY_STRANGER' => 'Heisann, fremmede!',
        'YOU_NEED_TO_BE_SIGNED_IN' => 'Du må være logget inn på Ning før du kan gjøre det.',
        'JUST_CLICK_ON_SIGN_IN' => 'Det er bare å klikke på "Logg inn" ovenfor. Hvis du ikke har en Ning-konto, klikk på "Registrer deg".',
        'YOU_NEED_TO_BE_' => 'Du må være %s for å kunne gjøre det.',
        'YOU_NEED_TO_BE_OWNER' => 'Du må være nettverksoppretteren for å kunne gjøre det.',
        'THAT_PHOTO_IS_AWAITING_APPROVAL' => 'Det bildet venter på godkjenning.',
        'YOU_NEED_TO_BE_A_FRIEND' => 'Du må være en venn av %s for å kunne gjøre det.',
        'MOST_ACTIVE' => 'Mest aktiv',
        'HOW_IT_WORKS' => 'Hvordan det fungerer',
        'MORE_WAYS_TO_ADD_PHOTOS' => 'Flere måter å legge til bilder på...',
        'BY_PHONE_OR_EMAIL' => '...via telefon eller e-post',
        'FROM_FLICKR' => '...fra Flickr',
        'FROM_YOUR_COMPUTER' => '...fra din datamaskin',
        'ADD_PHOTOS_FROM_YOUR_FLICKR' => 'Legg til bilder fra din Flickr-konto.',
        'MORE_INFORMATION' => 'Mer informasjon',
        'ADD_PHOTOS_BY_PHONE_OR_EMAIL' => 'Legg til bilder via telefon eller e-post.',
        'SEND_ONE_PHOTO_OR_VIDEO' => 'Send et bilde eller video via e-post.  Tittelen på e-posten vil bli tittelen på bildet eller videoen, og innholdet vil bli beskrivelsen.',
        'CLICK_HERE_TO_GET_A_NEW_UNIQUE' => 'Klikk her for å få en ny e-postadresse',
        'UPLOAD_PHOTOS_FROM_YOUR' => 'Last opp et bilde fra datamaskinen din.',
        'PHOTO' => 'bilde',
        'YOUVE_SET_THE_NUMBER_OF_PHOTOS' => 'Foreløpig viser du ingen bilder.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_PHOTO' => 'Dette vinduet vil ikke vises for andre med mindre du velger minst ett bilde.',
        'THERE_IS_NEW_COMMENT_ON_PHOTO_X' => 'Det er lagt til en ny kommentar på bildet ditt, "%s", på %s',
        'THERE_IS_NEW_COMMENT_ON_PHOTO' => 'Det er lagt til en ny kommentar på et av bildene dine på %s',
        'SOMEBODY_COMMENTED_PHOTO_ADDED_TO_X' => 'noen har kommentert et bilde du har lagt til på %s',
        'SOMEBODY_UPLOADED_PHOTO_TO_X' => 'noen har lastet opp et bilde på %s',
        'ADD_PHOTOS_OR_VIDEOS_TO_X' => 'Legg til videoer eller bilder til %s direkte fra telefonen din ved å sende dem til en e-postadresse.',
        'DO_YOU_REALLY_WANT_TO_REMOVE' => 'Vil du virkelig fjerne denne artikkelen fra dine favoritter?',
        'DELETE_THIS_PHOTO_Q' => 'Slette dette bildet?',
        'ARE_YOU_SURE_DELETE_THIS_PHOTO' => 'Er du sikker på at du vil slette dette bildet?  Dette kan ta et par minutter.',
        'PHOTO_SLIDESHOW' => 'Lysbildeshow',
        'THUMBNAILS' => 'Miniatyrbilder',
        'DETAIL' => 'Detalj',
        'TAG' => 'Merke',
        'RATE' => 'Ranger',
        'ALL_SIZES' => 'Alle størrelser',
        'ADD_TO_ALBUM' => 'Legg til i album',
        'ROTATE_PHOTO' => 'Roter bilde',
        'ABOUT_YOUR_PHOTO' => 'Om bildet ditt',
        'SEE_PHOTOS_ON_NETWORK' => 'Se disse bildene på %s',
        'EMBED_CODE' => 'Embed-kode',
        'IMPORT_PHOTOS_FLICKR' => 'Hent bildene dine fra Flickr',
        'CLICK_HERE_TO_CONTINUE_TO_FLICKR' => 'Klikk her for å fortsette til Flickr',
        'TO_GET_YOUR_PHOTOS_FROM_FLICKR' => 'For å hente bildene dine fra Flickr må du først la %S koble seg til Flickr-kontoen din.',
        'IMPORT_PHOTOS' => 'Importer bilder',
        'GET_MY' => 'Hent',
        'GET_PHOTOS' => 'Hent bilder',
        'MOST_RECENT_PHOTOS' => 'nyeste bilder',
        'GET_ALL_MY_FLICKR' => 'Hent alle bildene mine fra Flickr (kan ta litt tid)',
        'GET_ALL_MY_TAGGED' => 'Hent alle bildene mine som er merket',
        'GET_PHOTOS_FROM_SET' => 'Hent alle bilder fra et sett:',
        'GET_STARTED_BY_IMPORT' => 'Vi vil automatisk hente titlene, merkene og annen kartleggingsinformasjon du har lagt til. <br/>Hvor lang tid vil det ta? </p> <p><ul style="padding-top:10px; "><li>10 bilder: <em>mindre enn 30 sekunder</em>. </li><li>50 bilder: <em>omtrent 2 minutter</em>. </li><li>200 bilder: <em>omtrent 6 minutter</em>. </li><li>500 bilder: <em>omtrent 15 minutter</em>. </li></ul>',
        'IF_YOURE_NOT_SIGNED_IN' => 'Hvis du ikke allerede er logget inn på Flickr vil du bli bedt om å logge inn.  Når du har logget deg inn, klikk på knappen med teksten "OK, jeg gir min tillatelse".',
        'GET_MY_FLICKR_PHOTOS_DESCRIPTIONS' => 'Hent beskrivelser også (dette vil fordoble tiden det tar).',
        'PLEASE_KEEP_THIS_PAGE_OPEN_WHILE_IMPORT' => 'La denne siden være åpen så vi kan fullføre importeringen av bildene dine.',
        'GET_MY_FLICKR_PHOTOS_ORIGINALS' => 'Hent hvert bilde i full størrelse (dette vil øke importeringstiden drastisk, og vi fraråder dette dersom mer enn 20 bilder importeres).',
        'MAKE_YOUR_X_PAGE_YOUR_OWN' => 'Klikk på "rediger" for å legge til tekst, videoer, bilder eller innretninger i dette vinduet.  Dette er nok en måte å gjøre %s-siden din mer personlig på.',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Klikk \'Rediger\' for å legge til tekst, HTML, videoer, bilder, eller en <a %1$s>tredjeparts innretning</a> til dette vinduet.',
        'BOX_WILL_NOT_SHOW_UNTIL_UPDATE_CONTENT' => 'Dette vinduet vil ikke vises for andre med mindre du oppdaterer innholdet.',
        'YOUR_X_BOX' => 'Ditt %s-vindu',
        'ABOUT_WIDGETS' => 'Om innretningene',
        'HELP' => 'Hjelp',
        'WIDGETS' => 'Innretninger',
        'LOOKING_TO_ADD_FUNCTIONALITY' => 'Lurer du på hvordan du kan gjøre ditt sosiale nettverk mer funksjonelt?  Kanskje en kalender, lokal værmelding, nedtelling til begivenheter, eller et web-kamera?  Med innretninger er det enkelt å legge til ytterligere funksjoner til et hvilket som helst tekstvindu i ditt nettverk.',
        'GETTING_STARTED' => 'Komme i gang',
        'BELOW_IS_LIST_OF_WIDGET' => 'Nedenfor finnes en <a %s>liste med innrettingsdistributører</a> du kanskje vil ha lyst til å sjekke ut.  Vi har valgt et par innretninger fra <a %s>yourminis. com</a> for å hjelpe deg med å komme i gang.  Det er bare å sette opp en innretning nedenfor, kopiere embed-koden og lime den direkte inn i tekstvinduet.  Gjør det!',
        'CALENDAR' => 'Kalender',
        'CALENDAR_WIDGET_ALLOWS_SEARCH' => 'Kalenderinnretningen ikke bare viser datoen, men lar deg også søke etter og legge til begivenheter i iCal-format (brukt av Google-kalenderen og mange andre kalenderdistributører på nettet).',
        'USE_EDIT_WIDGET_BUTTON_CALENDAR' => 'Bruk &#8220;rediger innretning&#8221; -knappen for å velge &#8220; søk etter begivenheter&#8221; , og legg deretter inn et søkeord (prøv ferier, et idrettslag, osv. ). Deretter velger du et søkeresultat for å legge til den begivenheten i kalenderen din.  Du kan også legge inn adressen manuelt for eksisterende iCal-feed.',
        'CUSTOMIZATION' => 'Tilpasning',
        'YOU_CAN_CUSTOMIZE_WIDGET' => 'Du kan tilpasse utseendet ved å føre musa over innretningen, og deretter klikke på fargevelgerikonet for å endre bakgrunn, innretningsstil og gjennomsiktighetsgrad.  Når du er ferdig, klikker du på &#8220; kopier til nett&#8221;  -lenka, deretter på &#8220; kopier embed-kode&#8221;  -knappen.  Når koden er kopiert kan du gå tilbake til et hvilket som helst tekstvindu på nettverket ditt, lime inn koden og lagre endringene.  Alt klart!',
        'GET_MORE_WIDGETS_FROM_YOURMINIS' => 'Hent flere innretninger fra yourminis. com >>',
        'WEATHER' => 'Været',
        'WEATHER_WIDGET_DISPLAYS' => 'Værinnretningen viser den lokale værmeldingen fra værkanalen.',
        'USE_EDIT_WIDGET_BUTTON_WEATHER' => 'Bruk &#8220; rediger innretning&#8221;  -knappen for å velge stedet du befinner deg på og velge mellom fahrenheit eller celsius.  Du kan velge å vise været kun for gjeldende dag, eller utvide det til en femdagers værmelding.',
        'COUNTDOWN' => 'Nedtelling',
        'COUNTDOWN_WIDGET_LETS_YOU' => 'Nedtellingsinnretningen lar deg opprette en nedtelling for en spesifikk begivenhet.  Ved å klikke på &#8220; rediger innretning&#8221;  -knappen kan du legge inn dato, tidspunkt og tittel eller bilde for begivenheten som du teller ned til.',
        'WEBCAM' => 'Web-kamera',
        'WEBCAM_WIDGET_ALLOWS_YOU' => 'Web-kamerainnretningen lar deg aktivt følge med på offentlig tilgjengelige web-kameraer.  Bruk &#8220;rediger innretning&#8221; -knappen til å velge fra en liste med forhåndsdefinerte web-kameraer, eller legg inn URL-adresser for web-kameraer manuelt.',
        'MORE_WIDGETS' => 'Flere innretninger',
        'NEED_MORE_OPTIONS' => 'Trenger du flere alternativ?  Vi anbefaler følgende nettsider for å slukke tørsten din for innretninger:',
        'MODERATION_DENIED_ON_X' => 'Moderering avslått for %s på %s',
        'MODERATION_DENIED_ON_A_X' => 'Moderering avslått for en av dine %s på %s',
        'YOU_HAVE_NEW_X_TO_MODERATE' => 'Du har en ny %s som kan modereres på %s',
        'NEW_X_TO_MODERATE' => 'Det er en ny %s som du kan moderere.',
        'MODERATION_APPROVED_ON_X' => 'Moderering godkjent for %s på %s',
        'MODERATION_APPROVED_ON_A_X' => 'Moderering godkjent for en av dine %s på %s',
        'JOIN' => 'Bli med',
        'WELCOME' => 'Velkommen',
        'WELCOME_TO_X' => 'Velkommen til %s',
        'WELCOME_TO_X_ELLIPSIS' => 'Velkommen til %s...',
        'RSS_LINK' => '<a %s>RSS</a>',
        'NEW_FEATURES_GROUPS_MUSIC' => '<h3 style="margin-top:0">Nye funksjoner! </h3>
            <ul><li><strong>Grupper</strong> &ndash;  La medlemmene dine opprette grupper på nettverket ditt</li>
                <li><strong>musikkspiller</strong> &ndash;  Legg til musikk og podkaster til nettverket ditt</li></ul>
            <p><a href="%s" class="desc add">Klikk her for å legge til funksjoner</a></p>',
        'NEW_FEATURES_ACTIVITY_BADGES' => '<h3 style="margin-top:0">Nye funksjoner! </h3>
            <ul><li><strong>Siste aktivitet</strong> &ndash;  Følg den siste medlemsaktiviteten på nettverket ditt</li>
                <li><strong>Skilt & innretninger</strong> &ndash;  Markedsfør nettverket ditt på nettet med egendefinerte skilt og innretninger</li></ul>
            <p><a href="%s" class="desc add">Klikk her for å legge til/redigere funksjoner</a></p>',
        'YOUR_TYPE_NAME_HAS_NEW_COMMENT_APPNAME' => 'Noen på %3$s har lagt til en ny kommentar til din %2$s, %1$s!',
        'YOUR_TYPE_HAS_NEW_COMMENT_APPNAME' => 'Noen på %2$s har lagt til en ny kommentar til din %1$s!',
        'HERE_IS_LINK' => 'Her er lenka for å bli med: <a %s>%s</a>',
        'THANKS_VALEDICTION' => 'Takk,',
        'THANKS' => 'Takk!',
        'YOU_CHANGED_YOUR_EMAIL_ON_X' => 'Du endret e-postadressen din på %s.',
        'YOU_CHANGED_YOUR_EMAIL_ON_X_ELLIPSIS' => 'Du endret e-postadressen din på %s...',
        'CLICK_HERE_TO_SIGN_IN_WITH_YOUR_NEW_EMAIL_ADDRESS' => 'Klikk her for å logge inn med din nye e-postadresse:',
        'IF_DID_NOT_CHANGE_EMAIL_ADDRESS' => 'Hvis du ikke endret e-postadressen din, klikk her:',
        'TO_STOP_BEING_NOTIFIED_OF_NEW_DISCUSSIONS_GO_TO' => 'For ikke lenger å bli varslet om nye diskusjoner, gå til:',
        'X_STARTED_DISCUSSION_ON_APPNAME_ELLIPSIS' => '%1$s begynte en ny diskusjon på %2$s...',
        'X_STARTED_THE_DISCUSSION_Y' => '%1$s begynte diskusjonen "%2$s".',
        'TO_VIEW_THIS_DISCUSSION_GO_TO' => 'For å se denne diskusjonen, gå til:',
        'X_HAS_INVITED_YOU_TO_JOIN_Y' => '%s har invitert deg til å bli med i %s!',
        'X_WANTS_YOU_TO_CHECK_OUT_Y' => '%s vil at du skal sjekke ut "%s" på %s!',
        'CHECK_OUT_TITLE_ON_APPNAME' => 'Sjekk ut "%s" på %s!',
        'ABOUT_X' => 'Om %s',
        'YOU_HAVE_RECEIVED_BECAUSE_X' => 'Du har mottatt denne e-posten fordi %s',
        'IF_YOU_NO_LONGER_WISH_FROM_X_CLICK_Y' => 'Hvis du ikke lenger ønsker å motta varslingse-poster fra %s, <a %s>klikk her</a>.',
        'CLICK_HERE' => 'Klikk her',
        'YOU_CAN_CONTACT_US' => 'Du kan ta kontakt med oss i forbindelse med spørsmål eller problemer angående ditt personvern på http://help.ning.com/?page_id=27 .',
        'MESSAGE_TO_ALL_MEMBERS_OF_X' => 'En melding til alle medlemmer av %s',
        'CLICK_TO_CHECK_OUT' => 'Klikk her for å sjekke den ut!',
        'CLICK_TO_APPROVE_X' => 'Klikk her for å godkjenne/slette denne %s',
        'YOUR_X_HAS_BEEN_APPROVED' => 'Din %s har blitt godkjent for %s!',
        'YOUR_X_WAS_NOT_APPROVED' => 'Din %s ble ikke godkjent for %s.',
        'CLICK_TO_VIEW_X' => 'Klikk her for å se denne %s!',
        'CLICK_TO_VIEW_IT' => 'Klikk her for å se den!',
        'TO_VIEW_USER_PROFILE_VISIT' => 'For å se %ss profil, gå til:',
        'YOU_ADDED_CONTENT' => 'du har lagt til innhold til %s, et moderert sosialt nettverk',
        'X_REPORTED_AN_ISSUE_ON_Y_ELLIPSIS' => '%1$s har meldt fra om et problem på %2$s...',
        'X_REPORTED_THE_FOLLOWING_ISSUE' => '%s meldte fra om følgende problem.',
        'URL_REPORTED_COLON' => 'URL-adresse som ble rapportert:',
        'ISSUE_COLON' => 'Problem:',
        'ADDITIONAL_INFORMATION_COLON' => 'Ytterligere informasjon:',
        'SEND_AN_INVITATION_TO_X' => 'Send en invitasjon til %s',
        'SOMEBODY_REQUESTED_JOIN_X' => 'noen har bedt om å bli med i %s',
        'WANT_TO_ADD_A_WELCOME_MESSAGE_FOR_X_ON_THEIR_PROFILE_GO_TO' => 'Vil du legge til en velkomstmelding til %s på profilen deres?   Gå til:',
        'USER_HAS_SENT_YOU_A_MESSAGE' => '%s har sendt deg en melding.',
        'TO_READ_THIS_MESSAGE_VISIT' => 'For å lese denne meldingen, går du til:',
        'X_HAS_SENT_YOU_A_MESSAGE_ON_Y_ELLIPSIS' => '%s har sendt deg en melding på %s...',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ELLIPSIS' => '%s har lagt deg til som venn...',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ON_Y' => '%s har lagt deg til som venn på %s...',
        'X_HAS_ACCEPTED_YOUR_FRIEND_REQUEST' => '%s har godtatt venneforespørselen din på %s!',
        'TO_ACCEPT_THIS_FRIEND_REQUEST_VISIT' => 'For å godta denne venneforespørselen, går du til:',
        'VIEW_XS_PAGE_ON_Y' => 'Se %ss side på %s',
        'MEMBER_OF_X_ACCEPTED' => 'et medlem av %s har godtatt venneforespørselen din',
        'IF_NO_LONGER_WISH_FRIEND_NOTIFICATION_EMAIL_FROM_X_CLICK_Y' => 'Hvis du ikke lenger ønsker å motta varslingse-poster om venneforespørselen fra %s, <a %s>klikk her</a>.',
        'YOU_RECEIVED_INVITATION_FROM_X' => 'Du mottok denne invitasjonen fra et medlem av %1$s.  Hvis du ikke ønsker å motta invitasjoner fra %1$s, tar du kontakt med oss på http://help.ning.com/?page_id=27 .',
        'ON_X_COLON' => 'På %s:',
        'ON_X' => 'på %s',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP' => '%s har bedt om å bli medlem av %s.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X_ELLIPSIS' => '%1$s har bedt om å bli med i %2$s på %3$s...',
        'USER_HAS_INVITED_YOU_TO_JOIN_THE_GROUP_X' => '%1$s har invitert deg til å bli med i gruppen "%2$s"',
        'VISIT_GROUP_AT' => 'Gå til %s på:',
        'ABOUT_GROUP' => 'Om %s',
        'A_MESSAGE_FROM_USERNAME_TO_GROUPNAME_ON_APPNAME' => 'En melding fra %s til alle medlemmer av %s på %s!',
        'YOU_CAN_SIGN_IN_USING_EMAIL_HERE' => 'Du kan logge inn med e-postadressen din her:',
        'USERNAME_COMMENTED_ON_BLOG_POST_TITLE_APPNAME' => '%s kommenterte blogg-innlegget \'%s\' på %s',
        'SEND_X_A_MESSAGE_HERE' => 'Send en melding til %s her:',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X_ELLIPSIS' => 'Du har et nytt medlem som må godkjennes på %s...',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE' => 'Du har et nytt medlem som må godkjennes.',
        'TO_APPROVE_XS_PROFILE_VISIT' => 'For å godkjenne %ss profil, gå til:',
        'CANT_CLICK_CUT_AND_PASTE' => 'Kan du ikke klikke på linken ovenfor?  Kopier og lim URL-adresssen inn i nettleseren din.',
        'CLICK_HERE_TO_JOIN_COLON' => 'Klikk her for å bli med:',
        'CLICK_HERE_TO_JOIN_BANG' => 'Klikk her for å bli med!',
        'YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED_ELLIPSIS' => 'Ditt medlemskap i %s ble godkjent...',
        'CONGRATULATIONS_BANG_YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED' => 'Gratulerer!   Ditt medlemskap i %s ble godkjent.',
        'YOU_CAN_NOW_SIGN_IN_USING_YOUR_EMAIL_ADDRESS_HERE' => 'Du kan nå logge inn med e-postadressen din her:',
        'VISIT_X_AT_Y' => 'Gå til %1$s på: %2$s',
        'TO_CONTROL_WHICH_EMAILS_YOUR_RECEIVE_ON_X_GO_TO' => 'For å regulere hvilke e-poster du mottar på %1$s, går du til:',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_ELLIPSIS' => 'Et medlem som har blitt utstengt har sendt deg en melding på %s...',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_USERNAME_WRITES' => 'Et medlem som har blitt utstengt har sendt deg en melding på %1$s.   %2$s skrev:',
        'WELCOME_TO_THE_GROUP_X' => 'Velkommen til gruppen "%s"',
        'WELCOME_TO_GROUP_X_ON_Y_ELLIPSIS' => 'Velkommen til %1$s på %2$s...',
        'TO_VIEW_THIS_GROUP_VISIT' => 'For å se denne gruppen, gå til:',
        'X_INVITES_YOU_TO_JOIN_Y' => '%1$s har invitert deg til å bli med i %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y' => '%1$s er nå medlem av %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y_ELLIPSIS' => '%1$s er nå medlem av %2$s...',
        'SOMEBODY' => 'Noen',
        'TO_VIEW_YOUR_NEW_COMMENT_VISIT' => 'For å se denne kommentaren, går du til:',
        'TO_VIEW_THE_NEW_COMMENT_VISIT' => 'For å se den nye kommentaren, går du til:',
        'TO_VIEW_THE_NEW_REPLY_VISIT' => 'For å se det nye svaret, går du til:',
        'WELCOME_TO_X_THANK_YOU_FOR_JOINING' => 'Velkommen til %s!  Takk for at du ble med.',
        'NAME_COLON' => 'Navn:',
        'EMAIL_COLON' => 'E-post:',
        'AGE_COLON' => 'Alder:',
        'GENDER_COLON' => 'Kjønn:',
        'LOCATION_COLON' => 'Sted:',
        'COUNTRY_COLON' => 'Land:',
        'GET_NETWORK_BADGE' => '%s-skilt',
        'SPREAD_WORD_GET_BADGE' => 'Tips en venn.  Skaff deg ditt eget %s-skilt for nettsiden eller MySpace-siden din.  (<a %s>Skaff kode</a>)',
        'SPREAD_WORD_GET_BADGE_SHORT' => 'Tips en venn.  <a href="%s">Skaff deg ditt eget %s-skilt</a>',
        'SHOW_ALLEGIANCE_GET_BADGE' => 'Vis din lojalitet.  Skaff deg ditt eget %s-skilt som du kan sette på nettsiden eller MySpace-siden din.  (<a %s>Skaff kode</a>)',
        'USER_COMMENTED_ON_A_TYPE_ON_APPNAME' => '%1$s kommenterte %2$s "%4$s" på %3$s',
        'UNABLE_TO_EXTRACT_EMAIL_ADDRESSES' => 'Vi beklager  - vi kunne ikke finne noen e-postadresser i denne filen.',
        'ADMINISTRATORS' => 'Administratorer',
        'YOUR_INVITATION_HAS_EXPIRED' => 'Invitasjonen din har gått ut.',
        'SORRY_INVITATION_EXPIRED' => 'Vi beklager, invitasjonen du har brukt har gått ut.   Du trenger en ny invitasjon for å bli med i %s.',
        'DISABLE_INVITATION_LINK' => 'Deaktiver invitasjonslenka?',
        'CREATING_LINK_WILL_DISABLE' => 'Hvis du oppretter en ny invitasjonslenke vil du deaktivere den gjeldende lenka.  Er du sikker på at du vil opprette en ny lenke?',
        'SHARE_LINK_WITH_PEOPLE' => 'Del denne lenka med folk du ønsker at skal bli med i dette nettverket:',
        'CREATE_INVITATION_LINK' => 'Opprett ny invitasjonslenke',
        'PLEASE_SELECT_SECOND_PART' => 'Velg andre del av e-postadressen din, f. eks. gmail. com.',
        'AT_SYMBOL_NOT_ALLOWED' => 'Sørg for at @-symbolet ikke er i den første delen av e-postadressen din.',
        'SORRY_WE_DONT_SUPPORT' => 'Beklager, vi støtter ikke nettbasert adressebok for e-postadressen din.  Prøv å klikke på \'E-postprogram\' nedenfor for å bruke adresser fra datamaskinen din.',
        'PLEASE_ENTER_PASSWORD_FOR_EMAIL' => 'Oppgi passordet ditt for %s.',
        'IMPORTING_ADDRESS_BOOK' => 'Importerer adressebok',
        'LEAVE_WINDOW_WHILE_GET' => '<strong>La vinduet være åpent</strong> mens vi får tak i dine venners e-postadresser.  Når vi er ferdig kan du velge hvilke venner du ønsker å invitere.',
        'SHARE_THIS_LINK' => 'Del denne lenka:',
        'SEND_WITH_EMAIL_PROGRAM' => 'Send den med e-postprogrammet på datamaskinen din:',
        'EMAIL_THIS' => 'Send dette på e-post',
        'IS_YOUR_FRIEND_PARENTHESIZED' => '(er din venn)',
        'CLEAR' => 'Fjern',
        'SEARCH_FRIENDS_TO_INVITE' => 'Søk etter venner du kan invitere:',
        'YOUR_INVITATIONS_HAVE_BEEN_SENT' => 'Invitasjonene dine er sendt',
        'WANT_TO_INVITE_MORE' => 'Vil du invitere flere venner?  Inviter flere venner ved å importere kontakter fra den nettbaserte adresseboken din eller e-postprogrammet ditt.',
        'MESSAGE_TOO_LONG' => 'Meldingen er for lang. Bruk færre enn %s tegn.',
        'FOLLOWING_DO_NOT_SEEM_VALID' => 'Følgende ser ikke ut til å være gyldige e-postadresser.  Invitasjonene ble ikke sendt.  Rett opp e-postadressene og prøv igjen.',
        'PLEASE_ENTER_EMAIL_ADDRESSES' => 'Legg inn én eller flere e-postadresser.',
        'ENTER_EMAIL_ADDRESSES' => 'Legg inn e-postadresser',
        'SEPARATE_MULTIPLE_ADDRESSES' => 'Adskill hver adresse med et komma',
        'YOUR_MESSAGE_OPTIONAL' => '<label>Din melding</label> (valgfritt)',
        'SEND_INVITATIONS' => 'Send invitasjoner',
        'WEB_ADDRESS_BOOK' => 'Nettbasert adressebok',
        'YAHOO_MAIL_HOTMAIL' => 'Yahoo Mail, Hotmail, GMail eller AOL Mail',
        'YOUR_EMAIL_ADDRESS' => 'Din e-postadresse',
        'IMPORT_ADDRESS_BOOK' => 'Importer adressebok',
        'DONT_WORRY_WE_WONT_SAVE' => 'Ingen grunn til bekymring; vi vil ikke lagre passordet ditt, og du vil fortsatt kunne velge hvilke venner du vil sende en e-post til.',
        'EMAIL_APPLICATION' => 'E-postprogram',
        'MICROSOFT_OUTLOOK_APPLE_MAIL' => 'Microsoft Outlook, Apple Mail, . CSV, osv.',
        'UPLOAD_CSV_OR_VCF' => 'Last opp en . csv- eller . vcf-fil som er eksportert fra Microsoft Outlook eller Apple adressebok.',
        'BROWSE_FOR_FILE' => 'Se etter fil',
        'UPLOAD' => 'Last opp',
        'SELECT_ELLIPSIS' => 'velg...',
        'OTHER_ELLIPSIS' => 'annet...',
        'DONT_WORRY_YOULL_GET_CHANCE' => 'Ingen grunn til bekymring, du vil fortsatt få velge hvilke venner du vil sende en e-post til.',
        'MEMBERSHIP_BY_INVITATION_ONLY' => 'Medlemskap kun ved invitasjon',
        'IF_YOU_ARE_ADMIN' => 'Hvis du er administrator, <a %s>klikker du her for å logge inn</a>.',
        'NAME_MUST_BE_SHORTER' => 'Navnet må være mindre enn %s tegn',
        'CITY_NAME_MUST_BE_SHORTER' => 'Bynavnet må være mindre enn %s tegn',
        'EMAIL_ALREADY_REGISTERED' => 'Denne e-postadressen er allerede registrert.  Velg en annen.',
        'EMAIL_NOT_VALID' => 'Denne e-postadressen ser ikke ut til å være gyldig.',
        'USERNAME_INVITED_YOU_TO_APPNAME' => '%s har invitert deg til %s',
        'YOU_ARE_SIGNING_UP_WITH' => 'Du registrerer deg med din Ning-ID.',
        'NOW_ENTER_PASSWORD' => 'Nå trenger du bare å legge inn passordet ditt for å fortsette.',
        'OR_SIGN_IN' => 'eller <a %s>logg inn</a>',
        'CHANGE_ADDRESS' => 'Endre adresse',
        'CHANGE_PAGE_ADDRESS' => 'Endre sideadresse',
        'PAGE_ADDRESS_TAKEN' => 'Vi beklager – den adressen er allerede i bruk.  Velg en annen.',
        'PAGE_ADDRESS_NOT_VALID' => 'Du kan kun bruke bokstavene mellom A og Z, tall og tegnet ’_’ i adressen din.',
        'ADD_BY_PHONE' => 'Legg til via telefon',
        'PAGE_ADDRESS' => 'Sideadresse',
        'PHOTO_MUST_BE_TYPE' => 'Bildet ditt må være en . jpg-, . gif- eller . png-fil.',
        'USEFUL_ADDRESSES' => 'Nyttige adresser',
        'MY_DETAILS' => 'Mine detaljer',
        'NONE_I_DO_NOT_WANT' => 'Ingen: Jeg vil ikke motta e-poster fra %s',
        'CHANGE_PASSWORD' => 'Endre passord',
        'PROFILE_SAVED' => 'Endringene dine er lagret.',
        'UPDATE_EMAIL_ADDRESS' => 'Oppdater e-postadresse',
        'EDIT_EMAIL_ADDRESS' => 'Rediger e-postadressen din',
        'MY_SETTINGS' => 'Mine innstillinger',
        'ABOUT_ME' => 'Om meg',
        'SELECT' => 'Velg...',
        'CITY' => 'By',
        'COUNTRY' => 'Land',
        'DATE_OF_BIRTH' => 'Fødselsdato',
        'DO_NOT_DISPLAY' => 'Ikke vis',
        'GENDER' => 'Kjønn',
        'CREATE_YOUR_PROFILE' => 'Opprett profilen din',
        'SYSTEM_REQUIREMENTS' => 'Systemkrav',
        'WE_SUPPORT_INTERNET_EXPLORER' => 'Vi støtter Internet Explorer 6 og 7, Firefox 2.0 og Safari 2.0. Hvis du bruker en annen nettleser (kanskje en som forsynes av internettleverandøren din) kan det hende at den ikke vil være kompatibel.',
        'MAKE_SURE_COOKIES' => 'Sørg for at informasjonskapsler og JavaScript er aktivert på nettleseren din.',
        'WHAT_IS_MY_EMAIL' => 'Hva er e-postadressen min?',
        'IF_JOINED_BEFORE_OCTOBER' => 'Hvis du ble med før 5. oktober 2007, kan du tidligere ha blitt bedt om en \'Ning-ID\'.  Nå ber vi deg om å logge inn med den e-postadressen du registrerte deg med. Men du kan likevel legge inn din Ning-ID din i dette feltet.',
        'CLICK_HERE_TO_RESET_PASSWORD' => 'Klikk her for å endre passordet ditt.',
        'STILL_HAVING_PROBLEMS' => 'Har du fortsatt problemer?',
        'VISIT_NING_HELP_CENTER' => 'Gå til <a %s>Ning hjelpesenter</a> for mer feilsøkingsinformasjon og støtte.',
        'PROBLEMS_SIGNING_UP_OR_SIGNING_IN' => 'Problemer med registrering eller innlogging',
        'WE_SENT_YOU_EMAIL' => 'Vi har sendt deg en e-post med en lenke du kan bruke til å endre passordet ditt.',
        'RESET_PASSWORD_EMAIL_SUBJECT' => 'Endring av passord',
        'RESET_PASSWORD_EMAIL_BODY' => '%1$s,

Vi har mottatt en forespørsel om å endre passordet ditt på %2$s.

Klikk på lenka nedenfor for å legge inn et nytt passord:

#{URL}

Hvis du ikke vil endre passordet ditt kan du se bort fra denne e-posten.

Takk,
"%2$s"-teamet

-----
%2$s bruker din Ning-ID for godkjenning.',
        'SET_PASSWORD' => 'Legg inn passord',
        'NEW_PASSWORD' => 'Nytt passord',
        'CREATE_NEW_PASSWORD' => 'Lag et nytt passord',
        'SET_NEW_PASSWORD' => 'Angi nytt passord for kontoen din.',
        'CHOOSE_NEW_PASSWORD' => 'Velg nytt passord',
        'HELLO_USERNAME_SIGN_OUT' => '<strong>Hei %s</strong> (<a %s>Logg ut</a>)',
        'NO_ACCOUNT_WITH_EMAIL_X' => 'Det finnes ingen konto med e-postadresse %s',
        'PLEASE_ENTER_CODE' => 'Legg inn koden som vises på høyre side.',
        'PROBLEMS_SIGNING_UP' => 'Problemer med å registrere deg?',
        'BY_SIGNING_UP_YOU_AGREE' => 'Ved å registrere deg sier du deg enig i <a %s> servicebetingelsene</a> og <a %s>retningslinjene for& nbsp; personvern</a>.',
        'FEEDBACK' => 'Tilbakemelding',
        'TERMS_OF_SERVICE' => 'Servicebetingelser',
        'PROBLEM_SIGNING_UP' => 'Det oppsto et problem under registreringen',
        'ALREADY_MEMBER_SIGN_IN' => 'Allerede medlem?  <a %s>Klikk her for å logge inn</a>.',
        'MEMBERSHIP_TO_APPNAME_BY_INVITATION_ONLY' => 'Medlemskap i %s kan kun oppnås ved invitasjon',
        'SORRY_BUT_ADMINISTRATOR_REQUIRES_INVITATION' => 'Vi beklager, men administratoren har valgt å begrense medlemskap i %s til de som har mottatt en invitasjon.  Hvis du har en invitasjon kan du klikke på lenka i e-posten for å bli med.',
        'PROBLEM_SIGNING_IN' => 'Det oppsto et problem under innloggingen',
        'WE_USE_NING_ID' => 'Vi bruker Ning-ID for godkjenning.  <a %s>Hva er en Ning-ID? </a>',
        'PROBLEMS_SIGNING_IN' => 'Problemer med å logge inn?',
        'SIGN_IN_OR_SIGN_UP' => '<input %s value="Sign in" /> &#160; eller&#160;  <strong><a %s>Registrer deg</a></strong>',
        'SIGN_IN_TO_APPNAME' => 'Logg deg på %s',
        'WHAT_IS_A_NING_ID' => 'Hva er en Ning-ID?',
        'LARR_BACK' => '← <a %s>Tilbake</a>',
        'NING_ID_LETS_YOU_CHOOSE' => 'Ning-ID godkjenningssystemet lar deg velge e-postadresse og passord én gang og bruke det til å bli med eller logge deg på et sosialt nettverk som bruker Ning-ID.',
        'WHEN_YOU_CREATE_NING_ID' => 'Når du oppretter en Ning-ID kan du også legge til et sett med grunnleggende detaljer og bilde til Ning-ID kontoen din.  Disse detaljene vil automatisk legges inn når du blir med i et nytt sosialt nettverk som bruker Ning-ID for godkjenning.  Den lar deg også holde rede på vennene dine og på meldinger som sendes i de nettverkene som bruker Ning-ID.',
        'SIGN_IN_WITH_NING_ID_WHENEVER' => 'Du kan logge deg inn med din Ning-ID, e-postadresse og passord når du ser dette symbolet: %s',
        'HELLO_USER' => 'Hei %s',
        'TEXT_FOR_HEADER_TAB' => 'Denne teksten tilhører en overskriftskategori',
        'BASED_ON' => 'Basert på',
        'ARE_YOU_SURE_DELETE_LANGUAGE' => 'Er du sikker på at du vil slette dette språket?',
        'DELETE_LANGUAGE' => 'Slett språk',
        'TEXT_RESET_TO_ORIGINAL_VERSION' => 'Teksten har blitt tilbakestilt til originalversjonen.',
        'UPLOAD_LANGUAGE_FILE' => 'Last opp språkfil',
        'ADD_TO_LANGUAGE' => 'Legg til språk:',
        'IF_YOU_CREATED_TRANSLATION' => 'Hvis du har opprettet en ny oversettelse i et annet Ning sosialt nettverk kan du importere arbeidet ditt her.  Innholdet i denne filen vil legges til det språket du har valgt.  Finner du ikke språket ditt på listen?  <a %s>Det er enkelt å legge til et nytt et</a>.',
        'EXAMPLES_SWEDISH_FINLAND' => 'Eksempler: Svensk (Finnland), filippinsk, spansk (Puerto Rico)',
        'START_FROM_SCRATCH_CREATE' => 'Begynn helt forfra!  Opprett en ny oversettelse for ditt nettverk ved å legge inn et navn for det nye språket og deretter velge et eksisterende språk som referansepunkt.',
        'KEY_MISSING_TEXT' => 'Nøkkel: <span %s>Manglende tekst</span> <span %s>Endret tekst</span>',
        'SHOW_ALL_TEXT' => 'Vis all tekst',
        'SHOW_MISSING_TEXT' => 'Vis manglende tekst',
        'SHOW_CHANGED_TEXT' => 'Vis endret tekst',
        'EXAMPLES_TABS_MEMBERS_FRIENDS' => 'Eksempler: Kategorier, medlemmer, venner',
        'RESET_TEXT_TO_ORIGINAL_VERSION' => 'Tilbakestill til originalversjonen',
        'ORIGINAL_TEXT_X' => 'Original Text - %s',
        'EDIT_LANGUAGE_ON_NETWORK' => 'Rediger språket for nettverket ditt',
        'CUSTOMIZE_TEXT_ON_NETWORK_INCLUDING' => 'Tilpass tekst på nettverket ditt, inkludert kategorinavn, e-postbunntekst, feilmeldinger og mer.',
        'ACTIVE_LANGUAGE_IS_X' => '<em>Aktivt språk for ditt nettverk er %1$s</em>.  <a %2$s>Endre aktivt språk</a>',
        'CURRENT_LANGUAGE_OPTIONS' => 'Gjeldende språkalternativ',
        'ACTIVE' => 'Aktiv',
        'MY_LANGUAGES' => 'Mine språk',
        'CREATE_NEW_TRANSLATION' => 'Opprett en ny oversettelse',
        'DONT_SEE_LANGUAGE_LISTED_CREATE' => 'Finner du ikke språket ditt på listen ovenfor?  <strong><a %s>Opprett en ny oversettelse for nettverket ditt</a></strong>.',
        'ADVANCED_IMPORT' => 'Avansert importering',
        'IF_YOU_TRANSLATED_A_LANGUAGE' => 'Hvis du har oversatt fra et språk på et eksisterende sosialt nettverk kan du <strong><a %s>importere språkfilen din</a></strong> og bruke det på dette nettverket.',
        'LANGUAGE_EDITOR' => 'Språkredigeringsprogram',
        'PUBLIC' => 'Offentlig',
        'GRANDFATHERED_PRIVACY_SETTING' => 'Din gjeldende innstilling for personvern, et offentlig nettverk der ikke-medlemmer bare kan vise påloggingssiden, er ikke lenger tilgjengelig.   Innstillingen for personvern er ikke endret, men hvis du foretar endringer her, kan du ikke gå tilbake igjen.   Gjeldende ekvivalent er et privat nettverk der hvem som helst kan registrere seg og bli medlem.',
        'NO_MISSING_ITEMS' => 'Det er ingen elementer som mangler - denne oversettelsen er 100%% fullført.  <a %s>Vis alle elementer. </a>',
        'NO_CHANGED_ITEMS' => 'Ingen endrede elementer.',
        'COULD_NOT_FIND_ITEMS_MATCHING' => 'Beklager - vi finner ingen elementer som samsvarer med <em>%s</em>.  <a %s>Vis alle elementer. </a>',
        'FILE_N' => '%s-fil',
        'TRANSLATION_FILE_HAS_FILENAME_LIKE' => 'En Ning-oversettingsfil har et filnavn som <code>en_US. txt</code>.  <a %s>Finn mer informasjon her. </a>',
        'SELECT_TRANSLATION_FILE' => 'Velg oversettingsfil:',
        'USE_THIS_TRANSLATION' => 'Bruk denne oversettelsen',
        'FOLLOWING_ARE_MISSING_FROM_RULES' => 'Vær oppmerksom på at følgende mangler fra reglene nedenfor: %s',
        'ALL' => 'Alle',
        'MISSING' => 'Mangler',
        'VIEW' => 'Visning',
        'TRANSLATION_CHANGES_SAVED' => 'Endringene dine er lagret.  Denne oversettelsen er %s%% fullført.',
        'TRANSLATION_CHANGES_SAVED_MAKE_CURRENT' => 'Endringene dine er lagret.  Denne oversettelsen er %s%% fullført.  Vil du bruke dette som gjeldende språk for nettverket?',
        'TRANSLATION_UPLOAD_SUCCESSFUL' => 'Opplastingen er fullført.  Denne oversettelsen er %s%% fullført.',
        'TRANSLATION_UPLOAD_SUCCESSFUL_MAKE_CURRENT' => 'Opplastingen er fullført.  Denne oversettelsen er %s%% fullført.  Vil du bruke dette som gjeldende språk for nettverket?',
        'X_IS_CURRENT_LANGUAGE' => '%s er nå språket for nettverket ditt.',
        'SAVE_PAGE' => 'Lagre side',
        'LANGUAGE_NAME_TAKEN' => 'Vi beklager – dette navnet er allerede i bruk.  Vennligst velg et annet navn.',
        'ENTER_NAME_FOR_TRANSLATION' => 'Vennligst skriv inn et navn på den nye oversettelsen, for eksempel portugisisk (Portugal)',
        'CREATE' => 'Opprett',
        'LANGUAGE_NAME' => 'Språknavn',
        'SAVE_ITEMS_ON_PAGE' => 'Lagre elementene på denne siden',
        'NEW_TRANSLATION' => 'Ny oversettelse',
        'MISMATCHED_CURLY_BRACKETS' => 'Ikke-samsvarende klammeparenteser',
        'MISMATCHED_SQUARE_BRACKETS' => 'Ikke-samsvarende hakeparenteser',
        'MISMATCHED_PARENTHESES' => 'Ikke-samsvarende parenteser',
        'ERROR_PROCESSING_SPECIAL_RULES' => 'Det oppstod en feil ved behandling av koden for spesialregler.',
        'ERROR_PROCESSING_TAB_NAMES' => 'Det oppstod en feil ved behandling av koden for kategorinavn.',
        'SPECIAL_RULES' => 'Spesialregler',
        'TAB_NAMES' => 'Kategorinavn',
        'SOURCE' => 'Kilde',
        'LANGUAGE_EDITOR_X' => 'Språkredigeringsprogram: %s',
        'BACK_TO_LANGUAGE_EDITOR' => '← Tilbake til språkredigeringsprogram',
        'CUSTOMIZE_YOUR_NETWORKS_TEXT' => 'Tilpass nettverkets tekst og meldinger, eller opprett et nytt språk.',
        'STOPWORDS' => 'en | om | en | er | som | på | være | ved | com | de | en | for | fra | hvordan | i | i | er | det | la | av | på | eller | det | den | dette | til | var | hva | når | hvor | hvem | vil | med | und | det | www',
        'STOPWORDS_ARE' => '<a %s>Stoppeord</a> er en valgfri liste med ord som skal filtreres ut av nettverksbeskrivelsen når metakoden opprettes øverst på hver side.  Valgfri.',
        'I_AM_MEMBER' => 'Jeg er medlem av:',
        'VIEW_PAGE_ON_APPNAME' => 'Vis min side på <em>%s</em>',
        'VISIT_APPNAME' => 'Gå til <em>%s</em>',
        'JOIN_US' => 'Bli med hos oss',
        'CREATED_BY_COLON' => 'Opprettet av:',
        'GET_MORE_BADGES' => 'Få flere skilt',
        'SHOW_LOGO' => 'Vis logo',
        'GALLERY' => 'Galleri',
        'BADGES' => 'Skilt',
        'MEMBER_BADGE' => 'Medlemsskilt',
        'WEAR_IT_WITH_PRIDE' => 'Bær det med stolthet!  Skaff et %s-medlemsskilt som du kan vise på web- eller MySpace-siden din.',
        'NETWORK_BADGE_LARGE' => 'Nettverksskilt (stort)',
        'SPREAD_THE_WORD_NETWORK_BADGE_LARGE' => 'Fortell det videre!  Skaff et %s-skilt som oppdateres dynamisk med nettverkets mest populære medlemmer.  Legg det inn på nettsidenettsiden eller  MySpace-siden din.',
        'NETWORK_BADGE_SMALL' => 'Nettverksskilt (lite)',
        'SPREAD_THE_WORD_NETWORK_BADGE_SMALL' => 'Fortell det videre!  Skaff et %s-medlemsmerke som du kan vise på nettsiden eller MySpace-siden din.',
        'PHOTO_SLIDESHOW_PROPER' => 'Lysbildeshow',
        'DISPLAY_SELECTION_OF_PHOTOS' => 'Vis et utvalg av bildene dine på en nettside eller MySpace-side med den stilige lysbildefremviseren vår.',
        'MUSIC_PLAYER' => 'Musikkspiller',
        'PLAY_MUSIC_ON_WEBSITE' => 'Spill musikken din på en nettside eller en MySpace-side med den stilige musikkspilleren.',
        'ADD_A_VIDEO_MORE_OPTIONS' => 'Legg til en video på nettsiden eller MySpace-siden din.  Ser du etter flere alternativer?  <a href="%s">Vis alle videoer</a> på %s.',
        'LARGE_N_PIXELS_WIDE' => 'Stor - %d piksler bred',
        'MEDIUM_N_PIXELS_WIDE' => 'Middels - %d piksler bred',
        'SMALL_N_PIXELS_WIDE' => 'Liten - %d piksler bred',
        'MY_MOST_RECENT' => 'Mine nyeste',
        'APP_ICON' => 'Programikon',
        'MEMBERSHIP_TO_X_IS_BY_INVITATION' => 'Medlemskap i %s oppnås bare gjennom invitasjon',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK' => '%s gav følgende tilbakemelding:',
        'X_PROVIDED_FEEDBACK_ON_Y_ELLIPSIS' => '%1$s gav tilbakemelding om %2$s...',
        'THANK_YOU_YOUR_MESSAGE_HAS_BEEN_SENT' => 'Tusen takk.   Meldingen er sendt.',
        'X_WOULD_LIKE_TO_JOIN_X' => '%s vil gjerne bli med i %s!',
        'X_HAS_REQUESTED_AN_INVITATION' => '%s har bedt om en invitasjon til %s',
        'YOUR_REQUEST_HAS_BEEN_SENT' => 'Forespørselen er sendt til nettverksoppretteren.',
        'TO_UNBAN_USERNAME_GO_TO' => '%s kan legitimeres ved å gå til:',
        'SEND_REQUEST' => 'Send forespørsel',
        'SEARCH' => 'Søk',
        'SEARCH_AGAIN' => 'Søk på nytt',
        'SEND_BROADCAST_MESSAGE' => 'Send kringkastingsmelding',
        'VERIFICATION_IMAGE' => 'Bekreftelsesbilde',
        'UNDER_CONSTRUCTION' => 'Under utarbeidelse',
        'PROFILE_INFORMATION_SAVED' => 'Profilinformasjon er lagret',
        'YOUR_SITES_DIRECTORY_PROFILE' => 'Informasjonen for din profil i nettverkskatalogen er lagret.',
        'NO_ACCOUNT_WITH_EMAIL' => 'Det finnes ingen konto med denne e-postadressen.',
        'INVALID_PASSWORD_CHECK_CAPS_LOCK' => 'Feil passord.   Er Caps Lock på?',
        'OOPS_THAT' => 'Uff da - det virket ikke.',
        'OOPS_THAT_DID_NOT_WORK' => 'Uff da - det virket ikke.   Vil du prøve på nytt?',
        'OOPS_THAT_DID_NOT_WORK_ERROR_CODE' => 'Uff da -dette virket ikke (%s).',
        'NOT_FOUND' => 'Finnes ikke',
        'YOUR_SITES_FEATURE_LIST' => 'Nettverkets liste over funksjoner er lagret.',
        'ONE_LINE_ANSWER' => 'Svar på én linje',
        'LONGER_ANSWER' => 'Lengre svar',
        'MULTIPLE_CHOICE' => 'Flervalg',
        'DATE' => 'Dato',
        'WEBSITE_ADDRESS' => 'Nettadresse',
        'EVERYTHING' => 'Alt',
        'JUST_THE_HOMEPAGE' => 'Bare hovedsiden',
        'JUST_THE_SIGN_UP_PAGE' => 'Bare registreringssiden',
        'YOUR_CHANGES_HAVE_BEEN_SAVED' => 'Endringene dine er lagret.',
        'JOIN_ME_ON_X' => 'Bli med meg på %s!',
        'NOT_ALLOWED' => 'Ikke tillatt',
        'COME_JOIN_ME_ON_X' => 'Kom å bli med meg på %s.',
        'COME_JOIN_ME_ON_X_ELLIPSIS' => 'Kom og bli med meg på %s ...',
        'X_NOT_VALID_EMAIL' => '%s er ikke en gyldig e-postadresse eller Ning-ID',
        'USER_BANNED_FROM_NETWORK' => '%1$s er utestengt fra dette nettverket.  <a %2$s>Send en melding til %1$s</a>',
        'USER_ALREADY_NETWORK_MEMBER' => '%1$s er allerede med i dette nettverket.  <a %2$s>Send en melding til %1$s</a>',
        'YOU_CAN_SEND_AT_MOST_X' => 'Du kan sende opptil %s samtidig.',
        'PLEASE_ENTER_YOUR_FRIENDS' => 'Legg inn dine venners e-postadresser eller Ning-ID-er',
        'THERE_HAS_BEEN_AN_ERROR' => 'Det har oppstått en feil',
        'INVITATIONS_HAVE_BEEN_SENT' => 'Invitasjonene er sendt.',
        'SEARCH_RESULTS' => 'Søkeresultater',
        'INVITE_YOUR_FRIENDS' => 'Inviter vennene dine',
        'SEND_INVITATIONS_FOR_FRIENDS' => 'Send ut invitasjoner, slik at vennene dine kan bli med',
        'INVITATION' => 'Invitasjon',
        'ADD_FROM_ADDRESS' => 'Legg til fra adressebok',
        'TO' => 'Til:',
        'SEND_TO' => 'Send til',
        'SUBJECT' => 'Emne',
        'YOUR_MESSAGE' => 'Din melding',
        'SEND' => 'Send',
        'REPORT_AN_ISSUE' => 'Melde om et problem  ',
        'TYPE_OF_ISSUE' => 'Type problem',
        'ADULT' => 'Voksen',
        'ABUSIVE' => 'Fornærmende',
        'BUG' => 'Feil',
        'FRAUD' => 'Bedrageri',
        'SPAM' => ' Søppel  ',
        'OTHER' => 'Annet',
        'DESCRIBE_YOUR_ISSUE' => 'Beskriv problemet',
        'SEND_REPORT' => 'Send rapport',
        'ADDED_BY_X_AT_X' => 'Lagt til av <a %s>%s</a> kl. %s den %s',
        'ADDED_BY_USER_TO_GROUP_AT_DATE' => 'Lagt til av <a %s>%s</a> i %s kl. %s den %s',
        'G_IA' => 'g:ia',
        'F_JS_Y' => 'F jS, Y',
        'CLICK_TO_VIEW' => 'Klikk for å vise',
        'COMMENT_FOR' => 'Kommentar for:',
        'COMMENT_ON' => 'Kommentar om:',
        'ACTION_BUTTON_FEATURE' => 'Funksjon',
        'FEATURE_THIS_ON_YOUR' => 'Fremhev dette på hovedsiden',
        'ACTION_BUTTON_REMOVE' => 'Fjern',
        'REMOVE' => 'Fjern',
        'REMOVE_THIS_FROM_YOUR' => 'Fjern dette fra hovedsiden',
        'FEATURE_ON_HOME' => 'Fremhev på hovedside',
        'REMOVE_FROM_HOME' => 'Fjern fra hovedside',
        'ITEM_WILL_APPEAR' => 'Elementet vil nå vises på merkede moduler på hovedsiden',
        'ITEM_WILL_NO_LONGER_APPEAR' => 'Elementet vil ikke lenger vises på merkede moduler på hovedsiden',
        'ADD_CONTENT' => 'Legg til innhold',
        'BROUGHT_TO_YOU_BY' => '%s presenteres av %s © %s',
        'GIVE_US_YOUR_FEEDBACK' => 'Gi oss tilbakemelding',
        'FOR_ADDITIONAL_QUESTIONS_OR_TO_CONTACT_NING_PLEASE_CLICK_HERE' => 'Klikk her for ytterligere spørsmål, eller for å kontakte Ning:',
        'SEND_FEEDBACK' => 'Send tilbakemelding',
        'SIGN_OUT' => ' logg ut  ',
        'SIGN_OUT_TITLE' => 'Logg ut',
        'EDIT_MY_PROFILE' => 'Rediger profilsvar',
        'INVITE_MORE' => 'Inviter flere',
        'USE_THIS_FORM_TO_SEND_FEEDBACK_TO_NC' => 'Bruk denne formen for å sende tilbakemelding til <a %s>%s</a> som er oppretteren av <a %s>%s</a>.',
        'YOUR_FEEDBACK' => 'Din tilbakemelding',
        'NETWORK_INFORMATION' => 'Nettverksinformasjon',
        'ABOUT_YOUR_SITE' => 'Om nettverket ditt',
        'WELCOME_TO_YOUR_SITE' => 'Velkommen til det sosiale nettverket ditt!',
        'EDIT_YOUR_NETWORKS_INFO' => 'Rediger nettverkets navn, beskrivelse og annen informasjon.',
        'TAGLINE' => 'Slagord',
        'APPEARS_IN_HEADER' => 'Vises i overskriften til nettverket',
        'APPEARS_IN_EMAILS' => 'Vises i e-post og på andre steder',
        'NETWORK_NAME' => 'Nettverksnavn',
        'DESCRIPTION' => 'Beskrivelse',
        'KEYWORDS' => 'Nøkkelord',
        'LANGUAGE' => 'Språk',
        'SEPARATE_EACH_KEYWORD' => 'Skill nøkkelord med komma',
        'ICON' => 'Ikon',
        'UPLOAD_A_PHOTO_WHICH_WILL_BE_RESIZED' => 'Last opp et bilde (GIF, JPG eller PNG). Størrelsen blir endret til et kvadrat.  Det kan ta noen minutter før bildet vises.',
        'SAVE_SETTINGS' => 'Lagre innstillinger',
        'SUCCESS_EXCLAMATION' => 'Det gikk bra!',
        'FEATURES' => 'Funksjoner',
        'ADD_FEATURES' => 'Legg til funksjoner i nettverket',
        'ORGANIZE_FEATURES' => 'Organiser hovedsiden ved trekke inn funksjoner fra listen nedenfor, og deretter plassere dem hvordan du vil.',
        'SKIP_FEATURES' => 'Klikk <a href="%s">Hopp over dette trinnet</a> for å fortsette med standardoppsettene og -funksjonene.',
        'FEATURES_FOR_ALL_PAGES' => 'Funksjoner som legges til i dette vinduet, vil vises på alle sidene i nettverket.',
        'CUSTOMIZE_SITE_BY_ADDING' => 'Tilpass ditt sosiale nettverk ved å legge til nye funksjoner eller fjerne de som finnes.',
        'ADJUST_YOUR_SITES_COLORS' => 'Juster nettverkets farger, bilder og generelle stil.',
        'APPEARANCE' => 'Utseende',
        'PROFILE_QUESTIONS' => 'Profilspørsmål',
        'EDIT_QUESTIONS_THAT_MEMBERS_ANSWER' => 'Rediger spørsmålene som medlemmer svarer på om seg selv.',
        'MESSAGE_SENT' => 'Meldingen er sendt!',
        'YOUR_MESSAGE_HAS_BEEN_SENT' => 'Meldingen er sendt til alle medlemmene av nettverket.',
        'YOUR_MESSAGE_HAS_BEEN_SENT_GROUP' => 'Meldingen er sendt til alle medlemmene i gruppen.',
        'YOUR_MESSAGE_IS_BEING_SENT' => 'Meldingen sendes.  Vent litt, fordi det kan ta et par minutter.',
        'BROADCAST_MESSAGE' => ' Kringkast melding  ',
        'TRACK_VISITORS_AND_TRENDS' => 'Spor besøkende og trender i det sosiale nettverket.',
        'EDIT_SOURCE_CODE' => 'Rediger kildekode',
        'TAKE_FULL_CONTROL' => 'Ta full kontroll over nettverkets funksjonalitet ved å redigere kildekoden.',
        'DELETE_THIS_SITE' => 'Slett det sosiale nettverket',
        'MAIN_PAGE' => 'Hovedside',
        'MAIN' => 'Hovedside',
        'MAIN_TAB_TEXT' => 'Hovedside',
        'MANAGE' => 'Administrer',
        'MANAGE_TAB_TEXT' => 'Administrer',
        'PAGE_TITLE' => 'Sidetittel',
        'LOREM_IPSUM_1' => 'Lorem <span %s>ipsum dolor</span> sit amet, consectetuer adipiscing elit.  Nunc scelerisque blandit dolor.  Vestibulum ante ipsum primis in faucibus orci luctus.',
        'LOREM_IPSUM_2' => 'Lorem ipsum dolor sit amet, consectetuer adipiscing',
        'LOREM_IPSUM_3' => 'Lorem ipsum dolor sit amet, <span class="preview_link">consectetuer</span> adipiscing',
        'EDIT_THE_APPEARANCE' => 'Rediger sidens utseende',
        'CHOOSE_A_THEME' => 'Velg et tema for det sosiale nettverket',
        'NOW_CUSTOMIZE_SITE' => 'Tilpass det sosiale nettverket ...',
        'THEME_SETTINGS' => 'Temainnstillinger',
        'ADVANCED' => 'Avansert',
        'TOP_BAR_AND_FOOTER' => 'Toppfelt og bunntekst',
        'HEADER_AND_NAVIGATION' => 'Overskrift og navigering',
        'ADD_A_LOGO' => 'Legg til en logo',
        'THIS_IMAGE_WILL_REPLACE' => 'Dette bildet vil erstatte teksten for nettverksnavn',
        'TABS' => 'Kategorier',
        'TAB' => 'Kategori',
        'SITE' => 'Nettverk',
        'SIDES' => 'Sider',
        'BODY' => 'Brødtekst',
        'SHOW_NING_LOGO' => 'Vil du vise Ning-logoen?',
        'LAUNCH' => 'START OPP!',
        'NING_ID' => 'Ning-ID',
        'PASSWORD' => 'Passord',
        'RETYPE_PASSWORD' => 'Skriv passordet på nytt',
        'TYPE_CODE_ON_RIGHT' => 'Skriv koden<br />på høyre side',
        'JOIN_X' => 'Bli med i %s.',
        'SIGN_UP_FOR_X' => 'Registrer deg for %s',
        'HAS_INVITED_YOU_TO_X' => 'har invitert deg til å bli med i %s.',
        'CONTENT_AWAITING_APPROVAL' => 'Venter på godkjenning',
        'NEW_MEMBER' => 'Nytt medlem?',
        'JOIN_X_NOW' => 'Bli med i %s nå!',
        'HIDE_THIS_MESSAGE' => 'Skjul denne meldingen',
        'PAGE_NOT_FOUND' => 'Finner ikke side',
        'THIS_PAGE_WAS_NOT_FOUND' => 'Beklager -finner ikke denne siden',
        'FOLLOW_THESE_LINKS_TO' => 'Følg disse koblingene til noen ting vi vet er tilgjengelige:',
        'ALTERNATIVELY_YOU_CAN_SEARCH' => 'Du kan eventuelt søke i følgende sosiale nettverk:',
        'IF_YOU_GET_THIS_MESSAGE' => 'Hvis du mottar denne meldingen på nytt, <a %s>bes du vennligst si fra. </a>',
        'GROUP_MEMBERS' => 'Gruppemedlemmer',
        'VIDEOS' => 'Videoer',
        'BLOG' => 'Blogg',
        'ACCOUNT' => 'Konto',
        'WE_ARE_SORRY_WE_ARE_HAVING' => 'Beklager, vi har et problem med denne siden.',
        'FOLLOW_LINK_TO_HOMEPAGE' => 'Følg <a %s>denne lenken</a> til hovedsiden.',
        'REQUEST_AN_INVITATION' => 'Be om invitasjon',
        'NAME' => 'Navn',
        'EMAIL_ADDRESS' => 'E-postadresse',
        'MESSAGE_OPTIONAL' => 'Melding (valgfritt)',
        'SORRY_HOWEVER_ITS_EASY' => '<strong>Beklager! </strong> Det er imidlertid enkelt å starte ditt eget sosiale nettverk.',
        'GET_YOUR_OWN_BAZEL' => 'Opprett ditt eget sosiale nettverk!',
        'SITE_IS_NOT_READY' => 'Dette sosiale nettverket er ikke klart ennå!',
        'BAZEL_IS_BEING_SET_UP' => 'Dette sosiale nettverket er fremdeles under utarbeiding!',
        'SIGN_IN' => 'Logg på',
        'FORGOT_YOUR_PASSWORD' => 'Har du glemt passordet?',
        'FORGOT_YOUR_PASSWORD_TITLE' => 'Har du glemt passordet?',
        'ENTER_EMAIL_AND_CLICK_RESET_PASSWORD' => 'Skriv inn e-postadressen og klikk \'Tilbakestill passord\'.  Du vil få en e-post med en lenke for å tilbakestille passordet.',
        'RESET_PASSWORD' => 'Tilbakestill passord',
        'EXPLORE' => 'Utforsk',
        'SIGN_UP' => 'Registrer deg',
        'CONFIRM_PASSWORD' => 'Bekreft passord',
        'VERIFICATION' => 'Fortell oss at du er en <br />person',
        'YOUR_PHOTO' => 'Bilde av deg',
        'SUMMARY' => 'Sammendrag',
        'YOUR_SITE_IS_READY' => 'Det sosiale nettverket er klart til å startes!   Standardinnstillinger blir brukt på alle trinnene du hoppet over.  Gå tilbake for å gjøre endringer, eller klikk \'Start! \' for å starte nettverket.',
        'WHEN_YOU_ARE_FINISHED' => 'Klikk \'Vis oppsett\' for å se verket ditt når det er ferdig!',
        'COMPLETE' => 'fullstendig',
        'INCOMPLETE' => 'ufullstendig',
        'VIEW_LAYOUT' => 'Vis oppsett',
        'CLEAR_CONTENTS' => 'Slett innhold',
        'ADD_MODULE' => 'Legg til modul...',
        'ADD_COLUMNS' => 'Legg til kolonner...',
        'PUBLIC_ANYBODY_CAN_JOIN' => '<strong>Offentlig</strong> -Hvem som helst kan bli med',
        'PRIVATE_ONLY_INVITED' => '<strong>Privat</strong> -Bare de som er invitert, kan bli med',
        'INVITATIONS' => 'Invitasjoner',
        'MEMBERS_CAN_INVITE' => 'Medlemmer kan invitere andre til å bli med.',
        'QUESTION_TITLE' => 'Spørsmålstittel',
        'ANSWER_TYPE' => 'Svartype',
        'REQUIRED' => 'Obligatorisk',
        'PRIVATE' => 'Privat',
        'CHOICES' => 'Valg',
        'SEPARATE_EACH_CHOICE' => 'Adskill valgene med komma',
        'CAN_PICK_MORE' => 'Kan velge flere enn ett',
        'ADD_ANOTHER_QUESTION' => 'Legg til et spørsmål til',
        'WHAT_INFORMATION' => 'Hvilke spørsmål vil du at medlemmene skal svare på når de blir med i nettverket?  Du kan endre rekkefølgen på spørsmålene nedenfor.  Det er bare å klikke spørsmålet og dra det dit du vil at det skal vises.',
        'IF_YOU_SELECT_REQUIRED_MEMBERS_WILL' => 'Hvis du merket “Obligatorisk”, må medlemmene svare på spørsmålet for å bli med.  Velger du “Privat”, er det bare du og andre administratorer som kan se svaret.',
        'WE_COULD_NOT_FIND_ANYTHING' => 'Finner ikke noe som samsvarer med "%s".  Hvorfor ikke søke etter noe annet?',
        'GET_CUSTOM_URL' => 'Få din egen tilpassede URL-adresse, få mer lagerplass og båndbredde eller kjør dine egne reklamer.',
        'VIEW_STATISTICS' => 'Vis statistikk',
        'ADD_TRACKING_CODE' => '<a %s>Legg til egen sporingskode</a>.',
        'TRACKING_CODE' => 'Sporingskode',
        'ANY_JAVASCRIPT_CODE' => 'Alle JavaScript-koder du limer inn her, blir satt inn nederst på hver side i nettverket.  Du kan bruke dette til eksterne sporingssystemer for nettsider, for eksempel Google Analytics.',
        'ANALYTICS_LEARN_MORE' => '<a %s>Klikk her</a> hvis du vil vite mer om Google Analytics og sette opp din egen konto.',
        'RESOURCES' => 'Ressurser',
        'LINKS' => 'Lenker',
        'PAGE' => 'Side',
        'BACKGROUND' => 'Bakgrunn',
        'TEXT' => 'Tekst',
        'HEADING_TEXT' => 'Overskrifttekst',
        'FONT' => 'Skrifttype',
        'AABBCC' => 'AaBbCc',
        'COLOR' => 'Farge',
        'LINK_COLOR' => 'Farge på lenke',
        'BODY_TEXT' => 'Brødtekst',
        'MIDDLE' => 'Midten',
        'FEATURE_BOXES' => 'Funksjonsvinduer',
        'TITLEBAR_TEXT_COLOR' => 'Tittellinjens tekstfarge',
        'TITLEBAR_BACKGROUND' => 'Tittellinjens bakgrunn',
        'UPLOADING_CONTENT' => 'Laster opp innhold ...',
        'WHEN_UPLOADING_IS_COMPLETE' => 'Når opplastingen er fullført, kan du sjekke ut  nettverket.',
        'FINISH' => 'Fullfør',
        'FLICKR_IMPORT_SETUP' => 'Flickr-importoppsett',
        'FLICKR_API_KEY' => 'Din nøkkel',
        'FLICKR_SECRET' => 'Din hemmelighet',
        'FLICKR_KEY_ERROR' => 'Det er problemer med Flickr-nøkkelen eller hemmeligheten du skrev inn.   Kan du kontrollere dem og prøve å skrive dem inn på nytt?',
        'FLICKR_INTRO' => 'Vil du at medlemmene skal kunne importere bilder fra Flickr?  Du har kommet til riktig sted.  Hvis du allerede har en Flickr API-nøkkel og -hemmelighet, kan du <a %s>hoppe videre</a>.  Er du ikke sikker på hva det betyr?  Det er bare å følge trinnene nedenfor, så er du i gang om bare noen få minutter.',
        'FLICKR_GET_ACCOUNT' => 'Hvis du ikke har en Flickr-konto allerede, kan du få en <a %s>her</a>.',
        'FLICKR_STEP1_TITLE' => 'Trinn 1: Skaff en Flickr API-nøkkel',
        'FLICKR_STEP1_APPLY_SCREEN' => 'Søk om siden for API-nøkkel på Flickr',
        'FLICKR_STEP1_API_SCREEN' => 'Siden for API-nøkkel på Flickr',
        'FLICKR_STEP1_INTRO' => 'Logg på Flickr og <a %s>søk om en ny API-nøkkel</a> (åpnes i et nytt vindu).',
        'FLICKR_STEP1_A' => 'Fyll ut <strong>navn</strong> og <strong>e-postadresse</strong>.',
        'FLICKR_STEP1_B' => 'Under <strong>Denne nøkkelen er for&hellip; </strong> velg alternativet <em>ikke-kommersiell bruk</em>.',
        'FLICKR_STEP1_C' => 'Beskriv det sosiale nettverket i vinduet <strong>Beskriv programmet du planlegger å bygge</strong>.',
        'FLICKR_STEP1_D' => 'Merk av i begge godkjennelsesvinduene.',
        'FLICKR_STEP1_APPLY' => 'Når du er ferdig, klikker du <strong>Bruk</strong>-knappen.',
        'FLICKR_STEP1_E' => 'Du vil lande på en side som viser den nye API-nøkkelen.  Klikk lenken <strong>Klikk her</strong> for å konfigurere brukergodkjenning for denne nøkkelen.',
        'FLICKR_STEP2_TITLE' => 'Trinn 2: Konfigurer nøkkelen',
        'FLICKR_STEP2_SETUP_SCREEN' => 'Oppsettsiden for godkjenning av API-nøkkel på Flickr',
        'FLICKR_STEP2_F' => 'Lim inn følgende nettadresse i feltet <strong>“Callback” URL-adresse</strong>',
        'FLICKR_STEP2_SAVE_CHANGES' => 'Når du er ferdig, klikker du <strong>Lagre endringer</strong>.',
        'FLICKR_STEP3_TITLE' => 'Trinn 3: Skriv inn din informasjon',
        'FLICKR_STEP3_KEYS_SCREEN' => 'Informasjonssiden for API-nøkkel på Flickr',
        'FLICKR_STEP3_CONGRATULATIONS' => 'Gratulerer!  Du er nå satt opp på Flickr.',
        'FLICKR_STEP3_COMPLETE' => 'Fullfør installasjonen på %s ved å kopiere og lime inn nøkkelen og hemmeligheten i følgende felt:',
        'COMPLETE_SETUP' => 'Fullfør installasjon',
        'SETUP_YOUR_SITE_TO' => 'Sett opp det sosiale nettverket for å importere bilder fra Flickr.',
        'FLICKR_IMPORTING' => 'Flickr-importerer',
        'YOU_NEED_TO_SET_UP_FLICKR' => 'Du må sette opp det sosiale nettverket ditt, slik at folk kan importere bilder fra Flickr.  Det tar bare noen få minutter, så hvorfor ikke <a %s>sette det opp nå? </a>',
        'DONT_SHOW_THIS_AGAIN_FLICKR' => 'Vis ikke dette igjen.',
        'YOUVE_SIGNED_OUT_OF_X' => 'Du er logget av %s.  Kom tilbake til oss igjen snart!',
        'CREATED_THIS_SOCIAL_NETWORK' => 'opprettet dette sosiale nettverket på <a href=\'http://www.ning.com\'>Ning</a>.',
        'CREATE_YOUR_OWN' => 'Opprett ditt eget sosiale nettverk på Ning helt gratis!',
        'DRAG_HERE_TO_REMOVE_FEATURE' => 'Dra her for å fjerne funksjon',
        'LAYOUT' => 'Oppsett',
        'DRAG' => 'Dra',
        'HERE' => 'Her',
        'YOU' => 'Du',
        'ADS' => 'Reklame',
        'MEMBERS' => 'Medlemmer',
        'HELLO_USERNAME' => 'Hei, brukernavn',
        'CREATED_BY' => 'Opprettet av',
        'SAVE_FEATURES' => 'Lagre funksjoner',
        'FORUM' => 'Forum',
        'CATEGORIES' => 'Kategorier',
        'FORUM_CATEGORIES' => 'Forumkategorier',
        'A_THREADED_DISCUSSION_FORUM' => 'Et trådet diskusjonsforum',
        'ALLOW_MEMBERS_TO_CREATE_GROUPS' => 'La medlemmene å opprette sine egne interessegrupper innenfor nettverket ditt',
        'FEATURE_POSTS_FROM_YOUR_BLOG' => 'Vis innlegg fra bloggen din eller bloggene til andre medlemmer',
        'TEXT_BOX' => 'Tekstboks',
        'PUT_ANY_TEXT_WIDGET_OR_HTML' => 'Legg inn hvilken som helst tekst, innretning eller HTML på hovedsiden.',
        'A_LIST_OF_MEMBERS' => 'En medlemsliste for det sosiale nettverket ditt',
        'ALLOW_USERS_PHOTOS' => 'La folk å laste opp og dele bilder',
        'ADD_FEEDS_FROM_ACROSS_THE_WEB' => 'Legg til stoff fra internettet',
        'INFORMATION_ABOUT_THE_USER' => 'Informasjon om personen som er logget på nå',
        'ALLOW_USERS_VIDEOS' => 'La folk å legge til og dele bilder',
        'SHOW_NETWORK_DESCRIPTION' => 'Vis nettverksbeskrivelsen din',
        'PROMOTE_NETWORK_WITH_BADGES' => 'Reklamer for nettverket ditt på hele Internett med tilpassede skilt og innretninger.',
        'MONETIZE_WITH_ADS' => 'Få inntekter på nettverket med reklame',
        'LET_MEMBERS_KNOW_WHO_CREATED_NETWORK' => 'La medlemmene få vite hvem som opprettet dette nettverket',
        'FOLLOW_LATEST_ACTIVITY' => 'Følg den siste medlemsaktiviteten på nettverket',
        'FAQ_FOR_NETWORK_CREATORS' => 'Vanlige spørsmål for nettverksopprettere',
        'ANSWERS_TO_FAQS' => 'Svar på vanlige spørsmål om tilpassing av det sosiale nettverket ditt.',
        'MEET_OTHER_LIKEMINDED' => 'Møt andre likesinnede nettverksopprettere, del ideer og få støtte fra Ning-teamet.',
        'CUSTOMIZE_THE_APPEARANCE_NETWORK' => 'Tilpass utseendet til det sosiale nettverket ved å legge til egne CSS-ark (Cascading Style Sheets) i feltet til venstre.  (<a href="%s">Hva er CSS? </a>)',
        'CUSTOMIZE_THE_APPEARANCE_PAGE' => 'Tilpass utseendet av siden ved å legge til egne CSS-ark (Cascading Style Sheets) i feltet til venstre.  (<a href="%s">Hva er CSS? </a>)',
        'CSS_ON_YOUR_SOCIAL_NETWORK' => 'CCS i det sosiale nettverket ditt',
        'CSS_ON_YOUR_PAGE' => 'CSS på din side',
        'ADDING_YOUR_OWN_CSS_NETWORK' => 'Ved å legge til egen CSS, får du full kontroll over skrifttyper, farger, linjeavstand og generell stil for nettverket ditt.',
        'ADDING_YOUR_OWN_CSS_PAGE' => 'Ved å legge til egen CSS på siden, får du full kontroll over skrifttyper, farger, linjeavstand og generell stil for siden.',
        'CSS_STYLES_WILL_OVERRIDE' => 'CSS-stilene du legger til her, vil overstyre eventuelle nåværende CSS-stiler du har valgt før.',
        'NEED_HELP_FIGURING_OUT_CSS' => 'Trenger du hjelp til å finne ut navnet på en bestemt CSS-klasse i nettverket?  Vi anbefaler "Inspect"-funksjonen (Inspiser) til det gratis tilleggsprogrammet <a href="%s">Firebug</a> (for Firefox-webleseren).',
        'WANT_TO_LEARN_MORE' => 'Vil du ha mer informasjon?  Sjekk ut delen <a href="%s">Advanced Customization</a> (Avansert tilpassing).',
        'APPLY_XS_THEME' => 'Bruk %ss tema',
        'X_ALREADY_REGISTERED_Y_TO_RESET' => 'Det er allerede registrert en Ning-ID med e-postadressen %s.  Logg på nedenfor med Ning-ID-en eller e-postadressen.  Hvis du har glemt passordet, <a href="%s">klikker du her for å tilbakestille passordet</a>.',
        'INVITED' => 'Invitert',
        'REQUESTED_INVITE' => 'Ba om invitasjon',
        'BAN_FROM_NETWORK' => 'Utesteng fra nettverk',
        'REMOVE_BAN' => 'Opphev utestengning',
        'CANCEL_INVITATION' => 'Avbryt invitasjon',
        'IGNORE' => 'Ignorer',
        'PROMOTE_TO_ADMINISTRATOR' => 'Forfrem til administrator',
        'DEMOTE_FROM_ADMINISTRATOR' => 'Degrader fra administrator',
        'STATUS' => 'Status',
        'DATE_JOINED' => 'Medlemsdato',
        'DATE_INVITED' => 'Invitasjonsdato',
        'DATE_REQUESTED' => 'Forespørselsdato',
        'DATE_APPLIED' => 'Søkedato',
        'NETWORK_CREATOR' => 'Nettverksoppretter',
        'NETWORK_ADMINISTRATOR' => 'Administrator',
        'ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Administratorer har lignende styringsnivå som nettverksoppretteren.',
        'DOWNLOAD_ALL_MEMBER_DATA' => 'Eksporter all medlemsdata (. CSV)',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Medlemsdata er eksportert. Klikk <a %s>denne lenken</a> for å lagre den til skrivebordet.',
        'CLICK_GO_TO_START_EXPORT' => 'Klikk Go (Start) for å starte eksporteringen.   Hvis du har mange medlemmer, kan prosessen ta flere minutter.',
        'MEMBER' => 'Medlem',
        'INVITED_BY_X' => 'Invitert av %s',
        'DONE' => 'Ferdig',
        'YOU_HAVE_BEEN_BANNED_FROM_APPNAME' => 'Du er blitt utstengt fra %s',
        'MESSAGE_TO_ADMINISTRATOR' => 'Meldingen til administratoren',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS_IF_YOU_THINK' => 'Beklager, %s, du får ikke tilgang til %s fordi du er utstengt. Hvis du tror du er utstengt ved en feiltakelse, kan du ta kontakt med administratoren.',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS' => 'Beklager, %s, du får ikke tilgang til %s fordi du er utstengt.',
        'SORRY_USERNAME' => 'Beklager, %s',
        'PENDING' => 'Venter',
        'ACCEPT' => 'Godta',
        'PENDING_APPROVAL' => 'Avventer godkjennelse',
        'ACCEPT_MEMBERSHIP' => 'Godta medlemskap',
        'DECLINE_MEMBERSHIP' => 'Avslå medlemskap',
        'NO_PAGE_YET' => 'Ingen side ennå',
        'YOUR_MEMBERSHIP_TO_X_IS_PENDING_APPROVAL' => 'Medlemskapet på %s avventer godkjennelse fra administratorene.',
        'MEMBERSHIP_PENDING_APPROVAL' => 'Påventer godkjenning av medlemskap',
        'YOUR_PROFILE_IS_PENDING_APPROVAL' => 'Profilen din avventer godkjennelse',
        'YOUR_PROFILE_DETAILS_MUST_BE_APPROVED_ON_X' => 'Opplysningene i profilen din må godkjennes av administratoren før du kan bli medlem i %s.  Du vil motta en e-post når profilen er godkjent.',
        'CONTINUE_ARROW' => 'Continue →',
        'LARR_BACK_TO_PENDING_MEMBERS' => '← Tilbake til avventende medlemmer',
        'X_IS_AWAITING_APPROVAL_TO_BECOME_MEMBER_OF_Y' => '%s avventer godkjennelse for å bli medlem i %s.',
        'VIEW_PAGE' => 'Vis side',
        'MESSAGE' => 'Melding',
        'SEND_MESSAGE' => 'Send melding',
        'MANAGE_FORUM_CATEGORIES' => 'Behandle forumkategorier',
        'START_DISCUSSIONS' => 'Start diskusjoner',
        'WELCOME_TO_YOUR_NEW_SOCIAL_NETWORK' => 'Velkommen til ditt nye sosiale nettverk',
        'NOW_ALL_YOU_NEED_TO_DO_IS_INVITE_YOUR_FRIENDS' => 'Alt du trenger å gjøre er å <a %s>invitere vennene dine</a>!',
        'CONTRIBUTE' => 'Bidra.',
        'CUSTOMIZE_APPEARANCE_BADGES' => '<strong>Tilpass. </strong> Juster <a %1$s>nettverkets utseende</a> og designe <a %2$s>skilt og innretninger</a>.',
        'CONTROL_MANAGE_PAGE' => '<strong>Kontroll. </strong>  <a %s>administrasjonssiden</a> er startsiden for en rekke konfigurasjonsalternativer.',
        'CREATE_GROUPS' => 'Opprett grupper',
        'INVITE_MORE_PEOPLE' => 'Inviter flere folk',
        'VIEW_THREAD' => 'Vis tråd',
        'COMMENT_THREAD' => 'Kommenter tråd',
        'COMMENT_BACK' => 'Gi kommentar tilbake',
        'HELLO_YOU_NEED_TO_ENABLE_JAVASCRIPT' => 'Hallo, du må aktivere JavaScript for å kunne bruke dette nettverket.',
        'PLEASE_CHECK_YOUR_BROWSER_SETTINGS' => 'Kontroller netttleserinnstillingene, eller ta kontakt med systemansvarlig.',
        'MANAGE_MEMBERS_ADMINS_INVITED' => 'Administrer medlemmer, administratorer, inviterte og utstengte personer.',
        'MANAGE_MEMBERS' => 'Administrer medlemmer',
        'MANAGE_INVITED_PEOPLE' => 'Administrer inviterte personer',
        'NETWORK_SETTINGS' => 'Nettverksinnstillinger',
        'PROMOTE_YOUR_NETWORK' => 'Reklamer for nettverket ditt',
        'NING_RESOURCES' => 'Ning-ressurser',
        'ADD_PREMIUM_SERVICES' => 'Legg til verdiøkende tjenester',
        'REQUEST_SOURCE_CODE' => 'Be om tilgang til kildekode',
        'REQUEST_A_COPY_OF_THE_SOURCE_CODE' => 'Utviklere: be om tilgang til kildekoden som kjører nettverket.',
        'JOIN_NETWORK_CREATORS' => 'Slutt deg til nettverksopprettere',
        'SEND_MESSAGE_TO_ALL_THIS' => 'Send en melding til alle medlemmene i nettverket.',
        'CREATE_ANOTHER_NETWORK' => 'Opprett et annet nettverk',
        'HAVE_ANOTHER_GREAT_IDEA' => 'Har du en annen glimrende idé for et sosialt nettverk?',
        'ALLOW_FACEBOOK_USERS_TO' => 'Tillat Facebook-brukere å sette innretningene for ditt nettverk på sine profilsider.',
        'BADGES_AND_WIDGETS' => 'Merker og innretninger',
        'CUSTOMIZE_WIDGETS_AND_BADGES' => 'Tilpass utseendet til nettverkets innretninger og skilt.',
        'GET_BADGES' => 'Få skilt',
        'CUSTOM_TEXT' => 'Tilpasset tekst',
        'IM_A_MEMBER_OF' => 'Jeg er medlem av:',
        'DONT_DISPLAY_ANY_BRANDING' => 'Vis ikke varemerking',
        'WATERMARK_OR_LOGO_IMAGE' => 'Vannmerke eller logobilde:',
        'NETWORK_BRANDING_BADGES' => 'Nettverksmerking: Skilt',
        'NETWORK_BRANDING_WIDGETS' => 'Nettverksmerking: Innretninger',
        'LOGO_IMAGE' => 'Logobilde',
        'SMALL_NETWORK_BADGE' => 'Lite nettverksskilt',
        'LARGE_NETWORK_BADGE' => 'Stort nettverksskilt',
        'REFRESH' => 'Oppdater',
        'HTML_EMBED_CODE' => 'HTML embed-kode:',
        'CUSTOMIZE' => 'Tilpass',
        'SHARE_TITLE' => 'Del \'%s\'',
        'SHARE_TYPE' => 'Del %s',
        'YOUR_MESSAGE_SENT' => 'Meldingen er sendt.',
        'YOUR_MESSAGES_SENT' => 'Meldingene er sendt.',
        'YOU_CAN_SHARE_TYPE_TWO_WAYS' => 'Du kan dele %s på følgende to måter&#8230;',
        'CHECK_OUT_THIS_TYPE_TITLE' => 'Sjekk ut denne %s: "%s"',
        'CHECK_OUT_THIS_TYPE' => 'Sjekk ut denne %s',
        'PHOTO_ALBUM' => ' fotoalbum  ',
        'CUSTOMIZE_YOUR_BADGES_AND_WIDGETS' => 'Tilpass skiltene og innretningene med egne farge- og bildevalg.  Endringene kan ta opptil 4 timer før de blir gjengitt på andre nettsider.',
        'BACKGROUND_IMAGE_AND_COLOR' => 'Bakgrunnsbilde og -farge',
        'USE_THIS_FORM_TO_REPORT_ISSUE_TO_NC' => 'Bruk denne formen for å melde om et problem til <a %s>%s</a> som er oppretteren av <a %s>%s</a>.',
        'SORRY_NCS_CANNOT_CHANGE_EMAIL' => 'Beklager, nettverksopprettere kan ikke endre sine e-postadresser gjennom nettverk de ikke eier.',
        'SORRY_NCS_CANNOT_CHANGE_PASSWORD' => 'Beklager, nettverksopprettere kan ikke endre sine passord gjennom nettverk de ikke eier.',
        'GO' => 'Gå til',
        'LARGE_THUMBNAILS' => 'Store miniatyrbilder',
        'SMALL_THUMBNAILS' => 'Små miniatyrbilder',
        'RECENTLY_JOINED' => 'Nyest',
        'MOST_POPULAR_MEMBERS' => 'Mest populær',
        'NO_MEMBERS_TO_DISPLAY' => 'På nåværende tidspunkt viser du ingen medlemmer',
        'BOX_WILL_NOT_SHOW_MEMBERS' => 'Dette vinduet vises ikke for andre personer, med mindre du merker minst én rad.',
        'DETAIL_VIEW' => 'Detaljert visning',
        'TITLES_ONLY' => 'Kun titler',
        'RECENTLY_ADDED_POSTS' => 'Nylig lagt til',
        'POPULAR_POSTS' => 'De fleste kommentarer',
        'PROMOTED_POSTS' => 'Presentert',
        'BOX_WILL_NOT_SHOW_BLOG_POST' => 'Dette vinduet vises ikke for andre personer, med mindre du merker minst ett innlegg.',
        'KEEP_WINDOW_OPEN_UPLOAD' => 'La nettleservinduet være åpent mens opplastingen pågår.',
        'CANCEL_UPLOAD' => 'Avbryt opplasting',
        'YOU_DO_NOT_HAVE_POSTS' => 'Du har ikke skrevet noen innlegg ennå.',
        'YOU_DO_NOT_HAVE_COMMENTS' => 'Du har ingen kommentarer å godkjenne.',
        'REQUIRED_FIELD' => '(Obligatorisk felt)',
        'BLOG_POST_BY_X' => 'Blogginnlegg av %s',
        'HELLO' => 'Hallo,',
        'ADDED_BY_X' => 'Lagt til av %s',
        'CLICK_TO_ADD_A_TITLE' => 'klikk for å legge til en tittel',
        'DELETE_BLOG_POST' => 'Slett innlegg',
        'DELETE_THIS_BLOG_POST_Q' => 'Vil du slette dette blogginnlegget?',
        'ARE_YOU_SURE_DELETE_THIS_BLOG_POST' => 'Er du sikker på at du vil slette dette blogginnlegget?  Dette kan ta et par minutter.',
        'SPINNER' => 'Spinner',
        'PLEASE_ENTER_SOMETHING_FOR_X' => 'Skriv inn noe for: %s',
        'PLEASE_SELECT_OPTION_FOR_X' => 'Velg et alternativ for: %s',
        'PLEASE_PROVIDE_VALID_DATE_FOR_X' => 'Oppgi en gyldig dato for: %s',
        'PLEASE_PROVIDE_DATE_FOR_X' => 'Oppgi en dato for: %s',
        'XS_BLOG_POSTS_FOR_M_Y' => '%ss blogginnlegg for %s %s',
        'FEATURED_BLOG_POSTS_FOR_M_Y' => 'Fremhevede blogginnlegg for %s %s',
        'BLOG_POSTS_FOR_M_Y' => 'Blogginnlegg for %s %s',
        'FEATURED_BLOG_POSTS' => 'Fremhevede blogginnlegg',
        'EVERYONES_POSTS' => 'Alles blogginnlegg',
        'PUBLISHED_N_OF_N' => 'Offentliggjort %d av %d',
        'DOWNLOAD_X' => 'Last ned %s',
        'UPLOAD_DID_NOT_WORK' => 'Beklager, men opplastingen mislyktes',
        'F_J_Y' => 'F j, Y',
        'M_J_Y' => 'M. j, Y',
        'XS_POSTS' => '%ss innlegg',
        'USERNAMES_COMMENTS' => '%ss kommentarer',
        'ADD_COMMENT' => 'Legg til kommentar',
        'XS_PAGE' => '%ss side',
        'XS_BLOG' => '%ss blogg',
        'XS_FRIENDS' => '%ss venner',
        'VIEW_XS_ELLIPSIS' => 'Vis %ss...',
        'DRAFT_BRACKETS' => '[ Utkast ]',
        'FEATURED' => 'Presentert',
        'MY_POSTS' => 'Mine innlegg',
        'MY_POSTS_ONLY' => 'Bare mine innlegg',
        'OWNER_POSTS_ONLY' => 'Bare oppretters innlegg',
        'JANUARY' => 'Januar',
        'FEBRUARY' => 'Februar',
        'MARCH' => 'Mars',
        'APRIL' => 'April',
        'MAY' => 'Mai',
        'JUNE' => 'Juni',
        'JULY' => 'Juli',
        'AUGUST' => 'August',
        'SEPTEMBER' => 'September',
        'OCTOBER' => 'Oktober',
        'NOVEMBER' => 'November',
        'DECEMBER' => 'Desember',
        'MY_COMMENTS' => 'Mine kommentarer',
        'AM' => 'AM',
        'PM' => 'PM',
        'MY_PAGE' => 'Min side',
        'MY_PAGE_TAB_TEXT' => 'Min side',
        'BLOG_POSTS' => 'Blogginnlegg',
        'MY_BLOG' => 'Min blogg',
        'MONTH' => 'Måned',
        'DAY' => 'Dag',
        'PICK_VALID_DEFAULT_VISIBILITY' => 'Foreta et gyldig valg for standard synlighet',
        'PICK_VALID_WHO_CAN_COMMENT' => 'Foreta et gyldig valg for hvem som kan kommentere',
        'PICK_VALID_BLOG_COMMENT_MODERATION' => 'Foreta et gyldig valg for moderering av blogginnlegg',
        'PICK_VALID_ACTIVITY_NOTIFICATION' => 'Foreta et gyldig valg for aktivitetsvarsling',
        'PICK_VALID_MODERATION_NOTIFICATION' => 'Foreta et gyldig valg for varsling om moderering',
        'PICK_VALID_APPROVAL_NOTIFICATION' => 'Foreta et gyldig valg for varsling om godkjenning',
        'PICK_VALID_INVITEE_NOTIFICATION' => 'Foreta et gyldig valg for varsling om tilslutning av invitert person',
        'PICK_VALID_NEVER_NOTIFICATION' => 'Foreta et gyldig valg for ingen varsling',
        'PICK_VALID_FRIEND_REQUEST_NOTIFICATION' => 'Foreta et gyldig valg for varsling om venneforespørsel',
        'PICK_VALID_NEW_MESSAGE_NOTIFICATION' => 'Foreta et gyldig valg for varsling om ny melding',
        'APPROVE_COMMENT' => 'Godkjenn kommentar',
        'MANAGE_BLOG' => 'Administrer blogg',
        'COMMENTS_POSTED_ON_BLOG' => 'Kommentarer er lagt inn på min blogg',
        'COMMENT' => 'Kommentar',
        'COMMENTER' => 'Kommentator',
        'POST' => '"POST, artikkel, POST"',
        'M_J_Y_G_IA' => 'M j, Y, g:ia',
        'POST_HAS_BEEN_DELETED' => 'Innlegg er slettet',
        'COMMENTS_ARE_CLOSED' => 'Kan ikke kommentere dette blogginnlegget',
        'NO_COMMENTS' => 'Ingen kommentarer',
        'FLAG' => 'Flagg',
        'POST_TITLE' => 'Tittel på innlegg',
        'DRAFT_PARENTHESES' => '(Utkast)',
        'SCHEDULED_TO_PUBLISH_ON' => 'Dato for offentliggjøring: %s',
        'EDIT_2' => 'redigere',
        'NONE' => 'Ingen',
        'N_NEW' => '%s Ny',
        'NO_POSTS' => 'Ingen innlegg',
        'ADD_NEW_BLOG_POST' => 'Legg til et nytt blogginnlegg',
        'HAPPY' => 'Glad',
        'SAD' => 'Trist',
        'COOL' => 'Kul',
        'EVIL' => 'Ond',
        'MAD' => 'Sint',
        'ENVIOUS' => 'Misunnelig',
        'ENTRY' => 'Oppføring',
        'WHAT_DATE_FOR_YOUR_POST' => 'Hvilken dato vil du legge ut innlegget?',
        'NOW' => 'Nå',
        'CHOOSE_DATE_AND_TIME' => 'Velg en dato og klokkeslett (hvis du velger en dato i fremtiden, vil innlegget bli offentliggjort da)',
        'PRIVACY_AND_COMMENTS' => 'Personvern og kommentarer',
        'WHO_CAN_VIEW_POST' => 'Hvem kan se dette innlegget?',
        'EVERYONE' => 'Alle',
        'ALLOW_COMMENTS' => 'Vil du ha kommentarer på dette innlegget?',
        'YES' => 'Ja',
        'NO' => 'Nei',
        'COMMENT_MODERATION' => 'Kommentarmoderering',
        'YOU_ARE_MODERATING_BLOG_COMMENTS' => 'Du modererer i nå bloggkommentarer.',
        'YOU_ARE_NOT_MODERATING_BLOG_COMMENTS' => 'På nåværende tidspunkt modererer du ikke bloggkommentarer.',
        'SAVE_AS_DRAFT' => 'Lagre som utkast',
        'PREVIEW' => 'Forhåndsvisning',
        'PUBLISH_POST' => 'Offentliggjør innlegg',
        'THIS_IS_PREVIEW_OF_BLOG_POST' => 'Dette er en forhåndsvisning av hvordan blogginnlegget vil se ut når du offentliggjør det.  Klikk Tilbake for å redigere innlegget, eller Offentliggjør hvis det er klart!',
        'BACK' => 'Tilbake',
        'PUBLISH' => 'Offentliggjør!',
        'BLOG_POST' => 'Blogginnlegg',
        'PROFILE' => 'Profil',
        'THIS_IS_UNPUBLISHED_DRAFT' => 'Dette er et ikke-offentliggjort utkast.',
        'WILL_BE_PUBLISHED_ON_X' => 'Vil bli offentliggjort den %s <small>%s</small>',
        'POSTED_ON_X' => 'Lagt inn <strong>%s</strong> <small>%s</small>',
        'POSTED_ON_X_BY' => 'Lagt inn <strong>%s</strong> <small>%s</small> av:',
        'ABOUT_THIS_POST' => 'Om dette innlegget',
        'ABOUT_YOUR_POST' => 'Om innlegget ditt',
        'ADDED_BY' => ' Lagt til av:   ',
        'JUST_FRIENDS' => 'Bare venner',
        'RECENT_POSTS' => 'Nylige innlegg',
        'THERE_ARE_NO_RECENT_POSTS' => 'Det er ingen nylige innlegg.',
        'YOUR_COMMENT_HAS_BEEN_ADDED_BUT' => 'Kommentaren din er lagt til, men må godkjennes før alle kan se den.',
        'AT_TIME_ON_DATE_USERNAME_SAID' => 'Kl. %s den %s, sa %s...',
        'X_DOES_NOT_HAVE_ANY_FRIENDS' => '%s har ingen venner i dette sosiale nettverket ennå.',
        'YOU_DO_NOT_HAVE_ANY_FRIENDS' => 'Du har ingen venner i dette sosiale nettverket ennå.',
        'EDIT_PAGE_APPEARANCE' => 'Rediger sidens utseende',
        'VIEW_PAGE_AS_OTHERS' => 'Vis siden slik andre vil se den',
        'ADD_BLOG_POST' => 'Legg til blogginnlegg',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED_2' => 'Hold dette leservinduet åpent mens alt innholdet til %s blir slettet.  Dette kan ta et par minutter.',
        'BAN_MEMBER_FROM_NETWORK' => 'Utesteng medlem fra nettverket',
        'BAN_USERNAME' => 'Vil du utstenge %s?',
        'BLOCK' => 'blokker',
        'CREATE_NEW_BLOG_POST' => 'Opprett et nytt blogginnlegg!',
        'EDIT_POST' => 'Rediger innlegg',
        'EDIT_POST_COLON' => 'Rediger innlegg:',
        'CONTINUE_READING' => 'Fortsett å lese...',
        'POSTED_BY_ME_LINK_ON_X_AT_X' => 'Posted by <a %s>me</a> on %s at %s  —',
        'POSTED_BY_X_ON_X_AT_X' => 'Posted by %s on %s at %s  —',
        'POSTED_BY_ME_ON_X_AT_X' => 'Posted by me on %s at %s  —',
        'ADD' => 'Legg til',
        'SUBSCRIBE' => 'Abonner',
        'VIEW_ARCHIVES' => 'Vis arkiver',
        'YOUR_SETTINGS_HAVE_BEEN_SAVED' => 'Innstillingene er lagret.',
        'PLEASE_CORRECT_THE_FOLLOWING' => 'Vennligst rett følgende:',
        'PRIVACY' => 'Personvern',
        'NETWORK_PRIVACY' => 'Personvern for nettverk',
        'THIS_NETWORK_VISIBLE_TO_EVERYONE' => 'Dette nettverket er <strong>synlig for alle</strong>.',
        'ANYONE_CAN_SIGN_UP_VISITORS_CAN' => 'Alle kan registrere seg for å bli medlem.  Besøkende kan ...',
        'SEE_EVERYTHING' => 'Se alt',
        'SEE_JUST_THE_MAIN_PAGE' => 'Bare se hovedsiden',
        'SEE_JUST_THE_SIGN_UP_PAGE' => 'Bare se registreringssiden',
        'THIS_NETWORK_VISIBLE_MEMBERS_ONLY' => 'Dette nettverket er <strong>bare synlig for medlemmer</strong>.',
        'WHO_CAN_SIGN_UP' => 'Hvem kan registrere seg for å bli medlem?',
        'MODERATION' => 'Innholdskontroll',
        'APPROVE_MEMBERS_BEFORE_JOIN' => 'Godkjenn nye medlemmer før de kan bli med',
        'APPROVE_PHOTOS_VIDEOS' => 'Godkjenn bilder og videoer før de vises',
        'SHOW_LATEST_ACTIVITY_ON_YOUR_NETWORK' => 'Vis den siste aktiviteten på nettverket ditt!',
        'PUT_A_CONSTANTLY_UPDATED_STREAM' => 'Plasser en stadig oppdatert strøm av nylige aktiviteter på nettverkets hovedside.',
        'CLICK_HERE_TO_ADD_LATEST_ACTIVITY' => 'Klikk her hvis du vil legge til den siste aktiviteten på nettverket ditt.',
        'THESE_OPTIONS_ARE_DISABLED_ACTIVITY' => 'Disse alternativene er deaktivert siden du ikke har den nyeste aktiviteten på nettverket ditt.',
        'ACTIVITY' => 'Aktivitet',
        'DISPLAY_PREFERENCES' => 'Vis innstillinger',
        'NEW_CONTENT' => 'Nytt innhold',
        'NEW_COMMENTS' => 'Nye kommentarer',
        'NEW_MEMBERS' => 'Nye medlemmer',
        'MEMBER_UPDATES' => 'Medlemsoppdatering',
        'WHAT_DISPLAYS_LATEST_ACTIVITY' => 'Hva vises i nettverkets <br />Siste aktivitet?',
        'LATEST_ACTIVITY' => 'Siste aktivitet',
        'X_COMMENTED_ON_POST_TITLE' => '%1$s svarte på diskusjonen %2$s',
        'X_LINK_COMMENTED_ON_POST_LINK_TITLE' => '%1$s <a %2$s>svarte</a> på diskusjonen <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_POST_LINK_TITLE' => 'Du <a %1$s>svarte</a> på diskusjonen <a %2$s>%3$s</a>',
        'X_COMMENTED_ON_BLOG_POST_TITLE' => '%1$s kommenterte blogginnlegget %2$s',
        'X_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '%1$s <a %2$s>kommenterte</a> blogginnlegget <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => 'Du <a %1$s>kommenterte</a> blogginnlegget <a %2$s>%3$s</a>',
        'X_STARTED_A_DISCUSSION_Y' => '%s startet en diskusjon kalt %s',
        'YOU_STARTED_A_DISCUSSION_Y' => 'Du startet en diskusjon ved navn %s',
        'X_ADDED_THE_BLOG_POST_Y' => '%s la til blogginnlegget \'%s\'',
        'YOU_ADDED_THE_BLOG_POST_Y' => 'Du la til blogginnlegget \'%s\'',
        'X_JOINED_THE_GROUP_Y' => '%s er blitt med i gruppen %s!',
        'YOU_JOINED_THE_GROUP_X' => 'Du er blitt med i gruppen %s',
        'X_JOINED_Y_GROUPS' => '%s ble med i %s grupper',
        'YOU_JOINED_X_GROUPS' => 'Du er med i %s grupper',
        'X_JOINED_APPNAME' => '%s ble med i %s. <a %s>Legg igjen en kommentar</a> for %s.',
        'WELCOME_MEMBER_N_OF_APPNAME' => 'Velkommen, %1$s!  Du er medlem nr. %2$s av %3$s.',
        'WELCOME_MEMBER_N_OF_APPNAME_FIND' => 'Velkommen, %1$s!  Du er medlem nr. %2$s av %3$s.  <a %4$s>Finn venner nå</a>.',
        'X_IS_MEMBER_N_OF_APPNAME' => '%1$s er medlem nr. %2$s av %3$s.',
        'XS_PROFILE_CHANGED' => '%ss profil er endret',
        'YOUR_PROFILE_CHANGED' => 'Din profil er endret',
        'X_LEFT_A_COMMENT_FOR_Y' => '%s la igjen en kommentar til %s',
        'YOU_LEFT_A_COMMENT_FOR_X' => 'Du la igjen en kommentar til %s',
        'X_LEFT_A_COMMENT_FOR_YOU' => '%s la igjen en kommentar til deg',
        'X_CREATED_A_GROUP_Y' => '%s opprettet gruppen %s',
        'YOU_CREATED_A_GROUP_Y' => 'Du opprettet gruppen %s',
        'X_CREATED_Y_NEW_GROUPS' => '%s opprettet %s nye grupper',
        'X_STARTED_Y_FORUM_POSTS' => '%s startet %s nye forumdiskusjoner',
        'YOU_STARTED_Y_FORUM_POSTS' => 'Du startet %s nye forumdiskusjoner',
        'X_ADDED_Y_BLOG_POSTS' => '%s la til %s nye blogginnlegg',
        'YOU_ADDED_Y_BLOG_POSTS' => 'Du la til %s nye blogginnlegg',
        'VIEW_XS_BLOG_POSTS' => 'Vis %ss blogginnlegg',
        'VIEW_YOUR_BLOG_POSTS' => 'Vis blogginnleggene dine',
        'APPNAME_HAS_NEW_PROFILE_QUESTIONS' => '%s har <a %s>nye profilspørsmål</a>',
        'APPNAME_NOW_HAS_MUSIC' => '%s har nå en musikkspiller',
        'APPNAME_NOW_HAS_GROUPS' => '%s har nå <a %s>grupper</a>',
        'APPNAME_NOW_HAS_VIDEO' => '%s har nå <a %s>videoer</a>',
        'APPNAME_NOW_HAS_FORUM' => '%s har nå et <a %s>forum</a>',
        'APPNAME_NOW_HAS_PHOTO' => '%s har nå <a %s>bilder</a>',
        'DID_YOU_KNOW' => 'Visste du at',
        'ANNOUNCEMENT' => 'Kunngjøring',
        'CONGRATULATIONS' => 'Gratulerer',
        'YOU_CREATED_APPNAME' => 'Du opprettet %s-nettverket.',
        'USER_CREATED_APPNAME' => '%s opprettet %s-nettverket.',
        'ADD_MESSAGES_ACTIVITY_FEED' => 'Legg til meldinger og velg det som vises i nettverkets aktivitetsstoff.',
        'WHICH_OF_YOUR_ACTIONS_DISPLAY_ACTIVITY' => 'Hvilke handlinger bør vises<br />som siste aktivitet?',
        'NEW_CONTENT_I_ADD' => 'Nytt innhold jeg legger til',
        'NEW_COMMENTS_I_ADD' => 'Nye kommentarer jeg legger til',
        'WHEN_I_UPDATE_MY_PROFILE' => 'Når jeg oppdaterer profilen min',
        'THE_LATEST_ACTIVITY_WILL_NEVER' => 'Siste aktivitet vil aldri vise meldinger du sender, sider eller medlemmer du viser, invitasjoner du avslår, personer du ikke vil ha som venner lenger eller avslår, eller ting du sletter.',
        'YOU_HAVENT_DONE_ANYTHING_RECENTLY' => 'Du har ingen nylig aktivitet.  Hvorfor ikke starte noe?',
        'YOUVE_TURNED_OFF_THE_ACTIVITY_DISPLAY_CLICK' => 'Du har deaktivert visning av aktivitetene dine.  <a %s>Klikk her for å aktivere den igjen. </a>',
        'THE_NETWORK_CREATOR_HAS_TURNED_OFF_THE_ACTIVITY' => 'Nettverksoppretteren har deaktivert visning av all aktivitet.',
        'NO_ACTIVITY_TO_DISPLAY' => 'På nåværende tidspunkt viser du ingen aktivitet.',
        'BOX_WILL_NOT_SHOW_ACTIVITY' => 'Denne boksen vises ikke for andre personer, med mindre du merker minst ett aktivitetselement.',
        'NOTHING_IS_HAPPENING_ON_YOUR_NETWORK' => 'Det er ingen nylig aktivitet.  Hvorfor ikke starte noe?',
        'MY_ACTIVITY_PREFERENCES' => 'Innstillinger for min aktivitet',
        'DELETE_ACTIVITY_ITEM' => 'Fjern aktivitetsmelding',
        'DELETE_THIS_ACTIVITY_MESSAGE_Q' => 'Vil du fjerne aktivitetsmeldingen?',
        'THIS_WILL_PREVENT_ACTIVITY' => 'Dette vil hindre at noen får se denne aktivitetsmeldingen',
        'X_HAS_POSTED_THE_MOST_PHOTOS' => '%1$s har lagt inn flest %2$sbilder%3$s',
        'X_IS_THE_MOST_POPULAR_PHOTO' => '%s er det mest populære bildet til nå',
        'X_HAS_POSTED_THE_MOST_VIDEOS' => '%1$s har lagt inn flest %2$svideoer%3$s',
        'X_IS_THE_MOST_POPULAR_VIDEO' => '%s er den mest populære videoen til nå',
        'X_HAS_POSTED_THE_MOST_MUSIC' => '%s har lagt inn flest sanger',
        'X_IS_THE_MOST_POPULAR_MUSIC' => '%s er den mest populære sangen til nå',
        'X_IS_THE_MOST_POPULAR_TOPIC' => '%s er det mest populære foruminnlegget til nå',
        'X_IS_THE_MOST_POPULAR_BLOG_POST' => '%s er det mest populære blogginnlegget til nå',
        'XS_LATEST_ACTIVITY_ON_APPNAME' => '%ss siste aktivitet på %s',
        'LATEST_ACTIVITY_ON_APPNAME' => 'Siste aktivitet på %s',
        'ADD_MESSAGE_TO_LATEST_ACTIVITY' => 'Legg til melding for siste aktivitet',
        'ADD_FACTS_ABOUT_THE_NETWORK_ELLIPSIS' => 'Legg til fakta om nettverket ..',
        'ADD_MESSAGE' => 'Legg til melding',
        'ELLIPSIS_OR_WRITE_YOUR_OWN_MESSAGE' => '.. eller skriv din egen melding',
        'NETWORK' => 'Nettverk',
        'WHO_CAN_VIEW_YOUR_PHOTOS_VIDEOS' => 'Hvem kan se bildene, videoene<br/> og blogginnleggene dine som standard?',
        'YOU_CAN_OVERRIDE_WHEN_YOU_ADD' => '(Du kan overstyre denne innstillingen for et bilde, en video eller et blogginnlegg når du legger det til.)',
        'MODERATE_COMMENTS_ON_BLOG' => 'Vil du godkjenne kommentarene <br /> før bloggen din vises?',
        'YES_LET_ME_APPROVE' => 'Ja - la meg godkjenne kommentaren først.',
        'NO_PUBLISH_COMMENTS' => 'Nei- offentliggjør kommentaren umiddelbart',
        'WHO_CAN_COMMENT_ON_PHOTOS_VIDEOS' => 'Hvem kan kommentere bildene,<br/> videoene og bloggen din?',
        'SAVE' => 'Lagre',
        'EMAIL' => 'E-post',
        'YOUR_PRIVACY_IS_IMPORTANT' => 'Ditt personvern er viktig for oss.  Hvis du har spørsmål om e-postvarsling, bes du sende oss en melding via <a href="http://help.ning.com/?page_id=27">Hjelpesenter</a>.',
        'ADD_PHOTOS_AND_VIDEOS_TO_X_BY_SENDING' => 'Legg til bilder og videoer i %s ved å sende dem til følgende e-postadresse:',
        'ADD_PHOTOS_AND_VIDEOS_TO_APPNAME_FROM_PHONE' => 'Legg til bilder og videoer i %s fra telefonen din ved å sende dem til følgende e-postadresse:',
        'GENERATE_NEW_EMAIL_ADDRESS' => 'Opprett ny e-postadresse',
        'SUPPORTS_TEXT_EMBEDDED' => 'Støtter tekst, inkluderte videoer, bilder og innretninger',
        'POST_COMMENT' => 'Legg inn kommentar',
        'YOU_NEED_TO_BE_MEMBER_COMMENTS' => 'Du må være medlem av %s for å kunne legge til kommentarer!',
        'MONTHLY_ARCHIVES' => 'Månedlige arkiver',
        'NO_FRIENDS_ON_SITE' => 'Ingen venner på dette sosiale nettverket ennå.',
        'NO_FRIENDS_ON_SITE_THAT_MATCH' => 'Ingen venner i dette sosiale nettverket passer til søkekriteriet ditt',
        'MEMBERS_TAB_TEXT' => 'Medlemmer',
        'SITE_HAS_NO_MEMBERS' => 'Dette sosiale nettverket har ingen medlemmer ennå!',
        'SITE_HAS_NO_MEMBERS_THAT_MATCH' => 'Dette sosiale nettverket har ingen medlemmer som passer til søkekriteriet ditt.',
        'NO_COMMENTS_YET' => 'Ingen kommentarer ennå!',
        'VIEW_ALL_COMMENTS' => 'Vis alle kommentarer',
        'YOU_HAVE_NOT_ADDED_BLOG_POSTS' => 'Du har ikke lagt til blogginnlegg ennå!',
        'YOU_CAN_WRITE_ABOUT_ANYTHING' => 'Du kan skrive om alt du vil, snakke om og legge ved favorittvideoer, -bilder og -musikk.',
        'WRITE_YOUR_FIRST_ENTRY' => 'Skriv ditt første innlegg!',
        'THERE_ARE_NO_BLOG_POSTS' => 'Foreløpig har ditt sosiale nettverk ingen blogginnlegg.',
        'THERE_ARE_NO_FEATURED_X' => 'Det er ingen fremhevede %s på det sosiale nettverket.',
        'THERE_ARE_NO_X_THAT_MATCH_SETTINGS' => 'Det er ingen %s som passer til innstillingene du har valgt.',
        'START_FEATURING_X_CLICK_Y' => 'Begynn å fremheve %s der du ser alternativet Fremhev.  <a %s>Klikk her</a> hvis du vil vite mer om fremheving.',
        'THIS_BOX_WILL_NOT_SHOW_BLOG_POSTS' => 'Denne boksen vises ikke for andre personer før det er blogginnlegg som kan vises.  Hvorfor ikke legge til en?',
        'YOUR_FRIEND' => 'Din venn',
        'REQUEST_SENT' => 'Forespørsel er sendt!',
        'BLOCKED' => 'Blokkert',
        'BANNED' => 'Utstengt',
        'ADD_YOUR_FIRST_BLOG_POST' => 'Legg til ditt første blogginnlegg',
        'MY_FIRST_BLOG_POST' => 'Mitt første blogginnlegg!',
        'TELL_THE_PEOPLE_ON' => 'Fortell folk på %s mer om deg selv.  Spørsmål merket med en <span %s>lås</span> er private og bare synlige for administratorer.',
        'CHOOSE_A_THEME_FOR_PAGE' => 'Velg et tema for siden din',
        'NOW_CUSTOMIZE_PAGE' => 'Tilpass siden din nå ...',
        'NO_POSTS_TO_DISPLAY' => 'Ingen innlegg å vise.',
        'YOU_ARE_DISPLAYING_NO_POSTS' => 'På nåværende tidspunkt viser du ingen innlegg.',
        'DATE_COLON' => 'Dato:',
        'TIME_COLON' => 'Klokkeslett:',
        'CHANGE' => 'Endre',
        'UPLOAD_A_PHOTO' => 'Last opp et bilde',
        'OPTIONS' => 'Alternativer',
        'PIXELS' => 'Piksler',
        'CANCEL' => 'Avbryt',
        'UPLOAD_A_FILE' => 'Last opp en fil:',
        'TO_INSERT_A_FILE' => 'Hvis du vil sette inn en fil, klikker du “Bla gjennom” eller “Velg” ovenfor for å finne filen på datamaskinen.',
        'UPLOADING' => 'Laster opp ...',
        'OK' => 'OK',
        'POPULAR_MEMBERS' => 'Populære medlemmer',
        'INVITE_FRIENDS' => 'Inviter venner',
        'VIEW_ALL' => 'Vis alle',
        'REMOVE_X' => 'Fjern %s',
        'ARE_YOU_SURE_BAN_X_AND_CONTENT' => 'Er du sikker på at du vil stenge ut %1$s fra det sosiale nettverket og slette alt innhold %1$s har lagt til?  Dette kan ta et par minutter.',
        'REMOVING_X' => 'Fjerner %s',
        'ARE_YOU_SURE_BAN_MEMBERS_AND_CONTENT' => 'Er du sikker på at du vil stenge ut de merkede medlemmene fra det sosiale nettverket og slette alt innhold de har lagt til?  Dette kan ta et par minutter.',
        'ARE_YOU_SURE_BAN_MEMBERS' => 'Er du sikker på at du vil stenge ut det merkede medlemmet/de merkede medlemmene fra det sosiale nettverket?  Dette kan ta et par minutter.',
        'BAN' => 'Steng ut',
        'REMOVING_MEMBERS' => 'Fjerner medlemmer',
        'FEMALE' => 'Kvinne',
        'MALE' => 'Mann',
        'UNITED_STATES' => 'USA',
        'AND' => 'og',
        'FROM' => 'fra',
        'GENDER_M' => 'Mann',
        'GENDER_F' => 'Kvinne',
        'XS_PAGE_ON_Y' => '%ss side på %s',
        'SEARCH_MEMBERS' => 'Søk gjennom medlemmer',
        'SOMEBODY_COMMENTED_BLOGPOST_ADDED_TO_X' => 'noen kommenterte et blogginnlegg du har lagt til %s',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE' => 'Du har en ny kommentar på siden din.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X' => 'Du har en ny kommentar på siden din på %s.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X_ELLIPSIS' => 'Du har en ny kommentar på siden din på %s...',
        'A_BLOG_POST' => 'et blogginnlegg',
        'NOW_THAT_YOU_JOINED_INVITE' => 'Nå som du er blitt med, <strong><a %s> kan du invitere vennene dine</a></strong>!',
        'THIS_IS_YOUR_PROFILE' => 'Dette er profilen din:',
        'START_BY_CUSTOMIZING_ITS_APPEARANCE' => 'Begynn med å <a %s>tilpasse utseendet</a>.',
        'USE_IT_TO_KEEP_A_BLOG_AND_DISPLAY_YOUR_PROFILE_ANSWERS' => 'Bruk det for å <a %1$s>føre en blogg</a> og vise <a %2$s> profilsvarene dine</a>',
        'START_CONTRIBUTING' => 'Begynn å bidra:',
        'UPLOAD_VIDEOS' => 'Last opp videoer',
        'CONTRIBUTE_TO_DISCUSSIONS' => 'Bidra til diskusjoner',
        'JOIN_GROUPS' => 'Bli med i grupper',
        'ADD_A_BLOG_POST' => 'Legg til et blogginnlegg',
        'CLICK_TO_ACCEPT_FRIENDS' => 'Klikk her for å vise venneforespørslene dine.',
        'LEAVE_X' => 'Utmelding av %s',
        'LEAVE_X_Q' => 'Vil du melde deg ut av %s?',
        'ARE_YOU_SURE_LEAVE_X' => 'Er du sikker på at du vil melde deg ut av %s og slette alt innholdet ditt?  Dette kan ta et par minutter.',
        'BACK_TO_USERNAMES_PAGE' => '&#8592;  Tibake til %ss side',
        'BACK_TO_MY_PAGE' => '&#8592;  Tilbake til min side',
        'COMMENT_WALL' => ' Kommentarvegg  ',
        'ONLINE' => 'Pålogget',
        'MEMBER_IS_ONLINE' => 'Medlem er online',
        'ONLINE_NOW' => 'Online nå',
        'CHOOSE_WHO_CAN_SEE_JOIN_AND_CONTRIBUTE' => 'Velg hvem som kan se, bli med i og bidra til nettverket ditt.',
        'EMAIL_NOTIFICATIONS' => 'E-postvarslinger',
        'WHAT_NETWORK_ACTIVITY_EMAIL_FOR' => 'Hvilken nettverksaktivitet vil du motta en e-postvarsling for?',
        'NETWORK_MESSAGES' => 'Nettverksmeldinger',
        'MEMBER_ACTIVITY' => 'Medlemsaktivitet',
        'APPROVAL' => 'Godkjenning',
        'FRIEND_REQUESTS' => 'Venneforespørsler',
        'PEOPLE_IVE_INVITED_JOIN' => 'Personer jeg har invitert til å bli med i dette nettverket',
        'MESSAGES_SENT_TO_ME' => 'Meldinger sendt til meg',
        'MESSAGES_SENT_TO_GROUPS' => 'Meldinger sendt til grupper jeg tilhører',
        'MESSAGES_SENT_TO_NETWORK' => 'Meldinger sendt til hele nettverket',
        'I_HAVE_NEW_COMMENTS' => 'Jeg har nye kommentarer å godkjenne',
        'I_HAVE_NEW_NETWORK_CONTENT' => 'Jeg har nytt nettverksinnhold å godkjenne',
        'CONTENT_ACTIVITY' => 'Innholdsaktivitet',
        'ACTIVITY_ON_THINGS_IVE_ADDED' => 'Aktivitet i forbindelse med det jeg har lagt til',
        'AUTO_FOLLOW_DISCUSSIONS_I_REPLY_TO' => 'Følg automatisk diskusjoner jeg svarer på',
        'THINGS_IVE_ADDED_APPROVED' => 'Det jeg har lagt til, er godkjent',
        'NOTIFICATIONS' => 'Meldinger',
        'EMAIL_ME_WHEN_PEOPLE_REPLY' => 'Send en e-post når noen svarer',
        'DO_NOT_EMAIL_ME_WHEN_PEOPLE_REPLY' => 'Send ikke e-post når noen svarer',
        'TO_STOP_FOLLOWING_THIS_X_CLICK_Y' => '<a %s>Klikk her</a> for å slutte å følge denne %s.',
        'YOU_ARE_NO_LONGER_FOLLOWING_THIS_X' => 'Du følger ikke lenger denne %s.',
        'NOTIFY' => 'Varsle',
        'STOP_NOTIFYING' => 'Stopp varsling',
        'EMAIL_WHEN_NEW_DISCUSSIONS' => 'Send en e-post når det er nye diskusjoner',
        'DO_NOT_EMAIL_WHEN_NEW_DISCUSSIONS' => 'Ikke send en e-post når det er nye diskusjoner',
        'STOP_FOLLOWING_ALL' => 'Slutt å følge alle diskusjoner og bloggkommentarer',
        'CHANGE_MY_PHOTO' => 'Bytt ut bildet mitt',
        'COUNTRY_AF' => 'Den islamske staten Afghanistan',
        'COUNTRY_AX' => 'Åland',
        'COUNTRY_AL' => 'Albania',
        'COUNTRY_DZ' => 'Algerie',
        'COUNTRY_AS' => 'Amerikansk Samoa',
        'COUNTRY_AD' => 'Andorra',
        'COUNTRY_AO' => 'Angola',
        'COUNTRY_AI' => 'Anguilla',
        'COUNTRY_AQ' => 'Antarktis',
        'COUNTRY_AG' => 'Antigua og Barbuda',
        'COUNTRY_AR' => 'Argentina',
        'COUNTRY_AM' => 'Armenia',
        'COUNTRY_AW' => 'Aruba',
        'COUNTRY_AU' => 'Australia',
        'COUNTRY_AT' => 'Østerrike',
        'COUNTRY_AZ' => 'Aserbajdsjan',
        'COUNTRY_BS' => 'Bahamas',
        'COUNTRY_BH' => 'Bahrain',
        'COUNTRY_BD' => 'Bangladesh',
        'COUNTRY_BB' => 'Barbados',
        'COUNTRY_BY' => 'Hviterussland',
        'COUNTRY_BE' => 'Belgia',
        'COUNTRY_BZ' => 'Belize',
        'COUNTRY_BJ' => 'Benin',
        'COUNTRY_BM' => 'Bermuda',
        'COUNTRY_BT' => 'Bhutan',
        'COUNTRY_BO' => '"Bolivia, Bolivia"',
        'COUNTRY_BA' => 'Bosnia-Hercegovina',
        'COUNTRY_BW' => 'Botswana',
        'COUNTRY_BV' => 'Bouvetøya',
        'COUNTRY_BR' => 'Brasil',
        'COUNTRY_IO' => 'Det britiske territoriet i Indiahavet',
        'COUNTRY_BN' => 'Brunei',
        'COUNTRY_BG' => 'Bulgaria',
        'COUNTRY_BF' => 'Burkina Faso',
        'COUNTRY_BI' => 'Burundi',
        'COUNTRY_KH' => 'Kambodsja',
        'COUNTRY_CM' => 'Kamerun',
        'COUNTRY_CA' => 'Canada',
        'COUNTRY_CV' => 'Kapp Verde',
        'COUNTRY_KY' => 'Caymanøyene',
        'COUNTRY_CF' => 'Den sentralafrikanske republikken',
        'COUNTRY_TD' => 'Tsjad',
        'COUNTRY_CL' => 'Chile',
        'COUNTRY_CN' => 'Kina, fastlandet',
        'COUNTRY_CX' => 'Christmasøya',
        'COUNTRY_CC' => 'Kokosøyene',
        'COUNTRY_CO' => 'Colombia',
        'COUNTRY_KM' => 'Komorene',
        'COUNTRY_CG' => 'Kongo (republikk)',
        'COUNTRY_CD' => 'Kongo (den demokratiske republikken)',
        'COUNTRY_CK' => 'Cookøyene',
        'COUNTRY_CR' => 'Costa Rica',
        'COUNTRY_CI' => 'Elfenbenskysten',
        'COUNTRY_HR' => 'Kroatia',
        'COUNTRY_CU' => 'Cuba',
        'COUNTRY_CY' => 'Kypros',
        'COUNTRY_CZ' => 'Den tsjekkiske republikken',
        'COUNTRY_DK' => 'Danmark',
        'COUNTRY_DJ' => 'Djibouti',
        'COUNTRY_DM' => 'Dominica',
        'COUNTRY_DO' => 'Den dominikanske republikken',
        'COUNTRY_EC' => 'Ecuador',
        'COUNTRY_EG' => 'Egypt',
        'COUNTRY_SV' => 'El Salvador',
        'COUNTRY_GQ' => 'Ekvatorial-Guinea',
        'COUNTRY_ER' => 'Eritrea',
        'COUNTRY_EE' => 'Estland',
        'COUNTRY_ET' => 'Etiopia',
        'COUNTRY_EU' => 'Den europeiske union',
        'COUNTRY_FK' => 'Falklandsøyene',
        'COUNTRY_FO' => 'Færøyene',
        'COUNTRY_FJ' => 'Fiji',
        'COUNTRY_FI' => 'Finland',
        'COUNTRY_FR' => 'Frankrike',
        'COUNTRY_GF' => 'Fransk Guyana',
        'COUNTRY_PF' => 'Fransk Polynesia',
        'COUNTRY_TF' => 'De franske sørterritorier',
        'COUNTRY_GA' => 'Gabon',
        'COUNTRY_GM' => 'Gambia',
        'COUNTRY_GE' => 'Georgia',
        'COUNTRY_DE' => 'Tyskland',
        'COUNTRY_GH' => 'Ghana',
        'COUNTRY_GI' => 'Gibraltar',
        'COUNTRY_GR' => 'Hellas',
        'COUNTRY_GL' => 'Grønland',
        'COUNTRY_GD' => 'Grenada',
        'COUNTRY_GP' => 'Guadeloupe',
        'COUNTRY_GU' => 'Guam',
        'COUNTRY_GT' => 'Guatemala',
        'COUNTRY_GN' => 'Guinea',
        'COUNTRY_GW' => 'Guinea-Bissau',
        'COUNTRY_GY' => 'Guyana',
        'COUNTRY_HT' => 'Haiti',
        'COUNTRY_HM' => 'Heardøya og McDonaldøyene',
        'COUNTRY_HN' => 'Honduras',
        'COUNTRY_HK' => 'Hong Kong',
        'COUNTRY_HU' => 'Ungarn',
        'COUNTRY_IS' => 'Island',
        'COUNTRY_IN' => 'India',
        'COUNTRY_ID' => 'Indonesia',
        'COUNTRY_IR' => 'Den islamske republikken Iran',
        'COUNTRY_IQ' => 'Irak',
        'COUNTRY_IE' => 'Irland',
        'COUNTRY_IL' => 'Israel',
        'COUNTRY_IT' => 'Italia',
        'COUNTRY_JM' => 'Jamaica',
        'COUNTRY_JP' => 'Japan',
        'COUNTRY_JO' => 'Jordan',
        'COUNTRY_KZ' => 'Kasakhstan',
        'COUNTRY_KE' => 'Kenya',
        'COUNTRY_KI' => 'Kiribati',
        'COUNTRY_KP' => 'Nord-Korea',
        'COUNTRY_KR' => 'Sør-Korea',
        'COUNTRY_KW' => 'Kuwait',
        'COUNTRY_KG' => 'Kirgisistan',
        'COUNTRY_LA' => 'Den demokratiske folkerepublikken Laos',
        'COUNTRY_LV' => 'Latvia',
        'COUNTRY_LB' => 'Libanon',
        'COUNTRY_LS' => 'Lesotho',
        'COUNTRY_LR' => 'Liberia',
        'COUNTRY_LY' => 'Den libyske arabiske Jamahiriya',
        'COUNTRY_LI' => 'Liechtenstein',
        'COUNTRY_LT' => 'Litauen',
        'COUNTRY_LU' => 'Luxemburg',
        'COUNTRY_MO' => 'Macao',
        'COUNTRY_MK' => 'Makedonia, tidligere jugoslavisk republikk',
        'COUNTRY_MG' => 'Madagaskar',
        'COUNTRY_MW' => 'Malawi',
        'COUNTRY_MY' => 'Malaysia',
        'COUNTRY_MV' => 'Maldivene',
        'COUNTRY_ML' => 'Mali',
        'COUNTRY_MT' => 'Malta',
        'COUNTRY_MH' => 'Marshalløyene',
        'COUNTRY_MQ' => 'Martinique',
        'COUNTRY_MR' => 'Mauritania',
        'COUNTRY_MU' => 'Mauritius',
        'COUNTRY_YT' => 'Mayotte',
        'COUNTRY_MX' => 'Mexico',
        'COUNTRY_FM' => 'Mikronesia, de føderale statene',
        'COUNTRY_MD' => 'Moldova, republikken',
        'COUNTRY_MC' => 'Monaco',
        'COUNTRY_MN' => 'Mongolia',
        'COUNTRY_MS' => 'Montserrat',
        'COUNTRY_MA' => 'Marokko',
        'COUNTRY_MZ' => 'Mosambik',
        'COUNTRY_MM' => 'Myanmar (tidl. Burma)',
        'COUNTRY_NA' => 'Namibia',
        'COUNTRY_NR' => 'Nauru',
        'COUNTRY_NP' => 'Nepal',
        'COUNTRY_NL' => 'Nederland',
        'COUNTRY_AN' => 'De nederlandske Antillene',
        'COUNTRY_NC' => 'Ny-Caledonia',
        'COUNTRY_NZ' => 'New Zealand',
        'COUNTRY_NI' => 'Nicaragua',
        'COUNTRY_NE' => 'Niger',
        'COUNTRY_NG' => 'Nigeria',
        'COUNTRY_NU' => 'Niue',
        'COUNTRY_NF' => 'Norfolkøya',
        'COUNTRY_MP' => 'Nord-Marianene',
        'COUNTRY_NO' => 'Norge',
        'COUNTRY_OM' => 'Oman',
        'COUNTRY_PK' => 'Pakistan',
        'COUNTRY_PW' => 'Palau',
        'COUNTRY_PS' => 'Palestina, okkuperte områder',
        'COUNTRY_PA' => 'Panama',
        'COUNTRY_PG' => 'Papua Ny-Guinea',
        'COUNTRY_PY' => 'Paraguay',
        'COUNTRY_PE' => 'Peru',
        'COUNTRY_PH' => 'Filippinene',
        'COUNTRY_PN' => 'Pitcairn',
        'COUNTRY_PL' => 'Polen',
        'COUNTRY_PT' => 'Portugal',
        'COUNTRY_PR' => 'Puerto Rico',
        'COUNTRY_QA' => 'Qatar',
        'COUNTRY_RE' => 'Réunion',
        'COUNTRY_RO' => 'Romania',
        'COUNTRY_RU' => 'Russiske samveldet',
        'COUNTRY_RW' => 'Rwanda',
        'COUNTRY_SH' => 'St. Helena',
        'COUNTRY_KN' => 'Saint Kitts og Nevis',
        'COUNTRY_LC' => 'St. Lucia',
        'COUNTRY_PM' => 'St. Pierre og Miquelon',
        'COUNTRY_VC' => 'St. Vincent og Grenadinene',
        'COUNTRY_WS' => 'Samoa',
        'COUNTRY_SM' => 'San Marino',
        'COUNTRY_ST' => 'São Tomé og Príncipe',
        'COUNTRY_SA' => 'Saudi-Arabia',
        'COUNTRY_SN' => 'Senegal',
        'COUNTRY_CS' => 'Serbia og Montenegro',
        'COUNTRY_SC' => 'Seychellene',
        'COUNTRY_SL' => 'Sierra Leone',
        'COUNTRY_SG' => 'Singapore',
        'COUNTRY_SK' => 'Slovakia',
        'COUNTRY_SI' => 'Slovenia',
        'COUNTRY_SB' => 'Salomoøyene',
        'COUNTRY_SO' => 'Somalia',
        'COUNTRY_ZA' => 'Sør-Afrika',
        'COUNTRY_GS' => 'Sør-Georgia og Sandwichøyene',
        'COUNTRY_ES' => 'Spania',
        'COUNTRY_LK' => 'Sri Lanka',
        'COUNTRY_SD' => 'Sudan',
        'COUNTRY_SR' => 'Surinam',
        'COUNTRY_SJ' => 'Svalbard og Jan Mayen',
        'COUNTRY_SZ' => 'Swaziland',
        'COUNTRY_SE' => 'Sverige',
        'COUNTRY_CH' => 'Sveits',
        'COUNTRY_SY' => 'Den syriske arabiske republikk',
        'COUNTRY_TW' => 'Taiwan',
        'COUNTRY_TJ' => 'Tadsjikistan',
        'COUNTRY_TZ' => 'Tanzania, den forente republikken',
        'COUNTRY_TH' => 'Thailand',
        'COUNTRY_TL' => 'Øst-Timor',
        'COUNTRY_TG' => 'Togo',
        'COUNTRY_TK' => 'Tokelau',
        'COUNTRY_TO' => 'Tonga',
        'COUNTRY_TT' => 'Trinidad og Tobago',
        'COUNTRY_TN' => 'Tunisia',
        'COUNTRY_TR' => 'Tyrkia',
        'COUNTRY_TM' => 'Turkmenistan',
        'COUNTRY_TC' => 'Turks- og Caicosøyene',
        'COUNTRY_TV' => 'Tuvalu',
        'COUNTRY_UG' => 'Uganda',
        'COUNTRY_UA' => 'Ukraina',
        'COUNTRY_AE' => 'De forente arabiske emirater',
        'COUNTRY_GB' => 'Storbritannia',
        'COUNTRY_US' => 'USA',
        'COUNTRY_UM' => 'De forente staters små fjerntliggende øyer',
        'COUNTRY_UY' => 'Uruguay',
        'COUNTRY_UZ' => 'Usbekistan',
        'COUNTRY_VU' => 'Vanuatu',
        'COUNTRY_VA' => 'Vatikanstaten',
        'COUNTRY_VE' => 'Venezuela',
        'COUNTRY_VN' => 'Vietnam',
        'COUNTRY_VG' => 'De britiske jomfruøyene',
        'COUNTRY_VI' => 'De amerikanske Jomfruøyene',
        'COUNTRY_WF' => 'Wallis og Futuna',
        'COUNTRY_EH' => 'Vest-Sahara',
        'COUNTRY_YE' => 'Jemen',
        'COUNTRY_ZM' => 'Zambia',
        'COUNTRY_ZW' => 'Zimbabwe',
        'ERROR_LOG' => 'Feillogg',
        'CANNOT_READ_ERROR_LOG' => 'Kan ikke lese feillogg',
        'CANNOT_OPEN_ERROR_LOG' => 'Kan ikke åpne feillogg',
        'CANNOT_SCAN_ERROR_LOG' => 'Kan ikke skanne feillogg',
        'MODELS_RESET' => 'Modellene er tilbakestilt:',
        'NO_MODELS_RESET' => 'Ingen modeller er tilbakestilt.',
        'NO_FEED_TO_DISPLAY' => 'På nåværende tidspunkt viser du ingen elementer.',
        'BOX_WILL_NOT_SHOW_FEED' => 'Denne boksen vises ikke for andre personer, med mindre du merker minst ett element.',
        'CLICK_EDIT_TO_SPECIFY_FEED' => 'Klikk Edit for å angi RSS for denne boksen.',
        'PROBLEM_OCCURRED_RETRIEVING_FEED' => 'Det oppsto et problem under henting av dette RSS-en.',
        'MORE_ELLIPSIS' => 'Mer...',
        'RSS' => 'RSS',
        'WE_ARE_SORRY_SITE_HAS_ISSUE' => 'Beklager, det er et problem på denne nettsiden.',
        'PLEASE_TRY_REFRESHING' => 'Prøv å oppdatere siden om 30 sekunder, eller <a %s>meld fra</a> hvis du får denne meldingen på nytt.',
        'NO_DISCUSSIONS_TAGGED_X' => 'Det er ingen diskusjoner merket "%1$s".',
        'PAGE_TITLE_COLON' => 'Sidetittel:',
        'PAGE_CONTENT' => 'Innhold:',
        'CREATE_PAGE' => 'Opprett side',
        'CREATE_NEW_PAGE' => 'Opprett en ny side',
        'YOUR_COMMENT' => 'Din kommentar',
        'ADD_YOUR_COMMENT' => 'Legg til din kommentar',
        'DELETE_PAGE' => 'Slett denne siden',
        'DELETE_THIS_PAGE_Q' => 'Vil du slette denne siden?',
        'ARE_YOU_SURE_DELETE_THIS_PAGE' => 'Er du sikker på at du vil slette denne siden (inkludert alle kommentarer)?  Dette kan ta et par minutter.',
        'SEARCH_PAGES' => 'Søk gjennom sider',
        'ALL_PAGES' => 'Alle sider',
        'SUBSCRIBE_TO_PAGES' => 'Abonner på disse sidene',
        'NOBODY_HAS_ADDED_PAGES' => 'Ingen har lagt til noen sider ennå!',
        'ADD_PAGES_CALL_TO_ACTION' => 'Opprett en side for å komme i gang.',
        'CREATE_A_PAGE' => 'Opprett en side',
        'PLEASE_ENTER_PAGE_CONTENT' => 'Legg inn sidens innhold',
        'SEARCH_RESULTS_FOR_X' => 'Søkeresultater for <em>%s</em>',
        'EDIT_YOUR_PAGE' => 'Rediger siden din',
        'UPDATE_PAGE' => 'Oppdater side',
        'CLOSE_DISCUSSION' => 'Avslutt diskusjon',
        'REOPEN_DISCUSSION' => 'Åpne diskusjon på nytt',
        'CLOSING_DISCUSSION_PREVENTS' => 'Avslutter du en diskusjon, er det ikke anledning til å svare mer.',
        'NO_DISCUSSION_TO_DISPLAY' => 'På nåværende tidspunkt viser du ingen diskusjoner.',
        'BOX_WILL_NOT_SHOW_DISCUSSION' => 'Denne boksen vises ikke for andre personer, med mindre du merker minst én diskusjon.',
        'NEWEST_DISCUSSIONS' => 'Nyeste diskusjoner',
        'LATEST_REPLIES' => 'Siste svar',
        'REPLIES_CLOSED_FOR_DISCUSSION' => 'Diskusjonen er stengt for flere svar.',
        'SORRY_DISCUSSION_CLOSED' => 'Beklager, men denne diskusjonen er nettopp avsluttet.',
        'MOST_REPLIES' => 'Flest svar',
        'OWNER_DISCUSSIONS_ONLY' => 'Bare diskusjoner for opprettere',
        'MY_DISCUSSIONS_ONLY' => 'Bare mine diskusjoner',
        'DISCUSSION_DELETED' => 'Diskusjon er slettet',
        'DISCUSSION_HAS_BEEN_DELETED' => 'Denne diskusjonen er ikke lenger tilgjengelig.',
        'REPLY_DELETED' => 'Svar er slettet',
        'REPLY_HAS_BEEN_DELETED' => 'Dette svaret er slettet.  <a %s>Gå tilbake til diskusjonen. </a>',
        'VIEW_ALL_DISCUSSIONS' => 'Vis alle diskusjoner',
        'ADD_CATEGORIES' => 'Legg til kategorier',
        'CATEGORY' => 'Kategori:',
        'NO_DISCUSSIONS_IN_CATEGORY' => 'Det er ingen diskusjoner i denne kategorien ennå.',
        'ADD_MANAGE_CATEGORIES' => 'Legg til/administrer kategorier',
        'VIEW_ALL_N_CATEGORIES' => 'Vis alle %s-kategorier',
        'UNTITLED_CATEGORY' => 'Kategori uten navn',
        'SAMPLE_TITLE' => 'Eksempeltittel',
        'UNCATEGORIZED' => 'Ikke-kategorisert',
        'EXISTING_DISCUSSIONS' => 'Nåværende diskusjoner som ikke er tilordnet en kategori.',
        'YOU_HAVE_NOT_ADDED_CATEGORIES' => 'Foreløpig er det ingen kategorier.  Legg til en kategori for å komme i gang!',
        'ADD_A_CATEGORY' => 'Legg til en kategori',
        'ADD_ANOTHER_CATEGORY' => 'Legg til en ny kategori',
        'MANAGE_CATEGORIES' => 'Administrer kategorier',
        'CATEGORY_TITLE' => 'Kategoritittel',
        'ALLOW_MEMBERS_TO_START_DISCUSSIONS' => 'Tillat medlemmer å starte diskusjoner i denne kategorien',
        'ONLY_I_CAN_START_DISCUSSIONS' => 'Det er bare jeg som kan starte diskusjoner i denne kategorien',
        'ALLOW_MEMBERS_TO_REPLY' => 'Tillat medlemmer å svare',
        'SUGGESTIONS' => 'Forslag:',
        'TRY_DIFFERENT_KEYWORDS' => 'Prøv andre eller mer generelle søkeord',
        'VIEW_DISCUSSIONS_OR_START_DISCUSSION' => '<a %s>Vis alle diskusjoner</a> eller <a %s>Start en ny diskusjon</a>',
        'MAKE_SURE_WORDS_SPELLED' => 'Kontroller at alle ord er riktig stavet.',
        'REPLY_WAS_DELETED' => 'Dette svaret ble slettet.',
        'TAGS_X' => '<strong>Merker:</strong> %s',
        'SEND_PRIVATE_MESSAGE' => 'Send privat melding',
        'PERMALINK_TO_REPLY' => 'Permalink til dette svaret',
        'PERMALINK' => ' Permalink  ',
        'WE_COULD_NOT_FIND_ANY_DISCUSSIONS' => 'Beklager - vi fant ingen diskusjoner som passet til søkekriteriet ditt.',
        'DISCUSSIONS_MATCHING_X' => 'Diskusjoner som passer til <em>\'%s\'</em>',
        'SEARCH_DISCUSSIONS' => 'Søk i diskusjoner',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS_2' => 'Du har ikke lagt til noen diskusjoner ennå!',
        'ADD_DISCUSSIONS_AND_SHARE' => 'Legg til diskusjoner og del dem med venner, familie og resten av verden!',
        'DISCUSSION' => 'Diskusjon',
        'DISCUSSIONS' => 'Diskusjoner',
        'KEEP_PAGE_OPEN_FORUM' => 'Behold denne siden åpen, slik at vi kan fullføre opplastingen av filene dine til forumet.',
        'MEANWHILE_FEEL_FREE_FORUM' => 'I mellomtiden kan du godt <a %s>åpne et nytt nettleservindu</a> og fortsette å bruke %s.',
        'START_A_NEW_DISCUSSION' => 'Start en ny diskusjon',
        'DISCUSSION_TITLE' => 'Tittel på diskusjon:',
        'FIRST_POST' => 'Innlegg:',
        'UPLOAD_FILES' => 'Legg ved fil(er):',
        'START_DISCUSSION' => 'Start diskusjon',
        'EDIT_DISCUSSION' => 'Rediger diskusjon',
        'START_A_DISCUSSION' => 'Start en diskusjon',
        'ALL_DISCUSSIONS' => 'Forum hjem',
        'CONTRIBUTORS' => 'Bidragsytere',
        'MY_DISCUSSIONS' => 'Mine diskusjoner',
        'READ_MORE' => 'Les mer',
        'STARTED_T_BY' => 'Startet <strong>%s</strong> av:',
        'ADDED_BY_X_T' => 'Lagt til av %s %s',
        'STARTED_BY_X_T' => 'Startet av %s %s',
        'REPLY_BY_X_T' => 'Svar innen <strong>%s</strong> %s',
        'STARTED_BY_X_LAST_REPLY_LINK_BY_X_T' => 'Startet av %s.  Siste <a %s>svar</a> fra %s %s.',
        'STARTED_DISCUSSION_LAST_REPLY_LINK_BY_X_T' => '<strong>Startet denne diskusjonen. </strong> Siste <a %s>svar</a> innen %s %s.',
        'STARTED_DISCUSSION_T' => '<strong>Startet denne diskusjonen</strong> %s',
        'ADDED_REPLY_T' => '<strong>La til et svar</strong> %s',
        'ADDED_POST_T' => '<strong>La til et innlegg</strong> %s',
        'STARTED_BY_X_ON' => 'Startet av %s den %s',
        'STARTED_DISCUSSION_ON' => '<strong>Startet denne diskusjonen</strong> %s',
        'STARTED_ON' => '<strong>Startet</strong> %s',
        'ADDED_REPLY_ON' => '<strong>La til et svar</strong> %s',
        'ADDED_POST_ON' => '<strong>La til et innlegg</strong> %s',
        'XS_DISCUSSIONS' => '%ss diskusjoner',
        'XS_DISCUSSIONS_LOWERCASE' => '%ss diskusjoner',
        'VIEW_XS_DISCUSSIONS' => 'Vis %ss diskusjoner',
        'VIEW_YOUR_DISCUSSIONS' => 'Vis dine diskusjoner',
        'TAGGED_X' => 'Merket: %s',
        'SUBSCRIBE_TO_DISCUSSIONS' => 'Abonner på disse diskusjonene',
        'SUBSCRIBE_TO_DISCUSSION' => 'Abonner på denne diskusjonen',
        'SUBSCRIBE_TO_XS_DISCUSSIONS' => 'Abonner på %ss diskusjoner',
        'ALL_DISCUSSIONS_TAGGED_X' => 'Alle diskusjoner merket <em>\'%s\'</em>',
        'SUBSCRIBE_TO_DISCUSSIONS_TAGGED_X' => 'Abonner på diskusjoner merket \'%s\'',
        'N_KB' => '%s KB',
        'N_MB' => '%s MB',
        'UPLOADING_FILES' => 'Laster opp filer',
        'ATTACHMENTS' => 'Vedlegg',
        'YOUR_POST' => 'Ditt innlegg:',
        'YOUR_REPLY' => 'Ditt svar:',
        'WOULD_YOU_LIKE_TO_UPLOAD_FILES' => 'Vil du laste opp filer?',
        'ADD_YOUR_REPLY' => 'Legg til svaret ditt',
        'REPLIES_TO_THIS_DISCUSSION' => 'Svar til denne diskusjonen',
        'POSTED_BY_X_ON' => 'Lagt inn av %s %s',
        'PLEASE_ENTER_TITLE' => 'Legg inn en tittel på diskusjonen',
        'PLEASE_ENTER_FIRST_POST' => 'Skriv det første innlegget i diskusjonen.',
        'REPLY_TO_THIS' => 'Svar på dette',
        'DELETE_ATTACHMENT' => 'Slett vedlegg',
        'DELETE_ATTACHMENT_Q' => 'Vil du slette dette vedlegget?',
        'DELETE_REPLY' => 'Slett svar',
        'DELETE_THIS_DISCUSSION_Q' => 'Vil du slette denne diskusjonen?',
        'ARE_YOU_SURE_DELETE_THIS_DISCUSSION' => 'Er du sikker på at du vil slette denne diskusjonen (inkludert alle svar)?  Dette kan ta et par minutter.',
        'DELETE_DISCUSSION' => 'Slett diskusjon',
        'NOBODY_HAS_ADDED_DISCUSSIONS' => 'Ingen har lagt til noen diskusjoner ennå.',
        'NOBODY_HAS_ADDED_DISCUSSIONS_ADD' => 'Ingen har lagt til noen diskusjoner ennå!  Legg til en diskusjon for å komme i gang.',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS' => 'Du har ikke lagt til noen diskusjoner ennå.  Legg til en diskusjon for å komme i gang!',
        'YOU_HAVE_NOT_STARTED_DISCUSSIONS' => 'Du har ikke startet noen diskusjoner ennå.',
        'YOU_HAVE_NOT_ADDED_TO_DISCUSSIONS' => 'Du har ikke bidratt til noen diskusjoner ennå.',
        'X_HAS_NOT_ADDED_DISCUSSIONS' => '%s har ikke lagt til noen diskusjoner ennå.',
        'X_HAS_NOT_STARTED_DISCUSSIONS' => '%s har ikke startet noen diskusjoner ennå.',
        'X_HAS_NOT_ADDED_TO_DISCUSSIONS' => '%s har ikke bidratt til noen diskusjoner ennå.',
        'VIEW_DISCUSSIONS' => 'Vis diskusjoner',
        'VIEW_ALL_PEOPLE_ON_X' => 'Vis alle personer på %s',
        'THERE_ARE_NO_DISCUSSIONS' => 'Foreløpig har ditt sosiale nettverk ingen diskusjoner.',
        'GROUP_HAS_NO_DISCUSSIONS' => 'Denne gruppen har ingen diskusjoner ennå.',
        'VIEW_DISCUSSIONS_IN_GROUP_FORUM' => 'Vis diskusjoner i <a %s>%s-forumet</a>!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT_ADD' => 'Det er ingen diskusjoner merket "%1$s".  Sjekk ut <a %2$s>bilder merket "%1$s"</a> eller <a %3$s>videoer merket "%1$s"</a>.  Du kan også legge til og merke dine egne diskusjoner!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT' => 'Det er ingen diskusjoner merket "%1$s".  Sjekk ut <a %2$s>bilder merket "%1$s"</a> eller <a %3$s>videoer merket "%1$s"</a>.',
        'THIS_BOX_WILL_NOT_SHOW_DISCUSSIONS' => 'Denne boksen vises ikke for andre før det er diskusjoner som kan vises.  Hvorfor ikke starte en?',
        'DISCUSSIONS_I_STARTED' => 'Diskusjoner jeg har startet',
        'DISCUSSIONS_X_STARTED' => 'Diskusjoner %s har startet',
        'DISCUSSIONS_I_REPLIED_TO' => 'Diskusjoner jeg har svart på',
        'DISCUSSIONS_X_REPLIED_TO' => 'Diskusjoner %s har svart på',
        'PLEASE_WRITE_SOMETHING_FOR_POST' => 'Skriv inn noe for innlegget ditt.',
        'PLEASE_WRITE_SOMETHING_FOR_REPLY' => 'Skriv inn noe for svaret ditt.',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION_X' => 'Det er en ny kommentar til diskusjonen ”%s” om %s',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION' => 'Det er en ny kommentar til én av diskusjonene om %s',
        'SOMEBODY_COMMENTED_DISCUSSION_ADDED_TO_X' => 'noen har kommentert en diskusjon du startet den %s',
        'ABOUT_YOUR_DISCUSSION' => 'Om diskusjonen din',
        'ABOUT_THIS_DISCUSSION' => 'Om denne diskusjonen',
        'USER_REPLIED_TO_A_DISCUSSION_ON_Y' => '%s svarte på en diskusjon om %s',
        'USER_REPLIED_TO_DISCUSSION_TITLE_ON_APPNAME' => '%s svarte på diskusjonen "%s" om %s',
        'PROBLEM_WITH_ICON' => 'Det er problemer med ikonfilen',
        'GROUP_ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Gruppeadministratorer har lignende styringsnivå som gruppeoppretteren.',
        'CREATE_NEW_GROUP' => 'Opprett ny gruppe',
        'CREATE_A_NEW_GROUP' => 'Opprett en ny gruppe',
        'CREATE_A_GROUP' => 'Opprett en gruppe',
        'VIEW_GROUPS' => 'Vis grupper',
        'CREATE_GROUP' => 'Opprett gruppe',
        'PLEASE_ENTER_NAME_FOR_GROUP' => 'Velg et navn på gruppen din.',
        'PLEASE_ENTER_URL_FOR_GROUP' => 'Velg en nettadresse for gruppen din.',
        'URL_CAN_CONTAIN_ONLY_LETTERS' => 'Nettadressen kan kun inneholde bokstaver og tall (ingen mellomrom).',
        'NAME_TAKEN' => 'Vi beklager – dette navnet er allerede i bruk.  Vennligst velg et annet navn.',
        'URL_TAKEN' => 'Vi beklager – denne nettadressen er allerede i bruk.  Vennligst velg en annen nettadresse.',
        'GROUP_INFORMATION' => 'Gruppeinformasjon',
        'EXTERNAL_WEBSITE' => 'Eksternnettside',
        'DO_YOU_HAVE_EXISTING_WEBSITE' => 'Har du en gruppenettside et annet sted?',
        'URL' => 'URL-adresse',
        'GROUPS' => 'Grupper',
        'SEARCH_GROUPS' => 'Søk blant grupper',
        'NOBODY_HAS_CREATED_GROUPS' => 'Ingen har opprettet noen grupper ennå.',
        'NOBODY_HAS_CREATED_GROUPS_ADD' => 'Ingen har opprettet noen grupper ennå!  Opprett en gruppe for å komme i gang.',
        'MY_GROUPS' => 'Mine grupper',
        'FEATURED_GROUPS' => 'Fremhevede grupper',
        'YOU_CAN_CREATE_GROUP' => 'Du kan <a %s>opprette en ny gruppe </a> om %s!',
        'GROUP_FORUM' => '%sforum',
        'USER_CREATED_GROUP' => '%s opprettet denne gruppen om %s.',
        'GROUP_MEMBERS_COUNT' => '%s Medlemmer (%d)',
        'WE_ARE_SORRY_NOT_ALLOWED_JOIN_GROUP' => 'Beklager, du har ikke lov til å bli med i denne gruppen.',
        'JOIN_GROUP_NOW' => 'Bli med i %s nå!',
        'USER_HAS_INVITED_YOU_TO_JOIN_GROUP' => '%s har invitert deg til å bli med i %s',
        'DECLINE' => 'Avslå',
        'WELCOME_TO_GROUP' => 'Velkommen til %s',
        'YOU_CAN_PARTICIPATE_IN_GROUP' => 'Du kan nå delta i %s-forumet.',
        'SEND_MESSAGE_TO_GROUP' => 'Send melding til gruppen',
        'LEAVE_THIS_GROUP' => 'Utmelding av gruppe',
        'EDIT_GROUP_INFO' => 'Rediger informasjonen til denne gruppen',
        'EDIT_GROUP_INFORMATION' => 'Rediger gruppeinformasjon',
        'MANAGE_GROUP_MEMBERS' => 'Administrer gruppemedlemmer',
        'GROUP_HAS_NO_MEMBERS' => 'Denne gruppen har ingen medlemmer ennå!',
        'GROUP_HAS_NO_MEMBERS_THAT_MATCH' => 'Denne gruppen har ingen medlemmer som passer til søkekriteriet ditt.',
        'USERS_GROUPS' => '%ss grupper',
        'YOU_HAVE_NOT_CREATED_GROUPS' => 'Du har ikke opprettet noen grupper ennå.',
        'USER_HAS_NOT_CREATED_GROUPS' => '%s har ikke opprettet noen grupper ennå.',
        'THERE_ARE_NO_FEATURED_GROUPS' => 'Det vises ingen fremhevede grupper i det sosiale nettverket ditt.',
        'START_FEATURING_GROUPS' => 'Begynn å fremheve grupper der du ser alternativet Fremhev.  <a %s>Klikk her</a> hvis du vil vite mer om fremheving.',
        'NO_GROUPS_TO_DISPLAY' => 'På nåværende tidspunkt viser du ingen grupper.',
        'BOX_WILL_NOT_SHOW_GROUPS' => 'Denne boksen vises ikke for andre personer, med mindre du merker minst én gruppe.',
        'YOU_HAVE_NOT_CREATED_GROUPS_2' => 'Du har ikke opprettet noen grupper ennå!',
        'CREATE_GROUPS_AND_SHARE' => 'Opprett grupper og del dem med venner, familie og resten av verden!',
        'THERE_ARE_NO_GROUPS' => 'Foreløpig er det ingen grupper i nettverket ditt.',
        'THIS_BOX_WILL_NOT_SHOW_GROUPS' => 'Denne boksen vises ikke for andre personer før det er grupper som kan vises.  Hvorfor ikke starte en?',
        'GROUPS_MATCHING_SEARCH_TERM' => 'Grupper som passer til <em>\'%s\'</em>',
        'WE_COULD_NOT_FIND_ANY_GROUPS' => 'Beklager - vi fant ingen grupper som passet til søkekriteriet ditt.',
        'VIEW_GROUPS_OR_CREATE_GROUP' => '<a %s>Vis alle grupper</a> eller <a %s>opprett en ny gruppe</a>',
        'VIEW_ALL_GROUPS' => 'Vis alle grupper',
        'DELETE_GROUP' => 'Slett gruppe',
        'DELETE_GROUP_Q' => 'Er du sikker på at du vil slette denne gruppen?',
        'GROUP_INVITATIONS' => 'Gruppeinvitasjoner',
        'YOU_HAVE_BEEN_INVITED_TO_JOIN' => 'Du er invitert til å bli med i:',
        'VISIT' => 'Besøk',
        'WHO_CAN_JOIN_GROUP' => 'Hvem kan bli med i denne gruppen?',
        'PRIVACY_CANNOT_BE_CHANGED' => 'Personvern kan ikke endres etter at gruppen er opprettet.',
        'ONLY_INVITED_PEOPLE' => 'Bare inviterte personer',
        'ALLOW_PEOPLE_TO_REQUEST' => 'Tillat personer å be om en invitasjon',
        'ANYONE_CAN_JOIN_GROUP' => 'Alle kan bli med i denne gruppen',
        'ONLY_INVITED_PEOPLE_CAN_JOIN_GROUP' => 'Bare inviterte personer kan bli med i denne gruppen',
        'WHY_NOT_CREATE_GROUP' => 'Hvorfor ikke <a %s>opprette din egen gruppe</a>?',
        'PLEASE_ENTER_NAME' => 'Legg inn navnet ditt',
        'PLEASE_ENTER_EMAIL_ADDRESS' => 'Legg inn e-postadressen din.',
        'PLEASE_ENTER_PAGE_ADDRESS' => 'Skriv inn en ny sideadresse.',
        'PLEASE_ENTER_PASSWORD' => 'Oppgi passordet ditt.',
        'CREATE_ACCOUNT_OR_SIGN_IN' => '<a %s>Klikk her for å opprette en konto</a>, eller prøv å logge inn igjen nedenfor.',
        'CREATE_ACCOUNT_OR_JOIN' => '<a %s>Klikk her for å opprette en konto</a>, eller prøv å logge inn igjen med Ning-ID-en nedenfor.',
        'CHOOSE_SHORTER_PASSWORD' => 'Velg et kortere passord.',
        'CHOOSE_SHORTER_NAME' => 'Velg et kortere navn.',
        'ENTER_SHORTER_CITY_NAME' => 'Skriv inn et kortere bynavn.',
        'PLEASE_ENTER_PASSWORD_AGAIN' => 'Oppgi passordet ditt på nytt i vinduet ”Skriv inn passord på nytt”.',
        'PLEASE_ENTER_CURRENT_PASSWORD' => 'Oppgi det gjeldende passordet ditt.',
        'PLEASE_ENTER_NEW_PASSWORD' => 'Oppgi ditt nye passord.',
        'PLEASE_ENTER_NEW_PASSWORD_AGAIN' => 'Oppgi ditt nye passord på nytt i vinduet “Bekreft passord”.',
        'CURRENT_PASSWORD' => 'Gjeldende passord',
        'PASSWORDS_DO_NOT_MATCH' => 'De to passordene stemmer ikke overens.',
        'NEW_AND_CONFIRMATION_PASSWORDS' => 'Nytt passord og bekreftet passord samsvarer ikke.',
        'YOUR_REQUEST_HAS_BEEN_SENT_TO_GROUP_CREATOR' => 'Forespørselen er sendt til gruppeoppretteren.',
        'X_IS_NOT_VALID_EMAIL_ADDRESS' => '%s er ikke en gyldig e-postadresse',
        'COME_JOIN_ME_ON_GROUP' => 'Kom å bli med meg på %s!',
        'INVITE_PEOPLE_TO_GROUP' => 'Inviter folk til %s',
        'INVITE_FRIENDS_TO_GROUP' => 'Inviter venner til %s',
        'SEND_INVITATIONS_TO_JOIN_GROUP' => 'Send invitasjoner til andre til å bli med i %s.',
        'GROUPNAME_MEMBERS' => 'Medlemmer i %s',
        'GROUP_CREATOR' => 'Gruppeoppretter',
        'GROUP_ADMINISTRATOR' => 'Gruppeadministrator',
        'DATE_BANNED' => 'Utstengt den',
        'BAN_FROM_GROUP' => 'Steng ute fra gruppe',
        'ARE_YOU_SURE_BAN_MEMBER_FROM_GROUP' => 'Er du sikker på at du vil utstenge det merkede medlemmet/de merkede medlemmene fra gruppen din?  Dette kan ta et par minutter.',
        'ALSO_DELETE_FORUM_POSTINGS' => 'Slett også deres foruminnlegg og svar.',
        'GROUP_WEB_ADDRESS' => 'Gruppens nettadresse',
        'GROUP' => 'Gruppe',
        'BACK_TO_GROUP' => '← Tilbake til %s',
        'USER_BANNED_FROM_GROUP' => '%1$s er utstengt fra denne gruppen.  <a %2$s>Send en melding til %1$s</a>',
        'USER_ALREADY_GROUP_MEMBER' => '%1$s er allerede medlem i denne gruppen.  <a %2$s>Send en melding til %1$s</a>',
        'GROUP_ADMIN_DISCUSSIONS' => 'Diskusjoner for gruppeadministratorer',
        'BACK_TO_NETWORK_GROUPS' => 'Tibake til %sgrupper',
        'MOST_MEMBERS' => 'Flest medlemmer',
        'THIS_SETS_URL_OF_GROUP' => 'Dette stiller inn URL-en til gruppen din:<br />http://%s/<strong>groupwebaddress</strong>',
        'LIKE_WHAT_YOU_SEE' => 'Liker du det du ser på %s?  Bli med nå!',
        'LIKE_WHAT_YOU_SEE_GROUP' => 'Liker du det du ser i %s?  Bli med nå!',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => 'Du har startet gruppen %1$s. Du kan starte en diskusjon i %1$s-forumet eller invitere flere til å bli med.',
        'YOU_ARE_MEMBER_OF_GROUP_AND_CAN_INVITE' => 'Du er nå medlem i %1$s.  Du kan delta i %1$sforumet eller invitere flere til å bli med.',
        'NETWORK_DOES_NOT_HAVE_MUSIC' => 'Dette nettverket har ingen musikk ennå!',
        'PERSON_DOES_NOT_HAVE_MUSIC' => 'Denne personen har ingen musikk ennå.',
        'FIND_MORE_MUSIC_LIKE_THIS' => 'Finn mer musikk som denne på <em>%s</em>',
        'TRACKS' => 'Spor',
        'ADD_MUSIC_TRACKS' => 'Legg til musikk',
        'CHOOSE_MUSIC_TRACKS' => 'Velg sanger du vil legge til',
        'YOU_CAN_ADD_UP_TO_MP3' => 'Du kan legge til opptil 4 MP3-er om gangen.',
        'UPLOAD_TRACKS' => 'Last opp sanger',
        'ADD_TRACKS' => 'Legg til sanger',
        'ENTER_THE_URL_MP3_TO_ADD' => 'Skriv inn URL-adressen for hver MP3-fil du vil legge til:',
        'EACH_MP3_FILE_MAY_BE_UP_TO' => 'Du kan laste opp opptil 100 MP3-filer!  Hver MP3-fil kan ha en størrelse på opptil 20 MB, men mindre filer vil lastes opp raskere.',
        'BE_NICE' => 'Vær hensynsfull',
        'PLEASE_UPLOAD_ONLY_TRACKS' => 'Last bare opp sanger hvis du har tillatelse til å gjøre det fra artisten eller innehaveren av opphavsretten.',
        'PLEASE_LINK_ONLY_TRACKS' => 'Koble bare til musikk som er godkjent for distribuering på Internett.',
        'MORE_WAY_TO_ADD_MUSIC' => 'Flere måter å legge til musikk ...',
        'ELLIP_FROM_ANOTHER_WEBSITE' => '... fra andre nettsider',
        'ADD_MUSIC_FROM_ANY_WEBSITE' => 'Legg til musikk fra hvilket som helst nettside ved å lime inn en lenke til MP3-filen.',
        'KEEP_PAGE_OPEN_MUSIC' => 'Behold denne siden åpen, slik at vi kan fullføre opplastingen av sangene. Du får beskjed når de er godkjent!',
        'MEANWHILE_FEEL_FREE_MUSIC' => 'I mellomtiden kan du godt <a %s>åpne et nytt nettleservindu</a> og fortsette å bruke %s.  Når opplastingen er fullført, kan du legge til titlene og beskrivelsene for sangene i dette vinduet.',
        'TRACKS_EXCEEDED_LIMIT' => 'Sporene overskrider visst grensen på 10 MB per sang.',
        'EDIT_TRACK_INFORMATION' => 'Rediger sanginformasjon',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_1' => 'Legg til en tittel, beskrivelse og annen informasjon for sangene du nettopp lastet opp.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_2' => 'Legg til en tittel, beskrivelse og annen informasjon for denne sangen.',
        'CANCEL_AND_RETURN_TO_PLAYLIST' => '<< Avbryt og gå tilbake til spillelisten',
        'TRACK_TITLE' => 'Sangtittel',
        'TRACK_ARTIST' => 'Artist',
        'TRACK_ALBUM' => ' Album  ',
        'ENABLE_DOWNLOAD_LINK' => 'Aktiver nedlastingslenke',
        'ALLOW_PEOPLE_TO_ADD_TRACK_TO_PROFILE' => 'Tillat folk å sette denne sangen på sine sider',
        'TRACK_ARTWORK' => 'Illustrasjoner',
        'EDIT_PLAYLIST' => 'Rediger spilleliste',
        'DRAG_TO_CHANGE_ORDER_PLAYLIST' => 'Hvis du vil endre rekkefølgen i spillelisten, klikker du sangen og drar den dit du vil spille den av.',
        'ADD_MUSIC_ELLIPSIS' => 'Legg til musikk ...',
        'ELLIPSIS_FROM_YOUR_COMPUTER' => '...fra din datamaskin',
        'UPLOAD_MP3_FROM_YOUR_COMPUTER' => 'Last opp MP3-filer fra datamaskinen.',
        'DELETE_THIS_TRACK_Q' => 'Vil du slette denne sangen?',
        'DELETE_TRACK' => 'Slett sang',
        'ARE_YOU_SURE_DELETE_THIS_TRACK' => 'Er du sikker på at du vil slette denne sangen?',
        'PLAY' => 'spille av',
        'GENRE' => 'Sjanger',
        'YEAR' => 'År',
        'LABEL' => 'Etikett',
        'EXPLICIT_LYRICS' => 'Tekster som ikke egner seg for barn',
        'ARTIST_SITE' => 'Nettside for artist',
        'HOSTING_SITE' => 'Vertsnettside',
        'LABEL_SITE' => 'Etikettplassering',
        'LICENSE' => 'Lisens',
        'SELECT_LICENSE' => '— Select license —',
        'LICENSE_NAME' => 'Lisensnavn',
        'LICENSE_URL' => 'URL-adressen til lisensen',
        'MUSIC' => 'Musikk',
        'ALLOW_PEOPLE_TO_UPLOAD_AND_SHARE_AUDIO' => 'Tillat personer å laste opp og dele lyd',
        'PLAYLIST' => 'Spilleliste',
        'PODCAST' => 'Podkast',
        'MOST_RECENT_TRACKS' => 'Nyest',
        'FEATURED_TRACKS' => 'Presentert',
        'HIGHEST_RATED_TRACKS' => 'Rangert høyest  ',
        'NO_TRACKS_TO_PLAY' => 'Foreløpig er det ingen musikk på nettverket ditt.',
        'BOX_WILL_NOT_SHOW_TRACKS' => 'Dette vinduet vises ikke for andre før det er en sang eller podkast å spille av.  Hvorfor ikke legge til en?',
        'NO_TRACKS_ON_PLAYLIST' => 'Foreløpig er det ingen sanger på denne spillelisten.',
        'PLAYER_WILL_NOT_SHOW_TRACKS' => 'Denne spilleren vises ikke for andre før det er en sang eller podkast å spille av.  Hvorfor ikke legge til en?',
        'NO_FEATURED_TRACKS' => 'Det er ingen fremhevede sanger i nettverket ditt.',
        'START_FEATURING_TRACKS' => 'Begynn å fremheve sanger når du hører en du vil vise på hovedsiden.',
        'VIEW_MUSICPLAYER' => 'Vis musikkspiller',
        'MY_PLAYLIST' => 'Min spilleliste',
        'NETWORK_PLAYLIST' => 'Nettverksspilleliste',
        'COPYRIGHT' => '©Med enerett',
        'CC_BY_X' => 'Creative Commons Attribution %s',
        'CC_BY_SA_X' => 'Creative Commons Attribution Share Alike %s',
        'CC_BY_ND_X' => 'Creative Commons Attribution No Derivatives %s',
        'CC_BY_NC_X' => 'Creative Commons Attribution Non-commercial %s',
        'CC_BY_NC_SA_X' => 'Creative Commons Attribution Non-commercial Share Alike %s',
        'CC_BY_NC_ND_X' => 'Creative Commons Attribution Non-commercial No Derivatives %s',
        'PUBLICDOMAIN' => 'Offentlig eiendom',
        'FACEBOOK_CONFIRM_DISABLE' => 'Er du sikker?',
        'FACEBOOK_PLAYER_DISABLE' => 'Deaktiver',
        'FACEBOOK_MUSIC_PLAYER_TITLE' => 'Musikkspiller',
        'FACEBOOK_MUSIC_PLAYER_DESC' => 'Tillat hvem som helst å legge til et program på deres Facebook-profilsider som spiller av ditt musikkutvalg.',
        'FACEBOOK_MUSIC_BUTTON' => 'Opprett musikkprogram &raquo;',
        'FACEBOOK_MUSIC_PLAYER_ENABLED' => 'Musikkspilleren på Facebook er allerede aktivert.',
        'FACEBOOK_VIDEO_PLAYER_TITLE' => 'Videospiller',
        'FACEBOOK_VIDEO_PLAYER_DESC' => 'Tillat hvem som helst å legge til sine Facebook-profilsider som spiller av video fra nettverket ditt.',
        'FACEBOOK_VIDEO_BUTTON' => 'Opprett videoprogram &raquo;',
        'FACEBOOK_VIDEO_PLAYER_ENABLED' => 'Videospilleren på Facebook er allerede aktivert.',
        'FACEBOOK_SLIDESHOW_PLAYER_TITLE' => 'Lysbildeshow',
        'FACEBOOK_SLIDESHOW_PLAYER_DESC' => 'Tillat hvem som helst å legge til et program på sine Facebook-profilsider som spiller av lysbildeshow fra nettverket ditt.',
        'FACEBOOK_SLIDESHOW_BUTTON' => 'Opprett program for lysbildeshow &raquo;',
        'FACEBOOK_SLIDESHOW_PLAYER_ENABLED' => 'Lysbildeshowet på Facebook er allerede aktivert.',
        'FACEBOOK_PLATFORM_LOGO' => 'Logo for Facebook-plattform',
        'FACEBOOK_QUICK_INTRO_1' => 'Facebook, en populær sosial nettverksside, gjør det mulig for tredjeparts-utviklere å lage programmer som kan legges til på Facebook-medlemmers profilsider.  I tillegg til å gi ekstra funksjonalitet for profilsiden, kan disse programmene brukes til å sende Facebook-brukere til andre steder på internett.',
        'FACEBOOK_QUICK_INTRO_2' => 'Med Ning behøver du ikke å være en utvikler for å reklamere for ditt sosiale nettverk på Facebook.  Vi har gjort alt grovarbeidet, og nettverket leveres ferdigbygd med integrert Facebook-program.  Det er bare å velge blant alternativene nedenfor, og ditt sosiale nettverk vil bli integrert med Facebook i løpet av sekunder.',
        'FACEBOOK_ADD_DEVELOPER_BUTTON' => 'Knappen Legg til utvikler',
        'FACEBOOK_SETUP_NEW_APP_BUTTON' => 'Knappen Sett opp nytt program',
        'FACEBOOK_YOUR_APPLICATIONS' => 'Dine Facebook-programmer',
        'FACEBOOK_EMBEDDING' => 'Facebook-reklame',
        'FACEBOOK_SETUP' => 'Facebook-reklame',
        'FACEBOOK_PROMOTING' => 'Reklamere for programmer på Facebook',
        'FACEBOOK_VIEW_APP' => 'Vis program',
        'FACEBOOK_ADD_THE' => 'Legg til',
        'FACEBOOK_RECENT' => 'Nyest',
        'FACEBOOK_RECENTLY_FEATURED' => 'Sist fremhevet',
        'FACEBOOK_RECENTLY_ADDED' => 'Sist lagt til',
        'FACEBOOK_PROMOTED' => 'Presentert',
        'FACEBOOK_RATED' => 'Rangert høyest  ',
        'FACEBOOK_POPULAR' => 'Populær',
        'FACEBOOK_MUSIC_WIDGET' => 'Musikkinnretning',
        'FACEBOOK_VIDEO_WIDGET' => 'Videoinnretning',
        'FACEBOOK_PHOTO_WIDGET' => 'Bildeinnretning',
        'FACEBOOK_INSTR_FIRST_STEPS' => 'Første trinn',
        'FACEBOOK_INSTR_CLICK_HERE_TO_GO_TO_FACEBOOK' => 'Klikk her for å gå til Facebook og begynne å lage programmet ditt.',
        'FACEBOOK_INSTR_OPEN_FACEBOOK_IN_NEW_WINDOW' => 'Dette vil åpne Facebook i et nytt vindu.  Hvis du ikke er logget på Facebook allerede, må du logge på nå.',
        'FACEBOOK_INSTR_FIRST_STEPS_1' => 'Hvis du ikke har laget et program på Facebook, blir du bedt om å legge til Facebooks utviklerprogram.  Etter at dette er gjort, vises meldingen "Du har ingen programmer. " Klikk <strong>Lag ett</strong>.',
        'FACEBOOK_INSTR_FIRST_STEPS_2' => 'Hvis du allerede har laget et program på Facebook, vil du komme til Facebooks utviklerprogram.  Klikk knappen <strong>Sett opp nytt program</strong>.',
        'FACEBOOK_INSTR_FIRST_STEPS_NEXT' => 'Deretter: anvisninger om hvordan du setter opp %s-programmet, slik at det fungerer på Facebook.',
        'FACEBOOK_INSTR_SETUP' => 'Oppsettanvisninger',
        'FACEBOOK_INSTR_SETUP_1' => 'Flott!  Nå må du oppgi detaljene.  Facebook må ha litt grunnleggende informasjon for å komme i gang med programmet.  Det er bare å følge trinnene nedenfor.',
        'FACEBOOK_INSTR_SETUP_REQ_FIELDS' => 'Obligatoriske felt',
        'FACEBOOK_INSTR_SETUP_2' => 'Velg et <strong>Programnavn</strong>.',
        'FACEBOOK_INSTR_SETUP_3' => 'Merk av for å angi at du har lest dokumentet om Facebook-betingelser.',
        'FACEBOOK_INSTR_SETUP_4' => 'Åpne delen <em>Obligatoriske felt</em>.',
        'FACEBOOK_INSTR_SETUP_BASE_OPT' => 'Grunnleggende alternativer',
        'FACEBOOK_INSTR_SETUP_5' => 'Skriv inn e-postadressen din i feltet <strong>E-post for støtte</strong>.',
        'FACEBOOK_INSTR_SETUP_6' => 'Lim inn følgende nettadresse i feltet <strong>“Callback” URL-adresse</strong>',
        'FACEBOOK_INSTR_SETUP_7_EXAMPLE_X' => 'Velg en <strong>Canvas Page-URL</strong> (URL for hjemmeside) (for eksempel <em>%s</em>).',
        'FACEBOOK_INSTR_SETUP_8' => 'Merk <strong>Ja</strong> for <em>Kan programmet ditt legges til på Facebook</em>.',
        'FACEBOOK_INSTR_SETUP_INST_OPT' => 'Installasjonsalternativer',
        'FACEBOOK_INSTR_SETUP_APP_DESC' => 'Skriv en <strong>programbeskrivelse</strong>.',
        'FACEBOOK_INSTR_SETUP_9' => 'Lim inn følgende kode i feltet <strong>Standard FBML</strong>:',
        'FACEBOOK_INSTR_SETUP_9B_WIDE' => 'For <strong>bokskolonne for standardprofil</strong>, merker du <strong>bred</strong>.',
        'FACEBOOK_INSTR_SETUP_9B_NARROW' => 'For <strong>bokskolonne for standardprofil</strong>, merker du <strong>smal</strong>.',
        'FACEBOOK_INSTR_SETUP_10' => 'I feltet <strong>Side Nav URL</strong> skriver du inn <em>Canvas Page URL</em> (som opprettet i trinn &#8216; f&#8217;  ovenfor).  Husk å ta med delen http://apps.facebook.com/ av URL-adressen.',
        'FACEBOOK_INSTR_SETUP_11' => 'Skriv tekst for <strong>vedleggshandling</strong>.  Dette er det som vises hvis du sender en melding til noen på Facebook, og du vil ta med ett av programmene dine.  Hvis programmet er et lysbildeshow, kan du legge inn bilder fra nettverksnavn.  Hvis programmet er en videospiller, kan du legge inn videoer fra nettverksnavn.',
        'FACEBOOK_INSTR_SETUP_12' => 'Lim inn følgende nettadresse i feltet <strong>“Callback” URL-adresse</strong>',
        'FACEBOOK_INSTR_APPLICATION_SETUP_PAGE' => 'Oppsettsiden for Facebook-program',
        'FACEBOOK_INSTR_SETUP_DONE' => 'Når du er ferdig, klikker du knappen <strong>Send</strong>.',
        'FACEBOOK_INSTR_SETUP_NEXT' => 'Deretter: Hente API-nøkkelen og hemmeligheten.',
        'FACEBOOK_API_INFO_TITLE' => 'API-informasjon for Facebook',
        'FACEBOOK_API_INFO_DESC' => 'Du må skrive inn API-nøkkelen og hemmeligheten samt programmets URL i feltene nedenfor for å kunne fullføre oppsettet.',
        'FACEBOOK_API_INFO_FIND_KEY' => 'Du kan finne API-nøkkelen og hemmeligheten på <a %s>Min programside på Facebook</a> (åpnes i et nytt vindu) under tittelen på programmet du nettopp har laget.',
        'FACEBOOK_API_INFO_MY_APPLICATIONS_PAGE' => 'Min programside (uthevet plassering av API-informasjon)',
        'FACEBOOK_API_INFO_KEY' => 'API-nøkkel',
        'FACEBOOK_API_INFO_SECRET' => 'API-hemmelighet',
        'FACEBOOK_URL_INFO_TITLE' => 'URL-adresse for Facebook-program',
        'FACEBOOK_URL_INFO_DESC' => 'URL-adressen for programmet er den samme som <strong>Canvas Page URL</strong> (URL for hjemmeside) du valgte på forrige side (i trinn &#8216; f&#8217; ).',
        'FACEBOOK_MUSIC_SHOULD_PLAY_FROM' => 'Musikkprogrammer på Facebook bør spille av:',
        'FACEBOOK_VIDEO_SHOULD_PLAY_FROM' => 'Videoprogrammer på Facebook bør spille av videoen som er:',
        'FACEBOOK_PHOTO_SHOULD_PLAY_FROM' => 'Facebook-programmer for lysbildeshow bør vise bilder fra:',
        'FACEBOOK_PROMOTING_ON' => 'Reklamere på Facebook',
        'FACEBOOK_SETUP_INSTR' => 'Oppsettanvisninger',
        'FACEBOOK_API_INFO' => 'API-informasjon',
        'FACEBOOK_DISABLE' => 'Deaktiver dette programmet',
        'FACEBOOK_TO_YOUR_FACEBOOK_PROFILE' => 'til Facebook-profilen din',
        'FACEBOOK_BACK_TO_EMBEDDING' => 'Tilbake til Facebook-reklame',
        'FACEBOOK_EMBEDDING_DESC' => 'Tillat Facebook-brukere å sette nettverkets innretninger og skilt på sine profilsider.',
        'FACEBOOK_PROMOTE' => 'Hvis du vil ha mest mulig valuta for pengene når det gjelder å reklamere for programmet ditt, anbefaler vi at du gjør følgende:  Du får tilgang til alle disse valgene fra Facebook-siden <strong><a %s>Mine programmer</a></strong> (lenken åpnes i nytt vindu).',
        'FACEBOOK_PROMOTE_TITLE_ABOUT_PAGE' => 'Tilby en Om-side',
        'FACEBOOK_PROMOTE_TEXT_ABOUT_PAGE' => 'Fortell Facebook-brukere hva programmet ditt handler om, ved å gi en klar beskrivelse.  Hvis du vil redigere denne informasjonen, klikker du på lenken <strong>Rediger Om-side</strong> ved siden av programmet du modifiserer.',
        'FACEBOOK_PROMOTE_TITLE_SUBMIT' => 'Send programmet til Facebook-katalogen',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_1' => 'Fortell om ditt nye program ved å legge det til i Facebook-katalogen.',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_2' => 'Hvis du vil sende programmet, klikker du på lenken <strong>Send program</strong> ved siden av programmet du modifiserer.  På den følgende siden kan du redigere programbeskrivelsen og legge til en logo for programmet ditt.',
        'FACEBOOK_PROMOTE_TITLE_PROFILE' => 'Legg til programmet i Facebook-profilen din',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_1' => 'Vis frem programmet ved å legge det til på profilsiden i Facebook. Deretter kan du lene deg tilbake og se på at vennene dine gjør det samme.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_2' => 'Det er bare å klikke på lenken <strong>Vis Om-side</strong> ved siden av det programmet du vil legge til i profilen din, og deretter velge knappen Legg til program på neste side.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_3' => 'Programmet ditt befinner seg nå nederst på Facebook-profilsiden din!',
        'FACEBOOK_PROMOTE_MY_APPLICATIONS_PAGE' => 'Siden Mine programmer på Facebook',
        'FACEBOOK_MY_APPS' => 'Mine programmer',
        'FORUM_TAB_TEXT' => 'Forum',
        'VIDEOS_TAB_TEXT' => 'Videoer',
        'PHOTOS_TAB_TEXT' => 'Bilder',
        'GROUPS_TAB_TEXT' => 'Grupper',
        'NO_PHOTOS_TAGGED_X_CHECK' => 'Det er ingen bilder merket "%1$s". Undersøk <a %2$s>diskusjoner merket "%1$s"</a>, <a %4$s>blogginnlegg merket "%1$s"</a> eller <a %3$s>videoer merket "%1$s"</a>. Du kan også legge til og merke dine egne bilder!',
        'EACH_VIDEO_MAY_BE_100MB' => 'Hver video kan ha en størrelse på opptil 100 MB. Vi støtter videoer i filformatene mov, mpg, avi, wmv og 3gp.',
        'I_HAVE_RIGHT_TO_UPLOAD_VIDEO' => 'Jeg har rett til å laste opp denne videoen i henhold til <a %s>Tjenestevilkår</a>.',
        'VIDEO_UPLOADER_REQUIRES_JAVA' => 'Massevideoopplasteren krever en nyere Java-versjon. <strong><a %s>Klikk her for å skaffe Java</a></strong>, eller <strong><a %s>gå tilbake til den enkle opplasteren</a></strong>.',
        'UPLOAD_A_VIDEO_FROM_YOUR_COMPUTER' => 'Last opp en video fra datamaskinen.',
        'HAVE_LOT_OF_VIDEOS' => 'Har du mange videoer du vil dele?',
        'TRY_BULK_VIDEO_UPLOADER' => 'Prøv massevideoopplasteren',
        'VIDEOS_SUCCESSFULLY_UPLOADED' => 'Opplastingen av videoene var vellykket!',
        'VIDEOS_UPLOADED_AWAITING' => 'Videoene er lastet opp og aventer godkjenning fra %ss opphavsmann.',
        'ADD_VIDEOS_OR_PHOTOS_TO_APPNAME' => 'Legg til videoer eller bilder til %s fra telefonen din ved å sende dem til en unik e-postadresse.',
        'GRAB_HTML_EMBED' => 'Ta HTML \'embed\'-koden fra en hvilken som helst populær videoside og legg til denne videoen på dette nettverket.',
        'GOOGLE' => 'Google',
        'YOUTUBE' => 'YouTube',
        'HAVING_PROBLEMS_WITH_VIDEO_UPLOADER' => 'Har du problemer med massevideoopplasteren? <strong><a %s>Gå tilbake til den enkle opplasteren</a></strong>.',
        'ADD_VIDEOS_FROM_YOUTUBE' => 'Legg til videoer fra YouTube eller Google',
        'TAGS_NO_COLON' => 'Koder',
        'NO_VIDEOS_TAGGED_X_CHECK' => 'Det er ingen videoer merket "%1$s". Undersøk <a %2$s>diskusjoner merket "%1$s"</a>, <a %4$s>blogginnlegg merket "%1$s"</a> eller <a %3$s>bilder merket "%1$s"</a>. Du kan også legge til og merke dine egne videoer!',
        'UPLOAD_VIDEOS_FROM' => 'Last opp videoer fra datamaskinen.',
        'YOUR_VIDEO_UPLOAD_TO_X_DID_NOT_COMPLETE_DUE_TO_A_CONVERSION_ERROR' => 'Videoopplastingen på %s ble ikke fullført på grunn av en konverteringsfeil.',
        'TO_HELP_TROUBLESHOOT_PROVIDE_THIS_VIDEO_ID_X' => 'Oppgi følgende video-ID for å få hjelp til feilsøking:  %s',
        'TO_VIEW_THE_VIDEO_VISIT' => 'Hvis du vil se videoen, går du til:',
        'YOUR_VIDEO_X_ON_Y_HAS_A_NEW_COMMENT' => 'Det er lagt til en ny kommentar på videoen "%1$s" på %2$s.',
        'YOUR_VIDEO_ON_X_HAS_A_NEW_COMMENT' => 'Videoen på %s har en ny kommentar.',
        'ADD_VIDEOS_BY_PHONE_OR' => 'Legg til videos via telefon eller e-post',
        'FEATURING_ELLIPSIS' => 'Fremhever...',
        'NOW_FEATURED_ON_MAIN' => 'Nå oppslått på hovedsiden',
        'DONT_FEATURE' => 'Ikke fremhev',
        'UNFEATURING_ELLIPSIS' => 'Fjerner fra hovedsiden...',
        'REMOVED_FROM_MAIN' => 'Fjernet fra hovedsiden',
        'ADDED_EXCLAMATION' => 'Lagt til!',
        'ERROR' => 'Feil',
        'ADDING_ELLIPSIS' => 'Legger til...',
        'TRACK_COULD_NOT_BE_LOADED' => 'Kan ikke laste sangen',
        'INVALID_URL' => 'Ugyldig URL-adresse',
        'NORMAL_PLAYBACK_ON' => 'Normal avspilling: På',
        'REPEAT_PLAYBACK_ON' => 'Gjenta avspilling: På',
        'SHUFFLE_PLAYBACK_ON' => 'Stokk avspilling: På',
        'OPEN_POPUP_WINDOW' => 'Åpne sprettoppvindu',
        'LOADING_PLAYLIST_ELLIPSIS' => 'Laster spilleliste...',
        'EACH_PHOTO_MAY_BE_UP_TO_10MB' => 'Hvert bilde kan ha en størrelse på opptil 10 MB. Vi støtter bilder i filformatene jpg, bmp og png.',
        'I_HAVE_RIGHT_TO_UPLOAD_PHOTOS' => 'Jeg har rett til å laste opp disse bildene i henhold til <a %s>Tjenestevilkår</a>.',
        'PHOTO_UPLOADER_REQUIRES_JAVA' => 'Massebildeopplasteren krever en nyere Java-versjon. <strong><a %s>Klikk her for å skaffe Java</a></strong>, eller <strong><a %s>gå tilbake til den enkle opplasteren</a></strong>.',
        'TRY_BULK_PHOTO_UPLOADER' => 'Prøv massebildeopplasteren',
        'HAVE_LOT_OF_PHOTOS' => 'Har du mange bilder du vil dele?',
        'PHOTOS_SUCCESSFULLY_UPLOADED' => 'Bildene er lastet opp.',
        'PHOTOS_UPLOADED_AWAITING' => 'Bildene er lastet opp og venter på godkjenning fra %ss opphavsmann.',
        'FLICKR' => 'Flickr',
        'ADD_PHOTOS_FROM_FLICKR' => 'Legg til bilder fra Flickr',
        'ADD_PHOTOS_OR_VIDEOS_TO_APPNAME' => 'Legg til bilder eller videoer til %s fra telefonen din ved å sende dem til en unik e-postadresse.',
        'HAVING_PROBLEMS_WITH_PHOTO_UPLOADER' => 'Har du problemer med massebildeopplasteren? <strong><a %s>Gå tilbake til den enkle opplasteren</a></strong>.',
        'UPLOAD_PHOTOS_FROM_YOUR_COMPUTER' => 'Last opp bilder fra datamaskinen',
        'YOUR_PHOTO_X_HAS_A_NEW_COMMENT_ON_Y' => 'Det er lagt til en ny kommentar på bildet "%1$s" på %2$s.',
        'YOUR_PHOTO_HAS_A_NEW_COMMENT_ON_X' => 'Bildet på %s har en ny kommentar.',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y_ELLIPSIS' => 'Du har en ny %1$s som må godkjennes på %2$s...',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y' => 'Du har en ny %1$s som må godkjennes på %2$s.',
        'YOU_HAVE_A_NEW_X_TITLE_TO_APPROVE_ON_Y' => 'Du har en ny %1$s "%2$s" som må godkjennes på %3$s.',
        'TO_APPROVE_THIS_X_VISIT' => 'Hvis du vil godkjenne denne %s, går du til:',
        'YOUR_X_ON_Y_HAS_BEEN_APPROVED_ELLIPSIS' => 'Din %1$s på %2$s har blitt godkjent...',
        'YOUR_TYPE_ON_X_HAS_A_NEW_COMMENT_ELLIPSIS' => '%1$s på %2$s har en ny kommentar...',
        'CLICK_HERE_TO_JOIN' => 'Klikk her for å bli med:',
        'X_WANTS_YOU_TO_CHECK_OUT_Y_ON_Z' => '%1$s vil at du skal undersøke "%2$s" på %3$s!',
        'YOUR_X_HAS_BEEN_APPROVED_ON_Y' => 'Din %s har blitt godkjent for %s.',
        'YOUR_X_Y_HAS_BEEN_APPROVED_ON_Z' => 'Din %1$s "%2$s" er godkjent på %3$s.',
        'TO_VIEW_YOUR_X_VISIT' => 'Hvis du vil se %s, går du til:',
        'TO_VIEW_THIS_X_VISIT' => 'Hvis du vil se denne %s, går du til:',
        'TO_VIEW_IT_VISIT' => 'Hvis du vil se den, går du til:',
        'X_REPORTED_THE_FOLLOWING_ISSUE_ON_Y_ELLIPSIS' => '%1$s har meldt fra om følgende problem på %2$s...',
        'USER_HAS_SENT_YOU_A_MESSAGE_ON_X' => '%1$s har sendt deg en melding på %2$s.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X' => '%1$s har bedt om å bli med i %2$s på %3$s.',
        'TO_APPROVE_OR_DENY_USER_REQUEST' => 'Hvis du vil godkjenne eller avslå %ss forespørsel, går du til:',
        'X_ADDED_A_COMMENT_TO_THE_BLOG_POST_Y_ON_Z' => '%1$s la til en kommentar til blogginnlegget "%2$s" på %3$s.',
        'X_ADDED_A_COMMENT_TO_A_BLOG_POST_ON_Y_ELLIPSIS' => '%1$s la til en kommentar til blogginnlegget på %2$s...',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X' => 'Du har et nytt medlem som må godkjennes på %s.',
        'WELCOME_TO_THE_GROUP_X_ON_Y' => 'Velkommen til gruppen "%1$s" på %2$s',
        'PLEASE_SELECT_A_MEMBER' => 'Velg ett eller flere medlemmer',
        'LOADING_YOUR_FRIENDS' => 'Vi laster vennene dine...',
        'YOUR_MESSAGE_HAS_BEEN_SENT_TITLE_CASE' => 'Meldingen er sendt',
        'TO_SEND_ANOTHER_MESSAGE' => 'Hvis du vil sende en ny melding, skriver du inn teksten nedenfor.',
        'PLEASE_CHOOSE_FRIENDS' => 'Velg noen venner før du sender meldingen.',
        'RESEND_INVITATION' => 'Resend invitasjon',
        'CHOOSE_FRIENDS' => 'Velg venner...',
        'ALL_FRIENDS' => 'All venner',
        'ALL_FRIENDS_ON_APPNAME' => 'Alle venner på %s',
        'SHARE_WITH_FRIENDS' => 'Del med venner',
        'SHARE_THIS_WITH_FRIENDS' => 'Del dette elementet med vennene dine',
        'COMPOSE_MESSAGE' => 'Skriv melding',
        'INVITATION_LINK_ONLY_VISIBLE' => 'Denne invitasjonslenken er bare synlig for nettverksoppretteren og administratorer. Medlemmer som melder seg på med denne lenken, blir automatisk venner med nettverksoppretteren.',
        'WE_ARE_LOADING_ADDRESSES' => 'Vi laster adressene dine...',
        'SELECT_ALL_NONE' => 'Merk Alt/Ingen',
        'INVITE_TO_APPNAME' => 'Inviter til \'%s\'',
        'INVITE_YOUR_FRIENDS_TO_APPNAME' => 'Inviter vennene dine til \'%s\'',
        'ALREADY_MEMBER_OF_NETWORK' => '(Er allerede med i dette nettverket.)',
        'OR_SHARE_THIS_INVITATION_LINK' => 'Eller del denne invitasjonslenken:',
        'CLICK_TO_MAIL' => '<a %s>Klikk her for å sende e-post nå</a>',
        'MESSAGE_HAS_BEEN_SENT' => 'Meldingen er sendt',
        'YOU_CAN_SHARE_THIS' => 'Du kan dele med flere personer nedenfor, eller <a %s>gå tilbake til foregående side</a>.',
        'VCARD_IMPORT_UNAVAILABLE' => 'Beklager, men importtjenesten for vCard er for øyeblikket utilgjengelig.',
        'CSV_IMPORT_UNAVAILABLE' => 'Beklager, men importtjenesten for CSV er for øyeblikket utilgjengelig.',
        'ERROR_OCCURRED' => 'Beklager, med det oppstod en feil.',
        'IMPORT_FAILED' => 'Beklager, men importen mislyktes.',
        'LOGIN_FAILED' => 'Beklager, men påloggingen mislyktes.',
        'UNABLE_TO_FIND_EMAIL' => 'Beklager, men vi finner ikke e-postfeltet.',
        'CANNOT_READ_VCARDS' => 'Beklager, men vi kan ikke lese disse vCard-ene.',
        'SORRY_WE_DO_NOT_SUPPORT' => 'Beklager, men vi støtter ikke webadresseboken for din e-postadresse. Prøv å klikke \'Address Book Application\' (Adressebokprogrammet) nedenfor for å bruke adresser fra datamaskinen.',
        'NO_ADDRESSES_FOUND' => 'Finner ingen adresser',
        'WE_DID_NOT_FIND_ADDRESSES' => 'Finner ingen adresser i adresseboken som ble importert.',
        'WANT_TO_INVITE_MORE_FRIENDS' => 'Vil du invitere flere venner? Importer kontakter fra ditt nett- eller skrivebordsbaserte adressebokprogram.',
        'IMPORT_FROM_WEB_ADDRESS_BOOK' => 'Importer fra nettbasert adressebok',
        'IMPORT_FROM_ADDRESS_BOOK_APPLICATION' => 'Importer fra adressebokprogram',
        'MICROSOFT_OUTLOOK_APPLE_ADDRESS_BOOK' => 'Microsoft Outlook, Apple Adressebok, CSV osv.',
        'PRIVACY_POLICY' => 'Retningslinjer for personvern',
        'APPLY_FOR_MEMBERSHIP_SIGN_IN' => 'Søk om medlemskap nå. Er du allerede medlem? <a %s>Klikk her for å logge på</a>.',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK_ON_Y' => '%1$s gav følgende tilbakemelding på %2$s:',
        'TRACK_STATISTICS' => 'Før statistikk',
        'FEATURED_MEMBERS' => 'Oppførte medlemmer',
        'CHECK_OUT_X_ON_Y_ELLIPSIS' => 'Sjekk ut "%1$s" på %2$s...',
        'CHECK_OUT_THIS_X_ON_Y_ELLIPSIS' => 'Undersøk denne %1$s på %2$s...',
        'SORRY_NO_MEMBERS_MATCHING_X_WERE_FOUND' => 'Beklager, finner ingen medlemmer som samsvarer med "%s".',
        'WHO_CAN_COMMENT_ON_POST' => 'Hvem kan kommentere dette innlegget?',
        'SEND_MESSAGE_TO_FRIENDS' => 'Send melding til venner',
        'PREVIOUS_POST' => '← Tidligere innlegg',
        'NEXT_POST' => 'Neste innlegg →',
        'PREVIOUS_POSTS' => '← Tidligere innlegg',
        'NEXT_POSTS' => 'Neste innlegg →',
        'NO_BLOG_POSTS_TAGGED_X_CHECK' => 'Det er ingen blogginnlegg merket "%1$s". Undersøk <a %2$s>diskusjoner merket "%1$s"</a>, <a %4$s>bilder merket "%1$s"</a> eller <a %3$s>videoer merket "%1$s"</a>. Du kan også legge til og merke dine egne blogginnlegg!',
        'ALL_POSTS_TAGGED_X_FOR_M_Y' => 'Alle innlegg merket <em>\'%s\'</em> for %s %s',
        'ALL_POSTS_TAGGED_X' => 'Alle innlegg merket <em>\'%s\'</em>',
        'MY_BLOG_POSTS_FOR_M_Y' => 'Mine blogginnlegg for %s %s',
        'MY_BLOG_POSTS' => 'Mine blogginnlegg',
        'PICK_VALID_ALL_FRIENDS_NOTIFICATION' => 'Foreta et gyldig valg for varsling om meldinger sendt til alle venner',
        'PRIVACY_CONTENT_CONTROL' => 'Personvern- og innholdskontroll',
        'ENABLE_MUSIC_DOWNLOAD_LINKS' => 'Aktiver nedlastingslenker for musikkspiller',
        'WELCOME_MEMBER_N_OF_APPNAME_INVITE' => 'Velkommen, %1$s! Du er medlem nr. %2$s av %3$s. <a %4$s>Inviter venner nå</a>.',
        'YOU_COMMENTED_ON_PHOTO_TITLE' => 'Du kommenterte bildet <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_PHOTO_TITLE' => '%s kommenterte bildet <a %s>%s</a>',
        'YOU_COMMENTED_ON_VIDEO_TITLE' => 'Du kommenterte videoen <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_VIDEO_TITLE' => '%s kommenterte videoen <a %s>%s</a>',
        'NOTIFY_BLOG_PING_SERVICES' => 'Vil du varsle tredjeparts bloggsporingstjenester når du legger til et nytt innlegg?',
        'YES_NOTIFY_BLOG_SERVICES' => 'Ja -- varsle <a %s>nettoppdateringstjenester</a> når jeg legger til et nytt blogginnlegg',
        'THERE_ARE_NO_FEATURED_MEMBERS' => 'Det vises ingen fremhevede medlemmer i det sosiale nettverket ditt.',
        'START_FEATURING_MEMBERS_CLICK_Y' => 'Begynn å fremheve medlemmer der du ser alternativet Fremhev. <a %s>Klikk her</a> hvis du vil vite mer om fremheving.',
        'THIS_IS_YOUR_PAGE' => 'Dette er din side:',
        'MESSAGES_SENT_TO_ALL_FRIENDS' => 'Meldinger sendt til alle venner',
        'TO_STOP_FOLLOWING_THIS_X_GO_TO' => 'Hvis du vil slutte å følge %s, går du til:',
        'SHOW_ALL' => 'Vis alle',
        'CHOOSE_GADGETS' => 'Velg én av disse fantastiske OpenSocial-gadgetene for å legge til på profilsiden din! Du kan <a %s>vise og klassifisere gadgeter her</a>, eller <a %s>få mer informasjon om OpenSocial her</a>.',
        'GADGETS_UNAVAILABLE' => 'Gadgeter er midlertidig utilgjengelige',
        'APOLOGIES_GADGETS_UNAVAILABLE' => 'Beklager – gadgeter er midlertidig utilgjengelige.',
        'BOX_WILL_NOT_SHOW_GADGET' => 'Denne boksen vises ikke for andre personer, med mindre du velger en gadget.',
        'CLICK_EDIT_TO_SPECIFY_GADGET_OR_VISIT_GADGET_GALLERY' => 'Klikk Rediger for å angi Gadget-URL-en for denne boksen, eller gå til <a %s>Gadget-katalogen</a>.',
        'PROBLEM_OCCURRED_RETRIEVING_GADGET' => 'Det oppstod et problem under henting av dette Gadget-URL-stoffet.',
        'ADD_GADGET_TO_YOUR_PAGE' => 'Legg til gadgeten i profilen din.',
        'GADGETS_BETA' => 'Gadgets (Beta)',
        'TRY_OUT_OPENSOCIAL_GADGETS_WARNING_EXPERIMENTAL' => 'Prøv OpenSocial-gadgeter. Advarsel! Denne funksjonen er på forsøkstadiet.',
        'ADD_TO_MY_PAGE' => 'Legg til min side',
        'GADGETS' => 'Gadgeter',
        'GADGETS_TAB_TEXT' => 'Gadgeter',
        'GADGET' => 'Gadget',
        'GADGETS_IS_IN_BETA' => 'Gadgeter er i beta.',
        'SORRY_GADGET_UNAVAILABLE' => 'Beklager, men denne gadgeten er utilgjengelig. Kontroller at du har den riktige URL-en. Hvis du fremdeles har problemer, <a %s>bes du vennligst si fra</a>.',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_ADD' => 'Det er ingen diskusjoner merket "%1$s". Undersøk <a %2$s>bilder merket "%1$s"</a>, <a %4$s>blogginnlegg merket "%1$s"</a> eller <a %3$s>videoer merket "%1$s"</a>. Du kan også legge til og merke dine egne diskusjoner!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK' => 'Det er ingen diskusjoner merket "%1$s". Undersøk <a %2$s>bilder merket "%1$s"</a>, <a %4$s>blogginnlegg merket "%1$s"</a> eller <a %3$s>videoer merket "%1$s"</a>.',
        'ALREADY_MEMBER_OF_GROUP' => '(Er allerede medlem i denne gruppen)',
        'INVITE_YOUR_FRIENDS_TO_GROUPNAME' => 'Inviter vennene dine til \'%s\'',
        'COME_JOIN_ME_ON_X_ON_Y' => 'Kom å bli med meg på %1$s på %2$s.',
        'COME_JOIN_ME_ON_X_ON_Y_ELLIPSIS' => 'Kom å bli med meg på %1$s på %2$s...',
        'INVITE_TO_GROUP' => 'Inviter til \'%s\'',
        'YOU_CAN_ADD_100_SONGS' => 'Du kan legge til 100 sanger i alt, og hver av dem kan ha en størrelse på 20 MB. Vi støtter sanger i mp3-filformatet.',
        'I_HAVE_RIGHT_TO_UPLOAD_SONGS' => 'Jeg har rett til å laste opp disse sangene i henhold til <a %s>Tjenestevilkår</a>.',
        'MUSIC_UPLOADER_REQUIRES_JAVA' => 'Massemusikkopplasteren krever en nyere Java-versjon. <strong><a %s>Klikk her for å skaffe Java</a></strong>, eller <strong><a %s>gå tilbake til den enkle opplasteren</a></strong>.',
        'HAVE_LOT_OF_MUSIC' => 'Har du mye musikk du vil dele?',
        'TRY_BULK_MUSIC_UPLOADER' => 'Prøv massemusikkopplasteren',
        'SONGS_SUCCESSFULLY_UPLOADED' => 'Sangene er lastet opp.',
        'SORRY_YOU_CAN_ONLY_HAVE_N_TRACKS' => 'Beklager, men du kan bare ha %s sanger på spillelisten. Fjern noen av sangene du har før du legger til flere.',
        'ADD_MUSIC_FROM_WEBSITE' => 'Legg til musikk fra et annet nettsted',
        'HAVING_PROBLEMS_WITH_MUSIC_UPLOADER' => 'Har du problemer med massemusikkopplasteren? <strong><a %s>Gå tilbake til den enkle opplasteren</a></strong>.',
        'UPLOAD_MUSIC_FROM_YOUR_COMPUTER' => 'Last opp musikk fra datamaskinen',
        'ADD_MUSIC' => 'Legg til musikk',
        'FACEBOOK_INSTR_SETUP_APP_PERMISSION' => 'Velg <strong>Brukere</strong> og <strong>Alle sider</strong>.',
    );

    /**
     * If the given widget title is the default English title for the widget,
     * translate it into the current language.
     *
     * @param string $widgetTitle  The title of the widget
     * @return string  A translated title if the title is the English default; otherwise, the title unchanged
     */
    public static function translateDefaultWidgetTitle($widgetTitle) {

        return $widgetTitle;
    }

}