<?php

XG_App::includeFileOnce('/lib/XG_AbstractMessageCatalog.php');

/**
 * Texts for the Dutch (the Netherlands) locale.
 */
class XG_MessageCatalog_nl_NL extends XG_AbstractMessageCatalog {

    /**
     * Returns a localized version of a string. The first argument is the message name, e.g., 'ADD_A_PHOTO'.
     * Subsequent arguments are substitution values (if the message contains sprintf format elements).
     *
     * @param $args array the message name, plus optional substitution values
     * @return string the localized string
     * @see xg_html()
     */
    public static function text($args) {
        $s = $args[0];
        static $a = array();
        if (! $a) {
            $a['N_SECONDS_AGO']['1'] = '1 seconde geleden ';
            $a['N_SECONDS_AGO']['n'] = '%s seconden geleden ';
            $a['N_MINUTES_AGO']['1'] = '1 minuut geleden ';
            $a['N_MINUTES_AGO']['n'] = '%s minuten geleden ';
            $a['N_HOURS_AGO']['1'] = '1 uur geleden ';
            $a['N_HOURS_AGO']['n'] = '%s uur geleden ';
            $a['N_VIDEOS']['1'] = '<strong>1</strong> video ';
            $a['N_VIDEOS']['n'] = '<strong>%s</strong> video\'s ';
            $a['N_VIEWS']['1'] = '1 weergave ';
            $a['N_VIEWS']['n'] = '%s weergaven ';
            $a['N_COMMENTS']['1'] = '<span class="comment-count">1</span> commentaar ';
            $a['N_COMMENTS']['n'] = '<span class="comment-count">%s</span> commentaren ';
            $a['VIDEO_IS_FAVORITE_OF']['1'] = 'Deze video is een <strong>favoriet</strong> van <strong>1 persoon</strong>. ';
            $a['VIDEO_IS_FAVORITE_OF']['n'] = 'Deze video is een <strong>favoriet</strong> van <strong>%s personen</strong>. ';
            $a['Y_ADDED_X_VIDEOS']['1'] = '%2$s heeft een video toegevoegd: ';
            $a['Y_ADDED_X_VIDEOS']['n'] = '%2$s heeft %s video\'s toegevoegd: ';
            $a['YOU_ADDED_X_VIDEOS']['1'] = 'Je hebt een video toegevoegd: ';
            $a['YOU_ADDED_X_VIDEOS']['n'] = 'Je hebt %s video\'s toegevoegd. ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['1'] = 'Er is 1 video op %2$s ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['n'] = 'Er zijn %1$s video\'s op %2$s ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['1'] = 'Er is 1 <a href="%3$s">video</a> op %2$s ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['n'] = 'Er zijn %1$s <a href="%3$s">video\'s</a> op %2$s ';
            $a['N_PHOTOS_FROM_ALBUM']['1'] = '1 foto uit dit album is verwijderd of privé gemaakt en kan dus niet worden weergegeven. ';
            $a['N_PHOTOS_FROM_ALBUM']['n'] = '%s foto\'s uit dit album zijn verwijderd of privé gemaakt en kunnen dus niet worden weergegeven. ';
            $a['N_PHOTOS']['1'] = '<strong>1</strong> foto ';
            $a['N_PHOTOS']['n'] = '<strong>%s</strong> foto\'s ';
            $a['N_PHOTOS_2']['1'] = '1 foto ';
            $a['N_PHOTOS_2']['n'] = '%s foto\'s ';
            $a['AND_X_OTHER_PEOPLE']['1'] = 'en 1 andere persoon ';
            $a['AND_X_OTHER_PEOPLE']['n'] = 'en %s anderen ';
            $a['PROBLEM_UPLOADING_FILES']['1'] = 'Er is een probleem opgetreden bij het uploaden van het volgende bestand: ';
            $a['PROBLEM_UPLOADING_FILES']['n'] = 'Er is een probleem opgetreden bij het uploaden van de volgende bestanden: ';
            $a['PHOTO_IS_FAVORITE_OF']['1'] = 'Deze foto is een <strong>favoriet</strong> van <strong>1 persoon</strong>. ';
            $a['PHOTO_IS_FAVORITE_OF']['n'] = 'Deze foto is een <strong>favoriet</strong> van <strong>%s personen</strong>. ';
            $a['RATING_Y_AFTER_X_VOTES']['1'] = '<strong>Waardering:</strong> %2$s na 1 stem ';
            $a['RATING_Y_AFTER_X_VOTES']['n'] = '<strong>Waardering:</strong> %2$s na %s stemmen ';
            $a['Y_AFTER_X_VOTES']['1'] = '%2$s na 1 stem ';
            $a['Y_AFTER_X_VOTES']['n'] = '%2$s na %s stemmen ';
            $a['N_PEOPLE']['1'] = '1 persoon ';
            $a['N_PEOPLE']['n'] = '%s personen ';
            $a['N_OF_5_STARS']['1'] = '1/5 sterren ';
            $a['N_OF_5_STARS']['n'] = '%s/5 sterren ';
            $a['YOUR_RATING_X_STARS']['1'] = 'Jouw waardering: 1 ster ';
            $a['YOUR_RATING_X_STARS']['n'] = 'Jouw waardering: %s sterren ';
            $a['Y_ADDED_X_PHOTOS']['1'] = '%2$s heeft een foto toegevoegd: ';
            $a['Y_ADDED_X_PHOTOS']['n'] = '%2$s heeft %s foto\'s toegevoegd. ';
            $a['YOU_ADDED_X_PHOTOS']['1'] = 'Je hebt een foto toegevoegd: ';
            $a['YOU_ADDED_X_PHOTOS']['n'] = 'Je hebt %s foto\'s toegevoegd. ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['1'] = 'Er is 1 foto op %2$s ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['n'] = 'Er zijn %1$s foto\'s op %2$s ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['1'] = 'Er is %1$s <a href="%3$s">foto</a> op %2$s ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['n'] = 'Er zijn %1$s <a href="%3$s">foto\'s</a> op %2$s ';
            $a['N_COMMENTS_ON_PAGE']['1'] = '<strong>1</strong> commentaar op je pagina ';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s</strong> Comments on your page';;
            $a['N_BLOG_COMMENTS']['1'] = '<strong>1</strong> weblogcommentaar ';
            $a['N_BLOG_COMMENTS']['n'] = '<strong>%s</strong> weblogcommentaren ';
            $a['N_YEARS_OLD']['1'] = '1 jaar oud ';
            $a['N_YEARS_OLD']['n'] = '%s jaar oud ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['1'] = 'Je hebt 1 verzoek om vriend te worden! ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['n'] = 'Je hebt %s verzoeken om vriend te worden! ';
            $a['COMMENT_WALL_N_COMMENTS']['1'] = 'Prikbord (1 commentaar) ';
            $a['COMMENT_WALL_N_COMMENTS']['n'] = 'Prikbord (%s commentaren) ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['1'] = '1 nieuw lid heeft zich de afgelopen week aangemeld ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['n'] = '%s nieuwe leden hebben zich de afgelopen week aangemeld ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['1'] = '1 <a href="%2$s">nieuw lid</a> heeft zich de afgelopen week aangemeld ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['n'] = '%1$s <a href="%2$s">nieuwe leden</a> hebben zich de afgelopen week aangemeld ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['1'] = 'Er is 1 nieuw lid op %2$s ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['n'] = 'Er zijn %1$s nieuwe leden op %2$s ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['1'] = 'Er is 1 <a href="%3$s">lid</a> op %2$s ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['n'] = 'Er zijn %1$s <a href="%3$s">leden</a> op %2$s ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['1'] = 'Er is 1 weblogbericht op %2$s ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['n'] = 'Er zijn %1$s weblogberichten op %2$s ';
            $a['N_NEW_MEMBERS']['1'] = '<strong>1</strong> nieuw lid ';
            $a['N_NEW_MEMBERS']['n'] = '<strong>%s</strong> nieuwe leden ';
            $a['N_REPLIES']['1'] = '1 antwoord ';
            $a['N_REPLIES']['n'] = '%s antwoorden ';
            $a['N_MINUTES']['1'] = '1 minuut over om je commentaar te bewerken. ';
            $a['N_MINUTES']['n'] = '%s minuten over om je commentaar te bewerken. ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['1'] = 'Er is 1 forumonderwerp op %2$s ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['n'] = 'Er zijn %1$s forumonderwerpen op %2$s ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['1'] = 'Er is 1 <a href="%3$s">forumonderwerp</a> op %2$s ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['n'] = 'Er zijn %1$s <a href="%3$s">forumonderwerpen</a> op %2$s ';
            $a['N_INVITES']['1'] = '%s uitnodiging ';
            $a['N_INVITES']['n'] = '%s uitnodigingen ';
            $a['N_MEMBERS']['1'] = '1 lid ';
            $a['N_MEMBERS']['n'] = '%s leden ';
            $a['N_MEMBERS_PARENTHESIZED']['1'] = '(1 lid) ';
            $a['N_MEMBERS_PARENTHESIZED']['n'] = '(%s leden) ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['1'] = 'Er is 1 groep op %2$s ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['n'] = 'Er zijn %1$s groepen op %2$s ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['1'] = 'Er is %1$s <a href="%3$s">groep</a> op %2$s ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['n'] = 'Er zijn %1$s <a href="%3$s">groepen</a> op %2$s ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['1'] = '1 liedje van deze afspeellijst kan niet worden weergegeven omdat het is verwijderd of niet langer wordt gedeeld. ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['n'] = '%s liedjes van deze afspeellijst kunnen niet worden weergegeven omdat ze zijn verwijderd of niet langer worden gedeeld. ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['1'] = 'Er is een nieuw liedje toegevoegd aan %2$s ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['n'] = 'Er zijn %1$s nieuwe liedjes toegevoegd aan %2$s ';
            $a['Y_ADDED_X_SONGS']['1'] = '%2$s heeft een liedje toegevoegd: ';
            $a['Y_ADDED_X_SONGS']['n'] = '%2$s heeft %s liedjes toegevoegd. ';
            $a['YOU_ADDED_X_SONGS']['1'] = 'Je hebt een liedje toegevoegd: ';
            $a['YOU_ADDED_X_SONGS']['n'] = 'Je hebt %s liedjes toegevoegd. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['1'] = '1 liedje toegevoegd aan deze afspeellijst. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['n'] = '%s liedjes toegevoegd aan deze afspeellijst. ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['1'] = 'Er is 1 liedje op %2$s ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['n'] = 'Er zijn %1$s liedjes op %2$s ';
            $a['N_INVITATIONS_RESENT']['1'] = '1 uitnodiging is opnieuw verzonden. ';
            $a['N_INVITATIONS_RESENT']['n'] = '%s uitnodigingen zijn opnieuw verzonden. ';
            $a['N_COMMENTS_ON_PAGE']['1'] = '<strong>1</strong> profielcommentaar ';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s</strong> profielcommentaren ';
            }
        if ($a[$args[0]]) {
            $args[0] = $a[$args[0]][$args[1]] ? $a[$args[0]][$args[1]] : $a[$args[0]]['n'];
            return @call_user_func_array('sprintf', $args);
        }
        $text = self::$messages[$s];
        if ($text) { $args[0] = $text; }
        return @call_user_func_array('sprintf', $args);
    }

    /**
     * Message names and texts. Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;
     */
    private static $messages = array(
        'BROWSING' => 'Bladeren',
        'MORE_VIDEOS' => 'Meer video\'s',
        'NETWORK_DOES_NOT_HAVE_VIDEOS' => 'Dit netwerk heeft nog geen video\'s.',
        'NETWORK_DOES_NOT_HAVE_FEATURED_VIDEOS' => 'Dit netwerk heeft nog geen video\'s voor op de hoofdpagina.',
        'PERSON_DOES_NOT_HAVE_VIDEOS' => 'Deze persoon heeft nog geen video\'s.',
        'COPY_TO_CLIPBOARD' => 'Kopieer naar het klembord',
        'COPIED_TO_CLIPBOARD' => 'Gekopieerd naar het klembord!',
        'NO_VIDEOS_TO_DISPLAY' => 'Je laat momenteel geen video\'s zien.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_VIDEO' => 'Dit vak is niet zichtbaar vooor anderen zolang je niet minstens een video hebt geselecteerd.',
        'WATERMARK_LOGO' => 'Watermerklogo',
        'CHOOSE_HEADER_OR_WATERMARK' => 'Je kunt een header- of een watermerklogo voor je videospeler kiezen.',
        'CUSTOMIZE_EMBED_INSTRUCTIONS' => 'Het logo wordt boven aan je %s weergegeven. Als je geen logo toevoegt, wordt in plaats daarvan de netwerknaam weergegeven. Het logo moet in de indeling .jpg, .gif of .png zijn. Logo\'s hoger dan 20 worden kleiner gemaakt om ze te laten passen.',
        'CUSTOMIZE_WATERMARK_INSTRUCTIONS' => 'Het watermerklogo wordt boven de hoek rechtsonder van de videoclip weergegeven.',
        'HEADER_LOGO' => 'Headerlogo',
        'WATERMARK' => 'Watermerk',
        'CUSTOMIZE_YOUR_VIDEO_PLAYER' => 'Je videospeler aanpassen!',
        'VIDEO_PLAYER' => 'Videospeler',
        'HEADER' => 'Header',
        'SAVE_CHANGES' => 'Wijzigingen opslaan',
        'THUMBNAIL' => 'Miniatuur',
        'CONVERSION_FAILED' => 'Conversie mislukt',
        'CONVERSION_IN_PROGRESS' => 'Conversie aan de gang',
        'MAP' => 'Kaart',
        'WHAT_IS_THIS' => 'Wat is dit?',
        'EDIT_VIDEO_INFORMATION' => 'Video-informatie bewerken',
        'ALL_VIDEOS' => 'Alle video\'s',
        'VIDEOS_HOME' => 'Video\'s hoofdpagina',
        'MY_VIDEOS' => 'Mijn video\'s',
        'MY_FRIENDS_VIDEOS' => 'Video\'s van mijn vrienden',
        'MY_FAVORITES' => 'Mijn favorieten',
        'XS_FAVORITES' => 'Favorieten van %s',
        'ADD_A_VIDEO' => 'Een video toevoegen',
        'JUST_NOW' => 'Nu net',
        '1_DAY_AGO' => '1 dag geleden',
        'M_J' => 'j M',
        'ME' => 'Ik',
        'X_SAID' => '%s zei...',
        'DELETE_COMMENT' => 'Reactie wissen',
        'YOU_HAVE_NOT_ADDED_VIDEOS' => 'Je hebt nog geen video\'s toegevoegd!',
        'ADD_VIDEOS_AND_SHARE' => 'Video\'s toevoegen en ze delen met je vrienden, familie of de rest van de wereld!',
        'THERE_ARE_NO_VIDEOS' => 'Je netwerk bevat momenteel geen video\'s.',
        'THIS_BOX_WILL_NOT_SHOW' => 'Dit vak wordt voor anderen pas weergegeven als er video\'s te zien zijn. Wil je er niet een toevoegen?',
        'ADD_VIDEOS' => 'Video\'s toevoegen',
        'VIEW_VIDEOS' => 'Video\'s weergeven',
        'YIKES' => 'Jakkie!',
        'A_PROBLEM_SEEMS' => 'Er lijkt iets mis te zijn.',
        'FOR_FURTHER_ASSISTANCE' => '<a %s>Neem contact met ons op</a> voor assistentie.',
        'OR_YOU_CAN_GO' => 'Of je kunt terugkeren naar de <a %s>%s hoofdpagina</a> of een <a %s>ander netwerk van Ning</a> bekijken',
        'TAGS' => 'Tags:',
        'POPULAR_TAGS' => 'Populaire tags',
        'MY_FRIENDS' => 'Mijn vrienden',
        'VIEW_ALL_MY_FRIENDS' => 'Al mijn vrienden weergeven',
        'VIEW_ALL_XS_FRIENDS' => 'Alle vrienden van %s weergeven',
        'WE_COULD_NOT_FIND_ANYONE_MATCHING' => 'Onze excuses - we konden niemand vinden die voldeed aan die zoekcriteria.',
        'VIEW_POPULAR_CONTRIBUTORS' => 'Populaire deelnemers weergeven',
        'POPULAR_CONTRIBUTORS' => 'Populaire deelnemers',
        'VIEW_MORE_CONTRIBUTORS' => 'Meer deelnemers weergeven',
        'ADD_AS_FRIEND' => 'Als vriend toevoegen',
        'SEND_A_MESSAGE' => 'Een bericht sturen',
        'IS_YOUR_FRIEND' => 'Is je vriend',
        'IS_BLOCKED' => 'Is geblokkeerd',
        'SORT_BY' => 'Sorteren op:',
        'CLOSE' => 'Sluiten',
        'USER_COUNT' => '(%d)',
        'NOBODY_HAS_ADDED_VIDEOS' => 'Niemand heeft nog video\'s toegevoegd. Voeg wat video\'s toe om te beginnen.',
        'SEARCH_PEOPLE' => 'Mensen zoeken:',
        'INVITE_YOUR_FRIENDS_TO' => 'Je vrienden uitnodigen bij %s.',
        'INVITE' => 'Uitnodigen',
        'INVITE_TAB_TEXT' => 'Uitnodigen',
        'YOU_HAVE_NOT_ADDED_FRIENDS' => 'Je hebt nog geen vrienden toegevoegd aan %s.',
        'SEARCH_FRIENDS' => 'Vrienden zoeken:',
        'ADD_YOUR_FIRST_VIDEO' => 'Je eerste video toevoegen',
        'USE_HTML_EMBED_CODE' => 'HTML-embed-code gebruiken',
        'UPLOAD_A_VIDEO_FROM' => 'Een video uploaden vanaf je computer:',
        'WE_SUPPORT_MOV' => 'We ondersteunen de bestanden: .mov, .mpg, .mp4, .avi, .3gp en .wmv. Bestanden mogen maximaal 100 MB groot zijn.',
        'NEED_HELP_HERE_ARE' => 'Hulp nodig? Hier vind je instructies voor <a %s>YouTube</a> en <a %s>Google Video</a>.',
        'ADD_TITLE_AND_DESCRIPTION' => 'Een titel en beschrijving toevoegen',
        'DESCRIPTION_COLON' => 'Beschrijving:',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_1' => 'Voeg een titel, beschrijving en andere informatie toe aan de video die je zojuist hebt geupload.',
        'EVERYTHING_IS_OPTIONAL' => 'Alles is optioneel; als je niets wilt toevoegen, klik je gewoon rechts op \'Deze stap overslaan\'.',
        'SKIP_THIS_STEP' => 'Deze stap overslaan',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_2' => 'Voeg een titel, beschrijving en andere informatie toe voor deze video.',
        'CANCEL_AND_RETURN_TO_VIDEO' => 'Annuleren en terugkeren naar de video',
        'TITLE' => 'Titel:',
        'TAGS_ARE_SHORT_DESCRIPTIONS' => 'Tags zijn korte beschrijvingen waarmee je video\'s kunt vinden. Scheid tags van elkaar met komma\'s of plaats tags van meerdere woorden tussen aanhalingstekens, bijvoorbeeld "San Francisco".',
        'WHO_CAN_VIEW_VIDEO' => 'Wie kan deze video bekijken?',
        'MOST_POPULAR' => 'Populairst',
        'HIGHEST_RATED' => 'Hoogste cijfer',
        'MOST_RECENT' => 'Meest recent',
        'MOST_FAVORITED' => 'Vaakst favoriet',
        'MOST_POPULAR_VIDEOS' => 'Populairste video\'s',
        'HIGHEST_RATED_VIDEOS' => 'Video\'s met hoogste cijfer',
        'MOST_RECENT_VIDEOS' => 'Meest recente video\'s',
        'MOST_FAVORITED_VIDEOS' => 'Vaakst favoriete video\'s',
        'ANYONE' => 'Iedereen',
        'JUST_MY_FRIENDS' => 'Alleen mijn vrienden',
        'JUST_ME' => 'Alleen ik',
        'VIEWABLE_BY_FRIENDS' => 'Te bekijken door <strong>vrienden</strong>',
        'PRIVATE_VIDEO' => '<strong>Privé</strong>-video',
        'VIEWABLE_BY_EVERYONE' => 'Te bekijken door <strong>iedereen</strong>',
        'LOCATION' => 'Locatie:',
        'NO_LOCATION' => 'Geen locatie',
        'CLICK_ON_LOCATION' => 'Klik op een locatie op de kaart:',
        'FIND_AN_ADDRESS' => 'Adres zoeken:',
        'LOCATE' => 'Zoek locatie',
        'YOU_CAN_ADD_YOUR_OWN_VIDEO' => 'Je kunt <a %s>je eigen video toevoegen</a> aan %s!',
        'ADD_PLAYER_LOGO_OR_WATERMARK' => 'Een logo of watermerk toevoegen aan de videospeler van je netwerk. <a %s>Stel het nu in!</a>',
        'APPROVE' => 'Goedkeuren',
        'DELETE' => 'Verwijderen',
        'APPLY_TO_VIDEOS_ADDED_BY' => 'Toepassen op alle Video\'s toegevoegd door %s',
        'NO_TITLE' => 'Geen titel',
        'ADDED_BY_STRONG_X' => 'Toegevoegd door <strong>%s</strong>',
        'NO_DESCRIPTION' => 'Geen beschrijving',
        'BY_X' => 'door %s',
        'YOU_HAVE_FINISHED_MODERATING' => 'Je bent klaar met modereren',
        'NO_VIDEOS_AWAITING_APPROVAL' => 'Momenteel zijn er geen Video\'s ter goedkeuring door jou. Als je iets te doen zoekt: kijk eens naar de <a %s>nieuwste video\'s</a>.',
        'NO_ONE_HAS_ADDED_ANY_VIDEOS' => 'Niemand heeft video\'s toegevoegd aan je netwerk. Voeg als eerste een video toe!',
        'ADDED_ON_DATE_BY_X' => '%s toegevoegd door %s.',
        'REMOVE_FROM_FAVORITES' => 'Verwijderen uit Favorieten',
        'REMOVE_VIDEO_FROM_FAVORITES' => 'Deze video verwijderen uit je favorieten?',
        'COLLECTED_BY_X' => 'Verzameld door %s',
        'ADD_FAVORITES' => 'Favorieten toevoegen',
        'YOU_CAN_MARK_VIDEO' => 'Je kunt elke video als favoriet markeren. Klik hiervoor op het pictogram \'Toevoegen aan favorieten\' wanneer je dit ziet op een video.',
        'VIEW_RECENT_VIDEOS' => 'Recente video\'s weergeven',
        'X_HAS_NOT_ADDED_FAVORITES' => '%s heeft nog geen favorieten toegevoegd.',
        'APPROVE_VIDEOS' => 'Video\'s goedkeuren',
        'YOUR_SITE_REQUIRES_YOU' => 'Je hebt gevraagd om foto\'s en video\'s van je  netwerk te modereren voordat ze worden geplaatst. Deze optie kun je wijzigen in het gedeelte<a %s>Privacy en leden</a> van \'Je netwerk beheren\'. Stel hier \'Materiaal modereren\' in op \'Nee\'.',
        'YOUR_SITE_ALLOWS_USERS' => 'Je hebt gevraagd om foto\'s en video\'s van je netwerk niet te modereren voordat ze worden geplaatst. Deze optie kun je wijzigen in het gedeelte<a %s>Privacy en leden</a> van \'Je netwerk beheren\'. Stel hier \'Materiaal modereren\' in op \'Ja\'.',
        'APPROVE_ALL_VIDEOS' => 'Alle video\'s goedkeuren?',
        'ARE_YOU_SURE_APPROVE_ALL_VIDEOS' => 'Weet je zeker dat je alle video\'s wilt goedkeuren? Dat kan enige minuten in beslag nemen.',
        'APPROVING' => 'Bezig met goedkeuren...',
        'APPROVE_ALL' => 'Alles goedkeuren',
        'DELETE_ALL_VIDEOS' => 'Alle video\'s verwijderen?',
        'ARE_YOU_SURE_DELETE_ALL_VIDEOS' => 'Weet je zeker dat je alle niet-goedgekeurde video\'s wilt verwijderen? Dat kan enige minuten duren.',
        'DELETING' => 'Bezig met verwijderen...',
        'DELETE_ALL' => 'Alles verwijderen',
        'XS_VIDEOS' => 'Video\'s van %s',
        'DELETE_ALL_XS_VIDEOS_Q' => 'Alle video\'s van %s verwijderen?',
        'DELETE_ALL_XS_VIDEOS' => 'Alle video\'s van %s verwijderen',
        'ARE_YOU_SURE_DELETE_ALL_XS_VIDEOS' => 'Weet je zeker dat je alle video\'s van %s wilt verwijderen? Dat kan enige minuten duren.',
        'DELETE_THIS_VIDEO_Q' => 'Deze video verwijderen?',
        'ARE_YOU_SURE_DELETE_THIS_VIDEO' => 'Weet je zeker dat je deze video wilt verwijderen? Dat kan enige duren.',
        'YOU_HAVE_NOT_ADDED_VIDEOS_2' => 'Je hebt nog geen video\'s toegevoegd. Voeg wat video\'s toe om te beginnen!',
        'X_HAS_NOT_ADDED_VIDEOS' => '%s heeft nog geen video\'s toegevoegd.',
        'YOUR_FRIENDS_DO_NOT_HAVE_VIDEOS' => 'Je vrienden hebben nog geen video\'s.',
        'ALL_VIDEOS_TAGGED_X' => 'Alle video\'s met de tag \'%s\'',
        'ALL_VIDEOS_TAGGED_X_2' => 'Alle video\'s met de tags <em>\'%s\'</em>',
        'NO_VIDEOS_TAGGED_X_CHECK_OUT' => 'Er zijn geen video\'s met de tag \'%1$s\'. Zoek naar <a %2$s>foto\'s met de tag \'%1$s\'</a>. Of voeg je eigen video\'s met tags toe!',
        'FILES_MUST_BE_100MB' => 'Bestanden mogen maximaal 100 MB groot zijn. We ondersteunen de volgende typen bestanden: .mov, .mpg, .avi, .3gp en .wmv.',
        'NEED_HELP' => 'Hulp nodig?',
        'HERE_ARE_INSTRUCTIONS' => 'Hier zijn de instructies voor <a %s>YouTube</a> en <a %s>Google Video</a>.',
        'PERSON_IN_CHARGE' => 'Degene die de baas is van %s wil je creaties bekijken voordat de hele wereld ze te zien krijgt.',
        'LEAVE_WINDOW_OPEN' => 'Laat dit venster open tot het uploaden voltooid is.',
        'KEEP_PAGE_OPEN' => 'Laat deze pagina open zodat we het uploaden van je video kunnen voltooien. Je krijgt een melding wanneer hij is goedgekeurd!',
        'MEANWHILE_FEEL_FREE' => 'Intussen kun je gewoon <a %s>een nieuw browser-venster openen</a> en verder gaan met %s. Als het uploaden voltooid is, kun je in dit venster een titel en een beschrijving toevoegen aan je video.',
        'VIDEO_IS_WAITING_FOR_APPROVAL' => 'Deze video <strong>wacht op goedkeuring</strong> door de initiatiefnemer van %s.',
        'LOADING' => 'Bezig met laden...',
        'EDIT_VIDEO' => 'Video bewerken',
        'DELETE_VIDEO' => 'Video verwijderen',
        'YOU_NEED_TO_BE_MEMBER' => 'Je moet lid zijn van %s om reacties te kunnen toevoegen!',
        'SIGN_UP_OR_SIGN_IN' => '<a %s>Sluit je aan bij dit netwerk</a>',
        'ADD_A_COMMENT' => 'Een reactie toevoegen',
        'LEAVE_A_COMMENT_FOR_USERNAME' => 'Laat een reactie achter voor %s',
        'MORE' => 'Meer',
        'PREVIOUS' => 'Vorige',
        'NEXT' => 'Volgende',
        'ABOUT_THIS_VIDEO' => 'Over deze video',
        'ABOUT_YOUR_VIDEO' => 'Over deze video',
        'ADDED_ON_DATE_BY' => '<strong>%s</strong> toegevoegd door:',
        'VIEWS' => 'Aantal maal bekeken:',
        'COMMENTS' => 'Reacties',
        'COMMENTS_COLON' => 'Reacties:',
        'LOCATION_OF_VIDEO' => 'Locatie van deze video:',
        'RELATED_VIDEOS' => 'Verwante video\'s',
        'ALL_VIDEOS_TAGGED_X_X' => 'Alle video\'s met de tag %s (%s)',
        'XS_VIDEOS_X' => 'De video\'s van %s (%s)',
        'XS_FAVORITES_X' => 'Favorieten van %s (%s)',
        'VIDEO_DETAILS' => 'Videodetails',
        'NEITHER_FILE_NOR_EMBED_CODE' => 'Er is noch een bestand, noch een embed-code opgegeven.',
        'VIDEO_UPLOADED_ON_X' => 'Video geüpload op %s',
        'PROBLEM_OCCURRED_CONVERTING_VIDEO' => 'Er is een probleem opgetreden tijdens het converteren van de video naar de Flash-indeling: %s',
        'STATUS_N' => 'Status %s',
        'YOUR_VIDEO_TITLED_X_COULD_NOT' => 'Je video met de titel \'%s\' kon niet worden toegevoegd aan %s',
        'YOUR_VIDEO_COULD_NOT_BE_ADDED' => 'Je video kon niet worden toegevoegd aan %s',
        'YOU_JUST_TRIED_TO_SEND_VIDEO' => 'Je hebt zojuist geprobeerd om een video in te zenden naar %s. Helaas ben je geen lid van. %s Daarom kunnen we deze video niet bezorgen.',
        'VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'Video-upload naar %s niet voltooid',
        'YOUR_VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'Je video-upload naar %s is niet voltooid.',
        'YOUR_VIDEO_ENCOUNTERED_A_PROBLEM' => 'Er is een probleem opgetreden bij het uploaden van je video naar %s',
        'THE_PROBLEM_WAS_X' => 'Het probleem was: %s',
        'FOR_FURTHER_ASSISTANCE_2' => 'Neem voor assistentie contact met ons op via:',
        'ID' => 'ID:',
        'VIDEO_TRANSCODING_FAILED_FOR_X' => 'Video-transcoding mislukt voor video %s in %s',
        'X_UPLOADED_A_VIDEO_THAT_FAILED' => '%s heeft een video geüpload waarvan het transcoderen mislukte.',
        'ERROR_MESSAGE' => 'Foutmelding:',
        'APPLICATION_NAME' => 'Naam toepassing:',
        'APPLICATION_ID' => 'ID toepassing:',
        'VIDEO_ID' => 'ID video:',
        'VIDEO_UPLOAD_COMPLETE_ON_X' => 'Video-upload naar %s voltooid',
        'YOUR_VIDEO_UPLOAD_COMPLETE_ON_X' => 'Je video-upload naar %s is voltooid',
        'YOUR_VIDEO_WAS_UPLOADED' => 'Het uploaden van je video naar %s is geslaagd!',
        'THAT_VIDEO_IS_AWAITING_APPROVAL' => 'Die video wacht op goedkeuring.',
        'THIS_VIDEO_IS_BEING_PROCESSED' => 'Deze video wordt nog verwerkt.',
        'ADD_VIDEO' => 'Video toevoegen',
        'VIDEO_BY_X' => 'Video door %s',
        'THERE_IS_NEW_COMMENT_ON_VIDEO_X' => 'Er is een nieuwe reactie op je video \'%s\' op %s',
        'THERE_IS_NEW_COMMENT_ON_VIDEO' => 'Er is een nieuwe reactie op een van je video\'s op %s',
        'SOMEBODY_COMMENTED_VIDEO_ADDED_TO_X' => 'Iemand heeft een reactie geplaatst op een video die je hebt toegevoegd aan %s.',
        'SOMEBODY_UPLOADED_VIDEO_TO_X' => 'Iemand heeft een video geüpload naar %s',
        'MORE_WAYS_TO_ADD_VIDEOS' => 'Meer manieren om video\'s toe te voegen...',
        'FROM_YOUTUBE_OR_GOOGLE' => '...vanaf YouTube of Google',
        'GRAB_THE_HTML_EMBED_CODE' => 'Pak de HTML-\'embed\'-code van welke populaire videosite ook en voeg die video toe aan  dit netwerk.',
        'ADD_A_VIDEO_FROM_YOUTUBE' => 'Een video toevoegen vanaf YouTube of Google',
        'PASTE_IN_EMBED' => 'Plak de \'embed\'-code voor de video hier:',
        'ADD_VIDEOS_BY_PHONE_OR_EMAIL' => 'Video toevoegen per telefoon of e-mail',
        'VIDEO' => 'video',
        'THERE_ARE_NO_VIDEOS_THAT_MATCH' => 'Er zijn geen video\'s die overeenkomen met de instellingen zoals je ze hebt geselecteerd.',
        'CLICK_EDIT_AND_CHANGE_SETTINGS' => 'Klik op \'Bewerken\' en verander de instellingen om dit vak ook aan anderen te tonen.',
        'PLAY_AGAIN' => 'Nogmaals afspelen',
        'SHARE' => 'Delen',
        'EMBED' => 'Embedden',
        'REWIND' => 'Terugspoelen',
        'CHANGE_SIZE' => 'Formaat wijzigen',
        'FULLSCREEN' => 'Volledig scherm',
        'EXIT_FULLSCREEN' => 'Volledig scherm sluiten',
        'HIDE' => 'Sluiten',
        'COPY_AND_PASTE_LINK' => 'Kopieer en plak deze link in een e-mail of een chat-bericht:',
        'FIND_MORE_VIDEOS_LIKE_THIS' => 'Vind meer video\'s zoals deze op <em>%s</em>',
        'SEE_VIDEO_ON_NETWORK' => 'Bekijk deze video op %s',
        'GET_EMBED_CODE' => 'Ontvang de embed-code',
        'MORE_PHOTOS' => 'Meer foto\'s',
        'THIS_ALBUM' => 'Dit album',
        'NETWORK_DOES_NOT_HAVE_PHOTOS' => 'Dit netwerk heeft nog geen foto\'s.',
        'PERSON_DOES_NOT_HAVE_PHOTOS' => 'Deze persoon heeft nog geen foto\'s.',
        'ALBUM_DOES_NOT_HAVE_PHOTOS' => 'Dit album bevat nog geen foto\'s.',
        'FIND_MORE_PHOTOS_LIKE_THIS' => 'Vind meer foto\'s zoals deze op <em>%s</em>',
        'NO_PHOTOS_AVAILABLE' => 'Dit album bevat momenteel geen foto\'s . <a %s>Klik hier om alle albums te bekijken</a>.',
        'ALBUM_PHOTOS_NOT_VISIBLE_TO_OTHERS' => 'Dit album is niet zichtbaar voor anderen binnen het netwerk omdat de foto\'s alleen zichtbaar zijn voor jou of nog goedgekeurd dienen te worden.',
        'CUSTOMIZE_YOUR_SLIDESHOW_PLAYER' => 'Je diaspeler aanpassen!',
        'ADD_SLIDESHOW_LOGO' => 'Voeg een logo toe aan de diavoorstelling van je community. <a %s>Nu instellen!</a>',
        'PHOTO_BY_X' => 'Foto door %s',
        'UPLOAD_PHOTOS' => 'Foto\'s uploaden',
        'PLAYER_COLOR' => 'Kleur speler',
        'SLIDESHOW_PLAYER' => 'diaspeler',
        'SLIDESHOW' => 'diavoorstelling',
        'FILTER' => 'Filter',
        'SAVE_ALBUM' => 'Album opslaan',
        'APPLY_THIS_INFO_TO_PHOTOS' => 'Pas deze info toe op de volgende foto\'s',
        'CLICK_TO_ADD_A_DESCRIPTION' => 'Klik om een beschrijving toe te voegen',
        'CHECK' => 'Aanvinken',
        'YOU_NEED_TO_BE_X' => 'Je moet %s zijn om dat te kunnen doen.',
        'ALL_PHOTOS' => 'Alle foto\'s',
        'POPULAR_PHOTOS' => 'Populaire foto\'s',
        'FEATURED_PHOTOS' => 'Foto\'s op hoofdpagina',
        'PHOTOS_HOME' => 'Foto\'s hoofdpagina',
        'ALL_ALBUMS' => 'Alle albums',
        'MY_PHOTOS' => 'Mijn foto\'s',
        'MY_ALBUMS' => 'Mijn albums',
        'ADD_PHOTOS' => 'Foto\'s toevoegen',
        'ADD_PHOTOS_SENTENCE_CASE' => 'Foto\'s toevoegen',
        'EDIT' => 'Bewerken',
        'CHOOSE_PHOTOS' => 'Foto\'s kiezen',
        'ADD_PHOTOS_BY_DRAGGING' => '<strong>Foto\'s toevoegen:</strong> naar album rechts slepen. Weghalen door terug te slepen.',
        'TITLE_YOUR_ALBUM' => '<strong>Geef album een titel.</strong> Plaats voorblad bij beschrijving',
        'SAVE_YOUR_ALBUM' => 'Album opslaan',
        'CHOOSE_FROM' => 'Kiezen uit:',
        'EVERYONES_PHOTOS' => 'Foto\'s van iedereen',
        'TAGGED' => 'Met de tag:',
        'OLDER_PHOTOS' => 'Oudere foto\'s',
        'MORE_RECENT_PHOTOS' => 'Recentere foto\'s',
        'YOUR_ALBUM' => 'Jouw album',
        'DRAG_ALBUM_COVER_HERE' => 'Plaats voorblad album hier',
        'ALBUM_TITLE' => 'Titel album:',
        'ALBUM' => 'album',
        'DRAG_PHOTOS_HERE' => 'Sleep je foto\'s hierheen',
        'PREVIOUS_ALBUM_PAGE' => 'Vorige pagina album',
        'NEXT_ALBUM_PAGE' => 'Volgende pagina album',
        'ADDED_ON_DATE' => '%s toegevoegd',
        'VIEW_AS_SLIDESHOW' => 'Weergeven als diavoorstelling',
        'CREATED_BY_ME' => 'Aangemaakt door <a %s>mij</a>',
        'CREATED_BY_X' => 'Aangemaakt door %s',
        'OUR_APOLOGIES' => 'Onze excuses',
        'ADD_PHOTOS_TO_ALBUM' => 'Voeg meer foto\'s toe aan dit album door uit de onderstaande opties te kiezen.',
        'YOU_CAN_ADD_PHOTOS' => 'Je kunt <a %s>nu foto\'s aan dit album toevoegen</a>.',
        'SITE_IS_GETTING_STARTED' => 'Dit netwerk is pas net opgezet!',
        'NO_ONE_CREATED_ALBUMS' => 'Zo te zien heeft nog niemand een album aangemaakt. Je kunt <a %s>nu een album aanmaken</a>.',
        'EDIT_YOUR_ALBUM' => 'Je album bewerken',
        'ALBUMS_WITH_THIS_PHOTO' => 'Alle albums met deze foto',
        'ALBUMS_WITH_X' => 'Alle albums met \'%s\'',
        'ALBUMS_WITH_X_2' => 'Alle albums met <em>\'%s\'</em>',
        'NO_ALBUMS_CONTAINING_PHOTO' => 'Er zijn geen albums die deze foto bevatten. Je kunt <a %s>een album aanmaken</a>.',
        'XS_ALBUMS' => 'Albums van %s',
        'CREATE_AN_ALBUM' => 'Een album aanmaken',
        'YOU_HAVE_NOT_CREATED_ALBUMS' => 'Je hebt nog geen fotoalbums aangemaakt. Je kunt <a %s>nu een album aanmaken</a>.',
        'X_HAS_NOT_CREATED_ALBUMS' => '%s heeft nog geen fotoalbums aangemaakt.',
        'MAKE_AN_ALBUM' => 'Een album maken',
        'ABOUT_THIS_ALBUM' => 'Over dit album',
        'ABOUT_YOUR_ALBUM' => 'Over je album',
        'EDIT_ALBUM' => 'Album bewerken',
        'DELETE_THIS_ALBUM' => 'Dit album verwijderen?',
        'DELETE_ALBUM' => 'Album verwijderen',
        'START_SLIDESHOW' => 'Diavoorstelling starten',
        'ALBUM_IS_NOW_EMPTY' => 'Dit album is nu leeg.',
        'YOU_ARE_GETTING_STARTED' => 'Je begint pas net!',
        'YOU_HAVE_NOT_ADDED_PHOTOS' => 'Je hebt nog geen foto\'s toegevoegd!',
        'ADD_PHOTOS_AND_SHARE' => 'Voeg foto\'s toe en deel ze met je vrienden, familie en de rest van de wereld!',
        'ADD_A_PHOTO' => 'Een foto toevoegen',
        'NO_PHOTOS_ON_SITE' => 'Momenteel bevat je netwerk geen foto\'s.',
        'BOX_WILL_NOT_SHOW_PHOTOS' => 'Dit vak wordt voor anderen pas weergegeven als er foto\'s te zien zijn. Wil je er niet een toevoegen?',
        'VIEW_EMBED_CODE' => 'Embed-code weergeven',
        'VIEW_SLIDESHOW' => 'Diavoorstelling weergeven',
        'VIEW_PHOTOS' => 'Foto\'s weergeven',
        'ADD_YOUR_FIRST_PHOTOS' => 'Je eerste foto\'s toevoegen',
        'YOU_CAN_ADD_YOUR_OWN_PHOTOS' => 'Je kunt <a %s>je eigen foto\'s toevoegen</a> aan %s!',
        'UPLOAD_PHOTOS_FROM' => 'Foto\'s uploaden vanaf je computer:',
        'ADD_TITLE_AND_DESCRIPTION_FOR_PHOTOS' => 'Voeg een titel en beschrijving toe voor je foto\'s',
        'EDIT_PHOTO_INFORMATION' => 'Foto-informatie bewerken',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_1' => 'Voeg een titel, beschrijving en andere informatie toe aan de foto\'s die je zojuist hebt geupload.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_2' => 'Voeg een titel, beschrijving en andere informatie toe voor deze foto.',
        'CANCEL_AND_RETURN_TO_PHOTO' => 'Annuleren en terugkeren naar de foto',
        'WHO_CAN_VIEW_PHOTO' => 'Wie kan deze foto bekijken?',
        'CAN_BE_VIEWED_BY' => 'Kan worden bekeken door:',
        'BY_ME' => 'door <a %s>mij</a>',
        'RSS_FEED_LABEL' => '<a %s>RSS-stroom</a>  – %s',
        'NO_PHOTOS_AWAITING_APPROVAL' => 'Momenteel zijn er geen foto\'s ter goedkeuring door jou. Als je iets te doen zoekt: kijk eens naar de <a %s>nieuwste foto\'s</a>?',
        'APPROVE_ALL_PHOTOS' => 'Alle foto\'s goedkeuren?',
        'ARE_YOU_SURE_APPROVE_ALL_PHOTOS' => 'Weet je zeker dat je alle foto\'s wilt goedkeuren? Dat kan enige minuten in beslag nemen.',
        'DELETE_ALL_PHOTOS' => 'Alle foto\'s verwijderen?',
        'ARE_YOU_SURE_DELETE_ALL_PHOTOS' => 'Weet je zeker dat je alle niet-goedgekeurde foto\'s wilt verwijderen? Dat kan enige minuten in beslag nemen.',
        'KEEP_WINDOW_OPEN_PHOTOS_APPROVED' => 'Houd dit browser-venster open terwijl de foto\'s worden goedgekeurd. Dit kan enige minuten in beslag nemen.',
        'KEEP_WINDOW_OPEN_PHOTOS_DELETED' => 'Houd dit browser-venster open terwijl de foto\'s worden verwijderd. Dit kan enige minuten in beslag nemen.',
        'APPLY_TO_PHOTOS_ADDED_BY' => 'Toepassen op alle foto\'s toegevoegd door %s',
        'NO_ONE_HAS_ADDED_ANY_PHOTOS' => 'Niemand heeft nog foto\'s toegevoegd aan je netwerk. Jij kunt de eerste zijn die <a %s>foto\'s toevoegt.</a>',
        'UNTITLED' => 'Zonder titel',
        'A_PROBLEM_OCCURRED' => 'Er is een probleem opgetreden',
        'PHOTOS_EXCEEDED_LIMIT' => 'De limiet van 10 MB per foto is overschreden.',
        'GET_A_SLIDESHOW_OF' => 'Diavoorstelling op van %s',
        'GET_A_SLIDESHOW' => 'Haal een diavoorstelling op!',
        'GET_SLIDESHOW_OF_PHOTOS' => 'Haal een diavoorstelling van deze foto\'s op',
        'COPY_AND_PASTE_SLIDESHOW' => 'Kopieer en plak onderstaande code om een diavoorstelling van deze foto\'s op je eigen website, MySpace-pagina of andere Ning-netwerken te plaatsen.',
        'COPY_AND_PASTE_SLIDESHOW_OF_ALBUM' => 'Kopieer en plak onderstaande code om een diavoorstelling van dit album op je eigen website, MySpace pagina of andere Ning-netwerken te plaatsen.',
        'LARGE_VERSION' => 'Grote versie',
        'SMALL_VERSION' => 'Kleine versie',
        'VIEW_SLIDESHOW_FULL_SIZE' => 'Geef deze diavoorstelling weer op volledig formaat',
        'PHOTOS' => 'Foto\'s',
        'XS_PHOTOS' => 'De foto\'s van %s',
        'XS_PHOTO' => 'De foto van %s',
        'YOU_CAN_MARK_PHOTO' => 'Je kunt elke foto als favoriet markeren. Je hoeft alleen op het pictogram \'Toevoegen aan favorieten\' te klikken wanneer je dit ziet op een foto.',
        'VIEW_RECENT_PHOTOS' => 'Recente foto\'s bekijken',
        'APPROVE_PHOTOS' => 'Foto\'s goedkeuren',
        'DELETE_ALL_XS_PHOTOS_Q' => 'Alle foto\'s van %s verwijderen?',
        'ARE_YOU_SURE_DELETE_ALL_XS_PHOTOS' => 'Weet je zeker dat je alle foto\'s van %s wilt verwijderen? Dat kan enige minuten in beslag nemen.',
        'REMOVE_X_AND_ALL_CONTENT' => 'Verwijder %1$s en al het materiaal van %1$s uit je netwerk',
        'SUCCESS' => 'Succes.',
        'DELETING_CONTENT' => 'Bezig met het verwijderen van materiaal...',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED' => 'Houd dit browser-venster open terwijl het materiaal wordt verwijderd. Dit kan enige minuten in beslag nemen.',
        'KEEP_WINDOW_OPEN_MEMBERS_DELETED' => 'Houd dit browservenster open tot de leden verwijderd zijn. Dit kan enige minuten in beslag nemen.',
        'DELETE_ALL_XS_PHOTOS' => 'Alle foto\'s van %s verwijderen',
        'CREATE_A_NEW_ALBUM' => 'Een nieuw album aanmaken',
        'VIEW_ALL_XS_ALBUMS' => 'Alle albums van %s bekijken',
        'YOU_HAVE_NOT_ADDED_PHOTOS_2' => 'Je hebt nog geen foto\'s toegevoegd. Voeg enkele foto\'s toe om te beginnen!',
        'X_HAS_NOT_ADDED_PHOTOS' => '%s heeft nog geen foto\'s toegevoegd.',
        'MY_FRIENDS_PHOTOS' => 'Foto\'s van mijn vrienden',
        'VIEW_PHOTOS_IN_SLIDESHOW' => 'Bekijk deze foto\'s in een diavoorstelling!',
        'YOUR_FRIENDS_DO_NOT_HAVE_PHOTOS' => 'Je vrienden hebben nog geen foto\'s',
        'ALL_PHOTOS_TAGGED_X' => 'Alle foto\'s met de tag \'%s\'',
        'ALL_PHOTOS_TAGGED_X_2' => 'Alle foto\'s met de tags <em>\'%s\'</em>',
        'NO_PHOTOS_TAGGED_X_CHECK_OUT' => 'Er zijn geen foto\'s met de tag \'%1$s\'. Kijk naar <a %2$s>video\'s met de tag \'%1$s\'</a>. Of voeg je eigen foto\'s toe met een tag!',
        'SELECT_YOUR_PHOTOS' => 'Je foto\'s selecteren',
        'PHOTO_MAY_BE_10MB' => 'Elke foto mag tot 10 MB groot zijn, maar kleinere foto\'s worden sneller geüpload!',
        'KEEP_PAGE_OPEN_PHOTOS' => 'Houd deze pagina open zodat we het uploaden van je foto\'s kunnen voltooien. Je krijgt een melding zodra ze zijn goedgekeurd!',
        'MEANWHILE_FEEL_FREE_PHOTOS' => 'Intussen kun je gewoon <a %s>een nieuw browser-venster openen</a> en verder gaan met %s. Als het uploaden voltooid is, kun je in dit venster titels en beschrijvingen toevoegen aan je foto\'s.',
        'PHOTO_IS_WAITING_FOR_APPROVAL' => 'Deze foto <strong>wacht op goedkeuring</strong> door de initiatiefnemer van %s.',
        'ADD_TO_FAVORITES' => 'Toevoegen aan favorieten',
        'EDIT_PHOTO' => 'Foto bewerken',
        'DELETE_PHOTO' => 'Foto verwijderen',
        'ABOUT_THIS_PHOTO' => 'Over deze foto',
        'LOCATION_OF_PHOTO' => 'Locatie van deze foto:',
        'ALBUMS_FEATURING_PHOTO' => 'Albums waarin deze foto staat',
        'VIEW_ALBUMS_WITH_PHOTO' => 'Alle albums met deze foto bekijken',
        'RETURN_TO_X' => 'Terugkeren naar %s',
        'RETURN_TO_PHOTOS_HOME' => 'Terug naar de fotohoofdpagina',
        'WE_COULD_NOT_FIND_ANYONE' => 'Onze excuses, we konden niemand vinden',
        'NOBODY_HAS_ADDED_PHOTOS' => 'Er heeft nog niemand foto\'s toegevoegd! Voeg enkele foto\'s toe om te beginnen.',
        'DEFAULT_TITLE' => 'Titel',
        'DEFAULT_DESCRIPTION' => 'Beschrijving',
        'UPLOAD_LIMIT_EXCEEDED' => 'De maximumbestandsgrootte voor uploaden is overschreden.',
        'SLOW_DOWN_THERE_CHIEF' => 'Rustig aan, maatje!',
        'I_DO_NOT_KNOW_USER' => 'Sorry, ik ken deze persoon niet.',
        'I_DO_NOT_HAVE_PHOTO' => 'Sorry, ik heb deze foto niet.',
        'I_DO_NOT_HAVE_ALBUM' => 'Sorry, ik heb dit album niet.',
        'ALBUM_BY_X_ON_X' => 'Album door %s op %s',
        'SENT' => 'Verzonden!',
        'I_HAVE_RECENTLY_ADDED' => 'Ik heb onlangs toegevoegd',
        'FROM_THE_BAZEL' => 'Vanaf dit netwerk',
        'RECENTLY_ADDED' => 'Onlangs toegevoegd',
        'RECENT_PUBLIC_PHOTOS_ON_X' => 'Recente openbare foto\'s op %s',
        'X_ALL_PHOTOS' => '%s - Alle foto\'s',
        'NO_TAG_WAS_SPECIFIED' => 'Er is geen tag opgegeven',
        'PUBLIC_PHOTOS_TAGGED_WITH_X' => 'Openbare foto\'s met de tag %s op %s',
        'XS_PUBLIC_PHOTOS_ON_X' => 'De openbare foto\'s van %s op %s',
        'WE_DO_NOT_KNOW_USER' => 'Wij kennen deze persoon niet.',
        'XS_FRIENDS_PHOTOS' => 'De foto\'s van de vrienden van %s',
        'XS_FAVORITE_PHOTOS_ON_X' => 'De favoriete foto\'s van %s op %s',
        'PHOTO_UPLOADED_ON_X' => 'Foto geupload naar %s',
        'FILE_EXCEEDED_MAXIMUM_SIZE' => 'Het bestand was groter dan de maximumgrootte',
        'PART_OF_FILE_WAS_UPLOADED' => 'Het bestand is slechts gedeeltelijk geüpload',
        'NO_FILE_WAS_UPLOADED' => 'Uploaden mislukt: misschien was de bestandsnaam onjuist',
        'PROBLEM_OCCURRED_DURING_UPLOAD' => 'Er is iets misgegaan tijdens het uploaden.',
        'ALPHABETICAL' => 'Alfabetisch',
        'MOST_VIEWS' => 'Grootst aantal keren bekeken',
        'RATING_NOT_RATED_YET' => '<strong>Cijfer:</strong> nog geen cijfer',
        'NOT_RATED_YET' => 'Nog geen cijfer',
        'HMM_SOMETHING_WENT_AWRY' => 'Hmm... er is iets misgegaan',
        'YOUR_PHOTO_TITLED_X_COULD_NOT' => 'Je foto met de titel \'%s\' kon niet worden toegevoegd aan %s',
        'YOUR_PHOTO_COULD_NOT_BE_ADDED' => 'Je foto kon niet worden toegevoegd aan %s',
        'YOU_JUST_TRIED_TO_SEND' => 'Je hebt zojuist geprobeerd om een foto in te zenden naar %s. Helaas ben je geen lid van %s en kunnen we deze foto dus niet bezorgen.',
        'ONLY_MY_FRIENDS' => 'Alleen mijn vrienden',
        'ANYBODY' => 'Iedereen',
        'ONLY_MY_FRIENDS_CAN_SEE_PHOTO' => 'Alleen mijn vrienden mogen deze foto zien',
        'ONLY_XS_FRIENDS_CAN_SEE_PHOTO' => 'Alleen vrienden van %s mogen deze foto zien',
        'ONLY_I_CAN_SEE_PHOTO' => 'Alleen ik mag deze foto zien',
        'ONLY_X_CAN_SEE_PHOTO' => 'Alleen %s mag deze foto zien',
        'EVERYONE_CAN_SEE_PHOTO' => 'Iedereen mag deze foto zien',
        'PRIVATE_PHOTO' => '<strong>Privé</strong>-foto',
        'HOWDY_STRANGER' => 'Welkom, vreemdeling!',
        'YOU_NEED_TO_BE_SIGNED_IN' => 'Je moet je aanmelden bij Ning voordat je dat kunt doen.',
        'JUST_CLICK_ON_SIGN_IN' => 'Klik hierboven op \'Aanmelden\'. Als je nog geen Ning-account hebt, klik je op \'Inschrijven\'.',
        'YOU_NEED_TO_BE_' => 'Je moet %s zijn om dat te kunnen doen.',
        'YOU_NEED_TO_BE_OWNER' => 'Je moet de initiatiefnemer van het netwerk zijn om dat te kunnen doen.',
        'THAT_PHOTO_IS_AWAITING_APPROVAL' => 'Die foto wacht op goedkeuring.',
        'YOU_NEED_TO_BE_A_FRIEND' => 'Je moet een vriend van %s zijn om dat te kunnen doen.',
        'MOST_ACTIVE' => 'Actiefst',
        'HOW_IT_WORKS' => 'Hoe het werkt',
        'MORE_WAYS_TO_ADD_PHOTOS' => 'Meer manieren om foto\'s toe te voegen...',
        'BY_PHONE_OR_EMAIL' => '...via telefoon of e-mail',
        'FROM_FLICKR' => '...vanaf Flickr',
        'FROM_YOUR_COMPUTER' => '...vanaf je computer',
        'ADD_PHOTOS_FROM_YOUR_FLICKR' => 'Foto\'s toevoegen vanaf je Flickr-account.',
        'MORE_INFORMATION' => 'Meer informatie',
        'ADD_PHOTOS_BY_PHONE_OR_EMAIL' => 'Foto\'s toevoegen per telefoon of e-mail',
        'SEND_ONE_PHOTO_OR_VIDEO' => 'Stuur één foto of video per e-mail. Het onderwerp van de e-mail wordt de titel van de foto of video, en de tekst van de mail wordt de beschrijving.',
        'CLICK_HERE_TO_GET_A_NEW_UNIQUE' => 'Klik hier om een nieuw e-mailadres te krijgen',
        'UPLOAD_PHOTOS_FROM_YOUR' => 'Foto\'s uploaden vanaf je computer.',
        'PHOTO' => 'foto',
        'YOUVE_SET_THE_NUMBER_OF_PHOTOS' => 'Er zijn momenteel geen foto\'s om weer te geven.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_PHOTO' => 'Dit vak is niet zichtbaar voor anderen zolang je niet minstens één foto hebt geselecteerd.',
        'THERE_IS_NEW_COMMENT_ON_PHOTO_X' => 'Er is een nieuwe reactie op je foto \'%s\' op %s',
        'THERE_IS_NEW_COMMENT_ON_PHOTO' => 'Er is een nieuwe reactie op een van je foto\'s op %s',
        'SOMEBODY_COMMENTED_PHOTO_ADDED_TO_X' => 'Iemand heeft een reactie gegeven op een foto die je hebt toegevoegd aan %s',
        'SOMEBODY_UPLOADED_PHOTO_TO_X' => 'Iemand heeft een foto geüpload naar %s',
        'ADD_PHOTOS_OR_VIDEOS_TO_X' => 'Voeg foto\'s of video\'s rechtstreeks vanuit je telefoon toe door ze naar een e-mailadres te sturen.',
        'DO_YOU_REALLY_WANT_TO_REMOVE' => 'Wil je dit item echt verwijderen uit je favorieten?',
        'DELETE_THIS_PHOTO_Q' => 'Deze foto verwijderen?',
        'ARE_YOU_SURE_DELETE_THIS_PHOTO' => 'Weet je zeker dat je deze foto wilt verwijderen? Dat kan enige minuten duren.',
        'PHOTO_SLIDESHOW' => 'Diavoorstelling',
        'THUMBNAILS' => 'Miniaturen',
        'DETAIL' => 'Detail',
        'TAG' => 'Taggen',
        'RATE' => 'Waarderen',
        'ALL_SIZES' => 'Alle groottes',
        'ADD_TO_ALBUM' => 'Toevoegen aan album',
        'ROTATE_PHOTO' => 'Foto draaien',
        'ABOUT_YOUR_PHOTO' => 'Over je foto',
        'SEE_PHOTOS_ON_NETWORK' => 'Bekijk deze foto\'s op %s',
        'EMBED_CODE' => 'Embed-code',
        'IMPORT_PHOTOS_FLICKR' => 'Haal je foto\'s op van Flickr',
        'CLICK_HERE_TO_CONTINUE_TO_FLICKR' => 'Klik hier om door te gaan naar Flickr',
        'TO_GET_YOUR_PHOTOS_FROM_FLICKR' => 'Als je je foto\'s wilt ophalen van Flickr, moet je eerst toestaan dat %S een koppeling naar je Flickr-account legt.',
        'IMPORT_PHOTOS' => 'Foto\'s importeren',
        'GET_MY' => 'Ophalen van mijn',
        'GET_PHOTOS' => 'Foto\'s ophalen',
        'MOST_RECENT_PHOTOS' => 'meest recente foto\'s',
        'GET_ALL_MY_FLICKR' => 'Haal al mijn foto\'s op van Flickr (kan even duren)',
        'GET_ALL_MY_TAGGED' => 'Haal al mijn foto\'s op met de tag',
        'GET_PHOTOS_FROM_SET' => 'Haal de foto\'s op uit een set:',
        'GET_STARTED_BY_IMPORT' => 'We halen automatisch je titels, tags en eventuele kaartinformatie op.<br/>Hoe lang duurt het?</p> <p><ul style="padding-top:10px;"><li>10 foto\'s: <em>minder dan 30 seconden</em>.</li><li>50 foto\'s: <em>circa 2 minuten</em>.</li><li>200 foto\'s: <em>circa 6 minuten</em>.</li><li>500 foto\'s: <em>circa 15 minuten</em>.</li></ul>',
        'IF_YOURE_NOT_SIGNED_IN' => 'Als je niet bent aangemeld bij Flickr, word je gevraagd om je aan te melden. Nadat je je hebt aangemeld, klik je op de knop met \'OK, I\'ll allow it\'.',
        'GET_MY_FLICKR_PHOTOS_DESCRIPTIONS' => 'Haal ook de beschrijvingen op (dan duurt het wel twee maal zo lang).',
        'PLEASE_KEEP_THIS_PAGE_OPEN_WHILE_IMPORT' => 'Houd deze pagina open zodat we het importeren van je foto\'s kunnen voltooien.',
        'GET_MY_FLICKR_PHOTOS_ORIGINALS' => 'Haal elke foto op in volledig formaat (hierdoor duurt het importeren ook langer).',
        'MAKE_YOUR_X_PAGE_YOUR_OWN' => '<p>Klik op \'Bewerken\' om tekst, video\'s, foto\'s of een widget toe te voegen aan dit vak. Dit is nog een manier om je %s-pagina uniek te maken.</p>',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Klik op  \'Bewerken\' om tekst, HTML, video\'s, foto\'s of <a %1$s>widgets van anderen</a> toe te voegen aan dit vak. Dit is een ander manier om jouw %2$s pagina uniek te maken.',
        'BOX_WILL_NOT_SHOW_UNTIL_UPDATE_CONTENT' => 'Zolang je de inhoud van dit vak niet verandert, is dit vak niet zichtbaar voor anderen.',
        'YOUR_X_BOX' => 'De %s-omschrijving',
        'ABOUT_WIDGETS' => 'Over widgets',
        'HELP' => 'Help',
        'WIDGETS' => 'Widgets',
        'LOOKING_TO_ADD_FUNCTIONALITY' => 'Wil je meer functionaliteiten aan je netwerk toevoegen? Zoals een agenda, weersverwachting, een teller of een webcam? Wanneer je gebruik maakt van widgets, is het makkelijk om extra functies aan ieder tekstvak op je netwerk toe te voegen.',
        'GETTING_STARTED' => 'Aan de slag',
        'BELOW_IS_LIST_OF_WIDGET' => 'Hieronder staat een <a %s>lijst van widget-aanbieders</a> die interessant voor je kunnen zijn. Wij hebben een aantal widgets geselecteerd van <a %s>yourminis.com</a> om je op weg te helpen. Start met het maken van het widget hieronder, kopieer de embed-code en plak deze code direct in het tekstvak. Aan de slag!',
        'CALENDAR' => 'Agenda',
        'CALENDAR_WIDGET_ALLOWS_SEARCH' => 'De agenda-widget laat niet alleen de datum zien, maar ook kun je ermee in gebeurtenissen zoeken en toevoegen in iCal-indeling (deze indeling wordt ook gebruikt door Google Calendar en andere online agendas).',
        'USE_EDIT_WIDGET_BUTTON_CALENDAR' => 'Gebruik de &#8220;bewerk widget&#8221; knop om te &#8220;zoeken naar gebeurtenissen&#8221;, voer vervolgens een zoekopdracht in (probeer bijvoorbeeld vakanties, een sportclub, etc.). Kies daarna een zoekresultaat om deze gebeurtenissen aan je agenda toe te voegen. Je kunt ook handmatig het adres van een bestaande iCal-feed toevoegen.',
        'CUSTOMIZATION' => 'Aanpassen',
        'YOU_CAN_CUSTOMIZE_WIDGET' => 'Je kunt de vormgeving van de widget aanpassen door met je muis over de widget te gaan. Klik daarna op het kleurenkiezerpictogram om de achtergrondkleur, de stijl van het widget en de transparantie te veranderen. Zodra je klaar bent klik je op de koppeling &#8220;kopieer naar web&#8221;, en vervolgens op de knop &#8220;kopieer embed-code&#8221;. Wanneer de code is gekopieerd, ga je terug naar een tekstvak in je netwerk, plak de code en sla de veranderingen op. Klaar!',
        'GET_MORE_WIDGETS_FROM_YOURMINIS' => 'Haal meer widgets op vanaf yourminis.com »',
        'WEATHER' => 'Weer',
        'WEATHER_WIDGET_DISPLAYS' => 'De weer-widget laat weersvoorspellingen zien van the Weather Channel.',
        'USE_EDIT_WIDGET_BUTTON_WEATHER' => 'Selecteer je locatie met de knop &#8220;bewerk widget&#8221; en kies vervolgens voor graden Celsius of Fahrenheit. Je kunt er voor kiezen om de verwachting voor alleen vandaag of voor vijf dagen vooruit te laten zien.',
        'COUNTDOWN' => 'Aftellen',
        'COUNTDOWN_WIDGET_LETS_YOU' => 'Met de aftellen-widget kun je aftellen tot een specifieke gebeurtenis. Door op de knop &#8220;bewerk widget&#8221; te klikken, kun je de datum, tijd en titel en/of foto instellen van de gebeurtenis waar je voor aftelt.',
        'WEBCAM' => 'Webcam',
        'WEBCAM_WIDGET_ALLOWS_YOU' => 'Met de webcam-widget kun je publiek beschikbare webcams in de gaten houden. Gebruik de knop &#8220;bewerk widget&#8221; om een webcam uit de keuzelijst te selecteren, of geef de URL van je webcam op.',
        'MORE_WIDGETS' => 'Meer widgets',
        'NEED_MORE_OPTIONS' => 'Nog meer opties nodig? We raden je aan om op een van de volgende sites te kijken om jouw widget-honger te stillen:',
        'MODERATION_DENIED_ON_X' => 'Moderatie afgewezen op %s op %s',
        'MODERATION_DENIED_ON_A_X' => 'Moderatie afgewezen op een %s van jou op %s',
        'YOU_HAVE_NEW_X_TO_MODERATE' => 'Je hebt een nieuwe %s om te modereren op %s',
        'NEW_X_TO_MODERATE' => 'Er is een nieuwe %s die je moet modereren.',
        'MODERATION_APPROVED_ON_X' => 'Moderatie goedgekeurd op %s op %s',
        'MODERATION_APPROVED_ON_A_X' => 'Moderatie goedgekeurd op een %s van jou op %s',
        'JOIN' => 'Deelnemen',
        'WELCOME' => 'Welkom',
        'WELCOME_TO_X' => 'Welkom bij %s',
        'WELCOME_TO_X_ELLIPSIS' => 'Welkom bij %...',
        'RSS_LINK' => '<a %s>RSS</a>',
        'NEW_FEATURES_GROUPS_MUSIC' => '<h3 style="margin-top:0">Nieuwe functies!</h3>
            <ul><li><strong>Groepen</strong> &ndash; Laat je leden groepen vormen binnen je community</li>
                <li><strong>Muziekspeler</strong> &ndash; Voeg muziek en podcasts toe aan je community</li></ul>
            <p><a href="%s" class="desc add">Klik hier om functies toe te voegen</a></p>',
        'NEW_FEATURES_ACTIVITY_BADGES' => '<h3 style="margin-top:0">Nieuwe functies!</h3>
            <ul><li><strong>Recente activiteit</strong> &ndash; Volg recente activiteit van leden in je community</li>
                <li><strong>Banners & widgets</strong> &ndash; Maak reclame voor je community op het web met aangepaste banners en widgets</li></ul>
            <p><a href="%s" class="desc add">Klik hier om functies toe te voegen of te bewerken</a></p>',
        'YOUR_TYPE_NAME_HAS_NEW_COMMENT_APPNAME' => 'Je %2$s, %1$s, heeft een nieuw commentaar dat is toegevoegd door iemand op %3$s!',
        'YOUR_TYPE_HAS_NEW_COMMENT_APPNAME' => 'Je %1$s heeft een nieuw commentaar dat is toegevoegd door iemand op %2$s!',
        'HERE_IS_LINK' => 'Met deze koppeling kun je deelnemen: <a %s>%s</a>',
        'THANKS_VALEDICTION' => 'Dank je wel,',
        'THANKS' => 'Dank je wel!',
        'YOU_CHANGED_YOUR_EMAIL_ON_X' => 'Je hebt je e-mailadres gewijzigd op %s.',
        'YOU_CHANGED_YOUR_EMAIL_ON_X_ELLIPSIS' => 'Je hebt je e-mailadres gewijzigd op %...',
        'CLICK_HERE_TO_SIGN_IN_WITH_YOUR_NEW_EMAIL_ADDRESS' => 'Klik hier om je aan te melden met je nieuwe e-mailadres:',
        'IF_DID_NOT_CHANGE_EMAIL_ADDRESS' => 'Als je je e-mailadres niet hebt gewijzigd, klik dan hier:',
        'TO_STOP_BEING_NOTIFIED_OF_NEW_DISCUSSIONS_GO_TO' => 'Als je niet meer gewaarschuwd wilt worden wanneer er nieuwe discussies zijn, ga dan naar:',
        'X_STARTED_DISCUSSION_ON_APPNAME_ELLIPSIS' => '%1$s heeft een nieuwe discussie gestart op %2$s...',
        'X_STARTED_THE_DISCUSSION_Y' => '%1$s heeft de discussie "%2$s" gestart.',
        'TO_VIEW_THIS_DISCUSSION_GO_TO' => 'Als je de discussie wilt bekijken, ga dan naar:',
        'X_HAS_INVITED_YOU_TO_JOIN_Y' => '%s heeft je uitgenodigd om je aan te sluiten bij %s!',
        'X_WANTS_YOU_TO_CHECK_OUT_Y' => '%s wil dat je kijkt naar \'%s\' op %s!',
        'CHECK_OUT_TITLE_ON_APPNAME' => 'Ga \'s kijken naar "%s" op %s!',
        'ABOUT_X' => 'Over %s',
        'YOU_HAVE_RECEIVED_BECAUSE_X' => 'Je ontvangt deze e-mail, want %s',
        'IF_YOU_NO_LONGER_WISH_FROM_X_CLICK_Y' => 'Als je geen meldingen meer wilt ontvangen van %s, <a %s>hier klikken</a>.',
        'CLICK_HERE' => 'Hier klikken',
        'YOU_CAN_CONTACT_US' => 'Je kunt contact met ons opnemen voor vragen of opmerkingen over privacy via http://help.ning.com/?page_id=27.',
        'MESSAGE_TO_ALL_MEMBERS_OF_X' => 'Een bericht aan alle leden van %s',
        'CLICK_TO_CHECK_OUT' => 'Klik hier om te bekijken!',
        'CLICK_TO_APPROVE_X' => 'Klik hier om deze %s goed te keuren/te verwijderen',
        'YOUR_X_HAS_BEEN_APPROVED' => 'Je %s is goedgekeurd op %s!',
        'YOUR_X_WAS_NOT_APPROVED' => 'Je %s is niet goedgekeurd op %s.',
        'CLICK_TO_VIEW_X' => 'Klik hier om deze %s te bekijken!',
        'CLICK_TO_VIEW_IT' => 'Klik hier om te bekijken!',
        'TO_VIEW_USER_PROFILE_VISIT' => 'Wil je het profiel van %s bekijken, bezoek dan:',
        'YOU_ADDED_CONTENT' => 'je hebt materiaal toegevoegd aan %s, een gemodereerde community',
        'X_REPORTED_AN_ISSUE_ON_Y_ELLIPSIS' => '%1$s heeft een probleem gerapporteerd op %2$s...',
        'X_REPORTED_THE_FOLLOWING_ISSUE' => '%s heeft het volgende probleem gerapporteerd.',
        'URL_REPORTED_COLON' => 'Gerapporteerde URL:',
        'ISSUE_COLON' => 'Probleem:',
        'ADDITIONAL_INFORMATION_COLON' => 'Nadere informatie:',
        'SEND_AN_INVITATION_TO_X' => 'Stuur een uitnodiging naar %s',
        'SOMEBODY_REQUESTED_JOIN_X' => 'Iemand heeft gevraagd om zich bij %s te mogen aansluiten',
        'WANT_TO_ADD_A_WELCOME_MESSAGE_FOR_X_ON_THEIR_PROFILE_GO_TO' => 'Wil je een welkomstbericht toevoegen voor %s op diens profiel?  Ga naar:',
        'USER_HAS_SENT_YOU_A_MESSAGE' => '%s heeft je een bericht gestuurd.',
        'TO_READ_THIS_MESSAGE_VISIT' => 'Om het bericht te lezen, ga je naar:',
        'X_HAS_SENT_YOU_A_MESSAGE_ON_Y_ELLIPSIS' => '%s heeft je een bericht gestuurd op %s...',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ELLIPSIS' => '&s heeft je toegevoegd als vriend...',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ON_Y' => '&s heeft je toegevoegd als vriend op %s.',
        'X_HAS_ACCEPTED_YOUR_FRIEND_REQUEST' => '%s heeft je verzoek tot vriendschap op %s geaccepteerd!',
        'TO_ACCEPT_THIS_FRIEND_REQUEST_VISIT' => 'Om dit verzoek tot vriendschap te accepteren, ga je naar:',
        'VIEW_XS_PAGE_ON_Y' => 'Bekijk de pagina van %s op %s',
        'MEMBER_OF_X_ACCEPTED' => 'Een lid van %s heeft je verzoek tot vriendschap geaccepteerd',
        'IF_NO_LONGER_WISH_FRIEND_NOTIFICATION_EMAIL_FROM_X_CLICK_Y' => 'Als je geen vriendschapsverzoeken van %s meer wilt ontvangen, <a %s>hier klikken</a>.',
        'YOU_RECEIVED_INVITATION_FROM_X' => 'Je hebt deze uitnodiging ontvangen van een lid van %1$s. Als je geen uitnodigingen meer wilt ontvangen van %1$s, neem dan contact met ons op via http://help.ning.com/?page_id=27.',
        'ON_X_COLON' => 'Op %s:',
        'ON_X' => 'op %s',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP' => '%s heeft gevraagd om lid te mogen worden van %s.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X_ELLIPSIS' => '%1$s heeft gevraagd om lid te mogen worden van %2$s op %3$s...',
        'USER_HAS_INVITED_YOU_TO_JOIN_THE_GROUP_X' => '%1$s heeft je uitgenodigd om deel te nemen aan de groep "%2$s"',
        'VISIT_GROUP_AT' => 'Bezoek %s op:',
        'ABOUT_GROUP' => 'Over %s',
        'A_MESSAGE_FROM_USERNAME_TO_GROUPNAME_ON_APPNAME' => 'Een bericht van %s aan alle leden van %s op %s!',
        'YOU_CAN_SIGN_IN_USING_EMAIL_HERE' => 'Je kunt je hier aanmelden met je e-mailadres:',
        'USERNAME_COMMENTED_ON_BLOG_POST_TITLE_APPNAME' => '%s heeft commentaar geleverd op het weblogbericht  \'%s\' op %s',
        'SEND_X_A_MESSAGE_HERE' => 'Stuur hier %s een bericht:',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X_ELLIPSIS' => 'Er is een nieuw lid om goed te keuren op %s...',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE' => 'Er is een nieuw lid om goed te keuren.',
        'TO_APPROVE_XS_PROFILE_VISIT' => 'Wil je het profiel van %s goedkeuren, bezoek dan:',
        'CANT_CLICK_CUT_AND_PASTE' => 'Kun je niet op de koppeling hierboven klikken? Kopieer en plak de URL dan gewoon in je webbrowser.',
        'CLICK_HERE_TO_JOIN_COLON' => 'Klik hier om deel te nemen:',
        'CLICK_HERE_TO_JOIN_BANG' => 'Klik hier om deel te nemen!',
        'YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED_ELLIPSIS' => 'Je aanvraag om lid te mogen worden van %s is goedgekeurd...',
        'CONGRATULATIONS_BANG_YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED' => 'Gefeliciteerd!  Je aanvraag om lid te mogen worden van %s is goedgekeurd.',
        'YOU_CAN_NOW_SIGN_IN_USING_YOUR_EMAIL_ADDRESS_HERE' => 'Je kunt je nu hier aanmelden met je e-mailadres:',
        'VISIT_X_AT_Y' => 'Bezoek %1$s op: %2$s',
        'TO_CONTROL_WHICH_EMAILS_YOUR_RECEIVE_ON_X_GO_TO' => 'Wil je instellen welke e-mails je op %1$s ontvangt, ga dan naar:',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_ELLIPSIS' => 'Een verwijderd lid heeft je een bericht gestuurd op %s...',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_USERNAME_WRITES' => 'Een verwijderd lid heeft je een bericht gestuurd op %1$s.  %2$s schrijft:',
        'WELCOME_TO_THE_GROUP_X' => 'Welkom bij de groep "%s"',
        'WELCOME_TO_GROUP_X_ON_Y_ELLIPSIS' => 'Welkom bij %1$s op %2$s...',
        'TO_VIEW_THIS_GROUP_VISIT' => 'Om deze groep te bekijken, ga je naar:',
        'X_INVITES_YOU_TO_JOIN_Y' => '%1$s nodigt je uit om je aan te sluiten bij %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y' => '%1$s is nu lid van %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y_ELLIPSIS' => '%1$s is nu lid van %2$s...',
        'SOMEBODY' => 'Iemand',
        'TO_VIEW_YOUR_NEW_COMMENT_VISIT' => 'Om je nieuwe commentaar te bekijken ga je naar:',
        'TO_VIEW_THE_NEW_COMMENT_VISIT' => 'Om het nieuwe commentaar te bekijken ga je naar:',
        'TO_VIEW_THE_NEW_REPLY_VISIT' => 'Om de nieuwe reactie te bekijken ga je naar:',
        'WELCOME_TO_X_THANK_YOU_FOR_JOINING' => 'Welkom bij %s! Leuk dat je meedoet.',
        'NAME_COLON' => 'Naam:',
        'EMAIL_COLON' => 'E-mail:',
        'AGE_COLON' => 'Leeftijd:',
        'GENDER_COLON' => 'Geslacht:',
        'LOCATION_COLON' => 'Locatie:',
        'COUNTRY_COLON' => 'Land:',
        'GET_NETWORK_BADGE' => '%s-banner',
        'SPREAD_WORD_GET_BADGE' => 'Maak reclame voor je community! Haal je eigen %s-banner op voor je webpagina of MySpace-pagina. (<a %s>Code ophalen</a>)',
        'SPREAD_WORD_GET_BADGE_SHORT' => 'Maak reclame voor je community! <a href="%s">Haal je eigen %s-banner op</a>',
        'SHOW_ALLEGIANCE_GET_BADGE' => 'Toon je loyaliteit! Haal je eigen %s-banner op om op je webpagina of MySpace-pagina te plaatsen. (<a %s>Code ophalen</a>)',
        'USER_COMMENTED_ON_A_TYPE_ON_APPNAME' => '%1$s gaf commentaar op %2$s "%4$s" op %3$s',
        'UNABLE_TO_EXTRACT_EMAIL_ADDRESSES' => 'Onze verontschuldigingen â€“ We konden geen e-mailadressen uit het bestand halen.',
        'ADMINISTRATORS' => 'Systeembeheerders',
        'YOUR_INVITATION_HAS_EXPIRED' => 'Je uitnodiging is verlopen',
        'SORRY_INVITATION_EXPIRED' => 'Sorry, maar de uitnodiging die je hebt gebruikt is verlopen.  Je moet een nieuwe uitnodiging krijgen om je aan te kunnen sluiten bij %s.',
        'DISABLE_INVITATION_LINK' => 'Koppeling voor uitnodigen uitschakelen?',
        'CREATING_LINK_WILL_DISABLE' => 'Als je een nieuwe uitnodigingskoppeling maakt, wordt de huidige uitgeschakeld. Weet je zeker dat je een nieuwe koppeling wilt maken?',
        'SHARE_LINK_WITH_PEOPLE' => 'Deel deze koppeling met mensen die je wilt laten deelnemen aan deze community:',
        'CREATE_INVITATION_LINK' => 'Nieuwe koppeling tot uitnodigen aanmaken',
        'PLEASE_SELECT_SECOND_PART' => 'Selecteer het tweede gedeelte van je e-mailadres, bijv. gmail.com.',
        'AT_SYMBOL_NOT_ALLOWED' => 'Zorg ervoor dat het teken @ niet voorkomt in het eerste deel van het e-mailadres.',
        'SORRY_WE_DONT_SUPPORT' => 'Sorry, maar we bieden geen ondersteuning voor het webadresboek voor jouw e-mailadres. Klik op \'E-mailtoepassing\' hieronder als je wilt proberen adressen vanaf je computer te gebruiken.',
        'PLEASE_ENTER_PASSWORD_FOR_EMAIL' => 'Geef je wachtwoord voor %s.',
        'IMPORTING_ADDRESS_BOOK' => 'Adresboek wordt geïmporteerd',
        'LEAVE_WINDOW_WHILE_GET' => '<strong>Laat dit venster open</strong> totdat we de e-mailadressen van je vrienden hebben opgehaald. Wanneer dit klaar is, kun je kiezen welke vrienden je wilt uitnodigen.',
        'SHARE_THIS_LINK' => 'Deel deze koppeling:',
        'SEND_WITH_EMAIL_PROGRAM' => 'Verzend hem met het e-mailprogramma op je computer:',
        'EMAIL_THIS' => 'Dit e-mailen',
        'IS_YOUR_FRIEND_PARENTHESIZED' => '(is je vriend)',
        'CLEAR' => 'Leegmaken',
        'SEARCH_FRIENDS_TO_INVITE' => 'Vrienden zoeken om uit te nodigen:',
        'YOUR_INVITATIONS_HAVE_BEEN_SENT' => 'Je uitnodigingen zijn verzonden',
        'WANT_TO_INVITE_MORE' => 'Wil je meer vrienden uitnodigen? Nodig meer vrienden uit door contactpersonen uit je webadresboek of e-mailtoepassing te importeren.',
        'MESSAGE_TOO_LONG' => 'Het bericht is te lang. Beperk het bericht tot %s tekens en probeer het opnieuw.',
        'FOLLOWING_DO_NOT_SEEM_VALID' => 'De volgende e-mailadressen lijken niet geldig te zijn. De uitnodigingen zijn niet verzonden. Corrigeer de e-mailadressen en probeer het opnieuw.',
        'PLEASE_ENTER_EMAIL_ADDRESSES' => 'Voer een of meer e-mailadressen in.',
        'ENTER_EMAIL_ADDRESSES' => 'Voer e-mailadressen in',
        'SEPARATE_MULTIPLE_ADDRESSES' => 'Scheid meerdere adressen door middel van komma\'s',
        'YOUR_MESSAGE_OPTIONAL' => '<label>Jouw bericht</label> (optioneel)',
        'SEND_INVITATIONS' => 'Uitnodigingen verzenden',
        'WEB_ADDRESS_BOOK' => 'Webadresboek',
        'YAHOO_MAIL_HOTMAIL' => 'Yahoo Mail, Hotmail, GMail of AOL Mail',
        'YOUR_EMAIL_ADDRESS' => 'Jouw e-mailadres',
        'IMPORT_ADDRESS_BOOK' => 'Adresboek importeren',
        'DONT_WORRY_WE_WONT_SAVE' => 'Maak je geen zorgen, we slaan je wachtwoord niet op en je kunt kiezen welke vrienden je e-mail wilt sturen.',
        'EMAIL_APPLICATION' => 'E-mailtoepassing',
        'MICROSOFT_OUTLOOK_APPLE_MAIL' => 'Microsoft Outlook, Apple Mail, .CSV, enz.',
        'UPLOAD_CSV_OR_VCF' => 'Upload een .csv- of .vcf-bestand dat je eerder hebt geëxporteerd vanuit Microsoft Outlook of Apple Address Book.',
        'BROWSE_FOR_FILE' => 'Naar bestand bladeren',
        'UPLOAD' => 'Uploaden',
        'SELECT_ELLIPSIS' => 'selecteren…',
        'OTHER_ELLIPSIS' => 'overige…',
        'DONT_WORRY_YOULL_GET_CHANCE' => 'Maak je geen zorgen, je kunt kiezen welke vrienden je e-mail wilt sturen.',
        'MEMBERSHIP_BY_INVITATION_ONLY' => 'Lidmaatschap alleen op uitnodiging',
        'IF_YOU_ARE_ADMIN' => 'Als je een beheerder bent, <a %s>klik dan hier om je aan te melden</a>.',
        'NAME_MUST_BE_SHORTER' => 'De naam mag niet langer dan %s tekens zijn',
        'CITY_NAME_MUST_BE_SHORTER' => 'De plaatsnaam mag niet langer dan %s tekens zijn',
        'EMAIL_ALREADY_REGISTERED' => 'Dit e-mailadres is al geregistreerd. Kies een ander.',
        'EMAIL_NOT_VALID' => 'Het e-mailadres lijkt niet geldig te zijn.',
        'USERNAME_INVITED_YOU_TO_APPNAME' => '%s heeft je uitgenodigd bij %s',
        'YOU_ARE_SIGNING_UP_WITH' => 'Je wordt lid met je Ning-id.',
        'NOW_ENTER_PASSWORD' => 'Voer nu je wachtwoord in om door te gaan.',
        'OR_SIGN_IN' => 'of <a %s>Meld je aan</a>',
        'CHANGE_ADDRESS' => 'Adres wijzigen',
        'CHANGE_PAGE_ADDRESS' => 'Pagina-adres wijzigen',
        'PAGE_ADDRESS_TAKEN' => 'Helaas - die naam is al bezet. Kies iets anders.',
        'PAGE_ADDRESS_NOT_VALID' => 'Je mag alleen de letters A-Z, cijfers en lage streepjes (_) in je adres gebruiken.',
        'ADD_BY_PHONE' => 'Toevoegen via telefoon',
        'PAGE_ADDRESS' => 'Pagina-adres',
        'PHOTO_MUST_BE_TYPE' => 'Je foto moet een .jpg-, .gif- of .png-bestand zijn.',
        'USEFUL_ADDRESSES' => 'Nuttige adressen',
        'MY_DETAILS' => 'Mijn gegevens',
        'NONE_I_DO_NOT_WANT' => 'Geen: Ik wil geen e-mails ontvangen van %s',
        'CHANGE_PASSWORD' => 'Wachtwoord wijzigen',
        'PROFILE_SAVED' => 'Je wijzigingen zijn opgeslagen.',
        'UPDATE_EMAIL_ADDRESS' => 'E-mailadres bijwerken',
        'EDIT_EMAIL_ADDRESS' => 'Je e-mailadres bewerken',
        'MY_SETTINGS' => 'Mijn instellingen',
        'ABOUT_ME' => 'Over mij',
        'SELECT' => 'Selecteren...',
        'CITY' => 'Plaats',
        'COUNTRY' => 'Land',
        'DATE_OF_BIRTH' => 'Geboortedatum',
        'DO_NOT_DISPLAY' => 'Niet weergeven',
        'GENDER' => 'Geslacht',
        'CREATE_YOUR_PROFILE' => 'Stel je profiel samen',
        'SYSTEM_REQUIREMENTS' => 'Systeemvereisten',
        'WE_SUPPORT_INTERNET_EXPLORER' => 'Wij ondersteunen Internet Explorer 6 & 7, Firefox 2.0 en Safari 2.0. Als je een andere browser gebruikt (misschien is die je geleverd door je internetaanbieder) dan kan het zijn dat die niet compatibel is.',
        'MAKE_SURE_COOKIES' => 'Zorg ervoor dat je browser cookies en JavaScript accepteert.',
        'WHAT_IS_MY_EMAIL' => 'Wat is mijn e-mailadres?',
        'IF_JOINED_BEFORE_OCTOBER' => 'Als je al voor 5 oktober 2007 lid geworden bent, dan werd je vroeger misschien om een \'Ning-id\' gevraagd. Vanaf nu vragen we je om je aan te melden met het e-mailadres waarmee je bent geregistreerd. Je kunt echter nog steeds je Ning-id in dit veld invoeren.',
        'CLICK_HERE_TO_RESET_PASSWORD' => 'Klik hier om je wachtwoord terug te stellen.',
        'STILL_HAVING_PROBLEMS' => 'Heb je nog steeds problemen?',
        'VISIT_NING_HELP_CENTER' => 'Bezoek het <a %s>Ning ondersteuningscentrum</a> voor meer informatie over problemen en ondersteuning.',
        'PROBLEMS_SIGNING_UP_OR_SIGNING_IN' => 'Problemen bij lid worden of aanmelden',
        'WE_SENT_YOU_EMAIL' => 'We hebben je een e-mail gestuurd met een koppeling waarmee je je wachtwoord kunt terugstellen.',
        'RESET_PASSWORD_EMAIL_SUBJECT' => 'Wachtwoord terugstellen',
        'RESET_PASSWORD_EMAIL_BODY' => '%1$s,

we hebben een verzoek ontvangen om je wachtwoord voor %2$s te wijzigen.

Klik op onderstaande koppeling om een nieuw wachtwoord in te stellen:

#{URL}

Als je je wachtwoord niet wilt wijzigen, dan kun je deze e-mail negeren.

Dank je wel,
het "%2$s"-team

-----
%2$s gebruikt de Ning-id voor verificatie.',
        'SET_PASSWORD' => 'Wachtwoord instellen',
        'NEW_PASSWORD' => 'Nieuw wachtwoord',
        'CREATE_NEW_PASSWORD' => 'Een nieuw wachtwoord instellen',
        'SET_NEW_PASSWORD' => 'Stel een nieuw wachtwoord in voor je Ning-account.',
        'CHOOSE_NEW_PASSWORD' => 'Kies een nieuw wachtwoord',
        'HELLO_USERNAME_SIGN_OUT' => '<strong>Hallo, %s</strong> (<a %s>Afmelden</a>)',
        'NO_ACCOUNT_WITH_EMAIL_X' => 'Er is geen account met het e-mailadres %s',
        'PLEASE_ENTER_CODE' => 'Voer de code in die je aan de rechterkant ziet.',
        'PROBLEMS_SIGNING_UP' => 'Problemen met lid worden?',
        'BY_SIGNING_UP_YOU_AGREE' => 'Door je aan te melden als lid ga je akkoord met de <a %s>Algemene voorwaarden</a> en het <a %s>Privacybeleid</a>.',
        'FEEDBACK' => 'Feedback',
        'TERMS_OF_SERVICE' => 'Algemene voorwaarden',
        'PROBLEM_SIGNING_UP' => 'Er was een probleem met je aanmelding',
        'ALREADY_MEMBER_SIGN_IN' => 'Al lid? <a %s>Klik hier om je aan te melden</a>.',
        'MEMBERSHIP_TO_APPNAME_BY_INVITATION_ONLY' => 'Lidmaatschap voor %s is alleen op uitnodiging',
        'SORRY_BUT_ADMINISTRATOR_REQUIRES_INVITATION' => 'Sorry, maar de beheerder heeft een uitnodiging verplicht gesteld voor aanmelding bij %s. Als je een uitnodiging hebt, klik dan op de koppeling in de e-mail om je aan te sluiten.',
        'PROBLEM_SIGNING_IN' => 'Er was een probleem bij het aanmelden',
        'WE_USE_NING_ID' => 'We gebruiken de Ning-id voor verificatie. <a %s>Wat is een Ning-id?</a>',
        'PROBLEMS_SIGNING_IN' => 'Problemen met aanmelden?',
        'SIGN_IN_OR_SIGN_UP' => '<input %s value="Aanmelden" /> &#160;of&#160; <strong><a %s>Lid worden</a></strong>',
        'SIGN_IN_TO_APPNAME' => 'Meld je aan bij %s',
        'WHAT_IS_A_NING_ID' => 'Wat is een Ning-id?',
        'LARR_BACK' => '← <a %s>Terug</a>',
        'NING_ID_LETS_YOU_CHOOSE' => 'Met het Ning-id-verificatiesysteem kies je een keer een e-mailadres en wachtwoord, en meld je je vervolgens aan bij alle communities die gebruik maken van de Ning-id.',
        'WHEN_YOU_CREATE_NING_ID' => 'Wanneer je een Ning-id creëert, kun je ook een aantal basisgegevens en je foto toevoegen aan je Ning-account. Deze gegevens worden dan meteen ingevuld als je je aanmeldt bij een nieuwe community die de Ning-id gebruikt voor verificatie. Bovendien kun je zo je vrienden en berichten bijhouden op alle communities die hem gebruiken.',
        'SIGN_IN_WITH_NING_ID_WHENEVER' => 'Je kunt je aanmelden met je Ning-id-e-mailadres en -wachtwoord wanneer je dit symbool ziet: %s',
        'HELLO_USER' => 'Hallo, %s',
        'TEXT_FOR_HEADER_TAB' => 'Deze tekst is voor een koptabblad',
        'BASED_ON' => 'Gebaseerd op',
        'ARE_YOU_SURE_DELETE_LANGUAGE' => 'Weet je zeker dat je deze taal wilt verwijderen?',
        'DELETE_LANGUAGE' => 'Taal verwijderen',
        'TEXT_RESET_TO_ORIGINAL_VERSION' => 'De tekst is teruggesteld op de oorspronkelijke versie.',
        'UPLOAD_LANGUAGE_FILE' => 'Taalbestand uploaden',
        'ADD_TO_LANGUAGE' => 'Toevoegen aan taal:',
        'IF_YOU_CREATED_TRANSLATION' => 'Als je een nieuwe vertaling hebt gemaakt binnen een andere Ning-community, dan kun je je werk hier importeren. De inhoud van het bestand wordt toegevoegd aan de taal van je keuze. Staat jouw taal er niet bij? <a %s>Je kunt gemakkelijk een nieuwe toevoegen</a>.',
        'EXAMPLES_SWEDISH_FINLAND' => 'Voorbeelden: Zweeds (Finland), Filippijns, Spaans (Puerto Rico)',
        'START_FROM_SCRATCH_CREATE' => 'Begin met niets! Maak een nieuwe vertaling voor je community door een naam op te geven voor de nieuwe taal, en dan een bestaande taal te kiezen als startpunt.',
        'KEY_MISSING_TEXT' => 'Sleutel: <span %s>Ontbrekende tekst</span> <span %s>Gewijzigde tekst</span>',
        'SHOW_ALL_TEXT' => 'Alle tekst weergeven',
        'SHOW_MISSING_TEXT' => 'Ontbrekende tekst weergeven',
        'SHOW_CHANGED_TEXT' => 'Gewijzigde tekst weergeven',
        'EXAMPLES_TABS_MEMBERS_FRIENDS' => 'Voorbeelden: Tabbladen, Leden, Vrienden',
        'RESET_TEXT_TO_ORIGINAL_VERSION' => 'Tekst terugstellen naar oorspronkelijke versie',
        'ORIGINAL_TEXT_X' => 'Oorspronkelijke tekst  – %s',
        'EDIT_LANGUAGE_ON_NETWORK' => 'De taal van je community bewerken',
        'CUSTOMIZE_TEXT_ON_NETWORK_INCLUDING' => 'Pas tekst binnen de community naar believen aan, waaronder tabbladnamen, e-mailvoetteksten, foutmeldingen enzovoort.',
        'ACTIVE_LANGUAGE_IS_X' => '<em>De actieve taal voor je community is %1$s</em>. <a %2$s>Actieve taal wijzigen</a>',
        'CURRENT_LANGUAGE_OPTIONS' => 'Huidige taalopties',
        'ACTIVE' => 'Actief',
        'MY_LANGUAGES' => 'Mijn talen',
        'CREATE_NEW_TRANSLATION' => 'Een nieuwe vertaling maken',
        'DONT_SEE_LANGUAGE_LISTED_CREATE' => 'Staat jouw taal er niet bij? <strong><a %s>Maak een nieuwe vertaling voor je community</a></strong>.',
        'ADVANCED_IMPORT' => 'Geavanceerd importeren',
        'IF_YOU_TRANSLATED_A_LANGUAGE' => 'Als je een taal voor een bestaande community hebt vertaald, dan kun je <strong><a %s>je taalbestand importeren</a></strong> en het voor deze community gebruiken.',
        'LANGUAGE_EDITOR' => 'Taal bewerken',
        'PUBLIC' => 'Openbaar',
        'GRANDFATHERED_PRIVACY_SETTING' => 'Je huidige privacy-instelling, een publiek netwerk waar niet-leden alleen het aanmeldscherm kunnen zien, is niet langer beschikbaar.  Je privacy-instelling is niet gewijzigd, maar als je hier iets verandert, dan kun je niet meer terugkomen.  Het huidige equivalent is een privénetwerk waarbij iedereen zich kan aanmelden om lid te worden.',
        'NO_MISSING_ITEMS' => 'Er zijn geen ontbrekende onderdelen  – deze vertaling is 100%% complete. <a %s>Alle onderdelen bekijken.</a>',
        'NO_CHANGED_ITEMS' => 'Er zijn geen gewijzigde onderdelen.',
        'COULD_NOT_FIND_ITEMS_MATCHING' => 'Helaas  – we konden geen onderdelen vinden die overeenkomen met <em>%s</em>. <a %s>Alle onderdelen bekijken.</a>',
        'FILE_N' => 'Bestand %s',
        'TRANSLATION_FILE_HAS_FILENAME_LIKE' => 'Een Ning-vertalingsbestand heeft een bestandsnaam zoals <code>en_US.txt</code>. <a %s>Meer weten? Klik hier.</a>',
        'SELECT_TRANSLATION_FILE' => 'Kies vertalingsbestand:',
        'USE_THIS_TRANSLATION' => 'Gebruik deze vertaling',
        'FOLLOWING_ARE_MISSING_FROM_RULES' => 'Merk op dat de volgende onderdelen ontbreken uit onderstaande regels: %s',
        'ALL' => 'Alle',
        'MISSING' => 'Ontbrekende',
        'VIEW' => 'Weergeven',
        'TRANSLATION_CHANGES_SAVED' => 'Je wijzigingen zijn opgeslagen. Deze vertaling is %s%% compleet.',
        'TRANSLATION_CHANGES_SAVED_MAKE_CURRENT' => 'Je wijzigingen zijn opgeslagen. Deze vertaling is %s%% compleet. Wil je deze gebruiken als de huidige taal voor je community?',
        'TRANSLATION_UPLOAD_SUCCESSFUL' => 'Je upload is gelukt. Deze vertaling is %s%% compleet.',
        'TRANSLATION_UPLOAD_SUCCESSFUL_MAKE_CURRENT' => 'Je upload is gelukt. Deze vertaling is %s%% compleet. Wil je deze gebruiken als de huidige taal voor je community?',
        'X_IS_CURRENT_LANGUAGE' => '%s is nu de taal van je community.',
        'SAVE_PAGE' => 'Pagina opslaan',
        'LANGUAGE_NAME_TAKEN' => 'Helaas - die naam is al bezet. Kies een andere naam.',
        'ENTER_NAME_FOR_TRANSLATION' => 'Voer een naam in voor je nieuwe vertaling, bijv. Nederlands (België)',
        'CREATE' => 'Aanmaken',
        'LANGUAGE_NAME' => 'Naam van taal',
        'SAVE_ITEMS_ON_PAGE' => 'De onderdelen op deze pagina opslaan',
        'NEW_TRANSLATION' => 'Nieuwe vertaling',
        'MISMATCHED_CURLY_BRACKETS' => 'Accolades passen niet bij elkaar',
        'MISMATCHED_SQUARE_BRACKETS' => 'Vierkante haken passen niet bij elkaar',
        'MISMATCHED_PARENTHESES' => 'Haakjes passen niet bij elkaar',
        'ERROR_PROCESSING_SPECIAL_RULES' => 'Er is een fout opgetreden bij het verwerken van de code voor speciale-regels.',
        'ERROR_PROCESSING_TAB_NAMES' => 'Er is een fout opgetreden bij het verwerken van de code voor tabbladnamen.',
        'SPECIAL_RULES' => 'Speciale regels',
        'TAB_NAMES' => 'Tabbladnamen',
        'SOURCE' => 'Bron',
        'LANGUAGE_EDITOR_X' => 'Taal bewerken: %s',
        'BACK_TO_LANGUAGE_EDITOR' => '←Terug naar taal bewerken',
        'CUSTOMIZE_YOUR_NETWORKS_TEXT' => 'Pas de tekst en berichten van je netwerk aan of creëer een nieuwe taal.',
        'STOPWORDS' => 'aan | als | be | ben | bent | com | dat | de | dit | en | door | een | heb | hebben | het | hoe | ik | in | is | of | met | naar | nl | op | over | van | voor | waar | wanneer | was | wat | wie | www | zal | zijn',
        'STOPWORDS_ARE' => '<a %s>Stopwoorden</a> vormen een optionele lijst van woorden die uit de beschrijving van het netwerk moeten worden gefilterd bij het creëren van de meta-tag boven aan de verschillende pagina\'s. Optioneel.',
        'I_AM_MEMBER' => 'Ik ben lid van:',
        'VIEW_PAGE_ON_APPNAME' => 'Bekijk mijn pagina bij <em>%s</em>',
        'VISIT_APPNAME' => 'Bezoek <em>%s</em>',
        'JOIN_US' => 'Word lid',
        'CREATED_BY_COLON' => 'Aangemaakt door:',
        'GET_MORE_BADGES' => 'Meer banners',
        'SHOW_LOGO' => 'Geef logo weer',
        'GALLERY' => 'Galerie',
        'BADGES' => 'Banners',
        'MEMBER_BADGE' => 'Ledenbanner',
        'WEAR_IT_WITH_PRIDE' => 'Laat zien dat je er bent! Haal een %s-ledenbanner op die je op een andere webpagina of MySpace-pagina kunt plaatsen.',
        'NETWORK_BADGE_LARGE' => 'Banner (groot)',
        'SPREAD_THE_WORD_NETWORK_BADGE_LARGE' => 'Maak reclame voor je netwerk! Download een %s banner die dynamisch wordt geüpdatet met de populairste leden. Zet deze banner op je andere website(s) of profielpagina(\'s).',
        'NETWORK_BADGE_SMALL' => 'Banner (klein)',
        'SPREAD_THE_WORD_NETWORK_BADGE_SMALL' => 'Maak reclame voor je netwerk! Download een %s die je op een andere website, blog of profielpagina kunt plaatsen.',
        'PHOTO_SLIDESHOW_PROPER' => 'Diavoorstelling',
        'DISPLAY_SELECTION_OF_PHOTOS' => 'Laat een selectie van je beste foto\'s zien op een andere website, blog of profielpagina door onze stijlvolle diavoorstellingsspeler.',
        'MUSIC_PLAYER' => 'Muziekspeler',
        'PLAY_MUSIC_ON_WEBSITE' => 'Speel je eigen muziek op een website, of een pagina bij MySpacemet onze stijlvolle muziekspeler.',
        'ADD_A_VIDEO_MORE_OPTIONS' => 'Voeg een video toe aan je webpagina of MySpace-pagina. Meer opties? <a href="%s">Toon alle video\'s</a> op %s.',
        'LARGE_N_PIXELS_WIDE' => 'Groot - %d pixels breed',
        'MEDIUM_N_PIXELS_WIDE' => 'Medium - %d pixels breed',
        'SMALL_N_PIXELS_WIDE' => 'Klein - %d pixels breed',
        'MY_MOST_RECENT' => 'Mijn meest recente',
        'APP_ICON' => 'Applicatie-pictogram',
        'MEMBERSHIP_TO_X_IS_BY_INVITATION' => 'Lidmaatschap van %s is uitsluitend op uitnodiging',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK' => '%s heeft de volgende reactie gegeven:',
        'X_PROVIDED_FEEDBACK_ON_Y_ELLIPSIS' => '%1$s heeft gereageerd op %2$s...',
        'THANK_YOU_YOUR_MESSAGE_HAS_BEEN_SENT' => 'Bedankt. Je bericht is verzonden.',
        'X_WOULD_LIKE_TO_JOIN_X' => '%s wil lid worden van %s!',
        'X_HAS_REQUESTED_AN_INVITATION' => '%s heeft een uitnodiging ontvangen voor %s',
        'YOUR_REQUEST_HAS_BEEN_SENT' => 'Je verzoek is naar de initiatiefnemer van het netwerk verzonden.',
        'TO_UNBAN_USERNAME_GO_TO' => 'Als je %s weer wilt toelaten, ga dan naar:',
        'SEND_REQUEST' => 'Verzoek verzenden',
        'SEARCH' => 'Zoeken',
        'SEARCH_AGAIN' => 'Nogmaals zoeken',
        'SEND_BROADCAST_MESSAGE' => 'Algemeen bericht verzenden',
        'VERIFICATION_IMAGE' => 'Verificatie-afbeelding',
        'UNDER_CONSTRUCTION' => 'Wordt aan gewerkt',
        'PROFILE_INFORMATION_SAVED' => 'Profielinformatie opgeslagen',
        'YOUR_SITES_DIRECTORY_PROFILE' => 'De profielinformatie van je communitymap is opgeslagen.',
        'NO_ACCOUNT_WITH_EMAIL' => 'Er is geen account met dat e-mailadres.',
        'INVALID_PASSWORD_CHECK_CAPS_LOCK' => 'Onjuist wachtwoord.  Staat Caps Lock aan?',
        'OOPS_THAT' => 'Oeps  – dat ging niet goed.',
        'OOPS_THAT_DID_NOT_WORK' => 'Oeps  – dat ging niet goed.  Nog eens proberen?',
        'OOPS_THAT_DID_NOT_WORK_ERROR_CODE' => 'Oeps  – dat ging niet goed (%s).',
        'NOT_FOUND' => 'Niet gevonden',
        'YOUR_SITES_FEATURE_LIST' => 'De lijst met functies van je netwerk is opgeslagen.',
        'ONE_LINE_ANSWER' => 'Antwoord van één regel',
        'LONGER_ANSWER' => 'Langer antwoord',
        'MULTIPLE_CHOICE' => 'Meerkeuze',
        'DATE' => 'Datum',
        'WEBSITE_ADDRESS' => 'Adres website',
        'EVERYTHING' => 'Alles',
        'JUST_THE_HOMEPAGE' => 'Alleen de hoofdpagina',
        'JUST_THE_SIGN_UP_PAGE' => 'Alleen de inschrijfpagina',
        'YOUR_CHANGES_HAVE_BEEN_SAVED' => 'De wijzigingen zijn opgeslagen.',
        'JOIN_ME_ON_X' => 'Sluit je bij me aan op %s!',
        'NOT_ALLOWED' => 'Niet toegestaan',
        'COME_JOIN_ME_ON_X' => 'Sluit je bij me aan op %s!',
        'COME_JOIN_ME_ON_X_ELLIPSIS' => 'Sluit je bij me aan op %s...',
        'X_NOT_VALID_EMAIL' => '%s is geen geldig e-mailadres of Ning ID',
        'USER_BANNED_FROM_NETWORK' => '%1$s is verwijderd uit deze community. <a %2$s>Stuur %1$s een bericht</a>',
        'USER_ALREADY_NETWORK_MEMBER' => '%1$s is al lid van deze community. <a %2$s>Stuur %1$s een bericht</a>',
        'YOU_CAN_SEND_AT_MOST_X' => 'Je kunt er hoogstens %s tegelijk sturen.',
        'PLEASE_ENTER_YOUR_FRIENDS' => 'Voer de e-mailadressen of Ning ID\'s van je vrienden in',
        'THERE_HAS_BEEN_AN_ERROR' => 'Er is iets misgegaan',
        'INVITATIONS_HAVE_BEEN_SENT' => 'Je uitnodigingen zijn verzonden.',
        'SEARCH_RESULTS' => 'Zoekresultaten',
        'INVITE_YOUR_FRIENDS' => 'Nodig je vrienden uit',
        'SEND_INVITATIONS_FOR_FRIENDS' => 'Stuur je vrienden een uitnodiging om zich aan te sluiten bij',
        'INVITATION' => 'Uitnodiging',
        'ADD_FROM_ADDRESS' => 'Toevoegen vanuit Adresboek',
        'TO' => 'Aan:',
        'SEND_TO' => 'Verzenden aan',
        'SUBJECT' => 'Onderwerp',
        'YOUR_MESSAGE' => 'Je bericht',
        'SEND' => 'Verzenden',
        'REPORT_AN_ISSUE' => 'Een probleem rapporteren?',
        'TYPE_OF_ISSUE' => 'Soort probleem',
        'ADULT' => 'Ongeschikt voor kinderen',
        'ABUSIVE' => 'Beledigend',
        'BUG' => 'Bug',
        'FRAUD' => 'Bedrog',
        'SPAM' => 'Spam',
        'OTHER' => 'Overige',
        'DESCRIBE_YOUR_ISSUE' => 'Omschrijving',
        'SEND_REPORT' => 'Melding verzenden',
        'ADDED_BY_X_AT_X' => 'Toegevoegd door <a %s>%s</a> op %s op %s',
        'ADDED_BY_USER_TO_GROUP_AT_DATE' => 'Toegevoegd door <a %s>%s</a> aan %s op %s op %s',
        'G_IA' => 'g:ia',
        'F_JS_Y' => 'F jS, Y',
        'CLICK_TO_VIEW' => 'Klik om te bekijken',
        'COMMENT_FOR' => 'Opmerking voor:',
        'COMMENT_ON' => 'Opmerking over:',
        'ACTION_BUTTON_FEATURE' => 'Onderwerp',
        'FEATURE_THIS_ON_YOUR' => 'Plaats dit op de hoofdpagina',
        'ACTION_BUTTON_REMOVE' => 'Verwijderen',
        'REMOVE' => 'Verwijderen',
        'REMOVE_THIS_FROM_YOUR' => 'Verwijder dit van de hoofdpagina',
        'FEATURE_ON_HOME' => 'Op hoofdpagina plaatsen',
        'REMOVE_FROM_HOME' => 'Van hoofdpagina verwijderen',
        'ITEM_WILL_APPEAR' => 'Dit item wordt nu weergegeven op geselecteerde modules op de hoofdpagina',
        'ITEM_WILL_NO_LONGER_APPEAR' => 'Dit item wordt niet meer weergegeven op geselecteerde modules op de hoofdpagina',
        'ADD_CONTENT' => 'Materiaal toevoegen',
        'BROUGHT_TO_YOU_BY' => '%s is een initiatief van %s © %s',
        'GIVE_US_YOUR_FEEDBACK' => 'Geef ons je feedback',
        'FOR_ADDITIONAL_QUESTIONS_OR_TO_CONTACT_NING_PLEASE_CLICK_HERE' => 'Voor andere vragen of om contact op te nemen met Ning klikt u hier:',
        'SEND_FEEDBACK' => 'Feedback verzenden',
        'SIGN_OUT' => 'afmelden',
        'SIGN_OUT_TITLE' => 'Afmelden',
        'EDIT_MY_PROFILE' => 'Mijn profiel bewerken',
        'INVITE_MORE' => 'Meer uitnodigen',
        'USE_THIS_FORM_TO_SEND_FEEDBACK_TO_NC' => 'Met dit formulier stuurt u commentaar naar <a %s>%s</a>, de initiatiefnemer van <a %s>%s</a>.',
        'YOUR_FEEDBACK' => 'Je feedback',
        'NETWORK_INFORMATION' => 'Netwerkinformatie',
        'ABOUT_YOUR_SITE' => 'Over je netwerk',
        'WELCOME_TO_YOUR_SITE' => 'Welkom bij ons netwerk!',
        'EDIT_YOUR_NETWORKS_INFO' => 'De naam, de beschrijving en andere informatie over je netwerk bewerken.',
        'TAGLINE' => 'Tagline',
        'APPEARS_IN_HEADER' => 'Wordt in de header van je netwerk weergegeven',
        'APPEARS_IN_EMAILS' => 'Wordt in e-mails en op andere plekken weergegeven',
        'NETWORK_NAME' => 'Naam netwerk',
        'DESCRIPTION' => 'Beschrijving',
        'KEYWORDS' => 'Trefwoorden',
        'LANGUAGE' => 'Taal',
        'SEPARATE_EACH_KEYWORD' => 'Zet komma\'s tussen de verschillende trefwoorden',
        'ICON' => 'Pictogram',
        'UPLOAD_A_PHOTO_WHICH_WILL_BE_RESIZED' => 'Je kunt een kleine foto uploaden (GIF, JPG of PNG), die dan vierkant wordt gemaakt.. Het kan een paar minuten duren voordat deze foto verschijnt!',
        'SAVE_SETTINGS' => 'Instellingen opslaan',
        'SUCCESS_EXCLAMATION' => 'Succes!',
        'FEATURES' => 'Onderdelen',
        'ADD_FEATURES' => 'Voeg functies toe aan je netwerk',
        'ORGANIZE_FEATURES' => 'Organiseer je hoofdpagina door functies uit onderstaande lijst te slepen en ze vervolgens op jouw manier te rangschikken.',
        'SKIP_FEATURES' => 'Klik op <a href="%s">Deze stap overslaan</a> als je wilt doorgaan met de standaardopmaak en -functies.',
        'FEATURES_FOR_ALL_PAGES' => 'Functies die je aan dit vak toevoegt, verschijnen op alle pagina\'s van je netwerk.',
        'CUSTOMIZE_SITE_BY_ADDING' => 'Pas je netwerk aan door nieuwe onderdelen toe te voegen of bestaande te verwijderen.',
        'ADJUST_YOUR_SITES_COLORS' => 'Bewerk de kleuren, afbeeldingen en algehele stijl van je netwerk.',
        'APPEARANCE' => 'Vormgeving',
        'PROFILE_QUESTIONS' => 'Profielvragen',
        'EDIT_QUESTIONS_THAT_MEMBERS_ANSWER' => 'De vragen die leden over zichzelf beantwoorden bewerken.',
        'MESSAGE_SENT' => 'Bericht verzonden!',
        'YOUR_MESSAGE_HAS_BEEN_SENT' => 'Je bericht is verzonden naar alle leden van je netwerk.',
        'YOUR_MESSAGE_HAS_BEEN_SENT_GROUP' => 'Je bericht is verzonden naar alle leden van je groep.',
        'YOUR_MESSAGE_IS_BEING_SENT' => 'Je bericht wordt verzonden. Even geduld want het kan enkele minuten duren.',
        'BROADCAST_MESSAGE' => 'Algemeen bericht',
        'TRACK_VISITORS_AND_TRENDS' => 'Houd cijfers bij over bezoekers en trends op je community.',
        'EDIT_SOURCE_CODE' => 'Broncode bewerken',
        'TAKE_FULL_CONTROL' => 'Bepaal zelf alle functionaliteit van je netwerk door de broncode te bewerken.',
        'DELETE_THIS_SITE' => 'Je netwerk verwijderen',
        'MAIN_PAGE' => 'Hoofdpagina',
        'MAIN' => 'Hoofdpagina',
        'MAIN_TAB_TEXT' => 'Hoofdpagina',
        'MANAGE' => 'Beheren',
        'MANAGE_TAB_TEXT' => 'Beheren',
        'PAGE_TITLE' => 'Paginatitel',
        'LOREM_IPSUM_1' => 'Lorem <span %s>ipsum dolor</span> sit amet, consectetuer adipiscing elit. Nunc scelerisque blandit dolor. Vestibulum ante ipsum primis in faucibus orci luctus.',
        'LOREM_IPSUM_2' => 'Lorem ipsum dolor sit amet, consectetuer adipiscing',
        'LOREM_IPSUM_3' => 'Lorem ipsum dolor sit amet, <span class="preview_link">consectetuer</span> adipiscing',
        'EDIT_THE_APPEARANCE' => 'De vormgeving van je pagina bewerken',
        'CHOOSE_A_THEME' => 'Een thema kiezen voor je netwerk',
        'NOW_CUSTOMIZE_SITE' => 'Pas nu je netwerk aan aan je persoonlijke voorkeuren...',
        'THEME_SETTINGS' => 'Thema-instellingen',
        'ADVANCED' => 'Geavanceerd',
        'TOP_BAR_AND_FOOTER' => 'Topbalk en onderkant',
        'HEADER_AND_NAVIGATION' => 'Header en navigatie',
        'ADD_A_LOGO' => 'Een logo toevoegen',
        'THIS_IMAGE_WILL_REPLACE' => 'Deze afbeelding vervangt de naamtekst van het netwerk',
        'TABS' => 'Tabs',
        'TAB' => 'Tabblad',
        'SITE' => 'Netwerk',
        'SIDES' => 'Zijkanten',
        'BODY' => 'Tekst van het bericht',
        'SHOW_NING_LOGO' => 'Ning-logo weergeven?',
        'LAUNCH' => 'STARTEN',
        'NING_ID' => 'Ning ID',
        'PASSWORD' => 'Wachtwoord',
        'RETYPE_PASSWORD' => 'Herhaal je wachtwoord',
        'TYPE_CODE_ON_RIGHT' => 'Typ de code<br />rechts',
        'JOIN_X' => 'Sluit je aan bij %s',
        'SIGN_UP_FOR_X' => 'Word lid van %s',
        'HAS_INVITED_YOU_TO_X' => 'heeft je uitgenodigd om je aan te sluiten bij %s.',
        'CONTENT_AWAITING_APPROVAL' => 'Materiaal in afwachting van goedkeuring:',
        'NEW_MEMBER' => 'Nieuw lid?',
        'JOIN_X_NOW' => 'Sluit je nu aan bij %s!',
        'HIDE_THIS_MESSAGE' => 'Dit bericht verbergen',
        'PAGE_NOT_FOUND' => 'Pagina niet gevonden',
        'THIS_PAGE_WAS_NOT_FOUND' => 'Helaas  – deze pagina is niet gevonden',
        'FOLLOW_THESE_LINKS_TO' => 'Volg deze koppelingen naar locaties die wel beschikbaar zijn:',
        'ALTERNATIVELY_YOU_CAN_SEARCH' => 'Je kunt ook zoeken binnen dit netwerk:',
        'IF_YOU_GET_THIS_MESSAGE' => 'Als je dit bericht weer krijgt, <a %s>laat het ons dan weten.</a>',
        'GROUP_MEMBERS' => 'Leden groep',
        'VIDEOS' => 'Video\'s',
        'BLOG' => 'Blog',
        'ACCOUNT' => 'Account',
        'WE_ARE_SORRY_WE_ARE_HAVING' => 'Sorry, er is iets mis met deze pagina.',
        'FOLLOW_LINK_TO_HOMEPAGE' => 'Volg <a %s>deze koppeling</a> naar de hoofdpagina.',
        'REQUEST_AN_INVITATION' => 'Om een uitnodiging verzoeken',
        'NAME' => 'Naam',
        'EMAIL_ADDRESS' => 'E-mailadres',
        'MESSAGE_OPTIONAL' => 'Bericht (optioneel)',
        'SORRY_HOWEVER_ITS_EASY' => '<strong>Sorry!</strong> Maar je kunt gemakkelijk een eigen netwerk opzetten.',
        'GET_YOUR_OWN_BAZEL' => 'Start je eigen netwerk!',
        'SITE_IS_NOT_READY' => 'Dit netwerk is nog niet klaar!',
        'BAZEL_IS_BEING_SET_UP' => 'Dit netwerk is nog in oprichting!',
        'SIGN_IN' => 'Aanmelden',
        'FORGOT_YOUR_PASSWORD' => 'Je wachtwoord vergeten?',
        'FORGOT_YOUR_PASSWORD_TITLE' => 'Je wachtwoord vergeten?',
        'ENTER_EMAIL_AND_CLICK_RESET_PASSWORD' => 'Geef je e-mailadres en klik op \'Wachtwoord herstellen\'. Je krijgt dan een e-mail met een koppeling waarmee je je wachtwoord kunt herstellen.',
        'RESET_PASSWORD' => 'Wachtwoord herstellen',
        'EXPLORE' => 'Verkennen',
        'SIGN_UP' => 'Inschrijven',
        'CONFIRM_PASSWORD' => 'Wachtwoord bevestigen',
        'VERIFICATION' => 'Laat ons weten dat je echt iemand bent',
        'YOUR_PHOTO' => 'Je foto',
        'SUMMARY' => 'Samenvatting',
        'YOUR_SITE_IS_READY' => 'Je netwerk is klaar voor de start! Voor de stappen die je hebt overgeslagen, worden de standaardinstellingen gebruikt. Ga terug om wijzigingen aan te brengen, of klik op \'Starten!\' om je netwerk te starten.',
        'WHEN_YOU_ARE_FINISHED' => 'Als je klaar bent, kun je op \'Opmaak weergeven\' klikken om je werk te bekijken!',
        'COMPLETE' => 'compleet',
        'INCOMPLETE' => 'niet compleet',
        'VIEW_LAYOUT' => 'Opmaak bekijken',
        'CLEAR_CONTENTS' => 'Inhoud wissen',
        'ADD_MODULE' => 'Module toevoegen...',
        'ADD_COLUMNS' => 'Kolommen toevoegen...',
        'PUBLIC_ANYBODY_CAN_JOIN' => '<strong>Openbaar</strong> – Iedereen kan zich aansluiten',
        'PRIVATE_ONLY_INVITED' => '<strong>Privé</strong>  – Alleen mensen die zijn uitgenodigd kunnen bekijken en zich aansluiten',
        'INVITATIONS' => 'Uitnodigingen',
        'MEMBERS_CAN_INVITE' => 'Leden kunnen anderen uitnodigen om zich aan te sluiten',
        'QUESTION_TITLE' => 'Titel vraag',
        'ANSWER_TYPE' => 'Type antwoord',
        'REQUIRED' => 'Verplicht?',
        'PRIVATE' => 'Privé',
        'CHOICES' => 'Keuzemogelijkheden',
        'SEPARATE_EACH_CHOICE' => 'Zet komma\'s tussen de verschillende keuzemogelijkheden',
        'CAN_PICK_MORE' => 'Kan meer dan één kiezen',
        'ADD_ANOTHER_QUESTION' => 'Nog een vraag toevoegen',
        'WHAT_INFORMATION' => 'Welke vragen wil je dat de leden die zich bij je netwerk aansluiten beantwoorden? Je kunt de onderstaande vragen in een andere volgorde zetten. Klik op een vraag en sleep hem naar de plek waar hij moet verschijnen.',
        'IF_YOU_SELECT_REQUIRED_MEMBERS_WILL' => 'Als je "Verplicht" selecteert, moeten leden de vraag beantwoorden voordat ze zich kunnen aansluiten. Als je "Privé" selecteert, is het antwoord alleen voor jou en andere beheerders zichtbaar.',
        'WE_COULD_NOT_FIND_ANYTHING' => 'We konden niets vinden dat overeenkomt met \'%s\'. Wil je naar iets anders zoeken?',
        'GET_CUSTOM_URL' => 'Bepaal zelf je URL, voeg opslag en bandbreedte toe, of plaats je eigen advertenties.',
        'TRACK_STATISTICS' => 'Statistieken nagaan',
        'TRACKING_CODE' => 'Tracking-code',
        'ANY_JAVASCRIPT_CODE' => 'De JavaScript-code die je hier plaatst, wordt aan iedere pagina in je netwerk toegevoegd. Je kan deze code gebruiken ten behoeve van externe tellers en meetsysteemen, zoals Google Analytics.',
        'ANALYTICS_LEARN_MORE' => 'Om meer over Google Analytics te weten te komen en je eigen account te starten, <a %s>klik hier</a>.',
        'RESOURCES' => 'Bronnen',
        'LINKS' => 'Koppelingen',
        'PAGE' => 'Pagina',
        'BACKGROUND' => 'Achtergrond',
        'TEXT' => 'Tekst',
        'HEADING_TEXT' => 'Koptekst',
        'FONT' => 'Lettertype',
        'AABBCC' => 'AaBbCc',
        'COLOR' => 'Kleur',
        'LINK_COLOR' => 'Kleur koppeling',
        'BODY_TEXT' => 'Hoofdtekst',
        'MIDDLE' => 'Midden',
        'FEATURE_BOXES' => 'Vakken voor functies',
        'TITLEBAR_TEXT_COLOR' => 'Tekstkleur titelbalk',
        'TITLEBAR_BACKGROUND' => 'Achtergrond titelbalk',
        'UPLOADING_CONTENT' => 'Bezig met het uploaden van materiaal...',
        'WHEN_UPLOADING_IS_COMPLETE' => 'Als de upload voltooid is, kun je het netwerk bekijken.',
        'FINISH' => 'Voltooien',
        'FLICKR_IMPORT_SETUP' => 'Flickr importeerinstellingen',
        'FLICKR_API_KEY' => 'Je sleutel',
        'FLICKR_SECRET' => 'Je geheim',
        'FLICKR_KEY_ERROR' => 'Er was iets mis met de Flickr-sleutel of het Flickr-geheim dat je hebt ingevoerd. Kijk ze na en voer ze opnieuw in.',
        'FLICKR_INTRO' => 'Wil je je leden toestaan om foto\'s te importeren vanuit Flickr? Dat kan hier. Als je al een Flickr API-sleutel en -geheim hebt, kun je <a %s>doorgaan</a>. Weet je niet precies weet wat dit betekent? Volg de onderstaande stappen, dan kun je binnen een paar minuten aan de slag.',
        'FLICKR_GET_ACCOUNT' => 'Als je nog geen Flickr-account hebt, maak er dan <a %s>hier</a> een aan.',
        'FLICKR_STEP1_TITLE' => 'Stap 1: Een Flickr API-sleutel ophalen',
        'FLICKR_STEP1_APPLY_SCREEN' => 'Vraag een API-sleutel aan bij Flickr',
        'FLICKR_STEP1_API_SCREEN' => 'API-sleutelscherm op Flickr',
        'FLICKR_STEP1_INTRO' => 'Login bij Flickr en <a %s>vraag een nieuwe API-sleutel aan</a> (pagina opent in een nieuw venster).',
        'FLICKR_STEP1_A' => 'Vul je <strong>naam</strong> en <strong>e-mailadres</strong> in.',
        'FLICKR_STEP1_B' => 'Bij de optie <strong>\'This key is for&hellip;\'</strong> kies voor <em>\'non-commercial use\'</em>.',
        'FLICKR_STEP1_C' => 'In het veld <strong>\'Describe the application are you planning to build\'</strong> beschrijf je je community.',
        'FLICKR_STEP1_D' => 'Vink beide hokjes aan bij de acceptatieverzoeken.',
        'FLICKR_STEP1_APPLY' => 'Als je klaar bent, klik dan op de knop <strong>\'Apply- \'</strong>.',
        'FLICKR_STEP1_E' => 'Je krijgt nu een scherm te zien met je nieuwe API-sleutel. Klik op de koppeling <strong>\'Click here\'- </strong> om de gebruikerskenmerken voor deze sleutel in te stellen.',
        'FLICKR_STEP2_TITLE' => 'Stap 2: Je sleutel instellen',
        'FLICKR_STEP2_SETUP_SCREEN' => 'Instellingenscherm API-sleutel op Flickr',
        'FLICKR_STEP2_F' => 'Knip en plak het volgende webadres in het veld <strong>\'Callback URL\'</strong>:',
        'FLICKR_STEP2_SAVE_CHANGES' => 'Als je klaar bent, klik dan op de knop <strong>\'Save Changes\'-knop</strong>.',
        'FLICKR_STEP3_TITLE' => 'Stap 3: Vul je gegevens in',
        'FLICKR_STEP3_KEYS_SCREEN' => 'Gegevensscherm API-sleutel op Flickr',
        'FLICKR_STEP3_CONGRATULATIONS' => 'Proficiat! je hebt Flickr nu goed ingesteld.',
        'FLICKR_STEP3_COMPLETE' => 'Om de installatie bij %s af te maken, kopieer je je sleutel en het geheim in de volgende velden:',
        'COMPLETE_SETUP' => 'Configuratie voltooien',
        'SETUP_YOUR_SITE_TO' => 'Configureer je netwerk voor het importeren van foto\'s vanaf Flickr.',
        'FLICKR_IMPORTING' => 'Flickr-foto\'s importeren',
        'YOU_NEED_TO_SET_UP_FLICKR' => 'Je moet eerst je community configureren als je mensen hun foto\'s wilt laten importeren vanaf Flickr. Dit duurt slechts enkele minuten, dus waarom niet <a %s>nu even configureren?</a>',
        'DONT_SHOW_THIS_AGAIN_FLICKR' => 'Deze melding niet meer weergeven.',
        'YOUVE_SIGNED_OUT_OF_X' => 'Je hebt je afgemeld bij %s. Kom snel weer eens kijken!',
        'CREATED_THIS_SOCIAL_NETWORK' => 'heeft dit netwerk opgezet op <a href=\'http://www.ning.com\'>Ning</a>.',
        'CREATE_YOUR_OWN' => 'Richt gratis je eigen netwerk op met Ning!',
        'DRAG_HERE_TO_REMOVE_FEATURE' => 'Sleep de functie hierheen om hem te verwijderen',
        'LAYOUT' => 'Opmaak',
        'DRAG' => 'Slepen',
        'HERE' => 'Hier',
        'YOU' => 'Jij',
        'ADS' => 'Advertenties',
        'MEMBERS' => 'Leden',
        'HELLO_USERNAME' => 'Hallo, gebruikersnaam',
        'CREATED_BY' => 'Gemaakt door:',
        'SAVE_FEATURES' => 'Onderdelen opslaan',
        'FORUM' => 'Forum',
        'CATEGORIES' => 'Categorieën',
        'FORUM_CATEGORIES' => 'Forumcategorieën',
        'A_THREADED_DISCUSSION_FORUM' => 'Een discussieforum met threads',
        'ALLOW_MEMBERS_TO_CREATE_GROUPS' => 'Laat leden eigen interessegroepen creeëren binnen jouw netwerk',
        'FEATURE_POSTS_FROM_YOUR_BLOG' => 'Presenteer materiaal van je blog of van de blogs van andere leden',
        'TEXT_BOX' => 'Tekstvak',
        'PUT_ANY_TEXT_WIDGET_OR_HTML' => 'Plaats willekeurige tekst, widgets of HTML op de hoofdpagina',
        'A_LIST_OF_MEMBERS' => 'Een lijst met de leden van je netwerk',
        'ALLOW_USERS_PHOTOS' => 'Geef mensen toestemming foto\'s up te loaden en te laten zien',
        'ADD_FEEDS_FROM_ACROSS_THE_WEB' => 'Voeg feeds toe vanuit het hele internet',
        'INFORMATION_ABOUT_THE_USER' => 'Informatie over de persoon die momenteel is aangemeld',
        'ALLOW_USERS_VIDEOS' => 'Laat mensen video\'s toevoegen en delen',
        'SHOW_NETWORK_DESCRIPTION' => 'Geef de beschrijving van je netwerk weer',
        'PROMOTE_NETWORK_WITH_BADGES' => 'Maak reclame voor je netwerk op het internet met aangepaste banners en widgets',
        'MONETIZE_WITH_ADS' => 'Verdien geld aan je netwerk met advertenties',
        'LET_MEMBERS_KNOW_WHO_CREATED_NETWORK' => 'Laat je leden weten wie dit netwerk heeft gesticht',
        'FOLLOW_LATEST_ACTIVITY' => 'Volg recente activiteit van leden binnen je netwerk',
        'FAQ_FOR_NETWORK_CREATORS' => 'Veelgestelde vragen voor initiatiefnemers netwerk',
        'ANSWERS_TO_FAQS' => 'Antwoorden op veelgestelde vragen over het aanpassen van jouw netwerk.',
        'MEET_OTHER_LIKEMINDED' => 'Geestverwanten leren kennen, ideeën delen en ondersteuning krijgen van het Ning-team.',
        'CUSTOMIZE_THE_APPEARANCE_NETWORK' => 'Pas de vormgeving van je netwerk aan door toevoeging van je eigen Cascading Style Sheets (CSS) aan het veld links. (<a href="%s">Wat is een CSS?</a>)',
        'CUSTOMIZE_THE_APPEARANCE_PAGE' => 'Pas de vormgeving van je pagina aan door je eigen Cascading Style Sheets (CSS) toe te voegen aan het veld links. (<a href="%s">Wat is CSS?</a>)',
        'CSS_ON_YOUR_SOCIAL_NETWORK' => 'CSS op je community',
        'CSS_ON_YOUR_PAGE' => 'CSS op je pagina',
        'ADDING_YOUR_OWN_CSS_NETWORK' => 'Door je eigen CSS aan je pagina toe te voegen, krijg je volledige controle over de lettertypen, kleuren, spatiëring en algemene stijl van je pagina.',
        'ADDING_YOUR_OWN_CSS_PAGE' => 'Door je eigen CSS aan je pagina toe te voegen, krijg je volledige controle over de lettertypen, kleuren, spatiëring en algemene stijl van je pagina.',
        'CSS_STYLES_WILL_OVERRIDE' => 'De CSS-stijlen die je hier toevoegt, vervangen eventuele bestaande CSS-stijlen die je eerder hebt gekozen.',
        'NEED_HELP_FIGURING_OUT_CSS' => 'Heb je hulp nodig bij het uitzoeken van de naam van een bepaalde CSS-klasse voor je netwerk? Wij adviseren het gebruik van de functie \'Inspect\' van de gratis uitbreidingstoepassing <a href="%s">Firebug</a> (voor de browser Firefox).',
        'WANT_TO_LEARN_MORE' => 'Wil je hier meer over weten ? Bekijk dan het gedeelte <a href="%s">Geavanceerde aanpassing</a>.',
        'APPLY_XS_THEME' => 'Pas het thema van %s toe',
        'X_ALREADY_REGISTERED_Y_TO_RESET' => 'Er is al een Ning ID aangemaakt in combinatie met het e-mail adres %s. Log  hieronder in met je Ning-ID of e-mailadres. Wanneer je je wachtwoord bent vergeten, <a href="%s">klik dan hier om je wachtwoord opnieuw in te stellen</a>.',
        'INVITED' => 'Uitgenodigd',
        'REQUESTED_INVITE' => 'Aangevraagde uitnodiging',
        'BAN_FROM_NETWORK' => 'Uit netwerk verwijderen',
        'REMOVE_BAN' => 'Verwijdering opheffen',
        'CANCEL_INVITATION' => 'Uitnodiging annuleren',
        'IGNORE' => 'Negeren',
        'PROMOTE_TO_ADMINISTRATOR' => 'Maak beheerder',
        'DEMOTE_FROM_ADMINISTRATOR' => 'Schrap beheerdersstatus',
        'STATUS' => 'Status',
        'DATE_JOINED' => 'Datum lid geworden',
        'DATE_INVITED' => 'Datum uitgenodigd',
        'DATE_REQUESTED' => 'Datum aangevraagd',
        'DATE_APPLIED' => 'Datum aangemeld',
        'NETWORK_CREATOR' => 'Initiatiefnemer netwerk',
        'NETWORK_ADMINISTRATOR' => 'Beheerder',
        'ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Leden met beheerdersbevoegdheden hebben dezelfde rechten als de initiatiefnemer van het netwerk.',
        'DOWNLOAD_ALL_MEMBER_DATA' => 'Alle ledengegevens exporteren (.csv)',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Je ledengegevens zijn geëxporteerd.  Klik rechts op <a %s>deze koppeling</a> en kies \'Opslaan als\' als je ze naar je bureaublad wilt opslaan.',
        'CLICK_GO_TO_START_EXPORT' => 'Klik op Gaan! om het exporteren te starten.  Als je veel leden hebt, kan dit een paar minuten duren.',
        'MEMBER' => 'Lid',
        'INVITED_BY_X' => 'Uitgenodigd door %s',
        'DONE' => 'Klaar',
        'YOU_HAVE_BEEN_BANNED_FROM_APPNAME' => 'Je bent verwijderd uit %s',
        'MESSAGE_TO_ADMINISTRATOR' => 'Bericht aan de beheerder',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS_IF_YOU_THINK' => 'Sorry, %s, je hebt geen toegang tot %s omdat je bent verwijderd. Als je denkt dat je ten onrechte bent verwijderd, neem dan contact op met de beheerder.',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS' => 'Sorry, %s, je hebt geen toegang tot %s omdat je bent verwijderd.',
        'SORRY_USERNAME' => 'Sorry, %s',
        'PENDING' => 'In behandeling',
        'ACCEPT' => 'Accepteren',
        'PENDING_APPROVAL' => 'In afwachting van goedkeuring',
        'ACCEPT_MEMBERSHIP' => 'Lidmaatschap accepteren',
        'DECLINE_MEMBERSHIP' => 'Lidmaatschap weigeren',
        'NO_PAGE_YET' => 'Nog geen pagina',
        'YOUR_MEMBERSHIP_TO_X_IS_PENDING_APPROVAL' => 'Je lidmaatschap van %s is in afwachting van goedkeuring door de beheerders.',
        'MEMBERSHIP_PENDING_APPROVAL' => 'Je lidmaatschapsaanvraag is in behandeling',
        'YOUR_PROFILE_IS_PENDING_APPROVAL' => 'Je profiel is in afwachting van goedkeuring',
        'YOUR_PROFILE_DETAILS_MUST_BE_APPROVED_ON_X' => 'Je profielgegevens moeten goedgekeurd worden door de beheerder voordat je lid kunt worden van %s. Je krijgt een e-mail zodra je profiel is goedgekeurd.',
        'CONTINUE_ARROW' => 'Doorgaan →',
        'LARR_BACK_TO_PENDING_MEMBERS' => '← Terug naar leden in afwachting van goedkeuring',
        'X_IS_AWAITING_APPROVAL_TO_BECOME_MEMBER_OF_Y' => '%s wacht op goedkeuring om lid te worden van %s.',
        'VIEW_PAGE' => 'Pagina bekijken',
        'MESSAGE' => 'Bericht',
        'SEND_MESSAGE' => 'Stuur bericht',
        'MANAGE_FORUM_CATEGORIES' => 'Forumcategorieën beheren',
        'START_DISCUSSIONS' => 'Discussies starten',
        'WELCOME_TO_YOUR_NEW_SOCIAL_NETWORK' => 'Welkom bij je nieuwe netwerk',
        'NOW_ALL_YOU_NEED_TO_DO_IS_INVITE_YOUR_FRIENDS' => 'Nu hoef je alleen nog maar <a %s>je vrienden uit te nodigen</a>!',
        'CONTRIBUTE' => 'Bijdragen.',
        'CUSTOMIZE_APPEARANCE_BADGES' => '<strong>Aanpassen.</strong> Pas de <a %1$s>vormgeving van je netwerk</a> aan en ontwerp <a %2$s>banners en widgets</a>.',
        'CONTROL_MANAGE_PAGE' => '<strong>Beheer.</strong>  Op de <a %s>beheerders</a>pagina vind je talloze configuratieopties.',
        'CREATE_GROUPS' => 'Groepen maken',
        'INVITE_MORE_PEOPLE' => 'Nodig meer mensen uit',
        'VIEW_THREAD' => 'Discussie weergeven',
        'COMMENT_THREAD' => 'Reactie op discussie',
        'COMMENT_BACK' => 'Reageer',
        'HELLO_YOU_NEED_TO_ENABLE_JAVASCRIPT' => 'Hallo, om dit netwerk te gebruiken, dien je JavaScript aan te zetten.',
        'PLEASE_CHECK_YOUR_BROWSER_SETTINGS' => 'Controleer de instellingen van je browser, of neem contact op met je systeembeheerder.',
        'MANAGE_MEMBERS_ADMINS_INVITED' => 'Beheer leden, beheerders, uitgenodigde personen en verwijderde personen',
        'MANAGE_MEMBERS' => 'Leden beheren',
        'MANAGE_INVITED_PEOPLE' => 'Uitgenodigde personen beheren',
        'NETWORK_SETTINGS' => 'Netwerk-instellingen',
        'PROMOTE_YOUR_NETWORK' => 'Maak reclame voor je netwerk',
        'NING_RESOURCES' => 'Ning Resources',
        'ADD_PREMIUM_SERVICES' => 'Voeg Premium Services toe',
        'REQUEST_SOURCE_CODE' => 'Broncode opvragen',
        'REQUEST_A_COPY_OF_THE_SOURCE_CODE' => 'Ontwikkelaars: raag een kopie op van de broncode van je netwerk.',
        'JOIN_NETWORK_CREATORS' => 'Word lid van Network Creators',
        'SEND_MESSAGE_TO_ALL_THIS' => 'Stuur een bericht aan alle leden van dit netwerk.',
        'CREATE_ANOTHER_NETWORK' => 'Maak een nieuw netwerk aan',
        'HAVE_ANOTHER_GREAT_IDEA' => 'Heb je een goed idee voor een nieuwnetwerk?',
        'ALLOW_FACEBOOK_USERS_TO' => 'Laat Facebook-gebruikers de widgets van je netwerk op hun profielpagina\'s plaatsen.',
        'BADGES_AND_WIDGETS' => 'Banners & Widgets',
        'CUSTOMIZE_WIDGETS_AND_BADGES' => 'Pas het uiterlijk aan van de widgets en banners van je netwerk',
        'GET_BADGES' => 'Neem een banner',
        'CUSTOM_TEXT' => 'Eigen tekst',
        'IM_A_MEMBER_OF' => 'Ik ben lid van:',
        'DONT_DISPLAY_ANY_BRANDING' => 'Geen logo weergeven',
        'WATERMARK_OR_LOGO_IMAGE' => 'Watermerk of logo:',
        'NETWORK_BRANDING_BADGES' => 'Netwerk vormgeven: banners',
        'NETWORK_BRANDING_WIDGETS' => 'Netwerk vormgeven: widgets',
        'LOGO_IMAGE' => 'Logo',
        'SMALL_NETWORK_BADGE' => 'Kleine banner',
        'LARGE_NETWORK_BADGE' => 'Grote banner',
        'REFRESH' => 'Verversen',
        'HTML_EMBED_CODE' => 'Embedded HTML-code:',
        'CUSTOMIZE' => 'Aanpassen',
        'SHARE_TITLE' => 'Deel \'%s\'',
        'SHARE_TYPE' => 'Deel %s',
        'YOUR_MESSAGE_SENT' => 'Je bericht is verzonden.',
        'YOUR_MESSAGES_SENT' => 'Je berichten zijn verzonden.',
        'YOU_CAN_SHARE_TYPE_TWO_WAYS' => 'Je kunt dit in %s op twee manieren delen&#8230;',
        'CHECK_OUT_THIS_TYPE_TITLE' => 'Kijk eens naar deze %s: "%s"',
        'CHECK_OUT_THIS_TYPE' => 'Kijk eens naar deze %s',
        'PHOTO_ALBUM' => 'fotoalbum',
        'CUSTOMIZE_YOUR_BADGES_AND_WIDGETS' => 'Verander je badges en widgets door je eigen kleuren en afbeeldingen toe te voegen. Het kan tot vier uur duren voordat je wijzigingen ook op andere websites te zien zijn.',
        'BACKGROUND_IMAGE_AND_COLOR' => 'Achtergrondafbeelding en -kleur',
        'USE_THIS_FORM_TO_REPORT_ISSUE_TO_NC' => 'Met dit formulier meld je een probleem aan <a %s>%s</a>, de initiatiefnemer van <a %s>%s</a>.',
        'SORRY_NCS_CANNOT_CHANGE_EMAIL' => 'Sorry, initiatiefnemers kunnen hun e-mailadres niet wijzigen via netwerken waar ze geen eigenaar van zijn.',
        'SORRY_NCS_CANNOT_CHANGE_PASSWORD' => 'Sorry, initiatiefnemers kunnen hun wachtwoord niet wijzigen via netwerken waar ze geen eigenaar van zijn.',
        'GO' => 'Gaan!',
        'LARGE_THUMBNAILS' => 'Grote afbeeldingen',
        'SMALL_THUMBNAILS' => 'Kleine afbeeldingen',
        'RECENTLY_JOINED' => 'Nieuwste',
        'MOST_POPULAR_MEMBERS' => 'Populairst',
        'NO_MEMBERS_TO_DISPLAY' => 'Er zijn geen leden om weer te geven',
        'BOX_WILL_NOT_SHOW_MEMBERS' => 'Dit vak is niet zichtbaar voor anderen tenzij je tenminste een rij selecteert.',
        'DETAIL_VIEW' => 'Details',
        'TITLES_ONLY' => 'Alleen titels',
        'RECENTLY_ADDED_POSTS' => 'Onlangs toegevoegd',
        'POPULAR_POSTS' => 'Meeste reacties',
        'PROMOTED_POSTS' => 'Op hoofdpagina',
        'BOX_WILL_NOT_SHOW_BLOG_POST' => 'Dit vak is niet zichtbaar voor anderen tenzij je tenminste een blogbijdrage selecteert.',
        'KEEP_WINDOW_OPEN_UPLOAD' => 'Houd dit browservenster open terwijl de upload bezig is.',
        'CANCEL_UPLOAD' => 'Uploaden annuleren',
        'YOU_DO_NOT_HAVE_POSTS' => 'Je hebt nog geen teksten geplaatst.',
        'YOU_DO_NOT_HAVE_COMMENTS' => 'Er zijn geen reacties voor je om goed te keuren.',
        'REQUIRED_FIELD' => '(Verplicht veld)',
        'BLOG_POST_BY_X' => 'Blogtekst door %s',
        'HELLO' => 'Hallo,',
        'ADDED_BY_X' => 'Toegevoegd door %s',
        'CLICK_TO_ADD_A_TITLE' => 'Klikken om een titel toe te voegen',
        'DELETE_BLOG_POST' => 'Verwijder blogpost',
        'DELETE_THIS_BLOG_POST_Q' => 'Deze blogpost verwijderen?',
        'ARE_YOU_SURE_DELETE_THIS_BLOG_POST' => 'Weet je zeker dat je deze blogpost wilt verwijderen? Dit kan enige duren.',
        'SPINNER' => 'Spinner',
        'PLEASE_ENTER_SOMETHING_FOR_X' => 'Voer iets in voor: %s',
        'PLEASE_SELECT_OPTION_FOR_X' => 'Selecteer een optie voor: %s',
        'PLEASE_PROVIDE_VALID_DATE_FOR_X' => 'Geef een geldige datum op voor: %s',
        'PLEASE_PROVIDE_DATE_FOR_X' => 'Geef een datum op voor: %s',
        'XS_BLOG_POSTS_FOR_M_Y' => 'De blogteksten van %s voor %s %s',
        'FEATURED_BLOG_POSTS_FOR_M_Y' => 'Blogteksten Op Hoofdpagina voor %s %s',
        'BLOG_POSTS_FOR_M_Y' => 'Blog-teksten voor %s %s',
        'FEATURED_BLOG_POSTS' => 'Blogteksten Op Hoofdpagina',
        'EVERYONES_POSTS' => 'De blogteksten van iedereen',
        'PUBLISHED_N_OF_N' => 'Gepubliceerd %d van %d',
        'DOWNLOAD_X' => 'Download %s',
        'UPLOAD_DID_NOT_WORK' => 'Sorry, die upload is niet gelukt',
        'F_J_Y' => 'F j, Y',
        'M_J_Y' => 'j M Y',
        'XS_POSTS' => 'De teksten van %s',
        'USERNAMES_COMMENTS' => '%s\'s Notities',
        'ADD_COMMENT' => 'Notitie toevoegen',
        'XS_PAGE' => 'De pagina van %s',
        'XS_BLOG' => 'De blog van %s',
        'XS_FRIENDS' => 'De vrienden van %s',
        'VIEW_XS_ELLIPSIS' => 'Bekijk %s\'s...',
        'DRAFT_BRACKETS' => '[ concept ]',
        'FEATURED' => 'Op hoofdpagina',
        'MY_POSTS' => 'Mijn teksten',
        'MY_POSTS_ONLY' => 'Alleen mijn teksten',
        'OWNER_POSTS_ONLY' => 'Alleen de teksten van de initiatiefnemer',
        'JANUARY' => 'Januari',
        'FEBRUARY' => 'Februari',
        'MARCH' => 'Maart',
        'APRIL' => 'April',
        'MAY' => 'Mei',
        'JUNE' => 'Juni',
        'JULY' => 'Juli',
        'AUGUST' => 'Augustus',
        'SEPTEMBER' => 'September',
        'OCTOBER' => 'Oktober',
        'NOVEMBER' => 'November',
        'DECEMBER' => 'December',
        'MY_COMMENTS' => 'Mijn berichten',
        'AM' => 'a.m.',
        'PM' => 'p.m.',
        'MY_PAGE' => 'Mijn pagina',
        'MY_PAGE_TAB_TEXT' => 'Mijn pagina',
        'BLOG_POSTS' => 'Blogteksten',
        'MY_BLOG' => 'Mijn blog',
        'MONTH' => 'Maand',
        'DAY' => 'Dag',
        'PICK_VALID_DEFAULT_VISIBILITY' => 'Maak een geldige keuze voor de standaardzichtbaarheid',
        'PICK_VALID_WHO_CAN_COMMENT' => 'Maak een geldige keuze voor wie reacties kan plaatsen',
        'PICK_VALID_BLOG_COMMENT_MODERATION' => 'Maak een geldige keuze voor de moderatie van blog-reacties',
        'PICK_VALID_ACTIVITY_NOTIFICATION' => 'Maak een geldige keuze voor de melding van activiteiten',
        'PICK_VALID_MODERATION_NOTIFICATION' => 'Maak een geldige keuze voor moderatiemelding',
        'PICK_VALID_APPROVAL_NOTIFICATION' => 'Maak een geldige keuze voor goedkeuringsmelding',
        'PICK_VALID_INVITEE_NOTIFICATION' => 'Maak een geldige keuze voor de melding van aansluiting door iemand die is uitgenodigd',
        'PICK_VALID_NEVER_NOTIFICATION' => 'Maak een geldige keuze voor het nooit ontvangen van meldingen',
        'PICK_VALID_FRIEND_REQUEST_NOTIFICATION' => 'Maak een geldige keuze voor de melding van vriendschapsverzoeken',
        'PICK_VALID_NEW_MESSAGE_NOTIFICATION' => 'Maak een geldige keuze voor de melding van nieuwe berichten',
        'APPROVE_COMMENT' => 'Reactie goedkeuren',
        'MANAGE_BLOG' => 'Blog beheren',
        'COMMENTS_POSTED_ON_BLOG' => 'Op mijn blog geplaatste reacties',
        'COMMENT' => 'Reactie',
        'COMMENTER' => 'Geplaatst door',
        'POST' => 'TEKST',
        'M_J_Y_G_IA' => 'j M, Y, g:ia',
        'POST_HAS_BEEN_DELETED' => 'Tekst is verwijderd',
        'COMMENTS_ARE_CLOSED' => 'Het is niet mogelijk op deze blogpost te reageren',
        'NO_COMMENTS' => 'Geen reacties',
        'FLAG' => 'Markering',
        'POST_TITLE' => 'Titel tekst',
        'DRAFT_PARENTHESES' => '(concept)',
        'SCHEDULED_TO_PUBLISH_ON' => 'Publicatie gepland op: %s',
        'EDIT_2' => 'bewerken',
        'NONE' => 'Geen',
        'N_NEW' => '%s nieuw',
        'NO_POSTS' => 'Geen teksten',
        'ADD_NEW_BLOG_POST' => 'Een nieuwe blog-tekst plaatsen',
        'HAPPY' => 'Blij',
        'SAD' => 'Triest',
        'COOL' => 'Cool',
        'EVIL' => 'Snood',
        'MAD' => 'Maf',
        'ENVIOUS' => 'Jaloers',
        'ENTRY' => 'Tekst',
        'WHAT_DATE_FOR_YOUR_POST' => 'Welke datum wil je voor je tekst?',
        'NOW' => 'Nu',
        'CHOOSE_DATE_AND_TIME' => 'Een datum en tijd kiezen (als je een datum in de toekomst kiest, wordt je tekst op die datum gepubliceerd)',
        'PRIVACY_AND_COMMENTS' => 'Privacy en opmerkingen',
        'WHO_CAN_VIEW_POST' => 'Wie kan deze tekst lezen?',
        'EVERYONE' => 'Iedereen',
        'ALLOW_COMMENTS' => 'Reacties op deze tekst toestaan?',
        'YES' => 'Ja',
        'NO' => 'Nee',
        'COMMENT_MODERATION' => 'Moderatie reacties',
        'YOU_ARE_MODERATING_BLOG_COMMENTS' => 'Je bent bezig met het modereren van blog-reacties.',
        'YOU_ARE_NOT_MODERATING_BLOG_COMMENTS' => 'Je bent niet bezig met het modereren van blog-reacties.',
        'SAVE_AS_DRAFT' => 'Als concept opslaan',
        'PREVIEW' => 'Voorbeeld',
        'PUBLISH_POST' => 'Tekst publiceren',
        'THIS_IS_PREVIEW_OF_BLOG_POST' => 'Dit is een voorbeeld van hoe je blog-tekst er bij publicatie uit komt te zien. Klik op Terug om de tekst te bewerken, of op Publiceren als hij klaar is!',
        'BACK' => 'Terug',
        'PUBLISH' => 'Publiceren!',
        'BLOG_POST' => 'Blog-tekst',
        'PROFILE' => 'Profiel',
        'THIS_IS_UNPUBLISHED_DRAFT' => 'Dit is een ongepubliceerde conceptversie',
        'WILL_BE_PUBLISHED_ON_X' => 'Wordt gepubliceerd op %s <small>%s</small>',
        'POSTED_ON_X' => 'Geplaatst op %s <small>%s</small>',
        'POSTED_ON_X_BY' => 'Geplaatst <strong>%s</strong> <small>%s</small> door:',
        'ABOUT_THIS_POST' => 'Over deze tekst',
        'ABOUT_YOUR_POST' => 'Over je tekst',
        'ADDED_BY' => 'Toegevoegd door:',
        'JUST_FRIENDS' => 'Alleen vrienden',
        'RECENT_POSTS' => 'Recente teksten',
        'THERE_ARE_NO_RECENT_POSTS' => 'Er zijn geen recente teksten.',
        'YOUR_COMMENT_HAS_BEEN_ADDED_BUT' => 'Jereactie is toegevoegd, maar moet worden goedgekeurd voordat iedereen het kan zien.',
        'AT_TIME_ON_DATE_USERNAME_SAID' => 'Bij %s op %s zei %s...',
        'X_DOES_NOT_HAVE_ANY_FRIENDS' => '%s heeft nog geen vrienden binnen dit netwerk.',
        'YOU_DO_NOT_HAVE_ANY_FRIENDS' => 'Je hebt nog geen vrienden binnen dit netwerk.',
        'EDIT_PAGE_APPEARANCE' => 'Paginavormgeving bewerken',
        'VIEW_PAGE_AS_OTHERS' => 'Pagina weergeven zoals anderen hem zien',
        'ADD_BLOG_POST' => 'Blogtekst toevoegen',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED_2' => 'Houd dit browser-venster open terwijl al het materiaal van %s wordt verwijderd. Dit kan enige minuten in beslag nemen.',
        'BAN_MEMBER_FROM_NETWORK' => 'Lid verwijderen uit netwerk',
        'BAN_USERNAME' => '%s verwijderen?',
        'BLOCK' => 'blokkeren',
        'CREATE_NEW_BLOG_POST' => 'Schrijf een nieuwe blogtekst!',
        'EDIT_POST' => 'Tekst bewerken',
        'EDIT_POST_COLON' => 'Tekst bewerken:',
        'CONTINUE_READING' => 'Doorgaan met lezen...',
        'POSTED_BY_ME_LINK_ON_X_AT_X' => 'Geplaatst door <a %s>mij</a> op %s bij %s  –',
        'POSTED_BY_X_ON_X_AT_X' => 'Geplaatst door %s op %s bij %s  –',
        'POSTED_BY_ME_ON_X_AT_X' => 'Geplaatst door mij op %s bij %s  –',
        'ADD' => 'Toevoegen',
        'SUBSCRIBE' => 'Abonneren',
        'VIEW_ARCHIVES' => 'Archieven bekijken',
        'YOUR_SETTINGS_HAVE_BEEN_SAVED' => 'Je instellingen zijn opgeslagen.',
        'PLEASE_CORRECT_THE_FOLLOWING' => 'Corrigeer het volgende:',
        'PRIVACY' => 'Privacy',
        'NETWORK_PRIVACY' => 'Privacy binnen het netwerk',
        'THIS_NETWORK_VISIBLE_TO_EVERYONE' => 'Dit netwerk is <strong>zichtbaar voor iedereen</strong>.',
        'ANYONE_CAN_SIGN_UP_VISITORS_CAN' => 'Iedereen kan zich aanmelden als lid. Bezoekers kunnen...',
        'SEE_EVERYTHING' => 'Alles zien',
        'SEE_JUST_THE_MAIN_PAGE' => 'Alleen de hoofdpagina zien',
        'SEE_JUST_THE_SIGN_UP_PAGE' => 'Alleen de aanmeldpagina zien',
        'THIS_NETWORK_VISIBLE_MEMBERS_ONLY' => 'Dit netwerk is <strong>alleen zichtbaar voor leden</strong>.',
        'WHO_CAN_SIGN_UP' => 'Wie kan zich aanmelden als lid?',
        'MODERATION' => 'Modereren',
        'APPROVE_MEMBERS_BEFORE_JOIN' => 'Nieuwe leden goedkeuren voordat ze kunnen deelnemen',
        'APPROVE_PHOTOS_VIDEOS' => 'Foto\'s en video\'s goedkeuren voordat ze verschijnen',
        'SHOW_LATEST_ACTIVITY_ON_YOUR_NETWORK' => 'Geef recente activiteiten in je netwerk weer!',
        'PUT_A_CONSTANTLY_UPDATED_STREAM' => 'Plaats een voortdurend bijgewerkte stroom van recente activiteiten op de hoofdpagina van je netwerk.',
        'CLICK_HERE_TO_ADD_LATEST_ACTIVITY' => 'Klik hier om recente activiteiten toe te voegen aan je netwerk.',
        'THESE_OPTIONS_ARE_DISABLED_ACTIVITY' => 'Deze opties zijn niet beschikbaar omdat je geen recente activiteiten in je netwerk hebt.',
        'ACTIVITY' => 'Activiteit',
        'DISPLAY_PREFERENCES' => 'Weergavevoorkeuren',
        'NEW_CONTENT' => 'Nieuw materiaal',
        'NEW_COMMENTS' => 'Nieuw commentaar',
        'NEW_MEMBERS' => 'Nieuwe leden',
        'MEMBER_UPDATES' => 'Bijgewerkte leden',
        'WHAT_DISPLAYS_LATEST_ACTIVITY' => 'Wat wordt weergegeven onder<br /> Recente activiteiten van je netwerk?',
        'LATEST_ACTIVITY' => 'Recente activiteiten',
        'X_COMMENTED_ON_POST_TITLE' => '%1$s heeft geantwoord op de discussie %2$s',
        'X_LINK_COMMENTED_ON_POST_LINK_TITLE' => '%1$s <a %2$s>heeft geantwoord</a> op de discussie <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_POST_LINK_TITLE' => 'Jij <a %1$s>hebt geantwoord</a> op de discussie <a %2$s>%3$s</a>',
        'X_COMMENTED_ON_BLOG_POST_TITLE' => '%1$s heeft gereageerd op het weblogbericht %2$s',
        'X_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '%1$s <a %2$s>heeft gereageerd </a> op het weblogbericht<a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => 'Jij <a %1$s>hebt gereageerd</a> op het weblogbericht<a %2$s>%3$s</a>',
        'X_STARTED_A_DISCUSSION_Y' => '%s heeft een discussie gestart met als naam %s',
        'YOU_STARTED_A_DISCUSSION_Y' => 'Je hebt een discussie gestart met als naam %s',
        'X_ADDED_THE_BLOG_POST_Y' => '%s heeft het weblogbericht \'%s\' geplaatst',
        'YOU_ADDED_THE_BLOG_POST_Y' => 'Je hebt het weblogbericht \'%s\' geplaatst',
        'X_JOINED_THE_GROUP_Y' => '%s heeft zich aangesloten bij de groep %s',
        'YOU_JOINED_THE_GROUP_X' => 'Je hebt je aangesloten bij de groep %s',
        'X_JOINED_Y_GROUPS' => '%s heeft zich bij %s groepen aangesloten',
        'YOU_JOINED_X_GROUPS' => 'Je hebt je bij %s groepen aangesloten',
        'X_JOINED_APPNAME' => '%s heeft zich bij %s aangesloten',
        'WELCOME_MEMBER_N_OF_APPNAME' => 'Welkom, %1$s! Je bent lid #%2$s van %3$s.',
        'WELCOME_MEMBER_N_OF_APPNAME_FIND' => 'Welkom, %1$s! Je bent lid #%2$s van %3$s. <a %4$s>Zoek nu naar vrienden</a>.',
        'X_IS_MEMBER_N_OF_APPNAME' => '%1$s is lid #%2$s van %3$s.',
        'XS_PROFILE_CHANGED' => 'Het profiel van %s is gewijzigd',
        'YOUR_PROFILE_CHANGED' => 'Je profiel is gewijzigd',
        'X_LEFT_A_COMMENT_FOR_Y' => '%s heeft commentaar achtergelaten voor %s',
        'YOU_LEFT_A_COMMENT_FOR_X' => 'Je hebt commentaar achtergelaten voor %s',
        'X_LEFT_A_COMMENT_FOR_YOU' => '%s heeft commentaar achtergelaten voor je',
        'X_CREATED_A_GROUP_Y' => '%s heeft een groep gestart met als naam %s',
        'YOU_CREATED_A_GROUP_Y' => 'Je hebt een groep gestart met als naam %s',
        'X_CREATED_Y_NEW_GROUPS' => '%s heeft %s nieuwe groepen gestart',
        'X_STARTED_Y_FORUM_POSTS' => '%s heeft %s nieuwe forumdiscussies gestart',
        'YOU_STARTED_Y_FORUM_POSTS' => 'Je hebt %s nieuwe forumdiscussies gestart',
        'X_ADDED_Y_BLOG_POSTS' => '%s heeft %s nieuwe weblogberichten geplaatst',
        'YOU_ADDED_Y_BLOG_POSTS' => 'Je hebt %s nieuwe weblogberichten geplaatst',
        'VIEW_XS_BLOG_POSTS' => 'De weblogberichten van %s bekijken',
        'VIEW_YOUR_BLOG_POSTS' => 'Je weblogberichten bekijken',
        'APPNAME_HAS_NEW_PROFILE_QUESTIONS' => '%s heeft <a %s>nieuwe profielvragen</a>',
        'APPNAME_NOW_HAS_MUSIC' => '%s heeft nu een muziekspeler',
        'APPNAME_NOW_HAS_GROUPS' => '%s heeft nu <a %s>groepen</a>',
        'APPNAME_NOW_HAS_VIDEO' => '%s heeft nu <a %s>video\'s</a>',
        'APPNAME_NOW_HAS_FORUM' => '%s heeft nu een <a %s>forum</a>',
        'APPNAME_NOW_HAS_PHOTO' => '%s heeft nu <a %s>foto\'s</a>',
        'DID_YOU_KNOW' => 'Wist je dat...',
        'ANNOUNCEMENT' => 'Aankondiging',
        'CONGRATULATIONS' => 'Gefeliciteerd',
        'YOU_CREATED_APPNAME' => 'Je hebt het netwerk %s gesticht.',
        'USER_CREATED_APPNAME' => '%s heeft het netwerk%s gesticht.',
        'ADD_MESSAGES_ACTIVITY_FEED' => 'Voeg berichten toe en kies wat er in de activiteitenstroom van je netwerk wordt weergegeven.',
        'WHICH_OF_YOUR_ACTIONS_DISPLAY_ACTIVITY' => 'Welke van je handelingen moet worden weergegeven<br /> onder Recente activiteiten?',
        'NEW_CONTENT_I_ADD' => 'Nieuw materiaal | toevoegen',
        'NEW_COMMENTS_I_ADD' => 'Nieuw commentaar| toevoegen',
        'WHEN_I_UPDATE_MY_PROFILE' => 'Wanneer ik mijn profiel bijwerk',
        'THE_LATEST_ACTIVITY_WILL_NEVER' => 'Onder Recente activiteit worden geen berichten weergegeven die je verstuurt, geen pagina\'s of leden die je bekijkt, geen uitnodigingen die je afwijst, geen personen die je afwijst en geen dingen die je verwijdert.',
        'YOU_HAVENT_DONE_ANYTHING_RECENTLY' => 'Je hebt geen recente activiteit. Doe \'s iets!',
        'YOUVE_TURNED_OFF_THE_ACTIVITY_DISPLAY_CLICK' => 'Je hebt weergave van je activiteiten uitgeschakeld. <a %s>Klik hier om dit weer aan te zetten.</a>',
        'THE_NETWORK_CREATOR_HAS_TURNED_OFF_THE_ACTIVITY' => 'De initiatiefnemer van het netwerk heeft weergave van alle activiteiten uitgeschakeld.',
        'NO_ACTIVITY_TO_DISPLAY' => 'Je laat momenteel geen activiteiten zien.',
        'BOX_WILL_NOT_SHOW_ACTIVITY' => 'Dit vak is niet zichtbaar voor anderen zolang je niet minstens een activiteit hebt geselecteerd.',
        'NOTHING_IS_HAPPENING_ON_YOUR_NETWORK' => 'Er is geen recente activiteit. Doe \'s iets!',
        'MY_ACTIVITY_PREFERENCES' => 'Mijn activiteitvoorkeuren',
        'DELETE_ACTIVITY_ITEM' => 'Activiteitbericht verwijderen',
        'DELETE_THIS_ACTIVITY_MESSAGE_Q' => 'Dit activiteitbericht verwijderen?',
        'THIS_WILL_PREVENT_ACTIVITY' => 'Hierdoor kan niemand dit activiteitbericht meer zien',
        'X_HAS_POSTED_THE_MOST_PHOTOS' => '%1$s heeft de meeste %2$sfoto\'s%3$s geplaatst',
        'X_IS_THE_MOST_POPULAR_PHOTO' => '%s is op dit moment de populairste foto',
        'X_HAS_POSTED_THE_MOST_VIDEOS' => '%1$s heeft de meeste %2$svideo\'s%3$s geplaatst',
        'X_IS_THE_MOST_POPULAR_VIDEO' => '%s is op dit moment de populairste video',
        'X_HAS_POSTED_THE_MOST_MUSIC' => '%s heeft de meeste liedjes geplaatst',
        'X_IS_THE_MOST_POPULAR_MUSIC' => '%s is op dit moment het populairste liedje',
        'X_IS_THE_MOST_POPULAR_TOPIC' => '%s is op dit moment het populairste forumbericht',
        'X_IS_THE_MOST_POPULAR_BLOG_POST' => '%s is op dit moment het populairste weblogbericht',
        'XS_LATEST_ACTIVITY_ON_APPNAME' => 'Recente activiteit van %s op %s',
        'LATEST_ACTIVITY_ON_APPNAME' => 'Recente activiteit op %s',
        'ADD_MESSAGE_TO_LATEST_ACTIVITY' => 'Voeg bericht toe aan Recente activiteit',
        'ADD_FACTS_ABOUT_THE_NETWORK_ELLIPSIS' => 'Voeg gegevens toe over het netwerk ...',
        'ADD_MESSAGE' => 'Bericht toevoegen',
        'ELLIPSIS_OR_WRITE_YOUR_OWN_MESSAGE' => '...of schrijf je eigen bericht',
        'NETWORK' => 'Netwerk',
        'WHO_CAN_VIEW_YOUR_PHOTOS_VIDEOS' => 'Wie kan standaard mijn foto\'s, video\'s<br/> en blogteksten bekijken?',
        'YOU_CAN_OVERRIDE_WHEN_YOU_ADD' => '(Deze instelling kun je bij het toevoegen wijzigen voor een specifieke foto, video of blog-tekst.)',
        'MODERATE_COMMENTS_ON_BLOG' => 'Wil je reacties goedkeuren<br />voordat ze op je blog verschijnen?',
        'YES_LET_ME_APPROVE' => 'Ja, ik wil commentaar eerst goedkeuren',
        'NO_PUBLISH_COMMENTS' => 'Nee, commentaar direct plaatsen',
        'WHO_CAN_COMMENT_ON_PHOTOS_VIDEOS' => 'Wie kan reacties plaatsen over mijn foto\'s, video\'s en blog?',
        'SAVE' => 'Opslaan',
        'EMAIL' => 'E-mail',
        'YOUR_PRIVACY_IS_IMPORTANT' => 'Je privacy is belangrijk voor ons. Als je vragen hebt over je e-mailmeldingen, stuur ons dan een bericht via het <a href="http://help.ning.com/?page_id=27">ondersteuningscentrum</a>.',
        'ADD_PHOTOS_AND_VIDEOS_TO_X_BY_SENDING' => 'Voeg foto\'s en video\'s toe aan %s door ze naar dit e-mailadres te sturen:',
        'ADD_PHOTOS_AND_VIDEOS_TO_APPNAME_FROM_PHONE' => 'Voeg foto\'s en video\'s toe aan %s vanaf je telefoon door ze te versturen naar dit e-mailadres:',
        'GENERATE_NEW_EMAIL_ADDRESS' => 'Nieuw e-mailadres aanmaken',
        'SUPPORTS_TEXT_EMBEDDED' => 'Ondersteuning voor tekst, embedded video\'s, foto\'s en widgets',
        'POST_COMMENT' => 'Reactie plaatsen',
        'YOU_NEED_TO_BE_MEMBER_COMMENTS' => 'Je moet lid zijn van %s om reacties te kunnen toevoegen!',
        'MONTHLY_ARCHIVES' => 'Maandarchieven',
        'NO_FRIENDS_ON_SITE' => 'Nog geen vrienden op deze community.',
        'NO_FRIENDS_ON_SITE_THAT_MATCH' => 'Geen vrienden op deze community die beantwoorden aan je zoekopdracht.',
        'MEMBERS_TAB_TEXT' => 'Leden',
        'SITE_HAS_NO_MEMBERS' => 'Deze community heeft nog geen leden!',
        'SITE_HAS_NO_MEMBERS_THAT_MATCH' => 'Deze community heeft geen leden die beantwoorden aan je zoekopdracht.',
        'NO_COMMENTS_YET' => 'Nog geen notities!',
        'VIEW_ALL_COMMENTS' => 'Alle notities bekijken',
        'YOU_HAVE_NOT_ADDED_BLOG_POSTS' => 'Je hebt nog geen blogteksten toegevoegd!',
        'YOU_CAN_WRITE_ABOUT_ANYTHING' => 'Je kunt schrijven over wat je maar wilt en je favoriete video\'s, foto\'s en muziek embedden en bespreken.',
        'WRITE_YOUR_FIRST_ENTRY' => 'Schrijf je eerste tekst!',
        'THERE_ARE_NO_BLOG_POSTS' => 'Je community bevat momenteel geen blog-teksten.',
        'THERE_ARE_NO_FEATURED_X' => 'Je hebt geen %s met \'Op Hoofdpagina\' gemarkeerd binnen je netwerk.',
        'THERE_ARE_NO_X_THAT_MATCH_SETTINGS' => 'Er zijn geen %s die overeenkomen met de instellingen zoals je die hebt geselecteerd.',
        'START_FEATURING_X_CLICK_Y' => 'Je kunt %s opnemen als onderdeel op de hoofdpagina waar je de optie \'Op hoofdpagina\' ziet. <a %s>Klik hier</a> voor nadere informatie over het opnemen van onderdelen op de hoofdpagina.',
        'THIS_BOX_WILL_NOT_SHOW_BLOG_POSTS' => 'Dit vak wordt pas zichtbaar voor anderen als er een blog-tekst is geplaatst. Voeg er eens een toe!',
        'YOUR_FRIEND' => 'Je vriend',
        'REQUEST_SENT' => 'Verzoek verzonden!',
        'BLOCKED' => 'Geblokkeerd',
        'BANNED' => 'Verwijderd',
        'ADD_YOUR_FIRST_BLOG_POST' => 'Voeg je eerste blogtekst toe',
        'MY_FIRST_BLOG_POST' => 'Mijn eerste blogtekst!',
        'TELL_THE_PEOPLE_ON' => 'Vertel de leden van %s iets over jezelf. Vragen die aangegeven zijn met <span %s>vergrendeld</span> zijn privé en zijn alleen zichtbaar voor beheerders.',
        'CHOOSE_A_THEME_FOR_PAGE' => 'Kies een thema voor je pagina',
        'NOW_CUSTOMIZE_PAGE' => 'Pas nu je pagina aan aan je persoonlijke voorkeuren...',
        'NO_POSTS_TO_DISPLAY' => 'Geen teksten om weer te geven.',
        'YOU_ARE_DISPLAYING_NO_POSTS' => 'Je geeft nu geen teksten weer.',
        'DATE_COLON' => 'Datum:',
        'TIME_COLON' => 'Tijd:',
        'CHANGE' => 'Wijzigen',
        'UPLOAD_A_PHOTO' => 'Een foto uploaden',
        'OPTIONS' => 'Opties',
        'PIXELS' => 'Pixels',
        'CANCEL' => 'Annuleren',
        'UPLOAD_A_FILE' => 'Een bestand uploaden:',
        'TO_INSERT_A_FILE' => 'Als je een bestand wilt invoegen, klik je op de knop \'Bladeren\' of \'Browse\' hierboven om het bestand op te zoeken op je computer.',
        'UPLOADING' => 'Bezig met uploaden...',
        'OK' => 'OK',
        'POPULAR_MEMBERS' => 'Populaire leden',
        'INVITE_FRIENDS' => 'Vrienden uitnodigen',
        'VIEW_ALL' => 'Alles weergeven',
        'REMOVE_X' => '%s verwijderen',
        'ARE_YOU_SURE_BAN_X_AND_CONTENT' => 'Weet je zeker dat je %1$s uit je community wilt verwijderen, en al het materiaal dat %1$s heeft toegevoegd? Dat kan enige minuten in beslag nemen.',
        'REMOVING_X' => 'Bezig met verwijderen %s',
        'ARE_YOU_SURE_BAN_MEMBERS_AND_CONTENT' => 'Weet je zeker dat je het lid of de leden die je hebt geselecteerd, wilt verwijderen en daarmee alle content die door hen is toegevoed? Dit kan enige minuten in beslag nemen.',
        'ARE_YOU_SURE_BAN_MEMBERS' => 'Weet je zeker dat je het lid of de leden die je hebt geselecteerd wilt verwijderen uit je netwerk? Dit kan enige minuten in beslag nemen.',
        'BAN' => 'Verwijder',
        'REMOVING_MEMBERS' => 'Bezig met verwijderen van leden',
        'FEMALE' => 'Vrouw',
        'MALE' => 'Man',
        'UNITED_STATES' => 'Verenigde Staten',
        'AND' => 'en',
        'FROM' => 'van',
        'GENDER_M' => 'Man',
        'GENDER_F' => 'Vrouw',
        'XS_PAGE_ON_Y' => 'De pagina van %s op %s',
        'SEARCH_MEMBERS' => 'Leden zoeken',
        'SOMEBODY_COMMENTED_BLOGPOST_ADDED_TO_X' => 'Iemand heeft een reactie geplaatst over een blog-tekst die je hebt toegevoegd aan %s',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE' => 'Er is nieuw commentaar voor je op je pagina.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X' => 'Er is nieuw commentaar voor je op je pagina op %s.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X_ELLIPSIS' => 'Er is nieuw commentaar voor je op je pagina op %s...',
        'A_BLOG_POST' => 'een blogtekst',
        'NOW_THAT_YOU_JOINED_INVITE' => 'Nu je lid bent geworden kun je <strong><a %s>je vrienden uitnodigen</a></strong>!',
        'THIS_IS_YOUR_PROFILE' => 'Dit is je profiel:',
        'START_BY_CUSTOMIZING_ITS_APPEARANCE' => 'Begin met het <a %s>aanpassen van de vormgeving</a>.',
        'USE_IT_TO_KEEP_A_BLOG_AND_DISPLAY_YOUR_PROFILE_ANSWERS' => 'Je kunt er een <a %1$s>weblog bijhouden</a> en je <a %2$s>profielantwoorden</a> weergeven.',
        'START_CONTRIBUTING' => 'Start met bijdragen:',
        'UPLOAD_VIDEOS' => 'Video\'s uploaden',
        'CONTRIBUTE_TO_DISCUSSIONS' => 'Doe mee met discussies',
        'JOIN_GROUPS' => 'Word lid van groepen',
        'ADD_A_BLOG_POST' => 'Voeg een blog-tekst toe',
        'CLICK_TO_ACCEPT_FRIENDS' => 'Klik hier om je vriendschapsverzoeken te bekijken.',
        'LEAVE_X' => '%s verlaten',
        'LEAVE_X_Q' => '%s verlaten?',
        'ARE_YOU_SURE_LEAVE_X' => 'Weet je zeker dat je %s wilt verlaten en al je materiaal wilt verwijderen? Dit kan enige minuten duren.',
        'BACK_TO_USERNAMES_PAGE' => '&#8592; Terug naar de pagina van %s',
        'BACK_TO_MY_PAGE' => '&#8592; Terug naar mijn pagina',
        'COMMENT_WALL' => 'Prikbord',
        'ONLINE' => 'Online',
        'MEMBER_IS_ONLINE' => 'Lid is online',
        'ONLINE_NOW' => 'Nu online',
        'CHOOSE_WHO_CAN_SEE_JOIN_AND_CONTRIBUTE' => 'Kies wie er jouw netwerk kan bekijken, lid kan worden en bijdragen kan leveren.',
        'EMAIL_NOTIFICATIONS' => 'E-mailmeldingen',
        'WHAT_NETWORK_ACTIVITY_EMAIL_FOR' => 'Voor welke community-activiteit wil je een e-mailmelding ontvangen?',
        'NETWORK_MESSAGES' => 'Netwerkberichten',
        'MEMBER_ACTIVITY' => 'Activiteit van leden',
        'APPROVAL' => 'Goedkeuring',
        'FRIEND_REQUESTS' => 'Verzoeken om vriendschap',
        'PEOPLE_IVE_INVITED_JOIN' => 'Mensen die ik heb uitgenodigd voor dit netwerk',
        'MESSAGES_SENT_TO_ME' => 'Berichten aan mij',
        'MESSAGES_SENT_TO_GROUPS' => 'Berichten aan de groepen waar ik bij hoor',
        'MESSAGES_SENT_TO_NETWORK' => 'Berichten aan het hele netwerk',
        'I_HAVE_NEW_COMMENTS' => 'Ik heb nieuw commentaar om goed te keuren',
        'I_HAVE_NEW_NETWORK_CONTENT' => 'Ik heb nieuw netwerkmateriaal om goed te keuren',
        'CONTENT_ACTIVITY' => 'Materiaalactiviteit',
        'ACTIVITY_ON_THINGS_IVE_ADDED' => 'Activiteit op dingen die ik heb toegevoegd',
        'AUTO_FOLLOW_DISCUSSIONS_I_REPLY_TO' => 'Automatisch discussies volgen waarop ik heb geantwoord',
        'THINGS_IVE_ADDED_APPROVED' => 'Dingen die ik heb toegevoegd, zijn goedgekeurd',
        'NOTIFICATIONS' => 'Meldingen',
        'EMAIL_ME_WHEN_PEOPLE_REPLY' => 'E-mail me wanneer mensen antwoord geven',
        'DO_NOT_EMAIL_ME_WHEN_PEOPLE_REPLY' => 'E-mail me niet wanneer mensen antwoord geven',
        'TO_STOP_FOLLOWING_THIS_X_CLICK_Y' => 'Als je deze %s niet meer wilt volgen, <a %s>klik dan hier</a>.',
        'YOU_ARE_NO_LONGER_FOLLOWING_THIS_X' => 'Je volgt deze %s niet langer.',
        'NOTIFY' => 'Waarschuwen',
        'STOP_NOTIFYING' => 'Meldingen stoppen',
        'EMAIL_WHEN_NEW_DISCUSSIONS' => 'E-mail me wanneer er nieuwe discussies zijn',
        'DO_NOT_EMAIL_WHEN_NEW_DISCUSSIONS' => 'E-mail me niet wanneer er nieuwe discussies zijn',
        'STOP_FOLLOWING_ALL' => 'Stoppen met het volgen van discussies en weblogcommentaren',
        'CHANGE_MY_PHOTO' => 'Mijn foto wijzigen',
        'COUNTRY_AF' => 'Afghanistan',
        'COUNTRY_AX' => 'Aland-eilanden',
        'COUNTRY_AL' => 'Albanië',
        'COUNTRY_DZ' => 'Algerije',
        'COUNTRY_AS' => 'Amerikaans-Samoa',
        'COUNTRY_AD' => 'Andorra',
        'COUNTRY_AO' => 'Angola',
        'COUNTRY_AI' => 'Anguilla',
        'COUNTRY_AQ' => 'Antarctica',
        'COUNTRY_AG' => 'Antigua en Barbuda',
        'COUNTRY_AR' => 'Argentinië',
        'COUNTRY_AM' => 'Armenië',
        'COUNTRY_AW' => 'Aruba',
        'COUNTRY_AU' => 'Australië',
        'COUNTRY_AT' => 'Oostenrijk',
        'COUNTRY_AZ' => 'Azerbeidzjan',
        'COUNTRY_BS' => 'Bahama\'s',
        'COUNTRY_BH' => 'Bahrein',
        'COUNTRY_BD' => 'Bangladesh',
        'COUNTRY_BB' => 'Barbados',
        'COUNTRY_BY' => 'Wit-Rusland',
        'COUNTRY_BE' => 'België',
        'COUNTRY_BZ' => 'Belize',
        'COUNTRY_BJ' => 'Benin',
        'COUNTRY_BM' => 'Bermuda',
        'COUNTRY_BT' => 'Bhutan',
        'COUNTRY_BO' => 'Bolivia',
        'COUNTRY_BA' => 'Bosnië en Herzegovina',
        'COUNTRY_BW' => 'Botswana',
        'COUNTRY_BV' => 'Bouveteiland',
        'COUNTRY_BR' => 'Brazilië',
        'COUNTRY_IO' => 'Brits Territorium in de Indische Oceaan',
        'COUNTRY_BN' => 'Sultanaat van Brunei',
        'COUNTRY_BG' => 'Bulgarije',
        'COUNTRY_BF' => 'Burkina Faso',
        'COUNTRY_BI' => 'Burundi',
        'COUNTRY_KH' => 'Cambodja',
        'COUNTRY_CM' => 'Kameroen',
        'COUNTRY_CA' => 'Canada',
        'COUNTRY_CV' => 'Kaapverdië',
        'COUNTRY_KY' => 'Caymaneilanden',
        'COUNTRY_CF' => 'Centraal-Afrikaanse Republiek',
        'COUNTRY_TD' => 'Tsjaad',
        'COUNTRY_CL' => 'Chili',
        'COUNTRY_CN' => 'China',
        'COUNTRY_CX' => 'Christmaseiland',
        'COUNTRY_CC' => 'Cocoseilanden',
        'COUNTRY_CO' => 'Colombia',
        'COUNTRY_KM' => 'Comoren',
        'COUNTRY_CG' => 'Congo, Republiek',
        'COUNTRY_CD' => 'Congo, Democratische Republiek',
        'COUNTRY_CK' => 'Cookeilanden',
        'COUNTRY_CR' => 'Costa Rica',
        'COUNTRY_CI' => 'Ivoorkust',
        'COUNTRY_HR' => 'Kroatië',
        'COUNTRY_CU' => 'Cuba',
        'COUNTRY_CY' => 'Cyprus',
        'COUNTRY_CZ' => 'Tsjechië',
        'COUNTRY_DK' => 'Denemarken',
        'COUNTRY_DJ' => 'Djibouti',
        'COUNTRY_DM' => 'Dominica',
        'COUNTRY_DO' => 'Dominicaanse Republiek',
        'COUNTRY_EC' => 'Ecuador',
        'COUNTRY_EG' => 'Egypte',
        'COUNTRY_SV' => 'El Salvador',
        'COUNTRY_GQ' => 'Equatoriaal-Guinea',
        'COUNTRY_ER' => 'Eritrea',
        'COUNTRY_EE' => 'Estland',
        'COUNTRY_ET' => 'Ethiopië',
        'COUNTRY_EU' => 'Europese Unie',
        'COUNTRY_FK' => 'Falklandeilanden',
        'COUNTRY_FO' => 'Faeröer',
        'COUNTRY_FJ' => 'Fiji',
        'COUNTRY_FI' => 'Finland',
        'COUNTRY_FR' => 'Frankrijk',
        'COUNTRY_GF' => 'Frans-Guyana',
        'COUNTRY_PF' => 'Frans-Polynesië',
        'COUNTRY_TF' => 'Franse Zuidelijke Gebiedsdelen',
        'COUNTRY_GA' => 'Gabon',
        'COUNTRY_GM' => 'Gambia',
        'COUNTRY_GE' => 'Georgië',
        'COUNTRY_DE' => 'Duitsland',
        'COUNTRY_GH' => 'Ghana',
        'COUNTRY_GI' => 'Gibraltar',
        'COUNTRY_GR' => 'Griekenland',
        'COUNTRY_GL' => 'Groenland',
        'COUNTRY_GD' => 'Grenada',
        'COUNTRY_GP' => 'Guadeloupe',
        'COUNTRY_GU' => 'Guam',
        'COUNTRY_GT' => 'Guatemala',
        'COUNTRY_GN' => 'Guinee',
        'COUNTRY_GW' => 'Guinee-Bissau',
        'COUNTRY_GY' => 'Guyana',
        'COUNTRY_HT' => 'Haïti',
        'COUNTRY_HM' => 'Heard- en McDonaldeilanden',
        'COUNTRY_HN' => 'Honduras',
        'COUNTRY_HK' => 'Hongkong',
        'COUNTRY_HU' => 'Hongarije',
        'COUNTRY_IS' => 'IJsland',
        'COUNTRY_IN' => 'India',
        'COUNTRY_ID' => 'Indonesië',
        'COUNTRY_IR' => 'Iran, Islamitische Republiek',
        'COUNTRY_IQ' => 'Irak',
        'COUNTRY_IE' => 'Ierland',
        'COUNTRY_IL' => 'Israël',
        'COUNTRY_IT' => 'Italië',
        'COUNTRY_JM' => 'Jamaica',
        'COUNTRY_JP' => 'Japan',
        'COUNTRY_JO' => 'Jordanië',
        'COUNTRY_KZ' => 'Kazachstan',
        'COUNTRY_KE' => 'Kenia',
        'COUNTRY_KI' => 'Kiribati',
        'COUNTRY_KP' => 'Korea, Democratische Volksrepubliek',
        'COUNTRY_KR' => 'Korea, Republiek',
        'COUNTRY_KW' => 'Koeweit',
        'COUNTRY_KG' => 'Kirgizië',
        'COUNTRY_LA' => 'Democratische Volksrepubliek Lao',
        'COUNTRY_LV' => 'Letland',
        'COUNTRY_LB' => 'Libanon',
        'COUNTRY_LS' => 'Lesotho',
        'COUNTRY_LR' => 'Liberia',
        'COUNTRY_LY' => 'Libisch-Arabische Jamahiriyah',
        'COUNTRY_LI' => 'Liechtenstein',
        'COUNTRY_LT' => 'Litouwen',
        'COUNTRY_LU' => 'Luxemburg',
        'COUNTRY_MO' => 'Macao',
        'COUNTRY_MK' => 'Macedonië, Voormalige Joegoslavische Republiek',
        'COUNTRY_MG' => 'Madagaskar',
        'COUNTRY_MW' => 'Malawi',
        'COUNTRY_MY' => 'Maleisië',
        'COUNTRY_MV' => 'Maldiven',
        'COUNTRY_ML' => 'Mali',
        'COUNTRY_MT' => 'Malta',
        'COUNTRY_MH' => 'Marshalleilanden',
        'COUNTRY_MQ' => 'Martinique',
        'COUNTRY_MR' => 'Mauretanië',
        'COUNTRY_MU' => 'Mauritius',
        'COUNTRY_YT' => 'Mayotte',
        'COUNTRY_MX' => 'Mexico',
        'COUNTRY_FM' => 'Micronesië, Federale Staten van',
        'COUNTRY_MD' => 'Moldavië, Republiek',
        'COUNTRY_MC' => 'Monaco',
        'COUNTRY_MN' => 'Mongolië',
        'COUNTRY_MS' => 'Montserrat',
        'COUNTRY_MA' => 'Marokko',
        'COUNTRY_MZ' => 'Mozambique',
        'COUNTRY_MM' => 'Myanmar',
        'COUNTRY_NA' => 'Namibië',
        'COUNTRY_NR' => 'Nauru',
        'COUNTRY_NP' => 'Nepal',
        'COUNTRY_NL' => 'Nederland',
        'COUNTRY_AN' => 'Nederlandse Antillen',
        'COUNTRY_NC' => 'Nieuw-Caleonië',
        'COUNTRY_NZ' => 'Nieuw-Zeeland',
        'COUNTRY_NI' => 'Nicaragua',
        'COUNTRY_NE' => 'Niger',
        'COUNTRY_NG' => 'Nigeria',
        'COUNTRY_NU' => 'Niue',
        'COUNTRY_NF' => 'Norfolkeiland',
        'COUNTRY_MP' => 'Noordelijke Marianen',
        'COUNTRY_NO' => 'Noorwegen',
        'COUNTRY_OM' => 'Oman',
        'COUNTRY_PK' => 'Pakistan',
        'COUNTRY_PW' => 'Palau',
        'COUNTRY_PS' => 'Palestijnse Gebieden, Bezette',
        'COUNTRY_PA' => 'Panama',
        'COUNTRY_PG' => 'Papoea-Nieuw-Guinea',
        'COUNTRY_PY' => 'Paraguay',
        'COUNTRY_PE' => 'Peru',
        'COUNTRY_PH' => 'Filippijnen',
        'COUNTRY_PN' => 'Pitcairn',
        'COUNTRY_PL' => 'Polen',
        'COUNTRY_PT' => 'Portugal',
        'COUNTRY_PR' => 'Porto Rico',
        'COUNTRY_QA' => 'Qatar',
        'COUNTRY_RE' => 'Réunion',
        'COUNTRY_RO' => 'Roemenië',
        'COUNTRY_RU' => 'Russische Federatie',
        'COUNTRY_RW' => 'Rwanda',
        'COUNTRY_SH' => 'Sint-Helena',
        'COUNTRY_KN' => 'Saint Kitts en Nevis',
        'COUNTRY_LC' => 'Saint Lucia',
        'COUNTRY_PM' => 'Saint-Pierre en Miquelon',
        'COUNTRY_VC' => 'Saint Vincent en de Grenadines',
        'COUNTRY_WS' => 'Samoa',
        'COUNTRY_SM' => 'San Marino',
        'COUNTRY_ST' => 'Sao Tomé en Principe',
        'COUNTRY_SA' => 'Saudi-Arabië',
        'COUNTRY_SN' => 'Senegal',
        'COUNTRY_CS' => 'Servië en Montenegro',
        'COUNTRY_SC' => 'Seychellen',
        'COUNTRY_SL' => 'Sierra Leone',
        'COUNTRY_SG' => 'Singapore',
        'COUNTRY_SK' => 'Slowakije',
        'COUNTRY_SI' => 'Slovenië',
        'COUNTRY_SB' => 'Solomoneilanden',
        'COUNTRY_SO' => 'Somalië',
        'COUNTRY_ZA' => 'Zuid-Afrika',
        'COUNTRY_GS' => 'Zuid-Georgië en de Zuidelijke Sandwicheilanden',
        'COUNTRY_ES' => 'Spanje',
        'COUNTRY_LK' => 'Sri Lanka',
        'COUNTRY_SD' => 'Soedan',
        'COUNTRY_SR' => 'Suriname',
        'COUNTRY_SJ' => 'Svalbard en Jan Mayen',
        'COUNTRY_SZ' => 'Swaziland',
        'COUNTRY_SE' => 'Zweden',
        'COUNTRY_CH' => 'Zwitserland',
        'COUNTRY_SY' => 'Syrië, Arabische Republiek',
        'COUNTRY_TW' => 'Taiwan',
        'COUNTRY_TJ' => 'Tadzjikistan',
        'COUNTRY_TZ' => 'Tanzania, Verenigde Republiek',
        'COUNTRY_TH' => 'Thailand',
        'COUNTRY_TL' => 'Oost-Timor',
        'COUNTRY_TG' => 'Togo',
        'COUNTRY_TK' => 'Tokelau-eilanden',
        'COUNTRY_TO' => 'Tonga',
        'COUNTRY_TT' => 'Trinidad en Tobago',
        'COUNTRY_TN' => 'Tunesië',
        'COUNTRY_TR' => 'Turkije',
        'COUNTRY_TM' => 'Turkmenistan',
        'COUNTRY_TC' => 'Turks- en Caicoseilanden',
        'COUNTRY_TV' => 'Tuvalu',
        'COUNTRY_UG' => 'Oeganda',
        'COUNTRY_UA' => 'Oekraïne',
        'COUNTRY_AE' => 'Verenigde Arabische Emiraten',
        'COUNTRY_GB' => 'Verenigd Koninkrijk',
        'COUNTRY_US' => 'Verenigde Staten',
        'COUNTRY_UM' => 'Amerikaanse ondergeschikte afgelegen eilanden',
        'COUNTRY_UY' => 'Uruguay',
        'COUNTRY_UZ' => 'Oezbekistan',
        'COUNTRY_VU' => 'Vanuatu',
        'COUNTRY_VA' => 'Vaticaanstad, Staat',
        'COUNTRY_VE' => 'Venezuela',
        'COUNTRY_VN' => 'Vietnam',
        'COUNTRY_VG' => 'Maagdeneilanden, Britse',
        'COUNTRY_VI' => 'Maagdeneilanden, Amerikaanse',
        'COUNTRY_WF' => 'Wallis en Futuna',
        'COUNTRY_EH' => 'Westelijke Sahara',
        'COUNTRY_YE' => 'Yemen',
        'COUNTRY_ZM' => 'Zambia',
        'COUNTRY_ZW' => 'Zimbabwe',
        'ERROR_LOG' => 'Foutenlogboek',
        'CANNOT_READ_ERROR_LOG' => 'Kan foutenlogboek niet lezen',
        'CANNOT_OPEN_ERROR_LOG' => 'Kan foutenlogboek niet openen',
        'CANNOT_SCAN_ERROR_LOG' => 'Kan foutenlogboek niet scannen',
        'MODELS_RESET' => 'Modellen hersteld:',
        'NO_MODELS_RESET' => 'Geen modellen zijn hersteld .',
        'NO_FEED_TO_DISPLAY' => 'Je geeft op dit moment geen items weer.',
        'BOX_WILL_NOT_SHOW_FEED' => 'Dit vak is niet zichtbaar voor anderen tenzij jer er tenminste 1 hebt geselecteerd.',
        'CLICK_EDIT_TO_SPECIFY_FEED' => 'Klik op \'Bewerken\' om de RSS-feed voor dit vak in te stellen.',
        'PROBLEM_OCCURRED_RETRIEVING_FEED' => 'Er is iets misgegaan bij het ophalen van deze RSS-feed.',
        'MORE_ELLIPSIS' => 'Meer...',
        'RSS' => 'RSS',
        'WE_ARE_SORRY_SITE_HAS_ISSUE' => 'Het spijt ons, er is  een probleem met deze site.',
        'PLEASE_TRY_REFRESHING' => 'Probeer de pagina over 30 seconden te vernieuwen. <a %s>Laat het ons weten</a> als je weer dit bericht krijgt.',
        'NO_DISCUSSIONS_TAGGED_X' => 'Er zijn geen discussies met de tag "%1$s".',
        'PAGE_TITLE_COLON' => 'Paginatitel:',
        'PAGE_CONTENT' => 'Inhoud:',
        'CREATE_PAGE' => 'Pagina aanmaken',
        'CREATE_NEW_PAGE' => 'Een nieuwe pagina aanmaken',
        'YOUR_COMMENT' => 'Je reactie',
        'ADD_YOUR_COMMENT' => 'Een reactie toevoegen',
        'DELETE_PAGE' => 'Deze pagina wissen',
        'DELETE_THIS_PAGE_Q' => 'Deze pagina wissen?',
        'ARE_YOU_SURE_DELETE_THIS_PAGE' => 'Weet je zeker dat je deze pagina (inclusief alle reacties) wilt wissen? Dat kan enige minuten duren.',
        'SEARCH_PAGES' => 'Pagina\'s doorzoeken',
        'ALL_PAGES' => 'Alle pagina\'s',
        'SUBSCRIBE_TO_PAGES' => 'Abonneer je op deze pagina\'s',
        'NOBODY_HAS_ADDED_PAGES' => 'Niemand heeft nog pagina\'s toegevoegd!',
        'ADD_PAGES_CALL_TO_ACTION' => 'Maak een pagina aan om te beginnen.',
        'CREATE_A_PAGE' => 'Een pagina aanmaken',
        'PLEASE_ENTER_PAGE_CONTENT' => 'Voer de inhoud van de pagina in',
        'SEARCH_RESULTS_FOR_X' => 'Zoekresultaten voor <em>%s</em>',
        'EDIT_YOUR_PAGE' => 'Je pagina bewerken',
        'UPDATE_PAGE' => 'Pagina bijwerken',
        'CLOSE_DISCUSSION' => 'Discussie sluiten',
        'REOPEN_DISCUSSION' => 'Discussie heropenen',
        'CLOSING_DISCUSSION_PREVENTS' => 'Als je een discussie sluit kan, niemand er meer op reageren',
        'NO_DISCUSSION_TO_DISPLAY' => 'Er zijn momenteel geen discussies om weer te geven.',
        'BOX_WILL_NOT_SHOW_DISCUSSION' => 'Dit vak is niet zichtbaar voor anderen tenzij je tenminste een discussie opent.',
        'NEWEST_DISCUSSIONS' => 'Nieuwste discussies',
        'LATEST_REPLIES' => 'Laatste reacties',
        'REPLIES_CLOSED_FOR_DISCUSSION' => 'Je kunt niet meer reageren op deze discussie.',
        'SORRY_DISCUSSION_CLOSED' => 'Sorry, maar deze discussie is net gesloten.',
        'MOST_REPLIES' => 'Meeste reacties',
        'OWNER_DISCUSSIONS_ONLY' => 'Alleen discussies van de initiatiefnemer',
        'MY_DISCUSSIONS_ONLY' => 'Alleen mijn eigen discussies',
        'DISCUSSION_DELETED' => 'Discussie verwijderd',
        'DISCUSSION_HAS_BEEN_DELETED' => 'Deze discussie is verwijderd.',
        'REPLY_DELETED' => 'Reactie verwijderd',
        'REPLY_HAS_BEEN_DELETED' => 'Deze reactie is verwijderd. <a %s>Keer terug naar de discussie</a>',
        'VIEW_ALL_DISCUSSIONS' => 'Laat alle discussies zien',
        'ADD_CATEGORIES' => 'Categorieën toevoegen',
        'CATEGORY' => 'Categorie:',
        'NO_DISCUSSIONS_IN_CATEGORY' => 'Er zijn nog geen discussies in deze categorie.',
        'ADD_MANAGE_CATEGORIES' => 'Toevoegen en beheren van categorieën',
        'VIEW_ALL_N_CATEGORIES' => 'Alle %s-categorieën weergeven',
        'UNTITLED_CATEGORY' => 'Naamloze categorie',
        'SAMPLE_TITLE' => 'Voorbeeldtitel',
        'UNCATEGORIZED' => 'Zonder categorie',
        'EXISTING_DISCUSSIONS' => 'Bestaande discussies waar nog geen categorie aan is toegewezen.',
        'YOU_HAVE_NOT_ADDED_CATEGORIES' => 'Op dit moment zijn er nog geen categorieën. Voeg een categorie toe om aan de slag te gaan!',
        'ADD_A_CATEGORY' => 'Categorie toevoegen',
        'ADD_ANOTHER_CATEGORY' => 'Nog een categorie toevoegen',
        'MANAGE_CATEGORIES' => 'Categorieën beheren',
        'CATEGORY_TITLE' => 'Categorietitel',
        'ALLOW_MEMBERS_TO_START_DISCUSSIONS' => 'Leden mogen discussies starten binnen deze categorie',
        'ONLY_I_CAN_START_DISCUSSIONS' => 'Alleen ikzelf mag discussies starten binnen deze categorie',
        'ALLOW_MEMBERS_TO_REPLY' => 'Leden mogen een reactie geven',
        'SUGGESTIONS' => 'Suggesties:',
        'TRY_DIFFERENT_KEYWORDS' => 'Probeer  andereof meer algemene trefwoorden',
        'VIEW_DISCUSSIONS_OR_START_DISCUSSION' => '<a %s>Geef alle discussies weer</a> of <a %s>Start een nieuwe discussie</a>',
        'MAKE_SURE_WORDS_SPELLED' => 'Controleer of alle woorden correct zijn gespeld',
        'REPLY_WAS_DELETED' => 'Deze reactie is verwijderd',
        'TAGS_X' => '<strong>Tags:</strong> %s',
        'SEND_PRIVATE_MESSAGE' => 'Stuur een privé-bericht',
        'PERMALINK_TO_REPLY' => 'Permanente link naar deze reactie',
        'PERMALINK' => 'Permanente link',
        'WE_COULD_NOT_FIND_ANY_DISCUSSIONS' => 'Helaas - we hebben geen discussies gevonden die overeenkomen met je zoekopdracht.',
        'DISCUSSIONS_MATCHING_X' => 'Discussies die overeenkomen met <em>\'%s\'</em>',
        'SEARCH_DISCUSSIONS' => 'Zoek discussies',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS_2' => 'Je hebt nog geen discussies toegevoegd!',
        'ADD_DISCUSSIONS_AND_SHARE' => 'Voeg een discussie toe en deel hem met je vrienden, familie of de rest van de wereld!!',
        'DISCUSSION' => 'Discussie',
        'DISCUSSIONS' => 'Discussies',
        'KEEP_PAGE_OPEN_FORUM' => 'Houd deze pagina open zodat we het uploaden van je bestanden naar het forum kunnen voltooien.',
        'MEANWHILE_FEEL_FREE_FORUM' => 'In de tussentijd kun je gewoon <a %s>een nieuw browser-venster openen</a> en en deze gebruiken %s.',
        'START_A_NEW_DISCUSSION' => 'Een nieuwe discussie starten',
        'DISCUSSION_TITLE' => 'Titel discussie:',
        'FIRST_POST' => 'Eerste bericht:',
        'UPLOAD_FILES' => 'Bestanden uploaden:',
        'START_DISCUSSION' => 'Discussie starten',
        'EDIT_DISCUSSION' => 'Discussie bewerken',
        'START_A_DISCUSSION' => 'Start een discussie',
        'ALL_DISCUSSIONS' => 'Alle discussies',
        'CONTRIBUTORS' => 'Deelnemers',
        'MY_DISCUSSIONS' => 'Mijn discussies',
        'READ_MORE' => 'Meer lezen',
        'STARTED_T_BY' => 'Gestart <strong>%s</strong> door:',
        'ADDED_BY_X_T' => 'Toegevoegd door %s %s',
        'STARTED_BY_X_T' => 'Gestart door %s op %s',
        'REPLY_BY_X_T' => 'Reactie van <strong>%s</strong> %s',
        'STARTED_BY_X_LAST_REPLY_LINK_BY_X_T' => 'Gestart door %s. Laatste <a %s>reactie</a> door %s %s.',
        'STARTED_DISCUSSION_LAST_REPLY_LINK_BY_X_T' => '<strong>heeft deze discussie gestart</strong>. Laatste <a %s>reactie</a> door %s %s.',
        'STARTED_DISCUSSION_T' => '<strong>heeft deze discussie gestart</strong> %s',
        'ADDED_REPLY_T' => '<strong>heeft gereageerd</strong> %s',
        'ADDED_POST_T' => '<strong>heeft een bericht geplaatst</strong> %s',
        'STARTED_BY_X_ON' => 'Gestart door %s op %s',
        'STARTED_DISCUSSION_ON' => '<strong>heeft deze discussie gestart</strong> %s',
        'STARTED_ON' => '<strong>Gestart</strong> %s',
        'ADDED_REPLY_ON' => '<strong>heeft gereageerd</strong> %s',
        'ADDED_POST_ON' => '<strong>heeft een bericht geplaatst</strong> %s',
        'XS_DISCUSSIONS' => 'De discussies van %s',
        'XS_DISCUSSIONS_LOWERCASE' => 'De discussies van %s',
        'VIEW_XS_DISCUSSIONS' => 'Bekijk de discussies van %s',
        'VIEW_YOUR_DISCUSSIONS' => 'Bekijk je discussies',
        'TAGGED_X' => 'Met de tag: %s',
        'SUBSCRIBE_TO_DISCUSSIONS' => 'Abonneer je op deze discussies',
        'SUBSCRIBE_TO_DISCUSSION' => 'Abonneer je op deze discussie',
        'SUBSCRIBE_TO_XS_DISCUSSIONS' => 'Abonneer je op de discussies van %s',
        'ALL_DISCUSSIONS_TAGGED_X' => 'Alle discussies met de tag <em>\'%s\'</em>',
        'SUBSCRIBE_TO_DISCUSSIONS_TAGGED_X' => 'Abonneer je op de discussies met de tag \'%s\'',
        'N_KB' => '%s kB',
        'N_MB' => '%s MB',
        'UPLOADING_FILES' => 'Bezig met uploaden bestanden',
        'ATTACHMENTS' => 'Bijlagen',
        'YOUR_POST' => 'Je bericht:',
        'YOUR_REPLY' => 'Je reactie:',
        'WOULD_YOU_LIKE_TO_UPLOAD_FILES' => 'Wil je bestanden uploaden?',
        'ADD_YOUR_REPLY' => 'Je reactie toevoegen',
        'REPLIES_TO_THIS_DISCUSSION' => 'Berichten in deze discussie',
        'POSTED_BY_X_ON' => 'Bericht van %s %s',
        'PLEASE_ENTER_TITLE' => 'Voer een titel in voor de discussie',
        'PLEASE_ENTER_FIRST_POST' => 'Schrijf het eerste bericht van de discussie.',
        'REPLY_TO_THIS' => 'Hierop reageren',
        'DELETE_ATTACHMENT' => 'Bijlage wissen',
        'DELETE_ATTACHMENT_Q' => 'Deze bijlage wissen?',
        'DELETE_REPLY' => 'Reactie wissen',
        'DELETE_THIS_DISCUSSION_Q' => 'Deze discussie wissen?',
        'ARE_YOU_SURE_DELETE_THIS_DISCUSSION' => 'Weet je zeker dat je deze discussie wilt wissen (inclusief alle berichten en reacties)? Dat kan enige minuten in beslag nemen.',
        'DELETE_DISCUSSION' => 'Discussie wissen',
        'NOBODY_HAS_ADDED_DISCUSSIONS' => 'Niemand heeft nog discussies toegevoegd! Voeg een discussie toe om te beginnen.',
        'NOBODY_HAS_ADDED_DISCUSSIONS_ADD' => 'Niemand heeft nog discussies toegevoegd. Voeg een discussie toe om te beginnen.',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS' => 'Je hebt nog geen discussies toegevoegd. Voeg een discussie toe om te beginnen!',
        'YOU_HAVE_NOT_STARTED_DISCUSSIONS' => 'Je hebt nog geen discussies gestart.',
        'YOU_HAVE_NOT_ADDED_TO_DISCUSSIONS' => 'Je hebt nog niet deelgenomen aan een discussie.',
        'X_HAS_NOT_ADDED_DISCUSSIONS' => '%s heeft nog niet deelgenomen aan een discussie.',
        'X_HAS_NOT_STARTED_DISCUSSIONS' => '%s heeft nog geen discussies gestart.',
        'X_HAS_NOT_ADDED_TO_DISCUSSIONS' => '%s heeft nog niets toegevoegd aan een discussie.',
        'VIEW_DISCUSSIONS' => 'Discussies bekijken',
        'VIEW_ALL_PEOPLE_ON_X' => 'Alle mensen op %s weergeven',
        'THERE_ARE_NO_DISCUSSIONS' => 'Er zijn momenteel geen discussies op je netwerk.',
        'GROUP_HAS_NO_DISCUSSIONS' => 'Deze groep heeft nog geen discussies.',
        'VIEW_DISCUSSIONS_IN_GROUP_FORUM' => 'Laat de discussies zien in het <a %s>%s forum</a>!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT_ADD' => 'Er zijn geen discussies met de tag "%1$s". Bekijk <a %2$s>foto\'s met de tag "%1$s"</a> of <a %3$s>video\'s met de tag "%1$s"</a>. Je kunt ook zelf een discussie toevoegen met je eigen tags.!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT' => 'Er zijn geen discussies met de tag "%1$s". Bekijk <a %2$s>foto\'s met de tag "%1$s"</a> of <a %3$s>video\'s met de tag "%1$s"</a>.',
        'THIS_BOX_WILL_NOT_SHOW_DISCUSSIONS' => 'Dit vak wordt aan anderen pas weergegeven als er discussies zijn om weer te geven. Wil je er een starten?',
        'DISCUSSIONS_I_STARTED' => 'Door mij gestarte discussies',
        'DISCUSSIONS_X_STARTED' => 'Door %s gestarte discussies',
        'DISCUSSIONS_I_REPLIED_TO' => 'Discussies waarop ik heb gereageerd',
        'DISCUSSIONS_X_REPLIED_TO' => 'Discussies waarop %s heeft gereageerd',
        'PLEASE_WRITE_SOMETHING_FOR_POST' => 'Schrijf iets voor je bericht.',
        'PLEASE_WRITE_SOMETHING_FOR_REPLY' => 'Schrijf iets voor je reactie.',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION_X' => 'Er is een nieuwe reactie op je discussie \'%s\' op %s',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION' => 'Er is een nieuwe reactie op een van je discussies op %s',
        'SOMEBODY_COMMENTED_DISCUSSION_ADDED_TO_X' => 'Iemand heeft gereageerd op een discussie die jij hebt gestart op %s',
        'ABOUT_YOUR_DISCUSSION' => 'Over je discussie',
        'ABOUT_THIS_DISCUSSION' => 'Over deze discussie',
        'USER_REPLIED_TO_A_DISCUSSION_ON_Y' => '%s heeft gereageerd op een discussie op %s',
        'USER_REPLIED_TO_DISCUSSION_TITLE_ON_APPNAME' => '%s heeft gereageerd op de discussie "%s" op %s',
        'PROBLEM_WITH_ICON' => 'Er was een probleem met het miniatuurbestand',
        'GROUP_ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Groepbeheerders hebben gelijke rechten over de groep als de initiatiefnemer van de groep',
        'CREATE_NEW_GROUP' => '"Nieuwe groep maken, Nieuwe groep maken"',
        'CREATE_A_NEW_GROUP' => 'Een nieuwe groep aanmaken',
        'CREATE_A_GROUP' => 'Een groep aanmaken',
        'VIEW_GROUPS' => 'Groepen weergeven',
        'CREATE_GROUP' => 'Groep aanmaken',
        'PLEASE_ENTER_NAME_FOR_GROUP' => 'Kies een naam voor je groep.',
        'PLEASE_ENTER_URL_FOR_GROUP' => 'Kies een web-adres voor je groep.',
        'URL_CAN_CONTAIN_ONLY_LETTERS' => 'Het webadres mag alleen letters en cijfers bevatten (geen spaties).',
        'NAME_TAKEN' => 'Helaas - die naam is al bezet. Kies een andere naam.',
        'URL_TAKEN' => 'Helaas - dat webadres is al bezet. Kies een ander webadres.',
        'GROUP_INFORMATION' => 'Groepsinformatie',
        'EXTERNAL_WEBSITE' => 'Externe website',
        'DO_YOU_HAVE_EXISTING_WEBSITE' => 'Heb je al een bestaande groepwebsite ergens anders?',
        'URL' => 'URL',
        'GROUPS' => 'Groepen',
        'SEARCH_GROUPS' => 'Doorzoek groepen',
        'NOBODY_HAS_CREATED_GROUPS' => 'Niemand heeft nog een groep aangemaakt.',
        'NOBODY_HAS_CREATED_GROUPS_ADD' => 'Niemand heeft nog een groep aangemaakt! Maak een groep aan en ga aan de slag.',
        'MY_GROUPS' => 'Mijn groepen',
        'FEATURED_GROUPS' => 'Groepen op de hoofdpagina',
        'YOU_CAN_CREATE_GROUP' => 'Je kunt <a %s>een nieuwe groep aanmaken</a> op %s!',
        'GROUP_FORUM' => '%s forum',
        'USER_CREATED_GROUP' => '%s heeft deze groep gecreëerd op %s.',
        'GROUP_MEMBERS_COUNT' => '%s leden (%d)',
        'WE_ARE_SORRY_NOT_ALLOWED_JOIN_GROUP' => 'Helaas kun je niet lid worden van deze groep.',
        'JOIN_GROUP_NOW' => 'Sluit je nu aan bij %s!',
        'USER_HAS_INVITED_YOU_TO_JOIN_GROUP' => '%s heeft je uitgenodigd om lid te worden van %s',
        'DECLINE' => 'Afwijzen',
        'WELCOME_TO_GROUP' => 'Welkom bij %s',
        'YOU_CAN_PARTICIPATE_IN_GROUP' => 'Je kunt nu deelnemen in het %s forum.',
        'SEND_MESSAGE_TO_GROUP' => 'Stuur een bericht naar de groep',
        'LEAVE_THIS_GROUP' => 'Verlaat deze groep',
        'EDIT_GROUP_INFO' => 'Bewerk de informatie over deze groep',
        'EDIT_GROUP_INFORMATION' => 'Bewerk groepsinformatie',
        'MANAGE_GROUP_MEMBERS' => 'Bewerk groepsleden',
        'GROUP_HAS_NO_MEMBERS' => 'Deze groep heeft nog geen leden!',
        'GROUP_HAS_NO_MEMBERS_THAT_MATCH' => 'Deze groep heeft geen leden die overeenkomen met je zoekpopdracht.',
        'USERS_GROUPS' => 'Groepen van %s',
        'YOU_HAVE_NOT_CREATED_GROUPS' => 'Je hebt nog geen groepen aangemaakt.',
        'USER_HAS_NOT_CREATED_GROUPS' => '%s heeft nog geen groepen aangemaakt.',
        'THERE_ARE_NO_FEATURED_GROUPS' => 'Er zijn geen groepen met de markering \'Op Hoofdpagina\'  binnen je netwerk.',
        'START_FEATURING_GROUPS' => 'Plaats groepen op de hoofdpagina met de knop \'Op Hoofdpagina\'. Voor meer informatie over op de hoofdpagina plaatsen <a %s>klik je hier</a>.',
        'NO_GROUPS_TO_DISPLAY' => 'Er zijn momenteel geen groepen om weer te geven.',
        'BOX_WILL_NOT_SHOW_GROUPS' => 'Dit vak is niet zichtbaar voor anderen. Selecteer minstens 1 groep.',
        'YOU_HAVE_NOT_CREATED_GROUPS_2' => 'Je hebt nog geen groepen aangemaakt!',
        'CREATE_GROUPS_AND_SHARE' => 'Maak groepen aan en deel ze met je vrienden, familie of de rest van de wereld!',
        'THERE_ARE_NO_GROUPS' => 'Er zijn momenteel geen groepen binnen je netwerk.',
        'THIS_BOX_WILL_NOT_SHOW_GROUPS' => 'Dit vak is niet zichtbaar voor anderen, omdat er nog geen groepen zijn. Waarom creëer je er nu niet een?',
        'GROUPS_MATCHING_SEARCH_TERM' => 'Groepen die overeenkomen met <em>\'%s\'</em>',
        'WE_COULD_NOT_FIND_ANY_GROUPS' => 'Helaas, we hebben geen groepen gevonden die overeenkomen met je zoekopdracht.',
        'VIEW_GROUPS_OR_CREATE_GROUP' => '<a %s>Laat alle groepen zien</a> of <a %s>Maak een nieuwe groep aan</a>',
        'VIEW_ALL_GROUPS' => 'Laat alle groepen zien',
        'DELETE_GROUP' => 'Groep verwijderen',
        'DELETE_GROUP_Q' => 'Weet je het zeker dat je deze groep wilt verwijderen?',
        'GROUP_INVITATIONS' => 'Groepsuitnodigingen',
        'YOU_HAVE_BEEN_INVITED_TO_JOIN' => 'Je bent uitgenodigd om lid te worden van:',
        'VISIT' => 'Bezoek',
        'WHO_CAN_JOIN_GROUP' => 'Wie kan er lid worden van deze groep?',
        'PRIVACY_CANNOT_BE_CHANGED' => 'De privacy-instelling kan niet meer worden gewijzigd nadat de groep is aangemaakt.',
        'ONLY_INVITED_PEOPLE' => 'Alleen personen met een uitnodiging',
        'ALLOW_PEOPLE_TO_REQUEST' => 'Sta toe dat anderen een uitnodiging aanvragen',
        'ANYONE_CAN_JOIN_GROUP' => 'Iedereen kan lid worden van deze groep',
        'ONLY_INVITED_PEOPLE_CAN_JOIN_GROUP' => 'Alleen personen met een uitnodigingen kunnen lid worden van deze groep',
        'WHY_NOT_CREATE_GROUP' => 'Waarom zou je niet <a %s>je eigen groep aanmaken</a>?',
        'PLEASE_ENTER_NAME' => 'Voer je naam in',
        'PLEASE_ENTER_EMAIL_ADDRESS' => 'Voer je emailadres in',
        'PLEASE_ENTER_PAGE_ADDRESS' => 'Voer een nieuw pagina-adres in',
        'PLEASE_ENTER_PASSWORD' => 'Voer je wachtwoord in',
        'CREATE_ACCOUNT_OR_SIGN_IN' => '<a %s>Klik hier om een account te maken</a> of probeer je hieronder opnieuw aan te melden.',
        'CREATE_ACCOUNT_OR_JOIN' => '<a %s>Klik hier om een account te maken</a> of probeer je hieronder aan te melden met je Ning-id.',
        'CHOOSE_SHORTER_PASSWORD' => 'Kies een korter wachtwoord.',
        'CHOOSE_SHORTER_NAME' => 'Kies een kortere naam.',
        'ENTER_SHORTER_CITY_NAME' => 'Kies een kortere plaatsnaam.',
        'PLEASE_ENTER_PASSWORD_AGAIN' => 'Voer je wachtwoord nogmaals in in het vak "Herhaal je wachtwoord".',
        'PLEASE_ENTER_CURRENT_PASSWORD' => 'Voer je huidige wachtwoord in.',
        'PLEASE_ENTER_NEW_PASSWORD' => 'Voer je nieuwe wachtwoord in.',
        'PLEASE_ENTER_NEW_PASSWORD_AGAIN' => 'Voer je nieuwe wachtwoord nogmaals in in het vak "Herhaal je wachtwoord".',
        'CURRENT_PASSWORD' => 'Huidig wachtwoord',
        'PASSWORDS_DO_NOT_MATCH' => 'De twee wachtwoorden komen niet overeen.',
        'NEW_AND_CONFIRMATION_PASSWORDS' => 'Het nieuwe wachtwoord en de bevestiging ervan komen niet overeen.',
        'YOUR_REQUEST_HAS_BEEN_SENT_TO_GROUP_CREATOR' => 'Je verzoek is verzonden naar de initiatiefnemer van de groep.',
        'X_IS_NOT_VALID_EMAIL_ADDRESS' => '%s is geen geldig e-mail adres',
        'COME_JOIN_ME_ON_GROUP' => 'Sluit je bij me aan op %s!',
        'INVITE_PEOPLE_TO_GROUP' => 'Nodig anderen uit voor %s',
        'INVITE_FRIENDS_TO_GROUP' => 'Nodig vrienden uit voor %s',
        'SEND_INVITATIONS_TO_JOIN_GROUP' => 'Stuur uitnodigingen naar anderen om lid te worden van %s.',
        'GROUPNAME_MEMBERS' => '%s leden',
        'GROUP_CREATOR' => 'Initiatiefnemer van de groep',
        'GROUP_ADMINISTRATOR' => 'Groepsbeheerder',
        'DATE_BANNED' => 'Datum verwijderd',
        'BAN_FROM_GROUP' => 'Uit groep verwijderen',
        'ARE_YOU_SURE_BAN_MEMBER_FROM_GROUP' => 'Weet je zeker dat je het lid of de leden die je hebt geselecteerd, wilt verwijderen? Dit kan enkele minuten in beslag nemen.',
        'ALSO_DELETE_FORUM_POSTINGS' => 'Verwijder ook de reacties en berichten.',
        'GROUP_WEB_ADDRESS' => 'Web-adres van de groep',
        'GROUP' => 'Groep',
        'BACK_TO_GROUP' => '← Terug naar %s',
        'USER_BANNED_FROM_GROUP' => '%1$s is reeds verwijderd uit deze groep. <a %2$s>Stuur %1$s een bericht</a>',
        'USER_ALREADY_GROUP_MEMBER' => '%1$s is reeds lid van deze groep. <a %2$s>Stuur %1$s een bericht</a>',
        'GROUP_ADMIN_DISCUSSIONS' => 'Groep admin discussies',
        'BACK_TO_NETWORK_GROUPS' => 'Terug naar %s groepen',
        'MOST_MEMBERS' => 'Meeste leden',
        'THIS_SETS_URL_OF_GROUP' => 'Dit bepaalt de URL van je groep: http://%s/<strong>groupwebaddress</strong>',
        'LIKE_WHAT_YOU_SEE' => 'Bevalt %s je? Sluit je aan!',
        'LIKE_WHAT_YOU_SEE_GROUP' => 'Bevalt %s je? Sluit je aan!',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => 'Je hebt de %1$s groep gecreëerd. Je kunt deelnemen aan het %1$s forum anderen uitnodigen om ook lid te worden.',
        'YOU_ARE_MEMBER_OF_GROUP_AND_CAN_INVITE' => 'Je bent nu lid van %1$s. Je kunt deelnemen aan het %1$s forum anderen uitnodigen om ook lid te worden.',
        'NETWORK_DOES_NOT_HAVE_MUSIC' => 'Dit netwerk heeft nog geen muziek.',
        'PERSON_DOES_NOT_HAVE_MUSIC' => 'Deze persoon heeft nog geen muziek.',
        'FIND_MORE_MUSIC_LIKE_THIS' => 'Vind meer van deze soort muziek op <em>%s</em>',
        'TRACKS' => 'Nummers',
        'ADD_MUSIC_TRACKS' => 'Audio toevoegen',
        'CHOOSE_MUSIC_TRACKS' => 'Kies een audiobestand',
        'YOU_CAN_ADD_UP_TO_MP3' => 'Je kunt tot 4 MP3\'s tegelijk uploaden',
        'UPLOAD_TRACKS' => 'Liedjes uploaden',
        'ADD_TRACKS' => 'Liedjes toevoegen',
        'ENTER_THE_URL_MP3_TO_ADD' => 'Geef de URL van elke MP3 die je wilt toevoegen:',
        'EACH_MP3_FILE_MAY_BE_UP_TO' => 'Je kunt tot 100 MP3\'s toevoegen! Elk MP3-bestand mag maximaal 20 Mb groot zijn, maar kleinere bestanden worden sneller verwerkt.',
        'BE_NICE' => 'Wees aardig',
        'PLEASE_UPLOAD_ONLY_TRACKS' => 'Alleen bestanden waarvan je toestemming hebt van de rechthebbende uploaden.',
        'PLEASE_LINK_ONLY_TRACKS' => 'Maak alleen links naar muziek die rechtenvrij gedistribueerd mag worden.',
        'MORE_WAY_TO_ADD_MUSIC' => 'Meer manieren om muziek toe te voegen...',
        'ELLIP_FROM_ANOTHER_WEBSITE' => '...vanaf een andere webpagina',
        'ADD_MUSIC_FROM_ANY_WEBSITE' => 'Voeg muziek vanaf een andere website toe door de link naar de MP3 te kopiren en plakken.',
        'KEEP_PAGE_OPEN_MUSIC' => 'Houd dit venster aub geopend terwijl je bestand wordt geüpload en we laten je weten wanneer de upload is goedgekeurd!',
        'MEANWHILE_FEEL_FREE_MUSIC' => 'Ondertussen kun je een <a %s>nieuw browser-venster openen</a> en doorgaan met %s. Zodra de upload gereed is kun je in dit venster titels en beschrijvingen aan de liedjes toevoegen.',
        'TRACKS_EXCEEDED_LIMIT' => 'Deze nummers lijken groter te zijn dan de toegestane 10 Mb.',
        'EDIT_TRACK_INFORMATION' => 'Pas beschrijving van het liedje aan',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_1' => 'Voeg een titel, beschrijving en aanvullende informatie toe aan de liedjes die je zojuist hebt geüpload.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_2' => 'Voeg een titel, beschrijving en aanvullende informatie toe aan dit liedje.',
        'CANCEL_AND_RETURN_TO_PLAYLIST' => '« Annuleren en terugkeren naar afspeellijst',
        'TRACK_TITLE' => 'Titel',
        'TRACK_ARTIST' => 'Artiest/Auteur',
        'TRACK_ALBUM' => 'Album',
        'ENABLE_DOWNLOAD_LINK' => 'Maak koppeling om download te loaden-',
        'ALLOW_PEOPLE_TO_ADD_TRACK_TO_PROFILE' => 'Sta toe dat anderen dit bestand op hun eigen site publiceren.',
        'TRACK_ARTWORK' => 'Artwork',
        'EDIT_PLAYLIST' => 'Afspeellijst bewerken',
        'DRAG_TO_CHANGE_ORDER_PLAYLIST' => 'Om de volgorde van de afspeellijst aan te passen, sleep je het liedje naar de juiste plaats.',
        'ADD_MUSIC_ELLIPSIS' => 'Muziek toevoegen...',
        'ELLIPSIS_FROM_YOUR_COMPUTER' => '...vanaf je computer',
        'UPLOAD_MP3_FROM_YOUR_COMPUTER' => 'MP3\'s vanaf je computer uploaden.',
        'DELETE_THIS_TRACK_Q' => 'Dit bestand verwijderen?',
        'DELETE_TRACK' => 'Bestand verwijderen',
        'ARE_YOU_SURE_DELETE_THIS_TRACK' => 'Weet u zeker dat u dit bestand wilt verwijderen?',
        'PLAY' => 'afspelen',
        'GENRE' => 'Genre',
        'YEAR' => 'Jaar',
        'LABEL' => 'Platenlabel',
        'EXPLICIT_LYRICS' => 'Expliciet taalgebruik',
        'ARTIST_SITE' => 'Website van de artiest/auteur',
        'HOSTING_SITE' => 'Hostisite',
        'LABEL_SITE' => 'Website van het label',
        'LICENSE' => 'Licentie',
        'SELECT_LICENSE' => '— Selecteer licentie —',
        'LICENSE_NAME' => 'Naam licentie',
        'LICENSE_URL' => 'Licentie-URL',
        'MUSIC' => 'Muziek',
        'ALLOW_PEOPLE_TO_UPLOAD_AND_SHARE_AUDIO' => 'Toestaan dat audio toegevoegd en met anderen gedeeld wordt.',
        'PLAYLIST' => 'Afspeellijst',
        'PODCAST' => 'Podcast',
        'MOST_RECENT_TRACKS' => 'Meest recent',
        'FEATURED_TRACKS' => 'Op hoofdpagina',
        'HIGHEST_RATED_TRACKS' => 'Hoogste cijfer',
        'NO_TRACKS_TO_PLAY' => 'Er staat momenteel geen muziek op je community.',
        'BOX_WILL_NOT_SHOW_TRACKS' => 'Dit vak is voor andere bezoekers niet te zien totdat er een liedje of podcast is toegevoegd. Waarom niet meteen even doen??',
        'NO_TRACKS_ON_PLAYLIST' => 'Er zijn momenteel geen bestanden aanwezig in deze afspeellijst.',
        'PLAYER_WILL_NOT_SHOW_TRACKS' => 'Deze speler is voor andere bezoekers niet te zien totdat er een liedje of podcast is toegevoegd. Waarom niet meteen even doen?',
        'NO_FEATURED_TRACKS' => 'Er zijn geen liedjes aan de hoofdpagina toegekend',
        'START_FEATURING_TRACKS' => 'Geef aan welke liedjes u graag op de hoofdpagina wilt zien.',
        'VIEW_MUSICPLAYER' => 'Muziekspeler weergeven',
        'MY_PLAYLIST' => 'Mijn afspeellijst',
        'NETWORK_PLAYLIST' => 'Afspeellijst netwerk',
        'COPYRIGHT' => '© Alle rechten voorbehouden',
        'CC_BY_X' => 'Creative Commons Naamsvermelding %s',
        'CC_BY_SA_X' => 'Creative Commons Naamsvermelding-GelijkDelen %s',
        'CC_BY_ND_X' => 'Creative Commons Naamsvermelding-GeenAfgeleideWerken %s',
        'CC_BY_NC_X' => 'Creative Commons Naamsvermelding-NietCommercieel %s',
        'CC_BY_NC_SA_X' => 'Creative Commons Naamsvermelding-NietCommercieel-GelijkDelen %s',
        'CC_BY_NC_ND_X' => 'Creative Commons Naamsvermelding-NietCommercieel-GeenAfgeleideWerken %s',
        'PUBLICDOMAIN' => 'Rechtenvrij',
        'FACEBOOK_CONFIRM_DISABLE' => 'Weet je het zeker?',
        'FACEBOOK_PLAYER_DISABLE' => 'Uitschakelen',
        'FACEBOOK_MUSIC_PLAYER_TITLE' => 'Muziekspeler',
        'FACEBOOK_MUSIC_PLAYER_DESC' => 'Geef anderen de mogelijkheid een toepassing aan hun Facebook-pagina\'s toe te voegen om audiofiles van jouw community mee af te spelen.',
        'FACEBOOK_MUSIC_BUTTON' => 'Maak audiotoepassing &raquo;',
        'FACEBOOK_MUSIC_PLAYER_ENABLED' => 'Facebook audiotoepassing al geactiveerd.',
        'FACEBOOK_VIDEO_PLAYER_TITLE' => 'Videospeler',
        'FACEBOOK_VIDEO_PLAYER_DESC' => 'Geef anderen de mogelijkheid een toepassing aan hun Facebook-pagina\'s toe te voegen om videofiles van jouw community mee af te spelen.',
        'FACEBOOK_VIDEO_BUTTON' => 'Maak videotoepassing &raquo;',
        'FACEBOOK_VIDEO_PLAYER_ENABLED' => 'Facebook videotoepassing al geactiveerd.',
        'FACEBOOK_SLIDESHOW_PLAYER_TITLE' => 'Diavoorstelling',
        'FACEBOOK_SLIDESHOW_PLAYER_DESC' => 'Geef anderen de mogelijkheid een toepassing aan hun Facebook-pagina\'s toe te voegen om een foto-slideshow van jouw community mee af te spelen.',
        'FACEBOOK_SLIDESHOW_BUTTON' => 'Maak fototoepassing &raquo;',
        'FACEBOOK_SLIDESHOW_PLAYER_ENABLED' => 'Facebook-fototoepassing al geactiveerd.',
        'FACEBOOK_PLATFORM_LOGO' => 'Facebook-logo',
        'FACEBOOK_QUICK_INTRO_1' => 'Facebook, een populaire community-site, biedt de mogelijkheid om applicaties van anderen toe te voegen aan Facebook profielpagina\'s. Dit biedt niet alleen extra functionaliteit, maar is ook een manier om andere Facebook-gebruikers attent te maken op je community.',
        'FACEBOOK_QUICK_INTRO_2' => 'Met Ning kun je op Facebook reclame maken voor je netwerk zonder dat je een programmeur hoeft te zijn. Al het ingewikkelde werk is al gedaan, in je netwerk zijn al diverse kant-en-klare Facebook-toepassingen aanwezig! Kies uit de onderstaande mogelijkheden en de integratie met Facebook is in luttele seconden gebeurd!',
        'FACEBOOK_ADD_DEVELOPER_BUTTON' => 'Ontwikkelaar-knop toevoegen',
        'FACEBOOK_SETUP_NEW_APP_BUTTON' => 'Nieuwe applicatieknop instellen',
        'FACEBOOK_YOUR_APPLICATIONS' => 'Jouw Facebook-applicaties',
        'FACEBOOK_EMBEDDING' => 'Reclame op Facebook',
        'FACEBOOK_SETUP' => 'Reclame op Facebook',
        'FACEBOOK_PROMOTING' => 'Reclametoepassingen op Facebook',
        'FACEBOOK_VIEW_APP' => 'Bekijk applicatie',
        'FACEBOOK_ADD_THE' => 'Voeg toe: de',
        'FACEBOOK_RECENT' => 'Meest recent',
        'FACEBOOK_RECENTLY_FEATURED' => 'meest recent op de hoofdpagina geplaatste',
        'FACEBOOK_RECENTLY_ADDED' => 'meest recent toegevoegde',
        'FACEBOOK_PROMOTED' => 'Op hoofdpagina',
        'FACEBOOK_RATED' => 'Hoogste cijfer',
        'FACEBOOK_POPULAR' => 'Populaire',
        'FACEBOOK_MUSIC_WIDGET' => 'muziekwidget',
        'FACEBOOK_VIDEO_WIDGET' => 'videowidget',
        'FACEBOOK_PHOTO_WIDGET' => 'fotowidget',
        'FACEBOOK_INSTR_FIRST_STEPS' => 'Eerste stappen',
        'FACEBOOK_INSTR_CLICK_HERE_TO_GO_TO_FACEBOOK' => 'Klik hier om naar Facebook te gaan en te starten met het aanmaken van je applicatie.',
        'FACEBOOK_INSTR_OPEN_FACEBOOK_IN_NEW_WINDOW' => 'Facebook opent nu in een nieuw venster. Als je nog niet ingelogd bent, moet je dat eerst doen.',
        'FACEBOOK_INSTR_FIRST_STEPS_1' => 'Als je nog geen applicatie op Facebook hebt aangemaakt, word je gevraagd om de Facebook Developer Applicatie te starten. Als je dit doet, volgt de melding "You have no applications." Klik dan op <strong>"Create one"</strong>.',
        'FACEBOOK_INSTR_FIRST_STEPS_2' => 'Als je al wel een applicatie op Facebook hebt, kom je automatisch in de Facebook Developer Applicatie. Klik nu op de knop <strong>"Set Up New Application"</strong>.',
        'FACEBOOK_INSTR_FIRST_STEPS_NEXT' => 'Volgende: instructies voor het opzetten van een applicatie zodat deze werkt op Facebook.',
        'FACEBOOK_INSTR_SETUP' => 'Installatie-instructies',
        'FACEBOOK_INSTR_SETUP_1' => 'Mooi! En dan nu nog wat gegevens. Facebook heeft deze gegevens nodig om je applicatie van de grond te krijgen. Volg gewoon de onderstaande stappen.',
        'FACEBOOK_INSTR_SETUP_REQ_FIELDS' => 'Verplichte velden',
        'FACEBOOK_INSTR_SETUP_2' => 'Kies een <strong>applicatienaam</strong>.',
        'FACEBOOK_INSTR_SETUP_3' => 'Aanvinken om aan te geven dat je de algemene voorwaarden van Facebook gelezen hebt.',
        'FACEBOOK_INSTR_SETUP_4' => 'Open de <em>"Optional Fields"</em>-sectie.',
        'FACEBOOK_INSTR_SETUP_BASE_OPT' => 'Basisopties',
        'FACEBOOK_INSTR_SETUP_5' => 'Typ uw e-mailadres in het <strong>"Support E-Mail"</strong>-veld.',
        'FACEBOOK_INSTR_SETUP_6' => 'Knip en plak het volgende webadres in het veld <strong>\'Callback URL\'</strong>:',
        'FACEBOOK_INSTR_SETUP_7_EXAMPLE_X' => 'Kies een <strong>Canvas Page URL</strong> (bijv. <em>%s</em>).',
        'FACEBOOK_INSTR_SETUP_8' => 'Kies <strong>"Yes"</strong> bij <em>"Can your application be added on Facebook"</em>.',
        'FACEBOOK_INSTR_SETUP_INST_OPT' => 'Installatie-opties',
        'FACEBOOK_INSTR_SETUP_APP_DESC' => 'Maak een <strong>Applicatiebeschrijving</strong>.',
        'FACEBOOK_INSTR_SETUP_9' => 'Knip en plak de volgende code in het <strong>"Default FBML"</strong>-veld:',
        'FACEBOOK_INSTR_SETUP_9B_WIDE' => 'Voor <strong>"Default Profile Box Column"</strong>, kies <strong>"Wide"</strong>.',
        'FACEBOOK_INSTR_SETUP_9B_NARROW' => 'Voor <strong>"Default Profile Box Column"</strong>, kies <strong>"Narrow"</strong>.',
        'FACEBOOK_INSTR_SETUP_10' => 'In het <strong>"Side Nav URL"</strong>-veld typ je de <em>Canvas Page URL</em> (die je hebt gemaakt in stap &#8216;f&#8217; hierboven). Zorg ervoor dat de URL begint met "http://apps.facebook.com/".',
        'FACEBOOK_INSTR_SETUP_11' => 'Maak een tekst voor de <strong>"Attachment action"</strong>. Dit is de tekst die verschijnt als je iemand een bericht stuurt op Facebook en één van je applicaties wilt toevoegen. Als je applicatie een diavoorstelling is, noem je het bijvoorbeeld "Foto\'s van (naam van je community)". Als je applicatie een videospeler is, noem je hem bijvoorbeeld "Video\'s van (naam van je community)".',
        'FACEBOOK_INSTR_SETUP_12' => 'Knip en plak het volgende webadres in het veld <strong>\'Callback URL\'</strong>:',
        'FACEBOOK_INSTR_APPLICATION_SETUP_PAGE' => 'Configuratiepagina voor Facebook-applicatie-',
        'FACEBOOK_INSTR_SETUP_DONE' => 'Als je klaar bent, klik dan op de <strong>"Submit"</strong>-knop.',
        'FACEBOOK_INSTR_SETUP_NEXT' => 'Volgende: je API-sleutel en- geheim toegezonden krijgen.',
        'FACEBOOK_API_INFO_TITLE' => 'Facebook API-informatie',
        'FACEBOOK_API_INFO_DESC' => 'Om de setup af te ronden moet je de API-sleutel en -geheim en de applicatie-URL invoeren in de onderstaande velden.',
        'FACEBOOK_API_INFO_FIND_KEY' => 'Je vindt de API-sleutel en -geheim op je <a %s>"My Applications"-pagina op Facebook</a> (opent in een nieuw venster) onder de titel die je aan de applicatie hebt gegeven.',
        'FACEBOOK_API_INFO_MY_APPLICATIONS_PAGE' => '"My Applications"-pagina (gemarkeerde deel geeft aan waar de API-informatie staat)',
        'FACEBOOK_API_INFO_KEY' => 'API-sleutel',
        'FACEBOOK_API_INFO_SECRET' => 'API-geheim',
        'FACEBOOK_URL_INFO_TITLE' => 'Facebook applicatie-URL',
        'FACEBOOK_URL_INFO_DESC' => 'De applicatie-URL is identiek aan de <strong>"Canvas Page URL"</strong> die je in de vorige pagina hebt gedefinieerd (in stap &#8216;f&#8217;).',
        'FACEBOOK_MUSIC_SHOULD_PLAY_FROM' => 'Facebook muziekapplicaties spelen audio van:',
        'FACEBOOK_VIDEO_SHOULD_PLAY_FROM' => 'Facebook videoapplicaties spelen video van:',
        'FACEBOOK_PHOTO_SHOULD_PLAY_FROM' => 'Facebook foto-applicaties laten foto\'s zien van:',
        'FACEBOOK_PROMOTING_ON' => 'Reclame maken op Facebook',
        'FACEBOOK_SETUP_INSTR' => 'Installatie-instructies',
        'FACEBOOK_API_INFO' => 'API-informatie',
        'FACEBOOK_DISABLE' => 'Deze applicatie uitschakelen',
        'FACEBOOK_TO_YOUR_FACEBOOK_PROFILE' => 'naar je Facebook-profiel',
        'FACEBOOK_BACK_TO_EMBEDDING' => 'terug naar Facebook-promotie',
        'FACEBOOK_EMBEDDING_DESC' => 'Sta toe dat Facebook-gebruikers de widgets en banners van je community op hun profielpagina\'s zetten.',
        'FACEBOOK_PROMOTE' => 'Om het meeste rendement uit je promotie-activiteiten te halen, raden wij aan de volgende stappen nog te doorlopen. Deze opties kunnen allemaal benaderd worden vanuit <strong><a %s>"My Applications"</a></strong> op Facebook (link opent in een nieuw venster).',
        'FACEBOOK_PROMOTE_TITLE_ABOUT_PAGE' => 'Maak een informatiepagina',
        'FACEBOOK_PROMOTE_TEXT_ABOUT_PAGE' => 'Geef Facebook-gebruikers een goede omschrijving van je community. Om deze informatie aan te passen klik je op de <strong>"Edit About Page"</strong>-link naast de naam van de applicatie die je wilt aanpassen.',
        'FACEBOOK_PROMOTE_TITLE_SUBMIT' => 'Voeg de applicatie toe aan de Facebook Directory',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_1' => 'Laat Facebook-gebruikers weten dat uw applicatie bestaat door deze in de Facebook directory op te nemen.',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_2' => 'Om je applicatie te activeren klik je op de koppeling <strong>"Submit Application"</strong> naast de naam van de applicatie die aangepast hebt. Op de pagina erna kun je de applicatiebeschrijving wijzigen en ook een logo toevoegen.',
        'FACEBOOK_PROMOTE_TITLE_PROFILE' => 'Voeg de applicatie toe aan je Facebook-profiel',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_1' => 'Zet je applicatie op je eigen Facebook-profielpagina en zie hoe je vrienden dat ook gaan doen.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_2' => 'Klik op de <strong>"View About Page"</strong>-link naast de applicatie die je op je profiel wilt zetten en klik dan de "Add Application"-knop op de volgende pagina.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_3' => 'Je applicatie staat nu onderaan je Facebook profielpagina!',
        'FACEBOOK_PROMOTE_MY_APPLICATIONS_PAGE' => 'De "My Applications"-pagina op Facebook',
        'FACEBOOK_MY_APPS' => 'Mijn applicaties',
        'FORUM_TAB_TEXT' => 'Forum',
        'VIDEOS_TAB_TEXT' => 'Video\'s',
        'PHOTOS_TAB_TEXT' => 'Foto\'s',
        'GROUPS_TAB_TEXT' => 'Groepen',
        'COME_JOIN_ME_ON_THE_GROUP_X_ON_Y' => 'Sluit je bij me aan bij de groep %1$s bij %2$s…',
        'COME_JOIN_ME_ON_X_ON_Y' => 'Sluit je bij me aan bij %1$s bij %2$s,',
        'COME_JOIN_ME_ON_X_ON_Y_ELLIPSIS' => 'Sluit je bij me aan bij %1$s bij %2$s…',
        'POPULATE' => '<strong>Vullen.</strong>',
        'ADD_PHOTOS_LOWER' => 'Foto\'s toevoegen',
        'YOUR_VIDEO_UPLOAD_TO_X_DID_NOT_COMPLETE_DUE_TO_A_CONVERSION_ERROR' => 'Het uploaden van de video naar %s is niet voltooid door een conversiefout.',
        'TO_HELP_TROUBLESHOOT_PROVIDE_THIS_VIDEO_ID_X' => 'Geef dit  Video-ID door om het probleem te helpen oplossen: %s',
        'YOUR_VIDEO_WAS_SUCCESSFULLY_UPLOADED_TO_X' => 'Het uploaden van je video naar %s is geslaagd.',
        'TO_VIEW_THE_VIDEO_VISIT' => 'Je kunt de video bekijken via:',
        'YOUR_VIDEO_X_ON_Y_HAS_A_NEW_COMMENT' => 'Er is een nieuwe reactie op je video "%1$s" op %2$s.',
        'YOUR_VIDEO_ON_X_HAS_A_NEW_COMMENT' => 'Er is een nieuwe reactie op je video bij %s.',
        'YOUR_PHOTO_X_HAS_A_NEW_COMMENT_ON_Y' => 'Er is een nieuwe reactie op je foto "%1$s" op %2$s.',
        'YOUR_PHOTO_HAS_A_NEW_COMMENT_ON_X' => 'Er is een nieuwe reactie op je foto op %s.',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y_ELLIPSIS' => 'Er is een nieuw(e) %1$s om goed te keuren op %2$s...',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y' => 'Er is een nieuw(e) %1$s om goed te keuren op %2$s.',
        'YOU_HAVE_A_NEW_X_TITLE_TO_APPROVE_ON_Y' => 'Er is een nieuw(e) %1$s "%2$s" om goed te keuren op %3$s.',
        'TO_APPROVE_THIS_X_VISIT' => 'Je kunt deze %s goedkeuren via:',
        'YOUR_X_ON_Y_HAS_BEEN_APPROVED_ELLIPSIS' => 'Je %1$s op %2$s is goedgekeurd...',
        'YOUR_TYPE_ON_X_HAS_A_NEW_COMMENT_ELLIPSIS' => 'Er is een nieuwe reactie op je %1$s op %2$s...',
        'CLICK_HERE_TO_JOIN' => 'Klik hier om deel te nemen:',
        'X_WANTS_YOU_TO_CHECK_OUT_Y_ON_Z' => '%1$s vraagt je om "%2$s" te bekijken op %3$s!',
        'YOUR_X_HAS_BEEN_APPROVED_ON_Y' => 'Je %s is goedgekeurd op %s.',
        'YOUR_X_Y_HAS_BEEN_APPROVED_ON_Z' => 'Je %1$s "%2$s" op %3$s is goedgekeurd.',
        'TO_VIEW_YOUR_X_VISIT' => 'Je kunt je %s bekijken via:',
        'TO_VIEW_THIS_X_VISIT' => 'Je kunt deze %s bekijken op:',
        'TO_VIEW_IT_VISIT' => 'Je kunt dit bekijken via:',
        'X_REPORTED_THE_FOLLOWING_ISSUE_ON_Y_ELLIPSIS' => '%1$s heeft het volgende probleem gemeld op %2$s...',
        'USER_HAS_SENT_YOU_A_MESSAGE_ON_X' => '%1$s heeft je een bericht gestuurd op %2$s.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X' => '%1$s heeft gevraagd om deel te mogen nemen aan %2$s op %3$s.',
        'TO_APPROVE_OR_DENY_USER_REQUEST' => 'Je kunt het verzoek van %s goedkeuren of afwijzen via:',
        'X_ADDED_A_COMMENT_TO_THE_BLOG_POST_Y_ON_Z' => '%1$s heeft een reactie toegevoegd aan blog-bericht "%2$s" op %3$s.',
        'X_ADDED_A_COMMENT_TO_A_BLOG_POST_ON_Y_ELLIPSIS' => '%1$s heeft een reactie toegevoegd aan een blog-bericht op %2$s...',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X' => 'Er is een nieuw lid om goed te keuren op %s.',
        'WELCOME_TO_THE_GROUP_X_ON_Y' => 'Welkom bij groep "%1$s" op %2$s',
        'LOADING_YOUR_FRIENDS' => 'Je vrienden worden opgezocht...',
        'YOUR_MESSAGE_HAS_BEEN_SENT_TITLE_CASE' => 'Je bericht is verzonden',
        'TO_SEND_ANOTHER_MESSAGE' => 'Wil je nog een bericht sturen, voer dan hieronder je tekst in.',
        'PLEASE_CHOOSE_FRIENDS' => 'Selecteer enkele vrienden voordat je je bericht verstuurt.',
        'THESE_FRIENDS' => 'Deze vrienden:',
        'ALL_FRIENDS' => 'Alle vrienden',
        'ALL_FRIENDS_ON_APPNAME' => 'Alle vrienden op %s',
        'SHARE_WITH_FRIENDS' => 'Delen met vrienden',
        'SHARE_THIS_WITH_FRIENDS' => 'Deel dit met je vrienden',
        'COMPOSE_MESSAGE' => 'Bericht opstellen',
        'INVITATION_LINK_ONLY_VISIBLE' => 'Deze uitnodigingskoppeling is alleen zichtbaar voor degene die het netwerk is begonnen en voor beheerders. Leden die zich met deze koppeling aanmelden worden automatisch vriend van degene die het netwerk heeft aangemaakt.',
        'WE_ARE_LOADING_ADDRESSES' => 'Je adressen worden opgezocht...',
        'SELECT_ALL_NONE' => 'Alles/niets selecteren',
        'INVITE_TO_APPNAME' => 'Uitnodigen voor \'%s\'',
        'INVITE_YOUR_FRIENDS_TO_APPNAME' => 'Nodig je vrienden uit voor \'%s\'',
        'ALREADY_MEMBER_OF_NETWORK' => '(Al lid van dit netwerk)',
        'OR_SHARE_THIS_INVITATION_LINK' => 'Of deel deze uitnodigingskoppeling:',
        'CLICK_TO_MAIL' => '<a %s>Klik hier om nu te versturen</a>.',
        'MESSAGE_HAS_BEEN_SENT' => 'Je bericht is verzonden',
        'YOU_CAN_SHARE_THIS' => 'Je kunt hieronder met meer mensen delen, of <a %s>teruggaan naar de vorige pagina</a>.',
        'VCARD_IMPORT_UNAVAILABLE' => 'Helaas is het importeren van vCards op dit moment niet mogelijk.',
        'CSV_IMPORT_UNAVAILABLE' => 'Helaas is het importeren van CSV\'s op dit moment niet mogelijk.',
        'ERROR_OCCURRED' => 'Er is een fout opgetreden.',
        'IMPORT_FAILED' => 'Het importeren is mislukt.',
        'LOGIN_FAILED' => 'Het aanmelden is mislukt.',
        'UNABLE_TO_FIND_EMAIL' => 'Helaas we kunnen we het e-mailveld niet vinden.',
        'CANNOT_READ_VCARDS' => 'Het lezen van deze vCards is niet mogelijk.',
        'NO_ADDRESSES_FOUND' => 'Geen adressen gevonden',
        'WE_DID_NOT_FIND_ADDRESSES' => 'Er zijn geen adressen gevonden in het geïmporteerde adresboek.',
        'IMPORT_FROM_WEB_ADDRESS_BOOK' => 'Importeren uit webadresboek',
        'IMPORT_FROM_ADDRESS_BOOK_APPLICATION' => 'Importeren uit adresboektoepassing',
        'PRIVACY_POLICY' => 'Privacybeleid',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK_ON_Y' => '%1$s heeft de volgende reactie gegeven op %2$s:',
        'CHECK_OUT_X_ON_Y_ELLIPSIS' => 'Ga \'s kijken naar "%1$s" op %2$s...',
        'CHECK_OUT_THIS_X_ON_Y_ELLIPSIS' => 'Ga \'s kijken naar deze %1$s op %2$s...',
        'SEND_MESSAGE_TO_FRIENDS' => 'Bericht sturen aan vrienden',
        'PICK_VALID_ALL_FRIENDS_NOTIFICATION' => 'Maak een geldige keuze voor de melding van berichten aan alle vrienden',
        'WELCOME_MEMBER_N_OF_APPNAME_INVITE' => 'Welkom, %1$s! Je bent lid nummer #%2$s van %3$s. <a %4$s>Nodig nu vrienden uit</a>.',
        'YOU_COMMENTED_ON_PHOTO_TITLE' => 'Je hebt commentaar geleverd op de foto <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_PHOTO_TITLE' => '%s heeft commentaar geleverd op de foto <a %s>%s</a>',
        'YOU_COMMENTED_ON_VIDEO_TITLE' => 'Je hebt commentaar geleverd op de video <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_VIDEO_TITLE' => '%s heeft commentaar geleverd op de video <a %s>%s</a>',
        'THIS_IS_YOUR_PAGE' => 'Dit is jouw pagina:',
        'MESSAGES_SENT_TO_ALL_FRIENDS' => 'Berichten verzonden aan alle vrienden',
        'TO_STOP_FOLLOWING_THIS_X_GO_TO' => 'Als je deze %s niet meer wilt volgen, ga dan naar:',
        'CHOOSE_GADGETS' => 'Kies een van deze fraaie OpenSocial-gadgets om aan je profielpagina toe te voegen! Je kunt <a %s>hier gadgets  bekijken en waarderen</a>, of je kunt <a %s>hier meer over OpenSocial te weten komen</a>.',
        'GADGETS_UNAVAILABLE' => 'Gadgetstijdelijk niet beschikbaar',
        'APOLOGIES_GADGETS_UNAVAILABLE' => 'De gadgetszijn tijdelijk niet beschikbaar.',
        'BOX_WILL_NOT_SHOW_GADGET' => 'Dit vak is niet zichtbaar voor anderen tenzij je een gadget selecteert.',
        'CLICK_EDIT_TO_SPECIFY_GADGET_OR_VISIT_GADGET_GALLERY' => 'Klik op Bewerken om de URL van het gadget voor dit vak op te geven bij <a %s>gadgets-overzicht</a>',
        'PROBLEM_OCCURRED_RETRIEVING_GADGET' => 'Er is iets misgegaan bij het ophalen van de URL-feed van dit gadget.',
        'ADD_GADGET_TO_YOUR_PAGE' => 'Dit gadgettoe aan je profiel toevoegen',
        'GADGETS_BETA' => 'Gadgets(bèta)',
        'TRY_OUT_OPENSOCIAL_GADGETS_WARNING_EXPERIMENTAL' => 'Probeer de gadgetsvan OpenSocial eens.  Waarschuwing: deze functie is experimenteel.',
        'ADD_TO_MY_PAGE' => 'Toevoegen aan mijn pagina',
        'GADGETS' => 'Gadgets',
        'GADGETS_TAB_TEXT' => 'Gadgets',
        'GADGET' => 'Gadget',
        'GADGETS_IS_IN_BETA' => 'Gadgets zijn nog in het bètastadiom.',
        'SORRY_GADGET_UNAVAILABLE' => 'Onze excuses, dit gadget is niet beschikbaar. Controleer of je de juiste URL hebt. Als het probleem blijft bestaan, <a %s>laat ons dat dan weten</a>.',
        'ALREADY_MEMBER_OF_GROUP' => '(Al lid van deze groep)',
        'INVITE_YOUR_FRIENDS_TO_GROUPNAME' => 'Nodig je vrienden uit voor \'%s\'',
        'INVITE_TO_GROUP' => 'Uitnodigen voor \'%s\'',

        'EACH_VIDEO_MAY_BE_100MB' => 'Een video mag 100 MB groot zijn. De ondersteunde videoformatien zijn mov, .mp4, mpg, .avi, .wmv en .3gp. ',
        'I_HAVE_RIGHT_TO_UPLOAD_VIDEO' => 'Ik heb het recht om deze video te uploaden volgens de <a %s>Gebruiksvoorwaarden</a> ',
        'VIDEO_UPLOADER_REQUIRES_JAVA' => 'Voor de massa-uploader voor video\'s is een recente versie van Java nodig. <strong><a %s>Klik hier om Java te verkrijgen</a></strong> of <strong><a %s>ga terug naar de eenvoudige uploader</a></strong>. ',
        'UPLOAD_A_VIDEO_FROM_YOUR_COMPUTER' => 'Een video uploaden vanaf je computer ',
        'HAVE_LOT_OF_VIDEOS' => 'Heb je veel video\'s die je wilt delen? ',
        'TRY_BULK_VIDEO_UPLOADER' => 'Probeer de massa-uploader voor video\'s ',
        'VIDEOS_SUCCESSFULLY_UPLOADED' => 'Je video\'s zijn correct geüpload. ',
        'VIDEOS_UPLOADED_AWAITING' => 'Je video\'s zijn correct geüpload en moeten nu nog goedgekeurd worden door de auteur van %s. ',
        'ADD_VIDEOS_OR_PHOTOS_TO_APPNAME' => 'Voeg video\'s en foto\'s rechtstreeks vanaf je telefoon toe aan %s door ze naar een uniek e-mailadres te sturen. ',
        'GRAB_HTML_EMBED' => 'Pak de HTML-\'insluitcode\' ("embedded" code) vanaf een willekeurige populaire videosite en voeg die video toe aan dit netwerk. ',
        'GOOGLE' => 'Google ',
        'YOUTUBE' => 'YouTube ',
        'HAVING_PROBLEMS_WITH_VIDEO_UPLOADER' => 'Problemen met de massa-uploader voor video\'s?  <strong><a %s>Ga terug naar onze eenvoudige uploader</a></strong>. ',
        'ADD_VIDEOS_FROM_YOUTUBE' => 'Video\'s toevoegen vanaf YouTube of Google ',
        'TAGS_NO_COLON' => 'Tags ',
        'NO_VIDEOS_TAGGED_X_CHECK' => 'Er zijn geen video\'s met de tag "%1$s". Bekijk <a %2$s>discussies met de tag "%1$s"</a>, <a %4$s>blog-berichten met de tag "%1$s"</a> of <a %3$s>foto\'s met de tag "%1$s"</a>. Of voeg je eigen video\'s toe en geef ze tags! ',
        'UPLOAD_VIDEOS_FROM' => 'Video\'s uploaden vanaf je computer ',
        'ADD_VIDEOS_BY_PHONE_OR' => 'Voeg video\'s toe via telefoon of e-mail ',
        //music player
        'FEATURING_ELLIPSIS' => 'Opvallende...',
        'OPEN_POPUP_WINDOW' => 'Open pop-upvenster',
        'NOW_FEATURED_ON_MAIN' => 'Nu in de kijker op de hoofdpagina ',
        'DONT_FEATURE' => 'Niet in de kijker zetten ',
        'UNFEATURING_ELLIPSIS' => 'Wordt van hoofdpagina verwijderd... ',
        'REMOVED_FROM_MAIN' => 'Verwijderd van hoofdpagina ',
        'ADDED_EXCLAMATION' => 'Toegevoegd! ',
        'ERROR' => 'Fout ',
        'ADDING_ELLIPSIS' => 'Bezig met toevoegen... ',
        'TRACK_COULD_NOT_BE_LOADED' => 'Liedje kon niet worden geladen ',
        'INVALID_URL' => 'Ongeldige URL ',
        'NORMAL_PLAYBACK_ON' => 'Normaal afspelen: Aan ',
        'REPEAT_PLAYBACK_ON' => 'Herhaald afspelen: Aan ',
        'SHUFFLE_PLAYBACK_ON' => 'Willekeurig afspelen: Aan ',
        'LOADING_PLAYLIST_ELLIPSIS' => 'Afspeellijst wordt geladen... ',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Je ledengegevens zijn geëxporteerd.  Klik op <a %s>deze koppeling</a> om ze op te slaan naar je bureaublad. ',
        'SET_NEW_PASSWORD' => 'Stel een nieuw wachtwoord in voor je account. ',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Klik op  \'Bewerken\' om tekst, HTML, video\'s, foto\'s of <a %1$s>widgets van anderen</a> toe te voegen aan dit vak. ',
        'EACH_PHOTO_MAY_BE_UP_TO_10MB' => 'Een foto mag 10 MB groot zijn. Ondersteunde bestandsformaten voor foto’s zijn .jpg, .gif en .png. ',
        'I_HAVE_RIGHT_TO_UPLOAD_PHOTOS' => 'Ik heb het recht om deze foto\'s te uploaden volgens de <a %s>Gebruiksvoorwaarden</a> ',
        'PHOTO_UPLOADER_REQUIRES_JAVA' => 'Voor de massa-uploader voor foto\'s is een recente versie van Java nodig. <strong><a %s>Klik hier om Java te verkrijgen</a></strong> of <strong><a %s>ga terug naar de eenvoudige uploader</a></strong>. ',
        'TRY_BULK_PHOTO_UPLOADER' => 'Probeer de massa-uploader voor foto\'s ',
        'HAVE_LOT_OF_PHOTOS' => 'Heb je veel foto\'s die je wilt delen? ',
        'PHOTOS_SUCCESSFULLY_UPLOADED' => 'Je foto\'s zijn correct geüpload. ',
        'PHOTOS_UPLOADED_AWAITING' => 'Je foto\'s zijn correct geüpload en moeten nu nog goedgekeurd worden door de auteur van %s. ',
        'FLICKR' => 'Flickr ',
        'ADD_PHOTOS_FROM_FLICKR' => 'Foto\'s van Flickr toevoegen ',
        'ADD_PHOTOS_OR_VIDEOS_TO_APPNAME' => 'Voeg foto\'s en video\'s rechtstreeks vanaf je telefoon toe aan %s door ze te sturen naar een uniek e-mailadres. ',
        'HAVING_PROBLEMS_WITH_PHOTO_UPLOADER' => 'Problemen met de massa-uploader voor foto\'s?  <strong><a %s>Ga terug naar onze eenvoudige uploader</a></strong>. ',
        'VIEW_SLIDESHOW' => 'Diavoorstelling weergeven ',
        'NO_PHOTOS_TAGGED_X_CHECK' => 'Er zijn geen foto\'s met de tag "%1$s". Bekijk <a %2$s>discussies met de tag "%1$s"</a>, <a %4$s>blog-berichten met de tag "%1$s"</a> of <a %3$s>video\'s met de tag "%1$s"</a>. Of voeg je eigen foto\'s toe en geef ze tags! ',
        'PHOTO_MAY_BE_10MB' => 'Een foto mag 10 MB groot zijn, maar hoe kleiner de foto, hoe sneller de upload. Ondersteunde fotoformaten zijn .jpg, .gif en .png. ',
        'UPLOAD_PHOTOS_FROM_YOUR_COMPUTER' => 'Foto\'s uploaden vanaf je computer ',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Klik op  \'Bewerken\' om tekst, HTML, video\'s, foto\'s of <a %1$s>widgets van anderen</a> toe te voegen aan dit vak. ',
        'PLEASE_SELECT_A_MEMBER' => 'Selecteer een of meer leden ',
        'RESEND_INVITATION' => 'Uitnodiging opnieuw verzenden ',
        'CHOOSE_FRIENDS' => 'Kies vrienden... ',
        'SORRY_WE_DO_NOT_SUPPORT' => 'Sorry, maar we bieden geen ondersteuning voor het webadresboek voor jouw e-mailadres. Klik op \'Importeren uit adresboektoepassing\' hieronder als je wilt proberen adressen vanaf je computer te gebruiken. ',
        'WANT_TO_INVITE_MORE_FRIENDS' => 'Wil je meer vrienden uitnodigen? Nodig meer vrienden uit door contactpersonen uit je webadresboek of e-mailtoepassing te importeren. ',
        'MICROSOFT_OUTLOOK_APPLE_ADDRESS_BOOK' => 'Microsoft Outlook, Apple Mail, .CSV, enz. ',
        'SET_NEW_PASSWORD' => 'Stel een nieuw wachtwoord in voor je account. ',
        'APPLY_FOR_MEMBERSHIP_SIGN_IN' => ' Vraag nu lidmaatschap aan. Al lid? <a %s>Klik hier om je aan te melden</a>. ',
        'FEATURED_MEMBERS' => 'Leden in de kijker ',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Je ledengegevens zijn geëxporteerd.  Klik op <a %s>deze koppeling</a> om ze op te slaan naar je bureaublad. ',
        'SORRY_NO_MEMBERS_MATCHING_X_WERE_FOUND' => 'Sorry, maar er zijn geen leden gevonden die passen bij "%s". ',
        'WHO_CAN_COMMENT_ON_POST' => 'Wie kan reageren op dit bericht? ',
        'PREVIOUS_POST' => '←  Vorig bericht ',
        'NEXT_POST' => 'Volgend bericht →',
        'PREVIOUS_POSTS' => '←  Vorige berichten ',
        'NEXT_POSTS' => 'Volgende berichten ← ',
        'NO_BLOG_POSTS_TAGGED_X_CHECK' => 'Er zijn geen blog-berichten met de tag "%1$s". Bekijk <a %2$s>discussies met de tag "%1$s"</a>, <a %4$s>foto\'s met de tag "%1$s"</a> of <a %3$s>video\'s met de tag "%1$s"</a>. Of voeg je eigen blogberichten toe en geef ze tags! ',
        'ALL_POSTS_TAGGED_X_FOR_M_Y' => 'Alle berichten met de tag <em>\'%s\'</em> voor %s %s ',
        'ALL_POSTS_TAGGED_X' => 'Alle berichten met de tag <em>\'%s\'</em> ',
        'MY_BLOG_POSTS_FOR_M_Y' => 'Mijn blog-berichten voor %s %s ',
        'MY_BLOG_POSTS' => 'Mijn blog-berichten ',
        'PRIVACY_CONTENT_CONTROL' => 'Privacy en beveiliging voor inhoud ',
        'MODERATION' => 'Beveiliging voor inhoud ',
        'ENABLE_MUSIC_DOWNLOAD_LINKS' => 'Download-koppelingen voor muziekspeler inschakelen ',
        'NOTIFY_BLOG_PING_SERVICES'  => 'Wil je andere volgdiensten voor blog-berichten waarschuwen wanneer je een nieuw bericht toevoegt? ',
        'YES_NOTIFY_BLOG_SERVICES' => 'Ja – Waarschuw <a %s>volgservices voor sites</a> wanneer ik een nieuw blog-bericht plaats ',
        'THERE_ARE_NO_FEATURED_MEMBERS' => 'Er staan geen leden in de kijker op je netwerk. ',
        'START_FEATURING_MEMBERS_CLICK_Y' => 'Je kunt leden in de kijker zetten wanneer je de optie In de kijker ziet. <a $s>Klik hier</a> voor meer informatie over in de kijker zetten. ',
        'SHOW_ALL' => 'Alles weergeven ',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_ADD' => 'Er zijn geen discussies met de tag "%1$s". Bekijk <a %2$s>foto\'s met de tag "%1$s"</a>, <a %4$s>blog-berichten met de tag "%1$s"</a> of <a %3$s>video\'s met de tag "%1$s"</a>. Of voeg je eigen discussies toe en geef ze tags! ',
        'NO_DISCUSSIONS_TAGGED_X_CHECK' => 'Er zijn geen discussies met de tag "%1$s". Bekijk <a %2$s>foto\'s met de tag "%1$s"</a>, <a %4$s>blog-berichten met de tag "%1$s"</a> of <a %3$s>video\'s met de tag "%1$s"</a>. ',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => 'Je hebt de groep %1$s gecreëerd. Je kunt een discussie starten in het forum %1$s of anderen uitnodigen om lid te worden. ',
        'YOU_CAN_ADD_100_SONGS' => 'Je kunt maximaal 100 liedjes toevoegen van maximaal 20 MB per stuk. Wij ondersteunen liedjes in .mp3-indeling. ',
        'I_HAVE_RIGHT_TO_UPLOAD_SONGS' => 'Ik heb het recht om deze liedjes te uploaden volgens de <a %s>Gebruiksvoorwaarden</a> ',
        'MUSIC_UPLOADER_REQUIRES_JAVA' => 'Voor de massa-uploader voor muziek is een recente versie van Java nodig. <strong><a %s>Klik hier om Java te verkrijgen</a></strong> of <strong><a %s>ga terug naar de eenvoudige uploader</a></strong>. ',
        'HAVE_LOT_OF_MUSIC' => 'Heb je veel muziek die je wilt delen? ',
        'TRY_BULK_MUSIC_UPLOADER' => 'Probeer de massa-uploader voor muziek ',
        'SONGS_SUCCESSFULLY_UPLOADED' => 'Je liedjes zijn correct geüpload. ',
        'SORRY_YOU_CAN_ONLY_HAVE_N_TRACKS' => 'Sorry, je kunt hoogstens %s liedjes in je afspeellijst opnemen. Verwijder enkele liedjes voordat je nieuwe toevoegt. ',
        'ADD_MUSIC_FROM_WEBSITE' => 'Muziek van een andere webpagina toevoegen ',
        'HAVING_PROBLEMS_WITH_MUSIC_UPLOADER' => 'Problemen met deze muziek-uploader?  <strong><a %s>Ga terug naar onze eenvoudige uploader</a></strong>. ',
        'UPLOAD_MUSIC_FROM_YOUR_COMPUTER' => 'Muziek uploaden vanaf je computer ',
        'ADD_MUSIC' => 'Audio toevoegen ',
        'FACEBOOK_INSTR_SETUP_APP_PERMISSION' 	=> 'Selecteer <strong>Gebruikers</strong> en <strong>Alle pagina\'s</strong>. ',

    );

    /**
     * If the given widget title is the default English title for the widget,
     * translate it into the current language.
     *
     * @param $widgetTitle string  The title of the widget
     * @return string  A translated title if the title is the English default; otherwise, the title unchanged
     */
    public static function translateDefaultWidgetTitle($widgetTitle) {

        return $widgetTitle;
    }

}