<?php

XG_App::includeFileOnce('/lib/XG_AbstractMessageCatalog.php');

/**
 * Texts for the ko_KR locale.
 */

class XG_MessageCatalog_ko_KR extends XG_AbstractMessageCatalog  {

    /**
     * Returns a localized version of a string. The first argument is the message name, e.g., 'ADD_A_PHOTO'.
     * Subsequent arguments are substitution values (if the message contains sprintf format elements).
     *
     * @param array $args the message name, plus optional substitution values
     * @return string the localized string
     * @see xg_html()
     */
    public static function text($args) {
        $s = $args[0];
        static $a = array();
        if (! $a) {
            $a['N_SECONDS_AGO']['1'] = '1초 전 ';
            $a['N_SECONDS_AGO']['n'] = '%s초 전 ';
            $a['N_MINUTES_AGO']['1'] = '1분 전 ';
            $a['N_MINUTES_AGO']['n'] = '%s분 전 ';
            $a['N_HOURS_AGO']['1'] = '1시간 전 ';
            $a['N_HOURS_AGO']['n'] = '%s시간 전 ';
            $a['N_VIDEOS']['1'] = '<strong>1</strong> 동영상 ';
            $a['N_VIDEOS']['n'] = '<strong>%s</strong> 동영상 ';
            $a['N_VIEWS']['1'] = '조회 수: 1 ';
            $a['N_VIEWS']['n'] = '조회 수: %s ';
            $a['N_COMMENTS']['1'] = '<span class="comment-count">1</span> 코멘트 ';
            $a['N_COMMENTS']['n'] = '<span class="comment-count">%s</span> 코멘트 ';
            $a['VIDEO_IS_FAVORITE_OF']['1'] = '이 동영상은 <strong>1명</strong>이 자신의 <strong>즐겨찾기</strong> 동영상으로 지정하였습니다.. ';
            $a['VIDEO_IS_FAVORITE_OF']['n'] = '이 동영상은 <strong>%s명</strong>이<strong> 자신의 즐겨찾기</strong> 동영상으로 지정하였습니다. ';
            $a['Y_ADDED_X_VIDEOS']['1'] = '%2$s님이 동영상을 1 건 추가했습니다: ';
            $a['Y_ADDED_X_VIDEOS']['n'] = '%2$s님이 동영상 %s건을 추가했습니다. ';
            $a['YOU_ADDED_X_VIDEOS']['1'] = '회원님이 동영상을 1 건 추가했습니다: ';
            $a['YOU_ADDED_X_VIDEOS']['n'] = '회원님이 %s건의 동영상을 추가했습니다. ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['1'] = '%2$s에 동영상이 1건 있습니다 ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['n'] = '%2$s에 동영상이 %1$s건 있습니다 ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['1'] = '%2$s에 1건의 <a href="%3$s">동영상</a>이 있습니다 ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['n'] = '%2$s에 %1$s건의 <a href="%3$s">동영상video</a>이 있습니다 ';
            $a['N_PHOTOS_FROM_ALBUM']['1'] = '사진 한 장이 이 앨범에서 삭제되었거나 비공개로 지정되었기 때문에 그 사진은 보여 드릴 수 없습니다. ';
            $a['N_PHOTOS_FROM_ALBUM']['n'] = '사진 %s 장이 이 앨범에서 삭제되었거나 비공개로 지정되었기 때문에 그 사진들은 보여 드릴 수 없습니다. ';
            $a['N_PHOTOS']['1'] = '사진 <strong>1</strong> 장 ';
            $a['N_PHOTOS']['n'] = '사진 <strong>%s</strong> 장 ';
            $a['N_PHOTOS_2']['1'] = '사진 1 장 ';
            $a['N_PHOTOS_2']['n'] = '사진 %s 장 ';
            $a['PROBLEM_UPLOADING_FILES']['1'] = '다음 파일을 업로드하는 데 문제가 발생했습니다: ';
            $a['PROBLEM_UPLOADING_FILES']['n'] = '다음 파일들을 업로드하는 데 문제가 발생했습니다: ';
            $a['PHOTO_IS_FAVORITE_OF']['1'] = '이 사진은 <strong>1 명</strong>이 자신의 <strong>즐겨찾기</strong> 사진으로 지정하였습니다. ';
            $a['PHOTO_IS_FAVORITE_OF']['n'] = '이 사진은 <strong>%s 명</strong>이 자신의 <strong>즐겨찾기</strong> 사진으로  지정하였습니다. ';
            $a['RATING_Y_AFTER_X_VOTES']['1'] = '<strong>추천도:</strong> %2$s – 1명이 평가 ';
            $a['RATING_Y_AFTER_X_VOTES']['n'] = '<strong>추천도: </strong> %2$s - %명이 평가 ';
            $a['Y_AFTER_X_VOTES']['1'] = '%2$s - 1명이 평가 ';
            $a['Y_AFTER_X_VOTES']['n'] = '%2$s - %s명이 평가 ';
            $a['N_PEOPLE']['1'] = '1명 ';
            $a['N_PEOPLE']['n'] = '%s명 ';
            $a['N_OF_5_STARS']['1'] = '별점 5점 중 1 점 ';
            $a['N_OF_5_STARS']['n'] = '별점 5 점 중 %s점 ';
            $a['YOUR_RATING_X_STARS']['1'] = '회원님의 추천도: 별점 1점 ';
            $a['YOUR_RATING_X_STARS']['n'] = '회원님의 추천도: 별점 %s점 ';
            $a['Y_ADDED_X_PHOTOS']['1'] = '%2$s님이 사진 한 장을 추가했습니다: ';
            $a['Y_ADDED_X_PHOTOS']['n'] = '%2$s님이 사진 %s 장을 추가했습니다. ';
            $a['YOU_ADDED_X_PHOTOS']['1'] = '회원님이 사진을 한 장 추가했습니다: ';
            $a['YOU_ADDED_X_PHOTOS']['n'] = '회원님이 사진을 %s장 추가했습니다. ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['1'] = '%2$s에 사진이 1건 있습니다 ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['n'] = '%2$s에 사진이 %1$s건 있습니다 ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['1'] = '%2$s에 %1$s건의 <a href="%3$s">사진</a>이 있습니다 ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['n'] = '%2$s에 %1$s건의 <a href="%3$s">사진</a>이 있습니다 ';
			$a['N_INVITATIONS_RESENT']['1'] = '초대장 1장을 재전송하였습니다. ';
            $a['N_INVITATIONS_RESENT']['n'] = '초대장 %s장을 재전송하였습니다. ';
            $a['AND_X_OTHER_PEOPLE']['1'] = '외 1인 ';
            $a['AND_X_OTHER_PEOPLE']['n'] = '외 %s 인 ';
            $a['N_COMMENTS_ON_PAGE']['1'] = '프로파일 코멘트: <strong>1</strong> ';
            $a['N_COMMENTS_ON_PAGE']['n'] = '프로파일 코멘트: <strong>%s</strong> ';
            $a['N_BLOG_COMMENTS']['1'] = '블로그 코멘트 <strong>1</strong>건 ';
            $a['N_BLOG_COMMENTS']['n'] = '블로그 코멘트 <strong>%s</strong>건 ';
            $a['N_YEARS_OLD']['1'] = '1년 ';
            $a['N_YEARS_OLD']['n'] = '%s년 ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['1'] = '친구 만들기 요청이 1건 있습니다! ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['n'] = '친구 만들기 요청이 %s건 있습니다! ';
            $a['COMMENT_WALL_N_COMMENTS']['1'] = 'Comment Wall (글 수: 1) ';
            $a['COMMENT_WALL_N_COMMENTS']['n'] = 'Comment Wall (글 % s건) ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['1'] = '지난 1주 간 신규 회원이 1명 가입했습니다 ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['n'] = '지난 1주 간 신규 회원이 %s명 가입했습니다 ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['1'] = '지난 1주 간 <a href="%2$s">신규 회원</a> 1명이 가입했습니다 ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['n'] = '지난 1주 간 <a href="%2$s">신규 회원</a> %1$s명이 가입했습니다 ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['1'] = '%2$s에 1명의 회원이 있습니다 ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['n'] = '%2$s에 %1$s명의 회원이 있습니다 ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['1'] = '%2$s에 1명의 <a href="%3$s">회원</a>이 있습니다 ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['n'] = '%2$s에 %1$s명의 <a href="%3$s">회원</a>이 있습니다 ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['1'] = '%2$s에 1건의 블로그 게시물이 있습니다 ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['n'] = '%2$s에 %1$s건의 게시물이 있습니다 ';
            $a['N_NEW_MEMBERS']['1'] = '신규 회원 <strong>1</strong>명 ';
            $a['N_NEW_MEMBERS']['n'] = '신규 회원 <strong>%s</strong>명 ';
            $a['N_REPLIES']['1'] = '답글 : 1 ';
            $a['N_REPLIES']['n'] = '답글: %s ';
            $a['N_MINUTES']['1'] = '1분 내로 글을 완료해 주세요. ';
            $a['N_MINUTES']['n'] = '%s분 내로 글을 완료해 주세요. ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['1'] = '1건의 포럼 주제가 %2$s에 게시되어 있습니다 ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['n'] = '%1$s건의 포럼 주제가 %2$s에 게시되어 있습니다 ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['1'] = '1건의 <a href="%3$s">포럼 주제</a>가 %2$s에 게시되어 있습니다 ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['n'] = '%1$s건의 <a href="%3$s">포럼 주제</a>가 %2$s에 게시되어 있습니다 ';
            $a['N_INVITES']['1'] = '초대 건수: %s ';
            $a['N_INVITES']['n'] = '초대 건수: %s ';
            $a['N_MEMBERS']['1'] = '회원 1명 ';
            $a['N_MEMBERS']['n'] = '회원 %s명 ';
            $a['N_MEMBERS_PARENTHESIZED']['1'] = '( 회원 1명) ';
            $a['N_MEMBERS_PARENTHESIZED']['n'] = '(회원 %s명) ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['1'] = '1개의 그룹이 %2$s에 참가 중입니다. ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['n'] = '%1$s개의 그룹이  %2$s에 참기 중입니다. ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['1'] = '%1$s개의 <a href="%3$s">그룹</a>이  %2$s에 참가 중입니다 ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['n'] = '%1$s개의 <a href="%3$s">그룹</a>이  %2$s에 참가 중입니다 ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['1'] = '이 플레이 리스트 중의 1곡은, 이미 삭제되었거나 더 이상 공유되지 않고 있는 이유로 보여 드릴 수 없습니다. ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['n'] = '이 플레이 리스트 중의 %s곡은 이미 삭제되었거나 더 이상 공유되지 않고 있는 이유로 보여 드릴 수 없습니다. ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['1'] = '%2$s에 새로운 노래 1곡이 추가됐습니다 ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['n'] = '%2$s 새로운 노래 %1$s곡이 추가됐습니다 ';
            $a['Y_ADDED_X_SONGS']['1'] = '%2$s님이 노래 1곡을 추가했습니다: ';
            $a['Y_ADDED_X_SONGS']['n'] = '%2$s님이 노래 %s 곡을 추가했습니다. ';
            $a['YOU_ADDED_X_SONGS']['1'] = '회원님이 노래 한 곡을 추가했습니다: ';
            $a['YOU_ADDED_X_SONGS']['n'] = '회원님이 노래 %s곡을 추가했습니다. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['1'] = '이 플레이 리스트에 노래 1곡이 추가됐습니다. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['n'] = '이 플레이 리스트에 노래 %s 곡이 추가됐습니다. ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['1'] = '%2$s에 1곡의 노래가 있습니다 ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['n'] = '%2$s에 %1$s곡의 노래가 있습니다 ';
        }
        if ($a[$args[0]]) {
            $args[0] = $a[$args[0]][$args[1]] ? $a[$args[0]][$args[1]] : $a[$args[0]]['n'];
            return @call_user_func_array('sprintf', $args);
        }
        $text = self::$messages[$s];
        if ($text) { $args[0] = $text; }
        return @call_user_func_array('sprintf', $args);
    }

    /**
     * Message names and texts. Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;
     */
    private static $messages = array(
        'BROWSING' => '둘러보기',
        'MORE_VIDEOS' => '추가 동영상',
        'NETWORK_DOES_NOT_HAVE_VIDEOS' => '이 네트워크에는 아직 동영상이 없습니다.',
        'NETWORK_DOES_NOT_HAVE_FEATURED_VIDEOS' => '이 네트워크에는 아직 추천 동영상이 없습니다.',
        'PERSON_DOES_NOT_HAVE_VIDEOS' => '이 회원님은 아직 동영상을 올리지 않았습니다.',
        'COPY_TO_CLIPBOARD' => '클립보드에 복사하기',
        'COPIED_TO_CLIPBOARD' => '클립보드에 복사됐습니다!',
        'NO_VIDEOS_TO_DISPLAY' => '회원님은 현재 동영상을 게시하지 않고 있습니다.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_VIDEO' => '회원님이 최소한 1 건의 동영상를 선택할 때까지 다른 사람들은 이 박스를 볼 수 없습니다.',
        'WATERMARK_LOGO' => '워터마크 로고',
        'CHOOSE_HEADER_OR_WATERMARK' => '회원님의 동영상 플레이어에 머릿글 로고 또는 워터마크 로고를 선택할 수 있습니다.',
        'CUSTOMIZE_EMBED_INSTRUCTIONS' => '로고는 회원님의 %s 상단에 표시됩니다.  회원님이 로고를 추가하지 않을 경우, 네트워크 이름이 대신 표시됩니다.  회원님의 로고는 . jpg, . gif 또는 . png 형식의 파일이어야 합니다.  세로 20 픽셀을 초과하면 크기가 자동으로 축소 조정됩니다.',
        'CUSTOMIZE_WATERMARK_INSTRUCTIONS' => '워터마크 로고는 동영상 클립의 우측 하단 코너에 나타납니다.',
        'HEADER_LOGO' => '헤더 로고',
        'WATERMARK' => '워터마크',
        'CUSTOMIZE_YOUR_VIDEO_PLAYER' => '맞춤형 동영상 플레이어를 설정하세요!',
        'VIDEO_PLAYER' => '동영상 플레이어',
        'HEADER' => '헤더',
        'SAVE_CHANGES' => '변경사항 저장',
        'THUMBNAIL' => '미리보기',
        'CONVERSION_FAILED' => '변환 중 오류가 발생했습니다',
        'CONVERSION_IN_PROGRESS' => '변환 중입니다',
        'MAP' => '지도',
        'WHAT_IS_THIS' => '이건 뭐죠?',
        'EDIT_VIDEO_INFORMATION' => '동영상 정보 편집',
        'ALL_VIDEOS' => '전체 동영상',
        'VIDEOS_HOME' => '동영상 홈',
        'MY_VIDEOS' => '내 비디오',
        'MY_FRIENDS_VIDEOS' => '내 친구의 동영상',
        'MY_FAVORITES' => '나의 즐겨찾기',
        'XS_FAVORITES' => '%s님의 즐겨찾기',
        'ADD_A_VIDEO' => '동영상 추가',
        'JUST_NOW' => '조금 전에',
        '1_DAY_AGO' => '1일 전',
        'M_J' => 'M j',
        'ME' => '나',
        'X_SAID' => '%s 님의 글...',
        'DELETE_COMMENT' => '글 삭제',
        'YOU_HAVE_NOT_ADDED_VIDEOS' => '회원님은 아직 동영상을 추가하지 않았습니다!',
        'ADD_VIDEOS_AND_SHARE' => '동영상을 추가해 회원님의 친구, 가족 및 전 세계의 누구나와 함께 공유하세요!',
        'THERE_ARE_NO_VIDEOS' => '현재 회원님의 사교 네트워크에는 동영상이 없습니다.',
        'THIS_BOX_WILL_NOT_SHOW' => '게시할 동영상이 있을 때까지 다른 사람들은 이 박스를 볼 수 없습니다.  동영상 하나 추가해 보시겠어요?',
        'ADD_VIDEOS' => '동영상 추가',
        'VIEW_VIDEOS' => '동영상 보기',
        'YIKES' => '저런!',
        'A_PROBLEM_SEEMS' => '문제가 발생한 것 같습니다.',
        'FOR_FURTHER_ASSISTANCE' => '도움이 필요하시면 <a %s>저희에게 연락주세요</a>.',
        'OR_YOU_CAN_GO' => '또는 <a %s>%s 메인 페이지</a>로 돌아가거나 <a %s>다른 Ning 사교 네트워크</a>를 둘러보세요',
        'TAGS' => '태그:',
        'POPULAR_TAGS' => '인기있는 태그',
        'MY_FRIENDS' => '나의 친구',
        'VIEW_ALL_MY_FRIENDS' => '나의 친구 모두 보기',
        'VIEW_ALL_XS_FRIENDS' => '%s 님의 친구 모두 보기',
        'WE_COULD_NOT_FIND_ANYONE_MATCHING' => '죄송합니다 – 회원님의 검색 조건에 맞는 사람을 찾지 못했습니다.',
        'VIEW_POPULAR_CONTRIBUTORS' => '인기 저자 보기',
        'POPULAR_CONTRIBUTORS' => '인기 저자',
        'VIEW_MORE_CONTRIBUTORS' => '추가 인기 저자 보기',
        'ADD_AS_FRIEND' => '친구로 추가',
        'SEND_A_MESSAGE' => '메시지 보내기',
        'IS_YOUR_FRIEND' => '회원님의 친구',
        'IS_BLOCKED' => '차단됨',
        'SORT_BY' => '정렬순:',
        'CLOSE' => '닫다',
        'EACH_VIDEO_MAY_BE_100MB' => '각 비디오(영상)는 최대 100MB까지 허용됩니다. mov, .mpg, .avi, .wmv 및 .3gp 파일 형식의 비디오를 지원합니다.',
        'I_HAVE_RIGHT_TO_UPLOAD_VIDEO' => '본인은 <a %s>이용약관</a>에 의거하여 이 비디오를 업로드할 권한을 보유하고 있습니다.',
        'VIDEO_UPLOADER_REQUIRES_JAVA' => '‘대량 비디오를 업로드’ 툴을 이용하시려면, 자바 최신 버전이 필요합니다. <strong><a %s>여기를 클릭해 자바 버전을 설치</a></strong>하거나 또는 <strong><a %s>일반 업로드 툴</a></strong>로 돌아가십시오.',
        'UPLOAD_A_VIDEO_FROM_YOUR_COMPUTER' => '회원님의 컴퓨터에서 비디오 업로드합니다',
        'HAVE_LOT_OF_VIDEOS' => '공유하고자 하는 비디오가 많으십니까?',
        'TRY_BULK_VIDEO_UPLOADER' => '‘대량 업로드 비디오 툴’을 이용해 보십시오',
        'VIDEOS_SUCCESSFULLY_UPLOADED' => '비디오가 성공적으로 업로드되었습니다.',
        'VIDEOS_UPLOADED_AWAITING' => '회원님의 비디오는 성공적으로 업로드되었으며 %s 운영자의 게시 승인을 받기 위해 대기 중입니다.',
        'ADD_VIDEOS_OR_PHOTOS_TO_APPNAME' => '회원님의 전화에서 특정 이메일 주소로 직접 비디오나 사진을 보내 %s에 추가하십시오.',
        'GRAB_HTML_EMBED' => '어떤 인기 비디오 사이트에서든 HTML \'임베드\' 코드를 가져와 해당 비디오를 이 네트워크에 추가하십시오.',
        'GOOGLE' => '구글',
        'YOUTUBE' => '유튜브',
        'HAVING_PROBLEMS_WITH_VIDEO_UPLOADER' => '‘대량 비디오 업로드 툴’을 이용하는 데 문제가 발생했습니까? <strong><a %s>일반 업로드 툴</a></strong>로 돌아가십시오.',
        'ADD_VIDEOS_FROM_YOUTUBE' => '유튜브나 구글에서 비디오 추가',
        'TAGS_NO_COLON' => '태그',
        'WE_SUPPORT_MOV' => 'Ning은 . mov, . mpg, . mp4, . avi, . 3gp와 . wmv 형식의 파일을 지원합니다.  파일의 용량은 100MB 이하이어야 합니다.',
        'NO_VIDEOS_TAGGED_X_CHECK' => '"%1$s"로 태그된 비디오가 없습니다.<a %2$s>"%1$s"로 태그된 논의주제</a>, <a %4$s>"%1$s"로 태그된 블로그 게시물</a>, 또는 <a %3$s>"%1$s"로 태그된 사진</a>을 확인하십시오. 또는 자신의 고유 비디오를 추가하거나 태그하십시오.',
        'UPLOAD_A_VIDEO_FROM' => '회원님의 컴퓨터에서 동영상 업로드:',
        'UPLOAD_VIDEOS_FROM' => '회원님의 컴퓨터에서 비디오 업로드합니다',
        'YOUR_VIDEO_UPLOAD_TO_X_DID_NOT_COMPLETE_DUE_TO_A_CONVERSION_ERROR' => '%s에 업로드한 회원님의 비디오가 변환오류로 인해 완료되지 않았습니다.',
        'FOR_FURTHER_ASSISTANCE_2' => '도움이 필요하시면 저희에게 다음으로 연락주세요:',
        'TO_HELP_TROUBLESHOOT_PROVIDE_THIS_VIDEO_ID_X' => '보다 신속한 문제 해결을 위해 이 동영상의 ID: %s를 알려주십시오',
        'YOUR_VIDEO_WAS_SUCCESSFULLY_UPLOADED_TO_X' => '회원님의 비디오가 성공적으로 %s에 업로드되었습니다.',
        'TO_VIEW_THE_VIDEO_VISIT' => '비디오를 보시려면, 다음을 방문하십시오:',
        'YOUR_VIDEO_X_ON_Y_HAS_A_NEW_COMMENT' => '%2$s에 올린 회원님의 "%1$s" 비디오에 새로운 답글이 올라와 있습니다',
        'YOUR_VIDEO_ON_X_HAS_A_NEW_COMMENT' => '%s에 있는 회원님의 비디오에 새로운 답글이 올라와 있습니다.',
        'ADD_VIDEOS_BY_PHONE_OR' => '전화나 이메일로 비디오 추가',
        'FEATURING_ELLIPSIS' => '추천…',
        'NOW_FEATURED_ON_MAIN' => '메인 페이지에 추천 중',
        'DONT_FEATURE' => '추천 취소',
        'UNFEATURING_ELLIPSIS' => '메인 페이지에서 제거 중…',
        'REMOVED_FROM_MAIN' => '메인 페이지에서 제거 완료',
        'ADDED_EXCLAMATION' => '추가 완료!',
        'ERROR' => '오류',
        'ADDING_ELLIPSIS' => '추가 중...',
        'TRACK_COULD_NOT_BE_LOADED' => '음악을 올리지 못 했습니다',
        'INVALID_URL' => '유효한 URL이 아닙니다',
        'NORMAL_PLAYBACK_ON' => '정상 재생: 켜짐',
        'REPEAT_PLAYBACK_ON' => '반복 재생: 켜짐',
        'SHUFFLE_PLAYBACK_ON' => '무작위(셔플) 재생: 켜짐',
        'OPEN_POPUP_WINDOW' => '팝업 창 사용',
        'LOADING_PLAYLIST_ELLIPSIS' => '음악목록 로딩 중…..',
        'EACH_PHOTO_MAY_BE_UP_TO_10MB' => '각 사진의 크기는 100MB까지 허용되지만 사진의 크기가 작을수록 업로드 시간이 빨라집니다. .jpg, .gif 와 .png 파일 형식의 사진을 지원합니다.',
        'I_HAVE_RIGHT_TO_UPLOAD_PHOTOS' => '본인은 <a %s>이용약관</a>에 의거해 이 사진을 업로드할 권한을 보유하고 있습니다.',
        'PHOTO_UPLOADER_REQUIRES_JAVA' => '‘대량 사진 업로드’ 툴을 이용하시려면, 자바 최신 버전이 필요합니다.  <strong><a %s>여기를 클릭해 자바를 설치</a></strong>하거나 또는 <strong><a %s>일반 업로드</a></strong>로 돌아가십시오.',
        'TRY_BULK_PHOTO_UPLOADER' => '‘대량 사진 업로드 툴’을 이용해 보십시오',
        'HAVE_LOT_OF_PHOTOS' => '공유하고자 하는 사진이 많으십니까?',
        'PHOTOS_SUCCESSFULLY_UPLOADED' => '비디오가 성공적으로 업로드되었습니다.',
        'PHOTOS_UPLOADED_AWAITING' => '회원님의 사진은 성공적으로 업로드되었으며 %s 운영자의 게시 승인을 받기 위해 대기 중입니다.',
        'FLICKR' => 'Flickr',
        'ADD_PHOTOS_FROM_FLICKR' => 'Flickr에서 사진 추가',
        'ADD_PHOTOS_OR_VIDEOS_TO_APPNAME' => '회원님의 전화에서 특정 이메일 주소로 직접 비디오나 사진을 보내 %s에 추가하십시오.',
        'HAVING_PROBLEMS_WITH_PHOTO_UPLOADER' => '‘대량 사진 업로드 툴’을 사용하는 데 문제가 있나요?  <strong><a %s>일반 업로드 툴</a></strong>로 돌아가십시오.',
        'VIEW_SLIDESHOW' => '슬라이드쇼 보기',
        'NO_PHOTOS_TAGGED_X_CHECK' => '"%1$s"로 태그된 사진이 없습니다. <a %2$s>"%1$s"로 태그된 논의주제</a>, <a %4$s>"%1$s"로 태그된 블로그 게시물</a> 또는 <a %3$s>"%1$s"로 태그된 동영상</a>을 확인하십시오. 또는 회원님의 사진을 추가하고 태그하십시오!',
        'UPLOAD_PHOTOS_FROM_YOUR_COMPUTER' => '회원님의 컴퓨터에서 사진 업로드',
        'YOUR_PHOTO_X_HAS_A_NEW_COMMENT_ON_Y' => '%2$s에 올린 회원님의 사진 "%1$s"에 새로운 답글이 올라와 있습니다.',
        'YOUR_PHOTO_HAS_A_NEW_COMMENT_ON_X' => '%s에 있는 회원님의 사진에 새로운 답글이 올라와 있습니다.',
        'CLICK_EDIT_TO_ADD_TEXT' => '\'편집\'을 클릭해 이 상자에 텍스트, HTML, 동영상, 사진이나 다른 <a %1$s>제3자 위짓을</a> 추가하세요.  회원님의 %2$s 페이지를 당신만의 고유한 페이지로 가꿀 수 있는 또 하나의 방법이랍니다..',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y_ELLIPSIS' => '%2$s에서 승인을 기다리고 있는 신규 %1$s가 있습니다 ...',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y' => '%2$s에서 승인을 기다리고 있는 신규 %1$s가 있습니다 .',
        'YOU_HAVE_A_NEW_X_TITLE_TO_APPROVE_ON_Y' => '%2$s에서 승인을 기다리고 있는 신규 %1$s가 있습니다 ...',
        'TO_APPROVE_THIS_X_VISIT' => '이 %s를 승인하려면, 다음 링크로 가십시오:',
        'YOUR_X_ON_Y_HAS_BEEN_APPROVED_ELLIPSIS' => '%2$s에 있는 회원님의 %1$s가 승인되었습니다...',
        'YOUR_TYPE_ON_X_HAS_A_NEW_COMMENT_ELLIPSIS' => '%2$s에 있는 회원님의 %1$s에 답글이 올라왔습니다...',
        'CLICK_HERE_TO_JOIN' => '여기를 클릭해서 가입하십시오:',
        'X_WANTS_YOU_TO_CHECK_OUT_Y_ON_Z' => '%1$s님이 %3$s에 있는 "%2$s"을 확인해 주시기를 요청합니다!',
        'YOUR_X_HAS_BEEN_APPROVED_ON_Y' => '회원님의 %s가 %s에서 승인되었습니다.',
        'YOUR_X_Y_HAS_BEEN_APPROVED_ON_Z' => '%3$s에 있는 회원님의 %1$s "%2$s"가 승인되었습니다.',
        'TO_VIEW_YOUR_X_VISIT' => '회원님의 %s을 보시려면, 다음을 방문하십시오:',
        'TO_VIEW_THIS_X_VISIT' => '이 %s을 보시려면, 다음을 방문하십시오:',
        'TO_VIEW_IT_VISIT' => '보기를 실행하시려면, 다음을 방문하십시오:',
        'X_REPORTED_THE_FOLLOWING_ISSUE_ON_Y_ELLIPSIS' => '%2$s에서 %1$s 님이 다음의 문제를 접수하였습니다...',
        'USER_HAS_SENT_YOU_A_MESSAGE_ON_X' => '%1$s 님이 %2$s에서 회원님에게 메시지를 보냈습니다.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X' => '%1$s 님이 %3$s에 있는 %2$s에 가입을 신청하였습니다 .',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X_ELLIPSIS' => '%3$s에 %1$s님이 %2$s에 가입을 신청했습니다...',
        'TO_APPROVE_OR_DENY_USER_REQUEST' => '%s 님의 가입 신청을 승인 또는 거부하려면, 다음 링크로 이동하십시오:',
        'X_ADDED_A_COMMENT_TO_THE_BLOG_POST_Y_ON_Z' => '%1$s 님이 %3$s에 있는 블로그 게시물  "%2$s"에 답글을 달았습니다.',
        'X_ADDED_A_COMMENT_TO_A_BLOG_POST_ON_Y_ELLIPSIS' => '%1$s 님이 블로그 게시물 %2$s에 답글을 달았습니다...',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X' => '%s에서 승인을 기다리고 있는 신규 회원이 있습니다.',
        'WELCOME_TO_THE_GROUP_X_ON_Y' => '%2$s에 있는 그룹  "%1$s"에 오신 것을 환영합니다.',
        'COME_JOIN_ME_ON_X' => '저랑 같이 %s에 가입하세요!',
        'PLEASE_SELECT_A_MEMBER' => '회원 1인 이상을 선택하십시오',
        'LOADING_YOUR_FRIENDS' => '회원님의 친구를 로딩 중입니다...',
        'YOUR_MESSAGE_HAS_BEEN_SENT_TITLE_CASE' => '회원님의 메시지를 전송했습니다.',
        'TO_SEND_ANOTHER_MESSAGE' => '추가 메시지를 보내시려면, 아래에 내용을 입력하십시오.',
        'PLEASE_CHOOSE_FRIENDS' => '메시지를 보내기에 앞서 친구를 선택하시기 바랍니다.',
        'RESEND_INVITATION' => '초대장 재전송',
        'CHOOSE_FRIENDS' => '친구를 선택합니다……',
        'ALL_FRIENDS' => '친구 전원',
        'ALL_FRIENDS_ON_APPNAME' => '%s의 친구 전원',
        'SHARE_WITH_FRIENDS' => '친구들과 공유',
        'SHARE_THIS_WITH_FRIENDS' => '이 항목을 회원님의 친구와 공유하십시오',
        'COMPOSE_MESSAGE' => '메시지 작성',
        'INVITATION_LINK_ONLY_VISIBLE' => '이 초대장 링크는 네트워크 설립자나 운영자만 볼 수 있습니다. 이 링크를 통해 가입하는 회원은 네트워크 설립자의 친구로 자동 등록됩니다.',
        'WE_ARE_LOADING_ADDRESSES' => '회원님의 주소를 로딩 중입니다...',
        'SELECT_ALL_NONE' => '전체 선택/취소',
        'INVITE_TO_APPNAME' => '\'%s\'에 초청하기',
        'INVITE_YOUR_FRIENDS_TO_APPNAME' => '\'%s\'에 회원님의 친구를 초대하십시오',
        'ALREADY_MEMBER_OF_NETWORK' => '(기존 회원입니다)',
        'OR_SHARE_THIS_INVITATION_LINK' => '또는 이 초청 링크를 공유하십시오:',
        'CLICK_TO_MAIL' => '<a %s>여기를 클릭해 지금 메일을 전송하십시오</a>.',
        'MESSAGE_HAS_BEEN_SENT' => '회원님의 메시지를 전송했습니다.',
        'YOU_CAN_SHARE_THIS' => '추가로 아래의 사람들과 공유하거나 <a %s>이전의 페이지로 돌아갈 수 있습니다</a>.',
        'VCARD_IMPORT_UNAVAILABLE' => '죄송합니다. vCard 가져오기 기능은 현재 제공되지 않습니다.',
        'CSV_IMPORT_UNAVAILABLE' => '죄송합니다. CSV 가져오기 기능은 현재 제공되지 않습니다.',
        'ERROR_OCCURRED' => '죄송합니다. 오류가 발생했습니다.',
        'IMPORT_FAILED' => '죄송합니다. 가져오기에 실패했습니다.',
        'LOGIN_FAILED' => '죄송합니다. 로그인에 실패했습니다.',
        'UNABLE_TO_FIND_EMAIL' => '죄송합니다. 이메일 필드를 찾을 수 없습니다.',
        'CANNOT_READ_VCARDS' => '죄송합니다, vCards를 읽을 수 없습니다.',
        'SORRY_WE_DO_NOT_SUPPORT' => '죄송합니다. 저희는 사용자님의 이메일 계정이 사용하는 웹 주소록을 지원하지 않습니다. 아래의 ‘주소록 프로그램’을 클릭하여 사용자님의 컴퓨터에 있는 주소록을 사용해 보십시오.',
        'NO_ADDRESSES_FOUND' => '주소를 찾지 못 했습니다',
        'WE_DID_NOT_FIND_ADDRESSES' => '가져온 파일에서 아무런 주소도 찾지 못 했습니다.',
        'WANT_TO_INVITE_MORE_FRIENDS' => '더 많은 친구를 초대하기 원하십니까? 회원님의 웹이나 데스크톱의 주소록 응용 프로그램에서 연락처를 직접 가져오십시오.',
        'IMPORT_FROM_WEB_ADDRESS_BOOK' => '웹 주소록에서 가져오기',
        'IMPORT_FROM_ADDRESS_BOOK_APPLICATION' => '주소록 응용 프로그램에서 가져오기',
        'MICROSOFT_OUTLOOK_APPLE_ADDRESS_BOOK' => '마이크로소프트 아웃룩, 애플 주소록, CSV, 등',
        'SET_NEW_PASSWORD' => '회원님의 Ning ID 계정에 새 비밀번호를 설정하세요.',
        'PRIVACY_POLICY' => '개인정보 보호정책',
        'APPLY_FOR_MEMBERSHIP_SIGN_IN' => '회원 가입. 기존 회원이시면, <a %s>여기를 클릭해 로그인하십시오</a>.',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK_ON_Y' => '%1$s 님이 %2$s에 다음의 평가 소감을 남기셨습니다:',
        'TRACK_STATISTICS' => '통계자료를 추적합니다',
        'FEATURED_MEMBERS' => '특별 멤버',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS_IF_YOU_THINK' => '죄송합니다, %s님, 회원님의 %s참여가 금지되었기 때문에 접속하실 수 없습니다.  실수로 금지가 되었다고 생각하시면 운영자에게 연락해 주세요.',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS' => '죄송합니다, %s님, 회원님의 %s참여가 금지되었기 때문에 접속하실 수 없습니다.',
        'CHECK_OUT_X_ON_Y_ELLIPSIS' => '%2$s에 있는 "%1$s"을 확인하십시오…',
        'CHECK_OUT_THIS_X_ON_Y_ELLIPSIS' => '%2$s에 있는 "%1$s"을 확인하십시오…',
        'SORRY_NO_MEMBERS_MATCHING_X_WERE_FOUND' => '죄송합니다. 검색하신 회원 "%s"을 찾지 못 했습니다.',
        'WHO_CAN_COMMENT_ON_POST' => '이 게시물에 대한 답글을 누구에게 허용하시겠습니까?',
        'SEND_MESSAGE_TO_FRIENDS' => '친구에게 메시지 보내기',
        'PREVIOUS_POST' => '← 이전 게시물',
        'NEXT_POST' => '다음 게시물',
        'PREVIOUS_POSTS' => '←  이전 게시물',
        'NEXT_POSTS' => '다음 게시물',
        'NO_BLOG_POSTS_TAGGED_X_CHECK' => '"%1$s"로 태그된 게시물이 없습니다.  <a %2$s>"%1$s"로 태그된 논의 주제</a>, <a %4$s>"%1$s"로 태그된 사진</a> 또는 <a %3$s>"%1$s"로 태그된 비디오</a>을 확인하십시오. 또는 회원님의 블로그 게시물을 추가하거나 태그하십시오!',
        'ALL_POSTS_TAGGED_X_FOR_M_Y' => '<em>\'%s\'</em>로 태그된 모든 게시물',
        'ALL_POSTS_TAGGED_X' => '<em>\'%s\'</em>로 태그된 모든 게시물',
        'MY_BLOG_POSTS_FOR_M_Y' => '%s %s에 있는 나의 블로그 게시물',
        'MY_BLOG_POSTS' => '나의 블로그 게시물',
        'PICK_VALID_ALL_FRIENDS_NOTIFICATION' => '모든 친구들에게 보낸 메시지 통지기능을 위한 유효한 선택을 하십시오.',
        'PRIVACY_CONTENT_CONTROL' => '개인정보 보호 및 컨텐츠 제어정책',
        'ENABLE_MUSIC_DOWNLOAD_LINKS' => '뮤직 플레이어 다운로드 링크 기능을 작동합니다',
        'WELCOME_MEMBER_N_OF_APPNAME_INVITE' => '%1$s 님, 환영합니다! 회원님은 %3$s의 #%2$s 번째 회원입니다. <a %4$s>지금 친구분들을 초대하십시오</a>.',
        'YOU_COMMENTED_ON_PHOTO_TITLE' => '<a %s>%s</a> 사진에 답글을 달았습니다.',
        'X_LINK_COMMENTED_ON_PHOTO_TITLE' => '%s  님이 <a %s>%s</a> 사진에 답글을 달았습니다.',
        'YOU_COMMENTED_ON_VIDEO_TITLE' => '<a %s>%s</a> 비디오에 답글을 달았습니다.',
        'X_LINK_COMMENTED_ON_VIDEO_TITLE' => '%s 님이 <a %s>%s</a> 비디오에 답글을 달았습니다.',
        'NOTIFY_BLOG_PING_SERVICES' => '새로운 게시물을 추가하면, 이를 제3자 블로그 추적 서비스에 통보하기를 원하십니까?',
        'YES_NOTIFY_BLOG_SERVICES' => '예 – 내가 새로운 블로그 게시물을 추가할 때 <a %s> 사이트 업데이트 서비스</a>에 통보하십시오.',
        'THERE_ARE_NO_FEATURED_MEMBERS' => '회원님의 사교 네트워크에는 ‘특별 멤버’가 설정되어 있지 않습니다.',
        'START_FEATURING_MEMBERS_CLICK_Y' => '‘특별 멤버’ 옵션 기능을 이용해 네트워크 회원을 추천하십시오. ‘특별 멤버’ 옵션 기능에 대한 보다 상세한 정보를 원하시면, <a %s>여기를 클릭하십시오</a>.',
        'THIS_IS_YOUR_PAGE' => '회원님의 페이지입니다.',
        'MESSAGES_SENT_TO_ALL_FRIENDS' => '친구 모두에게 보낸 편지',
        'TO_STOP_FOLLOWING_THIS_X_GO_TO' => '이 %s 추적 기능을 중단하려면, 다음 링크로 이동하십시오:',
        'SHOW_ALL' => '전체 보기',
        'CHOOSE_GADGETS' => '회원님의 프로파일 페이지에 추가할 OpenSocial(오픈 소셜) gadget을 하나 선택하십시오! <a %s>이 페이지에서 gadget을 보고 평가하거나, 또는 <a %s>오픈 소셜의 기능을 배워보십시오</a>.',
        'GADGETS_UNAVAILABLE' => '지금은 잠시 gadget을 사용할 수 없습니다',
        'APOLOGIES_GADGETS_UNAVAILABLE' => '죄송합니다. Gadget의 사용이 잠시 중단되었습니다.',
        'BOX_WILL_NOT_SHOW_GADGET' => 'Gadget을 선택하지 않을 경우, 이 박스는 다른 사람들이 볼 수 없습니다.',
        'CLICK_EDIT_TO_SPECIFY_GADGET_OR_VISIT_GADGET_GALLERY' => '편집을 클릭해 이 박스에 대한 Gadget URL을 지정하거나 <a %s>Gadget Directory(Gadget 주소록)</a>를 방문하십시오.',
        'PROBLEM_OCCURRED_RETRIEVING_GADGET' => 'Gadget URL을 불러오는 과정에서 문제가 발생했습니다.',
        'ADD_GADGET_TO_YOUR_PAGE' => '회원님의 프로파일에 이 Gadget을 추가하십시오',
        'GADGETS_BETA' => 'Gadget(베타)',
        'TRY_OUT_OPENSOCIAL_GADGETS_WARNING_EXPERIMENTAL' => '오픈소셜 Gadget을 시험해 보십시오.  경고: 이 기능은 현재 테스트 중인 기능입니다.',
        'ADD_TO_MY_PAGE' => '내 페이지에 추가',
        'GADGETS' => 'Gadget',
        'GADGETS_TAB_TEXT' => 'Gadget',
        'GADGET' => 'Gadget',
        'GADGETS_IS_IN_BETA' => 'Gadget은 현재 베타 테스트 중입니다.',
        'SORRY_GADGET_UNAVAILABLE' => '죄송합니다만, 이 Gadget은 현재 이용할 수 없습니다. URL이 정확한지 확인하시기 바랍니다. 여전히 문제가 발생하면, <a %s>저희에게 알려주시기 바랍니다</a>.',
        'VIEW_ALL_N_CATEGORIES' => '모든 %s 카테고리 보기',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_ADD' => '"%1$s"로 태그된 논의주제가 없습니다. <a %2$s>"%1$s"로 태그된 사진</a>, <a %4$s>"%1$s"로 태그된 블로그 게시물 </a> 또는 <a %3$s>"%1$s"로 태그된 비디오</a>를 확인하십시오. 또는 회원님의 논의 주제를 추가하거나 태그하십시오.',
        'NO_DISCUSSIONS_TAGGED_X_CHECK' => '"%1$s"로 태그된 논의주제가 없습니다. <a %2$s>"%1$s"로 태그된 사진</a>, <a %4$s>"%1$s"로 태그된 블로그 게시물 </a> 또는 <a %3$s>"%1$s"로 태그된 비디오 </a>을 확인하십시오.',
        'ALREADY_MEMBER_OF_GROUP' => '(이 그룹의 기존 회원입니다)',
        'INVITE_YOUR_FRIENDS_TO_GROUPNAME' => '\'%s\'에 회원님의 친구를 초대하십시오',
        'COME_JOIN_ME_ON_X_ON_Y' => '%2$s에 있는 %1$s에 저랑 같이 가입하십시오.',
        'COME_JOIN_ME_ON_X_ON_Y_ELLIPSIS' => '%2$s에 있는 %1$s에 저랑 같이 가입하십시오…',
        'INVITE_TO_GROUP' => '\'%s\'에 초청하기',
        'YOU_CAN_ADD_100_SONGS' => '용량한도 20MB의 노래 100곡을 추가할 수 있습니다. .mp3 파일 형식의 노래를 지원합니다.',
        'I_HAVE_RIGHT_TO_UPLOAD_SONGS' => '본인은 <a %s">이용약관</a>에 의거하여 이 노래를 업로드할 권한을 보유하고 있습니다.',
        'MUSIC_UPLOADER_REQUIRES_JAVA' => '‘음악 대량 업로드 툴’을 이용하시려면, 자바 최신 버전이 필요합니다. <strong><a %s>여기를 클릭해 자바를 설치하거나</a></strong>, 또는 <strong><a %s>일반 업로드 툴로 이동하십시오</a></strong>.',
        'HAVE_LOT_OF_MUSIC' => '공유하고 싶은 음악이 많으십니까?',
        'TRY_BULK_MUSIC_UPLOADER' => '‘음악 대량 업로드 툴’을 이용하십시오',
        'SONGS_SUCCESSFULLY_UPLOADED' => '회원님의 노래는 성공적으로 업로드되었습니다.',
        'SORRY_YOU_CAN_ONLY_HAVE_N_TRACKS' => '죄송합니다. 재생목록에는 최대 %s 곡까지 저장할 수 있습니다. 곡을 추가하기 전에저장된 노래를 일부 삭제하십시오.',
        'ADD_MUSIC_FROM_WEBSITE' => '다른 웹사이트에서 음악 추가',
        'HAVING_PROBLEMS_WITH_MUSIC_UPLOADER' => '이 음악 업로드 툴에 문제가 있습니까?  <strong><a %s>일반 업로드 툴로 돌아가십시오</a></strong>.',
        'UPLOAD_MUSIC_FROM_YOUR_COMPUTER' => '회원님의 컴퓨터에서 음악을 업로드합니다',
        'ADD_MUSIC' => '음악 추가',
        'FACEBOOK_INSTR_SETUP_APP_PERMISSION' => '<strong>사용자</strong>와 <strong>모든 페이지</strong>를 선택하십시오.',
        'USER_COUNT' => '(%d)',
        'NOBODY_HAS_ADDED_VIDEOS' => '아직 게시된 동영상이 없습니다!  시작하시려면 동영상을 추가하세요.',
        'SEARCH_PEOPLE' => '회원 검색:',
        'INVITE_YOUR_FRIENDS_TO' => '%s에 회원님의 친구를 초대하세요.',
        'INVITE' => '초대',
        'INVITE_TAB_TEXT' => '초대',
        'YOU_HAVE_NOT_ADDED_FRIENDS' => '아직 %s에 친구를 추가하지 않았습니다.',
        'SEARCH_FRIENDS' => '친구 검색:',
        'ADD_YOUR_FIRST_VIDEO' => '회원님의 첫 번째 동영상을 추가하세요',
        'USE_HTML_EMBED_CODE' => 'HTML 임베드 코드 사용',
        'NEED_HELP_HERE_ARE' => '도움이 필요하세요?  다음은 <a %s>YouTube</a>와 <a %s>Google Video</a> 관련 사용방법입니다.',
        'ADD_TITLE_AND_DESCRIPTION' => '제목과 내용 설명을 입력하세요',
        'DESCRIPTION_COLON' => '내용:',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_1' => '업로드 하신 동영상의 제목, 내용 및 기타 정보를 추가하세요.',
        'EVERYTHING_IS_OPTIONAL' => '모두 선택사항입니다;  아무 정보도 추가하기 원치 않으면 우측의 “건너뛰기”를 클릭하세요.',
        'SKIP_THIS_STEP' => '건너뛰기',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_2' => '이 동영상의 제목, 내용 및 기타 정보를 추가하세요.',
        'CANCEL_AND_RETURN_TO_VIDEO' => '취소하고 동영상으로 돌아가기',
        'TITLE' => '제목:',
        'TAGS_ARE_SHORT_DESCRIPTIONS' => '태그는 회원님이 자신의 동영상을 찾을 때 도움이 되는 짧은 설명입니다.  태그는 쉼표로 분리하시고, 여러 단어의 태그의 경우는 따옴표 안에 넣으세요. 예: “San Francisco”',
        'WHO_CAN_VIEW_VIDEO' => '누가 이 동영상을 볼 수 있나요?',
        'MOST_POPULAR' => '최고 인기',
        'HIGHEST_RATED' => '최고 등급',
        'MOST_RECENT' => '최신',
        'MOST_FAVORITED' => '최다 즐겨찾기 지정',
        'MOST_POPULAR_VIDEOS' => '최고 인기 동영상',
        'HIGHEST_RATED_VIDEOS' => '최고 등급 동영상',
        'MOST_RECENT_VIDEOS' => '최신 동영상',
        'MOST_FAVORITED_VIDEOS' => '최다 즐겨찾기 지정 동영상',
        'ANYONE' => '누구나',
        'JUST_MY_FRIENDS' => '나의 친구에게만',
        'JUST_ME' => '나만',
        'VIEWABLE_BY_FRIENDS' => '<strong>친구들</strong>에게만 공개',
        'PRIVATE_VIDEO' => '<strong>비공개</strong> 동영상',
        'VIEWABLE_BY_EVERYONE' => '<strong>전체</strong> 공개',
        'LOCATION' => '위치:',
        'NO_LOCATION' => '위치 없음',
        'CLICK_ON_LOCATION' => '지도에서 위치를 클릭하세요:',
        'FIND_AN_ADDRESS' => '주소 찾기:',
        'LOCATE' => '찾기',
        'YOU_CAN_ADD_YOUR_OWN_VIDEO' => '%2$s에 <a %1$s>회원님의 자신의 동영상을 추가</a>할 수 있습니다!',
        'ADD_PLAYER_LOGO_OR_WATERMARK' => '회원님의 네트워크 동영상 플레이어에 로고나 워터마크 이미지를 추가하세요.  <a %s>지금 설정하세요! </a>',
        'APPROVE' => '승인',
        'DELETE' => '삭제하기',
        'APPLY_TO_VIDEOS_ADDED_BY' => '%s님이 추가한 모든 동영상에 적용',
        'NO_TITLE' => '제목 없음',
        'ADDED_BY_STRONG_X' => '게시자: <strong>%s</strong>',
        'NO_DESCRIPTION' => '내용 설명 없음',
        'BY_X' => '게시자',
        'YOU_HAVE_FINISHED_MODERATING' => '회원님이 검토를 완료했습니다',
        'NO_VIDEOS_AWAITING_APPROVAL' => '현재는 승인을 기다리는 동영상이 없습니다.  볼 거리를 찾고 계시면 <a %s>최신 동영상</a>을 둘러보시는 것이 어떨까요?',
        'NO_ONE_HAS_ADDED_ANY_VIDEOS' => '회원님의 사교 네트워크에는 아직 아무도 동영상을 추가하지 않았습니다.  일착으로 동영상을 올리세요!',
        'ADDED_ON_DATE_BY_X' => '%s을(를) %s님이 추가.',
        'REMOVE_FROM_FAVORITES' => '즐겨찾기에서 제거',
        'REMOVE_VIDEO_FROM_FAVORITES' => '즐겨찾기에서 이 동영상을 제거할까요?',
        'COLLECTED_BY_X' => '%s님이 수집',
        'ADD_FAVORITES' => '즐겨찾기에 추가',
        'YOU_CAN_MARK_VIDEO' => '어떤 동영상이든 즐겨찾기에 지정할 수 있습니다.  동영상에 따라 나오는 “즐겨찾기에 추가” 아이콘을 보시면 그 아이콘만 클릭하면 됩니다.',
        'VIEW_RECENT_VIDEOS' => '최신 동영상 보기',
        'X_HAS_NOT_ADDED_FAVORITES' => '%s님은 아직 즐겨찾기에 아무 것도 추가하지 않았습니다.',
        'APPROVE_VIDEOS' => '동영상 승인',
        'YOUR_SITE_REQUIRES_YOU' => '회원님은 자신의 사교 네트워크에 게시될 사진과 동영상은 반드시 사전 검토를 받도록 설정하셨습니다.  이 설정을 변경하려면 <a %s>여기를 클릭해 공개설정 페이지</a>로 가서 ‘신규 사진과 동영상 승인’을 꺼놓으세요.',
        'YOUR_SITE_ALLOWS_USERS' => '회원님은 자신의 사교 네트워크에 게시될 사진과 동영상에 사전 검토가 필요하지 않도록 설정하였습니다.  이 설정을 변경하려면 <a %s>여기를 클릭해 공개설정 페이지</a>로 가서 \'신규 사진과 동영상 승인\'을 켜놓으세요.',
        'APPROVE_ALL_VIDEOS' => '모든 동영상을 승인할까요?',
        'ARE_YOU_SURE_APPROVE_ALL_VIDEOS' => '모든 동영상을 승인하기 원하는 것이 확실합니까?  완료하는 데 몇 분 정도 소요될 수 있습니다.',
        'APPROVING' => '승인 중...',
        'APPROVE_ALL' => '모두 승인',
        'DELETE_ALL_VIDEOS' => '모든 동영상을 삭제할까요?',
        'ARE_YOU_SURE_DELETE_ALL_VIDEOS' => '승인되지 않은 모든 동영상을 삭제하기 원하는 것이 확실합니까?  완료하는 데 몇 분 정도 소요될 수 있습니다.',
        'DELETING' => '삭제 중...',
        'DELETE_ALL' => '모두 삭제',
        'XS_VIDEOS' => '%s님의 동영상',
        'DELETE_ALL_XS_VIDEOS_Q' => '%s님의 동영상 모두 삭제',
        'DELETE_ALL_XS_VIDEOS' => '%s님의 동영상 모두 삭제',
        'ARE_YOU_SURE_DELETE_ALL_XS_VIDEOS' => '%s님의 모든 동영상을 삭제하기 원하는 것이 확실합니까?  몇 분 정도 소요될 수 있습니다.',
        'DELETE_THIS_VIDEO_Q' => '이 동영상을 삭제할까요?',
        'ARE_YOU_SURE_DELETE_THIS_VIDEO' => '이 동영상을 삭제하기 원하는 것이 확실합니까?  몇 분 정도 소요될 수 있습니다.',
        'YOU_HAVE_NOT_ADDED_VIDEOS_2' => '회원님은 아직 동영상을 한 건도 추가하지 않았습니다.  동영상을 추가해 시작하세요!',
        'X_HAS_NOT_ADDED_VIDEOS' => '%s님은 아직 동영상을 한 건도 추가하지 않았습니다.',
        'YOUR_FRIENDS_DO_NOT_HAVE_VIDEOS' => '회원님의 친구들은 아직 동영상을 한 건도 추가하지 않았습니다.',
        'ALL_VIDEOS_TAGGED_X' => '\'%s\'로 태그된 모든 동영상',
        'ALL_VIDEOS_TAGGED_X_2' => '<em>\'%s\'</em>로 태그된 모든 동영상',
        'NO_VIDEOS_TAGGED_X_CHECK_OUT' => '"%1$s"로 태그된 동영상이 없습니다.  <a %2$s> 토론("%1$s"로 태그된)</a> 또는 <a %3$s> 사진("%1$s"로 태그된)</a>을 한 번 둘러보세요.  또는 회원님의 동영상을 추가하거나 태그하세요!',
        'FILES_MUST_BE_100MB' => '파일의 용량은 100MB 이하이어야 합니다.  Ning은 . mov, . mpg, . avi, . 3gp와 . wmv 형식의 파일을 지원합니다.',
        'NEED_HELP' => '도움이 필요하세요?',
        'HERE_ARE_INSTRUCTIONS' => '다음은 <a %s>YouTube</a>와 <a %s>Google Video</a> 관련 사용방법입니다.',
        'PERSON_IN_CHARGE' => '회원님의 작품을 세계에 공개하기에 앞서 %s의 운영자가 미리 검토하고자 하는군요.',
        'LEAVE_WINDOW_OPEN' => '업로드가 완성될 때까지 이 창을 계속해서 열어놓아 두세요.',
        'KEEP_PAGE_OPEN' => '저희가 회원님의 동영상을 완전히 업로드할 때까지 이 페이지를 열어놓고 기다리시면 승인이 되는대로 알려드리겠습니다!',
        'MEANWHILE_FEEL_FREE' => '그 동안 <a %s>새 브라우저 창을 열고</a> %s을 이용하세요.  업로드가 완료되면 이 창에서 회원님의 동영상 제목과 내용 설명을 추가할 수 있습니다.',
        'VIDEO_IS_WAITING_FOR_APPROVAL' => '이 동영상은 %s 운영자의 <strong>승인을 기다리고 있습니다.</strong>',
        'LOADING' => '로딩 중...',
        'EDIT_VIDEO' => '동영상 편집',
        'DELETE_VIDEO' => '동영상 삭제',
        'YOU_NEED_TO_BE_MEMBER' => '코멘트를 달려면 우선 %s의 가입자가 되어야 합니다!',
        'SIGN_UP_OR_SIGN_IN' => '<a %s>이 네트워크에 가입하세요</a>',
        'ADD_A_COMMENT' => '코멘트 추가하기',
        'LEAVE_A_COMMENT_FOR_USERNAME' => '%s님에게 글을 남기세요',
        'MORE' => '기타',
        'PREVIOUS' => '이전',
        'NEXT' => '다음',
        'ABOUT_THIS_VIDEO' => '동영상 관련 정보',
        'ABOUT_YOUR_VIDEO' => '동영상 관련 정보',
        'ADDED_ON_DATE_BY' => '<strong>%s</strong> 게시자:',
        'VIEWS' => '조회 수:',
        'COMMENTS' => '설명',
        'COMMENTS_COLON' => '글:',
        'LOCATION_OF_VIDEO' => '이 동영상의 위치:',
        'RELATED_VIDEOS' => '관련 동영상',
        'ALL_VIDEOS_TAGGED_X_X' => '%s(%s)로 태그된 모든 동영상',
        'XS_VIDEOS_X' => '%s님의 동영상 (%s)',
        'XS_FAVORITES_X' => '%s님의 즐겨찾기 (%s)',
        'VIDEO_DETAILS' => '동영상 세부 내용',
        'NEITHER_FILE_NOR_EMBED_CODE' => '파일이나 임베드 코드가 지정되지 않았습니다.',
        'VIDEO_UPLOADED_ON_X' => '%s에 동영상 업로드 완료',
        'PROBLEM_OCCURRED_CONVERTING_VIDEO' => '동영상을 플래시 포맷으로 전환하는 과정에 오류가 발생했습니다: %s',
        'STATUS_N' => '%s상태',
        'YOUR_VIDEO_TITLED_X_COULD_NOT' => '회원님의 “%s”이라는 제목의 동영상은 %s에 추가되지 못 했습니다',
        'YOUR_VIDEO_COULD_NOT_BE_ADDED' => '회원님의 동영상은 %s에 추가되지 못 했습니다.',
        'YOU_JUST_TRIED_TO_SEND_VIDEO' => '회원님은 조금 전에 %s에 동영상을 전송하려 하셨습니다.  회원님은 %s의 가입자가 아니므로 저희로써는 동영상을 전달해 드릴 수 없습니다.',
        'VIDEO_UPLOAD_DID_NOT_COMPLETE' => '회원님의 비디오 업로드가 %s에 완료되지 않았습니다.',
        'YOUR_VIDEO_UPLOAD_DID_NOT_COMPLETE' => '회원님의 동영상 업로드가 %s에 완료되지 않았습니다.',
        'YOUR_VIDEO_ENCOUNTERED_A_PROBLEM' => '회원님의 동영상을 %s에 업로드하는 과정에서 오류가 발생했습니다',
        'THE_PROBLEM_WAS_X' => '오류 내용: %s',
        'ID' => 'ID:',
        'VIDEO_TRANSCODING_FAILED_FOR_X' => '%s 내의 %s 동영상의 동영상 변환 코드에 오류가 발생했습니다',
        'X_UPLOADED_A_VIDEO_THAT_FAILED' => '%s님이 업로드한 동영상이 변환 중 오류가 발생됐습니다.',
        'ERROR_MESSAGE' => '오류 메시지:',
        'APPLICATION_NAME' => '응용 프로그램 명:',
        'APPLICATION_ID' => '응용 프로그램 ID:',
        'VIDEO_ID' => '동영상 ID:',
        'VIDEO_UPLOAD_COMPLETE_ON_X' => '회원님의 비디오 업로드가 %s에 완료되었습니다.',
        'YOUR_VIDEO_UPLOAD_COMPLETE_ON_X' => '회원님의 동영상 업로드가 %s에 완료되었습니다',
        'YOUR_VIDEO_WAS_UPLOADED' => '회원님의 비디오가 성공적으로 %s에 업로드됐습니다!',
        'THAT_VIDEO_IS_AWAITING_APPROVAL' => '업로드한 동영상은 승인 대기 중입니다.',
        'THIS_VIDEO_IS_BEING_PROCESSED' => '이 동영상은 아직 처리 중입니다.',
        'ADD_VIDEO' => '동영상 추가',
        'VIDEO_BY_X' => '%s님의 동영상',
        'THERE_IS_NEW_COMMENT_ON_VIDEO_X' => '%s에 올린 회원님의 “%s” 동영상에 새로운 코멘트가 올라와 있습니다',
        'THERE_IS_NEW_COMMENT_ON_VIDEO' => '%s에 올린 회원님의 동영상 중 하나에 새로운 코멘트가 올라 있습니다',
        'SOMEBODY_COMMENTED_VIDEO_ADDED_TO_X' => '회원님이 %s에 추가한 동영상에 누군가가 코멘트를 달았습니다',
        'SOMEBODY_UPLOADED_VIDEO_TO_X' => '누군가가 %s에 동영상을 업로드했습니다',
        'MORE_WAYS_TO_ADD_VIDEOS' => '기타 동영상 추가 방법...',
        'FROM_YOUTUBE_OR_GOOGLE' => '...YouTube 이나 Google에서',
        'GRAB_THE_HTML_EMBED_CODE' => '어떤 인기 동영상 사이트에서든 HTML \'임베드\' 코드를 가져와 해당 동영상을 이 사교 네트워크에 추가하세요.',
        'ADD_A_VIDEO_FROM_YOUTUBE' => 'YouTube나 Google에서 동영상 추가',
        'PASTE_IN_EMBED' => '\'임베드\' 코드를 여기에 붙여넣기 하세요:',
        'ADD_VIDEOS_BY_PHONE_OR_EMAIL' => '전화나 이메일로 동영상 추가',
        'VIDEO' => '동영상',
        'THERE_ARE_NO_VIDEOS_THAT_MATCH' => '회원님이 선택한 설정과 일치하는 동영상이 없습니다.',
        'CLICK_EDIT_AND_CHANGE_SETTINGS' => '이 상자를 다른 사람에게 공개하려면 \'편집\'을 클릭해 설정을 변경하세요.',
        'PLAY_AGAIN' => '다시 보기',
        'SHARE' => '공유',
        'EMBED' => '임베드',
        'REWIND' => '리와인드',
        'CHANGE_SIZE' => '크기 변경',
        'FULLSCREEN' => '전체화면',
        'EXIT_FULLSCREEN' => '전체화면 끝내기',
        'HIDE' => '닫다',
        'COPY_AND_PASTE_LINK' => '이 링크를 복사해서 이메일이나 IM에 붙여 넣으세요:',
        'FIND_MORE_VIDEOS_LIKE_THIS' => '<em>%s</em>에서 비슷한 종류의 동영상 찾기',
        'SEE_VIDEO_ON_NETWORK' => '%s에서 이 동영상 보기',
        'GET_EMBED_CODE' => '임베드 코드 가져오기',
        'MORE_PHOTOS' => '추가 사진',
        'THIS_ALBUM' => '이 앨범',
        'NETWORK_DOES_NOT_HAVE_PHOTOS' => '이 네트워크에는 아직 사진이 없습니다.',
        'PERSON_DOES_NOT_HAVE_PHOTOS' => '이 분은 아직 사진이 없습니다.',
        'ALBUM_DOES_NOT_HAVE_PHOTOS' => '이 앨범에는 아직 사진이 없습니다.',
        'FIND_MORE_PHOTOS_LIKE_THIS' => '<em>%s</em>에서 비슷한 종류의 사진 찾기',
        'NO_PHOTOS_AVAILABLE' => '이 앨범에는 현재 제공되는 사진이 없습니다.  <a %s>여기를 클릭해 모든 앨범을 보세요</a>.',
        'ALBUM_PHOTOS_NOT_VISIBLE_TO_OTHERS' => '이 앨범의 사진들은 회원님만 볼 수 있거나 아직 승인되지 않은 상태여서 네트워크 상의 다른 사람들은 볼 수 없습니다.',
        'CUSTOMIZE_YOUR_SLIDESHOW_PLAYER' => '회원님의 맞춤형 슬라이드쇼 플레이어를 설정하세요!',
        'ADD_SLIDESHOW_LOGO' => '회원님 사교 네트워크의 슬라이드쇼에 로고를 추가하세요.  <a %s>지금 설정하세요! </a>',
        'PHOTO_BY_X' => '%s님의 사진',
        'UPLOAD_PHOTOS' => '사진 업로드',
        'PLAYER_COLOR' => '플레이어 색상',
        'SLIDESHOW_PLAYER' => '슬라이드쇼 플레이어',
        'SLIDESHOW' => '슬라이드쇼',
        'FILTER' => '필터',
        'SAVE_ALBUM' => '앨범 저장',
        'APPLY_THIS_INFO_TO_PHOTOS' => '다음의 사진들에 이 정보 적용',
        'CLICK_TO_ADD_A_DESCRIPTION' => '클릭하여 내용 설명을 추가하세요',
        'CHECK' => '확인',
        'YOU_NEED_TO_BE_X' => '%s이어야만 이용가능한 기능입니다.',
        'ALL_PHOTOS' => '모든 사진',
        'POPULAR_PHOTOS' => '인기 사진',
        'FEATURED_PHOTOS' => '추천 사진',
        'PHOTOS_HOME' => '사진 홈',
        'ALL_ALBUMS' => '모든 앨범',
        'MY_PHOTOS' => '나의 사진',
        'MY_ALBUMS' => '나의 앨범',
        'ADD_PHOTOS' => '사진 추가',
        'ADD_PHOTOS_SENTENCE_CASE' => '복수 사진 추가',
        'EDIT' => '편집',
        'CHOOSE_PHOTOS' => '사진 선택',
        'ADD_PHOTOS_BY_DRAGGING' => '우측에 있는 회원님의 앨범으로 <strong>사진을 ’끌어 오기’로 추가</strong>하세요.  다시 제 자리로 ‘끌어 오기’ 해서 제거하세요.',
        'TITLE_YOUR_ALBUM' => '<strong>앨범 제목을 입력하세요. </strong> 표지와 설명 내용을 작성하세요.',
        'SAVE_YOUR_ALBUM' => '앨범을 저장하세요!',
        'CHOOSE_FROM' => '선택 사항:',
        'EVERYONES_PHOTOS' => '모든 사람의 사진',
        'TAGGED' => '태그:',
        'OLDER_PHOTOS' => '이전 사진',
        'MORE_RECENT_PHOTOS' => '최근 사진',
        'YOUR_ALBUM' => '회원님의 앨범',
        'DRAG_ALBUM_COVER_HERE' => '앨범 표지를 여기로 ‘끌어 오기’ 하세요',
        'ALBUM_TITLE' => '앨범 제목:',
        'ALBUM' => '앨범',
        'DRAG_PHOTOS_HERE' => '회원님의 사진을 여기로 ‘끌어 오기’하세요',
        'PREVIOUS_ALBUM_PAGE' => '앨범 이전 페이지',
        'NEXT_ALBUM_PAGE' => '앨범 다음 페이지',
        'ADDED_ON_DATE' => '%s을(를) 추가했습니다',
        'VIEW_AS_SLIDESHOW' => '슬라이드쇼로 보기',
        'CREATED_BY_ME' => '게시자: <a %s>나</a>',
        'CREATED_BY_X' => '게시자: %s',
        'OUR_APOLOGIES' => '죄송합니다',
        'ADD_PHOTOS_TO_ALBUM' => '다음 사항 중 선택하셔서 이 앨범에 사진을 추가하세요.',
        'YOU_CAN_ADD_PHOTOS' => '<a %s>이 앨범에 당장 사진을 추가</a>할 수 있습니다.',
        'SITE_IS_GETTING_STARTED' => '이 사교 네트워크는 이제 슬슬 바빠지는군요!',
        'NO_ONE_CREATED_ALBUMS' => '아직 아무도 앨범을 만들지 않은 것 같군요.  <a %s>지금 앨범을 작성</a>하실 수 있습니다.',
        'EDIT_YOUR_ALBUM' => '회원님의 앨범 편집',
        'ALBUMS_WITH_THIS_PHOTO' => '이 사진이 수록되어 있는 모든 앨범',
        'ALBUMS_WITH_X' => '\'%s\'이 수록되어 있는 모든 앨범',
        'ALBUMS_WITH_X_2' => '<em>\'%s\'</em>이 수록되어 있는 모든 앨범',
        'NO_ALBUMS_CONTAINING_PHOTO' => '이 사진이 수록되어 있는 앨범이 없습니다.  <a %s>새 앨범을 작성</a>할 수 있습니다.',
        'XS_ALBUMS' => '%s님의 앨범',
        'CREATE_AN_ALBUM' => '앨범 작성하기',
        'YOU_HAVE_NOT_CREATED_ALBUMS' => '회원님은 아직 앨범을 작성하지 않았습니다.  <a %s>지금 앨범을 작성</a>할 수 있습니다.',
        'X_HAS_NOT_CREATED_ALBUMS' => '%s님은 아직 앨범을 작성하지 않았습니다.',
        'MAKE_AN_ALBUM' => '앨범 만들기',
        'ABOUT_THIS_ALBUM' => '앨범 정보',
        'ABOUT_YOUR_ALBUM' => '회원님의 앨범 정보',
        'EDIT_ALBUM' => '앨범 편집',
        'DELETE_THIS_ALBUM' => '이 앨범을 삭제할까요?',
        'DELETE_ALBUM' => '앨범 삭제',
        'START_SLIDESHOW' => '슬라이드쇼 시작',
        'ALBUM_IS_NOW_EMPTY' => '이 앨범은 이제 비었습니다.',
        'YOU_ARE_GETTING_STARTED' => '아직도 할 일이 많아요!',
        'YOU_HAVE_NOT_ADDED_PHOTOS' => '회원님은 아직 사진을 추가하지 않았습니다!',
        'ADD_PHOTOS_AND_SHARE' => '사진을 추가해 친지나 세계 모든 사람들과 함께 나누세요!',
        'ADD_A_PHOTO' => '사진 추가',
        'NO_PHOTOS_ON_SITE' => '현재 회원님의 사교 네트워크에는 사진이 없습니다.',
        'BOX_WILL_NOT_SHOW_PHOTOS' => '보여줄 사진이 있을 때까지 다른 사람들은 이 박스를 볼 수 없습니다.  사진 한 장 추가해 보시겠어요?',
        'VIEW_EMBED_CODE' => '임베드 코드 보기',
        'VIEW_PHOTOS' => '사진 보기',
        'ADD_YOUR_FIRST_PHOTOS' => '회원님의 첫 번째 사진을 추가하세요',
        'YOU_CAN_ADD_YOUR_OWN_PHOTOS' => '%2$s에 <a %1$s>회원님의 사진</a>을 추가할 수 있습니다!',
        'UPLOAD_PHOTOS_FROM' => '회원님의 컴퓨터에서 사진을 업로드하세요:',
        'ADD_TITLE_AND_DESCRIPTION_FOR_PHOTOS' => '사진 제목과 내용 설명을 추가하세요',
        'EDIT_PHOTO_INFORMATION' => '사진 정보 편집',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_1' => '회원님이 업로드한 사진들의 제목, 설명 내용 및 기타 정보를 추가하세요.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_2' => '회원님이 업로드한 이 사진의 제목, 설명 내용 및 기타 정보를 추가하세요.',
        'CANCEL_AND_RETURN_TO_PHOTO' => '취소하고 사진으로 돌아가기',
        'WHO_CAN_VIEW_PHOTO' => '누가 이 동영상을 볼 수 있나요?',
        'CAN_BE_VIEWED_BY' => '다음 사람들에게 보기 허용:',
        'BY_ME' => '<a %s>나</a>만 허용',
        'RSS_FEED_LABEL' => '<a %s>RSS 피드</a> –  %s',
        'NO_PHOTOS_AWAITING_APPROVAL' => '현재는 승인을 기다리는 사진이 없습니다.  볼 거리를 찾고 있다면 <a %s>최신 사진</a>을 둘러보시는 것이 어떨까요?',
        'APPROVE_ALL_PHOTOS' => '모든 사진을 승인할까요?',
        'ARE_YOU_SURE_APPROVE_ALL_PHOTOS' => '모든 사진을 승인하기 원하시는 것이  확실합니까?  완료하는 데 몇 분 정도 소요될 수 있습니다.',
        'DELETE_ALL_PHOTOS' => '모든 사진을 삭제할까요?',
        'ARE_YOU_SURE_DELETE_ALL_PHOTOS' => '승인되지 않은 사진을 모두 삭제하기 원하는 것이 확실합니까?  완료하는 데 몇 분 정도 소요될 수 있습니다.',
        'KEEP_WINDOW_OPEN_PHOTOS_APPROVED' => '사진을 승인하는 동안 이 브라우저 창을 계속해서 열어놓으세요.  몇 분 정도 소요될 수 있습니다.',
        'KEEP_WINDOW_OPEN_PHOTOS_DELETED' => '사진을 삭제하는 동안 이 브라우저 창을 계속해서 열어놓으세요.  몇 분 정도 소요될 수 있습니다.',
        'APPLY_TO_PHOTOS_ADDED_BY' => '%s님이 추가한 모든 사진에 적용',
        'NO_ONE_HAS_ADDED_ANY_PHOTOS' => '회원님의 사교 네트워크에는 아직 아무도 사진을 추가하지 않았군요.  일착으로 <a %s>사진을 추가하세요. </a>',
        'UNTITLED' => '제목 없슴',
        'A_PROBLEM_OCCURRED' => '오류가 발생했습니다',
        'PHOTOS_EXCEEDED_LIMIT' => '사진(들)이 사진 당 최대 용량 한도인 10 MB를 초과한 것 같습니다.',
        'GET_A_SLIDESHOW_OF' => '%s님의 슬라이드쇼 보기',
        'GET_A_SLIDESHOW' => '슬라이드쇼 보기!',
        'GET_SLIDESHOW_OF_PHOTOS' => '이 사진들의 슬라이드쇼 보기',
        'COPY_AND_PASTE_SLIDESHOW' => '아래의 코드를 복사해서 붙여 넣어 회원님의 웹사이트나 MySpace 페이지 또는 Ning 네트워크에서 이 사진들을 슬라이드쇼로 구성하세요.',
        'COPY_AND_PASTE_SLIDESHOW_OF_ALBUM' => '아래의 코드를 복사해서 붙여 넣어 회원님의 웹사이트나 MySpace 페이지 또는 Ning 네트워크에서 이 앨범을 슬라이드쇼로 작성하세요.',
        'LARGE_VERSION' => '확대 버전',
        'SMALL_VERSION' => '축소 버전',
        'VIEW_SLIDESHOW_FULL_SIZE' => '이 슬라이드쇼를 확대 버전으로 보기',
        'PHOTOS' => '사진',
        'XS_PHOTOS' => '%s님의 사진',
        'XS_PHOTO' => '%s 님의 사진',
        'YOU_CAN_MARK_PHOTO' => '어떤 사진이든 즐겨찾기에 지정할 수 있습니다.  사진 상에 나타나는 “즐겨찾기에 추가” 아이콘이 보이면 그 아이콘만 클릭하면 됩니다.',
        'VIEW_RECENT_PHOTOS' => '최근 사진 보기',
        'APPROVE_PHOTOS' => '사진 승인',
        'DELETE_ALL_XS_PHOTOS_Q' => '%s님의 모든 사진을 삭제할까요?',
        'ARE_YOU_SURE_DELETE_ALL_XS_PHOTOS' => '%s의 모든 사진을 삭제하기 원하는 것이 확실합니까?  몇 분 정도 소요될 수 있습니다.',
        'REMOVE_X_AND_ALL_CONTENT' => '%1$s님과 %1$s님의 컨텐츠를 회원님의 사교 네트워크에서 삭제',
        'SUCCESS' => '완료.',
        'DELETING_CONTENT' => '컨텐츠 삭제 중...',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED' => '컨텐츠를 삭제하는 동안 이 브라우저 창을 계속해서 열어놓으세요.  몇 분 정도 소요될 수 있습니다.',
        'KEEP_WINDOW_OPEN_MEMBERS_DELETED' => '회원들을 삭제하는 동안 이 브라우저 창을 계속해서 열어놓으세요.  몇 분 정도 소요될 수 있습니다.',
        'DELETE_ALL_XS_PHOTOS' => '%s님의 모든 사진 삭제',
        'CREATE_A_NEW_ALBUM' => '새 앨범 작성하기',
        'VIEW_ALL_XS_ALBUMS' => '%s님의 모든 앨범 보기',
        'YOU_HAVE_NOT_ADDED_PHOTOS_2' => '회원님은 아직 사진을 한 장도 추가하지 않았습니다.  사진을 추가해 시작하세요!',
        'X_HAS_NOT_ADDED_PHOTOS' => '%s님은 아직 사진을 한 장도 추가하지 않았습니다.',
        'MY_FRIENDS_PHOTOS' => '나의 친구의 사진',
        'VIEW_PHOTOS_IN_SLIDESHOW' => '이 사진들을 슬라이드쇼로 보세요!',
        'YOUR_FRIENDS_DO_NOT_HAVE_PHOTOS' => '회원님의 친구들은 아직 사진을 추가하지 않았습니다',
        'ALL_PHOTOS_TAGGED_X' => '\'%s\'로 태그된 모든 사진',
        'ALL_PHOTOS_TAGGED_X_2' => '<em>\'%s\'</em>로 태그된 모든 사진',
        'NO_PHOTOS_TAGGED_X_CHECK_OUT' => '"%1$s"로 태그된 사진이 없습니다.  <a %2$s> "%1$s"로 태그된 토론</a> 또는 <a %3$s> "%1$s"로 태그된 동영상</a>을 한 번 둘러 보세요.  또는 회원님의 사진을 추가하거나 태그하세요!',
        'SELECT_YOUR_PHOTOS' => '회원님의 사진을 선택하세요',
        'PHOTO_MAY_BE_10MB' => '각 사진의 크기는 10MB까지 허용되지만 사진의 크기가 작을수록 업로드 시간이 빨라집니다. .jpg, .gif 와 .png 파일 형식의 사진을 지원합니다.',
        'KEEP_PAGE_OPEN_PHOTOS' => '저희가 회원님의 사진을 완전히 업로드할 때까지 이 페이지를 열어놓고 기다리시면 승인이 되는대로 알려드리겠습니다!',
        'MEANWHILE_FEEL_FREE_PHOTOS' => '그 동안 <a %s>새 브라우저 창을 열고</a> %s을 이용하세요.  업로드가 완료되면 이 창에서 회원님의 사진 제목과 내용 설명을 추가할 수 있습니다.',
        'PHOTO_IS_WAITING_FOR_APPROVAL' => '이 사진은 %s 운영자의 <strong>승인을 기다리고 있습니다.</strong>',
        'ADD_TO_FAVORITES' => '즐겨찾기에 추가',
        'EDIT_PHOTO' => '사진 편집',
        'DELETE_PHOTO' => '사진 삭제',
        'ABOUT_THIS_PHOTO' => '이 사진 정보',
        'LOCATION_OF_PHOTO' => '이 사진의 위치:',
        'ALBUMS_FEATURING_PHOTO' => '이 사진이 수록되어 있는 모든 앨범',
        'VIEW_ALBUMS_WITH_PHOTO' => '이 사진이 수록되어 있는 모든 앨범 보기',
        'RETURN_TO_X' => '%s로 돌아가기',
        'RETURN_TO_PHOTOS_HOME' => '사진 홈으로 돌아가기',
        'WE_COULD_NOT_FIND_ANYONE' => '죄송합니다 – 아무도 찾지 못했습니다',
        'NOBODY_HAS_ADDED_PHOTOS' => '아직 아무도 사진을 추가하지 않았습니다!  사진을 추가해 시작하세요.',
        'DEFAULT_TITLE' => '제목',
        'DEFAULT_DESCRIPTION' => '내용 설명',
        'UPLOAD_LIMIT_EXCEEDED' => '업로드 파일 용량 한도가 초과됐습니다.',
        'SLOW_DOWN_THERE_CHIEF' => '죄송합니다',
        'I_DO_NOT_KNOW_USER' => '죄송합니다, 모르는 사람입니다.',
        'I_DO_NOT_HAVE_PHOTO' => '죄송합니다, 이 사진을 갖고 있지 않습니다.',
        'I_DO_NOT_HAVE_ALBUM' => '죄송합니다, 이 앨범이 없습니다.',
        'ALBUM_BY_X_ON_X' => '%s에 수록된 %s의 앨범',
        'SENT' => '전송 완료!',
        'I_HAVE_RECENTLY_ADDED' => '나의 최근 추가항목',
        'FROM_THE_BAZEL' => '이 네트워크의 콘텐츠',
        'RECENTLY_ADDED' => '최근 추가 항목',
        'RECENT_PUBLIC_PHOTOS_ON_X' => '%s의 최근 공개 사진',
        'X_ALL_PHOTOS' => '%s – 모든 사진',
        'NO_TAG_WAS_SPECIFIED' => '태그를 지정하지 않았습니다',
        'PUBLIC_PHOTOS_TAGGED_WITH_X' => '%s의 %s로 태그된 공개 사진',
        'XS_PUBLIC_PHOTOS_ON_X' => '%s에 게시된 %s의 공개 사진',
        'WE_DO_NOT_KNOW_USER' => '이 사람을 알지 못합니다.',
        'XS_FRIENDS_PHOTOS' => '%s님의 친구의 사진',
        'XS_FAVORITE_PHOTOS_ON_X' => '%s에 게시된 %s님의 즐겨찾기 지정 사진',
        'PHOTO_UPLOADED_ON_X' => '%s에 업로드된 사진',
        'FILE_EXCEEDED_MAXIMUM_SIZE' => '파일 용량이 한도를 초과하였습니다',
        'PART_OF_FILE_WAS_UPLOADED' => '파일의 일부분만이 업로드됐습니다',
        'NO_FILE_WAS_UPLOADED' => '업로드가 실패했습니다;  파일명에 오류가 있을 수 있습니다',
        'PROBLEM_OCCURRED_DURING_UPLOAD' => '업로드 중 문제가 발생했습니다.',
        'ALPHABETICAL' => '알파벳 순',
        'MOST_VIEWS' => '최다 조회',
        'RATING_NOT_RATED_YET' => '<strong>추천도:</strong> 아직 평가 없음',
        'NOT_RATED_YET' => '</strong> 아직 평가 없음',
        'HMM_SOMETHING_WENT_AWRY' => '흠...뭔가 잘못된 것 같네요.',
        'YOUR_PHOTO_TITLED_X_COULD_NOT' => '회원님의 “%s” 라는 제목의 사진은 %s에 추가되지 못했습니다',
        'YOUR_PHOTO_COULD_NOT_BE_ADDED' => '회원님의 사진은 %s에 추가되지 못했습니다',
        'YOU_JUST_TRIED_TO_SEND' => '회원님은 조금 전에 %s에 사진을 전송하려 하셨습니다.  죄송하지만 회원님은 %s의 회원이 아니므로 저희로서는 이 사진을 전달할 길이 없군요.',
        'ONLY_MY_FRIENDS' => '나의 친구만',
        'ANYBODY' => '누구든',
        'ONLY_MY_FRIENDS_CAN_SEE_PHOTO' => '나의 친구만 이 사진을 볼 수 있게 하기',
        'ONLY_XS_FRIENDS_CAN_SEE_PHOTO' => '%s님의 친구만 이 사진을 볼 수 있게 하기.',
        'ONLY_I_CAN_SEE_PHOTO' => '나만 이 사진을 볼 수 있습니다',
        'ONLY_X_CAN_SEE_PHOTO' => '%s님만 이 사진을 볼 수 있습니다',
        'EVERYONE_CAN_SEE_PHOTO' => '모든 사람이 이 사진을 볼 수 있습니다',
        'PRIVATE_PHOTO' => '<strong>비공개</strong> 사진',
        'HOWDY_STRANGER' => '처음 뵙는 것 같네요!',
        'YOU_NEED_TO_BE_SIGNED_IN' => 'Ning에 로그인하셔야만 사용이 가능합니다.',
        'JUST_CLICK_ON_SIGN_IN' => '위쪽에 있는 “로그인”을 버튼을 클릭하거나 아직 Ning 계정이 없는 경우라면 “가입”을 클릭하세요.',
        'YOU_NEED_TO_BE_' => '%s이어야만 이용가능한 기능입니다.',
        'YOU_NEED_TO_BE_OWNER' => '네트워크 개설자여야만 사용 가능한 기능입니다.',
        'THAT_PHOTO_IS_AWAITING_APPROVAL' => '업로드한 동영상은 승인 대기 중입니다.',
        'YOU_NEED_TO_BE_A_FRIEND' => '%s님의 친구만 사용 가능한 기능입니다.',
        'MOST_ACTIVE' => '가장 활동적인 회원',
        'HOW_IT_WORKS' => '사용 방법',
        'MORE_WAYS_TO_ADD_PHOTOS' => '기타 사진 추가 방법...',
        'BY_PHONE_OR_EMAIL' => '...전화나 이메일로',
        'FROM_FLICKR' => '...Flick에서',
        'FROM_YOUR_COMPUTER' => '...회원님의 컴퓨터에서',
        'ADD_PHOTOS_FROM_YOUR_FLICKR' => '회원님의 Flickr 계정에서 추가.',
        'MORE_INFORMATION' => '추가 정보',
        'ADD_PHOTOS_BY_PHONE_OR_EMAIL' => '전화나 이메일로 사진 추가',
        'SEND_ONE_PHOTO_OR_VIDEO' => '이메일 당 1개의 사진이나 동영상을 보내기.  이메일의 제목이 사진이나 동영상의 제목이 되고 이메일 본문은 내용이 됩니다.',
        'CLICK_HERE_TO_GET_A_NEW_UNIQUE' => '여기를 클릭해 새 이메일 주소를 받으세요',
        'UPLOAD_PHOTOS_FROM_YOUR' => '회원님의 컴퓨터에서 사진을 업로드하세요.',
        'PHOTO' => '사진',
        'YOUVE_SET_THE_NUMBER_OF_PHOTOS' => '회원님은 현재 사진을 게시하지 않고 있습니다.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_PHOTO' => '최소한 1개의 사진을 선택할 때까지 다른 사람들은 이 상자를 볼 수 없습니다.',
        'THERE_IS_NEW_COMMENT_ON_PHOTO_X' => '%s에 올린 회원님의 “%s” 사진에 새로운 답글이 올라 있습니다',
        'THERE_IS_NEW_COMMENT_ON_PHOTO' => '%s에 올린 회원님의 사진 중 하나에 새로운 답글이 올라 있습니다',
        'SOMEBODY_COMMENTED_PHOTO_ADDED_TO_X' => '회원님이 %s에 추가한 사진 하나에 누군가가 코멘트를 올렸습니다',
        'SOMEBODY_UPLOADED_PHOTO_TO_X' => '누군가가 %s에 사진을 업로드했습니다',
        'ADD_PHOTOS_OR_VIDEOS_TO_X' => '회원님의 전화에서 직접 사진과 동영상을 보내 %s에 사진이나 동영상을 추가하세요.',
        'DO_YOU_REALLY_WANT_TO_REMOVE' => '회원님의 즐겨찾기에서 이 항목을 정말로 제거하기 원하세요?',
        'DELETE_THIS_PHOTO_Q' => '이 사진을 삭제할까요?',
        'ARE_YOU_SURE_DELETE_THIS_PHOTO' => '이 사진을 정말로 삭제하기 원하세요?  몇 분 정도 소요될 수 있습니다.',
        'PHOTO_SLIDESHOW' => '슬라이드쇼',
        'THUMBNAILS' => '요약',
        'DETAIL' => '세부 내용',
        'TAG' => '꼬리표',
        'RATE' => '추천하기',
        'ALL_SIZES' => '모든 크기',
        'ADD_TO_ALBUM' => '앨범에 추가',
        'ROTATE_PHOTO' => '사진 회전시키기',
        'ABOUT_YOUR_PHOTO' => '회원님의 사진 정보',
        'SEE_PHOTOS_ON_NETWORK' => '이 사진들을 %s에서 보기',
        'EMBED_CODE' => '코드 뭍기',
        'IMPORT_PHOTOS_FLICKR' => 'Flickr에서 회원님의 사진 가져오기',
        'CLICK_HERE_TO_CONTINUE_TO_FLICKR' => '여기를 클릭해 Flickr로 가기',
        'TO_GET_YOUR_PHOTOS_FROM_FLICKR' => 'Flickr에서 회원님의 사진을 가져오려면  %s를 Flickr 계정에 링크할 수 있도록 먼저 허용해야 합니다.',
        'IMPORT_PHOTOS' => '사진 가져오기',
        'GET_MY' => '나의 콘텐츠 가져오기:',
        'GET_PHOTOS' => '사진 가져오기',
        'MOST_RECENT_PHOTOS' => '가장 최근 사진',
        'GET_ALL_MY_FLICKR' => 'Flickr상의 나의 모든 사진 가져오기 (상장 정도의 시간이 소요될 수 있습니다)',
        'GET_ALL_MY_TAGGED' => '나의 모든 사진 태그하기',
        'GET_PHOTOS_FROM_SET' => '세트에서 사진 가져오기:',
        'GET_STARTED_BY_IMPORT' => '저희가 자동으로 회원님이 갖고 있는 회원님의 제목, 태그와 모든 매핑 정보를 가져오게 됩니다. <br/>얼마나 시간이 소요됩니까? </p> <p><ul style="padding-top:10px; "><li>사진 10장: <em>30초 미만</em>. "><li>사진 50장: <em>약 2분</em>. </li><li>사진 200장: <em>약 6분</em>. </li><li>사진 500장: <em>약 15분</em>. </li></ul>',
        'IF_YOURE_NOT_SIGNED_IN' => 'Flickr에 로그인하지 않은 상태이면 로그인 요청을 받으실 겁니다.  일단 로그인하면 “OK, 허용합니다”라고 적힌 버튼을 클릭하세요.',
        'GET_MY_FLICKR_PHOTOS_DESCRIPTIONS' => '내용도 가져오기(소요 시간이 배로 늘어납니다).',
        'PLEASE_KEEP_THIS_PAGE_OPEN_WHILE_IMPORT' => '저희가 회원님의 사진 가져오기 작업을 완료할 수 있도록 이 페이지를 계속해서 열어 놓으세요.',
        'GET_MY_FLICKR_PHOTOS_ORIGINALS' => '각 사진의 본래 규격 버젼의사진을 가져오기(가져오기에 소요되는 시간이 상당히 늘어나며 사진이 20장을 초과할 경우에는 권유되지 않는 방법입니다).',
        'MAKE_YOUR_X_PAGE_YOUR_OWN' => '“편집”을 클릭해 텍스트, 동영상, 사진이나 다른 위짓을 이 상자에 추가하세요.  회원님의 %s 페이지를 당신만의 고유한 페이지로 가꿀 수 있는 또 하나의 방법이랍니다.',
        'BOX_WILL_NOT_SHOW_UNTIL_UPDATE_CONTENT' => '페이지의 컨텐츠를 업데이트할 때까지 다른 사람은 이 상자를 볼 수 없습니다.',
        'YOUR_X_BOX' => '회원님의 %s 상자',
        'ABOUT_WIDGETS' => '위짓 정보',
        'HELP' => '도움말',
        'WIDGETS' => '위짓',
        'LOOKING_TO_ADD_FUNCTIONALITY' => '회원님의 사교 네트워크에 더 많은 기능을 추가하기 원하세요?  달력, 현지 날씨, 이벤트 카운트다운이나 웹캠을 추가하고 싶으세요?  위짓을 이용하면 회원님 네트워크의 어느 상자에든 손쉽게 다양한 기능을 추가할 수 있습니다.',
        'GETTING_STARTED' => '시작하기',
        'BELOW_IS_LIST_OF_WIDGET' => '아래는 회원님이 검토해 볼 만한  <a %s> 위짓 제공업체의 목록입니다.</a>  회원님이 손쉽게 시작할 수 있게 저희가 <a %s>yourminis com</a>에서 몇 개의 위짓을 골라 보았습니다.  아래와 같은 위짓을 설정하고, 임베드 코드를 복사해서 텍스트 상자 안에 직접 붙여 넣으세요.  한 번 해 보자구요!',
        'CALENDAR' => '달력',
        'CALENDAR_WIDGET_ALLOWS_SEARCH' => '달력 위짓은 날짜만 표시할 뿐 아니라 iCal 포맷 이벤트(Google Calendar 및 다른 많은 온라인 달력 제공업체가 사용)를 검색하고 추가할 수 있게 합니다.',
        'USE_EDIT_WIDGET_BUTTON_CALENDAR' => '&#8220 위짓 편집 &#8221;  버튼을 이용하여 &#8220 이벤트 검색 &#8221;을 선택한 후,  검색어(공휴일, 스포츠 팀 등 )를 입력하세요.  다음 단계로, 검색 결과를 선택해 해당 이벤트를 회원님의 달력에 추가하시면 됩니다.  아울러 기존의 모든 iCal 피드의 주소를 수기 입력할 수 있습니다.',
        'CUSTOMIZATION' => '맞춤형 설정',
        'YOU_CAN_CUSTOMIZE_WIDGET' => '마우스를 이용해 컬러선택기 아이콘을 클릭해서 배경색, 위짓 스타일과 투명도를 바꿔 위짓의 디자인을 개인취향에 맞게 설정할 수 있습니다.  설정이 끝나고 나면, &#8220; 웹으로 복사하기&#8221; 링크를 클릭하고, &#8220; 코드 임베드 복사&#8221; 버튼을 눌러 주시면 됩니다.  코드가 복사되면 회원님 네트워크의 텍스트 상자로 돌아가서 코드를 붙여 넣고 변경사항을 저장하세요.  완료입니다!',
        'GET_MORE_WIDGETS_FROM_YOURMINIS' => 'yourminis.com에서 더 많은 위짓을',
        'WEATHER' => '날씨',
        'WEATHER_WIDGET_DISPLAYS' => '날씨 위젯은 Weather Channel에서 제공하는 현지 날씨를 표시합니다.',
        'USE_EDIT_WIDGET_BUTTON_WEATHER' => '&#8220 위짓 편집 &#8221;  회원님이 계신 곳을 선택한 후, 화씨와 섭씨 중 어떤 쪽이든 선택하시면 됩니다.  오늘의 날씨만을 표시하거나 5일 일기예보로 확장할 수 있습니다.',
        'COUNTDOWN' => '카운트다운',
        'COUNTDOWN_WIDGET_LETS_YOU' => '카운트다운 위짓은 특정 이벤트에 대한 카운트다운을 설정하게 합니다.  &#8220버튼을 클릭하면; 위짓 편집 &#8221;  날짜, 시간, 제목이나 카운트다운 이벤트의 이미지를 입력할 수 있습니다.',
        'WEBCAM' => '웹캠',
        'WEBCAM_WIDGET_ALLOWS_YOU' => '웹캠 위짓을 이용해 공개된 웹캠을 능동적으로 모니터링할 수 있습니다.  &#8220 사용; 위짓 편집 &#8221;  버튼을 사용하여 사전 정의된 웹캠 목록에서 선택하거나 웹캠의 URL을 수기로 입력하세요.',
        'MORE_WIDGETS' => '추가 위짓',
        'NEED_MORE_OPTIONS' => '더 많은 옵션이 필요하세요?  회원님의 위짓 욕심을 충족시키시려면 다음과 같은 사이트로 찾아가 보세요:',
        'MODERATION_DENIED_ON_X' => '%s에 검토 후 %가 거부됐습니다',
        'MODERATION_DENIED_ON_A_X' => '%s에 검토 후 회원님의 %s가 거부됐습니다',
        'YOU_HAVE_NEW_X_TO_MODERATE' => '검토할 신규 %s가 %s에 있습니다',
        'NEW_X_TO_MODERATE' => '회원님이 검토할 신규 %s가 있습니다.',
        'MODERATION_APPROVED_ON_X' => '%s가 검토 후, %에 승인됐습니다',
        'MODERATION_APPROVED_ON_A_X' => '%s에 회원님의 %s가 검토 후, 승인됐습니다',
        'JOIN' => '가입하다',
        'WELCOME' => '환영',
        'WELCOME_TO_X' => '%s에 방문하신 것을 환영합니다',
        'WELCOME_TO_X_ELLIPSIS' => '%s에 방문하신 것을 환영합니다...',
        'RSS_LINK' => '<a %s>RSS</a>',
        'NEW_FEATURES_GROUPS_MUSIC' => '<h3 style="margin-top:0">새 기능! </h3>
            <ul><li><strong>그룹</strong> &ndash;  회원님의 가입자들이 네트워크 내에 그룹을 개설할 수 있게 합니다</li>
 <li><strong>뮤직 플레이어</strong> &ndash;  회원님의 네트워크에 음악과 포드캐스트를 추가하세요</li></ul>
<p><a href="%s" class="desc add">여기를 클릭해 기능을 추가하세요</a></p>',
        'NEW_FEATURES_ACTIVITY_BADGES' => '<h3 style="margin-top:0">새 기능! </h3>
            <ul><li><strong>최근 활동 내용</strong> &ndash;  회원님 네트워크의 최근의 회원 활동 내용을 확인하세요</li>
                <li><strong>뱃지와 위짓</strong> &ndash;  맞춤형 뱃지와 위짓을 이용해 회원님의 네트워크를 웹 전반에 걸쳐 홍보하세요</li></ul>
 <p><a href="%s" class="desc add">여기를 클릭해 기능을 추가/편집하세요</a></p>',
        'YOUR_TYPE_NAME_HAS_NEW_COMMENT_APPNAME' => '%3$s의 누군가가 회원님의 %2$s인 %1$s에 새 코멘트를 달았습니다!',
        'YOUR_TYPE_HAS_NEW_COMMENT_APPNAME' => '%2$s에 누군가가 회원님의 %1$s에 대해 새 코멘트를 달았습니다!',
        'HERE_IS_LINK' => '가입 링크입니다: <a %s>%s</a>',
        'THANKS_VALEDICTION' => '감사합니다,',
        'THANKS' => '감사합니다!',
        'YOU_CHANGED_YOUR_EMAIL_ON_X' => '회원님이 %s 상의 자신의 이메일 주소를 변경하였습니다.',
        'YOU_CHANGED_YOUR_EMAIL_ON_X_ELLIPSIS' => '회원님이 %s 상의 자신의 이메일 주소를 변경하였습니다....',
        'CLICK_HERE_TO_SIGN_IN_WITH_YOUR_NEW_EMAIL_ADDRESS' => '여기를 클릭해 회원님의 새 이메일 주소로 로그인하세요:',
        'IF_DID_NOT_CHANGE_EMAIL_ADDRESS' => '이메일 주소를 변경하지 않았다면 여기를 클릭하세요:',
        'TO_STOP_BEING_NOTIFIED_OF_NEW_DISCUSSIONS_GO_TO' => '새 토론에 대한 통지를 더 이상 받고 싶지 않으시면 다음으로 가세요:',
        'X_STARTED_DISCUSSION_ON_APPNAME_ELLIPSIS' => '%1$s님이 %2$s에서 새 토론을 시작했습니다...',
        'X_STARTED_THE_DISCUSSION_Y' => '%1$s님이 "%2$s"에서 토론을 시작했습니다',
        'TO_VIEW_THIS_DISCUSSION_GO_TO' => '이 토론을 보려면 다음으로 가세요:',
        'X_HAS_INVITED_YOU_TO_JOIN_Y' => '%s님이 회원님에게 %s에 가입하도록 초대했습니다!',
        'X_WANTS_YOU_TO_CHECK_OUT_Y' => '%s님이 회원님께서 %s의 “%s”을 둘러 보시도록 요청합니다!',
        'CHECK_OUT_TITLE_ON_APPNAME' => '“%s”의 %s을 한 번 둘러 보세요!',
        'ABOUT_X' => '%s정보',
        'YOU_HAVE_RECEIVED_BECAUSE_X' => '% 때문에 이 이메일을 받으셨습니다',
        'IF_YOU_NO_LONGER_WISH_FROM_X_CLICK_Y' => '%s에서 더 이상 이메일을 받고 싶지 않으시면 <a %s>여기를 클릭</a>하세요.',
        'CLICK_HERE' => '여기를 클릭',
        'YOU_CAN_CONTACT_US' => '회원님의 개인정보보호와 관련해 질문이나 우려되는 사항이 있으시면 저희에게http://help.ning.com/?page_id=27 으로 연락주세요.',
        'MESSAGE_TO_ALL_MEMBERS_OF_X' => '%s의 회원 전원에게 메시지 전송',
        'CLICK_TO_CHECK_OUT' => '여기를 클릭해 확인해 보세요!',
        'CLICK_TO_APPROVE_X' => '여기를 클릭해 이 %s을 승인/삭제하세요',
        'YOUR_X_HAS_BEEN_APPROVED' => '회원님의 %s가 %s에서 승인되었습니다!',
        'YOUR_X_WAS_NOT_APPROVED' => '회원님의 %s가 %s 에서 승인되지 않았습니다.',
        'CLICK_TO_VIEW_X' => '여기를 클릭해서 이 %s을 보세요!',
        'CLICK_TO_VIEW_IT' => '보시려면 여기를 클릭하세요!',
        'TO_VIEW_USER_PROFILE_VISIT' => '%s님의 프로필을 보려면 다음으로 가세요:',
        'YOU_ADDED_CONTENT' => '사전 승인이 요구되는 사교 네트워크인 %s에 컨텐츠를 추가하셨습니다',
        'X_REPORTED_AN_ISSUE_ON_Y_ELLIPSIS' => '%2$s에서 %1$s 님이 문제를 접수하였습니다...',
        'X_REPORTED_THE_FOLLOWING_ISSUE' => '%s님이 다음의 사안에 대해 신고했습니다.',
        'URL_REPORTED_COLON' => '신고된 URL:',
        'ISSUE_COLON' => '사안:',
        'ADDITIONAL_INFORMATION_COLON' => '추가 정보:',
        'SEND_AN_INVITATION_TO_X' => '%s에게 초대장 전송',
        'SOMEBODY_REQUESTED_JOIN_X' => '%s에 가입을 희망하는 사람이 있습니다',
        'WANT_TO_ADD_A_WELCOME_MESSAGE_FOR_X_ON_THEIR_PROFILE_GO_TO' => '%s을 위한 환영 메시지를 그들의 프로필에 추가하시겠습니까?   다음으로 이동:',
        'USER_HAS_SENT_YOU_A_MESSAGE' => '%s님이 회원님에게 메시지를 보냈습니다.',
        'TO_READ_THIS_MESSAGE_VISIT' => '이 메시지를 읽으려면, 다음으로 이동하세요:',
        'X_HAS_SENT_YOU_A_MESSAGE_ON_Y_ELLIPSIS' => '%s님이 %에 회원님에게 메시지를 보냈습니다...',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ELLIPSIS' => '%s님이 회원님을 친구로 추가했습니다...',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ON_Y' => '%s님이 %s에서 회원님을 친구로 추가했습니다...',
        'X_HAS_ACCEPTED_YOUR_FRIEND_REQUEST' => '%s가 %s에서 회원님의 친구만들기 신청을 받아들였습니다!',
        'TO_ACCEPT_THIS_FRIEND_REQUEST_VISIT' => '이 친구만들기 신청을 받아들이시려면 다음으로 이동하세요:',
        'VIEW_XS_PAGE_ON_Y' => '%s의 페이지를 %s에서 보기',
        'MEMBER_OF_X_ACCEPTED' => '%s의 가입자가 회원님의 친구만들기 신청을 받아들였습니다',
        'IF_NO_LONGER_WISH_FRIEND_NOTIFICATION_EMAIL_FROM_X_CLICK_Y' => '%s에서 더 이상 친구만들기 신청 통지를 받고 싶지 않으시면 <a %s>여기를 클릭하세요</a>.',
        'YOU_RECEIVED_INVITATION_FROM_X' => '%1$s의 한 회원이 회원님을 초대했습니다.  더 이상 %1$s로부터 초대를 받고 싶지 않으시면 다음 페이지에서 저희에게 연락하세요http://help.ning.com/?page_id=27 .',
        'ON_X_COLON' => '%s에:',
        'ON_X' => '%s에',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP' => '%s님이 %s에 가입을 신청했습니다.',
        'USER_HAS_INVITED_YOU_TO_JOIN_THE_GROUP_X' => '%1$s님이 회원님을 그룹 "%2$s"에 초대했습니다',
        'VISIT_GROUP_AT' => '다음에서 %s를 방문하세요:',
        'ABOUT_GROUP' => '%s정보',
        'A_MESSAGE_FROM_USERNAME_TO_GROUPNAME_ON_APPNAME' => '%s님이 %s 회원 전원에게 전체 메시지를 %s에 보냈습니다!',
        'YOU_CAN_SIGN_IN_USING_EMAIL_HERE' => '회원님의 이메일 주소를 이용해 여기서 로그인할 수 있습니다:',
        'USERNAME_COMMENTED_ON_BLOG_POST_TITLE_APPNAME' => '%s님이 블로그 ‘%s’ 게시물에 대해 %s에 코멘트를 달았습니다',
        'SEND_X_A_MESSAGE_HERE' => '여기에서 %s님에게 메시지를 보내세요:',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X_ELLIPSIS' => '%s에서 승인을 기다리고 있는 신규 가입 회원이 있습니다...',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE' => '승인을 기다리고 있는 신규 가입 회원이 있습니다.',
        'TO_APPROVE_XS_PROFILE_VISIT' => '%s님의 프로필을 승인하려면 다음으로 이동하세요:',
        'CANT_CLICK_CUT_AND_PASTE' => '위의 링크를 클릭해도 아무런 변화가 없습니까?  회원님의 웹 브라우저에 URL을 복사해서 붙여 넣으세요.',
        'CLICK_HERE_TO_JOIN_COLON' => '여기를 클릭해서 가입하세요:',
        'CLICK_HERE_TO_JOIN_BANG' => '여기를 클릭해서 가입하세요!',
        'YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED_ELLIPSIS' => '회원님의 %s 가입 신청이 승인되었습니다...',
        'CONGRATULATIONS_BANG_YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED' => '축하합니다!   회원님의 %s 가입 신청이 승인되었습니다.',
        'YOU_CAN_NOW_SIGN_IN_USING_YOUR_EMAIL_ADDRESS_HERE' => '지금 회원님의 이메일 주소를 이용해 여기에서 로그인할 수 있습니다:',
        'VISIT_X_AT_Y' => '다음으로 %s를 방문하세요: %2$s',
        'TO_CONTROL_WHICH_EMAILS_YOUR_RECEIVE_ON_X_GO_TO' => '%1$s에서 받을 메일을 설정하려면 다음으로 이동하세요:',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_ELLIPSIS' => '%s에 금지된 회원이 회원님에게 메시지를 보냈습니다...',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_USERNAME_WRITES' => '%1$s에 금지된 회원이 회원님에게 메시지를 보냈습니다.   %2$s님의 글:',
        'WELCOME_TO_THE_GROUP_X' => '“%s” 그룹에 오신 것을 환영합니다.',
        'WELCOME_TO_GROUP_X_ON_Y_ELLIPSIS' => '%2$s의 %1$s에 오신 것을 환영합니다...',
        'TO_VIEW_THIS_GROUP_VISIT' => '이 그룹을 보려면 다음으로 이동하세요:',
        'X_INVITES_YOU_TO_JOIN_Y' => '%1$s님이 회원님을 %2$s에 초대했습니다.',
        'X_IS_NOW_A_MEMBER_OF_Y' => '%1$s님이 %2$s에 회원으로 가입했습니다.',
        'X_IS_NOW_A_MEMBER_OF_Y_ELLIPSIS' => '%1$s님이 %2$s에 회원으로 가입했습니다....',
        'SOMEBODY' => '누군가',
        'TO_VIEW_YOUR_NEW_COMMENT_VISIT' => '회원님의 새 코멘트를 보려면 다음으로 이동하세요:',
        'TO_VIEW_THE_NEW_COMMENT_VISIT' => '새 코멘트를 보려면 다음으로 이동하세요:',
        'TO_VIEW_THE_NEW_REPLY_VISIT' => '새 답글을 보려면 다음으로 이동하세요:',
        'WELCOME_TO_X_THANK_YOU_FOR_JOINING' => '%s에 오신 것을 환영합니다!  가입해 주셔서 감사합니다.',
        'NAME_COLON' => '이름:',
        'EMAIL_COLON' => '이메일:',
        'AGE_COLON' => '나이:',
        'GENDER_COLON' => '성별:',
        'LOCATION_COLON' => '위치:',
        'COUNTRY_COLON' => '국가:',
        'GET_NETWORK_BADGE' => '%s 뱃지',
        'SPREAD_WORD_GET_BADGE' => '널리 알려 주세요.  회원님의 웹사이트나 MySpace 페이지에 게시할 수 있는 %s 뱃지를 받으세요.  (<a %s>코드 가져오기</a>)',
        'SPREAD_WORD_GET_BADGE_SHORT' => '널리 알려 주세요.  <a href="%s">회원님의 %s 뱃지를 받으세요</a>',
        'SHOW_ALLEGIANCE_GET_BADGE' => '충성심을 과시하세요.  회원님의 웹사이트나 MySpace 페이지에 표시할 수 있는 %s 뱃지를 받으세요.  (<a %s>코드 가져오기</a>)',
        'USER_COMMENTED_ON_A_TYPE_ON_APPNAME' => '%1$s님이  %3$s에서 %2$s의 "%4$s"에 코멘트를 달았습니다',
        'UNABLE_TO_EXTRACT_EMAIL_ADDRESSES' => '죄송합니다 “ 파일에서 이메일 주소를 가져오지 못 했습니다.',
        'ADMINISTRATORS' => '운영자',
        'YOUR_INVITATION_HAS_EXPIRED' => '초대장이 만료되었습니다',
        'SORRY_INVITATION_EXPIRED' => '죄송합니다, 지금 사용하신 초대장은 만료되었습니다.   %s에 가입하려면 새로운 초대장이 필요합니다.',
        'DISABLE_INVITATION_LINK' => '초대 링크를 폐기할까요?',
        'CREATING_LINK_WILL_DISABLE' => '새로운 초대 링크를 만듦으로써 현재의 링크가 폐기됩니다.  새로운 링크를 생성하기 원하는 것이 확실합니까?',
        'SHARE_LINK_WITH_PEOPLE' => '이 링크를 이 네트워크에 가입하기 원하는 사람과 공유하세요:',
        'CREATE_INVITATION_LINK' => '새 초대 링크 생성',
        'PLEASE_SELECT_SECOND_PART' => '회원님의 이메일 주소의 두 번째 부분을 선택하세요, 예: gmail. com.',
        'AT_SYMBOL_NOT_ALLOWED' => '이메일 주소의 첫 부분에 @ 부호를 적지 않도록 유의하세요.',
        'SORRY_WE_DONT_SUPPORT' => '죄송합니다, Ning은 회원님의 이메일 주소에 연계된 웹 주소록을 지원하지 않습니다.  회원님의 컴퓨터에 저장되어 있는 주소를 사용하시려면 아래의 \'이메일 애플리케이션\'을 클릭해 보세요.',
        'PLEASE_ENTER_PASSWORD_FOR_EMAIL' => '%s의 비밀번호를 입력하세요.',
        'IMPORTING_ADDRESS_BOOK' => '주소록 가져오기',
        'LEAVE_WINDOW_WHILE_GET' => '친구의 이메일 주소를 가져오는 동안 <strong>이 창을 계속해서 열어 놓으세요.</strong>  완료되면 초대할 친구를 선택할 수 있습니다.',
        'SHARE_THIS_LINK' => '이 링크 공유:',
        'SEND_WITH_EMAIL_PROGRAM' => '회원님 컴퓨터의 이메일 프로그램으로 전송하세요:',
        'EMAIL_THIS' => '이메일로 전송',
        'IS_YOUR_FRIEND_PARENTHESIZED' => '(회원님의 친구입니다)',
        'CLEAR' => '비우기',
        'SEARCH_FRIENDS_TO_INVITE' => '초대할 친구 검색:',
        'YOUR_INVITATIONS_HAVE_BEEN_SENT' => '회원님의 초대장을 전송했습니다',
        'WANT_TO_INVITE_MORE' => '친구를 더 초대하시겠습니까?  회원님 자신의 웹 주소록이나 이메일 응용 프로그램에서 연락처 목록을 가져오심으로써 더 많은 친구를 초대하세요.',
        'MESSAGE_TOO_LONG' => '메시지가 너무 깁니다. 글자 수를 %s개 미만으로 줄이시기 바랍니다.',
        'FOLLOWING_DO_NOT_SEEM_VALID' => '다음은 유효한 이메일 주소가 아닌 것 같습니다.  초대장이 전송되지 않았습니다.  이메일 주소를 정정한 후 다시 시도하세요.',
        'PLEASE_ENTER_EMAIL_ADDRESSES' => '한 개 혹은 그 이상의 이메일 주소를 입력하세요.',
        'ENTER_EMAIL_ADDRESSES' => '이메일 주소 입력',
        'SEPARATE_MULTIPLE_ADDRESSES' => '여러 개의 주소를 입력하실 경우 쉼표로 분리하세요',
        'YOUR_MESSAGE_OPTIONAL' => '<label>회원님의 메시지</label>(선택사항)',
        'SEND_INVITATIONS' => '초대장 전송',
        'WEB_ADDRESS_BOOK' => '웹 주소록',
        'YAHOO_MAIL_HOTMAIL' => '야후 메일, 핫메일, G메일, 또는 AOL 메일',
        'YOUR_EMAIL_ADDRESS' => '회원님의 이메일 주소',
        'IMPORT_ADDRESS_BOOK' => '주소록 가져오기',
        'DONT_WORRY_WE_WONT_SAVE' => '걱정하실 필요가 없어요 -- 저희는 회원님의 비밀번호를 저장하지 않으며, 이메일을 보내고 싶은 친구를 선택할 기회를 충분히 드리거든요.',
        'EMAIL_APPLICATION' => '이메일 응용 프로그램',
        'MICROSOFT_OUTLOOK_APPLE_MAIL' => '마이크로소프트 아웃룩, 애플 메일, . CSV, 기타',
        'UPLOAD_CSV_OR_VCF' => '. csv 또는 . vcf 파일을 마이크로소프트 아웃룩이나 애플 주소록으로부터 가져오기를 실행해 업로드하세요.',
        'BROWSE_FOR_FILE' => '파일 찾기',
        'UPLOAD' => '업로드',
        'SELECT_ELLIPSIS' => '선택...',
        'OTHER_ELLIPSIS' => '기타...',
        'DONT_WORRY_YOULL_GET_CHANCE' => '이메일을 보내고 싶은 친구를 선택할 기회가 있으니 걱정하지 마세요.',
        'MEMBERSHIP_BY_INVITATION_ONLY' => '초대에 의해서만 가입이 가능합니다',
        'IF_YOU_ARE_ADMIN' => '운영자이면 <a %s>여기를 클릭해 로그인</a>하세요.',
        'NAME_MUST_BE_SHORTER' => '이름은 %s자 이하이어야 합니다',
        'CITY_NAME_MUST_BE_SHORTER' => '도시명은 %s자 이하이어야 합니다',
        'EMAIL_ALREADY_REGISTERED' => '이 이메일 주소는 이미 다른 사람에게 등록되어 사용중입니다.  다른 이메일을 선택하세요.',
        'EMAIL_NOT_VALID' => '다음은 유효한 이메일 주소가 아닌 것 같습니다.',
        'USERNAME_INVITED_YOU_TO_APPNAME' => '%s님이 회원님을 %s에 초대했습니다',
        'YOU_ARE_SIGNING_UP_WITH' => '회원님은 지금 Ning ID를 이용해 등록하고 있습니다.',
        'NOW_ENTER_PASSWORD' => '회원님의 비밀번호를 입력해 진행하세요.',
        'OR_SIGN_IN' => '또는 <a %s>로그인</a> 하세요',
        'CHANGE_ADDRESS' => '주소 변경',
        'CHANGE_PAGE_ADDRESS' => '페이지 주소 변경',
        'PAGE_ADDRESS_TAKEN' => '죄송합니다 – 입력한 주소는 이미 사용 중인 주소입니다.  다른 이메일을 선택하세요.',
        'PAGE_ADDRESS_NOT_VALID' => '알파벳 A-Z, 숫자와 밑줄(_)만 이메일 주소에 사용할 수 있습니다.',
        'ADD_BY_PHONE' => '전화로 추가',
        'PAGE_ADDRESS' => '페이지 주소',
        'PHOTO_MUST_BE_TYPE' => '회원님의 사진은 . jpg, . gif 또는 . png 파일이어야 합니다.',
        'USEFUL_ADDRESSES' => '알아 두면 도움이 되는 주소',
        'MY_DETAILS' => '나의 세부 세항',
        'NONE_I_DO_NOT_WANT' => '거부: %s로부터 어떠한 이메일 통지도 받고 싶지 않음',
        'CHANGE_PASSWORD' => '비밀번호 변경',
        'PROFILE_SAVED' => '변경 사항이 성공적으로 저장되었습니다.',
        'UPDATE_EMAIL_ADDRESS' => '이메일 주소 업데이트',
        'EDIT_EMAIL_ADDRESS' => '이메일 주소 편집',
        'MY_SETTINGS' => '나의 설정',
        'ABOUT_ME' => '나의 정보',
        'SELECT' => '선택...',
        'CITY' => '도시',
        'COUNTRY' => '국명',
        'DATE_OF_BIRTH' => '생년월일',
        'DO_NOT_DISPLAY' => '표시하지 않음',
        'GENDER' => '성별:',
        'CREATE_YOUR_PROFILE' => '본인의 프로필 개설',
        'SYSTEM_REQUIREMENTS' => '시스템 최소 사양',
        'WE_SUPPORT_INTERNET_EXPLORER' => '인터넷 익스플로어러 6과 7, 파이어폭스 1.5와 2.0, 사파리 2.0을 지원합니다. 다른 브라우저를 이용하고 계시면(인터넷 서비스 제공업체가 제공하는 브라우저 등) 호환되지 않을 수 있습니다.',
        'MAKE_SURE_COOKIES' => '브라우저의 쿠키와 자바스크립트 기능을 허용하도록 설정해 주세요.',
        'WHAT_IS_MY_EMAIL' => '나의 이메일 주소는 무엇입니까?',
        'IF_JOINED_BEFORE_OCTOBER' => '2007년 10월 5일 이전에 가입했을 경우, 이전엔 \'Ning ID\'를 입력하도록 요청받으셨을 것입니다.  이제는 회원님이 등록 시 사용했던 이메일 주소를 입력해 로그인하도록 설정되어 있지만 여전히 이 필드에 Ning ID를 입력해도 무방합니다.',
        'CLICK_HERE_TO_RESET_PASSWORD' => '여기를 클릭해 비밀번호를 재설정하세요.',
        'STILL_HAVING_PROBLEMS' => '아직 문제가 있나요?',
        'VISIT_NING_HELP_CENTER' => '<a %s>Ning 도우미 센터</a>를 방문해 문제해결 도움말과 지원을 받으세요.',
        'PROBLEMS_SIGNING_UP_OR_SIGNING_IN' => '가입 또는 로그인 문제',
        'WE_SENT_YOU_EMAIL' => '회원님의 비밀번호를 재설정하는 링크를 이메일로 전송하였습니다.',
        'RESET_PASSWORD_EMAIL_SUBJECT' => '비밀번호 재설정',
        'RESET_PASSWORD_EMAIL_BODY' => '%1$s,

회원님의 %2$s 비밀번호 변경 요청을 접수하였습니다.

아래의 링크를 클릭해 새 비밀번호를 설정하세요:

#{URL}

비밀번호 변경을 원하지 않으면 이 이메일을 무시하셔도 됩니다.

감사합니다,
 "%2$s" 팀

-----
%2$s은 Ning ID로 신원을 확인합니다.',
        'SET_PASSWORD' => '비밀번호 설정',
        'NEW_PASSWORD' => '새 비밀번호',
        'CREATE_NEW_PASSWORD' => '새 비밀번호 개설',
        'CHOOSE_NEW_PASSWORD' => '새 비밀번호를 선택하세요',
        'HELLO_USERNAME_SIGN_OUT' => '<strong>안녕하세요, %s님</strong> (<a %s>로그아웃</a>)',
        'NO_ACCOUNT_WITH_EMAIL_X' => '%s 이메일 주소와 연결된 계정이 없습니다',
        'PLEASE_ENTER_CODE' => '우측에 표시되는 코드를 입력하세요.',
        'PROBLEMS_SIGNING_UP' => '가입하시는 데 문제가 있나요?',
        'BY_SIGNING_UP_YOU_AGREE' => '사이트에 가입함으로써 회원님은 <a %s>이용약관</a>과 <a %s>과 개인정보보호&nbsp ; 정책</a>에 합의하신 것으로 됩니다.',
        'FEEDBACK' => '피드백',
        'TERMS_OF_SERVICE' => '이용약관',
        'PROBLEM_SIGNING_UP' => '가입하는 데 문제가 있습니다',
        'ALREADY_MEMBER_SIGN_IN' => '이미 회원이십니까?  <a %s>여기를 클릭해 로그인 하세요</a>.',
        'MEMBERSHIP_TO_APPNAME_BY_INVITATION_ONLY' => '%s는 초대에 의해서만 가입이 가능합니다',
        'SORRY_BUT_ADMINISTRATOR_REQUIRES_INVITATION' => '죄송하지만 운영자가 %s를 초대에 의해서만 가입이 가능하도록 설정해 놓았습니다.  초대장을 갖고 계시면 이메일에 있는 링크를 클릭해 가입하세요.',
        'PROBLEM_SIGNING_IN' => '가입하는 데 문제가 있었습니다',
        'WE_USE_NING_ID' => '저희는 Ning ID를 통해 신원을 확인합니다.  <a %s>Ning ID는 무엇인가요? </a>',
        'PROBLEMS_SIGNING_IN' => '로그인하시는 데 문제가 있나요?',
        'SIGN_IN_OR_SIGN_UP' => '<input %s value="Sign In" /> &#160; 또는&#160;  <strong><a %s>가입</a></strong>',
        'SIGN_IN_TO_APPNAME' => '%s에 로그인',
        'WHAT_IS_A_NING_ID' => 'Ning ID는 무엇인가요?',
        'LARR_BACK' => '← <a %s>뒤로</a>',
        'NING_ID_LETS_YOU_CHOOSE' => 'Ning ID 인증 시스템은 이메일 주소와 비밀번호를 한 번 선택하게 한 후, 이를 이용해 모든 사교 네트워크에 가입하거나 로그인하게 합니다.',
        'WHEN_YOU_CREATE_NING_ID' => 'Ning ID를 개설하면 회원님의 Ning ID 계정에 기본 상세정보와 회원님의 사진을 추가할 수 있습니다.  이 세부사항은 회원님이 Ning ID로 인증 절차를 거치는 새로운 사교 네트워크에 가입할 때 미리 자동으로 담깁니다.  아울러 회원님은 이 모든 사교 네트워크 전반에 걸쳐 이 정보를 사용하는 회원님의 친구와 메시지를 추적하고 기록할 수 있게 합니다.',
        'SIGN_IN_WITH_NING_ID_WHENEVER' => '다음과 같은 부호를 볼 때면 언제든지 회원님의 Ning ID 이메일 주소와 비밀번호를 사용해 로그인할 수 있습니다: %s',
        'HELLO_USER' => '안녕하세요, %s님',
        'TEXT_FOR_HEADER_TAB' => '이 텍스트는 헤더 탭 용입니다',
        'BASED_ON' => '출처',
        'ARE_YOU_SURE_DELETE_LANGUAGE' => '이 언어를 삭제하기 원하는 것이 맞습니까?',
        'DELETE_LANGUAGE' => '언어 삭제',
        'TEXT_RESET_TO_ORIGINAL_VERSION' => '텍스트가 원래 버전으로 재설정됐습니다.',
        'UPLOAD_LANGUAGE_FILE' => '언어 파일 업로드',
        'ADD_TO_LANGUAGE' => '언어에 추가',
        'IF_YOU_CREATED_TRANSLATION' => '새로운 번역이나 또 다른 Ning 사교 네트워크를 개설할 경우, 회원님의 게시물을 이 곳으로 가져올 수 있습니다.  해당 파일의 컨텐츠는 회원님이 선택하는 언어로 추가됩니다.  언어 목록이 보이지 않습니까?  <a %s>새 언어를 손쉽게 추가할 수 있습니다</a>.',
        'EXAMPLES_SWEDISH_FINLAND' => '예: 스웨덴(핀란드), 필리핀, 스페인(푸에르토리코)',
        'START_FROM_SCRATCH_CREATE' => '처음부터 다시 시작!  새 언어의 명칭을 입력한 후, 기존의 언어를 참조로 회원님의 새로운 번역을 만드세요.',
        'KEY_MISSING_TEXT' => 'Key: <span %s>Missing Text</span> <span %s>Changed Text</span>',
        'SHOW_ALL_TEXT' => '전체 텍스트 보기',
        'SHOW_MISSING_TEXT' => '빠진 텍스트 보기',
        'SHOW_CHANGED_TEXT' => '변경된 텍스트 보기',
        'EXAMPLES_TABS_MEMBERS_FRIENDS' => '예: 탭, 회원, 친구',
        'RESET_TEXT_TO_ORIGINAL_VERSION' => '텍스트를 원래 버전으로 재설정',
        'ORIGINAL_TEXT_X' => '원래 텍스트 –  %s',
        'EDIT_LANGUAGE_ON_NETWORK' => '회원님의 네트워크 언어 수정',
        'CUSTOMIZE_TEXT_ON_NETWORK_INCLUDING' => '탭 명칭, 이메일 바닥글, 오류 메시지를 포함한 회원님 네트워크와 관련한 모든 텍스트를 맞춤형으로 설정할 수 있습니다.',
        'ACTIVE_LANGUAGE_IS_X' => '<em>현재 사용 중인 언어: %1$s</em>  <a %2$s>사용언어 변경</a>',
        'CURRENT_LANGUAGE_OPTIONS' => '현재 언어 도구',
        'ACTIVE' => '사용 중',
        'MY_LANGUAGES' => '나의 언어',
        'CREATE_NEW_TRANSLATION' => '새 번역 만들기',
        'DONT_SEE_LANGUAGE_LISTED_CREATE' => '위에 언어 목록이 보이지 않습니까?  <strong><a %s>회원님 네트워크의 새로운 번역을 만드세요</a></strong>.',
        'ADVANCED_IMPORT' => '고급 불러오기 기능',
        'IF_YOU_TRANSLATED_A_LANGUAGE' => '기존의 사교 네트워크에서 특정언어를 번역했을 경우,  <strong><a %s>언어 파일 불러오기</a></strong>를 실행해 이 네트워크에서 사용할 수 있습니다.',
        'LANGUAGE_EDITOR' => '언어 편집기',
        'PUBLIC' => '일반',
        'GRANDFATHERED_PRIVACY_SETTING' => '회원님의 현재 프라이버시 설정(비회원들은 로그인 화면만 볼 수 있는 공개 네트워크)은 더 이상 이용할 수 없습니다.   회원님의 프라이버시 설정은 아직 변경되지 않았지만,  여기서 변경하시면 원상복귀가 불가능합니다.   현재는 누구라도 등록하여 회원이 될 수 있는 비공개 네트워크입니다.',
        'NO_MISSING_ITEMS' => '누락된 항목이 없군요 –  이 번역은 100 %% 완료입니다.  <a %s>모든 항목 보기. </a>',
        'NO_CHANGED_ITEMS' => '변경된 항목이 없습니다',
        'COULD_NOT_FIND_ITEMS_MATCHING' => '죄송합니다 –  <em>%s</em>에 일치하는 어떤 항목도 찾을 수가 없습니다.  <a %s>모든 항목 보기. </a>',
        'FILE_N' => '파일 %s',
        'TRANSLATION_FILE_HAS_FILENAME_LIKE' => 'Ning 번역 파일은  <code>en_US와 같은 파일명을 갖게 됩니다. txt</code>.  <a %s> 더 자세한 정보는 이 곳에서. </a>',
        'SELECT_TRANSLATION_FILE' => '번역 파일 선택:',
        'USE_THIS_TRANSLATION' => '이 번역을 이용',
        'FOLLOWING_ARE_MISSING_FROM_RULES' => '아래의 규칙에서는 다음과 같은 사항들이 누락 되어 있다는 것에 주목하세요:%s',
        'ALL' => '모두',
        'MISSING' => '누락됨',
        'VIEW' => '보기',
        'TRANSLATION_CHANGES_SAVED' => '회원님의 변경이 저장되었습니다.  이 변역은 %s%% 완료되었습니다.',
        'TRANSLATION_CHANGES_SAVED_MAKE_CURRENT' => '회원님의 변경이 저장되었습니다.  이 변역은 %s%% 완료되었습니다.  이 언어를 회원님의 현재 네트워크 언어로 사용하시겠어요?',
        'TRANSLATION_UPLOAD_SUCCESSFUL' => '회원님의 업로드가 성공적으로 완료되었습니다.  이 변역은 %s%% 완료되었습니다.',
        'TRANSLATION_UPLOAD_SUCCESSFUL_MAKE_CURRENT' => '회원님의 업로드가 성공적으로 완료되었습니다.  이 변역은 %s%% 완료되었습니다.  이 언어를 회원님의 현재 네트워크 언어로 사용하시겠어요?',
        'X_IS_CURRENT_LANGUAGE' => '이제 %s가 회원님의 네트워크 언어로 설정되었습니다.',
        'SAVE_PAGE' => '페이지 저장',
        'LANGUAGE_NAME_TAKEN' => '죄송합니다 – 입력하신 이름은 이미 다른 회원이 사용하고 있습니다.  다른 이름을 선택하세요.',
        'ENTER_NAME_FOR_TRANSLATION' => '새로운 번역을 위한 이름을 입력하세요(예: 포르투갈어(포르투갈))',
        'CREATE' => '만들기',
        'LANGUAGE_NAME' => '언어 이름',
        'SAVE_ITEMS_ON_PAGE' => '항목들을 이 페이지에 저장',
        'NEW_TRANSLATION' => '새로운 번역',
        'MISMATCHED_CURLY_BRACKETS' => '짝이 맞지 않는 중괼호(curly brackets)',
        'MISMATCHED_SQUARE_BRACKETS' => '짝이 맞지 않는 꺾쇠 괄호(square brackets)',
        'MISMATCHED_PARENTHESES' => '짝이 맞지 않는 괄호',
        'ERROR_PROCESSING_SPECIAL_RULES' => '특별 규칙 코드를 처리하는 동안 오류가 발생했습니다.',
        'ERROR_PROCESSING_TAB_NAMES' => '색인명 코드를 처리하는 동안 오류가 발생했습니다.',
        'SPECIAL_RULES' => '특별 규칙',
        'TAB_NAMES' => '색인명',
        'SOURCE' => '출처',
        'LANGUAGE_EDITOR_X' => '언어 편집기: %s',
        'BACK_TO_LANGUAGE_EDITOR' => '← 언어 편집기로 돌아가기',
        'CUSTOMIZE_YOUR_NETWORKS_TEXT' => '회원님의 네트워크에서 이용되는 글 및 메시지를 마춤설정 하시거나 전혀 새로운 언어를 만들 수 있습니다.',
        'STOPWORDS' => 'a | about | an | are | as | at | be | by | com | de | en | for | from | how | i | in | is | it | la | of | on | or | that | the | this | to | was | what | when | where | who | will | with | und | the | www',
        'STOPWORDS_ARE' => '<a %s>금지어</a> 란, 각 페이지 상단의 메타 태그를 만드실 때 네트워크의 설명 내용에서 걸러 내고자 하는 단어 목록으로서, 회원님의 선택에 의해 설정할 수 있습니다.  선택 사항',
        'I_AM_MEMBER' => '나는 다음과 같은 네트워크의 회원입니다:',
        'VIEW_PAGE_ON_APPNAME' => '<em>%s</em>에서 나의 페이지 보기',
        'VISIT_APPNAME' => 'Visit <em>%s</em>',
        'JOIN_US' => '가입하세요.',
        'CREATED_BY_COLON' => '만든 사람:',
        'GET_MORE_BADGES' => '더 많은 뱃지 얻기.',
        'SHOW_LOGO' => '로고 보이기',
        'GALLERY' => '겔러리',
        'BADGES' => '뱃지',
        'MEMBER_BADGE' => '회원 뱃지',
        'WEAR_IT_WITH_PRIDE' => '자랑스럽게 착용하세요!  회원님의 개인 웹사이트나 MySpace페이지에 게시할 수 있는 %s 회원 뱃지를 받으세요.',
        'NETWORK_BADGE_LARGE' => '네트워크 뱃지(대형)',
        'SPREAD_THE_WORD_NETWORK_BADGE_LARGE' => '소문을 내 주세요!  네트워크에서 가장 인기 있는 회원들과 자주 업데이트되는 %s뱃지를 받으세요.  회원님의 웹사이트나 MySpace페이지에 추가하세요.',
        'NETWORK_BADGE_SMALL' => '네트워크 뱃지(소형)',
        'SPREAD_THE_WORD_NETWORK_BADGE_SMALL' => '소문을 내 주세요!  회원님의 웹사이트나 MySpace 페이지에 게시 할 수 있는 %s뱃지를 받으세요.',
        'PHOTO_SLIDESHOW_PROPER' => '사진 슬라이드쇼',
        'DISPLAY_SELECTION_OF_PHOTOS' => '저희가 제공하는 스타일리시한 슬라이드쇼 플레이어를 사용하여 회원님의 웹사이트나 MySpace 페이지에 원하는 사진을 게시하세요.',
        'MUSIC_PLAYER' => '뮤직 플레이어',
        'PLAY_MUSIC_ON_WEBSITE' => '저희가 제공하는 스타일리시한 뮤직 플레이어를 사용하여 웹사이트나 MySpace페이지에서 음악을 재생하세요.',
        'ADD_A_VIDEO_MORE_OPTIONS' => '동영상을 회원님의 웹사이트나MySpace페이지에 추가하세요.  더욱 다양한 옵션이 필요하세요?  %s에 있는 <a href="%s">모든 동영상 보기</a>.',
        'LARGE_N_PIXELS_WIDE' => '대형 – 가로 %d 픽셀',
        'MEDIUM_N_PIXELS_WIDE' => '보통 – 가로 %d 픽셀',
        'SMALL_N_PIXELS_WIDE' => '소형 – 가로 %d 픽셀',
        'MY_MOST_RECENT' => '나의 최신 작품',
        'APP_ICON' => '응용 프로그램 아이콘',
        'MEMBERSHIP_TO_X_IS_BY_INVITATION' => '초대 받은 사람만 %s의 회원이 되실 수 있습니다',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK' => '%s님께서 다음과 같은 평가 소감을 남기셨습니다:',
        'X_PROVIDED_FEEDBACK_ON_Y_ELLIPSIS' => '%2$s에 %1$s 님께서 평가 소감을 남기셨습니다...',
        'THANK_YOU_YOUR_MESSAGE_HAS_BEEN_SENT' => '감사합니다.   회원님의 메시지가 전송되었습니다.',
        'X_WOULD_LIKE_TO_JOIN_X' => '%s님께서 %s에 가입하기를 원하십니다!',
        'X_HAS_REQUESTED_AN_INVITATION' => '%s님께서 %s에의 초대를 요청했습니다',
        'YOUR_REQUEST_HAS_BEEN_SENT' => '회원님의 요청이 네트워크 개설자에게 발송되었습니다.',
        'TO_UNBAN_USERNAME_GO_TO' => '%s의 금지를 해제하려면, 이 곳으로 가십시오:',
        'SEND_REQUEST' => '요청 발송',
        'SEARCH' => '검색',
        'SEARCH_AGAIN' => '다시 검색',
        'SEND_BROADCAST_MESSAGE' => '전체 메시지 발송',
        'VERIFICATION_IMAGE' => '인증 이미지',
        'UNDER_CONSTRUCTION' => '준비 중',
        'PROFILE_INFORMATION_SAVED' => '프로필 정보 저장되었습니다.',
        'YOUR_SITES_DIRECTORY_PROFILE' => '회원님의 네트워크의 디렉토리 프로필 정보가 저장되었습니다.',
        'NO_ACCOUNT_WITH_EMAIL' => '입력하신 이메일 주소에 따른 계정이 없습니다.',
        'INVALID_PASSWORD_CHECK_CAPS_LOCK' => '비밀번호가 틀렸습니다.   ‘Caps Lock’이 켜져 있습니까?',
        'OOPS_THAT' => '저런 –   로그인 실패입니다.',
        'OOPS_THAT_DID_NOT_WORK' => '저런 –   로그인 실패입니다.   다시 시도해 보시겠어요?',
        'OOPS_THAT_DID_NOT_WORK_ERROR_CODE' => '저런 –  로그인 실패입니다 (%s).',
        'NOT_FOUND' => '찾을 수 없습니다',
        'YOUR_SITES_FEATURE_LIST' => '회원님의 네트워크의 기능 목록이 저장되었습니다.',
        'ONE_LINE_ANSWER' => '한 줄 답변',
        'LONGER_ANSWER' => '긴 답변',
        'MULTIPLE_CHOICE' => '다지선답 형',
        'DATE' => '날짜',
        'WEBSITE_ADDRESS' => '웹사이트 주소',
        'EVERYTHING' => '모두',
        'JUST_THE_HOMEPAGE' => '메인 페이지만',
        'JUST_THE_SIGN_UP_PAGE' => '가입 페이지만',
        'YOUR_CHANGES_HAVE_BEEN_SAVED' => '회원님의 변경이 저장되었습니다.',
        'JOIN_ME_ON_X' => '%s에 가입하고 싶어요!',
        'NOT_ALLOWED' => '허용되지 않음',
        'COME_JOIN_ME_ON_X_ELLIPSIS' => '저랑 같이 %s에 가입하세요!...',
        'X_NOT_VALID_EMAIL' => '%s 는 유효한 이메일 주소나Ning ID가 아닙니다',
        'USER_BANNED_FROM_NETWORK' => '%1$s 님은 이 네트워크으로부터 금지되었습니다.  <a %2$s>%1$s님께 메시지 보내기</a>',
        'USER_ALREADY_NETWORK_MEMBER' => '%1$s님은 이미 이 네트워크의 회원이십니다.  <a %2$s>%1$s님께 메시지 보내기</a>',
        'YOU_CAN_SEND_AT_MOST_X' => '한 번에 %s개까지만 보내실 수 있습니다.',
        'PLEASE_ENTER_YOUR_FRIENDS' => '친구의 이메일 주소나 Ning ID를 입력하세요.',
        'THERE_HAS_BEEN_AN_ERROR' => '오류가 발생했습니다',
        'INVITATIONS_HAVE_BEEN_SENT' => '회원님의 초대장이 발송되었습니다.',
        'SEARCH_RESULTS' => '검색 결과',
        'INVITE_YOUR_FRIENDS' => '친구 초대',
        'SEND_INVITATIONS_FOR_FRIENDS' => '친구에게 가입 초대 발송',
        'INVITATION' => '초대',
        'ADD_FROM_ADDRESS' => '주소록에서 가져오기.',
        'TO' => '받는 사람:',
        'SEND_TO' => '받는 사람:',
        'SUBJECT' => '제목',
        'YOUR_MESSAGE' => '메시지',
        'SEND' => '보내기',
        'REPORT_AN_ISSUE' => '문제 보고',
        'TYPE_OF_ISSUE' => '문제 종류',
        'ADULT' => '성인용 컨텐츠',
        'ABUSIVE' => '불량사용',
        'BUG' => '버그',
        'FRAUD' => '사기 행각',
        'SPAM' => '스팸메일',
        'OTHER' => '기타',
        'DESCRIBE_YOUR_ISSUE' => '문제 설명',
        'SEND_REPORT' => '신고서 보내기',
        'ADDED_BY_X_AT_X' => '%s 일 %s에서 <a %s>%s</a>님이 추가',
        'ADDED_BY_USER_TO_GROUP_AT_DATE' => '%s 일 %s에서 %s로 <a %s>%s</a>님이 추가',
        'G_IA' => 'g:ia',
        'F_JS_Y' => 'F jS, Y',
        'CLICK_TO_VIEW' => '클릭하여 보기',
        'COMMENT_FOR' => '코멘트 수신:',
        'COMMENT_ON' => '코멘트 대상:',
        'ACTION_BUTTON_FEATURE' => '인기 항목',
        'FEATURE_THIS_ON_YOUR' => '메인 페이지에 인기 항목으로 게시하기',
        'ACTION_BUTTON_REMOVE' => '삭제',
        'REMOVE' => '삭제',
        'REMOVE_THIS_FROM_YOUR' => '메인 페이지에서 이것을 삭제하기',
        'FEATURE_ON_HOME' => '메인 페이지의 인기 항목으로.',
        'REMOVE_FROM_HOME' => '메인 페이지로부터 삭제',
        'ITEM_WILL_APPEAR' => '이 아이템은 메인 페이지 상의 특정 모듈에 나타납니다',
        'ITEM_WILL_NO_LONGER_APPEAR' => '이 아이템은 더 이상 메인 페이지 상의 특정  모듈에 나타나지 않게 됩니다.',
        'ADD_CONTENT' => '내용 추가',
        'BROUGHT_TO_YOU_BY' => '%s는 %s © %s에 의해 제공됩니다',
        'GIVE_US_YOUR_FEEDBACK' => '회원님의 평가 소감을 보내 주세요',
        'FOR_ADDITIONAL_QUESTIONS_OR_TO_CONTACT_NING_PLEASE_CLICK_HERE' => '추가로 질문이 있으시거나 Ning에게 연락하시고자 하는 경우 여기을 클릭해 주세요:',
        'SEND_FEEDBACK' => '평가 소감 전송',
        'SIGN_OUT' => '사인 아웃',
        'SIGN_OUT_TITLE' => '퇴장',
        'EDIT_MY_PROFILE' => '프로필 답변 편집하기',
        'INVITE_MORE' => '더 많은 사람 초대하기',
        'USE_THIS_FORM_TO_SEND_FEEDBACK_TO_NC' => '평가 소감을 전하시고 싶으시면 이 양식을 이용하여 <a %s>%s</a>, (을)를 개설한 <a %s>%s</a>님께 보내 주세요.',
        'YOUR_FEEDBACK' => '회원님의 평가 소감',
        'NETWORK_INFORMATION' => '동호회 정보',
        'ABOUT_YOUR_SITE' => '회원님의 네트워크에 관하여',
        'WELCOME_TO_YOUR_SITE' => '사교 네트워크에 오신 것을 환영합니다!',
        'EDIT_YOUR_NETWORKS_INFO' => '네트워크의 이름과 내용 설명 및 기타 정보를 편집하세요.',
        'TAGLINE' => '태그라인',
        'APPEARS_IN_HEADER' => '동호회 웹사이트의 머릿글에 표시됩니다',
        'APPEARS_IN_EMAILS' => '이메일 및 기타 다른 곳에 표시됩니다',
        'NETWORK_NAME' => '네트워크 이름',
        'DESCRIPTION' => '내용',
        'KEYWORDS' => '키워드',
        'LANGUAGE' => '언어',
        'SEPARATE_EACH_KEYWORD' => '각 키워드는 쉼표로 분리하세요.',
        'ICON' => '아이콘',
        'UPLOAD_A_PHOTO_WHICH_WILL_BE_RESIZED' => '사진(GIF, JPG 또는 PNG 파일 형식)을 업로드하세요. 크기는 정사각형 모양으로 자동 조정됩니다.  이 사진이 뜨는데 몇 분 정도 시간이 소요될 수 있습니다.',
        'SAVE_SETTINGS' => '설정 저장',
        'SUCCESS_EXCLAMATION' => '성공입니다!',
        'FEATURES' => '기능',
        'ADD_FEATURES' => '기능을 네트워크에 추가하기',
        'ORGANIZE_FEATURES' => '아래의 목록에서 어떤 기능이든 ‘끌어 오기’로  불러 와서 원하시는 곳에 배치함으로써 회원님의 메인 페이지를 마음대로 꾸며 보세요.',
        'SKIP_FEATURES' => '기본값으로 제공된 레이아웃과 기능만으로 계속하시려면 <a href="%s">이 단계 생략</a>을 클릭하면 됩니다.',
        'FEATURES_FOR_ALL_PAGES' => '이 상자에 추가된 기능은 네트워크의 회원님의 모든 페이지 상에 나타납니다.',
        'CUSTOMIZE_SITE_BY_ADDING' => '새로운 기능을 추가하거나 제거하여 회원님의 사교 네트워크를 마춤형으로 설정해 보세요.',
        'ADJUST_YOUR_SITES_COLORS' => '네트워크의 색상, 이미지 및 전체적인 스타일을 바꿔 보세요.',
        'APPEARANCE' => '모양',
        'PROFILE_QUESTIONS' => '프로필 질문',
        'EDIT_QUESTIONS_THAT_MEMBERS_ANSWER' => '회원들이 자신들을 소개할 수 있도록 도와주는 프로필 질문들을 편집하세요.',
        'MESSAGE_SENT' => '메시지가 발송되었습니다!',
        'YOUR_MESSAGE_HAS_BEEN_SENT' => '회원님의 메시지가 네트워크 회원 모두에게 발송되었습니다.',
        'YOUR_MESSAGE_HAS_BEEN_SENT_GROUP' => '회원님의 메시지가 그룹의 회원 모두에게 발송되었습니다.',
        'YOUR_MESSAGE_IS_BEING_SENT' => '회원님의 메시지가 발송 중입니다.  명령을 수행하는데 몇 분 정도 걸릴 수 있습니다.  기다려 주세요.',
        'BROADCAST_MESSAGE' => '전체 메시지',
        'TRACK_VISITORS_AND_TRENDS' => '회원님의 사교 네트워크의 방문객들과 트렌드를 추적해 드립니다.',
        'EDIT_SOURCE_CODE' => '출처 코드 편집',
        'TAKE_FULL_CONTROL' => '출처 코드를 편집함으로써 회원님의 네트워크 기능을 완벽히 컨트롤해 보세요.',
        'DELETE_THIS_SITE' => '회원님의 사교 네크워크 삭제하기',
        'MAIN_PAGE' => '메인 페이지',
        'MAIN' => '메인',
        'MAIN_TAB_TEXT' => '메인',
        'MANAGE' => '관리',
        'MANAGE_TAB_TEXT' => '관리',
        'PAGE_TITLE' => '페이지 제목',
        'LOREM_IPSUM_1' => 'Lorem <span %s>ipsum dolor</span> sit amet, consectetuer adipiscing elit.  Nunc scelerisque blandit dolor.  Vestibulum ante ipsum primis in faucibus orci luctus.',
        'LOREM_IPSUM_2' => 'Lorem ipsum dolor sit amet, consectetuer adipiscing',
        'LOREM_IPSUM_3' => 'Lorem ipsum dolor sit amet, <span class="preview_link">consectetuer</span> adipiscing',
        'EDIT_THE_APPEARANCE' => '회원님의 페이지 모양 편집',
        'CHOOSE_A_THEME' => '회원님의 사교 네트워크에 적합한 테마를 선택하세요.',
        'NOW_CUSTOMIZE_SITE' => '이제 회원님의 동호회를 원하시는 대로 꾸밀 차례입니다...',
        'THEME_SETTINGS' => '테마 설정',
        'ADVANCED' => '고급',
        'TOP_BAR_AND_FOOTER' => '상단 바& 푸터',
        'HEADER_AND_NAVIGATION' => '헤더 & 네비게이션',
        'ADD_A_LOGO' => '로고 추가하기',
        'THIS_IMAGE_WILL_REPLACE' => '이 이미지는 글로 표기된 네트워크 이름을 대신합니다',
        'TABS' => '탭',
        'TAB' => '색인',
        'SITE' => '네트워크',
        'SIDES' => '사이드',
        'BODY' => '본문',
        'SHOW_NING_LOGO' => 'Ning 로고를 게시할까요?',
        'LAUNCH' => '개시!',
        'NING_ID' => 'Ning ID',
        'PASSWORD' => '비밀번호',
        'RETYPE_PASSWORD' => '비밀번호 재입력',
        'TYPE_CODE_ON_RIGHT' => '오른쪽에 코드<br/>입력하십시오',
        'JOIN_X' => '%s 가입',
        'SIGN_UP_FOR_X' => '%s 가입',
        'HAS_INVITED_YOU_TO_X' => '…님으로부터 %s가입하시도록 초대받으셨어요.',
        'CONTENT_AWAITING_APPROVAL' => '승인 대기 중',
        'NEW_MEMBER' => '새 회원이세요?',
        'JOIN_X_NOW' => '지금 %s에 가입하세요!',
        'HIDE_THIS_MESSAGE' => '이 메시지 숨기기',
        'PAGE_NOT_FOUND' => '페이지를 찾을 수 없습니다',
        'THIS_PAGE_WAS_NOT_FOUND' => '죄송합니다 – 이 페이지를 찾지 못했습니다.',
        'FOLLOW_THESE_LINKS_TO' => '다음의 링크들을 따라가면 이용가능한 항목을 확실하게 찾으실 수 있습니다:',
        'ALTERNATIVELY_YOU_CAN_SEARCH' => '아니면, 이 사교 네트워크를 검색하실 수도 있습니다:',
        'IF_YOU_GET_THIS_MESSAGE' => '이 메시지가 다시 나타나면<a %s>저희에게 꼭 알려 주십시오. </a>',
        'GROUP_MEMBERS' => '그룹 회원',
        'VIDEOS' => '동영상',
        'BLOG' => '블로그',
        'ACCOUNT' => '계정',
        'WE_ARE_SORRY_WE_ARE_HAVING' => '죄송합니다, 현재 이 페이지에 문제가 있어 해결 중입니다.',
        'FOLLOW_LINK_TO_HOMEPAGE' => '<a %s>이 링크</a>를 따라 메인 페이지로 가 주세요.',
        'REQUEST_AN_INVITATION' => '초대 요청하기',
        'NAME' => '이름',
        'EMAIL_ADDRESS' => '이메일 주소',
        'MESSAGE_OPTIONAL' => '메시지 (선택사항)',
        'SORRY_HOWEVER_ITS_EASY' => '<strong>죄송합니다! </strong>하지만 회원님도 간단하게 직접 자신의 사교 네트워크를 시작할 수 있다구요.',
        'GET_YOUR_OWN_BAZEL' => '자신만의 사교 네크워크를 개설해 보세요!',
        'SITE_IS_NOT_READY' => '이 동호회는 아직 이용하실 준비가 되어있지 않군요!',
        'BAZEL_IS_BEING_SET_UP' => '이 동호회는 아직 개설 중입니다!',
        'SIGN_IN' => '입장',
        'FORGOT_YOUR_PASSWORD' => '비밀번호를 잊으셨나요?',
        'FORGOT_YOUR_PASSWORD_TITLE' => '비밀번호를 잊으셨나요?',
        'ENTER_EMAIL_AND_CLICK_RESET_PASSWORD' => '이메일 주소를 입력하고 ‘비밀번호 재설정’을 클릭하세요.  비밀번호를 재설정할 수 있는 링크가 포함된 이메일이 회원님게 발송될 것입니다.',
        'RESET_PASSWORD' => '비밀번호 재설정',
        'EXPLORE' => '탐색',
        'SIGN_UP' => '가입',
        'CONFIRM_PASSWORD' => '비밀번호 확인',
        'VERIFICATION' => '<br />사람이 가입한다는 것을 확인해 주세요',
        'YOUR_PHOTO' => '회원님의 사진',
        'SUMMARY' => '요약',
        'YOUR_SITE_IS_READY' => '회원님의 사교 네크워크 개시 준비가 완료되었습니다!   회원님께서 생략하신 각각의 설정 단계에는 모두 기본치가 사용됩니다.  되돌아가서 변경을 하시거나 ‘개시!’를 클릭하여 클릭하여 네트워크를 시작하시면 됩니다..',
        'WHEN_YOU_ARE_FINISHED' => '완료되었으면 ‘레이아웃 보기’를 눌러 회원님의 작품을 감상해 보십시오!',
        'COMPLETE' => '완료',
        'INCOMPLETE' => '완료되지 않음',
        'VIEW_LAYOUT' => '레이아웃 보기',
        'CLEAR_CONTENTS' => '컨텐츠 취소',
        'ADD_MODULE' => '모듈 추가...',
        'ADD_COLUMNS' => '칼럼 추가...',
        'PUBLIC_ANYBODY_CAN_JOIN' => '<strong>공개</strong> –  누구나 가입할 수 있습니다',
        'PRIVATE_ONLY_INVITED' => '<strong>비공개</strong> –  초대한 사람들만 열람하거나 가입할 수 있습니다.',
        'INVITATIONS' => '초대',
        'MEMBERS_CAN_INVITE' => '회원들은 다른 사람에게 가입 초대를 보낼 수 있습니다.',
        'QUESTION_TITLE' => '질문 제목',
        'ANSWER_TYPE' => '대답 종류',
        'REQUIRED' => '필수',
        'PRIVATE' => '비공개',
        'CHOICES' => '선택',
        'SEPARATE_EACH_CHOICE' => '각각의 선택 사항을 쉼표로 분리해 주십시오.',
        'CAN_PICK_MORE' => '둘 이상을 선택할 수 있습니다',
        'ADD_ANOTHER_QUESTION' => '다른 질문 추가',
        'WHAT_INFORMATION' => '다른 회원들이 회원님의 네트워크에 가입 하고자 할 때 어떤 질문을 묻고 싶으세요?  아래의 질문의 순서를 변경할 수 있습니다.  질문을 클릭한 다음 ‘끌어 오기’로 원하시는 곳에 옮기기만 하면 됩니다.',
        'IF_YOU_SELECT_REQUIRED_MEMBERS_WILL' => '“필수”를 선택하면 회원들이 가입하고자 할 때 그 질문에 반드시 대답을 해야 합니다.  “비공개”를 선택한 경우에는 회원님과 다른 관리자들만 그 대답을 볼 수 있게 됩니다.',
        'WE_COULD_NOT_FIND_ANYTHING' => '"%s"에 일치하는 항목을 찾을 수 없습니다.  검색 항목을 바꾸어 검색해 보시겠어요?',
        'GET_CUSTOM_URL' => '마춤형 URL을 즐기심과 함께 저장 용량과 대역폭을 추가하시거나, 회원님 자신의 광고를 홍보해 보세요.',
        'VIEW_STATISTICS' => '통계치 보기',
        'ADD_TRACKING_CODE' => '<a %s>회원님 고유의 추적 코드 추가하기 </a>.',
        'TRACKING_CODE' => '추적 코드',
        'ANY_JAVASCRIPT_CODE' => '이 곳에 붙여넣는 JavaScript 코드는 회원님의 네트워크 모든 페이지 하단에 삽입됩니다.  이 기능은 Google Analytics과 같은 외부 사이트 추적 시스템에도 사용할 수 있습니다.',
        'ANALYTICS_LEARN_MORE' => 'Google Analytics에 대한 보다 자세한 정보와 계정 설정을 위해서는 <a %s>이 곳을 클릭</a>해 주세요 .',
        'RESOURCES' => '참조 정보',
        'LINKS' => '링크',
        'PAGE' => '페이지',
        'BACKGROUND' => '배경',
        'TEXT' => '글',
        'HEADING_TEXT' => '머릿글',
        'FONT' => '폰트',
        'AABBCC' => 'AaBbCc',
        'COLOR' => '색상',
        'LINK_COLOR' => '링크 색상',
        'BODY_TEXT' => '본문 텍스트',
        'MIDDLE' => '중간',
        'FEATURE_BOXES' => '기능 상자',
        'TITLEBAR_TEXT_COLOR' => '타이틀바 본문 색상',
        'TITLEBAR_BACKGROUND' => '타이틀바 배경',
        'UPLOADING_CONTENT' => '컨텐츠 업로드 중입니다...',
        'WHEN_UPLOADING_IS_COMPLETE' => '업로드가 완료되면 네트워크를 둘러 보실 수 있습니다.',
        'FINISH' => '완료',
        'FLICKR_IMPORT_SETUP' => 'Flickr 불러 오기 설정',
        'FLICKR_API_KEY' => '회원님의 키',
        'FLICKR_SECRET' => '회원님의 암호',
        'FLICKR_KEY_ERROR' => '입력하신 Flickr 키 또는 암호에 문제가 있습니다.   확인 후 다시 입력해 주시겠어요?',
        'FLICKR_INTRO' => '회원님의 네트워크 회원들이 자신들의 사진을 Flickr에서 임포트할 수 있도록 허용하시겠어요?  잘 찾아 오셨습니다.  이미 Flickr API 키와 암호를 갖고 계시는 경우에는  <a %s>단계 생략</a>하실 수 있습니다.  무슨 뜻인지 잘 모르시겠다구요?  아래에 제시된 단계별 지시를 따르기만 하시면 몇 분 내로 직접 문제를 해결하실 수 있습니다.',
        'FLICKR_GET_ACCOUNT' => '이미 Flickr계정을 갖고 계시지 않은 경우는 <a %s>여기</a>에서 계정을 만드세요.',
        'FLICKR_STEP1_TITLE' => '1단계: Flickr API 키 받기',
        'FLICKR_STEP1_APPLY_SCREEN' => 'Flickr의 API 키 화면에서 신청하십시오',
        'FLICKR_STEP1_API_SCREEN' => 'Flickr화면의 API 키 화면',
        'FLICKR_STEP1_INTRO' => 'Flickr에 로그인하셔서  <a %s>새로운 API 키를 신청하십시오</a> (새로운 창이 열릴 것입니다).',
        'FLICKR_STEP1_A' => '<strong>이름</strong>과<strong>이메일 주소</strong>를 입력하세요.',
        'FLICKR_STEP1_B' => '<strong>”이 키는…” 아래에는for&hellip; </strong> <em>비영리 사용</em>옵션을 선택하십시오.',
        'FLICKR_STEP1_C' => '<strong>만들고 싶은 응용 프로그램 설명</strong>상자에 회원님의 동호회에 대한 설명을 입력하십시오.',
        'FLICKR_STEP1_D' => '두 개의 승인 상자 모두에 체크해 주시기 바랍니다.',
        'FLICKR_STEP1_APPLY' => '체크가 된 것을 확인한 후 <strong>신청</strong>버튼을 클릭하세요.',
        'FLICKR_STEP1_E' => '회원님의 새로운 API 키가 표시된 화면이 나타날 것입니다.  <strong>여기를 클릭하세요</strong>라고 표시된 링크를 클릭하여 키의 사용자 인증 내용을 설정하세요.',
        'FLICKR_STEP2_TITLE' => '2단계: 키 설정',
        'FLICKR_STEP2_SETUP_SCREEN' => 'Flickr의 API 키 인증 내용 설정 화면',
        'FLICKR_STEP2_F' => '다음의 웹 주소를<strong>콜백 URL</strong>필드에 붙여 넣으십시오:',
        'FLICKR_STEP2_SAVE_CHANGES' => '다 되셨으면 <strong>변경 내용 저장하기</strong> 버튼을 클릭하십시오.',
        'FLICKR_STEP3_TITLE' => '3단계: 개인 정보 입력',
        'FLICKR_STEP3_KEYS_SCREEN' => 'Flickr의 API 키 정보 화면',
        'FLICKR_STEP3_CONGRATULATIONS' => '축하합니다!  회원님의 정보가 지금 Flickr에 설정되어 있습니다.',
        'FLICKR_STEP3_COMPLETE' => '다음에 나타난 필드에 회원님의 키와 암호를 복사하여 붙여넣기만 하면 %s에서의 설정이 완료됩니다.',
        'COMPLETE_SETUP' => '설정 완료',
        'SETUP_YOUR_SITE_TO' => '회원님의 동호회를 만들어서 Flickr로부터 사진을 불러 오시면 됩니다.',
        'FLICKR_IMPORTING' => 'Flickr 불러 오기',
        'YOU_NEED_TO_SET_UP_FLICKR' => '다른 사람들이 Flickr에서 사진을 불러 올 수 있도록 허용하시기 위해서는 회원님 자신의 사교 네트워크를 개설하셔야 합니다.  개설하는 과정은 몇 분 밖에 걸리지않는데 <a %s>지금 바로 만들어 보시겠어요? </a>',
        'DONT_SHOW_THIS_AGAIN_FLICKR' => '이 메시지 다시는 보이지 말아주세요.',
        'YOUVE_SIGNED_OUT_OF_X' => '회원님께서는 방금 %s.에서 퇴장하셨습니다  저희를 조만간 꼭 다시 방문해 주세요!',
        'CREATED_THIS_SOCIAL_NETWORK' => '이 사교 네트워크는 <a href=\'http://www.ning.com\'>Ning</a>에 개설되어 있습니다.',
        'CREATE_YOUR_OWN' => 'Ning에서는 회원님 자신의 사교 네트워크를 무료로 개설할 수 있는 기회를 드립니다!',
        'DRAG_HERE_TO_REMOVE_FEATURE' => '기능 삭제하려면 이곳으로 ‘끌어 오기.’',
        'LAYOUT' => '레이아웃',
        'DRAG' => '끌어 오기',
        'HERE' => '여기',
        'YOU' => '회원님',
        'ADS' => '광고',
        'MEMBERS' => '회원',
        'HELLO_USERNAME' => '안녕하십니까, Username님',
        'CREATED_BY' => '만든 사람',
        'SAVE_FEATURES' => '기능 저장',
        'FORUM' => '포럼',
        'CATEGORIES' => '부류',
        'FORUM_CATEGORIES' => '포럼 부류',
        'A_THREADED_DISCUSSION_FORUM' => '응답형 토론 포럼',
        'ALLOW_MEMBERS_TO_CREATE_GROUPS' => '네트워크 가입자들이 자신의 관심 그룹을 네트워크 내에 창설하는 것을 허용 하기',
        'FEATURE_POSTS_FROM_YOUR_BLOG' => '회원님의 블로그 또는 다른 회원의 블로그에서 추천된 게시물',
        'TEXT_BOX' => '텍스트 상자',
        'PUT_ANY_TEXT_WIDGET_OR_HTML' => '메인 페이지에 어떤 종류의 텍스트, 위짓 또는 HTML를 게제하기.',
        'A_LIST_OF_MEMBERS' => '회원님의 사교 네트워크 가입자 목록',
        'ALLOW_USERS_PHOTOS' => '사람들이 사진을 업로드하고 공유할 수 있도록 허용하기',
        'ADD_FEEDS_FROM_ACROSS_THE_WEB' => '인터넷 상의 출처를 막론하고 피드 추가 하기',
        'INFORMATION_ABOUT_THE_USER' => '현재 네트워크 이용 중인 사람들에 대한 정보',
        'ALLOW_USERS_VIDEOS' => '사람들이 동영상을 추가하고 공유하도록 허용하기',
        'SHOW_NETWORK_DESCRIPTION' => '사교 네트워크 내용 설명 보이기',
        'PROMOTE_NETWORK_WITH_BADGES' => '맞춤형 뱃지와 위짓을 사용하여 회원님의 사교 네트워크를 인터넷 상에 홍보하기',
        'MONETIZE_WITH_ADS' => '광고를 이용하여 회원님의 사교 네트워크를 수익상품화하기',
        'LET_MEMBERS_KNOW_WHO_CREATED_NETWORK' => '가입자들에 이 사교 네트워크의 개설자를 소개하기',
        'FOLLOW_LATEST_ACTIVITY' => '사교 네트워크의 최신 회원 활동 내역 및 동향 추적',
        'FAQ_FOR_NETWORK_CREATORS' => '사교 네트워크 개설자들을 위한 FAQ',
        'ANSWERS_TO_FAQS' => '사교 네트워크를 어떤 식으로 맞춤 설정할 수 있는지에 관해 저희에게 자주 주어지는 질문들에 대한 답변이 마련되어 있습니다.',
        'MEET_OTHER_LIKEMINDED' => '스타일이 비슷한 다른 사교 네트워크 개설자들을 만나 아이디어를 공유하고 Ning팀의 지원도 받으실 수 있습니다.',
        'CUSTOMIZE_THE_APPEARANCE_NETWORK' => '왼쪽 필드에 자신만의 독특한 CSS (Cascading Style Sheets) 를 추가하여 회원님의 사교 네트워크 웹사이트를 원하시는 스타일로 꾸미실 수 있습니다.  (<a href="%s">CSS란 무엇입니까? </a>)',
        'CUSTOMIZE_THE_APPEARANCE_PAGE' => '왼쪽 필드에 자신만의 독특한 CSS (Cascading Style Sheets) 를 추가하여 회원님의 웹사이트를 원하시는 스타일로 꾸미실 수 있습니다.  (<a href="%s">CSS란 무엇입니까? </a>)',
        'CSS_ON_YOUR_SOCIAL_NETWORK' => '회원님의 사교 네트워크 상의 CSS',
        'CSS_ON_YOUR_PAGE' => '회원님의 홈페이지의 CSS',
        'ADDING_YOUR_OWN_CSS_NETWORK' => '자신만의 독특한CSS를 추가하심으로써 회원님의 사교 네트워크에 쓰일 폰트, 색상, 띄어 쓰기 및 일반적인 스타일을 완벽하게 컨트롤 할 수 있습니다.',
        'ADDING_YOUR_OWN_CSS_PAGE' => '자신만의 CSS를 웹페이지에 추가하심으로써 회원님의 홈페이지에 쓰일 폰트, 색상, 띄어 쓰기 및 일반적인 스타일을 완벽하게 컨트롤 할 수 있습니다',
        'CSS_STYLES_WILL_OVERRIDE' => '이 곳에 CSS스타일을 추가하시면 이 새 스타일이 기존에 선택하신 모든 CSS 스타일을 번복하게 됩니다.',
        'NEED_HELP_FIGURING_OUT_CSS' => '사교 네트워크의 구체적인 CSS 클래스 이름을 찾으시는데 도움이 필요하세요?  무료로 제공되는 <a href="%s">Firebug</a> extension (Firefox 브라우저의 경우에 해당함) 상의 “조사” 기능을 추천합니다..',
        'WANT_TO_LEARN_MORE' => '더 자세한 내용을 알고 싶으세요?  <a href="%s">고급 맞춤형 지정</a>섹션을 참조하세요.',
        'APPLY_XS_THEME' => '%s의 테마 적용',
        'X_ALREADY_REGISTERED_Y_TO_RESET' => '%s라는 이메일 주소로 등록된 Ning ID가 이미 존재합니다.  아래에서 회원님의 Ning ID나 이메일 주소로 로그인 하십시오.  비밀번호를 잊어버리셨을 경우<a href="%s">이 곳을 클릭하여 비밀번호를 재설정하세요</a>.',
        'INVITED' => '초대 받음',
        'REQUESTED_INVITE' => '초대 요청함',
        'BAN_FROM_NETWORK' => '네트워크로부터 금지하기',
        'REMOVE_BAN' => '금지 해제',
        'CANCEL_INVITATION' => '초대 취소',
        'IGNORE' => '무시',
        'PROMOTE_TO_ADMINISTRATOR' => '운영자로 진급시키기',
        'DEMOTE_FROM_ADMINISTRATOR' => '운영자로부터 강등시키기',
        'STATUS' => '회원 등급',
        'DATE_JOINED' => '가입 날짜',
        'DATE_INVITED' => '초대 날짜',
        'DATE_REQUESTED' => '요청 날짜',
        'DATE_APPLIED' => '적용 날짜',
        'NETWORK_CREATOR' => '네트워크 개설자',
        'NETWORK_ADMINISTRATOR' => '운영자',
        'ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => '운영자는 사교 네트워크 개설자와 비슷한 수준의 컨트롤을 행사할 수 있습니다.',
        'DOWNLOAD_ALL_MEMBER_DATA' => '모든 가입자 정보 내보내기(. CSV)',
        'CLICK_TO_SEE_MEMBER_DATA' => '회원님의 데이터가 내보내기되었습니다. 회원님의 데스크톱에 데이터를 저장하시려면, <a %s>이 링크</a>를 클릭하십시오.',
        'CLICK_GO_TO_START_EXPORT' => '‘내보내기’를 시작하려면 “Go”를 클릭하십시오.   가입자 수가 많을 경우 처리에 몇 분 정도가 소요될 수 있습니다.',
        'MEMBER' => '회원',
        'INVITED_BY_X' => '%s님이 초대합니다',
        'DONE' => '완료',
        'YOU_HAVE_BEEN_BANNED_FROM_APPNAME' => '회원님께서는 %s(에)서 금지되셨습니다',
        'MESSAGE_TO_ADMINISTRATOR' => '운영자에게 보내는 메시지',
        'SORRY_USERNAME' => '죄송합니다, %s님',
        'PENDING' => '보류',
        'ACCEPT' => '승인',
        'PENDING_APPROVAL' => '승인 대기 중',
        'ACCEPT_MEMBERSHIP' => '회원 가입 승인',
        'DECLINE_MEMBERSHIP' => '회원 가입 거절',
        'NO_PAGE_YET' => '아직 페이지가 없습니다',
        'YOUR_MEMBERSHIP_TO_X_IS_PENDING_APPROVAL' => '회원님의 %s에 가입 신청은 아직 운영자로부터의 승인을 기다리고 있는 중입니다.',
        'MEMBERSHIP_PENDING_APPROVAL' => '회원 가입 신청 – 승인 대기 중',
        'YOUR_PROFILE_IS_PENDING_APPROVAL' => '회원님의 프로필은 승인 대기 중입니다',
        'YOUR_PROFILE_DETAILS_MUST_BE_APPROVED_ON_X' => '회원님의 프로필 세부 사항에 대한 운영자의 승인을 받으셔야 %s의 회원이 되실 수 있습니다.  회원님의 프로필이 승인되면 그에 대한 통지가 이메일로 발송됩니다.',
        'CONTINUE_ARROW' => '속행 →',
        'LARR_BACK_TO_PENDING_MEMBERS' => '← 승인 대기 중인 회원’으로 가기',
        'X_IS_AWAITING_APPROVAL_TO_BECOME_MEMBER_OF_Y' => '%s님께서는 %s회원 가입 승인을 기다리고 있습니다.',
        'VIEW_PAGE' => '페이지 보기',
        'MESSAGE' => '메시지',
        'SEND_MESSAGE' => '메시지 발송',
        'MANAGE_FORUM_CATEGORIES' => '포럼 부류 관리하기',
        'START_DISCUSSIONS' => '토론 시작',
        'WELCOME_TO_YOUR_NEW_SOCIAL_NETWORK' => '회원님이 개설한 새로운 사교 네트워크에의 환영 말씀을 드립니다.',
        'NOW_ALL_YOU_NEED_TO_DO_IS_INVITE_YOUR_FRIENDS' => '이제 <a %s>친구 초대</a>만 하시면 됩니다!',
        'CONTRIBUTE' => '도움 주신 분:',
        'CUSTOMIZE_APPEARANCE_BADGES' => '<strong>맞춤형 설정 사항 </strong> <a %1$s>네트워크 외관</a>을 원하는 대로 바꾸고 <a %2$s>뱃지와 위짓</a>을 디자인 하십시오.',
        'CONTROL_MANAGE_PAGE' => '<strong>컨트롤. </strong><a %s>관리</a>페이지로 가시면 다양할 설정 옵션을 발견하실 수 있습니다.',
        'CREATE_GROUPS' => '그룹 만들기',
        'INVITE_MORE_PEOPLE' => '더 많은 사람 초대',
        'VIEW_THREAD' => '코멘트 경과 일별하기',
        'COMMENT_THREAD' => '코멘트 경과',
        'COMMENT_BACK' => '응답 코멘트 남기기',
        'HELLO_YOU_NEED_TO_ENABLE_JAVASCRIPT' => '안녕하십니까, 이 네트워크를 사용하려면 JavaScript를 허용하셔야 합니다.',
        'PLEASE_CHECK_YOUR_BROWSER_SETTINGS' => '회원님의 브라우저 설정을 확인하거나 시스템 운영자에게 연락하십시오',
        'MANAGE_MEMBERS_ADMINS_INVITED' => '가입자, 운영자, 초대받은 사람들, 금지된 사람들을 관리하기.',
        'MANAGE_MEMBERS' => '가입자 관리하기',
        'MANAGE_INVITED_PEOPLE' => '초대받은 사람들 관리하기',
        'NETWORK_SETTINGS' => '네트워크 설정',
        'PROMOTE_YOUR_NETWORK' => '네트워크 홍보',
        'NING_RESOURCES' => 'Ning이 제공하는 유용한 도구들',
        'ADD_PREMIUM_SERVICES' => '프리미엄 서비스 추가',
        'REQUEST_SOURCE_CODE' => '출처 액세스 코드 요청',
        'REQUEST_A_COPY_OF_THE_SOURCE_CODE' => '개발자: 네트워크를 실행에 필요한 출처 코드에 대한 액세스를 요청하세요.',
        'JOIN_NETWORK_CREATORS' => '사교 네트워크 개설자 모임에 가입',
        'SEND_MESSAGE_TO_ALL_THIS' => '네트워크의 모든 가입자들에게 메시지 전송하기.',
        'CREATE_ANOTHER_NETWORK' => '또 다른 네트워크 개설하기',
        'HAVE_ANOTHER_GREAT_IDEA' => '사교 네트워크에 관한 좋은 아이디어가 있으십니까?',
        'ALLOW_FACEBOOK_USERS_TO' => 'Facebook 사용자들로 하여금 회원님의 네트워크의 위짓을 자신들의 프로필 페이지에 게재할 수 있도록 허용하기.',
        'BADGES_AND_WIDGETS' => '뱃지 및 위짓',
        'CUSTOMIZE_WIDGETS_AND_BADGES' => '회원님의 네트워크에 사용되는 위짓과 뱃지를 모양을 맞춤형으로 만들기.',
        'GET_BADGES' => '뱃지 받기',
        'CUSTOM_TEXT' => '맞춤형 글체',
        'IM_A_MEMBER_OF' => '나는 다음과 같은 네트워크의 회원입니다:',
        'DONT_DISPLAY_ANY_BRANDING' => '로고나 마크를 전혀 쓰지 않기.',
        'WATERMARK_OR_LOGO_IMAGE' => '워터마크 또는 로고 이미지:',
        'NETWORK_BRANDING_BADGES' => '네트워크 브랜딩: 뱃지',
        'NETWORK_BRANDING_WIDGETS' => '네트워크 브랜딩: 위짓',
        'LOGO_IMAGE' => '로고 이미지',
        'SMALL_NETWORK_BADGE' => '소형 네트워크 뱃지',
        'LARGE_NETWORK_BADGE' => '대형 네트워크 뱃지',
        'REFRESH' => '리후레쉬하기',
        'HTML_EMBED_CODE' => 'HTML 임베드 코드:',
        'CUSTOMIZE' => '맞춤형 지정',
        'SHARE_TITLE' => '\'%s\' 공유',
        'SHARE_TYPE' => '%s 공유',
        'YOUR_MESSAGE_SENT' => '회원님의 메시지가 성공적으로 발송되었습니다.',
        'YOUR_MESSAGES_SENT' => '회원님의 메시지들이 모두 성공적으로 발송되었습니다.',
        'YOU_CAN_SHARE_TYPE_TWO_WAYS' => '이 %s(은)는 두 가지 방법으로 공유하실 수 있습니다 &#8230;',
        'CHECK_OUT_THIS_TYPE_TITLE' => '이 %s를 둘러 보세요: "%s"',
        'CHECK_OUT_THIS_TYPE' => '이 %s(을)를 둘러 보세요.',
        'PHOTO_ALBUM' => '포토 앨범',
        'CUSTOMIZE_YOUR_BADGES_AND_WIDGETS' => '뱃지과 위짓을 회원님 자신의 독특한 색상과 이미지를 사용하여 원하는 대로 꾸며 보세요.  회원님의 변경 사항이 다른 웹사이트에 반영되기까지는 최대 4시간까지 걸릴 수 있습니다.',
        'BACKGROUND_IMAGE_AND_COLOR' => '배경 이미지 & 색상',
        'USE_THIS_FORM_TO_REPORT_ISSUE_TO_NC' => '이 양식을 사용하여 <a %s>%s</a>의 사교 네트워크 개설자인<a %s>%s</a>님에게 문제를 통고해 주세요.',
        'SORRY_NCS_CANNOT_CHANGE_EMAIL' => '죄송합니다, 사교 네트워크 개설자는 자신의 소유가 아닌 사교 네트워크를 통해 자신의 이메일 주소를 변경할 수 없습니다.',
        'SORRY_NCS_CANNOT_CHANGE_PASSWORD' => '죄송합니다, 사교 네트워크 개설자는 자신의 소유가 아닌 사교 네트워크를 통해 자신의 비밀번호를 변경할 수 없습니다.',
        'GO' => '"(로, 으로) 이동하다"',
        'LARGE_THUMBNAILS' => '대형 썸네일',
        'SMALL_THUMBNAILS' => '소형 썸네일',
        'RECENTLY_JOINED' => '최신',
        'MOST_POPULAR_MEMBERS' => '최고 인기',
        'NO_MEMBERS_TO_DISPLAY' => '회원님께서는 현재 가입자를 표시하지 않고 계십니다.',
        'BOX_WILL_NOT_SHOW_MEMBERS' => '회원님이 적어도 한 줄의 가로행을 선택하지 않는 한, 다른 사람들은 이 상자를 볼 수 없습니다.',
        'DETAIL_VIEW' => '세부 내용 보기',
        'TITLES_ONLY' => '제목만',
        'RECENTLY_ADDED_POSTS' => '최근 추가 항목',
        'POPULAR_POSTS' => '가장 많은 코멘트를 받은 항목',
        'PROMOTED_POSTS' => '추천',
        'BOX_WILL_NOT_SHOW_BLOG_POST' => '회원님께서 적어도 한 개의 게시물을 선택하지 않는 한, 다른 사람들은 이 상자를 볼 수 없습니다.',
        'KEEP_WINDOW_OPEN_UPLOAD' => '업로드가 진행되는 동안 이 브라우저 창을 계속해서 열어 놓으세요.',
        'CANCEL_UPLOAD' => '업로드 취소',
        'YOU_DO_NOT_HAVE_POSTS' => '회원님께서는 아직 아무런 게시물도 작성하지 않으셨습니다.',
        'YOU_DO_NOT_HAVE_COMMENTS' => '승인할 코멘트가 없습니다.',
        'REQUIRED_FIELD' => '(입력이 반드시 필요한 필드)',
        'BLOG_POST_BY_X' => '%s님의 블로그 게시물',
        'HELLO' => '안녕하십니까.',
        'ADDED_BY_X' => '%s님이 추가한 포스트',
        'CLICK_TO_ADD_A_TITLE' => '클릭하여 제목 추가',
        'DELETE_BLOG_POST' => '게시물 삭제하기',
        'DELETE_THIS_BLOG_POST_Q' => '이 블로그 게시물을 삭제하시겠어요?',
        'ARE_YOU_SURE_DELETE_THIS_BLOG_POST' => '이 블로그 게시물을 정말로 삭제하기 원하세요?  몇 분 정도 소요될 수 있습니다.',
        'SPINNER' => 'Spinner',
        'PLEASE_ENTER_SOMETHING_FOR_X' => '다음을 위해 뭔가 입력해 주세요: %s',
        'PLEASE_SELECT_OPTION_FOR_X' => '다음을 위한 옵션을 선택하세요: %s',
        'PLEASE_PROVIDE_VALID_DATE_FOR_X' => '이 곳에 유효한 날짜를 입력하세요: %s',
        'PLEASE_PROVIDE_DATE_FOR_X' => '이 곳에 날짜를 입력하세요: %s',
        'XS_BLOG_POSTS_FOR_M_Y' => '%s %s를 위한 %s님의 블로그 게시물',
        'FEATURED_BLOG_POSTS_FOR_M_Y' => '%s %s(을)를 위한 추천 블로그 게시물',
        'BLOG_POSTS_FOR_M_Y' => '%s %s(을)를 위한 블로그 게시물',
        'FEATURED_BLOG_POSTS' => '추천 블로그 게시물',
        'EVERYONES_POSTS' => '모두의 블로그 포스트',
        'PUBLISHED_N_OF_N' => '%d의 %d를 게시함',
        'DOWNLOAD_X' => '%s 다운로드하기',
        'UPLOAD_DID_NOT_WORK' => '죄송합니다, 업로드가 제대로 이루어지지 않았습니다',
        'F_J_Y' => 'F j, Y',
        'M_J_Y' => 'M. j, Y',
        'XS_POSTS' => '%s님의 게시물',
        'USERNAMES_COMMENTS' => '%s님의 코멘트',
        'ADD_COMMENT' => '코멘트 추가하기',
        'XS_PAGE' => '%s님의 페이지',
        'XS_BLOG' => '%s님의 블로그',
        'XS_FRIENDS' => '%s님의 친구',
        'VIEW_XS_ELLIPSIS' => '%s님의보기...',
        'DRAFT_BRACKETS' => '[초안 ]',
        'FEATURED' => '추천',
        'MY_POSTS' => '나의 게시물',
        'MY_POSTS_ONLY' => '나의 게시물만 보기',
        'OWNER_POSTS_ONLY' => '개설자의 게시물만 보기',
        'JANUARY' => '1월',
        'FEBRUARY' => '2월',
        'MARCH' => '3월',
        'APRIL' => '4월',
        'MAY' => '5월',
        'JUNE' => '6월',
        'JULY' => '7월',
        'AUGUST' => '8월',
        'SEPTEMBER' => '9월',
        'OCTOBER' => '10월',
        'NOVEMBER' => '11월',
        'DECEMBER' => '12월',
        'MY_COMMENTS' => '나의 코멘트',
        'AM' => '오전',
        'PM' => '오후',
        'MY_PAGE' => '나의 페이지',
        'MY_PAGE_TAB_TEXT' => '나의 페이지',
        'BLOG_POSTS' => '블로그 게시물',
        'MY_BLOG' => '나의 블로그',
        'MONTH' => '월',
        'DAY' => '일',
        'PICK_VALID_DEFAULT_VISIBILITY' => '표시되는 기본값을 설정할 유효한 선택을 하세요.',
        'PICK_VALID_WHO_CAN_COMMENT' => '코멘트 자격이 있는 사람을 지정할 유효한 선택을 하세요.',
        'PICK_VALID_BLOG_COMMENT_MODERATION' => '블로그 코멘트 중재할 수 있는 유효한 선택을 하세요.',
        'PICK_VALID_ACTIVITY_NOTIFICATION' => '활동 사항 통지 기능을 위한 유효한 선택을 하십시오',
        'PICK_VALID_MODERATION_NOTIFICATION' => '중재 사항 통지 기능을 위한 유효한 선택을 하세요.',
        'PICK_VALID_APPROVAL_NOTIFICATION' => '승인 여부 통지를 위한 유효한 선택을 하세요.',
        'PICK_VALID_INVITEE_NOTIFICATION' => '초대받은 사람이 가입한 경우의 통지 기능을 위한 유효한 선택을 하세요.',
        'PICK_VALID_NEVER_NOTIFICATION' => '어떠한 종류의 통지도 받고 싶지 않으신 경우에 필요한 유효한 선택을 하세요.',
        'PICK_VALID_FRIEND_REQUEST_NOTIFICATION' => '친구 요청이 있는 경우의 통지 기능을 위한 유효한 선택을 하세요.',
        'PICK_VALID_NEW_MESSAGE_NOTIFICATION' => '새로운 메세지가 있슴을 알려주는 통지 기능을 위한 유효한 선택을 하세요.',
        'APPROVE_COMMENT' => '코멘트 승인',
        'MANAGE_BLOG' => '블로그 관리',
        'COMMENTS_POSTED_ON_BLOG' => '나의 블로그에 게시된 코멘트',
        'COMMENT' => '코멘트',
        'COMMENTER' => '코멘트 게시자',
        'POST' => '게시물',
        'M_J_Y_G_IA' => 'M j, Y, g:ia',
        'POST_HAS_BEEN_DELETED' => '게시물이 삭제되었습니다',
        'COMMENTS_ARE_CLOSED' => '이 블로그 게시물에는 더 이상 코멘트를 추가할 수 없습니다',
        'NO_COMMENTS' => '코멘트 없음',
        'FLAG' => '깃발 달기',
        'POST_TITLE' => '게시물 제목',
        'DRAFT_PARENTHESES' => '(초안)',
        'SCHEDULED_TO_PUBLISH_ON' => '게시 예정일: %s',
        'EDIT_2' => '편집',
        'NONE' => '없음',
        'N_NEW' => '%s 새 게시물',
        'NO_POSTS' => '게시물 없음',
        'ADD_NEW_BLOG_POST' => '새 블로그 게시물 추가',
        'HAPPY' => '기쁨',
        'SAD' => '슬픔',
        'COOL' => '멋짐',
        'EVIL' => '심술',
        'MAD' => '화남',
        'ENVIOUS' => '부러움',
        'ENTRY' => '입력',
        'WHAT_DATE_FOR_YOUR_POST' => '회원님의 게시물을 언제 게시해 드릴까요?',
        'NOW' => '지금',
        'CHOOSE_DATE_AND_TIME' => '날짜와 시간을 선택하십시오(향후의 날짜를 선택하면 게시물은 그 날짜에 게시됩니다)',
        'PRIVACY_AND_COMMENTS' => '공개 여부 및 코멘트 설정',
        'WHO_CAN_VIEW_POST' => '누가 이 게시물을 볼 수 있습니까?',
        'EVERYONE' => '모두',
        'ALLOW_COMMENTS' => '이 게시물에 코멘트를 허용하시겠습니까?',
        'YES' => '예',
        'NO' => '아니오',
        'COMMENT_MODERATION' => '코멘트 검토',
        'YOU_ARE_MODERATING_BLOG_COMMENTS' => '회원님께서는 현재 모든 블로그 코멘트를 검토 후 게시하도록 설정하고 있습니다.',
        'YOU_ARE_NOT_MODERATING_BLOG_COMMENTS' => '회원님께서는 현재 블로그 코멘트를 검토 없이 곧바로 게시하도록 설정하고 있습니다.',
        'SAVE_AS_DRAFT' => '임시 저장',
        'PREVIEW' => '미리 보기',
        'PUBLISH_POST' => '게시물 올리기',
        'THIS_IS_PREVIEW_OF_BLOG_POST' => '이것은 회원님의 블로그 게시물이 어떻게  게시될지 미리 보기 위한 기능입니다.  \'뒤로’를 클릭하여 게시물을 편집하시거나, 그대로 마음에 드시면 ‘올리기’를 클릭하세요!',
        'BACK' => '뒤로',
        'PUBLISH' => '올리기!',
        'BLOG_POST' => '블로그 게시물',
        'PROFILE' => '프로필',
        'THIS_IS_UNPUBLISHED_DRAFT' => '이것은 아직 게시되지 않은 초안입니다',
        'WILL_BE_PUBLISHED_ON_X' => '%s <small>%s</small>에 게시될 것입니다',
        'POSTED_ON_X' => '<strong>%s</strong> <small>%s</small>를 게시했습니다',
        'POSTED_ON_X_BY' => '<strong>%s</strong> <small>%s</small>의 게시자:',
        'ABOUT_THIS_POST' => '이 포스트에 대하여',
        'ABOUT_YOUR_POST' => '회원님의 포스트에 대하여',
        'ADDED_BY' => '추가한 사람:',
        'JUST_FRIENDS' => '친구',
        'RECENT_POSTS' => '최근 게시물',
        'THERE_ARE_NO_RECENT_POSTS' => '최근의 게시물이 없습니다.',
        'YOUR_COMMENT_HAS_BEEN_ADDED_BUT' => '회원님의 코멘트가 추가되었지만 승인을 받아야 모든 사람들이 볼 수 있게 됩니다..',
        'AT_TIME_ON_DATE_USERNAME_SAID' => '%s일 %s시에, %s 님이 다음과 같은 코멘트를 남겼습니다...',
        'X_DOES_NOT_HAVE_ANY_FRIENDS' => '%s님은 아직 이 동호회에 친구가 없군요.',
        'YOU_DO_NOT_HAVE_ANY_FRIENDS' => '회원님께서는 아직 이 동호회에서 친구가 없군요.',
        'EDIT_PAGE_APPEARANCE' => '페이지 보기 편집',
        'VIEW_PAGE_AS_OTHERS' => '다른 사람들에게 보여 지는 대로의 페이지 보기',
        'ADD_BLOG_POST' => '블로그 게시물 추가',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED_2' => '%s님의 컨텐츠가 삭제되는 동안 계속해서 이 브라우저 창을 열어 두십시오.  몇 분 정도 소요될 수 있습니다.',
        'BAN_MEMBER_FROM_NETWORK' => '네트워크로부터 특정 가입자를 금지하기',
        'BAN_USERNAME' => '%s님을 금지하시겠습니까 ?',
        'BLOCK' => '차단하다',
        'CREATE_NEW_BLOG_POST' => '새로운 블로그 게시물을 작성하세요!',
        'EDIT_POST' => '게시물 편집',
        'EDIT_POST_COLON' => '게시물 편집:',
        'CONTINUE_READING' => '계속 읽기...',
        'POSTED_BY_ME_LINK_ON_X_AT_X' => '<a %s>회원님</a>께서 %s에 %s로 올린 항목—',
        'POSTED_BY_X_ON_X_AT_X' => '%s님께서 %s에 %s로 올린 항목—',
        'POSTED_BY_ME_ON_X_AT_X' => '회원님께서 %s에 %s로 올린 항목—',
        'ADD' => '추가',
        'SUBSCRIBE' => '가입',
        'VIEW_ARCHIVES' => '지난 자료 보기',
        'YOUR_SETTINGS_HAVE_BEEN_SAVED' => '회원님의 설정이 저장되었습니다.',
        'PLEASE_CORRECT_THE_FOLLOWING' => '다음을 수정해 주세요:',
        'PRIVACY' => '개인정보',
        'NETWORK_PRIVACY' => '네트워크의 개인정보 설정',
        'THIS_NETWORK_VISIBLE_TO_EVERYONE' => '이 네트워크는  <strong> 누구나 볼 수 있습니다</strong>.',
        'ANYONE_CAN_SIGN_UP_VISITORS_CAN' => '누구나 회원 가입을 할 수 있습니다.  방문자에게 다음과 같은 권한이 주어집니다...',
        'SEE_EVERYTHING' => '전부 볼 수 있도록',
        'SEE_JUST_THE_MAIN_PAGE' => '메인 페이지만 볼 수 있도록',
        'SEE_JUST_THE_SIGN_UP_PAGE' => '가입자 등록 페이지만 볼 수 있도록',
        'THIS_NETWORK_VISIBLE_MEMBERS_ONLY' => '이 네트워크는 <strong>회원들만 볼 수 있습니다</strong>.',
        'WHO_CAN_SIGN_UP' => '어떤 사람이 회원으로 가입할 수 있나요?',
        'MODERATION' => '컨텐츠 제어정책',
        'APPROVE_MEMBERS_BEFORE_JOIN' => '새로운 회원이 가입하기 전 승인하기',
        'APPROVE_PHOTOS_VIDEOS' => '사진과 동영상의 게시 전 승인하기',
        'SHOW_LATEST_ACTIVITY_ON_YOUR_NETWORK' => '회원님의 네트워크에서의 최신 활동 내용을 보여드립니다!',
        'PUT_A_CONSTANTLY_UPDATED_STREAM' => '회원님의 네트워크 메인 페이지에 지속적으로 업데이트 되는 최신 활동 내용 스트림을 올려 두기.',
        'CLICK_HERE_TO_ADD_LATEST_ACTIVITY' => '이 곳을 클릭하여 ‘최신 활동 내용’을 회원님의 네트워크에 추가하세요.',
        'THESE_OPTIONS_ARE_DISABLED_ACTIVITY' => '회원님의 네트워크에 ‘최신 활동 내용’이 없으므로 이들 옵션을 사용하실 수 없습니다.',
        'ACTIVITY' => '활동 내용',
        'DISPLAY_PREFERENCES' => '선호 사항 설정 표시하기',
        'NEW_CONTENT' => '새 컨텐츠',
        'NEW_COMMENTS' => '새 코멘트',
        'NEW_MEMBERS' => '새 가입자',
        'MEMBER_UPDATES' => '가입자 업데이트',
        'WHAT_DISPLAYS_LATEST_ACTIVITY' => '회원님의 네트워크의<br />’최신 활동 내용’에 어떤 사항들이 표시되나요 ?',
        'LATEST_ACTIVITY' => '최신 활동 내용',
        'X_COMMENTED_ON_POST_TITLE' => '%1$s가 %2$s 토론에 답글을 게시하였습니다',
        'X_LINK_COMMENTED_ON_POST_LINK_TITLE' => '%1$s님이 <a %3$s>%4$s</a>토론에<a %2$s> 답글을 게시</a>하셨습니다',
        'YOU_LINK_COMMENTED_ON_POST_LINK_TITLE' => '회원님은 <a %2$s>%3$s</a>토론에 <a %1$s>답글을 게시</a> 하셨습니다',
        'X_COMMENTED_ON_BLOG_POST_TITLE' => '%1$s님이 %2$s블로그 게시물에 코멘트를 남기셨습니다',
        'X_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '%1$s님이 <a %3$s>%4$s</a>블로그 게시물에<a %2$s> 코멘트를 남기셨습니다</a>.',
        'YOU_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '회원님께서는 <a %2$s>%3$s</a>블로그 게시물에<a %1$s>코멘트를 남기셨습니다</a>.',
        'X_STARTED_A_DISCUSSION_Y' => '%s님이 %s(이)라는 제목의 토론을 시작하셨습니다.',
        'YOU_STARTED_A_DISCUSSION_Y' => '회원님께서 %s(이)라는 제목의 토론을 시작하셨습니다.',
        'X_ADDED_THE_BLOG_POST_Y' => '%s님이 \'%s\'라는 블로그 게시물을 추가하셨습니다',
        'YOU_ADDED_THE_BLOG_POST_Y' => '회원님은 블로그 게시물 \'%s\'을(를) 추가하셨습니다',
        'X_JOINED_THE_GROUP_Y' => '%s님이 %s그룹에 가입하셨습니다',
        'YOU_JOINED_THE_GROUP_X' => '회원님께서는 %s그룹에 가입하셨습니다',
        'X_JOINED_Y_GROUPS' => '%s님께서는 %s 그룹에 가입하셨습니다.',
        'YOU_JOINED_X_GROUPS' => '회원님께서는 %s 그룹에 가입하셨습니다',
        'X_JOINED_APPNAME' => '%s 님이 %s에 가입했습니다. %s 님에게 <a %s>답글을 남기십시오</a>.',
        'WELCOME_MEMBER_N_OF_APPNAME' => '환영합니다, %1$s님!  회원님께서는 %3$s중 #%2$s 째 가입자이십니다.',
        'WELCOME_MEMBER_N_OF_APPNAME_FIND' => '환영합니다, %1$s님!  회원님께서는 %3$s중 #%2$s 째 가입자이십니다.  <a %4$s>지금 친구를 찾아 보십시오</a>.',
        'X_IS_MEMBER_N_OF_APPNAME' => '%1$s님은 %3$s 중 #%2$s째 가입자이십니다.',
        'XS_PROFILE_CHANGED' => '%s님 의 프로필이 변경되었습니다',
        'YOUR_PROFILE_CHANGED' => '회원님의 프로필이 변경되었습니다',
        'X_LEFT_A_COMMENT_FOR_Y' => '%s님께서 %s에 코멘트를 남기셨습니다',
        'YOU_LEFT_A_COMMENT_FOR_X' => '회원님께서는 %s 에 코멘트를 남기셨습니다',
        'X_LEFT_A_COMMENT_FOR_YOU' => '%s님이 회원님를 위해 코멘트를 남기셨습니다',
        'X_CREATED_A_GROUP_Y' => '%s님께서 %s(이)라는 이름의 그룹을 만드셨습니다',
        'YOU_CREATED_A_GROUP_Y' => '회원님께서는 %s(이)라는 이름의 그룹을 만드셨습니다',
        'X_CREATED_Y_NEW_GROUPS' => '%s님은 %s 개의 새 그룹을 만드셨습니다',
        'X_STARTED_Y_FORUM_POSTS' => '%님께서 %s개의 새 포럼 토론을 시작하셨습니다',
        'YOU_STARTED_Y_FORUM_POSTS' => '회원님께서 %s개의 새 포럼 토론을 시작하셨습니다',
        'X_ADDED_Y_BLOG_POSTS' => '%s님은 %s 개의 새 블로그 게시물을 추가하셨습니다',
        'YOU_ADDED_Y_BLOG_POSTS' => '회원님께서는 %s 개의 새 블로그 게시물을 추가하셨습니다.',
        'VIEW_XS_BLOG_POSTS' => '%s님의 블로그 게시물 보기',
        'VIEW_YOUR_BLOG_POSTS' => '회원님의 블로그 게시물 보기',
        'APPNAME_HAS_NEW_PROFILE_QUESTIONS' => '%s님께서 <a %s>새로운 프로필 질문</a>이 있다는군요.',
        'APPNAME_NOW_HAS_MUSIC' => '%s에는 이제 뮤직 플레이어가 있습니다',
        'APPNAME_NOW_HAS_GROUPS' => '%s에는 이제 <a %s>그룹</a>이 있습니다',
        'APPNAME_NOW_HAS_VIDEO' => '%s에는 이제 <a %s>동영상</a>이 있습니다',
        'APPNAME_NOW_HAS_FORUM' => '%s에는 이제 <a %s>포럼</a>이 있습니다',
        'APPNAME_NOW_HAS_PHOTO' => '%s에는 이제 <a %s>사진</a>이 있습니다',
        'DID_YOU_KNOW' => '알고 계세요…',
        'ANNOUNCEMENT' => '알림',
        'CONGRATULATIONS' => '축하합니다',
        'YOU_CREATED_APPNAME' => '회원님께서는 %s 네트워크를 만드셨습니다',
        'USER_CREATED_APPNAME' => '%s님께서 %s network를 만드셨습니다.',
        'ADD_MESSAGES_ACTIVITY_FEED' => '메시지를 추가하고 네트워크의 활동 내용 입력창구에 표시할 내용을 선택하세요.',
        'WHICH_OF_YOUR_ACTIONS_DISPLAY_ACTIVITY' => '회원님의 활동 내용 중 어느 것을 <br />’최신 활동 내용’에 표시하시겠습니까 ?',
        'NEW_CONTENT_I_ADD' => '내가 추가한 새 컨텐츠',
        'NEW_COMMENTS_I_ADD' => '내가 추가한 새 코멘트',
        'WHEN_I_UPDATE_MY_PROFILE' => '나의 프로필 업데이트 날짜',
        'THE_LATEST_ACTIVITY_WILL_NEVER' => '‘최신 활동 내용’에서는 보낸 메시지, 본 페이지나 회원, 거절한 초청, 친구 요청을 허락하거나 거절한 회원, 삭제한 것 등을 절대로 표시하지 않습니다.',
        'YOU_HAVENT_DONE_ANYTHING_RECENTLY' => '최근의 활동 내용이 없습니다.  원가 한 번 시작해 보시겠어요?',
        'YOUVE_TURNED_OFF_THE_ACTIVITY_DISPLAY_CLICK' => '활동 내용의 표시를 껐습니다..  다시 켜려면 <a %s>이 곳을 클릭하세요. </a>',
        'THE_NETWORK_CREATOR_HAS_TURNED_OFF_THE_ACTIVITY' => '네트워크 개설자가 모든 활동 내용의 표시를 차단했습니다.',
        'NO_ACTIVITY_TO_DISPLAY' => '회원님께서는 현재 아무런 활동내용이 없는 것으로 나타나 있습니다.',
        'BOX_WILL_NOT_SHOW_ACTIVITY' => '최소한 한 개의 활동 내용을 선택하지 않는 한 다른 사람들은 이 상자를 볼 수 없습니다.',
        'NOTHING_IS_HAPPENING_ON_YOUR_NETWORK' => '최근 활동 내역이 없습니다  원가 한 번 시작해 보시겠어요?',
        'MY_ACTIVITY_PREFERENCES' => '나의 활동 내용 선호사항',
        'DELETE_ACTIVITY_ITEM' => '활동 내용 메시지 삭제',
        'DELETE_THIS_ACTIVITY_MESSAGE_Q' => '활동 내용 메시지를 삭제하시겠어요?',
        'THIS_WILL_PREVENT_ACTIVITY' => '삭제하시면 다른 사람이 이 활동 내용 메시지를 보는 것을 방지하게 됩니다.',
        'X_HAS_POSTED_THE_MOST_PHOTOS' => '%1$s님이 이제까지 가장 많은 %2$s사진%3$s을 올렸습니다',
        'X_IS_THE_MOST_POPULAR_PHOTO' => '%s 은(는) 지금까지 가장 인기 있는 사진입니다',
        'X_HAS_POSTED_THE_MOST_VIDEOS' => '%1$s님이 이제까지 가장 많은 %2$s동영상%3$s을 올렸습니다',
        'X_IS_THE_MOST_POPULAR_VIDEO' => '%s (은)는 지금까지 가장 인기 있는 동영상입니다',
        'X_HAS_POSTED_THE_MOST_MUSIC' => '%s님이 이제까지 가장 많은 노래를 올렸습니다',
        'X_IS_THE_MOST_POPULAR_MUSIC' => '%s(은)는 지금까지 가장 인기 있는 노래입니다',
        'X_IS_THE_MOST_POPULAR_TOPIC' => '%s(은)는 지금까지 가장 인기 있는 포럼입니다',
        'X_IS_THE_MOST_POPULAR_BLOG_POST' => '%s(은)는 지금까지 가장 인기 있는 블로그 게시물입니다',
        'XS_LATEST_ACTIVITY_ON_APPNAME' => '%s에서 %s님의 최신 활동 내용.',
        'LATEST_ACTIVITY_ON_APPNAME' => '%s에서의 최신 활동 내용',
        'ADD_MESSAGE_TO_LATEST_ACTIVITY' => '최신 활동 내용에 메시지 추가',
        'ADD_FACTS_ABOUT_THE_NETWORK_ELLIPSIS' => '네트워크에 대한 설명 추가...',
        'ADD_MESSAGE' => '메시지 추가',
        'ELLIPSIS_OR_WRITE_YOUR_OWN_MESSAGE' => '...또는 직접 메시지 작성',
        'NETWORK' => '네트워크',
        'WHO_CAN_VIEW_YOUR_PHOTOS_VIDEOS' => '기본 설정 상에서는 누가 사진, 동영상 <br/>및 블로그 게시물을 볼 수 있도록 돼 있나요?',
        'YOU_CAN_OVERRIDE_WHEN_YOU_ADD' => '(사진, 동영상 또는 블로그 게시물을 추가 시 사진, 동영상 또는 블로그 게시물 설정의 기본 설정 사항을 변경할 수 있습니다.)',
        'MODERATE_COMMENTS_ON_BLOG' => '코멘트가 블로그에 게시되기 <br/>전 사전 승인을 받아야 하도록 설정하시겠어요?',
        'YES_LET_ME_APPROVE' => '예– 제가 코멘트 승인을 할 수 있게 해 주세요.',
        'NO_PUBLISH_COMMENTS' => '아니오–  코멘트를 즉시 게시해 주십시오',
        'WHO_CAN_COMMENT_ON_PHOTOS_VIDEOS' => '누가 회원님의 사진, <br/> 동영상 및 블로그에 코멘트를 할 수 있도록 돼 있나요?',
        'SAVE' => '저장하기',
        'EMAIL' => '이메일',
        'YOUR_PRIVACY_IS_IMPORTANT' => '저희는 회원님의 개인 정보를 소중히 여깁니다.  이메일 통지 기능에 대한 질문이 있으시면  <a href="http://help.ning.com/?page_id=27">도우미 센터</a>를 통해 저희에게 연락해 주세요.',
        'ADD_PHOTOS_AND_VIDEOS_TO_X_BY_SENDING' => '%s에 사진과 동영상을 추가하시려면 다음의 이메일 주소로사진과 동영상을보내주세요:',
        'ADD_PHOTOS_AND_VIDEOS_TO_APPNAME_FROM_PHONE' => '휴대전화 상의 사진과 동영상을 %s에 추가하시려면 다음의 이메일 주소로 사진과 동영상을 보내주세요:',
        'GENERATE_NEW_EMAIL_ADDRESS' => '새 이메일 주소 만들기',
        'SUPPORTS_TEXT_EMBEDDED' => '텍스트, 임베드 동영상, 사진 및 위짓을 지원합니다.',
        'POST_COMMENT' => '코멘트 올리기',
        'YOU_NEED_TO_BE_MEMBER_COMMENTS' => '코멘트를 달려면 우선 %s의 가입자가 되어야 합니다!',
        'MONTHLY_ARCHIVES' => '월별 기록',
        'NO_FRIENDS_ON_SITE' => '이 사교 네트워크에는 아직 친구가 없군요.',
        'NO_FRIENDS_ON_SITE_THAT_MATCH' => '이 사교 네트워크에는 회원님의 검색 조건에 맞는 친구가 없군요.',
        'MEMBERS_TAB_TEXT' => '회원',
        'SITE_HAS_NO_MEMBERS' => '이 사교 네트워크는 아직 가입자가 없습니다!',
        'SITE_HAS_NO_MEMBERS_THAT_MATCH' => '이 사교 네트워크에는 회원님의 검색 조건과 일치하는 가입자가 없습니다.',
        'NO_COMMENTS_YET' => '아직 코멘트가 없습니다!',
        'VIEW_ALL_COMMENTS' => '모든 코멘트 보기',
        'YOU_HAVE_NOT_ADDED_BLOG_POSTS' => '회원님께서는 아직 어떠한 블로그 게시물도 추가하시지 않으셨습니다!',
        'YOU_CAN_WRITE_ABOUT_ANYTHING' => '쓰고 싶은 것이나 이야기 하고 싶은 것은 어떤 것이든 쓰실 수 있고 동영상, 사진, 음악 등을 글 속에 포함하실 수 있어요.',
        'WRITE_YOUR_FIRST_ENTRY' => '첫 번째 글을 작성하십시오!',
        'THERE_ARE_NO_BLOG_POSTS' => '회원님의 사교 네트워크에는 현재 블로그 게시물이 없습니다.',
        'THERE_ARE_NO_FEATURED_X' => '회원님의 사교 네트워크에는 인기항목으로 지정된 %s(이)가 없습니다.',
        'THERE_ARE_NO_X_THAT_MATCH_SETTINGS' => '회원님께서 선택하신 설정과 일치하는 %s(이)가 없습니다.',
        'START_FEATURING_X_CLICK_Y' => '’인기 항목’ 옵션이 있는 곳에서 %s을 인기 항목으로 추천해 보세요.  추천 기능에 대한 더 자세한 정보는 <a %s>이 곳을 클릭하십시오</a>.',
        'THIS_BOX_WILL_NOT_SHOW_BLOG_POSTS' => '볼 수 있는 블로그 게시물이 있을 때까지 다른 사람들은 이 상자를 볼 수 없습니다.  블로그를 한 건 추가해 보시겠어요?',
        'YOUR_FRIEND' => '회원님의 친구',
        'REQUEST_SENT' => '요청 전송 완료!',
        'BLOCKED' => '차단됨',
        'BANNED' => '금지된',
        'ADD_YOUR_FIRST_BLOG_POST' => '회원님의 첫 번째 블로그 게시물 추가',
        'MY_FIRST_BLOG_POST' => '나의 첫 번째 블로그 게시물!',
        'TELL_THE_PEOPLE_ON' => '%s에서 회원들에게 자신을 소개 해 보세요.  <span %s>잠금</span>이라는 표시가 있는 질문은 비공개이며 관리자만 볼 수 있습니다.',
        'CHOOSE_A_THEME_FOR_PAGE' => '페이지 테마 선택',
        'NOW_CUSTOMIZE_PAGE' => '이제 회원님의 페이지를 맞춤 설정하십시오...',
        'NO_POSTS_TO_DISPLAY' => '표시할 게시물이 없습니다.',
        'YOU_ARE_DISPLAYING_NO_POSTS' => '현재 표시되는 게시물이 없습니다.',
        'DATE_COLON' => '날짜:',
        'TIME_COLON' => '시간:',
        'CHANGE' => '변경',
        'UPLOAD_A_PHOTO' => '사진 업로드',
        'OPTIONS' => '옵션',
        'PIXELS' => '픽셀',
        'CANCEL' => '취소하기',
        'UPLOAD_A_FILE' => '파일 업로드:',
        'TO_INSERT_A_FILE' => '파일을 추가하려면 상단의 “브라우즈”나 “선택”버튼을 클릭하여 회원님의 컴퓨터 상에 저장된 파일을 찾으세요.',
        'UPLOADING' => '업로딩 중...',
        'OK' => 'OK',
        'POPULAR_MEMBERS' => '인기 회원',
        'INVITE_FRIENDS' => '친구 초대하기',
        'VIEW_ALL' => '모두 보기',
        'REMOVE_X' => '%s 삭제',
        'ARE_YOU_SURE_BAN_X_AND_CONTENT' => '정말로 %1$s님을 회원님의 사교 네트워크에서 금지하고 %1$s가 추가한 모든 컨텐츠를 삭제하시겠어요?  몇 분 정도 소요될 수 있습니다.',
        'REMOVING_X' => '%s삭제',
        'ARE_YOU_SURE_BAN_MEMBERS_AND_CONTENT' => '정말로 지정된 회원(들)을 회원님의 사교 네트워크에서 금지시키고 이들이 올린 모든 컨텐츠를 삭제하시겠어요?  몇 분 정도 소요될 수 있습니다.',
        'ARE_YOU_SURE_BAN_MEMBERS' => '지정된 회원(들)을 회원님의 사교 네트워크에서 정말로 금지시키시겠어요?  몇 분 정도 소요될 수 있습니다.',
        'BAN' => '금지',
        'REMOVING_MEMBERS' => '회원 삭제',
        'FEMALE' => '여성',
        'MALE' => '남성',
        'UNITED_STATES' => '미국',
        'AND' => '및',
        'FROM' => '로부터',
        'GENDER_M' => '남성',
        'GENDER_F' => '여성',
        'XS_PAGE_ON_Y' => '%s상의 %s님의 페이지',
        'SEARCH_MEMBERS' => '회원 검색',
        'SOMEBODY_COMMENTED_BLOGPOST_ADDED_TO_X' => '회원님께서 %s에 추가한 블로그 게시물에 누군가가 코멘트를 남겼습니다',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE' => '회원님의 페이지에 새로운 코멘트가 게시되어 있습니다.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X' => '회원님의 %s페이지에 새로운 코멘트가 게시되어 있습니다.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X_ELLIPSIS' => '회원님의 %s페이지에 새로운 코멘트가 게시되어 있습니다....',
        'A_BLOG_POST' => '블로그 게시물',
        'NOW_THAT_YOU_JOINED_INVITE' => '이제 가입이 완료되셨으니 <strong><a %s>친구를 초대하세요</a></strong>!',
        'THIS_IS_YOUR_PROFILE' => '회원님의 프로필은 다음과 같습니다:',
        'START_BY_CUSTOMIZING_ITS_APPEARANCE' => '<a %s>프로필 보기의 마춤형 설정</a>부터 시작하십시오.',
        'USE_IT_TO_KEEP_A_BLOG_AND_DISPLAY_YOUR_PROFILE_ANSWERS' => '이 기능은 <a %1$s>블로그 관리</a> 및 <a %2$s>프로필 답변</a>을 표시하는데 사용할 수 있습니다.',
        'START_CONTRIBUTING' => '참여하기:',
        'UPLOAD_VIDEOS' => '동영상 업로드',
        'CONTRIBUTE_TO_DISCUSSIONS' => '토론 참여',
        'JOIN_GROUPS' => '그룹 가입',
        'ADD_A_BLOG_POST' => '블로그 게시물 추가',
        'CLICK_TO_ACCEPT_FRIENDS' => '친구 요청 상태를 보시려면 이 곳을 클릭하세요.',
        'LEAVE_X' => '%s 탈퇴',
        'LEAVE_X_Q' => '%s에서 탈퇴하시겠어요?',
        'ARE_YOU_SURE_LEAVE_X' => '정말로 %s 에서 탈퇴하고 회원님의 모든 컨텐츠를 삭제하시겠습니까?  몇 분 정도 소요될 수 있습니다.',
        'BACK_TO_USERNAMES_PAGE' => '&#8592;  %s님의 페이지로 돌아가기',
        'BACK_TO_MY_PAGE' => '&#8592;  나의 페이지로 돌아가기',
        'COMMENT_WALL' => 'Comment Wall',
        'ONLINE' => '온라인',
        'MEMBER_IS_ONLINE' => '멤버는 현재 온라인 상태입니다',
        'ONLINE_NOW' => '현재 온라인 상태임',
        'CHOOSE_WHO_CAN_SEE_JOIN_AND_CONTRIBUTE' => '누가 회원님의 네트워크를 보고, 가입하며 컨텐츠 변경에 참여할 수 있는지 선택해 주세요.',
        'EMAIL_NOTIFICATIONS' => '이메일 통지',
        'WHAT_NETWORK_ACTIVITY_EMAIL_FOR' => '어떤 종류의 네트워크 활동 내용에 대한 이메일 통지를 받고 싶으세요?',
        'NETWORK_MESSAGES' => '네트워크 메시지',
        'MEMBER_ACTIVITY' => '회원 활동 사항',
        'APPROVAL' => '승인',
        'FRIEND_REQUESTS' => '친구 요청',
        'PEOPLE_IVE_INVITED_JOIN' => '내가 이 사교 네트워크 가입을 권유한 사람들',
        'MESSAGES_SENT_TO_ME' => '내가 받은 메시지',
        'MESSAGES_SENT_TO_GROUPS' => '내가 속한 그룹을 대상으로 발송된 메시지',
        'MESSAGES_SENT_TO_NETWORK' => '전체 네트워크를 대상으로 발송된 메시지',
        'I_HAVE_NEW_COMMENTS' => '승인을 요하는 새 코멘트들이 있는 경우',
        'I_HAVE_NEW_NETWORK_CONTENT' => '승인을 요하는 네트워크 켄텐츠가 있는 경우',
        'CONTENT_ACTIVITY' => '컨텐츠 활동 내용',
        'ACTIVITY_ON_THINGS_IVE_ADDED' => '내가 추가한 사항에 대한 활동 내용',
        'AUTO_FOLLOW_DISCUSSIONS_I_REPLY_TO' => '내가 답글을 게시한 토론을 자동으로 추적하기',
        'THINGS_IVE_ADDED_APPROVED' => '내가 추가한 내용이 승인됨',
        'NOTIFICATIONS' => '통지 기능',
        'EMAIL_ME_WHEN_PEOPLE_REPLY' => '사람들이 답글을 게시하면 이메일을 보내 주세요',
        'DO_NOT_EMAIL_ME_WHEN_PEOPLE_REPLY' => '사람들이 답글을 게시하더라도 이메일을 보낼 필요 없어요.',
        'TO_STOP_FOLLOWING_THIS_X_CLICK_Y' => '이 %s추적 기능을 중단하려면, <a %s>이 곳을 클릭하세요</a>.',
        'YOU_ARE_NO_LONGER_FOLLOWING_THIS_X' => '회원님께서는 더 이상 %s(을)를 추적하지 않도록 설정하셨습니다..',
        'NOTIFY' => '알림',
        'STOP_NOTIFYING' => '통지 중지',
        'EMAIL_WHEN_NEW_DISCUSSIONS' => '새로운 토론이 있을 때 이메일을 보내 주세요.',
        'DO_NOT_EMAIL_WHEN_NEW_DISCUSSIONS' => '새로운 토론이 있을 때라도 나에게 이메일을 보낼 필요는 없어요.',
        'STOP_FOLLOWING_ALL' => '모든 토론과 블로그 코멘트 추적 중단하기.',
        'CHANGE_MY_PHOTO' => '나의 사진 변경',
        'COUNTRY_AF' => '아프가니스탄',
        'COUNTRY_AX' => '알란드 섬',
        'COUNTRY_AL' => '알바니아',
        'COUNTRY_DZ' => '알제리',
        'COUNTRY_AS' => '미국령 사모아',
        'COUNTRY_AD' => '안도라',
        'COUNTRY_AO' => '앙골라',
        'COUNTRY_AI' => '앵귈라',
        'COUNTRY_AQ' => '남극 대륙',
        'COUNTRY_AG' => '앤티가 바부다',
        'COUNTRY_AR' => '아르헨티나',
        'COUNTRY_AM' => '아르메니아',
        'COUNTRY_AW' => '아루바',
        'COUNTRY_AU' => '오스트레일리아',
        'COUNTRY_AT' => '오스트리아',
        'COUNTRY_AZ' => '아제르바이잔',
        'COUNTRY_BS' => '바하마',
        'COUNTRY_BH' => '바레인',
        'COUNTRY_BD' => '방글라데시',
        'COUNTRY_BB' => '바베이도스',
        'COUNTRY_BY' => '벨로루시',
        'COUNTRY_BE' => '벨기에',
        'COUNTRY_BZ' => '벨리즈',
        'COUNTRY_BJ' => '베냉',
        'COUNTRY_BM' => '버뮤다',
        'COUNTRY_BT' => '부탄',
        'COUNTRY_BO' => '볼리비아',
        'COUNTRY_BA' => '보스니아 헤르체고비나',
        'COUNTRY_BW' => '보츠와나',
        'COUNTRY_BV' => '부베이 섬',
        'COUNTRY_BR' => '브라질',
        'COUNTRY_IO' => '영국령 인도양 식민지',
        'COUNTRY_BN' => '브루나이 왕국',
        'COUNTRY_BG' => '불가리아',
        'COUNTRY_BF' => '부르키나파소',
        'COUNTRY_BI' => '부룬디',
        'COUNTRY_KH' => '캄보디아',
        'COUNTRY_CM' => '카메룬',
        'COUNTRY_CA' => '캐나다',
        'COUNTRY_CV' => '카보베르데',
        'COUNTRY_KY' => '케이맨 제도',
        'COUNTRY_CF' => '중앙 아프리카 공화국',
        'COUNTRY_TD' => '차드',
        'COUNTRY_CL' => '칠레',
        'COUNTRY_CN' => '중국 본토',
        'COUNTRY_CX' => '크리스마스 섬',
        'COUNTRY_CC' => '코코스 제도',
        'COUNTRY_CO' => '콜롬비아',
        'COUNTRY_KM' => '코모로',
        'COUNTRY_CG' => '콩고 공화국',
        'COUNTRY_CD' => '콩고 민주 공화국',
        'COUNTRY_CK' => '쿡 제도',
        'COUNTRY_CR' => '코스타리카',
        'COUNTRY_CI' => '코테 디부아르',
        'COUNTRY_HR' => '크로아티아',
        'COUNTRY_CU' => '쿠바',
        'COUNTRY_CY' => '키프로스',
        'COUNTRY_CZ' => '체코 공화국',
        'COUNTRY_DK' => '덴마크',
        'COUNTRY_DJ' => '지부티',
        'COUNTRY_DM' => '도미니카',
        'COUNTRY_DO' => '도미니카 공화국',
        'COUNTRY_EC' => '에콰도르',
        'COUNTRY_EG' => '이집트',
        'COUNTRY_SV' => '엘살바도르',
        'COUNTRY_GQ' => '적도 기니',
        'COUNTRY_ER' => '에리트레아',
        'COUNTRY_EE' => '에스토니아',
        'COUNTRY_ET' => '에티오피아',
        'COUNTRY_EU' => 'EU',
        'COUNTRY_FK' => '포크랜드 섬',
        'COUNTRY_FO' => '페로 제도',
        'COUNTRY_FJ' => '피지',
        'COUNTRY_FI' => '핀란드',
        'COUNTRY_FR' => '프랑스',
        'COUNTRY_GF' => '프랑스령 기아나',
        'COUNTRY_PF' => '프랑스령 폴리네시아',
        'COUNTRY_TF' => '프랑스 남부령',
        'COUNTRY_GA' => '가봉',
        'COUNTRY_GM' => '감비아',
        'COUNTRY_GE' => '그루지야',
        'COUNTRY_DE' => '독일',
        'COUNTRY_GH' => '가나',
        'COUNTRY_GI' => '지브롤터',
        'COUNTRY_GR' => '그리스',
        'COUNTRY_GL' => '그린란드',
        'COUNTRY_GD' => '그레나다',
        'COUNTRY_GP' => '과들루프',
        'COUNTRY_GU' => '괌',
        'COUNTRY_GT' => '과테말라',
        'COUNTRY_GN' => '기니',
        'COUNTRY_GW' => '기니비사우',
        'COUNTRY_GY' => '가이아나',
        'COUNTRY_HT' => '아이티',
        'COUNTRY_HM' => '허드 섬 및 맥도널드 제도',
        'COUNTRY_HN' => '혼두라스',
        'COUNTRY_HK' => '홍콩',
        'COUNTRY_HU' => '헝가리',
        'COUNTRY_IS' => '아이슬란드',
        'COUNTRY_IN' => '인도',
        'COUNTRY_ID' => '인도네시아',
        'COUNTRY_IR' => '이란 공화국',
        'COUNTRY_IQ' => '이라크',
        'COUNTRY_IE' => '아일랜드',
        'COUNTRY_IL' => '이스라엘',
        'COUNTRY_IT' => '이탈리아',
        'COUNTRY_JM' => '자메이카',
        'COUNTRY_JP' => '일본',
        'COUNTRY_JO' => '요르단',
        'COUNTRY_KZ' => '카자흐스탄',
        'COUNTRY_KE' => '케냐',
        'COUNTRY_KI' => '키리바시',
        'COUNTRY_KP' => '조선 인민 공화국(북한)',
        'COUNTRY_KR' => '대한민국',
        'COUNTRY_KW' => '쿠웨이트',
        'COUNTRY_KG' => '키르기즈스탄',
        'COUNTRY_LA' => '라오 인민 공화국',
        'COUNTRY_LV' => '라트비아',
        'COUNTRY_LB' => '레바논',
        'COUNTRY_LS' => '레소토',
        'COUNTRY_LR' => '라이베리아',
        'COUNTRY_LY' => '리비아',
        'COUNTRY_LI' => '리히첸슈타인',
        'COUNTRY_LT' => '리투아니아',
        'COUNTRY_LU' => '룩셈부르크',
        'COUNTRY_MO' => '마카오',
        'COUNTRY_MK' => '마세도니아(전 유고슬라비아 공화국)',
        'COUNTRY_MG' => '마다가스카르',
        'COUNTRY_MW' => '말라위',
        'COUNTRY_MY' => '말레이시아',
        'COUNTRY_MV' => '몰디브',
        'COUNTRY_ML' => '말리',
        'COUNTRY_MT' => '몰타',
        'COUNTRY_MH' => '마샬 군도',
        'COUNTRY_MQ' => '마르티니크',
        'COUNTRY_MR' => '모리타니',
        'COUNTRY_MU' => '모리셔스',
        'COUNTRY_YT' => '마요트',
        'COUNTRY_MX' => '멕시코',
        'COUNTRY_FM' => '미크로네시아 연방',
        'COUNTRY_MD' => '몰도바 공화국',
        'COUNTRY_MC' => '모나코',
        'COUNTRY_MN' => '몽골',
        'COUNTRY_MS' => '몽세랏',
        'COUNTRY_MA' => '모로코',
        'COUNTRY_MZ' => '모잠비크',
        'COUNTRY_MM' => '미얀마',
        'COUNTRY_NA' => '나미비아',
        'COUNTRY_NR' => '나우루',
        'COUNTRY_NP' => '네팔',
        'COUNTRY_NL' => '네덜란드',
        'COUNTRY_AN' => '네덜란드 안틸레스',
        'COUNTRY_NC' => '뉴 칼레도니아',
        'COUNTRY_NZ' => '뉴질랜드',
        'COUNTRY_NI' => '니카라과',
        'COUNTRY_NE' => '니제르',
        'COUNTRY_NG' => '나이지리아',
        'COUNTRY_NU' => '니우에',
        'COUNTRY_NF' => '노포크 군도',
        'COUNTRY_MP' => '북마리아나 제도',
        'COUNTRY_NO' => '노르웨이',
        'COUNTRY_OM' => '오만',
        'COUNTRY_PK' => '파키스탄',
        'COUNTRY_PW' => '팔라우',
        'COUNTRY_PS' => '팔레스타인 자치구',
        'COUNTRY_PA' => '파나마',
        'COUNTRY_PG' => '파푸아뉴기니',
        'COUNTRY_PY' => '파라과이',
        'COUNTRY_PE' => '페루',
        'COUNTRY_PH' => '필리핀',
        'COUNTRY_PN' => '피트컨',
        'COUNTRY_PL' => '폴란드',
        'COUNTRY_PT' => '포르투갈',
        'COUNTRY_PR' => '푸에르토리코',
        'COUNTRY_QA' => '카타르',
        'COUNTRY_RE' => '리유니언',
        'COUNTRY_RO' => '루마니아',
        'COUNTRY_RU' => '러시아 연합',
        'COUNTRY_RW' => '르완다',
        'COUNTRY_SH' => '세인트 헬레나',
        'COUNTRY_KN' => '세인트 크리스토퍼 네비스',
        'COUNTRY_LC' => '세인트 루시아',
        'COUNTRY_PM' => '세인트 피에르과 미켈론',
        'COUNTRY_VC' => '세인트 빈센트와 그레나딘 제도',
        'COUNTRY_WS' => '사모아',
        'COUNTRY_SM' => '산마리노',
        'COUNTRY_ST' => '사오 톰과 프린시프',
        'COUNTRY_SA' => '사우디아라비아',
        'COUNTRY_SN' => '세네갈',
        'COUNTRY_CS' => '세르비아와 몬테네그로',
        'COUNTRY_SC' => '세이셸',
        'COUNTRY_SL' => '시에라 레온',
        'COUNTRY_SG' => '싱가포르',
        'COUNTRY_SK' => '슬로바키아',
        'COUNTRY_SI' => '슬로베니아',
        'COUNTRY_SB' => '솔로몬 섬',
        'COUNTRY_SO' => '소말리아',
        'COUNTRY_ZA' => '남아프리카 공화국',
        'COUNTRY_GS' => '남 그루지아와 남 샌드위치 섬',
        'COUNTRY_ES' => '스페인',
        'COUNTRY_LK' => '스리랑카',
        'COUNTRY_SD' => '수단',
        'COUNTRY_SR' => '수리남',
        'COUNTRY_SJ' => '스발바드와 잔 매연',
        'COUNTRY_SZ' => '스와질란드',
        'COUNTRY_SE' => '스웨덴',
        'COUNTRY_CH' => '스위스',
        'COUNTRY_SY' => '시리아 아랍 공화국',
        'COUNTRY_TW' => '타이완',
        'COUNTRY_TJ' => '타지키스탄',
        'COUNTRY_TZ' => '탄자니아 연합 공화국',
        'COUNTRY_TH' => '태국',
        'COUNTRY_TL' => '동티모르',
        'COUNTRY_TG' => '토고',
        'COUNTRY_TK' => '토케라우',
        'COUNTRY_TO' => '통가',
        'COUNTRY_TT' => '트라니다드 토바고',
        'COUNTRY_TN' => '튀니지',
        'COUNTRY_TR' => '터키',
        'COUNTRY_TM' => '투르크메니스탄',
        'COUNTRY_TC' => '터크스 앤 카이코스 제도',
        'COUNTRY_TV' => '투발라',
        'COUNTRY_UG' => '우간다',
        'COUNTRY_UA' => '우크라이나',
        'COUNTRY_AE' => '아랍에미레이트공화국',
        'COUNTRY_GB' => '영국',
        'COUNTRY_US' => '미국',
        'COUNTRY_UM' => '미국 소수 외부 제도',
        'COUNTRY_UY' => '우루과이',
        'COUNTRY_UZ' => '우즈베키스탄',
        'COUNTRY_VU' => '바누아투',
        'COUNTRY_VA' => '바티칸 시',
        'COUNTRY_VE' => '베네수엘라',
        'COUNTRY_VN' => '베트남',
        'COUNTRY_VG' => '영국령 버진 아일랜드',
        'COUNTRY_VI' => '미국령 버진 아일랜드',
        'COUNTRY_WF' => 'Wallis and Futuna',
        'COUNTRY_EH' => '서부 사하라',
        'COUNTRY_YE' => '예멘',
        'COUNTRY_ZM' => '잠비아',
        'COUNTRY_ZW' => '짐바브웨',
        'ERROR_LOG' => '오류 로그',
        'CANNOT_READ_ERROR_LOG' => '오류 로그를 읽을 수 없습니다',
        'CANNOT_OPEN_ERROR_LOG' => '오류 로그를 열 수 없습니다',
        'CANNOT_SCAN_ERROR_LOG' => '오류 로그를 스캔할 수 없습니다',
        'MODELS_RESET' => '리셋 모델:',
        'NO_MODELS_RESET' => '리셋한 모델이 없습니다.',
        'NO_FEED_TO_DISPLAY' => '현재 표시된 항목이 없습니다.',
        'BOX_WILL_NOT_SHOW_FEED' => '적어도 한 항목이라도 선택되지 않는 한  다른 사람들은 이 상자를 볼 수 없습니다.',
        'CLICK_EDIT_TO_SPECIFY_FEED' => '’편집’을 클릭하여 이 상자의 RSS피드를 지정하세요.',
        'PROBLEM_OCCURRED_RETRIEVING_FEED' => '이 RSS 피드를 불러오는 중 문제가 발생했습니다.',
        'MORE_ELLIPSIS' => '기타...',
        'RSS' => 'RSS',
        'WE_ARE_SORRY_SITE_HAS_ISSUE' => '죄송합니다, 이 사이트에 문제가 발생했습니다.',
        'PLEASE_TRY_REFRESHING' => '30초 안에 페이지 새로고침을 시도하거나 이 메시지가 다시 나타나면 <a %s>저희에게 연락하십시오</a>.',
        'NO_DISCUSSIONS_TAGGED_X' => '"%1$s"라는 태그가 붙은 토론이 없습니다.',
        'PAGE_TITLE_COLON' => '페이지 제목:',
        'PAGE_CONTENT' => '컨텐츠:',
        'CREATE_PAGE' => '페이지 만들기',
        'CREATE_NEW_PAGE' => '새 페이지 만들기',
        'YOUR_COMMENT' => '회원님의 코멘트',
        'ADD_YOUR_COMMENT' => '회원님의 코멘트 추가',
        'DELETE_PAGE' => '이 페이지 삭제',
        'DELETE_THIS_PAGE_Q' => '이 페이지를 삭제하시겠습니까?',
        'ARE_YOU_SURE_DELETE_THIS_PAGE' => '모든 코멘트를 포함하여 이 페이지를 정말로 삭제하시겠습니까?  몇 분 정도 소요될 수 있습니다.',
        'SEARCH_PAGES' => '페이지 검색',
        'ALL_PAGES' => '모든 페이지',
        'SUBSCRIBE_TO_PAGES' => '이 페이지 구독',
        'NOBODY_HAS_ADDED_PAGES' => '아직 아무도 페이지를 추가하지 않았습니다!',
        'ADD_PAGES_CALL_TO_ACTION' => '시작하려면 페이지를 만드십시오.',
        'CREATE_A_PAGE' => '페이지 만들기',
        'PLEASE_ENTER_PAGE_CONTENT' => '페이지 내용을 입력하세요',
        'SEARCH_RESULTS_FOR_X' => '<em>%s</em>의 검색 결과',
        'EDIT_YOUR_PAGE' => '회원님의 페이지 편집',
        'UPDATE_PAGE' => '페이지 업데이트',
        'CLOSE_DISCUSSION' => '토론 종료',
        'REOPEN_DISCUSSION' => '토론 재오픈',
        'CLOSING_DISCUSSION_PREVENTS' => '토론을 종료하면 더 이상의 답글을 달 수 없습니다',
        'NO_DISCUSSION_TO_DISPLAY' => '현재 표시하신 토론이 없습니다.',
        'BOX_WILL_NOT_SHOW_DISCUSSION' => '최소한 한 개의 토론을 선택하지 않으면 다른 사람들에게 이 상자가 나타나지 않습니다.',
        'NEWEST_DISCUSSIONS' => '최신 토론',
        'LATEST_REPLIES' => '최신 답변',
        'REPLIES_CLOSED_FOR_DISCUSSION' => '이 토론에 대한 답글은 종료되었습니다.',
        'SORRY_DISCUSSION_CLOSED' => '죄송하지만 이 토론은 방금 답글 다는 것이 종료 되었습니다..',
        'MOST_REPLIES' => '가장 많은 답글',
        'OWNER_DISCUSSIONS_ONLY' => '개설자 토론만',
        'MY_DISCUSSIONS_ONLY' => '나의 토론만',
        'DISCUSSION_DELETED' => '토론 삭제됨',
        'DISCUSSION_HAS_BEEN_DELETED' => '이 토론은 더 이상 열람하실 수 없습니다.',
        'REPLY_DELETED' => '답글 삭제됨',
        'REPLY_HAS_BEEN_DELETED' => '이 답글은 삭제되었습니다.  <a %s>토론으로 돌아가기. </a>',
        'VIEW_ALL_DISCUSSIONS' => '모든 토론 보기',
        'ADD_CATEGORIES' => '카테고리 추가',
        'CATEGORY' => '카테고리:',
        'NO_DISCUSSIONS_IN_CATEGORY' => '이 카테고리에는 아직 토론이 없습니다.',
        'ADD_MANAGE_CATEGORIES' => '카테고리 추가/관리',
        'UNTITLED_CATEGORY' => '제목이 없는 카테고리',
        'SAMPLE_TITLE' => '제목 견본',
        'UNCATEGORIZED' => '카테고리 정해지지 않음',
        'EXISTING_DISCUSSIONS' => '아직 카테고리가 지정되지 않은 기존의 토론.',
        'YOU_HAVE_NOT_ADDED_CATEGORIES' => '현재는 어떤 카테고리도 없습니다.  시작하려면 카테고리를 추가하십시오!',
        'ADD_A_CATEGORY' => '카테고리 추가',
        'ADD_ANOTHER_CATEGORY' => '다른 카테고리 추가',
        'MANAGE_CATEGORIES' => '카테고리 관리',
        'CATEGORY_TITLE' => '카테고리 제목',
        'ALLOW_MEMBERS_TO_START_DISCUSSIONS' => '가입자들이 이 카테고리에서 토론을 시작할 수 있도록 허용하기',
        'ONLY_I_CAN_START_DISCUSSIONS' => '이 카테고리에서는 나만 토론을 시작할 수 있도록 함.',
        'ALLOW_MEMBERS_TO_REPLY' => '회원이 답글을 달 수 있도록 허용하기',
        'SUGGESTIONS' => '제안:',
        'TRY_DIFFERENT_KEYWORDS' => '다른 키워드나 보다 일반적인 키워드를 사용해 보세요.',
        'VIEW_DISCUSSIONS_OR_START_DISCUSSION' => '<a %s>모든 토론 보기</a> 또는 <a %s>새 토론 시작하기</a>',
        'MAKE_SURE_WORDS_SPELLED' => '모든 단어의 철자가 올바른지 확인해 주세요.',
        'REPLY_WAS_DELETED' => '이 답글은 삭제되었습니다',
        'TAGS_X' => '<strong>태그:</strong> %s',
        'SEND_PRIVATE_MESSAGE' => '비공개 메시지 보내기',
        'PERMALINK_TO_REPLY' => '이 답글로 Permalink',
        'PERMALINK' => 'Permalink',
        'WE_COULD_NOT_FIND_ANY_DISCUSSIONS' => '죄송하지만 회원님의 검색 조건에 맞는 토론을 찾을 수 없습니다.',
        'DISCUSSIONS_MATCHING_X' => '<em>\'%s\'</em>에 일치하는 토론',
        'SEARCH_DISCUSSIONS' => '토론 검색',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS_2' => '회원님께서는 아직 한 건도 추가하신 토론이 없습니다!',
        'ADD_DISCUSSIONS_AND_SHARE' => '토론을 추가하여 친구, 가족 및 전세계와 함께 나누십시오!',
        'DISCUSSION' => '토론',
        'DISCUSSIONS' => '토론',
        'KEEP_PAGE_OPEN_FORUM' => '회원님의 파일이 포럼에 업로드가 완료될 때까지 이 페이지를 계속해서 열어 두세요.',
        'MEANWHILE_FEEL_FREE_FORUM' => '그 동안 <a %s>새 브라우저 창을 열고</a> %s을 이용하세요.',
        'START_A_NEW_DISCUSSION' => '새 토론 시작하기',
        'DISCUSSION_TITLE' => '토론 제목:',
        'FIRST_POST' => '게시물:',
        'UPLOAD_FILES' => '파일 첨부:',
        'START_DISCUSSION' => '토론 시작',
        'EDIT_DISCUSSION' => '토론 편집',
        'START_A_DISCUSSION' => '토론 시작',
        'ALL_DISCUSSIONS' => '포럼 홈페이지',
        'CONTRIBUTORS' => '도움 주신 분',
        'MY_DISCUSSIONS' => '나의 토론',
        'READ_MORE' => '더 자세한 정보',
        'STARTED_T_BY' => '<strong>%s</strong>를 시작한 사람:',
        'ADDED_BY_X_T' => '%s %s님이 추가함',
        'STARTED_BY_X_T' => '%s %s님이 시작함',
        'REPLY_BY_X_T' => '<strong>%s</strong> %s님이 답글 작성함',
        'STARTED_BY_X_LAST_REPLY_LINK_BY_X_T' => '%s로 개시  %s %s님이 마지막 <a %s>답글</a> 씀.',
        'STARTED_DISCUSSION_LAST_REPLY_LINK_BY_X_T' => '<strong>이 토론을 시작했습니다 </strong> %s %s님이 마지막 <a %s>답글</a> 씀.',
        'STARTED_DISCUSSION_T' => '<strong>이 토론을 시작했습니다</strong> %s',
        'ADDED_REPLY_T' => '<strong>답글을 추가하셨습니다</strong> %s',
        'ADDED_POST_T' => '<strong>게시물을 추가하셨습니다</strong> %s',
        'STARTED_BY_X_ON' => '%s에서 %s님이 시작하셨습니다',
        'STARTED_DISCUSSION_ON' => '<strong>이 토론을 시작했습니다</strong> %s',
        'STARTED_ON' => '<strong>Started</strong> %s',
        'ADDED_REPLY_ON' => '<strong>답글을 추가하셨습니다</strong> %s',
        'ADDED_POST_ON' => '<strong>게시물을 추가하셨습니다</strong> %s',
        'XS_DISCUSSIONS' => '%s님의 토론',
        'XS_DISCUSSIONS_LOWERCASE' => '%s님의 토론',
        'VIEW_XS_DISCUSSIONS' => '%s님의 토론 보기',
        'VIEW_YOUR_DISCUSSIONS' => '회원님의 토론 보기',
        'TAGGED_X' => '태그됨:%s',
        'SUBSCRIBE_TO_DISCUSSIONS' => '이 토론들에 구독하기',
        'SUBSCRIBE_TO_DISCUSSION' => '이 토론 구독하기',
        'SUBSCRIBE_TO_XS_DISCUSSIONS' => '%s님의 토론 구독하기',
        'ALL_DISCUSSIONS_TAGGED_X' => '<em>\'%s\'</em>태그가 달린 모든 토론',
        'SUBSCRIBE_TO_DISCUSSIONS_TAGGED_X' => '태그된 토론 구독\'%s\'',
        'N_KB' => '%s KB',
        'N_MB' => '%s MB',
        'UPLOADING_FILES' => '파일 업로드',
        'ATTACHMENTS' => '첨부',
        'YOUR_POST' => '회원님의 게시물:',
        'YOUR_REPLY' => '회원님의 답글:',
        'WOULD_YOU_LIKE_TO_UPLOAD_FILES' => '파일을 업로드하시겠습니까?',
        'ADD_YOUR_REPLY' => '회원님의 답글 추가',
        'REPLIES_TO_THIS_DISCUSSION' => '이 토론에 대한 답글',
        'POSTED_BY_X_ON' => '게시자 %s %s',
        'PLEASE_ENTER_TITLE' => '토론의 주제를 입력하세요',
        'PLEASE_ENTER_FIRST_POST' => '토론의 첫 번째 게시물을 작성해 주십시오.',
        'REPLY_TO_THIS' => '여기에 대한 답글',
        'DELETE_ATTACHMENT' => '첨부 삭제',
        'DELETE_ATTACHMENT_Q' => '이 첨부 문서를 삭제하시겠어요?',
        'DELETE_REPLY' => '답글 삭제',
        'DELETE_THIS_DISCUSSION_Q' => '이 토론을 삭제하시겠어요?',
        'ARE_YOU_SURE_DELETE_THIS_DISCUSSION' => '정말 모든 답글을 포함하여 이 토론을 전체적으로 삭제하기 원하세요?  몇 분 정도 소요될 수 있습니다.',
        'DELETE_DISCUSSION' => '토론 삭제',
        'NOBODY_HAS_ADDED_DISCUSSIONS' => '아직 아무도 토론을 추가하지 않았습니다.',
        'NOBODY_HAS_ADDED_DISCUSSIONS_ADD' => '아직 아무도 토론을 추가하지 않았습니다!  시작하려면 토론을 추가하십시오.',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS' => '회원님께서는 아직 아무런 토론을 추가하지 않으셨습니다.  시작하려면 토론을 추가해 주세요!',
        'YOU_HAVE_NOT_STARTED_DISCUSSIONS' => '회원님께서는 아직 어떠한 토론도 시작하지 않으셨습니다.',
        'YOU_HAVE_NOT_ADDED_TO_DISCUSSIONS' => '회원님께서는 아직 어떠한 토론도 추가하지 않으셨습니다.',
        'X_HAS_NOT_ADDED_DISCUSSIONS' => '%s님은 아직 어떠한 토론도 추가하지 않으셨습니다.',
        'X_HAS_NOT_STARTED_DISCUSSIONS' => '%s님은 아직 어떠한 토론도 시작하지 않으셨습니다.',
        'X_HAS_NOT_ADDED_TO_DISCUSSIONS' => '%s님은 아직 어떠한 토론도 추가하지 않으셨습니다.',
        'VIEW_DISCUSSIONS' => '토론 보기',
        'VIEW_ALL_PEOPLE_ON_X' => '%s상의 모든 가입자 보기',
        'THERE_ARE_NO_DISCUSSIONS' => '회원님의 네트워크에는 현재 토론이 없습니다.',
        'GROUP_HAS_NO_DISCUSSIONS' => '이 그룹은 아직 어떠한 토론도 없습니다.',
        'VIEW_DISCUSSIONS_IN_GROUP_FORUM' => '<a %s>%s 포럼</a>의 토론 보기!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT_ADD' => '"%1$s"라는 태그가 붙은 토론이 없습니다.  <a %2$s>태그가 붙은 사진"%1$s"</a> 이나 <a %3$s>태그가 붙은 동영상 "%1$s"</a>을 한 번 둘러 보세요.  아니면 회원님 자신의 토론을 추가하고 태그를 붙이셔도 좋구요!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT' => '"%1$s"라는 태그가 붙은 토론이 없습니다.  <a %2$s>태그가 붙은 사진"%1$s"</a> 이나 <a %3$s>태그가 붙은 동영상 "%1$s"</a>을 한 번 둘러 보세요.',
        'THIS_BOX_WILL_NOT_SHOW_DISCUSSIONS' => '보여 줄 수 있는 토론이 생기기 전까지는 다른 사람들은 이 상자를 볼 수 없습니다.  토론을 직접 시작해 보시는 건 어때요?',
        'DISCUSSIONS_I_STARTED' => '내가 시작한 토론',
        'DISCUSSIONS_X_STARTED' => '%s님이 시작한 토론',
        'DISCUSSIONS_I_REPLIED_TO' => '내가 답글을 게시한 토론',
        'DISCUSSIONS_X_REPLIED_TO' => '%s님이 답글을 게시한 토론',
        'PLEASE_WRITE_SOMETHING_FOR_POST' => '회원님의 게시물을 작성하세요.',
        'PLEASE_WRITE_SOMETHING_FOR_REPLY' => '회원님의 답글을 작성하세요.',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION_X' => '%s상의 회원님의 토론 “%s”에 새로운 코멘트가 게시되었습니다.',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION' => '%s상의 회원님의 토론 중 하나에 새로운 코멘트가 게시되었습니다.',
        'SOMEBODY_COMMENTED_DISCUSSION_ADDED_TO_X' => '회원님께서 %s에서 시작한 토론에 누군가 코멘트를 남겼습니다.',
        'ABOUT_YOUR_DISCUSSION' => '회원님의 토론에 관하여',
        'ABOUT_THIS_DISCUSSION' => '이 토론에 관하여',
        'USER_REPLIED_TO_A_DISCUSSION_ON_Y' => '%s님께서 %s 상의 토론에 답글을 남겼습니다.',
        'USER_REPLIED_TO_DISCUSSION_TITLE_ON_APPNAME' => '%s님께서  %s 상의 “%s”에 답글을 남겼습니다.',
        'PROBLEM_WITH_ICON' => '아이콘 파일에 문제가 있었습니다',
        'GROUP_ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => '그룹 관리자는 그룹 개설자와  비슷한 수준의 컨트롤 권한을 가집니다.',
        'CREATE_NEW_GROUP' => '새 그룹 만들기',
        'CREATE_A_NEW_GROUP' => '새 그룹 만들기',
        'CREATE_A_GROUP' => '그룹 만들기',
        'VIEW_GROUPS' => '그룹 보기',
        'CREATE_GROUP' => '그룹 만들기',
        'PLEASE_ENTER_NAME_FOR_GROUP' => '회원님의 그룹명을 선택하세요.',
        'PLEASE_ENTER_URL_FOR_GROUP' => '회원님의 그룹 웹 주소를 선택하세요.',
        'URL_CAN_CONTAIN_ONLY_LETTERS' => '웹 주소는 문자와 번호만을 사용하여 만드실 수 있습니다 (빈 칸은 허용되지 않습니다).',
        'NAME_TAKEN' => '죄송합니다 – 입력하신 이름은 이미 다른 회원이 사용하고 있습니다.  다른 이름을 선택하세요.',
        'URL_TAKEN' => '죄송합니다 – 입력하신 웹 주소는 이미 사용 중입니다.  다른 웹 주소를 선택하세요.',
        'GROUP_INFORMATION' => '그룹 정보',
        'EXTERNAL_WEBSITE' => '외부 웹사이트',
        'DO_YOU_HAVE_EXISTING_WEBSITE' => '다른 곳에 기존의 그룹 웹사이트를 갖고 계신지요?',
        'URL' => 'URL',
        'GROUPS' => '그룹',
        'SEARCH_GROUPS' => '그룹 검색',
        'NOBODY_HAS_CREATED_GROUPS' => '아직 아무도 그룹을 만들지 않았습니다.',
        'NOBODY_HAS_CREATED_GROUPS_ADD' => '아직 아무도 그룹을 만들지 않았습니다!  시작할 그룹을 만드십시오.',
        'MY_GROUPS' => '나의 그룹',
        'FEATURED_GROUPS' => '주목 대상의 그룹',
        'YOU_CAN_CREATE_GROUP' => '%2$s에서 <a %1$s>새 그룹 만들기</a>를 하실 수 있습니다!',
        'GROUP_FORUM' => '%s 포럼',
        'USER_CREATED_GROUP' => '%s 님께서 %s 상에 이 그룹을 만들었습니다.',
        'GROUP_MEMBERS_COUNT' => '가입자 %s 명 (%d)',
        'WE_ARE_SORRY_NOT_ALLOWED_JOIN_GROUP' => '죄송하지만 회원님께서는 이 그룹에 가입하실 수 없습니다.',
        'JOIN_GROUP_NOW' => '지금 %s에 가입하세요!',
        'USER_HAS_INVITED_YOU_TO_JOIN_GROUP' => '%s 님께서 회원님을 %s에 가입하시도록 초대했습니다',
        'DECLINE' => '거절',
        'WELCOME_TO_GROUP' => '%s에 방문하신 것을 환영합니다',
        'YOU_CAN_PARTICIPATE_IN_GROUP' => '이제 %s 포럼에 참여하실 수 있습니다.',
        'SEND_MESSAGE_TO_GROUP' => '그룹 전체에 메시지 보내기',
        'LEAVE_THIS_GROUP' => '그룹 탈퇴',
        'EDIT_GROUP_INFO' => '그룹 정보 편집',
        'EDIT_GROUP_INFORMATION' => '그룹 정보 편집',
        'MANAGE_GROUP_MEMBERS' => '그룹 가입자 관리',
        'GROUP_HAS_NO_MEMBERS' => '이 그룹에는 아직 가입자가 없습니다!',
        'GROUP_HAS_NO_MEMBERS_THAT_MATCH' => '이 그룹에는 회원님의 검색 조건과 일치하는 가입자가 없습니다.',
        'USERS_GROUPS' => '%s님의 그룹',
        'YOU_HAVE_NOT_CREATED_GROUPS' => '회원님께서는 아직 아무 그룹도 만들지 않으셨습니다.',
        'USER_HAS_NOT_CREATED_GROUPS' => '%s 님은 아직 어떤 그룹도 만들지 않으셨습니다.',
        'THERE_ARE_NO_FEATURED_GROUPS' => '회원님의 사교 네트워크에는 주목 대상의 그룹이 없습니다.',
        'START_FEATURING_GROUPS' => '추천 옵션이 있는 곳에서 그룹 추천을 시작하세요.  추천 기능에 대한 더 자세한 정보는 <a %s>이 곳을 클릭하십시오</a>.',
        'NO_GROUPS_TO_DISPLAY' => '현재 표시되는 그룹이 없습니다.',
        'BOX_WILL_NOT_SHOW_GROUPS' => '회원님께서 최소한 한 개의 그룹이라도 선택하지 않는 한 다른 사람들은 이 상자를 볼 수 없습니다.',
        'YOU_HAVE_NOT_CREATED_GROUPS_2' => '회원님께서는 아직 아무 그룹도 만들지 않으셨습니다!',
        'CREATE_GROUPS_AND_SHARE' => '그룹을 만들고 친구, 가족 또는 전세계와 공유하세요!',
        'THERE_ARE_NO_GROUPS' => '현재 회원님의 네트워크 상에는 그룹이 없습니다.',
        'THIS_BOX_WILL_NOT_SHOW_GROUPS' => '표시되는 그룹이 생길 때까지 다른 사람들은 이 상자를 볼 수 없습니다.  직접 그룹을 개설해 보시겠어요?.',
        'GROUPS_MATCHING_SEARCH_TERM' => '그룹 매칭<em>\'%s\'</em>',
        'WE_COULD_NOT_FIND_ANY_GROUPS' => '죄송하지만 회원님의 검색 조건에 일치하는 그룹을 찾을 수 없습니다.',
        'VIEW_GROUPS_OR_CREATE_GROUP' => '<a %s>모든 그룹 보기</a>또는 <a %s>새로운 그룹 만들기</a>',
        'VIEW_ALL_GROUPS' => '모든 그룹 보기',
        'DELETE_GROUP' => '그룹 삭제',
        'DELETE_GROUP_Q' => '정말로 이 그룹을 삭제하기 원하세요?',
        'GROUP_INVITATIONS' => '그룹 초청',
        'YOU_HAVE_BEEN_INVITED_TO_JOIN' => '다음 그룹에의 가입을 초대 받으셨습니다:',
        'VISIT' => '방문',
        'WHO_CAN_JOIN_GROUP' => '누가 이 그룹에 가입할 자격이 있나요?',
        'PRIVACY_CANNOT_BE_CHANGED' => '그룹을 만든 후에는 공개 여부 설정를 수정할 수 없습니다.',
        'ONLY_INVITED_PEOPLE' => '초대 받은 사람들만',
        'ALLOW_PEOPLE_TO_REQUEST' => '사람들이 초대를 신청할 수 있도록 허락하기',
        'ANYONE_CAN_JOIN_GROUP' => '누구나 이 그룹에 가입할 수 있게 하기',
        'ONLY_INVITED_PEOPLE_CAN_JOIN_GROUP' => '초대 받은 사람들만 이 그룹에 가입할 수 있게 하기',
        'WHY_NOT_CREATE_GROUP' => '회원님이 직접 <a %s>나의 그룹 개설하기 </a>를 시도해 보시는 건 어때요?',
        'PLEASE_ENTER_NAME' => '회원님의 이름을 입력하세요',
        'PLEASE_ENTER_EMAIL_ADDRESS' => '회원님의 이메일 주소를 입력하세요.',
        'PLEASE_ENTER_PAGE_ADDRESS' => '새로운 페이지 주소를 입력하세요.',
        'PLEASE_ENTER_PASSWORD' => '비밀 번호를 입력하세요.',
        'CREATE_ACCOUNT_OR_SIGN_IN' => '<a %s>계정을 만들려면 이 곳을 클릭</a>하시거나 또는 아래에서 다시 로그인을 시도해 보세요.',
        'CREATE_ACCOUNT_OR_JOIN' => '<a %s>계정을 만들려면 이 곳을 클릭</a> 하시거나 또는 아래에서 회원님의 Ning ID로 다시 입장을 시도해 보십시오.',
        'CHOOSE_SHORTER_PASSWORD' => '좀 더 짧은 비밀 번호를 선택해 주세요.',
        'CHOOSE_SHORTER_NAME' => '좀 더 짧은 이름을 선택해 주세요.',
        'ENTER_SHORTER_CITY_NAME' => '좀 더 짧은 도시 이름을 입력해 주세요.',
        'PLEASE_ENTER_PASSWORD_AGAIN' => '“비밀 번호 재입력” 란에 비밀 번호를 다시 입력하세요.',
        'PLEASE_ENTER_CURRENT_PASSWORD' => '현재의 비밀번호를 입력하세요.',
        'PLEASE_ENTER_NEW_PASSWORD' => '새로운 비밀번호를 입력하세요.',
        'PLEASE_ENTER_NEW_PASSWORD_AGAIN' => '”비밀번호 확인”란에 새로운 비밀번호를 다시 입력하세요.',
        'CURRENT_PASSWORD' => '현재의 비밀번호',
        'PASSWORDS_DO_NOT_MATCH' => '두 비밀번호가 일치하지 않습니다.',
        'NEW_AND_CONFIRMATION_PASSWORDS' => '새 비밀번호와 비밀번호 확인란에 입력한 비밀번호가 일치하지 않습니다.',
        'YOUR_REQUEST_HAS_BEEN_SENT_TO_GROUP_CREATOR' => '그룹 개설자에게 회원님의 신청을 보냈습니다.',
        'X_IS_NOT_VALID_EMAIL_ADDRESS' => '%s는 유효한 이메일 주소가 아닙니다.',
        'COME_JOIN_ME_ON_GROUP' => '저랑 같이 %s에 가입하세요!',
        'INVITE_PEOPLE_TO_GROUP' => '%s로 사람들을 초대',
        'INVITE_FRIENDS_TO_GROUP' => '%s로 친구 초대',
        'SEND_INVITATIONS_TO_JOIN_GROUP' => '다른 사람들에게 %s에의 가입 초대를 보내기.',
        'GROUPNAME_MEMBERS' => '%s 가입자',
        'GROUP_CREATOR' => '그룹 개설자',
        'GROUP_ADMINISTRATOR' => '그룹 운영자',
        'DATE_BANNED' => '금지된 날짜',
        'BAN_FROM_GROUP' => '그룹에서 금지',
        'ARE_YOU_SURE_BAN_MEMBER_FROM_GROUP' => '지정된 회원(들)을 정말로 회원님의 그룹에서 금지시키기 원하세요?   몇 분 정도 소요될 수 있습니다.',
        'ALSO_DELETE_FORUM_POSTINGS' => '또한 포럼 게시물과 답글을 삭제하기.',
        'GROUP_WEB_ADDRESS' => '그룹 웹 주소',
        'GROUP' => '그룹',
        'BACK_TO_GROUP' => '← %s로 되돌아 가기',
        'USER_BANNED_FROM_GROUP' => '%1$s님은 이 그룹에서 금지되었습니다.  <a %2$s>%1$s님께 메시지 보내기</a>',
        'USER_ALREADY_GROUP_MEMBER' => '%1$s님은 이미 이 그룹의 가입자입니다.  <a %2$s>%1$s님께 메시지 보내기</a>',
        'GROUP_ADMIN_DISCUSSIONS' => '그룹 관리자 토론',
        'BACK_TO_NETWORK_GROUPS' => '%s 그룹으로 돌아가기',
        'MOST_MEMBERS' => '가장 많은 회원 수',
        'THIS_SETS_URL_OF_GROUP' => '회원님의 그룹의 URL입니다:<br />http://%s/<strong>groupwebaddress</strong>',
        'LIKE_WHAT_YOU_SEE' => '%s의 내용이 마음에 드세요?  그럼 지금 당장 가입하세요!',
        'LIKE_WHAT_YOU_SEE_GROUP' => '%s의 내용이 마음에 드십니까?  그럼 지금 당장 가입하세요!',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => '%1$s 그룹을 만들었습니다. %1$s 포룸에서 논의를 시작하거나 다른 사람들이 가입하도록 초대할 수 있습니다.',
        'YOU_ARE_MEMBER_OF_GROUP_AND_CAN_INVITE' => '회원님께서는 %1$s의 가입자가 되셨습니다.  %1$s 포럼에 참여하거나 더 많은 사람들에게 가입 초대를 하실 수 있습니다.',
        'NETWORK_DOES_NOT_HAVE_MUSIC' => '이 네트워크에는 아직 아무런 음악도 없습니다.',
        'PERSON_DOES_NOT_HAVE_MUSIC' => '이 분은 아무런 음악도 올려 놓지 않았습니다.',
        'FIND_MORE_MUSIC_LIKE_THIS' => '<em>%s</em>에서 이런 종류의 음악에 더 많이 찾아 보실 수 있습니다',
        'TRACKS' => '추적',
        'ADD_MUSIC_TRACKS' => '음악 추가',
        'CHOOSE_MUSIC_TRACKS' => '추가할 노래를 선택하세요',
        'YOU_CAN_ADD_UP_TO_MP3' => '한 번에 최대4개의 MP3를 추가할 수 있습니다.',
        'UPLOAD_TRACKS' => '노래 업로드하기',
        'ADD_TRACKS' => '노래 추가하기',
        'ENTER_THE_URL_MP3_TO_ADD' => '추가하고 싶은 각각의 MP3에 URL을 입력하세요.',
        'EACH_MP3_FILE_MAY_BE_UP_TO' => '최대 100개의 MP3 파일을 업로드하실 수 있습니다!  각 MP3 파일의 최대 허용 용량은 20MB이며 크기가 작은 파일은 보다 빠르게 업로드됩니다.',
        'BE_NICE' => '규정을 준수해 주세요.',
        'PLEASE_UPLOAD_ONLY_TRACKS' => '아티스트나 저작권자에게서 승인을 받은 경우에만 노래를 업로드 하시기 바랍니다.',
        'PLEASE_LINK_ONLY_TRACKS' => '인터넷 상에서의 배포가 승인된 음악에만 링크 하세요.',
        'MORE_WAY_TO_ADD_MUSIC' => '음악을 추가할 수 더 많은 방법...',
        'ELLIP_FROM_ANOTHER_WEBSITE' => '...다른 웹사이트로부터의',
        'ADD_MUSIC_FROM_ANY_WEBSITE' => '링크를 MP3에 붙여 넣기만 하면 어떤 웹사이트로부터도 음악을 추가할 수 있습니다.',
        'KEEP_PAGE_OPEN_MUSIC' => '노래 업로드가 완료될 수 있도록 이 페이지를 계속해서 열어 두세요. 업로드가 승인되면 알려 드리겠습니다!',
        'MEANWHILE_FEEL_FREE_MUSIC' => '그 동안 <a %s>새 브라우저 창을 열고</a> %s을 이용하세요.  업로드가 완료되면 이 창에서 노래의 제목과 설명을 추가하실 수 있습니다.',
        'TRACKS_EXCEEDED_LIMIT' => '이 노래(들)는 곡 당 10MB의 용량 제한을 초과한 것 같군요.',
        'EDIT_TRACK_INFORMATION' => '노래 정보 편집',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_1' => '방금 업로드하신 노래에 제목, 설명 기타 다른 정보를 추가하세요.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_2' => '이 노래에 제목, 설명 기타 정보를 추가하십시오.',
        'CANCEL_AND_RETURN_TO_PLAYLIST' => '« 취소하고 플레이리스트로 돌아가기',
        'TRACK_TITLE' => '노래 제목',
        'TRACK_ARTIST' => '아티스트',
        'TRACK_ALBUM' => '앨범',
        'ENABLE_DOWNLOAD_LINK' => '다운로드 링크 활성화시키기',
        'ALLOW_PEOPLE_TO_ADD_TRACK_TO_PROFILE' => '다른 사람들이 자신들의 페이지에 이 노래를 올릴 수 있도록 허용하기',
        'TRACK_ARTWORK' => '작품',
        'EDIT_PLAYLIST' => '플레이리스트 편집',
        'DRAG_TO_CHANGE_ORDER_PLAYLIST' => '플레이리스트의 순서를 재설정하시려면 노래를 클릭한 후 원하는 곳에 ‘끌어 오기’를 하시면 됩니다.',
        'ADD_MUSIC_ELLIPSIS' => '음악 추가...',
        'ELLIPSIS_FROM_YOUR_COMPUTER' => '...회원님의 컴퓨터에서',
        'UPLOAD_MP3_FROM_YOUR_COMPUTER' => '회원님의 컴퓨터로부터 MP3 업로드하기.',
        'DELETE_THIS_TRACK_Q' => '이 노래를 삭제하시겠습니까?',
        'DELETE_TRACK' => '노래 삭제',
        'ARE_YOU_SURE_DELETE_THIS_TRACK' => '이 노래를 정말로 삭제하고 싶으세요?',
        'PLAY' => '재생하다',
        'GENRE' => '장르',
        'YEAR' => '연도',
        'LABEL' => '레이블',
        'EXPLICIT_LYRICS' => '불건전 내용',
        'ARTIST_SITE' => '아티스트 홈페이지',
        'HOSTING_SITE' => '호스팅 사이트',
        'LABEL_SITE' => '레이블 사이트',
        'LICENSE' => '라이선스',
        'SELECT_LICENSE' => '—  Select license —',
        'LICENSE_NAME' => '라이선스 이름',
        'LICENSE_URL' => 'License URL',
        'MUSIC' => '음악',
        'ALLOW_PEOPLE_TO_UPLOAD_AND_SHARE_AUDIO' => '사람들이 오디오 파일을 업로드 및 공유할 수 있도록 허용하기',
        'PLAYLIST' => '플레이 리스트',
        'PODCAST' => '포드캐스트',
        'MOST_RECENT_TRACKS' => '최신',
        'FEATURED_TRACKS' => '추천',
        'HIGHEST_RATED_TRACKS' => '최고 등급',
        'NO_TRACKS_TO_PLAY' => '회원님의 네트워크에는 현재 음악이 없습니다.',
        'BOX_WILL_NOT_SHOW_TRACKS' => '재생할 노래나 포드캐스트가 있을 때까지 다른 사람들은 이 상자를 볼 수 없습니다.  노래 한 곡 추가해 보시겠어요?',
        'NO_TRACKS_ON_PLAYLIST' => '현재 이 플레이리스트에는 노래가 없습니다.',
        'PLAYER_WILL_NOT_SHOW_TRACKS' => '재생할 노래나 포드캐스트가 있을 때까지 다른 사람들은 이 플레이어를 볼 수 없습니다.  노래를 한 곡 추가해 보시겠어요?',
        'NO_FEATURED_TRACKS' => '회원님의 네트워크에는 추천곡이 없습니다.',
        'START_FEATURING_TRACKS' => '메인 페이지에 올리고 싶을 만큼 좋은 노래를 들으시면  그런 노래들을 추천곡으로 올려 보세요.',
        'VIEW_MUSICPLAYER' => '뮤직 플레이어 보기',
        'MY_PLAYLIST' => '나의 플레이 리스트',
        'NETWORK_PLAYLIST' => '네트워크 플레이 리스트',
        'COPYRIGHT' => '© 모든 저작권은 보호됨',
        'CC_BY_X' => '저작권자 표시%s',
        'CC_BY_SA_X' => '저작권자 표시-동일조건변경허락 %s',
        'CC_BY_ND_X' => '저작권자 표시-변경금지%s',
        'CC_BY_NC_X' => '저작권자 표시-비영리 %s',
        'CC_BY_NC_SA_X' => '저작권자 표시-비영리 및 동일조건변경허락 %s',
        'CC_BY_NC_ND_X' => '저작권자 표시-비영리, 변경금지%s',
        'PUBLICDOMAIN' => '공공 도메인',
        'FACEBOOK_CONFIRM_DISABLE' => '확실하세요?',
        'FACEBOOK_PLAYER_DISABLE' => '해제',
        'FACEBOOK_MUSIC_PLAYER_TITLE' => '뮤직 플레이어',
        'FACEBOOK_MUSIC_PLAYER_DESC' => '회원님께서 선택하신 음악을 재생할 수 있는 응요프로그램을 누구라도 자신의 Facebook 프로필에 추가할 수 있도록 승인하기.',
        'FACEBOOK_MUSIC_BUTTON' => '음악 응용 프로그램 만들기&raquo;',
        'FACEBOOK_MUSIC_PLAYER_ENABLED' => 'Facebook 뮤직 플레이어가 이미 작동 중.',
        'FACEBOOK_VIDEO_PLAYER_TITLE' => '동영상 플레이어',
        'FACEBOOK_VIDEO_PLAYER_DESC' => '회원님의 네트워크에 있는 동영상을 재생하는 응용 프로그램을 누구라도 자신의 Facebook 프로필에 추가할 수 있도록 승인하기.',
        'FACEBOOK_VIDEO_BUTTON' => '동영상 응용 프로그램 만들기&raquo;',
        'FACEBOOK_VIDEO_PLAYER_ENABLED' => 'Facebook 동영상 플레이어가 이미 작동 중.',
        'FACEBOOK_SLIDESHOW_PLAYER_TITLE' => '사진 슬라이드쇼',
        'FACEBOOK_SLIDESHOW_PLAYER_DESC' => '회원님의 네트워크에 있는 사진 슬라이드쇼를 재생하는 응용 프로그램을 누구라도 자신의 Facebook 프로필에 추가할 수 있도록 승인하기.',
        'FACEBOOK_SLIDESHOW_BUTTON' => '사진 슬라이드쇼 응용 프로그램 만들기 &raquo;',
        'FACEBOOK_SLIDESHOW_PLAYER_ENABLED' => 'Facebook 사진 슬라이드쇼가 이미 작동 중.',
        'FACEBOOK_PLATFORM_LOGO' => 'Facebook 플랫폼 로고',
        'FACEBOOK_QUICK_INTRO_1' => '인기 있는 사교 네트워크 사이트인 Facebook에서는 제 3자 개발자가Facebook 회원 프로필 페이지에 추가될 수 있는 응용 프로그램을 개발하는 것을 허용하고 있습니다.  이와 같은 응용 프로그램들은 프로필 페이지 기능성을 향상시킬 뿐 아니라  Facebook 사용자를 다른 웹 사이트로 유도하는 데 사용될 수 있습니다.',
        'FACEBOOK_QUICK_INTRO_2' => 'Ning과 함께라면 Facebook에서 사교 네트워크를 홍보하기 위해 프로그램 개발자가 될 필요가 없어집니다.  저희는 이미 여러분을 대신하여 어려운 부분의 일을 다 해 드렸기 때문에 회원님께서 저희를 이용해 개설하는 네크워크는  Facebook 응용 프로그램과의 통합 기능이 이미 포함하게 됩니다.  아래에 제시된 옵션 중에서 선택하기만 하면 단 몇 초 만에 회원님의 사교 네트워크가 Facebook과 통합될 것입니다.',
        'FACEBOOK_ADD_DEVELOPER_BUTTON' => '개발자 버튼 추가',
        'FACEBOOK_SETUP_NEW_APP_BUTTON' => '새로운 응용 프로그램의 버튼 설정',
        'FACEBOOK_YOUR_APPLICATIONS' => '회원님의Facebook 응용 프로그램',
        'FACEBOOK_EMBEDDING' => 'Facebook 프로모션',
        'FACEBOOK_SETUP' => 'Facebook 프로모션',
        'FACEBOOK_PROMOTING' => 'Facebook에서 응용 프로그램 홍보',
        'FACEBOOK_VIEW_APP' => '응용 프로그램 보기',
        'FACEBOOK_ADD_THE' => '추가',
        'FACEBOOK_RECENT' => '최신',
        'FACEBOOK_RECENTLY_FEATURED' => '가장 최근에 인기항목으로 추천된 것',
        'FACEBOOK_RECENTLY_ADDED' => '가장 최근에 추가된 것',
        'FACEBOOK_PROMOTED' => '추천',
        'FACEBOOK_RATED' => '최고 등급',
        'FACEBOOK_POPULAR' => '인기',
        'FACEBOOK_MUSIC_WIDGET' => '음악 위짓',
        'FACEBOOK_VIDEO_WIDGET' => '동영상 위짓',
        'FACEBOOK_PHOTO_WIDGET' => '사진 위짓',
        'FACEBOOK_INSTR_FIRST_STEPS' => '첫  번째 단계',
        'FACEBOOK_INSTR_CLICK_HERE_TO_GO_TO_FACEBOOK' => '이 곳을 클릭하여 Facebook으로 가신 후 응용 프로그램을 시작하십시오.',
        'FACEBOOK_INSTR_OPEN_FACEBOOK_IN_NEW_WINDOW' => 'Facebook이 새 창에서 열릴 것입니다,  이미 Facebook에 로그인 되어 있지 않으시다면 이 단계에서 로그인 하셔야 합니다.',
        'FACEBOOK_INSTR_FIRST_STEPS_1' => 'Facebook에서 이미 응용 프로그램을 만들지 않으신 경우 Facebook의 개발자 응용 프로그램을 추가할 것을 요청 받으실 것입니다.  일단 추가 신청을 하시면 “응용 프로그램이 없습니다”라는 메시지가 뜹니다. " <strong>새로 만들기</strong>를 클릭하십시오.',
        'FACEBOOK_INSTR_FIRST_STEPS_2' => '이미 Facebook에서 응용 프로그램을 만든 적이 있으시면 Facebook의 개발자 응용 프로그램이 나타날 것입니다.  <strong>새로운 응용 프로그램 설정</strong>버튼을 클릭하세요.',
        'FACEBOOK_INSTR_FIRST_STEPS_NEXT' => '다음: %s 응용 프로그램을 Facebook에서 사용할 수 있도록 설정하는 방법 안내를 보기.',
        'FACEBOOK_INSTR_SETUP' => '설정 방법 안내',
        'FACEBOOK_INSTR_SETUP_1' => '자, 이제까지 잘 따라 오셨어요!  보다 자세한 설명을 드릴께요.  응용 프로그램을 시작하려면 Facebook은 몇 가지 기본적인 정보를 필요로 합니다.  아래의 단계를 따라 주세요.',
        'FACEBOOK_INSTR_SETUP_REQ_FIELDS' => '필수 필드',
        'FACEBOOK_INSTR_SETUP_2' => '<strong>응용 프로그램 이름</strong>을 선택하시기 바랍니다.',
        'FACEBOOK_INSTR_SETUP_3' => 'Facebook 사용 약관을 읽었다는 표시를 해 주셔야 합니다.',
        'FACEBOOK_INSTR_SETUP_4' => '<em>선택 필드</em>를 여세요.',
        'FACEBOOK_INSTR_SETUP_BASE_OPT' => '기본 옵션',
        'FACEBOOK_INSTR_SETUP_5' => '<strong>이메일 지원</strong>필드에 회원님의 이메일 주소를 입력하십시오.',
        'FACEBOOK_INSTR_SETUP_6' => '다음의 웹 주소를<strong>콜백 URL</strong>필드에 붙여 넣으십시오:',
        'FACEBOOK_INSTR_SETUP_7_EXAMPLE_X' => '<strong>캔버스 페이지URL</strong> (e.g. <em>%s</em>)을 선택하세요.',
        'FACEBOOK_INSTR_SETUP_8' => '<em>회원님의 응용 프로그램을Facebook에 올릴 수 있습니까</em>에 <strong>예</strong>를 선택하십시오.',
        'FACEBOOK_INSTR_SETUP_INST_OPT' => '설치 옵션',
        'FACEBOOK_INSTR_SETUP_APP_DESC' => '<strong>응용 프로그램 설명</strong>을 작성해 주세요.',
        'FACEBOOK_INSTR_SETUP_9' => '<strong>기본값 FBML</strong>필드에 다음의 코드를 붙여 넣으십시오:',
        'FACEBOOK_INSTR_SETUP_9B_WIDE' => '<strong>기본값 프로필 상자 칼럼</strong>, 에는 <strong>넓음(Wide)</strong>을 선택하셔야 합니다..',
        'FACEBOOK_INSTR_SETUP_9B_NARROW' => '<strong>기본값 프로필 상자 칼럼</strong>,  에는 <strong>좁음(narrow)</strong>을 선택해 주세요.',
        'FACEBOOK_INSTR_SETUP_10' => '<strong>Side Nav URL</strong>필드에는  회원님의 <em>캔버스 페이지 URL</em>( 위의 &#8216;단계에서 만든 것)을 입력하세요. f&#8217;  ).  URL에는 http://apps.facebook.com/ 부분이 반드시 포함되어야 합니다.',
        'FACEBOOK_INSTR_SETUP_11' => '<strong>첨부 사항</strong>에 들어갈 설명을 입력하세요.  이것은회원님이Facebook에서 누군가에게 메시지를 보내면서 회원님의 응용 프로그램 중 하나를 그 이메일에 포함시키고자 할 때 나타나게 됩니다.  응용 프로그램이 ‘사진 슬라이드쇼’인 경우에는 ‘모 네트워크로부터의 사진’을 입력하게 될 것입니다.  응용 프로그램이 ‘동영상 플레이어’인 경우에는 ‘모 네트워크로부터의 동영상’을 입력하게 될 것입니다.',
        'FACEBOOK_INSTR_SETUP_12' => '다음의 웹 주소를<strong>콜백 URL</strong>필드에 붙여 넣으십시오:',
        'FACEBOOK_INSTR_APPLICATION_SETUP_PAGE' => 'Facebook 응용 프로그램 설정 페이지',
        'FACEBOOK_INSTR_SETUP_DONE' => '다 되었으면<strong>보내기</strong>버튼을 클릭하세요.',
        'FACEBOOK_INSTR_SETUP_NEXT' => '다음: API 키와 암호 불러오기.',
        'FACEBOOK_API_INFO_TITLE' => 'Facebook API 정보',
        'FACEBOOK_API_INFO_DESC' => '설정을 완료하려면 아래 필드에 API키와 암호 및 응용 프로그램 URL을 입력하셔야 합니다.',
        'FACEBOOK_API_INFO_FIND_KEY' => 'API키와 암호는 방금 만드신 응용 프로그램 제목 밑에 있는 <a %s>Facebook에서 나의 응용 프로그램 페이지</a>(새 창에서 열림)에서 찾을 수 있습니다.',
        'FACEBOOK_API_INFO_MY_APPLICATIONS_PAGE' => '나의 응용 프로그램 페이지(API 정보의 하이라이트 표시가 된 부분)',
        'FACEBOOK_API_INFO_KEY' => 'API키',
        'FACEBOOK_API_INFO_SECRET' => 'API 암호',
        'FACEBOOK_URL_INFO_TITLE' => 'Facebook 응용 프로그램 URL',
        'FACEBOOK_URL_INFO_DESC' => '응용 프로그램 URL는 이전 페이지에서 정의(&#8216; 단계 상)했던<strong>Canvas Page URL</strong> 과 같습니다 f&#8217; ).',
        'FACEBOOK_MUSIC_SHOULD_PLAY_FROM' => 'Facebook 음악 응용 프로그램은 다음을 재생해야 합니다:',
        'FACEBOOK_VIDEO_SHOULD_PLAY_FROM' => 'Facebook 동영상 응용 프로그램은 다음의 비디오를 재생해야 합니다:',
        'FACEBOOK_PHOTO_SHOULD_PLAY_FROM' => 'Facebook슬라이드쇼 응용 프로그램은 이 곳의 사진을 재생해야 합니다.',
        'FACEBOOK_PROMOTING_ON' => 'Facebook에서의 홍보',
        'FACEBOOK_SETUP_INSTR' => '설정 방법 안내',
        'FACEBOOK_API_INFO' => 'API 정보',
        'FACEBOOK_DISABLE' => '이 응용 프로그램 해제하기',
        'FACEBOOK_TO_YOUR_FACEBOOK_PROFILE' => '회원님의Facebook 프로필로 가기',
        'FACEBOOK_BACK_TO_EMBEDDING' => 'Facebook 프로모션으로 돌아가기',
        'FACEBOOK_EMBEDDING_DESC' => 'Facebook사용자들이 회원님 네트워크의 위짓과 뱃지를 자신들의 프로필 페이지에 올릴 수 있도록 허용합니다.',
        'FACEBOOK_PROMOTE' => '새로운 응용 프로그램을 홍보하는 데 있어 최소한의 비용으로 최대의 효과를 거두기 위해 다음의 방법을 권장합니다.  이와 같은 옵션들은Facebook의 <strong><a %s>나의 응용 프로그램</a></strong>페이지에서 찾을 수 있습니다 (링크는 새 창에서 열리게 됩니다).',
        'FACEBOOK_PROMOTE_TITLE_ABOUT_PAGE' => '설명 페이지 제공',
        'FACEBOOK_PROMOTE_TEXT_ABOUT_PAGE' => 'Facebook 사용자들로 하여금 회원님의 응용 프로그램이 어떤 것인지 알 수 있도록 명확한 설명을 제공해 주세요.  이 내용을 편집하려면 수정 중인 응용 프로그램 옆의<strong>설명 페이지 편집하기</strong>링크를 클릭하시면 됩니다.',
        'FACEBOOK_PROMOTE_TITLE_SUBMIT' => '응용 프로그램을 Facebook 디렉토리에 제출',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_1' => '회원님의 새로운 응용 프로그램을 Facebook 디렉토리에 추가함으로써 보다 광범위한 홍보 효과를 올릴 수 있습니다.',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_2' => '응용 프로그램을 제출하려면 수정 중인 응용 프로그램 옆의 <strong>응용 프로그램 제출</strong>링크를 클릭하세요.  다음 페이지에서는 응용 프로그램 설명을 편집하거나  응용 프로그램에 로고를 추가할 수도 있습니다.',
        'FACEBOOK_PROMOTE_TITLE_PROFILE' => 'Facebook프로필에 응용 프로그램 추가',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_1' => '회원님의 Facebook 프로필 페이지에 응용 프로그램을 올려 솜씨를 뽐내고, 친구들이 이제 회원님을 따라 자기들도 응용 프로그램을 올려 보려는 걸 느긋하게 지켜 보시면 됩니다.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_2' => '회원님의 프로필에 추가하기를 원하는 응용 회원님의 프로필 페이지에 올리고자 하는 응용 프로그램 옆의 <strong>설명 페이지 보기</strong>링크를 클릭한 다음, 그 다음 페이지에서 ‘응용 프로그램 추가’ 버튼을 선택하시기만 하면 됩니다.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_3' => '이제 회원님의 응용 프로그램이 Facebook 프로필 페이지 하단부에 나타날 것입니다!',
        'FACEBOOK_PROMOTE_MY_APPLICATIONS_PAGE' => 'Facebook의 ‘나의 응용 프로그램’ 페이지',
        'FACEBOOK_MY_APPS' => '나의 응용 프로그램',
        'FORUM_TAB_TEXT' => '포럼',
        'VIDEOS_TAB_TEXT' => '동영상',
        'PHOTOS_TAB_TEXT' => '사진',
        'GROUPS_TAB_TEXT' => '그룹',
        'ADD_PHOTOS_LOWER' => '사진 추가',
    );

    /**
     * If the given widget title is the default English title for the widget,
     * translate it into the current language.
     *
     * @param string $widgetTitle  The title of the widget
     * @return string  A translated title if the title is the English default; otherwise, the title unchanged
     */
    public static function translateDefaultWidgetTitle($widgetTitle) {
        
        return $widgetTitle;
    }

}