<?php
XG_App::includeFileOnce('/lib/XG_AbstractMessageCatalog.php');

/**
 * Texts for the French (Canada) locale.
 *
 * @see Bazel I18N Guidelines for tips on choosing key names
 */
class XG_MessageCatalog_fr_CA extends XG_AbstractMessageCatalog {

    /**
     * Returns a localized version of a string. The first argument is the message name, e.g., 'ADD_A_PHOTO'.
     * Subsequent arguments are substitution values (if the message contains sprintf format elements).
     *
     * @param $args array the message name, plus optional substitution values
     * @return string the localized string
     * @see xg_html()
     */
    public static function text($args) {
        $s = $args[0];
        static $a = array();
        if (! $a) {
            $a['N_SECONDS_AGO']['1'] = 'Il y a 1 seconde ';
            $a['N_SECONDS_AGO']['n'] = 'Il y a %s secondes ';
            $a['N_MINUTES_AGO']['1'] = 'Il y a 1 minute ';
            $a['N_MINUTES_AGO']['n'] = 'Il y a %s minutes ';
            $a['N_HOURS_AGO']['1'] = 'Il y a 1 heure ';
            $a['N_HOURS_AGO']['n'] = 'Il y a %s heures ';
            $a['N_VIDEOS']['1'] = '<strong>1</strong> Vidéo ';
            $a['N_VIDEOS']['n'] = '<strong>%s</strong> Vidéos ';
            $a['N_VIEWS']['1'] = '1 vue ';
            $a['N_VIEWS']['n'] = '%s vues ';
            $a['N_COMMENTS']['1'] = '<span class="comment-count">1</span> Commentaire ';
            $a['N_COMMENTS']['n'] = '<span class="comment-count">%s</span> Commentaires ';
            $a['VIDEO_IS_FAVORITE_OF']['1'] = 'Cette vidéo est la<strong>préferée</strong> d\’ <strong>une personne</strong>. ';
            $a['VIDEO_IS_FAVORITE_OF']['n'] = 'Cette video est la <strong>préferée</strong> de <strong>%s personnes</strong>. ';
            $a['Y_ADDED_X_VIDEOS']['1'] = '%2$s a ajouté une vidéo : ';
            $a['Y_ADDED_X_VIDEOS']['n'] = '%2$s a ajouter %s vidéos. ';
            $a['YOU_ADDED_X_VIDEOS']['1'] = 'Vous avez ajouté une vidéo : ';
            $a['YOU_ADDED_X_VIDEOS']['n'] = 'Vous avez ajouté %s vidéos. ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['1'] = 'Il y a une vidéo sur %2$s ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['n'] = 'Il y a %1$s vidéos sur %2$s ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['1'] = 'Il y a 1 <a href="%3$s">vidéo</a> sur %2$s ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['n'] = 'Il y a %1$s <a href="%3$s">vidéos</a> sur %2$s ';
            $a['N_PHOTOS_FROM_ALBUM']['1'] = '1 photo de cet album a été supprimée ou rendue privée, pour qu\'elle ne soit pas affichée. ';
            $a['N_PHOTOS_FROM_ALBUM']['n'] = '%s photos de cet album ont été supprimées ou rendues privées, pour qu\'elles ne soient pas affichées. ';
            $a['N_PHOTOS']['1'] = '<strong>1</strong> Photo ';
            $a['N_PHOTOS']['n'] = '<strong>%s</strong> Photos ';
            $a['N_PHOTOS_2']['1'] = '1 photo ';
            $a['N_PHOTOS_2']['n'] = '%s photos ';
            $a['AND_X_OTHER_PEOPLE']['1'] = 'ajouter 1 autre personne ';
            $a['AND_X_OTHER_PEOPLE']['n'] = 'et %s autres personnes ';
            $a['PROBLEM_UPLOADING_FILES']['1'] = 'Un problème est survenu durant le téléchargement du fichier suivant : ';
            $a['PROBLEM_UPLOADING_FILES']['n'] = 'Un problème est survenu durant le téléchargement des fichiers suivants : ';
            $a['PHOTO_IS_FAVORITE_OF']['1'] = 'Cette photo est la <strong>préferée</strong> d\’<strong>1 personne</strong>. ';
            $a['PHOTO_IS_FAVORITE_OF']['n'] = 'Cette photo est la <strong>préferée</strong> de <strong>%s personnes</strong>. ';
            $a['RATING_Y_AFTER_X_VOTES']['1'] = '<strong>Classement :</strong> %2$s après 1 vote ';
            $a['RATING_Y_AFTER_X_VOTES']['n'] = '<strong>Classement :</strong> %2$s après %s votes ';
            $a['Y_AFTER_X_VOTES']['1'] = '%2$s après 1 vote ';
            $a['Y_AFTER_X_VOTES']['n'] = '%2$s après %s votes ';
            $a['N_PEOPLE']['1'] = '1 personne ';
            $a['N_PEOPLE']['n'] = '%s personnes ';
            $a['N_OF_5_STARS']['1'] = '1/5 étoile ';
            $a['N_OF_5_STARS']['n'] = '%s/5 étoiles ';
            $a['YOUR_RATING_X_STARS']['1'] = 'Votre classement : 1 étoile ';
            $a['YOUR_RATING_X_STARS']['n'] = 'Votre classement : %s étoiles ';
            $a['Y_ADDED_X_PHOTOS']['1'] = '%2$s a ajouté une photo : ';
            $a['Y_ADDED_X_PHOTOS']['n'] = '%2$s a ajouté %s photos. ';
            $a['YOU_ADDED_X_PHOTOS']['1'] = 'Vous avez ajouté une photo : ';
            $a['YOU_ADDED_X_PHOTOS']['n'] = 'Vous avez ajouté %s photos. ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['1'] = 'Il y a 1 photo sur %2$s ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['n'] = 'Il y a %1$s photos sur %2$s ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['1'] = 'Il y a %1$s <a href="%3$s">photo</a> sur %2$s ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['n'] = 'Il y a %1$s <a href="%3$s">photos</a> sur %2$s ';
            $a['N_COMMENTS_ON_PAGE']['1'] = '<strong>1</strong> Commentaire dans votre page ';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s</strong> Comments on your page';;
            $a['N_BLOG_COMMENTS']['1'] = '<strong>1</strong> commentaire blogue ';
            $a['N_BLOG_COMMENTS']['n'] = '<strong>%s</strong> commentaries blogue ';
            $a['N_YEARS_OLD']['1'] = 'Âgé(e) d\’1 an ';
            $a['N_YEARS_OLD']['n'] = 'Âgé(e)s de %s ans ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['1'] = 'Vous avez 1 requête d’ami(e)! ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['n'] = 'Vous avez %s requêtes d’ami(e)! ';
            $a['COMMENT_WALL_N_COMMENTS']['1'] = 'Mur de commentaires(1 commentaire) ';
            $a['COMMENT_WALL_N_COMMENTS']['n'] = 'Mur de Commentaires(%s commentaires) ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['1'] = '1 nouveau membre a adhéré pendant la semaine passée ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['n'] = '%s nouveaux membres ont adhéré pendant la semaine passée ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['1'] = '1 <a href="%2$s">nouveau membre</a> a adhéré pendant la semaine passée ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['n'] = '%1$s <a href="%2$s">nouveaux membres</a> ont adhéré pendant la semaine passée ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['1'] = 'Il y a 1 membre sur %2$s ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['n'] = 'Il y a %1$s membres sur %2$s ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['1'] = 'Il y a 1 <a href="%3$s">membre</a> sur %2$s ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['n'] = 'Il y a %1$s <a href="%3$s">membres</a> sur %2$s ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['1'] = 'Il y a 1 publication de blogue sur %2$s ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['n'] = 'Il y a %1$s publications de blogue sur %2$s ';
            $a['N_NEW_MEMBERS']['1'] = '<strong>1</strong> Nouveau membre ';
            $a['N_NEW_MEMBERS']['n'] = '<strong>%s</strong> Nouveaux Membres ';
            $a['N_REPLIES']['1'] = '1 Réponse ';
            $a['N_REPLIES']['n'] = '%s Réponses ';
            $a['N_MINUTES']['1'] = 'Il reste 1 minute pour modifier votre commentaire. ';
            $a['N_MINUTES']['n'] = 'Il reste %s minutes pour modifier votre commentaire. ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['1'] = 'Il y a un sujet de forum sur %2$s ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['n'] = 'Il y a %1$s sujets de forum sur %2$s ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['1'] = 'Il y a 1 <a href="%3$s">sujet de forum</a> on %2$s ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['n'] = 'Il y a %1$s <a href="%3$s">sujets de forum</a> sur %2$s ';
            $a['N_INVITES']['1'] = '%s invitation ';
            $a['N_INVITES']['n'] = '%s invitations ';
            $a['N_MEMBERS']['1'] = '1 membre ';
            $a['N_MEMBERS']['n'] = '%s membres ';
            $a['N_MEMBERS_PARENTHESIZED']['1'] = '(1 membre) ';
            $a['N_MEMBERS_PARENTHESIZED']['n'] = '(%s membres) ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['1'] = 'Il y a 1 groupe sur %2$s ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['n'] = 'Il y a %1$s groupes sur %2$s ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['1'] = 'Il y a %1$s <a href="%3$s">groupe</a> on %2$s ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['n'] = 'Il y a %1$s <a href="%3$s">groupes</a> sur %2$s ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['1'] = '1 chanson de cette sélection ne peut être affichée parce qu’elle a été supprimée ou n’est plus partagée. ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['n'] = '%s chansons de cette sélection ne peuvent être affichées parce qu’elles ont été supprimées ou ne sont plus partagées. ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['1'] = 'Une nouvelle chanson a été ajoutée à %2$s ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['n'] = '%1$s nouvelles chansons ont été ajoutées à %2$s ';
            $a['Y_ADDED_X_SONGS']['1'] = '%2$s a ajouté une chanson : ';
            $a['Y_ADDED_X_SONGS']['n'] = '%2$s a ajouté %s chansons. ';
            $a['YOU_ADDED_X_SONGS']['1'] = 'Vous avez ajouté une chanson : ';
            $a['YOU_ADDED_X_SONGS']['n'] = 'Vous avez ajouté %s chansons. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['1'] = '1 chanson ajoutée à cette sélection. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['n'] = '%s chansons ajoutées à cette sélection. ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['1'] = 'Il y a une chanson sur %2$s ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['n'] = 'Il y a %1$s chansons sur %2$s ';
            $a['N_INVITATIONS_RESENT']['1'] = '1 invitation a été renvoyée. ';
            $a['N_INVITATIONS_RESENT']['n'] = '%s invitations ont été renvoyées. ';
            $a['N_COMMENTS_ON_PAGE']['1'] = '<strong>1</strong> commentaire profil ';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s</strong> commentaires profil ';
            }
        if ($a[$args[0]]) {
            $args[0] = $a[$args[0]][$args[1]] ? $a[$args[0]][$args[1]] : $a[$args[0]]['n'];
            return @call_user_func_array('sprintf', $args);
        }
        $text = self::$messages[$s];
        if ($text) { $args[0] = $text; }
        return @call_user_func_array('sprintf', $args);
    }

    /**
     * Message names and texts. Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;
     */
    private static $messages = array(
        'FACEBOOK_VIDEO_PLAYER_TITLE' => 'Lecteur vidéo',
        'FACEBOOK_VIDEO_BUTTON' => 'Créer une application de lecteur vidéo &raquo;',
        'FACEBOOK_VIDEO_PLAYER_ENABLED' => 'Le lecteur vidéo Facebook est déjà activé.',
        'FACEBOOK_VIDEO_WIDGET' => 'Widget Vidéo',
        'FACEBOOK_INSTR_SETUP_11' => 'Entrez un texte dans le champ <strong>Action pièce jointe</strong>. Ce texte lorsque vous envoyez un message à un usager sur Facebook et vous voulez y inclure une de vos applications. Si votre application est un diaporama de photos, vous pouvez par exemple entrez « Photos du réseau X ». Ou bien si votre application est un lecteur vidéo, vous pouvez par exemple entrer « Vidéo du réseau X ».',
        'WHO_CAN_VIEW_YOUR_PHOTOS_VIDEOS' => 'Qui peut voir vos photos, vidéos et entrées de blogue<br/>par défaut?',
        'YOU_CAN_OVERRIDE_WHEN_YOU_ADD' => '(Vous pouvez supplanter ce paramètre pour une photo, vidéo ou entrée de blogue lorsque vous les ajoutez.)',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT_ADD' => 'Il n\'y a aucune discussion ayant comme balise "%1$s". Vérifiez <a %2$s>les photos ayant comme balise "%1$s"</a> ou <a %3$s>les vidéos ayant comme balise "%1$s"</a>. Ou bien balisez vos propres discussions!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT' => 'Il n\'y a aucune discussion ayant comme tag "%1$s". Vérifiez <a %2$s>les photos ayant comme balise "%1$s"</a> ou <a %3$s>les vidéos ayant comme balise "%1$s"</a>.',
        'CHOOSE_HEADER_OR_WATERMARK' => 'Vous pouvez choisir entre un logo ou un filigrane pour votre lecteur vidéo.',
        'CUSTOMIZE_WATERMARK_INSTRUCTIONS' => 'Le filigrane apparaît au-dessus du coin droit de votre vidéo.',
        'CUSTOMIZE_YOUR_VIDEO_PLAYER' => 'Personnaliser votre lecteur vidéo!',
        'VIDEO_PLAYER' => 'Lecteur vidéo',
        'EDIT_VIDEO_INFORMATION' => 'Modifier l\'information sur la vidéo',
        'ALL_VIDEOS' => 'Toutes les vidéos',
        'VIDEOS_HOME' => 'Page d\'accueil vidéos',
        'MY_VIDEOS' => 'Mes vidéos',
        'MY_FRIENDS_VIDEOS' => 'Vidéos de mes amis',
        'ADD_A_VIDEO' => 'Ajouter une vidéo',
        'YOU_HAVE_NOT_ADDED_VIDEOS' => 'Vous n\'avez pas encore ajouté de vidéos!',
        'ADD_VIDEOS_AND_SHARE' => 'Ajoutez des vidéos et partagez les avec vos amis, votre famille ou le monde entier!',
        'ADD_VIDEOS' => 'Ajout de vidéos',
        'VIEW_VIDEOS' => 'Visionner les vidéos',
        'NOBODY_HAS_ADDED_VIDEOS' => 'Personne n\'a ajouté de Vidéos! Ajoutez-en dès maintenant.',
        'ADD_YOUR_FIRST_VIDEO' => 'Ajoutez votre toute première vidéo',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_1' => 'Ajoutez un titre, une description et d\'autres informations pour la vidéo que vous venez de télécharger.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_2' => 'Ajoutez un titre, une description et d\'autres informations pour cette Vidéo.',
        'CANCEL_AND_RETURN_TO_VIDEO' => 'Annuler et retourner à la vidéo',
        'TAGS_ARE_SHORT_DESCRIPTIONS' => 'Des balises (balises en anglais) sont des mots-clés ou de courts textes qui servent à identifier vos vidéos. Séparez chaque balisepar une virgule et mettez vos multi-mots entre guillemets, par exemple, « Océan Pacifique ».',
        'WHO_CAN_VIEW_VIDEO' => 'Qui peut accéder à cette vidéo?',
        'YOU_CAN_ADD_YOUR_OWN_VIDEO' => 'Vous pouvez <a %s>ajouter votre propre vidéo</a> au réseau : %s!',
        'ADD_PLAYER_LOGO_OR_WATERMARK' => 'Ajoutez un logo ou un filigrane à votre lecteur vidéo. <a %s>Faites-le maintenant!</a>',
        'APPLY_TO_VIDEOS_ADDED_BY' => 'Applicable à toutes les Vidéos ajoutées par %s',
        'NO_VIDEOS_AWAITING_APPROVAL' => 'Il n\'y a actuellement aucune Vidéo à autoriser. Si vous chercher quelque chose à faire, pourquoi ne pas visionner <a %s>les plus récentes Vidéos</a>?',
        'REMOVE_VIDEO_FROM_FAVORITES' => 'Enlever cette Vidéo de mes Favoris?',
        'YOU_CAN_MARK_VIDEO' => 'Vous pouvez ajouter une vidéo à vos Favoris en cliquant sur l\'îcone « Ajouter à mes Favoris » située au-dessus de la Vidéo.',
        'VIEW_RECENT_VIDEOS' => 'Voir les plus récentes Vidéos',
        'APPROVE_VIDEOS' => 'Autoriser Vidéos',
        'YOUR_SITE_REQUIRES_YOU' => 'Vous devez autoriser les photos et vidéos sur votre réseau social avant qu\'elles soient publiées. Pour modifier cette option, allez à la section <a %s>Adhésion et confidentialité</a> de la page de gestion et cocher « Non » dans la section « Modération des photos et vidéos ».',
        'ARE_YOU_SURE_APPROVE_ALL_VIDEOS' => 'Êtes-vous sûr de vouloir autoriser toutes les Vidéos? Cela peut prendre quelques minutes.',
        'ARE_YOU_SURE_DELETE_ALL_VIDEOS' => 'Êtes-vous sûr de vouloir supprimer toutes les Vidéos qui ne sont pas encore autorisées? Cela peut prendre quelques minutes.',
        'XS_VIDEOS' => 'Les Vidéos de(d\') %s',
        'DELETE_ALL_XS_VIDEOS_Q' => 'Supprimer toutes les Vidéos de(d\') %s?',
        'DELETE_ALL_XS_VIDEOS' => 'Supprimer toutes les Vidéos de(d\') %s',
        'ARE_YOU_SURE_DELETE_ALL_XS_VIDEOS' => 'Êtes-vous sûr de vouloir supprimer toutes les Vidéos de(d\') %s? Cela peut prendre quelques minutes.',
        'DELETE_THIS_VIDEO_Q' => 'Supprimer cette Vidéo?',
        'ARE_YOU_SURE_DELETE_THIS_VIDEO' => 'Êtes-vous sûr de vouloir supprimer cette Vidéo? Cela peut prendre quelques minutes.',
        'YOU_HAVE_NOT_ADDED_VIDEOS_2' => 'Vous n\'avez pas encore ajouté de Vidéos. Ajoutez-en dès maintenant!',
        'X_HAS_NOT_ADDED_VIDEOS' => '%s n\'a pas encore ajouté de Vidéos.',
        'YOUR_FRIENDS_DO_NOT_HAVE_VIDEOS' => 'Vos amis n\'ont pas encore ajouté de Vidéos.',
        'ALL_VIDEOS_TAGGED_X' => 'Toutes les vidéos ayant comme tag \'%s\'',
        'ALL_VIDEOS_TAGGED_X_2' => 'Toutes les vidéos ayant comme tag <em>\'%s\'</em>',
        'NO_VIDEOS_TAGGED_X_CHECK_OUT' => 'Il n\'y a aucune vidéo ayant comme tag "%1$s". Vérifiez <a %2$s>les discussions ayant comme tag "%1$s"</a> ou <a %3$s>les photos ayant comme balise "%1$s"</a>. Ou bien balisez vos propres vidéos!',
        'KEEP_PAGE_OPEN' => 'Veuillez garder cette fenêtre ouverte pendant le téléchargement de votre Vidéo. Lorsque votre Vidéo sera autorisée par l\'administrateur, nous allons vous le faire savoir!',
        'MEANWHILE_FEEL_FREE' => 'En attendant, sentez-vous libre <a %s>d\'ouvrir une autre fenêtre</a> et de continuer à naviguer le réseau « %s ». Lorsque le téléchargement sera terminé, vous allez avoir l\'occasion d\'ajouter un titre et une description à votre Vidéo.',
        'VIDEO_IS_WAITING_FOR_APPROVAL' => 'Cette Vidéo est <strong>en attente d\'autorisation</strong> pas l\'administrateur du réseau « %s ».',
        'EDIT_VIDEO' => 'Modifier Vidéo',
        'DELETE_VIDEO' => 'Supprimer Vidéo',
        'ABOUT_THIS_VIDEO' => 'À propos de cette vidéo',
        'LOCATION_OF_VIDEO' => 'Emplacement de cette Vidéo:',
        'RELATED_VIDEOS' => 'Vidéos Similaires',
        'ALL_VIDEOS_TAGGED_X_X' => 'Toutes les Vidéos ayant comme tag %s (%s)',
        'XS_VIDEOS_X' => 'Les Vidéos de %s (%s)',
        'VIDEO_DETAILS' => 'Détails de la Vidéo',
        'UPLOAD_A_VIDEO_FROM' => 'Télécharger une Vidéo à partir de votre ordinateur:',
        'VIDEO_UPLOADED_ON_X' => 'Vidéo téléchargé le %s',
        'YOUR_VIDEO_TITLED_X_COULD_NOT' => 'Votre vidéo intitulé "%s" n\'a pu être ajoutée au réseau « %s »',
        'VIDEO_ID' => 'ID de la Vidéo:',
        'ADD_VIDEO' => 'Ajouter une vidéo',
        'MORE_WAYS_TO_ADD_VIDEOS' => 'D\'autres manières d\'ajouter des vidéos…',
        'NO_PHOTOS_TAGGED_X_CHECK_OUT' => 'Il n\'y a aucune photo ayant comme balise "%1$s". Vérifiez <a %2$s>les discussions ayant comme balise "%1$s"</a> ou <a %3$s>les vidéos ayant comme tag "%1$s"</a>. Ou bien balisez vos propres photos!',
        'ADD_PHOTOS_OR_VIDEOS_TO_X' => 'Ajouter une photo ou vidéo directement sur le réseau « %s » par téléphone en l\'envoyant à une adresse électronique.',
        'MAKE_YOUR_X_PAGE_YOUR_OWN' => '<p>Cliquez sur « Modifier » pour ajouter un texte, des vidéos, des photos ou n\'importe quel « widget » à cette boîte. C\'est une autre manière de personnaliser votre page sur le réseau « %s ».</p>',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Cliquez sur « Modifier » pour ajouter un texte, un code HTML, des vidéos, des photos, ou des « <a %1$s>widgets</a> » à cette boîte. C\'est une autre manière de personnaliser votre page sur %2$s.',
        'ADD_A_VIDEO_MORE_OPTIONS' => 'Ajoutez une vidéo à votre site web ou votre page MySpace. Vous voulez d\'autres options? <a href="%s">Visionnez toutes les vidéos</a> sur %s.',
        'NO_VIDEOS_TO_DISPLAY' => 'Vous n\'affichez actuellement aucune vidéo.',
        'NO_PHOTOS_AVAILABLE' => 'Il n\'y a actuellement aucune photo de disponible dans cet album. <a %s>Cliquez ici pour voir tous les albums</a>.',
        'NO_PHOTOS_AWAITING_APPROVAL' => 'Il n\'y a actuellement aucune photo à autoriser. Si vous chercher quelque chose à faire, pourquoi ne pas aller voir <a %s>les plus récentes photos</a>?',
        'YOUVE_SET_THE_NUMBER_OF_PHOTOS' => 'Il n\'y a actuellement aucune photo d\'affichée.',
        'NO_MEMBERS_TO_DISPLAY' => 'Vous n\'affichez actuellement aucun membre',
        'YOU_ARE_MODERATING_BLOG_COMMENTS' => 'Vous avez actuellement choisi de modérer les commentaires sur votre blogue.',
        'YOU_ARE_NOT_MODERATING_BLOG_COMMENTS' => 'Vous avez actuellement choisi de ne pas modérer les commentaires sur votre blogue.',
        'THERE_ARE_NO_FEATURED_X' => 'Il n\'y a actuellement pas de %s en primeur sur votre réseau social.',
        'YOU_ARE_DISPLAYING_NO_POSTS' => 'Vous n\'affichez actuellement aucune entrée.',
        'NO_FEED_TO_DISPLAY' => 'Vous n\'affichez actuellement aucun article.',
        'NO_DISCUSSION_TO_DISPLAY' => 'Vous n\'affichez actuellement aucune discussion.',
        'YOU_HAVE_NOT_ADDED_CATEGORIES' => 'Il n\'y a actuellement aucune catégorie. Ajoutez-en dès maintenant!',
        'THERE_ARE_NO_DISCUSSIONS' => 'Il n\'y a actuellement aucune discussion sur votre réseau.',
        'NO_GROUPS_TO_DISPLAY' => 'Il n\'y a actuellement aucun groupe d\'affiché.',
        'NO_TRACKS_TO_PLAY' => 'Il n\'y a actuellement pas de musique sur votre réseau social.',
        'FACEBOOK_INSTR_OPEN_FACEBOOK_IN_NEW_WINDOW' => 'Ceci va ouvrir Facebook dans une autre fenêtre. Si vous n\'êtes pas actuellement connecté sur Facebook, vous allez devoir le faire à cet instant.',
        'YOU_ARE_GETTING_STARTED' => 'Ce n\'est que le commencement!',
        'ARE_YOU_SURE_APPROVE_ALL_PHOTOS' => 'Êtes-vous sûr de vouloir autoriser toutes les Photos? Cela peut prendre quelques minutes.',
        'ARE_YOU_SURE_DELETE_ALL_PHOTOS' => 'Êtes-vous sûr de vouloir supprimer toutes les photos qui ne sont pas encore autorisées? Cela peut prendre quelques minutes.',
        'KEEP_WINDOW_OPEN_PHOTOS_APPROVED' => 'Veuillez garder cette fenêtre ouverte pendant l\'autorisation des photos. Cela peut prendre quelques minutes.',
        'KEEP_WINDOW_OPEN_PHOTOS_DELETED' => 'Veuillez garder cette fenêtre ouverte pendant la suppression des photos. Cela peut prendre quelques minutes.',
        'ARE_YOU_SURE_DELETE_ALL_XS_PHOTOS' => 'Êtes-vous sûr de vouloir supprimer toutes les photos de %s? Cela peut prendre quelques minutes.',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED' => 'Veuillez garder cette fenêtre ouverte pendant la suppression du contenu. Cela peut prendre quelques minutes.',
        'ARE_YOU_SURE_DELETE_THIS_PHOTO' => 'Êtes-vous sûr de vouloir supprimer cette Photo? Cela peut prendre quelques minutes.',
        'GET_MY_FLICKR_PHOTOS_DESCRIPTIONS' => 'Importer les descriptions aussi (cela va doubler le temps d\'importation).',
        'GET_MY_FLICKR_PHOTOS_ORIGINALS' => 'Importer la version pleine dimension de chaque photo (cela va aussi augmenter le temps d\'importation).',
        'REMOVE_THIS_FROM_YOUR' => 'Enlever ceci de la page principale',
        'YOU_NEED_TO_SET_UP_FLICKR' => 'Vous devez mettre en place le mécanisme d\'importation avant de que les gens puissent importer leur photos de chez Flickr. Cela prend seulement quelques minutes alors pourquoi ne pas <a %s>le faire dès maintenant</a>?',
        'DONT_SHOW_THIS_AGAIN_FLICKR' => 'SVP ne pas me montrer ceci à nouveau.',
        'THIS_IS_PREVIEW_OF_BLOG_POST' => 'Ceci est une prévisualisation de votre post blogue. Cliquer sur « Précédent » pour modifier à nouveau l\'entrée ou sur « Publier! » pour le publier!',
        'THIS_IS_UNPUBLISHED_DRAFT' => 'Ceci est un brouillon non publié',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED_2' => 'Veuillez garder cette fenêtre ouverte pendant que tout le contenu de %s s\'efface. Cela peut prendre quelques minutes.',
        'REPLY_TO_THIS' => 'Répondre à cela',
        'THIS_SETS_URL_OF_GROUP' => 'Ceci est l\'adresse web de votre groupe: http://%s/<strong>adressedugroupe</strong>',
        'USE_EDIT_WIDGET_BUTTON_CALENDAR' => 'Cliquez sur le bouton « Modifier widget » et ensuite sur « Recherche d\'événements ». Entrez un terme de recherche (par exemple : Noël, Pâques, une équipe sportive, etc.), cliquez sur « Allez! » et ensuite sélectionnez un des résultats de recherche pour l\'ajouter à votre calendrier. Vous pouvez aussi manuellement ajouter l\'adresse web d\'un flux iCal (iCal feed) existant.',
        'WEBCAM_WIDGET_ALLOWS_YOU' => 'Le widget Webcam vous permet de surveiller activement toute webcam disponible publiquement. Cliquez sur le bouton « Modifier widget » pour sélectionner une des webcams gratuites de la liste « Webcams prédéfinies» ou bien entrer manuellement l\'adresse web d\'une webcam.',
        'FLICKR_STEP2_F' => 'Copiez et collez l\'adresse web suivante dans le champs <strong>Rappeler URL</strong>:',
        'PLEASE_ENTER_URL_FOR_GROUP' => 'Veuillez choisir une adresse web pour votre groupe.',
        'URL_CAN_CONTAIN_ONLY_LETTERS' => 'L\'adresse Web ne peut contenir que des lettres ou des chiffres (pas d\'espaces).',
        'URL_TAKEN' => 'Nous sommes désolés - cette adresse web est déjà prise. Veuillez choisir une autre adresse web.',
        'LICENSE_URL' => 'Adresse web de la licence',
        'FACEBOOK_INSTR_SETUP_6' => 'Copiez et collez l\'adresse web suivante dans le champs <strong>Rappeler URL</strong>:',
        'FACEBOOK_INSTR_SETUP_12' => 'Copiez et collez l\'adresse web suivante dans le champs <strong>Rappeler URL</strong>:',
        'TAGGED' => 'Avec balises :',
        'ALL_PHOTOS_TAGGED_X' => 'Toutes les photos ayant comme balise \'%s\'',
        'ALL_PHOTOS_TAGGED_X_2' => 'Toutes les photos ayant comme balise<em>\'%s\'</em>',
        'PUBLIC_PHOTOS_TAGGED_WITH_X' => 'Photos publiques taggées %s par %s',
        'GET_ALL_MY_TAGGED' => 'Importer toutes mes photos ayant comme tag',
        'NO_DISCUSSIONS_TAGGED_X' => 'Il n\'y a aucune discussion ayant comme tag "%1$s". Vous pouvez tagger vos discussions dès maintenant.',
        'TAGGED_X' => 'Avec balises : %s',
        'ALL_DISCUSSIONS_TAGGED_X' => 'Toutes les Discussion ayant comme tag <em>\'%s\'</em>',
        'SUBSCRIBE_TO_DISCUSSIONS_TAGGED_X' => 'S\'inscrire aux Discussions ayant comme tag \'%s\'',
        'TAGS' => 'Balises :',
        'POPULAR_TAGS' => 'Balises populaires',
        'GET_STARTED_BY_IMPORT' => 'Nous allons automatiquement importer les titres, balises ainsi que les coordonnées géographiques.<br/>Combien de temps cela va prendre?</p><p><ul style="padding-top:10px;"><li>10 photos: <em>moins de 30 secondes</em>.</li><li>50 photos: <em>environ 2 minutes</em>.</li><li>200 photos: <em>environ 6 minutes</em>.</li><li>500 photos: <em>environ 15 minutes</em>.</li></ul>',
        'BROWSING' => 'Navigation',
        'MORE_VIDEOS' => 'Plus de vidéos',
        'NETWORK_DOES_NOT_HAVE_VIDEOS' => 'Ce réseau n’a pas encore de vidéos.',
        'NETWORK_DOES_NOT_HAVE_FEATURED_VIDEOS' => 'Ce réseau n’a pas encore de vidéos de qualité.',
        'PERSON_DOES_NOT_HAVE_VIDEOS' => 'Cette personne n’a pas encore de video.',
        'COPY_TO_CLIPBOARD' => 'Copier au presse-papiers',
        'COPIED_TO_CLIPBOARD' => 'Copié au presse-papiers!',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_VIDEO' => 'Cette boîte ne va pas être affichée à moins que vous ne sélectionniez au moins une vidéo.',
        'WATERMARK_LOGO' => 'Filigrane',
        'CUSTOMIZE_EMBED_INSTRUCTIONS' => 'Le logo apparaît dans le haut de votre %s. Si vous n\'ajoutez pas de logo, le nom de réseau sera affiché à la place. Votre logo doit être en format .jpg, .gif ou .png. Les logos ayant une hauteur supérieure à 20 pixels doivent être redimensionnés pour pouvoir être insérés.',
        'HEADER_LOGO' => 'Logo d\'en-tête',
        'WATERMARK' => 'Filigrane',
        'HEADER' => 'En-Tête',
        'SAVE_CHANGES' => 'Sauvegarder vos modifications',
        'THUMBNAIL' => 'Imagette',
        'CONVERSION_FAILED' => 'Conversion Échouée',
        'CONVERSION_IN_PROGRESS' => 'Conversion En Cours',
        'MAP' => 'Carte Géographique',
        'WHAT_IS_THIS' => 'Qu\'est-ce que ceci?',
        'MY_FAVORITES' => 'Mes Favoris',
        'XS_FAVORITES' => 'Les Favoris de(d\') %s',
        'JUST_NOW' => 'dernièrement',
        '1_DAY_AGO' => 'hier',
        'M_J' => 'j M',
        'ME' => 'Moi',
        'X_SAID' => '%s a dit...',
        'DELETE_COMMENT' => 'Supprimer le commentaire',
        'YIKES' => 'Oups!',
        'A_PROBLEM_SEEMS' => 'Un problème vient de survenir.',
        'FOR_FURTHER_ASSISTANCE' => 'Pour de plus amples renseignements, veuillez <a %s>nous rejoindre</a>.',
        'OR_YOU_CAN_GO' => 'Vous pouvez aussi retourner à la <a %s>page principale</a> du réseau « %s » ou bien découvrir d\'autres <a %s>Réseaux sociaux sur Ning</a>',
        'MY_FRIENDS' => 'Mes amis',
        'VIEW_ALL_MY_FRIENDS' => 'Voir tous mes amis',
        'VIEW_ALL_XS_FRIENDS' => 'Voir tous les amis de(d\') %s',
        'WE_COULD_NOT_FIND_ANYONE_MATCHING' => 'Nous sommes désolés, aucun résultat n\'a été trouvé.',
        'VIEW_POPULAR_CONTRIBUTORS' => 'Voir contributeurs populaires',
        'POPULAR_CONTRIBUTORS' => 'Contributeurs populaires',
        'VIEW_MORE_CONTRIBUTORS' => 'Voir d\'autres contributeurs',
        'ADD_AS_FRIEND' => 'Ajouter à ma liste d\'amis!',
        'SEND_A_MESSAGE' => 'Envoyer un Message!',
        'IS_YOUR_FRIEND' => 'Est votre ami(e)!',
        'IS_BLOCKED' => 'Est Bloqué(e)',
        'SORT_BY' => 'Classer par:',
        'CLOSE' => 'Fermer',
        'USER_COUNT' => '(%d)',
        'SEARCH_PEOPLE' => 'Recherche de Personnes:',
        'INVITE_YOUR_FRIENDS_TO' => 'Invitez vos amis à joindre le réseau: %s.',
        'INVITE' => 'Invitation',
        'INVITE_TAB_TEXT' => 'Invitation',
        'YOU_HAVE_NOT_ADDED_FRIENDS' => 'Vous n\'avez pas encore d\'amis sur le réseau: %s.',
        'SEARCH_FRIENDS' => 'Recherche d\'amis:',
        'USE_HTML_EMBED_CODE' => 'Utiliser un « Code d\'incrustation HTML »',
        'WE_SUPPORT_MOV' => 'Nous supportons les fichiers de formats .mov, .mpg, .mp4, .avi, .3gp et .wmv. Les fichiers doivent avoir une dimension de 100 Mo ou moins.',
        'NEED_HELP_HERE_ARE' => 'Besoin d\'aide? Voici les instructions pour <a %s>YouTube</a> et <a %s>Google Video</a>.',
        'ADD_TITLE_AND_DESCRIPTION' => 'Ajoutez un titre et une description',
        'DESCRIPTION_COLON' => 'Description:',
        'EVERYTHING_IS_OPTIONAL' => 'Cette étape est optionnelle. Si vous voulez ne rien ajouter, vouz n\'avez qu\'à cliquer sur « Sauter cette étape ».',
        'SKIP_THIS_STEP' => 'Sauter cette étape',
        'TITLE' => 'Titre :',
        'MOST_POPULAR' => 'Les plus populaires',
        'HIGHEST_RATED' => 'Les mieux coté(e)(s)',
        'MOST_RECENT' => 'Les plus récent(e)(s)',
        'MOST_FAVORITED' => 'Les plus ajouté(e)s aux favoris',
        'MOST_POPULAR_VIDEOS' => 'Vidéos les plus populaires',
        'HIGHEST_RATED_VIDEOS' => 'Vidéo les mieux cotées',
        'MOST_RECENT_VIDEOS' => 'Vidéos les plus récentes',
        'MOST_FAVORITED_VIDEOS' => 'Vidéos les plus ajoutées au favoris',
        'ANYONE' => 'Tout le monde',
        'JUST_MY_FRIENDS' => 'Juste mes amis',
        'JUST_ME' => 'Juste moi',
        'VIEWABLE_BY_FRIENDS' => 'Visible à <strong>Mes amis</strong>',
        'PRIVATE_VIDEO' => 'Vidéo <strong>privée</strong>',
        'VIEWABLE_BY_EVERYONE' => 'Visible à <strong>Toute le monde</strong>',
        'LOCATION' => 'Emplacement:',
        'NO_LOCATION' => 'Emplacement non spécifié',
        'CLICK_ON_LOCATION' => 'Cliquez sur un emplacement sur la carte:',
        'FIND_AN_ADDRESS' => 'Repérer une adresse:',
        'LOCATE' => 'Repérer',
        'APPROVE' => 'Autoriser',
        'DELETE' => 'Supprimer',
        'NO_TITLE' => 'Aucun Titre',
        'ADDED_BY_STRONG_X' => 'Ajout par <strong>%s</strong>',
        'NO_DESCRIPTION' => 'Aucune Description',
        'BY_X' => 'par %s',
        'YOU_HAVE_FINISHED_MODERATING' => 'Vous avez fini de modérer',
        'NO_ONE_HAS_ADDED_ANY_VIDEOS' => 'Personne n\'a ajouté de vidéos à votre réseau social. Soyez le/la premier(ère) à le faire!',
        'ADDED_ON_DATE_BY_X' => 'Ajout le %s par %s.',
        'REMOVE_FROM_FAVORITES' => 'Enlever de mes Favoris',
        'COLLECTED_BY_X' => 'Collection de %s',
        'ADD_FAVORITES' => 'Ajouter à mes Favoris',
        'X_HAS_NOT_ADDED_FAVORITES' => '%s n\'a pas encore de favoris.',
        'YOUR_SITE_ALLOWS_USERS' => 'Vous avez décidé de ne pas modérer les photos et vidéos sur votre réseau social. Pour modifier cette option, allez à la section <a %s>Confidentialité et membres</a> de la page de gestion et cocher « Oui » dans la section « Modération des photos et vidéos ».',
        'APPROVE_ALL_VIDEOS' => 'Autoriser toutes les Vidéos?',
        'APPROVING' => 'Autorisation…',
        'APPROVE_ALL' => 'Tout Autoriser',
        'DELETE_ALL_VIDEOS' => 'Supprimer toutes les Vidéos?',
        'DELETING' => 'Suppression...',
        'DELETE_ALL' => 'Tout Supprimer',
        'FILES_MUST_BE_100MB' => 'Les fichiers doivent avoir une dimension de 100 Mo ou moins. Nous supportons les fichiers de formats .mov, .mpg, .mp4, .avi, .3gp et .wmv.',
        'NEED_HELP' => 'Besoin d\'aide?',
        'HERE_ARE_INSTRUCTIONS' => 'Voici les instructions pour <a %s>YouTube</a> et <a %s>Google Video</a>.',
        'PERSON_IN_CHARGE' => 'La personne en charge du réseau %s veut vérifier votre contenu avant de le rendre visible au reste du monde.',
        'LEAVE_WINDOW_OPEN' => 'Veuillez garder cette fenêtre ouverte pendant le téléchargement.',
        'LOADING' => 'Chargement...',
        'YOU_NEED_TO_BE_MEMBER' => 'Vous devez être membre du réseau « %s » avant de pouvoir ajouter des commentaires!',
        'SIGN_UP_OR_SIGN_IN' => '<a %s>Joindre ce réseau</a>',
        'ADD_A_COMMENT' => 'Ajouter un commentaire',
        'LEAVE_A_COMMENT_FOR_USERNAME' => 'Laissez un commentaire pour %s',
        'MORE' => 'Autres',
        'PREVIOUS' => 'Précédente',
        'NEXT' => 'Suivante',
        'ABOUT_YOUR_VIDEO' => 'À propos de cette vidéo',
        'ADDED_ON_DATE_BY' => 'Ajouté(e)(s) <strong>%s</strong> par:',
        'VIEWS' => 'Vue(s):',
        'COMMENTS' => 'Commentaires',
        'COMMENTS_COLON' => 'Commentaires:',
        'XS_FAVORITES_X' => 'Les Favoris de %s (%s)',
        'NEITHER_FILE_NOR_EMBED_CODE' => 'Aucun fichier ou code d\'incrustation n\'a pas été spécifié.',
        'PROBLEM_OCCURRED_CONVERTING_VIDEO' => 'Un problème s\'est produit pendant la conversion de la vidéo en format Flash: %s',
        'STATUS_N' => 'Statut %s',
        'YOUR_VIDEO_COULD_NOT_BE_ADDED' => 'Votre vidéo n\'a pu être ajoutée au réseau « %s »',
        'YOUR_VIDEO_UPLOAD_TO_X_DID_NOT_COMPLETE_DUE_TO_A_CONVERSION_ERROR' => 'Le téléchargement de la vidéo n\'a pu être complété sur le réseau %s à cause d’une erreur de conversion.',
        'YOU_JUST_TRIED_TO_SEND_VIDEO' => 'Vous venez d\'essayer d\'envoyer une au %s. Malheureusement, vous n’êtes pas un membre de %s et nous ne pouvons pas livrer cette vidéo.',
        'VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'Le téléchargement de la vidéo n\'a pu être complété sur le réseau « %s »',
        'FOR_FURTHER_ASSISTANCE_2' => 'Pour plus d\'assistance, veuillez nous rejoindre au:',
        'TO_HELP_TROUBLESHOOT_PROVIDE_THIS_VIDEO_ID_X' => 'Pour aider au dépannage, fournir cet idenfiant de video : %s',
        'YOUR_VIDEO_WAS_SUCCESSFULLY_UPLOADED_TO_X' => 'Votre vidéo a été téléchargée avec succès sur le réseau %s.',
        'VIDEO_TRANSCODING_FAILED_FOR_X' => 'La conversion de la vidéo « %s » a échouée sur le réseau « %s »',
        'X_UPLOADED_A_VIDEO_THAT_FAILED' => '%s a téléchargé une vidéo qui a échouée pendant la conversion.',
        'ERROR_MESSAGE' => 'Message d\'Erreur:',
        'APPLICATION_NAME' => 'Nom du réseau:',
        'APPLICATION_ID' => 'ID du réseau:',
        'VIDEO_UPLOAD_COMPLETE_ON_X' => 'Téléchargement vidéo complété sur le réseau « %s »',
        'TO_VIEW_THE_VIDEO_VISIT' => 'Pour voir la video, aller à :',
        'THAT_VIDEO_IS_AWAITING_APPROVAL' => 'Cette vidéo est en attente d\'autorisation.',
        'THIS_VIDEO_IS_BEING_PROCESSED' => 'Cette vidéo est en cours de conversion.',
        'VIDEO_BY_X' => 'Vidéo par %s',
        'YOUR_VIDEO_X_ON_Y_HAS_A_NEW_COMMENT' => 'Il y a un nouveau commentaire pour votre vidéo "%s" sur le réseau "%s".',
        'YOUR_VIDEO_ON_X_HAS_A_NEW_COMMENT' => 'Il y a un nouveau commentaire pour votre vidéo sur le réseau %s.',
        'SOMEBODY_COMMENTED_VIDEO_ADDED_TO_X' => 'quelqu\'un a écrit un commentaire pour une vidéo que vous avez ajoutée au réseau « %s »',
        'SOMEBODY_UPLOADED_VIDEO_TO_X' => 'quelqu\'un a téléchargé une vidéo sur le réseau « %s »',
        'FROM_YOUTUBE_OR_GOOGLE' => '…à partir de YouTube ou Google',
        'GRAB_THE_HTML_EMBED_CODE' => 'Copiez/Collez un « code d\'incrustation HTML » de n\'importe quel site de vidéos et ajoutez cette vidéo à ce réseau social.',
        'ADD_A_VIDEO_FROM_YOUTUBE' => 'Ajouter une vidéo provenant de YouTube ou Google.',
        'PASTE_IN_EMBED' => 'Copiez/Collez le « code d\'incrustation » pour la vidéo ici:',
        'ADD_VIDEOS_BY_PHONE_OR_EMAIL' => 'Ajouter une vidéo par téléphone ou courriel',
        'VIDEO' => 'vidéo',
        'THERE_ARE_NO_VIDEOS_THAT_MATCH' => 'Il n\'y a pas de vidéos correspondant au paramètres que vous avez sélectionnés.',
        'CLICK_EDIT_AND_CHANGE_SETTINGS' => 'Cliquez sur \'Modifier\' et changez les paramètres si vous voulez que les gens puissent voir cette boîte.',
        'PLAY_AGAIN' => 'Jouer à nouveau',
        'SHARE' => 'Partager',
        'EMBED' => 'Incruster',
        'REWIND' => 'Rembobiner',
        'CHANGE_SIZE' => 'Changer Dimensions',
        'FULLSCREEN' => 'Plein Écran',
        'EXIT_FULLSCREEN' => 'Quitter Plein Écran',
        'HIDE' => 'Fermer',
        'COPY_AND_PASTE_LINK' => 'Copiez et collez ce lien dans un courriel ou un message instantané :',
        'FIND_MORE_VIDEOS_LIKE_THIS' => 'Trouvez plus de vidéos comme celle-ci sur <em>%s</em>',
        'SEE_VIDEO_ON_NETWORK' => 'Voir cette vidéo sur %s',
        'GET_EMBED_CODE' => 'Obtenir le code d\'incrustation',
        'MORE_PHOTOS' => 'Plus de Photos',
        'THIS_ALBUM' => 'Cet Album',
        'NETWORK_DOES_NOT_HAVE_PHOTOS' => 'Ce réseau n’a pas encore de photos.',
        'PERSON_DOES_NOT_HAVE_PHOTOS' => 'Cette personne n’a pas encore de photos.',
        'ALBUM_DOES_NOT_HAVE_PHOTOS' => 'Cet album n’a pas encore de photos.',
        'FIND_MORE_PHOTOS_LIKE_THIS' => 'Trouvez plus de photos comme celle-ci sur <em>%s</em>',
        'ALBUM_PHOTOS_NOT_VISIBLE_TO_OTHERS' => 'Cet album n\'est pas visible aux autres personnes du réseau car les photos dont il contient sont seulement visibles à vous ou bien n\'ont pas encore été autorisées.',
        'CUSTOMIZE_YOUR_SLIDESHOW_PLAYER' => 'Personnaliser votre diaporama!',
        'ADD_SLIDESHOW_LOGO' => 'Ajoutez un logo à votre diaporama. <a %s>Faites-le maintenant!</a>',
        'PHOTO_BY_X' => 'Photo par %s',
        'UPLOAD_PHOTOS' => 'Télécharger les photos',
        'PLAYER_COLOR' => 'Couleur du Diaporama',
        'SLIDESHOW_PLAYER' => 'diaporama',
        'SLIDESHOW' => 'diaporama',
        'FILTER' => 'Filtrer',
        'SAVE_ALBUM' => 'Sauvegarder l\'Album',
        'APPLY_THIS_INFO_TO_PHOTOS' => 'Utiliser cette information pour toutes les photos',
        'CLICK_TO_ADD_A_DESCRIPTION' => 'Cliquer ici pour ajouter une description',
        'CHECK' => 'Vérifier',
        'YOU_NEED_TO_BE_X' => 'Vous devez être %s afin de pouvoir faire cela.',
        'ALL_PHOTOS' => 'Toutes Photos',
        'POPULAR_PHOTOS' => 'Photos Populaires',
        'FEATURED_PHOTOS' => 'Photos En Primeur',
        'PHOTOS_HOME' => 'Page d\'Accueil Photo',
        'ALL_ALBUMS' => 'Tous les Albums',
        'MY_PHOTOS' => 'Mes Photos',
        'MY_ALBUMS' => 'Mes Albums',
        'ADD_PHOTOS' => 'Ajouter des photos',
        'ADD_PHOTOS_SENTENCE_CASE' => 'Ajouter des photos',
        'EDIT' => 'Modifier',
        'CHOOSE_PHOTOS' => 'Choisir les photos',
        'ADD_PHOTOS_BY_DRAGGING' => '<strong>Trainez les photos à ajouter</strong> sur l\'album à droite.',
        'TITLE_YOUR_ALBUM' => '<strong>Ajoutez un titre à votre album</strong> ainsi qu\'une couverture et une description.',
        'SAVE_YOUR_ALBUM' => 'Sauvegardez votre album!',
        'CHOOSE_FROM' => 'Choisir parmi:',
        'EVERYONES_PHOTOS' => 'Toutes',
        'OLDER_PHOTOS' => 'Photos moins récentes',
        'MORE_RECENT_PHOTOS' => 'Plus de Photos récentes',
        'YOUR_ALBUM' => 'Votre Album',
        'DRAG_ALBUM_COVER_HERE' => 'Traînez la couverture d\'album ici',
        'ALBUM_TITLE' => 'Titre de l\'Album:',
        'ALBUM' => 'album',
        'DRAG_PHOTOS_HERE' => 'Traînez Vos Photos Ici',
        'PREVIOUS_ALBUM_PAGE' => 'Page Précédente',
        'NEXT_ALBUM_PAGE' => 'Page Suivante',
        'ADDED_ON_DATE' => 'Ajout %s',
        'VIEW_AS_SLIDESHOW' => 'Voir en diaporama',
        'CREATED_BY_ME' => 'Créé(e)(s) par <a %s>Moi</a>',
        'CREATED_BY_X' => 'Créé(e)(s) par %s',
        'OUR_APOLOGIES' => 'Toutes nos excuses',
        'ADD_PHOTOS_TO_ALBUM' => 'Ajouter d\'autres photos à cet album en choisissant une des options ci-dessous.',
        'YOU_CAN_ADD_PHOTOS' => 'Vous pouvez <a %s>ajouter des photos à cet album dès l\'instant</a>.',
        'SITE_IS_GETTING_STARTED' => 'Ce Réseau Social ne fait que débuter!',
        'NO_ONE_CREATED_ALBUMS' => 'Personne n\'a créé d\'Albums! <a %s>Créez-en un dès maintenant</a>.',
        'EDIT_YOUR_ALBUM' => 'Modifier Votre album',
        'ALBUMS_WITH_THIS_PHOTO' => 'Tous les Albums contenant cette Photo',
        'ALBUMS_WITH_X' => 'Tous les Albums Avec \'%s\'',
        'ALBUMS_WITH_X_2' => 'Tous les Albums Avec <em>\'%s\'</em>',
        'NO_ALBUMS_CONTAINING_PHOTO' => 'Il n\'y a aucun album contenant cette photo. Vous pouvez <a %s>créer un nouvel album</a>.',
        'XS_ALBUMS' => 'Albums de %s',
        'CREATE_AN_ALBUM' => 'Créer un Album',
        'YOU_HAVE_NOT_CREATED_ALBUMS' => 'Vous n\'avez pas encore créé d\'albums photos. Vous pouvez en <a %s>créer un maintenant</a>.',
        'X_HAS_NOT_CREATED_ALBUMS' => '%s n\'a pas encore créé d\'albums.',
        'MAKE_AN_ALBUM' => 'Créer un Album',
        'ABOUT_THIS_ALBUM' => 'À propos de cet album',
        'ABOUT_YOUR_ALBUM' => 'À propos de votre album',
        'EDIT_ALBUM' => 'Modifier Album',
        'DELETE_THIS_ALBUM' => 'Supprimer cet album?',
        'DELETE_ALBUM' => 'Supprimer l\'Album',
        'START_SLIDESHOW' => 'Démarrer le Diaporama',
        'ALBUM_IS_NOW_EMPTY' => 'Cet album est maintenant vide.',
        'YOU_HAVE_NOT_ADDED_PHOTOS' => 'Vous n\'avez pas encore ajouté de Photos!',
        'ADD_PHOTOS_AND_SHARE' => 'Ajoutez des photos et partagez les avec vos amis, votre famille ou le monde entier!',
        'ADD_A_PHOTO' => 'Ajouter une photo',
        'VIEW_EMBED_CODE' => 'Voir code d\'incrustation',
        'VIEW_SLIDESHOW' => 'Voir Diaporama',
        'VIEW_PHOTOS' => 'Voir Photos',
        'ADD_YOUR_FIRST_PHOTOS' => 'Ajoutez vos premières Photos',
        'YOU_CAN_ADD_YOUR_OWN_PHOTOS' => 'Vous pouvez <a %s>ajouter vos propres photos</a> au réseau « %s »!',
        'UPLOAD_PHOTOS_FROM' => 'Télécharger les photos à partir de votre ordinateur:',
        'ADD_TITLE_AND_DESCRIPTION_FOR_PHOTOS' => 'Ajoutez un titre et une description à vos photos',
        'EDIT_PHOTO_INFORMATION' => 'Modifier Information sur la photo',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_1' => 'Ajoutez un un titre, une description et d\'autres informations aux photos que vous venez de télécharger.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_2' => 'Ajouter un titre, une description, autres informations à propos de cette photo.',
        'CANCEL_AND_RETURN_TO_PHOTO' => 'Annuler et retourner à la photo',
        'WHO_CAN_VIEW_PHOTO' => 'Qui peut voir cette photo?',
        'CAN_BE_VIEWED_BY' => 'Peut être vue par:',
        'BY_ME' => 'par <a %s>Moi</a>',
        'RSS_FEED_LABEL' => '<a %s>Fil de Syndication</a> – %s',
        'APPROVE_ALL_PHOTOS' => 'Autoriser toutes les photos?',
        'DELETE_ALL_PHOTOS' => 'Supprimer toutes les photos?',
        'APPLY_TO_PHOTOS_ADDED_BY' => 'Appliquer à toutes les photos ajoutées par %s',
        'NO_ONE_HAS_ADDED_ANY_PHOTOS' => 'Personne n\'a ajouté de photos à votre réseau social. Soyez le/la premier(ère) à <a %s>en ajouter</a>.',
        'UNTITLED' => 'Sans Titre',
        'A_PROBLEM_OCCURRED' => 'Un problème s\'est produit',
        'PHOTOS_EXCEEDED_LIMIT' => 'Une des photos a excédée la limite de 10 Mo par photo.',
        'GET_A_SLIDESHOW_OF' => 'Obtenez un diaporama pour « %s »',
        'GET_A_SLIDESHOW' => 'Obtenez un Diaporama!',
        'GET_SLIDESHOW_OF_PHOTOS' => 'Obtenez un diaporama de ces photos',
        'COPY_AND_PASTE_SLIDESHOW' => 'Copiez et collez le code ci-dessous pour placer un diaporama sur votre site web, votre page MySpace ou d\'autres réseaux sur Ning.',
        'COPY_AND_PASTE_SLIDESHOW_OF_ALBUM' => 'Copiez et collez le code ci-dessous pour placer un diaporama de cet album sur votre site web, votre page MySpace ou d\'autres réseaux sur Ning.',
        'LARGE_VERSION' => 'Grand',
        'SMALL_VERSION' => 'Petit',
        'VIEW_SLIDESHOW_FULL_SIZE' => 'Voir ce diaporama en plein écran',
        'PHOTOS' => 'Photos',
        'XS_PHOTOS' => 'Photos de(d\') %s',
        'XS_PHOTO' => 'Photo de(d\') %s',
        'YOU_CAN_MARK_PHOTO' => 'Vouz pouvez ajouter toute photo à vos favoris. Cliquer simplement sur l\'îcone « Ajouter aux Favoris » lorsqu\'elle apparaît au-dessus d\'une photo.',
        'VIEW_RECENT_PHOTOS' => 'Voir Photos Récentes',
        'APPROVE_PHOTOS' => 'Autorisation de Photos',
        'DELETE_ALL_XS_PHOTOS_Q' => 'Supprimer toutes les photos de %s?',
        'REMOVE_X_AND_ALL_CONTENT' => 'Supprimer %1$s et tout son contenu de votre réseau social',
        'SUCCESS' => 'Succès.',
        'DELETING_CONTENT' => 'Suppression du Contenu...',
        'KEEP_WINDOW_OPEN_MEMBERS_DELETED' => 'Veuillez garder cette fenêtre de navigateur ouverte pendant la suppression des membres. Ce processus peut prendre quelques minutes.',
        'DELETE_ALL_XS_PHOTOS' => 'Supprimer toutes les photos de %s',
        'CREATE_A_NEW_ALBUM' => 'Créer un Nouvel Album',
        'VIEW_ALL_XS_ALBUMS' => 'Voir tous les Albums de %s',
        'YOU_HAVE_NOT_ADDED_PHOTOS_2' => 'Vous n\'avez pas encore ajouté de Photos. Ajoutez-en dès maintenant!',
        'X_HAS_NOT_ADDED_PHOTOS' => '%s n\'a pas encore ajouté de Photos.',
        'MY_FRIENDS_PHOTOS' => 'Photos de mes amis',
        'VIEW_PHOTOS_IN_SLIDESHOW' => 'Voir ces photos en diaporama!',
        'YOUR_FRIENDS_DO_NOT_HAVE_PHOTOS' => 'Vos amis n\'ont pas encore ajouté de Photos.',
        'SELECT_YOUR_PHOTOS' => 'Sélectionnez Vos Photos',
        'PHOTO_MAY_BE_10MB' => 'Les photos ont une limite de 10 Mo chaque mais plus elles sont petites, plus elles sont téléchargées plus rapidement!',
        'KEEP_PAGE_OPEN_PHOTOS' => 'Veuillez garder cette fenêtre ouverte pendant le téléchargement de vos Photos. Lorsque vos Photos seront autorisées par l\'administrateur, nous allons vous le faire savoir!',
        'MEANWHILE_FEEL_FREE_PHOTOS' => 'En attendant, sentez-vous libre <a %s>d\'ouvrir une autre fenêtre</a> et de continuer à naviguer le réseau « %s ». Lorsque le téléchargement sera terminé, vous allez avoir l\'occasion d\'ajouter un titre et une description à vos photos.',
        'PHOTO_IS_WAITING_FOR_APPROVAL' => 'Cette Photo est <strong>en attente d\'autorisation</strong> pas l\'administrateur du réseau « %s ».',
        'ADD_TO_FAVORITES' => 'Ajouter aux Favoris',
        'EDIT_PHOTO' => 'Modifier la photo',
        'DELETE_PHOTO' => 'Supprimer la Photo',
        'ABOUT_THIS_PHOTO' => 'À propos de cette photo',
        'LOCATION_OF_PHOTO' => 'Emplacement de cette Photo:',
        'ALBUMS_FEATURING_PHOTO' => 'Albums Featuring This Photo',
        'VIEW_ALBUMS_WITH_PHOTO' => 'View All Albums with This Photo',
        'RETURN_TO_X' => 'Retour vers "%s"',
        'RETURN_TO_PHOTOS_HOME' => 'Retour à l’Accueil des Photos',
        'WE_COULD_NOT_FIND_ANYONE' => 'Désolé - nous n\'avons trouvé personne',
        'NOBODY_HAS_ADDED_PHOTOS' => 'Personne n\'a ajouté de Photos! Ajoutez-en dès maintenant.',
        'DEFAULT_TITLE' => 'Titre',
        'DEFAULT_DESCRIPTION' => 'Description',
        'UPLOAD_LIMIT_EXCEEDED' => 'Le fichier téléchargé excède la limite de taille permise.',
        'SLOW_DOWN_THERE_CHIEF' => 'Un moment svp!',
        'I_DO_NOT_KNOW_USER' => 'Désolé, je ne reconnais pas cette personne.',
        'I_DO_NOT_HAVE_PHOTO' => 'Désolé, je ne reconnais pas cette photo.',
        'I_DO_NOT_HAVE_ALBUM' => 'Désolé, je ne reconnais pas cet album.',
        'ALBUM_BY_X_ON_X' => 'Album de %s le %s',
        'SENT' => 'Envoyé(e)(s)!',
        'I_HAVE_RECENTLY_ADDED' => 'Que j\'ai ajouté(e)(s) dernièrement',
        'FROM_THE_BAZEL' => 'De ce réseau',
        'RECENTLY_ADDED' => 'Ajouté(e)(s) récemment',
        'RECENT_PUBLIC_PHOTOS_ON_X' => 'Récentes photos publiques sur %s',
        'X_ALL_PHOTOS' => '%s - Toutes les photos',
        'NO_TAG_WAS_SPECIFIED' => 'Aucune tag n\'a été spécifié',
        'XS_PUBLIC_PHOTOS_ON_X' => 'Photos publiques de %s sur %s',
        'WE_DO_NOT_KNOW_USER' => 'Nous ne reconnaissons pas cette personne.',
        'XS_FRIENDS_PHOTOS' => 'Photos des amis de %s',
        'XS_FAVORITE_PHOTOS_ON_X' => 'Les photos favorites de %s sur %s',
        'PHOTO_UPLOADED_ON_X' => 'Photo téléchargée sur %s',
        'FILE_EXCEEDED_MAXIMUM_SIZE' => 'La taille du fichier excède la limite permise',
        'PART_OF_FILE_WAS_UPLOADED' => 'Seule une partie du fichier a été téléchargée',
        'NO_FILE_WAS_UPLOADED' => 'Le téléchargement a échoué, le nom du fichier est peut-être incorrect',
        'PROBLEM_OCCURRED_DURING_UPLOAD' => 'Un problème a été détecté pendant le téléchargement.',
        'ALPHABETICAL' => 'Ordre Alphabétique',
        'MOST_VIEWS' => 'Avec le plus de Vues',
        'RATING_NOT_RATED_YET' => '<strong>Cote:</strong> Aucune Cote',
        'NOT_RATED_YET' => 'Aucune Cote',
        'HMM_SOMETHING_WENT_AWRY' => 'Hum...une erreur s\'est produite',
        'YOUR_PHOTO_TITLED_X_COULD_NOT' => 'Votre photo intitulée « %s » n\'a pus être ajoutée au réseau « %s »',
        'YOUR_PHOTO_COULD_NOT_BE_ADDED' => 'Votre photo n\'a pus être ajoutée au réseau « %s »',
        'YOU_JUST_TRIED_TO_SEND' => 'Vous venez juste d\'essayer d\'envoyer une photo au %s. Malheureusement, vous n\'êtes pas un membre du %s et nous ne pouvons donc pas livrer cette photo.',
        'ONLY_MY_FRIENDS' => 'Juste mes amis',
        'ANYBODY' => 'Tout le monde',
        'ONLY_MY_FRIENDS_CAN_SEE_PHOTO' => 'Seuls mes amis peuvent voir cette photo',
        'ONLY_XS_FRIENDS_CAN_SEE_PHOTO' => 'Seuls les amis de %s peuvent voir cette photo',
        'ONLY_I_CAN_SEE_PHOTO' => 'Seul moi peut voir cette photo',
        'ONLY_X_CAN_SEE_PHOTO' => 'Seul(e) %s peut voir cette photo',
        'EVERYONE_CAN_SEE_PHOTO' => 'Tout le monde peut voir cette photo',
        'PRIVATE_PHOTO' => 'Photo <strong>Privée</strong>',
        'HOWDY_STRANGER' => 'Bonjour, Étranger(ère)!',
        'YOU_NEED_TO_BE_SIGNED_IN' => 'Vouz devez vous connecter à Ning avant de pouvoir faire cela.',
        'JUST_CLICK_ON_SIGN_IN' => 'Veuillez cliquer sur « Connexion » ci-dessus pour vous connecter ou bien sur  « Inscription » si vouz n\'avez pas encore un compte sur Ning.',
        'YOU_NEED_TO_BE_' => 'Vous devez être %s afin de pouvoir faire cela.',
        'YOU_NEED_TO_BE_OWNER' => 'Vous devez être le créateur du réseau afin de faire cela.',
        'THAT_PHOTO_IS_AWAITING_APPROVAL' => 'Cette photo est en attente d\'autorisation.',
        'YOU_NEED_TO_BE_A_FRIEND' => 'Vous devez être un(e) ami(e) de %s afin de faire cela.',
        'MOST_ACTIVE' => 'Plus Actifs',
        'HOW_IT_WORKS' => 'Fonctionnement',
        'MORE_WAYS_TO_ADD_PHOTOS' => 'D\'autres moyens d\'ajouter des photos…',
        'BY_PHONE_OR_EMAIL' => '…par téléphone ou courriel',
        'FROM_FLICKR' => '...à partir de Flickr',
        'FROM_YOUR_COMPUTER' => '…de votre ordinateur',
        'ADD_PHOTOS_FROM_YOUR_FLICKR' => 'Ajouter des photos de votre compte Flickr.',
        'MORE_INFORMATION' => 'Plus d\'information',
        'ADD_PHOTOS_BY_PHONE_OR_EMAIL' => 'Ajouter des photos par téléphone ou par courriel',
        'SEND_ONE_PHOTO_OR_VIDEO' => 'Envoyez une photo ou une vidéo par courriel. Le sujet du courriel devient le titre et le message devient la description.',
        'CLICK_HERE_TO_GET_A_NEW_UNIQUE' => 'Cliquez ici pour obtenir une nouvelle adresse électronique',
        'UPLOAD_PHOTOS_FROM_YOUR' => 'Télécharger une photo à partir de votre ordinateur.',
        'PHOTO' => 'photo',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_PHOTO' => 'Cette boîte ne va pas être affichée s\'il n\'y a pas au moins une photo de sélectionnée.',
        'YOUR_PHOTO_X_HAS_A_NEW_COMMENT_ON_Y' => 'Il y a un nouveau commentaire pour votre photo "%1$s" sur le réseau %2$s.',
        'YOUR_PHOTO_HAS_A_NEW_COMMENT_ON_X' => 'Il y a un nouveau commentaire pour votre photo sur le réseau %s.',
        'SOMEBODY_COMMENTED_PHOTO_ADDED_TO_X' => 'quelqu\'un a écrit un commentaire pour une photo que vous avez ajoutée au réseau « %s »',
        'SOMEBODY_UPLOADED_PHOTO_TO_X' => 'quelqu\'un a téléchargé une photo sur le réseau « %s »',
        'DO_YOU_REALLY_WANT_TO_REMOVE' => 'Êtes-vous sûr de vouloir enlever cet objet de vos favoris?',
        'DELETE_THIS_PHOTO_Q' => 'Supprimer Cette Photo?',
        'PHOTO_SLIDESHOW' => 'Diaporama',
        'THUMBNAILS' => 'Imagettes',
        'DETAIL' => 'Détail',
        'TAG' => 'Tagger',
        'RATE' => 'Coter',
        'ALL_SIZES' => 'Autres Dimensions',
        'ADD_TO_ALBUM' => 'Ajouter à un Album',
        'ROTATE_PHOTO' => 'Rotation de la Photo',
        'ABOUT_YOUR_PHOTO' => 'À propos de votre photo',
        'SEE_PHOTOS_ON_NETWORK' => 'Voir ces photos sur %s',
        'EMBED_CODE' => 'Code d\'incrustation',
        'IMPORT_PHOTOS_FLICKR' => 'Importer les photos de votre compte Flickr',
        'CLICK_HERE_TO_CONTINUE_TO_FLICKR' => 'Cliquer ici pour aller sur Flickr',
        'TO_GET_YOUR_PHOTOS_FROM_FLICKR' => 'Pour importer vos photos de chez Flickr, vous devez tout d\'abord autoriser le réseau « %S » à accéder à votre compte Flickr.',
        'IMPORT_PHOTOS' => 'Importer Photos',
        'GET_MY' => 'Importer mes',
        'GET_PHOTOS' => 'Importer Photos',
        'MOST_RECENT_PHOTOS' => 'les plus récentes photos',
        'GET_ALL_MY_FLICKR' => 'Importer toutes mes photos de chez Flickr (peut prendre quelque temps)',
        'GET_PHOTOS_FROM_SET' => 'Importer mes photos de la série:',
        'IF_YOURE_NOT_SIGNED_IN' => 'Si vous n\'êtes pas connecté à Flickr, vous allez être appelé à le faire. Après connexion, cliquez sur le bouton intitulé « D\'accord, je vais le permettre ».',
        'PLEASE_KEEP_THIS_PAGE_OPEN_WHILE_IMPORT' => 'Veuillez garder cette fenêtre ouverte pour que nous puissions finir d\'importer vos photos.',
        'BOX_WILL_NOT_SHOW_UNTIL_UPDATE_CONTENT' => 'Cette boîte ne va pas être affichée aux autres personnes du réseau si vous n\'y ajoutez pas de contenu.',
        'YOUR_X_BOX' => 'Votre boîte sur "%s"',
        'ABOUT_WIDGETS' => 'À propos deswidgets',
        'HELP' => '?',
        'WIDGETS' => 'Widgets',
        'LOOKING_TO_ADD_FUNCTIONALITY' => 'Vous voulez ajouter d\'autres fonctionnalités à votre réseau social? Peut-être un calendrier, des prévisions météo, un compte à rebours, ou une webcam? Avec des widgets, vous pouvez ajouter ces fonctionnalités à n\'importe quelle boîte textuelle de votre réseau.',
        'GETTING_STARTED' => 'Mise en route',
        'BELOW_IS_LIST_OF_WIDGET' => 'Vous trouverez au bas de la page une <a %s>liste de fournisseurs de widgets</a> que vous pouvez visiter. Nous avons sélectionné quelques widgets du fournisseur <a %s>yourminis.com</a> à titre d\'exemple. Pour ajouter un widget à une boîte textuelle, veuillez tout simplement copier et coller le code d\'incrustation directement dans la boîte. Allez-y, essayez!',
        'CALENDAR' => 'Calendrier',
        'CALENDAR_WIDGET_ALLOWS_SEARCH' => 'Le widget Calendrier (Calendar) affiche la date et vous permet de rechercher et d\'ajouter des événements de format iCal (utilisé par Google Calendar et d\'autres calendriers en ligne).',
        'CUSTOMIZATION' => 'Personnalisation',
        'YOU_CAN_CUSTOMIZE_WIDGET' => 'Vous pouvez personnaliser l\'apparence du widget en traînant le curseur sur le widget et ensuite en cliquant sur l\'îcone du sélecteur de couleurs pour changer la couleur de fond, le style du widget, ainsi que le niveau de transparence. Lorsque vous avez terminé, cliquez sur le bouton « copier sur web » et ensuite sur le bouton « copier code d\'incrustation ». Après avoir copié le code, retournez vers n\'importe quelle boîte textuelle sur votre réseau, collez le code à l\'intérieur de la boîte et finalement cliquez sur « Sauvegarder ». C\'est tout!',
        'GET_MORE_WIDGETS_FROM_YOURMINIS' => 'Obtenez plus de widgets à yourminis.com Â»',
        'WEATHER' => 'Météo',
        'WEATHER_WIDGET_DISPLAYS' => 'Le widget Météo (Weather) affiche les prédictions météo du Weather Channel.',
        'USE_EDIT_WIDGET_BUTTON_WEATHER' => 'Cliquez sur le bouton « Modifier widget » et ensuite sur « Modifier paramètres ». Entrez une ville ou une région (location) et cliquez sur « Allez! ». Sélectionnez un des résultats de recherche, choisissez Fahrenheit ou Celsius et cliquez sur « Enregistrer ». Vous pouvez aussi choisir d\'afficher la météo pour aujourd\'hui ou la prédiction météo pour les cinq prochains jours.',
        'COUNTDOWN' => 'Compte à Rebours',
        'COUNTDOWN_WIDGET_LETS_YOU' => 'Le widget Compte à rebours vous permet de diffuser un compte à rebours pour un événement spécifique. En cliquant sur le bouton « Modifier widget » et ensuite sur « Modifier », vous pouvez entrer une date, une heure, ainsi qu\'un titre ou une image pour votre événement.',
        'WEBCAM' => 'Webcam',
        'MORE_WIDGETS' => 'D\'autres widgets',
        'NEED_MORE_OPTIONS' => 'Besoin de plus d\'options? Nous vous recommandons les sites web ci-dessous pour apaiser votre soif de widgets:',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y_ELLIPSIS' => 'Vous devez approuver un nouveau %1$s sur %2$s…',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y' => 'Vous devez approuver un nouveau %1$s sur %2$s.',
        'YOU_HAVE_A_NEW_X_TITLE_TO_APPROVE_ON_Y' => 'Vous devez approuver un nouveau %1$s de "%2$s"  sur %3$s.',
        'TO_APPROVE_THIS_X_VISIT' => 'Pour approuver ce %s, aller à :',
        'YOUR_X_ON_Y_HAS_BEEN_APPROVED_ELLIPSIS' => 'Votre %1$s sur %2$s a été approuvé…',
        'JOIN' => 'Se Joindre',
        'WELCOME' => 'Bienvenue',
        'WELCOME_TO_X' => 'Bienvenue sur %s',
        'WELCOME_TO_X_ELLIPSIS' => 'Bienvenue à %s...',
        'RSS_LINK' => '<a %s>RSS</a>',
        'NEW_FEATURES_GROUPS_MUSIC' => '<h3 style="margin-top:0">Nouvelles fonctionnalités!</h3>
            <ul><li><strong>Groupes</strong> &ndash; Laissent vos members créer des groupes dans votre réseau</li>
                <li><strong>Lecteur de musique</strong> &ndash; Ajouter la musique et les balado à votre réseau</li></ul>
            <p><a href="%s" class="desc add">Cliquer ici pour ajouter des fonctionnalités</a></p>',
        'NEW_FEATURES_ACTIVITY_BADGES' => '<h3 style="margin-top:0">Nouvelles fonctionnalités!</h3>
            <ul><li><strong>Activité la pus récente</strong> &ndash; Suivre l\'Activité récente de membres dans votre réseau</li>
                <li><strong>Insignes et widgets</strong> &ndash; Faites la promotion de votre réseau à travers le web à l’aide d\'insignes et de widgets personnalisés</li></ul>
            <p><a href="%s" class="desc add">Cliquez ici pour ajouter/modifier les fonctionnalités</a></p>',
        'YOUR_TYPE_ON_X_HAS_A_NEW_COMMENT_ELLIPSIS' => 'Il y a un nouveau commentaire pour votre %1$s sur %2$s.…',
        'CLICK_HERE_TO_JOIN' => 'Cliquer ici pour prendre part :',
        'THANKS_VALEDICTION' => 'Merci,',
        'THANKS' => 'Merci!',
        'YOU_CHANGED_YOUR_EMAIL_ON_X' => 'Vous avez modifié votre adresse électronique au %s.',
        'YOU_CHANGED_YOUR_EMAIL_ON_X_ELLIPSIS' => 'Vous avez modifié votre adresse électronique au %s…',
        'CLICK_HERE_TO_SIGN_IN_WITH_YOUR_NEW_EMAIL_ADDRESS' => 'Cliquer ici pour ouvrir une session avec votre nouvelle adresse électronique :',
        'IF_DID_NOT_CHANGE_EMAIL_ADDRESS' => 'Si vous n’avez pas modifié votre adresse électronique, cliquer ici :',
        'TO_STOP_BEING_NOTIFIED_OF_NEW_DISCUSSIONS_GO_TO' => 'Pour cesser de recevoir les avis de nouvelles discussions, aller à :',
        'X_STARTED_DISCUSSION_ON_APPNAME_ELLIPSIS' => '%1$s a démarré une nouvelle discussion au %2$s…',
        'X_STARTED_THE_DISCUSSION_Y' => '%1$s a démarré la discussion "%2$s".',
        'TO_VIEW_THIS_DISCUSSION_GO_TO' => 'Pour visualiser la discussion, aller à :',
        'X_HAS_INVITED_YOU_TO_JOIN_Y' => '%s vous a invité à joindre le réseau "%s"!',
        'X_WANTS_YOU_TO_CHECK_OUT_Y_ON_Z' => '%1$s vous invite à voir "%2$s" sur %3$s!',
        'CHECK_OUT_TITLE_ON_APPNAME' => 'Sortir "%s" sur %s!',
        'ABOUT_X' => 'Au sujet du réseau: %s',
        'YOU_HAVE_RECEIVED_BECAUSE_X' => 'Vous avez reçu ce courriel parce que %s',
        'IF_YOU_NO_LONGER_WISH_FROM_X_CLICK_Y' => 'Si vous désirez ne plus recevoir de courriels du réseau « %s », <a %s>veuillez cliquer ici</a>.',
        'CLICK_HERE' => 'Cliquez Ici',
        'MESSAGE_TO_ALL_MEMBERS_OF_X' => 'Un message à tous les membres du réseau « %s »',
        'YOUR_X_HAS_BEEN_APPROVED_ON_Y' => 'Votre %s a été autorisé sur le réseau %s.',
        'YOUR_X_Y_HAS_BEEN_APPROVED_ON_Z' => 'Votre %1$s de "%2$s" a été autorisé sur %3$s.',
        'TO_VIEW_YOUR_X_VISIT' => 'Pour voir votre %s, aller à :',
        'TO_VIEW_THIS_X_VISIT' => 'Pour voir ce %s, aller à :',
        'TO_VIEW_IT_VISIT' => 'Pour le voir, aller à :',
        'X_REPORTED_AN_ISSUE_ON_Y_ELLIPSIS' => '%1$s a signalé un souci sur %2$s...',
        'X_REPORTED_THE_FOLLOWING_ISSUE_ON_Y_ELLIPSIS' => '%1$s a signalé le problème suivant sur %2$s…',
        'URL_REPORTED_COLON' => 'Adresse URL Signalée :',
        'ISSUE_COLON' => 'Problème :',
        'ADDITIONAL_INFORMATION_COLON' => 'Renseignements Supplémentaires :',
        'SEND_AN_INVITATION_TO_X' => 'Envoyer une invitation à %s',
        'SOMEBODY_REQUESTED_JOIN_X' => 'quelqu\'un a demandé une invitation à joindre le réseau « %s »',
        'WANT_TO_ADD_A_WELCOME_MESSAGE_FOR_X_ON_THEIR_PROFILE_GO_TO' => 'Voulez-vous ajouter un message d’accueil pour %s sur leur profil?  Aller à :',
        'USER_HAS_SENT_YOU_A_MESSAGE_ON_X' => '%1$s vous a envoyé un message sur %2$s.',
        'TO_READ_THIS_MESSAGE_VISIT' => 'Pour lire ce message, visiter :',
        'X_HAS_SENT_YOU_A_MESSAGE_ON_Y_ELLIPSIS' => '%s vous a envoyé un message sur %s !',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ON_Y' => '%s vous a ajouté comme ami sur %s.',
        'X_HAS_ACCEPTED_YOUR_FRIEND_REQUEST' => '%s a accepté votre requête d\'amitié sur le réseau « %s »!',
        'TO_ACCEPT_THIS_FRIEND_REQUEST_VISIT' => 'Pour accepter la requête de cet(te) ami(e), visiter :',
        'VIEW_XS_PAGE_ON_Y' => 'Voir la page de %s sur %s',
        'MEMBER_OF_X_ACCEPTED' => 'un membre du réseau « %s » a accepté votre requête d\'amitié',
        'IF_NO_LONGER_WISH_FRIEND_NOTIFICATION_EMAIL_FROM_X_CLICK_Y' => 'Si vous désirez ne plus recevoir de notifications pour les requêtes d\'amitié du réseau « %s », <a %s>veuillez cliquer ici</a>.',
        'ON_X_COLON' => 'Le %s:',
        'ON_X' => 'le %s',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X' => '%1$s a demandé l’inscription de %2$s sur %3$s...',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X_ELLIPSIS' => '%1$s a demandé l’inscription de %2$s à %3$s...',
        'TO_APPROVE_OR_DENY_USER_REQUEST' => 'Pour autoriser ou refuser la demande de %s, aller à :',
        'VISIT_GROUP_AT' => 'Visiter %s à :',
        'A_MESSAGE_FROM_USERNAME_TO_GROUPNAME_ON_APPNAME' => 'Un message de %s à tous les membres du groupe %s sur le réseau %s!',
        'YOU_CAN_SIGN_IN_USING_EMAIL_HERE' => 'Vous pouvez vous connecter à l’aide de votre adresse électronique ici :',
        'X_ADDED_A_COMMENT_TO_THE_BLOG_POST_Y_ON_Z' => '%1$s a ajouté un commentaire à l\'entrée "%2$s" sur %3$s.',
        'X_ADDED_A_COMMENT_TO_A_BLOG_POST_ON_Y_ELLIPSIS' => '%1$s a ajouté un commentaire à une entrée sur %2$s…',
        'SEND_X_A_MESSAGE_HERE' => 'Envoyer un message à %s ici :',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X_ELLIPSIS' => 'Vous devez approuver un nouveau membre à %s...',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X' => 'Vous devez approuver un nouveau membre à %s.',
        'TO_APPROVE_XS_PROFILE_VISIT' => 'Pour approuver le profil de %s, visiter :',
        'CLICK_HERE_TO_JOIN_COLON' => 'Cliquer ici pour prendre part :',
        'CLICK_HERE_TO_JOIN_BANG' => 'Cliquer ici pour prendre part !',
        'YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED_ELLIPSIS' => 'Votre inscription %s a été approuvée !',
        'CONGRATULATIONS_BANG_YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED' => 'Félicitations !  Votre inscription %s a été approuvée.',
        'YOU_CAN_NOW_SIGN_IN_USING_YOUR_EMAIL_ADDRESS_HERE' => 'Vous pouvez maintenant vous connecter à l’aide de votre adresse électronique :',
        'VISIT_X_AT_Y' => 'Visiter %1$s au : %2$s',
        'TO_CONTROL_WHICH_EMAILS_YOUR_RECEIVE_ON_X_GO_TO' => 'Pour contrôler les courriels que vous recevez %1$s, aller à :',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_ELLIPSIS' => 'Un membre déchu vous a envoyé un message sur %s...',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_USERNAME_WRITES' => 'Un membre déchu vous a envoyé un message sur %1$s.  %2$s écrit :',
        'WELCOME_TO_THE_GROUP_X_ON_Y' => 'Bienvenue dans le Groupe "%1$s" sur %2$s',
        'WELCOME_TO_GROUP_X_ON_Y_ELLIPSIS' => 'Bienvenue à %1$s sur %2$s...',
        'TO_VIEW_THIS_GROUP_VISIT' => 'Pour voir ce groupe, visiter :',
        'COME_JOIN_ME_ON_X' => 'Venez me joindre sur "%s"!',
        'X_IS_NOW_A_MEMBER_OF_Y' => '%1$s est maintenant membre du %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y_ELLIPSIS' => '%1$s est maintenant membre du %2$s...',
        'SOMEBODY' => 'Quelqu’un',
        'TO_VIEW_YOUR_NEW_COMMENT_VISIT' => 'Pour voir votre nouveau commentaire, visiter :',
        'TO_VIEW_THE_NEW_COMMENT_VISIT' => 'Pour voir le nouveau commentaire, visiter :',
        'TO_VIEW_THE_NEW_REPLY_VISIT' => 'Pour voir la nouvelle réponse, visiter :',
        'WELCOME_TO_X_THANK_YOU_FOR_JOINING' => 'Bienvenue au %s! Merci de prendre part.',
        'NAME_COLON' => 'Nom :',
        'EMAIL_COLON' => 'Courriel :',
        'GENDER_COLON' => 'Sexe :',
        'COUNTRY_COLON' => 'Pays :',
        'LOADING_YOUR_FRIENDS' => 'Nous chargeons vos amis…',
        'YOUR_MESSAGE_HAS_BEEN_SENT_TITLE_CASE' => 'Votre message a été envoyé',
        'TO_SEND_ANOTHER_MESSAGE' => 'Pour envoyer un autre message, veuillez entrer votre texte ci-dessous.',
        'PLEASE_CHOOSE_FRIENDS' => 'Veuillez sélectionner quelques amis avant d’envoyer votre message.',
        'THESE_FRIENDS' => 'Ces amis :',
        'ALL_FRIENDS' => 'Tous les amis',
        'ALL_FRIENDS_ON_APPNAME' => 'Tous les amis sur %s',
        'SHARE_WITH_FRIENDS' => 'À partager avec les Amis',
        'SHARE_THIS_WITH_FRIENDS' => 'Partager cet élément avec vos amis',
        'COMPOSE_MESSAGE' => 'Rédiger le message',
        'INVITATION_LINK_ONLY_VISIBLE' => 'Ce lien d’invitation n’est visible qu’aux créateur et administrateurs du réseau. Les membres qui s\'inscrivent à partir de ce lien deviennent automatiquement les amis du créateur du réseau',
        'WE_ARE_LOADING_ADDRESSES' => 'Nous chargeons vos adresses…',
        'SELECT_ALL_NONE' => 'Sélectionner Tous/Aucun',
        'INVITE_TO_APPNAME' => 'Inviter à \'%s\'',
        'INVITE_YOUR_FRIENDS_TO_APPNAME' => 'Inviter vos amis à \'%s\'',
        'ALREADY_MEMBER_OF_NETWORK' => '(Déjà membre de ce réseau)',
        'OR_SHARE_THIS_INVITATION_LINK' => 'Ou partager ce lien d’invitation :',
        'CLICK_TO_MAIL' => '<a %s>Cliquer ici pour envoyer maintenant</a>.',
        'MESSAGE_HAS_BEEN_SENT' => 'Votre message a été envoyé',
        'YOU_CAN_SHARE_THIS' => 'Vous pouvez partager avec plus de personnes ci-dessous, ou <a %s>retourner à la page précédente</a>.',
        'VCARD_IMPORT_UNAVAILABLE' => 'Nous sommes désolés, mais le service d\’importation vCard est actuellement indisponible.',
        'CSV_IMPORT_UNAVAILABLE' => 'Nous sommes désolés, mais le service d\’importation CSV est actuellement indisponible.',
        'ERROR_OCCURRED' => 'Nous sommes désolés, mais une erreur est survenue.',
        'IMPORT_FAILED' => 'Nous sommes désolés, mais l’importation a échoué.',
        'LOGIN_FAILED' => 'Nous sommes désolés, mais la connexion a échoué.',
        'UNABLE_TO_FIND_EMAIL' => 'Nous sommes désolés, mais nous n\’arrivons pas à trouver le champ de courriel.',
        'CANNOT_READ_VCARDS' => 'Nous sommes désolés, mais nous n\’arrivons pas à lire ces vCards.',
        'GET_NETWORK_BADGE' => '%s Insigne',
        'SPREAD_WORD_GET_BADGE' => 'Passer le message. Obtenez votre propre insigne %s pour votre site web ou page MySpace. (<a %s>Obtenir le Code</a>)',
        'SPREAD_WORD_GET_BADGE_SHORT' => 'Passer le message. <a href="%s">Obtenez votre propre insigne %s </a>',
        'SHOW_ALLEGIANCE_GET_BADGE' => 'Montrer votre loyauté. Obtenez votre propre insigne %s pour votre site web ou page MySpace. (<a %s>Get Code</a>)',
        'USER_COMMENTED_ON_A_TYPE_ON_APPNAME' => '%1$s a commenté sur le %2$s "%4$s" de %3$s',
        'ADMINISTRATORS' => 'Administrateurs',
        'YOUR_INVITATION_HAS_EXPIRED' => 'Votre Invitation a Expiré',
        'SORRY_INVITATION_EXPIRED' => 'Nous sommes désolés, l\'invitation que vous avez utilisée a expiré.  Vous aurez besoin d\\’une nouvelle invitation pour prendre part %s.',
        'DISABLE_INVITATION_LINK' => 'Désactiver le lien d’Invitation?',
        'CREATING_LINK_WILL_DISABLE' => 'La création du lien pour une nouvelle invitation désactivera le lien actuel. Êtes-vous sûr de vouloir créer ce lien?',
        'SHARE_LINK_WITH_PEOPLE' => 'Partager ce lien avec des personnes que vous voulez joindre à ce réseau :',
        'CREATE_INVITATION_LINK' => 'Créer Lien de Nouvelle Invitation',
        'PLEASE_SELECT_SECOND_PART' => 'Veuillez sélectionner la deuxième partie de votre courrier électronique, par exemple, gmail.com.',
        'AT_SYMBOL_NOT_ALLOWED' => 'Veuillez vous assurer que le symbole @ n’est pas la première partie de l’adresse électronique.',
        'SORRY_WE_DONT_SUPPORT' => 'Désolé, nous ne supportons pas le carnet d’adresses web pour votre adresse électronique. Essayer de cliquer sur « Application courriel » plus bas pour vous servir des adresses de votre ordinateur.',
        'PLEASE_ENTER_PASSWORD_FOR_EMAIL' => 'Veuillez entrer votre mot de passe %s.',
        'IMPORTING_ADDRESS_BOOK' => 'Importation du carnet d’adresses',
        'LEAVE_WINDOW_WHILE_GET' => '<strong>Veuillez laisser cette fenêtre ouverte</strong> pendant que nous allons chercher les adresses électroniques de vos amis. Lorsque nous avons fini, vous pouvez choisir quels amis inviter.',
        'SHARE_THIS_LINK' => 'Partager ce lien :',
        'SEND_WITH_EMAIL_PROGRAM' => 'Envoyez-le à l\'aide du gestionnaire de courriels de votre ordinateur.:',
        'EMAIL_THIS' => 'Envoyer ceci par courriel',
        'CLEAR' => 'Effacer',
        'SEARCH_FRIENDS_TO_INVITE' => 'Rechercher des Ami(e)s à Inviter :',
        'YOUR_INVITATIONS_HAVE_BEEN_SENT' => 'Vos Invitations ont été Envoyées',
        'NO_ADDRESSES_FOUND' => 'Aucune adresse trouvée',
        'WE_DID_NOT_FIND_ADDRESSES' => 'Nous n’avons trouvé aucune adresse dans le carnet d’adresses importé.',
        'WANT_TO_INVITE_MORE' => 'Vous voulez inviter plus d’ami(e)s? Inviter plus d’ami(e)s en important les coordonnées de votre carnet d’adresses web ou gestionnaire de courriels.',
        'MESSAGE_TOO_LONG' => 'Le message est trop long. Veuillez le réduire à %s caractères et réessayer.',
        'FOLLOWING_DO_NOT_SEEM_VALID' => 'L\'adresse électronique suivante ne semble pas être valable. Les invitations n’ont pas été envoyées. Veuillez corriger les adresses électroniques et réessayer.',
        'PLEASE_ENTER_EMAIL_ADDRESSES' => 'Veuillez entrer une adresse électronique ou plus.',
        'ENTER_EMAIL_ADDRESSES' => 'Entrer adresse électronique',
        'SEPARATE_MULTIPLE_ADDRESSES' => 'Séparer d’une virgule les adresses multiples',
        'YOUR_MESSAGE_OPTIONAL' => '<label>Votre message</label> (au choix)',
        'SEND_INVITATIONS' => 'Envoyer Invitations',
        'IMPORT_FROM_WEB_ADDRESS_BOOK' => 'Importer du carnet d’adresses en ligne',
        'YAHOO_MAIL_HOTMAIL' => 'Yahoo Mail, Hotmail, GMail ou AOL Mail',
        'YOUR_EMAIL_ADDRESS' => 'Votre adresse électronique',
        'IMPORT_ADDRESS_BOOK' => 'Importer Carnet d’adresses',
        'DONT_WORRY_WE_WONT_SAVE' => 'Rassurez-vous, nous n\'enregistreront pas votre mot de passe et vous aurez la possibilité de choisir quels ami(e)s recevront vos courriels.',
        'IMPORT_FROM_ADDRESS_BOOK_APPLICATION' => 'Importer de l’application Carnet d’adresses',
        'MICROSOFT_OUTLOOK_APPLE_MAIL' => 'Microsoft Outlook, Apple Mail, .CSV, etc.',
        'UPLOAD_CSV_OR_VCF' => 'Télécharger un fichier .csv ou .vcf de Microsof Outlook ou Apple Address Book.',
        'BROWSE_FOR_FILE' => 'Naviguer pour trouver le fichier',
        'UPLOAD' => 'Télécharger',
        'SELECT_ELLIPSIS' => 'sélectionner…',
        'OTHER_ELLIPSIS' => 'autre…',
        'DONT_WORRY_YOULL_GET_CHANCE' => 'Rassurez-vous, vous aurez l\'occasion de choisir à quel(le)s ami(e)s envoyer des courriels.',
        'MEMBERSHIP_BY_INVITATION_ONLY' => 'Inscription individuelle seulement',
        'IF_YOU_ARE_ADMIN' => 'Si vous êtes un administrateur <a %s>cliquer ici pour vous connecter</a>.',
        'NAME_MUST_BE_SHORTER' => 'Le nom doit être plus court de %s caractères',
        'CITY_NAME_MUST_BE_SHORTER' => 'Le nom de la ville doit être plus court de %s caractères',
        'EMAIL_ALREADY_REGISTERED' => 'L’adresse électronique a déjà été enregistrée. Veuillez en choisir une autre.',
        'EMAIL_NOT_VALID' => 'Cette adresse électronique ne semble pas être valable.',
        'USERNAME_INVITED_YOU_TO_APPNAME' => '%s vous a invite à %s',
        'YOU_ARE_SIGNING_UP_WITH' => 'Vous vous connectez avec votre Ning ID.',
        'NOW_ENTER_PASSWORD' => 'Entrer maintenant votre mot de passe pour continuer.',
        'OR_SIGN_IN' => 'ou <a %s>Ouvrir une Session</a>',
        'CHANGE_ADDRESS' => 'Modifier l’Adresse',
        'CHANGE_PAGE_ADDRESS' => 'Modifier l\'adresse de page',
        'PAGE_ADDRESS_TAKEN' => 'Nos excuses – cette adresse a déjà été prise. Veuillez en choisir une autre.',
        'PAGE_ADDRESS_NOT_VALID' => 'Vous pouvez uniquement utiliser les lettres A à Z, les nombres et les soulignements (_) dans votre adresse.',
        'ADD_BY_PHONE' => 'Ajouter par téléphone',
        'PAGE_ADDRESS' => 'Adresse de page',
        'PHOTO_MUST_BE_TYPE' => 'Votre photo doit être un fichier .jpg, .gif ou .png.',
        'USEFUL_ADDRESSES' => 'Adresses utiles',
        'MY_DETAILS' => 'Mes coordonnées',
        'NONE_I_DO_NOT_WANT' => 'Aucun : je ne veux pas recevoir de courriels de %s',
        'CHANGE_PASSWORD' => 'Modifier le mot de passe',
        'PROFILE_SAVED' => 'Vos modifications ont été enregistrées avec succès.',
        'UPDATE_EMAIL_ADDRESS' => 'Mise à jour d\'adresse électronique',
        'EDIT_EMAIL_ADDRESS' => 'Modifier votre adresse électronique',
        'MY_SETTINGS' => 'Mes paramètres',
        'ABOUT_ME' => 'À propos de moi',
        'SELECT' => 'Sélectionner...',
        'CITY' => 'Ville',
        'COUNTRY' => 'Pays',
        'DATE_OF_BIRTH' => 'Date de naissance',
        'DO_NOT_DISPLAY' => 'Ne pas afficher',
        'GENDER' => 'Genre',
        'CREATE_YOUR_PROFILE' => 'Créer Votre Profil',
        'SYSTEM_REQUIREMENTS' => 'Besoins du Système',
        'WE_SUPPORT_INTERNET_EXPLORER' => 'Nous supportons Internet Explorer 6 et 7, Firefox 2.0 et Safari 2.0. Si vous utilisez un navigateur différent (peut-être un fourni par votre opérateur de service Internet), il pourrait ne pas être compatible.',
        'MAKE_SURE_COOKIES' => 'Assurez-vous que les fichiers témoins et JavaScript sont activés dans votre navigateur.',
        'WHAT_IS_MY_EMAIL' => 'Quelle est mon adresse électronique?',
        'IF_JOINED_BEFORE_OCTOBER' => 'Si vous vous êtes inscrit avant le 5 octobre 2007, vous pourriez avoir été invité à entrer le « Ning ID ». Nous vous demandons maintenant de vous connecter avec l’adresse électronique de votre inscription, cependant vous pouvez quand même entrer votre Ning ID  dans le champ.',
        'CLICK_HERE_TO_RESET_PASSWORD' => 'Cliquer ici pour réinitialiser votre mot de passe.',
        'STILL_HAVING_PROBLEMS' => 'Encore des problèmes?',
        'VISIT_NING_HELP_CENTER' => 'Visiter le <a %s>Centre d\'Aide Ning</a> pour plus de renseignement de dépannage et de soutien.',
        'PROBLEMS_SIGNING_UP_OR_SIGNING_IN' => 'Problèmes d\'ouverture et de fermeture de session',
        'WE_SENT_YOU_EMAIL' => 'Nous vous avons envoyé un courriel avec un lien pour réinitialiser votre mot de passe.',
        'RESET_PASSWORD_EMAIL_SUBJECT' => 'Réinitialisation du mot de passe',
        'RESET_PASSWORD_EMAIL_BODY' => '%1$s,

Nous avons reçu une requête pour modifier votre mot de passe %2$s.

Cliquer sur le lien ci-dessous pour initialiser un nouveau mot de passe :

#{URL}

Si vous ne voulez pas modifier votre mot de passe, vous pouvez ignorer ce courriel.

Merci,
L\'équipe du réseau %2$s

-----
%2$s utilise le Ning ID  pour l\'authentification.',
        'SET_PASSWORD' => 'Initialiser le mot de passe',
        'NEW_PASSWORD' => 'Nouveau mot de passe',
        'CREATE_NEW_PASSWORD' => 'Créer un nouveau mot de passe',
        'SET_NEW_PASSWORD' => 'Initialiser un nouveau mot de passe pour votre compte Ning ID.',
        'CHOOSE_NEW_PASSWORD' => 'Veuillez choisir un nouveau mot de passe',
        'HELLO_USERNAME_SIGN_OUT' => '<strong>Bonjour, %s</strong> (<a %s>Déconnecter</a>)',
        'NO_ACCOUNT_WITH_EMAIL_X' => 'Il n\'y a pas de compte associé à cette adresse électronique %s',
        'PLEASE_ENTER_CODE' => 'Veuillez entrer le code qui apparaît sur le côté droit.',
        'PROBLEMS_SIGNING_UP' => 'Des problèmes de connexion?',
        'BY_SIGNING_UP_YOU_AGREE' => 'En ouvrant une session, vous acceptez de respecter les <a %s>Conditions d’Utilisation</a> et <a %s>Politique&nbsp;de Confidentialité</a>.',
        'FEEDBACK' => 'Commentaires',
        'TERMS_OF_SERVICE' => 'Conditions d\'Utilisation',
        'PRIVACY_POLICY' => 'Politique sur la vie privée',
        'PROBLEM_SIGNING_UP' => 'Il y a eu un problème de connexion',
        'ALREADY_MEMBER_SIGN_IN' => 'Déjà membre? <a %s>Cliquer ici pour ouvrir une session</a>.',
        'MEMBERSHIP_TO_APPNAME_BY_INVITATION_ONLY' => 'L’adhésion au %s se fait Sur Invitation Seulement',
        'SORRY_BUT_ADMINISTRATOR_REQUIRES_INVITATION' => 'Nous sommes désolé, mais l’administration a choisi d\'exiger une invitation pour adhérer %s. Si vous avez une invitation, cliquer sur le lien dans le courriel pour adhérer.',
        'PROBLEM_SIGNING_IN' => 'Il y a eu un problème de connexion',
        'WE_USE_NING_ID' => 'Nous utilisons Ning ID pour l\'authentification. <a %s>Qu’est-ce que Ning ID?</a>',
        'PROBLEMS_SIGNING_IN' => 'Des problèmes de connexion?',
        'SIGN_IN_OR_SIGN_UP' => '<input %s value="Connexion" /> &#160;ou&#160; <strong><a %s>Se connecter</a></strong>',
        'SIGN_IN_TO_APPNAME' => 'Se connecter à %s',
        'WHAT_IS_A_NING_ID' => 'Qu’est-ce qu’un Ning ID?',
        'LARR_BACK' => '← <a %s>Retour</a>',
        'NING_ID_LETS_YOU_CHOOSE' => 'Le système d\'authentification Ning ID vous permet de choisir une adresse électronique et un mot de passe une seule fois, et de l\'utiliser pour prendre part à ou se connecter à un réseau social utilisant Ning ID.',
        'WHEN_YOU_CREATE_NING_ID' => 'Lorsque vous créez un Ning ID, vous pouvez aussi ajouter à votre compte Ning ID un ensemble de détails de base ainsi que votre photo. Ces détails sont alors pré-chargés chaque fois que vous prenez part à un réseau social utilisant Ning ID pour l’authentification. Cela vous permet aussi de garder le contact avec vos ami(e)s à travers tous les réseaux sociaux qui l’utilisent.',
        'SIGN_IN_WITH_NING_ID_WHENEVER' => 'Vous pouvez ouvrir une session avec votre adresse électronique et mot de passe Ning ID chaque fois que vous rencontrez ce symbole : %s',
        'HELLO_USER' => 'Bonjour, %s',
        'TEXT_FOR_HEADER_TAB' => 'Le texte est destiné à un onglet d’en-tête',
        'BASED_ON' => 'Basé sur',
        'ARE_YOU_SURE_DELETE_LANGUAGE' => 'Êtes-vous sûr de vouloir supprimer cette langue?',
        'DELETE_LANGUAGE' => 'Supprimer la Langue',
        'TEXT_RESET_TO_ORIGINAL_VERSION' => 'Le texte a été ramené à sa version initiale.',
        'UPLOAD_LANGUAGE_FILE' => 'Télécharger le Fichier Langue',
        'ADD_TO_LANGUAGE' => 'Ajouter à la Langue :',
        'IF_YOU_CREATED_TRANSLATION' => 'Si vous avez créé une nouvelle traduction dans un autre réseau social Ning, vous pouvez importer votre travail ici. Les contenus du fichier seront ajoutés à la langue de votre choix. Vous ne voyez pas votre langue dans la liste? <a %s>Il est facile d’en ajouter une nouvelle</a>.',
        'EXAMPLES_SWEDISH_FINLAND' => 'Exemples : suédois (Finlande), philippin, espagnol (Porto Rico)',
        'START_FROM_SCRATCH_CREATE' => 'Commencer à partir de rien! Créer une nouvelle traduction pour votre réseau en entrant un nom pour la nouvelle langue, puis en choisissant une langue existante comme point de référence.',
        'KEY_MISSING_TEXT' => 'Clef : <span %s>Texte manquant</span> <span %s>Texte modifié</span>',
        'SHOW_ALL_TEXT' => 'Montrer tout le texte',
        'SHOW_MISSING_TEXT' => 'Montrer le texte manquant',
        'SHOW_CHANGED_TEXT' => 'Montrer le texte modifié',
        'EXAMPLES_TABS_MEMBERS_FRIENDS' => 'Exemples : Onglets, Membres, Ami(e)s',
        'RESET_TEXT_TO_ORIGINAL_VERSION' => 'Ramener le texte à sa version originale',
        'ORIGINAL_TEXT_X' => 'Texte original – %s',
        'EDIT_LANGUAGE_ON_NETWORK' => 'Modifier la langue dans votre réseau',
        'CUSTOMIZE_TEXT_ON_NETWORK_INCLUDING' => 'Personnaliser un texte quelconque de votre réseau, y compris les noms d’onglets, les bas de page de courriel, les messages d’erreur et ainsi de suite.',
        'ACTIVE_LANGUAGE_IS_X' => '<em>La langue active pour votre réseau is %1$s</em>. <a %2$s>Modifier La Langue Active</a>',
        'CURRENT_LANGUAGE_OPTIONS' => 'Choix Actuel de Langue',
        'ACTIVE' => 'Actif',
        'MY_LANGUAGES' => 'Mes Langues',
        'CREATE_NEW_TRANSLATION' => 'Créer une Nouvelle Traduction',
        'DONT_SEE_LANGUAGE_LISTED_CREATE' => 'Vous ne voyez pas votre langue listée ci-dessus? <strong><a %s>Créer une nouvelle traduction pour votre réseau</a></strong>.',
        'ADVANCED_IMPORT' => 'Importation Avancée',
        'IF_YOU_TRANSLATED_A_LANGUAGE' => 'Si vous avez traduit une langue dans un réseau social existant, vous pouvez <strong><a %s>importer votre fichier langue file</a></strong> et l’utiliser dans ce réseau.',
        'LANGUAGE_EDITOR' => 'Éditeur de langue',
        'PUBLIC' => 'Public',
        'GRANDFATHERED_PRIVACY_SETTING' => 'Votre paramètre de confidentialité actuel, un réseau public où les non membres ne peuvent voir que l’écran de connexion, n’est plus disponible. Votre paramètre de confidentialité n\\’a pas été modifié, mais si vous faites des modifications quelconques ici, vous ne pourrez les annuler. L’équivalent actuel est un réseau privé auquel tout le monde peut adhérer.',
        'NO_MISSING_ITEMS' => 'Il y a des éléments manquants â cette traduction est complète à 100%%. <a %s>Voir tous les éléments.</a>',
        'NO_CHANGED_ITEMS' => 'Il n\\’y a pas d’éléments modifiés.',
        'COULD_NOT_FIND_ITEMS_MATCHING' => 'Toutes nos excuses – nous n’avons pas pu trouver d\\’éléments correspondants <em>%s</em>. <a %s>Voir tous les éléments.</a>',
        'FILE_N' => 'Fichier %s',
        'TRANSLATION_FILE_HAS_FILENAME_LIKE' => 'Un fichier de traduction Ning a un nom de fichier ressemblant à <code>en_US.txt</code>. <a %s>En apprendre davantage ici.</a>',
        'SELECT_TRANSLATION_FILE' => 'Sélectionner Fichier de traduction :',
        'USE_THIS_TRANSLATION' => 'Utiliser Cette Traduction',
        'FOLLOWING_ARE_MISSING_FROM_RULES' => 'Remarquer que ce qui suit manque aux règles ci-dessous : %s',
        'ALL' => 'Tout',
        'MISSING' => 'Manquant',
        'VIEW' => 'Affichage',
        'TRANSLATION_CHANGES_SAVED' => 'Vos modifications ont été sauvegardées. Cette traduction est %s%% complétée.',
        'TRANSLATION_CHANGES_SAVED_MAKE_CURRENT' => 'Vos modifications ont été sauvegardées. Cette traduction est %s%% complétée. Aimeriez-vous utiliser cela comme la langue actuelle pour votre réseau?',
        'TRANSLATION_UPLOAD_SUCCESSFUL' => 'Votre téléchargement a réussi. Cette traduction est %s%% complétée.',
        'TRANSLATION_UPLOAD_SUCCESSFUL_MAKE_CURRENT' => 'Votre téléchargement a réussi. Cette traduction est %s%% complétée. Aimeriez-vous utiliser cela comme la langue actuelle pour votre réseau?',
        'X_IS_CURRENT_LANGUAGE' => '%s est maintenant la langue de votre réseau.',
        'SAVE_PAGE' => 'Sauvegarder la page',
        'LANGUAGE_NAME_TAKEN' => 'Nous sommes désolés - ce nom est déjà pris. Veuillez choisir un autre nom.',
        'ENTER_NAME_FOR_TRANSLATION' => 'Veuillez entrer un nom pour votre traduction, e.g., le portugais (Portugal)',
        'CREATE' => 'Créer',
        'LANGUAGE_NAME' => 'Nom de la Langue',
        'SAVE_ITEMS_ON_PAGE' => 'Sauvegarder les éléments de cette page',
        'NEW_TRANSLATION' => 'Nouvelle Traduction',
        'MISMATCHED_CURLY_BRACKETS' => 'Accolades dépareillées',
        'MISMATCHED_SQUARE_BRACKETS' => 'Crochets dépareillés',
        'MISMATCHED_PARENTHESES' => 'Parenthèses dépareillées',
        'ERROR_PROCESSING_SPECIAL_RULES' => 'Une erreur est survenue durant le traitement du code de Règles Spéciales.',
        'ERROR_PROCESSING_TAB_NAMES' => 'Une erreur est survenue durant le traitement du code des Noms d’Onglet.',
        'SPECIAL_RULES' => 'Règles Spéciales',
        'TAB_NAMES' => 'Noms d’Onglet',
        'SOURCE' => 'Source',
        'LANGUAGE_EDITOR_X' => 'Éditeur de langue : %s',
        'BACK_TO_LANGUAGE_EDITOR' => '← Retour à l’éditeur de langue',
        'CUSTOMIZE_YOUR_NETWORKS_TEXT' => 'Personnaliser les textes et messages de votre réseau ou créer une nouvelle langue.',
        'STOPWORDS' => 'a | about | an | are | as | at | be | by | com | de | en | for | from | how | i | in | is | it | la | of | on | or | that | the | this | to | was | what | when | where | who | will | with | und | the | www',
        'STOPWORDS_ARE' => 'Les <a %s>Mots Vides</a> sont une liste facultative de mots éliminés par filtrage de la description du réseau lors de la création des balises méta en haut de chaque page. Au choix.',
        'I_AM_MEMBER' => 'Je suis un membre du réseau:',
        'VIEW_PAGE_ON_APPNAME' => 'Voir ma page au <em>%s</em>',
        'VISIT_APPNAME' => 'Visiter <em>%s</em>',
        'JOIN_US' => 'Joignez-vous à nous',
        'CREATED_BY_COLON' => 'Créé par :',
        'GET_MORE_BADGES' => 'Obtenir d\'autres insignes',
        'SHOW_LOGO' => 'Afficher logo',
        'GALLERY' => 'Galerie',
        'BADGES' => 'Insignes',
        'MEMBER_BADGE' => 'Insigne de membre',
        'WEAR_IT_WITH_PRIDE' => 'Portez-le avec fierté ! Obtenez un insigne de membre %s que vous pouvez afficher sur votre site web ou votre page MySpace.',
        'NETWORK_BADGE_LARGE' => 'Insigne de réseau (Grand)',
        'SPREAD_THE_WORD_NETWORK_BADGE_LARGE' => 'Passez le message! Obtenez une insigne du réseau "%s" qui inclus une mise à jour dynamique des membres les plus populaires du réseau. Ajoutez-le à votre site web ou votre page MySpace.',
        'NETWORK_BADGE_SMALL' => 'Insigne de réseau (Petit)',
        'SPREAD_THE_WORD_NETWORK_BADGE_SMALL' => 'Passez le message! Obtenez un insigne du réseau « %s » que vous pouvez afficher sur votre site web ou votre page MySpace.',
        'PHOTO_SLIDESHOW_PROPER' => 'Diaporama de Photos',
        'DISPLAY_SELECTION_OF_PHOTOS' => 'Affichez une sélection de vos photos sur un site web ou une page MySpace grâce à notre chic diaporama de photos.',
        'MUSIC_PLAYER' => 'Lecteur Audio',
        'PLAY_MUSIC_ON_WEBSITE' => 'Faites jouer votre musique sur un site web ou une page MySpace grâce à notre chic lecteur audio.',
        'LARGE_N_PIXELS_WIDE' => 'Grand - %d pixels de large',
        'MEDIUM_N_PIXELS_WIDE' => 'Moyen - %d pixels de large',
        'SMALL_N_PIXELS_WIDE' => 'Petit - %d pixels de large',
        'MY_MOST_RECENT' => 'Mes Plus Récent(e)(s)',
        'APP_ICON' => 'Îcone',
        'MEMBERSHIP_TO_X_IS_BY_INVITATION' => 'L\'adhésion au réseau « %s » est par invitation seulement',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK_ON_Y' => '%1$s a fourni le commentaire sur %2$s:',
        'X_PROVIDED_FEEDBACK_ON_Y_ELLIPSIS' => '%1$s a fourni le commentaire suivant %2$s...',
        'THANK_YOU_YOUR_MESSAGE_HAS_BEEN_SENT' => 'Merci. Votre message a été envoyé.',
        'X_WOULD_LIKE_TO_JOIN_X' => '%s veut se joindre au groupe %s!',
        'X_HAS_REQUESTED_AN_INVITATION' => '%s a demandé une invitation à joindre le réseau « %s »',
        'YOUR_REQUEST_HAS_BEEN_SENT' => 'Votre requête a été envoyée au créateur du réseau.',
        'TO_UNBAN_USERNAME_GO_TO' => 'Pour lever l’interdiction %s, aller à :',
        'SEND_REQUEST' => 'Envoyer Requête',
        'SEARCH' => 'Recherche',
        'SEARCH_AGAIN' => 'Rechercher à nouveau',
        'SEND_BROADCAST_MESSAGE' => 'Envoyer Message de Diffusion',
        'VERIFICATION_IMAGE' => 'Image de Vérification',
        'UNDER_CONSTRUCTION' => 'En Construction',
        'PROFILE_INFORMATION_SAVED' => 'Information Profil Sauvegardée',
        'YOUR_SITES_DIRECTORY_PROFILE' => 'L\'information sur le répertoire de votre réseau a été sauvegardée.',
        'NO_ACCOUNT_WITH_EMAIL' => 'Il n’y a pas de compte avec cette adresse électronique.',
        'INVALID_PASSWORD_CHECK_CAPS_LOCK' => 'Mot de Passe erronée.  Le Verr. Maj. est-il appuyé?',
        'OOPS_THAT' => 'Oups – cela n’a pas fonctionné.',
        'OOPS_THAT_DID_NOT_WORK' => 'Oups – cela n’a pas fonctionné.  Réessayer?',
        'OOPS_THAT_DID_NOT_WORK_ERROR_CODE' => 'Oups – cela n’a pas fonctionné (%s).',
        'NOT_FOUND' => 'Non Trouvé',
        'YOUR_SITES_FEATURE_LIST' => 'Votre liste de fonctionnalités a été sauvegardée.',
        'ONE_LINE_ANSWER' => 'Réponse en une ligne',
        'LONGER_ANSWER' => 'Réponse multilignes',
        'MULTIPLE_CHOICE' => 'Choix multiple',
        'DATE' => 'Date',
        'WEBSITE_ADDRESS' => 'Adresse du site web',
        'EVERYTHING' => 'Tout le réseau',
        'JUST_THE_HOMEPAGE' => 'Seulement la page principale',
        'JUST_THE_SIGN_UP_PAGE' => 'Juste la page d\'adhésion',
        'YOUR_CHANGES_HAVE_BEEN_SAVED' => 'Vos modifications ont été sauvegardées.',
        'JOIN_ME_ON_X' => 'Joignez-vous au réseau « %s »!',
        'NOT_ALLOWED' => 'Non Permis',
        'COME_JOIN_ME_ON_X_ELLIPSIS' => 'Venez me joindre sur %s...',
        'X_NOT_VALID_EMAIL' => '%s n\'est pas un Ning ID ou une adresse électronique valide.',
        'USER_BANNED_FROM_NETWORK' => '%1$s a été banni de ce réseau. <a %2$s>Envoyer un message à %1$s</a>',
        'USER_ALREADY_NETWORK_MEMBER' => '%1$s est déjà membre de ce réseau. <a %2$s>Envoyer un message à %1$s</a>',
        'YOU_CAN_SEND_AT_MOST_X' => 'Vous ne pouvez qu\'en envoyer %s à la fois.',
        'PLEASE_ENTER_YOUR_FRIENDS' => 'Veuillez entrer les adresses électroniques ou les Ning ID de vos amis',
        'THERE_HAS_BEEN_AN_ERROR' => 'Il y a eu une erreur',
        'INVITATIONS_HAVE_BEEN_SENT' => 'Invitation(s) envoyée(s)',
        'SEARCH_RESULTS' => 'Résultats de recherche',
        'INVITE_YOUR_FRIENDS' => 'Invitez Vos Amis',
        'SEND_INVITATIONS_FOR_FRIENDS' => 'Envoyez une invitation à vos amis pour qu\'ils joignent votre réseau social:',
        'INVITATION' => 'Invitation',
        'ADD_FROM_ADDRESS' => 'Carnet d\'Adresses (Address Book)',
        'TO' => 'À:',
        'SEND_TO' => 'Envoyer à',
        'SUBJECT' => 'Sujet',
        'YOUR_MESSAGE' => 'Votre message',
        'SEND' => 'Envoyer',
        'REPORT_AN_ISSUE' => 'Signaler un problème',
        'TYPE_OF_ISSUE' => 'Type de Problème',
        'ADULT' => 'Adulte',
        'ABUSIVE' => 'Abus',
        'BUG' => 'Bogue',
        'FRAUD' => 'Fraude',
        'SPAM' => 'Spam',
        'OTHER' => 'Autre',
        'DESCRIBE_YOUR_ISSUE' => 'Description du Problème',
        'SEND_REPORT' => 'Envoyer Formulaire',
        'ADDED_BY_X_AT_X' => 'Ajouté(e)(s) par <a %s>%s</a> à %s le %s',
        'ADDED_BY_USER_TO_GROUP_AT_DATE' => 'Ajouté par <a %s>%s</a> au groupe %s le %s sur le réseau %s',
        'G_IA' => 'g:ia',
        'F_JS_Y' => 'F jS, Y',
        'CLICK_TO_VIEW' => 'Cliquez ici pour voir',
        'COMMENT_FOR' => 'Commentaire pour:',
        'COMMENT_ON' => 'Commentaire sur:',
        'ACTION_BUTTON_FEATURE' => 'Promouvoir',
        'FEATURE_THIS_ON_YOUR' => 'Exhiber ceci sur la page principale',
        'ACTION_BUTTON_REMOVE' => 'Supprimer',
        'REMOVE' => 'Supprimer',
        'FEATURE_ON_HOME' => 'Exhiber sur la page principale',
        'REMOVE_FROM_HOME' => 'Enlever de la page principale',
        'ITEM_WILL_APPEAR' => 'Cet élément apparaîtra sur les modules sélectionnés de la page principale',
        'ITEM_WILL_NO_LONGER_APPEAR' => 'Cet élément apparaîtra sur les modules sélectionnés de la page principale',
        'ADD_CONTENT' => 'Ajouter du contenu',
        'BROUGHT_TO_YOU_BY' => '%s vous est présenté par %s © %s',
        'GIVE_US_YOUR_FEEDBACK' => 'Laisser un commentaire',
        'FOR_ADDITIONAL_QUESTIONS_OR_TO_CONTACT_NING_PLEASE_CLICK_HERE' => 'Pour des questions supplémentaires ou pour contacter Ning, veuillez cliquer ici :',
        'SEND_FEEDBACK' => 'Envoyer Votre Commentaire',
        'SIGN_OUT' => 'se déconnecter',
        'SIGN_OUT_TITLE' => 'Se déconnecter',
        'INVITE_MORE' => 'En inviter plus',
        'USE_THIS_FORM_TO_SEND_FEEDBACK_TO_NC' => 'Utiliser ce formulaire pour envoyer vos commentaries à <a %s>%s</a>, le créateur de <a %s>%s</a>.',
        'YOUR_FEEDBACK' => 'Votre Commentaire',
        'NETWORK_INFORMATION' => 'Information sur le Réseau',
        'ABOUT_YOUR_SITE' => 'À propos de votre réseau',
        'WELCOME_TO_YOUR_SITE' => 'Bienvenue à votre réseau social!',
        'EDIT_YOUR_NETWORKS_INFO' => 'Modifier le nom, la description et autres renseignements de votre réseau.',
        'TAGLINE' => 'Sommaire',
        'APPEARS_IN_HEADER' => 'Apparaît dans l\'en-tête de votre réseau',
        'APPEARS_IN_EMAILS' => 'Apparaît dans dans les courriels et à d\'autres endroits',
        'NETWORK_NAME' => 'Nom du réseau',
        'DESCRIPTION' => 'Description',
        'KEYWORDS' => 'Mots-clés',
        'LANGUAGE' => 'Langage',
        'SEPARATE_EACH_KEYWORD' => 'Séparez chaque mot-clé par une virgule',
        'ICON' => 'Icône',
        'UPLOAD_A_PHOTO_WHICH_WILL_BE_RESIZED' => 'Télécharger une photo (GIF, JPG, PNG), qui va être redimensionnée en un carré. Cette photo peut prendre quelques minutes avant d\'apparaître.',
        'SAVE_SETTINGS' => 'Sauvegarder Paramètres',
        'SUCCESS_EXCLAMATION' => 'Succès!',
        'FEATURES' => 'Fonctionnalités',
        'ADD_FEATURES' => 'Ajouter des fonctionnalités à Votre Réseau',
        'ORGANIZE_FEATURES' => 'Organiser votre page principale en glissant les fonctionnalités de la liste ci-dessous, puis en les arrangeant comme vous voulez.',
        'SKIP_FEATURES' => 'Cliquer sur <a href="%s">Sauter cette étape</a> pour continuer avec les fonctionnalités et la présentation par défaut.',
        'FEATURES_FOR_ALL_PAGES' => 'Les fonctionnalités ajoutées à cette case apparaitront dans toutes les pages de votre réseau.',
        'CUSTOMIZE_SITE_BY_ADDING' => 'Personnaliser le réseau social en ajoutant de nouvelles fonctionnalités ou bien en enlevant des fonctionnalités existantes.',
        'ADJUST_YOUR_SITES_COLORS' => 'Ajuster les couleurs du réseau, les images et le style en général.',
        'APPEARANCE' => 'Apparence',
        'PROFILE_QUESTIONS' => 'Questions de profil',
        'EDIT_QUESTIONS_THAT_MEMBERS_ANSWER' => 'Modifier les questions auxquelles les membres répondent sur eux-mêmes.',
        'MESSAGE_SENT' => 'Message Envoyé!',
        'YOUR_MESSAGE_HAS_BEEN_SENT' => 'Votre message a été envoyé à tous les membres de votre réseau.',
        'YOUR_MESSAGE_HAS_BEEN_SENT_GROUP' => 'Votre message a été envoyé à tous les membres de votre groupe.',
        'YOUR_MESSAGE_IS_BEING_SENT' => 'Votre message est en cours d\'envoi. Veuillez patienter puisque cela peut prendre quelques minutes.',
        'BROADCAST_MESSAGE' => 'Diffusion de messages',
        'TRACK_VISITORS_AND_TRENDS' => 'Voir le trafic et les statistiques de votre réseau social.',
        'EDIT_SOURCE_CODE' => 'Modifier le code source',
        'TAKE_FULL_CONTROL' => 'Prenez plein contrôle de votre réseau en modifiant le code source.',
        'DELETE_THIS_SITE' => 'Supprimer votre réseau social',
        'MAIN_PAGE' => 'Page principale',
        'MAIN' => 'Page principale',
        'MAIN_TAB_TEXT' => 'Page principale',
        'MANAGE' => 'Gestion',
        'MANAGE_TAB_TEXT' => 'Gestion',
        'PAGE_TITLE' => 'Titre de la page',
        'LOREM_IPSUM_1' => 'Lorem <span %s>ipsum dolor</span> sit amet, consectetuer adipiscing elit. Nunc scelerisque blandit dolor. Vestibulum ante ipsum primis in faucibus orci luctus.',
        'LOREM_IPSUM_2' => 'Lorem ipsum dolor sit amet, consectetuer adipiscing',
        'LOREM_IPSUM_3' => 'Lorem ipsum dolor sit amet, <span class="preview_link">consectetuer</span> adipiscing',
        'EDIT_THE_APPEARANCE' => 'Modifier l\'apparence de votre page',
        'CHOOSE_A_THEME' => 'Choisissez un thème pour votre réseau social',
        'NOW_CUSTOMIZE_SITE' => 'Personnaliser maintenant votre réseau social !',
        'THEME_SETTINGS' => 'Paramètres Thème',
        'ADVANCED' => 'Section Approfondie',
        'TOP_BAR_AND_FOOTER' => 'Barre d\'en-tête et note de bas de page',
        'HEADER_AND_NAVIGATION' => 'En-tête et Navigation',
        'ADD_A_LOGO' => 'Ajouter un Logo',
        'THIS_IMAGE_WILL_REPLACE' => 'Cette image va remplacer le nom textuel du réseau dans l\'en-tête',
        'TABS' => 'Onglets',
        'TAB' => 'Onglet',
        'SITE' => 'Réseau',
        'SIDES' => 'Côtés',
        'BODY' => 'Corps',
        'SHOW_NING_LOGO' => 'Montrer le logo de Ning?',
        'LAUNCH' => 'LANCER!',
        'NING_ID' => 'Ning ID',
        'PASSWORD' => 'Mot de passe',
        'RETYPE_PASSWORD' => 'Re-saisir votre mot de passe',
        'TYPE_CODE_ON_RIGHT' => 'Saisissez le Code<br />sur la Droite',
        'JOIN_X' => 'Se joindre au réseau « %s »',
        'SIGN_UP_FOR_X' => 'Ouvrir une Session pour %s',
        'HAS_INVITED_YOU_TO_X' => 'vous a invité à joindre le réseau « %s ».',
        'CONTENT_AWAITING_APPROVAL' => 'En attente d\'autorisation',
        'NEW_MEMBER' => 'Nouveau Membre?',
        'JOIN_X_NOW' => 'Joignez-vous au réseau « %s », dès maintenant!',
        'HIDE_THIS_MESSAGE' => 'Dissimuler ce message',
        'PAGE_NOT_FOUND' => 'Page Inexistante',
        'THIS_PAGE_WAS_NOT_FOUND' => 'Toutes nos excuses, cette page n’a pas été trouvée',
        'FOLLOW_THESE_LINKS_TO' => 'Veuillez choisir un des liens ci-dessous:',
        'ALTERNATIVELY_YOU_CAN_SEARCH' => 'Sinon vous pouvez aussi faire une recherche sur ce réseau social:',
        'IF_YOU_GET_THIS_MESSAGE' => 'Si vous obtenez ce message à nouveau, <a %s>veuillez nous le faire savoir.</a>',
        'GROUP_MEMBERS' => 'Membres du Groupe',
        'VIDEOS' => 'Vidéos',
        'BLOG' => 'Blogue',
        'ACCOUNT' => 'Compte',
        'WE_ARE_SORRY_WE_ARE_HAVING' => 'Nous sommes désolé, il y a un problème avec cette page.',
        'FOLLOW_LINK_TO_HOMEPAGE' => 'Suivez <a %s>ce lien</a> pour aller à la page principale.',
        'REQUEST_AN_INVITATION' => 'Demander Une Invitation',
        'NAME' => 'Nom',
        'EMAIL_ADDRESS' => 'Adresse électronique',
        'MESSAGE_OPTIONAL' => 'Message (Facultatif)',
        'SORRY_HOWEVER_ITS_EASY' => '<strong>Désolé!</strong> Par contre, il est facile de créer votre propre réseau social.',
        'GET_YOUR_OWN_BAZEL' => 'Créez votre propre réseau social!',
        'SITE_IS_NOT_READY' => 'Ce réseau social n\'est pas encore tout à fait prêt!',
        'BAZEL_IS_BEING_SET_UP' => 'Ce réseau social est en cours d\'installation!',
        'SIGN_IN' => 'Se connecter',
        'FORGOT_YOUR_PASSWORD' => 'Mot de passe oublié?',
        'FORGOT_YOUR_PASSWORD_TITLE' => 'Mot de passe oublié?',
        'ENTER_EMAIL_AND_CLICK_RESET_PASSWORD' => 'Entrer votre adresse électronique et cliquer sur « Réinitialisation du mot de passe ». Vous recevrez un courriel ayant un lien pour réinitialiser votre mot de passe.',
        'RESET_PASSWORD' => 'Réinitialiser mot de passe',
        'EXPLORE' => 'Explorer',
        'SIGN_UP' => 'Inscription',
        'CONFIRM_PASSWORD' => 'Confirmez le mot de passe',
        'VERIFICATION' => 'Vérification',
        'YOUR_PHOTO' => 'Votre photo',
        'SUMMARY' => 'Sommaire',
        'YOUR_SITE_IS_READY' => 'Votre réseau social est prêt pour le lancement! Les paramètres à défaut vont être utilisés pour chaque étape que vous sautez. Revenez en arrière pour faire des changements ou bien cliquer sur \'Lancer!\' pour lancer votre réseau.',
        'WHEN_YOU_ARE_FINISHED' => 'Lorsque vous avez terminé, cliquez sur « Voir Mise en page » pour voir la nouvelle mise en pages!',
        'COMPLETE' => 'complet',
        'INCOMPLETE' => 'incomplet',
        'VIEW_LAYOUT' => 'Voir Mise en page',
        'CLEAR_CONTENTS' => 'Effacer Contenu',
        'ADD_MODULE' => 'Ajouter Module...',
        'ADD_COLUMNS' => 'Ajouter Colonnes...',
        'PUBLIC_ANYBODY_CAN_JOIN' => '<strong>Public</strong> – Tout le monde peut adhérer',
        'PRIVATE_ONLY_INVITED' => '<strong>Privé</strong> – Seules les personnes invitées peuvent y accéder et adhérer',
        'INVITATIONS' => 'Invitations',
        'MEMBERS_CAN_INVITE' => 'Membres peuvent inviter des gens à joindre',
        'QUESTION_TITLE' => 'Titre de la question',
        'ANSWER_TYPE' => 'Type de réponse',
        'REQUIRED' => 'Obligatoire?',
        'PRIVATE' => 'Privé',
        'CHOICES' => 'Choix',
        'SEPARATE_EACH_CHOICE' => 'Séparez chaque choix par une virgule',
        'CAN_PICK_MORE' => 'Plus qu\'une réponse possible',
        'ADD_ANOTHER_QUESTION' => 'Ajouter une autre question',
        'WHAT_INFORMATION' => 'Quelles questions voulez-vous demander à vos membres lorsqu\'ils s\'inscrivent à votre réseau? Vous pouvez réarranger les questions tout simplement en cliquant sur une question et en la traînant à l\'emplacement de votre choix.',
        'IF_YOU_SELECT_REQUIRED_MEMBERS_WILL' => 'Si vous sélectionnez « Obligatoire », les membres devront répondre à la question pour adhérer. Si vous sélectionnez « Privé », la réponse ne sera visible qu’à vous et à d’autres administrateurs.',
        'WE_COULD_NOT_FIND_ANYTHING' => 'Nous n\'avons pu trouvé de résultats correspondant au terme de recherche "%s". Pourquoi ne pas rechercher quelque chose d\'autre?',
        'GET_CUSTOM_URL' => 'Obtenir votre propre adresse URL, ajouter plus d\'espace mémoire et de bande passante (bandwidth) ou bien incoporer vos propres publicités.',
        'TRACK_STATISTICS' => 'Enquêtes Statistiques',
        'TRACKING_CODE' => 'Code de Pistage',
        'ANY_JAVASCRIPT_CODE' => 'Tout code JavaScript que vous collez ici est inséré en bas de chaque page de votre réseau. Vous pouvez l’utiliser pour les systèmes de pistage de site externe tels que Google Analytics.',
        'ANALYTICS_LEARN_MORE' => 'Pour en apprendre plus à propos de Google Analytics et créer votre propre compte, <a %s>cliquer ici</a>.',
        'RESOURCES' => 'Ressources',
        'LINKS' => 'Liens',
        'PAGE' => 'Page',
        'BACKGROUND' => 'Fond',
        'TEXT' => 'Texte',
        'HEADING_TEXT' => 'Texte d\'en-tête',
        'FONT' => 'Police',
        'AABBCC' => 'AaBbCc',
        'COLOR' => 'Couleur',
        'LINK_COLOR' => 'Couleur des liens',
        'BODY_TEXT' => 'Texte du corps',
        'MIDDLE' => 'Milieu',
        'FEATURE_BOXES' => 'Boîtes de fonctionnalité',
        'TITLEBAR_TEXT_COLOR' => 'Couleur du texte de la barre titre',
        'TITLEBAR_BACKGROUND' => 'Couleur de fond de la barre titre',
        'UPLOADING_CONTENT' => 'Téléchargement du contenu!',
        'WHEN_UPLOADING_IS_COMPLETE' => 'Lorsque le téléchargement sera terminé, vous pourrez accéder au réseau.',
        'FINISH' => 'Terminer',
        'FLICKR_IMPORT_SETUP' => 'Paramètres d\'importation de chez Flickr',
        'FLICKR_API_KEY' => 'Votre clé',
        'FLICKR_SECRET' => 'Votre secret',
        'FLICKR_KEY_ERROR' => 'Il y a un problème avec la clé (Flickr key) ou le secret. Veuillez vérifier et les entrer à nouveau.',
        'FLICKR_INTRO' => 'Vous voulez permettre à vos membres d\'importer leurs photos de chez Flickr? Vous êtes au bon endroit. Si vous avez déjà une clé (Flickr API Key) et un secret, vous pouvez <a %s>sauter à l\'étape suivante</a>. Si vous n\'êtes pas sûr, veuillez tout simplement suivre les étapes ci-dessous.',
        'FLICKR_GET_ACCOUNT' => 'Si vous n\'avez pas de compte Flickr, obtenez-en un <a %s>ici</a>.',
        'FLICKR_STEP1_TITLE' => 'Étape 1: Obtenir une clé de chez Flickr',
        'FLICKR_STEP1_APPLY_SCREEN' => 'Image: Faire une demande pour une Clé (API Key) sur Flickr',
        'FLICKR_STEP1_API_SCREEN' => 'Image: Clé (API Key) sur Flickr',
        'FLICKR_STEP1_INTRO' => 'Connectez-vous à Flickr et <a %s>faites une demande pour une nouvelle clé (API key)</a> (s\'ouvre dans une autre fenêtre).',
        'FLICKR_STEP1_A' => 'Entrez votre nom (<strong>Votre nom</strong>) et Adresse Électronique (<strong>Adresse électronique</strong>).',
        'FLICKR_STEP1_B' => 'Dans la section <strong>Cette touche sert à &hellip;...</strong>, cochez l\'option <em>l\'usage non-commercial</em>.',
        'FLICKR_STEP1_C' => 'Décrivez votre réseau social dans la boîte <strong>Décrire l\'application que vous planifiez créer</strong>.',
        'FLICKR_STEP1_D' => 'Cochez les deux cases de consentement.',
        'FLICKR_STEP1_APPLY' => 'Cliquez sur le bouton <strong>Appliquer</strong> lorsque vous avez terminé.',
        'FLICKR_STEP1_E' => 'Vous allez atterrir sur la page montrant votre nouvelle Clé API. Cliquez sur le lien <strong>Cliquez ici</strong> pour configurer les paramètres d\'authentification de la clé.',
        'FLICKR_STEP2_TITLE' => 'Étape 2: Établissement de la clé',
        'FLICKR_STEP2_SETUP_SCREEN' => 'Image: Établissement de la clé (API Key) sur Flickr',
        'FLICKR_STEP2_SAVE_CHANGES' => 'Lorsque vous avez terminé, cliquez sur le bouton <strong>Sauvegarder modifications</strong>.',
        'FLICKR_STEP3_TITLE' => 'Étape 3: Entrer votre information',
        'FLICKR_STEP3_KEYS_SCREEN' => 'API Key information screen on Flickr',
        'FLICKR_STEP3_CONGRATULATIONS' => 'Félicitations! Vous avez terminé le processus avec Flickr.',
        'FLICKR_STEP3_COMPLETE' => 'Pour compléter le processus, veuillez simplement copier et coller la clé et le secret dans les champs ci-dessous:',
        'COMPLETE_SETUP' => 'Compléter processus',
        'SETUP_YOUR_SITE_TO' => 'Mettre en place le méchanisme permettant l\'importation de photos de chez Flickr.',
        'FLICKR_IMPORTING' => 'Importation Flickr',
        'YOUVE_SIGNED_OUT_OF_X' => 'Vous vous êtes déconnecté avec succès du réseau « %s ». Veuillez revenir nous voir très bientôt!',
        'CREATED_THIS_SOCIAL_NETWORK' => 'A créé ce réseau social à <a href=\'http://www.ning.com\'>Ning</a>.',
        'CREATE_YOUR_OWN' => 'Créez gratuitement votre propre réseau social avec Ning!',
        'DRAG_HERE_TO_REMOVE_FEATURE' => 'Traînez ici pour enlever la fonctionnalité',
        'LAYOUT' => 'Présentation',
        'DRAG' => 'Traîner',
        'HERE' => 'Ici',
        'YOU' => 'Vous',
        'ADS' => 'Publicités',
        'MEMBERS' => 'Membres',
        'HELLO_USERNAME' => 'Bonjour, nom d’utilisateur',
        'CREATED_BY' => 'Créé par',
        'SAVE_FEATURES' => 'Sauvegarder les fonctionnalités',
        'FORUM' => 'Forum',
        'CATEGORIES' => 'Catégories',
        'FORUM_CATEGORIES' => 'Catégories du forum',
        'A_THREADED_DISCUSSION_FORUM' => 'Un forum de discussion',
        'ALLOW_MEMBERS_TO_CREATE_GROUPS' => 'Permettre aux membres de créer leurs propres groupes sur votre réseau',
        'FEATURE_POSTS_FROM_YOUR_BLOG' => 'Mettez en primeur les entrées de votre blogue ou des blogues des autres membres',
        'TEXT_BOX' => 'Boîte textuelle',
        'PUT_ANY_TEXT_WIDGET_OR_HTML' => 'Mettre tout texte, widget ou HTML sur la page principale',
        'A_LIST_OF_MEMBERS' => 'Une liste des membres de votre réseau social',
        'ALLOW_USERS_PHOTOS' => 'Permettre aux gens de télécharger et partager des photos',
        'ADD_FEEDS_FROM_ACROSS_THE_WEB' => 'Ajouter des éléments venant de partout sur Internet',
        'INFORMATION_ABOUT_THE_USER' => 'À propos de la personne actuellement connectée',
        'ALLOW_USERS_VIDEOS' => 'Permettre aux gens de télécharger et partager des vidéos',
        'SHOW_NETWORK_DESCRIPTION' => 'Montrer la description de votre réseau',
        'PROMOTE_NETWORK_WITH_BADGES' => 'Faites la promotion de votre réseau à travers internet avec des insignes et widgets',
        'MONETIZE_WITH_ADS' => 'Monétiser votre réseau à l’aide de la publicité',
        'LET_MEMBERS_KNOW_WHO_CREATED_NETWORK' => 'Laisser vos membres savoir qui a créé ce réseau',
        'FOLLOW_LATEST_ACTIVITY' => 'Suivre l\'Activité récente de membre de votre réseau',
        'FAQ_FOR_NETWORK_CREATORS' => 'Foire aux questions',
        'ANSWERS_TO_FAQS' => 'Réponses aux questions les plus fréquentes par rapport à la personnalisation de votre réseau social.',
        'MEET_OTHER_LIKEMINDED' => 'Rencontrer d\'autres créateurs de réseaux, partager des idées et obtenir le support de l\'équipe de Ning.',
        'CUSTOMIZE_THE_APPEARANCE_NETWORK' => 'Personnalisez l\'apparence de votre réseau social en ajoutant votre propre code CSS dans le champs à gauche. (<a href="%s">Qu\'est-ce qu\'un code CSS?</a>)',
        'CUSTOMIZE_THE_APPEARANCE_PAGE' => 'Personnaliser l’apparence de votre page en ajoutant vos propres Feuilles de Style en Cascade (FSC) dans le champ de gauche. (<a href="%s">Qu\'est-ce qu\'un FSC?</a>)',
        'CSS_ON_YOUR_SOCIAL_NETWORK' => 'Code CSS pour votre réseau social',
        'CSS_ON_YOUR_PAGE' => 'FSC pour votre page',
        'ADDING_YOUR_OWN_CSS_NETWORK' => 'En ajoutant votre propre code CSS, vous avez le contrôle total sur les polices de caractères, couleurs, espacements et le style général de votre réseau.',
        'ADDING_YOUR_OWN_CSS_PAGE' => 'Ajouter votre propre FSC à votre page vous donne le contrôle total sur les polices, la couleur, l’espacement et le style général de votre page.',
        'CSS_STYLES_WILL_OVERRIDE' => 'Le code CSS ajouté ici va supplanter tout style CSS choisi auparavant.',
        'NEED_HELP_FIGURING_OUT_CSS' => 'Vous avez du mal à trouver le nom d\'une classe CSS spécifique? Nous vous recommandons la fonction « Inspect » de l\'extension <a href="%s">Firebug</a> pour le fureteur Firefox.',
        'WANT_TO_LEARN_MORE' => 'Vous voulez en apprendre d\'avantage? Allez lire la section <a href="%s">Personnalisation Approfondie</a>.',
        'APPLY_XS_THEME' => 'Utiliser le thème du réseau « %s »',
        'X_ALREADY_REGISTERED_Y_TO_RESET' => 'Il y a déjà un Ning ID d\'enregistré avec l\'adresse électronique %s. Veuillez vous connecter ci-dessous avec votre Ning ID ou adresse électronique. Si vous avez oublié votre mot de passe, <a href="%s">cliquez ici pour réinitialiser votre mot de passe</a>.',
        'INVITED' => 'Invité',
        'REQUESTED_INVITE' => 'A fait une Demande d\'Invitation',
        'BAN_FROM_NETWORK' => 'Bannir du réseau',
        'REMOVE_BAN' => 'Annuler le Bannissement',
        'CANCEL_INVITATION' => 'Annuler l\'Invitation',
        'IGNORE' => 'Ignorer',
        'PROMOTE_TO_ADMINISTRATOR' => 'Promouvoir comme Administrateur',
        'DEMOTE_FROM_ADMINISTRATOR' => 'Révoquer Administrateur',
        'STATUS' => 'État',
        'DATE_JOINED' => 'Joint le',
        'DATE_INVITED' => 'Invité le',
        'DATE_REQUESTED' => 'Requête faite le',
        'DATE_APPLIED' => 'Appliqué le',
        'NETWORK_CREATOR' => 'Créateur du Réseau',
        'NETWORK_ADMINISTRATOR' => 'Administrateur',
        'ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Les administrateurs ont le même niveau de contrôle que le créateur du réseau.',
        'DOWNLOAD_ALL_MEMBER_DATA' => 'Exporter Toutes les Données de Membre (.CSV)',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Vos Données de Membre ont été exportés.  Cliquer du droit sur <a %s>ce lien</a> et choisir \'Save As\' pour les sauvegarder dans votre ordinateur.',
        'CLICK_GO_TO_START_EXPORT' => 'Cliquer sur Aller à pour démarrer l’exportation. Si vous avez de nombreux membres, le processus pourrait prendre quelques minutes.',
        'MEMBER' => 'Membre',
        'INVITED_BY_X' => 'Invité par %s',
        'DONE' => 'Fini',
        'YOU_HAVE_BEEN_BANNED_FROM_APPNAME' => 'Vous avez été banni du réseau %s',
        'MESSAGE_TO_ADMINISTRATOR' => 'Message pour l’Administrateur',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS_IF_YOU_THINK' => 'Désolé, %s, vous ne pouvez accéder à %s puisque vous avez été exclu. Si vous pensez avoir été exclu par erreur, vous pouvez contacter l’Administrateur.',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS' => 'Désolé, %s, vous ne pouvez accéder à %s puisque vous avez été exclu.',
        'SORRY_USERNAME' => 'Désolé, %s',
        'PENDING' => 'En attente',
        'ACCEPT' => 'Accepter',
        'PENDING_APPROVAL' => 'En Attente d’Approbation',
        'ACCEPT_MEMBERSHIP' => 'Accepter l’Adhésion',
        'DECLINE_MEMBERSHIP' => 'Refuser l’Adhésion',
        'NO_PAGE_YET' => 'Aucune Page Encore',
        'YOUR_MEMBERSHIP_TO_X_IS_PENDING_APPROVAL' => 'Votre adhésion à %s est en attente d’approbation des administrateurs.',
        'MEMBERSHIP_PENDING_APPROVAL' => 'Adhésion en attente d’autorisation',
        'YOUR_PROFILE_IS_PENDING_APPROVAL' => 'Votre profil est en Attente d’Adhésion',
        'YOUR_PROFILE_DETAILS_MUST_BE_APPROVED_ON_X' => 'Vos détails de profil doivent être approuvés par l’Administrateur avant que vous ne puissiez être membre de %s. Vous recevrez un courriel dès que votre profil est approuvé.',
        'CONTINUE_ARROW' => 'Continuer →',
        'LARR_BACK_TO_PENDING_MEMBERS' => '← Retour au Membres en Attente',
        'X_IS_AWAITING_APPROVAL_TO_BECOME_MEMBER_OF_Y' => '%s attend l’approbation pour devenir un membre de %s.',
        'VIEW_PAGE' => 'Voir la page',
        'MESSAGE' => 'Message',
        'SEND_MESSAGE' => 'Envoyer Message',
        'MANAGE_FORUM_CATEGORIES' => 'Gérer les catégories du forum',
        'START_DISCUSSIONS' => 'Démarrer les discussions',
        'WELCOME_TO_YOUR_NEW_SOCIAL_NETWORK' => 'Bienvenue dans votre nouveau réseau social',
        'NOW_ALL_YOU_NEED_TO_DO_IS_INVITE_YOUR_FRIENDS' => 'Tout ce que vous avez à faire est <a %s>d’inviter vos ami(e)s</a>!',
        'CONTRIBUTE' => 'Contribuer.',
        'CUSTOMIZE_APPEARANCE_BADGES' => '<strong>Personnaliser.</strong> Ajuster <a %1$s>l’apparence du réseau</a> et les <a %2$s>insignes et widgets</a>.',
        'CONTROL_MANAGE_PAGE' => '<strong>Contrôler.</strong>  La page <a %s>gérer</a> contient une série d\'options de configuration.',
        'CREATE_GROUPS' => 'Créer des groupes',
        'INVITE_MORE_PEOPLE' => 'Inviter d\'autres personnes...',
        'VIEW_THREAD' => 'Voir Fil de Discussions',
        'COMMENT_THREAD' => 'Fil de commentaires',
        'COMMENT_BACK' => 'Répondre',
        'HELLO_YOU_NEED_TO_ENABLE_JAVASCRIPT' => 'Bonjour, vous devez activer JavaScript afin de pouvoir accéder à ce réseau.',
        'PLEASE_CHECK_YOUR_BROWSER_SETTINGS' => 'Veuillez vérifier les paramètres de votre fureteur ou contacter votre administrateur de système.',
        'MANAGE_MEMBERS_ADMINS_INVITED' => 'Gérer les membres, les administrateurs, les invités et les exclusions.',
        'MANAGE_MEMBERS' => 'Gérer membres',
        'MANAGE_INVITED_PEOPLE' => 'Gérer Personnes Invitées',
        'NETWORK_SETTINGS' => 'Paramètres du réseau',
        'PROMOTE_YOUR_NETWORK' => 'Promouvoir votre réseau',
        'NING_RESOURCES' => 'Ressources Ning',
        'ADD_PREMIUM_SERVICES' => 'Ajouter des Services Premium',
        'REQUEST_SOURCE_CODE' => 'Requête du Code Source',
        'REQUEST_A_COPY_OF_THE_SOURCE_CODE' => 'Faire une demande pour obtenir une copie du code source de votre réseau.',
        'JOIN_NETWORK_CREATORS' => 'Créateurs de réseaux',
        'SEND_MESSAGE_TO_ALL_THIS' => 'Envoyer un message à tous les membres de ce réseau.',
        'CREATE_ANOTHER_NETWORK' => 'Créer un autre réseau',
        'HAVE_ANOTHER_GREAT_IDEA' => 'Vous avez une idée de génie pour un autre Réseau Social?',
        'ALLOW_FACEBOOK_USERS_TO' => 'Permettre aux utilisateurs de Facebook de placer les widgets provenant de votre réseau sur leurs pages de profil.',
        'BADGES_AND_WIDGETS' => 'Insignes et widgets',
        'CUSTOMIZE_WIDGETS_AND_BADGES' => 'Personnaliser l\'apparence des insignes et widgets de votre réseau.',
        'GET_BADGES' => 'Obtenir des insignes',
        'CUSTOM_TEXT' => 'Texte personnalisé',
        'IM_A_MEMBER_OF' => 'Je suis un membre du réseau:',
        'DONT_DISPLAY_ANY_BRANDING' => 'Ne pas afficher de marque',
        'WATERMARK_OR_LOGO_IMAGE' => 'Filigrane ou image de logo :',
        'NETWORK_BRANDING_BADGES' => 'Marque de réseau : insignes',
        'NETWORK_BRANDING_WIDGETS' => 'Marque de réseau : widgets',
        'LOGO_IMAGE' => 'Image de logo',
        'SMALL_NETWORK_BADGE' => 'Petit insigne de réseau',
        'LARGE_NETWORK_BADGE' => 'Grand insigne de réseau',
        'REFRESH' => 'Rafraîchir',
        'HTML_EMBED_CODE' => 'Code d\'incrustation HTML :',
        'CUSTOMIZE' => 'Personnaliser',
        'SHARE_TITLE' => 'Partager \'%s\'',
        'SHARE_TYPE' => 'Partager %s',
        'YOUR_MESSAGE_SENT' => 'Votre message a été envoyé avec succès.',
        'YOUR_MESSAGES_SENT' => 'Vos messages ont été envoyés avec succès.',
        'YOU_CAN_SHARE_TYPE_TWO_WAYS' => 'Vous pouvez partager cette %s de deux manières&#8230;',
        'CHECK_OUT_X_ON_Y_ELLIPSIS' => 'Jetez un coup d\'oeil à "%1$s" sur %2$s…',
        'CHECK_OUT_THIS_X_ON_Y_ELLIPSIS' => 'Jetez un coup d\'oeil à ce %1$s sur %2$s…',
        'PHOTO_ALBUM' => 'album photo',
        'CUSTOMIZE_YOUR_BADGES_AND_WIDGETS' => 'Personnalisez vos insignes et widgets avec votre propre choix de couleurs et d\'images. Vos modifications peuvent prendre jusqu\'à 4 heures avant d\'être reflétées sur d\'autres sites web.',
        'BACKGROUND_IMAGE_AND_COLOR' => 'Image de fond et couleur',
        'USE_THIS_FORM_TO_REPORT_ISSUE_TO_NC' => 'Utiliser ce formulaire pour signaler tout problème à <a %s>%s</a>, le créateur de <a %s>%s</a>.',
        'SEND_MESSAGE_TO_FRIENDS' => 'Envoyer le message aux amis',
        'SORRY_NCS_CANNOT_CHANGE_EMAIL' => 'Désolé, les créateurs de réseau ne peuvent modifier leurs adresses électroniques à travers les réseaux qui ne leur appartiennent pas.',
        'SORRY_NCS_CANNOT_CHANGE_PASSWORD' => 'Désolé, les créateurs de réseau ne peuvent modifier leurs adresses électroniques à travers les réseaux qui ne leur appartiennent pas.',
        'GO' => 'Allez',
        'LARGE_THUMBNAILS' => 'Grande Imagettes',
        'SMALL_THUMBNAILS' => 'Petites Imagettes',
        'RECENTLY_JOINED' => 'Nouveaux',
        'MOST_POPULAR_MEMBERS' => 'Les plus populaires',
        'BOX_WILL_NOT_SHOW_MEMBERS' => 'Cette boîte ne va pas être affichée à moins que vous ne sélectionniez au moins une rangée.',
        'DETAIL_VIEW' => 'Vue détaillée',
        'TITLES_ONLY' => 'Titres seulement',
        'RECENTLY_ADDED_POSTS' => 'Ajouté(e)(s) récemment',
        'POPULAR_POSTS' => 'Avec le plus de commentaires',
        'PROMOTED_POSTS' => 'En Primeur',
        'BOX_WILL_NOT_SHOW_BLOG_POST' => 'Cette boîte ne va pas être affichée à moins que vous ne sélectionniez au moins une entrée.',
        'KEEP_WINDOW_OPEN_UPLOAD' => 'Veuillez garder cette fenêtre ouverte pendant le téléchargement.',
        'CANCEL_UPLOAD' => 'Annuler Téléchargement',
        'YOU_DO_NOT_HAVE_POSTS' => 'Vous n\'avez pas encore rédigé d\'entrées de blogue.',
        'YOU_DO_NOT_HAVE_COMMENTS' => 'Vous n\'avez pas de commentaires à autoriser.',
        'REQUIRED_FIELD' => '(Champ Requis)',
        'BLOG_POST_BY_X' => 'Entrée de blogue par %s',
        'HELLO' => 'Bonjour,',
        'ADDED_BY_X' => 'Ajouté(e)(s) par %s',
        'CLICK_TO_ADD_A_TITLE' => 'cliquer ici pour ajouter un titre',
        'DELETE_BLOG_POST' => 'Supprimer l\'entrée',
        'DELETE_THIS_BLOG_POST_Q' => 'Supprimer l\'entrée de blogue?',
        'ARE_YOU_SURE_DELETE_THIS_BLOG_POST' => 'Êtes-vous sûr de vouloir supprimer cette entrée de blogue? Ce processus peut prendre quelques minutes.',
        'SPINNER' => 'Spinner',
        'PLEASE_ENTER_SOMETHING_FOR_X' => 'Veuillez entrer quelque chose pour: %s',
        'PLEASE_SELECT_OPTION_FOR_X' => 'Veuillez choisir une option pour: %s',
        'PLEASE_PROVIDE_VALID_DATE_FOR_X' => 'Veuillez fournir une date valide pour: %s',
        'PLEASE_PROVIDE_DATE_FOR_X' => 'Veuillez fournir une date pour: %s',
        'XS_BLOG_POSTS_FOR_M_Y' => 'Les entrées de blogue de %s pour %s %s',
        'FEATURED_BLOG_POSTS_FOR_M_Y' => 'Les entrées de blogue en primeur pour %s %s',
        'BLOG_POSTS_FOR_M_Y' => 'Entrées de blogue pour %s %s',
        'FEATURED_BLOG_POSTS' => 'Entrées de blogue en primeur',
        'EVERYONES_POSTS' => 'Les entrées de blogue de tout le monde',
        'PUBLISHED_N_OF_N' => 'Publication %d de %d',
        'DOWNLOAD_X' => 'Télécharger %s',
        'UPLOAD_DID_NOT_WORK' => 'Désolé, ce téléchargement n\'a pas fonctionné',
        'F_J_Y' => 'F j, Y',
        'M_J_Y' => 'j M Y',
        'XS_POSTS' => 'Les entrées de %s',
        'USERNAMES_COMMENTS' => 'Commentaires de %s',
        'ADD_COMMENT' => 'Ajouter Commentaire',
        'XS_PAGE' => 'Page de(d\') %s',
        'XS_BLOG' => 'Blogue de %s',
        'XS_FRIENDS' => 'Amis de %s',
        'VIEW_XS_ELLIPSIS' => 'Voir %s\'s…',
        'DRAFT_BRACKETS' => '[ Brouillon ]',
        'FEATURED' => 'En Primeur',
        'MY_POSTS' => 'Mes entrées',
        'MY_POSTS_ONLY' => 'Mes entrées seulement',
        'OWNER_POSTS_ONLY' => 'Les entrées du créateur seulement',
        'JANUARY' => 'Janvier',
        'FEBRUARY' => 'Février',
        'MARCH' => 'Mars',
        'APRIL' => 'Avril',
        'MAY' => 'Mai',
        'JUNE' => 'Juin',
        'JULY' => 'Juillet',
        'AUGUST' => 'Août',
        'SEPTEMBER' => 'Septembre',
        'OCTOBER' => 'Octobre',
        'NOVEMBER' => 'Novembre',
        'DECEMBER' => 'Décembre',
        'MY_COMMENTS' => 'Mes commentaires',
        'AM' => 'AM',
        'PM' => 'PM',
        'MY_PAGE' => 'Ma page',
        'MY_PAGE_TAB_TEXT' => 'Ma page',
        'BLOG_POSTS' => 'Entrées de blogue',
        'MY_BLOG' => 'Mon blogue',
        'MONTH' => 'Mois',
        'DAY' => 'Jour',
        'PICK_VALID_DEFAULT_VISIBILITY' => 'Veuillez sélectionner un choix valide pour la visibilité par défaut',
        'PICK_VALID_WHO_CAN_COMMENT' => 'Veuillez sélectionner un choix valide pour qui peut laisser un commentaire',
        'PICK_VALID_BLOG_COMMENT_MODERATION' => 'Veuillez sélectionner un choix valide pour la modération du blogue',
        'PICK_VALID_ACTIVITY_NOTIFICATION' => 'Veuillez sélectionner un choix valide pour la notification d\'activité',
        'PICK_VALID_MODERATION_NOTIFICATION' => 'Veuillez sélectionner un choix valide pour la notification de modération',
        'PICK_VALID_APPROVAL_NOTIFICATION' => 'Veuillez sélectionner un choix valide pour la notification d\'autorisation',
        'PICK_VALID_INVITEE_NOTIFICATION' => 'Veuillez sélectionner un choix valide pour la notification de nouveaux membres',
        'PICK_VALID_NEVER_NOTIFICATION' => 'Veuillez sélectionner un choix valide pour la notification pour la réception de notifications',
        'PICK_VALID_ALL_FRIENDS_NOTIFICATION' => 'Veuillez sélectionner un choix valable pour la notification de nouveaux messages envoyés à tous les amis',
        'PICK_VALID_FRIEND_REQUEST_NOTIFICATION' => 'Veuillez sélectionner un choix valide pour la notification de requêtes d\'amitié',
        'PICK_VALID_NEW_MESSAGE_NOTIFICATION' => 'Veuillez sélectionner un choix valide pour la notification de nouveaux messages',
        'APPROVE_COMMENT' => 'Autoriser Le Commentaire',
        'MANAGE_BLOG' => 'Gérer Blogue',
        'COMMENTS_POSTED_ON_BLOG' => 'Commentaires publiés sur mon blogue',
        'COMMENT' => 'Commentaire',
        'COMMENTER' => 'Commenter',
        'POST' => 'Entrée',
        'M_J_Y_G_IA' => 'j M, Y, g:ia',
        'POST_HAS_BEEN_DELETED' => 'L\'entrée a été supprimée',
        'COMMENTS_ARE_CLOSED' => 'Les commentaires ne sont pas permis sur cette entrée de blogue',
        'NO_COMMENTS' => 'Aucun commentaire',
        'FLAG' => 'Signaler',
        'POST_TITLE' => 'Titre de l\'entrée',
        'DRAFT_PARENTHESES' => '(Brouillon)',
        'SCHEDULED_TO_PUBLISH_ON' => 'Publication prévue pour le: %s',
        'EDIT_2' => 'modifier',
        'NONE' => 'Aucune',
        'N_NEW' => '%s Nouveau(s)',
        'NO_POSTS' => 'Aucune entrée',
        'ADD_NEW_BLOG_POST' => 'Ajouter un nouveau entrée à mon blogue',
        'HAPPY' => 'Joyeux',
        'SAD' => 'Triste',
        'COOL' => 'Cool',
        'EVIL' => 'Diabolique',
        'MAD' => 'Furieux',
        'ENVIOUS' => 'Envieux',
        'ENTRY' => 'Entrée',
        'WHAT_DATE_FOR_YOUR_POST' => 'À quelle date voulez-vous publier l\'entrée?',
        'NOW' => 'Maintenant',
        'CHOOSE_DATE_AND_TIME' => 'Choisissez une date et une heure (si vous choisissez un temps ultérieur, votre entrée va être publiée à ce temps)',
        'PRIVACY_AND_COMMENTS' => 'Confidentialité et commentaires',
        'WHO_CAN_VIEW_POST' => 'Qui peut voir cette entrée?',
        'EVERYONE' => 'Tout public',
        'ALLOW_COMMENTS' => 'Permettre l\'ajout de commentaires à cette entrée?',
        'YES' => 'Oui',
        'NO' => 'Non',
        'COMMENT_MODERATION' => 'Modération des commentaires',
        'SAVE_AS_DRAFT' => 'Sauvegarder comme Brouillon',
        'PREVIEW' => 'Prévisualiser',
        'PUBLISH_POST' => 'Publier l\'entrée',
        'BACK' => 'Retourner',
        'PUBLISH' => 'Publier!',
        'BLOG_POST' => 'Entrée de blogue',
        'PROFILE' => 'Profil',
        'WILL_BE_PUBLISHED_ON_X' => 'Va être publié le %s <small>%s</small>',
        'POSTED_ON_X' => 'Publié le %s <small>%s</small>',
        'POSTED_ON_X_BY' => 'Publié (le) <strong>%s</strong> <small>%s</small> par:',
        'ABOUT_THIS_POST' => 'À propos de cette entrée',
        'ABOUT_YOUR_POST' => 'À propos de votre entrée',
        'ADDED_BY' => 'Ajouté par:',
        'JUST_FRIENDS' => 'Juste mes Amis',
        'RECENT_POSTS' => 'Entrées récentes',
        'THERE_ARE_NO_RECENT_POSTS' => 'Il n\'y a pas d\'entrées récentes.',
        'YOUR_COMMENT_HAS_BEEN_ADDED_BUT' => 'Votre commentaire a été ajouté mais il doit être autorisé avant que les gens puissent le voir.',
        'AT_TIME_ON_DATE_USERNAME_SAID' => 'À %s le %s, %s a dit...',
        'X_DOES_NOT_HAVE_ANY_FRIENDS' => '%s n\'a pas encore d\'amis sur le réseau.',
        'YOU_DO_NOT_HAVE_ANY_FRIENDS' => 'Vous n’avez pas encore d’ami(e)s sur ce réseau social.',
        'EDIT_PAGE_APPEARANCE' => 'Modifier l’apparence de la page',
        'VIEW_PAGE_AS_OTHERS' => 'Voir la page comme les autres la voient',
        'ADD_BLOG_POST' => 'Ajouter une entrée à mon blogue',
        'BAN_MEMBER_FROM_NETWORK' => 'Bannir le membre du réseau',
        'BAN_USERNAME' => 'Bannir %s?',
        'BLOCK' => 'bloquer',
        'CREATE_NEW_BLOG_POST' => 'Créer une nouvelle entrée de blogue!',
        'EDIT_POST' => 'Modifier l\'entrée',
        'EDIT_POST_COLON' => 'Modifier l\'entrée :',
        'CONTINUE_READING' => 'Continuer à lire...',
        'POSTED_BY_ME_LINK_ON_X_AT_X' => 'Publié par <a %s>moi</a> le %s à %s —',
        'POSTED_BY_X_ON_X_AT_X' => 'Publié par %s le %s à %s —',
        'POSTED_BY_ME_ON_X_AT_X' => 'Publié par moi le %s à %s —',
        'ADD' => 'Ajouter',
        'SUBSCRIBE' => 'Inscription',
        'VIEW_ARCHIVES' => 'Voir Archives',
        'YOUR_SETTINGS_HAVE_BEEN_SAVED' => 'Vos paramètres ont été sauvegardés.',
        'PLEASE_CORRECT_THE_FOLLOWING' => 'Veuillez corriger les choses suivantes:',
        'PRIVACY' => 'Confidentialité',
        'NETWORK_PRIVACY' => 'Confidentialité du Réseau',
        'THIS_NETWORK_VISIBLE_TO_EVERYONE' => 'Ce réseau est <strong>visible par tous</strong>.',
        'ANYONE_CAN_SIGN_UP_VISITORS_CAN' => 'Tout le monde peut devenir membre. Les visiteurs le peuvent !',
        'SEE_EVERYTHING' => 'Voir tout',
        'SEE_JUST_THE_MAIN_PAGE' => 'Voir seulement la page principale',
        'SEE_JUST_THE_SIGN_UP_PAGE' => 'Voir seulement la page d\'inscription',
        'THIS_NETWORK_VISIBLE_MEMBERS_ONLY' => 'Ce réseau est <strong>visible pour les membres seulement</strong>.',
        'WHO_CAN_SIGN_UP' => 'Qui peut devenir membre?',
        'MODERATION' => 'Modération',
        'APPROVE_MEMBERS_BEFORE_JOIN' => 'Approuver les nouveaux membres avant leur adhésion',
        'APPROVE_PHOTOS_VIDEOS' => 'Approuver les photos et vidéos avant leur apparition',
        'SHOW_LATEST_ACTIVITY_ON_YOUR_NETWORK' => 'Montrer l\'Activité récente sur votre réseau!',
        'PUT_A_CONSTANTLY_UPDATED_STREAM' => 'Mettre un flux constamment mis à jour d\'activités récentes sur la page principale de votre réseau.',
        'CLICK_HERE_TO_ADD_LATEST_ACTIVITY' => 'Cliquer ici pour ajouter l\'Activité récente de votre réseau.',
        'THESE_OPTIONS_ARE_DISABLED_ACTIVITY' => 'Ces options sont désactivées puisque vous n\'avez pas d\'Activité récente sur votre réseau.',
        'ACTIVITY' => 'Activité',
        'DISPLAY_PREFERENCES' => 'Afficher les préférences',
        'NEW_CONTENT' => 'Nouveau contenu',
        'NEW_COMMENTS' => 'Nouveaux commentaires',
        'NEW_MEMBERS' => 'Nouveaux membres',
        'MEMBER_UPDATES' => 'Mise à jour de membre',
        'WHAT_DISPLAYS_LATEST_ACTIVITY' => 'Afficher sur Activité récente',
        'LATEST_ACTIVITY' => 'Activité récente',
        'X_COMMENTED_ON_POST_TITLE' => '%1$s a répondu à la discussion %2$s',
        'X_LINK_COMMENTED_ON_POST_LINK_TITLE' => '%1$s <a %2$s>a répondu</a> à la discussion <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_POST_LINK_TITLE' => 'Vous <a %1$s>avez répondu</a> à la discussion <a %2$s>%3$s</a>',
        'X_COMMENTED_ON_BLOG_POST_TITLE' => '%1$s a publié un commentaire sur l\'entrée de blogue %2$s',
        'X_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '%1$s <a %2$s>a publié un commentaire</a> sur l\'entrée de blogue <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => 'Vous <a %1$s>avez publié un commentaire</a> sur l\'entrée de blogue <a %2$s>%3$s</a>',
        'X_STARTED_A_DISCUSSION_Y' => '%s a commencé une discussion appelée %s',
        'YOU_STARTED_A_DISCUSSION_Y' => 'Vous avez commencé une discussion appelée %s',
        'X_ADDED_THE_BLOG_POST_Y' => '%s a publié une entrée de blogue\'%s\'',
        'YOU_ADDED_THE_BLOG_POST_Y' => 'Vous avez publié une entrée de blogue\'%s\'',
        'X_JOINED_THE_GROUP_Y' => '%s s’est joint(e) au groupe %s',
        'YOU_JOINED_THE_GROUP_X' => 'Vous vous êtes joint(e) au groupe%s',
        'X_JOINED_Y_GROUPS' => '%s s’est joint(e) %s aux groupes',
        'YOU_JOINED_X_GROUPS' => 'Vous vous êtes joint(e) %s aux groupes',
        'X_JOINED_APPNAME' => '%s s’est joint(e) à %s',
        'WELCOME_MEMBER_N_OF_APPNAME' => 'Bienvenue, %1$s! Vous êtes membre #%2$s de %3$s.',
        'WELCOME_MEMBER_N_OF_APPNAME_INVITE' => 'Bienvenue, %1$s! Vous êtes membre #%2$s de %3$s. <a %4$s>Inviter les ami(e)s maintenant</a>.',
        'X_IS_MEMBER_N_OF_APPNAME' => '%1$s est membre #%2$s de %3$s.',
        'XS_PROFILE_CHANGED' => 'Profil de %s s’est modifié',
        'YOUR_PROFILE_CHANGED' => 'Votre profil s’est modifié',
        'X_LEFT_A_COMMENT_FOR_Y' => '%s a laissé un commentaire à %s',
        'YOU_LEFT_A_COMMENT_FOR_X' => 'Vous avez laissé un commentaire à %s',
        'X_LEFT_A_COMMENT_FOR_YOU' => '%s vous a laissé un commenatire',
        'X_CREATED_A_GROUP_Y' => '%s a créé un groupe appelé %s',
        'YOU_CREATED_A_GROUP_Y' => 'Vous avez créé un groupe appelé %s',
        'X_CREATED_Y_NEW_GROUPS' => '%s a créé %s de nouveaux groupes',
        'X_STARTED_Y_FORUM_POSTS' => '%s a démarré %s nouveaux forums de discussion',
        'YOU_STARTED_Y_FORUM_POSTS' => 'Vous avez démarré %s nouveaux groupes de discussions',
        'X_ADDED_Y_BLOG_POSTS' => '%s a publié %s nouvelles entrées de blogue',
        'YOU_ADDED_Y_BLOG_POSTS' => 'Vous avez publié %s nouvelles entrées de blogue',
        'YOU_COMMENTED_ON_PHOTO_TITLE' => 'Vous avez commenté la photo <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_PHOTO_TITLE' => '%s a commenté la photo <a %s>%s</a>',
        'YOU_COMMENTED_ON_VIDEO_TITLE' => 'Vous avez commenté la vidéo <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_VIDEO_TITLE' => '%s a commenté la vidéo <a %s>%s</a>',
        'VIEW_XS_BLOG_POSTS' => 'Voir les entrées de blogue par %s',
        'VIEW_YOUR_BLOG_POSTS' => 'Voir vos entrées de blogue',
        'APPNAME_HAS_NEW_PROFILE_QUESTIONS' => '%s a <a %s>nouvelles questions de profil</a>',
        'APPNAME_NOW_HAS_MUSIC' => '%s a maintenant un lecteur de musique',
        'APPNAME_NOW_HAS_GROUPS' => '%s a maintenant des <a %s>groupes</a>',
        'APPNAME_NOW_HAS_VIDEO' => '%s a maintenant des<a %s>vidéos</a>',
        'APPNAME_NOW_HAS_FORUM' => '%s a maintenant un <a %s>forum</a>',
        'APPNAME_NOW_HAS_PHOTO' => '%s a maintenant des <a %s>photos</a>',
        'DID_YOU_KNOW' => 'Saviez-vous',
        'ANNOUNCEMENT' => 'Annonce',
        'CONGRATULATIONS' => 'Félicitations',
        'YOU_CREATED_APPNAME' => 'Vous avez créé le réseau %s.',
        'USER_CREATED_APPNAME' => '%s a créé le réseau %s.',
        'ADD_MESSAGES_ACTIVITY_FEED' => 'Ajouter les messages et choisir ce qui s’affiche dans les activités du réseau.',
        'WHICH_OF_YOUR_ACTIONS_DISPLAY_ACTIVITY' => 'Parmi vos actions, lesquelles devraient être affichées dans Activité récente?',
        'NEW_CONTENT_I_ADD' => 'Nouveau contenu que j’ajoute',
        'NEW_COMMENTS_I_ADD' => 'Nouveaux commentaries que j’ajoute',
        'WHEN_I_UPDATE_MY_PROFILE' => 'Lorsque je mets à jour mon profil',
        'THE_LATEST_ACTIVITY_WILL_NEVER' => 'Activité récente n’affichera jamais les messages que vous envoyez, les pages ou membres que vous visionnez, les invitations que vous déclinez ou les choses que vous supprimez.',
        'YOU_HAVENT_DONE_ANYTHING_RECENTLY' => 'Vous n’avez pas d’activité récente. Pourquoi ne pas démarrer quelque chose?',
        'YOUVE_TURNED_OFF_THE_ACTIVITY_DISPLAY_CLICK' => 'Vous avez fermé l’affichage de votre activité. <a %s>Cliquer ici pour l’ouvrir de nouveau.</a>',
        'THE_NETWORK_CREATOR_HAS_TURNED_OFF_THE_ACTIVITY' => 'Le créateur de réseau a fermé l’affichage de toute activité.',
        'NO_ACTIVITY_TO_DISPLAY' => 'Il n\'y a actuellement aucune activité d\'affichée.',
        'BOX_WILL_NOT_SHOW_ACTIVITY' => 'Cette boîte ne se montrera pas à d’autres personnes à moins de sélectionner au moins un élément d’activité.',
        'NOTHING_IS_HAPPENING_ON_YOUR_NETWORK' => 'Il n\’y a pas d’activité récente. Pourquoi ne pas commencer quelque chose ?',
        'MY_ACTIVITY_PREFERENCES' => 'Mes préférences d’activité',
        'DELETE_ACTIVITY_ITEM' => 'Retirer le Message d’Activité',
        'DELETE_THIS_ACTIVITY_MESSAGE_Q' => 'Retirer ce message d’activité?',
        'THIS_WILL_PREVENT_ACTIVITY' => 'Cela empêchera quiconque de voir ce message d’activité',
        'X_HAS_POSTED_THE_MOST_PHOTOS' => '%1$s a publié le plus de %2$sphotos%3$s',
        'X_IS_THE_MOST_POPULAR_PHOTO' => '%s est la photo la plus populaire à ce jour',
        'X_HAS_POSTED_THE_MOST_VIDEOS' => '%1$s a publié le plus de %2$svidéos%3$s',
        'X_IS_THE_MOST_POPULAR_VIDEO' => '%s est la vidéo la plus populaire à ce jour',
        'X_HAS_POSTED_THE_MOST_MUSIC' => '%s a publié le plus de chansons',
        'X_IS_THE_MOST_POPULAR_MUSIC' => '%s a publié le plus de chanson à ce jour',
        'X_IS_THE_MOST_POPULAR_TOPIC' => '%s est l\'entrée de forum le plus populaire à ce jour',
        'X_IS_THE_MOST_POPULAR_BLOG_POST' => '%s est l\'entrée de blogue le plus populaire à ce jour',
        'XS_LATEST_ACTIVITY_ON_APPNAME' => '%s\'s Activité récente sur %s',
        'LATEST_ACTIVITY_ON_APPNAME' => 'Activité récente sur %s',
        'ADD_MESSAGE_TO_LATEST_ACTIVITY' => 'Ajouter un Message à Activité récente',
        'ADD_FACTS_ABOUT_THE_NETWORK_ELLIPSIS' => 'Ajouter des faits sur le réseau',
        'ADD_MESSAGE' => 'Ajouter Message',
        'ELLIPSIS_OR_WRITE_YOUR_OWN_MESSAGE' => '…ou écrire votre propre message',
        'NETWORK' => 'Réseau',
        'MODERATE_COMMENTS_ON_BLOG' => 'Voulez-vous autoriser les commentaires avant<br/>qu\'ils soient publiés sur votre blogue?',
        'YES_LET_ME_APPROVE' => 'Oui – Laissez-moi d’abord approuver les commentaires',
        'NO_PUBLISH_COMMENTS' => 'Non – Publier immédiatement les commentaires',
        'WHO_CAN_COMMENT_ON_PHOTOS_VIDEOS' => 'Qui peut laisser un commentaire sur mes photos,<br/>mes vidéos et mon blogue?',
        'SAVE' => 'Enregistrer',
        'EMAIL' => 'Adresse électronique',
        'YOUR_PRIVACY_IS_IMPORTANT' => 'Votre vie privée est importante pour nous. Si vous avez des questions sur vos notifications de courriels, veuillez nous envoyer une note à l’adresse <a href="http://help.ning.com/?page_id=27">Service à la clientèle</a>.',
        'ADD_PHOTOS_AND_VIDEOS_TO_X_BY_SENDING' => 'Ajoutez des photos et vidéos au réseau « %s » en les envoyant à l\'adresse suivante:',
        'ADD_PHOTOS_AND_VIDEOS_TO_APPNAME_FROM_PHONE' => 'Ajouter les photos et vidéos à %s de votre téléphone en les envoyant à cette adresse électronique :',
        'GENERATE_NEW_EMAIL_ADDRESS' => 'Générer une nouvelle adresse électronique',
        'SUPPORTS_TEXT_EMBEDDED' => 'Prend en charge texte, vidéos (incrustées), photos et « widgets »',
        'POST_COMMENT' => 'Publier un commentaire',
        'YOU_NEED_TO_BE_MEMBER_COMMENTS' => 'Vous devez être membre du réseau « %s » avant de pouvoir ajouter des commentaires!',
        'MONTHLY_ARCHIVES' => 'Archives Mensuelles',
        'NO_FRIENDS_ON_SITE' => 'Pas encore d\'amis sur ce réseau social.',
        'NO_FRIENDS_ON_SITE_THAT_MATCH' => 'Aucun ami sur ce réseau social ne correspond à votre recherche.',
        'MEMBERS_TAB_TEXT' => 'Membres',
        'SITE_HAS_NO_MEMBERS' => 'Ce réseau social n\'a pas encore de membres!',
        'SITE_HAS_NO_MEMBERS_THAT_MATCH' => 'Ce réseau social n\'a pas de membres correspondant à votre recherche.',
        'NO_COMMENTS_YET' => 'Pas encore de commentaires!',
        'VIEW_ALL_COMMENTS' => 'Voir tous les commentaires',
        'YOU_HAVE_NOT_ADDED_BLOG_POSTS' => 'Vous n\'avez pas encore ajouté d\'entrées à votre blogue!',
        'YOU_CAN_WRITE_ABOUT_ANYTHING' => 'Vous pouvez écrire à propos de tout et de rien ainsi que d\'y insérer vos vidéos (incrusté), photos et votre musique préférée.',
        'WRITE_YOUR_FIRST_ENTRY' => 'Rédigez votre première entrée!',
        'THERE_ARE_NO_X_THAT_MATCH_SETTINGS' => 'Il n\'y a pas de %s correspondant aux paramètres que vous avez sélectionnés.',
        'START_FEATURING_X_CLICK_Y' => 'Mettez en primeur les %s lorsque vous voyez l\'option « Mettre en Primeur ». Pour en apprendre plus à propos de cette option, <a %s>cliquez ici</a>.',
        'YOUR_FRIEND' => 'Votre Ami(e)',
        'REQUEST_SENT' => 'Requête Envoyée!',
        'BLOCKED' => 'Bloqué',
        'BANNED' => 'Banni',
        'ADD_YOUR_FIRST_BLOG_POST' => 'Ajouter la toute première entrée sur votre blogue',
        'MY_FIRST_BLOG_POST' => 'Ma première entrée de blogue!',
        'TELL_THE_PEOPLE_ON' => 'Raconter aux personnes sur %s davantage sur vous. Les questions marquées d\'un <span %s>verrou</span> sont privées et visibles des administrateurs uniquement.',
        'CHOOSE_A_THEME_FOR_PAGE' => 'Choisissez un thème pour votre page',
        'NOW_CUSTOMIZE_PAGE' => 'Personnaliser maintenant votre page!',
        'NO_POSTS_TO_DISPLAY' => 'Aucunes entrées à afficher.',
        'DATE_COLON' => 'Date:',
        'TIME_COLON' => 'Heure:',
        'CHANGE' => 'Changer',
        'UPLOAD_A_PHOTO' => 'Télécharger une photo',
        'OPTIONS' => 'Options',
        'PIXELS' => 'Pixels',
        'CANCEL' => 'Annuler',
        'UPLOAD_A_FILE' => 'Télécharger un fichier:',
        'TO_INSERT_A_FILE' => 'Pour insérer un fichier, cliquez sur le bouton « Naviguer » ou « Choisir » ci-dessus pour repérer le fichier sur votre ordinateur.',
        'UPLOADING' => 'Téléchargement...',
        'OK' => 'OK',
        'POPULAR_MEMBERS' => 'Membres Populaires',
        'INVITE_FRIENDS' => 'Invitez vos amis',
        'VIEW_ALL' => 'En voir plus',
        'REMOVE_X' => 'Enlever %s',
        'ARE_YOU_SURE_BAN_X_AND_CONTENT' => 'Êtes-vous sûr de vouloir bannir %1$s de votre réseau social et d\'effacer tout le contenu que %1$s a ajouté? Ce processus peut prendre quelques minutes.',
        'REMOVING_X' => 'Suppression de %s',
        'ARE_YOU_SURE_BAN_MEMBERS_AND_CONTENT' => 'Êtes-vous sûr de vouloir bannir les membres sélectionnés de votre réseau social et d\'effacer tout le contenu qu\'ils ont ajouté? Ce processus peut prendre quelques minutes.',
        'ARE_YOU_SURE_BAN_MEMBERS' => 'Êtes-vous sûr de vouloir supprimer les membres sélectionnés de votre réseau social? Ce processus peut prendre quelques minutes.',
        'BAN' => 'Bannir',
        'REMOVING_MEMBERS' => 'Suppression des Membres',
        'FEMALE' => 'Femme',
        'MALE' => 'Homme',
        'UNITED_STATES' => 'États-Unis',
        'AND' => 'et',
        'FROM' => 'de',
        'GENDER_M' => 'Homme',
        'GENDER_F' => 'Femme',
        'XS_PAGE_ON_Y' => 'La page de %s sur %s',
        'SEARCH_MEMBERS' => 'Recherche de membres',
        'SOMEBODY_COMMENTED_BLOGPOST_ADDED_TO_X' => 'quelqu\'un a ajouté un commentaire à une entrée de blogue que vous avez ajouté sur "%s"',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X' => 'Vous avez un nouveau commentaire sur votre page sur %s.',
        'A_BLOG_POST' => 'une entrée de blogue',
        'NOW_THAT_YOU_JOINED_INVITE' => 'Maintenant que vous avez adhéré, <strong><a %s>inviter vos ami(e)s</a></strong>!',
        'THIS_IS_YOUR_PAGE' => 'Ceci est votre page :',
        'START_BY_CUSTOMIZING_ITS_APPEARANCE' => 'Commencer par <a %s>personnaliser son apparence</a>.',
        'USE_IT_TO_KEEP_A_BLOG_AND_DISPLAY_YOUR_PROFILE_ANSWERS' => 'Utilisez-le pour <a %1$s>alimenter un blogue</a>, et afficher <a %2$s>vos réponses de profil</a>.',
        'START_CONTRIBUTING' => 'Démarrer votre contribution :',
        'UPLOAD_VIDEOS' => 'Télécharger des vidéos',
        'CONTRIBUTE_TO_DISCUSSIONS' => 'Contribuer aux discussions',
        'JOIN_GROUPS' => 'Prendre part aux groupes',
        'ADD_A_BLOG_POST' => 'Ajoutez une entrée à votre blogue',
        'CLICK_TO_ACCEPT_FRIENDS' => 'Cliquez ici pour voir vos requêtes d\'amitié.',
        'LEAVE_X' => 'Quitter %s',
        'LEAVE_X_Q' => 'Quitter %s?',
        'ARE_YOU_SURE_LEAVE_X' => 'Êtes-vous sûr(e) de vouloir quitter %s et supprimer tout votre contenu? Ce processus peut prendre plusieurs minutes.',
        'BACK_TO_USERNAMES_PAGE' => '&#8592; De retour à la page de %s',
        'BACK_TO_MY_PAGE' => '&#8592; Retour à Ma page',
        'COMMENT_WALL' => 'Mur de commentaires',
        'ONLINE' => 'En ligne',
        'MEMBER_IS_ONLINE' => 'Le membre est en ligne',
        'ONLINE_NOW' => 'En ligne maintenant',
        'CHOOSE_WHO_CAN_SEE_JOIN_AND_CONTRIBUTE' => 'Choisir qui peut voir, adhérer à et contribuer à votre réseau.',
        'EMAIL_NOTIFICATIONS' => 'Notifications courriel',
        'WHAT_NETWORK_ACTIVITY_EMAIL_FOR' => 'Pour quelle activité de réseau voulez-vous recevoir un avis?',
        'NETWORK_MESSAGES' => 'Messages de Réseau',
        'MEMBER_ACTIVITY' => 'Activité de Membre',
        'APPROVAL' => 'Approbation',
        'FRIEND_REQUESTS' => 'Requêtes d’ami(e)',
        'PEOPLE_IVE_INVITED_JOIN' => 'Des personnes que j’ai invitées à joindre ce réseau',
        'MESSAGES_SENT_TO_ME' => 'Messages qui m\'ont été envoyés',
        'MESSAGES_SENT_TO_GROUPS' => 'Messages envoyés aux groupes auxquels j’appartiens',
        'MESSAGES_SENT_TO_NETWORK' => 'Messages envoyés au réseau entier',
        'MESSAGES_SENT_TO_ALL_FRIENDS' => 'Les messages envoyés à tous les amis',
        'I_HAVE_NEW_COMMENTS' => 'J’ai de nouveaux commentaires à approuver',
        'I_HAVE_NEW_NETWORK_CONTENT' => 'J’ai le nouveau contenu de réseau à approuver',
        'CONTENT_ACTIVITY' => 'Activité de contenu',
        'ACTIVITY_ON_THINGS_IVE_ADDED' => 'Activité sur des choses que j’ai ajoutées',
        'AUTO_FOLLOW_DISCUSSIONS_I_REPLY_TO' => 'Suivre automatiquement les discussions auxquelles je réponds',
        'THINGS_IVE_ADDED_APPROVED' => 'Les choses que j’ai ajoutées ont été approuvées',
        'NOTIFICATIONS' => 'Avis',
        'EMAIL_ME_WHEN_PEOPLE_REPLY' => 'Envoyez-moi un courriel lorsque les gens répondent',
        'DO_NOT_EMAIL_ME_WHEN_PEOPLE_REPLY' => 'Ne m\'envoyez pas de courriel lorsque les gens répondent',
        'TO_STOP_FOLLOWING_THIS_X_GO_TO' => 'Pour arêter de suivre ce %s, aller à :',
        'YOU_ARE_NO_LONGER_FOLLOWING_THIS_X' => 'Vous ne suivez plus ce %s.',
        'NOTIFY' => 'Notifier',
        'STOP_NOTIFYING' => 'Cesser d’envoyer des avis',
        'EMAIL_WHEN_NEW_DISCUSSIONS' => 'Envoyez-moi un courriel lorsqu’il y a de nouvelles discussions',
        'DO_NOT_EMAIL_WHEN_NEW_DISCUSSIONS' => 'Ne m’envoyez pas de courriel lorsqu\'il n’y a pas de nouvelles discussions.',
        'STOP_FOLLOWING_ALL' => 'Arrêter de suivre tous les commentaires de discussions et de blogues',
        'CHANGE_MY_PHOTO' => 'Changer Ma Photo',
        'COUNTRY_AF' => 'Afghanistan',
        'COUNTRY_AX' => 'Îles d\'Åland',
        'COUNTRY_AL' => 'Albanie',
        'COUNTRY_DZ' => 'Algérie',
        'COUNTRY_AS' => 'Samoa américaines',
        'COUNTRY_AD' => 'Andorre',
        'COUNTRY_AO' => 'Angola',
        'COUNTRY_AI' => 'Anguilla',
        'COUNTRY_AQ' => 'Antarctique',
        'COUNTRY_AG' => 'Antigua-et-Barbuda',
        'COUNTRY_AR' => 'Argentine',
        'COUNTRY_AM' => 'Arménie',
        'COUNTRY_AW' => 'Aruba',
        'COUNTRY_AU' => 'Australie',
        'COUNTRY_AT' => 'Autriche',
        'COUNTRY_AZ' => 'Azerbaïdjan',
        'COUNTRY_BS' => 'Bahamas',
        'COUNTRY_BH' => 'Bahreïn',
        'COUNTRY_BD' => 'Bangladesh',
        'COUNTRY_BB' => 'Barbade',
        'COUNTRY_BY' => 'Bélarus',
        'COUNTRY_BE' => 'Belgique',
        'COUNTRY_BZ' => 'Bélize',
        'COUNTRY_BJ' => 'Bénin',
        'COUNTRY_BM' => 'Bermudes',
        'COUNTRY_BT' => 'Bhoutan',
        'COUNTRY_BO' => 'Bolivie',
        'COUNTRY_BA' => 'Bosnie-Herzégovine',
        'COUNTRY_BW' => 'Botswana',
        'COUNTRY_BV' => 'Bouvet (île)',
        'COUNTRY_BR' => 'Brésil',
        'COUNTRY_IO' => 'Territoires britanniques de l\'Océan Indien',
        'COUNTRY_BN' => 'Bruneï Darussalam',
        'COUNTRY_BG' => 'Bulgarie',
        'COUNTRY_BF' => 'Burkina Faso',
        'COUNTRY_BI' => 'Burundi',
        'COUNTRY_KH' => 'Cambodge',
        'COUNTRY_CM' => 'Cameroun',
        'COUNTRY_CA' => 'Canada',
        'COUNTRY_CV' => 'Cap-Vert (îles du)',
        'COUNTRY_KY' => 'Cayman (îles)',
        'COUNTRY_CF' => 'République centrafricaine',
        'COUNTRY_TD' => 'Tchad',
        'COUNTRY_CL' => 'Chili',
        'COUNTRY_CN' => 'Chine continentale',
        'COUNTRY_CX' => 'Christmas (île)',
        'COUNTRY_CC' => 'Cocos-Keeling (îles)',
        'COUNTRY_CO' => 'Colombie',
        'COUNTRY_KM' => 'Comores',
        'COUNTRY_CG' => 'République du Congo',
        'COUNTRY_CD' => 'République Démocratique du Congo',
        'COUNTRY_CK' => 'Cook (îles)',
        'COUNTRY_CR' => 'Costa Rica',
        'COUNTRY_CI' => 'Côte d\'Ivoire',
        'COUNTRY_HR' => 'Croatie',
        'COUNTRY_CU' => 'Cuba',
        'COUNTRY_CY' => 'Chypre',
        'COUNTRY_CZ' => 'République tchèque',
        'COUNTRY_DK' => 'Danemark',
        'COUNTRY_DJ' => 'Djibouti',
        'COUNTRY_DM' => 'Dominique',
        'COUNTRY_DO' => 'République dominicaine',
        'COUNTRY_EC' => 'Équateur',
        'COUNTRY_EG' => 'Égypte',
        'COUNTRY_SV' => 'Salvador',
        'COUNTRY_GQ' => 'Guinée équatoriale',
        'COUNTRY_ER' => 'Érythrée',
        'COUNTRY_EE' => 'Estonie',
        'COUNTRY_ET' => 'Éthiopie',
        'COUNTRY_EU' => 'Union européenne',
        'COUNTRY_FK' => 'Îles Falkland',
        'COUNTRY_FO' => 'Féroé (îles)',
        'COUNTRY_FJ' => 'Fiji',
        'COUNTRY_FI' => 'Finlande',
        'COUNTRY_FR' => 'France',
        'COUNTRY_GF' => 'Guyane française',
        'COUNTRY_PF' => 'Polynésie française',
        'COUNTRY_TF' => 'Territoires Français du Sud',
        'COUNTRY_GA' => 'Gabon',
        'COUNTRY_GM' => 'Gambie',
        'COUNTRY_GE' => 'Géorgie',
        'COUNTRY_DE' => 'Allemagne',
        'COUNTRY_GH' => 'Ghana',
        'COUNTRY_GI' => 'Gibraltar',
        'COUNTRY_GR' => 'Grèce',
        'COUNTRY_GL' => 'Groenland',
        'COUNTRY_GD' => 'Grenade',
        'COUNTRY_GP' => 'Guadeloupe',
        'COUNTRY_GU' => 'Guam',
        'COUNTRY_GT' => 'Guatémala',
        'COUNTRY_GN' => 'Guinée',
        'COUNTRY_GW' => 'Guinée-Bissau',
        'COUNTRY_GY' => 'Guyane',
        'COUNTRY_HT' => 'Haïti',
        'COUNTRY_HM' => 'Heard et McDonald (îles)',
        'COUNTRY_HN' => 'Honduras',
        'COUNTRY_HK' => 'Hong Kong',
        'COUNTRY_HU' => 'Hongrie',
        'COUNTRY_IS' => 'Islande',
        'COUNTRY_IN' => 'Inde',
        'COUNTRY_ID' => 'Indonésie',
        'COUNTRY_IR' => 'République Islamique d’Iran',
        'COUNTRY_IQ' => 'Irak',
        'COUNTRY_IE' => 'Irlande',
        'COUNTRY_IL' => 'Israël',
        'COUNTRY_IT' => 'Italie',
        'COUNTRY_JM' => 'Jamaïque',
        'COUNTRY_JP' => 'Japon',
        'COUNTRY_JO' => 'Jordanie',
        'COUNTRY_KZ' => 'Kazakhstan',
        'COUNTRY_KE' => 'Kénya',
        'COUNTRY_KI' => 'Kiribati',
        'COUNTRY_KP' => 'République Populaire Démocratique de Corée',
        'COUNTRY_KR' => 'République de Corée',
        'COUNTRY_KW' => 'Koweït',
        'COUNTRY_KG' => 'Kirghizistan',
        'COUNTRY_LA' => 'République démocratique populaire lao',
        'COUNTRY_LV' => 'Lettonie',
        'COUNTRY_LB' => 'Liban',
        'COUNTRY_LS' => 'Lésotho',
        'COUNTRY_LR' => 'Libéria',
        'COUNTRY_LY' => 'Jamahiriya Arabe Libyenne',
        'COUNTRY_LI' => 'Liechtenstein',
        'COUNTRY_LT' => 'Lituanie',
        'COUNTRY_LU' => 'Luxembourg',
        'COUNTRY_MO' => 'Macao',
        'COUNTRY_MK' => 'Ex-République yougoslave de Macédoine',
        'COUNTRY_MG' => 'Madagascar',
        'COUNTRY_MW' => 'Malawi',
        'COUNTRY_MY' => 'Malaisie',
        'COUNTRY_MV' => 'Maldives',
        'COUNTRY_ML' => 'Mali',
        'COUNTRY_MT' => 'Malte',
        'COUNTRY_MH' => 'Îles Marshall',
        'COUNTRY_MQ' => 'Martinique',
        'COUNTRY_MR' => 'Mauritanie',
        'COUNTRY_MU' => 'Maurice',
        'COUNTRY_YT' => 'Mayotte',
        'COUNTRY_MX' => 'Mexique',
        'COUNTRY_FM' => 'États fédérés de Micronésie',
        'COUNTRY_MD' => 'République de Moldavie',
        'COUNTRY_MC' => 'Monaco',
        'COUNTRY_MN' => 'Mongolie',
        'COUNTRY_MS' => 'Montserrat',
        'COUNTRY_MA' => 'Maroc',
        'COUNTRY_MZ' => 'Mozambique',
        'COUNTRY_MM' => 'birman',
        'COUNTRY_NA' => 'Namibie',
        'COUNTRY_NR' => 'Mauru',
        'COUNTRY_NP' => 'Népal',
        'COUNTRY_NL' => 'Pays-Bas',
        'COUNTRY_AN' => 'Antilles Néerlandaises',
        'COUNTRY_NC' => 'Nouvelle Calédonie',
        'COUNTRY_NZ' => 'Nouvelle-Zélande',
        'COUNTRY_NI' => 'Nicaragua',
        'COUNTRY_NE' => 'Niger',
        'COUNTRY_NG' => 'Nigéria',
        'COUNTRY_NU' => 'Niue',
        'COUNTRY_NF' => 'Île Norfolk',
        'COUNTRY_MP' => 'Mariannes du Nord (îles)',
        'COUNTRY_NO' => 'Norvège',
        'COUNTRY_OM' => 'Oman',
        'COUNTRY_PK' => 'Pakistan',
        'COUNTRY_PW' => 'Palau',
        'COUNTRY_PS' => 'Territoire Occupé de Palestine',
        'COUNTRY_PA' => 'Panama',
        'COUNTRY_PG' => 'Papouasie-Nouvelle-Guinée',
        'COUNTRY_PY' => 'Paraguay',
        'COUNTRY_PE' => 'Pérou',
        'COUNTRY_PH' => 'Philippines',
        'COUNTRY_PN' => 'Pitcairn',
        'COUNTRY_PL' => 'Pologne',
        'COUNTRY_PT' => 'Portugal',
        'COUNTRY_PR' => 'Porto Rico',
        'COUNTRY_QA' => 'Qatar',
        'COUNTRY_RE' => 'Réunion',
        'COUNTRY_RO' => 'Roumanie',
        'COUNTRY_RU' => 'Fédération de Russie',
        'COUNTRY_RW' => 'Rwanda',
        'COUNTRY_SH' => 'Sainte Hélène',
        'COUNTRY_KN' => 'Saint-Kitts-et-Nevis',
        'COUNTRY_LC' => 'Sainte Lucie',
        'COUNTRY_PM' => 'Saint-Pierre et Miquelon',
        'COUNTRY_VC' => 'Saint Vincent et les Grenadines',
        'COUNTRY_WS' => 'Samoa',
        'COUNTRY_SM' => 'San Marino',
        'COUNTRY_ST' => 'Sao Tome et Principe',
        'COUNTRY_SA' => 'Arabie saoudite',
        'COUNTRY_SN' => 'Sénégal',
        'COUNTRY_CS' => 'Serbie et Monténégro',
        'COUNTRY_SC' => 'Seychelles',
        'COUNTRY_SL' => 'Sierra Leone',
        'COUNTRY_SG' => 'Singapour',
        'COUNTRY_SK' => 'Slovaquie',
        'COUNTRY_SI' => 'Slovénie',
        'COUNTRY_SB' => 'Îles Salomon',
        'COUNTRY_SO' => 'Somalie',
        'COUNTRY_ZA' => 'Afrique du Sud',
        'COUNTRY_GS' => 'Géorgie du Sud et Îles Sandwich du Sud',
        'COUNTRY_ES' => 'Espagne',
        'COUNTRY_LK' => 'Sri Lanka',
        'COUNTRY_SD' => 'Soudan',
        'COUNTRY_SR' => 'Surinam',
        'COUNTRY_SJ' => 'Svalbard et Jan Mayen (îles)',
        'COUNTRY_SZ' => 'Swaziland',
        'COUNTRY_SE' => 'Suède',
        'COUNTRY_CH' => 'Suisse',
        'COUNTRY_SY' => 'République arabe de Syrie',
        'COUNTRY_TW' => 'Taiwan',
        'COUNTRY_TJ' => 'Tadjikistan',
        'COUNTRY_TZ' => 'République Unie de Tanzanie',
        'COUNTRY_TH' => 'Thaïlande',
        'COUNTRY_TL' => 'Timor-Leste',
        'COUNTRY_TG' => 'Togo',
        'COUNTRY_TK' => 'Tokelau',
        'COUNTRY_TO' => 'Tonga',
        'COUNTRY_TT' => 'Trinidad et Tobago',
        'COUNTRY_TN' => 'Tunisie',
        'COUNTRY_TR' => 'Turquie',
        'COUNTRY_TM' => 'Turkménistan',
        'COUNTRY_TC' => 'Turks-et-Caicos (Îles)',
        'COUNTRY_TV' => 'Tuvalu',
        'COUNTRY_UG' => 'Ouganda',
        'COUNTRY_UA' => 'Ukraine',
        'COUNTRY_AE' => 'Émirats Arabes Unis',
        'COUNTRY_GB' => 'Royaume-Uni',
        'COUNTRY_US' => 'États-Unis',
        'COUNTRY_UM' => 'Dépendances américaines du Pacifique',
        'COUNTRY_UY' => 'Uruguay',
        'COUNTRY_UZ' => 'Ouzbékistan',
        'COUNTRY_VU' => 'Vanuatu',
        'COUNTRY_VA' => 'Cité État du Vatican',
        'COUNTRY_VE' => 'Venezuela',
        'COUNTRY_VN' => 'Viêt Nam',
        'COUNTRY_VG' => 'Îles Vierges Britanniques',
        'COUNTRY_VI' => 'Îles Vierges Américaines',
        'COUNTRY_WF' => 'Wallis et Futuna',
        'COUNTRY_EH' => 'Sahara Occidental',
        'COUNTRY_YE' => 'Yémen',
        'COUNTRY_ZM' => 'Zambie',
        'COUNTRY_ZW' => 'Zimbabwe',
        'ERROR_LOG' => 'Journal des erreurs',
        'CANNOT_READ_ERROR_LOG' => 'Impossible lire le journal des erreurs',
        'CANNOT_OPEN_ERROR_LOG' => 'Impossible d\'ouvrir le journal des erreurs',
        'CANNOT_SCAN_ERROR_LOG' => 'Impossible de balayer le journal des erreurs',
        'MODELS_RESET' => 'Réinitialisation des modèles :',
        'NO_MODELS_RESET' => 'Pas de réinitialisation de modèles.',
        'BOX_WILL_NOT_SHOW_FEED' => 'Cette boîte ne va pas être affichée s\'il n\'y a pas au moins un article de sélectionné.',
        'CLICK_EDIT_TO_SPECIFY_FEED' => 'Veuillez cliquer sur « Modifier » pour définir le flux RSS de cette boîte.',
        'PROBLEM_OCCURRED_RETRIEVING_FEED' => 'Un problème s\'est produit lors de la récupération du flux RSS.',
        'MORE_ELLIPSIS' => 'Plus...',
        'RSS' => 'RSS',
        'CHOOSE_GADGETS' => 'Choisir un de ses bons gadgets OpenSocial à ajouter à votre page de profil! Vous pouvez <a %s>visualiser et évaluer les gadgets ici</a>, ou <a %s>en apprendre d\'avantage sur OpenSocial ici</a>.',
        'GADGETS_UNAVAILABLE' => 'Gadgets temporairement indisponibles',
        'APOLOGIES_GADGETS_UNAVAILABLE' => 'Nous nous excusons – les gadgets sont temporairement indisponibles.',
        'BOX_WILL_NOT_SHOW_GADGET' => 'Cette boîte ne se montrera pas pour d’autres personnes à moins que vous ne sélectionniez au moins un gadget.',
        'CLICK_EDIT_TO_SPECIFY_GADGET_OR_VISIT_GADGET_GALLERY' => 'Veuillez cliquer sur Modifier pour spécifier l\'URL du gadget pour cette boîte ou aller au <a %s>Répertoire Gadgets</a>.',
        'PROBLEM_OCCURRED_RETRIEVING_GADGET' => 'Un problème s\'est produit lors de la récupération de ce flux d’URL de Gadget.',
        'ADD_GADGET_TO_YOUR_PAGE' => 'Ajouter ce gadget à votre profil',
        'GADGETS_BETA' => 'Gadgets (Béta)',
        'TRY_OUT_OPENSOCIAL_GADGETS_WARNING_EXPERIMENTAL' => 'Essayer les gadgets OpenSocial.  Avertissement : cette fonctionnalité est expérimentale.',
        'ADD_TO_MY_PAGE' => 'Ajouter à Ma page',
        'GADGETS' => 'Gadgets',
        'GADGETS_TAB_TEXT' => 'Gadgets',
        'GADGET' => 'Gadget',
        'GADGETS_IS_IN_BETA' => 'Gadgets est en béta.',
        'SORRY_GADGET_UNAVAILABLE' => 'Nous sommes désolés, mais ce Gadget est indisponible. Veuillez verifier que vous avez le bon url. Si les problèmes persistes, <a %s>veuillez nous en avertir</a>.',
        'WE_ARE_SORRY_SITE_HAS_ISSUE' => 'Nous sommes désolés, un problème s\'est produit sur ce site.',
        'PLEASE_TRY_REFRESHING' => 'Veuillez essayer de rafraîchir la page dans 30 secondes et <a %s>faites-le nous savoir</a> si vous voyez ce message à nouveau.',
        'PAGE_TITLE_COLON' => 'Titre de la page :',
        'PAGE_CONTENT' => 'Contenu:',
        'CREATE_PAGE' => 'Créer une Page',
        'CREATE_NEW_PAGE' => 'Créer une nouvelle Page',
        'YOUR_COMMENT' => 'Votre Commentaire',
        'ADD_YOUR_COMMENT' => 'Ajouter Votre Commentaire',
        'DELETE_PAGE' => 'Supprimer cette Page',
        'DELETE_THIS_PAGE_Q' => 'Supprimer cette Page?',
        'ARE_YOU_SURE_DELETE_THIS_PAGE' => 'Êtes-vous sûr de vouloir supprimer cette page (incluant tous les commentaires)? Ce processus peut prendre quelques minutes.',
        'SEARCH_PAGES' => 'Pages de Recherche',
        'ALL_PAGES' => 'Toutes les Pages',
        'SUBSCRIBE_TO_PAGES' => 'S\'inscrire à ces pages',
        'NOBODY_HAS_ADDED_PAGES' => 'Personne n\'a ajouté de pages!',
        'ADD_PAGES_CALL_TO_ACTION' => 'Créez la toute première page.',
        'CREATE_A_PAGE' => 'Créer une Page',
        'PLEASE_ENTER_PAGE_CONTENT' => 'Veuillez entrer le contenu de la page',
        'SEARCH_RESULTS_FOR_X' => 'Résulats de recherche pour <em>%s</em>',
        'EDIT_YOUR_PAGE' => 'Modifier Votre page',
        'UPDATE_PAGE' => 'Mettre la page à jour',
        'CLOSE_DISCUSSION' => 'Fermer la discussion',
        'REOPEN_DISCUSSION' => 'Ré-ouvrir la discussion',
        'CLOSING_DISCUSSION_PREVENTS' => 'La fermeture d’une discussion empêche toute réponse supplémentaire',
        'BOX_WILL_NOT_SHOW_DISCUSSION' => 'Cette boîte ne va pas être affichée s\'il n\'y a pas au moins une discussion de sélectionnée.',
        'NEWEST_DISCUSSIONS' => 'Les Plus Récentes Discussions',
        'LATEST_REPLIES' => 'Les plus récentes réponses',
        'REPLIES_CLOSED_FOR_DISCUSSION' => 'Les réponses sont fermées pour cette discussion.',
        'SORRY_DISCUSSION_CLOSED' => 'Nous sommes désolés, mais cette discussion vient juste d’être fermée aux réponses supplémentaires',
        'MOST_REPLIES' => 'Avec Le Plus De Réponses',
        'OWNER_DISCUSSIONS_ONLY' => 'Discussions Du Créateur Seulement',
        'MY_DISCUSSIONS_ONLY' => 'Mes discussions seulement',
        'DISCUSSION_DELETED' => 'Discussion Supprimée',
        'DISCUSSION_HAS_BEEN_DELETED' => 'Cette discussion a été supprimée.',
        'REPLY_DELETED' => 'Réponse Supprimée',
        'REPLY_HAS_BEEN_DELETED' => 'Cette réponse a été supprimée. <a %s>Retourner à la discussion.</a>',
        'VIEW_ALL_DISCUSSIONS' => 'Voir Toutes les Discussions',
        'ADD_CATEGORIES' => 'Ajouter des catégories',
        'CATEGORY' => 'Catégorie:',
        'NO_DISCUSSIONS_IN_CATEGORY' => 'Il n\'y a pas encore de discussions dans cette catégorie.',
        'ADD_MANAGE_CATEGORIES' => 'Ajouter/Gérer Catégories',
        'VIEW_ALL_N_CATEGORIES' => 'Voir toutes les catégories %s',
        'UNTITLED_CATEGORY' => 'Catégorie Sans titre',
        'SAMPLE_TITLE' => 'Exemple de Titre',
        'UNCATEGORIZED' => 'Non Catégorisées',
        'EXISTING_DISCUSSIONS' => 'Discussions existantes n\'appartenant à aucune catégorie.',
        'ADD_A_CATEGORY' => 'Ajouter une catégorie',
        'ADD_ANOTHER_CATEGORY' => 'Ajouter une autre catégorie',
        'MANAGE_CATEGORIES' => 'Gérer Catégories',
        'CATEGORY_TITLE' => 'Titre de la catégorie',
        'ALLOW_MEMBERS_TO_START_DISCUSSIONS' => 'Permettre au membres de démarrer des discussions dans cette catégorie',
        'ONLY_I_CAN_START_DISCUSSIONS' => 'Moi seul peux démarrer des discussions dans cette catégorie',
        'ALLOW_MEMBERS_TO_REPLY' => 'Permettre aux membres de répondre',
        'SUGGESTIONS' => 'Suggestions:',
        'TRY_DIFFERENT_KEYWORDS' => 'Essayez d\'autres termes',
        'VIEW_DISCUSSIONS_OR_START_DISCUSSION' => '<a %s>Voir toutes les discussions</a> ou <a %s>Démarrer une nouvelle discussion</a>',
        'MAKE_SURE_WORDS_SPELLED' => 'Assurez-vous que tous les mots sont épelés correctement',
        'REPLY_WAS_DELETED' => 'Cette réponse a été supprimée',
        'TAGS_X' => '<strong>Tags:</strong> %s',
        'SEND_PRIVATE_MESSAGE' => 'Envoyer un Message Privé',
        'PERMALINK_TO_REPLY' => 'Lien Permanent vers cette Réponse',
        'PERMALINK' => 'Lien Permanent',
        'WE_COULD_NOT_FIND_ANY_DISCUSSIONS' => 'Toutes nos excuses - nous n\'avons pu trouver de discussions correspondant à votre recherche.',
        'DISCUSSIONS_MATCHING_X' => 'Discussions correspondant au terme <em>\'%s\'</em>',
        'SEARCH_DISCUSSIONS' => 'Recherche de Discussions',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS_2' => 'Vous n\'avez pas encore ajouté de discussions!',
        'ADD_DISCUSSIONS_AND_SHARE' => 'Ajoutez des discussions et partager les avec vos amis, votre famille ou le reste du monde!',
        'DISCUSSION' => 'Discussion',
        'DISCUSSIONS' => 'Discussions',
        'KEEP_PAGE_OPEN_FORUM' => 'Veuillez garder cette fenêtre ouverte pendant le téléchargement des fichiers vers le forum.',
        'MEANWHILE_FEEL_FREE_FORUM' => 'En attendant, sentez-vous libre <a %s>d\'ouvrir une autre fenêtre</a> et de continuer à naviguer le réseau « %s ».',
        'START_A_NEW_DISCUSSION' => 'Démarrer une nouvelle discussion',
        'DISCUSSION_TITLE' => 'Titre de la discussion:',
        'FIRST_POST' => 'Entrée :',
        'UPLOAD_FILES' => 'Téléchargement de Fichiers:',
        'START_DISCUSSION' => 'Démarrer la discussion',
        'EDIT_DISCUSSION' => 'Modifier Discussion',
        'START_A_DISCUSSION' => 'Démarrer une discussion',
        'ALL_DISCUSSIONS' => 'Toutes les Discussions',
        'CONTRIBUTORS' => 'Contributeurs',
        'MY_DISCUSSIONS' => 'Mes discussions',
        'READ_MORE' => 'Lire Plus',
        'STARTED_T_BY' => 'Démarrée le <strong>%s</strong> par:',
        'ADDED_BY_X_T' => 'Ajoutée par %s %s',
        'STARTED_BY_X_T' => 'Démarrée par %s %s',
        'REPLY_BY_X_T' => 'Réponse postée par <strong>%s</strong> %s',
        'STARTED_BY_X_LAST_REPLY_LINK_BY_X_T' => 'Démarrée par %s. Dernière <a %s>réponse</a> par %s %s.',
        'STARTED_DISCUSSION_LAST_REPLY_LINK_BY_X_T' => '<strong>A démarrée cette discussion.</strong> Dernière <a %s>réponse</a> par %s %s.',
        'STARTED_DISCUSSION_T' => '<strong>A démarré cette discussion </strong> %s',
        'ADDED_REPLY_T' => '<strong>A ajouté une réponse </strong> %s',
        'ADDED_POST_T' => '<strong>A ajouté une entrée </strong> %s',
        'STARTED_BY_X_ON' => 'Démarrée par %s %s',
        'STARTED_DISCUSSION_ON' => '<strong>A démarré cette discussion </strong> %s',
        'STARTED_ON' => '<strong>Démarrée </strong> %s',
        'ADDED_REPLY_ON' => '<strong>A ajouté une réponse </strong> %s',
        'ADDED_POST_ON' => '<strong>A ajouté une entrée </strong> %s',
        'XS_DISCUSSIONS' => 'discussions de %s',
        'XS_DISCUSSIONS_LOWERCASE' => 'discussions de %s',
        'VIEW_XS_DISCUSSIONS' => 'Voir les discussions de %s',
        'VIEW_YOUR_DISCUSSIONS' => 'Voir vos discussions',
        'SUBSCRIBE_TO_DISCUSSIONS' => 'S\'inscrire à ces discussions',
        'SUBSCRIBE_TO_DISCUSSION' => 'S\'inscrire à cette discussion',
        'SUBSCRIBE_TO_XS_DISCUSSIONS' => 'S\'inscrire à ces discussions',
        'N_KB' => '%s KB',
        'N_MB' => '%s MB',
        'UPLOADING_FILES' => 'Téléchargement de Fichiers',
        'ATTACHMENTS' => 'Pièces jointes',
        'YOUR_POST' => 'Votre Entrée :',
        'YOUR_REPLY' => 'Votre Réponse:',
        'WOULD_YOU_LIKE_TO_UPLOAD_FILES' => 'Voulez-vous télécharger des fichiers?',
        'ADD_YOUR_REPLY' => 'Ajouter Votre Réponse',
        'REPLIES_TO_THIS_DISCUSSION' => 'Réponses à cette Discussion',
        'POSTED_BY_X_ON' => 'Publié par %s %s',
        'PLEASE_ENTER_TITLE' => 'Veuillez entrer un titre pour la discussion',
        'PLEASE_ENTER_FIRST_POST' => 'Veuillez rédiger une première entrée pour la discussion.',
        'DELETE_ATTACHMENT' => 'Supprimer pièce jointe',
        'DELETE_ATTACHMENT_Q' => 'Supprimer cette pièce jointe?',
        'DELETE_REPLY' => 'Supprimer Réponse',
        'DELETE_THIS_DISCUSSION_Q' => 'Supprimer cette discussion?',
        'ARE_YOU_SURE_DELETE_THIS_DISCUSSION' => 'Êtes-vous sûr de vouloir supprimer cette discussion (incluant tous les commentaires et réponses)? Ce processus peut prendre quelques minutes.',
        'DELETE_DISCUSSION' => 'Supprimer Discussion',
        'NOBODY_HAS_ADDED_DISCUSSIONS' => 'Personne n\'a ajouté de discussions! Ajoutez-en dès maintenant.',
        'NOBODY_HAS_ADDED_DISCUSSIONS_ADD' => 'Personne n\'a ajouté de discussions! Ajoutez-en dès maintenant.',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS' => 'Vous n\'avez pas encore ajouté de discussions. Ajoutez-en dès maintenant',
        'YOU_HAVE_NOT_STARTED_DISCUSSIONS' => 'Vous n\'avez pas encore démarré de Discussions.',
        'YOU_HAVE_NOT_ADDED_TO_DISCUSSIONS' => 'Vous n\'avez pas encore participé à une discussion.',
        'X_HAS_NOT_ADDED_DISCUSSIONS' => '%s n\'a pas encore ajouté de discussions.',
        'X_HAS_NOT_STARTED_DISCUSSIONS' => '%s n\'a pas encore démarré de Discussions.',
        'X_HAS_NOT_ADDED_TO_DISCUSSIONS' => '%s n\'a pas encore participé à une discussion.',
        'VIEW_DISCUSSIONS' => 'Voir les Discussions',
        'VIEW_ALL_PEOPLE_ON_X' => 'Voir tous les membres du réseau « %s »',
        'GROUP_HAS_NO_DISCUSSIONS' => 'Ce groupe n\'a pas encore de discussions.',
        'VIEW_DISCUSSIONS_IN_GROUP_FORUM' => 'Voir les dicussions dans le <a %s>forum du groupe %s</a>!',
        'THIS_BOX_WILL_NOT_SHOW_DISCUSSIONS' => 'Cette boîte ne va pas être affichée s\'il n\'y a pas de discussions à afficher. Pourquoi ne pas en ajouter?',
        'DISCUSSIONS_I_STARTED' => 'Discussions que j\'ai démarrées',
        'DISCUSSIONS_X_STARTED' => 'Discussions que/qu\' %s a démarrées',
        'DISCUSSIONS_I_REPLIED_TO' => 'Discussions auxquelles j\'ai répondu',
        'DISCUSSIONS_X_REPLIED_TO' => 'Discussions auxquelles %s a répondu',
        'PLEASE_WRITE_SOMETHING_FOR_POST' => 'Veuillez rédiger quelque chose pour votre entrée.',
        'PLEASE_WRITE_SOMETHING_FOR_REPLY' => 'Veuillez rédiger quelque chose pour votre réponse.',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION_X' => 'Il y a un nouveau commentaire pour votre discussion "%s" sur %s',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION' => 'Il y a un nouveau commentaire pour vos discussions sur %s',
        'SOMEBODY_COMMENTED_DISCUSSION_ADDED_TO_X' => 'Quelqu’un a fait un commentaire dans une discussion que vous avez commencée sur %s',
        'ABOUT_YOUR_DISCUSSION' => 'À propos de votre discussion',
        'ABOUT_THIS_DISCUSSION' => 'À propos de cette discussion',
        'USER_REPLIED_TO_A_DISCUSSION_ON_Y' => '%s a répondu à une discussion sur %s',
        'USER_REPLIED_TO_DISCUSSION_TITLE_ON_APPNAME' => '%s a répondu à la discussion "%s" sur %s',
        'ALREADY_MEMBER_OF_GROUP' => '(Déjà membre de ce groupe)',
        'INVITE_YOUR_FRIENDS_TO_GROUPNAME' => 'Inviter vos amis à \'%s\'',
        'PROBLEM_WITH_ICON' => 'Il y a eu un problème avec le fichier de l\'îcone',
        'GROUP_ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Les administrateurs du groupe ont le même niveau de contrôle que le créateur du groupe.',
        'CREATE_NEW_GROUP' => 'Créer un nouveau groupe',
        'CREATE_A_NEW_GROUP' => 'Créer un nouveau groupe',
        'CREATE_A_GROUP' => 'Créer un groupe',
        'VIEW_GROUPS' => 'Voir les Groupes',
        'CREATE_GROUP' => 'Créer Groupe',
        'PLEASE_ENTER_NAME_FOR_GROUP' => 'Veuillez choisir un nom pour votre groupe.',
        'NAME_TAKEN' => 'Nous sommes désolés - ce nom est déjà pris. Veuillez choisir un autre nom.',
        'GROUP_INFORMATION' => 'À propos du groupe',
        'EXTERNAL_WEBSITE' => 'Site web externe',
        'DO_YOU_HAVE_EXISTING_WEBSITE' => 'Avez-vous un site web externe pour un groupe préexistant?',
        'URL' => 'URL',
        'GROUPS' => 'Groupes',
        'SEARCH_GROUPS' => 'Recherche de groupes',
        'NOBODY_HAS_CREATED_GROUPS' => 'Personne n\'a créé de groupes.',
        'NOBODY_HAS_CREATED_GROUPS_ADD' => 'Personne n\'a créé de groupes! Créez-en un dès maintenant.',
        'MY_GROUPS' => 'Mes Groupes',
        'FEATURED_GROUPS' => 'Groupes En Primeur',
        'YOU_CAN_CREATE_GROUP' => 'Vous pouvez <a %s>créer un nouveau groupe</a> sur %s!',
        'GROUP_FORUM' => 'Forum du groupe %s',
        'USER_CREATED_GROUP' => '%s a créé ce groupe sur %s.',
        'GROUP_MEMBERS_COUNT' => 'Membres du groupe %s (%d)',
        'WE_ARE_SORRY_NOT_ALLOWED_JOIN_GROUP' => 'Nous sommes désolé, vous n\'avez pas la permission de joindre ce groupe.',
        'JOIN_GROUP_NOW' => 'Joignez-vous au réseau « %s », dès maintenant!',
        'USER_HAS_INVITED_YOU_TO_JOIN_GROUP' => '%s vous a invité à joindre %s',
        'DECLINE' => 'Refuser',
        'WELCOME_TO_GROUP' => 'Bienvenue sur %s',
        'YOU_CAN_PARTICIPATE_IN_GROUP' => 'Vous pouvez maintenant participer au forum du groupe %s.',
        'SEND_MESSAGE_TO_GROUP' => 'Envoyer un message au groupe',
        'LEAVE_THIS_GROUP' => 'Abandonner Ce Groupe',
        'EDIT_GROUP_INFO' => 'Modifier Renseignements sur ce groupe',
        'EDIT_GROUP_INFORMATION' => 'Modifier Renseignements sur ce groupe',
        'MANAGE_GROUP_MEMBERS' => 'Gérer les membres du groupe',
        'GROUP_HAS_NO_MEMBERS' => 'Ce groupe n\'a pas encore de membres!',
        'GROUP_HAS_NO_MEMBERS_THAT_MATCH' => 'Ce groupe n\'a pas encore de membres correspondant à votre recherche.',
        'USERS_GROUPS' => 'Groupes de %s',
        'YOU_HAVE_NOT_CREATED_GROUPS' => 'Vous n\'avez pas encore créé de groupes.',
        'USER_HAS_NOT_CREATED_GROUPS' => '%s n\'a pas encore créé de groupes.',
        'THERE_ARE_NO_FEATURED_GROUPS' => 'Il n\'y a pas de groupes en primeur sur votre réseau social.',
        'START_FEATURING_GROUPS' => 'Mettez en primeur les %s lorsque vous voyez l\'option « Mettre en primeur ». Pour en apprendre plus à propos de cette option, <a %s>cliquez ici</a>.',
        'BOX_WILL_NOT_SHOW_GROUPS' => 'Cette boîte ne va pas être affichée s\'il n\'y a pas au moins un groupe de sélectionné.',
        'YOU_HAVE_NOT_CREATED_GROUPS_2' => 'Vous n\'avez pas encore créé de groupes!',
        'CREATE_GROUPS_AND_SHARE' => 'Créez des groupes et partager les avec vos amis, votre famille ou le reste du monde!',
        'GROUPS_MATCHING_SEARCH_TERM' => 'Groupes correspondant au terme de recherche <em>\'%s\'</em>',
        'WE_COULD_NOT_FIND_ANY_GROUPS' => 'Désolé - il n\'y a aucun groupe correspondant au terme de recherche.',
        'VIEW_GROUPS_OR_CREATE_GROUP' => '<a %s>Voir tous les groupes</a> ou <a %s>Créer un nouveau groupe</a>',
        'VIEW_ALL_GROUPS' => 'Voir tous les Groupes',
        'DELETE_GROUP' => 'Supprimer le Groupe',
        'DELETE_GROUP_Q' => 'Êtes-vous sûr de vouloir supprimer ce groupe?',
        'GROUP_INVITATIONS' => 'Invitations au Groupe',
        'YOU_HAVE_BEEN_INVITED_TO_JOIN' => 'Vous êtes invité à joindre:',
        'VISIT' => 'Visiter',
        'WHO_CAN_JOIN_GROUP' => 'Qui peut se joindre à ce groupe?',
        'PRIVACY_CANNOT_BE_CHANGED' => 'La confidentialité peut être modifiée suivant la création du groupe.',
        'ONLY_INVITED_PEOPLE' => 'Seulement les gens invités',
        'ALLOW_PEOPLE_TO_REQUEST' => 'Permettre au gens de demander une invitation',
        'ANYONE_CAN_JOIN_GROUP' => 'Tout le monde peut se joindre à ce groupe',
        'ONLY_INVITED_PEOPLE_CAN_JOIN_GROUP' => 'Seulement les gens invités peuvent se joindre à ce groupe',
        'WHY_NOT_CREATE_GROUP' => 'Pourquoi ne pas <a %s>créer votre propre groupe</a>?',
        'PLEASE_ENTER_NAME' => 'Veuillez entrer votre nom',
        'PLEASE_ENTER_EMAIL_ADDRESS' => 'Veuillez entrer votre adresse électronique',
        'PLEASE_ENTER_PAGE_ADDRESS' => 'Veuillez entrer une nouvelle adresse de page.',
        'PLEASE_ENTER_PASSWORD' => 'Veuillez entrer votre mot de passe.',
        'CREATE_ACCOUNT_OR_SIGN_IN' => '<a %s>Cliquer ici pour créer un compte</a> ou essayer d’ouvrir de nouveau une session ci-dessous.',
        'CREATE_ACCOUNT_OR_JOIN' => '<a %s>Cliquer ici pour créer un compte</a> ou essayer de prendre part à nouveau à l’aide de votre Ning ID ci-dessous.',
        'CHOOSE_SHORTER_PASSWORD' => 'Veuillez choisir un mot de passe plus court.',
        'CHOOSE_SHORTER_NAME' => 'Veuillez choisir un nom plus court.',
        'ENTER_SHORTER_CITY_NAME' => 'Veuillez choisir un nom de ville plus court.',
        'PLEASE_ENTER_PASSWORD_AGAIN' => 'Veuillez entrer de nouveau votre mot de passe dans la case «Re-saisir Mot de passe».',
        'PLEASE_ENTER_CURRENT_PASSWORD' => 'Veuillez entrer votre mot de passe actuel.',
        'PLEASE_ENTER_NEW_PASSWORD' => 'Veuillez entrer votre nouveau mot de passe.',
        'PLEASE_ENTER_NEW_PASSWORD_AGAIN' => 'Veuillez entrer de nouveau votre nouveau mot de passe dans la case  «Confirmer Mot de passe».',
        'CURRENT_PASSWORD' => 'Mot de passe actuel',
        'PASSWORDS_DO_NOT_MATCH' => 'Les deux mots de passe ne correspondent pas.',
        'NEW_AND_CONFIRMATION_PASSWORDS' => 'Le nouveau mot de passe et le mot de passe de confirmation ne correspondent pas.',
        'YOUR_REQUEST_HAS_BEEN_SENT_TO_GROUP_CREATOR' => 'Votre requête a été envoyée au créateur du groupe.',
        'X_IS_NOT_VALID_EMAIL_ADDRESS' => '%s n\'est pas une adresse électronique valide',
        'COME_JOIN_ME_ON_X_ON_Y' => 'Venez me retrouver à %1$s sur %2$s.',
        'COME_JOIN_ME_ON_X_ON_Y_ELLIPSIS' => 'Venez me retrouver à %1$s sur %2$s …',
        'INVITE_PEOPLE_TO_GROUP' => 'Inviter des gens au groupe %s',
        'INVITE_TO_GROUP' => 'Inviter à \'%s\'',
        'SEND_INVITATIONS_TO_JOIN_GROUP' => 'Envoyer des invitations aux gens pour qu\'ils se joignent au groupe %s.',
        'GROUPNAME_MEMBERS' => 'Membres du groupe %s',
        'GROUP_CREATOR' => 'Créateur du Groupe',
        'GROUP_ADMINISTRATOR' => 'Administrateur du Groupe',
        'DATE_BANNED' => 'Banni le',
        'BAN_FROM_GROUP' => 'Bannir du groupe',
        'ARE_YOU_SURE_BAN_MEMBER_FROM_GROUP' => 'Êtes-vous sûr de vouloir bannir ce(s) membre(s) de votre groupe? Ce processus peut prendre quelque minutes.',
        'ALSO_DELETE_FORUM_POSTINGS' => 'Aussi supprimer leurs publications et réponses sur le forum de discussions.',
        'GROUP_WEB_ADDRESS' => 'Adresse web du groupe',
        'GROUP' => 'Groupe',
        'BACK_TO_GROUP' => '← Retour au %s',
        'USER_BANNED_FROM_GROUP' => '%1$s a été banni de ce groupe. <a %2$s>Envoyer un message à %1$s</a>',
        'USER_ALREADY_GROUP_MEMBER' => '%1$s est déjà membre de ce groupe. <a %2$s>Envoyer un message à %1$s</a>',
        'GROUP_ADMIN_DISCUSSIONS' => 'Discussions des administrateurs du groupe',
        'BACK_TO_NETWORK_GROUPS' => 'Retours aux groupes de %s',
        'MOST_MEMBERS' => 'Avec le plus de membres',
        'LIKE_WHAT_YOU_SEE' => 'Vous aimez ce que vous voyez sur %s? Adhérez maintenant!',
        'LIKE_WHAT_YOU_SEE_GROUP' => 'Vous aimez ce que vous voyez sur %s? Adhérez maintenant!',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => 'Vous avez créé le groupe %1$s. Vous pouvez participer au forum ou bien inviter d\'autres gens à se joindre au groupe %1$s.',
        'YOU_ARE_MEMBER_OF_GROUP_AND_CAN_INVITE' => 'Vous êtes maintenant membre du groupe %1$s. Vouz pouvez participer au forum ou bien inviter d\'autres gens à se joindre au groupe %1$s.',
        'NETWORK_DOES_NOT_HAVE_MUSIC' => 'Le réseau n’a pas encore de musique.',
        'PERSON_DOES_NOT_HAVE_MUSIC' => 'Cette personne n’a pas encore de musique.',
        'FIND_MORE_MUSIC_LIKE_THIS' => 'Découvrez plus de musique comme celle-ci sur <em>%s</em>',
        'TRACKS' => 'Chansons',
        'ADD_MUSIC_TRACKS' => 'Ajouter Musique',
        'CHOOSE_MUSIC_TRACKS' => 'Choisissez les chansons à ajouter',
        'YOU_CAN_ADD_UP_TO_MP3' => 'Vous pouvez ajouter jusqu\'à quatre fichiers MP3 à la fois.',
        'UPLOAD_TRACKS' => 'Télécharger les Chansons',
        'ADD_TRACKS' => 'Ajouter les Chansons',
        'ENTER_THE_URL_MP3_TO_ADD' => 'Entrer l\'adresse url de chaque fichier MP3 que vous voulez ajouter:',
        'EACH_MP3_FILE_MAY_BE_UP_TO' => 'Vous pouvez ajouter jusqu\'à 100 fichiers MP3! Chaque fichier peut avoir avoir une taille limite de 20Mo. Notez que les petits fichiers sont téléchargés plus rapidement.',
        'BE_NICE' => 'Soyez sage',
        'PLEASE_UPLOAD_ONLY_TRACKS' => 'Veuillez seulement télécharger les chansons dont vous avez obtenu la permission de l\'artiste ou du détenteur des droits d\'auteur.',
        'PLEASE_LINK_ONLY_TRACKS' => 'Veuillez seulement relier les chansons dont la publication sur le web a été autorisée.',
        'MORE_WAY_TO_ADD_MUSIC' => 'D’autres manières d’ajouter de la musique…',
        'ELLIP_FROM_ANOTHER_WEBSITE' => '…d’un autre site web',
        'ADD_MUSIC_FROM_ANY_WEBSITE' => 'Ajoutez de la musique à partir d\'un autre site web en entrant un lien vers le fichier MP3 de ce site.',
        'KEEP_PAGE_OPEN_MUSIC' => 'Veuillez garder cette fenêtre ouverte pendant le téléchargement des chansons. Lorsqu\'elles seront autorisées, nous allons vous le faire savoir!',
        'MEANWHILE_FEEL_FREE_MUSIC' => 'En attendant, sentez-vous libre <a %s>d\'ouvrir une autre fenêtre</a> et de continuer à naviguer le réseau « %s ». Lorsque le téléchargement sera terminé, vous allez avoir l\'occasion d\'ajouter un titre et une description à vos chansons.',
        'TRACKS_EXCEEDED_LIMIT' => 'La/les chanson(s) semble(nt) excéder la taille limite permise de 10 Mo.',
        'EDIT_TRACK_INFORMATION' => 'Modifier Information Chanson',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_1' => 'Ajoutez un titre, une description, ainsi que d\'autres informations sur la/les chanson(s) que vous venez de télécharger.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_2' => 'Ajoutez un titre, une description, ainsi que d\'autres informations sur cette chanson.',
        'CANCEL_AND_RETURN_TO_PLAYLIST' => 'Â« Annuler et retourner à la sélection',
        'TRACK_TITLE' => 'Titre de la Chanson',
        'TRACK_ARTIST' => 'Artiste',
        'TRACK_ALBUM' => 'Album',
        'ENABLE_DOWNLOAD_LINK' => 'Permettre le téléchargement de la chanson',
        'ALLOW_PEOPLE_TO_ADD_TRACK_TO_PROFILE' => 'Permettre aux membres d\'ajouter cette chanson à leurs pages',
        'TRACK_ARTWORK' => 'Image',
        'EDIT_PLAYLIST' => 'Modifier Playlist',
        'DRAG_TO_CHANGE_ORDER_PLAYLIST' => 'Pour réorganiser votre playlist, cliquez sur la chanson et traînez la où vous voulez sur la liste.',
        'ADD_MUSIC_ELLIPSIS' => 'Ajouter de la musique...',
        'ELLIPSIS_FROM_YOUR_COMPUTER' => '…de votre ordinateur',
        'UPLOAD_MP3_FROM_YOUR_COMPUTER' => 'Télécharger des fichiers MP3 à partir de votre ordinateur.',
        'DELETE_THIS_TRACK_Q' => 'Supprimer Cette Chanson?',
        'DELETE_TRACK' => 'Supprimer Chanson',
        'ARE_YOU_SURE_DELETE_THIS_TRACK' => 'Êtes-vous sûr de vouloir supprimer cette chanson?',
        'PLAY' => 'lire',
        'GENRE' => 'Genre',
        'YEAR' => 'Année',
        'LABEL' => 'Maison de disques',
        'EXPLICIT_LYRICS' => 'Paroles Explicites',
        'ARTIST_SITE' => 'Site Web de l\'Artiste',
        'HOSTING_SITE' => 'Site d\'Hébergement',
        'LABEL_SITE' => 'Site Web de la Maison de disques',
        'LICENSE' => 'Licence',
        'SELECT_LICENSE' => '— Sélectionnez une license —',
        'LICENSE_NAME' => 'Nom de la license',
        'MUSIC' => 'Musique',
        'ALLOW_PEOPLE_TO_UPLOAD_AND_SHARE_AUDIO' => 'Permettre aux membres de télécharger et partager de la musique',
        'PLAYLIST' => 'Playlist',
        'PODCAST' => 'Podcast',
        'MOST_RECENT_TRACKS' => 'Les plus récent(e)(s)',
        'FEATURED_TRACKS' => 'En Primeur',
        'HIGHEST_RATED_TRACKS' => 'Les mieux coté(e)(s)',
        'BOX_WILL_NOT_SHOW_TRACKS' => 'Cette boîte ne va pas être affichée s\'il n\'y a pas de chansons ou balados à afficher. Pourquoi ne pas en ajouter?',
        'NO_FEATURED_TRACKS' => 'Il n\'y a pas de chansons en primeur sur votre réseau.',
        'START_FEATURING_TRACKS' => 'Mettez en primeur les chansons que vous voulez voir apparaître à la page principale',
        'VIEW_MUSICPLAYER' => 'Voir lecteur audio',
        'MY_PLAYLIST' => 'Ma Playlist',
        'NETWORK_PLAYLIST' => 'Playlist du Réseau',
        'COPYRIGHT' => '© Tous Droits Réservés',
        'CC_BY_X' => 'Creative Commons Attribution %s',
        'CC_BY_SA_X' => 'Creative Commons Attribution Share Alike %s',
        'CC_BY_ND_X' => 'Creative Commons Attribution No Derivatives %s',
        'CC_BY_NC_X' => 'Creative Commons Attribution Non-commercial %s',
        'CC_BY_NC_SA_X' => 'Creative Commons Attribution Non-commercial Share Alike %s',
        'CC_BY_NC_ND_X' => 'Creative Commons Attribution Non-commercial No Derivatives %s',
        'PUBLICDOMAIN' => 'Domaine Publique',
        'FACEBOOK_CONFIRM_DISABLE' => 'Êtes-vous sûr?',
        'FACEBOOK_PLAYER_DISABLE' => 'Désactiver',
        'FACEBOOK_MUSIC_PLAYER_TITLE' => 'Lecteur Audio',
        'FACEBOOK_MUSIC_PLAYER_DESC' => 'Permettre à n\'importe qui d\'ajouter une application, leur permettant de faire jouer votre sélection musicale, à leur page de profil sur Facebook.',
        'FACEBOOK_MUSIC_BUTTON' => 'Créer une Application de Lecteur Audio &raquo;',
        'FACEBOOK_MUSIC_PLAYER_ENABLED' => 'Le Lecteur Audio Facebook est déjà activé.',
        'FACEBOOK_VIDEO_PLAYER_DESC' => 'Permettre à n\'importe qui d\'ajouter une application, leur permettant de faire jouer une vidéo de votre réseau, à leur page de profil sur Facebook.',
        'FACEBOOK_SLIDESHOW_PLAYER_TITLE' => 'Diaporama de Photos',
        'FACEBOOK_SLIDESHOW_PLAYER_DESC' => 'Permettre à n\'importe qui d\'ajouter une application, leur permettant de faire jouer un diaporama de photos de votre réseau, à leur page de profil sur Facebook.',
        'FACEBOOK_SLIDESHOW_BUTTON' => 'Créer une Application de Diaporama de Photos &raquo;',
        'FACEBOOK_SLIDESHOW_PLAYER_ENABLED' => 'Le Diaporama de Photos Facebook est déjà activé.',
        'FACEBOOK_PLATFORM_LOGO' => 'Logo de la plateforme Facebook',
        'FACEBOOK_QUICK_INTRO_1' => 'Facebook, un populaire réseau social, permet aux développeurs de créer des applications pouvant être ajoutées à la page de profil de leurs membres. En plus d\'ajouter de nouvelles fonctionnalités à la page de profil, ces applications servent aussi à rediriger le traffic de Facebook vers d\'autres sites web.',
        'FACEBOOK_QUICK_INTRO_2' => 'Avec Ning, vous n\'avez pas besoin d\'être un développeur afin de promouvoir votre réseau social sur Facebook. Nous avons déjà fait la plus grande partie du travail et votre réseau social est déjà muni du processus vous permettant d\'intégrer vos applications sur Facebook. Veuillez tout simplement choisir une/des option(s) ci-dessous et votre réseau social va être intégré sur Facebook en quelques secondes.',
        'FACEBOOK_ADD_DEVELOPER_BUTTON' => 'Ajouter bouton de développeur',
        'FACEBOOK_SETUP_NEW_APP_BUTTON' => 'Créer bouton pour Nouvelle Application',
        'FACEBOOK_YOUR_APPLICATIONS' => 'Vos Applications Facebook',
        'FACEBOOK_EMBEDDING' => 'Promouvoir sur Facebook',
        'FACEBOOK_SETUP' => 'Promouvoir sur Facebook',
        'FACEBOOK_PROMOTING' => 'Promouvoir vos Applications sur Facebook',
        'FACEBOOK_VIEW_APP' => 'Voir Application',
        'FACEBOOK_ADD_THE' => 'Ajouter le',
        'FACEBOOK_RECENT' => 'Les plus récent(e)(s)',
        'FACEBOOK_RECENTLY_FEATURED' => 'Dernièrement En Primeur',
        'FACEBOOK_RECENTLY_ADDED' => 'Ajoutés Dernièrement',
        'FACEBOOK_PROMOTED' => 'En Primeur',
        'FACEBOOK_RATED' => 'Les mieux coté(e)(s)',
        'FACEBOOK_POPULAR' => 'Populaires',
        'FACEBOOK_MUSIC_WIDGET' => 'Widget Audio',
        'FACEBOOK_PHOTO_WIDGET' => 'Widget Photos',
        'FACEBOOK_INSTR_FIRST_STEPS' => 'Étapes Préliminaires',
        'FACEBOOK_INSTR_CLICK_HERE_TO_GO_TO_FACEBOOK' => 'Cliquez ici pour aller sur Facebook afin de créer votre application.',
        'FACEBOOK_INSTR_FIRST_STEPS_1' => 'Si n\'avez pas encore créé d\'application sur Facebook, vous allez être invité à ajouter une « Facebook\'s Developer application ». Après cela, vous allez voir le texte « You have no applications. » Cliquez sur <strong>Create one</strong>.',
        'FACEBOOK_INSTR_FIRST_STEPS_2' => 'Si avez déjà créé une application sur Facebook, vous allez atterrir sur la page « Facebook\'s Developer application ». Cliquez sur le bouton <strong>Set Up New Application</strong>.',
        'FACEBOOK_INSTR_FIRST_STEPS_NEXT' => 'Étape Suivante: Instructions pour la mise en place de votre application %s sur Facebook.',
        'FACEBOOK_INSTR_SETUP' => 'Instructions pour la mise en place',
        'FACEBOOK_INSTR_SETUP_1' => 'Parfait! Maintenant pour les petits détails. Facebook a besoin d\'obtenir certaines informations de base pour mettre en place votre application. Veuillez tout simplement suivre les étapes ci-dessous.',
        'FACEBOOK_INSTR_SETUP_REQ_FIELDS' => 'Champs Requis',
        'FACEBOOK_INSTR_SETUP_2' => 'Choisissez un <strong>Application Name</strong> (Nom d\'Application).',
        'FACEBOOK_INSTR_SETUP_3' => 'Cocher pour indiquer que vous avez lu les termes d\'utilisation de Facebook (terms document).',
        'FACEBOOK_INSTR_SETUP_4' => 'Ouvrez la section <em>Optional Fields</em> (Champs Optionnels).',
        'FACEBOOK_INSTR_SETUP_BASE_OPT' => 'Options de Base',
        'FACEBOOK_INSTR_SETUP_5' => 'Entrez votre adresse électronique dans le champ <strong>Support courriel</strong>.',
        'FACEBOOK_INSTR_SETUP_7_EXAMPLE_X' => 'Choisir une <strong>Adresse URL de page mate</strong> (ex. <em>%s</em>).',
        'FACEBOOK_INSTR_SETUP_8' => 'Choisissez <strong>Yes</strong> (Oui) pour la question <em>"Can your application be added on Facebook"</em>.',
        'FACEBOOK_INSTR_SETUP_INST_OPT' => 'Options d\'Installation',
        'FACEBOOK_INSTR_SETUP_APP_DESC' => 'Entrez une <strong>Description pour cette Application</strong>.',
        'FACEBOOK_INSTR_SETUP_9' => 'Copiez et collez le code suivant dans le champ <strong>FBML par défaut </strong>:',
        'FACEBOOK_INSTR_SETUP_9B_WIDE' => 'Pour la question <strong>Default Profile Box Column</strong>, choisissez <strong>Wide</strong>.',
        'FACEBOOK_INSTR_SETUP_9B_NARROW' => 'Pour la question <strong>Default Profile Box Column</strong>, choisissez <strong>Narrow</strong>.',
        'FACEBOOK_INSTR_SETUP_10' => 'Pour le champ <strong>Side Nav URL</strong>, entrez le <em>Canvas Page URL</em> (créé à l\'étape &#8216;f&#8217; ci-dessus). Soyez certain d\'inclure la portion « http://apps.facebook.com/ » de l\'URL.',
        'FACEBOOK_INSTR_APPLICATION_SETUP_PAGE' => 'Page de mise en place d\'une application sur Facebook',
        'FACEBOOK_INSTR_SETUP_DONE' => 'Lorsque vous avez terminé, cliquez sur le bouton <strong>Soumettre</strong>.',
        'FACEBOOK_INSTR_SETUP_NEXT' => 'Étape suivante: Récupérer votre Clé (API Key) et secret.',
        'FACEBOOK_API_INFO_TITLE' => 'Facebook API Information',
        'FACEBOOK_API_INFO_DESC' => 'Afin de compléter votre mise en place, vous devez entrer votre Clé (API Key) et secret, ainsi que l\'URL de votre Application dans les champs ci-dessous.',
        'FACEBOOK_API_INFO_FIND_KEY' => 'Vous pouvez trouver votre clé (API Key) et secret sur votre page <a %s>Ma page d\'applications sur Facebook</a> (s\'ouvre dans une nouvelle fenêtre) en dessous du titre de l\'application que vous venez de créer.',
        'FACEBOOK_API_INFO_MY_APPLICATIONS_PAGE' => 'Ma page d\'applications (avec mise en évidence de la location de l\'info API)',
        'FACEBOOK_API_INFO_KEY' => 'Clé (API Key)',
        'FACEBOOK_API_INFO_SECRET' => 'API Secret',
        'FACEBOOK_URL_INFO_TITLE' => 'URL de l\'Application Facebook',
        'FACEBOOK_URL_INFO_DESC' => 'URL de l\'Application est le même que celui de la page <strong>Canvas Page URL</strong> que vous avez définie à la page précédente (étape &#8216;f&#8217;).',
        'FACEBOOK_MUSIC_SHOULD_PLAY_FROM' => 'Les applications musicales Facebook devraient lire:',
        'FACEBOOK_VIDEO_SHOULD_PLAY_FROM' => 'Les applications vidéo Facebook devraient lire la vidéo qui est:',
        'FACEBOOK_PHOTO_SHOULD_PLAY_FROM' => 'Les applications diaporamas Facebook devraient lire les photos de:',
        'FACEBOOK_PROMOTING_ON' => 'Promouvoir sur Facebook',
        'FACEBOOK_SETUP_INSTR' => 'Instructions pour la mise en place',
        'FACEBOOK_API_INFO' => 'Information sur l\'API',
        'FACEBOOK_DISABLE' => 'Désactiver cette Application',
        'FACEBOOK_TO_YOUR_FACEBOOK_PROFILE' => 'à votre profil sur Facebook',
        'FACEBOOK_BACK_TO_EMBEDDING' => 'Retour vers « Promouvoir sur Facebook »',
        'FACEBOOK_EMBEDDING_DESC' => 'Permettre aux usagers de Facebook d\'ajouter des widgets réseau ainsi que des insignes à leurs pages de profil.',
        'FACEBOOK_PROMOTE' => 'Pour maximiser l\'impact lors de la promotion de votre nouvelle application, nous vous recommandons de suivre les étapes suivantes. Ces options peuvent être accédées à partir de la page <strong><a %s>My Applications</a></strong> sur Facebook (s\'ouvre dans une nouvelle fenêtre).',
        'FACEBOOK_PROMOTE_TITLE_ABOUT_PAGE' => 'Fournir une page d\'info (About Page)',
        'FACEBOOK_PROMOTE_TEXT_ABOUT_PAGE' => 'Informez les usagers de Facebook à propos de votre application. Pour modifier cette information, cliquez sur le lien <strong>Modifier à propos de la page</strong> à côté de l\'application que vous êtes en train de modifier.',
        'FACEBOOK_PROMOTE_TITLE_SUBMIT' => 'Soumettre l\'Application au « Facebook Directory »',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_1' => 'Faites la promotion de votre nouvelle application en l\'ajoutant au « Facebook directory ».',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_2' => 'Pour soumettre votre application, cliquez sur le lien <strong>Soumettre application</strong> à côté de l\'application que vous êtes entrain de modifier. Sur la page suivante, vous pouvez modifier la description de votre application ainsi que son logo.',
        'FACEBOOK_PROMOTE_TITLE_PROFILE' => 'Ajouter l\'Application à votre Profil sur Facebook (Facebook Profile)',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_1' => 'Montrez votre application en l\'ajoutant à votre page de profil Facebook, puis assoyez-vous et regardez vos amis faire pareil.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_2' => 'Cliquez sur le lien <strong>View About Page</strong> à côté de l\'application que vous voulez ajouter à votre profil, ensuite cliquez sur le bouton « Ajouter Application » de la page suivante.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_3' => 'Votre application est maintenant au bas de page de profil sur Facebook!',
        'FACEBOOK_PROMOTE_MY_APPLICATIONS_PAGE' => 'Ma page d\'applications sur Facebbok',
        'FACEBOOK_MY_APPS' => 'Mes Applications',
        'FORUM_TAB_TEXT' => 'Forum',
        'VIDEOS_TAB_TEXT' => 'Vidéos',
        'PHOTOS_TAB_TEXT' => 'Photos',
        'GROUPS_TAB_TEXT' => 'Groupes',
        'EACH_VIDEO_MAY_BE_100MB' => 'Chaque vidéo peut atteindre jusqu’à 100 MB. Nous acceptons des fichiers vidéo en formats .mov, .mp4, .mpg, .avi, .wmv et .3gp. ',
        'I_HAVE_RIGHT_TO_UPLOAD_VIDEO' => 'J’ai le droit de télécharger cette vidéo en vertu des  <a %s>Conditions de service</a>. ',
        'VIDEO_UPLOADER_REQUIRES_JAVA' => 'Ce téléchargeur de vidéos en série nécessite la version récente de Java. <strong><a %s>Cliquez ici pour installer Java</a></strong>, ou <strong><a %s>ou utilisez le téléchargeur simple</a></strong>. ',
        'UPLOAD_A_VIDEO_FROM_YOUR_COMPUTER' => 'Télécharger une vidéo à partir de votre ordinateur ',
        'HAVE_LOT_OF_VIDEOS' => 'Vous avez plusieurs vidéos à partager? ',
        'TRY_BULK_VIDEO_UPLOADER' => 'Essayez le téléchargeur de vidéos en série ',
        'VIDEOS_SUCCESSFULLY_UPLOADED' => 'Vos vidéos ont été téléchargées avec succès. ',
        'VIDEOS_UPLOADED_AWAITING' => 'Vos vidéos ont été téléchargées avec succès et elles sont en attente d\'approbation du %s\'s créateur. ',
        'ADD_VIDEOS_OR_PHOTOS_TO_APPNAME' => 'Ajoutez des photos ou des vidéos directement sur le réseau « %s » par téléphone en les envoyant à une adresse de courriel unique. ',
        'GRAB_HTML_EMBED' => 'Copiez/Collez un « code d\'incrustation HTML » de n\'importe quel site de vidéos populaire et ajoutez la vidéo à ce réseau. ',
        'GOOGLE' => 'Google ',
        'YOUTUBE' => 'YouTube ',
        'HAVING_PROBLEMS_WITH_VIDEO_UPLOADER' => 'Vous éprouvez des problèmes avec le téléchargeur de vidéos en série?  <strong><a %s>Utilisez le téléchargeur simple</a></strong>. ',
        'ADD_VIDEOS_FROM_YOUTUBE' => 'Ajouter des vidéos provenant de YouTube ou Google. ',
        'TAGS_NO_COLON' => 'Repères ',
        'NO_VIDEOS_TAGGED_X_CHECK' => 'Il n\'y a aucune vidéo ayant comme repère "%1$s". Vérifiez <a %2$s>les discussions ayant comme repère "%1$s"</a>, <a %4$s>les entrées ayant comme repère "%1$s"</a> ou <a %3$s>les photos ayant comme repère "%1$s"</a>. Ou bien, ajoutez vos propres repères aux vidéos! ',
        'UPLOAD_VIDEOS_FROM' => 'Ajouter des vidéos à partir de votre ordinateur. ',
        'ADD_VIDEOS_BY_PHONE_OR' => 'Ajouter des vidéos par téléphone ou par courriel. ',
        //music player
        'FEATURING_ELLIPSIS' => 'En Primeur...',
        'OPEN_POPUP_WINDOW' => 'Ouvrir Fenêtre Contextuelle',
        'NOW_FEATURED_ON_MAIN' => 'Présentement en vedette sur la page principale ',
        'DONT_FEATURE' => 'Ne pas mettre en vedette ',
        'UNFEATURING_ELLIPSIS' => 'En train de supprimer de la page principale... ',
        'REMOVED_FROM_MAIN' => 'Removed from Main ',
        'ADDED_EXCLAMATION' => 'Ajouté! ',
        'ERROR' => 'Erreur ',
        'ADDING_ELLIPSIS' => 'Ajout en cours… ',
        'TRACK_COULD_NOT_BE_LOADED' => 'Le fichier audio n’a pas pu être téléchargé ',
        'INVALID_URL' => 'URL invalide ',
        'NORMAL_PLAYBACK_ON' => 'Lecture normale: Activée ',
        'REPEAT_PLAYBACK_ON' => 'Lecture répétée: Activée ',
        'SHUFFLE_PLAYBACK_ON' => 'Lecture aléatoire: Activée ',
        'LOADING_PLAYLIST_ELLIPSIS' => 'Téléchargement de la liste d’écoute... ',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Vos Données de Membre ont été exportées.  Cliquez sur <a %s>ce lien</a> pour les sauvegarder dans votre ordinateur. ',
        'SET_NEW_PASSWORD' => 'Créez un nouveau mot de passe pour votre compte. ',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Cliquez sur « Modifier » pour ajouter un texte, un code HTML, des vidéos, des photos, ou des « <a %1$s>widgets tiers</a> » à cette boîte. ',
        'EACH_PHOTO_MAY_BE_UP_TO_10MB' => 'Chaque photo peut atteindre jusqu’à 10 MB. Nous acceptons les fichiers photo en formats .jpg, .gif et .png. ',
        'I_HAVE_RIGHT_TO_UPLOAD_PHOTOS' => 'J\'ai le droit de télécharger ces photos en vertu des <a %s>Conditions de service</a>. ',
        'PHOTO_UPLOADER_REQUIRES_JAVA' => 'Le téléchargeur de photos en série nécessite la version récente de Java. <strong><a %s>Cliquez ici pour installer Java</a></strong>, ou <strong><a %s>utilisez le téléchargeur simple</a></strong>. ',
        'TRY_BULK_PHOTO_UPLOADER' => 'Essayez le téléchargeur de photos en série ',
        'HAVE_LOT_OF_PHOTOS' => 'Vous avez plusieurs photos à partager? ',
        'PHOTOS_SUCCESSFULLY_UPLOADED' => 'Vos photos ont été téléchargées avec succès. ',
        'PHOTOS_UPLOADED_AWAITING' => 'Vos photos ont été téléchargées avec succès et elles sont en attente d\'approbation du %s\'s créateur. ',
        'FLICKR' => 'Flickr ',
        'ADD_PHOTOS_FROM_FLICKR' => 'Ajouter les photos de votre compte Flickr ',
        'ADD_PHOTOS_OR_VIDEOS_TO_APPNAME' => 'Ajoutez des photos ou des vidéos directement sur le réseau « %s » par téléphone en les envoyant à une adresse de courriel unique. ',
        'HAVING_PROBLEMS_WITH_PHOTO_UPLOADER' => 'Vous éprouvez des problèmes avec le téléchargeur de vidéos en série?  <strong><a %s>Utilisez notre téléchargeur simple</a></strong>. ',
        'VIEW_SLIDESHOW' => 'Voir Diaporama ',
        'NO_PHOTOS_TAGGED_X_CHECK' => 'Il n\'y a aucune photo ayant comme repère "%1$s". Vérifiez <a %2$s>les discussions ayant comme repère "%1$s"</a>, <a %4$s>les entrées ayant comme repère "%1$s"</a> ou <a %3$s>les vidéos ayant comme repère "%1$s"</a>. Ou bien, ajoutez vos propres repères aux photos! ',
        'PHOTO_MAY_BE_10MB' => 'Chaque photo peut atteindre jusqu’à 10 MB, mais des photos plus petites pourront être téléchargées plus rapidement. Nous acceptons des fichiers photos en format .jpg, .gif et .png. ',
        'UPLOAD_PHOTOS_FROM_YOUR_COMPUTER' => 'Télécharger des photos à partir de votre ordinateur ',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Cliquez sur « Modifier » pour ajouter un texte, un code HTML, des vidéos, des photos, ou des « <a %1$s>widgets tiers</a> » à cette boîte. ',
        'PLEASE_SELECT_A_MEMBER' => 'Veuillez sélectionner un ou plusieurs membres ',
        'RESEND_INVITATION' => 'Renvoyer l’invitation ',
        'CHOOSE_FRIENDS' => 'Choisir des amis... ',
        'SORRY_WE_DO_NOT_SUPPORT' => 'Désolé, nous ne supportons pas le carnet d’adresses Web pour votre adresse électronique. Essayer de cliquer \'Email Application\' plus bas pour vous servir des adresses de votre ordinateur. ',
        'WANT_TO_INVITE_MORE_FRIENDS' => 'Vous voulez inviter plus d’ami(e)s? Inviter plus d’ami(e)s en important les coordonnées de votre carnet d’adresses Web ou gestionnaire de courriels. ',
        'MICROSOFT_OUTLOOK_APPLE_ADDRESS_BOOK' => 'Microsoft Outlook, Apple Mail, .CSV, etc. ',
        'SET_NEW_PASSWORD' => 'Créez un nouveau mot de passe pour votre compte. ',
        'APPLY_FOR_MEMBERSHIP_SIGN_IN' => 'S’inscrire comme membre dès maintenant. Déjà membre? <a %s>Cliquez ici pour ouvrir une session</a>. ',
        'FEATURED_MEMBERS' => 'Membres en vedette ',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Vos Données de Membre ont été exportées.  Cliquez sur <a %s>ce lien</a> pour les sauvegarder dans votre ordinateur. ',
        'SORRY_NO_MEMBERS_MATCHING_X_WERE_FOUND' => 'Désolé, aucun membre correspondant à "%s" n’a été trouvé. ',
        'WHO_CAN_COMMENT_ON_POST' => 'Qui peut commenter cette entrée? ',
        'PREVIOUS_POST' => '← Entrée précédente ',
        'NEXT_POST' => 'Entrée suivante  →',
        'PREVIOUS_POSTS' => '←  Entrées précédentes ',
        'NEXT_POSTS' => 'Entrées suivantes  →',
        'NO_BLOG_POSTS_TAGGED_X_CHECK' => 'Il n\'y a aucune entrée ayant comme repère "%1$s". Vérifiez <a %2$s>les discussions ayant comme repère "%1$s"</a>, <a %4$s>les photos ayant comme repère "%1$s"</a> ou <a %3$s>les vidéos ayant comme repère "%1$s"</a>. Ou bien, ajoutez vos propres repères aux entrées! ',
        'ALL_POSTS_TAGGED_X_FOR_M_Y' => 'Tous les entrées ayant comme repère <em>\'%s\'</em> pour %s %s ',
        'ALL_POSTS_TAGGED_X' => 'Toutes les entrées ayant comme balise <em>\'%s\'</em> ',
        'MY_BLOG_POSTS_FOR_M_Y' => 'Mes entrées pour %s %s ',
        'MY_BLOG_POSTS' => 'Mes entrées ',
        'PRIVACY_CONTENT_CONTROL' => 'Contrôle du contenu et l’intimité ',
        'MODERATION' => 'Contrôle du contenu ',
        'ENABLE_MUSIC_DOWNLOAD_LINKS' => 'Permettre au lecteur de musique de télécharger des fichiers ',
        'NOTIFY_BLOG_PING_SERVICES' => 'Voulez-vous notifier des services tiers de suivi des blogs lorsque vous ajoutez une nouvelle entrée? ',
        'YES_NOTIFY_BLOG_SERVICES' => 'Oui – Äì Avisez <a %s>les services de mise à jour du site</a> lorsque j’ajoute une nouvelle entrée ',
        'THERE_ARE_NO_FEATURED_MEMBERS' => 'Il n’y a aucun Membre en vedette dans votre réseautage personnel. ',
        'START_FEATURING_MEMBERS_CLICK_Y' => 'Commencez à mettre les membres en vedette lorsque vous apercevez l’option « Mettre en vedette ». Pour en apprendre plus sur la mise en vedette, <a %s>cliquez ici</a>. ',
        'SHOW_ALL' => 'Afficher tous ',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_ADD' => 'Il n\'y a aucune discussion ayant comme repère "%1$s". Vérifiez <a %2$s>les photos ayant comme repère "%1$s"</a>, <a %4$s>les entrées ayant comme repère "%1$s"</a> ou <a %3$s>les vidéos ayant comme repère "%1$s"</a>. Ou bien, ajoutez vos propres repères aux discussions! ',
        'NO_DISCUSSIONS_TAGGED_X_CHECK' => 'Il n\'y a aucune discussion ayant comme repère "%1$s". Vérifiez <a %2$s>les photos ayant comme repère "%1$s"</a>, <a %4$s>les entrées ayant comme repère "%1$s"</a> ou <a %3$s>les vidéos ayant comme repère "%1$s"</a>. ',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => 'Vous avez créé le groupe %1$s. Vous pouvez lancer une discussion sur le forum %1$s ou bien inviter d\'autres gens à se joindre. ',
        'YOU_CAN_ADD_100_SONGS' => 'Vous pouvez ajouter un total de 100 chansons, dont chacune peut atteindre 20 MB. Nous acceptons des chansons en format .mp3. ',
        'I_HAVE_RIGHT_TO_UPLOAD_SONGS' => 'J’ai le droit de télécharger ces chansons en vertu des  <a %s>Conditions de service</a>. ',
        'MUSIC_UPLOADER_REQUIRES_JAVA' => 'Ce téléchargeur de vidéos en série nécessite la version récente de Java. <strong><a %s>Cliquez ici pour installer Java</a></strong>, ou <strong><a %s>utilisez le téléchargeur simple</a></strong>. ',
        'HAVE_LOT_OF_MUSIC' => 'Vous avez beaucoup de musique à partager? ',
        'TRY_BULK_MUSIC_UPLOADER' => 'Essayez le téléchargeur de musique en série ',
        'SONGS_SUCCESSFULLY_UPLOADED' => 'Vos fichiers audio ont été téléchargés avec succès. ',
        'SORRY_YOU_CAN_ONLY_HAVE_N_TRACKS' => 'Désolé, vous pouvez seulement avoir %s fichiers audio dans votre liste d’écoute. Veuillez enlever quelques fichiers audio existant avant d’en ajouter d’autres. ',
        'ADD_MUSIC_FROM_WEBSITE' => 'Ajouter de la musique à partir d’un autre site Web. ',
        'HAVING_PROBLEMS_WITH_MUSIC_UPLOADER' => 'Vous éprouvez des problèmes avec ce téléchargeur de musique en série?  <strong><a %s>Utilisez notre téléchargeur simple</a></strong>. ',
        'UPLOAD_MUSIC_FROM_YOUR_COMPUTER' => 'Télécharger de la musique à partir de votre ordinateur. ',
        'ADD_MUSIC' => 'Ajouter Musique ',
        'FACEBOOK_INSTR_SETUP_APP_PERMISSION' => 'Sélectionnez <strong>Utilisateurs</strong> et <strong>Toutes les pages</strong>. ',



    );

    /**
     * If the given widget title is the default English title for the widget,
     * translate it into the current language.
     *
     * @param $widgetTitle string  The title of the widget
     * @return string  A translated title if the title is the English default; otherwise, the title unchanged
     */
    public static function translateDefaultWidgetTitle($widgetTitle) {

        return $widgetTitle;
    }

}