<?php

XG_App::includeFileOnce('/lib/XG_AbstractMessageCatalog.php');

/**
 * Texts for the fi_FI
 */
class XG_MessageCatalog_fi_FI extends XG_AbstractMessageCatalog {


    /**
     * Returns a localized version of a string. The first argument is the message name, e.g., 'ADD_A_PHOTO'.
     * Subsequent arguments are substitution values (if the message contains sprintf format elements).
     *
     * @param array $args the message name, plus optional substitution values
     * @return string the localized string
     * @see xg_html()
     */
    public static function text($args) {
        $s = $args[0];
        static $a = array();
        if (! $a) {
            $a['N_SECONDS_AGO']['1'] = '1sekunti sitten ';
            $a['N_SECONDS_AGO']['n'] = '%s sekuntia sitten ';
            $a['N_MINUTES_AGO']['1'] = '1 minuutti sitten ';
            $a['N_MINUTES_AGO']['n'] = '%s minuuttia sitten ';
            $a['N_HOURS_AGO']['1'] = '1 tunti sitten ';
            $a['N_HOURS_AGO']['n'] = '%s tuntia sitten ';
            $a['N_VIDEOS']['1'] = '<strong>1</strong> Video ';
            $a['N_VIDEOS']['n'] = '<strong>%s</strong> videota ';
            $a['N_VIEWS']['1'] = '1 katselu ';
            $a['N_VIEWS']['n'] = '%s katselua ';
            $a['N_COMMENTS']['1'] = '<span class="comment-count">1</span> kommentti ';
            $a['N_COMMENTS']['n'] = '<span class="comment-count">%s</span> kommenttia ';
            $a['VIDEO_IS_FAVORITE_OF']['1'] = 'Tämä video on <strong>1 henkilön</strong><strong>suosikki</strong> . ';
            $a['VIDEO_IS_FAVORITE_OF']['n'] = 'Tämä video on  <strong>%s henkilön</strong><strong>suosikki</strong> . ';
            $a['Y_ADDED_X_VIDEOS']['1'] = '%2$s lisäsi videon: ';
            $a['Y_ADDED_X_VIDEOS']['n'] = '%2$s lisäsi %s videota. ';
            $a['YOU_ADDED_X_VIDEOS']['1'] = 'Sinä lisäsit videon: ';
            $a['YOU_ADDED_X_VIDEOS']['n'] = 'Sinä lisäsit %s videota. ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['1'] = '%2$s:ssa on 1 video ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['n'] = '%2$s:ssa on %1$s videota ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['1'] = '%2$s:ssa on 1 <a href="%3$s">video</a> ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['n'] = ' %2$s:ssa on %1$s <a href="%3$s">videota</a> ';
            $a['N_PHOTOS_FROM_ALBUM']['1'] = '1 valokuva tässä albumissa on poistettu tai muutettu yksityiseksi niin, ettei sitä voi näyttää. ';
            $a['N_PHOTOS_FROM_ALBUM']['n'] = '%s valokuvaa tässä albumissa on poistettu tai muutettu yksityisiksi niin, ettei niitä voi näyttää. ';
            $a['N_PHOTOS']['1'] = '<strong>1</strong> valokuva ';
            $a['N_PHOTOS']['n'] = '<strong>%s</strong> valokuvaa ';
            $a['N_PHOTOS_2']['1'] = '1 valokuva ';
            $a['N_PHOTOS_2']['n'] = '%s valokuvaa ';
            $a['PROBLEM_UPLOADING_FILES']['1'] = 'On tapahtunut virhe ladattaessa seuraavaa tiedostoa: ';
            $a['PROBLEM_UPLOADING_FILES']['n'] = 'On tapahtunut virhe ladattaessa seuraavia tiedostoja: ';
            $a['PHOTO_IS_FAVORITE_OF']['1'] = 'Tämä valokuva on  <strong>1 henkilön</strong><strong>suosikki</strong>. ';
            $a['PHOTO_IS_FAVORITE_OF']['n'] = 'Tämä valokuva on <strong>%s henkilön</strong><strong>suosikki</strong>. ';
            $a['RATING_Y_AFTER_X_VOTES']['1'] = '<strong>Arvosana:</strong> %2$s 1 äänen perusteella ';
            $a['RATING_Y_AFTER_X_VOTES']['n'] = '<strong>Arvosana:</strong> %2$s %s äänen perusteella ';
            $a['Y_AFTER_X_VOTES']['1'] = '%2$s 1 äänen jälkeen ';
            $a['Y_AFTER_X_VOTES']['n'] = '%2$s %s äänen jälkeen ';
            $a['N_PEOPLE']['1'] = '1 henkilö ';
            $a['N_PEOPLE']['n'] = '%s henkilöä ';
            $a['N_OF_5_STARS']['1'] = '1/5 tähteä ';
            $a['N_OF_5_STARS']['n'] = '%s/5 tähteä ';
            $a['YOUR_RATING_X_STARS']['1'] = 'Sinun arvostelusi: 1 tähti ';
            $a['YOUR_RATING_X_STARS']['n'] = 'Sinun arvostelusi: %s tähteä ';
            $a['Y_ADDED_X_PHOTOS']['1'] = '%2$s lisäsi valokuvan: ';
            $a['Y_ADDED_X_PHOTOS']['n'] = '%2$s lisäsi %s valokuvaa. ';
            $a['YOU_ADDED_X_PHOTOS']['1'] = 'Sinä lisäsit valokuvan: ';
            $a['YOU_ADDED_X_PHOTOS']['n'] = 'Sinä lisäsit %s valokuvaa. ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['1'] = '%2$s:ssa on 1 valokuva ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['n'] = ' %2$s:ssa on %1$s valokuvaa ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['1'] = '%2$s:ssa on %1$s <a href="%3$s">kuvaa</a> ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['n'] = '%2$s:ssa on  %1$s <a href="%3$s">kuvaa</a> ';
            $a['N_INVITATIONS_RESENT']['1'] = '1 kutsu on lähetetty uudelleen. ';
            $a['N_INVITATIONS_RESENT']['n'] = '%s kutsua on lähetetty uudelleen. ';
            $a['AND_X_OTHER_PEOPLE']['1'] = 'ja 1 muu henkilö ';
            $a['AND_X_OTHER_PEOPLE']['n'] = 'ja %s muita henkilöitä ';
            $a['N_COMMENTS_ON_PAGE']['1'] = '<strong>1</strong> profiili kommentti ';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s</strong> profiili kommenttia ';
            $a['N_BLOG_COMMENTS']['1'] = '<strong>1</strong> blogi kommentti ';
            $a['N_BLOG_COMMENTS']['n'] = '<strong>%s</strong> blogi kommenttia ';
            $a['N_YEARS_OLD']['1'] = '1 vuoden vanha ';
            $a['N_YEARS_OLD']['n'] = '%s vuotta vanha ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['1'] = 'Sinulla on 1 ystäväpyyntö! ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['n'] = 'Sinulla on %s ystäväpyyntöä! ';
            $a['COMMENT_WALL_N_COMMENTS']['1'] = 'Kommenttitaulu (1 kommentti) ';
            $a['COMMENT_WALL_N_COMMENTS']['n'] = 'Kommenttitaulu (%s kommenttia) ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['1'] = '1 uusi jäsen liittynyt viime viikolla ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['n'] = '%s uutta jäsentä liittynyt viime viikolla ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['1'] = '1 <a href="%2$s">uusi jäsen</a> liittynyt viime viikolla. ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['n'] = '%1$s <a href="%2$s">uutta jäsentä</a> liittynyt viime viikolla ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['1'] = '%2$s:ssa on 1 jäsen. ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['n'] = '%2$s:ssa on %1$s jäsentä  ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['1'] = '%2$s:ssa on 1 <a href="%3$s">jäsen</a> ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['n'] = '%2$s:ssa on %1$s <a href="%3$s">jäsentä</a> ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['1'] = '%2$s:ssa on 1 blogi-posti ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['n'] = '%2$s:ssa on %1$s blogi-postia ';
            $a['N_NEW_MEMBERS']['1'] = '<strong>1</strong> Uusi jäsen ';
            $a['N_NEW_MEMBERS']['n'] = '<strong>%s</strong> Uutta jäsentä ';
            $a['N_REPLIES']['1'] = '1 vastaus ';
            $a['N_REPLIES']['n'] = '%s vastausta ';
            $a['N_MINUTES']['1'] = '1 minuutti aikaa jäljellä kommentin muokkaukseen. ';
            $a['N_MINUTES']['n'] = '%s minuuttia aikaa jäljellä kommentin muokkaukseen. ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['1'] = '%2$s:ssa on 1 keskustelun aihe  ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['n'] = ' %2$s:ssa on %1$s keskustelun aihetta ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['1'] = '%2$s:ssa on 1 <a href="%3$s">keskustelun aihe</a> ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['n'] = '%2$s:ssa on %1$s <a href="%3$s">keskustelun aihetta</a> ';
            $a['N_INVITES']['1'] = '%s kutsuu ';
            $a['N_INVITES']['n'] = '%s kutsuu ';
            $a['N_MEMBERS']['1'] = '1 jäsen ';
            $a['N_MEMBERS']['n'] = '%s jäsentä ';
            $a['N_MEMBERS_PARENTHESIZED']['1'] = '(1 jäsen) ';
            $a['N_MEMBERS_PARENTHESIZED']['n'] = '(%s jäsentä) ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['1'] = '%2$s:ssa on 1 ryhmä ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['n'] = '%2$s:ssa on %1$s ryhmää ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['1'] = '%2$s:ssa on %1$s <a href="%3$s">ryhmä</a> ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['n'] = '%2$s:ssa on %1$s <a href="%3$s">ryhmää</a>  ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['1'] = '1 kappaletta tältä soittolistalta ei voida soittaa, koska se on poistettu tai ei ole enää jaettavana. ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['n'] = '%s kappaletta tältä soittolistalta ei voida soittaa, koska ne on poistettu tai eivät ole enää jaettavina. ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['1'] = 'Uusi kappale on lisätty %2$s:een ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['n'] = '%1$s uusia kappaleita on lisätty %2$s:een ';
            $a['Y_ADDED_X_SONGS']['1'] = '%2$s lisäsi kappaleen: ';
            $a['Y_ADDED_X_SONGS']['n'] = '%2$s lisäsi %s kappaletta. ';
            $a['YOU_ADDED_X_SONGS']['1'] = 'Sinä lisäsit kappaleen: ';
            $a['YOU_ADDED_X_SONGS']['n'] = 'Sinä lisäsit %s kappaletta. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['1'] = '1 kappale lisätty tälle soittolistalle. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['n'] = '%s kappaletta lisätty tälle soittolistalle. ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['1'] = '%2$s:ssa on 1 kappale ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['n'] = ' %2$s:ssa on %1$s kappaletta ';
        }
        if ($a[$args[0]]) {
            $args[0] = $a[$args[0]][$args[1]] ? $a[$args[0]][$args[1]] : $a[$args[0]]['n'];
            return @call_user_func_array('sprintf', $args);
        }
        $text = self::$messages[$s];
        if ($text) { $args[0] = $text; }
        return @call_user_func_array('sprintf', $args);
    }

    /**
     * Message names and texts. Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;
     */
    private static $messages = array(
        'BROWSING' => 'Selaa',
        'MORE_VIDEOS' => 'Lisää videoita',
        'NETWORK_DOES_NOT_HAVE_VIDEOS' => 'Tässä verkostossa ei ole vielä videoita.',
        'NETWORK_DOES_NOT_HAVE_FEATURED_VIDEOS' => 'Tässä verkostossa ei ole vielä yhtään kiinnostavaa videota.',
        'PERSON_DOES_NOT_HAVE_VIDEOS' => 'Tällä henkilöllä ei ole vielä yhtään videota.',
        'COPY_TO_CLIPBOARD' => 'Kopioi leikepöydälle',
        'COPIED_TO_CLIPBOARD' => 'Kopioitu leikepöydälle!',
        'NO_VIDEOS_TO_DISPLAY' => 'Et ole tällä hetkellä toistamassa videoita.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_VIDEO' => 'Tämä ruutu ei näy muille henkilöille ennen kuin olet valinnut ainakin yhden videon.',
        'WATERMARK_LOGO' => 'Vesileimalogo',
        'CHOOSE_HEADER_OR_WATERMARK' => 'Voit valita videosoittimellesi joko otsikon tai vesileimalogon.',
        'CUSTOMIZE_EMBED_INSTRUCTIONS' => 'Logo näkyy %s:n yläreunassa.  Jos et lisää logoa sen tilalla näytetään verkoston nimi.  Logosi tulee olla . jpg, . gif tai . png muodossa.  Logot, jotka ovat korkeampia kuin 20 kuvapistettä pienennetään sopiviksi.',
        'CUSTOMIZE_WATERMARK_INSTRUCTIONS' => 'Vesileimalogo ilmestyy videoklipin oikeaan alakulmaan.',
        'HEADER_LOGO' => 'Otsikkologo',
        'WATERMARK' => 'Vesileima',
        'CUSTOMIZE_YOUR_VIDEO_PLAYER' => 'Mukauta videosoittimesi!',
        'VIDEO_PLAYER' => 'Videosoitin',
        'HEADER' => 'Otsikko',
        'SAVE_CHANGES' => 'Tallenna muutokset',
        'THUMBNAIL' => 'Pikkukuva',
        'CONVERSION_FAILED' => 'Konvertointi epäonnistui',
        'CONVERSION_IN_PROGRESS' => 'Konvertointi käynnissä',
        'MAP' => 'Kartta',
        'WHAT_IS_THIS' => 'Mikä tämä on?',
        'EDIT_VIDEO_INFORMATION' => 'Muokkaa videon tietoja',
        'ALL_VIDEOS' => 'Kaikki videot',
        'VIDEOS_HOME' => 'Videot aloitus',
        'MY_VIDEOS' => 'Omat videot',
        'MY_FRIENDS_VIDEOS' => 'Ystävieni videot',
        'MY_FAVORITES' => 'Suosikkini',
        'XS_FAVORITES' => '%s:n Suosikit',
        'ADD_A_VIDEO' => 'Lisää Video',
        'JUST_NOW' => 'juuri nyt',
        '1_DAY_AGO' => '1 päivä sitten',
        'M_J' => 'M j',
        'ME' => 'Minä',
        'X_SAID' => '%s sanoi…',
        'DELETE_COMMENT' => 'Poista kommentti',
        'YOU_HAVE_NOT_ADDED_VIDEOS' => 'Et ole lisännyt yhtään videota vielä!',
        'ADD_VIDEOS_AND_SHARE' => 'Lisää videoita ja jaa ne ystäviesi, perheesi  tai koko maailman kanssa!',
        'THERE_ARE_NO_VIDEOS' => 'Verkostossasi ei ole tällä hetkellä videoita.',
        'THIS_BOX_WILL_NOT_SHOW' => 'Tämä ruutu ei näy muille henkilöille ennen kuin täällä on videoita.  Miksi et lisäisi yhtä?',
        'ADD_VIDEOS' => 'Lisää videoita',
        'VIEW_VIDEOS' => 'Katsele videoita',
        'YIKES' => 'Iik!',
        'A_PROBLEM_SEEMS' => 'On ilmaantunut ongelma.',
        'FOR_FURTHER_ASSISTANCE' => 'Lisätietoa <a %s>ota yhteys meihin</a>.',
        'OR_YOU_CAN_GO' => 'Tai voit mennä takaisin <a %s>%s pääsivulle</a> tai selata <a %s>muita Ning-verkostoja</a>',
        'TAGS' => 'Tagit:',
        'POPULAR_TAGS' => 'Suosittuja tageja',
        'MY_FRIENDS' => 'Ystäväni',
        'VIEW_ALL_MY_FRIENDS' => 'Näytä kaikki ystäväni',
        'VIEW_ALL_XS_FRIENDS' => 'Näytä kaikki  %s:n ystävät',
        'WE_COULD_NOT_FIND_ANYONE_MATCHING' => 'Valitettavasti emme löytäneet ketään etsintäkriteereihisi sopivaa.',
        'VIEW_POPULAR_CONTRIBUTORS' => 'Näytä suosituimmat osallistujat',
        'POPULAR_CONTRIBUTORS' => 'Suositut osallistujat',
        'VIEW_MORE_CONTRIBUTORS' => 'Näytä lisää osallistujia',
        'ADD_AS_FRIEND' => 'Lisää ystäväksi',
        'SEND_A_MESSAGE' => 'Lähetä viesti',
        'IS_YOUR_FRIEND' => 'On ystäväsi',
        'IS_BLOCKED' => 'On estetty',
        'SORT_BY' => 'Lajiteltu:',
        'CLOSE' => 'Sulje',
        'USER_COUNT' => '(%d)',
        'NOBODY_HAS_ADDED_VIDEOS' => 'Kukaan ei ole vielä lisännyt videoita!  Lisää videoita päästäksesi alkuun.',
        'SEARCH_PEOPLE' => 'Etsi henkilöitä:',
        'INVITE_YOUR_FRIENDS_TO' => 'Kutsu ystäviäsi %s.',
        'INVITE' => 'Kutsu',
        'INVITE_TAB_TEXT' => 'Kutsu',
        'YOU_HAVE_NOT_ADDED_FRIENDS' => 'Et ole lisännyt vielä yhtään ystävää %s.',
        'SEARCH_FRIENDS' => 'Etsi ystäviä:',
        'ADD_YOUR_FIRST_VIDEO' => 'Lisää ensimmäinen videosi',
        'USE_HTML_EMBED_CODE' => 'Käytä HTML upotettua koodia',
        'UPLOAD_A_VIDEO_FROM' => 'Lataa video omalta tietokoneeltasi. Hyväksymme kaikki tunnettu tiedostomuodot!',
        'WE_SUPPORT_MOV' => 'Tuemme .mov, .mpg, .avi, .3gp ja .wmv tiedostomuotoja. Tiedostojen tulee olla 100 Mt tai pienempiä.',
        'NEED_HELP_HERE_ARE' => 'Tarvitsetko apua?  Tässä on <a %s>YouTube</a> ja <a %s>Google Video</a> ohjeet.',
        'ADD_TITLE_AND_DESCRIPTION' => 'Lisää nimi ja kuvaus',
        'DESCRIPTION_COLON' => 'Kuvaus:',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_1' => 'Lisää nimi, kuvaus ja muuta tietoa videosta jonka juuri latasit.',
        'EVERYTHING_IS_OPTIONAL' => 'Kaikki on valinnaista;  jos et halua lisätä mitään, klikkaa “Ohita tämä”  oikealla.',
        'SKIP_THIS_STEP' => 'Ohita tämä',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_2' => 'Lisää nimi, kuvaus ja muuta tietoa tästä videosta.',
        'CANCEL_AND_RETURN_TO_VIDEO' => 'Peruuta ja palaa videoon.',
        'TITLE' => 'Nimi:',
        'TAGS_ARE_SHORT_DESCRIPTIONS' => 'Tagit ovat lyhyitä kuvauksia, jotka auttavat löytämään videot.  Erottele tagit pilkuilla ja moniosaiset tagit lainausmerkeillä kuten "San Francisco".',
        'WHO_CAN_VIEW_VIDEO' => 'Kuka voi katsoa tämän videon?',
        'MOST_POPULAR' => 'Suosituin',
        'HIGHEST_RATED' => 'Korkein arvosana',
        'MOST_RECENT' => 'Uusin',
        'MOST_FAVORITED' => 'Eniten suosikeissa',
        'MOST_POPULAR_VIDEOS' => 'Suosituimmat videot',
        'HIGHEST_RATED_VIDEOS' => 'Korkeimman arvosanan videot',
        'MOST_RECENT_VIDEOS' => 'Uusimmat videot',
        'MOST_FAVORITED_VIDEOS' => 'Eniten suosikeissa olevat videot',
        'ANYONE' => 'Kuka tahansa',
        'JUST_MY_FRIENDS' => 'Vain omat ystäväni',
        'JUST_ME' => 'Vain minä',
        'VIEWABLE_BY_FRIENDS' => 'Näkyvissä <strong>ystäville</strong>',
        'PRIVATE_VIDEO' => '<strong>Yksityis</strong> video',
        'VIEWABLE_BY_EVERYONE' => 'Näkyvissä <strong>kaikille</strong>',
        'LOCATION' => 'Sijainti:',
        'NO_LOCATION' => 'Ei sijaintia',
        'CLICK_ON_LOCATION' => 'Klikkaa sijaintia kartalla:',
        'FIND_AN_ADDRESS' => 'Etsi osoite:',
        'LOCATE' => 'Etsi',
        'YOU_CAN_ADD_YOUR_OWN_VIDEO' => 'Voit <a %s>lisätä oman videon</a>  %s!',
        'ADD_PLAYER_LOGO_OR_WATERMARK' => 'Lisää logo tai vesileimakuva verkostosi videosoittimeen.  <a %s>Määritä se nyt! </a>',
        'APPROVE' => 'Hyväksy',
        'DELETE' => 'Poista',
        'APPLY_TO_VIDEOS_ADDED_BY' => 'Käytä kaikkiin %s:n lisäämiin videoihin',
        'NO_TITLE' => 'Ei nimeä',
        'ADDED_BY_STRONG_X' => 'Lisännyt <strong>%s</strong>',
        'NO_DESCRIPTION' => 'Ei kuvausta',
        'BY_X' => '%s',
        'YOU_HAVE_FINISHED_MODERATING' => 'Olet lopettanut moderoinnin',
        'NO_VIDEOS_AWAITING_APPROVAL' => 'Yhtään videota ei ole odottamassa hyväksymistä.  Jos et tiedä mitä tekisit, käy katsomassa  <a %s>uusimmat videot</a>',
        'NO_ONE_HAS_ADDED_ANY_VIDEOS' => 'Kukaan ei ole lisännyt videoita verkostoosi.  Ole ensimmäinen, joka lisää videon!',
        'ADDED_ON_DATE_BY_X' => '%s lisännyt %s.',
        'REMOVE_FROM_FAVORITES' => 'Poista suosikeista',
        'REMOVE_VIDEO_FROM_FAVORITES' => 'Haluatko poistaa tämän videon suosikeistasi?',
        'COLLECTED_BY_X' => 'Kerännyt %s',
        'ADD_FAVORITES' => 'Lisää suosikkeihin',
        'YOU_CAN_MARK_VIDEO' => 'Voit merkitä minkä videon tahansa suosikkeihin.  Klikkaa vain "Lisää suosikkeihin" kuvaketta kun näet sen videolla.',
        'VIEW_RECENT_VIDEOS' => 'Näytä uusimmat videot',
        'X_HAS_NOT_ADDED_FAVORITES' => '%s ei ole lisännyt mitään suosikkeihin vielä.',
        'APPROVE_VIDEOS' => 'Hyväksy videot',
        'YOUR_SITE_REQUIRES_YOU' => 'Olet valinnut verkostossasi julkaistavien valokuvien ja videoiden moderointioption ennen julkaisua.  Voit muuttaa tämän asetuksen klikkaamalla <a %s>, menemällä Yksityisyysasetuksiin </a> ja poistamalla \\’Approve New Photos And Videos\'.',
        'YOUR_SITE_ALLOWS_USERS' => 'Et ole valinnut verkostossasi julkaistavien valokuvien ja videoiden moderointioptiota  ennen julkaisua.  Voit muuttaa tämän asetuksen klikkaamalla <a %s>, menemällä Yksityisyysasetuksiin </a> ja valitsemalla \'Approve New Photos And Videos\'.',
        'APPROVE_ALL_VIDEOS' => 'Hyväksytkö kaikki videot?',
        'ARE_YOU_SURE_APPROVE_ALL_VIDEOS' => 'Oletko varma, että haluat hyväksyä kaikki videot?  Tämä voi kestää muutaman minuutin.',
        'APPROVING' => 'Hyväksyy…',
        'APPROVE_ALL' => 'Hyväksy kaikki',
        'DELETE_ALL_VIDEOS' => 'Haluatko poistaa kaikki videot?',
        'ARE_YOU_SURE_DELETE_ALL_VIDEOS' => 'Oletko varma, että haluat poistaa kaikki hyväksymättömät videot?  Tämä voi kestää muutaman minuutin.',
        'DELETING' => 'Poistaa…',
        'DELETE_ALL' => 'Poista kaikki',
        'XS_VIDEOS' => '%s:n videot',
        'DELETE_ALL_XS_VIDEOS_Q' => 'Haluatko poistaa kaikki %s:n videot?',
        'DELETE_ALL_XS_VIDEOS' => 'Poista kaikki %s:n videot',
        'ARE_YOU_SURE_DELETE_ALL_XS_VIDEOS' => 'Oletko varma, että haluat poistaa kaikki %s:n videot?  Käsittely voi kestää muutaman minuutin.',
        'DELETE_THIS_VIDEO_Q' => 'Poistetaanko tämä video?',
        'ARE_YOU_SURE_DELETE_THIS_VIDEO' => 'Oletko varma, että haluat poistaa tämän videon?  Käsittely voi kestää muutaman minuutin.',
        'YOU_HAVE_NOT_ADDED_VIDEOS_2' => 'Et ole lisännyt yhtään videota vielä.  Lisää muutama video päästäksesi alkuun!',
        'X_HAS_NOT_ADDED_VIDEOS' => '%s ei ole lisännyt vielä yhtään videota.',
        'YOUR_FRIENDS_DO_NOT_HAVE_VIDEOS' => 'Ystävilläsi ei ole vielä yhtään videota.',
        'ALL_VIDEOS_TAGGED_X' => 'Kaikkiin videoihin lisätty tagit \'%s\'',
        'ALL_VIDEOS_TAGGED_X_2' => 'Kaikkiin videoihin lisätty tagit <em>\'%s\'</em>',
        'NO_VIDEOS_TAGGED_X_CHECK_OUT' => 'Yhdessäkään videossa ei ole tageja "%1$s".  Tarkista <a %2$s>keskustelutagit "%1$s"</a> tai <a %3$s>valokuvatagit "%1$s"</a>.  Tai lisää ja merkitse tageilla omat videosi!',
        'FILES_MUST_BE_100MB' => 'Tiedostojen tulee olla kooltaan alle 100 Mt.  Tuemme . mov, . mpg, . avi, . 3gp ja . wmv-tiedostomuotoja.',
        'NEED_HELP' => 'Tarvitsetko apua?',
        'HERE_ARE_INSTRUCTIONS' => 'Tässä on <a %s>YouTube</a> ja <a %s>Google Video</a> ohjeet.',
        'PERSON_IN_CHARGE' => '%s vastuussa oleva henkilö haluaa nähdä luomuksesi ennen kuin se julkaistaan kaikkien nähtäväksi.',
        'LEAVE_WINDOW_OPEN' => 'Älä sulje selaimen ikkunaa ennen kuin lataaminen on loppunut.',
        'KEEP_PAGE_OPEN' => 'Älä sulje tätä sivua ennen kuin olemme ladanneet videosi, ilmoitamme sinulle kun se on hyväksytty!',
        'MEANWHILE_FEEL_FREE' => 'Sillä aikaa voit vapaasti <a %s>avata uuden ikkunan</a> ja jatkaa %s:n selaamista.  Kun lataaminen on suoritettu loppuun, voit lisätä videoosi nimen ja kuvauksen tässä ikkunassa.',
        'VIDEO_IS_WAITING_FOR_APPROVAL' => 'Tämä video <strong>odottaa %s:n perustajan hyväksyntää</strong>.',
        'LOADING' => 'Lataa...',
        'EDIT_VIDEO' => 'Muokkaa videota',
        'DELETE_VIDEO' => 'Poista video',
        'YOU_NEED_TO_BE_MEMBER' => 'Sinun tulee olla %s:n jäsen ennen kuin voit kommentoida!',
        'SIGN_UP_OR_SIGN_IN' => '<a %s>Liity tähän verkostoon</a>',
        'ADD_A_COMMENT' => 'Lisää kommentti',
        'LEAVE_A_COMMENT_FOR_USERNAME' => 'Jätä kommentti %s:lle',
        'MORE' => 'Lisää',
        'PREVIOUS' => 'Edellinen',
        'NEXT' => 'Seuraava',
        'ABOUT_THIS_VIDEO' => 'Tietoa tästä videosta',
        'ABOUT_YOUR_VIDEO' => 'Tietoa tästä videosta',
        'ADDED_ON_DATE_BY' => 'Lisännyt <strong>%s</strong>:',
        'VIEWS' => 'Näytetty:',
        'COMMENTS' => 'Kommentit',
        'COMMENTS_COLON' => 'Kommentit:',
        'LOCATION_OF_VIDEO' => 'Tämän videon sijainti:',
        'RELATED_VIDEOS' => 'Samanlaisia videoita',
        'ALL_VIDEOS_TAGGED_X_X' => 'Kaikki videot merkitty tageilla %s (%s)',
        'XS_VIDEOS_X' => '%s:n videot (%s)',
        'XS_FAVORITES_X' => '%s:n suosikit (%s)',
        'VIDEO_DETAILS' => 'Videotiedot',
        'NEITHER_FILE_NOR_EMBED_CODE' => 'Tiedostoa eikä upotettua koodia ei ole määritelty.',
        'VIDEO_UPLOADED_ON_X' => 'Video on ladattu %s',
        'PROBLEM_OCCURRED_CONVERTING_VIDEO' => 'Videon konvertoinnissa Flash-muotoon on ongelma: %s',
        'STATUS_N' => 'Tila %s',
        'YOUR_VIDEO_TITLED_X_COULD_NOT' => 'Videotasi nimeltä "%s" ei voitu lisätä %s',
        'YOUR_VIDEO_COULD_NOT_BE_ADDED' => 'Videotasi ei voitu lisätä %s',
        'YOU_JUST_TRIED_TO_SEND_VIDEO' => 'Yritit juuri lähettää videon %s.  Valitettavasti, sinä et ole %s:n jäsen ja emme voi julkaista tätä videota.',
        'VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'Videon lataamisesi %s ei onnistunut',
        'YOUR_VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'Videon lataamisesi %s ei onnistunut.',
        'YOUR_VIDEO_ENCOUNTERED_A_PROBLEM' => 'Ladatessasi videota %s-verkostoon tapahtui virhe',
        'THE_PROBLEM_WAS_X' => 'Ongelma oli: %s',
        'FOR_FURTHER_ASSISTANCE_2' => 'Jos tarvitset lisäapua ota yhteys meihin:',
        'ID' => 'ID:',
        'VIDEO_TRANSCODING_FAILED_FOR_X' => 'Videon %s muuntaminen %s epäonnistui',
        'X_UPLOADED_A_VIDEO_THAT_FAILED' => '%s latasi videon, jonka muuntaminen epäonnistui.',
        'ERROR_MESSAGE' => 'Virhesanoma:',
        'APPLICATION_NAME' => 'Sovelluksen nimi:',
        'APPLICATION_ID' => 'Sovelluksen ID:',
        'VIDEO_ID' => 'Videon ID:',
        'VIDEO_UPLOAD_COMPLETE_ON_X' => 'Videon latauksesi on loppuun suoritettu %s-verkostoon',
        'YOUR_VIDEO_UPLOAD_COMPLETE_ON_X' => 'Videon latauksesi on loppuunsuoritettu %s',
        'YOUR_VIDEO_WAS_UPLOADED' => 'Videosi on onnistuneesti ladattu %s-verkostoon!',
        'THAT_VIDEO_IS_AWAITING_APPROVAL' => 'Video odottaa hyväksymistä.',
        'THIS_VIDEO_IS_BEING_PROCESSED' => 'Tätä videota käsitellään vielä.',
        'ADD_VIDEO' => 'Lisää video',
        'VIDEO_BY_X' => '%s video',
        'THERE_IS_NEW_COMMENT_ON_VIDEO_X' => 'Videoosi on uusi kommentti "%s"  %s',
        'THERE_IS_NEW_COMMENT_ON_VIDEO' => 'Yhteen videoistasi on uusi kommentti %s',
        'SOMEBODY_COMMENTED_VIDEO_ADDED_TO_X' => 'Joku on kommentoinut videota, jonka olet lisännyt %s',
        'SOMEBODY_UPLOADED_VIDEO_TO_X' => 'joku on ladannut videon %s',
        'MORE_WAYS_TO_ADD_VIDEOS' => 'Enemmän tapoja lisätä videoita…',
        'FROM_YOUTUBE_OR_GOOGLE' => '…tarjoaa YouTube tai Google',
        'GRAB_THE_HTML_EMBED_CODE' => 'Ota HTML \'embed\' koodi miltä tahansa suositulta videosivustolta ja lisää video tähän verkostoon.',
        'ADD_A_VIDEO_FROM_YOUTUBE' => 'Lisää video YouTube tai Google sivustolta',
        'PASTE_IN_EMBED' => 'Kopioi upotettu videon koodi tähän:',
        'ADD_VIDEOS_BY_PHONE_OR_EMAIL' => 'Lisää video puhelimitse tai sähköpostilla',
        'VIDEO' => 'video',
        'THERE_ARE_NO_VIDEOS_THAT_MATCH' => 'Valintakriteereitäsi vastaavia videoita ei löytynyt.',
        'CLICK_EDIT_AND_CHANGE_SETTINGS' => 'Klikkaa \'Edit\' ja muuta asetukset jos haluat tämän ruudun näkyvän muille henkilöille.',
        'PLAY_AGAIN' => 'Toista uudestaan',
        'SHARE' => 'Jaa',
        'EMBED' => 'Upotettu',
        'REWIND' => 'Kelaa taaksepäin',
        'CHANGE_SIZE' => 'Muuta koko',
        'FULLSCREEN' => 'Koko näyttö',
        'EXIT_FULLSCREEN' => 'Poistu kokonäytöstä',
        'HIDE' => 'Sulje',
        'COPY_AND_PASTE_LINK' => 'Kopioi ja liitä tämä linkki sähköpostiin tai pikaviestiin:',
        'FIND_MORE_VIDEOS_LIKE_THIS' => 'Etsi muita samanlaisia videoita <em>%s</em>',
        'SEE_VIDEO_ON_NETWORK' => 'Katsele tämä video %s-verkostossa.',
        'GET_EMBED_CODE' => 'Hae upotettu koodi',
        'MORE_PHOTOS' => 'Lisää valokuvia',
        'THIS_ALBUM' => 'Tämä albumi',
        'NETWORK_DOES_NOT_HAVE_PHOTOS' => 'Tässä verkostossa ei ole vielä valokuvia.',
        'PERSON_DOES_NOT_HAVE_PHOTOS' => 'Tällä henkilöllä ei ole vielä valokuvia.',
        'ALBUM_DOES_NOT_HAVE_PHOTOS' => 'Tässä albumissa ei ole vielä valokuvia.',
        'FIND_MORE_PHOTOS_LIKE_THIS' => 'Etsi muita samanlaisia valokuvia <em>%s</em>',
        'NO_PHOTOS_AVAILABLE' => 'Tässä albumissa ei ole tällä hetkellä valokuvia.  <a %s>Klikkaa nähdäksesi kaikki albumit</a>.',
        'ALBUM_PHOTOS_NOT_VISIBLE_TO_OTHERS' => 'Tämä albumi ei näy muille tässä verkostossa, sen kuvat ovat näkyvissä vain sinulle tai niitä ei ole vielä hyväksytty.',
        'CUSTOMIZE_YOUR_SLIDESHOW_PLAYER' => 'Mukauta diaesityssoittimesi!',
        'ADD_SLIDESHOW_LOGO' => 'Lisää logo verkostosi diaesitykseen.  <a %s>Määritä se nyt! </a>',
        'PHOTO_BY_X' => '%s valokuva',
        'UPLOAD_PHOTOS' => 'Lataa valokuvia',
        'PLAYER_COLOR' => 'Soittimen väri',
        'SLIDESHOW_PLAYER' => 'diaesityssoitin',
        'SLIDESHOW' => 'diaesitys',
        'FILTER' => 'Suodatin',
        'SAVE_ALBUM' => 'Tallenna albumi',
        'APPLY_THIS_INFO_TO_PHOTOS' => 'Käytä tätä tietoa seuraaviin kuviin',
        'CLICK_TO_ADD_A_DESCRIPTION' => 'klikkaa lisätäksesi kuvauksen',
        'CHECK' => 'Tarkista',
        'YOU_NEED_TO_BE_X' => 'Sinun täytyy olla %s tehdäksesi toiminnon.',
        'ALL_PHOTOS' => 'Kaikki valokuvat',
        'POPULAR_PHOTOS' => 'Suositut valokuvat',
        'FEATURED_PHOTOS' => 'Kiinnostavat valokuvat',
        'PHOTOS_HOME' => 'Valokuvat aloitus',
        'ALL_ALBUMS' => 'Kaikki albumit',
        'MY_PHOTOS' => 'Omat kuvat',
        'MY_ALBUMS' => 'Omat albumit',
        'ADD_PHOTOS' => 'Lisää kuvia',
        'ADD_PHOTOS_SENTENCE_CASE' => 'Lisää kuvia',
        'EDIT' => 'Muokkaa',
        'CHOOSE_PHOTOS' => 'Valitse kuvat',
        'ADD_PHOTOS_BY_DRAGGING' => '<strong>Lisää kuvat vetämällä ne</strong> albumiisi oikealla.  Poista ne vetämällä ne takaisin.',
        'TITLE_YOUR_ALBUM' => '<strong>Anna albumillesi nimi. </strong> Valitse kansi ja kuvaus.',
        'SAVE_YOUR_ALBUM' => 'Tallenna albumisi!',
        'CHOOSE_FROM' => 'Valitse seuraavista:',
        'EVERYONES_PHOTOS' => 'Kaikkien kuvat',
        'TAGGED' => 'Tagit:',
        'OLDER_PHOTOS' => 'Vanhemmat kuvat',
        'MORE_RECENT_PHOTOS' => 'Uusimmat kuvat',
        'YOUR_ALBUM' => 'Oma albumisi',
        'DRAG_ALBUM_COVER_HERE' => 'Vedä albumin kansi tähän',
        'ALBUM_TITLE' => 'Albumin nimi:',
        'ALBUM' => 'albumi',
        'DRAG_PHOTOS_HERE' => 'Vedä kuvasi tänne',
        'PREVIOUS_ALBUM_PAGE' => 'Edellinen albumin sivu',
        'NEXT_ALBUM_PAGE' => 'Seuraava albumin sivu',
        'ADDED_ON_DATE' => 'Lisännyt: %s',
        'VIEW_AS_SLIDESHOW' => 'Katso diaesitys',
        'CREATED_BY_ME' => 'Luonut <a %s>Minä</a>',
        'CREATED_BY_X' => 'Luonut %s',
        'OUR_APOLOGIES' => 'Anteeksipyyntömme',
        'ADD_PHOTOS_TO_ALBUM' => 'Lisää kuvia albumiin valitsemalla alla olevista asetuksista.',
        'YOU_CAN_ADD_PHOTOS' => 'Sinä voit <a %s>lisätä kuvia albumiin nyt</a>.',
        'SITE_IS_GETTING_STARTED' => 'Tämä verkosto on vasta käynnistymässä!',
        'NO_ONE_CREATED_ALBUMS' => 'Kukaan ei ole vielä luonut yhtään albumia.  Sinä voit <a %s>luoda albumin nyt</a>.',
        'EDIT_YOUR_ALBUM' => 'Muokkaa albumiasi',
        'ALBUMS_WITH_THIS_PHOTO' => 'Kaikki albumit joissa on tämä kuva',
        'ALBUMS_WITH_X' => 'Kaikki albumit joissa \'%s\'',
        'ALBUMS_WITH_X_2' => 'Kaikki albumit joissa <em>\'%s\'</em>',
        'NO_ALBUMS_CONTAINING_PHOTO' => 'Yhdessäkään albumissa ei ole tätä kuvaa.  Sinä voit <a %s>luoda uuden albumin</a>.',
        'XS_ALBUMS' => '%s:n albumit',
        'CREATE_AN_ALBUM' => 'Luo albumi',
        'YOU_HAVE_NOT_CREATED_ALBUMS' => 'Et ole luonut yhtään albumia vielä.  Sinä voit <a %s>luoda albumin nyt</a>.',
        'X_HAS_NOT_CREATED_ALBUMS' => '%s ei ole luonut yhtään albumia vielä.',
        'MAKE_AN_ALBUM' => 'Tee albumi',
        'ABOUT_THIS_ALBUM' => 'Tietoja tästä albumista',
        'ABOUT_YOUR_ALBUM' => 'Tietoja omasta albumistasi',
        'EDIT_ALBUM' => 'Muokkaa albumia',
        'DELETE_THIS_ALBUM' => 'Poistetaanko tämä albumi?',
        'DELETE_ALBUM' => 'Poista albumi',
        'START_SLIDESHOW' => 'Aloita diaesitys',
        'ALBUM_IS_NOW_EMPTY' => 'Tämä albumi on nyt tyhjä.',
        'YOU_ARE_GETTING_STARTED' => 'Olet vasta aloittelemassa!',
        'YOU_HAVE_NOT_ADDED_PHOTOS' => 'Et ole lisännyt yhtään kuvaa vielä!',
        'ADD_PHOTOS_AND_SHARE' => 'Lisää kuvia ja jaa ne ystäviesi, perheesi tai koko maailman kanssa!',
        'ADD_A_PHOTO' => 'Lisää kuva',
        'NO_PHOTOS_ON_SITE' => 'Verkostossasi ei ole tällä hetkellä valokuvia.',
        'BOX_WILL_NOT_SHOW_PHOTOS' => 'Tämä ruutu ei näy muille henkilöille ennen kuin täällä on valokuvia.  Miksi et lisäisi yhtä?',
        'VIEW_EMBED_CODE' => 'Näytä upotettu koodi',
        'VIEW_SLIDESHOW' => 'Näytä diaesitys',
        'VIEW_PHOTOS' => 'Näytä kuvat',
        'ADD_YOUR_FIRST_PHOTOS' => 'Lisää ensimmäiset kuvasi',
        'YOU_CAN_ADD_YOUR_OWN_PHOTOS' => 'Sinä voit <a %s>lisätä omat kuvasi</a>  %s!',
        'UPLOAD_PHOTOS_FROM' => 'Lataa kuvia tietokoneeltasi:',
        'ADD_TITLE_AND_DESCRIPTION_FOR_PHOTOS' => 'Lisää kuvillesi nimi ja kuvaus',
        'EDIT_PHOTO_INFORMATION' => 'Muokkaa kuvatietoja',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_1' => 'Lisää nimi, kuvaus ja muita tietoja kuviin, jotka juuri latasit.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_2' => 'Lisää nimi, kuvaus ja muuta tietoa tähän kuvaan.',
        'CANCEL_AND_RETURN_TO_PHOTO' => 'Peruuta ja palaa kuvaan',
        'WHO_CAN_VIEW_PHOTO' => 'Kuka saa katsoa tämän kuvan?',
        'CAN_BE_VIEWED_BY' => 'Tämän saa katsoa:',
        'BY_ME' => '<a %s>Minä</a>',
        'RSS_FEED_LABEL' => '<a %s>RSS-syöte</a> - %s',
        'NO_PHOTOS_AWAITING_APPROVAL' => 'Tällä hetkellä ei ole hyväksyttäviä kuvia.  Jos sinulle ei ole mitään tekemistä katso vaikka <a %s>uusimmat kuvat</a>',
        'APPROVE_ALL_PHOTOS' => 'Hyväksytäänkö kaikki kuvat?',
        'ARE_YOU_SURE_APPROVE_ALL_PHOTOS' => 'Oletko varma, että haluat hyväksyä kaikki kuvat?  Tämä voi kestää muutaman minuutin.',
        'DELETE_ALL_PHOTOS' => 'Poistetaanko kaikki kuvat?',
        'ARE_YOU_SURE_DELETE_ALL_PHOTOS' => 'Oletko varma, että haluat poistaa kaikki hyväksymättömät kuvat?  Tämä voi kestää muutaman minuutin.',
        'KEEP_WINDOW_OPEN_PHOTOS_APPROVED' => 'Älä sulje selaimen ikkunaa ennen kuin kuvat on hyväksytty.  Käsittely voi kestää muutaman minuutin.',
        'KEEP_WINDOW_OPEN_PHOTOS_DELETED' => 'Älä sulje selaimen ikkunaa ennen kuin kaikki kuvat on poistettu.  Käsittely voi kestää muutaman minuutin.',
        'APPLY_TO_PHOTOS_ADDED_BY' => 'Käytä kaikkiin kuviin jotka on lisännyt %s',
        'NO_ONE_HAS_ADDED_ANY_PHOTOS' => 'Kukaan ei ole lisännyt kuvia sosiaaliseen verkostoosi.  Voit olla ensimmäinen joka <a %s>lisää kuvia. </a>',
        'UNTITLED' => 'Nimetön',
        'A_PROBLEM_OCCURRED' => 'On ilmennyt ongelma',
        'PHOTOS_EXCEEDED_LIMIT' => 'Kuva(t) ovat suurempia kuin sallittu 10 Mt per kuva.',
        'GET_A_SLIDESHOW_OF' => 'Hae %s diaesitys',
        'GET_A_SLIDESHOW' => 'Tee diaesitys!',
        'GET_SLIDESHOW_OF_PHOTOS' => 'Tee diaesitys näistä kuvista',
        'COPY_AND_PASTE_SLIDESHOW' => 'Kopioi ja liitä alla oleva koodi lisätäksesi näiden kuvien diaesityksen omalle verkkosivullesi, MySpace-sivulle tai muuhun  Ning-verkostoon.',
        'COPY_AND_PASTE_SLIDESHOW_OF_ALBUM' => 'Kopioi ja liitä alla oleva koodi lisätäksesi tämän albumin diaesityksen omalle verkkosivullesi, MySpace-sivulle tai muuhun  Ning-verkostoon.',
        'LARGE_VERSION' => 'Suuri versio',
        'SMALL_VERSION' => 'Pieni versio',
        'VIEW_SLIDESHOW_FULL_SIZE' => 'Näytä diaesitys täysikokoisena',
        'PHOTOS' => 'Kuvat',
        'XS_PHOTOS' => '%s:n kuvat',
        'XS_PHOTO' => '%s:n kuva',
        'YOU_CAN_MARK_PHOTO' => 'Voit merkitä minkä tahansa kuvan suosikiksi.  Klikkaa vain "Lisää suosikkeihin" kuvaketta kun näet sen kuvassa.',
        'VIEW_RECENT_PHOTOS' => 'Näytä uusimmat kuvat',
        'APPROVE_PHOTOS' => 'Hyväksy kuvat',
        'DELETE_ALL_XS_PHOTOS_Q' => 'Haluatko poistaa kaikki %s:n kuvat?',
        'ARE_YOU_SURE_DELETE_ALL_XS_PHOTOS' => 'Oletko varma, että haluat poistaa kaikki %s:n kuvat?  Käsittely voi kestää muutaman minuutin.',
        'REMOVE_X_AND_ALL_CONTENT' => 'Poista %1$s ja kaikki %1$s:n sisältö verkostostasi',
        'SUCCESS' => 'Onnistui.',
        'DELETING_CONTENT' => 'Poistaa sisältöä…',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED' => 'Älä sulje selaimen ikkunaa ennen kuin sisältö on poistettu.  Käsittely voi kestää muutaman minuutin.',
        'KEEP_WINDOW_OPEN_MEMBERS_DELETED' => 'Älä sulje selaimen ikkunaa ennen kuin kaikki jäsenet on poistettu.  Käsittely voi kestää muutaman minuutin.',
        'DELETE_ALL_XS_PHOTOS' => 'Poista kaikki %s:n kuvat',
        'CREATE_A_NEW_ALBUM' => 'Luo uusi albumi',
        'VIEW_ALL_XS_ALBUMS' => 'Näytä kaikki %s:n albumit',
        'YOU_HAVE_NOT_ADDED_PHOTOS_2' => 'Et ole lisännyt yhtään kuvaa vielä.  Lisää kuvia päästäksesi alkuun!',
        'X_HAS_NOT_ADDED_PHOTOS' => '%s ei ole lisännyt yhtään kuvaa vielä.',
        'MY_FRIENDS_PHOTOS' => 'Ystävieni kuvia',
        'VIEW_PHOTOS_IN_SLIDESHOW' => 'Näytä nämä kuvat diaesityksenä!',
        'YOUR_FRIENDS_DO_NOT_HAVE_PHOTOS' => 'Ystävilläsi ei ole vielä yhtään kuvaa',
        'ALL_PHOTOS_TAGGED_X' => 'Kaikissa kuvissa on tagit \'%s\'',
        'ALL_PHOTOS_TAGGED_X_2' => 'Kaikissa kuvissa on tagit <em>\'%s\'</em>',
        'NO_PHOTOS_TAGGED_X_CHECK_OUT' => 'Yhdessäkään kuvassa ei ole tageja "%1$s".  Tarkista <a %2$s>keskustelutagit "%1$s"</a> tai <a %3$s>videotagit "%1$s"</a>.  Tai lisää ja tag-merkitse omat kuvasi!',
        'SELECT_YOUR_PHOTOS' => 'Valitse kuvasi',
        'PHOTO_MAY_BE_10MB' => 'Jokainen kuva saa olla kooltaan enintään 10 Mt, mutta pienemmät kuvat latautuvat nopeammin. Tuemme .jpg, .gif ja .png kuvamuotoja.',
        'KEEP_PAGE_OPEN_PHOTOS' => 'Älä sulje tätä sivua, jotta voimme suorittaa kuviesi latauksen loppuun ja ilmoittaa sinulle kun ne on hyväksytty!',
        'MEANWHILE_FEEL_FREE_PHOTOS' => 'Sillä aikaa voit vapaasti <a %s>avata uuden ikkunan</a> ja jatkaa %s:n selaamista.  Kun lataaminen on suoritettu, voit lisätä kuviisi nimet ja kuvaukset tässä ikkunassa.',
        'PHOTO_IS_WAITING_FOR_APPROVAL' => 'Tämä kuva <strong>odottaa %s:n perustajan hyväksymistä</strong> .',
        'ADD_TO_FAVORITES' => 'Lisää suosikkeihin',
        'EDIT_PHOTO' => 'Muokkaa kuvaa',
        'DELETE_PHOTO' => 'Poista kuva',
        'ABOUT_THIS_PHOTO' => 'Tietoja tästä kuvasta',
        'LOCATION_OF_PHOTO' => 'Tämän kuvan sijainti:',
        'ALBUMS_FEATURING_PHOTO' => 'Albumit joissa on tämä kuva',
        'VIEW_ALBUMS_WITH_PHOTO' => 'Näytä kaikki albumit, joissa on tämä kuva',
        'RETURN_TO_X' => 'Palaa %s',
        'RETURN_TO_PHOTOS_HOME' => 'Palaa kuvien aloitussivulle',
        'WE_COULD_NOT_FIND_ANYONE' => 'Anteeksipyyntömme – emme löytäneet ketään',
        'NOBODY_HAS_ADDED_PHOTOS' => 'Kukaan ei ole lisännyt kuvia vielä!  Lisää joitakin kuvia aloittaaksesi.',
        'DEFAULT_TITLE' => 'Nimi',
        'DEFAULT_DESCRIPTION' => 'Kuvaus',
        'UPLOAD_LIMIT_EXCEEDED' => 'Latauksen enimmäiskoko ylittyi.',
        'SLOW_DOWN_THERE_CHIEF' => 'Anteeksi',
        'I_DO_NOT_KNOW_USER' => 'Anteeksi en tunne tätä henkilöä.',
        'I_DO_NOT_HAVE_PHOTO' => 'Anteeksi minulla ei ole tätä kuvaa.',
        'I_DO_NOT_HAVE_ALBUM' => 'Anteeksi minulla ei ole tätä albumia.',
        'ALBUM_BY_X_ON_X' => '%s albumi  %s',
        'SENT' => 'Lähetetty!',
        'I_HAVE_RECENTLY_ADDED' => 'Viimeksi lisätyt',
        'FROM_THE_BAZEL' => 'Tästä verkostosta',
        'RECENTLY_ADDED' => 'Viimeksi lisätyt',
        'RECENT_PUBLIC_PHOTOS_ON_X' => 'Uusimmat julkiset kuvat %s',
        'X_ALL_PHOTOS' => '%s – Kaikki kuvat',
        'NO_TAG_WAS_SPECIFIED' => 'Yhtään tagia ei ole merkitty',
        'PUBLIC_PHOTOS_TAGGED_WITH_X' => 'Julkiset kuvat on tagmerkitty %s  %s',
        'XS_PUBLIC_PHOTOS_ON_X' => '%s:n julkiset kuvat %s',
        'WE_DO_NOT_KNOW_USER' => 'Me emme tunne tätä henkilöä.',
        'XS_FRIENDS_PHOTOS' => '%s:n ystävien kuvat',
        'XS_FAVORITE_PHOTOS_ON_X' => '%s:n suosikkikuvat kohteessa %s',
        'PHOTO_UPLOADED_ON_X' => 'Kuva on ladattu kohteeseen %s',
        'FILE_EXCEEDED_MAXIMUM_SIZE' => 'Tiedoston koko ylittää maksimin',
        'PART_OF_FILE_WAS_UPLOADED' => 'Vain osa tiedostosta on ladattu',
        'NO_FILE_WAS_UPLOADED' => 'Lataaminen epäonnistui;  Valitsemasi tiedostonimi ei kelpaa',
        'PROBLEM_OCCURRED_DURING_UPLOAD' => 'Latauksessa tapahtui virhe.',
        'ALPHABETICAL' => 'Aakkosellinen',
        'MOST_VIEWS' => 'Useimmin katsotut',
        'RATING_NOT_RATED_YET' => '<strong>Arvosana:</strong> Ei arvosteltu vielä',
        'NOT_RATED_YET' => 'Ei arvosteltu vielä',
        'HMM_SOMETHING_WENT_AWRY' => 'Hmm....jokin meni pieleen',
        'YOUR_PHOTO_TITLED_X_COULD_NOT' => 'Kuvaasi nimeltä "%s" ei voitu lisätä %s',
        'YOUR_PHOTO_COULD_NOT_BE_ADDED' => 'Kuvaasi ei voitu lisätä %s',
        'YOU_JUST_TRIED_TO_SEND' => 'Yritit juuri lähettää kuvan %s.  Valitettavasti et ole %s:n jäsen, emmekä voi julkaista tätä kuvaa.',
        'ONLY_MY_FRIENDS' => 'Vain ystäväni',
        'ANYBODY' => 'Kuka tahansa',
        'ONLY_MY_FRIENDS_CAN_SEE_PHOTO' => 'Vain ystäväni saavat nähdä kuvan',
        'ONLY_XS_FRIENDS_CAN_SEE_PHOTO' => 'Vain %s:n ystävät saavat nähdä kuvan',
        'ONLY_I_CAN_SEE_PHOTO' => 'Vain minä itse näen tämän kuvan',
        'ONLY_X_CAN_SEE_PHOTO' => 'Vain %s saa nähdä kuvan',
        'EVERYONE_CAN_SEE_PHOTO' => 'Kaikki saavat nähdä kuvan',
        'PRIVATE_PHOTO' => '<strong>Yksityinen</strong> kuva',
        'HOWDY_STRANGER' => 'Hei Vieras!',
        'YOU_NEED_TO_BE_SIGNED_IN' => 'Sinun täytyy kirjautua Ning-verkostoon ennen kuin voit tehdä tämän.',
        'JUST_CLICK_ON_SIGN_IN' => 'Klikkaa "Kirjaudu sisään" yläreunassa, jos sinulle ei ole Ning-tiliä klikkaa "Rekisteröidy".',
        'YOU_NEED_TO_BE_' => 'Sinun täytyy olla %s tehdäksesi toiminnon.',
        'YOU_NEED_TO_BE_OWNER' => 'Vain verkoston perustaja voi tehdä tämän toiminnon.',
        'THAT_PHOTO_IS_AWAITING_APPROVAL' => 'Tämä kuva odottaa hyväksymistä.',
        'YOU_NEED_TO_BE_A_FRIEND' => 'Vain %s:n ystävä voi tehdä tämän.',
        'MOST_ACTIVE' => 'Aktiivisimmat',
        'HOW_IT_WORKS' => 'Kuinka se toimii',
        'MORE_WAYS_TO_ADD_PHOTOS' => 'Lisää tapoja lisätä kuvia…',
        'BY_PHONE_OR_EMAIL' => '…puhelimitse tai sähköpostitse',
        'FROM_FLICKR' => '…Flickr-sivustolta',
        'FROM_YOUR_COMPUTER' => '…omalta tietokoneeltasi',
        'ADD_PHOTOS_FROM_YOUR_FLICKR' => 'Lisää kuvia Flickr-tililtäsi.',
        'MORE_INFORMATION' => 'Lisätietoa',
        'ADD_PHOTOS_BY_PHONE_OR_EMAIL' => 'Lisää kuvia puhelimitse tai sähköpostitse',
        'SEND_ONE_PHOTO_OR_VIDEO' => 'Lähetä yksi kuva tai video kerrallaan puhelimitse tai sähköpostitse.  Sähköpostin aiheesta tulee kuvan tai videon nimi ja tekstistä tulee sen kuvaus.',
        'CLICK_HERE_TO_GET_A_NEW_UNIQUE' => 'Klikkaa saadaksesi uuden sähköpostiosoitteen',
        'UPLOAD_PHOTOS_FROM_YOUR' => 'Lataa kuvia tietokoneeltasi.',
        'PHOTO' => 'kuva',
        'YOUVE_SET_THE_NUMBER_OF_PHOTOS' => 'Tällä hetkellä et näytä yhtään kuvaa.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_PHOTO' => 'Tämä laatikko ei näy muille, jollet valitse ainakin yhtä kuvaa.',
        'THERE_IS_NEW_COMMENT_ON_PHOTO_X' => 'Kuvallesi "%s" on uusi kommentti %s',
        'THERE_IS_NEW_COMMENT_ON_PHOTO' => 'Yhdelle kuvistasi on uusi kommentti %s',
        'SOMEBODY_COMMENTED_PHOTO_ADDED_TO_X' => 'joku on kommentoinut lisäämääsi kuvaa %s',
        'SOMEBODY_UPLOADED_PHOTO_TO_X' => 'joku on ladannut kuvan %s',
        'ADD_PHOTOS_OR_VIDEOS_TO_X' => 'Lisää kuvia tai videoita kohteeseen %s suoraan puhelimestasi lähettämällä ne sähköpostiosoitteeseen.',
        'DO_YOU_REALLY_WANT_TO_REMOVE' => 'Haluatko todella poistaa tämän suosikeistasi?',
        'DELETE_THIS_PHOTO_Q' => 'Poistetaanko tämä kuva?',
        'ARE_YOU_SURE_DELETE_THIS_PHOTO' => 'Oletko varma, että haluat poistaa tämän kuvan?  Käsittely voi kestää muutaman minuutin.',
        'PHOTO_SLIDESHOW' => 'Diaesitys',
        'THUMBNAILS' => 'Pikkukuvat',
        'DETAIL' => 'Yksityiskohta',
        'TAG' => 'Tag',
        'RATE' => 'Arvostele',
        'ALL_SIZES' => 'Kaikki koot',
        'ADD_TO_ALBUM' => 'Lisää albumiin',
        'ROTATE_PHOTO' => 'Kierrä kuvaa',
        'ABOUT_YOUR_PHOTO' => 'Tietoa kuvastasi',
        'SEE_PHOTOS_ON_NETWORK' => 'Katso kuvat %s',
        'EMBED_CODE' => 'Upotettu koodi',
        'IMPORT_PHOTOS_FLICKR' => 'Hae kuviasi Flickr-sivustolta',
        'CLICK_HERE_TO_CONTINUE_TO_FLICKR' => 'Klikkaa jatkaaksesi Flickr-sivustolle',
        'TO_GET_YOUR_PHOTOS_FROM_FLICKR' => 'Saadaksesi kuvasi Flickr-sivustolta sinun tulee sallia, että %S voi linkittää Flickr-tiliisi.',
        'IMPORT_PHOTOS' => 'Tuo kuvia',
        'GET_MY' => 'Hae omat',
        'GET_PHOTOS' => 'Hae kuvat',
        'MOST_RECENT_PHOTOS' => 'uusimmat kuvat',
        'GET_ALL_MY_FLICKR' => 'Hae kaikki kuvani Flickr-sivustolta (voi kestää jonkin aikaa)',
        'GET_ALL_MY_TAGGED' => 'Hae kaikki tag-merkityt kuvani',
        'GET_PHOTOS_FROM_SET' => 'Hae kuvia tästä valikoimasta:',
        'GET_STARTED_BY_IMPORT' => 'Haemme automaattisesti nimet, tagit ja kaikki karttatiedot jotka sinulla on. <br/>Kuinka kauan se kestää? </p> <p><ul style="padding-top:10px; "><li>10 kuvaa: <em>vähemmän kuin 30 sekuntia</em>. </li><li>50 kuvaa: <em>noin 2 minuuttia</em>. </li><li>200 kuvaa: <em>noin 6 minuuttia</em>. </li><li>500 kuvaa: <em>noin 15 minuuttia</em>. </li></ul>',
        'IF_YOURE_NOT_SIGNED_IN' => 'Jos et ole kirjautunut sisään Flickr-tilillesi sinua pyydetään tekemään se.  Kun olet kirjautunut sisään klikkaa painiketta  "OK, sallin".',
        'GET_MY_FLICKR_PHOTOS_DESCRIPTIONS' => 'Hae myös kuvaukset (tämä kaksinkertaistaa kestoajan).',
        'PLEASE_KEEP_THIS_PAGE_OPEN_WHILE_IMPORT' => 'Pidä tämä sivu auki niin kauan kuin siirrämme kuviasi.',
        'GET_MY_FLICKR_PHOTOS_ORIGINALS' => 'Hae jokainen kuva täysikokoisena (tämä lisää siirtoaikaa huomattavasti, emmekä suosittele yli 20 kuvalle).',
        'MAKE_YOUR_X_PAGE_YOUR_OWN' => 'Klikkaa "Muokkaa" lisätäksesi tekstiä, videoita, kuvia tai widgetin tähän kenttään.  Tämä on yksi tapa tehdä %s sivustasi persoonallinen.',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Klikkaa \'Muokkaa\' lisätäksesi tekstiä, HTML-koodia, videoita, kuvia tai mitä tahansa <a %1$s>kolmannen osapuolen widgettejä</a> tähän kenttään.  Tämä on toinen tapa tehdä %2$s sivustasi persoonallinen.',
        'BOX_WILL_NOT_SHOW_UNTIL_UPDATE_CONTENT' => 'Tämä kenttä ei näy muille, ennen kuin olet päivittänyt sen sisällön.',
        'YOUR_X_BOX' => 'Oma %s kenttä',
        'ABOUT_WIDGETS' => 'Tietoa Widgeteistä',
        'HELP' => 'Ohje',
        'WIDGETS' => 'Widgetit',
        'LOOKING_TO_ADD_FUNCTIONALITY' => 'Haluatko lisätä sosiaaliseen verkostoosi toimintoja?  Miten olisi kalenteri, paikallissää, tapahtumakalenteri tai webkamera?  Widgettien avulla on helppoa lisätä ominaisuuksia mihin tahansa muokkausruutuun verkostossasi.',
        'GETTING_STARTED' => 'Aloitusopas',
        'BELOW_IS_LIST_OF_WIDGET' => 'Alla on <a %s>lista widget-tarjoajista</a>.  Olemme valinneet muutaman <a %s>yourminis.com</a> widgetin päästäksesi alkuun. Ota widget käyttöön kopioimalla upotettu koodi ja liittämällä se suoraan muokkausruutuun. Anna mennä!',
        'CALENDAR' => 'Kalenteri',
        'CALENDAR_WIDGET_ALLOWS_SEARCH' => 'Kalenteri-widget ei vain näytä päivämäärää vaan mahdollistaa iCal-muodossa olevien tapahtumien etsimisen ja lisäämisen (käytössä  Google Kalenterissa ja monilla muilla online-tarjoajilla).',
        'USE_EDIT_WIDGET_BUTTON_CALENDAR' => 'Käytä &#8220; muokkaa widget&#8221;  valintapainike &#8220; etsi tapahtumia&#8221; , syötä hakusana (kokeile loma, urheilujoukkue tms. ). Valitse sitten haun tulos ja lisää tapahtumat kalenteriisi.  Voit myös syöttää manuaalisesti minkä tahansa iCal-syötteen osoitteen.',
        'CUSTOMIZATION' => 'Mukautus',
        'YOU_CAN_CUSTOMIZE_WIDGET' => 'Voit mukauttaa widgetin ulkonäköä siirtämällä hiiren widgetin päälle, klikkaamalla värinpoimijaa vaihtaaksesi taustan, widgetin tyylin ja läpinäkyvyysasteen.  Kun olet valmis klikkaa &#8220; kopioi webbiin&#8221;  linkki, sitten &#8220; kopioi upotettu koodi&#8221;  painike.  Kun koodi on kopioitu voit palata mihin tahansa muokkausruutuun verkostossasi ja liittää siihen koodin ja tallentaa muutokset.  Kaikki tehty!',
        'GET_MORE_WIDGETS_FROM_YOURMINIS' => 'Hae lisää yourminis. com widgeteja »',
        'WEATHER' => 'Sää',
        'WEATHER_WIDGET_DISPLAYS' => 'Sää-widget näyttää paikallisen sääennustuksen sääkanavalta.',
        'USE_EDIT_WIDGET_BUTTON_WEATHER' => 'Käytä &#8220; muokkaa widget&#8221;  painikkeella valitset sijainnin ja Fahrenheit tai Celcius-asteikon.  Voit valita tämän hetkisen sään tai laajentaa sen viiden päivän ennusteeksi..',
        'COUNTDOWN' => 'Lähtölaskenta',
        'COUNTDOWN_WIDGET_LETS_YOU' => 'Lähtölaskenta-widget mahdollistaa jäljellä olevan ajan laskemisen tiettyyn tapahtumaan.  Klikkaa &#8220; muokkaa widget&#8221;  painiketta, syötä päivämäärä, kellonaika ja tapahtuman nimi tai logo käynnistääksesi laskurin.',
        'WEBCAM' => 'Webkamera',
        'WEBCAM_WIDGET_ALLOWS_YOU' => 'Webkamera-widget sallii julkisesti tarjolla olevien webkameroiden kuvan näyttämisen.  Käytä &#8220; muokkaa widget&#8221;  painike, jolla voit valita webkameran luettelosta tai manuaalisesti syöttää minkä tahansa webkameran URL-osoitteen.',
        'MORE_WIDGETS' => 'Lisää widgetteja',
        'NEED_MORE_OPTIONS' => 'Tarvitsetko lisäasetuksia?  Suosittelemme seuraavia sivustoja sammuttamaan widget-janoasi:',
        'MODERATION_DENIED_ON_X' => 'Moderointi kielletty  %s  %s',
        'MODERATION_DENIED_ON_A_X' => 'Moderointi kielletty sinun %s  %s',
        'YOU_HAVE_NEW_X_TO_MODERATE' => 'Sinulla on uusi %s moderoitavaksi %s',
        'NEW_X_TO_MODERATE' => 'Uusi %s moderoitavaksi sinulle.',
        'MODERATION_APPROVED_ON_X' => 'Moderointi hyväksytty %s  %s',
        'MODERATION_APPROVED_ON_A_X' => 'Moderointi hyväksytty sinun %s  %s',
        'JOIN' => 'Liity',
        'WELCOME' => 'Tervetuloa',
        'WELCOME_TO_X' => 'Tervetuloa %s',
        'WELCOME_TO_X_ELLIPSIS' => 'Tervetuloa %s…',
        'RSS_LINK' => '<a %s>RSS</a>',
        'NEW_FEATURES_GROUPS_MUSIC' => '<h3 style="margin-top:0">Uusia ominaisuuksia! </h3>
            <ul><li><strong>Ryhmät</strong> &ndash;  Jäsenet voivat perustaa ryhmiä verkostoosi</li>
                <li><strong>Musiikkisoitin</strong> &ndash;  Lisää musiikkia ja podcasteja verkostoosi/li></ul>
            <p><a href="%s" class="desc add">Klikkaa lisätäksesi ominaisuuksia</a></p>',
        'NEW_FEATURES_ACTIVITY_BADGES' => '<h3 style="margin-top:0">Uusia ominaisuuksia! </h3>
            <ul><li><strong>Uusimmat aktiviteetit</strong> &ndash;  Seuraa jäsenten aktiviteettia verkostossasi</li>
                <li><strong>Merkit & Widgetit</strong> &ndash;  Mainosta verkostoasi webissä merkkien ja widgettejen avulla</li></ul>
            <p><a href="%s" class="desc add">Klikkaa lisätäksesi/muokataksesi ominaisuuksia</a></p>',
        'YOUR_TYPE_NAME_HAS_NEW_COMMENT_APPNAME' => 'Sinun %2$s, %1$s, on uusi kommentti lisännyt joku %3$s!',
        'YOUR_TYPE_HAS_NEW_COMMENT_APPNAME' => 'Sinun  %1$s on uusi kommentti lisännyt joku  %2$s!',
        'HERE_IS_LINK' => 'Tässä linkki liittymistä varten: <a %s>%s</a>',
        'THANKS_VALEDICTION' => 'Kiitos,',
        'THANKS' => 'Kiitos!',
        'YOU_CHANGED_YOUR_EMAIL_ON_X' => 'Olet vaihtanut sähköpostiosoitteesi %s.',
        'YOU_CHANGED_YOUR_EMAIL_ON_X_ELLIPSIS' => 'Olet vaihtanut sähköpostiosoitteesi %s…',
        'CLICK_HERE_TO_SIGN_IN_WITH_YOUR_NEW_EMAIL_ADDRESS' => 'Klikkaa kirjautuaksesi sisään uudella sähköpostiosoitteella:',
        'IF_DID_NOT_CHANGE_EMAIL_ADDRESS' => 'Jos et ole vaihtanut sähköpostiosoitettasi klikkaa tätä:',
        'TO_STOP_BEING_NOTIFIED_OF_NEW_DISCUSSIONS_GO_TO' => 'Pysäyttääksesi ilmoitukset uusista keskusteluista siirry:',
        'X_STARTED_DISCUSSION_ON_APPNAME_ELLIPSIS' => '%1$s aloitti uuden keskustelun %2$s…',
        'X_STARTED_THE_DISCUSSION_Y' => '%1$s aloitti keskustelun "%2$s".',
        'TO_VIEW_THIS_DISCUSSION_GO_TO' => 'Nähdäksesi keskustelun siirry:',
        'X_HAS_INVITED_YOU_TO_JOIN_Y' => '%s on kutsunut sinut mukaan %s!',
        'X_WANTS_YOU_TO_CHECK_OUT_Y' => '%s haluaa, että katsot"%s"  kohdassa %s!',
        'CHECK_OUT_TITLE_ON_APPNAME' => 'Katso "%s"  kohdassa %s!',
        'ABOUT_X' => 'Tietoja %s',
        'YOU_HAVE_RECEIVED_BECAUSE_X' => 'Olet saanut tämän sähköpostin koska %s',
        'IF_YOU_NO_LONGER_WISH_FROM_X_CLICK_Y' => 'Jos et enää halua saada ilmoituksia sähköposteista %s, <a %s>klikkaa tätä</a>.',
        'CLICK_HERE' => 'Klikkaa tätä',
        'YOU_CAN_CONTACT_US' => 'Voit ottaa yhteyden kaikissa asioissa, jotka koskevat yksityisyyttäsi osoitteeseen http://help.ning.com/?page_id=27 .',
        'MESSAGE_TO_ALL_MEMBERS_OF_X' => 'Viesti kaikille %s-verkoston jäsenille',
        'CLICK_TO_CHECK_OUT' => 'Klikkaa lukeaksesi!',
        'CLICK_TO_APPROVE_X' => 'Klikkaa hyväksy/poista tämä %s',
        'YOUR_X_HAS_BEEN_APPROVED' => 'Sinun %s on hyväksytty %s!',
        'YOUR_X_WAS_NOT_APPROVED' => 'Sinun %s ei ole hyväksytty %s.',
        'CLICK_TO_VIEW_X' => 'Klikkaa nähdäksesi tämä %s!',
        'CLICK_TO_VIEW_IT' => 'Klikkaa katsoaksesi!',
        'TO_VIEW_USER_PROFILE_VISIT' => 'Katsoaksesi %s:n profiilin, mene:',
        'YOU_ADDED_CONTENT' => 'olet lisännyt sisältöä moderoituun sosiaaliseen verkostoon %s',
        'X_REPORTED_AN_ISSUE_ON_Y_ELLIPSIS' => '%1$s on ilmoittanut ongelmasta verkostossa %2$s...',
        'X_REPORTED_THE_FOLLOWING_ISSUE' => '%s ilmoitti seuraavasta ongelmasta.',
        'URL_REPORTED_COLON' => 'Ilmoitettu URL:',
        'ISSUE_COLON' => 'Asia:',
        'ADDITIONAL_INFORMATION_COLON' => 'Lisätiedot:',
        'SEND_AN_INVITATION_TO_X' => 'Lähetä kutsu vastaanottajalle %s',
        'SOMEBODY_REQUESTED_JOIN_X' => 'joku on lähettänyt liittymispyynnön verkostoon %s',
        'WANT_TO_ADD_A_WELCOME_MESSAGE_FOR_X_ON_THEIR_PROFILE_GO_TO' => 'Haluatko lisätä Tervetuloa-viestin %s:n profiiliin?   Siirry:',
        'USER_HAS_SENT_YOU_A_MESSAGE' => '%s on lähettänyt sinulle viestin.',
        'TO_READ_THIS_MESSAGE_VISIT' => 'Lukeaksesi viestin mene:',
        'X_HAS_SENT_YOU_A_MESSAGE_ON_Y_ELLIPSIS' => '%s on lähettänyt sinulle viestin verkostossa %s…',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ELLIPSIS' => '%s on lisännyt sinut ystäviinsä…',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ON_Y' => '%s on lisännyt sinut ystäviinsä verkostossa %s...',
        'X_HAS_ACCEPTED_YOUR_FRIEND_REQUEST' => '%s on hyväksynyt ystäväpyyntösi verkostossa %s!',
        'TO_ACCEPT_THIS_FRIEND_REQUEST_VISIT' => 'Hyväksyäksesi tämän ystäväpyynnön mene:',
        'VIEW_XS_PAGE_ON_Y' => 'Katso %s:n sivua kohdassa %s',
        'MEMBER_OF_X_ACCEPTED' => '%s:n jäsen hyväksyi ystäväpyyntösi',
        'IF_NO_LONGER_WISH_FRIEND_NOTIFICATION_EMAIL_FROM_X_CLICK_Y' => 'Jos et enää halua saada viestejä ystäväpyynnöistä verkostosta %s, <a %s>klikkaa tätä</a>.',
        'YOU_RECEIVED_INVITATION_FROM_X' => 'Olet saanut kutsun %1$s:n jäseneltä.  Jos et halua saada kutsuja verkostosta %1$s, ota yhteyttä http://help.ning.com/?page_id=27 .',
        'ON_X_COLON' => 'Verkostossa %s:',
        'ON_X' => 'verkostossa %s',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP' => '%s on pyytänyt %s:n jäsenyyttä .',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X_ELLIPSIS' => '%1$s on pyytänyt %2$s:n jäsenyyttä verkostossa %3$s…',
        'USER_HAS_INVITED_YOU_TO_JOIN_THE_GROUP_X' => '%1$s on kutsunut sinut ryhmään "%2$s"',
        'VISIT_GROUP_AT' => 'Mene %s:',
        'ABOUT_GROUP' => 'Tietoja %s',
        'A_MESSAGE_FROM_USERNAME_TO_GROUPNAME_ON_APPNAME' => 'Viesti lähettäjältä %s kaikille %s:n jäsenille verkostossa %s!',
        'YOU_CAN_SIGN_IN_USING_EMAIL_HERE' => 'Voit kirjautua sisään sähköpostiosoitteellasi tästä:',
        'USERNAME_COMMENTED_ON_BLOG_POST_TITLE_APPNAME' => '%s kommentoi blog-postissa \'%s\'  %s',
        'SEND_X_A_MESSAGE_HERE' => 'Lähetä vastaanottajalle %s viesti tästä:',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X_ELLIPSIS' => 'Sinulla on jäsenpyyntö hyväksyttäväksi verkostossa %s…',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE' => 'Sinulla on uusi jäsen hyväksyttäväksi.',
        'TO_APPROVE_XS_PROFILE_VISIT' => 'Hyväksyäksesi %s:n profiilin, mene:',
        'CANT_CLICK_CUT_AND_PASTE' => 'Eikö linkki aukea?  Kopioi ja liitä URL-osoite web-selaimesi osoiteriville.',
        'CLICK_HERE_TO_JOIN_COLON' => 'Klikkaa liittyäksesi:',
        'CLICK_HERE_TO_JOIN_BANG' => 'Klikkaa tätä ja liity!',
        'YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED_ELLIPSIS' => '%s jäsenyytesi  on hyväksytty…',
        'CONGRATULATIONS_BANG_YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED' => 'Onnittelut!   %s jäsenyytesi on hyväksytty.',
        'YOU_CAN_NOW_SIGN_IN_USING_YOUR_EMAIL_ADDRESS_HERE' => 'Voit nyt kirjautua sisään käyttämällä sähköpostiosoitettasi:',
        'VISIT_X_AT_Y' => 'Käy %1$s : %2$s',
        'TO_CONTROL_WHICH_EMAILS_YOUR_RECEIVE_ON_X_GO_TO' => 'Hallinnoidaksesi sähköpostiviestejäsi %1$s, siirry:',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_ELLIPSIS' => 'Estetty jäsen on lähettänyt sinulle viestin %s…',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_USERNAME_WRITES' => 'Estetty jäsen on lähettänyt sinulle viestin %1$s.   %2$s kirjoittaa:',
        'WELCOME_TO_THE_GROUP_X' => 'Tervetuloa ryhmään "%s"',
        'WELCOME_TO_GROUP_X_ON_Y_ELLIPSIS' => 'Tervetuloa ryhmään %1$s verkostossa %2$s…',
        'TO_VIEW_THIS_GROUP_VISIT' => 'Nähdäksesi ryhmän viestit mene:',
        'X_INVITES_YOU_TO_JOIN_Y' => '%1$s kutsuu sinut mukaan %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y' => '%1$s on nyt %2$s jäsen.',
        'X_IS_NOW_A_MEMBER_OF_Y_ELLIPSIS' => '%1$s on nyt %2$s:n jäsen',
        'SOMEBODY' => 'Joku',
        'TO_VIEW_YOUR_NEW_COMMENT_VISIT' => 'Katsoaksesi uuden kommenttisi mene:',
        'TO_VIEW_THE_NEW_COMMENT_VISIT' => 'Katsoaksesi uuden kommentin mene:',
        'TO_VIEW_THE_NEW_REPLY_VISIT' => 'Katsoaksesi uuden vastauksen mene:',
        'WELCOME_TO_X_THANK_YOU_FOR_JOINING' => 'Tervetuloa %s!  Kiitos liittymisestä.',
        'NAME_COLON' => 'Nimi:',
        'EMAIL_COLON' => 'Sähköposti:',
        'AGE_COLON' => 'Ikä:',
        'GENDER_COLON' => 'Sukupuoli:',
        'LOCATION_COLON' => 'Sijainti:',
        'COUNTRY_COLON' => 'Maa:',
        'GET_NETWORK_BADGE' => '%s merkki',
        'SPREAD_WORD_GET_BADGE' => 'Levitä sanaa.  Hanki oma %s-merkki verkkosivuillesi tai   MySpace-sivullesi.  (<a %s>Hanki koodi</a>)',
        'SPREAD_WORD_GET_BADGE_SHORT' => 'Levitä sanaa.  <a href="%s">Hanki oma %s merkki</a>',
        'SHOW_ALLEGIANCE_GET_BADGE' => 'Näytä uskollisuutesi.  Hanki oma %s merkki websivuillesi tai MySpace-sivulle.  (<a %s>Hanki koodi</a>)',
        'USER_COMMENTED_ON_A_TYPE_ON_APPNAME' => '%1$s kommentoi %2$s "%4$s" kohdassa %3$s',
        'UNABLE_TO_EXTRACT_EMAIL_ADDRESSES' => 'Pahoittelemme, emme pystyneet saamaan  sähköpostiosoitteita tästä tiedostosta.',
        'ADMINISTRATORS' => 'Järjestelmänvalvojat',
        'YOUR_INVITATION_HAS_EXPIRED' => 'Kutsusi on rauennut',
        'SORRY_INVITATION_EXPIRED' => 'Olemme pahoillamme kutsusi on rauennut.   Tarvitset uuden kutsun liittyäksesi %s.',
        'DISABLE_INVITATION_LINK' => 'Poistetaanko Kutsulinkki käytöstä?',
        'CREATING_LINK_WILL_DISABLE' => 'Uuden kutsulinkin luominen poistaa nykyisen linkin käytöstä.  Oletko varma, että haluat luoda uuden linkin?',
        'SHARE_LINK_WITH_PEOPLE' => 'Lähetä tämä linkki henkilöille, joiden haluat liittyvän tähän verkostoon:',
        'CREATE_INVITATION_LINK' => 'Luo uusi Kutsulinkki',
        'PLEASE_SELECT_SECOND_PART' => 'Valitse sähköpostiosoitteesi loppuosa, esimerkiksi gmail. com.',
        'AT_SYMBOL_NOT_ALLOWED' => 'Varmista, ettei @ merkki ole osoitteen ensimmäisessä osassa.',
        'SORRY_WE_DONT_SUPPORT' => 'Valitettavasti emme tue sähköpostiosoitteesi osoitteistoa.  Klikkaa \'Email Application\' käyttääksesi tietokoneesi osoitteita.',
        'PLEASE_ENTER_PASSWORD_FOR_EMAIL' => 'Anna %s salasanasi.',
        'IMPORTING_ADDRESS_BOOK' => 'Tuo osoitekirjaa',
        'LEAVE_WINDOW_WHILE_GET' => '<strong>Pidä ikkuna auki</strong> niin kauan kunnes olemme tuoneet ystäviesi sähköpostiosoitteet.  Kun tuominen on loppuunsuoritettu, voit valita ketkä ystävistä haluat kutsua.',
        'SHARE_THIS_LINK' => 'Lähetä tämä linkki:',
        'SEND_WITH_EMAIL_PROGRAM' => 'Lähetä se tietokoneesi sähköpostiohjelmalla:',
        'EMAIL_THIS' => 'Lähetä sähköpostilla tämä',
        'IS_YOUR_FRIEND_PARENTHESIZED' => '(on ystäväsi)',
        'CLEAR' => 'Poista',
        'SEARCH_FRIENDS_TO_INVITE' => 'Valitse kutsuttavat ystävät:',
        'YOUR_INVITATIONS_HAVE_BEEN_SENT' => 'Kutsusi on lähetetty',
        'WANT_TO_INVITE_MORE' => 'Haluatko kutsua lisää ystäviä?  Kutsu lisää ystäviä tuomalla kontaktisi web-osoitekirjastasi tai sähköpostiohjelmastasi.',
        'MESSAGE_TOO_LONG' => 'Viestisi on liian pitkä. Käytä enintään %s merkkiä.',
        'FOLLOWING_DO_NOT_SEEM_VALID' => 'Osoite ei ole kelvollinen sähköpostiosoite.  Kutsuja ei ole lähetetty.  Korjaa sähköpostiosoitteet ja yritä uudelleen.',
        'PLEASE_ENTER_EMAIL_ADDRESSES' => 'Lisää yksi tai useampia sähköpostiosoitteita.',
        'ENTER_EMAIL_ADDRESSES' => 'Lisää sähköpostiosoitteet',
        'SEPARATE_MULTIPLE_ADDRESSES' => 'Erottele useammat osoitteet pilkuilla',
        'YOUR_MESSAGE_OPTIONAL' => '<label>Viestisi</label> (Valinnainen)',
        'SEND_INVITATIONS' => 'Lähetä kutsut',
        'WEB_ADDRESS_BOOK' => 'Web osoitekirja',
        'YAHOO_MAIL_HOTMAIL' => 'Yahoo Mail, Hotmail, GMail tai AOL Mail',
        'YOUR_EMAIL_ADDRESS' => 'Oma sähköpostiosoitteesi',
        'IMPORT_ADDRESS_BOOK' => 'Tuo osoitekirja',
        'DONT_WORRY_WE_WONT_SAVE' => 'Älä huolestu, emme tallenna salasanaasi ja saat mahdollisuuden valita kenelle ystävistäsi sähköposti lähetetään.',
        'EMAIL_APPLICATION' => 'Sähköpostiohjelma',
        'MICROSOFT_OUTLOOK_APPLE_MAIL' => 'Microsoft Outlook, Apple Mail, . CSV, jne.',
        'UPLOAD_CSV_OR_VCF' => 'Lataa Microsoft Outlookista tai Applen osoitekirjasta tuotu csv- tai . vcf-tiedosto.',
        'BROWSE_FOR_FILE' => 'Etsi tiedosto',
        'UPLOAD' => 'Lataa',
        'SELECT_ELLIPSIS' => 'valitse…',
        'OTHER_ELLIPSIS' => 'toinen…',
        'DONT_WORRY_YOULL_GET_CHANCE' => 'Älä huolestu saat mahdollisuuden valita kenelle ystävistä sähköposti lähetetään.',
        'MEMBERSHIP_BY_INVITATION_ONLY' => 'Jäsenyys vain kutsulla',
        'IF_YOU_ARE_ADMIN' => 'Jos olet järjestelmänvalvoja <a %s>klikkaa kirjautuaksesi sisään</a>.',
        'NAME_MUST_BE_SHORTER' => 'Nimen täytyy olla lyhyempi kuin %s merkkiä',
        'CITY_NAME_MUST_BE_SHORTER' => 'Kaupungin nimen täytyy olla lyhyempi kuin %s merkkiä',
        'EMAIL_ALREADY_REGISTERED' => 'Tämä sähköpostisoite on jo käytössä.  Valitse uusi.',
        'EMAIL_NOT_VALID' => 'Tämä sähköpostiosoite ei ole kelvollinen.',
        'USERNAME_INVITED_YOU_TO_APPNAME' => '%s kutsui sinut %s',
        'YOU_ARE_SIGNING_UP_WITH' => 'Olet kirjautumassa sisään Ning ID:lläsi.',
        'NOW_ENTER_PASSWORD' => 'Anna salasanasi jatkaaksesi.',
        'OR_SIGN_IN' => 'or <a %s>Kirjaudu sisään</a>',
        'CHANGE_ADDRESS' => 'Muuta osoite',
        'CHANGE_PAGE_ADDRESS' => 'Muuta sivun osoite',
        'PAGE_ADDRESS_TAKEN' => 'Valitettavasti tämä osoite on jo käytössä.  Valitse uusi.',
        'PAGE_ADDRESS_NOT_VALID' => 'Voit käyttää kirjaimia A-Z, numeroita ja alaviivaa (_) osoitteessasi.',
        'ADD_BY_PHONE' => 'Lisää puhelimitse',
        'PAGE_ADDRESS' => 'Sivun osoite',
        'PHOTO_MUST_BE_TYPE' => 'Valokuvasi tulee olla . jpg, . gif tai . png-muodossa.',
        'USEFUL_ADDRESSES' => 'Hyödyllisiä osoitteita',
        'MY_DETAILS' => 'Omat tiedot',
        'NONE_I_DO_NOT_WANT' => 'Ei: En halua saada sähköposteja lähettäjältä %s',
        'CHANGE_PASSWORD' => 'Vaihda salasana',
        'PROFILE_SAVED' => 'Muutoksesi on tallennettu.',
        'UPDATE_EMAIL_ADDRESS' => 'Päivitä sähköpostisoite',
        'EDIT_EMAIL_ADDRESS' => 'Muokkaa sähköpostiosoitettasi',
        'MY_SETTINGS' => 'Omat asetukset',
        'ABOUT_ME' => 'Tietoja minusta',
        'SELECT' => 'Valitse…',
        'CITY' => 'Kaupunki',
        'COUNTRY' => 'Maa',
        'DATE_OF_BIRTH' => 'Syntymäaika',
        'DO_NOT_DISPLAY' => 'Älä näytä',
        'GENDER' => 'Sukupuoli',
        'CREATE_YOUR_PROFILE' => 'Luo oma profiili',
        'SYSTEM_REQUIREMENTS' => 'Järjestelmävaatimukset',
        'WE_SUPPORT_INTERNET_EXPLORER' => 'Tuemme selaimia Internet Explorer 6 & 7, Firefox 2.0 ja Safari 2.0. Jos käytät jotain muuta selainta (ehkä internetpalvelusi tarjoamaa) voi olla, ettei se ole yhteensopiva.',
        'MAKE_SURE_COOKIES' => 'Salli evästeet ja JavaScript selaimessasi.',
        'WHAT_IS_MY_EMAIL' => 'Mikä on sähköpostiosoitteeni?',
        'IF_JOINED_BEFORE_OCTOBER' => 'Jos olet liittynyt ennen 5.lokakuuta 2007, sinulta on aiemmin pyydetty \'Ning ID\'.  Pyydämme sinua kirjautumaan sisään sillä sähköpostiosoitteella, jolla rekisteröidyit. Voit kuitenkin vielä lisätä Ning ID:n tähän kenttään.',
        'CLICK_HERE_TO_RESET_PASSWORD' => 'Klikkaa poistaaksesi salasanasi.',
        'STILL_HAVING_PROBLEMS' => 'Onko vielä ongelmia?',
        'VISIT_NING_HELP_CENTER' => 'Vieraile <a %s>Ning Help Center</a> saadaksesi lisää neuvoja ja tukea.',
        'PROBLEMS_SIGNING_UP_OR_SIGNING_IN' => 'Ongelmia rekisteröinnissä tai sisäänkirjautumisessa.',
        'WE_SENT_YOU_EMAIL' => 'Olemme lähettäneen sinulle sähköpostilla linkin, jonka kautta voit poistaa salasanasi.',
        'RESET_PASSWORD_EMAIL_SUBJECT' => 'Salasanan poisto',
        'RESET_PASSWORD_EMAIL_BODY' => '%1$s,

Olemme saaneet pyynnön muuttaa salasanasi %2$s.

Klikkaa linkkiä alla antaaksesi uuden salasanan:

#{URL}

Jos et halua muuttaa salasanaasi hylkää tämä viesti.

Kiitos,
"%2$s" Tiimi

-----
%2$s käyttää  Ning ID:tä tunnistamiseen.',
        'SET_PASSWORD' => 'Anna salasana',
        'NEW_PASSWORD' => 'Uusi salasana',
        'CREATE_NEW_PASSWORD' => 'Luo uusi salasana',
        'SET_NEW_PASSWORD' => 'Anna uusi salasana Ning ID tilillesi.',
        'CHOOSE_NEW_PASSWORD' => 'Valitse uusi salasana',
        'HELLO_USERNAME_SIGN_OUT' => '<strong>Hei, %s</strong> (<a %s>kirjaudu ulos</a>)',
        'NO_ACCOUNT_WITH_EMAIL_X' => 'Tällä sähköpostiosoitteella %s ei löydy tiliä',
        'PLEASE_ENTER_CODE' => 'Lisää oikealle ilmestyvä koodi.',
        'PROBLEMS_SIGNING_UP' => 'Onko ongelmia rekisteröinnissä?',
        'BY_SIGNING_UP_YOU_AGREE' => 'Rekisteröityessäsi hyväksyt <a %s>Terms of Service</a> ja <a %s>Privacy&nbsp Policy</a>.',
        'FEEDBACK' => 'Palaute',
        'TERMS_OF_SERVICE' => 'Palveluehdot',
        'PROBLEM_SIGNING_UP' => 'Rekisteröinnissä on ongelma',
        'ALREADY_MEMBER_SIGN_IN' => 'Oletko jo jäsen?  <a %s>Klikkaa kirjautuaksesi sisään</a>.',
        'MEMBERSHIP_TO_APPNAME_BY_INVITATION_ONLY' => '%s jäsenyys vain kutsulla',
        'SORRY_BUT_ADMINISTRATOR_REQUIRES_INVITATION' => 'Olemme pahoillamme, mutta järjestelmänvalvoja vaatii kutsun %s:n liittymiseksi.  Jos sinulla on kutsu, klikkaa sähköpostin linkkiä liittyäksesi.',
        'PROBLEM_SIGNING_IN' => 'Sisäänkirjautumisessa oli ongelma',
        'WE_USE_NING_ID' => 'Käytämme Ning ID -tunnistusta.  <a %s>Mikä on Ning ID? </a>',
        'PROBLEMS_SIGNING_IN' => 'Onko ongelmia sisäänkirjautumisessa?',
        'SIGN_IN_OR_SIGN_UP' => '<input %s value="Kirjaudu sisään" /> &#160; tai&#160;  <strong><a %s>Rekisteröidy</a></strong>',
        'SIGN_IN_TO_APPNAME' => 'Kirjaudu sisään %s',
        'WHAT_IS_A_NING_ID' => 'Mikä on Ning ID?',
        'LARR_BACK' => '<a %s>Takaisin</a>',
        'NING_ID_LETS_YOU_CHOOSE' => 'Ning ID -tunnistusjärjestelmä sallii sinun valita sähköpostiosoitteen ja salasanan ja käyttää niitä rekisteröinnissä ja sisäänkirjautumisessa kaikkiin verkkoihin, jotka käyttävät Ning ID:tä.',
        'WHEN_YOU_CREATE_NING_ID' => 'Kun luot itsellesi Ning ID:n, voit myös lisätä perustietoja ja valokuvan  Ning ID -tilillesi.  Nämä tiedot täydentyvät kaikkiin uusiin verkostoihin, jotka käyttävät Ning ID -tunnistusta.  Se mahdollistaa myös ystäviesi ja viestien jäljittämisen kaikissa sosiaalisissa verkostoissa, jotka käyttävät sitä.',
        'SIGN_IN_WITH_NING_ID_WHENEVER' => 'Voit kirjautua sisään Ning ID -sähköpostiosoitteella ja salasanalla aina kun näet tämän symbolin: %s',
        'HELLO_USER' => 'Hei, %s',
        'TEXT_FOR_HEADER_TAB' => 'Tämä teksti on välilehden otsikko',
        'BASED_ON' => 'Perustuu',
        'ARE_YOU_SURE_DELETE_LANGUAGE' => 'Oletko varma, että haluat poistaa tämän kielen?',
        'DELETE_LANGUAGE' => 'Poista kieli',
        'TEXT_RESET_TO_ORIGINAL_VERSION' => 'Teksti on palautettu alkuperäiseen muotoon.',
        'UPLOAD_LANGUAGE_FILE' => 'Lataa kielitiedosto',
        'ADD_TO_LANGUAGE' => 'Lisää kieli:',
        'IF_YOU_CREATED_TRANSLATION' => 'Jos olet tehnyt uuden käännöksen johonkin Ning sosiaaliseen verkostoon voit tuoda työsi tänne.  Tiedoston sisältö lisätään valitsemaasi kieleen.  Etkö löydä omaa kieltäsi?  <a %s>Uuden lisääminen on helppoa</a>.',
        'EXAMPLES_SWEDISH_FINLAND' => 'Esimerkiksi: ruotsi (suomi), filippiino, espanja (puerto rico)',
        'START_FROM_SCRATCH_CREATE' => 'Aloita alusta!  Tee uusi käännös verkostoosi syöttämällä uuden kielen nimen ja sitten valitsemalla olemassaolevan kielen referenssiksi.',
        'KEY_MISSING_TEXT' => 'Avain: <span %s>Puuttuva teksti</span> <span %s>Muutettu teksti</span>',
        'SHOW_ALL_TEXT' => 'Näytä kaikki teksti',
        'SHOW_MISSING_TEXT' => 'Näytä puuttuva teksti',
        'SHOW_CHANGED_TEXT' => 'Näytä muutettu teksti',
        'EXAMPLES_TABS_MEMBERS_FRIENDS' => 'Esimerkkejä: Välilehdet, Jäsenet, Ystävät',
        'RESET_TEXT_TO_ORIGINAL_VERSION' => 'Palauta teksti alkuperäiseen muotoon',
        'ORIGINAL_TEXT_X' => 'Alkuperäinen teksti - %s',
        'EDIT_LANGUAGE_ON_NETWORK' => 'Muokkaa verkostosi kieltä',
        'CUSTOMIZE_TEXT_ON_NETWORK_INCLUDING' => 'Mukauta verkostosi tekstit, mukaan lukien välilehdet, sähköpostitunnisteet, virhesanomat ja muut.',
        'ACTIVE_LANGUAGE_IS_X' => '<em>Verkostosi aktiivinen kieli on  %1$s</em>.  <a %2$s>Vaihda aktiivinen kieli</a>',
        'CURRENT_LANGUAGE_OPTIONS' => 'Nykyinen kieliasetus',
        'ACTIVE' => 'Aktiivinen',
        'MY_LANGUAGES' => 'Omat kielet',
        'CREATE_NEW_TRANSLATION' => 'Luo uusi käännös',
        'DONT_SEE_LANGUAGE_LISTED_CREATE' => 'Etkö löydä kieltäsi listalta?  <strong><a %s>Luo uusi käännös verkostoosi</a></strong>.',
        'ADVANCED_IMPORT' => 'Erikoishaku',
        'IF_YOU_TRANSLATED_A_LANGUAGE' => 'Jos olet kääntänyt kieltä jossakin sosiaalisessa verkostossa voit <strong><a %s>tuoda kielitiedoston</a></strong> ja käyttää sitä tässä verkostossa.',
        'LANGUAGE_EDITOR' => 'Kielieditori',
        'PUBLIC' => 'Julkinen',
        'GRANDFATHERED_PRIVACY_SETTING' => 'Nykyiset yksityisyysasetuksesi, julkinen verkko jossa ei-jäsenet voivat nähdä vain aloitusvalikon, eivät ole enää käytössä.   Yksityisyysasetuksiasi ei ole muutettu, mutta jos teet jotain muutoksia tässä et voi palata takaisin.   Nykyinen asetus on yksityinen verkko johon kuka tahansa voi rekisteröityä tullakseen jäseneksi.',
        'NO_MISSING_ITEMS' => 'Ei puuttuvia nimikkeitä - tämä käännös on  100%% valmis.  <a %s>Näytä kaikki nimikkeet. </a>',
        'NO_CHANGED_ITEMS' => 'Ei puuttuvia nimikkeitä.',
        'COULD_NOT_FIND_ITEMS_MATCHING' => 'Valitettavasti emme löytäneet <em>%s</em> vastaavia nimikkeitä.  <a %s>Näytä kaikki nimikkeet. </a>',
        'FILE_N' => 'Tiedosto %s',
        'TRANSLATION_FILE_HAS_FILENAME_LIKE' => 'Ning käännöksen tiedostonimi on muotoa<code>en_US. txt</code>.  <a %s>Lue lisää täältä. </a>',
        'SELECT_TRANSLATION_FILE' => 'Valitse käännöstiedosto:',
        'USE_THIS_TRANSLATION' => 'Käytä tätä käännöstä',
        'FOLLOWING_ARE_MISSING_FROM_RULES' => 'Huomaa että seuraavat puuttuvat allaolevista säännöistä: %s',
        'ALL' => 'Kaikki',
        'MISSING' => 'Puuttuvat',
        'VIEW' => 'Näytä',
        'TRANSLATION_CHANGES_SAVED' => 'Muutoksesi on tallennettu.  Tämä käännös on %s%% valmis.',
        'TRANSLATION_CHANGES_SAVED_MAKE_CURRENT' => 'Muutoksesi on tallennettu.  Tämä käännös on %s%% valmis.  Haluatko käyttää nykyistä kielivalintaa verkostossasi?',
        'TRANSLATION_UPLOAD_SUCCESSFUL' => 'Latauksesi onnistui.  Tämä käännös on %s%% valmis.',
        'TRANSLATION_UPLOAD_SUCCESSFUL_MAKE_CURRENT' => 'Latauksesi onnistui.  Tämä käännös on %s%% valmis.  Haluatko käyttää nykyistä kielivalintaa verkostossasi?',
        'X_IS_CURRENT_LANGUAGE' => '%s on nyt verkostosi kieli.',
        'SAVE_PAGE' => 'Tallenna sivu',
        'LANGUAGE_NAME_TAKEN' => 'Valitsemasi nimi on jo valitettavasti käytössä.  Valitse toinen nimi.',
        'ENTER_NAME_FOR_TRANSLATION' => 'Anna nimi uudelle käännökselle, esimerkiksi portugali (Portugali)',
        'CREATE' => 'Luo',
        'LANGUAGE_NAME' => 'Kielen nimi',
        'SAVE_ITEMS_ON_PAGE' => 'Tallenna tämän sivun nimikkeet',
        'NEW_TRANSLATION' => 'Uusi käännös',
        'MISMATCHED_CURLY_BRACKETS' => 'Virheelliset aaltosulkeet',
        'MISMATCHED_SQUARE_BRACKETS' => 'Virheelliset hakasulkeet',
        'MISMATCHED_PARENTHESES' => 'Virheelliset lainausmerkit',
        'ERROR_PROCESSING_SPECIAL_RULES' => 'On tapahtunut virhe käsiteltäessä Erikoissääntökoodeja.',
        'ERROR_PROCESSING_TAB_NAMES' => 'On tapahtunut virhe käsiteltäessä välilehtinimikoodia.',
        'SPECIAL_RULES' => 'Erityissäännöt',
        'TAB_NAMES' => 'Välilehtien nimet',
        'SOURCE' => 'Lähde',
        'LANGUAGE_EDITOR_X' => 'Kielieditori: %s',
        'BACK_TO_LANGUAGE_EDITOR' => '← Palaa kielieditoriin',
        'CUSTOMIZE_YOUR_NETWORKS_TEXT' => 'Mukauta verkostosi tekstit ja viestit tai luo uusi kieli.',
        'STOPWORDS' => 'a | about | an | are | as | at | be | by | com | de | en | for | from | how | i | in | is | it | la | of | on | or | that | the | this | to | was | what | when | where | who | will | with | und | the | www',
        'STOPWORDS_ARE' => '<a %s>Stopwords</a> on valinnainen lista sanoja jotka voidaan suodattaa pois verkoston kuvauksesta kun luodaan sivujen yläreunan metatageja.  Valinnainen.',
        'I_AM_MEMBER' => 'Olen jäsen:',
        'VIEW_PAGE_ON_APPNAME' => 'Katso sivuani <em>%s</em>',
        'VISIT_APPNAME' => 'Vieraile <em>%s</em>',
        'JOIN_US' => 'Liity meihin',
        'CREATED_BY_COLON' => 'Luonut:',
        'GET_MORE_BADGES' => 'Hae lisää merkkejä',
        'SHOW_LOGO' => 'Näytä logo',
        'GALLERY' => 'Galleria',
        'BADGES' => 'Merkit',
        'MEMBER_BADGE' => 'Jäsenmerkki',
        'WEAR_IT_WITH_PRIDE' => 'Käytä sitä ylpeydellä!  Hae %s jäsenmerkki jota voit käyttää verkkosivullasi tai MySpace-sivulla.',
        'NETWORK_BADGE_LARGE' => 'Verkostomerkki (iso)',
        'SPREAD_THE_WORD_NETWORK_BADGE_LARGE' => 'Levitä sanaa!  Hae %s merkki joka päivittyy dynaamisesti suosituimpien jäsenten verkostoissa.  Lisää verkkosivullesi tai MySpace-sivulle.',
        'NETWORK_BADGE_SMALL' => 'Verkostomerkki (pieni)',
        'SPREAD_THE_WORD_NETWORK_BADGE_SMALL' => 'Levitä sanaa!  Hae %s merkki jota voit käyttää verkkosivullasi tai MySpace-sivulla.',
        'PHOTO_SLIDESHOW_PROPER' => 'Kuvaesitys',
        'DISPLAY_SELECTION_OF_PHOTOS' => 'Näytä valikoima kuviasi verkkosivullasi tai MySpace-sivulla käyttäen hienoa kuvanesityssoitinta.',
        'MUSIC_PLAYER' => 'Musiikkisoitin',
        'PLAY_MUSIC_ON_WEBSITE' => 'Soita musiikkia verkkosivullasi tai  MySpace -sivulla käyttäen hienoa musiikkisoitintamme.',
        'ADD_A_VIDEO_MORE_OPTIONS' => 'Lisää video verkkosivullesi tai MySpace -sivulle.  Etsitkö lisää asetuksia?  <a href="%s">Näytä kaikki videot</a> on %s.',
        'LARGE_N_PIXELS_WIDE' => 'Iso - %d kuvapistettä leveä',
        'MEDIUM_N_PIXELS_WIDE' => 'Normaali - %d kuvapistettä leveä',
        'SMALL_N_PIXELS_WIDE' => 'Pieni - %d kuvapistettä leveä',
        'MY_MOST_RECENT' => 'Omat uusimmat',
        'APP_ICON' => 'App kuvake',
        'MEMBERSHIP_TO_X_IS_BY_INVITATION' => '%s jäsenyys vain kutsulla',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK' => '%s on antanut seuraavaa palautetta:',
        'X_PROVIDED_FEEDBACK_ON_Y_ELLIPSIS' => '%1$s on antanut palautetta %2$s…',
        'THANK_YOU_YOUR_MESSAGE_HAS_BEEN_SENT' => 'Kiitos.   Viestisi on lähetetty.',
        'X_WOULD_LIKE_TO_JOIN_X' => '%s haluaisi liittyä verkostoon %s!',
        'X_HAS_REQUESTED_AN_INVITATION' => '%s on pyytänyt kutsua verkostoon %s',
        'YOUR_REQUEST_HAS_BEEN_SENT' => 'Pyyntösi on lähetetty verkoston perustajalle.',
        'TO_UNBAN_USERNAME_GO_TO' => 'Salli %s, siirry:',
        'SEND_REQUEST' => 'Lähetä pyyntö',
        'SEARCH' => 'Etsi',
        'SEARCH_AGAIN' => 'Etsi uudestaan',
        'SEND_BROADCAST_MESSAGE' => 'Lähetä yleinen viesti',
        'VERIFICATION_IMAGE' => 'Tarkastuskuva',
        'UNDER_CONSTRUCTION' => 'Tekeillä',
        'PROFILE_INFORMATION_SAVED' => 'Profiilitieto tallennettu',
        'YOUR_SITES_DIRECTORY_PROFILE' => 'Verkostosi profiilikansio on tallennettu.',
        'NO_ACCOUNT_WITH_EMAIL' => 'Tällä sähköpostiosoitteella ei löydy tiliä.',
        'INVALID_PASSWORD_CHECK_CAPS_LOCK' => 'Väärä salasana.   Onko Caps Lock päällä?',
        'OOPS_THAT' => 'Oho - tämä ei toimi.',
        'OOPS_THAT_DID_NOT_WORK' => 'Oho - tämä ei toimi.   Yritätkö uudestaan?',
        'OOPS_THAT_DID_NOT_WORK_ERROR_CODE' => 'Oho - tämä ei toimi (%s).',
        'NOT_FOUND' => 'Ei löydy',
        'YOUR_SITES_FEATURE_LIST' => 'Verkostosi ominaisuuslista on tallennettu.',
        'ONE_LINE_ANSWER' => 'Yhden rivin vastaus',
        'LONGER_ANSWER' => 'Pitempi vastaus',
        'MULTIPLE_CHOICE' => 'Monivalinta',
        'DATE' => 'Päivämäärä',
        'WEBSITE_ADDRESS' => 'Kotisivuosoite',
        'EVERYTHING' => 'Kaikki',
        'JUST_THE_HOMEPAGE' => 'Vain pääsivu',
        'JUST_THE_SIGN_UP_PAGE' => 'Vain allekirjoitussivu',
        'YOUR_CHANGES_HAVE_BEEN_SAVED' => 'Muutoksesi on tallennettu.',
        'JOIN_ME_ON_X' => 'Liitä minut verkostoon %s!',
        'NOT_ALLOWED' => 'Ei sallittu',
        'COME_JOIN_ME_ON_X' => 'Liity seuraani verkostossa %s!',
        'COME_JOIN_ME_ON_X_ELLIPSIS' => 'Liity seuraani verkostossa %s…',
        'X_NOT_VALID_EMAIL' => '%s ei ole kelvollinen sähköpostiosoite tai Ning ID',
        'USER_BANNED_FROM_NETWORK' => '%1$s on estetty tästä verkostosta.  <a %2$s>Lähetä %1$s viesti</a>',
        'USER_ALREADY_NETWORK_MEMBER' => '%1$s on jo tämän verkoston jäsen.  <a %2$s>Lähetä %1$s viesti</a>',
        'YOU_CAN_SEND_AT_MOST_X' => 'Voit lähettää enintään %s kerrallaan.',
        'PLEASE_ENTER_YOUR_FRIENDS' => 'Anna ystäviesi sähköpostisosoitteet tai Ning ID:t',
        'THERE_HAS_BEEN_AN_ERROR' => 'On tapahtunut virhe',
        'INVITATIONS_HAVE_BEEN_SENT' => 'Kutsusi on lähetetty.',
        'SEARCH_RESULTS' => 'Etsinnän tulokset',
        'INVITE_YOUR_FRIENDS' => 'Kutsu ystäväsi',
        'SEND_INVITATIONS_FOR_FRIENDS' => 'Lähetä liittymiskutsuja ystävillesi',
        'INVITATION' => 'Kutsu',
        'ADD_FROM_ADDRESS' => 'Lisää osoitekirjasta',
        'TO' => 'Kenelle:',
        'SEND_TO' => 'Lähetä',
        'SUBJECT' => 'Aihe',
        'YOUR_MESSAGE' => 'Viestisi',
        'SEND' => 'Lähetä',
        'REPORT_AN_ISSUE' => 'Ilmoita ongelmasta',
        'TYPE_OF_ISSUE' => 'Asian laatu',
        'ADULT' => 'Sopimaton',
        'ABUSIVE' => 'Loukkaava',
        'BUG' => 'Bugi',
        'FRAUD' => 'Petos',
        'SPAM' => 'Spam',
        'OTHER' => 'Muut',
        'DESCRIBE_YOUR_ISSUE' => 'Kuvaile asia',
        'SEND_REPORT' => 'Lähetä ilmoitus',
        'ADDED_BY_X_AT_X' => 'Lisännyt <a %s>%s</a>  %s on %s',
        'ADDED_BY_USER_TO_GROUP_AT_DATE' => 'Lisännyt <a %s>%s</a>  %s at %s on %s',
        'G_IA' => 'g:ia',
        'F_JS_Y' => 'F jS, Y',
        'CLICK_TO_VIEW' => 'Klikkaa nähdäksesi',
        'COMMENT_FOR' => 'Kommentti:',
        'COMMENT_ON' => 'Kommentti:',
        'ACTION_BUTTON_FEATURE' => 'Ominaisuus',
        'FEATURE_THIS_ON_YOUR' => 'Esitä tämä etusivulla',
        'ACTION_BUTTON_REMOVE' => 'Poista',
        'REMOVE' => 'Poista',
        'REMOVE_THIS_FROM_YOUR' => 'Poista tämä etusivulta',
        'FEATURE_ON_HOME' => 'Pääsivun ominaisuus',
        'REMOVE_FROM_HOME' => 'Poista pääsivulta',
        'ITEM_WILL_APPEAR' => 'Tätä ei näytetä valituissa moduuleissa etusivulla',
        'ITEM_WILL_NO_LONGER_APPEAR' => 'Tätä ei enää näytetä valituissa moduuleissa etusivulla',
        'ADD_CONTENT' => 'Lisää sisältö',
        'BROUGHT_TO_YOU_BY' => '%s tekijä %s © %s',
        'GIVE_US_YOUR_FEEDBACK' => 'Anna meille palautetta',
        'FOR_ADDITIONAL_QUESTIONS_OR_TO_CONTACT_NING_PLEASE_CLICK_HERE' => 'Lisätietoja saat ottamalla yhteyden Ning-verkostoon, klikkaa tätä:',
        'SEND_FEEDBACK' => 'Lähetä palaute',
        'SIGN_OUT' => 'kirjautua ulos',
        'SIGN_OUT_TITLE' => 'Kirjaudu ulos',
        'EDIT_MY_PROFILE' => 'Muokkaa profiilin vastauksia',
        'INVITE_MORE' => 'Kutsu lisää',
        'USE_THIS_FORM_TO_SEND_FEEDBACK_TO_NC' => 'Käytä tätä lomaketta lähettääksesi palautetta <a %s>%s</a>:lle, <a %s>%s</a>:n perustajalle.',
        'YOUR_FEEDBACK' => 'Palautteesi',
        'NETWORK_INFORMATION' => 'Verkostotieto',
        'ABOUT_YOUR_SITE' => 'Tietoa verkostostasi',
        'WELCOME_TO_YOUR_SITE' => 'Tervetuloa omaan verkostoosi!',
        'EDIT_YOUR_NETWORKS_INFO' => 'Muokkaa verkostosi nimeä, kuvausta tai muuta tietoa.',
        'TAGLINE' => 'Tagrivi',
        'APPEARS_IN_HEADER' => 'Näkyy verkostosi otsikossa',
        'APPEARS_IN_EMAILS' => 'Näkyy sähköposteissa ja muualla',
        'NETWORK_NAME' => 'Verkoston nimi',
        'DESCRIPTION' => 'Kuvaus',
        'KEYWORDS' => 'Avainsanat',
        'LANGUAGE' => 'Kieli',
        'SEPARATE_EACH_KEYWORD' => 'Erottele avainsanat toisistaan pilkuilla',
        'ICON' => 'Kuvake',
        'UPLOAD_A_PHOTO_WHICH_WILL_BE_RESIZED' => 'Lataa kuva (GIF, JPG or PNG), joka muutetaan neliön muotoiseksi.  Kuvan näyttämiseen saattaa kulua muutama minuutti.',
        'SAVE_SETTINGS' => 'Tallenna asetukset',
        'SUCCESS_EXCLAMATION' => 'Onnistui!',
        'FEATURES' => 'Ominaisuudet',
        'ADD_FEATURES' => 'Lisää ominaisuuksia verkostoosi.',
        'ORGANIZE_FEATURES' => 'Järjestä pääsivusi: vedä ominaisuuksia alla olevasta listasta ja laita ne sitten haluamaasi järjestykseen.',
        'SKIP_FEATURES' => 'Napsauta <a href="%s">Ohita</a>, jos haluat jatkaa oletusasettelulla ja ominaisuuksilla.',
        'FEATURES_FOR_ALL_PAGES' => 'Tähän laatikkoon lisätyt ominaisuudet näkyvät verkostosi kaikilla sivuilla.',
        'CUSTOMIZE_SITE_BY_ADDING' => 'Mukauta yhteisöäsi lisäämällä uusia ominaisuuksia tai poistamalla nykyisiä.',
        'ADJUST_YOUR_SITES_COLORS' => 'Muuta verkostosi värejä, kuvia ja yleistä tyyliä.',
        'APPEARANCE' => 'Ulkoasu',
        'PROFILE_QUESTIONS' => 'Profiilikysymykset',
        'EDIT_QUESTIONS_THAT_MEMBERS_ANSWER' => 'Muokkaa kysymyksiä, joihin jäsenet vastaavat.',
        'MESSAGE_SENT' => 'Viesti lähetetty!',
        'YOUR_MESSAGE_HAS_BEEN_SENT' => 'Viestisi on lähetetty kaikille verkostosi jäsenille.',
        'YOUR_MESSAGE_HAS_BEEN_SENT_GROUP' => 'Viestisi on lähetetty kaikille ryhmäsi jäsenille.',
        'YOUR_MESSAGE_IS_BEING_SENT' => 'Viestiäsi lähetetään.  Odota, tämä saattaa kestää muutaman minuutin.',
        'BROADCAST_MESSAGE' => 'Lähetä viesti',
        'TRACK_VISITORS_AND_TRENDS' => 'Seuraa yhteisösi vieraita ja suuntauksia.',
        'EDIT_SOURCE_CODE' => 'Muokkaa lähdekoodia',
        'TAKE_FULL_CONTROL' => 'Ota verkostosi toiminnallisuus hallintaasi muokkaamalla lähdekoodia.',
        'DELETE_THIS_SITE' => 'Poista yhteisösi.',
        'MAIN_PAGE' => 'Pääsivu',
        'MAIN' => 'Pää',
        'MAIN_TAB_TEXT' => 'Pää',
        'MANAGE' => 'Hallinnoi',
        'MANAGE_TAB_TEXT' => 'Hallinnoi',
        'PAGE_TITLE' => 'Sivun otsikko',
        'LOREM_IPSUM_1' => 'Lorem <span %s>ipsum dolor</span> sit amet, consectetuer adipiscing elit.  Nunc scelerisque blandit dolor.  Vestibulum ante ipsum primis in faucibus orci luctus.',
        'LOREM_IPSUM_2' => 'Lorem ipsum dolor sit amet, consectetuer adipiscing',
        'LOREM_IPSUM_3' => 'Lorem ipsum dolor sit amet, <span class="preview_link">consectetuer</span> adipiscing',
        'EDIT_THE_APPEARANCE' => 'Muokkaa sivusi ulkoasua.',
        'CHOOSE_A_THEME' => 'Valitse yhteisöllesi teema.',
        'NOW_CUSTOMIZE_SITE' => 'Mukauta yhteisöäsi…',
        'THEME_SETTINGS' => 'Teema-asetukset',
        'ADVANCED' => 'Erikoishaku',
        'TOP_BAR_AND_FOOTER' => 'Yläpalkki ja alatunniste',
        'HEADER_AND_NAVIGATION' => 'Otsikko ja navigointi',
        'ADD_A_LOGO' => 'Lisää logo',
        'THIS_IMAGE_WILL_REPLACE' => 'Tämä kuva korvaa verkoston nimitekstin',
        'TABS' => 'Välilehdet',
        'TAB' => 'Välilehti',
        'SITE' => 'Verkosto',
        'SIDES' => 'Puolet',
        'BODY' => 'Leipäteksti',
        'SHOW_NING_LOGO' => 'Näytetäänkö Ning-logo?',
        'LAUNCH' => 'OTA KÄYTTÖÖN!',
        'NING_ID' => 'Ning-tunnus',
        'PASSWORD' => 'Salasana',
        'RETYPE_PASSWORD' => 'Kirjoita salasana uudelleen',
        'TYPE_CODE_ON_RIGHT' => 'Kirjoita koodi<br />oikealla',
        'JOIN_X' => 'Liity tänne: %s',
        'SIGN_UP_FOR_X' => 'Kirjaudu tänne: %s',
        'HAS_INVITED_YOU_TO_X' => 'on kutsunut sinut liittymään tänne: %s.',
        'CONTENT_AWAITING_APPROVAL' => 'Odotetaan hyväksyntää',
        'NEW_MEMBER' => 'Uusi jäsen?',
        'JOIN_X_NOW' => 'Liity nyt tänne: %s!',
        'HIDE_THIS_MESSAGE' => 'Piilota tämä viesti',
        'PAGE_NOT_FOUND' => 'Sivua ei löydy',
        'THIS_PAGE_WAS_NOT_FOUND' => 'Pahoittelemme - tätä sivua ei löytynyt',
        'FOLLOW_THESE_LINKS_TO' => 'Tässä on toimivia linkkejä:',
        'ALTERNATIVELY_YOU_CAN_SEARCH' => 'Voit myös etsiä tästä yhteisöstä:',
        'IF_YOU_GET_THIS_MESSAGE' => 'Jos saat tämän viestin uudestaan, <a %s>kerro meille. </a>',
        'GROUP_MEMBERS' => 'Ryhmän jäsenet',
        'VIDEOS' => 'Videot',
        'BLOG' => 'Blogi',
        'ACCOUNT' => 'Käyttäjätili',
        'WE_ARE_SORRY_WE_ARE_HAVING' => 'Valitettavasti tällä sivulla on ongelma.',
        'FOLLOW_LINK_TO_HOMEPAGE' => 'Mene <a %s>tästä</a> pääsivulle.',
        'REQUEST_AN_INVITATION' => 'Pyydä kutsua',
        'NAME' => 'Nimi',
        'EMAIL_ADDRESS' => 'Sähköpostiosoite',
        'MESSAGE_OPTIONAL' => 'Viesti (ei pakollinen)',
        'SORRY_HOWEVER_ITS_EASY' => '<strong>Pahoittelemme! </strong>  Voit kuitenkin helposti perustaa oman yhteisön.',
        'GET_YOUR_OWN_BAZEL' => 'Perusta oma yhteisö!',
        'SITE_IS_NOT_READY' => 'Tämä yhteisö ei ole vielä valmis!',
        'BAZEL_IS_BEING_SET_UP' => 'Tämän yhteisön perustaminen on kesken!',
        'SIGN_IN' => 'Kirjaudu',
        'FORGOT_YOUR_PASSWORD' => 'Unohditko salasanasi?',
        'FORGOT_YOUR_PASSWORD_TITLE' => 'Unohditko salasanasi?',
        'ENTER_EMAIL_AND_CLICK_RESET_PASSWORD' => 'Anna sähköpostiosoitteesi ja napsauta \'Vaihda salasanaa\'.  Saat sähköpostin, jossa olevan linkin kautta voit vaihtaa salasanasi.',
        'RESET_PASSWORD' => 'Vaihda salasanaa',
        'EXPLORE' => 'Tutki',
        'SIGN_UP' => 'Kirjaudu',
        'CONFIRM_PASSWORD' => 'Vahvista salasana',
        'VERIFICATION' => 'Kerro olevasi <br />henkilö',
        'YOUR_PHOTO' => 'Kuvasi',
        'SUMMARY' => 'Yhteenveto',
        'YOUR_SITE_IS_READY' => 'Yhteisösi on valmis otettavaksi käyttöön!   Ohittamissasi kohdissa käytetään oletusasetuksia.  Palaa tekemään muutoksia tai napsauta \\’Ota käyttöön! \', jos haluat ottaa verkostosi käyttöön.',
        'WHEN_YOU_ARE_FINISHED' => 'Kun olet valmis, napsauta \'Näytä asettelu\', jotta pääset tarkastelemaan luomustasi!',
        'COMPLETE' => 'valmis',
        'INCOMPLETE' => 'kesken',
        'VIEW_LAYOUT' => 'Tarkastele asettelua',
        'CLEAR_CONTENTS' => 'Poista sisältö',
        'ADD_MODULE' => 'Lisää moduuli…',
        'ADD_COLUMNS' => 'Lisää palstoja…',
        'PUBLIC_ANYBODY_CAN_JOIN' => '<strong>Julkinen</strong> - Kuka tahansa voi liittyä',
        'PRIVATE_ONLY_INVITED' => '<strong>Yksityinen</strong>  Vain kutsutut henkilöt voivat tarkastella ja liittyä',
        'INVITATIONS' => 'Kutsut',
        'MEMBERS_CAN_INVITE' => 'Jäsenet voivat kutsua muita liittymään.',
        'QUESTION_TITLE' => 'Kysymyksen otsikko',
        'ANSWER_TYPE' => 'Vastaustyyppi',
        'REQUIRED' => 'Vaaditaan',
        'PRIVATE' => 'Yksityinen',
        'CHOICES' => 'Valinnat',
        'SEPARATE_EACH_CHOICE' => 'Erota kaikki valinnat pilkulla',
        'CAN_PICK_MORE' => 'Voidaan valita enemmän kuin yksi',
        'ADD_ANOTHER_QUESTION' => 'Lisää kysymys',
        'WHAT_INFORMATION' => 'Mihin kysymyksiin haluaisit jäsentesi vastaavan, kun he liittyvät verkostoosi?  Voit tilata kysymykset uudestaan.  Napsauta kysymystä ja vedä se haluamaasi paikkaan.',
        'IF_YOU_SELECT_REQUIRED_MEMBERS_WILL' => 'Jos valitset “Vaaditaan”, jäsenten täytyy vastata kysymykseen voidakseen liittyä.  Jos valitset “Yksityinen”, vastaus näkyy vain sinulle ja muille ylläpitäjille',
        'WE_COULD_NOT_FIND_ANYTHING' => 'Haulla "%s" ei löytynyt mitään.  Etsi jotain muuta.',
        'GET_CUSTOM_URL' => 'Hanki omanlaisesi URL, lisää levytilaa ja kaistanleveyttä tai pyöritä omia ilmoituksia.',
        'VIEW_STATISTICS' => 'Näytä tilastot',
        'ADD_TRACKING_CODE' => '<a %s>Lisää oma seurantakoodi</a>.',
        'TRACKING_CODE' => 'Seurantakoodi',
        'ANY_JAVASCRIPT_CODE' => 'Tähän liittämäsi JavaScript-koodi lisätään verkostosi jokaisen sivun alalaitaan.  Voit käyttää tätä ulkoisille sivuston seurantajärjestelmille, kuten Google Analytics.',
        'ANALYTICS_LEARN_MORE' => 'Jos haluat saada lisätietoja Google Analytics järjestelmästä tai perustaa oman käyttäjätilin, <a %s>napsauta tästä</a>.',
        'RESOURCES' => 'Resurssit',
        'LINKS' => 'Linkit',
        'PAGE' => 'Sivu',
        'BACKGROUND' => 'Tausta',
        'TEXT' => 'Teksti',
        'HEADING_TEXT' => 'Otsikon teksti',
        'FONT' => 'Kirjasin',
        'AABBCC' => 'AaBbCc',
        'COLOR' => 'Väri',
        'LINK_COLOR' => 'Linkin väri',
        'BODY_TEXT' => 'Leipäteksti',
        'MIDDLE' => 'Keskellä',
        'FEATURE_BOXES' => 'Ominaisuuslaatikot',
        'TITLEBAR_TEXT_COLOR' => 'Otsikkopalkin tekstin väri',
        'TITLEBAR_BACKGROUND' => 'Otsikkopalkin tausta',
        'UPLOADING_CONTENT' => 'Ladataan sisältöä…',
        'WHEN_UPLOADING_IS_COMPLETE' => 'Kun lataus on valmis, voit tarkistaa verkoston.',
        'FINISH' => 'Valmis',
        'FLICKR_IMPORT_SETUP' => 'Flickr-palvelun tuonnin asennus',
        'FLICKR_API_KEY' => 'Avaimesi',
        'FLICKR_SECRET' => 'Salaisuutesi',
        'FLICKR_KEY_ERROR' => 'Antamassasi Flickr-avaimessa tai salaisuudessa oli jokin ongelma.   Tarkistaisitko ne ja yritä antaa ne uudestaan.',
        'FLICKR_INTRO' => 'Haluatko antaa jäsenillesi mahdollisuuden tuoda kuviaan Flickr-palvelusta?  Olet oikeassa paikassa.  Jos sinulla on jo Flickr–palvelun API-avain ja salaisuus, voit <a %s>siirtyä eteenpäin</a>.  Mitä se tarkoittaa?  Kun seuraat alla olevia ohjeita, pääset käyttämään palvelua muutaman minuutin päästä.',
        'FLICKR_GET_ACCOUNT' => 'Jollei sinulla ole vielä Flickr-käyttäjätiliä, hanki tili <a %s>täältä</a>.',
        'FLICKR_STEP1_TITLE' => 'Vaihe 1: Hanki Flickr API-avain',
        'FLICKR_STEP1_APPLY_SCREEN' => 'Flickr-palvelun Hae API-avainta näyttö.',
        'FLICKR_STEP1_API_SCREEN' => 'Flickr-palvelun API-avainnäyttö',
        'FLICKR_STEP1_INTRO' => 'Kirjaudu Flickr-palveluun ja <a %s>hae uutta API-avainta</a> (avautuu uuteen ikkunaan).',
        'FLICKR_STEP1_A' => 'Täytä <strong>Nimi</strong> ja <strong>Sähköpostiosoite</strong>.',
        'FLICKR_STEP1_B' => 'Kohdassa <strong>Tämän avaimen omistaa&hellip; </strong> valitse vaihtoehto <em>ei-kaupallinen käyttö</em>.',
        'FLICKR_STEP1_C' => 'Kuvaile yhteisöäsi laatikossa<strong>Kuvaile sovellusta, jonka aiot rakentaa</strong>.',
        'FLICKR_STEP1_D' => 'Valitse molemmat hyväksyntäkohdat.',
        'FLICKR_STEP1_APPLY' => 'Kun olet valmis, napsauta <strong>Käytä</strong>-nappia.',
        'FLICKR_STEP1_E' => 'Tulet näyttöön, jossa näkyy uusi API-avaimesi.  Napsauta <strong>Napsauta tästä</strong> -linkkiä, jotta pääset määrittelemään käyttäjätunnistuksen tälle avaimelle.',
        'FLICKR_STEP2_TITLE' => 'Vaihe 2: Määrittele avaimesi',
        'FLICKR_STEP2_SETUP_SCREEN' => 'API-avaimen tunnistuksen määrittely näyttö Flickr-palvelussa',
        'FLICKR_STEP2_F' => 'Liitä seuraava internet-osoite <strong>Callback URL</strong> kenttään:',
        'FLICKR_STEP2_SAVE_CHANGES' => 'Kun olet valmis, napsauta <strong>Tallenna muutokset</strong> nappia.',
        'FLICKR_STEP3_TITLE' => 'Vaihe 3: Anna tietosi',
        'FLICKR_STEP3_KEYS_SCREEN' => 'Flickr-palvelun API-avaimen tietojen näyttö',
        'FLICKR_STEP3_CONGRATULATIONS' => 'Onnittelut!  Pystyt nyt käyttämään Flickr-palvelua.',
        'FLICKR_STEP3_COMPLETE' => 'Jotta saat viimeisteltyä %s:n määrittelyn, kopioi ja liitä avaimesi ja salaisuutesi alla oleviin kenttiin:',
        'COMPLETE_SETUP' => 'Viimeistele määrittely',
        'SETUP_YOUR_SITE_TO' => 'Määrittele yhteisösi, jotta pääset tuomaan kuvia Flickr-palvelusta.',
        'FLICKR_IMPORTING' => 'Tuonti Flickr-palvelusta',
        'YOU_NEED_TO_SET_UP_FLICKR' => 'Yhteisösi täytyy määritellä, jotta ihmiset voivat tuoda kuviaan Flickr-palvelusta.  Määrittely kestää vain muutaman minuutin, joten <a %s>tee se heti. </a>',
        'DONT_SHOW_THIS_AGAIN_FLICKR' => 'Älä näytä tätä uudestaan.',
        'YOUVE_SIGNED_OUT_OF_X' => 'Olet kirjautunut ulos täältä: %s.  Tervetuloa uudelleen!',
        'CREATED_THIS_SOCIAL_NETWORK' => 'perusti tämän yhteisön täällä: <a href=\'http://www.ning.com\'>Ning</a>.',
        'CREATE_YOUR_OWN' => 'Perusta oma Ning-yhteisö ilmaiseksi!',
        'DRAG_HERE_TO_REMOVE_FEATURE' => 'Vedä tänne poistettava ominaisuus',
        'LAYOUT' => 'Asettelu',
        'DRAG' => 'Vedä',
        'HERE' => 'Tänne',
        'YOU' => 'Sinä',
        'ADS' => 'Ilmoitukset',
        'MEMBERS' => 'Jäsenet',
        'HELLO_USERNAME' => 'Hei, käyttäjänimi',
        'CREATED_BY' => 'Perustanut',
        'SAVE_FEATURES' => 'Tallenna ominaisuudet',
        'FORUM' => 'Foorumi',
        'CATEGORIES' => 'Luokat',
        'FORUM_CATEGORIES' => 'Foorumin luokat',
        'A_THREADED_DISCUSSION_FORUM' => 'Ketjumuotoinen keskustelufoorumi',
        'ALLOW_MEMBERS_TO_CREATE_GROUPS' => 'Salli jäsenille omien ryhmien perustaminen yhteisössäsi',
        'FEATURE_POSTS_FROM_YOUR_BLOG' => 'Suosittele artikkeleita omasta blogistasi tai muiden jäsenten blogeista',
        'TEXT_BOX' => 'Muokkausruutu',
        'PUT_ANY_TEXT_WIDGET_OR_HTML' => 'Laita pääsivulle tekstiä, vimpain tai HTML-kieltä',
        'A_LIST_OF_MEMBERS' => 'Yhteisösi jäsenluettelo',
        'ALLOW_USERS_PHOTOS' => 'Salli kuvien lataaminen sivuille ja niiden jakaminen',
        'ADD_FEEDS_FROM_ACROSS_THE_WEB' => 'Lisää syötteitä internetistä',
        'INFORMATION_ABOUT_THE_USER' => 'Tällä hetkellä kirjautuneen henkilön tiedot',
        'ALLOW_USERS_VIDEOS' => 'Salli videoiden lisääminen ja jakaminen',
        'SHOW_NETWORK_DESCRIPTION' => 'Näytä verkostosi kuvaus',
        'PROMOTE_NETWORK_WITH_BADGES' => 'Markkinoi verkostoasi internetissä omanlaisillasi merkeillä ja vimpaimilla',
        'MONETIZE_WITH_ADS' => 'Tee verkostostasi valuuttaa ilmoituksilla',
        'LET_MEMBERS_KNOW_WHO_CREATED_NETWORK' => 'Kerro jäsenillesi, kuka on perustanut tämän verkoston',
        'FOLLOW_LATEST_ACTIVITY' => 'Seuraa jäsenten uusimpia tapahtumia verkostossasi',
        'FAQ_FOR_NETWORK_CREATORS' => 'Usein kysyttyä - verkoston perustajille',
        'ANSWERS_TO_FAQS' => 'Vastauksia yleisiin kysymyksiin yhteisön mukauttamisesta',
        'MEET_OTHER_LIKEMINDED' => 'Tapaa samanhenkisiä verkoston perustajia, vaihda ajatuksia ja hyödy Ning-tiimin tuesta.',
        'CUSTOMIZE_THE_APPEARANCE_NETWORK' => 'Mukauta yhteisösi ulkoasua lisäämällä omia CSS-tyyliohjeita vasemmalla olevaan kenttään.  (<a href="%s">Mikä on CSS? </a>)',
        'CUSTOMIZE_THE_APPEARANCE_PAGE' => 'Mukauta sivusi ulkoasua lisäämällä omia CSS-tyyliohjeita vasemmalla olevaan kenttään.  (<a href="%s">Mikä on CSS? </a>)',
        'CSS_ON_YOUR_SOCIAL_NETWORK' => 'Yhteisösi CSS-tyyliohjeet',
        'CSS_ON_YOUR_PAGE' => 'Sivusi CSS-tyyliohjeet',
        'ADDING_YOUR_OWN_CSS_NETWORK' => 'Omia CSS-tyyliohjeita lisäämällä voit hallita verkostosi kirjasimia, värejä, rivivälejä ja yleistä tyyliä.',
        'ADDING_YOUR_OWN_CSS_PAGE' => 'Omia CSS-tyyliohjeita lisäämällä voit hallita sivusi kirjasimia, värejä, rivivälejä ja yleistä tyyliä.',
        'CSS_STYLES_WILL_OVERRIDE' => 'Tähän lisäämäsi CSS-tyylit ohittavat kaikki mahdollisesti aiemmin valitsemasi CSS-tyylit.',
        'NEED_HELP_FIGURING_OUT_CSS' => 'Tarvitsetko apua jonkin verkostossasi olevan CSS-luokan nimen selvittämiseen?  Suosittelemme ilmaisen <a href="%s">Firebug</a>-lisäosan "Inspect"-ominaisuutta (Firefox-selaimessa).',
        'WANT_TO_LEARN_MORE' => 'Haluatko lisätietoja?  Katso <a href="%s">Edistynyt mukauttaminen</a> osiota.',
        'APPLY_XS_THEME' => 'Käytä %s:n teemaa',
        'X_ALREADY_REGISTERED_Y_TO_RESET' => 'Sähköpostiosoitteelle %s on jo rekisteröity Ning-tunnus.  Kirjaudu sisään Ning-tunnuksellasi tai sähköpostiosoitteellasi.  Jos olet unohtanut salasanasi, <a href="%s">napsauta tästä vaihtaaksesi salasanan</a>.',
        'INVITED' => 'Kutsuttu',
        'REQUESTED_INVITE' => 'Pyytänyt kutsua',
        'BAN_FROM_NETWORK' => 'Aseta porttikielto verkostoon',
        'REMOVE_BAN' => 'Kumoa porttikielto',
        'CANCEL_INVITATION' => 'Peru kutsu',
        'IGNORE' => 'Ohita',
        'PROMOTE_TO_ADMINISTRATOR' => 'Ylennä ylläpitäjäksi',
        'DEMOTE_FROM_ADMINISTRATOR' => 'Siirrä ylläpitäjästä alemmalle tasolle',
        'STATUS' => 'Tila',
        'DATE_JOINED' => 'Liittymispäivämäärä',
        'DATE_INVITED' => 'Kutsumispäivämäärä',
        'DATE_REQUESTED' => 'Pyyntöpäivämäärä',
        'DATE_APPLIED' => 'Käyttöönottopäivämäärä',
        'NETWORK_CREATOR' => 'Verkoston perustaja',
        'NETWORK_ADMINISTRATOR' => 'Ylläpitäjä',
        'ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Ylläpitäjillä on samat hallintamahdollisuudet kuin perustajalla.',
        'DOWNLOAD_ALL_MEMBER_DATA' => 'Vie kaikki jäsentiedot (. CSV)',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Jäsentietosi on tuotu.  Klikkaa <a %s>tätä linkkiä</a> tallentaaksesi sen työpöydälle.',
        'CLICK_GO_TO_START_EXPORT' => 'Napsauta Aloita aloittaaksesi viennin.   Jos jäseniä on paljon, prosessi saattaa kestää muutaman minuutin.',
        'MEMBER' => 'Jäsen',
        'INVITED_BY_X' => 'Kutsunut %s',
        'DONE' => 'Valmis',
        'YOU_HAVE_BEEN_BANNED_FROM_APPNAME' => 'Olet saanut porttikiellon tänne: %s',
        'MESSAGE_TO_ADMINISTRATOR' => 'Viesti ylläpitäjälle',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS_IF_YOU_THINK' => 'Pahoittelemme, %s, olet saanut porttikiellon tänne: %s.  Jos uskot saaneesi porttikiellon vahingossa, voit ottaa yhteyttä ylläpitäjään.',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS' => 'Pahoittelemme, %s, olet saanut porttikiellon tänne: %s.',
        'SORRY_USERNAME' => 'Pahoittelut, %s',
        'PENDING' => 'Odottaa',
        'ACCEPT' => 'Hyväksy',
        'PENDING_APPROVAL' => 'Odottaa hyväksyntää',
        'ACCEPT_MEMBERSHIP' => 'Hyväksy jäsenyys',
        'DECLINE_MEMBERSHIP' => 'Hylkää jäsenyys',
        'NO_PAGE_YET' => 'Ei sivua',
        'YOUR_MEMBERSHIP_TO_X_IS_PENDING_APPROVAL' => '%s:n jäsenyytesi odottaa ylläpitäjien hyväksyntää.',
        'MEMBERSHIP_PENDING_APPROVAL' => 'Jäsenyys odottaa hyväksymistä',
        'YOUR_PROFILE_IS_PENDING_APPROVAL' => 'Profiilisi odottaa hyväksyntää',
        'YOUR_PROFILE_DETAILS_MUST_BE_APPROVED_ON_X' => 'Ylläpitäjän täytyy hyväksyä profiilitietosi ennen kuin pääset %s:n jäseneksi.  Saat tiedon sähköpostilla, kun profiilisi on hyväksytty.',
        'CONTINUE_ARROW' => 'Continue →',
        'LARR_BACK_TO_PENDING_MEMBERS' => '← Takaisin odottaviin jäseniin',
        'X_IS_AWAITING_APPROVAL_TO_BECOME_MEMBER_OF_Y' => '%s odottaa hyväksyntää %s:n jäseneksi.',
        'VIEW_PAGE' => 'Näytä sivu',
        'MESSAGE' => 'Viesti',
        'SEND_MESSAGE' => 'Lähetä viesti',
        'MANAGE_FORUM_CATEGORIES' => 'Hallinnoi foorumin luokkia',
        'START_DISCUSSIONS' => 'Aloita keskusteluja',
        'WELCOME_TO_YOUR_NEW_SOCIAL_NETWORK' => 'Tervetuloa uuteen yhteisöösi',
        'NOW_ALL_YOU_NEED_TO_DO_IS_INVITE_YOUR_FRIENDS' => 'Nyt voit <a %s>kutsua ystäväsi mukaan</a>!',
        'CONTRIBUTE' => 'Osallistu.',
        'CUSTOMIZE_APPEARANCE_BADGES' => '<strong>Mukauta. </strong> Muuta <a %1$s>verkoston ulkoasua</a> ja suunnittele <a %2$s>merkkejä ja vimpaimia</a>.',
        'CONTROL_MANAGE_PAGE' => '<strong>Hallitse.</strong>  <a %s>Hallinnoi</a>-sivulla on runsaasti erilaisia kokoonpanovaihtoehtoja.',
        'CREATE_GROUPS' => 'Perusta ryhmiä',
        'INVITE_MORE_PEOPLE' => 'Kutsu lisää ihmisiä',
        'VIEW_THREAD' => 'Näytä ketju',
        'COMMENT_THREAD' => 'Kommentoi ketjua',
        'COMMENT_BACK' => 'Vastaa kommenttiin',
        'HELLO_YOU_NEED_TO_ENABLE_JAVASCRIPT' => 'Hei, aseta JavaScript-tuki päälle jotta pääset käyttämään tätä verkostoa.',
        'PLEASE_CHECK_YOUR_BROWSER_SETTINGS' => 'Tarkista selaimesi asetukset tai ota yhteyttä järjestelmänvalvojaan.',
        'MANAGE_MEMBERS_ADMINS_INVITED' => 'Hallinnoi jäseniä, ylläpitäjiä, kutsuttuja ja porttikiellon saaneita.',
        'MANAGE_MEMBERS' => 'Hallinnoi jäseniä',
        'MANAGE_INVITED_PEOPLE' => 'Hallinnoi kutsuttuja',
        'NETWORK_SETTINGS' => 'Verkoston asetukset',
        'PROMOTE_YOUR_NETWORK' => 'Markkinoi verkostoasi',
        'NING_RESOURCES' => 'Ningin resurssit',
        'ADD_PREMIUM_SERVICES' => 'Lisää premium-palvelut',
        'REQUEST_SOURCE_CODE' => 'Pyydä pääsyä lähdekoodiin',
        'REQUEST_A_COPY_OF_THE_SOURCE_CODE' => 'Kehittäjät: pyydä pääsyä verkoston lähdekoodiin.',
        'JOIN_NETWORK_CREATORS' => 'Liity verkoston perustajiin',
        'SEND_MESSAGE_TO_ALL_THIS' => 'Lähetä viesti kaikille tämän verkoston jäsenille.',
        'CREATE_ANOTHER_NETWORK' => 'Perusta uusi verkosto',
        'HAVE_ANOTHER_GREAT_IDEA' => 'Onko sinulla hyvä idea verkostoksi?',
        'ALLOW_FACEBOOK_USERS_TO' => 'Salli Facebookin käyttäjien laittaa verkostosi vimpaimia profiilisivuilleen.',
        'BADGES_AND_WIDGETS' => 'Merkit ja vimpaimet',
        'CUSTOMIZE_WIDGETS_AND_BADGES' => 'Mukauta verkostosi vimpainten ja merkkien ulkonäköä.',
        'GET_BADGES' => 'Hanki merkkejä',
        'CUSTOM_TEXT' => 'Mukautettu teksti',
        'IM_A_MEMBER_OF' => 'Olen jäsen:',
        'DONT_DISPLAY_ANY_BRANDING' => 'Älä näytä mukautuksia',
        'WATERMARK_OR_LOGO_IMAGE' => 'Vesileiman tai logon kuva:',
        'NETWORK_BRANDING_BADGES' => 'Verkoston mukautus: merkit',
        'NETWORK_BRANDING_WIDGETS' => 'Verkoston mukautus: vimpaimet',
        'LOGO_IMAGE' => 'Logon kuva',
        'SMALL_NETWORK_BADGE' => 'Pieni verkoston merkki',
        'LARGE_NETWORK_BADGE' => 'Iso verkoston merkki',
        'REFRESH' => 'Päivitä',
        'HTML_EMBED_CODE' => 'HTML upotettu koodi:',
        'CUSTOMIZE' => 'Mukauta',
        'SHARE_TITLE' => 'Jaa \'%s\'',
        'SHARE_TYPE' => 'Jaa %s',
        'YOUR_MESSAGE_SENT' => 'Viestin lähetys onnistui.',
        'YOUR_MESSAGES_SENT' => 'Viestien lähetys onnistui.',
        'YOU_CAN_SHARE_TYPE_TWO_WAYS' => 'Voit jakaa tämän %s kahdella tavalla&#8230;',
        'CHECK_OUT_THIS_TYPE_TITLE' => 'Katso tätä %s: "%s"',
        'CHECK_OUT_THIS_TYPE' => 'Katso tätä %s',
        'PHOTO_ALBUM' => 'kuva-albumi',
        'CUSTOMIZE_YOUR_BADGES_AND_WIDGETS' => 'Mukauta merkkejä ja vimpaimia omilla väri- ja kuvavalinnoilla.  Tekemiesi muutosten näkyminen muilla sivustoilla saattaa kestää jopa 4 tuntia.',
        'BACKGROUND_IMAGE_AND_COLOR' => 'Taustan kuva ja väri',
        'USE_THIS_FORM_TO_REPORT_ISSUE_TO_NC' => 'Käytä tätä lomaketta, jos haluat tehdä ilmoituksen <a %s>%s</a>:lle, joka on <a %s>%s</a>:n perustaja.',
        'SORRY_NCS_CANNOT_CHANGE_EMAIL' => 'Verkoston luojat eivät voi muuttaa sähköpostiosoitettaan sellaisten verkostojen kautta joita eivät omista.',
        'SORRY_NCS_CANNOT_CHANGE_PASSWORD' => 'Verkoston luojat eivät voi muuttaa salasanaansa sellaisten verkostojen kautta joita eivät omista.',
        'GO' => 'Siirry',
        'LARGE_THUMBNAILS' => 'Isot esikatselukuvat',
        'SMALL_THUMBNAILS' => 'Pienet esikatselukuvat',
        'RECENTLY_JOINED' => 'Uusimmat',
        'MOST_POPULAR_MEMBERS' => 'Suosituin',
        'NO_MEMBERS_TO_DISPLAY' => 'Tällä hetkellä mitään jäseniäsi ei näytetä.',
        'BOX_WILL_NOT_SHOW_MEMBERS' => 'Tämä laatikko ei näy muille, jollet valitse vähintään yhtä riviä.',
        'DETAIL_VIEW' => 'Yksityiskohtainen näkymä',
        'TITLES_ONLY' => 'Vain nimet',
        'RECENTLY_ADDED_POSTS' => 'Viimeksi lisätyt',
        'POPULAR_POSTS' => 'Eniten kommentteja',
        'PROMOTED_POSTS' => 'Ominaisuudet',
        'BOX_WILL_NOT_SHOW_BLOG_POST' => 'Tämä laatikko ei näy muille, jollet valitse vähintään yhtä artikkelia.',
        'KEEP_WINDOW_OPEN_UPLOAD' => 'Pidä selaimen ikkuna auki niin kauan kuin lataaminen jatkuu.',
        'CANCEL_UPLOAD' => 'Peruuta lataaminen',
        'YOU_DO_NOT_HAVE_POSTS' => 'Et ole kirjoittanut vielä yhtään artikkelia.',
        'YOU_DO_NOT_HAVE_COMMENTS' => 'Ei hyväksyttäviä kommentteja.',
        'REQUIRED_FIELD' => '(Pakollinen kenttä)',
        'BLOG_POST_BY_X' => 'Blogiartikkelin kirjoittanut %s',
        'HELLO' => 'Hei,',
        'ADDED_BY_X' => 'Lisännyt %s',
        'CLICK_TO_ADD_A_TITLE' => 'Napsauta ja lisää otsikko',
        'DELETE_BLOG_POST' => 'Poista artikkeli',
        'DELETE_THIS_BLOG_POST_Q' => 'Poistetaanko tämä blogiartikkeli?',
        'ARE_YOU_SURE_DELETE_THIS_BLOG_POST' => 'Haluatko varmasti poistaa tämän blogiartikkelin?  Käsittely voi kestää muutaman minuutin.',
        'SPINNER' => 'Spinner',
        'PLEASE_ENTER_SOMETHING_FOR_X' => 'Kirjoita jotain %s:lle',
        'PLEASE_SELECT_OPTION_FOR_X' => 'Valitse vaihtoehto %s:lle',
        'PLEASE_PROVIDE_VALID_DATE_FOR_X' => 'Anna oikea päivämäärä %s:lle',
        'PLEASE_PROVIDE_DATE_FOR_X' => 'Anna päivämäärä %s:lle',
        'XS_BLOG_POSTS_FOR_M_Y' => '%s:n blogiartikkelit: %s %s',
        'FEATURED_BLOG_POSTS_FOR_M_Y' => 'Suositellut blogiartikkelit: %s %s',
        'BLOG_POSTS_FOR_M_Y' => 'Blogiartikkelit: %s %s',
        'FEATURED_BLOG_POSTS' => 'Suositellut blogiartikkelit',
        'EVERYONES_POSTS' => 'Kaikkien blogiartikkelit',
        'PUBLISHED_N_OF_N' => 'Julkaistu %d. %d.',
        'DOWNLOAD_X' => 'Lataa %s',
        'UPLOAD_DID_NOT_WORK' => 'Valitettavasti lataus ei onnistunut',
        'F_J_Y' => 'F j, Y',
        'M_J_Y' => 'M. j, Y',
        'XS_POSTS' => '%s:n artikkelit',
        'USERNAMES_COMMENTS' => '%s:n kommentit',
        'ADD_COMMENT' => 'Lisää kommentti',
        'XS_PAGE' => '%s:n sivu',
        'XS_BLOG' => '%s:n blogi',
        'XS_FRIENDS' => '%s:n ystävät',
        'VIEW_XS_ELLIPSIS' => 'Näytä %s:n…',
        'DRAFT_BRACKETS' => '[ Luonnos ]',
        'FEATURED' => 'Ominaisuudet',
        'MY_POSTS' => 'Omat artikkelini',
        'MY_POSTS_ONLY' => 'Vain omat artikkelini',
        'OWNER_POSTS_ONLY' => 'Vain perustajan artikkelit',
        'JANUARY' => 'tammikuu',
        'FEBRUARY' => 'helmikuu',
        'MARCH' => 'maaliskuu',
        'APRIL' => 'huhtikuu',
        'MAY' => 'toukokuu',
        'JUNE' => 'kesäkuu',
        'JULY' => 'heinäkuu',
        'AUGUST' => 'elokuu',
        'SEPTEMBER' => 'syyskuu',
        'OCTOBER' => 'lokakuu',
        'NOVEMBER' => 'marraskuu',
        'DECEMBER' => 'joulukuu',
        'MY_COMMENTS' => 'Omat kommenttini',
        'AM' => 'ap',
        'PM' => 'ip',
        'MY_PAGE' => 'Oma sivuni',
        'MY_PAGE_TAB_TEXT' => 'Oma sivuni',
        'BLOG_POSTS' => 'Blogiartikkelit',
        'MY_BLOG' => 'Oma blogini',
        'MONTH' => 'Kuukausi',
        'DAY' => 'Päivä',
        'PICK_VALID_DEFAULT_VISIBILITY' => 'Valitse oikea vaihtoehto oletusnäkyvyydeksi',
        'PICK_VALID_WHO_CAN_COMMENT' => 'Valitse oikea vaihtoehto, kuka voi kommentoida',
        'PICK_VALID_BLOG_COMMENT_MODERATION' => 'Valitse oikea vaihtoehto blogin kommenttien moderoinnille',
        'PICK_VALID_ACTIVITY_NOTIFICATION' => 'Valitse oikea vaihtoehto tapahtumailmoituksille',
        'PICK_VALID_MODERATION_NOTIFICATION' => 'Valitse oikea vaihtoehto moderointi-ilmoituksille',
        'PICK_VALID_APPROVAL_NOTIFICATION' => 'Valitse oikea vaihtoehto hyväksyntäilmoituksille',
        'PICK_VALID_INVITEE_NOTIFICATION' => 'Valitse oikea vaihtoehto ilmoituksille kutsutun henkilön liittymisestä',
        'PICK_VALID_NEVER_NOTIFICATION' => 'Valitse oikea vaihtoehto sille, ettet halua ilmoituksia',
        'PICK_VALID_FRIEND_REQUEST_NOTIFICATION' => 'Valitse oikea vaihtoehto ystäväpyyntöilmoituksille',
        'PICK_VALID_NEW_MESSAGE_NOTIFICATION' => 'Valitse oikea vaihtoehto uusien viestien ilmoituksille',
        'APPROVE_COMMENT' => 'Hyväksy kommentti',
        'MANAGE_BLOG' => 'Hallinnoi blogia',
        'COMMENTS_POSTED_ON_BLOG' => 'Omaan blogiini tulleet kommentit',
        'COMMENT' => 'Kommentti',
        'COMMENTER' => 'Kommentoija',
        'POST' => 'ARTIKKELI',
        'M_J_Y_G_IA' => 'M j, Y, g:ia',
        'POST_HAS_BEEN_DELETED' => 'Artikkeli on poistettu',
        'COMMENTS_ARE_CLOSED' => 'Tämän blogiartikkelin kommentit on suljettu',
        'NO_COMMENTS' => 'Ei kommentteja',
        'FLAG' => 'Lippu',
        'POST_TITLE' => 'Artikkelin otsikko',
        'DRAFT_PARENTHESES' => '(Luonnos)',
        'SCHEDULED_TO_PUBLISH_ON' => 'Suunniteltu julkaisuaika: %s',
        'EDIT_2' => 'muokkaa',
        'NONE' => 'Ei mitään',
        'N_NEW' => '%s uusi',
        'NO_POSTS' => 'Ei artikkeleita',
        'ADD_NEW_BLOG_POST' => 'Lisää uusi blogiartikkeli',
        'HAPPY' => 'Iloinen',
        'SAD' => 'Surullinen',
        'COOL' => 'Cool',
        'EVIL' => 'Paha',
        'MAD' => 'Vihainen',
        'ENVIOUS' => 'Kateellinen',
        'ENTRY' => 'Merkintä',
        'WHAT_DATE_FOR_YOUR_POST' => 'Minkä päivämäärän haluat artikkelille?',
        'NOW' => 'Nyt',
        'CHOOSE_DATE_AND_TIME' => 'Valitse päivämäärä ja aika (jos valitset tulevan päivämäärän, artikkelisi julkaistaan silloin)',
        'PRIVACY_AND_COMMENTS' => 'Yksityisyys ja kommentit',
        'WHO_CAN_VIEW_POST' => 'Kuka voi tarkastella tätä artikkelia?',
        'EVERYONE' => 'Kaikki',
        'ALLOW_COMMENTS' => 'Sallitaanko kommentit tähän artikkeliin?',
        'YES' => 'Kyllä',
        'NO' => 'Ei',
        'COMMENT_MODERATION' => 'Kommenttien moderointi',
        'YOU_ARE_MODERATING_BLOG_COMMENTS' => 'Moderoit nyt blogikommentteja.',
        'YOU_ARE_NOT_MODERATING_BLOG_COMMENTS' => 'Et moderoi nyt blogikommentteja.',
        'SAVE_AS_DRAFT' => 'Tallenna luonnoksena',
        'PREVIEW' => 'Esikatselu',
        'PUBLISH_POST' => 'Julkaise artikkeli',
        'THIS_IS_PREVIEW_OF_BLOG_POST' => 'Tämä esikatselu näyttää, millainen blogiartikkelisi on julkaistuna.  Napsauta Palaa, jos haluat muokata artikkelia tai Julkaise, jos artikkeli on valmis!',
        'BACK' => 'Palaa',
        'PUBLISH' => 'Julkaise!',
        'BLOG_POST' => 'Blogiartikkeli',
        'PROFILE' => 'Profiili',
        'THIS_IS_UNPUBLISHED_DRAFT' => 'Tämä on julkaisematon luonnos',
        'WILL_BE_PUBLISHED_ON_X' => 'Julkaistaan %s <small>%s</small>',
        'POSTED_ON_X' => 'Kirjoitettu <strong>%s</strong> <small>%s</small>',
        'POSTED_ON_X_BY' => 'Kirjoittanut <strong>%s</strong> <small>%s</small>:',
        'ABOUT_THIS_POST' => 'Tietoa tästä artikkelista',
        'ABOUT_YOUR_POST' => 'Tietoa artikkelistasi',
        'ADDED_BY' => 'Lisännyt:',
        'JUST_FRIENDS' => 'Vain ystäviä',
        'RECENT_POSTS' => 'Viimeaikaiset artikkelit',
        'THERE_ARE_NO_RECENT_POSTS' => 'Viimeaikaisia artikkeleita ei ole.',
        'YOUR_COMMENT_HAS_BEEN_ADDED_BUT' => 'Kommenttisi on lisätty, mutta se täytyy hyväksyä ennen kuin se näytetään kaikille.',
        'AT_TIME_ON_DATE_USERNAME_SAID' => '%s %s, %s sanoi…',
        'X_DOES_NOT_HAVE_ANY_FRIENDS' => '%s:lla ei ole vielä ystäviä tässä yhteisössä.',
        'YOU_DO_NOT_HAVE_ANY_FRIENDS' => 'Sinulla ei ole vielä ystäviä tässä yhteisössä.',
        'EDIT_PAGE_APPEARANCE' => 'Muokkaa sivun ulkoasua',
        'VIEW_PAGE_AS_OTHERS' => 'Näytä sivu niin kuin se näkyy muille',
        'ADD_BLOG_POST' => 'Lisää blogiartikkeli',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED_2' => 'Jätä tämä selainikkuna auki siksi aikaa kun kaikki %s:n sisältö poistetaan.  Käsittely voi kestää muutaman minuutin.',
        'BAN_MEMBER_FROM_NETWORK' => 'Anna jäsenelle porttikielto verkostoon',
        'BAN_USERNAME' => 'Annetaanko %s:lle porttikielto?',
        'BLOCK' => 'estä',
        'CREATE_NEW_BLOG_POST' => 'Tee uusi blogiartikkeli!',
        'EDIT_POST' => 'Muokkaa artikkelia',
        'EDIT_POST_COLON' => 'Muokkaa artikkelia:',
        'CONTINUE_READING' => 'Jatka lukemista…',
        'POSTED_BY_ME_LINK_ON_X_AT_X' => 'Posted by <a %s>me</a> on %s at %s —',
        'POSTED_BY_X_ON_X_AT_X' => 'Posted by %s on %s at %s —',
        'POSTED_BY_ME_ON_X_AT_X' => 'Posted by me on %s at %s  —',
        'ADD' => 'Lisää',
        'SUBSCRIBE' => 'Tilaa',
        'VIEW_ARCHIVES' => 'Näytä arkistot',
        'YOUR_SETTINGS_HAVE_BEEN_SAVED' => 'Asetukset on tallennettu.',
        'PLEASE_CORRECT_THE_FOLLOWING' => 'Korjaa seuraava:',
        'PRIVACY' => 'Yksityisyys',
        'NETWORK_PRIVACY' => 'Verkoston yksityisyys',
        'THIS_NETWORK_VISIBLE_TO_EVERYONE' => 'Tämä verkosto <strong>näkyy kaikille</strong>.',
        'ANYONE_CAN_SIGN_UP_VISITORS_CAN' => 'Kaikki voivat kirjautua ja ryhtyä jäseniksi.  Vieraat voivat…',
        'SEE_EVERYTHING' => 'Nähdä kaiken',
        'SEE_JUST_THE_MAIN_PAGE' => 'Nähdä vain pääsivun',
        'SEE_JUST_THE_SIGN_UP_PAGE' => 'Nähdä vain kirjautumissivun',
        'THIS_NETWORK_VISIBLE_MEMBERS_ONLY' => 'Tämä verkosto <strong>näkyy vain jäsenille</strong>.',
        'WHO_CAN_SIGN_UP' => 'Kuka voi kirjautua ja päästä jäseneksi?',
        'MODERATION' => 'Sisällön valvonta',
        'APPROVE_MEMBERS_BEFORE_JOIN' => 'Hyväksy uudet jäsenet ennen liittymistä',
        'APPROVE_PHOTOS_VIDEOS' => 'Hyväksy kuvat ja videot ennen ilmestymistä',
        'SHOW_LATEST_ACTIVITY_ON_YOUR_NETWORK' => 'Näytä uusimmat tapahtumat!',
        'PUT_A_CONSTANTLY_UPDATED_STREAM' => 'Lisää verkoston pääsivulle jatkuvasti päivittyvät tiedot viimeaikaisista tapahtumista.',
        'CLICK_HERE_TO_ADD_LATEST_ACTIVITY' => 'Napsauta tästä lisätäksesi Uusimmat tapahtumat verkostoosi.',
        'THESE_OPTIONS_ARE_DISABLED_ACTIVITY' => 'Nämä vaihtoehdot eivät ole käytössä, koska Uusimmat tapahtumat eivät ole käytössä verkostossasi.',
        'ACTIVITY' => 'Tapahtumat',
        'DISPLAY_PREFERENCES' => 'Näyttövalinnat',
        'NEW_CONTENT' => 'Uusi sisältö',
        'NEW_COMMENTS' => 'Uudet kommentit',
        'NEW_MEMBERS' => 'Uudet jäsenet',
        'MEMBER_UPDATES' => 'Jäsenten päivitykset',
        'WHAT_DISPLAYS_LATEST_ACTIVITY' => 'Mitä näytetään verkoston <br />Uusimmissa tapahtumissa?',
        'LATEST_ACTIVITY' => 'Uusimmat tapahtumat',
        'X_COMMENTED_ON_POST_TITLE' => '%1$s vastasi keskusteluun %2$s',
        'X_LINK_COMMENTED_ON_POST_LINK_TITLE' => '%1$s <a %2$s>vastasi</a> keskusteluun <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_POST_LINK_TITLE' => '<a %1$s>Vastasit</a> keskusteluun <a %2$s>%3$s</a>',
        'X_COMMENTED_ON_BLOG_POST_TITLE' => '%1$s kommentoi blogiartikkelia %2$s',
        'X_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '%1$s <a %2$s>kommentoi</a> blogiartikkelia <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '<a %1$s>Kommentoit</a> blogiartikkelia <a %2$s>%3$s</a>',
        'X_STARTED_A_DISCUSSION_Y' => '%s aloitti keskustelun %s',
        'YOU_STARTED_A_DISCUSSION_Y' => 'Aloitit keskustelun %s',
        'X_ADDED_THE_BLOG_POST_Y' => '%s lisäsi blogiartikkelin \'%s\'',
        'YOU_ADDED_THE_BLOG_POST_Y' => 'Lisäsit blogiartikkelin \'%s\'',
        'X_JOINED_THE_GROUP_Y' => '%s liittyi ryhmään %s',
        'YOU_JOINED_THE_GROUP_X' => 'Liityit ryhmään %s',
        'X_JOINED_Y_GROUPS' => '%s liittyi %s ryhmiin',
        'YOU_JOINED_X_GROUPS' => 'Liityit %s ryhmiin',
        'X_JOINED_APPNAME' => '%s liittynyt %s. <a %s>Lähetä kommentti</a> %s.',
        'WELCOME_MEMBER_N_OF_APPNAME' => 'Tervetuloa %1$s!  Olet jäsen #%2$s (%3$s).',
        'WELCOME_MEMBER_N_OF_APPNAME_FIND' => 'Tervetuloa %1$s!  Olet jäsen #%2$s (%3$s).  <a %4$s>Etsi ystäviä</a>.',
        'X_IS_MEMBER_N_OF_APPNAME' => '%1$s on jäsen #%2$s (%3$s).',
        'XS_PROFILE_CHANGED' => '%s:n profiili muuttui',
        'YOUR_PROFILE_CHANGED' => 'Profiilisi muuttui',
        'X_LEFT_A_COMMENT_FOR_Y' => '%s jätti kommentin %s:lle',
        'YOU_LEFT_A_COMMENT_FOR_X' => 'Jätit kommentin %s:lle',
        'X_LEFT_A_COMMENT_FOR_YOU' => '%s jätti kommentin sinulle',
        'X_CREATED_A_GROUP_Y' => '%s perusti ryhmän %s',
        'YOU_CREATED_A_GROUP_Y' => 'Perustit ryhmän %s',
        'X_CREATED_Y_NEW_GROUPS' => '%s perusti %s uutta ryhmää',
        'X_STARTED_Y_FORUM_POSTS' => '%s aloitti %s uutta keskustelua foorumilla',
        'YOU_STARTED_Y_FORUM_POSTS' => 'Aloitit %s uutta keskustelua foorumilla',
        'X_ADDED_Y_BLOG_POSTS' => '%s lisäsi %s uutta blogiartikkelia',
        'YOU_ADDED_Y_BLOG_POSTS' => 'Lisäsit %s uutta blogiartikkelia',
        'VIEW_XS_BLOG_POSTS' => 'Näytä %s:n blogiartikkelit',
        'VIEW_YOUR_BLOG_POSTS' => 'Näytä omat blogiartikkelisi',
        'APPNAME_HAS_NEW_PROFILE_QUESTIONS' => '%s:lla on <a %s>uusia profiilikysymyksiä</a>',
        'APPNAME_NOW_HAS_MUSIC' => '%s:lla on nyt musiikkisoitin',
        'APPNAME_NOW_HAS_GROUPS' => '%s:lla on nyt <a %s>ryhmää</a>',
        'APPNAME_NOW_HAS_VIDEO' => '%s:lla on nyt <a %s>videota</a>',
        'APPNAME_NOW_HAS_FORUM' => '%s:lla on nyt <a %s>foorumi</a>',
        'APPNAME_NOW_HAS_PHOTO' => '%s:lla on nyt <a %s>kuvaa</a>',
        'DID_YOU_KNOW' => 'Tiesitkö',
        'ANNOUNCEMENT' => 'Ilmoitus',
        'CONGRATULATIONS' => 'Onnittelut',
        'YOU_CREATED_APPNAME' => 'Perustit verkoston %s.',
        'USER_CREATED_APPNAME' => '%s perusti verkoston %s.',
        'ADD_MESSAGES_ACTIVITY_FEED' => 'Lisää viestejä ja valitse mitä verkostosi tapahtumien syötteessä näkyy.',
        'WHICH_OF_YOUR_ACTIONS_DISPLAY_ACTIVITY' => 'Mitkä tekemäsi asiat näytetään <br />Uusimmissa tapahtumissa?',
        'NEW_CONTENT_I_ADD' => 'Lisäämäni uusi sisältö',
        'NEW_COMMENTS_I_ADD' => 'Lisäämäni uudet kommentit',
        'WHEN_I_UPDATE_MY_PROFILE' => 'Kun päivitän profiiliani',
        'THE_LATEST_ACTIVITY_WILL_NEVER' => 'Uusimmissa tapahtumissa ei koskaan näytetä lähettämiäsi viestejä, tarkastelemiasi sivuja tai jäseniä, hylkäämiäsi kutsuja, ihmisiä jotka torjut tai poistat ystävistäsi eikä poistamiasi asioita.',
        'YOU_HAVENT_DONE_ANYTHING_RECENTLY' => 'Ei viimeaikaisia tapahtumia.  Aloita jotakin!',
        'YOUVE_TURNED_OFF_THE_ACTIVITY_DISPLAY_CLICK' => 'Olet laittanut tapahtumiesi näytön pois päältä.  <a %s>Napsauta tästä, jos haluat laittaa sen päälle. </a>',
        'THE_NETWORK_CREATOR_HAS_TURNED_OFF_THE_ACTIVITY' => 'Verkoston perustaja on laittanut kaikkien tapahtumien näytön pois päältä.',
        'NO_ACTIVITY_TO_DISPLAY' => 'Tällä hetkellä mitään tapahtumia ei näytetä.',
        'BOX_WILL_NOT_SHOW_ACTIVITY' => 'Tätä laatikkoa ei näytetä muille, ellet valitse vähintään yhtä tapahtumalajia.',
        'NOTHING_IS_HAPPENING_ON_YOUR_NETWORK' => 'Viimeaikaisia tapahtumia ei ole.  Aloita jotakin!',
        'MY_ACTIVITY_PREFERENCES' => 'Tapahtumavalintani',
        'DELETE_ACTIVITY_ITEM' => 'Poista tapahtumaviesti',
        'DELETE_THIS_ACTIVITY_MESSAGE_Q' => 'Poistetaanko tämä tapahtumaviesti?',
        'THIS_WILL_PREVENT_ACTIVITY' => 'Tällä estät ketään näkemästä tätä tapahtumaviestiä',
        'X_HAS_POSTED_THE_MOST_PHOTOS' => '%1$s on liittänyt eniten %2$skuvia%3$s',
        'X_IS_THE_MOST_POPULAR_PHOTO' => '%s on suosituin kuva tähän mennessä',
        'X_HAS_POSTED_THE_MOST_VIDEOS' => '%1$s on liittänyt eniten %2$svideoita%3$s',
        'X_IS_THE_MOST_POPULAR_VIDEO' => '%s on suosituin video tähän mennessä',
        'X_HAS_POSTED_THE_MOST_MUSIC' => '%s on liittänyt eniten lauluja',
        'X_IS_THE_MOST_POPULAR_MUSIC' => '%s on suosituin laulu tähän mennessä',
        'X_IS_THE_MOST_POPULAR_TOPIC' => '%s on suosituin foorumiartikkeli tähän mennessä',
        'X_IS_THE_MOST_POPULAR_BLOG_POST' => '%s on suosituin blogiartikkeli tähän mennessä',
        'XS_LATEST_ACTIVITY_ON_APPNAME' => '%s:n uusimmat tapahtumat täällä: %s',
        'LATEST_ACTIVITY_ON_APPNAME' => 'Uusimmat tapahtumat täällä: %s',
        'ADD_MESSAGE_TO_LATEST_ACTIVITY' => 'Lisää viesti uusimpiin tapahtumiin',
        'ADD_FACTS_ABOUT_THE_NETWORK_ELLIPSIS' => 'Lisää tietoja verkostosta...',
        'ADD_MESSAGE' => 'Lisää viesti',
        'ELLIPSIS_OR_WRITE_YOUR_OWN_MESSAGE' => '...tai kirjoita oma viesti',
        'NETWORK' => 'Verkosto',
        'WHO_CAN_VIEW_YOUR_PHOTOS_VIDEOS' => 'Kuka voi katsella kuvia, videoita <br/> ja blogiartikkeleita oletuksena?',
        'YOU_CAN_OVERRIDE_WHEN_YOU_ADD' => '(Voit ohittaa tämän asetuksen lisätessäsi kuvan, videon tai blogiartikkelin.)',
        'MODERATE_COMMENTS_ON_BLOG' => 'Haluatko hyväksyä kommentit<br />ennen kuin ne näkyvät blogissasi?',
        'YES_LET_ME_APPROVE' => 'Kyllä – Haluan hyväksyä kommentit ensin',
        'NO_PUBLISH_COMMENTS' => 'Ei – Julkaise kommentit heti',
        'WHO_CAN_COMMENT_ON_PHOTOS_VIDEOS' => 'Kuka voi kommentoida kuvia,<br/> videoita ja blogia?',
        'SAVE' => 'Tallenna',
        'EMAIL' => 'Sähköposti',
        'YOUR_PRIVACY_IS_IMPORTANT' => 'Yksityisyydensuojasi on meille tärkeä.  Jos sinulla on kysyttävää sähköposti-ilmoituksista, lähetä meille viesti täältä: <a href="http://help.ning.com/?page_id=27">Help Center</a>.',
        'ADD_PHOTOS_AND_VIDEOS_TO_X_BY_SENDING' => 'Lisää kuvia paikkaan s% lähettämällä ne tähän sähköpostiin:',
        'ADD_PHOTOS_AND_VIDEOS_TO_APPNAME_FROM_PHONE' => 'Lisää kuvia ja videoita kännykästäsi paikkaan s% lähettämällä ne tähän sähköpostiin:',
        'GENERATE_NEW_EMAIL_ADDRESS' => 'Kehitä uusi sähköpostiosoite',
        'SUPPORTS_TEXT_EMBEDDED' => 'Tukee tekstiä, upotettuja videoita, kuvia ja vimpaimia',
        'POST_COMMENT' => 'Liitä kommentti',
        'YOU_NEED_TO_BE_MEMBER_COMMENTS' => 'Sinun tulee olla %s:n jäsen ennen kuin voit kommentoida!',
        'MONTHLY_ARCHIVES' => 'Kuukausiarkistot',
        'NO_FRIENDS_ON_SITE' => 'Ei vielä ystäviä tässä yhteisössä.',
        'NO_FRIENDS_ON_SITE_THAT_MATCH' => 'Ei hakua vastaavia ystäviä tässä yhteisössä.',
        'MEMBERS_TAB_TEXT' => 'Jäsenet',
        'SITE_HAS_NO_MEMBERS' => 'Tässä yhteisössä ei ole vielä jäseniä!',
        'SITE_HAS_NO_MEMBERS_THAT_MATCH' => 'Tässä yhteisössä ei ole hakua vastaavia jäseniä!',
        'NO_COMMENTS_YET' => 'Ei vielä kommentteja!',
        'VIEW_ALL_COMMENTS' => 'Näytä kaikki kommentit',
        'YOU_HAVE_NOT_ADDED_BLOG_POSTS' => 'Et ole vielä lisännyt blogiartikkeleita!',
        'YOU_CAN_WRITE_ABOUT_ANYTHING' => 'Voit kirjoittaa mistä vain, upottaa suosikkivideoitasi, kuviasi ja musiikkiasi ja keskustella niistä.',
        'WRITE_YOUR_FIRST_ENTRY' => 'Kirjoita ensimmäinen merkintäsi!',
        'THERE_ARE_NO_BLOG_POSTS' => 'Tällä hetkellä yhteisössäsi ei ole blogiartikkeleita.',
        'THERE_ARE_NO_FEATURED_X' => 'Yhteisössäsi ei ole suositteluja tässä luokassa: %s',
        'THERE_ARE_NO_X_THAT_MATCH_SETTINGS' => 'Valitsemiasi asetuksia vastaavia kohteita ei ole tässä luokassa: %s',
        'START_FEATURING_X_CLICK_Y' => 'Ryhdy tekemään %s-suosituksia Suosittele-valinnasta.  Jos haluat lisätietoa suosittelusta, <a %s>napsauta tästä</a>.',
        'THIS_BOX_WILL_NOT_SHOW_BLOG_POSTS' => 'Tämä laatikko ei näy muille, ennen kuin on näytettäviä blogiartikkeleita.  Miksi et lisäisi yhtä?',
        'YOUR_FRIEND' => 'Ystäväsi',
        'REQUEST_SENT' => 'Pyyntö lähetetty!',
        'BLOCKED' => 'Estetty',
        'BANNED' => 'Saanut porttikiellon',
        'ADD_YOUR_FIRST_BLOG_POST' => 'Lisää ensimmäinen blogiartikkelisi',
        'MY_FIRST_BLOG_POST' => 'Ensimmäinen blogiartikkelini!',
        'TELL_THE_PEOPLE_ON' => 'Kerro %s:ssa oleville lisää itsestäsi.  Tällä symbolilla <span %s>lukko</span> merkityt kysymykset ovat yksityisiä ja näkyvät vain ylläpitäjille.',
        'CHOOSE_A_THEME_FOR_PAGE' => 'Valitse sivullesi teema',
        'NOW_CUSTOMIZE_PAGE' => 'Mukauta nyt sivuasi...',
        'NO_POSTS_TO_DISPLAY' => 'Ei näytettäviä artikkeleita.',
        'YOU_ARE_DISPLAYING_NO_POSTS' => 'Tällä hetkellä artikkeleita ei näytetä.',
        'DATE_COLON' => 'Päiväys:',
        'TIME_COLON' => 'Aika:',
        'CHANGE' => 'Vaihda',
        'UPLOAD_A_PHOTO' => 'Lataa valokuva',
        'OPTIONS' => 'asetukset',
        'PIXELS' => 'Pikselit',
        'CANCEL' => 'Peruuta',
        'UPLOAD_A_FILE' => 'Lataa tiedosto:',
        'TO_INSERT_A_FILE' => 'Voit lisätä tiedoston napsauttamalla “Selaa” tai “Valitse” nappia ja etsimällä tiedoston tietokoneeltasi.',
        'UPLOADING' => 'Ladataan...',
        'OK' => 'OK',
        'POPULAR_MEMBERS' => 'Suositut jäsenet',
        'INVITE_FRIENDS' => 'Kutsu ystäviä',
        'VIEW_ALL' => 'Näytä kaikki',
        'REMOVE_X' => 'Poista %s',
        'ARE_YOU_SURE_BAN_X_AND_CONTENT' => 'Haluatko varmasti antaa %1$s:lle porttikiellon yhteisöösi ja poistaa kaiken %1$s:n lisäämän sisällön?  Käsittely voi kestää muutaman minuutin.',
        'REMOVING_X' => 'Poistetaan %s',
        'ARE_YOU_SURE_BAN_MEMBERS_AND_CONTENT' => 'Haluatko varmasti antaa valitsemillesi jäsenille porttikiellon yhteisöösi ja poistaa kaiken heidän lisäämänsä sisällön?  Käsittely voi kestää muutaman minuutin.',
        'ARE_YOU_SURE_BAN_MEMBERS' => 'Haluatko varmasti antaa valitsemillesi jäsenille porttikiellon yhteisöösi?  Käsittely voi kestää muutaman minuutin.',
        'BAN' => 'Porttikielto',
        'REMOVING_MEMBERS' => 'Poistetaan jäsenet',
        'FEMALE' => 'Nainen',
        'MALE' => 'Mies',
        'UNITED_STATES' => 'Yhdysvallat',
        'AND' => 'ja',
        'FROM' => 'mistä',
        'GENDER_M' => 'Mies',
        'GENDER_F' => 'Nainen',
        'XS_PAGE_ON_Y' => '%s:n sivu täällä: %s',
        'SEARCH_MEMBERS' => 'Etsi jäseniä',
        'SOMEBODY_COMMENTED_BLOGPOST_ADDED_TO_X' => 'joku on kommentoinut tänne lisäämääsi blogiartikkelia: %s',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE' => 'Sivullasi on uusi kommentti.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X' => 'Sivullasi on uusi kommentti täällä: %s.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X_ELLIPSIS' => 'Sivullasi on uusi kommentti täällä: %s...',
        'A_BLOG_POST' => 'blogiartikkeli',
        'NOW_THAT_YOU_JOINED_INVITE' => 'Nyt kun olet liittynyt, <strong><a %s>kutsu ystäväsi mukaan</a></strong>!',
        'THIS_IS_YOUR_PROFILE' => 'Tämä on profliisi:',
        'START_BY_CUSTOMIZING_ITS_APPEARANCE' => 'Aloita <a %s>mukauttamalla ulkoasua</a>.',
        'USE_IT_TO_KEEP_A_BLOG_AND_DISPLAY_YOUR_PROFILE_ANSWERS' => 'Käytä sitä <a %1$s>blogin pitämiseen</a> ja näytä <a %2$s>profiilivastauksesi</a>.',
        'START_CONTRIBUTING' => 'Aloita osallistuminen:',
        'UPLOAD_VIDEOS' => 'Lataa tänne videoita',
        'CONTRIBUTE_TO_DISCUSSIONS' => 'Osallistu keskusteluihin',
        'JOIN_GROUPS' => 'Liity ryhmiin',
        'ADD_A_BLOG_POST' => 'Lisää blogiartikkeli',
        'CLICK_TO_ACCEPT_FRIENDS' => 'Näet ystäväpyyntösi napsauttamalla tästä.',
        'LEAVE_X' => 'Lähde täältä: %s',
        'LEAVE_X_Q' => 'Lähdetäänkö täältä: %s?',
        'ARE_YOU_SURE_LEAVE_X' => 'Haluatko varmasti lähteä ja poistaa kaiken lisäämäsi sisällön täältä: %s?  Käsittely voi kestää muutaman minuutin.',
        'BACK_TO_USERNAMES_PAGE' => '&#8592;  Takaisin %s:n sivulle',
        'BACK_TO_MY_PAGE' => '&#8592;  Takaisin omalle sivulleni',
        'COMMENT_WALL' => 'Kommenttitaulu',
        'ONLINE' => 'Online',
        'MEMBER_IS_ONLINE' => 'Jäsen on online-tilassa',
        'ONLINE_NOW' => 'Online-tilassa nyt',
        'CHOOSE_WHO_CAN_SEE_JOIN_AND_CONTRIBUTE' => 'Valitse, ketkä pääsevät katselemaan, liittymään ja osallistumaan verkostoosi.',
        'EMAIL_NOTIFICATIONS' => 'Sähköposti-ilmoitukset',
        'WHAT_NETWORK_ACTIVITY_EMAIL_FOR' => 'Mistä verkoston tapahtumista haluat saada ilmoituksen sähköpostiin?',
        'NETWORK_MESSAGES' => 'Verkoston viestit',
        'MEMBER_ACTIVITY' => 'Jäsenten tapahtumat',
        'APPROVAL' => 'Hyväksyntä',
        'FRIEND_REQUESTS' => 'Ystäväpyynnöt',
        'PEOPLE_IVE_INVITED_JOIN' => 'Henkilöt, jotka olen kutsunut tähän verkostoon',
        'MESSAGES_SENT_TO_ME' => 'Minulle lähetetyt viestit',
        'MESSAGES_SENT_TO_GROUPS' => 'Ryhmiini lähetetyt viestit',
        'MESSAGES_SENT_TO_NETWORK' => 'Koko verkostolle lähetetyt viestit',
        'I_HAVE_NEW_COMMENTS' => 'Minulla on uusia hyväksyttäviä kommentteja',
        'I_HAVE_NEW_NETWORK_CONTENT' => 'Minulla on uutta hyväksyttävää sisältöä',
        'CONTENT_ACTIVITY' => 'Sisällön tapahtumat',
        'ACTIVITY_ON_THINGS_IVE_ADDED' => 'Tapahtumat lisäämissäni kohteissa',
        'AUTO_FOLLOW_DISCUSSIONS_I_REPLY_TO' => 'Seuraa automaattisesti keskusteluja, joihin vastaan',
        'THINGS_IVE_ADDED_APPROVED' => 'Lisäämäni kohteet on hyväksytty',
        'NOTIFICATIONS' => 'Ilmoitukset',
        'EMAIL_ME_WHEN_PEOPLE_REPLY' => 'Haluan sähköpostia kun tulee vastauksia',
        'DO_NOT_EMAIL_ME_WHEN_PEOPLE_REPLY' => 'En halua sähköpostia kun tulee vastauksia',
        'TO_STOP_FOLLOWING_THIS_X_CLICK_Y' => '<a %s>Napsauta tästä</a>, jos haluat lakata seuraamasta tätä: %s.',
        'YOU_ARE_NO_LONGER_FOLLOWING_THIS_X' => 'Et seuraa enää tätä: %s.',
        'NOTIFY' => 'Ilmoita',
        'STOP_NOTIFYING' => 'Lakkaa ilmoittamasta',
        'EMAIL_WHEN_NEW_DISCUSSIONS' => 'Haluan sähköpostia, kun tulee uusia keskusteluja',
        'DO_NOT_EMAIL_WHEN_NEW_DISCUSSIONS' => 'En halua sähköpostia, kun tulee uusia keskusteluja',
        'STOP_FOLLOWING_ALL' => 'Lakkaa seuraamasta kaikkia keskusteluja ja blogikommentteja',
        'CHANGE_MY_PHOTO' => 'Vaihda kuvani',
        'COUNTRY_AF' => 'Afganistan',
        'COUNTRY_AX' => 'Ahvenanmaa',
        'COUNTRY_AL' => 'Albania',
        'COUNTRY_DZ' => 'Algeria',
        'COUNTRY_AS' => 'Amerikan Samoa',
        'COUNTRY_AD' => 'Andorra',
        'COUNTRY_AO' => 'Angola',
        'COUNTRY_AI' => 'Anguilla',
        'COUNTRY_AQ' => 'Antarktis',
        'COUNTRY_AG' => 'Antigua ja Barbuda',
        'COUNTRY_AR' => 'Argentiina',
        'COUNTRY_AM' => 'Armenia',
        'COUNTRY_AW' => 'Aruba',
        'COUNTRY_AU' => 'Australia',
        'COUNTRY_AT' => 'Itävalta',
        'COUNTRY_AZ' => 'Azerbaidžan',
        'COUNTRY_BS' => 'Bahama',
        'COUNTRY_BH' => 'Bahrain',
        'COUNTRY_BD' => 'Bangladesh',
        'COUNTRY_BB' => 'Barbados',
        'COUNTRY_BY' => 'Valko-Venäjä',
        'COUNTRY_BE' => 'Belgia',
        'COUNTRY_BZ' => 'Belize',
        'COUNTRY_BJ' => 'Benin',
        'COUNTRY_BM' => 'Bermuda',
        'COUNTRY_BT' => 'Bhutan',
        'COUNTRY_BO' => 'Bolivia',
        'COUNTRY_BA' => 'Bosnia ja Hertsegovina',
        'COUNTRY_BW' => 'Botswana',
        'COUNTRY_BV' => 'Bouvet nsaari',
        'COUNTRY_BR' => 'Brasilia',
        'COUNTRY_IO' => 'Brittiläinen Intian valtameren alue',
        'COUNTRY_BN' => 'Brunei',
        'COUNTRY_BG' => 'Bulgaria',
        'COUNTRY_BF' => 'Burkina Faso',
        'COUNTRY_BI' => 'Burundi',
        'COUNTRY_KH' => 'Kambodža',
        'COUNTRY_CM' => 'Kamerun',
        'COUNTRY_CA' => 'Kanada',
        'COUNTRY_CV' => 'Kap Verde',
        'COUNTRY_KY' => 'Caymansaaret',
        'COUNTRY_CF' => 'Keski-Afrikan tasavalta',
        'COUNTRY_TD' => 'Tšad',
        'COUNTRY_CL' => 'Chile',
        'COUNTRY_CN' => 'Kiina (Manner-Kiina)',
        'COUNTRY_CX' => 'Joulusaari',
        'COUNTRY_CC' => 'Kookossaaret',
        'COUNTRY_CO' => 'Kolumbia',
        'COUNTRY_KM' => 'Komorit',
        'COUNTRY_CG' => 'Kongon tasavalta',
        'COUNTRY_CD' => 'Kongon demokraattinen tasavalta',
        'COUNTRY_CK' => 'Cookinsaaret',
        'COUNTRY_CR' => 'Costa Rica',
        'COUNTRY_CI' => 'Norsunluurannikko',
        'COUNTRY_HR' => 'Kroatia',
        'COUNTRY_CU' => 'Kuuba',
        'COUNTRY_CY' => 'Kypros',
        'COUNTRY_CZ' => 'Tšekin tasavalta',
        'COUNTRY_DK' => 'Tanska',
        'COUNTRY_DJ' => 'Djibouti',
        'COUNTRY_DM' => 'Dominica',
        'COUNTRY_DO' => 'Dominikaaninen tasavalta',
        'COUNTRY_EC' => 'Ecuador',
        'COUNTRY_EG' => 'Egypti',
        'COUNTRY_SV' => 'El Salvador',
        'COUNTRY_GQ' => 'Päiväntasaajan Guinea',
        'COUNTRY_ER' => 'Eritrea',
        'COUNTRY_EE' => 'Viro',
        'COUNTRY_ET' => 'Etiopia',
        'COUNTRY_EU' => 'Euroopan unioni',
        'COUNTRY_FK' => 'Falklandinsaaret',
        'COUNTRY_FO' => 'Färsaaret',
        'COUNTRY_FJ' => 'Fidži',
        'COUNTRY_FI' => 'Suomi',
        'COUNTRY_FR' => 'Ranska',
        'COUNTRY_GF' => 'Ranskan Guayana',
        'COUNTRY_PF' => 'Ranskan Polynesia',
        'COUNTRY_TF' => 'Ranskan eteläiset territoriot',
        'COUNTRY_GA' => 'Gabon',
        'COUNTRY_GM' => 'Gambia',
        'COUNTRY_GE' => 'Georgia',
        'COUNTRY_DE' => 'Saksa',
        'COUNTRY_GH' => 'Ghana',
        'COUNTRY_GI' => 'Gibraltar',
        'COUNTRY_GR' => 'Kreikka',
        'COUNTRY_GL' => 'Grönlanti',
        'COUNTRY_GD' => 'Grenada',
        'COUNTRY_GP' => 'Guadeloupe',
        'COUNTRY_GU' => 'Guam',
        'COUNTRY_GT' => 'Guatemala',
        'COUNTRY_GN' => 'Guinea',
        'COUNTRY_GW' => 'Guinea-Bissau',
        'COUNTRY_GY' => 'Guyana',
        'COUNTRY_HT' => 'Haiti',
        'COUNTRY_HM' => 'Heard ja McDonaldinsaaret',
        'COUNTRY_HN' => 'Honduras',
        'COUNTRY_HK' => 'Hong Kong',
        'COUNTRY_HU' => 'Unkari',
        'COUNTRY_IS' => 'Islanti',
        'COUNTRY_IN' => 'Intia',
        'COUNTRY_ID' => 'Indonesia',
        'COUNTRY_IR' => 'Iran',
        'COUNTRY_IQ' => 'Irak',
        'COUNTRY_IE' => 'Irlanti',
        'COUNTRY_IL' => 'Israel',
        'COUNTRY_IT' => 'Italia',
        'COUNTRY_JM' => 'Jamaika',
        'COUNTRY_JP' => 'Japani',
        'COUNTRY_JO' => 'Jordania',
        'COUNTRY_KZ' => 'Kazakstan',
        'COUNTRY_KE' => 'Kenia',
        'COUNTRY_KI' => 'Kiribati',
        'COUNTRY_KP' => 'Korean demokraattinen kansantasavalta',
        'COUNTRY_KR' => 'Korean tasavalta',
        'COUNTRY_KW' => 'Kuwait',
        'COUNTRY_KG' => 'Kirgisia',
        'COUNTRY_LA' => 'Laos',
        'COUNTRY_LV' => 'Latvia',
        'COUNTRY_LB' => 'Libanon',
        'COUNTRY_LS' => 'Lesotho',
        'COUNTRY_LR' => 'Liberia',
        'COUNTRY_LY' => 'Libya',
        'COUNTRY_LI' => 'Liechtenstein',
        'COUNTRY_LT' => 'Liettua',
        'COUNTRY_LU' => 'Luxemburg',
        'COUNTRY_MO' => 'Macao',
        'COUNTRY_MK' => 'Makedonia (entinen Jugoslavian tasavalta)',
        'COUNTRY_MG' => 'Madagaskar',
        'COUNTRY_MW' => 'Malawi',
        'COUNTRY_MY' => 'Malesia',
        'COUNTRY_MV' => 'Malediivit',
        'COUNTRY_ML' => 'Mali',
        'COUNTRY_MT' => 'Malta',
        'COUNTRY_MH' => 'Marshallinsaaret',
        'COUNTRY_MQ' => 'Martinique',
        'COUNTRY_MR' => 'Mauritania',
        'COUNTRY_MU' => 'Mauritius',
        'COUNTRY_YT' => 'Mayotte',
        'COUNTRY_MX' => 'Meksiko',
        'COUNTRY_FM' => 'Mikronesian liittovaltio',
        'COUNTRY_MD' => 'Moldovan tasavalta',
        'COUNTRY_MC' => 'Monaco',
        'COUNTRY_MN' => 'Mongolia',
        'COUNTRY_MS' => 'Montserrat',
        'COUNTRY_MA' => 'Marokko',
        'COUNTRY_MZ' => 'Mosambik',
        'COUNTRY_MM' => 'Myanmar',
        'COUNTRY_NA' => 'Namibia',
        'COUNTRY_NR' => 'Nauru',
        'COUNTRY_NP' => 'Nepal',
        'COUNTRY_NL' => 'Alankomaat',
        'COUNTRY_AN' => 'Alankomaiden Antillit',
        'COUNTRY_NC' => 'Uusi-Kaledonia',
        'COUNTRY_NZ' => 'Uusi-Seelanti',
        'COUNTRY_NI' => 'Nicaragua',
        'COUNTRY_NE' => 'Niger',
        'COUNTRY_NG' => 'Nigeria',
        'COUNTRY_NU' => 'Niue',
        'COUNTRY_NF' => 'Norfolkinsaari',
        'COUNTRY_MP' => 'Pohjois-Mariaanit',
        'COUNTRY_NO' => 'Norja',
        'COUNTRY_OM' => 'Oman',
        'COUNTRY_PK' => 'Pakistan',
        'COUNTRY_PW' => 'Palau',
        'COUNTRY_PS' => 'Palestiinalaishallinnon alue',
        'COUNTRY_PA' => 'Panama',
        'COUNTRY_PG' => 'Papua-Uusi-Guinea',
        'COUNTRY_PY' => 'Paraguay',
        'COUNTRY_PE' => 'Peru',
        'COUNTRY_PH' => 'Filippiinit',
        'COUNTRY_PN' => 'Pitcairn',
        'COUNTRY_PL' => 'Puola',
        'COUNTRY_PT' => 'Portugali',
        'COUNTRY_PR' => 'Puerto Rico',
        'COUNTRY_QA' => 'Qatar',
        'COUNTRY_RE' => 'Réunion',
        'COUNTRY_RO' => 'Romania',
        'COUNTRY_RU' => 'Venäjän federaatio',
        'COUNTRY_RW' => 'Ruanda',
        'COUNTRY_SH' => 'Saint Helena',
        'COUNTRY_KN' => 'Saint Kitts ja Nevis',
        'COUNTRY_LC' => 'Saint Lucia',
        'COUNTRY_PM' => 'Saint-Pierre ja Miquelon',
        'COUNTRY_VC' => 'Saint Vincent ja Grenadiinit',
        'COUNTRY_WS' => 'Samoa',
        'COUNTRY_SM' => 'San Marino',
        'COUNTRY_ST' => 'Sao Tome ja Principe',
        'COUNTRY_SA' => 'Saudi-Arabia',
        'COUNTRY_SN' => 'Senegal',
        'COUNTRY_CS' => 'Serbia ja Montenegro',
        'COUNTRY_SC' => 'Seychellit',
        'COUNTRY_SL' => 'Sierra Leone',
        'COUNTRY_SG' => 'Singapore',
        'COUNTRY_SK' => 'Slovakia',
        'COUNTRY_SI' => 'Slovenia',
        'COUNTRY_SB' => 'Salomonsaaret',
        'COUNTRY_SO' => 'Somalia',
        'COUNTRY_ZA' => 'Etelä-Afrikka',
        'COUNTRY_GS' => 'Etelä-Georgia ja Eteläiset Sandwichsaaret',
        'COUNTRY_ES' => 'Espanja',
        'COUNTRY_LK' => 'Sri Lanka',
        'COUNTRY_SD' => 'Sudan',
        'COUNTRY_SR' => 'Surinam',
        'COUNTRY_SJ' => 'Huippuvuoret and Jan Mayen',
        'COUNTRY_SZ' => 'Swazimaa',
        'COUNTRY_SE' => 'Ruotsi',
        'COUNTRY_CH' => 'Sveitsi',
        'COUNTRY_SY' => 'Syyrian arabitasavalta',
        'COUNTRY_TW' => 'Taiwan',
        'COUNTRY_TJ' => 'Tadžikistan',
        'COUNTRY_TZ' => 'Tansanian yhdistynyt tasavalta',
        'COUNTRY_TH' => 'Thaimaa',
        'COUNTRY_TL' => 'Itä-Timor',
        'COUNTRY_TG' => 'Togo',
        'COUNTRY_TK' => 'Tokelau',
        'COUNTRY_TO' => 'Tonga',
        'COUNTRY_TT' => 'Trinidad ja Tobago',
        'COUNTRY_TN' => 'Tunisia',
        'COUNTRY_TR' => 'Turkki',
        'COUNTRY_TM' => 'Turkmenistan',
        'COUNTRY_TC' => 'Turks- ja Caicossaaret',
        'COUNTRY_TV' => 'Tuvalu',
        'COUNTRY_UG' => 'Uganda',
        'COUNTRY_UA' => 'Ukraina',
        'COUNTRY_AE' => 'Yhdistyneet Arabiemiirikunnat',
        'COUNTRY_GB' => 'Yhdistynyt kuningaskunta',
        'COUNTRY_US' => 'Yhdysvallat',
        'COUNTRY_UM' => 'Yhdysvaltain Tyynenmeren erillissaaret',
        'COUNTRY_UY' => 'Uruguay',
        'COUNTRY_UZ' => 'Uzbekistan',
        'COUNTRY_VU' => 'Vanuatu',
        'COUNTRY_VA' => 'Vatikaanivaltio',
        'COUNTRY_VE' => 'Venezuela',
        'COUNTRY_VN' => 'Vietnam',
        'COUNTRY_VG' => 'Brittiläiset Neitsytsaaret',
        'COUNTRY_VI' => 'Yhdysvaltain Neitsytsaaret',
        'COUNTRY_WF' => 'Wallis- ja Futunasaaret',
        'COUNTRY_EH' => 'Länsi-Sahara',
        'COUNTRY_YE' => 'Jemen',
        'COUNTRY_ZM' => 'Sambia',
        'COUNTRY_ZW' => 'Zimbabwe',
        'ERROR_LOG' => 'Virheloki',
        'CANNOT_READ_ERROR_LOG' => 'Virhelokia ei voi lukea',
        'CANNOT_OPEN_ERROR_LOG' => 'Virhelokia ei voi avata',
        'CANNOT_SCAN_ERROR_LOG' => 'Virhelokia ei voi tutkia',
        'MODELS_RESET' => 'Mallien palautus:',
        'NO_MODELS_RESET' => 'Ei mallien palautusta.',
        'NO_FEED_TO_DISPLAY' => 'Tällä hetkellä ei näytetä kohteita.',
        'BOX_WILL_NOT_SHOW_FEED' => 'Tätä laatikkoa ei näytetä muille, ellet valitse vähintään yhtä kohdetta.',
        'CLICK_EDIT_TO_SPECIFY_FEED' => 'Napsauta Muokkaa ja määrittele tämän laatikon RSS-syöte.',
        'PROBLEM_OCCURRED_RETRIEVING_FEED' => 'RSS-syötteen noutamisessa ilmeni ongelma.',
        'MORE_ELLIPSIS' => 'Lisää...',
        'RSS' => 'RSS',
        'WE_ARE_SORRY_SITE_HAS_ISSUE' => 'Valitettavasti tällä sivustolla on jokin ongelma.',
        'PLEASE_TRY_REFRESHING' => 'Yritä päivittää sivu 30 sekunnin kuluttua tai <a %s>kerro meille</a>, jos saat tämän viestin uudestaan.',
        'NO_DISCUSSIONS_TAGGED_X' => 'Ei ole keskusteluja, joissa olisi tagi "%1$s".',
        'PAGE_TITLE_COLON' => 'Sivun otsikko:',
        'PAGE_CONTENT' => 'Sisältö:',
        'CREATE_PAGE' => 'Luo sivu',
        'CREATE_NEW_PAGE' => 'Luo uusi sivu',
        'YOUR_COMMENT' => 'Kommenttisi',
        'ADD_YOUR_COMMENT' => 'Lisää kommenttisi',
        'DELETE_PAGE' => 'Poista tämä sivu',
        'DELETE_THIS_PAGE_Q' => 'Poistetaanko tämä sivu?',
        'ARE_YOU_SURE_DELETE_THIS_PAGE' => 'Haluatko varmasti poistaa tämän sivun (ja kaikki kommentit)?  Käsittely voi kestää muutaman minuutin.',
        'SEARCH_PAGES' => 'Hae sivuilta',
        'ALL_PAGES' => 'Kaikki sivut',
        'SUBSCRIBE_TO_PAGES' => 'Tilaa nämä sivut',
        'NOBODY_HAS_ADDED_PAGES' => 'Sivuja ei ole vielä lisätty!',
        'ADD_PAGES_CALL_TO_ACTION' => 'Aloita luomalla sivu.',
        'CREATE_A_PAGE' => 'Luo sivu',
        'PLEASE_ENTER_PAGE_CONTENT' => 'Kirjoita sivun sisältö',
        'SEARCH_RESULTS_FOR_X' => 'Etsinnän tulos <em>%s</em>',
        'EDIT_YOUR_PAGE' => 'Muokkaa sivuasi',
        'UPDATE_PAGE' => 'Päivitä sivu',
        'CLOSE_DISCUSSION' => 'Sulje keskustelu',
        'REOPEN_DISCUSSION' => 'Avaa keskustelu uudelleen',
        'CLOSING_DISCUSSION_PREVENTS' => 'Keskustelun sulkeminen estää uudet vastaukset',
        'NO_DISCUSSION_TO_DISPLAY' => 'Tällä hetkellä ei näytetä keskusteluja.',
        'BOX_WILL_NOT_SHOW_DISCUSSION' => 'Tätä laatikkoa ei näytetä muille, ellet valitse ainakin yhtä keskustelua.',
        'NEWEST_DISCUSSIONS' => 'Uusimmat keskustelut',
        'LATEST_REPLIES' => 'Viimeisimmät vastaukset',
        'REPLIES_CLOSED_FOR_DISCUSSION' => 'Tämä keskustelu on suljettu, eikä siihen voi vastata.',
        'SORRY_DISCUSSION_CLOSED' => 'Valitettavasti tämä keskustelu on juuri suljettu, eikä siihen voi vastata.',
        'MOST_REPLIES' => 'Eniten vastauksia',
        'OWNER_DISCUSSIONS_ONLY' => 'Vain perustajan keskustelut',
        'MY_DISCUSSIONS_ONLY' => 'Vain omat keskusteluni',
        'DISCUSSION_DELETED' => 'Keskustelu poistettu',
        'DISCUSSION_HAS_BEEN_DELETED' => 'Tämä keskustelu ei ole enää käytettävissä.',
        'REPLY_DELETED' => 'Vastaus poistettu',
        'REPLY_HAS_BEEN_DELETED' => 'Tämä vastaus on poistettu.  <a %s>Palaa keskusteluun. </a>',
        'VIEW_ALL_DISCUSSIONS' => 'Näytä kaikki keskustelut',
        'ADD_CATEGORIES' => 'Lisää luokkia',
        'CATEGORY' => 'Luokka:',
        'NO_DISCUSSIONS_IN_CATEGORY' => 'Tässä luokassa ei ole vielä keskusteluja.',
        'ADD_MANAGE_CATEGORIES' => 'Lisää/hallinnoi luokkia',
        'VIEW_ALL_N_CATEGORIES' => 'Näytä kaikki %s:n luokat',
        'UNTITLED_CATEGORY' => 'Nimetön luokka',
        'SAMPLE_TITLE' => 'Esimerkkiotsikko',
        'UNCATEGORIZED' => 'Luokittelematon',
        'EXISTING_DISCUSSIONS' => 'Keskustelut joille ei ole annettu luokkaa.',
        'YOU_HAVE_NOT_ADDED_CATEGORIES' => 'Luokkia ei ole tällä hetkellä.  Aloita lisäämällä luokka!',
        'ADD_A_CATEGORY' => 'Lisää luokka',
        'ADD_ANOTHER_CATEGORY' => 'Lisää uusi luokka',
        'MANAGE_CATEGORIES' => 'Hallinnoi luokkia',
        'CATEGORY_TITLE' => 'Luokan otsikko',
        'ALLOW_MEMBERS_TO_START_DISCUSSIONS' => 'Salli jäsenten aloittaa keskusteluja tässä luokassa.',
        'ONLY_I_CAN_START_DISCUSSIONS' => 'Vain minä voin aloittaa keskusteluja tässä luokassa',
        'ALLOW_MEMBERS_TO_REPLY' => 'Salli vastaaminen jäsenille',
        'SUGGESTIONS' => 'Ehdotuksia:',
        'TRY_DIFFERENT_KEYWORDS' => 'Kokeile erilaisia tai yleisempiä hakusanoja',
        'VIEW_DISCUSSIONS_OR_START_DISCUSSION' => '<a %s>Näytä kaikki keskustelut</a> tai <a %s>Aloita uusi keskustelu</a>',
        'MAKE_SURE_WORDS_SPELLED' => 'Tarkista ettei sanoissa ole kirjoitusvirheitä',
        'REPLY_WAS_DELETED' => 'Tämä vastaus on poistettu',
        'TAGS_X' => '<strong>Tagit:</strong> %s',
        'SEND_PRIVATE_MESSAGE' => 'Lähetä yksityisviesti',
        'PERMALINK_TO_REPLY' => 'Tee pysyvä linkki tähän vastaukseen',
        'PERMALINK' => 'Permalink',
        'WE_COULD_NOT_FIND_ANY_DISCUSSIONS' => 'Valitettavasti hakuusi sopivia keskusteluja ei löytynyt.',
        'DISCUSSIONS_MATCHING_X' => 'Keskustelut haulla <em>\'%s\'</em>',
        'SEARCH_DISCUSSIONS' => 'Etsi keskusteluista',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS_2' => 'Et ole vielä lisännyt keskusteluja!',
        'ADD_DISCUSSIONS_AND_SHARE' => 'Lisää keskusteluja ja jaa ne ystäviesi, sukulaistesi ja kaikkien muiden kanssa!',
        'DISCUSSION' => 'Keskustelu',
        'DISCUSSIONS' => 'Keskustelut',
        'KEEP_PAGE_OPEN_FORUM' => 'Jätä tämä sivu auki, jotta voimme viimeistellä tiedostojesi lataamisen foorumille.',
        'MEANWHILE_FEEL_FREE_FORUM' => 'Sillä aikaa voit vapaasti <a %s>avata uuden ikkunan</a> ja jatkaa %s:n selaamista.',
        'START_A_NEW_DISCUSSION' => 'Aloita uusi keskustelu',
        'DISCUSSION_TITLE' => 'Keskustelun otsikko:',
        'FIRST_POST' => 'Artikkeli:',
        'UPLOAD_FILES' => 'Liitä tiedosto(ja):',
        'START_DISCUSSION' => 'Aloita keskustelu',
        'EDIT_DISCUSSION' => 'Muokkaa keskustelua',
        'START_A_DISCUSSION' => 'Aloita keskustelu',
        'ALL_DISCUSSIONS' => 'Foorumin kotisivu',
        'CONTRIBUTORS' => 'Osallistujat',
        'MY_DISCUSSIONS' => 'Omat keskusteluni',
        'READ_MORE' => 'Lue lisää',
        'STARTED_T_BY' => 'Aloittanut <strong>%s</strong>:',
        'ADDED_BY_X_T' => 'Lisännyt %s %s',
        'STARTED_BY_X_T' => 'Aloittanut %s %s',
        'REPLY_BY_X_T' => 'Vastannut <strong>%s</strong> %s',
        'STARTED_BY_X_LAST_REPLY_LINK_BY_X_T' => 'Aloittanut %s.  Viimeksi <a %s>vastannut</a> %s %s.',
        'STARTED_DISCUSSION_LAST_REPLY_LINK_BY_X_T' => '<strong>Aloitti tämän keskustelun. </strong> Viimeksi <a %s>vastannut</a>  %s %s.',
        'STARTED_DISCUSSION_T' => '<strong>Aloitti tämän keskustelun</strong> %s',
        'ADDED_REPLY_T' => '<strong>Lisäsi vastauksen</strong> %s',
        'ADDED_POST_T' => '<strong>Lisäsi artikkelin</strong> %s',
        'STARTED_BY_X_ON' => 'Aloittanut %s %s',
        'STARTED_DISCUSSION_ON' => '<strong>Aloitti tämän keskustelun</strong> %s',
        'STARTED_ON' => '<strong>Aloitti</strong> %s',
        'ADDED_REPLY_ON' => '<strong>Lisäsi vastauksen</strong> %s',
        'ADDED_POST_ON' => '<strong>Lisäsi artikkelin</strong> %s',
        'XS_DISCUSSIONS' => '%s:n keskustelut',
        'XS_DISCUSSIONS_LOWERCASE' => '%s:n keskustelut',
        'VIEW_XS_DISCUSSIONS' => 'Näytä %s:n keskustelut',
        'VIEW_YOUR_DISCUSSIONS' => 'Näytä omat keskustelusi',
        'TAGGED_X' => 'Tagi: %s',
        'SUBSCRIBE_TO_DISCUSSIONS' => 'Tilaa nämä keskustelut',
        'SUBSCRIBE_TO_DISCUSSION' => 'Tilaa tämä keskustelu',
        'SUBSCRIBE_TO_XS_DISCUSSIONS' => 'Tilaa %s:n keskustelut',
        'ALL_DISCUSSIONS_TAGGED_X' => 'Kaikki keskustelut joissa tagi <em>\'%s\'</em>',
        'SUBSCRIBE_TO_DISCUSSIONS_TAGGED_X' => 'Tilaa keskustelut joissa tagi \'%s\'',
        'N_KB' => '%s KB',
        'N_MB' => '%s MB',
        'UPLOADING_FILES' => 'Ladataan tiedostoja',
        'ATTACHMENTS' => 'Liitteet',
        'YOUR_POST' => 'Artikkelisi:',
        'YOUR_REPLY' => 'Vastauksesi:',
        'WOULD_YOU_LIKE_TO_UPLOAD_FILES' => 'Haluatko ladata tiedostoja tänne?',
        'ADD_YOUR_REPLY' => 'Lisää vastauksesi',
        'REPLIES_TO_THIS_DISCUSSION' => 'Vastaukset tähän keskusteluun',
        'POSTED_BY_X_ON' => 'Liittänyt %s %s',
        'PLEASE_ENTER_TITLE' => 'Anna keskustelulle nimi',
        'PLEASE_ENTER_FIRST_POST' => 'Kirjoita keskustelun ensimmäinen artikkeli.',
        'REPLY_TO_THIS' => 'Vastaa tähän',
        'DELETE_ATTACHMENT' => 'Poista liite',
        'DELETE_ATTACHMENT_Q' => 'Poistetaanko tämä liite?',
        'DELETE_REPLY' => 'Poista vastaus',
        'DELETE_THIS_DISCUSSION_Q' => 'Poistetaanko tämä keskustelu?',
        'ARE_YOU_SURE_DELETE_THIS_DISCUSSION' => 'Are you sure you want to delete this discussion (including all replies)?  Käsittely voi kestää muutaman minuutin.',
        'DELETE_DISCUSSION' => 'Delete Discussion',
        'NOBODY_HAS_ADDED_DISCUSSIONS' => 'Nobody has added any discussions yet.',
        'NOBODY_HAS_ADDED_DISCUSSIONS_ADD' => 'Nobody has added any discussions yet!  Add a discussion to get started.',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS' => 'You haven\'t added any discussions yet.  Add a discussion to get started!',
        'YOU_HAVE_NOT_STARTED_DISCUSSIONS' => 'You haven\'t started any discussions yet.',
        'YOU_HAVE_NOT_ADDED_TO_DISCUSSIONS' => 'You haven\'t added to any discussions yet.',
        'X_HAS_NOT_ADDED_DISCUSSIONS' => '%s hasn\'t added any discussions yet.',
        'X_HAS_NOT_STARTED_DISCUSSIONS' => '%s hasn\'t started any discussions yet.',
        'X_HAS_NOT_ADDED_TO_DISCUSSIONS' => '%s hasn\'t added to any discussions yet.',
        'VIEW_DISCUSSIONS' => 'View Discussions',
        'VIEW_ALL_PEOPLE_ON_X' => 'View All People on %s',
        'THERE_ARE_NO_DISCUSSIONS' => 'There are currently no discussions on your network.',
        'GROUP_HAS_NO_DISCUSSIONS' => 'This group does not have any discussions yet.',
        'VIEW_DISCUSSIONS_IN_GROUP_FORUM' => 'View discussions in the <a %s>%s forum</a>!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT_ADD' => 'Ei ole keskusteluja, joissa olisi tagi "%1$s".  Katso <a %2$s>kuvat joissa tagi "%1$s"</a> tai <a %3$s>videot joissa tagi "%1$s"</a>.  Tai lisää ja merkitse omat keskustelusi!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT' => 'Ei ole keskusteluja, joissa olisi tagi "%1$s".  Katso <a %2$s>kuvat joissa tagi "%1$s"</a> tai <a %3$s>videot joissa tagi "%1$s"</a>.',
        'THIS_BOX_WILL_NOT_SHOW_DISCUSSIONS' => 'Tämä laatikko ei näy muille, ennen kuin on näytettäviä keskusteluja.  Voit aloittaa keskustelun!',
        'DISCUSSIONS_I_STARTED' => 'Aloittamani keskustelut',
        'DISCUSSIONS_X_STARTED' => '%s:n aloittamat keskustelut',
        'DISCUSSIONS_I_REPLIED_TO' => 'Keskustelut joihin olen vastannut',
        'DISCUSSIONS_X_REPLIED_TO' => 'Keskustelut joihin %s on vastannut',
        'PLEASE_WRITE_SOMETHING_FOR_POST' => 'Kirjoita jotain artikkeliisi.',
        'PLEASE_WRITE_SOMETHING_FOR_REPLY' => 'Kirjoita jotain vastaukseesi.',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION_X' => 'Keskusteluusi "%s" on uusi kommentti täällä: %s',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION' => 'Johonkin keskusteluusi on uusi kommentti täällä: %s',
        'SOMEBODY_COMMENTED_DISCUSSION_ADDED_TO_X' => 'joku on kommentoinut täällä aloittamaasi keskustelua: %s',
        'ABOUT_YOUR_DISCUSSION' => 'Tietoa keskustelustasi',
        'ABOUT_THIS_DISCUSSION' => 'Tietoa tästä keskustelusta',
        'USER_REPLIED_TO_A_DISCUSSION_ON_Y' => '%s vastasi keskusteluun täällä: %s',
        'USER_REPLIED_TO_DISCUSSION_TITLE_ON_APPNAME' => '%s vastasi keskusteluun "%s" täällä: %s',
        'PROBLEM_WITH_ICON' => 'Kuvaketiedostossa ilmeni jokin ongelma',
        'GROUP_ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Ryhmän ylläpitäjillä on vastaavat hallintaoikeudet kuin ryhmän perustajalla.',
        'CREATE_NEW_GROUP' => 'Perusta uusi ryhmä',
        'CREATE_A_NEW_GROUP' => 'Perusta uusi ryhmä',
        'CREATE_A_GROUP' => 'Perusta ryhmä',
        'VIEW_GROUPS' => 'Näytä ryhmät',
        'CREATE_GROUP' => 'Perusta ryhmä',
        'PLEASE_ENTER_NAME_FOR_GROUP' => 'Anna ryhmällesi nimi.',
        'PLEASE_ENTER_URL_FOR_GROUP' => 'Valitse ryhmällesi verkko-osoite..',
        'URL_CAN_CONTAIN_ONLY_LETTERS' => 'URI voi sisältää vain kirjaimia ja numeroita (ei välilyöntejä).',
        'NAME_TAKEN' => 'Valitsemasi nimi on jo valitettavasti käytössä.  Valitse toinen nimi.',
        'URL_TAKEN' => 'Valitsemasi URI on jo käytössä.  Valitse toinen URI.',
        'GROUP_INFORMATION' => 'Ryhmän tiedot',
        'EXTERNAL_WEBSITE' => 'Ulkoinen internetsivu',
        'DO_YOU_HAVE_EXISTING_WEBSITE' => 'Onko sinulla jo ryhmäsivusto jossakin muualla internetissä?',
        'URL' => 'URL',
        'GROUPS' => 'Ryhmät',
        'SEARCH_GROUPS' => 'Etsi ryhmistä',
        'NOBODY_HAS_CREATED_GROUPS' => 'Ryhmiä ei ole vielä perustettu.',
        'NOBODY_HAS_CREATED_GROUPS_ADD' => 'Ryhmiä ei ole vielä perustettu!  Aloita perustamalla ryhmä.',
        'MY_GROUPS' => 'Omat ryhmäni',
        'FEATURED_GROUPS' => 'Suositellut ryhmät',
        'YOU_CAN_CREATE_GROUP' => 'Voit <a %s>perustaa uuden ryhmän</a> tänne: %s!',
        'GROUP_FORUM' => '%s-foorumi',
        'USER_CREATED_GROUP' => '%s on perustanut tämän ryhmän täällä: %s.',
        'GROUP_MEMBERS_COUNT' => '%s jäsentä (%d)',
        'WE_ARE_SORRY_NOT_ALLOWED_JOIN_GROUP' => 'Valitettavasti et voi liittyä tähän ryhmään.',
        'JOIN_GROUP_NOW' => 'Liity nyt tänne: %s!',
        'USER_HAS_INVITED_YOU_TO_JOIN_GROUP' => '%s on kutsunut sinut liittymään tänne: %s',
        'DECLINE' => 'Hylkää',
        'WELCOME_TO_GROUP' => 'Tervetuloa %s',
        'YOU_CAN_PARTICIPATE_IN_GROUP' => 'Voit nyt osallistua %s-foorumin toimintaan.',
        'SEND_MESSAGE_TO_GROUP' => 'Lähetä viesti ryhmään',
        'LEAVE_THIS_GROUP' => 'Lähde ryhmästä',
        'EDIT_GROUP_INFO' => 'Muokkaa tämän ryhmän tietoja',
        'EDIT_GROUP_INFORMATION' => 'Muokkaa ryhmän tietoja',
        'MANAGE_GROUP_MEMBERS' => 'Hallinnoi ryhmän jäseniä',
        'GROUP_HAS_NO_MEMBERS' => 'Tässä ryhmässä ei ole vielä jäseniä!',
        'GROUP_HAS_NO_MEMBERS_THAT_MATCH' => 'Tässä ryhmässä ei ole hakuasi vastaavia jäseniä.',
        'USERS_GROUPS' => '%s:n ryhmät',
        'YOU_HAVE_NOT_CREATED_GROUPS' => 'Et ole vielä perustanut ryhmiä.',
        'USER_HAS_NOT_CREATED_GROUPS' => '%s ei ole vielä perustanut ryhmiä.',
        'THERE_ARE_NO_FEATURED_GROUPS' => 'Yhteisössäsi ei ole suositeltuja ryhmiä.',
        'START_FEATURING_GROUPS' => 'Aloita ryhmien suosittelu Suosittele-valinnasta.  Jos haluat lisätietoa suosittelusta, <a %s>napsauta tästä</a>.',
        'NO_GROUPS_TO_DISPLAY' => 'Tällä hetkellä ryhmiä ei näytetä.',
        'BOX_WILL_NOT_SHOW_GROUPS' => 'Tämä laatikko ei näy muille, ellet valitse vähintään yhtä ryhmää.',
        'YOU_HAVE_NOT_CREATED_GROUPS_2' => 'Et ole vielä perustanut ryhmiä!',
        'CREATE_GROUPS_AND_SHARE' => 'Perusta ryhmä ja jaa se ystäviesi, sukulaistesi tai kaikkien muiden kanssa!',
        'THERE_ARE_NO_GROUPS' => 'Tällä hetkellä yhteisössäsi ei ole ryhmiä.',
        'THIS_BOX_WILL_NOT_SHOW_GROUPS' => 'Tämä laatikko ei näy muille, ennen kuin on näytettäviä ryhmiä.  Voit perustaa ryhmän!',
        'GROUPS_MATCHING_SEARCH_TERM' => 'Hakua <em>\'%s\'</em> vastaavat ryhmät',
        'WE_COULD_NOT_FIND_ANY_GROUPS' => 'Valitettavasti hakuasi vastaavia ryhmiä ei löytynyt.',
        'VIEW_GROUPS_OR_CREATE_GROUP' => '<a %s>Näytä kaikki ryhmät</a> tai <a %s>perusta uusi ryhmä</a>',
        'VIEW_ALL_GROUPS' => 'Näytä kaikki ryhmät',
        'DELETE_GROUP' => 'Poista ryhmä',
        'DELETE_GROUP_Q' => 'Haluatko varmasti poistaa tämän ryhmän?',
        'GROUP_INVITATIONS' => 'Ryhmäkutsut',
        'YOU_HAVE_BEEN_INVITED_TO_JOIN' => 'Sinut on kutsuttu liittymään tänne:',
        'VISIT' => 'Vieraile',
        'WHO_CAN_JOIN_GROUP' => 'Ketkä voivat liittyä tähän ryhmään?',
        'PRIVACY_CANNOT_BE_CHANGED' => 'Yksityisyysvalintoja ei voi muuttaa ryhmän perustamisen jälkeen.',
        'ONLY_INVITED_PEOPLE' => 'Vain kutsutut',
        'ALLOW_PEOPLE_TO_REQUEST' => 'Salli kutsun pyytäminen',
        'ANYONE_CAN_JOIN_GROUP' => 'Kaikki voivat liittyä tähän ryhmään',
        'ONLY_INVITED_PEOPLE_CAN_JOIN_GROUP' => 'Vain kutsutut voivat liittyä tähän ryhmään',
        'WHY_NOT_CREATE_GROUP' => 'Voit <a %s>perustaa oman ryhmän</a>!',
        'PLEASE_ENTER_NAME' => 'Anna nimesi',
        'PLEASE_ENTER_EMAIL_ADDRESS' => 'Anna sähköpostiosoitteesi.',
        'PLEASE_ENTER_PAGE_ADDRESS' => 'Anna uusi sivun osoite.',
        'PLEASE_ENTER_PASSWORD' => 'Anna salasanasi.',
        'CREATE_ACCOUNT_OR_SIGN_IN' => '<a %s>Perusta käyttäjätili napsauttamalla tästä</a> tai yritä kirjautua uudelleen.',
        'CREATE_ACCOUNT_OR_JOIN' => '<a %s> Perusta käyttäjätili napsauttamalla tästä</a> tai yritä liittyä Ning-tunnuksellasi uudelleen.',
        'CHOOSE_SHORTER_PASSWORD' => 'Valitse lyhyempi salasana.',
        'CHOOSE_SHORTER_NAME' => 'Valitse lyhyempi nimi.',
        'ENTER_SHORTER_CITY_NAME' => 'Anna lyhyempi kaupungin nimi.',
        'PLEASE_ENTER_PASSWORD_AGAIN' => 'Kirjoita salasanasi uudelleen "Anna salasana uudelleen" laatikkoon.',
        'PLEASE_ENTER_CURRENT_PASSWORD' => 'Anna nykyinen salasanasi.',
        'PLEASE_ENTER_NEW_PASSWORD' => 'Anna uusi salasanasi.',
        'PLEASE_ENTER_NEW_PASSWORD_AGAIN' => 'Kirjoita uusi salasanasi "Vahvista salasana" laatikkoon.',
        'CURRENT_PASSWORD' => 'Nykyinen salasana',
        'PASSWORDS_DO_NOT_MATCH' => 'Salasanat eivät vastaa toisiaan.',
        'NEW_AND_CONFIRMATION_PASSWORDS' => 'Uusi salasana ja vahvistus eivät vastaa toisiaan.',
        'YOUR_REQUEST_HAS_BEEN_SENT_TO_GROUP_CREATOR' => 'Pyyntösi on lähetetty ryhmän perustajalle.',
        'X_IS_NOT_VALID_EMAIL_ADDRESS' => '%s ei ole oikea sähköpostiosoite',
        'COME_JOIN_ME_ON_GROUP' => 'Liity seuraani verkostossa %s!',
        'INVITE_PEOPLE_TO_GROUP' => 'Kutsu ihmisiä tänne: %s',
        'INVITE_FRIENDS_TO_GROUP' => 'Kutsu ystäviä tänne: %s',
        'SEND_INVITATIONS_TO_JOIN_GROUP' => 'Lähetä muille kutsuja liittyä tänne: %s.',
        'GROUPNAME_MEMBERS' => '%s:n jäsenet',
        'GROUP_CREATOR' => 'Ryhmän perustaja',
        'GROUP_ADMINISTRATOR' => 'Ryhmän ylläpitäjä',
        'DATE_BANNED' => 'Porttikiellon päivämäärä',
        'BAN_FROM_GROUP' => 'Anna porttikielto ryhmään',
        'ARE_YOU_SURE_BAN_MEMBER_FROM_GROUP' => 'Haluatko varmasti antaa valitsemillesi jäsenille porttikiellon ryhmään?  Käsittely voi kestää muutaman minuutin.',
        'ALSO_DELETE_FORUM_POSTINGS' => 'Poista myös heidän artiikkelinsa ja vastauksensa foorumilta.',
        'GROUP_WEB_ADDRESS' => 'Ryhmän internet-osoite',
        'GROUP' => 'Ryhmä',
        'BACK_TO_GROUP' => '← Takaisin tänne: %s',
        'USER_BANNED_FROM_GROUP' => '%1$s on saanut porttikiellon tähän ryhmään.  <a %2$s>Lähetä %1$s viesti</a>',
        'USER_ALREADY_GROUP_MEMBER' => '%1$s on jo tämän ryhmän jäsen.  <a %2$s>Lähetä %1$s viesti</a>',
        'GROUP_ADMIN_DISCUSSIONS' => 'Ryhmän ylläpitäjän keskustelut',
        'BACK_TO_NETWORK_GROUPS' => 'Takaisin %s-ryhmiin',
        'MOST_MEMBERS' => 'Eniten jäseniä',
        'THIS_SETS_URL_OF_GROUP' => 'Tällä asetaan ryhmällesi URL:<br />http://%s/<strong>groupwebaddress</strong>',
        'LIKE_WHAT_YOU_SEE' => 'Näyttääkö %s hyvältä?  Liity nyt!',
        'LIKE_WHAT_YOU_SEE_GROUP' => 'Näyttääkö %s hyvältä?  Liity nyt!',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => 'Olet perustanut ryhmän %1$s. Voit aloittaa keskustelun %1$s-foorumilla tai kutsua lisää ihmisiä liittymään.',
        'YOU_ARE_MEMBER_OF_GROUP_AND_CAN_INVITE' => 'Olet nyt %1$s:n jäsen.  Voit osallistua %1$s-foorumin toimintaan tai kutsua lisää ihmisiä liittymään.',
        'NETWORK_DOES_NOT_HAVE_MUSIC' => 'Tässä verkostossa ei ole vielä musiikkia.',
        'PERSON_DOES_NOT_HAVE_MUSIC' => 'Tällä henkilöllä ei ole vielä musiikkia.',
        'FIND_MORE_MUSIC_LIKE_THIS' => 'Etsi samanlaista musiikkia täältä: <em>%s</em>',
        'TRACKS' => 'Kappaleet',
        'ADD_MUSIC_TRACKS' => 'Lisää musiikkia',
        'CHOOSE_MUSIC_TRACKS' => 'Valitse lisättävät kappaleet',
        'YOU_CAN_ADD_UP_TO_MP3' => 'Voit lisätä kerralla korkeintaan 4 MP3-tiedostoa.',
        'UPLOAD_TRACKS' => 'Lataa kappaleita',
        'ADD_TRACKS' => 'Lisää kappaleita',
        'ENTER_THE_URL_MP3_TO_ADD' => 'Anna URL jokaiselle MP3:lle jonka haluat lisätä:',
        'EACH_MP3_FILE_MAY_BE_UP_TO' => 'Voit ladata tänne jopa 100 MP3-tiedostoa!  MP3-tiedosto saa olla korkeintaan 20 Mt:n kokoinen, mutta pienemmät latautuvat nopeammin.',
        'BE_NICE' => 'Ole kiltti',
        'PLEASE_UPLOAD_ONLY_TRACKS' => 'Lataa kappaleita vain, jos sinulla on esittäjän tai tekijänoikeuden haltijan lupa siihen.',
        'PLEASE_LINK_ONLY_TRACKS' => 'Linkitä vain musiikkiin, jonka jakelu internetissä on oikeutettu.',
        'MORE_WAY_TO_ADD_MUSIC' => 'Muita tapoja lisätä musiikkia...',
        'ELLIP_FROM_ANOTHER_WEBSITE' => '…toiselta internet-sivulta',
        'ADD_MUSIC_FROM_ANY_WEBSITE' => 'Lisää musiikkia internetistä liittämällä linkki MP3-tiedostoon.',
        'KEEP_PAGE_OPEN_MUSIC' => 'Pidä tämä sivu auki, jotta saamme kappaleet ladattua! Kerromme kun ne on hyväksytty.',
        'MEANWHILE_FEEL_FREE_MUSIC' => 'Sillä aikaa voit vapaasti <a %s>avata uuden ikkunan</a> ja jatkaa %s:n selaamista.  Kun lataus on valmis, voit lisätä kappaleisiisi nimen ja kuvauksen tässä ikkunassa.',
        'TRACKS_EXCEEDED_LIMIT' => 'Kokoraja (10 Mt/kappale) näyttää ylittyneen.',
        'EDIT_TRACK_INFORMATION' => 'Muokkaa kappaleen tietoja.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_1' => 'Lisää juuri lataamillesi kappaleille nimi, kuvaus ja muita tietoja.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_2' => 'Lisää tälle kappaleelle nimi, kuvaus ja muita tietoja.',
        'CANCEL_AND_RETURN_TO_PLAYLIST' => '<< Peruuta ja palaa soittolistaan',
        'TRACK_TITLE' => 'Kappaleen nimi',
        'TRACK_ARTIST' => 'Esittäjä',
        'TRACK_ALBUM' => 'Levy',
        'ENABLE_DOWNLOAD_LINK' => 'Ota käyttöön latauslinkki',
        'ALLOW_PEOPLE_TO_ADD_TRACK_TO_PROFILE' => 'Salli ihmisten laittaa tämä kappale sivuilleen',
        'TRACK_ARTWORK' => 'Kuvitus',
        'EDIT_PLAYLIST' => 'Muokkaa soittoluetteloa',
        'DRAG_TO_CHANGE_ORDER_PLAYLIST' => 'Voit järjestää soittoluetteloa napsauttamalla kappaletta ja vetämällä sen haluamaasi kohtaan.',
        'ADD_MUSIC_ELLIPSIS' => 'Lisää musiikkia…',
        'ELLIPSIS_FROM_YOUR_COMPUTER' => '…omalta tietokoneeltasi',
        'UPLOAD_MP3_FROM_YOUR_COMPUTER' => 'Lataa MP3-tiedostoja tietokoneeltasi.',
        'DELETE_THIS_TRACK_Q' => 'Poistetaanko kappale?',
        'DELETE_TRACK' => 'Poista kappale',
        'ARE_YOU_SURE_DELETE_THIS_TRACK' => 'Haluatko varmasti poistaa tämän kappaleen?',
        'PLAY' => 'toistaa',
        'GENRE' => 'Tyylilaji',
        'YEAR' => 'Vuosi',
        'LABEL' => 'Luokitus',
        'EXPLICIT_LYRICS' => 'Explicit Lyrics',
        'ARTIST_SITE' => 'Esittäjän sivut',
        'HOSTING_SITE' => 'Palveluntarjoajan sivut',
        'LABEL_SITE' => 'Luokituksen sivut',
        'LICENSE' => 'Lisenssi',
        'SELECT_LICENSE' => 'Select license',
        'LICENSE_NAME' => 'Lisenssin nimi',
        'LICENSE_URL' => 'Lisenssin URL',
        'MUSIC' => 'Musiikki',
        'ALLOW_PEOPLE_TO_UPLOAD_AND_SHARE_AUDIO' => 'Salli äänitteiden lataaminen tänne ja niiden jakaminen',
        'PLAYLIST' => 'Soittoluettelo',
        'PODCAST' => 'Podcast',
        'MOST_RECENT_TRACKS' => 'Uusin',
        'FEATURED_TRACKS' => 'Ominaisuudet',
        'HIGHEST_RATED_TRACKS' => 'Korkein arvosana',
        'NO_TRACKS_TO_PLAY' => 'Tällä hetkellä verkostossasi ei ole musiikkia.',
        'BOX_WILL_NOT_SHOW_TRACKS' => 'Tämä laatikko ei näy muille, ennen kuin on soitettavia kappaleita tai podcasteja.  Miksi et lisäisi yhtä?',
        'NO_TRACKS_ON_PLAYLIST' => 'Tällä hetkellä tässä soittoluettelossa ei ole kappaleita.',
        'PLAYER_WILL_NOT_SHOW_TRACKS' => 'Tämä soitin ei näy muille, ennen kuin on soitettavia kappaleita tai podcasteja.  Miksi et lisäisi yhtä?',
        'NO_FEATURED_TRACKS' => 'Verkostossasi ei ole suositeltuja kappaleita.',
        'START_FEATURING_TRACKS' => 'Aloita suosittelu, kun kuulet kappaleen jonka haluaisit näkyvän pääsivulla.',
        'VIEW_MUSICPLAYER' => 'Näytä musiikkisoitin',
        'MY_PLAYLIST' => 'Oma soittoluetteloni',
        'NETWORK_PLAYLIST' => 'Verkoston soittoluettelo',
        'COPYRIGHT' => '© Kaikki oikeudet pidätetään',
        'CC_BY_X' => 'Creative Commons lisenssi %s',
        'CC_BY_SA_X' => 'Creative Commons lisenssi Sama lisenssi %s',
        'CC_BY_ND_X' => 'Creative Commons lisenssi Ei jälkiperäisiä %s',
        'CC_BY_NC_X' => 'Creative Commons lisenssi Ei kaupalliseen käyttöön %s',
        'CC_BY_NC_SA_X' => 'Creative Commons lisenssi Ei kaupalliseen käyttöön ja Sama lisenssi %s',
        'CC_BY_NC_ND_X' => 'Creative Commons lisenssi Ei kaupalliseen käyttöön ja Ei jälkiperäisiä %s',
        'PUBLICDOMAIN' => 'Julkinen alue',
        'FACEBOOK_CONFIRM_DISABLE' => 'Oletko varma?',
        'FACEBOOK_PLAYER_DISABLE' => 'Poista käytöstä',
        'FACEBOOK_MUSIC_PLAYER_TITLE' => 'Musiikkisoitin',
        'FACEBOOK_MUSIC_PLAYER_DESC' => 'Salli kenen tahansa lisätä Facebook-profiilisivulleen sovellus, joka soittaa valitsemaasi musiikkia.',
        'FACEBOOK_MUSIC_BUTTON' => 'Luo musiikkisovellus &raquo;',
        'FACEBOOK_MUSIC_PLAYER_ENABLED' => 'Facebookin musiikkisoitin on jo käytössä.',
        'FACEBOOK_VIDEO_PLAYER_TITLE' => 'Videosoitin',
        'FACEBOOK_VIDEO_PLAYER_DESC' => 'Salli kenen tahansa lisätä Facebook-profiilisivulleen sovellus, joka näyttää videon verkostostasi.',
        'FACEBOOK_VIDEO_BUTTON' => 'Luo videosovellus &raquo;',
        'FACEBOOK_VIDEO_PLAYER_ENABLED' => 'Facebookin videosoitin on jo käytössä.',
        'FACEBOOK_SLIDESHOW_PLAYER_TITLE' => 'Kuvaesitys',
        'FACEBOOK_SLIDESHOW_PLAYER_DESC' => 'Salli kenen tahansa lisätä Facebook-profiilisivulleen sovellus, joka näyttää valokuvia diaesityksenä verkostostasi.',
        'FACEBOOK_SLIDESHOW_BUTTON' => 'Luo valokuvien diaesityssovellus &raquo;',
        'FACEBOOK_SLIDESHOW_PLAYER_ENABLED' => 'Facebookin valokuvien diaesitys on jo käytössä.',
        'FACEBOOK_PLATFORM_LOGO' => 'Facebookin käyttötason logo',
        'FACEBOOK_QUICK_INTRO_1' => 'Suosittu yhteisösivusto Facebook sallii kolmannen osapuolen kehittäjien luoda sovelluksia, joita voidaan lisätä Facebookin jäsenten profiilisivuille.  Nämä sovellukset tarjoavat lisätoiminnallisuuksia profiilisivuille, ja lisäksi niitä voidaan käyttää viemään Facebookin käyttäjiä muihin internetkohteisiin.',
        'FACEBOOK_QUICK_INTRO_2' => 'Kun käytät Ningiä, sinun ei tarvitse olla kehittäjä markkinoidaksesi yhteisöäsi Facebookissa.  Olemme tehneet työn puolestasi, ja Facebook-sovellusten integrointi on verkostossasi valmiina.  Valitse alla olevista vaihtoehdoista, ja muutaman sekunnin kuluttua verkostosi on integroitu Facebookin kanssa.',
        'FACEBOOK_ADD_DEVELOPER_BUTTON' => 'Lisää kehittäjä painike',
        'FACEBOOK_SETUP_NEW_APP_BUTTON' => 'Asenna uusi sovellus painike',
        'FACEBOOK_YOUR_APPLICATIONS' => 'Facebook-sovelluksesi',
        'FACEBOOK_EMBEDDING' => 'Facebook-markkinointi',
        'FACEBOOK_SETUP' => 'Facebook-markkinointi',
        'FACEBOOK_PROMOTING' => 'Sovellusten markkinointi Facebookissa',
        'FACEBOOK_VIEW_APP' => 'Näytä sovellus',
        'FACEBOOK_ADD_THE' => 'Lisää',
        'FACEBOOK_RECENT' => 'Uusin',
        'FACEBOOK_RECENTLY_FEATURED' => 'Viimeksi suositeltu',
        'FACEBOOK_RECENTLY_ADDED' => 'Viimeksi lisätty',
        'FACEBOOK_PROMOTED' => 'Ominaisuudet',
        'FACEBOOK_RATED' => 'Korkein arvosana',
        'FACEBOOK_POPULAR' => 'Suosittu',
        'FACEBOOK_MUSIC_WIDGET' => 'Musiikkivimpain',
        'FACEBOOK_VIDEO_WIDGET' => 'Videovimpain',
        'FACEBOOK_PHOTO_WIDGET' => 'Kuvavimpain',
        'FACEBOOK_INSTR_FIRST_STEPS' => 'Aloitus',
        'FACEBOOK_INSTR_CLICK_HERE_TO_GO_TO_FACEBOOK' => 'Tästä napsauttamalla pääset Facebookiin ja voit aloittaa sovelluksen luomisen.',
        'FACEBOOK_INSTR_OPEN_FACEBOOK_IN_NEW_WINDOW' => 'Tästä Facebook avautuu uuteen ikkunaan.  Jollet ole vielä kirjautunut Facebookiin, kirjaudu nyt.',
        'FACEBOOK_INSTR_FIRST_STEPS_1' => 'Jollet ole vielä luonut sovellusta Facebookiin, sinua pyydetään lisäämään Facebookin kehittäjäsovellus.  Kun olet valmis, näet tekstin "Ei sovelluksia ". Napsauta <strong>Luo sovellus</strong>.',
        'FACEBOOK_INSTR_FIRST_STEPS_2' => 'Jos olet jo luonut sovelluksen Facebookiin, päädyt Facebookin kehittäjäsovellukseen.  Napsauta <strong> Asenna uusi sovellus </strong> painiketta.',
        'FACEBOOK_INSTR_FIRST_STEPS_NEXT' => 'Seuraavaksi: ohjeet %s-sovelluksesi asentamiseen Facebookin kanssa toimivaksi.',
        'FACEBOOK_INSTR_SETUP' => 'Asennusohjeet',
        'FACEBOOK_INSTR_SETUP_1' => 'Hyvä!  Nyt tietoihin.  Facebook tarvitsee joitakin perustietoja saadakseen sovelluksesi käyttöön.  Seuraa alla olevia ohjeita.',
        'FACEBOOK_INSTR_SETUP_REQ_FIELDS' => 'Vaaditut kentät',
        'FACEBOOK_INSTR_SETUP_2' => 'Valitse <strong>sovelluksen nimi</strong>.',
        'FACEBOOK_INSTR_SETUP_3' => 'Valitse tämä merkiksi että olet lukenut Facebookin ehdot.',
        'FACEBOOK_INSTR_SETUP_4' => 'Avaa <em>Valinnaiset kentät</em> osio.',
        'FACEBOOK_INSTR_SETUP_BASE_OPT' => 'Pohjavalinnat',
        'FACEBOOK_INSTR_SETUP_5' => 'Laita sähköpostiosoitteesi <strong>Tuen sähköposti</strong> kenttään.',
        'FACEBOOK_INSTR_SETUP_6' => 'Liitä seuraava internet-osoite <strong>Callback URL</strong> kenttään:',
        'FACEBOOK_INSTR_SETUP_7_EXAMPLE_X' => 'Valitse <strong>pohjasivun URL</strong> (esim. <em>%s</em>).',
        'FACEBOOK_INSTR_SETUP_8' => 'Valitse <strong>Kyllä</strong> kohdassa <em>Voidaanko sovelluksesi lisätä Facebookiin</em>.',
        'FACEBOOK_INSTR_SETUP_INST_OPT' => 'Asennuksen asetukset',
        'FACEBOOK_INSTR_SETUP_APP_DESC' => 'Kirjoita <strong>sovelluksen kuvaus</strong>.',
        'FACEBOOK_INSTR_SETUP_9' => 'Liitä seuraava koodi <strong>Oletus-FBML</strong> kenttään:',
        'FACEBOOK_INSTR_SETUP_9B_WIDE' => 'Kohdassa <strong>Oletussarake profiililaatikossa</strong> valitse <strong>leveä</strong>.',
        'FACEBOOK_INSTR_SETUP_9B_NARROW' => 'Kohdassa <strong>Oletussarake profiililaatikossa</strong> valitse <strong>kapea</strong>.',
        'FACEBOOK_INSTR_SETUP_10' => 'Kirjoita <strong>Side Nav URL</strong> kenttään <em>pohjasivun URL</em> (luotu kohdassa &#8216; f&#8217;  yllä).  Tarkista että sisällytät URLin osan http://apps.facebook.com/.',
        'FACEBOOK_INSTR_SETUP_11' => 'Kirjoita teksti kohtaan <strong>liitteiden toimenpiteet</strong>.  Tämä ilmestyy, jos lähetät jollekulle viestin Facebookissa ja haluat lisätä jonkin sovelluksesi viestiin.  Jos sovelluksesi on valokuvien diaesitys, voit kirjoittaa vaikka Kuvia Verkostonimestä.  Jos sovelluksesi on videosoitin, voit kirjoittaa vaikka Videoita Verkostonimestä.',
        'FACEBOOK_INSTR_SETUP_12' => 'Liitä seuraava internet-osoite <strong>Callback URL</strong> kenttään:',
        'FACEBOOK_INSTR_APPLICATION_SETUP_PAGE' => 'Facebook-sovelluksen asennussivu',
        'FACEBOOK_INSTR_SETUP_DONE' => 'Kun olet valmis, napsauta <strong>Lähetä</strong>-painiketta.',
        'FACEBOOK_INSTR_SETUP_NEXT' => 'Seuraavaksi: API-avaimen ja salaisuuden haku.',
        'FACEBOOK_API_INFO_TITLE' => 'Facebookin API-tiedot',
        'FACEBOOK_API_INFO_DESC' => 'Jotta asennus saadaan valmiiksi, kirjoita API-avaimesi ja salaisuutesi sekä sovelluksesi URL alla oleviin kenttiin.',
        'FACEBOOK_API_INFO_FIND_KEY' => 'API-avaimesi ja salaisuutesi löydät<a %s>Omat sovellukseni sivulta Facebookista</a> (avautuu uuteen ikkunaan) juuri luomasi sovelluksen nimen alta.',
        'FACEBOOK_API_INFO_MY_APPLICATIONS_PAGE' => 'Omat sovellukseni sivu (korostaa API-tietojen sijainnin)',
        'FACEBOOK_API_INFO_KEY' => 'API-avain',
        'FACEBOOK_API_INFO_SECRET' => 'API-salaisuus',
        'FACEBOOK_URL_INFO_TITLE' => 'Facebookin sovelluksen URL',
        'FACEBOOK_URL_INFO_DESC' => 'Sovelluksen URL on sama kuin <strong>pohjasivun URL</strong> jonka määrittelit edellisellä sivulla (kohdassa &#8216; f&#8217; ).',
        'FACEBOOK_MUSIC_SHOULD_PLAY_FROM' => 'Facebookin musiikkisovellusten pitää soittaa:',
        'FACEBOOK_VIDEO_SHOULD_PLAY_FROM' => 'Facebookin videosovellusten pitää näyttää videota joka on:',
        'FACEBOOK_PHOTO_SHOULD_PLAY_FROM' => 'Facebookin diaesityssovellusten pitää näyttää kuvia täältä:',
        'FACEBOOK_PROMOTING_ON' => 'Markkinointi Facebookissa',
        'FACEBOOK_SETUP_INSTR' => 'Asennusohjeet',
        'FACEBOOK_API_INFO' => 'API-tiedot',
        'FACEBOOK_DISABLE' => 'Poista tämä sovellus käytöstä',
        'FACEBOOK_TO_YOUR_FACEBOOK_PROFILE' => 'Facebook-profiiliisi',
        'FACEBOOK_BACK_TO_EMBEDDING' => 'Takaisin Facebook-markkinointiin',
        'FACEBOOK_EMBEDDING_DESC' => 'Salli Facebookin käyttäjien laittaa verkostosi vimpaimia ja merkkejä profiilisivuilleen.',
        'FACEBOOK_PROMOTE' => 'Jotta saisit täydet tehot irti uuden sovelluksesi markkinoinnista, suosittelemme toimimaan seuraavasti.  Kaikkiin näihin asetuksiin pääsee Facebookin <strong><a %s>Omat sovellukseni</a></strong> sivulta (linkki avautuu uuteen ikkunaan).',
        'FACEBOOK_PROMOTE_TITLE_ABOUT_PAGE' => 'Tee Tietoja-sivu',
        'FACEBOOK_PROMOTE_TEXT_ABOUT_PAGE' => 'Kerro Facebookin käyttäjille sovelluksestasi selkeällä kuvauksella.  Voit muokata tietoja napsauttamalla määrittelemäsi sovelluksen vieressä olevaa <strong>Muokkaa Tietoja-sivua</strong> linkkiä.',
        'FACEBOOK_PROMOTE_TITLE_SUBMIT' => 'Lähetä sovellus Facebookin hakemistoon',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_1' => 'Levitä sanaa uudesta sovelluksestasi lisäämällä se Facebookin hakemistoon.',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_2' => 'Voit lähettää sovelluksesi napsauttamalla määrittelemäsi sovelluksen vieressä olevaa <strong>Lähetä sovellus</strong> linkkiä.  Seuraavalla sivulla voit muokata sovelluksen kuvausta ja lisätä sovelluksellesi logon.',
        'FACEBOOK_PROMOTE_TITLE_PROFILE' => 'Lisää sovellus Facebook-profiiliisi',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_1' => 'Esittele sovellustasi lisäämällä se Facebookin profiilisivuillesi. Nyt voit rentoutua ja katsoa, kun ystäväsikin esittelevät sitä.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_2' => 'Napsauta sen sovelluksen vieressä olevaa <strong>Näytä Tietoja-sivu</strong> linkkiä jonka haluat lisätä profiiliisi ja valitse sitten Lisää sovellus painike seuraavalla sivulla.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_3' => 'Sovelluksesi on nyt Facebook-profiilisivusi alalaidassa!',
        'FACEBOOK_PROMOTE_MY_APPLICATIONS_PAGE' => 'Omat sovellukseni sivu Facebookissa',
        'FACEBOOK_MY_APPS' => 'Omat sovellukseni',
        'FORUM_TAB_TEXT' => 'Foorumi',
        'VIDEOS_TAB_TEXT' => 'Videot',
        'PHOTOS_TAB_TEXT' => 'Kuvat',
        'GROUPS_TAB_TEXT' => 'Ryhmät',
        'EACH_VIDEO_MAY_BE_100MB' => 'Jokainen video saa olla kooltaan enintään 100 Mt. Tuemme .mov, .mpg, .avi, .wmv ja .3gp videomuotoja.',
        'I_HAVE_RIGHT_TO_UPLOAD_VIDEO' => 'Minulla on oikeus ladata tämä video  <a %s>Palveluehdot</a>.',
        'VIDEO_UPLOADER_REQUIRES_JAVA' => 'Videoiden joukkolataus vaatii uudemman Java version. <strong><a %s>Klikkaa tähän saadaksesi Javan</a></strong>, tai <strong><a %s>palaa yksinkertaiseen lataajaan</a></strong>.',
        'UPLOAD_A_VIDEO_FROM_YOUR_COMPUTER' => 'Lataa video tietokoneeltasi',
        'HAVE_LOT_OF_VIDEOS' => 'Onko sinulla monta videota jaettavana?',
        'TRY_BULK_VIDEO_UPLOADER' => 'Kokeile videoiden joukkolataajaa',
        'VIDEOS_SUCCESSFULLY_UPLOADED' => 'Videosi on onnistuneesti ladattu.',
        'VIDEOS_UPLOADED_AWAITING' => 'Videosi ovat onnistuneesti ladattu ja odottavat  %s\'s tekijän hyväksyntää.',
        'ADD_VIDEOS_OR_PHOTOS_TO_APPNAME' => 'Lisää videoita tai kuvia kohteeseen %s suoraan puhelimestasi lähettämällä ne sähköpostiosoitteeseen.',
        'GRAB_HTML_EMBED' => 'Ota HTML \'embed\' koodi miltä tahansa suositulta videosivustolta ja lisää video tähän verkostoon.',
        'GOOGLE' => 'Google',
        'YOUTUBE' => 'YouTube',
        'HAVING_PROBLEMS_WITH_VIDEO_UPLOADER' => 'Onko sinulla ongelmia joukkolataajan kanssa?  <strong><a %s>Palaa takaisin yksinkertaiseen lataajaamme</a></strong>.',
        'ADD_VIDEOS_FROM_YOUTUBE' => 'Lisää videoita YouTube tai Google sivustolta',
        'TAGS_NO_COLON' => 'Tagit',
        'NO_VIDEOS_TAGGED_X_CHECK' => 'Ei ole yhtään videota tagilla "%1$s". Tarkista <a %2$s>keskustelua tagilla "%1$s"</a>, <a %4$s>blogipostitusta tagilla "%1$s"</a> or <a %3$s>kuvaa tagilla "%1$s"</a>. Tai lisää ja merkitse tageilla omat videosi!',
        'UPLOAD_VIDEOS_FROM' => 'Lataa videoita omalta tietokoneeltasi',
        'YOUR_VIDEO_UPLOAD_TO_X_DID_NOT_COMPLETE_DUE_TO_A_CONVERSION_ERROR' => 'Videolataustasi %s ei suoritettu loppuun konversointivirheen takia.',
        'TO_HELP_TROUBLESHOOT_PROVIDE_THIS_VIDEO_ID_X' => 'Helpottaaksesi vianetsintää anna tämä videon tunnus ID: %s',
        'YOUR_VIDEO_WAS_SUCCESSFULLY_UPLOADED_TO_X' => 'Videosi on onnistuneesti ladattu %s-verkostoon!.',
        'TO_VIEW_THE_VIDEO_VISIT' => 'Voit katsoa videon kohdasta:',
        'YOUR_VIDEO_X_ON_Y_HAS_A_NEW_COMMENT' => 'Videoosi "%1$s"  %2$s on lisätty uusi kommentti.',
        'YOUR_VIDEO_ON_X_HAS_A_NEW_COMMENT' => 'Videoosi %s on öisätty uusi kommentti.',
        'ADD_VIDEOS_BY_PHONE_OR' => 'Lisää videoita puhelimitse tai sähköpostilla',
        'FEATURING_ELLIPSIS' => 'Esitellään…',
        'NOW_FEATURED_ON_MAIN' => 'Nyt esittelyssä pääsivulla',
        'DONT_FEATURE' => 'Älä esittele',
        'UNFEATURING_ELLIPSIS' => 'Poistaa pääsivulta...',
        'REMOVED_FROM_MAIN' => 'Poistettu pääsivulta',
        'ADDED_EXCLAMATION' => 'Lisätty!',
        'ERROR' => 'Virhe',
        'ADDING_ELLIPSIS' => 'Lisää...',
        'TRACK_COULD_NOT_BE_LOADED' => 'Kappaletta ei voitu ladata',
        'INVALID_URL' => 'Kelvoton URL',
        'NORMAL_PLAYBACK_ON' => 'Normaali toisto: Päällä',
        'REPEAT_PLAYBACK_ON' => 'Toistuva toisto: Päällä',
        'SHUFFLE_PLAYBACK_ON' => 'Sekoitus toisto: Päällä',
        'OPEN_POPUP_WINDOW' => 'Avaa ponnahdusikkuna',
        'LOADING_PLAYLIST_ELLIPSIS' => 'Lataa soittoluetteloa...',
        'EACH_PHOTO_MAY_BE_UP_TO_10MB' => 'Jokainen kuva voi olla kooltaan enintään 10 Mt. Tuemme .jpg, .gif ja .png kuvamuotoja.',
        'I_HAVE_RIGHT_TO_UPLOAD_PHOTOS' => 'Minulla on oikeus ladata nämä kuvat <a %s>Palveluehdot</a>.',
        'PHOTO_UPLOADER_REQUIRES_JAVA' => 'Kuvien massalataaja vaatii uudemman Java version. <strong><a %s>Klikkaa Java tästä</a></strong>, tai <strong><a %s>palaa yksinkertaiseen lataajaan</a></strong>.',
        'TRY_BULK_PHOTO_UPLOADER' => 'Kokeile kuvien joukkolataajaa',
        'HAVE_LOT_OF_PHOTOS' => 'Onko sinulla paljon kuvia jaettavana?',
        'PHOTOS_SUCCESSFULLY_UPLOADED' => 'Kuvasi on ladattu onnistuneesti.',
        'PHOTOS_UPLOADED_AWAITING' => 'Kuvasi on ladattu onnistuneesti ja odottavat  %s\'s perustajan hyväksyntää.',
        'FLICKR' => 'Flickr',
        'ADD_PHOTOS_FROM_FLICKR' => 'Lisää kuvia Flickr-sivustolta',
        'ADD_PHOTOS_OR_VIDEOS_TO_APPNAME' => 'Lisää kuvia tai videoita kohteeseen %s suoraan puhelimestasi lähettämällä ne sähköpostiosoitteeseen.',
        'HAVING_PROBLEMS_WITH_PHOTO_UPLOADER' => 'Onko sinulla ongelmia kuvien joukkolatauksen kanssa?  <strong><a %s>Palaa takaisin yksinkertaiseen lataukseen</a></strong>.',
        'NO_PHOTOS_TAGGED_X_CHECK' => 'Yhtään kuvaa ei ole tag-merkitty "%1$s". Katso <a %2$s>tag-merkityt keskustelut  "%1$s"</a>, <a %4$s>tag-merkityt blogikirjoitukset "%1$s"</a> tai <a %3$s>tag-merkityt videot "%1$s"</a>. Tai lisää ja merkitse tageilla omat kuvasi!',
        'UPLOAD_PHOTOS_FROM_YOUR_COMPUTER' => 'Lataa kuvia tietokoneeltasi',
        'YOUR_PHOTO_X_HAS_A_NEW_COMMENT_ON_Y' => 'Kuvallesi "%1$s" on uusi kommentti %2$s.',
        'YOUR_PHOTO_HAS_A_NEW_COMMENT_ON_X' => 'Kuvallesi on uusi kommentti %s.',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y_ELLIPSIS' => 'Sinulla on uusi %1$s hyväksyttäväksi verkostossa %2$s...',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y' => 'Sinulla on uusi %1$s hyväksyttäväksi verkostossa %2$s.',
        'YOU_HAVE_A_NEW_X_TITLE_TO_APPROVE_ON_Y' => 'Sinulla on uusi %1$s "%2$s" hyväksyttäväksi verkostossa %3$s.',
        'TO_APPROVE_THIS_X_VISIT' => 'Hyväksyäksesi tämän %s, siirry:',
        'YOUR_X_ON_Y_HAS_BEEN_APPROVED_ELLIPSIS' => 'Sinun %1$s verkostossa %2$s on hyväksytty...',
        'YOUR_TYPE_ON_X_HAS_A_NEW_COMMENT_ELLIPSIS' => 'Sinun %1$s verkostossa%2$s on uusi kommentti...',
        'CLICK_HERE_TO_JOIN' => 'Klikkaa liittyäksesi:',
        'X_WANTS_YOU_TO_CHECK_OUT_Y_ON_Z' => '%1$s haluaa, että katsot "%2$s" verkostossa %3$s!',
        'YOUR_X_HAS_BEEN_APPROVED_ON_Y' => 'Sinun %s on hyväksytty verkostossa %s.',
        'YOUR_X_Y_HAS_BEEN_APPROVED_ON_Z' => 'Sinun %1$s "%2$s" on hyväksytty verkostossa %3$s.',
        'TO_VIEW_YOUR_X_VISIT' => 'Nähdäksesi %s, siirry:',
        'TO_VIEW_THIS_X_VISIT' => 'Nähdäksesi tämän %s, siirry:',
        'TO_VIEW_IT_VISIT' => 'Nähdäksesi sen, siirry:',
        'X_REPORTED_THE_FOLLOWING_ISSUE_ON_Y_ELLIPSIS' => '%1$s ilmoitti seuraavasta ongelmasta verkostossa %2$s...',
        'USER_HAS_SENT_YOU_A_MESSAGE_ON_X' => '%1$s on lähettänyt sinulle viestin verkostossa %2$s.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X' => '%1$s  on lähettänyt liittymispyynnön %2$s verkostossa %3$s.',
        'TO_APPROVE_OR_DENY_USER_REQUEST' => 'Hyväksyäksesi tai hylätäksesi %s\'s pyynnön, siirry:',
        'X_ADDED_A_COMMENT_TO_THE_BLOG_POST_Y_ON_Z' => '%1$s lisäsi kommentin blogikirjoitukseen "%2$s" verkostossa %3$s.',
        'X_ADDED_A_COMMENT_TO_A_BLOG_POST_ON_Y_ELLIPSIS' => '%1$s lisäsi kommentin blogikirjoitukseen verkostossa %2$s...',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X' => 'Sinulla on jäsenpyyntö hyväksyttäväksi verkostossa %s.',
        'WELCOME_TO_THE_GROUP_X_ON_Y' => 'Tervetuloa ryhmään "%1$s"verkostossa %2$s',
        'PLEASE_SELECT_A_MEMBER' => 'Valitse yksi tai useampia jäsen',
        'LOADING_YOUR_FRIENDS' => 'Lataamme ystäviäsi...',
        'YOUR_MESSAGE_HAS_BEEN_SENT_TITLE_CASE' => 'Viestisi on lähetetty',
        'TO_SEND_ANOTHER_MESSAGE' => 'Lähettääksesi toisen viestin, kirjoita tekstisi tähän alle.',
        'PLEASE_CHOOSE_FRIENDS' => 'Valitse ensin ystävät ennen kuin lähetät viestin.',
        'RESEND_INVITATION' => 'Lähetä kutsu uudelleen',
        'CHOOSE_FRIENDS' => 'Valitse ystävät...',
        'ALL_FRIENDS' => 'Kaikki ystävät',
        'ALL_FRIENDS_ON_APPNAME' => 'Kaikki ystävät verkostossa %s',
        'SHARE_WITH_FRIENDS' => 'Jaa ystävien kanssa',
        'SHARE_THIS_WITH_FRIENDS' => 'Jaa tämä asia ystäviesi kanssa',
        'COMPOSE_MESSAGE' => 'Luo viesti',
        'INVITATION_LINK_ONLY_VISIBLE' => 'Tämä kutsulinkki näkyy vain verkoston perustajalle ja ylläpitäjille. Jäsenet, jotka liittyvät tämän linkin kautta tulevat automaattisesti verkoston perustajan ystäviksi.',
        'WE_ARE_LOADING_ADDRESSES' => 'Lataamme osoitteitasi...',
        'SELECT_ALL_NONE' => 'Valitse kaikki/ei yhtään',
        'INVITE_TO_APPNAME' => 'Kutsu \'%s\'',
        'INVITE_YOUR_FRIENDS_TO_APPNAME' => 'Kutsu ystäväsi \'%s\'',
        'ALREADY_MEMBER_OF_NETWORK' => '(On jo tämän verkoston jäsen)',
        'OR_SHARE_THIS_INVITATION_LINK' => 'Tai jaa tämä kutsulinkki:',
        'CLICK_TO_MAIL' => '<a %s>Klikkaa tästä lähettääksesi viestin nyt</a>.',
        'MESSAGE_HAS_BEEN_SENT' => 'Viestisi on lähetetty',
        'YOU_CAN_SHARE_THIS' => 'Voit jakaa lisää alla olevien henkilöiden kanssa tai  <a %s>palata takaisin edelliselle sivulle</a>.',
        'VCARD_IMPORT_UNAVAILABLE' => 'Olemme pahoillamme, mutta vCard tuontipalvelu on tällä hetkellä poissa käytöstä.',
        'CSV_IMPORT_UNAVAILABLE' => 'Olemme pahoillamme, mutta CSV tuontipalvelu tällä hetkellä poissa käytöstä.',
        'ERROR_OCCURRED' => 'Olemme pahoillamme, mutta on tapahtunut virhe.',
        'IMPORT_FAILED' => 'Olemme pahoillamme, mutta tuonti epäonnistui.',
        'LOGIN_FAILED' => 'Olemme pahoillamme, mutta sisään kirjautuminen epäonnistui.',
        'UNABLE_TO_FIND_EMAIL' => 'Olemme pahoillamme, mutta emme löytäneet email-kenttää.',
        'CANNOT_READ_VCARDS' => 'Olemme pahoillamme, mutta emme voi lukea näitä vCards.',
        'SORRY_WE_DO_NOT_SUPPORT' => 'Valitettavasti emme tue sähköpostiosoitteesi osoitekirjaa. Yritä klikata \'Osoitekirjasovellus\' alla käyttääksesi tietokoneesi osoitteita.',
        'NO_ADDRESSES_FOUND' => 'Osoitteita ei löytynyt',
        'WE_DID_NOT_FIND_ADDRESSES' => 'Emme löytäneet osoitteita tuodusta osoitekirjasta.',
        'WANT_TO_INVITE_MORE_FRIENDS' => 'Haluatko kutsua lisää ystäviä? Tuo kontakteja web-osoitekirjastasi tai työpöytäsi osoitekirjasovelluksesta.',
        'IMPORT_FROM_WEB_ADDRESS_BOOK' => 'Tuo Web osoitekirjasta',
        'IMPORT_FROM_ADDRESS_BOOK_APPLICATION' => 'Tuo osoitekirjasovelluksesta',
        'MICROSOFT_OUTLOOK_APPLE_ADDRESS_BOOK' => 'Microsoft Outlook, Apple Address Book, .CSV, jne.',
        'PRIVACY_POLICY' => 'Yksityisyysehdot',
        'APPLY_FOR_MEMBERSHIP_SIGN_IN' => 'Hae jäsenyyttä nyt. Oletko jo jäsen? <a %s>Klikkaa tästä kirjautuaksesi sisälle</a>.',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK_ON_Y' => '%1$s on antanut seuraavaa palautetta %2$s:',
        'TRACK_STATISTICS' => 'Seuraa tilastoja',
        'FEATURED_MEMBERS' => 'Esitellyt jäsenet',
        'CHECK_OUT_X_ON_Y_ELLIPSIS' => 'Katso "%1$s" kohdassa %2$s...',
        'CHECK_OUT_THIS_X_ON_Y_ELLIPSIS' => 'Katso tämä %1$s kohdassa %2$s...',
        'SORRY_NO_MEMBERS_MATCHING_X_WERE_FOUND' => 'Valitettavasti yhtään jäsentä ei löydy "%s" mukaisesti.',
        'WHO_CAN_COMMENT_ON_POST' => 'Kuka saa kommentoida tätä postia?',
        'SEND_MESSAGE_TO_FRIENDS' => 'Lähetä viesti ystäville',
        'PREVIOUS_POST' => '← Edellinen kirjoitus',
        'NEXT_POST' => 'Seuraava kirjoitus →',
        'PREVIOUS_POSTS' => '←  Edelliset kirjoitukset',
        'NEXT_POSTS' => 'Seuraavat kirjoitukset →',
        'NO_BLOG_POSTS_TAGGED_X_CHECK' => 'Yhtään blogikirjoitusta ei ole merkitty tageilla "%1$s". Katso <a %2$s>keskustelujen tagit "%1$s"</a>, <a %4$s>kuvien tagit "%1$s"</a> tai <a %3$s>videoiden tagit "%1$s"</a>. Tai lisää ja merkitse tageilla omat blogikirjoituksesi!',
        'ALL_POSTS_TAGGED_X_FOR_M_Y' => 'Kaikkiin kirjoituksiin lisätty tagit <em>\'%s\'</em> %s %s',
        'ALL_POSTS_TAGGED_X' => 'Kaikkiin kirjoituksiin lisätty tagit <em>\'%s\'</em>',
        'MY_BLOG_POSTS_FOR_M_Y' => 'Omat blogikirjoitukset %s %s',
        'MY_BLOG_POSTS' => 'Omat blogikirjoitukset',
        'PICK_VALID_ALL_FRIENDS_NOTIFICATION' => 'Valitse oikea vaihtoehto kaikille ystäville lähetettyjen viestien ilmoituksille',
        'PRIVACY_CONTENT_CONTROL' => 'Yksityisyys & Sisällön valvonta',
        'ENABLE_MUSIC_DOWNLOAD_LINKS' => 'Ota käyttöön Music Playerin latauslinkit',
        'WELCOME_MEMBER_N_OF_APPNAME_INVITE' => 'Tervetuloa, %1$s! Olet jäsen #%2$s %3$s. <a %4$s>Kutsu ystäviä nyt</a>.',
        'YOU_COMMENTED_ON_PHOTO_TITLE' => 'Olet kommentoinut kuvaa <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_PHOTO_TITLE' => '%s on kommentoinut kuvaa <a %s>%s</a>',
        'YOU_COMMENTED_ON_VIDEO_TITLE' => 'Olet kommentoinut videota <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_VIDEO_TITLE' => '%s on kommentoinut videota <a %s>%s</a>',
        'NOTIFY_BLOG_PING_SERVICES' => 'Haluatko ilmoittaa uuden kirjoituksen lisäämisestä 3:n osapuolen blogin seurantapalveluun?',
        'YES_NOTIFY_BLOG_SERVICES' => 'Kyllä -- Ilmoita <a %s>sivuston päivityspalvelulle</a> kun lisään uuden kirjoituksen blogiini',
        'THERE_ARE_NO_FEATURED_MEMBERS' => 'Yhteisössäsi ei ole esiteltyjä jäseniä.',
        'START_FEATURING_MEMBERS_CLICK_Y' => 'Aloita jäsenien esittely kun näet Esittelyoption. Lue lisää esittelystä, <a %s>klikkaa tätä</a>.',
        'THIS_IS_YOUR_PAGE' => 'Tämä on sinun sivusi:',
        'MESSAGES_SENT_TO_ALL_FRIENDS' => 'Kaikille ystäville lähetetyt viestit',
        'TO_STOP_FOLLOWING_THIS_X_GO_TO' => 'Lopeta tämän %s seuraaminen, siirry:',
        'SHOW_ALL' => 'Näytä kaikki',
        'CHOOSE_GADGETS' => 'Valitse yksi näistä OpenSocial laitteista omalle profiilisivullesi! Voit <a %s>nähdä ja arvostella laitteita täällä</a>, tai <a %s>saada lisätietoja  OpenSocial täältä</a>.',
        'GADGETS_UNAVAILABLE' => 'Laitteet väliaikaisesti poissa käytöstä',
        'APOLOGIES_GADGETS_UNAVAILABLE' => 'Pahoittelemme – laitteet ovat väliaikaisesti poissa käytöstä.',
        'BOX_WILL_NOT_SHOW_GADGET' => 'Tämä laatikko ei näy muille, jollet valitse laitetta.',
        'CLICK_EDIT_TO_SPECIFY_GADGET_OR_VISIT_GADGET_GALLERY' => 'Klikkaa Edit määritelläksesi laitteen URL tälle laatikolle tai siirry <a %s>Laiteluettelo</a>.',
        'PROBLEM_OCCURRED_RETRIEVING_GADGET' => 'Tämän laitteen RSS-syötteen noutamisessa ilmeni ongelma.',
        'ADD_GADGET_TO_YOUR_PAGE' => 'Lisää tämä laite profiiliisi.',
        'GADGETS_BETA' => 'Laitteet (Beta)',
        'TRY_OUT_OPENSOCIAL_GADGETS_WARNING_EXPERIMENTAL' => 'Kokeile OpenSocial laitteita.  Varoitus: tämä toiminto on kokeellinen.',
        'ADD_TO_MY_PAGE' => 'Lisää sivulleni',
        'GADGETS' => 'Laitteet',
        'GADGETS_TAB_TEXT' => 'Laitteet',
        'GADGET' => 'Laite',
        'GADGETS_IS_IN_BETA' => 'Laitteet ovat Beta-muotoa.',
        'SORRY_GADGET_UNAVAILABLE' => 'Olemme pahoillamme, mutta tämä laite ei ole saatavilla. Tarkista ja varmista, että sinulla on oikea URL. Jos sinulla edelleen on ongelmia, <a %s>ilmoita meille</a>.',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_ADD' => 'Yhtään keskustelua ei ole merkitty tageilla "%1$s". Katso <a %2$s>tag-merkityt kuvat "%1$s"</a>, <a %4$s>tag-merkityt blogikirjoitukset "%1$s"</a> tai <a %3$s>tsg-merkityt videot "%1$s"</a>. Tai lisää ja merkitse tageilla omat keskustelusi!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK' => 'Yhtään keskustelua ei ole merkitty tageilla "%1$s". Katso <a %2$s>tag-merkityt kuvat "%1$s"</a>, <a %4$s>tag-merkityt blogikirjoitukset "%1$s"</a> tai <a %3$s>tag-merkityt videot "%1$s"</a>.',
        'ALREADY_MEMBER_OF_GROUP' => '(On jo ryhmän jäsen)',
        'INVITE_YOUR_FRIENDS_TO_GROUPNAME' => 'Kutsu ystäväsi \'%s\'',
        'COME_JOIN_ME_ON_X_ON_Y' => 'Tule ja liity seuraani %1$s verkostossa %2$s.',
        'COME_JOIN_ME_ON_X_ON_Y_ELLIPSIS' => 'Tule ja liity seuraani verkostossa %1$s verkostossa %2$s...',
        'INVITE_TO_GROUP' => 'Kutsu \'%s\'',
        'YOU_CAN_ADD_100_SONGS' => 'Voit lisätä enintään 100 kappaletta, joista jokainen voi olla kooltaan enintään 20 Mt. Tuemme kappaleita .mp3 tiedostomuodossa.',
        'I_HAVE_RIGHT_TO_UPLOAD_SONGS' => 'Minulla on oikeus ladata nämä kappaleet <a %s">Palveluehdot</a>.',
        'MUSIC_UPLOADER_REQUIRES_JAVA' => 'Musiikin joukkolataaja vaatii uudemman Java version. <strong><a %s>Klikkaa tästä Java</a></strong>, tai <strong><a %s>palaa yksinkertaiseen lataukseen</a></strong>.',
        'HAVE_LOT_OF_MUSIC' => 'Onko sinulla paljon jaettavaa musiikkia?',
        'TRY_BULK_MUSIC_UPLOADER' => 'Kokeile musiikin joukkolataajaa.',
        'SONGS_SUCCESSFULLY_UPLOADED' => 'Kappaleesi on ladattu.',
        'SORRY_YOU_CAN_ONLY_HAVE_N_TRACKS' => 'Pahoittelemme, sinulla voi olla vain %s kappaletta soittolistalla. Poista joitakin entisiä kappaleita ennen kuin lataat uusia.',
        'ADD_MUSIC_FROM_WEBSITE' => 'Lisää musiikkia toiselta Internet-sivustolta',
        'HAVING_PROBLEMS_WITH_MUSIC_UPLOADER' => 'Onko sinulla ongelmia tämän musiikin lataajan kanssa?  <strong><a %s>Palaa takaisin yksinkertaiseen lataajaan</a></strong>.',
        'UPLOAD_MUSIC_FROM_YOUR_COMPUTER' => 'Lataa musiikkia tietokoneeltasi',
        'ADD_MUSIC' => 'Lisää musiikkia',
        'FACEBOOK_INSTR_SETUP_APP_PERMISSION' => 'Valitse <strong>Käyttäjät</strong> ja <strong>Kaikki sivut</strong>.',
    );

    /**
     * If the given widget title is the default English title for the widget,
     * translate it into the current language.
     *
     * @param string $widgetTitle  The title of the widget
     * @return string  A translated title if the title is the English default; otherwise, the title unchanged
     */
    public static function translateDefaultWidgetTitle($widgetTitle) {

        return $widgetTitle;
    }

}