<?php

XG_App::includeFileOnce('/lib/XG_AbstractMessageCatalog.php');

/**
 * Texts for the es_ES locale.
 */
class XG_MessageCatalog_es_ES extends XG_AbstractMessageCatalog {

    /**
     * Returns a localized version of a string. The first argument is the message name, e.g., 'ADD_A_PHOTO'.
     * Subsequent arguments are substitution values (if the message contains sprintf format elements).
     *
     * @param $args array the message name, plus optional substitution values
     * @return string the localized string
     * @see xg_html()
     */
    public static function text($args) {
        $s = $args[0];
        static $a = array();
        if (! $a) {
            $a['N_SECONDS_AGO']['1'] = 'Hace 1 segundo ';
            $a['N_SECONDS_AGO']['n'] = 'Hace %s segundos ';
            $a['N_MINUTES_AGO']['1'] = 'Hace 1 minuto ';
            $a['N_MINUTES_AGO']['n'] = 'Hace %s minutos ';
            $a['N_HOURS_AGO']['1'] = 'Hace 1 hora ';
            $a['N_HOURS_AGO']['n'] = 'Hace %s horas ';
            $a['N_VIDEOS']['1'] = '<strong>1</strong> video ';
            $a['N_VIDEOS']['n'] = '<strong>%s</strong> videos ';
            $a['N_VIEWS']['1'] = '1 vista ';
            $a['N_VIEWS']['n'] = '%s vistas ';
            $a['N_COMMENTS']['1'] = '<span class="comment-count">1</span> comentario ';
            $a['N_COMMENTS']['n'] = '<span class="comment-count">%s</span> comentarios ';
            $a['VIDEO_IS_FAVORITE_OF']['1'] = 'Este video es el <strong>favorito</strong> de <strong>1 persona</strong>. ';
            $a['VIDEO_IS_FAVORITE_OF']['n'] = 'Este video es el <strong>favorito</strong> de <strong>%s personas</strong>. ';
            $a['Y_ADDED_X_VIDEOS']['1'] = '%2$s ha añadido un video: ';
            $a['Y_ADDED_X_VIDEOS']['n'] = '%2$s ha añadido %s videos. ';
            $a['YOU_ADDED_X_VIDEOS']['1'] = 'Has añadido un video: ';
            $a['YOU_ADDED_X_VIDEOS']['n'] = 'Has añadido %s videos. ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['1'] = 'Hay 1 video en %2$s ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['n'] = 'Hay %1$s videos en %2$s ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['1'] = 'Hay 1 <a href="%3$s">video</a> en %2$s ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['n'] = 'Hay %1$s <a href="%3$s">videos</a> en %2$s ';
            $a['N_PHOTOS_FROM_ALBUM']['1'] = 'Se ha eliminado o hecho privada 1 foto de este álbum, por lo tanto no se puede visualizar. ';
            $a['N_PHOTOS_FROM_ALBUM']['n'] = 'Se han eliminado o hecho privadas %s fotos de este álbum, por lo tanto no se pueden visualizar. ';
            $a['N_PHOTOS']['1'] = '<strong>1</strong> foto ';
            $a['N_PHOTOS']['n'] = '<strong>%s</strong> fotos ';
            $a['N_PHOTOS_2']['1'] = '1 foto ';
            $a['N_PHOTOS_2']['n'] = '%s fotos ';
            $a['AND_X_OTHER_PEOPLE']['1'] = 'Y otra persona más ';
            $a['AND_X_OTHER_PEOPLE']['n'] = 'y %s otras personas más ';
            $a['PROBLEM_UPLOADING_FILES']['1'] = 'Ha ocurrido un problema en la carga de este archivo: ';
            $a['PROBLEM_UPLOADING_FILES']['n'] = 'Ha ocurrido un problema en la carga de los siguientes archivos: ';
            $a['PHOTO_IS_FAVORITE_OF']['1'] = 'Esta foto es la <strong>favorita</strong> de <strong>1 persona</strong>. ';
            $a['PHOTO_IS_FAVORITE_OF']['n'] = 'Esta foto es la <strong>favorita</strong> de <strong>%s personas</strong>. ';
            $a['RATING_Y_AFTER_X_VOTES']['1'] = '<strong>Calificación:</strong> %2$s después de 1 voto ';
            $a['RATING_Y_AFTER_X_VOTES']['n'] = '<strong>Calificación:</strong> %2$s después de %s votos ';
            $a['Y_AFTER_X_VOTES']['1'] = '%2$s después de 1 voto ';
            $a['Y_AFTER_X_VOTES']['n'] = '%2$s después de %s votos ';
            $a['N_PEOPLE']['1'] = '1 persona ';
            $a['N_PEOPLE']['n'] = '%s personas ';
            $a['N_OF_5_STARS']['1'] = '1/5 estrella ';
            $a['N_OF_5_STARS']['n'] = '%s/5 estrellas ';
            $a['YOUR_RATING_X_STARS']['1'] = 'Tu calificación: 1 estrella ';
            $a['YOUR_RATING_X_STARS']['n'] = 'Tu calificación: %s estrellas ';
            $a['Y_ADDED_X_PHOTOS']['1'] = '%2$s ha añadido una foto: ';
            $a['Y_ADDED_X_PHOTOS']['n'] = '%2$s ha añadido %s fotos. ';
            $a['YOU_ADDED_X_PHOTOS']['1'] = 'Has añadido una foto: ';
            $a['YOU_ADDED_X_PHOTOS']['n'] = 'Has añadido %s fotos. ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['1'] = 'Hay 1 foto en %2$s ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['n'] = 'Hay %1$s fotos en %2$s ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['1'] = 'Hay %1$s <a href="%3$s">foto</a> en %2$s ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['n'] = 'Hay %1$s <a href="%3$s">fotos</a> en %2$s ';
            $a['N_COMMENTS_ON_PAGE']['1'] = '<strong>1</strong> comentario en tu página ';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s</strong> Comments on your page';;
            $a['N_BLOG_COMMENTS']['1'] = '<strong>1</strong> comentario en el blog ';
            $a['N_BLOG_COMMENTS']['n'] = '<strong>%s</strong> cometarios en el blog ';
            $a['N_YEARS_OLD']['1'] = '1 año ';
            $a['N_YEARS_OLD']['n'] = '%s años ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['1'] = '¡Tienes 1 petición de amistad! ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['n'] = '¡Tienes %s peticiones de amistad! ';
            $a['COMMENT_WALL_N_COMMENTS']['1'] = 'Comentario (1 comentario) ';
            $a['COMMENT_WALL_N_COMMENTS']['n'] = 'Comentario (%s comentarios) ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['1'] = 'Se ha unido 1 miembro nuevo durante esta semana ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['n'] = 'Se han unido %s miembros nuevos durante la semana pasada ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['1'] = 'Se ha unido 1 <a href="%2$s">miembro nuevo </a> durante esta semana ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['n'] = 'Se han unido %1$s <a href="%2$s">miembros nuevos </a> durante esta semana ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['1'] = 'Hay 1 miembro en %2$s ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['n'] = 'Hay %1$s miembros en %2$s ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['1'] = 'Hay 1 <a href="%3$s">miembro</a> en %2$s ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['n'] = 'Hay %1$s <a href="%3$s">miembros</a> en %2$s ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['1'] = 'Hay 1 publicación en el blog en %2$s ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['n'] = 'Hay %1$s publicaciones en el blog en %2$s ';
            $a['N_NEW_MEMBERS']['1'] = '<strong>1</strong> miembro nuevo ';
            $a['N_NEW_MEMBERS']['n'] = '<strong>%s</strong> miembros nuevos ';
            $a['N_REPLIES']['1'] = '1 contestación ';
            $a['N_REPLIES']['n'] = '%s contestaciones ';
            $a['N_MINUTES']['1'] = 'Queda 1 minuto para editar tu comentario. ';
            $a['N_MINUTES']['n'] = 'Quedan %s minutos para editar tu comentario. ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['1'] = 'Hay 1 tema en el foro en %2$s ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['n'] = 'Hay %1$s temas en el foro en %2$s ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['1'] = 'Hay 1 <a href="%3$s">tema en el foro</a> en %2$s ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['n'] = 'Hay %1$s <a href="%3$s">temas en el foro</a> en %2$s ';
            $a['N_INVITES']['1'] = '%s invitado ';
            $a['N_INVITES']['n'] = '%s invitados ';
            $a['N_MEMBERS']['1'] = '1 miembro ';
            $a['N_MEMBERS']['n'] = '%s miembros ';
            $a['N_MEMBERS_PARENTHESIZED']['1'] = '(1 miembro) ';
            $a['N_MEMBERS_PARENTHESIZED']['n'] = '(%s miembros) ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['1'] = 'Hay 1 grupo en %2$s ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['n'] = 'Hay %1$s grupos en %2$s ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['1'] = 'Hay %1$s <a href="%3$s">grupo</a> en %2$s ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['n'] = 'Hay %1$s <a href="%3$s">grupos</a> en %2$s ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['1'] = 'No se puede visualizar 1 canción de la lista de reproducción porque se ha eliminado o ya no se comparte. ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['n'] = 'No se pueden visualizar %s canciones de la lista de reproducción porque se han borrado o ya no se comparten. ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['1'] = 'Se ha añadido una canción nueva a %2$s ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['n'] = 'Se han añadido %1$s canciones nuevas a %2$s ';
            $a['Y_ADDED_X_SONGS']['1'] = '%2$s ha añadido una canción: ';
            $a['Y_ADDED_X_SONGS']['n'] = '%2$s ha añadido %s canciones. ';
            $a['YOU_ADDED_X_SONGS']['1'] = 'Has añadido una canción: ';
            $a['YOU_ADDED_X_SONGS']['n'] = 'Has añadido %s canciones. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['1'] = 'Se ha añadido 1 canción a la lista de reproducción. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['n'] = 'Se han añadido %s canciones a la lista de reproducción. ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['1'] = 'Hay 1 canción en %2$s ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['n'] = 'Hay %1$s canciones en %2$s ';
            $a['N_INVITATIONS_RESENT']['1'] = 'Se ha reenviado 1 invitación. ';
            $a['N_INVITATIONS_RESENT']['n'] = 'Se han reenviado %s invitaciones. ';
            $a['N_COMMENTS_ON_PAGE']['1'] = '<strong>1</strong> comentario en el perfil ';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s</strong> comentarios en el perfil ';
            }
        if ($a[$args[0]]) {
            $args[0] = $a[$args[0]][$args[1]] ? $a[$args[0]][$args[1]] : $a[$args[0]]['n'];
            return @call_user_func_array('sprintf', $args);
        }
        $text = self::$messages[$s];
        if ($text) { $args[0] = $text; }
        return @call_user_func_array('sprintf', $args);
    }

    /**
     * Message names and texts. Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;
     */
    private static $messages = array(
        'BROWSING' => 'Navegando',
        'MORE_VIDEOS' => 'Más videos',
        'NETWORK_DOES_NOT_HAVE_VIDEOS' => 'Esta red aún no tiene videos.',
        'NETWORK_DOES_NOT_HAVE_FEATURED_VIDEOS' => 'Esta red aún no tiene ningún video destacado.',
        'PERSON_DOES_NOT_HAVE_VIDEOS' => 'Esta persona aún no tiene ningún video.',
        'COPY_TO_CLIPBOARD' => 'Copiar',
        'COPIED_TO_CLIPBOARD' => '¡Copiado!',
        'NO_VIDEOS_TO_DISPLAY' => 'Ahora no estás mostrando videos.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_VIDEO' => 'Este área no aparecerá para otras personas hasta que elijas al menos un video.',
        'WATERMARK_LOGO' => 'Logotipo filigrana',
        'CHOOSE_HEADER_OR_WATERMARK' => 'Puedes elegir un encabezado o una filigrana para tu reproductor de videos.',
        'CUSTOMIZE_EMBED_INSTRUCTIONS' => 'El logotipo aparece al principio de tu página. Si no añades un logotipo, se mostrará  en su lugar el nombre de la red. Tu logotipo debe estar en formator jpg, gif o png. Los logotipos mayores de 20 pixeles de altura serán modificados para que quepan.',
        'CUSTOMIZE_WATERMARK_INSTRUCTIONS' => 'La filigrana aparece abajo a la derecha de la imagen de video.',
        'HEADER_LOGO' => 'Logotipo de encabezamiento',
        'WATERMARK' => 'Filigrana',
        'CUSTOMIZE_YOUR_VIDEO_PLAYER' => '¡Personaliza tu reproductor de video!',
        'VIDEO_PLAYER' => 'Reproductor de video',
        'HEADER' => 'Encabezado',
        'SAVE_CHANGES' => 'Guardar cambios',
        'THUMBNAIL' => 'Versión reducida',
        'CONVERSION_FAILED' => 'La conversión ha fallado',
        'CONVERSION_IN_PROGRESS' => 'Conversión en progreso',
        'MAP' => 'Mapa',
        'WHAT_IS_THIS' => '¿Qué es esto?',
        'EDIT_VIDEO_INFORMATION' => 'Edita la información del video',
        'ALL_VIDEOS' => 'Todos los Videos',
        'VIDEOS_HOME' => 'Videos',
        'MY_VIDEOS' => 'Mis videos',
        'MY_FRIENDS_VIDEOS' => 'Videos de mis amistades',
        'MY_FAVORITES' => 'Mis favoritos',
        'XS_FAVORITES' => 'Los favoritos de %s',
        'ADD_A_VIDEO' => 'Añade un video',
        'JUST_NOW' => 'Ahora',
        '1_DAY_AGO' => 'hace 1 día',
        'M_J' => 'j M',
        'ME' => 'Mí',
        'X_SAID' => '%s dijo…',
        'DELETE_COMMENT' => 'Borrar comentario',
        'YOU_HAVE_NOT_ADDED_VIDEOS' => '¡Todavía no has añadido ningún video!',
        'ADD_VIDEOS_AND_SHARE' => 'Añade videos o compártelos con tus amistades, familia o el resto del mundo.',
        'THERE_ARE_NO_VIDEOS' => 'En este momento no hay vídeos en tu red social.',
        'THIS_BOX_WILL_NOT_SHOW' => 'Este recuadro no le aparecerá al resto de los usuarios hasta que exista algún vídeo para mostrar. ¿Por qué no añades uno?',
        'ADD_VIDEOS' => 'Añadir videos',
        'VIEW_VIDEOS' => 'Ver videos',
        'YIKES' => '¡Ups!',
        'A_PROBLEM_SEEMS' => 'Parece que hay un problema.',
        'FOR_FURTHER_ASSISTANCE' => 'Para más asistencia, por favor ponte en <a %s>contacto con nosotros</a>.',
        'OR_YOU_CAN_GO' => 'O puedes volver a la <a %s>%s página principal</a> o navegar <a %s>otras redes sociales de Ning</a>',
        'TAGS' => 'Etiquetas:',
        'POPULAR_TAGS' => 'Etiquetas populares',
        'MY_FRIENDS' => 'Mis amistades',
        'VIEW_ALL_MY_FRIENDS' => 'Ver todas mis amistades',
        'VIEW_ALL_XS_FRIENDS' => 'Ver todas las amistades de %s',
        'WE_COULD_NOT_FIND_ANYONE_MATCHING' => 'Disculpas - no pudimos encontrar alguna persona que concuerde con tu búsqueda.',
        'VIEW_POPULAR_CONTRIBUTORS' => 'Ver participantes populares',
        'POPULAR_CONTRIBUTORS' => 'Participantes populares',
        'VIEW_MORE_CONTRIBUTORS' => 'Ver más contribuyentes populares',
        'ADD_AS_FRIEND' => 'Añadir como amigo',
        'SEND_A_MESSAGE' => 'Enviar un mensaje',
        'IS_YOUR_FRIEND' => 'Es tu amigo',
        'IS_BLOCKED' => 'Está bloqueado',
        'SORT_BY' => 'Ordenar por:',
        'CLOSE' => 'Cerrar',
        'USER_COUNT' => '(%d)',
        'NOBODY_HAS_ADDED_VIDEOS' => '¡Nadie ha añadido videos todavía! Añade algunos para empezar.',
        'SEARCH_PEOPLE' => 'Busca gente:',
        'INVITE_YOUR_FRIENDS_TO' => 'Invita a tus amistades a la %s.',
        'INVITE' => 'Invita',
        'INVITE_TAB_TEXT' => 'Invita',
        'YOU_HAVE_NOT_ADDED_FRIENDS' => 'Todavía no has añadido ninguna amistad a la red %s.',
        'SEARCH_FRIENDS' => 'Buscar amistades:',
        'ADD_YOUR_FIRST_VIDEO' => 'Añade tu primer video',
        'USE_HTML_EMBED_CODE' => 'Usa el código HTML',
        'UPLOAD_A_VIDEO_FROM' => 'Carga un video desde tu ordenador:',
        'WE_SUPPORT_MOV' => 'Le damos soporte a los formatos .mov, .mpg, .mp4, .avi, .3gp y .wmv. Los archivos deben ser de 100MB o menos.',
        'NEED_HELP_HERE_ARE' => '¿Necesitas ayuda? Aquí tienes instrucciones para <a %s>YouTube</a> y <a %s>Google Video</a>.',
        'ADD_TITLE_AND_DESCRIPTION' => 'Añade un título y una descripción',
        'DESCRIPTION_COLON' => 'Descripción:',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_1' => 'Añádele un título, descripción y otra información al video que acabas de cargar.',
        'EVERYTHING_IS_OPTIONAL' => 'Todo es opcional; si no quieres añadir nada, haz clic en "Saltarse este paso" a la derecha.',
        'SKIP_THIS_STEP' => 'Saltarse este paso',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_2' => 'Añádele un título, descripción y otra información a este video.',
        'CANCEL_AND_RETURN_TO_VIDEO' => 'Cancelar y volver al video',
        'TITLE' => 'Título:',
        'TAGS_ARE_SHORT_DESCRIPTIONS' => 'Las etiquetas son mini-descripciones temáticas que ayudan en la búsqueda de tus videos. Separa etiquetas con comas; si son de palabras múltiples, ponlas entre comillas ("EL Carmen").',
        'WHO_CAN_VIEW_VIDEO' => '¿Quién puede ver este video?',
        'MOST_POPULAR' => 'Más populares',
        'HIGHEST_RATED' => 'Calificación más alta',
        'MOST_RECENT' => 'Más recientes',
        'MOST_FAVORITED' => 'Los favoritos',
        'MOST_POPULAR_VIDEOS' => 'Los videos más populares',
        'HIGHEST_RATED_VIDEOS' => 'Los videos mejor calificados',
        'MOST_RECENT_VIDEOS' => 'Los videos más recientes',
        'MOST_FAVORITED_VIDEOS' => 'Los videos favoritos',
        'ANYONE' => 'Cualquiera',
        'JUST_MY_FRIENDS' => 'Sólo mis amistades',
        'JUST_ME' => 'Sólo yo',
        'VIEWABLE_BY_FRIENDS' => 'Sólo lo pueden ver <strong>mis amistades</strong>',
        'PRIVATE_VIDEO' => 'Video <strong>Privado</strong>',
        'VIEWABLE_BY_EVERYONE' => 'Lo puede ver <strong>todo el mundo</strong>',
        'LOCATION' => 'Ubicación:',
        'NO_LOCATION' => 'Sin ubicación',
        'CLICK_ON_LOCATION' => 'Haz clic sobre una ubicación en el mapa:',
        'FIND_AN_ADDRESS' => 'Encuentra una dirección',
        'LOCATE' => 'Ubicar',
        'YOU_CAN_ADD_YOUR_OWN_VIDEO' => '¡Puedes <a %s>añadir tu propio video </a> a %s!',
        'ADD_PLAYER_LOGO_OR_WATERMARK' => 'Añade un logotipo o una filigrana al reproductor de video de tu red. <a %s>¡Configúralo ahora!</a>',
        'APPROVE' => 'Aprobar',
        'DELETE' => 'Eliminar',
        'APPLY_TO_VIDEOS_ADDED_BY' => 'Aplicar a todos los videos añadidos por %s',
        'NO_TITLE' => 'Sin título',
        'ADDED_BY_STRONG_X' => 'Añadido por <strong>%s</strong>',
        'NO_DESCRIPTION' => 'Sin descripción',
        'BY_X' => 'por %s',
        'YOU_HAVE_FINISHED_MODERATING' => 'Terminaste de moderar',
        'NO_VIDEOS_AWAITING_APPROVAL' => 'En este momento no hay videos esperando aprobación. Si estás buscando algo para hacer, ¿por qué no ves los <a %s>últimos videos </a>?',
        'NO_ONE_HAS_ADDED_ANY_VIDEOS' => 'Nadie ha añadido videos a tu red social.',
        'ADDED_ON_DATE_BY_X' => 'Añadido %s por %s.',
        'REMOVE_FROM_FAVORITES' => 'Quitar de favoritos',
        'REMOVE_VIDEO_FROM_FAVORITES' => '¿Quitar este video de tus favoritos?',
        'COLLECTED_BY_X' => 'Compilado por %s',
        'ADD_FAVORITES' => 'Añadir favoritos',
        'YOU_CAN_MARK_VIDEO' => 'Puedes marcar cualquier video como favorito. Haz clic en "Añadir a favoritos" cuando lo veas en un video.',
        'VIEW_RECENT_VIDEOS' => 'Ver videos recientes',
        'X_HAS_NOT_ADDED_FAVORITES' => '%s no ha añadido nada a sus favoritos todavía.',
        'APPROVE_VIDEOS' => 'Aprobar Videos',
        'YOUR_SITE_REQUIRES_YOU' => 'Solicitaste moderar las fotos y los videos en tu red social antes que sean publicados. Para cambiar esta opción, visita la sección <a %s>Privacidad y miembros</a> en Administrar tu red y selecciona Moderación de contenidos a \'No\'.',
        'YOUR_SITE_ALLOWS_USERS' => 'Solicitaste no moderar las fotos y los videos en tu red social antes que sean publicados. Para cambiar esta opción, visita la sección <a %s>Privacidad y miembros</a> en Administrar tu Red y selecciona Moderación de contenidos a \'Si\'.',
        'APPROVE_ALL_VIDEOS' => '¿Aprobar todos los videos?',
        'ARE_YOU_SURE_APPROVE_ALL_VIDEOS' => '¿Estás seguro que quieres aprobar todos los videos? Tardará algunos minutos.',
        'APPROVING' => 'Aprobando',
        'APPROVE_ALL' => 'Aprobar todo',
        'DELETE_ALL_VIDEOS' => '¿Borrar todos los videos?',
        'ARE_YOU_SURE_DELETE_ALL_VIDEOS' => '¿Estás seguro que quieres borrar todos los videos que no estén aprobados? Esto puede tomar algunos minutos.',
        'DELETING' => 'Eliminando',
        'DELETE_ALL' => 'Borrar todo',
        'XS_VIDEOS' => 'Videos de %s',
        'DELETE_ALL_XS_VIDEOS_Q' => '¿Borrar todos los videos de %s?',
        'DELETE_ALL_XS_VIDEOS' => 'Borrar todos los videos de %s',
        'ARE_YOU_SURE_DELETE_ALL_XS_VIDEOS' => '¿Estás seguro de que quieres borrar todos los videos de %s? Esto puede tomar algunos minutos.',
        'DELETE_THIS_VIDEO_Q' => '¿Borrar este video?',
        'ARE_YOU_SURE_DELETE_THIS_VIDEO' => '¿Estás seguro que quieres borrar este video? Esto puede tomar algunos minutos.',
        'YOU_HAVE_NOT_ADDED_VIDEOS_2' => 'Todavía no has añadido ningún video. ¡Añade un video para empezar!',
        'X_HAS_NOT_ADDED_VIDEOS' => '%s todavía no ha añadido ningún video.',
        'YOUR_FRIENDS_DO_NOT_HAVE_VIDEOS' => 'Tus amistades no han añadido videos todavía.',
        'ALL_VIDEOS_TAGGED_X' => 'Todos los videos con etiqueta \'%s\'',
        'ALL_VIDEOS_TAGGED_X_2' => 'Todos los videos con etiqueta <em>\'%s\'</em>',
        'NO_VIDEOS_TAGGED_X_CHECK_OUT' => 'No hay videos con etiqueta "%1$s". Puedes ver <a %2$s>discusiones con etiqueta "%1$s"</a> o  <a %2$s>fotos con etiqueta "%1$s"</a>. ¡También puedes añadir y etiquetar tus propios videos!',
        'FILES_MUST_BE_100MB' => 'Los archivos deben ser de 100MB o menos. Le damos soporte a formatos .mov, .mpg, .mp4, .avi, .3gp y .wmv.',
        'NEED_HELP' => '¿Necesitas ayuda?',
        'HERE_ARE_INSTRUCTIONS' => 'Aquí están las instrucciones para <a %s>YouTube</a> y <a %s>Google Video</a>.',
        'PERSON_IN_CHARGE' => 'La persona a cargo de %s quiere ver lo que haces antes de mostrárselo al mundo.',
        'LEAVE_WINDOW_OPEN' => 'Por favor deja esta ventana abierta mientras el proceso de carga se completa.',
        'KEEP_PAGE_OPEN' => 'Por favor deja esta ventana abierta mientras terminamos de cargar tu video y te avisaremos cuando esté aprobado.',
        'MEANWHILE_FEEL_FREE' => 'Mientras tanto puedes <a %s>abrir una ventana nueva de tu navegador</a> y continuar usando %s. Cuando se haya completado la carga, podrás añadir un título y una descripción a tu video en esta ventana.',
        'VIDEO_IS_WAITING_FOR_APPROVAL' => 'Este video esta<strong>esperando aprobación</strong> por parte del creador de %s\\.',
        'LOADING' => 'Cargando…',
        'EDIT_VIDEO' => 'Editar video',
        'DELETE_VIDEO' => 'Borrar video',
        'YOU_NEED_TO_BE_MEMBER' => '¡Necesitas ser un miembro de %s para añadir comentarios!',
        'SIGN_UP_OR_SIGN_IN' => '<a %s>Únete a esta red</a>',
        'ADD_A_COMMENT' => 'Añadir un comentario',
        'LEAVE_A_COMMENT_FOR_USERNAME' => 'Dejar un comentario para %s',
        'MORE' => 'Más',
        'PREVIOUS' => 'Anterior',
        'NEXT' => 'Próximo',
        'ABOUT_THIS_VIDEO' => 'Sobre este video',
        'ABOUT_YOUR_VIDEO' => 'Sobre este video',
        'ADDED_ON_DATE_BY' => 'Añadido <strong>%s</strong> por:',
        'VIEWS' => 'Vistas:',
        'COMMENTS' => 'Comentarios',
        'COMMENTS_COLON' => 'Comentarios:',
        'LOCATION_OF_VIDEO' => 'Ubicación de este video:',
        'RELATED_VIDEOS' => 'Videos relacionados',
        'ALL_VIDEOS_TAGGED_X_X' => 'Todos los videos con etiqueta %s (%s)',
        'XS_VIDEOS_X' => 'Videos de %s (%s)',
        'XS_FAVORITES_X' => 'Favoritos de %s (%s)',
        'VIDEO_DETAILS' => 'Detalles del video',
        'NEITHER_FILE_NOR_EMBED_CODE' => 'Ni un archivo ni un código para hacer un <em>embed</em> fue especificado.',
        'VIDEO_UPLOADED_ON_X' => 'El video fue cargado en %s',
        'PROBLEM_OCCURRED_CONVERTING_VIDEO' => 'Ocurrió un problema durante la conversión del video a formato Flash: %s',
        'STATUS_N' => 'Estado %s',
        'YOUR_VIDEO_TITLED_X_COULD_NOT' => 'Tu video titulado "%s" no pudo ser añadido %s',
        'YOUR_VIDEO_COULD_NOT_BE_ADDED' => 'Tu video no pudo ser añadido a %s',
        'YOU_JUST_TRIED_TO_SEND_VIDEO' => 'Has intentado mandar un video a %s. Lamentablemente no eres miembro de %s y no podemos mandarle este video.',
        'VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'No se completó la carga del video en %s',
        'YOUR_VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'La carga del vídeo no se completó en %s.',
        'YOUR_VIDEO_ENCOUNTERED_A_PROBLEM' => 'Tu vídeo tuvo algunos problemas mientras se cargaba en %s',
        'THE_PROBLEM_WAS_X' => 'El problema fue: %s',
        'FOR_FURTHER_ASSISTANCE_2' => 'Para más asistencia, por favor visita:',
        'ID' => 'ID:',
        'VIDEO_TRANSCODING_FAILED_FOR_X' => 'La codificación del video falló %s en %s',
        'X_UPLOADED_A_VIDEO_THAT_FAILED' => '%s subió un video que falló la codificación.',
        'ERROR_MESSAGE' => 'Mensaje de error:',
        'APPLICATION_NAME' => 'Nombre de la aplicación:',
        'APPLICATION_ID' => 'ID de la aplicación:',
        'VIDEO_ID' => 'ID del video :',
        'VIDEO_UPLOAD_COMPLETE_ON_X' => 'La carga del video se completó en %s',
        'YOUR_VIDEO_UPLOAD_COMPLETE_ON_X' => 'la carga de tu vídeo se  completó en %s',
        'YOUR_VIDEO_WAS_UPLOADED' => '¡Tu vídeo fue cargado a %s!',
        'THAT_VIDEO_IS_AWAITING_APPROVAL' => 'Ese video está esperando aprobación.',
        'THIS_VIDEO_IS_BEING_PROCESSED' => 'Este video todavía está siendo procesado.',
        'ADD_VIDEO' => 'Añadir video',
        'VIDEO_BY_X' => 'Video de %s',
        'THERE_IS_NEW_COMMENT_ON_VIDEO_X' => 'Hay un nuevo comentario sobre tu vídeo "%s" en %s',
        'THERE_IS_NEW_COMMENT_ON_VIDEO' => 'Hay un nuevo comentario sobre tu vídeo en %s',
        'SOMEBODY_COMMENTED_VIDEO_ADDED_TO_X' => 'Alguien comentó sobre el video que añadiste a %s',
        'SOMEBODY_UPLOADED_VIDEO_TO_X' => 'alguien subió un video a %s',
        'MORE_WAYS_TO_ADD_VIDEOS' => 'Más maneras de añadir videos',
        'FROM_YOUTUBE_OR_GOOGLE' => '…de YouTube o Google',
        'GRAB_THE_HTML_EMBED_CODE' => 'Copia el código HTML <em>embed</em> de cualquier sitio de videos y añade ese video a tu red social.',
        'ADD_A_VIDEO_FROM_YOUTUBE' => 'Añade un video de YouTube o Google',
        'PASTE_IN_EMBED' => 'Copia el codigo <em>embed</em> de este video aquí:',
        'ADD_VIDEOS_BY_PHONE_OR_EMAIL' => 'Añade un video por teléfono o email',
        'VIDEO' => 'Video',
        'THERE_ARE_NO_VIDEOS_THAT_MATCH' => 'No hay videos con las características que elegiste.',
        'CLICK_EDIT_AND_CHANGE_SETTINGS' => 'Haz clic en \'Editar\' y cambia la configuración si quieres que este área sea visible para otras personas.',
        'PLAY_AGAIN' => 'Reproducir de nuevo',
        'SHARE' => 'Compartir',
        'EMBED' => 'Insertar',
        'REWIND' => 'Rebobinar',
        'CHANGE_SIZE' => 'Cambiar tamaño',
        'FULLSCREEN' => 'Pantalla completa',
        'EXIT_FULLSCREEN' => 'Salir de la pantalla completa',
        'HIDE' => 'Cerrar',
        'COPY_AND_PASTE_LINK' => 'Copiar y pegar este enlace en un email o un mensaje instantáneo:',
        'FIND_MORE_VIDEOS_LIKE_THIS' => 'Encuentra más videos como este en <em>%s</em>',
        'SEE_VIDEO_ON_NETWORK' => 'Ve este video en %s',
        'GET_EMBED_CODE' => 'Ver código incrustado',
        'MORE_PHOTOS' => 'Más fotos',
        'THIS_ALBUM' => 'Este álbum',
        'NETWORK_DOES_NOT_HAVE_PHOTOS' => 'Esta red aún no tiene fotos.',
        'PERSON_DOES_NOT_HAVE_PHOTOS' => 'Esta persona aún no tiene fotos.',
        'ALBUM_DOES_NOT_HAVE_PHOTOS' => 'Este álbum aún no tiene fotos.',
        'FIND_MORE_PHOTOS_LIKE_THIS' => 'Encuentra más fotos como esta en <em>%s</em>',
        'NO_PHOTOS_AVAILABLE' => 'No hay fotos en este álbum. <a %s>Haz clic aquí para ver todos los álbumes</a>.',
        'ALBUM_PHOTOS_NOT_VISIBLE_TO_OTHERS' => 'Este álbum no es visible para otras personas en la red porque las fotos sólo son visibles para ti o aún tienen que ser aprobadas.',
        'CUSTOMIZE_YOUR_SLIDESHOW_PLAYER' => '¡Configura tu reproductor de fotos!',
        'ADD_SLIDESHOW_LOGO' => 'Añade un logotipo a tu exposición de fotos de la red social <a %s></a>',
        'PHOTO_BY_X' => 'Foto de %s',
        'UPLOAD_PHOTOS' => 'Añade fotos',
        'PLAYER_COLOR' => 'Color del reproductor',
        'SLIDESHOW_PLAYER' => 'Reproductor de fotos',
        'SLIDESHOW' => 'Exposición de fotos',
        'FILTER' => 'Filtro',
        'SAVE_ALBUM' => 'Guardar album',
        'APPLY_THIS_INFO_TO_PHOTOS' => 'Aplicar esta información a las siguientes fotos',
        'CLICK_TO_ADD_A_DESCRIPTION' => 'Haz clic para añadir una descripción',
        'CHECK' => 'Selecciona',
        'YOU_NEED_TO_BE_X' => 'Necesitas ser %s para hacer eso.',
        'ALL_PHOTOS' => 'Todas las fotos',
        'POPULAR_PHOTOS' => 'Fotos populares',
        'FEATURED_PHOTOS' => 'Fotos destacadas',
        'PHOTOS_HOME' => 'Fotos',
        'ALL_ALBUMS' => 'Todos los álbumes',
        'MY_PHOTOS' => 'Mis fotos',
        'MY_ALBUMS' => 'Mis álbumes',
        'ADD_PHOTOS' => 'Añadir fotos',
        'ADD_PHOTOS_SENTENCE_CASE' => 'Añadir fotos',
        'EDIT' => 'Edición',
        'CHOOSE_PHOTOS' => 'Elegir fotos',
        'ADD_PHOTOS_BY_DRAGGING' => '<strong>Añade fotos arrastrándolas</strong> a tu álbum a la derecha. Elimínalas devolviéndolas a su lugar de origen.',
        'TITLE_YOUR_ALBUM' => '<strong>Titula tu álbum.</strong> Dale una portada y una descripción.',
        'SAVE_YOUR_ALBUM' => 'Graba tu álbum',
        'CHOOSE_FROM' => 'Elegir de:',
        'EVERYONES_PHOTOS' => 'Todas las fotos',
        'TAGGED' => 'Etiquetada:',
        'OLDER_PHOTOS' => 'Fotos más antiguas',
        'MORE_RECENT_PHOTOS' => 'Fotos más recientes',
        'YOUR_ALBUM' => 'Tu álbum',
        'DRAG_ALBUM_COVER_HERE' => 'Arrastra la tapa del álbum aquí',
        'ALBUM_TITLE' => 'Título del álbum:',
        'ALBUM' => 'Álbum',
        'DRAG_PHOTOS_HERE' => 'Arrastra tus fotos aquí',
        'PREVIOUS_ALBUM_PAGE' => 'Página anterior del álbum',
        'NEXT_ALBUM_PAGE' => 'Próxima página del álbum',
        'ADDED_ON_DATE' => 'Añadida %s',
        'VIEW_AS_SLIDESHOW' => 'Ver como exposición de fotos',
        'CREATED_BY_ME' => 'Creado por <a %s>Mi</a>',
        'CREATED_BY_X' => 'Creado por %s',
        'OUR_APOLOGIES' => 'Disculpas',
        'ADD_PHOTOS_TO_ALBUM' => 'Añade más fotos a este álbum eligiendo de las opciones que están debajo.',
        'YOU_CAN_ADD_PHOTOS' => 'Puedes <a %s>añadir fotos a este álbum ahora</a>.',
        'SITE_IS_GETTING_STARTED' => 'Esta red social está recién empezada.',
        'NO_ONE_CREATED_ALBUMS' => 'Parece que nadie ha creado ningún álbum todavía. Puedes <a %s>crear tu álbum ahora</a>.',
        'EDIT_YOUR_ALBUM' => 'Edita tu álbum',
        'ALBUMS_WITH_THIS_PHOTO' => 'Todos los álbumes con esta foto',
        'ALBUMS_WITH_X' => 'Todos los álbumes con \'%s\'',
        'ALBUMS_WITH_X_2' => 'Todos los álbumes con <em>\'%s\'</em>',
        'NO_ALBUMS_CONTAINING_PHOTO' => 'No hay álbumes que contengan esta foto. Puedes <a %s>crear un álbum nuevo</a>.',
        'XS_ALBUMS' => 'Los álbumes de %s',
        'CREATE_AN_ALBUM' => 'Crea un álbum',
        'YOU_HAVE_NOT_CREATED_ALBUMS' => 'Todavía no has creado ningún álbum de fotos. Puedes <a %s>crear un álbum ahora</a>.',
        'X_HAS_NOT_CREATED_ALBUMS' => '%s todavía no hay creado ningún álbum.',
        'MAKE_AN_ALBUM' => 'Crea un álbum',
        'ABOUT_THIS_ALBUM' => 'Sobre este álbum',
        'ABOUT_YOUR_ALBUM' => 'Sobre tu álbum',
        'EDIT_ALBUM' => 'Editar el álbum',
        'DELETE_THIS_ALBUM' => '¿Borrar este álbum?',
        'DELETE_ALBUM' => 'Borrar álbum',
        'START_SLIDESHOW' => 'Comenzar exposición de fotos',
        'ALBUM_IS_NOW_EMPTY' => 'Este álbum está vacío.',
        'YOU_ARE_GETTING_STARTED' => '¡Estás comenzando!',
        'YOU_HAVE_NOT_ADDED_PHOTOS' => 'Todavía no has añadido ninguna foto.',
        'ADD_PHOTOS_AND_SHARE' => 'Añade fotos y compártelas con tus amistades, tu familia y el resto del mundo.',
        'ADD_A_PHOTO' => 'Añadir una foto',
        'NO_PHOTOS_ON_SITE' => 'En la actualidad no hay fotos en tu red social.',
        'BOX_WILL_NOT_SHOW_PHOTOS' => 'Este recuadro no será visto por otras personas hasta que haya alguna foto para mostrar. ¿Por qué no añades una?',
        'VIEW_EMBED_CODE' => 'Ver código <em>incrustar</em>',
        'VIEW_SLIDESHOW' => 'Ver exposición de fotos',
        'VIEW_PHOTOS' => 'Ver fotos',
        'ADD_YOUR_FIRST_PHOTOS' => 'Añade tus primeras fotos',
        'YOU_CAN_ADD_YOUR_OWN_PHOTOS' => '¡Puedes <a %s>añadir tus propias fotos</a> a %s!',
        'UPLOAD_PHOTOS_FROM' => 'Carga las fotos desde tu ordenador:',
        'ADD_TITLE_AND_DESCRIPTION_FOR_PHOTOS' => 'Añade un título y una descripción a tus fotos',
        'EDIT_PHOTO_INFORMATION' => 'Edita la información de la foto',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_1' => 'Añade un título, una descripción y cualquier otra información que quieras a las fotos que acabas de cargar.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_2' => 'Añade un título, una descripción y cualquier otra información que quieras a esta foto.',
        'CANCEL_AND_RETURN_TO_PHOTO' => 'Cancela y vuelve a la foto',
        'WHO_CAN_VIEW_PHOTO' => '¿Quién puede ver esta foto?',
        'CAN_BE_VIEWED_BY' => 'Puede verlo:',
        'BY_ME' => 'la subí <a %s>yo</a>',
        'RSS_FEED_LABEL' => '<a %s>Canal RSS</a> - %s',
        'NO_PHOTOS_AWAITING_APPROVAL' => 'En este momento no hay fotos que estén esperando aprobación. ¿Puedes ver las <a %s>últimas fotos</a>?',
        'APPROVE_ALL_PHOTOS' => '¿Aprobar todas las fotos?',
        'ARE_YOU_SURE_APPROVE_ALL_PHOTOS' => '¿Estás seguro de que quieres aprobar todas las fotos? Esto podría tardar unos minutos.',
        'DELETE_ALL_PHOTOS' => '¿Borrar todas las fotos?',
        'ARE_YOU_SURE_DELETE_ALL_PHOTOS' => '¿Estás seguro de que quieres borrar todas las fotos que aún no están aprobadas? Esto puede tomar algunos minutos.',
        'KEEP_WINDOW_OPEN_PHOTOS_APPROVED' => 'Por favor deja esta ventana del navegador abierta mientras las fotos son aprobadas. Este proceso puede tardar unos minutos.',
        'KEEP_WINDOW_OPEN_PHOTOS_DELETED' => 'Por favor deja esta ventana del navegador abierta mientras las fotos son aprobadas. Este proceso puede tardar unos minutos.',
        'APPLY_TO_PHOTOS_ADDED_BY' => 'Aplicar a todas las fotos de %s',
        'NO_ONE_HAS_ADDED_ANY_PHOTOS' => 'No se han añadido fotos a tu red social. Puedes <a %s>ser el primero</a> en hacerlo.',
        'UNTITLED' => 'Sin título',
        'A_PROBLEM_OCCURRED' => 'Ha ocurrido un problema',
        'PHOTOS_EXCEEDED_LIMIT' => 'Las fotos parecen ser más grandes de 10MB (por foto)',
        'GET_A_SLIDESHOW_OF' => 'Consigue una exposición de fotos de  %s',
        'GET_A_SLIDESHOW' => 'Consigue una exposición de fotos',
        'GET_SLIDESHOW_OF_PHOTOS' => 'Consigue una exposición de estas fotos',
        'COPY_AND_PASTE_SLIDESHOW' => 'Copia y pega el código que está abajo para ponerlo en una exposición de estas fotos en tu sitio Web, página Myspace u otras redes de Ning.',
        'COPY_AND_PASTE_SLIDESHOW_OF_ALBUM' => 'Copia y pega el código que está abajo para ponerlo en una exposición de fotos de tu álbum en su sitio Web, página MySpace u otras redes de Ning.',
        'LARGE_VERSION' => 'Versión grande',
        'SMALL_VERSION' => 'Versión pequeña',
        'VIEW_SLIDESHOW_FULL_SIZE' => 'Mira esta exposición de fotos en pantalla completa.',
        'PHOTOS' => 'Fotos',
        'XS_PHOTOS' => 'Las fotos de %s',
        'XS_PHOTO' => 'La foto de %s',
        'YOU_CAN_MARK_PHOTO' => 'Puedes marcar cualquier foto como favorita. Haz clic en el icono que dice "Añadir a favoritos" cuando lo veas sobre una foto.',
        'VIEW_RECENT_PHOTOS' => 'Ver fotos recientes',
        'APPROVE_PHOTOS' => 'Aprobar fotos',
        'DELETE_ALL_XS_PHOTOS_Q' => '¿Borrar todas las fotos de %s?',
        'ARE_YOU_SURE_DELETE_ALL_XS_PHOTOS' => '¿Estás seguro que quieres borrar todas las fotos de %s? Este proceso puede tardar unos minutos.',
        'REMOVE_X_AND_ALL_CONTENT' => 'Borrar %1$s y todos los contenidos de %1$s de mi red social',
        'SUCCESS' => 'Éxito.',
        'DELETING_CONTENT' => 'Borrando contenido',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED' => 'Por favor deja esta ventana del navegador abierta mientras el contenido es borrado. Este proceso puede tardar unos minutos.',
        'KEEP_WINDOW_OPEN_MEMBERS_DELETED' => 'Por favor deja esta ventana del navegador abierta mientras se borran los miembros. Este proceso puede tardar unos minutos.',
        'DELETE_ALL_XS_PHOTOS' => 'Borrar todas las fotos de %s',
        'CREATE_A_NEW_ALBUM' => 'Crear un nuevo álbum',
        'VIEW_ALL_XS_ALBUMS' => 'Ver todos los álbumes de %s',
        'YOU_HAVE_NOT_ADDED_PHOTOS_2' => 'Todavía no has añadido ninguna foto. Añade algunas para comenzar.',
        'X_HAS_NOT_ADDED_PHOTOS' => '%s todavía no ha añadido ninguna foto.',
        'MY_FRIENDS_PHOTOS' => 'Fotos de mis amistades',
        'VIEW_PHOTOS_IN_SLIDESHOW' => 'Ver estas fotos en una exposición.',
        'YOUR_FRIENDS_DO_NOT_HAVE_PHOTOS' => 'Tus amistades todavía no tienen fotos.',
        'ALL_PHOTOS_TAGGED_X' => 'Todas las fotos están etiquetadas \'%s\'',
        'ALL_PHOTOS_TAGGED_X_2' => 'Todas las fotos están etiquetadas <em>\'%s\'</em>',
        'NO_PHOTOS_TAGGED_X_CHECK_OUT' => 'No hay ninguna foto con etiqueta "%1$s". Puedes ver <a %2$s>discusiones con etiqueta "%1$s"</a> o <a %3$s>videos con etiqueta "%1$s"</a>.',
        'SELECT_YOUR_PHOTOS' => 'Selecciona tus fotos',
        'PHOTO_MAY_BE_10MB' => 'Cada foto puede tener un tamaño de hasta 10MB, pero las fotos pequeñas se cargarán más rápido.',
        'KEEP_PAGE_OPEN_PHOTOS' => 'Por favor deja esta página abierta para poder terminar de cargar tus fotos y te avisaremos cuando hayan sido aprobadas',
        'MEANWHILE_FEEL_FREE_PHOTOS' => 'Mientras tanto, puedes <a %s>abrir otra ventana de tu navegador</a> y continuar usando %s. Cuando la carga se haya completado, podrás añadirle títulos y descripciones a tus fotos en esta ventana.',
        'PHOTO_IS_WAITING_FOR_APPROVAL' => 'Esta foto esta <strong>esperando ser aprobada</strong> por el creador de %s',
        'ADD_TO_FAVORITES' => 'Añadir a favoritas',
        'EDIT_PHOTO' => 'Editar foto',
        'DELETE_PHOTO' => 'Borrar foto',
        'ABOUT_THIS_PHOTO' => 'Sobre esta foto',
        'LOCATION_OF_PHOTO' => 'Ubicación de esta foto:',
        'ALBUMS_FEATURING_PHOTO' => 'Álbumes que contienen esta foto',
        'VIEW_ALBUMS_WITH_PHOTO' => 'Mira todos los álbumes con esta Foto',
        'RETURN_TO_X' => 'Volver a %s',
        'RETURN_TO_PHOTOS_HOME' => 'Volver a fotos',
        'WE_COULD_NOT_FIND_ANYONE' => 'Discúlpanos - no pudimos encontrar a nadie',
        'NOBODY_HAS_ADDED_PHOTOS' => 'Nadie ha añadido fotos todavía. Añade algunas fotos para comenzar.',
        'DEFAULT_TITLE' => 'Título',
        'DEFAULT_DESCRIPTION' => 'Descripción',
        'UPLOAD_LIMIT_EXCEEDED' => 'Se ha excedido el límite del tamaño para el archivo que se estaba cargando.',
        'SLOW_DOWN_THERE_CHIEF' => 'Disculpas',
        'I_DO_NOT_KNOW_USER' => 'Disculpa, no se quién es esa persona.',
        'I_DO_NOT_HAVE_PHOTO' => 'Disculpa, no tengo esa foto.',
        'I_DO_NOT_HAVE_ALBUM' => 'Disculpa, no tengo ese álbum.',
        'ALBUM_BY_X_ON_X' => 'El álbum fue creado por %s en %s',
        'SENT' => '¡Enviado!',
        'I_HAVE_RECENTLY_ADDED' => 'Lo añadí recientemente',
        'FROM_THE_BAZEL' => 'De esta red',
        'RECENTLY_ADDED' => 'Recientemente añadido',
        'RECENT_PUBLIC_PHOTOS_ON_X' => 'Últimas fotos públicas en %s',
        'X_ALL_PHOTOS' => '%s - Todas las fotos',
        'NO_TAG_WAS_SPECIFIED' => 'No se especificó una etiqueta',
        'PUBLIC_PHOTOS_TAGGED_WITH_X' => 'Fotos publicas etiquetadas con %s en %s',
        'XS_PUBLIC_PHOTOS_ON_X' => 'Fotos publicas de %s en %s',
        'WE_DO_NOT_KNOW_USER' => 'No conocemos a esta persona.',
        'XS_FRIENDS_PHOTOS' => 'Fotos de las amistades de %s',
        'XS_FAVORITE_PHOTOS_ON_X' => 'Las fotos favoritas de %s en %s',
        'PHOTO_UPLOADED_ON_X' => 'Foto subida en %s',
        'FILE_EXCEEDED_MAXIMUM_SIZE' => 'El archivo excedió el tamaño máximo',
        'PART_OF_FILE_WAS_UPLOADED' => 'Sólo parte del archivo fue subido',
        'NO_FILE_WAS_UPLOADED' => 'La carga falló; puede que el nombre del archivo sea inválido o incorrecto.',
        'PROBLEM_OCCURRED_DURING_UPLOAD' => 'Un problema ha ocurrido durante la carga.',
        'ALPHABETICAL' => 'Alfabético',
        'MOST_VIEWS' => 'Más vistas',
        'RATING_NOT_RATED_YET' => '<strong>Calificación:</strong> No calificada',
        'NOT_RATED_YET' => 'No calificada',
        'HMM_SOMETHING_WENT_AWRY' => '¡Hmm! ... algo salió mal',
        'YOUR_PHOTO_TITLED_X_COULD_NOT' => 'Tu foto titulada "%s" no pudo ser añadida a %s',
        'YOUR_PHOTO_COULD_NOT_BE_ADDED' => 'Tu foto no pudo ser añadida a %s',
        'YOU_JUST_TRIED_TO_SEND' => 'Has intentado mandar una foto a %s. Desafortunadamente no eres miembro de %s y no podemos mandar la foto.',
        'ONLY_MY_FRIENDS' => 'Sólo mis amistades',
        'ANYBODY' => 'Cualquiera',
        'ONLY_MY_FRIENDS_CAN_SEE_PHOTO' => 'Sólo mis amistades pueden ver esta foto',
        'ONLY_XS_FRIENDS_CAN_SEE_PHOTO' => 'Sólo las amistades de %s pueden ver esta foto',
        'ONLY_I_CAN_SEE_PHOTO' => 'Sólo yo puedo ver esta foto',
        'ONLY_X_CAN_SEE_PHOTO' => 'Sólo %s puede ver esta foto',
        'EVERYONE_CAN_SEE_PHOTO' => 'Todos pueden ver esta foto',
        'PRIVATE_PHOTO' => 'Foto <strong>privada</strong>',
        'HOWDY_STRANGER' => 'Hola, ¿quién eres?',
        'YOU_NEED_TO_BE_SIGNED_IN' => 'Tienes que estar registrado para hacer eso.',
        'JUST_CLICK_ON_SIGN_IN' => 'Haz clic en "Acceso" arriba; o si todavía no tienes una cuenta haz clic en "Registrarse".',
        'YOU_NEED_TO_BE_' => 'Necesitas ser %s para hacer eso.',
        'YOU_NEED_TO_BE_OWNER' => 'Necesitas ser el creador de la red para hacer eso.',
        'THAT_PHOTO_IS_AWAITING_APPROVAL' => 'Esa foto está esperando ser aprobada.',
        'YOU_NEED_TO_BE_A_FRIEND' => 'Necesitas ser un amigo de %s para hacer eso.',
        'MOST_ACTIVE' => 'Más activos',
        'HOW_IT_WORKS' => 'Cómo funciona',
        'MORE_WAYS_TO_ADD_PHOTOS' => 'Más formas de añadir fotos…',
        'BY_PHONE_OR_EMAIL' => '… por teléfono o por email',
        'FROM_FLICKR' => '…de Flickr',
        'FROM_YOUR_COMPUTER' => '…de tu ordenador',
        'ADD_PHOTOS_FROM_YOUR_FLICKR' => 'Añade fotos de tu cuenta de Flickr .',
        'MORE_INFORMATION' => 'Más información',
        'ADD_PHOTOS_BY_PHONE_OR_EMAIL' => 'Añadir fotos por email o desde tu móvil',
        'SEND_ONE_PHOTO_OR_VIDEO' => 'Envía una foto o video por email. El tema del email se volverá el título de la foto o el video y el contenido del mail se volverá la descripción.',
        'CLICK_HERE_TO_GET_A_NEW_UNIQUE' => 'Haz clic aquí para conseguir una dirección nueva de email',
        'UPLOAD_PHOTOS_FROM_YOUR' => 'Carga fotos desde tu ordenador.',
        'PHOTO' => 'Foto',
        'YOUVE_SET_THE_NUMBER_OF_PHOTOS' => 'No estás mostrando ninguna foto.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_PHOTO' => 'Este área no será visible a otros hasta que selecciones al menos una foto.',
        'THERE_IS_NEW_COMMENT_ON_PHOTO_X' => 'Hay un comentario nuevo sobre tu foto "%s" en %s',
        'THERE_IS_NEW_COMMENT_ON_PHOTO' => 'Hay un comentario nuevo en una de tus fotos en %s',
        'SOMEBODY_COMMENTED_PHOTO_ADDED_TO_X' => 'alguien hizo un comentario sobre una foto que añadiste a %s',
        'SOMEBODY_UPLOADED_PHOTO_TO_X' => 'Alguien subió una foto a %s',
        'ADD_PHOTOS_OR_VIDEOS_TO_X' => 'Añade fotos o videos a %s directamente desde tu móvil enviándolos a una dirección de email.',
        'DO_YOU_REALLY_WANT_TO_REMOVE' => '¿Quieres realmente borrar este elemento de tus favoritos?',
        'DELETE_THIS_PHOTO_Q' => '¿Borrar esta foto?',
        'ARE_YOU_SURE_DELETE_THIS_PHOTO' => '¿Estás seguro que quieres borrar esta foto? Este proceso puede tardar unos minutos.',
        'PHOTO_SLIDESHOW' => 'Exposición de fotos',
        'THUMBNAILS' => 'Versión reducida',
        'DETAIL' => 'Detalles',
        'TAG' => 'Etiqueta',
        'RATE' => 'Calificar',
        'ALL_SIZES' => 'Todos los tamaños',
        'ADD_TO_ALBUM' => 'Añadir al álbum',
        'ROTATE_PHOTO' => 'Rotar foto',
        'ABOUT_YOUR_PHOTO' => 'Sobre tu foto',
        'SEE_PHOTOS_ON_NETWORK' => 'Ver estas fotos en %s',
        'EMBED_CODE' => 'Código incrustado',
        'IMPORT_PHOTOS_FLICKR' => 'Importar tus fotos de Flickr',
        'CLICK_HERE_TO_CONTINUE_TO_FLICKR' => 'Haz clic aquí para ir a Flickr',
        'TO_GET_YOUR_PHOTOS_FROM_FLICKR' => 'Para importar tus fotos de Flickr, primero debes permitirle a %S estar enlazado a tu cuenta en Flickr .',
        'IMPORT_PHOTOS' => 'Importar fotos',
        'GET_MY' => 'Consigue mis',
        'GET_PHOTOS' => 'Importar fotos',
        'MOST_RECENT_PHOTOS' => 'Las fotos más recientes',
        'GET_ALL_MY_FLICKR' => 'Importar todas mis fotos de Flickr (esto puede tardar un poco)',
        'GET_ALL_MY_TAGGED' => 'Importar todas mis fotos etiquetadas',
        'GET_PHOTOS_FROM_SET' => 'Importar fotos de un set:',
        'GET_STARTED_BY_IMPORT' => 'Importaremos tus títulos, etiquetas e información de ubicación automáticamente.<br/>¿Cuánto tardará?</p> <p><ul style="padding-top:10px;"><li>10 Fotos: <em>menos de 30 segundos</em>.</li><li>50 fotos: <em>alrededor de 2 minutos</em>.</li><li>200 fotos: <em>alrededor de 6 minutos</em>.</li><li>500 fotos: <em>alrededor de 15 minutos</em>.</li></ul>',
        'IF_YOURE_NOT_SIGNED_IN' => 'Si no estás registrado en Flickr, se te pedirá que lo hagas. Cuando ya estés registrado, haz clic en el botón que dice "OK, lo permito".',
        'GET_MY_FLICKR_PHOTOS_DESCRIPTIONS' => 'Importa las descripciones también (esto doblará el tiempo que demora hacerlo).',
        'PLEASE_KEEP_THIS_PAGE_OPEN_WHILE_IMPORT' => 'Por favor deja esta página abierta y así podemos terminar de importar tus fotos.',
        'GET_MY_FLICKR_PHOTOS_ORIGINALS' => 'Importa la versión de tamaño completo de la versión de cada foto (esto también incrementara el tiempo de importación).',
        'MAKE_YOUR_X_PAGE_YOUR_OWN' => 'Haz clic  en "editar" para añadir texto, videos, fotos o lo que quieras a esta caja. Es otra forma de personalizar tu %s .',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Haz clic en \'Edición\' para añadir texto, HTML, videos, fotos o <a %1$s>Widgets externos</a> a esta caja. Es otra forma de personalizar tu página %2$s.',
        'BOX_WILL_NOT_SHOW_UNTIL_UPDATE_CONTENT' => 'Esta caja no le aparecerá a otros usuarios hasta que haya algo de contenido.',
        'YOUR_X_BOX' => 'Tu caja de diálogo en %s',
        'ABOUT_WIDGETS' => 'Sobre Widgets',
        'HELP' => 'Ayuda',
        'WIDGETS' => 'Widgets',
        'LOOKING_TO_ADD_FUNCTIONALITY' => '¿Te gustaría añadir otras cosas a tu red social? ¿Un calendario? ¿El tiempo? ¿Un contador o una videocámara para red? Con widgets, es fácil añadir funciones adicionales a cualquier cuadro de texto en tu red.',
        'GETTING_STARTED' => 'Introducción',
        'BELOW_IS_LIST_OF_WIDGET' => 'Abajo encontrarás una <a %s>lista de proveedores de widgets</a>. Hemos seleccionado unos cuantos de <a %s>yourminis.com</a> para empezar.',
        'CALENDAR' => 'Calendario',
        'CALENDAR_WIDGET_ALLOWS_SEARCH' => 'El calendario puede mostrar la fecha y te permite hacer búsquedas de eventos de iCal (usados por Google Calendar y muchos otros proveedores de calendarios en línea).',
        'USE_EDIT_WIDGET_BUTTON_CALENDAR' => 'Utiliza el botón &#8220;editar widget&#8221; para seleccionar &#8220;buscar eventos&#8221;, luego ingresa una palabra de búsqueda (por ejemplo, vacaciones, el nombre de un equipo deportivo, etc.). A continuación simplemente elige un resultado para agregar dichos eventos a tu calendario. También puedes ingresar la dirección de cualquier fuente iCal existente.',
        'CUSTOMIZATION' => 'Configuración',
        'YOU_CAN_CUSTOMIZE_WIDGET' => 'Puede personalizar la apariencia del widget haciendo pasar el mouse por encima de éste y luego haciendo clic sobre el icono de selección del color para cambiar el fondo, el estilo del widget y el nivel de transparencia. Una vez finalizado, haz clic en el enlace &#8220;copiar a Web&#8221; y luego en el botón &#8220;copiar código incrustado&#8221;. Una vez que el código fue copiado, simplemente regresa a cualquier caja de texto en tu red, pega el código, guarda los cambios y listo.',
        'GET_MORE_WIDGETS_FROM_YOURMINIS' => 'Obtén más widgets en yourminis.com »',
        'WEATHER' => 'Tiempo',
        'WEATHER_WIDGET_DISPLAYS' => 'El widget del tiempo muestra el pronóstico local del tiempo según los datos del Weather Channel.',
        'USE_EDIT_WIDGET_BUTTON_WEATHER' => 'Utiliza el botón &#8220;editar widget&#8221; para seleccionar tu ubicación y elegir grados Fahrenheit o centígrados. Puedes elegir visualizar el pronóstico del tiempo sólo para el día actual o expandirlo a cinco días.',
        'COUNTDOWN' => 'Cuenta regresiva',
        'COUNTDOWN_WIDGET_LETS_YOU' => 'El widget de cuenta regresiva te permite crear una cuenta regresiva para un evento específico. Al hacer clic en el botón &#8220;editar widget&#8221;, podrás ingresar la fecha, hora, título o imagen de un evento futuro',
        'WEBCAM' => 'Videocámara para red',
        'WEBCAM_WIDGET_ALLOWS_YOU' => 'El widget de la videocámara para la red te permite monitorear activamente cualquier videocámara para la red que esté disponible al público. Utiliza el botón &#8220;editar widget&#8221; para elegir a partir de una lista predefinida de videocámaras para la red o ingresar manualmente el URL de alguna otra videocámara para la red.',
        'MORE_WIDGETS' => 'Más Widgets',
        'NEED_MORE_OPTIONS' => '¿Necesitas más opciones? Te recomendamos cualquiera de las siguientes páginas para que puedas calmar tu sed de widgets:',
        'MODERATION_DENIED_ON_X' => 'La moderación ha sido denegada en %s sobre %s',
        'MODERATION_DENIED_ON_A_X' => 'La moderación ha sido denegada en una %s de un %s',
        'YOU_HAVE_NEW_X_TO_MODERATE' => 'Tienes un nuevo %s para moderar en %s',
        'NEW_X_TO_MODERATE' => 'Hay un nuevo %s para que tú moderes.',
        'MODERATION_APPROVED_ON_X' => 'Moderación aprobada en %s sobre %s',
        'MODERATION_APPROVED_ON_A_X' => 'Moderación aprobada de un %s sobre ti en %s',
        'JOIN' => 'Únete',
        'WELCOME' => 'Bienvenido',
        'WELCOME_TO_X' => 'Bienvenido a %s',
        'WELCOME_TO_X_ELLIPSIS' => 'Bienvenido a %s',
        'RSS_LINK' => '<a %s>RSS</a>',
        'NEW_FEATURES_GROUPS_MUSIC' => '<h3 style="margin-top:0">¡Nuevas características!</h3>
            <ul><li><strong>Grupos</strong> &ndash; Deja que tus miembros creen grupos en tu red</li>
                <li><strong>Reproductor de música</strong> &ndash; Añade música y podcasts a tu red</li></ul>
            <p><a href="%s" class="desc add">Haz clic aquí para añadir características</a></p>',
        'NEW_FEATURES_ACTIVITY_BADGES' => '<h3 style="margin-top:0">¡Nuevas características!</h3>
            <ul><li><strong>Últimas actividades</strong> &ndash;Sigue las últimas actividades de los miembros de tu red</li>
                <li><strong> Insignias y widgets</strong> &ndash; Promociona tu red en Internet con insignias y widgets personalizados</li></ul>
            <p><a href="%s" class="desc add">Haz clic para añadir/editar características</a></p>',
        'YOUR_TYPE_NAME_HAS_NEW_COMMENT_APPNAME' => '¡Tus%2$s, %1$s, tienen un comentario nuevo sobre alguien en %3$s!',
        'YOUR_TYPE_HAS_NEW_COMMENT_APPNAME' => '¡Tu %1$s tiene un nuevo comentario sobre alguien en %2$s!',
        'HERE_IS_LINK' => 'Aquí tienes el enlace para unirte: <a %s>%s</a>',
        'THANKS_VALEDICTION' => 'Gracias,',
        'THANKS' => '¡Gracias!',
        'YOU_CHANGED_YOUR_EMAIL_ON_X' => 'Has cambiado tu dirección de email en %s.',
        'YOU_CHANGED_YOUR_EMAIL_ON_X_ELLIPSIS' => 'Has cambiado tu dirección de email en %s…',
        'CLICK_HERE_TO_SIGN_IN_WITH_YOUR_NEW_EMAIL_ADDRESS' => 'Haz clic aquí para abrir la sesión con tu nueva dirección de email:',
        'IF_DID_NOT_CHANGE_EMAIL_ADDRESS' => 'Si no has cambiado de dirección de email, haz clic aquí:',
        'TO_STOP_BEING_NOTIFIED_OF_NEW_DISCUSSIONS_GO_TO' => 'Para no recibir notificaciones cada vez que hay nuevas discusiones, ve a:',
        'X_STARTED_DISCUSSION_ON_APPNAME_ELLIPSIS' => '%1$s ha empezado una discusión nueva en %2$s…',
        'X_STARTED_THE_DISCUSSION_Y' => '%1$s ha empezado la discusión "%2$s".',
        'TO_VIEW_THIS_DISCUSSION_GO_TO' => 'Para ver esta discusión, ve a:',
        'X_HAS_INVITED_YOU_TO_JOIN_Y' => '¡%s te ha invitado a que te unas a %s!',
        'X_WANTS_YOU_TO_CHECK_OUT_Y' => '¡%s quiero que te veas "%s" en %s!',
        'CHECK_OUT_TITLE_ON_APPNAME' => '¡Desconéctate "%s" en%s!',
        'ABOUT_X' => 'Sobre %s',
        'YOU_HAVE_RECEIVED_BECAUSE_X' => 'Recibiste este email porque %s',
        'IF_YOU_NO_LONGER_WISH_FROM_X_CLICK_Y' => 'Si no deseas recibir más notificaciones vía email de parte de %s, <a %s>por favor haz clic aquí</a>.',
        'CLICK_HERE' => 'Haz clic aquí',
        'YOU_CAN_CONTACT_US' => 'Puedes ponerte en contacto con nosotros con cualquier pregunta o duda con respecto a tu privacidad en http://help.ning.com/?page_id=27.',
        'MESSAGE_TO_ALL_MEMBERS_OF_X' => 'Un mensaje a todos los miembros de %s',
        'CLICK_TO_CHECK_OUT' => '¡Haz clic aquí para verlo!',
        'CLICK_TO_APPROVE_X' => 'Haz clic aquí para aprobar o borrar este %s',
        'YOUR_X_HAS_BEEN_APPROVED' => '¡Tu %s ha sido aprobado(a) en %s!',
        'YOUR_X_WAS_NOT_APPROVED' => 'Tu %s no ha sido aprobado(a) en %s.',
        'CLICK_TO_VIEW_X' => '¡Haz clic aquí para ver este %s!',
        'CLICK_TO_VIEW_IT' => '¡Haz clic aquí para verlo!',
        'TO_VIEW_USER_PROFILE_VISIT' => 'Para ver el perfil de %s\' , visita:',
        'YOU_ADDED_CONTENT' => 'añadiste contenido a  %s, una red social moderada',
        'X_REPORTED_AN_ISSUE_ON_Y_ELLIPSIS' => '%1$s ha informado sobre una duda en %2$s',
        'X_REPORTED_THE_FOLLOWING_ISSUE' => '%s ha informado del siguiente tema.',
        'URL_REPORTED_COLON' => 'URL reportado:',
        'ISSUE_COLON' => 'Tema:',
        'ADDITIONAL_INFORMATION_COLON' => 'Información adicional:',
        'SEND_AN_INVITATION_TO_X' => 'Envía una invitación a %s',
        'SOMEBODY_REQUESTED_JOIN_X' => 'alguien pidió unirse a %s',
        'WANT_TO_ADD_A_WELCOME_MESSAGE_FOR_X_ON_THEIR_PROFILE_GO_TO' => '¿Quieres añadir un mensaje de bienvenida en el perfil de %s?  Ve a:',
        'USER_HAS_SENT_YOU_A_MESSAGE' => '%s te ha mandado un mensaje.',
        'TO_READ_THIS_MESSAGE_VISIT' => 'Para leer este mensaje, visita:',
        'X_HAS_SENT_YOU_A_MESSAGE_ON_Y_ELLIPSIS' => '¡%s te ha enviado un mensaje en %s!',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ELLIPSIS' => '%s te ha añadido como amigo',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ON_Y' => '%s te ha añadido como amigo en %s.',
        'X_HAS_ACCEPTED_YOUR_FRIEND_REQUEST' => '¡%s ha aceptado tu solicitud en %s!',
        'TO_ACCEPT_THIS_FRIEND_REQUEST_VISIT' => 'Para aceptar la petición de un amigo, visita:',
        'VIEW_XS_PAGE_ON_Y' => 'Ver la página de %s en %s',
        'MEMBER_OF_X_ACCEPTED' => 'un miembro de %s ha aceptado tu solicitud de amistad',
        'IF_NO_LONGER_WISH_FRIEND_NOTIFICATION_EMAIL_FROM_X_CLICK_Y' => 'Si no deseas recibir más notificaciones de solicitudes de amistad de parte de %s, <a %s>por favor, haz clic aquí</a>.',
        'YOU_RECEIVED_INVITATION_FROM_X' => 'Has recibido esta invitación de un miembro de %1$s. Si no deseas recibir más invitaciones de %1$s, por favor ponte en contacto con nosotros en http://help.ning.com/?page_id=27 .',
        'ON_X_COLON' => 'Sobre %s:',
        'ON_X' => 'sobre %s',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP' => '%s ha pedido membresía de %s.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X_ELLIPSIS' => '%1$s ha pedido membresía de %2$s en %3$s',
        'USER_HAS_INVITED_YOU_TO_JOIN_THE_GROUP_X' => '%1$s te ha invitado a unirte al grupo "%2$s"',
        'VISIT_GROUP_AT' => 'Visita %s en:',
        'ABOUT_GROUP' => 'Sobre %s',
        'A_MESSAGE_FROM_USERNAME_TO_GROUPNAME_ON_APPNAME' => '¡Un mensaje de %s a todos los miembros de %s en %s!',
        'YOU_CAN_SIGN_IN_USING_EMAIL_HERE' => 'Puedes abrir una cuenta con tu dirección de email aquí:',
        'USERNAME_COMMENTED_ON_BLOG_POST_TITLE_APPNAME' => '%s ha hecho un comentario sobre el post del blog \'%s\' en %s',
        'SEND_X_A_MESSAGE_HERE' => 'Manda un mensaje a %s aquí:',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X_ELLIPSIS' => '¡Tienes que aprobar un nuevo miembro en %s!',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE' => 'Tienes que aprobar un nuevo miembro.',
        'TO_APPROVE_XS_PROFILE_VISIT' => 'Para aprobar el perfil de %s\' , visita:',
        'CANT_CLICK_CUT_AND_PASTE' => '¿No puedes hacer clic en el enlace que está arriba? Simplemente copia y pega la dirección URL en tu navegador Web.',
        'CLICK_HERE_TO_JOIN_COLON' => 'Haz clic para unirte:',
        'CLICK_HERE_TO_JOIN_BANG' => '¡Haz clic para unirte!',
        'YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED_ELLIPSIS' => 'Tu membresía %s ha sido aprobada',
        'CONGRATULATIONS_BANG_YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED' => '¡Felicitaciones!  Tu membresía %s ha sido aprobada.',
        'YOU_CAN_NOW_SIGN_IN_USING_YOUR_EMAIL_ADDRESS_HERE' => 'Ahora puedes abrir la cuenta con el uso de tu dirección de email aquí:',
        'VISIT_X_AT_Y' => 'Visitar %1$s en: %2$s',
        'TO_CONTROL_WHICH_EMAILS_YOUR_RECEIVE_ON_X_GO_TO' => 'Para controlar qué emails quieres recibir en %1$s, ve a:',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_ELLIPSIS' => '¡Un miembro desautorizado en %s te ha mandado un mensaje!',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_USERNAME_WRITES' => 'Un miembro desautorizado en %1$s ha mandado un mensaje.  %2$s escribe:',
        'WELCOME_TO_THE_GROUP_X' => 'Bienvenido al grupo "%s"',
        'WELCOME_TO_GROUP_X_ON_Y_ELLIPSIS' => 'Bienvenido a %1$s en %2$s…',
        'TO_VIEW_THIS_GROUP_VISIT' => 'Para ver este grupo visita:',
        'X_INVITES_YOU_TO_JOIN_Y' => '%1$s te ha invitado a unirte a %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y' => '%1$s ahora es un miembro de %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y_ELLIPSIS' => '¡%1$s ahora es un miembro de %2$s!',
        'SOMEBODY' => 'Alguien',
        'TO_VIEW_YOUR_NEW_COMMENT_VISIT' => 'Para ver tu nuevo comentario, visita:',
        'TO_VIEW_THE_NEW_COMMENT_VISIT' => 'Para ver el nuevo comentario, visita:',
        'TO_VIEW_THE_NEW_REPLY_VISIT' => 'Para ver la nueva respuesta, visita:',
        'WELCOME_TO_X_THANK_YOU_FOR_JOINING' => '¡Bienvenido a %s! Gracias por unirte.',
        'NAME_COLON' => 'Nombre:',
        'EMAIL_COLON' => 'Email:',
        'AGE_COLON' => 'Edad:',
        'GENDER_COLON' => 'Género:',
        'LOCATION_COLON' => 'Ubicación:',
        'COUNTRY_COLON' => 'País:',
        'GET_NETWORK_BADGE' => '%s Insignia',
        'SPREAD_WORD_GET_BADGE' => '¡Riega la voz! Consigue tu propia insignia %s para tu sitio web o página Myspace. (<a %s>Consigue el código</a>)',
        'SPREAD_WORD_GET_BADGE_SHORT' => '¡Riega la voz! <a href="%s">Consigue tu propia %s insignia</a>',
        'SHOW_ALLEGIANCE_GET_BADGE' => 'Muestra tus alianzas. Consigue tu propia insignia  %s para tu sitio Web o tu página MySpace. (<a %s>Consigue el código</a>)',
        'USER_COMMENTED_ON_A_TYPE_ON_APPNAME' => '%1$s ha hecho un comentario sobre %2$s "%4$s" en %3$s',
        'UNABLE_TO_EXTRACT_EMAIL_ADDRESSES' => '¡Lo sentimos! No hemos podido extraer ninguna dirección de email del archivo.',
        'ADMINISTRATORS' => 'Administradores',
        'YOUR_INVITATION_HAS_EXPIRED' => 'Tu invitación ha caducado',
        'SORRY_INVITATION_EXPIRED' => 'Lo sentimos, la invitación que has usado ha caducado. Necesitarás una invitación nueva para unirte a %s.',
        'DISABLE_INVITATION_LINK' => '¿Deshabilitar el enlace de invitación?',
        'CREATING_LINK_WILL_DISABLE' => 'Crear un nuevo enlace de invitación deshabilitará el enlace actual. ¿Seguro que quieres crear un enlace nuevo?',
        'SHARE_LINK_WITH_PEOPLE' => 'Compartir este enlace con la gente que quieres que se una a esta red:',
        'CREATE_INVITATION_LINK' => 'Crear un nuevo enlace de invitación',
        'PLEASE_SELECT_SECOND_PART' => 'Por favor elige la segunda parte de tu dirección de email, por ejemplo, gmail.com.',
        'AT_SYMBOL_NOT_ALLOWED' => 'Por favor asegúrate que el símbolo @ no esté en la primera parte de la dirección email.',
        'SORRY_WE_DONT_SUPPORT' => 'Lo sentimos, no soportamos la libreta de dirección de esta Web. Intenta hacer clic en  \'aplicación de email\' que está abajo para usar las direcciones de tu ordenador.',
        'PLEASE_ENTER_PASSWORD_FOR_EMAIL' => 'Por favor escribe tu contraseña de %s.',
        'IMPORTING_ADDRESS_BOOK' => 'Importando la libreta de direcciones',
        'LEAVE_WINDOW_WHILE_GET' => '<strong>Por favor deja esta ventana abierta</strong> mientras obtenemos las direcciones de tus amigos. Cuando hayamos terminado, podrás elegir a qué amigos invitar.',
        'SHARE_THIS_LINK' => 'Compartir este enlace:',
        'SEND_WITH_EMAIL_PROGRAM' => 'Mándalo con el programa de email de tu ordenador:',
        'EMAIL_THIS' => 'Manda un email de esto',
        'IS_YOUR_FRIEND_PARENTHESIZED' => '(es tu amigo)',
        'CLEAR' => 'Borrar',
        'SEARCH_FRIENDS_TO_INVITE' => 'Buscar amigos para invitarles:',
        'YOUR_INVITATIONS_HAVE_BEEN_SENT' => 'Se han mandado tus invitaciones',
        'WANT_TO_INVITE_MORE' => '¿Quieres invitar a más amigos? Invita a más amigos importando contactos de la libreta de direcciones de tu Web o tu aplicación de email.',
        'MESSAGE_TOO_LONG' => 'El mensaje es demasiado largo. Por favor redúcelo a %s caracteres y vuélvelo a intentar.',
        'FOLLOWING_DO_NOT_SEEM_VALID' => 'Las siguientes no parecen ser direcciones de email válidas. Las invitaciones no se han enviado. Por favor corrige las direcciones de email y vuélvelo a intentar.',
        'PLEASE_ENTER_EMAIL_ADDRESSES' => 'Por favor escribe una o más direcciones de email.',
        'ENTER_EMAIL_ADDRESSES' => 'Escribe las direcciones de email',
        'SEPARATE_MULTIPLE_ADDRESSES' => 'Separa múltiples direcciones con comas',
        'YOUR_MESSAGE_OPTIONAL' => '<label>Tu mensaje</label> (Opcional)',
        'SEND_INVITATIONS' => 'Mandar invitaciones',
        'WEB_ADDRESS_BOOK' => 'Libreta de direcciones de la Web',
        'YAHOO_MAIL_HOTMAIL' => 'Yahoo Mail, Hotmail, GMail o AOL Mail',
        'YOUR_EMAIL_ADDRESS' => 'Tu dirección de email',
        'IMPORT_ADDRESS_BOOK' => 'Importar libreta de direcciones',
        'DONT_WORRY_WE_WONT_SAVE' => 'No te preocupes, no guardaremos tu contraseña y tendrás la oportunidad de elegir a qué amigos quieres mandar un mensaje.',
        'EMAIL_APPLICATION' => 'Aplicación email',
        'MICROSOFT_OUTLOOK_APPLE_MAIL' => 'Microsoft Outlook, Apple Mail, .CSV, etc.',
        'UPLOAD_CSV_OR_VCF' => 'Descarga un archivo .csv o .vcf exportado de Microsoft Outlook o la libreta de direcciones de Apple.',
        'BROWSE_FOR_FILE' => 'Buscar archivo',
        'UPLOAD' => 'Cargar',
        'SELECT_ELLIPSIS' => 'seleccionar…',
        'OTHER_ELLIPSIS' => 'otro…',
        'DONT_WORRY_YOULL_GET_CHANCE' => 'No te preocupes, tendrás la oportunidad de elegir a qué amigos mandarás un email.',
        'MEMBERSHIP_BY_INVITATION_ONLY' => 'Membresía sólo por invitación',
        'IF_YOU_ARE_ADMIN' => 'Si eres un administrador, <a %s>haz clic aquí para iniciar la sesión</a>.',
        'NAME_MUST_BE_SHORTER' => 'El nombre tiene que ser más corto que %s caracteres',
        'CITY_NAME_MUST_BE_SHORTER' => 'El nombre de la ciudad tiene que ser más corto que %s caracteres',
        'EMAIL_ALREADY_REGISTERED' => 'Esta dirección de email ya se ha registrado. Por favor elige otra.',
        'EMAIL_NOT_VALID' => 'Esta dirección de email parece ser no válida.',
        'USERNAME_INVITED_YOU_TO_APPNAME' => '%s te ha invitado a %s',
        'YOU_ARE_SIGNING_UP_WITH' => 'Te estás registrando con tu ID de Ning.',
        'NOW_ENTER_PASSWORD' => 'Ahora, escribe la contraseña para continuar.',
        'OR_SIGN_IN' => 'o <a %s>Inicia la sesión</a>',
        'CHANGE_ADDRESS' => 'Cambiar la dirección',
        'CHANGE_PAGE_ADDRESS' => 'Cambiar la página de direcciones',
        'PAGE_ADDRESS_TAKEN' => 'Lo sentimos, esta dirección ya existe. Por favor elige otra.',
        'PAGE_ADDRESS_NOT_VALID' => 'Sólo puedes usar las letras A-Z, números y el subrayado (_) en tu dirección.',
        'ADD_BY_PHONE' => 'Añadir por teléfono',
        'PAGE_ADDRESS' => 'Página de direcciones',
        'PHOTO_MUST_BE_TYPE' => 'Tu foto tiene que ser un archivo .jpg, .gif o .png.',
        'USEFUL_ADDRESSES' => 'Direcciones útiles',
        'MY_DETAILS' => 'Mis detalles',
        'NONE_I_DO_NOT_WANT' => 'Ninguno: no quiero recibir mensajes de %s',
        'CHANGE_PASSWORD' => 'Cambiar contraseña',
        'PROFILE_SAVED' => 'Tus cambios se han guardado con éxito.',
        'UPDATE_EMAIL_ADDRESS' => 'Actualizar la dirección de email',
        'EDIT_EMAIL_ADDRESS' => 'Editar tu dirección de email',
        'MY_SETTINGS' => 'Mi configuración',
        'ABOUT_ME' => 'Acerca de mí',
        'SELECT' => 'Seleccionar',
        'CITY' => 'Ciudad',
        'COUNTRY' => 'País',
        'DATE_OF_BIRTH' => 'Fecha de nacimiento',
        'DO_NOT_DISPLAY' => 'No visualizar',
        'GENDER' => 'Género',
        'CREATE_YOUR_PROFILE' => 'Crear tu perfil',
        'SYSTEM_REQUIREMENTS' => 'Requisitos del sistema',
        'WE_SUPPORT_INTERNET_EXPLORER' => 'Les damos soporte a Internet Explorer 6 y 7, Firefox 2.0 y Safari 2.0. Si usas un navegador diferente (a lo mejor uno que ofrece tu proveedor de servicio de Internet) puede que éste no sea compatible.',
        'MAKE_SURE_COOKIES' => 'Asegúrate que las cookies y JavaScript estén habilitados en tu navegador.',
        'WHAT_IS_MY_EMAIL' => '¿Qué es mi dirección de email?',
        'IF_JOINED_BEFORE_OCTOBER' => 'Si te uniste antes del 5 de octubre de 2007, antes te pediríamos una \'ID Ning\'. Ahora te pedimos que inicies la sesión con la dirección de email con la que te registraste; no obstante, todavía puedes usar tu ID Ning en este campo.',
        'CLICK_HERE_TO_RESET_PASSWORD' => 'Haz clic aquí para reestablecer tu contraseña.',
        'STILL_HAVING_PROBLEMS' => '¿Todavía tienes problemas?',
        'VISIT_NING_HELP_CENTER' => 'Visita el <a %s>el centro de ayuda de Ning </a> para más información sobre resolución de anomalías y soporte.',
        'PROBLEMS_SIGNING_UP_OR_SIGNING_IN' => 'Problemas para registrarse o iniciar una sesión',
        'WE_SENT_YOU_EMAIL' => 'Te hemos enviado un email con un enlace para reestablecer tu contraseña.',
        'RESET_PASSWORD_EMAIL_SUBJECT' => 'Reestablecer contraseña',
        'RESET_PASSWORD_EMAIL_BODY' => '%1$s,

Hemos recibido una petición para cambiar tu contraseña en %2$s.

Haz clic en el enlace que está debajo para configurar la nueva contraseña :

#{URL}

Si no quieres cambiar tu contraseña, puedes ignorar este email.

Gracias,
El "%2$s"

-----
%2$s usa la ID de Ning para autentificar.',
        'SET_PASSWORD' => 'Configurar contraseña',
        'NEW_PASSWORD' => 'Nueva contraseña',
        'CREATE_NEW_PASSWORD' => 'Crear nueva contraseña',
        'SET_NEW_PASSWORD' => 'Configurar una nueva contraseña para tu cuenta ID de Ning.',
        'CHOOSE_NEW_PASSWORD' => 'Por favor elige una nueva contraseña',
        'HELLO_USERNAME_SIGN_OUT' => '<strong>Hola, %s</strong> (<a %s>Cerrar sesión</a>)',
        'NO_ACCOUNT_WITH_EMAIL_X' => 'No hay ninguna cuenta con esta dirección de email %s',
        'PLEASE_ENTER_CODE' => 'Por favor escribe el código que aparece en la parte derecha.',
        'PROBLEMS_SIGNING_UP' => '¿Problemas registrándote?',
        'BY_SIGNING_UP_YOU_AGREE' => 'Al registrarte has aceptado los <a %s>Términos de servicio</a> o <a %s>política&nbsp;de&nbsp;privacidad</a>.',
        'FEEDBACK' => 'Comentarios',
        'TERMS_OF_SERVICE' => 'Términos de servicio',
        'PROBLEM_SIGNING_UP' => 'Hubo un problema en el proceso de registro',
        'ALREADY_MEMBER_SIGN_IN' => '¿Ya eres un miembro? <a %s>Haz clic aquí para iniciar la sesión</a>.',
        'MEMBERSHIP_TO_APPNAME_BY_INVITATION_ONLY' => 'La membresía de %s es sólo por invitación',
        'SORRY_BUT_ADMINISTRATOR_REQUIRES_INVITATION' => 'Lo sentimos, pero el administrador ha elegido que se necesita una invitación para unirte a %s. Si tienes una invitación, haz clic en el enlace del email para unirte.',
        'PROBLEM_SIGNING_IN' => 'Ha ocurrido un problema durante el inicio de la sesión',
        'WE_USE_NING_ID' => 'Tienes que usar el ID de Ning para autentificar. <a %s>¿Qué es una ID de Ning?</a>',
        'PROBLEMS_SIGNING_IN' => '¿Problemas para iniciar la sesión?',
        'SIGN_IN_OR_SIGN_UP' => '<input %s value="Acceso" /> &#160;or&#160; <strong><a %s>Registrarse</a></strong>',
        'SIGN_IN_TO_APPNAME' => 'Inicia la sesión en %s',
        'WHAT_IS_A_NING_ID' => '¿Qué es una ID de Ning?',
        'LARR_BACK' => '← <a %s>Atrás</a>',
        'NING_ID_LETS_YOU_CHOOSE' => 'El sistema de autenticación ID de Ning te permite elegir una dirección de email y una contraseña una vez y usarlas para unirte o iniciar una sesión en cualquier red que use la ID de Ning.',
        'WHEN_YOU_CREATE_NING_ID' => 'Cuando creas una ID de Ning, también puedes añadir un conjunto de detalles básicos y tu foto en tu cuenta ID de Ning. Estos detalles se inician por defecto cada vez que te unes a una red social nueva que use la ID Ning para autentificación. También te permite rastrear a tus amigos y mensajes por todas las redes sociales que uses.',
        'SIGN_IN_WITH_NING_ID_WHENEVER' => 'Puedes iniciar una sesión con la dirección de email de la ID de Ning y la contraseña cada vez que veas este símbolo: %s',
        'HELLO_USER' => 'Hola, %s',
        'TEXT_FOR_HEADER_TAB' => 'Este texto es para la pestaña de encabezado',
        'BASED_ON' => 'Basado en',
        'ARE_YOU_SURE_DELETE_LANGUAGE' => '¿Estás seguro que quieres borrar este idioma?',
        'DELETE_LANGUAGE' => 'Borrar idioma',
        'TEXT_RESET_TO_ORIGINAL_VERSION' => 'El texto se ha reestablecido a la versión original.',
        'UPLOAD_LANGUAGE_FILE' => 'Actualizar archivo de idioma',
        'ADD_TO_LANGUAGE' => 'Añadir a idioma:',
        'IF_YOU_CREATED_TRANSLATION' => 'Si has creado una traducción nueva en otra red social de Ning, puedes importar tu trabajo aquí. Los contenidos del archivo se añadirán al idioma de tu elección ¿No ves tu idioma en la lista? <a %s>Es fácil añadir uno nuevo</a>.',
        'EXAMPLES_SWEDISH_FINLAND' => 'Ejemplos: sueco (Finlandia), filipino, español (Puerto Rico)',
        'START_FROM_SCRATCH_CREATE' => '¡Comienza desde cero! Crea una nueva traducción de tu red escribiendo un nombre para el nuevo idioma, luego elige un idioma existente como punto de referencia.',
        'KEY_MISSING_TEXT' => 'Clave: <span %s>texto que falta</span> <span %s>texto cambiado</span>',
        'SHOW_ALL_TEXT' => 'Mostrar todo el texto',
        'SHOW_MISSING_TEXT' => 'Mostrar el texto que falta',
        'SHOW_CHANGED_TEXT' => 'Mostrar el texto cambiado',
        'EXAMPLES_TABS_MEMBERS_FRIENDS' => 'Ejemplos: pestañas, miembros, amigos',
        'RESET_TEXT_TO_ORIGINAL_VERSION' => 'Reestablecer el texto a la versión original',
        'ORIGINAL_TEXT_X' => 'Texto original en %s',
        'EDIT_LANGUAGE_ON_NETWORK' => 'Edita el idioma de tu red',
        'CUSTOMIZE_TEXT_ON_NETWORK_INCLUDING' => 'Personaliza cualquier texto de tu red, incluidos los nombres de etiquetas, pie de página de los emails, mensajes de error y mucho más.',
        'ACTIVE_LANGUAGE_IS_X' => '<em>El idioma activo de tu red es %1$s</em>. <a %2$s>Cambiar idioma activo</a>',
        'CURRENT_LANGUAGE_OPTIONS' => 'Opciones del idioma actual',
        'ACTIVE' => 'Activo',
        'MY_LANGUAGES' => 'Mis idiomas',
        'CREATE_NEW_TRANSLATION' => 'Crear una nueva traducción',
        'DONT_SEE_LANGUAGE_LISTED_CREATE' => '¿No ves tu idioma en la lista de arriba? <strong><a %s>Crear una nueva traducción para tu red</a></strong>.',
        'ADVANCED_IMPORT' => 'Importación avanzada',
        'IF_YOU_TRANSLATED_A_LANGUAGE' => 'Si has traducido un idioma en una red social existente, puedes  <strong><a %s>importar tu archivo de idioma</a></strong> y usarlo en esta red.',
        'LANGUAGE_EDITOR' => 'Editor de idioma',
        'PUBLIC' => 'Público',
        'GRANDFATHERED_PRIVACY_SETTING' => 'Tu configuración de privacidad actual, una red pública de la que los no miembros sólo pueden ver la pantalla de inicio de sesión, ya no está disponible. Tu configuración de privacidad no ha cambiado, pero si quieres hacer cambios aquí, no podrás volver. El equivalente actual es una red privada en la que cualquiera puede registrarse para ser miembro.',
        'NO_MISSING_ITEMS' => 'No hay elementos perdidos; esta traducción está 100% completa. <a %s>Ver todos los artículos </a>',
        'NO_CHANGED_ITEMS' => 'No hay elementos cambiados.',
        'COULD_NOT_FIND_ITEMS_MATCHING' => 'Lo sentimos, no hemos podido encontrar ningún elemento parecido <em>%s</em>. <a %s>Ver todos los elementos.</a>',
        'FILE_N' => 'Fichero %s',
        'TRANSLATION_FILE_HAS_FILENAME_LIKE' => 'Una traducción Ning tiene un nombre de fichero como <code>en_US.txt</code>. <a %s>Sigue leyendo.</a>',
        'SELECT_TRANSLATION_FILE' => 'Elegir fichero de traducción:',
        'USE_THIS_TRANSLATION' => 'Usar esta traducción',
        'FOLLOWING_ARE_MISSING_FROM_RULES' => 'Ten en cuenta que falta lo siguiente de las reglas que siguen: %s',
        'ALL' => 'Todas',
        'MISSING' => 'Faltan',
        'VIEW' => 'Ver',
        'TRANSLATION_CHANGES_SAVED' => 'Se han guardado tus cambios. Esta traducción está %s%% completa.',
        'TRANSLATION_CHANGES_SAVED_MAKE_CURRENT' => 'Se han guardado tus cambios. Esta traducción está  %s%% completa. ¿Quieres usarla como el idioma actual de tu red?',
        'TRANSLATION_UPLOAD_SUCCESSFUL' => 'Tu carga ha tenido éxito. Esta traducción está %s%% completa.',
        'TRANSLATION_UPLOAD_SUCCESSFUL_MAKE_CURRENT' => 'Tu carga ha tenido éxito. Esta traducción está %s%% completa. ¿Quieres usarla como el idioma actual de tu red?',
        'X_IS_CURRENT_LANGUAGE' => 'Ahora %s es el idioma de tu red.',
        'SAVE_PAGE' => 'Guardar página',
        'LANGUAGE_NAME_TAKEN' => 'Ese nombre ya existe. Por favor elige otro nombre.',
        'ENTER_NAME_FOR_TRANSLATION' => 'Por favor escribe un nombre para tu nueva traducción, por ejemplo, portugués (Portugal)',
        'CREATE' => 'Crear',
        'LANGUAGE_NAME' => 'Nombre del idioma',
        'SAVE_ITEMS_ON_PAGE' => 'Guarda los elementos en esta página',
        'NEW_TRANSLATION' => 'Nueva traducción',
        'MISMATCHED_CURLY_BRACKETS' => 'Llaves desiguales',
        'MISMATCHED_SQUARE_BRACKETS' => 'Corchetes desiguales',
        'MISMATCHED_PARENTHESES' => 'Paréntesis desiguales',
        'ERROR_PROCESSING_SPECIAL_RULES' => 'Ha ocurrido un error mientras se procesaba el código de reglas especiales.',
        'ERROR_PROCESSING_TAB_NAMES' => 'Ha ocurrido un error mientras se procesaba el código nombre de etiquetas.',
        'SPECIAL_RULES' => 'Reglas especiales',
        'TAB_NAMES' => 'Nombres de etiquetas',
        'SOURCE' => 'Fuente',
        'LANGUAGE_EDITOR_X' => 'Editor de Idioma: %s',
        'BACK_TO_LANGUAGE_EDITOR' => '←  Volver al Editor de Idioma',
        'CUSTOMIZE_YOUR_NETWORKS_TEXT' => 'Personaliza el texto de tu red y los mensajes o crea un idioma nuevo.',
        'STOPWORDS' => 'a | about | an | are | as | at | be | by | com | de | en | for | from | how | i | in | is | it | la | of | on | or | that | the | this | to | was | what | when | where | who | will | with | und | the | www',
        'STOPWORDS_ARE' => '<a %s>Stopwords</a>es una lista opcional de palabras que se tienen que filtrar para quitarlas de la descripción de la red cuando se crea la meta etiqueta en la parte superior de cada página. Opcional.',
        'I_AM_MEMBER' => 'Soy miembro de:',
        'VIEW_PAGE_ON_APPNAME' => 'Visita mi página en <em>%s</em>',
        'VISIT_APPNAME' => 'Visitar <em>%s</em>',
        'JOIN_US' => 'Únete',
        'CREATED_BY_COLON' => 'Creado por:',
        'GET_MORE_BADGES' => 'Obtén mas emblemas',
        'SHOW_LOGO' => 'Mostrar logotipo',
        'GALLERY' => 'Galería',
        'BADGES' => 'Emblemas',
        'MEMBER_BADGE' => 'Insignias de los miembros',
        'WEAR_IT_WITH_PRIDE' => '¡Exhíbelas con orgullo! Consigue un emblema de miembro %s que puedes desplegar en tu página web o MySpace.',
        'NETWORK_BADGE_LARGE' => 'Emblema de la Red (Grande)',
        'SPREAD_THE_WORD_NETWORK_BADGE_LARGE' => '¡Riega la voz! Obtén un emblema de %s que se actualiza automáticamente, mostrando los miembros mas populares de l red. Agrégalo a tu página web o de MySpace.',
        'NETWORK_BADGE_SMALL' => 'Emblema de la Red (Pequeño)',
        'SPREAD_THE_WORD_NETWORK_BADGE_SMALL' => '¡Riega la voz! Obtén un emblema %s que puedas mostrar en tu página Web o en tu página de MySpace.',
        'PHOTO_SLIDESHOW_PROPER' => 'Exposición de fotos',
        'DISPLAY_SELECTION_OF_PHOTOS' => 'Muestra una selección de tus fotos en una página Web o en tu página de MySpace con nuestro elegante expositor de fotos.',
        'MUSIC_PLAYER' => 'Reproductor de música',
        'PLAY_MUSIC_ON_WEBSITE' => 'Reproduce tu música en una página Web o en tu página de MySpace con nuestro elegante reproductor de música.',
        'ADD_A_VIDEO_MORE_OPTIONS' => 'Añade un video a tu página Web o a tu página MySpace. ¿Buscas más opciones? <a href="%s">Ver todos los videos </a> en %s.',
        'LARGE_N_PIXELS_WIDE' => 'Grande - %d píxeles de ancho',
        'MEDIUM_N_PIXELS_WIDE' => 'Mediano - %d píxeles de ancho',
        'SMALL_N_PIXELS_WIDE' => 'Pequeño - %d píxeles de ancho',
        'MY_MOST_RECENT' => 'Más recientes',
        'APP_ICON' => 'Icono de aplicación',
        'MEMBERSHIP_TO_X_IS_BY_INVITATION' => 'Membresía a %s es sólo por invitación',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK' => '%s ofreció el siguiente comentario:',
        'X_PROVIDED_FEEDBACK_ON_Y_ELLIPSIS' => '%1$s ofreció comentarios sobre %2$s...',
        'THANK_YOU_YOUR_MESSAGE_HAS_BEEN_SENT' => 'Gracias. Tu mensaje ha sido enviado.',
        'X_WOULD_LIKE_TO_JOIN_X' => '¡%s quiere unirse a %s!',
        'X_HAS_REQUESTED_AN_INVITATION' => '%s ha solicitado una invitación a %s',
        'YOUR_REQUEST_HAS_BEEN_SENT' => 'Tu solicitud ha sido enviada al creador de la red.',
        'TO_UNBAN_USERNAME_GO_TO' => 'Para quitar una prohibición %s, ve a:',
        'SEND_REQUEST' => 'Enviar solicitud',
        'SEARCH' => 'Buscar',
        'SEARCH_AGAIN' => 'Buscar nuevamente',
        'SEND_BROADCAST_MESSAGE' => 'Mandar un mensaje a todos los miembros',
        'VERIFICATION_IMAGE' => 'Imagen de verificación',
        'UNDER_CONSTRUCTION' => 'En construcción',
        'PROFILE_INFORMATION_SAVED' => 'Información del perfil grabada',
        'YOUR_SITES_DIRECTORY_PROFILE' => 'La información de tu directorio de perfiles de tu red social ha sido grabada.',
        'NO_ACCOUNT_WITH_EMAIL' => 'No hay ninguna cuenta con esta dirección de email.',
        'INVALID_PASSWORD_CHECK_CAPS_LOCK' => 'Contraseña no válida ¿Tienes el bloqueador de mayúsculas puesto?',
        'OOPS_THAT' => '¡Ups! Eso no funcionó.',
        'OOPS_THAT_DID_NOT_WORK' => 'Eso no funcionó. ¿Pruebas otra vez?',
        'OOPS_THAT_DID_NOT_WORK_ERROR_CODE' => '¡Ups! Eso no funcionó (%s).',
        'NOT_FOUND' => 'No se encontró',
        'YOUR_SITES_FEATURE_LIST' => 'El listado de las aplicaciones de tu red ha sido salvado.',
        'ONE_LINE_ANSWER' => 'Respuesta de una línea',
        'LONGER_ANSWER' => 'Respuesta más larga',
        'MULTIPLE_CHOICE' => 'Opciones múltiples',
        'DATE' => 'Fecha',
        'WEBSITE_ADDRESS' => 'Dirección de página Web',
        'EVERYTHING' => 'Todo',
        'JUST_THE_HOMEPAGE' => 'Sólo la página principal',
        'JUST_THE_SIGN_UP_PAGE' => 'Sólo la página de registro',
        'YOUR_CHANGES_HAVE_BEEN_SAVED' => 'Tus cambios han sido grabados.',
        'JOIN_ME_ON_X' => '¡Únete a mi en %s!',
        'NOT_ALLOWED' => 'No está permitido',
        'COME_JOIN_ME_ON_X' => '¡Ven y únete a %s!',
        'COME_JOIN_ME_ON_X_ELLIPSIS' => '¡Ven y únete a %s!',
        'X_NOT_VALID_EMAIL' => '%s no es una dirección de email o un ID válido',
        'USER_BANNED_FROM_NETWORK' => '%1$s tiene prohibido acceder a esta red. <a %2$s>Envía un mensaje a %1$s</a>',
        'USER_ALREADY_NETWORK_MEMBER' => '%1$s Ya es un miembro de esta red. <a %2$s>Envía un mensaje a %1$s</a>',
        'YOU_CAN_SEND_AT_MOST_X' => 'Puedes enviar como máximo %s al mismo tiempo.',
        'PLEASE_ENTER_YOUR_FRIENDS' => 'Por favor introduce las direcciones de email de tus amistades o sus IDs',
        'THERE_HAS_BEEN_AN_ERROR' => 'Ha ocurrido un error',
        'INVITATIONS_HAVE_BEEN_SENT' => 'Tu invitación ha sido enviada.',
        'SEARCH_RESULTS' => 'Resultados de la búsqueda',
        'INVITE_YOUR_FRIENDS' => 'Invita a tus amistades',
        'SEND_INVITATIONS_FOR_FRIENDS' => '¡Envía invitaciones a tus amistades para que se unan a',
        'INVITATION' => 'Invitación',
        'ADD_FROM_ADDRESS' => 'Añadir desde una agenda de direcciones',
        'TO' => 'Para:',
        'SEND_TO' => 'Enviar a',
        'SUBJECT' => 'Asunto',
        'YOUR_MESSAGE' => 'Tu mensaje',
        'SEND' => 'Enviar',
        'REPORT_AN_ISSUE' => 'Reportar un problema',
        'TYPE_OF_ISSUE' => 'Tipo de problema',
        'ADULT' => 'Adulto',
        'ABUSIVE' => 'Abusivo',
        'BUG' => 'Problema',
        'FRAUD' => 'Fraude',
        'SPAM' => 'Basura',
        'OTHER' => 'Otros',
        'DESCRIBE_YOUR_ISSUE' => 'Describe el problema',
        'SEND_REPORT' => 'Enviar un informe',
        'ADDED_BY_X_AT_X' => 'Añadido por <a %s>%s</a> at %s en %s',
        'ADDED_BY_USER_TO_GROUP_AT_DATE' => 'Añadido por <a %s>%s</a> a %s en %s en la fecha %s',
        'G_IA' => 'g:ia',
        'F_JS_Y' => 'F jS, Y',
        'CLICK_TO_VIEW' => 'Haz clic para ver',
        'COMMENT_FOR' => 'Comentario para:',
        'COMMENT_ON' => 'Comentario en:',
        'ACTION_BUTTON_FEATURE' => 'Destacar',
        'FEATURE_THIS_ON_YOUR' => 'Destaca esto en tu página principal',
        'ACTION_BUTTON_REMOVE' => 'Quitar',
        'REMOVE' => 'Quitar',
        'REMOVE_THIS_FROM_YOUR' => 'Quitar esto de la página principal',
        'FEATURE_ON_HOME' => 'Destaca esto en la página principal',
        'REMOVE_FROM_HOME' => 'Quitar de la página principal',
        'ITEM_WILL_APPEAR' => 'Este elemento ahora aparecerá en los módulos seleccionados de la página principal',
        'ITEM_WILL_NO_LONGER_APPEAR' => 'Este elemento no aparecerá más en los módulos seleccionados de la página principal',
        'ADD_CONTENT' => 'Añadir contenido',
        'BROUGHT_TO_YOU_BY' => '%s te lo trae %s © %s',
        'GIVE_US_YOUR_FEEDBACK' => 'Envíanos comentarios',
        'FOR_ADDITIONAL_QUESTIONS_OR_TO_CONTACT_NING_PLEASE_CLICK_HERE' => 'Para más preguntas o para contactar con Ning, por favor haz clic aquí:',
        'SEND_FEEDBACK' => 'Enviar comentarios',
        'SIGN_OUT' => 'cerrar sesión',
        'SIGN_OUT_TITLE' => 'Cerrar sesión',
        'EDIT_MY_PROFILE' => 'Editar repuestas de mi perfil',
        'INVITE_MORE' => 'Invitar más',
        'USE_THIS_FORM_TO_SEND_FEEDBACK_TO_NC' => 'Usa este formulario para enviar comentarios a  <a %s>%s</a>, el creador de <a %s>%s</a>.',
        'YOUR_FEEDBACK' => 'Tus comentarios',
        'NETWORK_INFORMATION' => 'Información de la red',
        'ABOUT_YOUR_SITE' => 'Sobre tu red',
        'WELCOME_TO_YOUR_SITE' => '¡Bienvenido a tu red social!',
        'EDIT_YOUR_NETWORKS_INFO' => 'Edita el nombre de tu red, la descripción y otra información.',
        'TAGLINE' => 'Rótulo',
        'APPEARS_IN_HEADER' => 'Aparece en el encabezado de tu red',
        'APPEARS_IN_EMAILS' => 'Aparece en los emails',
        'NETWORK_NAME' => 'Nombre de la red',
        'DESCRIPTION' => 'Descripción',
        'KEYWORDS' => 'Palabras claves',
        'LANGUAGE' => 'Lenguaje',
        'SEPARATE_EACH_KEYWORD' => 'Separa cada palabra clave con una coma',
        'ICON' => 'Icono',
        'UPLOAD_A_PHOTO_WHICH_WILL_BE_RESIZED' => 'Puedes cargar una pequeña foto (GIF, JPG o PNG), la cuál será modificada al tamaño de un cuadrado. La nueva foto tardará unos minutos en aparecer.',
        'SAVE_SETTINGS' => 'Guardar configuración',
        'SUCCESS_EXCLAMATION' => '¡Éxito!',
        'FEATURES' => 'Aplicaciones',
        'ADD_FEATURES' => 'Añadir funciones a tu red',
        'ORGANIZE_FEATURES' => 'Organiza tu página inicial arrastrando las funciones que aparecen en la lista de abajo y luego ponlas como quieras.',
        'SKIP_FEATURES' => 'Haz clic en <a href="%s">Saltarse este paso</a> para continuar con la distribución y las características por defecto.',
        'FEATURES_FOR_ALL_PAGES' => 'Las características que se añadan en esta caja aparecerán en todas las páginas de tu red.',
        'CUSTOMIZE_SITE_BY_ADDING' => 'Configura tu red social añadiendo nuevas aplicaciones o quitando las existentes.',
        'ADJUST_YOUR_SITES_COLORS' => 'Ajusta los colores, las imágenes y el estilo en general de tu red social.',
        'APPEARANCE' => 'Apariencia',
        'PROFILE_QUESTIONS' => 'Preguntas para el perfil',
        'EDIT_QUESTIONS_THAT_MEMBERS_ANSWER' => 'Edita las preguntas que los miembros contestan sobre sí mismos.',
        'MESSAGE_SENT' => '¡Mensaje enviado!',
        'YOUR_MESSAGE_HAS_BEEN_SENT' => 'Tu mensaje ha sido enviado a todos los miembros de tu red.',
        'YOUR_MESSAGE_HAS_BEEN_SENT_GROUP' => 'Tu mensaje ha sido enviado a todos los miembros de tu grupo.',
        'YOUR_MESSAGE_IS_BEING_SENT' => 'Tu mensaje está siendo enviado. Por favor espera, esto puede tardar algunos minutos.',
        'BROADCAST_MESSAGE' => 'Difunde un mensaje',
        'TRACK_VISITORS_AND_TRENDS' => 'Rastrea a tus visitantes y sus tendencias en tu red social.',
        'EDIT_SOURCE_CODE' => 'Editar el código fuente',
        'TAKE_FULL_CONTROL' => 'Toma control total de la funcionalidad de tu red por medio de la edición del código fuente.',
        'DELETE_THIS_SITE' => 'Borrar tu red social',
        'MAIN_PAGE' => 'Página principal',
        'MAIN' => 'Principal',
        'MAIN_TAB_TEXT' => 'Principal',
        'MANAGE' => 'Administrar',
        'MANAGE_TAB_TEXT' => 'Administrar',
        'PAGE_TITLE' => 'Título de página',
        'LOREM_IPSUM_1' => 'Lorem <span %s>ipsum dolor</span> sit amet, consectetuer adipiscing elit. Nunc scelerisque blandit dolor. Vestibulum ante ipsum primis in faucibus orci luctus.',
        'LOREM_IPSUM_2' => 'Lorem ipsum dolor sit amet, consectetuer adipiscing',
        'LOREM_IPSUM_3' => 'Lorem ipsum dolor sit amet, <span class="preview_link">consectetuer</span> adipiscing',
        'EDIT_THE_APPEARANCE' => 'Edita la apariencia de tu página',
        'CHOOSE_A_THEME' => 'Elige un tema gráfico para tu red social',
        'NOW_CUSTOMIZE_SITE' => '¡Ahora puedes personalizar tu red social!',
        'THEME_SETTINGS' => 'Configuración de Tema',
        'ADVANCED' => 'Avanzado',
        'TOP_BAR_AND_FOOTER' => 'Encabezado y pie de página',
        'HEADER_AND_NAVIGATION' => 'Encabezado y navegación',
        'ADD_A_LOGO' => 'Añade un logotipo',
        'THIS_IMAGE_WILL_REPLACE' => 'Esta imagen reemplazará el texto con el nombre de la red',
        'TABS' => 'Pestañas',
        'TAB' => 'Pestaña',
        'SITE' => 'Red',
        'SIDES' => 'Laterales',
        'BODY' => 'Cuerpo',
        'SHOW_NING_LOGO' => '¿Mostrar el logotipo de Ning?',
        'LAUNCH' => '¡LANZAR!',
        'NING_ID' => 'Ning ID',
        'PASSWORD' => 'Contraseña',
        'RETYPE_PASSWORD' => 'Reescribe la contraseña',
        'TYPE_CODE_ON_RIGHT' => 'Escribe el código<br />en la derecha',
        'JOIN_X' => 'Únete a %s',
        'SIGN_UP_FOR_X' => 'Regístrate en %s',
        'HAS_INVITED_YOU_TO_X' => 'te ha invitado a que te unas a la %s.',
        'CONTENT_AWAITING_APPROVAL' => 'Contenido que espera aprobación',
        'NEW_MEMBER' => '¿Nuevo miembro?',
        'JOIN_X_NOW' => '¡Únete a %s ahora!',
        'HIDE_THIS_MESSAGE' => 'Ocultar este mensaje',
        'PAGE_NOT_FOUND' => 'Página no encontrada',
        'THIS_PAGE_WAS_NOT_FOUND' => 'Lo sentimos, no se encontró esta página',
        'FOLLOW_THESE_LINKS_TO' => 'Sigue estos enlaces a algunas cosas que sabemos que están disponibles:',
        'ALTERNATIVELY_YOU_CAN_SEARCH' => 'Por otra parte, puedes buscar esta red social:',
        'IF_YOU_GET_THIS_MESSAGE' => 'Si te aparece este mensaje nuevamente, <a %s>por favor de háznoslo saber.</a>',
        'GROUP_MEMBERS' => 'Miembros del grupo',
        'VIDEOS' => 'Videos',
        'BLOG' => 'Blog',
        'ACCOUNT' => 'Cuenta',
        'WE_ARE_SORRY_WE_ARE_HAVING' => 'Discúlpanos, estamos teniendo un problema con esta página.',
        'FOLLOW_LINK_TO_HOMEPAGE' => 'Sigue <a %s>este enlace</a> a la página principal.',
        'REQUEST_AN_INVITATION' => 'Pedir una invitación',
        'NAME' => 'Nombre',
        'EMAIL_ADDRESS' => 'Dirección de email',
        'MESSAGE_OPTIONAL' => 'Mensaje (Opcional)',
        'SORRY_HOWEVER_ITS_EASY' => '<strong>¡Disculpa!</strong> De todas maneras, es fácil comenzar tu propia red social.',
        'GET_YOUR_OWN_BAZEL' => '¡Crea tu propia red social!',
        'SITE_IS_NOT_READY' => '¡Esta red social todavía no está lista!',
        'BAZEL_IS_BEING_SET_UP' => '¡Esta red social todavía está siendo configurada!',
        'SIGN_IN' => 'Iniciar sesión',
        'FORGOT_YOUR_PASSWORD' => '¿Olvidaste tu contraseña?',
        'FORGOT_YOUR_PASSWORD_TITLE' => '¿Olvidaste tu contraseña?',
        'ENTER_EMAIL_AND_CLICK_RESET_PASSWORD' => 'Escribe tu dirección email y haz clic en  \'Reestablecer contraseña\'. Recibirás un email con un enlace para reestablecer tu contraseña.',
        'RESET_PASSWORD' => 'Reestablecer contraseña',
        'EXPLORE' => 'Explora',
        'SIGN_UP' => 'Registrarse',
        'CONFIRM_PASSWORD' => 'Confirma la contraseña',
        'VERIFICATION' => 'Haznos saber que eres <br />una persona',
        'YOUR_PHOTO' => 'Tu foto',
        'SUMMARY' => 'Resumen',
        'YOUR_SITE_IS_READY' => '¡Tu red social está lista para ser lanzada! La configuración predeterminada será usada para los pasos que te has saltado. Vuelve atrás para hacer cambios, o haz clic en  \'¡Lanzar!\' para lanzar tu red.',
        'WHEN_YOU_ARE_FINISHED' => '¡Cuando termines, haz clic en \'Ver diseño\' para ver los resultados!',
        'COMPLETE' => 'completo',
        'INCOMPLETE' => 'incompleto',
        'VIEW_LAYOUT' => 'Ver diseño',
        'CLEAR_CONTENTS' => 'Limpiar contenidos',
        'ADD_MODULE' => 'Añadir módulo…',
        'ADD_COLUMNS' => 'Añadir columnas…',
        'PUBLIC_ANYBODY_CAN_JOIN' => '<strong>Pública</strong> Cualquiera puede unirse',
        'PRIVATE_ONLY_INVITED' => '<strong>Privada</strong> Sólo la gente que está invitada puede verla y unirse',
        'INVITATIONS' => 'Invitaciones',
        'MEMBERS_CAN_INVITE' => 'Miembros pueden invitar a otros.',
        'QUESTION_TITLE' => 'Título de la pregunta',
        'ANSWER_TYPE' => 'Tipo de respuesta',
        'REQUIRED' => '¿Necesario?',
        'PRIVATE' => 'Número privado',
        'CHOICES' => 'Opciones',
        'SEPARATE_EACH_CHOICE' => 'Separa cada opción con una coma',
        'CAN_PICK_MORE' => 'Puedes elegir más de una',
        'ADD_ANOTHER_QUESTION' => 'Añade otra pregunta',
        'WHAT_INFORMATION' => '¿Qué preguntas te gustaría que tus miembros respondieran cuando se unan a tu red? Puedes reordenar las preguntas que están debajo. Simplemente haz clic sobre la pregunta y arrástrala a donde quieres que aparezca.',
        'IF_YOU_SELECT_REQUIRED_MEMBERS_WILL' => 'Si eliges “Requisito”, los miembros tendrán que responder la pregunta para unirse. Si eliges "Privada", la pregunta sólo la verás tú y otros administradores.',
        'WE_COULD_NOT_FIND_ANYTHING' => 'No pudimos encontrar nada que coincida con "%s". ¿Por qué no buscas otra cosa?',
        'GET_CUSTOM_URL' => 'Consigue el nombre de URL que quieras, espacio de almacenamiento y ancho de banda, o publica tus propios avisos.',
        'TRACK_STATISTICS' => 'Mantener estadísticas',
        'TRACKING_CODE' => 'Código de seguimiento',
        'ANY_JAVASCRIPT_CODE' => 'Cualquier código de JavaScript que copies aquí se inserta en la parte inferior de todas las páginas de tu red. Puedes usarlo para sistemas de seguimiento externos, como por ejemplo Google Analytics.',
        'ANALYTICS_LEARN_MORE' => 'Para saber más acerca de Google Analytics y configurar tu cuenta, <a %s>haz clic aquí</a>.',
        'RESOURCES' => 'Recursos',
        'LINKS' => 'Enlaces',
        'PAGE' => 'Página',
        'BACKGROUND' => 'Fondo',
        'TEXT' => 'Texto',
        'HEADING_TEXT' => 'Texto del encabezado',
        'FONT' => 'Fuente',
        'AABBCC' => 'AaBbCc',
        'COLOR' => 'Color',
        'LINK_COLOR' => 'Color de los enlaces',
        'BODY_TEXT' => 'Cuerpo del texto',
        'MIDDLE' => 'Medio',
        'FEATURE_BOXES' => 'Cajas de características',
        'TITLEBAR_TEXT_COLOR' => 'Color del texto del encabezado',
        'TITLEBAR_BACKGROUND' => 'Fondo del encabezado',
        'UPLOADING_CONTENT' => 'Cargando contenido…',
        'WHEN_UPLOADING_IS_COMPLETE' => 'Cuando la carga complete podrás echarle un vistazo a la red.',
        'FINISH' => 'Finalizar',
        'FLICKR_IMPORT_SETUP' => 'Configuración de la importación de Flickr',
        'FLICKR_API_KEY' => 'Tu clave',
        'FLICKR_SECRET' => 'Tu secreto',
        'FLICKR_KEY_ERROR' => 'Hubo un problema con la clave o secreto de Flickr que introdujiste. ¿Puedes corroborarlos y tratar de introducirlos nuevamente?',
        'FLICKR_INTRO' => '¿Quieres dejar que tus miembros importen sus fotos de Flickr? Has llegado al lugar correcto. Si ya tienes una clave y un secreto en Flickr, puedes <a %s>saltarte este paso</a>. ¿No estás muy seguro de lo que eso significa? Sigue los pasos que están debajo y en un par de minutos estarás listo.',
        'FLICKR_GET_ACCOUNT' => 'Si todavía no tienes una cuenta Flickr, consigue una <a %s>aquí</a>.',
        'FLICKR_STEP1_TITLE' => 'Paso 1: Consigue una llave API Flickr',
        'FLICKR_STEP1_APPLY_SCREEN' => 'Aplica la llave API en la pantalla de Flickr',
        'FLICKR_STEP1_API_SCREEN' => 'Llave API en la pantalla de Flickr',
        'FLICKR_STEP1_INTRO' => 'Inicia la sesión en Flickr y <a %s>pide una llave API nueva</a> (se abre en una ventana nueva).',
        'FLICKR_STEP1_A' => 'Rellena <strong>tu nombre</strong> y <strong>tu dirección email</strong>.',
        'FLICKR_STEP1_B' => 'Debajo de<strong>Esta clave es para&hellip;</strong> elige la opción <em>uso no comercial </em>.',
        'FLICKR_STEP1_C' => 'Describe tu red social en la caja <strong>Describe la aplicación que planeas construir</strong>.',
        'FLICKR_STEP1_D' => 'Marca ambas cajas de aceptación.',
        'FLICKR_STEP1_APPLY' => 'Cuando termines, haz clic en el botón <strong>Aplicar</strong>.',
        'FLICKR_STEP1_E' => 'Aparecerá una pantalla que mostrará tu nueva llave API. Haz clic en el enlace <strong>Haz clic aquí</strong> para configurar la autentificación de usuario para esta llave.',
        'FLICKR_STEP2_TITLE' => 'Paso: Configura tu llave',
        'FLICKR_STEP2_SETUP_SCREEN' => 'Pantalla de configuración de autentificación de la llave API de Flickr',
        'FLICKR_STEP2_F' => 'Copia la siguiente dirección de Web en el campo <strong>URL de retorno de llamada</strong> :',
        'FLICKR_STEP2_SAVE_CHANGES' => 'Cuando hayas terminado haz clic en el botón <strong>Guardar cambios</strong>.',
        'FLICKR_STEP3_TITLE' => 'Paso 3: Escribe tu información',
        'FLICKR_STEP3_KEYS_SCREEN' => 'Pantalla de información de la llave API de Flickr',
        'FLICKR_STEP3_CONGRATULATIONS' => '¡Felicitaciones! Te has registrado en Flickr.',
        'FLICKR_STEP3_COMPLETE' => 'Para completar la configuración de %s, simplemente copia y pega tu clave/secreto en los siguientes campos:',
        'COMPLETE_SETUP' => 'Configuración completa',
        'SETUP_YOUR_SITE_TO' => 'Configura tu red social para importar fotos desde Flickr.',
        'FLICKR_IMPORTING' => 'Importar de Flickr',
        'YOU_NEED_TO_SET_UP_FLICKR' => 'Necesitas configurar tu red social para que la gente pueda importar sus fotos desde Flickr. Sólo te llevará unos pocos minutos, así que ¿por qué <a %s> no lo haces ahora?</a>',
        'DONT_SHOW_THIS_AGAIN_FLICKR' => 'Por favor no me muestres esto nuevamente.',
        'YOUVE_SIGNED_OUT_OF_X' => 'Has salido de %s sin problemas. ¡Por favor vuelve y únete a nosotros nuevamente pronto!',
        'CREATED_THIS_SOCIAL_NETWORK' => 'creó esta red social en <a href=\'http://www.ning.com\'>Ning</a>.',
        'CREATE_YOUR_OWN' => '¡Crea tu propia red social en Ning gratis!',
        'DRAG_HERE_TO_REMOVE_FEATURE' => 'Arrastrar aquí para quitar aplicación',
        'LAYOUT' => 'Diseño',
        'DRAG' => 'Arrastra',
        'HERE' => 'Aquí',
        'YOU' => 'Tus',
        'ADS' => 'Anuncios',
        'MEMBERS' => 'Miembros',
        'HELLO_USERNAME' => 'Hola, nombre de usuario',
        'CREATED_BY' => 'Creado por',
        'SAVE_FEATURES' => 'Guardar Aplicaciones',
        'FORUM' => 'Foro',
        'CATEGORIES' => 'Categorías',
        'FORUM_CATEGORIES' => 'Categorías del foro',
        'A_THREADED_DISCUSSION_FORUM' => 'Foro de conversaciones',
        'ALLOW_MEMBERS_TO_CREATE_GROUPS' => 'Permite que los miembros creen sus propios grupos de interés en tu red',
        'FEATURE_POSTS_FROM_YOUR_BLOG' => 'Destaca posts de tu blog o de blogs de otros miembros',
        'TEXT_BOX' => 'Caja de texto',
        'PUT_ANY_TEXT_WIDGET_OR_HTML' => 'Pon cualquier texto, widget o HTML en la página principal.',
        'A_LIST_OF_MEMBERS' => 'Una lista de los miembros de tu red social',
        'ALLOW_USERS_PHOTOS' => 'Permite a las personas que suban y compartan fotos',
        'ADD_FEEDS_FROM_ACROSS_THE_WEB' => 'Añade alimentadores de la red',
        'INFORMATION_ABOUT_THE_USER' => 'Información sobre las personas que se encuentran conectadas en este momento',
        'ALLOW_USERS_VIDEOS' => 'Permite a las personas añadir y compartir videos',
        'SHOW_NETWORK_DESCRIPTION' => 'Muestra la descripción de tu red',
        'PROMOTE_NETWORK_WITH_BADGES' => 'Promociona tu red en la Web con insignias y widgets personalizados',
        'MONETIZE_WITH_ADS' => 'Monetiza tu red con publicidad',
        'LET_MEMBERS_KNOW_WHO_CREATED_NETWORK' => 'Permite que tus miembros sepan quién creó esta red',
        'FOLLOW_LATEST_ACTIVITY' => 'Sigue las últimas actividades de los miembros de tu red',
        'FAQ_FOR_NETWORK_CREATORS' => 'Preguntas frecuentes para creadores de redes',
        'ANSWERS_TO_FAQS' => 'Respuestas a preguntas frecuentes para modificar tu red social.',
        'MEET_OTHER_LIKEMINDED' => 'Conoce a otros creadores de redes parecidos a ti, comparte ideas y obtén soporte técnico del grupo de Ning.',
        'CUSTOMIZE_THE_APPEARANCE_NETWORK' => 'Personaliza la apariencia de tu red social añadiendo tu propio estilo de hojas de estilo cascada (CSS) en el campo de la izquierda. (<a href="%s">¿Qué es CSS?</a>)',
        'CUSTOMIZE_THE_APPEARANCE_PAGE' => 'Personaliza la apariencia de tu página añadiendo tu propio estilo de hojas de estilo cascada (CSS) en el campo de la izquierda. (<a href="%s">¿Qué es CSS?</a>)',
        'CSS_ON_YOUR_SOCIAL_NETWORK' => 'CSS en tu red social',
        'CSS_ON_YOUR_PAGE' => 'CSS en tu página',
        'ADDING_YOUR_OWN_CSS_NETWORK' => 'Añadir tu propio CSS te dará un control total sobre la tipografía, los colores, los espacios y el estilo general de tu red.',
        'ADDING_YOUR_OWN_CSS_PAGE' => 'Añadir tu propio CSS te dará control total sobre la tipografía, los colores, los espacios y el estilo general de tu página.',
        'CSS_STYLES_WILL_OVERRIDE' => 'El estilo de CSS que añadas aquí eliminará cualquier estilo de CSS que hayas elegido con anterioridad.',
        'NEED_HELP_FIGURING_OUT_CSS' => '¿Necesitas ayuda para saber cuál es la clase específica de CSS en tu red? Te recomendamos la aplicación "Inspeccionar" de la extensión <a href="%s">Firebug</a> gratuita (para el navegador Firefox ).',
        'WANT_TO_LEARN_MORE' => '¿Quieres aprender más? Fíjate nuestra sección de <a href="%s">Personalización avanzada</a> .',
        'APPLY_XS_THEME' => 'Aplicar el tema de %s',
        'X_ALREADY_REGISTERED_Y_TO_RESET' => 'El ID registrado con la dirección de email %s ya existe. Utiliza este formulario para acceder con tu ID o email. Si olvidaste tu clave, <a href="%s">haz clic aquí para recibir una nueva</a>.',
        'INVITED' => 'Invitado',
        'REQUESTED_INVITE' => 'Pidió invitación',
        'BAN_FROM_NETWORK' => 'Prohibir acceso',
        'REMOVE_BAN' => 'Permitir acceso',
        'CANCEL_INVITATION' => 'Cancelar invitación',
        'IGNORE' => 'Rechazar',
        'PROMOTE_TO_ADMINISTRATOR' => 'Dar privilegios de administrador',
        'DEMOTE_FROM_ADMINISTRATOR' => 'Quitar privilegios de administrador',
        'STATUS' => 'Estado',
        'DATE_JOINED' => 'Fecha en que se unió',
        'DATE_INVITED' => 'Fecha en que fue invitado',
        'DATE_REQUESTED' => 'Fecha solicitada',
        'DATE_APPLIED' => 'Fecha de aplicación',
        'NETWORK_CREATOR' => 'Creador de la red',
        'NETWORK_ADMINISTRATOR' => 'Administrador',
        'ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Los administradores tienen un nivel similar de control al Creador de la red.',
        'DOWNLOAD_ALL_MEMBER_DATA' => 'Exportar todos los datos de los miembros (.CSV)',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Los datos de tus miembros se han exportado. Haz clic con el botón derecho a <a %s>este enlace</a> y elige  \'Guardar como\' para guardarlo en tu escritorio.',
        'CLICK_GO_TO_START_EXPORT' => 'Haz clic en Ir para empezar la exportación. Si tienes muchos miembros, el proceso tardará unos minutos.',
        'MEMBER' => 'Miembro',
        'INVITED_BY_X' => 'Invitado por %s',
        'DONE' => 'Listo',
        'YOU_HAVE_BEEN_BANNED_FROM_APPNAME' => 'No puedes acceder a %s',
        'MESSAGE_TO_ADMINISTRATOR' => 'Mensaje al administrador',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS_IF_YOU_THINK' => 'Lo sentimos, %s, no puedes acceder a %s ya que lo tienes prohibido. Si piensa que te han prohibido la entrada por error, puedes contactar al administrador.',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS' => 'Lo sentimos, %s, no puedes acceder a %s ya que lo tienes prohibido.',
        'SORRY_USERNAME' => 'Disculpas, %s',
        'PENDING' => 'Pendiente',
        'ACCEPT' => 'Aceptar',
        'PENDING_APPROVAL' => 'Aprobación pendiente',
        'ACCEPT_MEMBERSHIP' => 'Aceptar membresía',
        'DECLINE_MEMBERSHIP' => 'Denegar membresía',
        'NO_PAGE_YET' => 'Todavía no hay una página',
        'YOUR_MEMBERSHIP_TO_X_IS_PENDING_APPROVAL' => 'Tu membresía de %s está pendiente de aprobación por parte de los administradores.',
        'MEMBERSHIP_PENDING_APPROVAL' => 'Aprobación de membresía pendiente',
        'YOUR_PROFILE_IS_PENDING_APPROVAL' => 'Tu perfil está pendiente de aprobación',
        'YOUR_PROFILE_DETAILS_MUST_BE_APPROVED_ON_X' => 'El administrador tiene que aprobar los detalles de tu perfil antes de que te conviertas en miembro de %s. Recibirás un mensaje una vez tu perfil haya sido aprobado.',
        'CONTINUE_ARROW' => 'Continuar →',
        'LARR_BACK_TO_PENDING_MEMBERS' => '← Volver a los miembros pendientes',
        'X_IS_AWAITING_APPROVAL_TO_BECOME_MEMBER_OF_Y' => '% está esperando la aprobación para convertirse en miembro de %s.',
        'VIEW_PAGE' => 'Ver página',
        'MESSAGE' => 'Mensaje',
        'SEND_MESSAGE' => 'Enviar mensaje',
        'MANAGE_FORUM_CATEGORIES' => 'Administrar las categorías del foro',
        'START_DISCUSSIONS' => 'Empezar discusiones',
        'WELCOME_TO_YOUR_NEW_SOCIAL_NETWORK' => 'Bienvenido a tu nueva red social',
        'NOW_ALL_YOU_NEED_TO_DO_IS_INVITE_YOUR_FRIENDS' => '¡Ahora todo lo que tienes que hacer es <a %s>invitar a tus amigos</a>!',
        'CONTRIBUTE' => 'Contribuir.',
        'CUSTOMIZE_APPEARANCE_BADGES' => '<strong>Personalizar.</strong> Ajusta el  <a %1$s>aspecto de la red</a> y diseña <a %2$s>insignias y widgets</a>.',
        'CONTROL_MANAGE_PAGE' => '<strong>Control.</strong>  La página <a %s>administración</a> tiene una serie de opciones de configuración.',
        'CREATE_GROUPS' => 'Crear grupos',
        'INVITE_MORE_PEOPLE' => 'Invita a más gente…',
        'VIEW_THREAD' => 'Ver conversación...',
        'COMMENT_THREAD' => 'Lista de comentarios',
        'COMMENT_BACK' => 'Comentar de Vuelta',
        'HELLO_YOU_NEED_TO_ENABLE_JAVASCRIPT' => 'Hola, necesitas tener JavaScript habilitado para usar esta red.',
        'PLEASE_CHECK_YOUR_BROWSER_SETTINGS' => 'Por favor verifica la configuracion de tu navegador o contacta a el administrador de tu sistema.',
        'MANAGE_MEMBERS_ADMINS_INVITED' => 'Administra miembros, administradores, gente invitada y prohibiciones.',
        'MANAGE_MEMBERS' => 'Administrar miembros',
        'MANAGE_INVITED_PEOPLE' => 'Administrar invitaciones',
        'NETWORK_SETTINGS' => 'Configuración de la red',
        'PROMOTE_YOUR_NETWORK' => 'Promociona tu red',
        'NING_RESOURCES' => 'Recursos de Ning',
        'ADD_PREMIUM_SERVICES' => 'Añadir servicios Premium',
        'REQUEST_SOURCE_CODE' => 'Pedir acceso al código fuente',
        'REQUEST_A_COPY_OF_THE_SOURCE_CODE' => 'Programadores: pedid el acceso al código fuente que ejecuta vuestra red.',
        'JOIN_NETWORK_CREATORS' => 'Únete a la red para Creadores de Red (<em>Network Creators</em>)',
        'SEND_MESSAGE_TO_ALL_THIS' => 'Envía un mensaje a todos los miembros de esta red.',
        'CREATE_ANOTHER_NETWORK' => 'Crear otra red',
        'HAVE_ANOTHER_GREAT_IDEA' => '¿Tienes una buena idea para otra red social?',
        'ALLOW_FACEBOOK_USERS_TO' => 'Permite a los usuarios de Facebook poner los widgets de tu red en sus páginas de perfil.',
        'BADGES_AND_WIDGETS' => 'Insignias y widgets',
        'CUSTOMIZE_WIDGETS_AND_BADGES' => 'Personaliza el aspecto de los widgets e insignias de tu red.',
        'GET_BADGES' => 'Consigue insignias',
        'CUSTOM_TEXT' => 'Personaliza el texto',
        'IM_A_MEMBER_OF' => 'Soy miembro de:',
        'DONT_DISPLAY_ANY_BRANDING' => 'No mostrar ninguna marca',
        'WATERMARK_OR_LOGO_IMAGE' => 'Filigrana o imagen logotipo:',
        'NETWORK_BRANDING_BADGES' => 'Marca de la red: Insignias',
        'NETWORK_BRANDING_WIDGETS' => 'Marca de la red: Widgets',
        'LOGO_IMAGE' => 'Imagen logotipo',
        'SMALL_NETWORK_BADGE' => 'Pequeña insignia de la red',
        'LARGE_NETWORK_BADGE' => 'Gran insignia de la red',
        'REFRESH' => 'Actualizar',
        'HTML_EMBED_CODE' => 'Código HTML insertado:',
        'CUSTOMIZE' => 'Personalizar',
        'SHARE_TITLE' => 'Compartir \'%s\'',
        'SHARE_TYPE' => 'Compartir %s',
        'YOUR_MESSAGE_SENT' => 'Tu mensaje se ha mandado con éxito.',
        'YOUR_MESSAGES_SENT' => 'Tus mensajes se han mandado con éxito.',
        'YOU_CAN_SHARE_TYPE_TWO_WAYS' => 'Puedes compartir esto %s de dos maneras&#8230;',
        'CHECK_OUT_THIS_TYPE_TITLE' => 'Desprotege esto %s: "%s"',
        'CHECK_OUT_THIS_TYPE' => 'Desprotege esto %s',
        'PHOTO_ALBUM' => 'álbum de fotos',
        'CUSTOMIZE_YOUR_BADGES_AND_WIDGETS' => 'Personaliza tus insignias y widgets con tu elección de colores e imágenes. Estos cambios pueden tardar hasta 4 horas en reflejarse en otros sitios Web.',
        'BACKGROUND_IMAGE_AND_COLOR' => 'Imagen y color de fondo',
        'USE_THIS_FORM_TO_REPORT_ISSUE_TO_NC' => 'Usa este formulario para informar de un problema a <a %s>%s</a>, el creador de <a %s>%s</a>.',
        'SORRY_NCS_CANNOT_CHANGE_EMAIL' => 'Lo sentimos, los creadores de la red no pueden cambiar las direcciones de email a través de redes que no les pertenecen.',
        'SORRY_NCS_CANNOT_CHANGE_PASSWORD' => 'Lo sentimos, los creadores de la red no pueden cambiar las contraseñas a través de redes que no les pertenecen.',
        'GO' => 'Ir a',
        'LARGE_THUMBNAILS' => 'Versiones medianas',
        'SMALL_THUMBNAILS' => 'Versiones pequeñas',
        'RECENTLY_JOINED' => 'Más recientes',
        'MOST_POPULAR_MEMBERS' => 'Más populares',
        'NO_MEMBERS_TO_DISPLAY' => 'No estás mostrando miembros actualmente',
        'BOX_WILL_NOT_SHOW_MEMBERS' => 'Este área no aparecerá para otros visitantes si no eliges al menos una fila.',
        'DETAIL_VIEW' => 'Ver detalles',
        'TITLES_ONLY' => 'Sólo títulos',
        'RECENTLY_ADDED_POSTS' => 'Recientemente añadido',
        'POPULAR_POSTS' => 'Mas comentarios',
        'PROMOTED_POSTS' => 'Destacados',
        'BOX_WILL_NOT_SHOW_BLOG_POST' => 'Este área no aparecerá para otros visitantes si no eliges al menos un post.',
        'KEEP_WINDOW_OPEN_UPLOAD' => 'Por favor deja esta ventana del navegador abierta mientras el archivo continuo cargando.',
        'CANCEL_UPLOAD' => 'Cancelar',
        'YOU_DO_NOT_HAVE_POSTS' => 'Todavía no has escrito ningún post.',
        'YOU_DO_NOT_HAVE_COMMENTS' => 'No tienes ningún comentario que aprobar.',
        'REQUIRED_FIELD' => '(Campo obligatorio)',
        'BLOG_POST_BY_X' => 'Post del blog escrito por %s',
        'HELLO' => 'Hola,',
        'ADDED_BY_X' => 'Añadido por %s',
        'CLICK_TO_ADD_A_TITLE' => 'Haz clic para añadirle un título',
        'DELETE_BLOG_POST' => 'Borrar post del blog',
        'DELETE_THIS_BLOG_POST_Q' => '¿Borrar este post del blog?',
        'ARE_YOU_SURE_DELETE_THIS_BLOG_POST' => '¿Estás seguro? Este proceso puede llevar unos minutos.',
        'SPINNER' => 'Spinner',
        'PLEASE_ENTER_SOMETHING_FOR_X' => 'Por favor introduce algo para: %s',
        'PLEASE_SELECT_OPTION_FOR_X' => 'Por favor selecciona una opción para: %s',
        'PLEASE_PROVIDE_VALID_DATE_FOR_X' => 'Por favor indica una fecha valida para: %s',
        'PLEASE_PROVIDE_DATE_FOR_X' => 'Por favor indica una fecha para: %s',
        'XS_BLOG_POSTS_FOR_M_Y' => 'Los posts de %s para %s %s',
        'FEATURED_BLOG_POSTS_FOR_M_Y' => 'Posts destacados para %s %s',
        'BLOG_POSTS_FOR_M_Y' => 'Posts para %s %s',
        'FEATURED_BLOG_POSTS' => 'Posts destacados',
        'EVERYONES_POSTS' => 'Todos los posts',
        'PUBLISHED_N_OF_N' => '%d publicados de %d',
        'DOWNLOAD_X' => 'Baja %s',
        'UPLOAD_DID_NOT_WORK' => 'Disculpas, esa carga no funcionó',
        'F_J_Y' => 'F j, Y',
        'M_J_Y' => 'j M Y',
        'XS_POSTS' => 'Los posts de %s',
        'USERNAMES_COMMENTS' => 'Comentarios de %s',
        'ADD_COMMENT' => 'Añadir comentario',
        'XS_PAGE' => 'Página de %s',
        'XS_BLOG' => 'El blog de %s',
        'XS_FRIENDS' => 'Las amistades de %s',
        'VIEW_XS_ELLIPSIS' => 'Ver %s\'s…',
        'DRAFT_BRACKETS' => '[ Borrador ]',
        'FEATURED' => 'Destacado',
        'MY_POSTS' => 'Mis posts',
        'MY_POSTS_ONLY' => 'Sólo mis posts',
        'OWNER_POSTS_ONLY' => 'Sólo los posts del creador',
        'JANUARY' => 'enero',
        'FEBRUARY' => 'febrero',
        'MARCH' => 'marzo',
        'APRIL' => 'abril',
        'MAY' => 'mayo',
        'JUNE' => 'junio',
        'JULY' => 'julio',
        'AUGUST' => 'agosto',
        'SEPTEMBER' => 'septiembre',
        'OCTOBER' => 'octubre',
        'NOVEMBER' => 'noviembre',
        'DECEMBER' => 'diciembre',
        'MY_COMMENTS' => 'Mis comentarios',
        'AM' => 'AM',
        'PM' => 'PM',
        'MY_PAGE' => 'Mi página',
        'MY_PAGE_TAB_TEXT' => 'Mi página',
        'BLOG_POSTS' => 'Blog Posts',
        'MY_BLOG' => 'Mi Blog',
        'MONTH' => 'Mes',
        'DAY' => 'Día',
        'PICK_VALID_DEFAULT_VISIBILITY' => 'Por favor elige una opción válida para la visibilidad predeterminada',
        'PICK_VALID_WHO_CAN_COMMENT' => 'Por favor elige una opción válida para quién puede comentar',
        'PICK_VALID_BLOG_COMMENT_MODERATION' => 'Por favor elige una opción válida para la moderación de los comentarios del blog',
        'PICK_VALID_ACTIVITY_NOTIFICATION' => 'Por favor elige una opción válida para las actividades de notificación',
        'PICK_VALID_MODERATION_NOTIFICATION' => 'Por favor elige una opción válida para las notificaciones de moderación',
        'PICK_VALID_APPROVAL_NOTIFICATION' => 'Por favor elige una opción válida para las notificaciones de aprobación',
        'PICK_VALID_INVITEE_NOTIFICATION' => 'Por favor elige una opción válida para las notificaciones de invitaciones para unirse al grupo',
        'PICK_VALID_NEVER_NOTIFICATION' => 'Por favor elige una opción válida para nunca recibir notificaciones',
        'PICK_VALID_FRIEND_REQUEST_NOTIFICATION' => 'Por favor elige una opción válida para las notificaciones de solicitudes de amistad',
        'PICK_VALID_NEW_MESSAGE_NOTIFICATION' => 'Por favor elige una opción válida para las notificaciones de nuevos mensajes',
        'APPROVE_COMMENT' => 'Aprobar comentario',
        'MANAGE_BLOG' => 'Administrar blog',
        'COMMENTS_POSTED_ON_BLOG' => 'Comentarios publicados en mi blog',
        'COMMENT' => 'Comentario',
        'COMMENTER' => '¿Quién comentó',
        'POST' => 'POST',
        'M_J_Y_G_IA' => 'j M, Y, g:ia',
        'POST_HAS_BEEN_DELETED' => 'El post ha sido borrado',
        'COMMENTS_ARE_CLOSED' => 'Los comentarios están cerrados para este post',
        'NO_COMMENTS' => 'No hay comentarios',
        'FLAG' => 'Banderín',
        'POST_TITLE' => 'Título del post',
        'DRAFT_PARENTHESES' => '(Borrado)',
        'SCHEDULED_TO_PUBLISH_ON' => 'Programado para ser publicado el: %s',
        'EDIT_2' => 'edición',
        'NONE' => 'Ninguno',
        'N_NEW' => 'Nuevo %s',
        'NO_POSTS' => 'No hay posts',
        'ADD_NEW_BLOG_POST' => 'Añadir un nuevo post',
        'HAPPY' => 'Feliz',
        'SAD' => 'Triste',
        'COOL' => 'Tranquilo',
        'EVIL' => 'Malvado',
        'MAD' => 'Loco',
        'ENVIOUS' => 'Envidioso',
        'ENTRY' => 'Entrada',
        'WHAT_DATE_FOR_YOUR_POST' => '¿Qué fecha te gustaría ponerle a tu post?',
        'NOW' => 'Ahora',
        'CHOOSE_DATE_AND_TIME' => 'Elige una fecha y hora (si eliges una fecha futura, tu post será publicado en ese momento)',
        'PRIVACY_AND_COMMENTS' => 'Privacidad y comentarios',
        'WHO_CAN_VIEW_POST' => '¿Quién puede ver este post?',
        'EVERYONE' => 'Para todas las edades',
        'ALLOW_COMMENTS' => '¿Permitir comentarios en este post?',
        'YES' => 'Sí',
        'NO' => 'No',
        'COMMENT_MODERATION' => 'Moderación de comentario',
        'YOU_ARE_MODERATING_BLOG_COMMENTS' => 'Estás moderando comentarios del blog en este momento.',
        'YOU_ARE_NOT_MODERATING_BLOG_COMMENTS' => 'No estás moderando comentarios del blog en este momento.',
        'SAVE_AS_DRAFT' => 'Guardar como borrador',
        'PREVIEW' => 'Vista previa',
        'PUBLISH_POST' => 'Publicar post',
        'THIS_IS_PREVIEW_OF_BLOG_POST' => 'Esta es una vista previa de cómo se verá tu post cuando lo publiques. ¡Haz clic en "Atrás" para editarlo nuevamente, o "Publicar", si ya está listo!',
        'BACK' => 'Atrás',
        'PUBLISH' => '¡Publicar!',
        'BLOG_POST' => 'Post del blog',
        'PROFILE' => 'Perfil',
        'THIS_IS_UNPUBLISHED_DRAFT' => 'Este es un borrador que aún no ha sido publicado',
        'WILL_BE_PUBLISHED_ON_X' => 'Será publicado en  %s <small>%s</small>',
        'POSTED_ON_X' => 'Publcado en %s <small>%s</small>',
        'POSTED_ON_X_BY' => 'Publicado <strong>%s</strong> <small>%s</small> por:',
        'ABOUT_THIS_POST' => 'Sobre este post',
        'ABOUT_YOUR_POST' => 'Sobre tu post',
        'ADDED_BY' => 'Añadido por:',
        'JUST_FRIENDS' => 'Sólo amistades',
        'RECENT_POSTS' => 'Posts recientes',
        'THERE_ARE_NO_RECENT_POSTS' => 'No hay posts recientes.',
        'YOUR_COMMENT_HAS_BEEN_ADDED_BUT' => 'Tu comentario ha sido añadido pero tiene que ser aprobado antes de que todos puedan verlo.',
        'AT_TIME_ON_DATE_USERNAME_SAID' => 'A las %s en el %s, %s dijo…',
        'X_DOES_NOT_HAVE_ANY_FRIENDS' => '%s todavía no tiene amistades en esta red social.',
        'YOU_DO_NOT_HAVE_ANY_FRIENDS' => 'Aún no tienes amigos en esta red social.',
        'EDIT_PAGE_APPEARANCE' => 'Editar la apariencia de la página',
        'VIEW_PAGE_AS_OTHERS' => 'Ver la página como los demás la ven',
        'ADD_BLOG_POST' => 'Añadir un post del blog',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED_2' => 'Por favor deja esta ventana del navegador abierta mientras todo el comentario de %s está siendo borrado. Este proceso puede tardar unos minutos.',
        'BAN_MEMBER_FROM_NETWORK' => 'Prohibir acceso a la red',
        'BAN_USERNAME' => '¿Prohibir acceso a %s?',
        'BLOCK' => 'bloquear',
        'CREATE_NEW_BLOG_POST' => '¡Crear un nuevo post del blog!',
        'EDIT_POST' => 'Editar post',
        'EDIT_POST_COLON' => 'Editar post:',
        'CONTINUE_READING' => 'Continuar leyendo…',
        'POSTED_BY_ME_LINK_ON_X_AT_X' => 'Publicado por <a %s>mi</a> sobre %s a las %s -',
        'POSTED_BY_X_ON_X_AT_X' => 'Publicado por %s sobre %s a las %s -',
        'POSTED_BY_ME_ON_X_AT_X' => 'Publicado por mí sobre %s a las %s -',
        'ADD' => 'Agregar',
        'SUBSCRIBE' => 'Suscribir',
        'VIEW_ARCHIVES' => 'Ver archivos',
        'YOUR_SETTINGS_HAVE_BEEN_SAVED' => 'Tu configuración ha sido grabada',
        'PLEASE_CORRECT_THE_FOLLOWING' => 'Por favor corrige lo siguiente:',
        'PRIVACY' => 'Privacidad',
        'NETWORK_PRIVACY' => 'Privacidad de la red',
        'THIS_NETWORK_VISIBLE_TO_EVERYONE' => 'Esta red está <strong>visible para todo el mundo</strong>.',
        'ANYONE_CAN_SIGN_UP_VISITORS_CAN' => 'Cualquiera puede registrarse y convertirse en un miembro. Los visitantes pueden…',
        'SEE_EVERYTHING' => 'Verlo todo',
        'SEE_JUST_THE_MAIN_PAGE' => 'Ver sólo la página principal',
        'SEE_JUST_THE_SIGN_UP_PAGE' => 'Ver solo la página de registro',
        'THIS_NETWORK_VISIBLE_MEMBERS_ONLY' => 'Esta página sólo es <strong>visible por los miembros</strong>.',
        'WHO_CAN_SIGN_UP' => '¿Quién puede registrarse para convertirse en un miembro?',
        'MODERATION' => 'Moderación',
        'APPROVE_MEMBERS_BEFORE_JOIN' => 'Aprobar a los nuevos miembros antes que puedan unirse',
        'APPROVE_PHOTOS_VIDEOS' => 'Aprobar las fotos y los videos antes que aparezcan',
        'SHOW_LATEST_ACTIVITY_ON_YOUR_NETWORK' => '¡Mostrar las últimas actividades de tu red!',
        'PUT_A_CONSTANTLY_UPDATED_STREAM' => 'Pon una secuencia constante de actividades recientes que se actualice en la página principal de tu red.',
        'CLICK_HERE_TO_ADD_LATEST_ACTIVITY' => 'Haz clic aquí para añadir las últimas actividades a tu red.',
        'THESE_OPTIONS_ARE_DISABLED_ACTIVITY' => 'Estas opciones no están habilitadas ya que no tienes últimas actividades en tu red.',
        'ACTIVITY' => 'Actividad',
        'DISPLAY_PREFERENCES' => 'Visualizar preferencias',
        'NEW_CONTENT' => 'Contenido nuevo',
        'NEW_COMMENTS' => 'Comentarios nuevos',
        'NEW_MEMBERS' => 'Miembros nuevos',
        'MEMBER_UPDATES' => 'Actualizaciones de los miembros',
        'WHAT_DISPLAYS_LATEST_ACTIVITY' => '¿Qué muestra las<br />últimas actividades en tu red?',
        'LATEST_ACTIVITY' => 'Última actividad',
        'X_COMMENTED_ON_POST_TITLE' => '%1$s respondió a la discusión %2$s',
        'X_LINK_COMMENTED_ON_POST_LINK_TITLE' => '%1$s <a %2$s>ha respondido</a> a la discusión <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_POST_LINK_TITLE' => 'Has <a %1$s>respondido</a>a la discusión<a %2$s>%3$s</a>',
        'X_COMMENTED_ON_BLOG_POST_TITLE' => '%1$s ha hecho un comentario sobre el post del blog %2$s',
        'X_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '%1$s <a %2$s>ha hecho un comentario</a> sobre el post del blog <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => 'Has <a %1$s>hecho un comentario</a> sobre el post del blog <a %2$s>%3$s</a>',
        'X_STARTED_A_DISCUSSION_Y' => '%s ha empezado una discusión llamada %s',
        'YOU_STARTED_A_DISCUSSION_Y' => 'Has empezado una discusión llamada %s',
        'X_ADDED_THE_BLOG_POST_Y' => '%s ha añadido un post en el blog \'%s\'',
        'YOU_ADDED_THE_BLOG_POST_Y' => 'Has añadido un post en el blog \'%s\'',
        'X_JOINED_THE_GROUP_Y' => '%s se ha unido al grupo %s',
        'YOU_JOINED_THE_GROUP_X' => 'Te has unido al grupo %s',
        'X_JOINED_Y_GROUPS' => '%s se ha unido a %s grupos',
        'YOU_JOINED_X_GROUPS' => 'Te has unido a %s grupos',
        'X_JOINED_APPNAME' => '%s se ha unido a %s',
        'WELCOME_MEMBER_N_OF_APPNAME' => '¡Bienvenido, %1$s! Ahora eres miembro #%2$s de %3$s.',
        'WELCOME_MEMBER_N_OF_APPNAME_FIND' => '¡Bienvenido, %1$s! Ahora eres miembro #%2$s de %3$s. <a %4$s>Encuentra amigos</a>.',
        'X_IS_MEMBER_N_OF_APPNAME' => '%1$s es miembro #%2$s de %3$s.',
        'XS_PROFILE_CHANGED' => '%s\'s ha cambiado el perfil',
        'YOUR_PROFILE_CHANGED' => 'Tu perfil ha cambiado',
        'X_LEFT_A_COMMENT_FOR_Y' => '%s ha dejado un comentario para %s',
        'YOU_LEFT_A_COMMENT_FOR_X' => 'Has dejado un comentario para %s',
        'X_LEFT_A_COMMENT_FOR_YOU' => '%s te ha dejado un comentario',
        'X_CREATED_A_GROUP_Y' => '%s ha creado un grupo llamado %s',
        'YOU_CREATED_A_GROUP_Y' => 'Has creado un grupo llamado %s',
        'X_CREATED_Y_NEW_GROUPS' => '%s ha creado %s grupos nuevos',
        'X_STARTED_Y_FORUM_POSTS' => '%s ha empezado %s discusiones nuevas en el foro',
        'YOU_STARTED_Y_FORUM_POSTS' => 'Has empezado %s discusiones nuevas en el foro',
        'X_ADDED_Y_BLOG_POSTS' => '%s ha añadido %s posts nuevos en el blog',
        'YOU_ADDED_Y_BLOG_POSTS' => 'Has añadido %s posts nuevos en el blog',
        'VIEW_XS_BLOG_POSTS' => 'Ver los posts en el blog de %s',
        'VIEW_YOUR_BLOG_POSTS' => 'Ver tus posts en el blog',
        'APPNAME_HAS_NEW_PROFILE_QUESTIONS' => '%s tiene <a %s>nuevas preguntas de perfil</a>',
        'APPNAME_NOW_HAS_MUSIC' => '%s ahora tiene un reproductor de música',
        'APPNAME_NOW_HAS_GROUPS' => '%s ahora tiene <a %s>grupos</a>',
        'APPNAME_NOW_HAS_VIDEO' => '%s ahora tiene <a %s>videos</a>',
        'APPNAME_NOW_HAS_FORUM' => '%s ahora tiene un <a %s>foro</a>',
        'APPNAME_NOW_HAS_PHOTO' => '%s ahora tiene <a %s>fotos</a>',
        'DID_YOU_KNOW' => 'Sabías que…',
        'ANNOUNCEMENT' => 'Anuncio',
        'CONGRATULATIONS' => 'Felicitaciones',
        'YOU_CREATED_APPNAME' => 'Has creado la red %s.',
        'USER_CREATED_APPNAME' => '%s ha creado la red %s.',
        'ADD_MESSAGES_ACTIVITY_FEED' => 'Añade mensaje y elige qué se muestra en el alimentador de actividades de tu red.',
        'WHICH_OF_YOUR_ACTIONS_DISPLAY_ACTIVITY' => '¿Qué acciones quisieras que aparezcan <br />en Últimas actividades?',
        'NEW_CONTENT_I_ADD' => 'Contenido nuevo añadido',
        'NEW_COMMENTS_I_ADD' => 'Comentarios nuevos añadidos',
        'WHEN_I_UPDATE_MY_PROFILE' => 'Cuando actualizo mi perfil',
        'THE_LATEST_ACTIVITY_WILL_NEVER' => 'Las últimas actividades nunca muestran los mensajes que envías, las páginas o miembros que visitas, las invitaciones que declinas, la gente que prohíbes o declinas o las cosas que borras.',
        'YOU_HAVENT_DONE_ANYTHING_RECENTLY' => 'No tienes actividades recientes ¿Por qué no comienzas algo?',
        'YOUVE_TURNED_OFF_THE_ACTIVITY_DISPLAY_CLICK' => 'Has desactivado la pantalla de tus actividades. <a %s>Haz clic aquí para encenderla.</a>',
        'THE_NETWORK_CREATOR_HAS_TURNED_OFF_THE_ACTIVITY' => 'El creador de redes ha apagado la pantalla de actividades.',
        'NO_ACTIVITY_TO_DISPLAY' => 'Ahora no estás mostrando actividades.',
        'BOX_WILL_NOT_SHOW_ACTIVITY' => 'Esta área no aparecerá para otras personas hasta que elijas al menos una actividad.',
        'NOTHING_IS_HAPPENING_ON_YOUR_NETWORK' => 'No hay actividades recientes. ¿Por qué no empiezas algo?',
        'MY_ACTIVITY_PREFERENCES' => 'Mis actividades preferentes',
        'DELETE_ACTIVITY_ITEM' => 'Elimina los mensajes de actividades',
        'DELETE_THIS_ACTIVITY_MESSAGE_Q' => '¿Eliminar este mensaje de actividades?',
        'THIS_WILL_PREVENT_ACTIVITY' => 'Esto evitará que la gente vea este mensaje de actividades',
        'X_HAS_POSTED_THE_MOST_PHOTOS' => '%1$s ha publicado la mayoría de las %2$sfotos%3$s',
        'X_IS_THE_MOST_POPULAR_PHOTO' => '%s es la foto más popular hasta el momento',
        'X_HAS_POSTED_THE_MOST_VIDEOS' => '%1$s ha publicado la mayoría de %2$s videos %3$s',
        'X_IS_THE_MOST_POPULAR_VIDEO' => '%s es el video más popular hasta el momento',
        'X_HAS_POSTED_THE_MOST_MUSIC' => '%s ha publicado la mayoría de canciones',
        'X_IS_THE_MOST_POPULAR_MUSIC' => '%s es la canción más popular hasta el momento',
        'X_IS_THE_MOST_POPULAR_TOPIC' => '%s es el post más popular del foro hasta el momento',
        'X_IS_THE_MOST_POPULAR_BLOG_POST' => '%s es el post del blog más popular hasta el momento',
        'XS_LATEST_ACTIVITY_ON_APPNAME' => '%s\'s Última actividad en %s',
        'LATEST_ACTIVITY_ON_APPNAME' => 'Última actividad en  %s',
        'ADD_MESSAGE_TO_LATEST_ACTIVITY' => 'Añadir mensaje en última actividad',
        'ADD_FACTS_ABOUT_THE_NETWORK_ELLIPSIS' => 'Añadir hechos sobre la red...',
        'ADD_MESSAGE' => 'Añadir mensaje',
        'ELLIPSIS_OR_WRITE_YOUR_OWN_MESSAGE' => '... o escribe tu propio mensaje',
        'NETWORK' => 'Red',
        'WHO_CAN_VIEW_YOUR_PHOTOS_VIDEOS' => '¿Quién puede ver mis fotos, videos <br/> y posts por omisión?',
        'YOU_CAN_OVERRIDE_WHEN_YOU_ADD' => '(Puedes cambiar esta configuración para una foto, video o post cuando lo añadas.)',
        'MODERATE_COMMENTS_ON_BLOG' => '¿Quieres aprobar los comentarios <br /> antes de que aparezcan en tu blog?',
        'YES_LET_ME_APPROVE' => 'Sí - Aprobar los comentarios para su publicación',
        'NO_PUBLISH_COMMENTS' => 'No – Publicar los comentarios inmediatamente',
        'WHO_CAN_COMMENT_ON_PHOTOS_VIDEOS' => '¿Quién puede comentar sobre mis fotos,<br/> videos y blog?',
        'SAVE' => 'Guardar',
        'EMAIL' => 'Email',
        'YOUR_PRIVACY_IS_IMPORTANT' => 'Tu privacidad es importante para nosotros. Si tienes alguna pregunta sobre tus notificaciones vía email, por favor mándanos una nota al <a href="http://help.ning.com/?page_id=27">Centro de ayuda</a>.',
        'ADD_PHOTOS_AND_VIDEOS_TO_X_BY_SENDING' => 'Añade fotos y videos a %s envíandolos a esta dirección de email:',
        'ADD_PHOTOS_AND_VIDEOS_TO_APPNAME_FROM_PHONE' => 'Añade fotos y videos %s directamente desde tu teléfono enviándolos a esta dirección de email:',
        'GENERATE_NEW_EMAIL_ADDRESS' => 'Generar una nueva dirección de Email',
        'SUPPORTS_TEXT_EMBEDDED' => 'Soporta texto, videos <em>embed</em>, fotos y widgets',
        'POST_COMMENT' => 'Publicar comentario',
        'YOU_NEED_TO_BE_MEMBER_COMMENTS' => 'Necesitas ser un miembro de %s para añadir comentarios!',
        'MONTHLY_ARCHIVES' => 'Archivos mensuales',
        'NO_FRIENDS_ON_SITE' => 'No hay amistades en esta red social todavía.',
        'NO_FRIENDS_ON_SITE_THAT_MATCH' => 'No hay amistades en esta red social que concuerden con tu búsqueda.',
        'MEMBERS_TAB_TEXT' => 'Miembros',
        'SITE_HAS_NO_MEMBERS' => '¡Esta red social todavía no tiene miembros!',
        'SITE_HAS_NO_MEMBERS_THAT_MATCH' => 'No hay miembros de esta red social que concuerden con tu búsqueda.',
        'NO_COMMENTS_YET' => '¡No hay comentarios todavía!',
        'VIEW_ALL_COMMENTS' => 'Ver todos los comentarios',
        'YOU_HAVE_NOT_ADDED_BLOG_POSTS' => 'Todavía no has añadido ningún post a tu blog.',
        'YOU_CAN_WRITE_ABOUT_ANYTHING' => 'Puedes escribir sobre lo que quieras, hablar de lo que quieras y poner tus videos favoritos, fotos y música.',
        'WRITE_YOUR_FIRST_ENTRY' => '¡Escribe tu primer post!',
        'THERE_ARE_NO_BLOG_POSTS' => 'No hay en este momento posts en el blog de tu red social.',
        'THERE_ARE_NO_FEATURED_X' => 'No hay %s destacadas en tu red social.',
        'THERE_ARE_NO_X_THAT_MATCH_SETTINGS' => 'No hay %s que satisfagan las condiciones.',
        'START_FEATURING_X_CLICK_Y' => 'Comienza a destacar %s donde veas la opción de Destacar. Para aprender más sobre destacar, <a %s>haz clic aquí</a>.',
        'THIS_BOX_WILL_NOT_SHOW_BLOG_POSTS' => 'Esta caja no será mostrada a otras personas hasta que existan posts para mostrar. ¿Porque no añades uno?',
        'YOUR_FRIEND' => 'Tu amigo',
        'REQUEST_SENT' => '¡Pedido enviado!',
        'BLOCKED' => 'Bloqueado',
        'BANNED' => 'Acceso prohibido',
        'ADD_YOUR_FIRST_BLOG_POST' => 'Añade tu primer post',
        'MY_FIRST_BLOG_POST' => '¡Mi primer post en mi blog!',
        'TELL_THE_PEOPLE_ON' => 'Cuenta más cosas sobre ti mismo en %s. Las preguntas marcadas con un <span %s>candado</span> son privadas y sólo las pueden ver los administradores.',
        'CHOOSE_A_THEME_FOR_PAGE' => 'Elige un tema para tu página',
        'NOW_CUSTOMIZE_PAGE' => 'Ahora personaliza tu página...',
        'NO_POSTS_TO_DISPLAY' => 'No hay posts para mostrar.',
        'YOU_ARE_DISPLAYING_NO_POSTS' => 'No estas mostrando posts.',
        'DATE_COLON' => 'Fecha:',
        'TIME_COLON' => 'Hora:',
        'CHANGE' => 'Cambiar',
        'UPLOAD_A_PHOTO' => 'Subir una foto',
        'OPTIONS' => 'opciones',
        'PIXELS' => 'Píxeles',
        'CANCEL' => 'Cancelar',
        'UPLOAD_A_FILE' => 'Subir un archivo:',
        'TO_INSERT_A_FILE' => 'Para insertar un archivo, haz clic en el botón "Navegar" o "Elegir" para localizar el archivo en tu computadora.',
        'UPLOADING' => 'Cargando…',
        'OK' => 'OK',
        'POPULAR_MEMBERS' => 'Miembros populares',
        'INVITE_FRIENDS' => 'Invita amistades',
        'VIEW_ALL' => 'Ver todos',
        'REMOVE_X' => 'Sacar %s',
        'ARE_YOU_SURE_BAN_X_AND_CONTENT' => '¿Estás seguro de que quieres prohibir acceso a %1$s de tu red social y borrar todo el contenido que %1$s haya añadido? Este proceso puede tardar unos minutos.',
        'REMOVING_X' => 'Sacando %s',
        'ARE_YOU_SURE_BAN_MEMBERS_AND_CONTENT' => '¿Estás seguro de que quieres prohibir acceso al (a los) miembro(s) seleccionado(s) de tu red social y eliminar todo el contenido que ha(n) añadido? Este proceso puede tardar unos minutos.',
        'ARE_YOU_SURE_BAN_MEMBERS' => '¿Estás seguro de que quieres prohibir el acceso a tu red social al (a los) miembro(s) seleccionado(s)? Este proceso puede llevar unos minutos.',
        'BAN' => 'Prohibir acceso',
        'REMOVING_MEMBERS' => 'Sacando miembros',
        'FEMALE' => 'Mujer',
        'MALE' => 'Hombre',
        'UNITED_STATES' => 'Estados Unidos',
        'AND' => 'Y',
        'FROM' => 'De',
        'GENDER_M' => 'Hombre',
        'GENDER_F' => 'Mujer',
        'XS_PAGE_ON_Y' => 'Página de %s en %s',
        'SEARCH_MEMBERS' => 'Buscar miembros',
        'SOMEBODY_COMMENTED_BLOGPOST_ADDED_TO_X' => 'Alguien comento un post que añadiste a  %s',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE' => 'Tienes un comentario nuevo sobre tu página.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X' => 'Tienes un comentario nuevo sobre tu página en %s.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X_ELLIPSIS' => '¡Tienes un comentario nuevo sobre tu página en %s!',
        'A_BLOG_POST' => 'un post del blog',
        'NOW_THAT_YOU_JOINED_INVITE' => '¡Ahora que te has unido, <strong><a %s>invita a tus amigos</a></strong>!',
        'THIS_IS_YOUR_PROFILE' => 'Este es tu perfil:',
        'START_BY_CUSTOMIZING_ITS_APPEARANCE' => 'Empieza <a %s>personalizando su aspecto</a>.',
        'USE_IT_TO_KEEP_A_BLOG_AND_DISPLAY_YOUR_PROFILE_ANSWERS' => 'Úsalo para <a %1$s>mantener tu blog</a> y mostrar <a %2$s>las respuestas de tu perfil</a>.',
        'START_CONTRIBUTING' => 'Empieza a contribuir:',
        'UPLOAD_VIDEOS' => 'Cargar videos',
        'CONTRIBUTE_TO_DISCUSSIONS' => 'Contribuye en las discusiones',
        'JOIN_GROUPS' => 'Únete a grupos',
        'ADD_A_BLOG_POST' => 'Añade un post en tu blog',
        'CLICK_TO_ACCEPT_FRIENDS' => 'Haz clic aquí para ver las solicitudes de amistad.',
        'LEAVE_X' => 'Salir de %s',
        'LEAVE_X_Q' => '¿Salir de %s?',
        'ARE_YOU_SURE_LEAVE_X' => '¿Estás seguro de que quieres salir de %s y borrar todo tu contenido? Este proceso puede llevar unos minutos.',
        'BACK_TO_USERNAMES_PAGE' => '&#8592; Volver a la página de %s',
        'BACK_TO_MY_PAGE' => '&#8592; Volver a mi página',
        'COMMENT_WALL' => 'Comentarios',
        'ONLINE' => 'Conectado',
        'MEMBER_IS_ONLINE' => 'El miembro está conectado',
        'ONLINE_NOW' => 'Ahora estás conectado',
        'CHOOSE_WHO_CAN_SEE_JOIN_AND_CONTRIBUTE' => 'Elige quien puede ver, unirse y contribuir a tu red.',
        'EMAIL_NOTIFICATIONS' => 'Notificaciones por email',
        'WHAT_NETWORK_ACTIVITY_EMAIL_FOR' => '¿Sobre qué actividades de tu red quieres recibir notificaciones por email?',
        'NETWORK_MESSAGES' => 'Mensajes de red',
        'MEMBER_ACTIVITY' => 'Actividad de los miembros',
        'APPROVAL' => 'Aprobación',
        'FRIEND_REQUESTS' => 'Peticiones de amistad',
        'PEOPLE_IVE_INVITED_JOIN' => 'La gente que he invitado a unirse a esta red',
        'MESSAGES_SENT_TO_ME' => 'Mensajes que me han enviado',
        'MESSAGES_SENT_TO_GROUPS' => 'Mensajes enviados a los grupos a los que pertenezco',
        'MESSAGES_SENT_TO_NETWORK' => 'Mensajes enviados a toda la red',
        'I_HAVE_NEW_COMMENTS' => 'Tengo nuevos comentarios que aprobar',
        'I_HAVE_NEW_NETWORK_CONTENT' => 'Tengo nuevo contenido de red que aprobar',
        'CONTENT_ACTIVITY' => 'Contenido de la actividad',
        'ACTIVITY_ON_THINGS_IVE_ADDED' => 'Actividades que he añadido a las cosas',
        'AUTO_FOLLOW_DISCUSSIONS_I_REPLY_TO' => 'Seguimientos automáticos a discusiones a los que he respondido',
        'THINGS_IVE_ADDED_APPROVED' => 'Cosas que he añadido y que han sido aprobadas',
        'NOTIFICATIONS' => 'Notificaciones',
        'EMAIL_ME_WHEN_PEOPLE_REPLY' => 'Mándame un email cuando la gente conteste',
        'DO_NOT_EMAIL_ME_WHEN_PEOPLE_REPLY' => 'No me mandes un email cuando la gente conteste',
        'TO_STOP_FOLLOWING_THIS_X_CLICK_Y' => 'Para dejar de seguir esto %s, <a %s>haz clic aquí</a>.',
        'YOU_ARE_NO_LONGER_FOLLOWING_THIS_X' => 'Ya no estás siguiendo esto %s.',
        'NOTIFY' => 'Notificar',
        'STOP_NOTIFYING' => 'Dejar de notificar',
        'EMAIL_WHEN_NEW_DISCUSSIONS' => 'Mándame un email cuando haya nuevas discusiones',
        'DO_NOT_EMAIL_WHEN_NEW_DISCUSSIONS' => 'No me mandes un email cuando haya nuevas discusiones',
        'STOP_FOLLOWING_ALL' => 'Deja de seguir todas las discusiones y comentarios del blog',
        'CHANGE_MY_PHOTO' => 'Cambiar mi foto',
        'COUNTRY_AF' => 'Afganistán',
        'COUNTRY_AX' => 'Islas Aland',
        'COUNTRY_AL' => 'Albania',
        'COUNTRY_DZ' => 'Argelia',
        'COUNTRY_AS' => 'Samoa Americana',
        'COUNTRY_AD' => 'Andorra',
        'COUNTRY_AO' => 'Angola',
        'COUNTRY_AI' => 'Anguila',
        'COUNTRY_AQ' => 'Antártida',
        'COUNTRY_AG' => 'Antigua y Barbuda',
        'COUNTRY_AR' => 'Argentina',
        'COUNTRY_AM' => 'Armenia',
        'COUNTRY_AW' => 'Aruba',
        'COUNTRY_AU' => 'Australia',
        'COUNTRY_AT' => 'Austria',
        'COUNTRY_AZ' => 'Azerbaiján',
        'COUNTRY_BS' => 'Bahamas',
        'COUNTRY_BH' => 'Bahréin',
        'COUNTRY_BD' => 'Bangladesh',
        'COUNTRY_BB' => 'Barbados',
        'COUNTRY_BY' => 'Bielorrusia',
        'COUNTRY_BE' => 'Bélgica',
        'COUNTRY_BZ' => 'Belice',
        'COUNTRY_BJ' => 'Benín',
        'COUNTRY_BM' => 'Bermudas',
        'COUNTRY_BT' => 'Bután',
        'COUNTRY_BO' => 'Bolivia',
        'COUNTRY_BA' => 'Bosnia-Herzegovina',
        'COUNTRY_BW' => 'Botswana',
        'COUNTRY_BV' => 'Isla Bouvet',
        'COUNTRY_BR' => 'Brasil',
        'COUNTRY_IO' => 'Territorio Británico del Océano Índico',
        'COUNTRY_BN' => 'Sultanato de Brunei',
        'COUNTRY_BG' => 'Bulgaria',
        'COUNTRY_BF' => 'Burkina Faso',
        'COUNTRY_BI' => 'Burundi',
        'COUNTRY_KH' => 'Camboya',
        'COUNTRY_CM' => 'Camerún',
        'COUNTRY_CA' => 'Canadá',
        'COUNTRY_CV' => 'Cabo Verde',
        'COUNTRY_KY' => 'Islas Caimán',
        'COUNTRY_CF' => 'República Centroafricana',
        'COUNTRY_TD' => 'Chad',
        'COUNTRY_CL' => 'Chile',
        'COUNTRY_CN' => 'China',
        'COUNTRY_CX' => 'Isla Christmas',
        'COUNTRY_CC' => 'Islas Cocos',
        'COUNTRY_CO' => 'Colombia',
        'COUNTRY_KM' => 'Comoras',
        'COUNTRY_CG' => 'República del Congo',
        'COUNTRY_CD' => 'República Democrática del Congo',
        'COUNTRY_CK' => 'Islas Cook',
        'COUNTRY_CR' => 'Costa Rica',
        'COUNTRY_CI' => 'Costa del Marfil',
        'COUNTRY_HR' => 'Croacia',
        'COUNTRY_CU' => 'Cuba',
        'COUNTRY_CY' => 'Chipre',
        'COUNTRY_CZ' => 'República Checa',
        'COUNTRY_DK' => 'Dinamarca',
        'COUNTRY_DJ' => 'Yibuti',
        'COUNTRY_DM' => 'Dominica',
        'COUNTRY_DO' => 'República Dominicana',
        'COUNTRY_EC' => 'Ecuador',
        'COUNTRY_EG' => 'Egipto',
        'COUNTRY_SV' => 'El Salvador',
        'COUNTRY_GQ' => 'Guinea Ecuatorial',
        'COUNTRY_ER' => 'Eritrea',
        'COUNTRY_EE' => 'Estonia',
        'COUNTRY_ET' => 'Etiopía',
        'COUNTRY_EU' => 'Unión Europea',
        'COUNTRY_FK' => 'Islas Malvinas',
        'COUNTRY_FO' => 'Islas Feroe',
        'COUNTRY_FJ' => 'Fiji',
        'COUNTRY_FI' => 'Finlandia',
        'COUNTRY_FR' => 'Francia',
        'COUNTRY_GF' => 'Guayana Francesa',
        'COUNTRY_PF' => 'Polinesia Francesa',
        'COUNTRY_TF' => 'Territorios Franceses Meridionales',
        'COUNTRY_GA' => 'Gabón',
        'COUNTRY_GM' => 'Gambia',
        'COUNTRY_GE' => 'Georgia',
        'COUNTRY_DE' => 'Alemania',
        'COUNTRY_GH' => 'Gana',
        'COUNTRY_GI' => 'Gibraltar',
        'COUNTRY_GR' => 'Grecia',
        'COUNTRY_GL' => 'Groenlandia',
        'COUNTRY_GD' => 'Granada',
        'COUNTRY_GP' => 'Guadalupe',
        'COUNTRY_GU' => 'Guam',
        'COUNTRY_GT' => 'Guatemala',
        'COUNTRY_GN' => 'Guinea',
        'COUNTRY_GW' => 'Guinea-Bissau',
        'COUNTRY_GY' => 'Guayana',
        'COUNTRY_HT' => 'Haití',
        'COUNTRY_HM' => 'Islas Heard y McDonald',
        'COUNTRY_HN' => 'Honduras',
        'COUNTRY_HK' => 'Hong Kong',
        'COUNTRY_HU' => 'Hungría',
        'COUNTRY_IS' => 'Islandia',
        'COUNTRY_IN' => 'India',
        'COUNTRY_ID' => 'Indonesia',
        'COUNTRY_IR' => 'Irán',
        'COUNTRY_IQ' => 'Irak',
        'COUNTRY_IE' => 'Irlanda',
        'COUNTRY_IL' => 'Israel',
        'COUNTRY_IT' => 'Italia',
        'COUNTRY_JM' => 'Jamaica',
        'COUNTRY_JP' => 'Japón',
        'COUNTRY_JO' => 'Jordania',
        'COUNTRY_KZ' => 'Kazajstán',
        'COUNTRY_KE' => 'Kenia',
        'COUNTRY_KI' => 'Kiribati',
        'COUNTRY_KP' => 'Corea, República Popular Democrática de',
        'COUNTRY_KR' => 'Corea, República de',
        'COUNTRY_KW' => 'Kuwait',
        'COUNTRY_KG' => 'Kirghizistán',
        'COUNTRY_LA' => 'Laos, República Popular Democrática de',
        'COUNTRY_LV' => 'Letonia',
        'COUNTRY_LB' => 'Líbano',
        'COUNTRY_LS' => 'Lesoto',
        'COUNTRY_LR' => 'Liberia',
        'COUNTRY_LY' => 'Libia',
        'COUNTRY_LI' => 'Liechtenstein',
        'COUNTRY_LT' => 'Lituania',
        'COUNTRY_LU' => 'Luxemburgo',
        'COUNTRY_MO' => 'Macao',
        'COUNTRY_MK' => 'Macedonia',
        'COUNTRY_MG' => 'Madagascar',
        'COUNTRY_MW' => 'Malawi',
        'COUNTRY_MY' => 'Malasia',
        'COUNTRY_MV' => 'Maldivas',
        'COUNTRY_ML' => 'Malí',
        'COUNTRY_MT' => 'Malta',
        'COUNTRY_MH' => 'Islas Marshall',
        'COUNTRY_MQ' => 'Martinica',
        'COUNTRY_MR' => 'Mauritania',
        'COUNTRY_MU' => 'Mauricio',
        'COUNTRY_YT' => 'Mayotte',
        'COUNTRY_MX' => 'México',
        'COUNTRY_FM' => 'Micronesia',
        'COUNTRY_MD' => 'República de Moldova',
        'COUNTRY_MC' => 'Mónaco',
        'COUNTRY_MN' => 'Mongolia',
        'COUNTRY_MS' => 'Montserrat',
        'COUNTRY_MA' => 'Marruecos',
        'COUNTRY_MZ' => 'Mozambique',
        'COUNTRY_MM' => 'Myanmar',
        'COUNTRY_NA' => 'Namibia',
        'COUNTRY_NR' => 'Nauru',
        'COUNTRY_NP' => 'Nepal',
        'COUNTRY_NL' => 'Países Bajos',
        'COUNTRY_AN' => 'Antillas Holandesas',
        'COUNTRY_NC' => 'Nueva Caledonia',
        'COUNTRY_NZ' => 'Nueva Zelanda',
        'COUNTRY_NI' => 'Nicaragua',
        'COUNTRY_NE' => 'Níger',
        'COUNTRY_NG' => 'Nigeria',
        'COUNTRY_NU' => 'Niue',
        'COUNTRY_NF' => 'Isla Norfolk',
        'COUNTRY_MP' => 'Islas Marianas del Norte',
        'COUNTRY_NO' => 'Noruega',
        'COUNTRY_OM' => 'Omán',
        'COUNTRY_PK' => 'Pakistán',
        'COUNTRY_PW' => 'Palaos',
        'COUNTRY_PS' => 'Territorio Palestino',
        'COUNTRY_PA' => 'Panamá',
        'COUNTRY_PG' => 'Papúa Nueva Guinea',
        'COUNTRY_PY' => 'Paraguay',
        'COUNTRY_PE' => 'Perú',
        'COUNTRY_PH' => 'Filipinas',
        'COUNTRY_PN' => 'Pitcairn',
        'COUNTRY_PL' => 'Polonia',
        'COUNTRY_PT' => 'Portugal',
        'COUNTRY_PR' => 'Puerto Rico',
        'COUNTRY_QA' => 'Qatar',
        'COUNTRY_RE' => 'Reunión',
        'COUNTRY_RO' => 'Rumania',
        'COUNTRY_RU' => 'Federación Rusa',
        'COUNTRY_RW' => 'Ruanda',
        'COUNTRY_SH' => 'Santa Helena',
        'COUNTRY_KN' => 'San Cristóbal y Nieves',
        'COUNTRY_LC' => 'Santa Lucia',
        'COUNTRY_PM' => 'San Pedro y Miquelon',
        'COUNTRY_VC' => 'San Vicente y las Granadinas',
        'COUNTRY_WS' => 'Samoa',
        'COUNTRY_SM' => 'San Marino',
        'COUNTRY_ST' => 'Santo Tomé y Príncipe',
        'COUNTRY_SA' => 'Arabia Saudita',
        'COUNTRY_SN' => 'Senegal',
        'COUNTRY_CS' => 'Serbia y Montenegro',
        'COUNTRY_SC' => 'Seychelles',
        'COUNTRY_SL' => 'Sierra Leona',
        'COUNTRY_SG' => 'Singapur',
        'COUNTRY_SK' => 'Eslovaquia',
        'COUNTRY_SI' => 'Eslovenia',
        'COUNTRY_SB' => 'Islas Salomón',
        'COUNTRY_SO' => 'Somalia',
        'COUNTRY_ZA' => 'Sud África',
        'COUNTRY_GS' => 'Islas Georgia y Sándwich del Sur',
        'COUNTRY_ES' => 'España',
        'COUNTRY_LK' => 'Sri Lanka',
        'COUNTRY_SD' => 'Sudán',
        'COUNTRY_SR' => 'Surinam',
        'COUNTRY_SJ' => 'Svalbard y Jan Mayen',
        'COUNTRY_SZ' => 'Suazilandia',
        'COUNTRY_SE' => 'Suecia',
        'COUNTRY_CH' => 'Suiza',
        'COUNTRY_SY' => 'Siria, República Árabe de',
        'COUNTRY_TW' => 'Taiwán',
        'COUNTRY_TJ' => 'Tajikistan',
        'COUNTRY_TZ' => 'Tanzania',
        'COUNTRY_TH' => 'Tailandia',
        'COUNTRY_TL' => 'Timor Oriental',
        'COUNTRY_TG' => 'Togo',
        'COUNTRY_TK' => 'Tokelau',
        'COUNTRY_TO' => 'Tonga',
        'COUNTRY_TT' => 'Trinidad Tobago',
        'COUNTRY_TN' => 'Tunicia',
        'COUNTRY_TR' => 'Turquía',
        'COUNTRY_TM' => 'Turkmenistán',
        'COUNTRY_TC' => 'IslasTurks y Caicos',
        'COUNTRY_TV' => 'Tuvalu',
        'COUNTRY_UG' => 'Uganda',
        'COUNTRY_UA' => 'Ucrania',
        'COUNTRY_AE' => 'Emiratos Árabes Unidos',
        'COUNTRY_GB' => 'Reino Unido',
        'COUNTRY_US' => 'Estados Unidos',
        'COUNTRY_UM' => 'Islas menores alejadas de los Estados Unidos',
        'COUNTRY_UY' => 'Uruguay',
        'COUNTRY_UZ' => 'Uzbekistán',
        'COUNTRY_VU' => 'Vanuatu',
        'COUNTRY_VA' => 'Vaticano',
        'COUNTRY_VE' => 'Venezuela',
        'COUNTRY_VN' => 'Vietnam',
        'COUNTRY_VG' => 'Islas Vírgenes (Británicas)',
        'COUNTRY_VI' => 'Islas Vírgenes (EEUU)',
        'COUNTRY_WF' => 'Wallis y Futuna',
        'COUNTRY_EH' => 'Sahara Occidental',
        'COUNTRY_YE' => 'Yemen',
        'COUNTRY_ZM' => 'Zambia',
        'COUNTRY_ZW' => 'Zimbabwe',
        'ERROR_LOG' => 'Registro de errores',
        'CANNOT_READ_ERROR_LOG' => 'No se puede leer el registro de errores',
        'CANNOT_OPEN_ERROR_LOG' => 'No se puede abrir el registro de errores',
        'CANNOT_SCAN_ERROR_LOG' => 'No se puede escanear el registro de errores',
        'MODELS_RESET' => 'Reestablecer modelos:',
        'NO_MODELS_RESET' => 'No se han reestablecido los modelos.',
        'NO_FEED_TO_DISPLAY' => 'Actualmente no estas mostrando elemento alguno.',
        'BOX_WILL_NOT_SHOW_FEED' => 'Este área no aparecerá para otros a menos que elijas al menos un elemento.',
        'CLICK_EDIT_TO_SPECIFY_FEED' => 'Haz clic en Editar para especificar el canal RSS para esta área.',
        'PROBLEM_OCCURRED_RETRIEVING_FEED' => 'Ocurrió un problema al tratar de obtener este canal RSS.',
        'MORE_ELLIPSIS' => 'Más...',
        'RSS' => 'RSS',
        'WE_ARE_SORRY_SITE_HAS_ISSUE' => 'Lo sentimos mucho, este sitio esta teniendo un problema en este momento.',
        'PLEASE_TRY_REFRESHING' => 'Por favor, trata de cargar nuevamente la pagina en 30 segundos, o <a %s>avísanos</a> si ves este mensaje nuevamente.',
        'NO_DISCUSSIONS_TAGGED_X' => 'No hay discusiones con etiqueta "%1$s".',
        'PAGE_TITLE_COLON' => 'Título de página:',
        'PAGE_CONTENT' => 'Contenido:',
        'CREATE_PAGE' => 'Crear página',
        'CREATE_NEW_PAGE' => 'Crear una nueva página',
        'YOUR_COMMENT' => 'Tu comentario',
        'ADD_YOUR_COMMENT' => 'Añadir comentario',
        'DELETE_PAGE' => 'Borrar esta página',
        'DELETE_THIS_PAGE_Q' => '¿Borrar esta página?',
        'ARE_YOU_SURE_DELETE_THIS_PAGE' => '¿Estás seguro de borrar esta pagina, incluidos todos los comentarios? Este proceso puede llevar algunos minutos.',
        'SEARCH_PAGES' => 'Buscar en páginas',
        'ALL_PAGES' => 'Todas las páginas',
        'SUBSCRIBE_TO_PAGES' => 'Suscríbete a estas páginas',
        'NOBODY_HAS_ADDED_PAGES' => '¡No se han añadido páginas aun!',
        'ADD_PAGES_CALL_TO_ACTION' => 'Crear una página para comenzar.',
        'CREATE_A_PAGE' => 'Crear una página',
        'PLEASE_ENTER_PAGE_CONTENT' => 'Ingresa el contenido de la página',
        'SEARCH_RESULTS_FOR_X' => 'Resultados para <em>%s</em>',
        'EDIT_YOUR_PAGE' => 'Editar tu página',
        'UPDATE_PAGE' => 'Actualizar página',
        'CLOSE_DISCUSSION' => 'Cerrar discusión',
        'REOPEN_DISCUSSION' => 'Reabrir discusión',
        'CLOSING_DISCUSSION_PREVENTS' => 'Cerrar una discusión impedirá que haya más respuestas',
        'NO_DISCUSSION_TO_DISPLAY' => 'Actualmente no estás mostrando charlas.',
        'BOX_WILL_NOT_SHOW_DISCUSSION' => 'Este área no aparecerá para otros hasta que elijas al menos una charla.',
        'NEWEST_DISCUSSIONS' => 'Charlas recientes',
        'LATEST_REPLIES' => 'Respuestas recientes',
        'REPLIES_CLOSED_FOR_DISCUSSION' => 'Las respuestas están cerradas para esta discusión.',
        'SORRY_DISCUSSION_CLOSED' => 'Lo sentimos, pero esta discusión se ha cerrado a más respuestas.',
        'MOST_REPLIES' => 'Con más respuestas',
        'OWNER_DISCUSSIONS_ONLY' => 'Sólo charlas del creador de la red',
        'MY_DISCUSSIONS_ONLY' => 'Sólo mis charlas',
        'DISCUSSION_DELETED' => 'Charla borrada',
        'DISCUSSION_HAS_BEEN_DELETED' => 'Esta charla ha sido borrada.',
        'REPLY_DELETED' => 'Respuesta borrada',
        'REPLY_HAS_BEEN_DELETED' => 'Esta respuesta se ha borrado. <a %s>Volver a la discusión.</a>',
        'VIEW_ALL_DISCUSSIONS' => 'Ver todas las charlas',
        'ADD_CATEGORIES' => 'Añadir categorías',
        'CATEGORY' => 'Categoría:',
        'NO_DISCUSSIONS_IN_CATEGORY' => 'No hay charlas en esta categoría.',
        'ADD_MANAGE_CATEGORIES' => 'Añadir/Administrar categorías',
        'VIEW_ALL_N_CATEGORIES' => 'Ver todas las categorías de %s',
        'UNTITLED_CATEGORY' => 'Categoría sin título',
        'SAMPLE_TITLE' => 'Título ejemplo',
        'UNCATEGORIZED' => 'Sin categoría',
        'EXISTING_DISCUSSIONS' => 'Charlas existentes que no tienen una categoría asignada.',
        'YOU_HAVE_NOT_ADDED_CATEGORIES' => 'No hay categorías. Añade una para empezar.',
        'ADD_A_CATEGORY' => 'Añadir categoría',
        'ADD_ANOTHER_CATEGORY' => 'Añadir otra categoría',
        'MANAGE_CATEGORIES' => 'Administrar categorías',
        'CATEGORY_TITLE' => 'Título de la categoría',
        'ALLOW_MEMBERS_TO_START_DISCUSSIONS' => 'Miembros pueden comenzar charlas en esta categoría',
        'ONLY_I_CAN_START_DISCUSSIONS' => 'Sólo yo puedo comenzar charlas en esta categoría',
        'ALLOW_MEMBERS_TO_REPLY' => 'Permitir que miembros respondan',
        'SUGGESTIONS' => 'Sugerencias:',
        'TRY_DIFFERENT_KEYWORDS' => 'Intenta otras palabras claves o términos más genéricos.',
        'VIEW_DISCUSSIONS_OR_START_DISCUSSION' => '<a %s>Ver todas las charlas</a> o <a %s>Comenzar una nueva charla</a>',
        'MAKE_SURE_WORDS_SPELLED' => 'Asegúrate de que el texto sea correcto.',
        'REPLY_WAS_DELETED' => 'Esta respuesta fue borrada',
        'TAGS_X' => '<strong>Etiquetas:</strong> %s',
        'SEND_PRIVATE_MESSAGE' => 'Enviar mensaje privado',
        'PERMALINK_TO_REPLY' => 'Enlace permanente a esta respuesta',
        'PERMALINK' => 'Enlace permanente',
        'WE_COULD_NOT_FIND_ANY_DISCUSSIONS' => 'No pudimos encontrar charlas con esa información.',
        'DISCUSSIONS_MATCHING_X' => 'Charlas que contienen <em>\'%s\'</em>',
        'SEARCH_DISCUSSIONS' => 'Buscar en los foros',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS_2' => 'No has añadido temas de discusión.',
        'ADD_DISCUSSIONS_AND_SHARE' => 'Añade discusiones y compártelas con tus amistades, familia y el resto del mundo.',
        'DISCUSSION' => 'Discusión',
        'DISCUSSIONS' => 'Discusiones',
        'KEEP_PAGE_OPEN_FORUM' => 'Por favor deja esta ventana abierta para que podamos terminar de cargar tus archivos al foro.',
        'MEANWHILE_FEEL_FREE_FORUM' => 'Mientras tanto, puedes <a %s>abrir una ventana nueva del navegador</a> y seguir usando %s.',
        'START_A_NEW_DISCUSSION' => 'Comenzar una nueva discusión',
        'DISCUSSION_TITLE' => 'Título de la discusión:',
        'FIRST_POST' => 'Post:',
        'UPLOAD_FILES' => 'Añadir archivos(s):',
        'START_DISCUSSION' => 'Comenzar discusión',
        'EDIT_DISCUSSION' => 'Editar discusión',
        'START_A_DISCUSSION' => 'Comenzar una discusión',
        'ALL_DISCUSSIONS' => 'Todas las discusiones',
        'CONTRIBUTORS' => 'Contribuyentes',
        'MY_DISCUSSIONS' => 'Mis discusiones',
        'READ_MORE' => 'Leer más',
        'STARTED_T_BY' => 'Comenzada <strong>%s</strong> por:',
        'ADDED_BY_X_T' => 'Añadido por %s %s',
        'STARTED_BY_X_T' => 'Comenzada por %s %s',
        'REPLY_BY_X_T' => 'Respuesta de <strong>%s</strong> %s',
        'STARTED_BY_X_LAST_REPLY_LINK_BY_X_T' => 'Comenzada por %s. Última <a %s>respuesta</a> de %s %s.',
        'STARTED_DISCUSSION_LAST_REPLY_LINK_BY_X_T' => '<strong>Comenzó esta discusión.</strong> Última <a %s>respuesta</a> de %s %s.',
        'STARTED_DISCUSSION_T' => '<strong>Comenzó esta discusión</strong> %s',
        'ADDED_REPLY_T' => '<strong>Añadió una respuesta</strong> %s',
        'ADDED_POST_T' => '<strong>Añadió un post</strong> %s',
        'STARTED_BY_X_ON' => 'Comenzada por %s en %s',
        'STARTED_DISCUSSION_ON' => '<strong>Comenzó esta discusión</strong> %s',
        'STARTED_ON' => '<strong>Comenzada</strong> %s',
        'ADDED_REPLY_ON' => '<strong>Añadió una respuesta</strong> %s',
        'ADDED_POST_ON' => '<strong>Añadió un post</strong> %s',
        'XS_DISCUSSIONS' => 'Discusiones de %s',
        'XS_DISCUSSIONS_LOWERCASE' => 'Discusiones de %s',
        'VIEW_XS_DISCUSSIONS' => 'Ver las discusiones de %s',
        'VIEW_YOUR_DISCUSSIONS' => 'Ver tus discusiones',
        'TAGGED_X' => 'Etiquetada: %s',
        'SUBSCRIBE_TO_DISCUSSIONS' => 'Subscribirse a estas discusiones',
        'SUBSCRIBE_TO_DISCUSSION' => 'Subscribirse a esta discusión',
        'SUBSCRIBE_TO_XS_DISCUSSIONS' => 'Subscribe a las discusiones de %s',
        'ALL_DISCUSSIONS_TAGGED_X' => 'Todas las discusiones etiquetadas <em>\'%s\'</em>',
        'SUBSCRIBE_TO_DISCUSSIONS_TAGGED_X' => 'Subscribe a las discusiones etiquetadas \'%s\'',
        'N_KB' => '%s KB',
        'N_MB' => '%s MB',
        'UPLOADING_FILES' => 'Subir archivos',
        'ATTACHMENTS' => 'Archivos adjuntos',
        'YOUR_POST' => 'Tu post:',
        'YOUR_REPLY' => 'Tu respuesta:',
        'WOULD_YOU_LIKE_TO_UPLOAD_FILES' => '¿Quieres cargar archivos?',
        'ADD_YOUR_REPLY' => 'Añade tu respuesta',
        'REPLIES_TO_THIS_DISCUSSION' => 'Respuestas a esta discusión',
        'POSTED_BY_X_ON' => 'Añadido por %s %s',
        'PLEASE_ENTER_TITLE' => 'Título',
        'PLEASE_ENTER_FIRST_POST' => 'Añade un primer post para esta discusión.',
        'REPLY_TO_THIS' => 'Responde a esto',
        'DELETE_ATTACHMENT' => 'Borrar archivo adjunto',
        'DELETE_ATTACHMENT_Q' => '¿Borrar este archivo adjunto?',
        'DELETE_REPLY' => 'Borrar respuesta',
        'DELETE_THIS_DISCUSSION_Q' => '¿Borrar esta discusión?',
        'ARE_YOU_SURE_DELETE_THIS_DISCUSSION' => '¿Estás seguro de que quieres borrar esta discusión (incluidas las respuestas)? Este proceso puede tardar unos minutos.',
        'DELETE_DISCUSSION' => 'Borrar esta discusión',
        'NOBODY_HAS_ADDED_DISCUSSIONS' => 'Aún no se han añadido discusiones.',
        'NOBODY_HAS_ADDED_DISCUSSIONS_ADD' => 'Aún no se han añadido discusiones. Añade una.',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS' => 'Aún no has añadido discusiones. ¡Añade una!',
        'YOU_HAVE_NOT_STARTED_DISCUSSIONS' => 'Aún no has añadido discusiones.',
        'YOU_HAVE_NOT_ADDED_TO_DISCUSSIONS' => 'Aún no has añadido respuestas a discusiones.',
        'X_HAS_NOT_ADDED_DISCUSSIONS' => '%s no ha añadido discusiones todavía.',
        'X_HAS_NOT_STARTED_DISCUSSIONS' => '%s no ha comenzado discusiones todavía.',
        'X_HAS_NOT_ADDED_TO_DISCUSSIONS' => '%s no ha añadido respuestas a discusiones todavía.',
        'VIEW_DISCUSSIONS' => 'Ver discusiones',
        'VIEW_ALL_PEOPLE_ON_X' => 'Ver a toda la gente en %s',
        'THERE_ARE_NO_DISCUSSIONS' => 'No hay discusiones en tu red.',
        'GROUP_HAS_NO_DISCUSSIONS' => 'Este grupo no tiene discusiones.',
        'VIEW_DISCUSSIONS_IN_GROUP_FORUM' => 'Ver discusiones en el <a %s>foro de %s</a>!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT_ADD' => 'No hay discusiones con etiquetas "%1$s". Busca <a %2$s>fotos con etiqueta "%1$s"</a> o <a %3$s>videos con etiqueta "%1$s"</a>. ¡O añade y etiqueta tus propias discusiones!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT' => 'No hay discusiones con etiquetas "%1$s". Busca <a %2$s>fotos con etiqueta "%1$s"</a> o <a %3$s>videos con etiqueta "%1$s"</a>.',
        'THIS_BOX_WILL_NOT_SHOW_DISCUSSIONS' => 'Este área no aparecerá para otros hasta que haya discusiones para mostrar. ¿Por qué no inicias una nueva discusión?',
        'DISCUSSIONS_I_STARTED' => 'Discusiones que yo comencé',
        'DISCUSSIONS_X_STARTED' => 'Discusiones comenzadas por %s',
        'DISCUSSIONS_I_REPLIED_TO' => 'Discusiones a las que respondí',
        'DISCUSSIONS_X_REPLIED_TO' => 'Discusiones a las que %s respondió',
        'PLEASE_WRITE_SOMETHING_FOR_POST' => 'Escribe algo para tu post.',
        'PLEASE_WRITE_SOMETHING_FOR_REPLY' => 'Escribe algo para tu respuesta.',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION_X' => 'Hay un nuevo comentario en tu discusión "%s" en %s',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION' => 'Hay un nuevo comentario en una de tus discusiones en %s',
        'SOMEBODY_COMMENTED_DISCUSSION_ADDED_TO_X' => 'alguien comentó en la discusión que comenzaste en %s',
        'ABOUT_YOUR_DISCUSSION' => 'Sobre tu discusión',
        'ABOUT_THIS_DISCUSSION' => 'Sobre esta discusión',
        'USER_REPLIED_TO_A_DISCUSSION_ON_Y' => '%s ha contestado a la discusión en %s',
        'USER_REPLIED_TO_DISCUSSION_TITLE_ON_APPNAME' => '%s ha contestado a la discusión "%s" en %s',
        'PROBLEM_WITH_ICON' => 'Ha ocurrido un problema con el archivo del icono',
        'GROUP_ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Los administradores del grupo tienen un nivel de control similar al del creador del grupo.',
        'CREATE_NEW_GROUP' => 'Crear grupo nuevo',
        'CREATE_A_NEW_GROUP' => 'Crear un grupo nuevo',
        'CREATE_A_GROUP' => 'Crear un grupo',
        'VIEW_GROUPS' => 'Ver grupos',
        'CREATE_GROUP' => 'Crear grupo',
        'PLEASE_ENTER_NAME_FOR_GROUP' => 'Elige un nombre para tu grupo.',
        'PLEASE_ENTER_URL_FOR_GROUP' => 'Elige una dirección de Web para tu grupo.',
        'URL_CAN_CONTAIN_ONLY_LETTERS' => 'La dirección de Web puede contener sólo letras y números (sin espacios).',
        'NAME_TAKEN' => 'Ese nombre ya existe. Por favor elige otro nombre.',
        'URL_TAKEN' => 'Esa dirección ya existe. Por favor elige otra.',
        'GROUP_INFORMATION' => 'Información del grupo',
        'EXTERNAL_WEBSITE' => 'Página Web externa',
        'DO_YOU_HAVE_EXISTING_WEBSITE' => '¿Tienes una página para el grupo en otro lugar?',
        'URL' => '"URL, dirección URL"',
        'GROUPS' => 'Grupos',
        'SEARCH_GROUPS' => 'Buscar en grupos:',
        'NOBODY_HAS_CREATED_GROUPS' => 'Aún no se ha creado ningún grupo.',
        'NOBODY_HAS_CREATED_GROUPS_ADD' => 'Nadie ha creado ningún grupo. Crea uno para comenzar.',
        'MY_GROUPS' => 'Mis grupos',
        'FEATURED_GROUPS' => 'Grupos Destacados',
        'YOU_CAN_CREATE_GROUP' => '¡Puedes <a %s>crear un grupo nuevo</a> en %s!',
        'GROUP_FORUM' => 'Foros de %s',
        'USER_CREATED_GROUP' => '%s creó este grupo en %s.',
        'GROUP_MEMBERS_COUNT' => 'Miembros de %s (%d)',
        'WE_ARE_SORRY_NOT_ALLOWED_JOIN_GROUP' => 'El acceso a este grupo es limitado.',
        'JOIN_GROUP_NOW' => '¡Únete a %s ahora!',
        'USER_HAS_INVITED_YOU_TO_JOIN_GROUP' => '%s te ha invitado a %s',
        'DECLINE' => 'No, gracias',
        'WELCOME_TO_GROUP' => 'Bienvenido a %s',
        'YOU_CAN_PARTICIPATE_IN_GROUP' => 'Ahora puedes participar en el foro %s.',
        'SEND_MESSAGE_TO_GROUP' => 'Enviar mensaje al grupo',
        'LEAVE_THIS_GROUP' => 'Dejar este grupo',
        'EDIT_GROUP_INFO' => 'Editar la información de este grupo',
        'EDIT_GROUP_INFORMATION' => 'Editar la información de este grupo',
        'MANAGE_GROUP_MEMBERS' => 'Administrar la membresía del grupo',
        'GROUP_HAS_NO_MEMBERS' => 'Este grupo aún no tiene miembros.',
        'GROUP_HAS_NO_MEMBERS_THAT_MATCH' => 'Este grupo no tiene miembros que satisfagan tus condiciones de búsqueda.',
        'USERS_GROUPS' => 'Grupos de %s',
        'YOU_HAVE_NOT_CREATED_GROUPS' => 'Aún no has creado ningún grupo.',
        'USER_HAS_NOT_CREATED_GROUPS' => '%s aún no ha creado ningún Grupo.',
        'THERE_ARE_NO_FEATURED_GROUPS' => 'No hay grupos destacados en tu red social.',
        'START_FEATURING_GROUPS' => 'Destaca grupos cuando veas la opción Destacar. Para saber más, <a %s>haz clic aquí</a>.',
        'NO_GROUPS_TO_DISPLAY' => 'Actualmente no estás mostrando ningún grupo.',
        'BOX_WILL_NOT_SHOW_GROUPS' => 'Este área no aparecerá para otros hasta que elijas al menos un grupo.',
        'YOU_HAVE_NOT_CREATED_GROUPS_2' => 'Aún no has creado ningún grupo.',
        'CREATE_GROUPS_AND_SHARE' => 'Crea grupos y compártelos con tus amistades, familia y el resto del mundo.',
        'THERE_ARE_NO_GROUPS' => 'Actualmente no hay grupos en tu red.',
        'THIS_BOX_WILL_NOT_SHOW_GROUPS' => 'Este área no aparecerá para otros hasta que haya grupos para mostrar. ¿Por qué no creas uno?',
        'GROUPS_MATCHING_SEARCH_TERM' => 'Grupos que coinciden con <em>\'%s\'</em>',
        'WE_COULD_NOT_FIND_ANY_GROUPS' => 'No pudimos encontrar grupos que coincidan con los términos de tu búsqueda.',
        'VIEW_GROUPS_OR_CREATE_GROUP' => '<a %s>Ver todos los grupos</a> o <a %s>Crear un grupo nuevo</a>',
        'VIEW_ALL_GROUPS' => 'Ver todos los grupos',
        'DELETE_GROUP' => 'Borrar grupo',
        'DELETE_GROUP_Q' => '¿Borrar este grupo?',
        'GROUP_INVITATIONS' => 'Invitaciones al grupo',
        'YOU_HAVE_BEEN_INVITED_TO_JOIN' => 'Te han invitado a unirte a:',
        'VISIT' => 'Visita',
        'WHO_CAN_JOIN_GROUP' => '¿Quién puede unirse a este grupo?',
        'PRIVACY_CANNOT_BE_CHANGED' => 'La privacidad no se puede cambiar una vez que el grupo ha sido creado.',
        'ONLY_INVITED_PEOPLE' => 'Sólo personas invitadas',
        'ALLOW_PEOPLE_TO_REQUEST' => 'Permitir a todo el mundo pedir invitaciones',
        'ANYONE_CAN_JOIN_GROUP' => 'Todos pueden unirse a este grupo',
        'ONLY_INVITED_PEOPLE_CAN_JOIN_GROUP' => 'Sólo personas invitadas puede unirse a este grupo',
        'WHY_NOT_CREATE_GROUP' => '¿Por qué no <a %s>creas tu propio grupo</a>?',
        'PLEASE_ENTER_NAME' => 'Nombre',
        'PLEASE_ENTER_EMAIL_ADDRESS' => 'Dirección de email',
        'PLEASE_ENTER_PAGE_ADDRESS' => 'Por favor escribe una nueva dirección de página.',
        'PLEASE_ENTER_PASSWORD' => 'Por favor escribe tu contraseña.',
        'CREATE_ACCOUNT_OR_SIGN_IN' => '<a %s>Haz clic aquí para crear una cuenta</a> o intenta iniciar una sesión otra vez abajo.',
        'CREATE_ACCOUNT_OR_JOIN' => '<a %s>Haz clic aquí para crear una cuenta</a> o intenta unirte otra vez con tu ID Ning abajo.',
        'CHOOSE_SHORTER_PASSWORD' => 'Por favor elige una contraseña más pequeña',
        'CHOOSE_SHORTER_NAME' => 'Por favor elige un nombre más corto.',
        'ENTER_SHORTER_CITY_NAME' => 'Por favor elige un nombre de ciudad más corto.',
        'PLEASE_ENTER_PASSWORD_AGAIN' => 'Por favor escribe tu contraseña otra vez en la caja “Reescribe contraseña”.',
        'PLEASE_ENTER_CURRENT_PASSWORD' => 'Por favor escribe tu contraseña actual.',
        'PLEASE_ENTER_NEW_PASSWORD' => 'Por favor escribe tu contraseña nueva.',
        'PLEASE_ENTER_NEW_PASSWORD_AGAIN' => 'Por favor escribe tu nueva contraseña otra vez en la caja “Confirmar contraseña”.',
        'CURRENT_PASSWORD' => 'Contraseña actual',
        'PASSWORDS_DO_NOT_MATCH' => 'Las dos contraseñas no son iguales.',
        'NEW_AND_CONFIRMATION_PASSWORDS' => 'La contraseña nueva y la contraseña de confirmación no son iguales.',
        'YOUR_REQUEST_HAS_BEEN_SENT_TO_GROUP_CREATOR' => 'Tu solicitud ha sido enviada al creador del grupo.',
        'X_IS_NOT_VALID_EMAIL_ADDRESS' => '%s no es un email válido',
        'COME_JOIN_ME_ON_GROUP' => '¡Ven y únete a %s!',
        'INVITE_PEOPLE_TO_GROUP' => 'Invita gente a %s',
        'INVITE_FRIENDS_TO_GROUP' => 'Invita amigos a %s',
        'SEND_INVITATIONS_TO_JOIN_GROUP' => 'Envía invitaciones para unirse a %s.',
        'GROUPNAME_MEMBERS' => 'Miembros de %s',
        'GROUP_CREATOR' => 'Creador del grupo',
        'GROUP_ADMINISTRATOR' => 'Administrador del grupo',
        'DATE_BANNED' => 'Fecha de prohibición de acceso',
        'BAN_FROM_GROUP' => 'Prohibir acceso al grupo',
        'ARE_YOU_SURE_BAN_MEMBER_FROM_GROUP' => '¿Estas seguro de que quieres prohibir acceso al (a los) miembro(s) elegido(s)? Este proceso puede llevar unos minutos.',
        'ALSO_DELETE_FORUM_POSTINGS' => 'También borrar sus respuestas y discusiones.',
        'GROUP_WEB_ADDRESS' => 'Dirección de Web del grupo',
        'GROUP' => 'Grupo',
        'BACK_TO_GROUP' => '← Volver a %s',
        'USER_BANNED_FROM_GROUP' => '%1$s no puede acceder a este grupo. <a %2$s>Envíale un mensaje a %1$s</a>',
        'USER_ALREADY_GROUP_MEMBER' => '%1$s ya es un miembro de este grupo. <a %2$s>Envíale un mensaje a %1$s</a>',
        'GROUP_ADMIN_DISCUSSIONS' => 'Administrar discusiones del grupo',
        'BACK_TO_NETWORK_GROUPS' => 'Volver a grupos de %s',
        'MOST_MEMBERS' => 'Con más miembros',
        'THIS_SETS_URL_OF_GROUP' => 'Esto define el URL para tu grupo:<br />http://%s/<strong>groupwebaddress</strong>',
        'LIKE_WHAT_YOU_SEE' => '¿Te gusta lo que ves en %s? ¡Únete ahora!',
        'LIKE_WHAT_YOU_SEE_GROUP' => '¿Te gusta lo que ves en %s? ¡Únete ahora!',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => 'Has creado el grupo %1$s. Puedes participar en el foro %1$s o invitar más personas a que se unan.',
        'YOU_ARE_MEMBER_OF_GROUP_AND_CAN_INVITE' => 'Ahora eres miembro de %1$s. Puedes participar en el foro %1$s o invitar más personas a que se unan.',
        'NETWORK_DOES_NOT_HAVE_MUSIC' => 'Esta red aún no tiene música.',
        'PERSON_DOES_NOT_HAVE_MUSIC' => 'Esta persona aún no tiene música.',
        'FIND_MORE_MUSIC_LIKE_THIS' => 'Encuentra más música como esta en <em>%s</em>',
        'TRACKS' => 'Pistas',
        'ADD_MUSIC_TRACKS' => 'Añadir música',
        'CHOOSE_MUSIC_TRACKS' => 'Elige canciones para añadir',
        'YOU_CAN_ADD_UP_TO_MP3' => 'Puedes añadir hasta 4 MP3 cada vez.',
        'UPLOAD_TRACKS' => 'Subir canciones',
        'ADD_TRACKS' => 'Añadir canciones',
        'ENTER_THE_URL_MP3_TO_ADD' => 'Ingresa el URL de cada MP3 que quieres añadir:',
        'EACH_MP3_FILE_MAY_BE_UP_TO' => '¡Puedes cargar hasta 100 MP3! Cada MP3 puede ser de hasta 20 MB, pero los archivos más pequeños se cargarán más rápidamente.',
        'BE_NICE' => 'Sé cordial',
        'PLEASE_UPLOAD_ONLY_TRACKS' => 'Por favor, carga canciones sólo si tienes permiso del artista o de quien controla el copyright.',
        'PLEASE_LINK_ONLY_TRACKS' => 'Por favor añade enlaces a música que haya sido autorizada para distribución en Internet.',
        'MORE_WAY_TO_ADD_MUSIC' => 'Más maneras de añadir música…',
        'ELLIP_FROM_ANOTHER_WEBSITE' => '…desde un sitio Web',
        'ADD_MUSIC_FROM_ANY_WEBSITE' => 'Añade música de cualquier otra página pegando el enlace al MP3.',
        'KEEP_PAGE_OPEN_MUSIC' => 'Por favor deja esta ventana abierta para que podamos terminar de cargar tus canciones y te diremos cuando hayan sido aprobadas',
        'MEANWHILE_FEEL_FREE_MUSIC' => 'Mientras tanto, puedes abrir otra ventana del navegador y continuar usando %s. Cuando el proceso acabe, podrás añadir títulos y descripciones para tus canciones en esta ventana.',
        'TRACKS_EXCEEDED_LIMIT' => 'El archivo de la canción parece ser de más de 10MB.',
        'EDIT_TRACK_INFORMATION' => 'Editar información de la canción.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_1' => 'Añade un título, descripción u otra información a las canciones que acabas de cargar.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_2' => 'Añade un título, descripción u otra información a esta canción.',
        'CANCEL_AND_RETURN_TO_PLAYLIST' => 'Cancelar y volver a la lista de reproducción',
        'TRACK_TITLE' => 'Canción',
        'TRACK_ARTIST' => 'Artista',
        'TRACK_ALBUM' => 'Álbum',
        'ENABLE_DOWNLOAD_LINK' => 'Permitir bajar',
        'ALLOW_PEOPLE_TO_ADD_TRACK_TO_PROFILE' => 'Permitir a usuarios poner esta canción en sus páginas',
        'TRACK_ARTWORK' => 'Carátula',
        'EDIT_PLAYLIST' => 'Editar lista de canciones',
        'DRAG_TO_CHANGE_ORDER_PLAYLIST' => 'Para reordenar la lista, selecciona y arrastra la canción a donde la quieras poner.',
        'ADD_MUSIC_ELLIPSIS' => 'Añadir música…',
        'ELLIPSIS_FROM_YOUR_COMPUTER' => '…de tu ordenador',
        'UPLOAD_MP3_FROM_YOUR_COMPUTER' => 'Subir MP3 de tu ordenador.',
        'DELETE_THIS_TRACK_Q' => '¿Borrar esta canción?',
        'DELETE_TRACK' => 'Borrar canción',
        'ARE_YOU_SURE_DELETE_THIS_TRACK' => '¿Estás seguro de que quieres borrar esta canción?',
        'PLAY' => 'reproducir',
        'GENRE' => 'Género',
        'YEAR' => 'Año',
        'LABEL' => 'Distribuidora',
        'EXPLICIT_LYRICS' => 'Letra explícita',
        'ARTIST_SITE' => 'Página del artista',
        'HOSTING_SITE' => 'Página de hosting',
        'LABEL_SITE' => 'Página de la distribuidora',
        'LICENSE' => 'Licencia',
        'SELECT_LICENSE' => '- Elegir licencia -',
        'LICENSE_NAME' => 'Nombre de la licencia',
        'LICENSE_URL' => 'URL de la licencia',
        'MUSIC' => 'Música',
        'ALLOW_PEOPLE_TO_UPLOAD_AND_SHARE_AUDIO' => 'Permitir que los usuarios suban y compartan audio',
        'PLAYLIST' => 'Lista de reproducción',
        'PODCAST' => 'Podcast',
        'MOST_RECENT_TRACKS' => 'Más recientes',
        'FEATURED_TRACKS' => 'Destacados',
        'HIGHEST_RATED_TRACKS' => 'Calificación más alta',
        'NO_TRACKS_TO_PLAY' => 'Actualmente no hay música en tu red social.',
        'BOX_WILL_NOT_SHOW_TRACKS' => 'Este área no aparecerá para otros hasta que haya canciones o podcasts.',
        'NO_TRACKS_ON_PLAYLIST' => 'Actualmente no hay canciones en esta lista.',
        'PLAYER_WILL_NOT_SHOW_TRACKS' => 'Este reproductor no aparecerá para otros hasta que haya canciones o podcasts.',
        'NO_FEATURED_TRACKS' => 'No hay canciones destacadas en tu red.',
        'START_FEATURING_TRACKS' => 'Marca como elegidas a las canciones que quieres escuchar en la pagina principal.',
        'VIEW_MUSICPLAYER' => 'Ver reproductor',
        'MY_PLAYLIST' => 'Mi lista de reproducción',
        'NETWORK_PLAYLIST' => 'Lista de reproducción de la red',
        'COPYRIGHT' => '© Todos los derechos reservados',
        'CC_BY_X' => 'Creative Commons Attribution %s',
        'CC_BY_SA_X' => 'Creative Commons Attribution Share Alike %s',
        'CC_BY_ND_X' => 'Creative Commons Attribution No Derivatives %s',
        'CC_BY_NC_X' => 'Creative Commons Attribution Non-commercial %s',
        'CC_BY_NC_SA_X' => 'Creative Commons Attribution Non-commercial Share Alike %s',
        'CC_BY_NC_ND_X' => 'Creative Commons Attribution Non-commercial No Derivatives %s',
        'PUBLICDOMAIN' => 'Dominio público',
        'FACEBOOK_CONFIRM_DISABLE' => '¿Estás seguro?',
        'FACEBOOK_PLAYER_DISABLE' => 'Inhabilitar',
        'FACEBOOK_MUSIC_PLAYER_TITLE' => 'Reproductor de música',
        'FACEBOOK_MUSIC_PLAYER_DESC' => 'Permite a cualquiera añadir una aplicación a sus páginas de perfil de Facebook para reproducir tu música elegida.',
        'FACEBOOK_MUSIC_BUTTON' => 'Crear aplicación de música y radio',
        'FACEBOOK_MUSIC_PLAYER_ENABLED' => 'El reproductor de música de Facebook ya está habilitado.',
        'FACEBOOK_VIDEO_PLAYER_TITLE' => 'Reproductor de video',
        'FACEBOOK_VIDEO_PLAYER_DESC' => 'Permite a cualquiera añadir una aplicación a sus páginas de perfil de Facebook para mostrar un video de tu red.',
        'FACEBOOK_VIDEO_BUTTON' => 'Crear aplicación de video y radio',
        'FACEBOOK_VIDEO_PLAYER_ENABLED' => 'El reproductor de video de Facebook ya está habilitado',
        'FACEBOOK_SLIDESHOW_PLAYER_TITLE' => 'Exposición de fotos',
        'FACEBOOK_SLIDESHOW_PLAYER_DESC' => 'Permite a cualquiera añadir una aplicación a sus páginas de perfil de Facebook para mostrar una exposición de las fotos de tu red.',
        'FACEBOOK_SLIDESHOW_BUTTON' => 'Crea una aplicación de exposición de fotos y radio',
        'FACEBOOK_SLIDESHOW_PLAYER_ENABLED' => 'La exposición de fotos de Facebook ya está habilitada.',
        'FACEBOOK_PLATFORM_LOGO' => 'Plataforma de logotipos de Facebook',
        'FACEBOOK_QUICK_INTRO_1' => 'Facebook, es un sitio popular de redes, que permite a programadores externos crear aplicaciones que se pueden añadir a las páginas de perfil de los miembros de Facebook. Además de ofrecer esta funcionalidad adicional a las páginas de perfil de los miembros, estas aplicaciones se pueden usar para llevar a los usuarios de Facebook a otros destinos.',
        'FACEBOOK_QUICK_INTRO_2' => 'Con Ning, no necesitas ser programador para promocionar tu red social en Facebook. Ya hemos hecho la parte más difícil y tu red ya está construida con el integrador de aplicaciones de Facebook. Tan sólo tienes que elegir las opciones de abajo y tu red social se integrará en Facebook en segundos.',
        'FACEBOOK_ADD_DEVELOPER_BUTTON' => 'Añadir botón de programador',
        'FACEBOOK_SETUP_NEW_APP_BUTTON' => 'Configurar el botón aplicación nueva',
        'FACEBOOK_YOUR_APPLICATIONS' => 'Tus aplicaciones Facebook',
        'FACEBOOK_EMBEDDING' => 'Promoción en Facebook',
        'FACEBOOK_SETUP' => 'Promoción en Facebook',
        'FACEBOOK_PROMOTING' => 'Promocionar aplicaciones en Facebook',
        'FACEBOOK_VIEW_APP' => 'Ver aplicación',
        'FACEBOOK_ADD_THE' => 'Añadir el',
        'FACEBOOK_RECENT' => 'Más recientes',
        'FACEBOOK_RECENTLY_FEATURED' => 'Más recientemente destacado',
        'FACEBOOK_RECENTLY_ADDED' => 'Los añadidos más recientes',
        'FACEBOOK_PROMOTED' => 'Destacados',
        'FACEBOOK_RATED' => 'Calificación más alta',
        'FACEBOOK_POPULAR' => 'Popular',
        'FACEBOOK_MUSIC_WIDGET' => 'Widget de música',
        'FACEBOOK_VIDEO_WIDGET' => 'Widget de video',
        'FACEBOOK_PHOTO_WIDGET' => 'Widget de fotos',
        'FACEBOOK_INSTR_FIRST_STEPS' => 'Primeros pasos',
        'FACEBOOK_INSTR_CLICK_HERE_TO_GO_TO_FACEBOOK' => 'Haz clic aquí para ir a Facebook y empezar a crear tu aplicación.',
        'FACEBOOK_INSTR_OPEN_FACEBOOK_IN_NEW_WINDOW' => 'Esto abrirá Facebook en una ventana nueva. Si no estás conectado a Facebook, tendrás que conectarte ahora.',
        'FACEBOOK_INSTR_FIRST_STEPS_1' => 'Si no has creado una aplicación en Facebook, te pedirán que añadas una aplicación desarrollada de Facebook. Una vez que lo hayas hecho, saldrá un mensaje "No tienes aplicaciones." Clic para <strong>crear una</strong>.',
        'FACEBOOK_INSTR_FIRST_STEPS_2' => 'Si ya has creado una aplicación en Facebook, irás a la aplicación desarrollada de Facebook. Haz clic en el botón <strong>Configura la nueva aplicación</strong>.',
        'FACEBOOK_INSTR_FIRST_STEPS_NEXT' => 'A continuación: Aquí tienes instrucciones sobre cómo configurar tu aplicación %s para que funcione en Facebook.',
        'FACEBOOK_INSTR_SETUP' => 'Instrucciones de configuración',
        'FACEBOOK_INSTR_SETUP_1' => '¡Felicitaciones! Ahora los detalles. Facebook necesita tener información básica para que tu aplicación funcione. Sigue los pasos de abajo.',
        'FACEBOOK_INSTR_SETUP_REQ_FIELDS' => 'Campos obligatorios',
        'FACEBOOK_INSTR_SETUP_2' => 'Escoge un <strong>nombre de aplicación</strong>.',
        'FACEBOOK_INSTR_SETUP_3' => 'Marca para indicar que has leído el documento de términos de Facebook.',
        'FACEBOOK_INSTR_SETUP_4' => 'Abre la sección <em>campos opcionales</em>.',
        'FACEBOOK_INSTR_SETUP_BASE_OPT' => 'Opciones base',
        'FACEBOOK_INSTR_SETUP_5' => 'Pon tu dirección email en el campo <strong>email de soporte</strong>.',
        'FACEBOOK_INSTR_SETUP_6' => 'Copia la siguiente dirección de Web en el campo <strong>URL de retorno de llamada</strong> :',
        'FACEBOOK_INSTR_SETUP_7_EXAMPLE_X' => 'Elige <strong>una página URL Canvas</strong> (por ejemplo <em>%s</em>).',
        'FACEBOOK_INSTR_SETUP_8' => 'Elige <strong>Sí</strong> para <em>¿Puede tu aplicación añadirse en Facebook?</em>.',
        'FACEBOOK_INSTR_SETUP_INST_OPT' => 'Opciones de instalación',
        'FACEBOOK_INSTR_SETUP_APP_DESC' => 'Escribe una <strong>descripción de la aplicación</strong>.',
        'FACEBOOK_INSTR_SETUP_9' => 'Copia el siguiente código en el campo <strong>FBML predeterminado</strong>:',
        'FACEBOOK_INSTR_SETUP_9B_WIDE' => 'Para la<strong>caja columna de perfil predeterminado, </strong> elige <strong>Ancha</strong>.',
        'FACEBOOK_INSTR_SETUP_9B_NARROW' => 'Para la <strong>caja columna de perfil predeterminado, </strong> elige <strong>Estrecha</strong>.',
        'FACEBOOK_INSTR_SETUP_10' => 'En el campo <strong>Side Nav URL</strong> escribe tu  <em>página URL Canvas</em> (tal y como la creaste en el paso &#8216;f&#8217; de arriba). Asegúrate de incluir la parte  http://apps.facebook.com/ de la dirección URL.',
        'FACEBOOK_INSTR_SETUP_11' => 'Escribe el texto para la <strong>Acción de adjuntar</strong>. Esto es lo que aparecerá si mandas un mensaje a una persona en Facebook y quieres incluir tus aplicaciones. Si tu aplicación es una exposición de fotos, puedes introducir fotos desde el nombre de la red. Si tu aplicación es un reproductor de video, puedes introducir videos desde el nombre de la red.',
        'FACEBOOK_INSTR_SETUP_12' => 'Copia la siguiente dirección de Web en el campo <strong>URL de retorno de llamada</strong> :',
        'FACEBOOK_INSTR_APPLICATION_SETUP_PAGE' => 'Página de configuración de aplicaciones Facebook',
        'FACEBOOK_INSTR_SETUP_DONE' => 'Cuando termines, haz clic en el botón <strong>Enviar</strong>.',
        'FACEBOOK_INSTR_SETUP_NEXT' => 'Siguiente: Recuperar la llave API y el secreto.',
        'FACEBOOK_API_INFO_TITLE' => 'Información API de Facebook',
        'FACEBOOK_API_INFO_DESC' => 'Para completar la configuración, tienes que escribir tu llave API y secreto y el URL de tu aplicación en los campos de abajo.',
        'FACEBOOK_API_INFO_FIND_KEY' => 'Puedes encontrar la llave API y el secreto en tu <a %s>página Mis aplicaciones de Facebook</a> (se abre en una ventana nueva) bajo el título de aplicación que acabas de crear.',
        'FACEBOOK_API_INFO_MY_APPLICATIONS_PAGE' => 'Página de mis aplicaciones (resalta la ubicación de la información API)',
        'FACEBOOK_API_INFO_KEY' => 'Llave API',
        'FACEBOOK_API_INFO_SECRET' => 'Secreto API',
        'FACEBOOK_URL_INFO_TITLE' => 'URL de la aplicación de Facebook',
        'FACEBOOK_URL_INFO_DESC' => 'El URL de la aplicación es la misma que el <strong>URL de la página Canvas</strong> que has definido en la página anterior (paso &#8216;f&#8217;).',
        'FACEBOOK_MUSIC_SHOULD_PLAY_FROM' => 'Las aplicaciones de música de Facebook deberían ponerse en:',
        'FACEBOOK_VIDEO_SHOULD_PLAY_FROM' => 'Las aplicaciones de video de Facebook deberían ponerse en:',
        'FACEBOOK_PHOTO_SHOULD_PLAY_FROM' => 'Las aplicaciones de exposición de fotos de Facebook debería ponerse en:',
        'FACEBOOK_PROMOTING_ON' => 'Promocionarse en Facebook',
        'FACEBOOK_SETUP_INSTR' => 'Instrucciones de configuración',
        'FACEBOOK_API_INFO' => 'Información API',
        'FACEBOOK_DISABLE' => 'Inhabilitar esta aplicación',
        'FACEBOOK_TO_YOUR_FACEBOOK_PROFILE' => 'Ir a tu perfil de Facebook',
        'FACEBOOK_BACK_TO_EMBEDDING' => 'Volver a la promoción de Facebook',
        'FACEBOOK_EMBEDDING_DESC' => 'Permitir a los usuarios de Facebook poner los widgets e insignias de tu red en sus páginas de perfiles.',
        'FACEBOOK_PROMOTE' => 'Para obtener una promoción lo más sonada posible de tu aplicación, te recomendamos que sigas los siguientes pasos. Se puede acceder a estas opciones desde la página <strong><a %s>Mis aplicaciones</a></strong> de Facebook (el enlace se abre en una ventana nueva).',
        'FACEBOOK_PROMOTE_TITLE_ABOUT_PAGE' => 'Crea una página "Acerca de"',
        'FACEBOOK_PROMOTE_TEXT_ABOUT_PAGE' => 'Permite que los usuarios de Facebook sepan de qué trata tu aplicación, dando una descripción clara. Para editar esta información, haz clic en el enlace <strong> Página editar Acerca de </strong> que está al lado de la aplicación que estás modificando.',
        'FACEBOOK_PROMOTE_TITLE_SUBMIT' => 'Envía la aplicación al directorio de Facebook.',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_1' => 'Divulga tu nueva aplicación añadiéndola en el directorio de Facebook.',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_2' => 'Para enviar tu aplicación haz clic en el enlace <strong>Enviar aplicación</strong> que está al lado de la aplicación que estás modificando. En la página que sigue podrás editar la descripción de la aplicación y podrás añadir un logotipo a tu aplicación.',
        'FACEBOOK_PROMOTE_TITLE_PROFILE' => 'Añadir la aplicación a tu perfil de Facebook',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_1' => 'Mostrar tu aplicación añadiéndola a tu página de perfil de Facebook, luego espera a que tus amigos hagan lo mismo.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_2' => 'Tan sólo haz clic en el enlace <strong>Ver página Acerca de</strong>que está al lado de la aplicación que quieres añadir a tu perfil y luego elige el botón Añadir aplicación que está en la siguiente página.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_3' => '¡Tu aplicación está en la parte inferior de página de perfil de Facebook!',
        'FACEBOOK_PROMOTE_MY_APPLICATIONS_PAGE' => 'Mi página de aplicaciones de Facebook',
        'FACEBOOK_MY_APPS' => 'Mis aplicaciones',
        'FORUM_TAB_TEXT' => 'Foro',
        'VIDEOS_TAB_TEXT' => 'Videos',
        'PHOTOS_TAB_TEXT' => 'Fotos',
        'GROUPS_TAB_TEXT' => 'Grupos',
        'YOUR_VIDEO_UPLOAD_TO_X_DID_NOT_COMPLETE_DUE_TO_A_CONVERSION_ERROR' => 'No se completó la carga del video %s debido a un error de conversión.',
        'TO_HELP_TROUBLESHOOT_PROVIDE_THIS_VIDEO_ID_X' => 'Para ayudar a solucionar el problema, proporciona el identificador de este video: %s',
        'YOUR_VIDEO_WAS_SUCCESSFULLY_UPLOADED_TO_X' => 'Tu video fue cargado a %s.',
        'TO_VIEW_THE_VIDEO_VISIT' => 'Para ver el video visita:',
        'YOUR_VIDEO_X_ON_Y_HAS_A_NEW_COMMENT' => 'Tu video  "%1$s" en %2$s, tiene un comentario nuevo',
        'YOUR_VIDEO_ON_X_HAS_A_NEW_COMMENT' => 'Hay un nuevo comentario sobre tu video en %s.',
        'YOUR_PHOTO_X_HAS_A_NEW_COMMENT_ON_Y' => 'Tu foto "%1$s" tiene un comentario nuevo en %2$s.',
        'YOUR_PHOTO_HAS_A_NEW_COMMENT_ON_X' => 'Hay un comentario nuevo sobre tu foto en %s.',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y_ELLIPSIS' => 'Tienes que aprobar un nuevo %1$s en %2$s…',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y' => 'Tienes que aprobar un nuevo %1$s en %2$s.',
        'YOU_HAVE_A_NEW_X_TITLE_TO_APPROVE_ON_Y' => 'Tienes que aprobar un nuevo %1$s "%2$s" en %3$s.',
        'TO_APPROVE_THIS_X_VISIT' => 'Para aprobar este %s, visita:',
        'YOUR_X_ON_Y_HAS_BEEN_APPROVED_ELLIPSIS' => 'Tu %1$s ha sido aprobado en %2$s…',
        'YOUR_TYPE_ON_X_HAS_A_NEW_COMMENT_ELLIPSIS' => 'Tu %1$s en %2$s tiene un comentario nuevo…',
        'CLICK_HERE_TO_JOIN' => 'Haz clic para unirte:',
        'X_WANTS_YOU_TO_CHECK_OUT_Y_ON_Z' => '¡%1$s quiere que le des un vistazo a "%2$s" en %3$s!',
        'YOUR_X_HAS_BEEN_APPROVED_ON_Y' => 'Tu %s ha sido aprobado(a) en %s.',
        'YOUR_X_Y_HAS_BEEN_APPROVED_ON_Z' => 'Tu %1$s "%2$s" se ha aprobado en %3$s.',
        'TO_VIEW_YOUR_X_VISIT' => 'Para ver tus %s, visita:',
        'TO_VIEW_THIS_X_VISIT' => 'Para ver este %s, visita:',
        'TO_VIEW_IT_VISIT' => 'Para verlo, visita:',
        'X_REPORTED_THE_FOLLOWING_ISSUE_ON_Y_ELLIPSIS' => '%1$s ha informado del siguiente tema en %2$s…',
        'USER_HAS_SENT_YOU_A_MESSAGE_ON_X' => '%1$s te ha mandado un mensaje sobre %2$s.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X' => '%1$s ha pedido membresía de %2$s en %3$s.',
        'TO_APPROVE_OR_DENY_USER_REQUEST' => 'Para aprobar o denegar la petición %s\'s visita:',
        'X_ADDED_A_COMMENT_TO_THE_BLOG_POST_Y_ON_Z' => '%1$s ha añadido un comentario al post del blog "%2$s" en %3$s.',
        'X_ADDED_A_COMMENT_TO_A_BLOG_POST_ON_Y_ELLIPSIS' => '%1$s ha añadido un comentario al post del blog en %2$s…',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X' => 'Tienes que aprobar un nuevo miembro en %s.',
        'WELCOME_TO_THE_GROUP_X_ON_Y' => 'Bienvenido al grupo "%1$s" en %2$s',
        'LOADING_YOUR_FRIENDS' => 'Estamos cargando tus amigos…',
        'YOUR_MESSAGE_HAS_BEEN_SENT_TITLE_CASE' => 'Se ha enviado el mensaje',
        'TO_SEND_ANOTHER_MESSAGE' => 'Para enviar otro mensaje, por favor escribe el texto aquí abajo.',
        'PLEASE_CHOOSE_FRIENDS' => 'Por favor elijge a algunos amigos antes de mandar tu mensaje.',
        'THESE_FRIENDS' => 'Estos amigos:',
        'ALL_FRIENDS' => 'Todos los amigos',
        'ALL_FRIENDS_ON_APPNAME' => 'Todos los amigos en %s',
        'SHARE_WITH_FRIENDS' => 'Compartir con amigos',
        'SHARE_THIS_WITH_FRIENDS' => 'Comparte este elemento con tus amigos',
        'COMPOSE_MESSAGE' => 'Escribe un mensaje',
        'INVITATION_LINK_ONLY_VISIBLE' => 'Este enlace de invitación sólo lo ven el creador de la red y los administradores. Los miembros que se unen con este enlace se convertirán en amigos del creador de la red de forma automática.',
        'WE_ARE_LOADING_ADDRESSES' => 'Estamos cargando tus direcciones…',
        'SELECT_ALL_NONE' => 'Elegir todos/ninguno',
        'INVITE_TO_APPNAME' => 'Invita a \'%s\'',
        'INVITE_YOUR_FRIENDS_TO_APPNAME' => 'Invita a tus amigos a \'%s\'',
        'ALREADY_MEMBER_OF_NETWORK' => '(Ya es miembro de la red)',
        'OR_SHARE_THIS_INVITATION_LINK' => 'O comparte este enlace de invitación:',
        'CLICK_TO_MAIL' => '<a %s>Haz clic para escribir un email</a>.',
        'MESSAGE_HAS_BEEN_SENT' => 'Se ha enviado su mensaje',
        'YOU_CAN_SHARE_THIS' => 'Puedes compartir con más gente abajo, o <a %s>volver a la página anterior</a>.',
        'VCARD_IMPORT_UNAVAILABLE' => 'Lo sentimos, el servicio de importación de vCard no está disponible en este momento.',
        'CSV_IMPORT_UNAVAILABLE' => 'Lo sentimos, el servicios de importación de CSV no está disponible en este momento.',
        'ERROR_OCCURRED' => 'Lo sentimos, ha ocurrido un error.',
        'IMPORT_FAILED' => 'Lo sentimos, la importación ha fallado.',
        'LOGIN_FAILED' => 'Lo sentimos, el inicio de sesión ha fallado.',
        'UNABLE_TO_FIND_EMAIL' => 'Lo sentimos, no podemos encontrar el campo de correo electrónico.',
        'CANNOT_READ_VCARDS' => 'Lo sentimos, no podemos leer estas vCards.',
        'NO_ADDRESSES_FOUND' => 'No se han encontrado direcciones',
        'WE_DID_NOT_FIND_ADDRESSES' => 'No hemos encontrado ninguna dirección en la agenda que hemos importado.',
        'IMPORT_FROM_WEB_ADDRESS_BOOK' => 'Importar desde la agenda Web',
        'IMPORT_FROM_ADDRESS_BOOK_APPLICATION' => 'Importar de la aplicación Agenda',
        'PRIVACY_POLICY' => 'Política de privacidad',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK_ON_Y' => '%1$s ofreció el siguiente comentario en %2$s:',
        'CHECK_OUT_X_ON_Y_ELLIPSIS' => 'Échale un vistazo a "%1$s" en %2$s…',
        'CHECK_OUT_THIS_X_ON_Y_ELLIPSIS' => 'Échale un vistazo a este %1$s en %2$s…',
        'SEND_MESSAGE_TO_FRIENDS' => 'Enviar un mensaje a amigos',
        'PICK_VALID_ALL_FRIENDS_NOTIFICATION' => 'Por favor elige una opción válida para las notificaciones de mensajes enviados a todos los amigos.',
        'WELCOME_MEMBER_N_OF_APPNAME_INVITE' => '¡Bienvenido, %1$s! Ahora eres miembro #%2$s of %3$s. <a %4$s>Invita a amigos</a>.',
        'YOU_COMMENTED_ON_PHOTO_TITLE' => 'Has hecho un comentario sobre la foto <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_PHOTO_TITLE' => '%s ha hecho un comentario sobre la foto <a %s>%s</a>',
        'YOU_COMMENTED_ON_VIDEO_TITLE' => 'Has hecho un comentario sobre el video <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_VIDEO_TITLE' => '%s ha hecho un comentario sobre el video <a %s>%s</a>',
        'THIS_IS_YOUR_PAGE' => 'Esta es tu página:',
        'MESSAGES_SENT_TO_ALL_FRIENDS' => 'Mensajes enviados a todos los amigos',
        'TO_STOP_FOLLOWING_THIS_X_GO_TO' => 'Para dejar de seguir este %s, ve a:',
        'CHOOSE_GADGETS' => '¡Elige unos de estos geniales gadgets OpenSocial para añadirlo a tu página perfil! Puedes <a %s>ver y puntuar gadgets aquí</a> o <a %s>aprender más acerca de OpenSocial aquí</a>.',
        'GADGETS_UNAVAILABLE' => 'Los gadgets no están disponibles temporalmente',
        'APOLOGIES_GADGETS_UNAVAILABLE' => 'Lo sentimos – los gadgets no están disponibles temporalmente.',
        'BOX_WILL_NOT_SHOW_GADGET' => 'Este área no aparecerá para otra gente a no ser que elijas un gadget.',
        'CLICK_EDIT_TO_SPECIFY_GADGET_OR_VISIT_GADGET_GALLERY' => 'Por favor haz clic en Editar para especificar el URL del gadget de este área o visita el <a %s>Directorio de los gadgets</a>.',
        'PROBLEM_OCCURRED_RETRIEVING_GADGET' => 'Ha ocurrido un problema al tratar de obtener la alimentación URL del gadget.',
        'ADD_GADGET_TO_YOUR_PAGE' => 'Añade este gadget a tu perfil',
        'GADGETS_BETA' => 'Gadgets (Beta)',
        'TRY_OUT_OPENSOCIAL_GADGETS_WARNING_EXPERIMENTAL' => 'Prueba OpenSocial gadgets. Advertencia: esta función es experimental.',
        'ADD_TO_MY_PAGE' => 'Añadir a mi página',
        'GADGETS' => 'Gadgets',
        'GADGETS_TAB_TEXT' => 'Gadgets',
        'GADGET' => 'Gadget',
        'GADGETS_IS_IN_BETA' => 'Gadgets están en beta.',
        'SORRY_GADGET_UNAVAILABLE' => 'Lo sentimos, pero este gadget no está disponible. Por favor comprueba que tienes el URL correcto. Si aún tienes problemas, <a %s>dínoslo</a>.',
        'ALREADY_MEMBER_OF_GROUP' => '(Ya es miembro de este grupo)',
        'INVITE_YOUR_FRIENDS_TO_GROUPNAME' => 'Invita a tus amigos a \'%s\'',
        'COME_JOIN_ME_ON_X_ON_Y' => 'Ven y únete a %1$s en %2$s.',
        'COME_JOIN_ME_ON_X_ON_Y_ELLIPSIS' => '¡Ven y únete a %1$s en %2$s…!',
        'INVITE_TO_GROUP' => 'Invita a \'%s\'',
        'EACH_VIDEO_MAY_BE_100MB' => 'Los vídeos sólo pueden tener un tamaño de 100MB. Admitimos vídeos en formato .mov, .mp4, .mpg, .avi, .wmv y 3gp. ',
        'I_HAVE_RIGHT_TO_UPLOAD_VIDEO' => 'Tengo derecho a cargar este vídeo según los <a %s>Términos de servicio</a>. ',
        'VIDEO_UPLOADER_REQUIRES_JAVA' => 'El nuevo programa para cargar vídeos necesita una versión más reciente de Java. <strong><a %s>Haz clic aquí para instalar Java</a></strong>, o <strong><a %s>volver al cargador sencillo</a></strong>. ',
        'UPLOAD_A_VIDEO_FROM_YOUR_COMPUTER' => 'Cargar un vídeo desde tu ordenador ',
        'HAVE_LOT_OF_VIDEOS' => '¿Tienes muchos vídeos que compartir? ',
        'TRY_BULK_VIDEO_UPLOADER' => 'Prueba el nuevo cargador de vídeos ',
        'VIDEOS_SUCCESSFULLY_UPLOADED' => 'Tus vídeos se han cargado con éxito. ',
        'VIDEOS_UPLOADED_AWAITING' => 'Tus vídeos se han cargado con éxito, ahora el creador de %s\ tiene que aprobarlos. ',
        'ADD_VIDEOS_OR_PHOTOS_TO_APPNAME' => 'Añade vídeos o fotos directamente a % desde tu teléfono mandándolos a una dirección de correo electrónico única. ',
        'GRAB_HTML_EMBED' => 'Copia el código HTML \'embed\' de cualquier sitio de vídeos y añade ese vídeo a tu red social. ',
        'GOOGLE' => 'Google ',
        'YOUTUBE' => 'YouTube ',
        'HAVING_PROBLEMS_WITH_VIDEO_UPLOADER' => '¿Tienes problemas con el nuevo cargador de vídeos?  <strong><a %s>Vuelve al cargador de vídeos sencillo.</a></strong>. ',
        'ADD_VIDEOS_FROM_YOUTUBE' => 'Añade vídeos de YouTube o Google ',
        'TAGS_NO_COLON' => 'Etiquetas ',
        'NO_VIDEOS_TAGGED_X_CHECK' => 'No hay vídeos con etiqueta "%1$s". Puedes ver <a %2$s>discusiones con etiqueta "%1$s"</a>, <a %4$s>post de blog con etiqueta "%1$s"</a> o<a %3$s>fotos con etiqueta "%1$s"</a>. También puedes añadir y etiquetar tus propios vídeos. ',
        'UPLOAD_VIDEOS_FROM' => 'Carga vídeos desde tu ordenador ',
        'ADD_VIDEOS_BY_PHONE_OR' => 'Añade vídeos por teléfono o e-mail. ',
        //music player
        'FEATURING_ELLIPSIS' => 'Destacando...',
        'OPEN_POPUP_WINDOW' => 'Abre ventana emergente',
        'NOW_FEATURED_ON_MAIN' => 'Ahora está en el menú principal ',
        'DONT_FEATURE' => 'No ponerlo ',
        'UNFEATURING_ELLIPSIS' => 'Quitarlo del menú principal... ',
        'REMOVED_FROM_MAIN' => 'Quitado del menú principal ',
        'ADDED_EXCLAMATION' => '¡Añadido! ',
        'ERROR' => 'Error ',
        'ADDING_ELLIPSIS' => 'Añadiendo... ',
        'TRACK_COULD_NOT_BE_LOADED' => 'No se ha podido cargar la canción ',
        'INVALID_URL' => 'URL inválida ',
        'NORMAL_PLAYBACK_ON' => 'Play-back normal: encendido ',
        'REPEAT_PLAYBACK_ON' => 'Repetir play-back: encendido ',
        'SHUFFLE_PLAYBACK_ON' => 'Mezclar play-back: encendido ',
        'LOADING_PLAYLIST_ELLIPSIS' => 'Cargar lista de canciones... ',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Se han exportado tus datos de los miembros. Haz clic <a %s>en este enlace</a> para guardarlos en tu escritorio. ',
        'SET_NEW_PASSWORD' => 'Configura una contraseña nueva para tu cuenta. ',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Haz clic en \'Editar\' para añadir texto, HTML, vídeos, fotos o  <a %1$s>Widgets externos</a> a esta caja ',
        'EACH_PHOTO_MAY_BE_UP_TO_10MB' => 'Las fotos no deben tener un tamaño superior a 100MB. Admitimos fotos en formato .jpg, .gif y .png. ',
        'I_HAVE_RIGHT_TO_UPLOAD_PHOTOS' => 'Tengo derecho a cargar estas fotos según los <a %s>Términos de servicio</a>. ',
        'PHOTO_UPLOADER_REQUIRES_JAVA' => 'El nuevo cargador de fotos necesita una versión más reciente de Java. <strong><a %s>Haz clic aquí para instalar Java</a></strong> o <strong><a %s>volver al cargador sencillo</a></strong>. ',
        'TRY_BULK_PHOTO_UPLOADER' => 'Prueba el nuevo cargador de fotos ',
        'HAVE_LOT_OF_PHOTOS' => '¿Tienes muchas fotos que compartir? ',
        'PHOTOS_SUCCESSFULLY_UPLOADED' => 'Tus fotos se han cargado con éxito. ',
        'PHOTOS_UPLOADED_AWAITING' => 'Tus fotos se han cargado con éxito, ahora el creador de %s tiene que aprobarlas. ',
        'FLICKR' => 'Flickr ',
        'ADD_PHOTOS_FROM_FLICKR' => 'Añade fotos de Flickr ',
        'ADD_PHOTOS_OR_VIDEOS_TO_APPNAME' => 'Añade fotos o vídeos a %s directamente desde tu teléfono mandándolas a través de una dirección de correo electrónico única. ',
        'HAVING_PROBLEMS_WITH_PHOTO_UPLOADER' => '¿Tienes problemas con el nuevo cargador de fotos?  <strong><a %s>Vuelve al cargador sencillo </a></strong>. ',
        'VIEW_SLIDESHOW' => 'Ver exposición de fotos ',
        'NO_PHOTOS_TAGGED_X_CHECK' => 'No hay ninguna foto con etiqueta "%1$s". Puedes ver <a %2$s>discusiones con etiqueta "%1$s"</a>, <a %4$s>noticias de blog con etiqueta "%1$s"</a> o <a %3$s>vídeos con etiqueta "%1$s"</a>. También puedes añadir y etiquetar tus propias fotos. ',
        'PHOTO_MAY_BE_10MB' => 'Las fotos pueden tener 10MB como máximo, pero las fotos más pequeñas se cargarán más rápido. Admitimos fotos en formato .jpg, .gif, .png. ',
        'UPLOAD_PHOTOS_FROM_YOUR_COMPUTER' => 'Cargar fotos desde tu ordenador ',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Haz clic en \'Editar\' para añadir texto, HTML, vídeos, fotos o  <a %1$s>Widgets externos</a> a esta caja ',
        'PLEASE_SELECT_A_MEMBER' => 'Por favor elige uno o más miembros ',
        'RESEND_INVITATION' => 'Reenviar invitación ',
        'CHOOSE_FRIENDS' => 'Elige amigos... ',
        'SORRY_WE_DO_NOT_SUPPORT' => 'Lo sentimos, no admitimos la libreta de dirección de esta Web. Intenta hacer clic en  \'aplicación de email\' que está abajo para usar las direcciones de tu ordenador. ',
        'WANT_TO_INVITE_MORE_FRIENDS' => '¿Quieres invitar a más amigos? Invita a más amigos importando contactos de la libreta de direcciones de tu Web o tu aplicación de email. ',
        'MICROSOFT_OUTLOOK_APPLE_ADDRESS_BOOK' => 'Microsoft Outlook, Apple Mail, .CSV, etc. ',
        'SET_NEW_PASSWORD' => 'Configura una contraseña nueva para tu cuenta. ',
        'APPLY_FOR_MEMBERSHIP_SIGN_IN' => ' Pide la membresía ahora. ¿Ya eres miembro? <a %s>Haz clic aquí para iniciar la sesión</a>. ',
        'FEATURED_MEMBERS' => 'Miembros que se muestran ',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Se han exportado tus datos de los miembros. Haz clic <a %s>en este enlace</a> para guardarlos en tu escritorio. ',
        'SORRY_NO_MEMBERS_MATCHING_X_WERE_FOUND' => 'Lo sentimos, no se han encontrado miembros  que coincidan con "%s". ',
        'WHO_CAN_COMMENT_ON_POST' => '¿Quién puede comentar en este post? ',
        'PREVIOUS_POST' => ' ← Post anterior ',
        'NEXT_POST' => 'Siguiente post  → ',
        'PREVIOUS_POSTS' => ' ← Posts anteriores ',
        'NEXT_POSTS' => 'Siguientes posts  → ',
        'NO_BLOG_POSTS_TAGGED_X_CHECK' => 'No hay post con etiqueta "%1$s". Puedes ver <a %2$s>discusiones con etiqueta "%1$s"</a>, <a %4$s>fotos con etiqueta "%1$s"</a> or <a %3$s>vídeos con etiqueta "%1$s"</a>. También puedes añadir y etiquetar tus propios posts. ',
        'ALL_POSTS_TAGGED_X_FOR_M_Y' => 'Todos los posts están etiquetados <em>\'%s\'</em> para %s %s ',
        'ALL_POSTS_TAGGED_X' => 'Todos los posts están etiquetados <em>\'%s\'</em> ',
        'MY_BLOG_POSTS_FOR_M_Y' => 'Mis post de blog para %s %s ',
        'MY_BLOG_POSTS' => 'Mis posts de blog ',
        'PRIVACY_CONTENT_CONTROL' => 'Privacidad y control de contenidos ',
        'MODERATION' => 'Control de contenidos ',
        'ENABLE_MUSIC_DOWNLOAD_LINKS' => 'Enlaces de descarga para habilitar el reproductor de música ',
        'NOTIFY_BLOG_PING_SERVICES' => '¿Quieres activar los servicios de rastreo de otros amigos cuando añadas un post nuevo? ',
        'YES_NOTIFY_BLOG_SERVICES' => 'Sí– notificar <a %s>servicios de actualización del sitio</a> cuando añado un post nuevo ',
        'THERE_ARE_NO_FEATURED_MEMBERS' => 'No hay miembros publicados en tu red social. ',
        'START_FEATURING_MEMBERS_CLICK_Y' => 'Comienza a promocionar miembros cuando veas la opción de Promocionar. Para saber más sobre Promocionar, <a %s>Haz clic aquí</a>. ',
        'SHOW_ALL' => 'Mostrar todos ',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_ADD' => 'No hay discusiones etiquetadas "%1$s". Puedes ver <a %2$s>fotos etiquetadas "%1$s"</a>, <a %4$s>post de blog etiquetados "%1$s"</a> o <a %3$s>vídeos etiquetados"%1$s"</a>. También puedes añadir y etiquetar tus propias discusiones. ',
        'NO_DISCUSSIONS_TAGGED_X_CHECK' => 'No hay discusiones con etiqueta "%1$s". Puedes ver <a %2$s>fotos con etiqueta "%1$s"</a>, <a %4$s>post de blog con etiqueta "%1$s"</a> o <a %3$s>vídeos con etiqueta "%1$s"</a>. ',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => 'Has creado el grupo %1$s. Puedes iniciar una discusión en el foro %1$s o invitar a más gente para que se una. ',
        'YOU_CAN_ADD_100_SONGS' => 'Puedes añadir un total de 100 canciones, ninguna de más de 20MB de tamaño. Admitimos canciones con formato .mp3. ',
        'I_HAVE_RIGHT_TO_UPLOAD_SONGS' => 'Tengo derecho a cargar canciones según los <a %s">Términos de servicio</a>. ',
        'MUSIC_UPLOADER_REQUIRES_JAVA' => 'El nuevo cargador de canciones requiere una versión más reciente de Java. <strong><a %s>Haz clic aquí para instalar Java</a></strong>, o <strong><a %s>volver al cargador sencillo</a></strong>. ',
        'HAVE_LOT_OF_MUSIC' => '¿Tienes mucha música que compartir? ',
        'TRY_BULK_MUSIC_UPLOADER' => 'Prueba el nuevo cargador de música ',
        'SONGS_SUCCESSFULLY_UPLOADED' => 'Tus canciones se han cargado con éxito. ',
        'SORRY_YOU_CAN_ONLY_HAVE_N_TRACKS' => 'Lo sentimos, sólo puedes añadir %s canciones más en tu lista de canciones. Por favor borra canciones antes de añadir más. ',
        'ADD_MUSIC_FROM_WEBSITE' => 'Añadir música desde otro sitio Web ',
        'HAVING_PROBLEMS_WITH_MUSIC_UPLOADER' => '¿Tienes problemas con este cargador de música?  <strong><a %s>Vuelve al cargador sencillo</a></strong>. ',
        'UPLOAD_MUSIC_FROM_YOUR_COMPUTER' => 'Carga música desde tu ordenador ',
        'ADD_MUSIC' => 'Añadir música ',
        'FACEBOOK_INSTR_SETUP_APP_PERMISSION' => 'Elige <strong>usuarios</strong> y<strong>todas las páginas</strong>. ',


    );

    /**
     * If the given widget title is the default English title for the widget,
     * translate it into the current language.
     *
     * @param $widgetTitle string  The title of the widget
     * @return string  A translated title if the title is the English default; otherwise, the title unchanged
     */
    public static function translateDefaultWidgetTitle($widgetTitle) {

        return $widgetTitle;
    }

}