<?php

XG_App::includeFileOnce('/lib/XG_AbstractMessageCatalog.php');

/**
 * Texts for the es_AR locale.
 */
class XG_MessageCatalog_es_AR extends XG_AbstractMessageCatalog {

    /**
     * Returns a localized version of a string. The first argument is the message name, e.g., 'ADD_A_PHOTO'.
     * Subsequent arguments are substitution values (if the message contains sprintf format elements).
     *
     * @param $args array the message name, plus optional substitution values
     * @return string the localized string
     * @see xg_html()
     */
    public static function text($args) {
        $s = $args[0];
        static $a = array();
        if (! $a) {
            $a['N_SECONDS_AGO']['1'] = 'Hace 1 segundo ';
            $a['N_SECONDS_AGO']['n'] = 'Hace %s segundos ';
            $a['N_MINUTES_AGO']['1'] = 'Hace 1 minuto ';
            $a['N_MINUTES_AGO']['n'] = 'Hace %s minutos ';
            $a['N_HOURS_AGO']['1'] = 'Hace 1 hora ';
            $a['N_HOURS_AGO']['n'] = 'Hace %s horas ';
            $a['N_VIDEOS']['1'] = '<strong>1</strong> video ';
            $a['N_VIDEOS']['n'] = '<strong>%s</strong> videos ';
            $a['N_VIEWS']['1'] = '1 vista ';
            $a['N_VIEWS']['n'] = '%s vistas ';
            $a['N_COMMENTS']['1'] = '<span class="comment-count">1</span> comentario ';
            $a['N_COMMENTS']['n'] = '<span class="comment-count">%s</span> comentarios ';
            $a['VIDEO_IS_FAVORITE_OF']['1'] = 'Este video está entre los <strong>favoritos</strong> de <strong>1 persona</strong>. ';
            $a['VIDEO_IS_FAVORITE_OF']['n'] = 'Este video está entre los <strong>favoritos</strong> de <strong>%s personas</strong>. ';
            $a['Y_ADDED_X_VIDEOS']['1'] = '%2$s agregaron un video: ';
            $a['Y_ADDED_X_VIDEOS']['n'] = '%2$s agregaron %s videos. ';
            $a['YOU_ADDED_X_VIDEOS']['1'] = 'Agregaste un video: ';
            $a['YOU_ADDED_X_VIDEOS']['n'] = 'Agregaste %s videos. ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['1'] = 'Hay 1 video en %2$s ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['n'] = 'Hay %1$s videos en %2$s ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['1'] = 'Hay 1 <a href="%3$s">video</a> en %2$s ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['n'] = 'Hay %1$s <a href="%3$s">videos</a> en %2$s ';
            $a['N_PHOTOS_FROM_ALBUM']['1'] = '1 foto de este álbum ha sido eliminada o ha pasado a ser privada, por lo que no se puede mostrar. ';
            $a['N_PHOTOS_FROM_ALBUM']['n'] = '%s fotos de este álbum han sido eliminadas o han pasado a ser privadas, por lo que no se pueden mostrar. ';
            $a['N_PHOTOS']['1'] = '<strong>1</strong> Foto ';
            $a['N_PHOTOS']['n'] = '<strong>%s</strong> Fotos ';
            $a['N_PHOTOS_2']['1'] = '1 foto ';
            $a['N_PHOTOS_2']['n'] = '%s fotos ';
            $a['AND_X_OTHER_PEOPLE']['1'] = 'y 1 persona más ';
            $a['AND_X_OTHER_PEOPLE']['n'] = 'y %s personas más ';
            $a['PROBLEM_UPLOADING_FILES']['1'] = 'Hubo un problema al subir el siguiente archivo: ';
            $a['PROBLEM_UPLOADING_FILES']['n'] = 'Hubo un problema al subir los siguientes archivos: ';
            $a['PHOTO_IS_FAVORITE_OF']['1'] = 'Esta foto está entre las <strong>favoritas</strong> de <strong>1 persona</strong>. ';
            $a['PHOTO_IS_FAVORITE_OF']['n'] = 'Esta foto está entre las <strong>favoritas</strong> de <strong>%s personas</strong>. ';
            $a['RATING_Y_AFTER_X_VOTES']['1'] = '<strong>Calificación:</strong> %2$s después de 1 voto ';
            $a['RATING_Y_AFTER_X_VOTES']['n'] = '<strong>Calificación:</strong> %2$s después de %s votos ';
            $a['Y_AFTER_X_VOTES']['1'] = '%2$s después de 1 voto ';
            $a['Y_AFTER_X_VOTES']['n'] = '%2$s después de %s votos ';
            $a['N_PEOPLE']['1'] = '1 persona ';
            $a['N_PEOPLE']['n'] = '%s personas ';
            $a['N_OF_5_STARS']['1'] = '1/5 estrella ';
            $a['N_OF_5_STARS']['n'] = '%s/5 estrellas ';
            $a['YOUR_RATING_X_STARS']['1'] = 'Tu calificación: 1 estrella ';
            $a['YOUR_RATING_X_STARS']['n'] = 'Tu calificación: %s estrellas ';
            $a['Y_ADDED_X_PHOTOS']['1'] = '%2$s agregaron una foto: ';
            $a['Y_ADDED_X_PHOTOS']['n'] = '%2$s agregaron %s fotos. ';
            $a['YOU_ADDED_X_PHOTOS']['1'] = 'Agregaste una foto: ';
            $a['YOU_ADDED_X_PHOTOS']['n'] = 'Agregaste %s fotos. ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['1'] = 'Hay 1 foto en %2$s ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['n'] = 'Hay %1$s fotos en %2$s ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['1'] = 'Hay %1$s <a href="%3$s">fotos</a> en %2$s ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['n'] = 'Hay %1$s <a href="%3$s">fotos</a> en %2$s ';
            $a['N_COMMENTS_ON_PAGE']['1'] = '<strong>1</strong> comentario en tu página ';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s</strong> Comments on your page';;
            $a['N_BLOG_COMMENTS']['1'] = '<strong>1</strong> comentario de blog ';
            $a['N_BLOG_COMMENTS']['n'] = '<strong>%s</strong> comentarios de blog ';
            $a['N_YEARS_OLD']['1'] = '1 año de antigüedad ';
            $a['N_YEARS_OLD']['n'] = '%s años de antigüedad ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['1'] = 'Tenés 1 pedido de un amigo ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['n'] = 'Tenés %s pedidos de amigos ';
            $a['COMMENT_WALL_N_COMMENTS']['1'] = 'Comentarios (1 comentario) ';
            $a['COMMENT_WALL_N_COMMENTS']['n'] = 'Comentarios (%s comentarios) ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['1'] = 'Durante la última semana, se unió 1 miembro nuevo ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['n'] = 'Durante la última semana, se unieron %s miembros nuevos ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['1'] = 'Durante la última semana, se unió 1 <a href="%2$s">miembro nuevo</a> ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['n'] = 'Durante la última semana, se unieron%1$s <a href="%2$s">miembros nuevos</a> ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['1'] = 'Hay 1 miembro en %2$s ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['n'] = 'Hay %1$s miembros en %2$s ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['1'] = 'Hay 1 <a href="%3$s">miembro</a> en %2$s ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['n'] = 'Hay %1$s <a href="%3$s">miembros</a> en %2$s ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['1'] = 'Hay 1 publicación de blog en %2$s ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['n'] = 'Hay %1$s publicaciones de blog en %2$s ';
            $a['N_NEW_MEMBERS']['1'] = '<strong>1</strong> miembro nuevo ';
            $a['N_NEW_MEMBERS']['n'] = '<strong>%s</strong> miembros nuevos ';
            $a['N_REPLIES']['1'] = '1 respuesta ';
            $a['N_REPLIES']['n'] = '%s respuestas ';
            $a['N_MINUTES']['1'] = 'Queda 1 minuto para editar tu comentario. ';
            $a['N_MINUTES']['n'] = 'Quedan %s para editar tu comentario. ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['1'] = 'Hay un tema de discusión en foro en %2$s ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['n'] = 'Hay %1$s temas de discusión en foro en %2$s ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['1'] = 'Hay 1 <a href="%3$s">tema de discusión en foro</a> en %2$s ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['n'] = 'Hay %1$s <a href="%3$s">temas de discusión en foro</a> en %2$s ';
            $a['N_INVITES']['1'] = '%s invitación ';
            $a['N_INVITES']['n'] = '%s invitaciones ';
            $a['N_MEMBERS']['1'] = '1 miembro ';
            $a['N_MEMBERS']['n'] = '%s miembros ';
            $a['N_MEMBERS_PARENTHESIZED']['1'] = '(1 miembro) ';
            $a['N_MEMBERS_PARENTHESIZED']['n'] = '(%s miembros) ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['1'] = 'Hay 1 grupo en %2$s ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['n'] = 'Hay %1$s grupos en %2$s ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['1'] = 'Hay %1$s <a href="%3$s">grupo</a> en %2$s ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['n'] = 'Hay %1$s <a href="%3$s">grupos</a> en %2$s ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['1'] = '1 canción de esta lista de reproducción no se puede mostrar porque ha sido eliminada o ya no figura como compartida. ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['n'] = '%s canciones de esta lista de reproducción no se pueden mostrar porque se eliminaron o ya no figuran como compartidas. ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['1'] = 'Se ha agregado una nueva canción a %2$s ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['n'] = 'Se han agregado %1$s nuevas canciones a %2$s ';
            $a['Y_ADDED_X_SONGS']['1'] = '%2$s agregó una canción: ';
            $a['Y_ADDED_X_SONGS']['n'] = '%2$s agregaron %s canciones. ';
            $a['YOU_ADDED_X_SONGS']['1'] = 'Agregaste una canción: ';
            $a['YOU_ADDED_X_SONGS']['n'] = 'Agregaste %s canciones. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['1'] = 'Se ha agregado 1 canción a esta lista de reproducción. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['n'] = 'Se han agregado %s canciones a esta lista de reproducción. ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['1'] = 'Hay 1 canción en %2$s ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['n'] = 'Hay %1$s canciones en %2$s ';
            $a['N_INVITATIONS_RESENT']['1'] = 'Se ha reenviado 1 invitación. ';
            $a['N_INVITATIONS_RESENT']['n'] = 'Se han reenviado %s invitaciones. ';
            $a['N_COMMENTS_ON_PAGE']['1'] = '<strong>1</strong> comentario en el perfil ';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s</strong> comentarios en el perfil ';
            }
        if ($a[$args[0]]) {
            $args[0] = $a[$args[0]][$args[1]] ? $a[$args[0]][$args[1]] : $a[$args[0]]['n'];
            return @call_user_func_array('sprintf', $args);
        }
        $text = self::$messages[$s];
        if ($text) { $args[0] = $text; }
        return @call_user_func_array('sprintf', $args);
    }

    /**
     * Message names and texts. Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;
     */
    private static $messages = array(
        'BROWSING' => 'Examinar',
        'MORE_VIDEOS' => 'Más videos',
        'NETWORK_DOES_NOT_HAVE_VIDEOS' => 'Esta red todavía no tiene nigún video.',
        'NETWORK_DOES_NOT_HAVE_FEATURED_VIDEOS' => 'Esta red todavía no tiene videos destacados.',
        'PERSON_DOES_NOT_HAVE_VIDEOS' => 'Esta persona todavía no tiene ningún video.',
        'COPY_TO_CLIPBOARD' => 'Copiar al portapapeles',
        'COPIED_TO_CLIPBOARD' => '¡Copiado al portapapeles!',
        'NO_VIDEOS_TO_DISPLAY' => 'No estás mostrando videos en este momento.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_VIDEO' => 'Este recuadro no aparecerá para otras personas hasta que elijas por lo menos un video.',
        'WATERMARK_LOGO' => 'Logotipo de marca de agua',
        'CHOOSE_HEADER_OR_WATERMARK' => 'Podés elegir un título o un logotipo de marca de agua para tu reproductor de videos.',
        'CUSTOMIZE_EMBED_INSTRUCTIONS' => 'El logotipo aparece en la parte superior de tu %s. Si no agregás un logotipo, en su lugar se verá el nombre de la red. Tu logotipo debe estar en formato .jpg, .gif o .png. Los logotipos de más de 20 píxeles de altura se modificarán para que entren.',
        'CUSTOMIZE_WATERMARK_INSTRUCTIONS' => 'El logotipo de marca de agua aparece en la esquina  inferior derecha del video clip.',
        'HEADER_LOGO' => 'Logotipo del encabezado',
        'WATERMARK' => 'Marca de agua',
        'CUSTOMIZE_YOUR_VIDEO_PLAYER' => '¡Personalizá tu reproductor de video!',
        'VIDEO_PLAYER' => 'Reproductor de video',
        'HEADER' => 'Encabezado',
        'SAVE_CHANGES' => 'Guardar cambios',
        'THUMBNAIL' => 'Miniatura',
        'CONVERSION_FAILED' => 'La conversión ha fallado',
        'CONVERSION_IN_PROGRESS' => 'Conversión en progreso',
        'MAP' => 'Mapa',
        'WHAT_IS_THIS' => '¿Qué es esto?',
        'EDIT_VIDEO_INFORMATION' => 'Editar la información del video',
        'ALL_VIDEOS' => 'Todos los videos',
        'VIDEOS_HOME' => 'Página principal de videos',
        'MY_VIDEOS' => 'Mis videos',
        'MY_FRIENDS_VIDEOS' => 'Videos de mis amigos',
        'MY_FAVORITES' => 'Mis favoritos',
        'XS_FAVORITES' => 'Los favoritos de %s',
        'ADD_A_VIDEO' => 'Agregar un video',
        'JUST_NOW' => 'ahora',
        '1_DAY_AGO' => 'Hace 1 día',
        'M_J' => 'j M',
        'ME' => 'mí',
        'X_SAID' => '%s dijo',
        'DELETE_COMMENT' => 'Eliminar comentario',
        'YOU_HAVE_NOT_ADDED_VIDEOS' => '¡Todavía no agregaste ningún video!',
        'ADD_VIDEOS_AND_SHARE' => '¡Agregá videos o compartilos con tus amigos, con tu familia o con el resto del mundo!',
        'THERE_ARE_NO_VIDEOS' => 'En este momento no hay videos en tu red social.',
        'THIS_BOX_WILL_NOT_SHOW' => 'Este recuadro no se mostrará al resto de las personas hasta que haya algún video para mostrar. ¿Por qué no agregás uno?',
        'ADD_VIDEOS' => 'Agregar videos',
        'VIEW_VIDEOS' => 'Ver videos',
        'YIKES' => 'Yikes!',
        'A_PROBLEM_SEEMS' => 'Aparentemente hubo un problema.',
        'FOR_FURTHER_ASSISTANCE' => 'Para obtener más información, por favor <a %s>contactanos</a>.',
        'OR_YOU_CAN_GO' => 'O podés volver a la <a %s>%s página principal</a> o navegar <a %s>otras redes sociales de Ning</a>',
        'TAGS' => 'Etiquetas:',
        'POPULAR_TAGS' => 'Etiquetas populares',
        'MY_FRIENDS' => 'Mis amigos',
        'VIEW_ALL_MY_FRIENDS' => 'Ver todos mis amigos',
        'VIEW_ALL_XS_FRIENDS' => 'Ver todos los amigos de %s',
        'WE_COULD_NOT_FIND_ANYONE_MATCHING' => 'Disculpá - no pudimos encontrar ninguna persona que concuerde con tu búsqueda.',
        'VIEW_POPULAR_CONTRIBUTORS' => 'Ver contribuyentes populares',
        'POPULAR_CONTRIBUTORS' => 'Contribuyentes populares',
        'VIEW_MORE_CONTRIBUTORS' => 'Ver más contribuyentes populares',
        'ADD_AS_FRIEND' => 'Agregar como amigo',
        'SEND_A_MESSAGE' => 'Enviar un mensaje',
        'IS_YOUR_FRIEND' => 'Es tu amigo',
        'IS_BLOCKED' => 'Está bloqueado',
        'SORT_BY' => 'Ordenar según:',
        'CLOSE' => 'Cerrar',
        'USER_COUNT' => '(%d)',
        'NOBODY_HAS_ADDED_VIDEOS' => '¡Nadie agregó videos todavía! Agregá algunos para empezar.',
        'SEARCH_PEOPLE' => 'Buscá gente:',
        'INVITE_YOUR_FRIENDS_TO' => 'Invita a tus amigos a la %s.',
        'INVITE' => 'Invitá',
        'INVITE_TAB_TEXT' => 'Invitá',
        'YOU_HAVE_NOT_ADDED_FRIENDS' => 'No agregaste ningún amigo a %s todavía.',
        'SEARCH_FRIENDS' => 'Buscar amigos:',
        'ADD_YOUR_FIRST_VIDEO' => 'Agregá tu primer video',
        'USE_HTML_EMBED_CODE' => 'Usá el código HTML incrustado',
        'UPLOAD_A_VIDEO_FROM' => 'Subí un video desde tu PC:',
        'WE_SUPPORT_MOV' => 'Admitimos los formatos .mov, .mpg, .mp4, .avi, .3gp y .wmv. Los archivos deben ser de 100Mb o menos.',
        'NEED_HELP_HERE_ARE' => '¿Necesitás ayuda? Acá tenés algunas instrucciones para <a %s>YouTube</a> y <a %s>Google Video</a>.',
        'ADD_TITLE_AND_DESCRIPTION' => 'Agregá un título y una descripción',
        'DESCRIPTION_COLON' => 'Descripción:',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_1' => 'Agregále un título, una descripción y otra información al video que acabás de subir.',
        'EVERYTHING_IS_OPTIONAL' => 'Todo es opcional; si no querés agregar nada sólo hacé clic en "Saltear este paso" a la derecha.',
        'SKIP_THIS_STEP' => 'Saltear este paso',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_2' => 'Agregarle un título, una descripción u otra información a este video.',
        'CANCEL_AND_RETURN_TO_VIDEO' => 'Cancelar y volver al video',
        'TITLE' => 'Título:',
        'TAGS_ARE_SHORT_DESCRIPTIONS' => 'Las etiquetas son descripciones que ayudan a encontrar tus videos. Separá las etiquetas con comas o si tienen varias palabras ponélas entre comillas como por ejemplo, "Buenos Aires”.',
        'WHO_CAN_VIEW_VIDEO' => '¿Quién puede ver este video?',
        'MOST_POPULAR' => 'Los más populares',
        'HIGHEST_RATED' => 'Los que tienen la calificación más alta',
        'MOST_RECENT' => 'Los más recientes',
        'MOST_FAVORITED' => 'Los favoritos',
        'MOST_POPULAR_VIDEOS' => 'Los videos más populares',
        'HIGHEST_RATED_VIDEOS' => 'Los videos con votación más alta',
        'MOST_RECENT_VIDEOS' => 'Los videos más recientes',
        'MOST_FAVORITED_VIDEOS' => 'Los videos más elegidos como favoritos',
        'ANYONE' => 'Cualquiera',
        'JUST_MY_FRIENDS' => 'Sólo mis amigos',
        'JUST_ME' => 'Sólo yo',
        'VIEWABLE_BY_FRIENDS' => 'Sólo lo pueden ver <strong>mis amigos</strong>',
        'PRIVATE_VIDEO' => 'Video <strong>privado</strong>',
        'VIEWABLE_BY_EVERYONE' => 'Lo puede ver <strong>todo el mundo</strong>',
        'LOCATION' => 'Ubicación:',
        'NO_LOCATION' => 'Sin ubicación',
        'CLICK_ON_LOCATION' => 'Hacé clic sobre una ubicación en el mapa:',
        'FIND_AN_ADDRESS' => 'Encontrá una dirección',
        'LOCATE' => 'Ubicar',
        'YOU_CAN_ADD_YOUR_OWN_VIDEO' => '¡Podés <a %s>agregar tu propio video </a> a %s!',
        'ADD_PLAYER_LOGO_OR_WATERMARK' => 'Agregá un logotipo o una marca de agua al reproductor de video de tu red. <a %s>¡Configuralo ya!</a>',
        'APPROVE' => 'Aprobar',
        'DELETE' => 'Eliminar',
        'APPLY_TO_VIDEOS_ADDED_BY' => 'Aplicar a todos los videos agregados por %s',
        'NO_TITLE' => 'Sin título',
        'ADDED_BY_STRONG_X' => 'Agregado por <strong>%s</strong>',
        'NO_DESCRIPTION' => 'Sin descripción',
        'BY_X' => 'por %s',
        'YOU_HAVE_FINISHED_MODERATING' => 'Terminaste de moderar',
        'NO_VIDEOS_AWAITING_APPROVAL' => 'En este momento no hay videos esperando aprobación. Si estás buscando algo para hacer, ¿por qué no mirás los <a %s>últimos videos </a>?',
        'NO_ONE_HAS_ADDED_ANY_VIDEOS' => 'Nadie agregó videos a tu red social. ¡Sé el primero en agregar un video!',
        'ADDED_ON_DATE_BY_X' => 'Agregado %s por %s.',
        'REMOVE_FROM_FAVORITES' => 'Quitar de favoritos',
        'REMOVE_VIDEO_FROM_FAVORITES' => '¿Sacar este video de tus favoritos?',
        'COLLECTED_BY_X' => 'Compilado por %s',
        'ADD_FAVORITES' => 'Agregar Favoritos',
        'YOU_CAN_MARK_VIDEO' => 'Podés marcar cualquier video como favorito. Sólo hacé clic en el icono "Agregar a favoritos" cuando lo veas en un video.',
        'VIEW_RECENT_VIDEOS' => 'Ver videos recientes',
        'X_HAS_NOT_ADDED_FAVORITES' => '%s no agregó nada a sus favoritos todavía.',
        'APPROVE_VIDEOS' => 'Aprobar videos',
        'YOUR_SITE_REQUIRES_YOU' => 'Pediste moderar las fotos y los videos en tu red social antes que sean publicados. Para cambiar esta opción, andá a la sección <a %s>Privacidad </a> y desmarcá \'Aprobar nuevas fotos y videos\'.',
        'YOUR_SITE_ALLOWS_USERS' => 'Pediste no moderar las fotos y los videos en tu red social antes que sean publicados. Para cambiar esta opción, andá a la sección <a %s>Privacidad </a> y marcá \'Aprobar nuevas fotos y videos\'.',
        'APPROVE_ALL_VIDEOS' => '¿Aprobar todos los videos?',
        'ARE_YOU_SURE_APPROVE_ALL_VIDEOS' => '¿Estás seguro de que querés aprobar todos los videos? Esto podría tardar unos minutos.',
        'APPROVING' => 'Aprobando...',
        'APPROVE_ALL' => 'Aprobar todo',
        'DELETE_ALL_VIDEOS' => '¿Eliminar todos los videos?',
        'ARE_YOU_SURE_DELETE_ALL_VIDEOS' => '¿Estás seguro de que querés eliminar todos los videos que no estén aprobados? Esto podría tardar unos minutos.',
        'DELETING' => 'Eliminando...',
        'DELETE_ALL' => 'Eliminar todo',
        'XS_VIDEOS' => '%s Videos',
        'DELETE_ALL_XS_VIDEOS_Q' => '¿Eliminar todos los videos de %s?',
        'DELETE_ALL_XS_VIDEOS' => 'Eliminar todos los videos de %s',
        'ARE_YOU_SURE_DELETE_ALL_XS_VIDEOS' => '¿Estás seguro de que querés eliminar todos los videos de %s? Esto podría tardar unos minutos.',
        'DELETE_THIS_VIDEO_Q' => '¿Eliminar este video?',
        'ARE_YOU_SURE_DELETE_THIS_VIDEO' => '¿Estás seguro de que querés eliminar  este video? Esto podría tardar unos minutos.',
        'YOU_HAVE_NOT_ADDED_VIDEOS_2' => 'Todavía no agregaste ningún video. ¡Agregá algún video para comenzar!',
        'X_HAS_NOT_ADDED_VIDEOS' => '%s todavía no agregó ningún video.',
        'YOUR_FRIENDS_DO_NOT_HAVE_VIDEOS' => 'Tus amigos todavía no agregaron videos.',
        'ALL_VIDEOS_TAGGED_X' => 'Todos los videos con etiqueta \'%s\'',
        'ALL_VIDEOS_TAGGED_X_2' => 'Todos los videos con etiqueta <em>\'%s\'</em>',
        'NO_VIDEOS_TAGGED_X_CHECK_OUT' => 'No hay videos con etiqueta "%1$s". Mirá las <a %2$s>discusiones con etiqueta "%1$s"</a> o las <a %2$s>fotos con etiqueta "%1$s"</a>. ¡O agregá y etiquetá tus propios videos!',
        'FILES_MUST_BE_100MB' => 'Los archivos deben ser de 100Mb o menos. Admitimos los formatos .mov, .mpg, .mp4, .avi, .3gp y .wmv.',
        'NEED_HELP' => '¿Necesitás ayuda?',
        'HERE_ARE_INSTRUCTIONS' => 'Acá están las instrucciones para <a %s>YouTube</a> y <a %s>Google Video</a>.',
        'PERSON_IN_CHARGE' => 'La persona a cargo de %s quiere ver lo que hacés antes de mostrárselo al mundo.',
        'LEAVE_WINDOW_OPEN' => 'Por favor dejá esta ventana abierta mientras termina la carga .',
        'KEEP_PAGE_OPEN' => 'Por favor dejá esta ventana abierta mientras terminamos de cargar tu video. ¡Te avisamos cuando esté aprobado!',
        'MEANWHILE_FEEL_FREE' => 'Mientras tanto,  podés <a %s>abrir una nueva ventana de tu explorador</a> y continua usando %s. Cuando haya terminado la carga, podrás agregarle un título y una descripción a tu video en esta ventana.',
        'VIDEO_IS_WAITING_FOR_APPROVAL' => 'Este video está<strong>esperando ser aprobado</strong> por parte del creador de %s\\.',
        'LOADING' => 'Cargando...',
        'EDIT_VIDEO' => 'Editar video',
        'DELETE_VIDEO' => 'Eliminar video',
        'YOU_NEED_TO_BE_MEMBER' => '¡Tenés que ser un miembro de %s para agregar comentarios!',
        'SIGN_UP_OR_SIGN_IN' => '<a %s>Uníte a esta red</a>',
        'ADD_A_COMMENT' => 'Agregar un comentario',
        'LEAVE_A_COMMENT_FOR_USERNAME' => 'Dejar un comentario para %s',
        'MORE' => 'Más',
        'PREVIOUS' => 'Anterior',
        'NEXT' => 'Próximo',
        'ABOUT_THIS_VIDEO' => 'Sobre este video',
        'ABOUT_YOUR_VIDEO' => 'Sobre este video',
        'ADDED_ON_DATE_BY' => 'Agregado <strong>%s</strong> by:',
        'VIEWS' => 'Vistas:',
        'COMMENTS' => 'Comentarios',
        'COMMENTS_COLON' => 'Comentarios:',
        'LOCATION_OF_VIDEO' => 'Ubicación de este video:',
        'RELATED_VIDEOS' => 'Videos relacionados',
        'ALL_VIDEOS_TAGGED_X_X' => 'Todos los videos con etiqueta %s (%s)',
        'XS_VIDEOS_X' => 'Videos de %s (%s)',
        'XS_FAVORITES_X' => 'Favoritos de %s (%s)',
        'VIDEO_DETAILS' => 'Detalles del video',
        'NEITHER_FILE_NOR_EMBED_CODE' => 'No se especificó ni un archivo ni un código incrustado.',
        'VIDEO_UPLOADED_ON_X' => 'El video fue subido en %s',
        'PROBLEM_OCCURRED_CONVERTING_VIDEO' => 'Hubo un problema mientras se convertía el video a formato Flash: %s',
        'STATUS_N' => 'Estado %s',
        'YOUR_VIDEO_TITLED_X_COULD_NOT' => 'Tu video titulado "%s" no pudo ser agregado a %s',
        'YOUR_VIDEO_COULD_NOT_BE_ADDED' => 'Tu video no pudo ser agregado a %s',
        'YOU_JUST_TRIED_TO_SEND_VIDEO' => 'Recién intentaste enviar un video a %s. Lamentablemente, no sos miembro de %s y no podemos entregarlo.',
        'VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'No se completó la carga del video en %s',
        'YOUR_VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'tu carga del video no se completó en  %s.',
        'YOUR_VIDEO_ENCOUNTERED_A_PROBLEM' => 'Hubo un problema con tu video mientras se cargaba en %s',
        'THE_PROBLEM_WAS_X' => 'El problema fue: %s',
        'FOR_FURTHER_ASSISTANCE_2' => 'Para más información, por favor ponete en contacto con:',
        'ID' => 'ID:',
        'VIDEO_TRANSCODING_FAILED_FOR_X' => 'La codificación del video falló %s en %s',
        'X_UPLOADED_A_VIDEO_THAT_FAILED' => '%s subió un video en el que falló la codificación.',
        'ERROR_MESSAGE' => 'Mensaje de error:',
        'APPLICATION_NAME' => 'Nombre de la aplicación:',
        'APPLICATION_ID' => 'ID de la aplicación:',
        'VIDEO_ID' => 'ID del video :',
        'VIDEO_UPLOAD_COMPLETE_ON_X' => 'La carga del video se completó en %s',
        'YOUR_VIDEO_UPLOAD_COMPLETE_ON_X' => 'La carga de su video se  completó en %s',
        'YOUR_VIDEO_WAS_UPLOADED' => 'Tu video se cargó con éxito en %s!',
        'THAT_VIDEO_IS_AWAITING_APPROVAL' => 'Ese video está esperando ser aprobado.',
        'THIS_VIDEO_IS_BEING_PROCESSED' => 'Este video todavía se está procesando.',
        'ADD_VIDEO' => 'Agregar video',
        'VIDEO_BY_X' => 'Video de %s',
        'THERE_IS_NEW_COMMENT_ON_VIDEO_X' => 'Hay un nuevo comentario sobre tu video "%s" en %s',
        'THERE_IS_NEW_COMMENT_ON_VIDEO' => 'Hay un nuevo comentario sobre uno de tus videos en %s',
        'SOMEBODY_COMMENTED_VIDEO_ADDED_TO_X' => 'alguien hizo un comentario sobre un video que agregaste en %s',
        'SOMEBODY_UPLOADED_VIDEO_TO_X' => 'alguien subió un video a %s',
        'MORE_WAYS_TO_ADD_VIDEOS' => 'Más formas de agregar videos...',
        'FROM_YOUTUBE_OR_GOOGLE' => 'Desde YouTube o Google',
        'GRAB_THE_HTML_EMBED_CODE' => 'Copiá el código HTML \'embed\' de cualquier sitio de videos y agregá ese video a tu red social.',
        'ADD_A_VIDEO_FROM_YOUTUBE' => 'Agregá un video de YouTube o Google',
        'PASTE_IN_EMBED' => 'Copiá el codigo \'incrustado\' de este video acá:',
        'ADD_VIDEOS_BY_PHONE_OR_EMAIL' => 'Agregá un video por teléfono o por correo electrónico',
        'VIDEO' => 'video',
        'THERE_ARE_NO_VIDEOS_THAT_MATCH' => 'No hay videos con las características que elegiste.',
        'CLICK_EDIT_AND_CHANGE_SETTINGS' => 'Hacá clic en \'Editar\' y cambiá la configuración para que este recuadro aparezca para otros usuarios.',
        'PLAY_AGAIN' => 'Reproducir de nuevo',
        'SHARE' => 'Compartir',
        'EMBED' => 'Incrustado',
        'REWIND' => 'Rebobinar',
        'CHANGE_SIZE' => 'Cambiar tamaño',
        'FULLSCREEN' => 'Pantalla completa',
        'EXIT_FULLSCREEN' => 'Salir de pantalla completa',
        'HIDE' => 'Cerrar',
        'COPY_AND_PASTE_LINK' => 'Copiá y pegá este vínculo en un mensaje de correo electrónico o en un mensaje instantaneo:',
        'FIND_MORE_VIDEOS_LIKE_THIS' => 'Encontrá más videos como éste en <em>%s</em>',
        'SEE_VIDEO_ON_NETWORK' => 'Mirá este video en %s',
        'GET_EMBED_CODE' => 'Obtener código incrustado',
        'MORE_PHOTOS' => 'Más fotos',
        'THIS_ALBUM' => 'Este álbum',
        'NETWORK_DOES_NOT_HAVE_PHOTOS' => 'Esta red todavía no tiene fotos.',
        'PERSON_DOES_NOT_HAVE_PHOTOS' => 'Esta persona todavía no tiene fotos.',
        'ALBUM_DOES_NOT_HAVE_PHOTOS' => 'Este álbum todavía no tiene fotos.',
        'FIND_MORE_PHOTOS_LIKE_THIS' => 'Encontrá más fotos como ésta en <em>%s</em>',
        'NO_PHOTOS_AVAILABLE' => 'No hay fotos en este álbum. <a %s>Hacé clic acá para ver todos los álbumes</a>.',
        'ALBUM_PHOTOS_NOT_VISIBLE_TO_OTHERS' => 'Este álbum no es visible a otras personas en esta red porque las fotos son sólo visibles para vos, o no fueron aprobadas.',
        'CUSTOMIZE_YOUR_SLIDESHOW_PLAYER' => '¡Personalizá tu reproductor de fotos!',
        'ADD_SLIDESHOW_LOGO' => 'Agregá un logotipo al reproductor de fotos de la red social <a %s> - ¡elegilo ahora!</a>',
        'PHOTO_BY_X' => 'Foto de %s',
        'UPLOAD_PHOTOS' => 'Subí fotos',
        'PLAYER_COLOR' => 'Color del reproductor',
        'SLIDESHOW_PLAYER' => 'Reproductor de fotos',
        'SLIDESHOW' => 'reproductor',
        'FILTER' => 'Filtro',
        'SAVE_ALBUM' => 'Guardar álbum',
        'APPLY_THIS_INFO_TO_PHOTOS' => 'Aplicar esta información a las siguientes fotos',
        'CLICK_TO_ADD_A_DESCRIPTION' => 'Hacé clic para agregar una descripción',
        'CHECK' => 'Controlá',
        'YOU_NEED_TO_BE_X' => 'Necesitás ser %s para hacer eso.',
        'ALL_PHOTOS' => 'Todas las fotos',
        'POPULAR_PHOTOS' => 'Fotos populares',
        'FEATURED_PHOTOS' => 'Fotos destacadas',
        'PHOTOS_HOME' => 'Página de inicio de fotos',
        'ALL_ALBUMS' => 'Todos los álbumes',
        'MY_PHOTOS' => 'Mis fotos',
        'MY_ALBUMS' => 'Mis álbumes',
        'ADD_PHOTOS' => 'Agregar fotos',
        'ADD_PHOTOS_SENTENCE_CASE' => 'Agregar fotos',
        'EDIT' => 'Editar',
        'CHOOSE_PHOTOS' => 'Elegir fotos',
        'ADD_PHOTOS_BY_DRAGGING' => '<strong>Agregá fotos arrastrándolas</strong> a tu álbum a la derecha. Eliminalas devolviéndolas a su lugar de origen.',
        'TITLE_YOUR_ALBUM' => '<strong>Titulá tu album.</strong> Ponele una tapa y una descripción.',
        'SAVE_YOUR_ALBUM' => '¡Guardá tu álbum!',
        'CHOOSE_FROM' => 'Elegir de:',
        'EVERYONES_PHOTOS' => 'Todas las fotos',
        'TAGGED' => 'Etiquetada:',
        'OLDER_PHOTOS' => 'Fotos anteriores',
        'MORE_RECENT_PHOTOS' => 'Fotos más recientes',
        'YOUR_ALBUM' => 'Tu álbum',
        'DRAG_ALBUM_COVER_HERE' => 'Arrastrá la tapa del álbum acá',
        'ALBUM_TITLE' => 'Título del álbum:',
        'ALBUM' => 'álbum',
        'DRAG_PHOTOS_HERE' => 'Arrastrá tus fotos acá',
        'PREVIOUS_ALBUM_PAGE' => 'Página anterior del álbum',
        'NEXT_ALBUM_PAGE' => 'Próxima página del álbum',
        'ADDED_ON_DATE' => 'Agregado %s',
        'VIEW_AS_SLIDESHOW' => 'Ver como presentación',
        'CREATED_BY_ME' => 'Creado por <a %s>Mi</a>',
        'CREATED_BY_X' => 'Creado por %s',
        'OUR_APOLOGIES' => 'Disculpá',
        'ADD_PHOTOS_TO_ALBUM' => 'Agregá más fotos a este álbum eligiendo de las opciones que están abajo.',
        'YOU_CAN_ADD_PHOTOS' => 'Podés <a %s>agregar fotos a este álbum ahora</a>.',
        'SITE_IS_GETTING_STARTED' => '¡Esta red social recién está comenzando!',
        'NO_ONE_CREATED_ALBUMS' => 'Parece que todavía nadie creó ningún álbum. Podés <a %s>crear un álbum ahora</a>.',
        'EDIT_YOUR_ALBUM' => 'Editá tu álbum',
        'ALBUMS_WITH_THIS_PHOTO' => 'Todos los álbumes con esta foto',
        'ALBUMS_WITH_X' => 'Todos los álbumes con \'%s\'',
        'ALBUMS_WITH_X_2' => 'Todos los álbumes con <em>\'%s\'</em>',
        'NO_ALBUMS_CONTAINING_PHOTO' => 'No hay álbumes que incluyan esta foto. Podés <a %s>crear un nuevo álbum</a>.',
        'XS_ALBUMS' => 'Álbumes de %s',
        'CREATE_AN_ALBUM' => 'Creá un álbum',
        'YOU_HAVE_NOT_CREATED_ALBUMS' => 'Todavía no creaste ningún álbum de fotos. Podés<a %s>crear un álbum ahora</a>.',
        'X_HAS_NOT_CREATED_ALBUMS' => '%s todavía no creó ningún álbum.',
        'MAKE_AN_ALBUM' => 'Creá un álbum',
        'ABOUT_THIS_ALBUM' => 'Acerca de éste álbum',
        'ABOUT_YOUR_ALBUM' => 'Acerca de tu álbum',
        'EDIT_ALBUM' => 'Editar el álbum',
        'DELETE_THIS_ALBUM' => '¿Eliminar este álbum?',
        'DELETE_ALBUM' => 'Eliminar álbum',
        'START_SLIDESHOW' => 'Empezar presentación',
        'ALBUM_IS_NOW_EMPTY' => 'Este álbum está vacío.',
        'YOU_ARE_GETTING_STARTED' => '¡Recién estás empezando!',
        'YOU_HAVE_NOT_ADDED_PHOTOS' => '¡Todavía no agregaste ninguna foto!',
        'ADD_PHOTOS_AND_SHARE' => '¡Agregá fotos y compartílas con tus amigos, con tu familia o con el resto del mundo!',
        'ADD_A_PHOTO' => 'Agregar una foto',
        'NO_PHOTOS_ON_SITE' => 'No hay fotos en tu red social en este momento.',
        'BOX_WILL_NOT_SHOW_PHOTOS' => 'Este recuadro no será visto por otras personas hasta que haya alguna foto para mostrar. ¿Por qué no agregás una?',
        'VIEW_EMBED_CODE' => 'Ver código incrustado',
        'VIEW_SLIDESHOW' => 'Ver presentación',
        'VIEW_PHOTOS' => 'Ver fotos',
        'ADD_YOUR_FIRST_PHOTOS' => 'Agregá tus primeras fotos',
        'YOU_CAN_ADD_YOUR_OWN_PHOTOS' => '¡Podés <a %s>agregar tus propias fotos</a> a %s!',
        'UPLOAD_PHOTOS_FROM' => 'Subí las fotos desde tu PC:',
        'ADD_TITLE_AND_DESCRIPTION_FOR_PHOTOS' => 'Agregá un título y una descripción a tus fotos',
        'EDIT_PHOTO_INFORMATION' => 'Editá la información de la foto',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_1' => 'Agregá un título, una descripción y cualquier otra información que quieras a las fotos que acabas de subir.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_2' => 'Agregá un título, una descripción y cualquier otra información que quieras a esta foto.',
        'CANCEL_AND_RETURN_TO_PHOTO' => 'Cancela y volvé a la foto',
        'WHO_CAN_VIEW_PHOTO' => '¿Quién puede ver esta foto?',
        'CAN_BE_VIEWED_BY' => 'Puede ser vista por:',
        'BY_ME' => 'la subí <a %s>Yo</a>',
        'RSS_FEED_LABEL' => '<a %s>Fuente RSS</a> - %s',
        'NO_PHOTOS_AWAITING_APPROVAL' => 'En este momento no hay fotos que estén esperando aprobación. Si estás buscando algo que hacer, ¿por qué no mirás las <a %s>últimas fotos</a>?',
        'APPROVE_ALL_PHOTOS' => '¿Aprobar todas las fotos?',
        'ARE_YOU_SURE_APPROVE_ALL_PHOTOS' => '¿Estás seguro de que querés aprobar todas las fotos? Esto podría tardar unos minutos.',
        'DELETE_ALL_PHOTOS' => '¿Eliminar todas las fotos?',
        'ARE_YOU_SURE_DELETE_ALL_PHOTOS' => '¿Estás seguro de que querés eliminar todas las fotos que todavía no están aprobadas? Esto podría tardar unos minutos.',
        'KEEP_WINDOW_OPEN_PHOTOS_APPROVED' => 'Por favor mantené esta ventana del explorador abierta mientras se aprueban las fotos. Este proceso podría tardar unos minutos.',
        'KEEP_WINDOW_OPEN_PHOTOS_DELETED' => 'Por favor mantené esta ventana del explorador abierta mientras se eliminan las fotos. Este proceso podría tardar unos minutos.',
        'APPLY_TO_PHOTOS_ADDED_BY' => 'Aplicar a todas las fotos agregadas por %s',
        'NO_ONE_HAS_ADDED_ANY_PHOTOS' => 'No se agregaron fotos a tu red social. Podés <a %s>ser el primero.</a>',
        'UNTITLED' => 'Sin título',
        'A_PROBLEM_OCCURRED' => 'Hubo un problema',
        'PHOTOS_EXCEEDED_LIMIT' => 'La foto parece superar el límite de 10 MB por foto.',
        'GET_A_SLIDESHOW_OF' => 'Conseguí una presentación de  %s',
        'GET_A_SLIDESHOW' => '¡Conseguí una presentación!',
        'GET_SLIDESHOW_OF_PHOTOS' => 'Conseguí una presentación de estas fotos',
        'COPY_AND_PASTE_SLIDESHOW' => 'Copiá y pegá el código para poner esta presentación de fotos en tu sitio web, en tu página MySpace, u otras redes sociales en Ning.',
        'COPY_AND_PASTE_SLIDESHOW_OF_ALBUM' => 'Copiá y pegá el código para poner una presentación de este álbum en tu sitio web, en tu página MySpace, u otras redes sociales en Ning.',
        'LARGE_VERSION' => 'Versión grande',
        'SMALL_VERSION' => 'Versión chica',
        'VIEW_SLIDESHOW_FULL_SIZE' => 'Mirá esta presentación en tamaño completo',
        'PHOTOS' => 'Fotos',
        'XS_PHOTOS' => 'Fotos de %s',
        'XS_PHOTO' => 'Foto de %s',
        'YOU_CAN_MARK_PHOTO' => 'Podés marcar cualquier foto como favorita. Simplemente hacé clic en el icono que dice "Agregar a  favoritos" cuando lo veas en una foto.',
        'VIEW_RECENT_PHOTOS' => 'Ver fotos recientes',
        'APPROVE_PHOTOS' => 'Aprobar fotos',
        'DELETE_ALL_XS_PHOTOS_Q' => '¿Eliminar todas las fotos de  %s\\?',
        'ARE_YOU_SURE_DELETE_ALL_XS_PHOTOS' => '¿Estás seguro de que querés eliminar todas las fotos de %s? Este proceso podría tardar unos minutos.',
        'REMOVE_X_AND_ALL_CONTENT' => 'Quitar %1$s y todos el contenido de %1$s de mi red social',
        'SUCCESS' => 'Éxito.',
        'DELETING_CONTENT' => 'Eliminando contenido...',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED' => 'Por favor mantené esta ventana del explorador abierta mientras se elimina el contenido. Este proceso podría tardar unos minutos.',
        'KEEP_WINDOW_OPEN_MEMBERS_DELETED' => 'Por favor mantené esta ventana del explorador abierta mientras se eliminan estos miembros. Este proceso podría tardar unos minutos.',
        'DELETE_ALL_XS_PHOTOS' => 'Eliminar todas las fotos de  %s',
        'CREATE_A_NEW_ALBUM' => 'Crear un nuevo álbum',
        'VIEW_ALL_XS_ALBUMS' => 'Ver todos los álbumes de %s',
        'YOU_HAVE_NOT_ADDED_PHOTOS_2' => 'Todavía no agregaste ninguna foto. ¡Agregá algunas para empezar!',
        'X_HAS_NOT_ADDED_PHOTOS' => '%s todavía no agregó ninguna foto.',
        'MY_FRIENDS_PHOTOS' => 'Fotos de mis amigos',
        'VIEW_PHOTOS_IN_SLIDESHOW' => '¡Ver estas fotos en una presentación!',
        'YOUR_FRIENDS_DO_NOT_HAVE_PHOTOS' => 'Tus amigos todavía no tienen fotos',
        'ALL_PHOTOS_TAGGED_X' => 'Todas las fotos están etiquetadas \'%s\'',
        'ALL_PHOTOS_TAGGED_X_2' => 'Todas las fotos están etiquetadas <em>\'%s\'</em>',
        'NO_PHOTOS_TAGGED_X_CHECK_OUT' => 'No hay ninguna foto con etiqueta "%1$s". ¡Mirá <a %2$s>las discusiones con etiqueta "%1$s"</a> o <a %3$s>videos con etiqueta "%1$s"</a>. ¡O agregá y etiquetá tus propias fotos!',
        'SELECT_YOUR_PHOTOS' => 'Seleccioná tus fotos',
        'PHOTO_MAY_BE_10MB' => 'Cada foto puede tener un tamaño de hasta 10 MB, pero las fotos chicas se cargarán más rápido.',
        'KEEP_PAGE_OPEN_PHOTOS' => 'Por favor mantené esta página abierta así podemos terminar de subir tus fotos. ¡Te avisamos cuando hayan sido aprobadas!',
        'MEANWHILE_FEEL_FREE_PHOTOS' => 'Mientras tanto, si tenés ganas <a %s>abrí otra ventana de tu navegador</a> y seguí usando %s. Cuando haya terminado la carga, podrás agregarle títulos y descripciones a tus fotos en esta ventana.',
        'PHOTO_IS_WAITING_FOR_APPROVAL' => 'Esta foto está <strong>esperando ser aprobada</strong> por el creador de %s',
        'ADD_TO_FAVORITES' => 'Agregar a favoritos',
        'EDIT_PHOTO' => 'Editar foto',
        'DELETE_PHOTO' => 'Eliminar foto',
        'ABOUT_THIS_PHOTO' => 'Acerca de esta foto',
        'LOCATION_OF_PHOTO' => 'Ubicación de esta foto:',
        'ALBUMS_FEATURING_PHOTO' => 'Álbumes que incluyen esta foto',
        'VIEW_ALBUMS_WITH_PHOTO' => 'Mirá todos los álbumes con esta foto',
        'RETURN_TO_X' => 'Volver a %s',
        'RETURN_TO_PHOTOS_HOME' => 'Volver a la página principal de fotos',
        'WE_COULD_NOT_FIND_ANYONE' => 'Disculpá - no pudimos encontrar a nadie',
        'NOBODY_HAS_ADDED_PHOTOS' => '¡Nadie agregó fotos todavía! Agregá algunas fotos para comenzar.',
        'DEFAULT_TITLE' => 'Título',
        'DEFAULT_DESCRIPTION' => 'Descripción',
        'UPLOAD_LIMIT_EXCEEDED' => 'Se sobrepasó el límite de tamaño para el archivo que se estaba cargando.',
        'SLOW_DOWN_THERE_CHIEF' => 'Disculpá',
        'I_DO_NOT_KNOW_USER' => 'Disculpá, no conozco a esta persona.',
        'I_DO_NOT_HAVE_PHOTO' => 'Disculpá, no tengo esa foto.',
        'I_DO_NOT_HAVE_ALBUM' => 'Disculpá, no tengo ese álbum.',
        'ALBUM_BY_X_ON_X' => 'El álbum fue creado por %s en %s',
        'SENT' => '¡Enviado!',
        'I_HAVE_RECENTLY_ADDED' => 'Lo agregué recientemente',
        'FROM_THE_BAZEL' => 'De esta red',
        'RECENTLY_ADDED' => 'Agregado recientemente',
        'RECENT_PUBLIC_PHOTOS_ON_X' => 'Últimas fotos públicas en %s',
        'X_ALL_PHOTOS' => '%s - Todas las fotos',
        'NO_TAG_WAS_SPECIFIED' => 'No se especificó ninguna etiqueta',
        'PUBLIC_PHOTOS_TAGGED_WITH_X' => 'Fotos públicas etiquetadas con %s en %s',
        'XS_PUBLIC_PHOTOS_ON_X' => 'Fotos públicas de %s en %s',
        'WE_DO_NOT_KNOW_USER' => 'No conocemos a esta persona.',
        'XS_FRIENDS_PHOTOS' => 'Fotos de los amigos de %s',
        'XS_FAVORITE_PHOTOS_ON_X' => 'Las fotos favoritas de %s en %s',
        'PHOTO_UPLOADED_ON_X' => 'Foto subida en%s',
        'FILE_EXCEEDED_MAXIMUM_SIZE' => 'El archivo sobrepasó el tamaño máximo',
        'PART_OF_FILE_WAS_UPLOADED' => 'Sólo se subió parte del archivo',
        'NO_FILE_WAS_UPLOADED' => 'La carga falló; el nombre del archivo puede ser incorrecto',
        'PROBLEM_OCCURRED_DURING_UPLOAD' => 'Hubo un problema durante la carga.',
        'ALPHABETICAL' => 'Alfabético',
        'MOST_VIEWS' => 'Más vistas',
        'RATING_NOT_RATED_YET' => '<strong>Calificación:</strong> Sin calificar todavía',
        'NOT_RATED_YET' => 'Sin calificar todavía',
        'HMM_SOMETHING_WENT_AWRY' => 'Hmm... algo pasó',
        'YOUR_PHOTO_TITLED_X_COULD_NOT' => 'Tu foto titulada "%s" no se pudo agregar a %s',
        'YOUR_PHOTO_COULD_NOT_BE_ADDED' => 'Tu foto no se pudo agregar a %s',
        'YOU_JUST_TRIED_TO_SEND' => 'Recién intentaste enviar una foto a %s. Lamentablemente, no sos miembro de %s y no podemos enviarla.',
        'ONLY_MY_FRIENDS' => 'Sólo mis amigos',
        'ANYBODY' => 'Cualquiera',
        'ONLY_MY_FRIENDS_CAN_SEE_PHOTO' => 'Sólo mis amigos pueden ver esta foto',
        'ONLY_XS_FRIENDS_CAN_SEE_PHOTO' => 'Sólo los amigos de %s pueden ver esta foto',
        'ONLY_I_CAN_SEE_PHOTO' => 'Sólo yo puedo ver esta foto',
        'ONLY_X_CAN_SEE_PHOTO' => 'Sólo %s puede ver esta foto',
        'EVERYONE_CAN_SEE_PHOTO' => 'Todos pueden ver esta foto',
        'PRIVATE_PHOTO' => 'Foto <strong>privada</strong>',
        'HOWDY_STRANGER' => 'Hola, ¿quién sos?',
        'YOU_NEED_TO_BE_SIGNED_IN' => 'Tenés que estar registrado en Ning para hacer eso.',
        'JUST_CLICK_ON_SIGN_IN' => 'Sólo hacé clic en "Iniciar sesión" arriba, o si todavía no tenés una cuenta en Ning hacé clic en "Anotarse".',
        'YOU_NEED_TO_BE_' => 'Necesitás ser %s para hacer eso.',
        'YOU_NEED_TO_BE_OWNER' => 'Tenés que ser el creador de la red para hacer eso.',
        'THAT_PHOTO_IS_AWAITING_APPROVAL' => 'Esa foto está esperando ser aprobada.',
        'YOU_NEED_TO_BE_A_FRIEND' => 'Tenés que ser un amigo de %s para hacer eso.',
        'MOST_ACTIVE' => 'Los más activos',
        'HOW_IT_WORKS' => 'Cómo funciona',
        'MORE_WAYS_TO_ADD_PHOTOS' => 'Más formas de agregar fotos...',
        'BY_PHONE_OR_EMAIL' => 'por teléfono o por correo electrónico',
        'FROM_FLICKR' => 'desde Flickr',
        'FROM_YOUR_COMPUTER' => 'desde tu PC',
        'ADD_PHOTOS_FROM_YOUR_FLICKR' => 'Agregá fotos de tu cuenta de Flickr.',
        'MORE_INFORMATION' => 'Más información',
        'ADD_PHOTOS_BY_PHONE_OR_EMAIL' => 'Agregar fotos por teléfono o por correo electrónico',
        'SEND_ONE_PHOTO_OR_VIDEO' => 'Enviá una foto o video o por correo electrónico. El asunto del correo será el titulo de la foto o el video, y el cuerpo del mensaje será la descripción.',
        'CLICK_HERE_TO_GET_A_NEW_UNIQUE' => 'Hacé clic acá para conseguir una nueva dirección de correo electrónico',
        'UPLOAD_PHOTOS_FROM_YOUR' => 'Subí fotos desde tu PC.',
        'PHOTO' => 'foto',
        'YOUVE_SET_THE_NUMBER_OF_PHOTOS' => 'No estás mostrando ninguna foto.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_PHOTO' => 'Este recuadro no será visible para otros hasta que selecciones al menos una foto.',
        'THERE_IS_NEW_COMMENT_ON_PHOTO_X' => 'Hay un nuevo comentario sobre tu foto "%s" en %s',
        'THERE_IS_NEW_COMMENT_ON_PHOTO' => 'Hay un nuevo comentario acerca de una de tus fotos en %s',
        'SOMEBODY_COMMENTED_PHOTO_ADDED_TO_X' => 'alguien hizo un comentario acerca de una foto que agregaste a %s',
        'SOMEBODY_UPLOADED_PHOTO_TO_X' => 'Alguien subió una foto a %s',
        'ADD_PHOTOS_OR_VIDEOS_TO_X' => 'Agregá fotos o videos a %s directamente desde tu teléfono enviándolos a una dirección de correo electrónico.',
        'DO_YOU_REALLY_WANT_TO_REMOVE' => '¿Realmente querés eliminar este elemento de tus favoritos?',
        'DELETE_THIS_PHOTO_Q' => '¿Eliminar esta foto?',
        'ARE_YOU_SURE_DELETE_THIS_PHOTO' => '¿Estás seguro de que querés eliminar esta foto? Este proceso podría tardar unos minutos.',
        'PHOTO_SLIDESHOW' => 'Presentación',
        'THUMBNAILS' => 'Miniaturas',
        'DETAIL' => 'Detalles',
        'TAG' => 'Etiquetar',
        'RATE' => 'Calificar',
        'ALL_SIZES' => 'Todos los tamaños',
        'ADD_TO_ALBUM' => 'Agregar a álbum',
        'ROTATE_PHOTO' => 'Rotar foto',
        'ABOUT_YOUR_PHOTO' => 'Acerca de tu foto',
        'SEE_PHOTOS_ON_NETWORK' => 'Ver estas fotos en %s',
        'EMBED_CODE' => 'Código incrustado',
        'IMPORT_PHOTOS_FLICKR' => 'Importar tus fotos de Flickr',
        'CLICK_HERE_TO_CONTINUE_TO_FLICKR' => 'Hacé clic acá para ir a Flickr',
        'TO_GET_YOUR_PHOTOS_FROM_FLICKR' => 'Para importar tus fotos de Flickr, primero tenés que permitirle a  %S estar vinculado a tu cuenta en Flickr .',
        'IMPORT_PHOTOS' => 'Importar fotos',
        'GET_MY' => 'Conseguí mis',
        'GET_PHOTOS' => 'Importar fotos',
        'MOST_RECENT_PHOTOS' => 'Las fotos más recientes',
        'GET_ALL_MY_FLICKR' => 'Importar todas mis fotos de Flickr (esto puede tardar un poco)',
        'GET_ALL_MY_TAGGED' => 'Etiquetar todas mis fotos',
        'GET_PHOTOS_FROM_SET' => 'Importar fotos de un conjunto:',
        'GET_STARTED_BY_IMPORT' => 'Nosotros importaremos tus títulos, etiquetas e información de localización automáticamente.<br/>¿Cuánto tardará?</p> <p><ul style="padding-top:10px;"><li>10 Fotos: <em>menos de 30 segundos</em>.</li><li>50 Fotos: <em>alrededor de 2 minutos</em>.</li><li>200 Fotos: <em>alrededor de 6 minutos</em>.</li><li>500 fotos: <em>alrededor de 15 minutos</em>.</li></ul>',
        'IF_YOURE_NOT_SIGNED_IN' => 'Si no iniciaste sesión en Flickr, se te pedirá que lo hagas. Cuando ya la hayas iniciado, hacé clic en el botón que dice "OK, permitir".',
        'GET_MY_FLICKR_PHOTOS_DESCRIPTIONS' => 'Importá las descripciones también (esto duplicará el tiempo que se tarda).',
        'PLEASE_KEEP_THIS_PAGE_OPEN_WHILE_IMPORT' => 'Por favor mantené esta página abierta así podemos terminar de importar tus fotos.',
        'GET_MY_FLICKR_PHOTOS_ORIGINALS' => 'Importá la versión de tamaño completo de cada foto (esto también aumentará el tiempo de importación y no lo recomendamos si son más de 20 fotos).',
        'MAKE_YOUR_X_PAGE_YOUR_OWN' => 'Hacé clic en "editar" para agregar texto, videos, fotos o lo que quieras en este recuadro. Es otra forma de personalizar tu  página de %s.',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Hacé clic en \'Editar\'  para agregar texto, HTML, videos, fotos, u <a %1$s>otros widgets de terceros</a> en este recuadro. Es otra forma de hacer tuya tu página %2$s.',
        'BOX_WILL_NOT_SHOW_UNTIL_UPDATE_CONTENT' => 'Otras personas no verán este recuadro hasta que actualices el contenido.',
        'YOUR_X_BOX' => 'Tu recuadro en %s',
        'ABOUT_WIDGETS' => 'Acerca de Widgets',
        'HELP' => 'Ayuda',
        'WIDGETS' => 'Widgets',
        'LOOKING_TO_ADD_FUNCTIONALITY' => '¿Querés agregar más funcionalidad a tu red social? Tal vez un calendario, o un pronóstico meteorológico local, o una cuenta regresiva hasta un evento o una cámara web? Con widgets, es fácil agregar nuevas cosas a cualquier recuadro en tu Red.',
        'GETTING_STARTED' => 'Introducción',
        'BELOW_IS_LIST_OF_WIDGET' => 'Esta es <a %s>una lista de proveedores de widgets</a> que podés usar para elegir los que te interesan. Elegimos algunos widgets de <a %s>yourminis.com</a> para empezar. Configurá un widget, copiá y pegá el codigo en el recuadro, y ¡listo!',
        'CALENDAR' => 'Calendario',
        'CALENDAR_WIDGET_ALLOWS_SEARCH' => 'El widget de Calendario te deja mostrar la fecha y buscar y agregar eventos en formato iCal (utilizado por el Calendario de Google y muchos otros proveedores de calendarios en línea).',
        'USE_EDIT_WIDGET_BUTTON_CALENDAR' => 'Usá el botón &#8220;edit widget&#8221; para elegir &#8220;search for events&#8221;, y luego ingresá un termino de búsqueda. También podes ingresar un URL iCal de forma manual para agregar los eventos.',
        'CUSTOMIZATION' => 'Configuración',
        'YOU_CAN_CUSTOMIZE_WIDGET' => 'Podés cambiar la apariencia del widget moviendo el mouse sobre él, después hacé clic en el selector de color para cambiar el fondo, estilo, y transparencia. Cuando termines, hacé clic en el vínculo &#8220;copy to web&#8221;, luego el botón &#8220;copy embed code&#8221;. Una vez que el código esté copiado, volvé al recuadro de texto en tu red, pegá el codigo y grabá tus cambios y ¡listo!',
        'GET_MORE_WIDGETS_FROM_YOURMINIS' => 'Conseguí más widgets en yourminis.com »',
        'WEATHER' => 'Pronóstico meteorológico',
        'WEATHER_WIDGET_DISPLAYS' => 'El Weather widget muestra el pronóstico meteorológico local, cortesía del Weather Channel.',
        'USE_EDIT_WIDGET_BUTTON_WEATHER' => 'Usá el botón &#8220;edit widget&#8221; para elegir tu ubicación geográfica, y luego elegí Fahrenheit o Celsius. También podés elegir mostrar el día actual, o el pronóstico para los próximos cinco días.',
        'COUNTDOWN' => 'Cuenta regresiva',
        'COUNTDOWN_WIDGET_LETS_YOU' => 'El Countdown widget te permite crear una cuenta regresiva hasta un evento específico. Hacé clic en el botón de &#8220;edit widget&#8221; podés ingresar la fecha, hora y título o imagen de un evento para llevar cuenta.',
        'WEBCAM' => 'Cámara web',
        'WEBCAM_WIDGET_ALLOWS_YOU' => 'El Webcam widget te permite monitorear cámaras web que estén disponibles públicamente. Usá el botón de &#8220;edit widget&#8221; para elegir de una lista de cámaras web preseleccionadas, o elegí el URL de la cámara web de forma manual.',
        'MORE_WIDGETS' => 'Más Widgets',
        'NEED_MORE_OPTIONS' => 'Más opciones? Te recomendamos los siguientes sitios para buscar widgets:',
        'MODERATION_DENIED_ON_X' => 'La moderación ha sido denegada en %s sobre %s',
        'MODERATION_DENIED_ON_A_X' => 'La moderación ha sido denegada en una %s de un %s',
        'YOU_HAVE_NEW_X_TO_MODERATE' => 'Tenés un nuevo %s para moderar en %s',
        'NEW_X_TO_MODERATE' => 'Hay un nuevo %s para que vos moderes.',
        'MODERATION_APPROVED_ON_X' => 'Moderación aprobada en %s sobre %s',
        'MODERATION_APPROVED_ON_A_X' => 'Moderación aprobada de un %s sobre vos en %s',
        'JOIN' => 'Unite',
        'WELCOME' => 'Bienvenido',
        'WELCOME_TO_X' => 'Bienvenido a %s',
        'WELCOME_TO_X_ELLIPSIS' => 'Bienvenido a %s',
        'RSS_LINK' => '<a %s>RSS</a>',
        'NEW_FEATURES_GROUPS_MUSIC' => '<h3 style="margin-top:0">Nuevas funciones</h3>
            <ul><li><strong>Grupos</strong> &ndash; Dejá que los miembros creen grupos en tu red</li>
                <li><strong>Reproductor de música</strong> &ndash; Agregá música y podcasts a tu red</li></ul>
            <p><a href="%s" class="desc add">Hacé clic acá para agregar funciones</a></p>',
        'NEW_FEATURES_ACTIVITY_BADGES' => '<h3 style="margin-top:0">Nuevas funciones</h3>
            <ul><li><strong>Actividad más reciente</strong> &ndash; Seguí la actividad más reciente de los miembros en tu red</li>
                <li><strong>Insignias y Widgets</strong> &ndash; Promocioná tu red en la web con insignias (“badges”) y widgets personalizados</li></ul>
            <p><a href="%s" class="desc add">Hacé clic acá para agregar/editar funciones</a></p>',
        'YOUR_TYPE_NAME_HAS_NEW_COMMENT_APPNAME' => '¡Tu %2$s, %1$s, tiene un nuevo comentario agregado por alguien en %3$s!',
        'YOUR_TYPE_HAS_NEW_COMMENT_APPNAME' => 'Tu %1$s tiene un nuevo comentario agregado por alguien en %2$s!',
        'HERE_IS_LINK' => 'Este es el vínculo para unirse: <a %s>%s</a>',
        'THANKS_VALEDICTION' => 'Gracias,',
        'THANKS' => '¡Gracias!',
        'YOU_CHANGED_YOUR_EMAIL_ON_X' => 'Cambiaste la dirección de correo electrónico en %s.',
        'YOU_CHANGED_YOUR_EMAIL_ON_X_ELLIPSIS' => 'Cambiaste la dirección de correo electrónico en %...',
        'CLICK_HERE_TO_SIGN_IN_WITH_YOUR_NEW_EMAIL_ADDRESS' => 'Hacé clic acá para iniciar sesión con tu nueva dirección de correo electrónico:',
        'IF_DID_NOT_CHANGE_EMAIL_ADDRESS' => 'Si vos no cambiaste la dirección de correo electrónico, hacé clic acá:',
        'TO_STOP_BEING_NOTIFIED_OF_NEW_DISCUSSIONS_GO_TO' => 'Para dejar de recibir notificaciones de nuevas discusiones, entrá en:',
        'X_STARTED_DISCUSSION_ON_APPNAME_ELLIPSIS' => '%1$s comenzó una nueva discusión en %2$s...',
        'X_STARTED_THE_DISCUSSION_Y' => '%1$s comenzó la discusión "%2$s".',
        'TO_VIEW_THIS_DISCUSSION_GO_TO' => 'Para ver esta discusión, entrá en:',
        'X_HAS_INVITED_YOU_TO_JOIN_Y' => '¡%s te ha invitado a que te unas a %s!',
        'X_WANTS_YOU_TO_CHECK_OUT_Y' => '¡%s quiero que mires  "%s" en %s!',
        'CHECK_OUT_TITLE_ON_APPNAME' => '¡Mirá "%s" en %s!',
        'ABOUT_X' => 'Acerca de %s',
        'YOU_HAVE_RECEIVED_BECAUSE_X' => 'Recibiste este mensaje de correo electrónico porque %s',
        'IF_YOU_NO_LONGER_WISH_FROM_X_CLICK_Y' => 'Si no querés recibir más notificaciones por correo electrónico de %s, <a %s>por favor hacé clic acá</a>.',
        'CLICK_HERE' => 'Hacé clic acá',
        'YOU_CAN_CONTACT_US' => 'Te podés comunicar con nosotros por cualquier pregunta o duda que tengas con respecto a tu privacidad, desde http://help.ning.com/?page_id=27 .',
        'MESSAGE_TO_ALL_MEMBERS_OF_X' => 'Un mensaje a todos los miembros de %s',
        'CLICK_TO_CHECK_OUT' => '¡Hacé clic acá para verlo!',
        'CLICK_TO_APPROVE_X' => 'Hacé clic acá para aprobar/eliminar este %s',
        'YOUR_X_HAS_BEEN_APPROVED' => '¡Tu %s se aprobó en %s!',
        'YOUR_X_WAS_NOT_APPROVED' => 'Tu %s no se aprobó en %s.',
        'CLICK_TO_VIEW_X' => '¡Hacé clic acá para ver este %s!',
        'CLICK_TO_VIEW_IT' => '¡Hacé clic acá para verlo!',
        'TO_VIEW_USER_PROFILE_VISIT' => 'Para ver el perfil de %s, visitá:',
        'YOU_ADDED_CONTENT' => 'agregaste contenido a  %s, una red social moderada',
        'X_REPORTED_AN_ISSUE_ON_Y_ELLIPSIS' => '%1$s informó acerca de una duda en %2$s...',
        'X_REPORTED_THE_FOLLOWING_ISSUE' => '%s informó acerca del siguiente problema.',
        'URL_REPORTED_COLON' => 'Dirección URL informada:',
        'ISSUE_COLON' => 'Problema:',
        'ADDITIONAL_INFORMATION_COLON' => 'Más información:',
        'SEND_AN_INVITATION_TO_X' => 'Enviá una invitación a %s',
        'SOMEBODY_REQUESTED_JOIN_X' => 'alguien pidió unirse a %s',
        'WANT_TO_ADD_A_WELCOME_MESSAGE_FOR_X_ON_THEIR_PROFILE_GO_TO' => '¿Querés agregar un mensaje de bienvenida para %s en su perfil? Entrá en:',
        'USER_HAS_SENT_YOU_A_MESSAGE' => '%s te envió un mensaje.',
        'TO_READ_THIS_MESSAGE_VISIT' => 'Para leer este mensaje, entrá en:',
        'X_HAS_SENT_YOU_A_MESSAGE_ON_Y_ELLIPSIS' => '%s te envió un mensaje en %s...',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ELLIPSIS' => '%s te agregó como amigo...',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ON_Y' => '%s te agregó como amigo en %s.',
        'X_HAS_ACCEPTED_YOUR_FRIEND_REQUEST' => '%s aceptó tu pedido en %s!',
        'TO_ACCEPT_THIS_FRIEND_REQUEST_VISIT' => 'Para aceptar el pedido de este amigo, entrá en:',
        'VIEW_XS_PAGE_ON_Y' => 'Ver la página de %s en %s',
        'MEMBER_OF_X_ACCEPTED' => 'Un miembro de %s aceptó tu pedido de amistad',
        'IF_NO_LONGER_WISH_FRIEND_NOTIFICATION_EMAIL_FROM_X_CLICK_Y' => 'Si ya no querés recibir mensajes de correo electrónico de aviso de pedidos de amistad de%s, <a %s>por favor, hacé clic acá</a>.',
        'YOU_RECEIVED_INVITATION_FROM_X' => 'Recibiste esta invitación de un miembro de %1$s. Si no querés recibir invitaciones de %1$s, ponete en contacto con nosotros en http://help.ning.com/?page_id=27 .',
        'ON_X_COLON' => 'Sobre %s:',
        'ON_X' => 'sobre %s',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP' => '%s pidió ser miembro de %s.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X_ELLIPSIS' => '%1$s pidió ser miembro de %2$s en %3$s...',
        'USER_HAS_INVITED_YOU_TO_JOIN_THE_GROUP_X' => '%1$s te invitó a que te unas al grupo "%2$s"',
        'VISIT_GROUP_AT' => 'Visitá a %s en:',
        'ABOUT_GROUP' => 'Acerca de %s',
        'A_MESSAGE_FROM_USERNAME_TO_GROUPNAME_ON_APPNAME' => 'Un mensaje de %s a todos los miembros de %s en %s!',
        'YOU_CAN_SIGN_IN_USING_EMAIL_HERE' => 'Podés iniciar sesión usando tu dirección de correo electrónico acá:',
        'USERNAME_COMMENTED_ON_BLOG_POST_TITLE_APPNAME' => '%s comentó en la publicación de blog \'%s\' en %s',
        'SEND_X_A_MESSAGE_HERE' => 'Enviar un mensaje a %s acá:',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X_ELLIPSIS' => 'Hay un nuevo miembro que espera tu aprobación en %s...',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE' => 'Hay un nuevo miembro que espera tu aprobación.',
        'TO_APPROVE_XS_PROFILE_VISIT' => 'Para aprobar el perfil de %s, andá a:',
        'CANT_CLICK_CUT_AND_PASTE' => '¿No podés hacer clic en el vínculo? Cortá y pegá la URL en tu navegador.',
        'CLICK_HERE_TO_JOIN_COLON' => 'Hacé clic acá para unirte:',
        'CLICK_HERE_TO_JOIN_BANG' => 'Hacé clic acá para unirte!',
        'YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED_ELLIPSIS' => 'Tu membresía en %s ha sido aprobada...',
        'CONGRATULATIONS_BANG_YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED' => '¡Felicitaciones! Tu membresía en %s ha sido aprobada.',
        'YOU_CAN_NOW_SIGN_IN_USING_YOUR_EMAIL_ADDRESS_HERE' => 'Ahora podés iniciar sesión usando tu dirección de correo electrónico acá:',
        'VISIT_X_AT_Y' => 'Visitá %1$s en: %2$s',
        'TO_CONTROL_WHICH_EMAILS_YOUR_RECEIVE_ON_X_GO_TO' => 'Para controlar qué mensajes recibís en %1$s, entrá en:',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_ELLIPSIS' => 'Un miembro no admitido te envió un mensaje a %s...',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_USERNAME_WRITES' => 'Un miembro no admitido te envió un mensaje en %1$s.  %2$s escribe:',
        'WELCOME_TO_THE_GROUP_X' => 'Bienvenido al grupo "%s"',
        'WELCOME_TO_GROUP_X_ON_Y_ELLIPSIS' => 'Bienvenido a %1$s en %2$s...',
        'TO_VIEW_THIS_GROUP_VISIT' => 'Para ver este grupo, andá a:',
        'X_INVITES_YOU_TO_JOIN_Y' => '%1$s te invita a unirte a %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y' => '%1$s ahora es miembro de %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y_ELLIPSIS' => '%1$s ahora es miembro de %2$s...',
        'SOMEBODY' => 'Alguien',
        'TO_VIEW_YOUR_NEW_COMMENT_VISIT' => 'Para ver tu nuevo comentario, andá a:',
        'TO_VIEW_THE_NEW_COMMENT_VISIT' => 'Para ver el nuevo comentario, andá a:',
        'TO_VIEW_THE_NEW_REPLY_VISIT' => 'Para ver la nueva respuesta, andá a:',
        'WELCOME_TO_X_THANK_YOU_FOR_JOINING' => '¡Bienvenido a %s! Gracias por unirte.',
        'NAME_COLON' => 'Nombre:',
        'EMAIL_COLON' => 'Correo electrónico:',
        'AGE_COLON' => 'Edad:',
        'GENDER_COLON' => 'Sexo:',
        'LOCATION_COLON' => 'Ubicación:',
        'COUNTRY_COLON' => 'País:',
        'GET_NETWORK_BADGE' => '%s Insignia',
        'SPREAD_WORD_GET_BADGE' => 'Avisale a todo el mundo. Conseguí tu propia insignia de %s para tu sitio web o tu página de MySpace. (<a %s>Obtener código</a>)',
        'SPREAD_WORD_GET_BADGE_SHORT' => 'Avisale a todo el mundo. <a href="%s">Conseguí tu propia insignia de %s</a>',
        'SHOW_ALLEGIANCE_GET_BADGE' => 'Mostrá tus colores. Conseguí tu propia insignia de %s para poner en tu sitio web o en tu página de MySpace. (<a %s>Obtener código</a>)',
        'USER_COMMENTED_ON_A_TYPE_ON_APPNAME' => '%1$s hizo un comentario sobre el %2$s "%4$s" en %3$s',
        'UNABLE_TO_EXTRACT_EMAIL_ADDRESSES' => 'Disculpá. No pudimos extraer direcciones de correo electrónico del archivo.',
        'ADMINISTRATORS' => 'Administradores',
        'YOUR_INVITATION_HAS_EXPIRED' => 'Tu invitación caducó',
        'SORRY_INVITATION_EXPIRED' => 'Lamentablemente, la invitación que usaste caducó. Necesitarás una nueva invitación para unirte a %s.',
        'DISABLE_INVITATION_LINK' => '¿Deshabilitar vínculo de invitación?',
        'CREATING_LINK_WILL_DISABLE' => 'Al crear un nuevo vínculo de invitación se deshabilita el vínculo actual. ¿Estás seguro de que querés crear un nuevo vínculo?',
        'SHARE_LINK_WITH_PEOPLE' => 'Compartí este vínculo con las personas que quieras que se unan a esta red:',
        'CREATE_INVITATION_LINK' => 'Crear nuevo vínculo de invitación',
        'PLEASE_SELECT_SECOND_PART' => 'Seleccioná la segunda parte de tu dirección de correo electrónico, por ej., gmail.com.',
        'AT_SYMBOL_NOT_ALLOWED' => 'Aseguráte de que el símbolo @ no esté en la primera parte de la dirección de correo electrónico.',
        'SORRY_WE_DONT_SUPPORT' => 'Lamentablemente, no trabajamos con la libreta de direcciones de tu dirección de correo electrónico. Intentá hacer clic en \'Email Application\' que se encuentra más abajo, para usar las direcciones de tu PC.',
        'PLEASE_ENTER_PASSWORD_FOR_EMAIL' => 'Ingresá tu contraseña para %s.',
        'IMPORTING_ADDRESS_BOOK' => 'Importando libreta de direcciones',
        'LEAVE_WINDOW_WHILE_GET' => '<strong>Mantené abierta esta ventana</strong> mientras obtenemos las direcciones de correo electrónico de tus amigos. Cuando hayamos terminado, podrás elegir a qué amigos invitar.',
        'SHARE_THIS_LINK' => 'Compartí este vínculo:',
        'SEND_WITH_EMAIL_PROGRAM' => 'Envialo con el programa de correo electrónico de tu PC:',
        'EMAIL_THIS' => 'Enviar esto por correo electrónico',
        'IS_YOUR_FRIEND_PARENTHESIZED' => '(es tu amigo)',
        'CLEAR' => 'Eliminar',
        'SEARCH_FRIENDS_TO_INVITE' => 'Buscar amigos para invitar:',
        'YOUR_INVITATIONS_HAVE_BEEN_SENT' => 'Se enviaron tus invitaciones',
        'WANT_TO_INVITE_MORE' => '¿Querés invitar a más amigos? Invitá a más amigos importando los contactos de tu libreta de direcciones web o de tu aplicación de correo electrónico.',
        'MESSAGE_TOO_LONG' => 'El mensaje es demasiado largo. Reducilo a %s caracteres y volvé a intentarlo.',
        'FOLLOWING_DO_NOT_SEEM_VALID' => 'Las siguientes parecen no ser direcciones de correo electrónico válidas. No se enviaron las invitaciones. Corregí las direcciones de correo electrónico y volvé a intentarlo.',
        'PLEASE_ENTER_EMAIL_ADDRESSES' => 'Ingresá una dirección de correo electrónico o varias.',
        'ENTER_EMAIL_ADDRESSES' => 'Ingresar direcciones de correo electrónico',
        'SEPARATE_MULTIPLE_ADDRESSES' => 'Separar varias direcciones con comas',
        'YOUR_MESSAGE_OPTIONAL' => '<label>Tu mensaje</label> (Opcional)',
        'SEND_INVITATIONS' => 'Enviar invitaciones',
        'WEB_ADDRESS_BOOK' => 'Libreta de direcciones web',
        'YAHOO_MAIL_HOTMAIL' => 'Yahoo Mail, Hotmail, GMail o AOL Mail',
        'YOUR_EMAIL_ADDRESS' => 'Tu dirección de correo electrónico',
        'IMPORT_ADDRESS_BOOK' => 'Importar libreta de direcciones',
        'DONT_WORRY_WE_WONT_SAVE' => 'No te preocupes no vamos a guardar tu contraseña y vas a poder elegir a qué amigos querés enviarles un mensaje de correo electrónico.',
        'EMAIL_APPLICATION' => 'Aplicación de correo electrónico',
        'MICROSOFT_OUTLOOK_APPLE_MAIL' => 'Microsoft Outlook, Apple Mail, .CSV, etc.',
        'UPLOAD_CSV_OR_VCF' => 'Subí un archivo .csv o .vcf exportado de Microsoft Outlook o Apple Address Book.',
        'BROWSE_FOR_FILE' => 'Examinar',
        'UPLOAD' => 'Cargar',
        'SELECT_ELLIPSIS' => 'Seleccionar',
        'OTHER_ELLIPSIS' => 'otro...',
        'DONT_WORRY_YOULL_GET_CHANCE' => 'No te preocupes, vas a poder elegir a qué amigos querés enviarles un mensaje de correo electrónico.',
        'MEMBERSHIP_BY_INVITATION_ONLY' => 'Membresía sólo por invitación',
        'IF_YOU_ARE_ADMIN' => 'Si sos un administrador, <a %s>hacé clic acá para ingresar</a>.',
        'NAME_MUST_BE_SHORTER' => 'El nombre debe tener menos de %s caracteres',
        'CITY_NAME_MUST_BE_SHORTER' => 'El nombre de la ciudad debe tener menos de %s caracteres',
        'EMAIL_ALREADY_REGISTERED' => 'Esta dirección de correo electrónico ya existe. Por favor elegí otra.',
        'EMAIL_NOT_VALID' => 'Esta dirección de correo electrónico no parece ser válida.',
        'USERNAME_INVITED_YOU_TO_APPNAME' => '%s te invitó %s',
        'YOU_ARE_SIGNING_UP_WITH' => 'Estás iniciando sesión con tu ID de Ning.',
        'NOW_ENTER_PASSWORD' => 'Sólo ingresá tu contraseña para continuar.',
        'OR_SIGN_IN' => 'o <a %s>Ingresá</a>',
        'CHANGE_ADDRESS' => 'Cambiar dirección',
        'CHANGE_PAGE_ADDRESS' => 'Cambiar dirección de página',
        'PAGE_ADDRESS_TAKEN' => 'Disculpá: esa dirección ya existe. Elegí otra.',
        'PAGE_ADDRESS_NOT_VALID' => 'Solamente podés usar las letras de la A a la Z, números y guión bajo (_) para formar tu dirección.',
        'ADD_BY_PHONE' => 'Agregar por teléfono',
        'PAGE_ADDRESS' => 'Dirección de la página',
        'PHOTO_MUST_BE_TYPE' => 'Tu foto debe ser un archivo.jpg, .gif o .png.',
        'USEFUL_ADDRESSES' => 'Direcciones útiles',
        'MY_DETAILS' => 'Mis detalles',
        'NONE_I_DO_NOT_WANT' => 'Ninguno: No quiero recibir mensajes de correo electrónico de %s',
        'CHANGE_PASSWORD' => 'Cambiar contraseña',
        'PROFILE_SAVED' => 'Los cambios se guardaron correctamente.',
        'UPDATE_EMAIL_ADDRESS' => 'Actualizar tu dirección de correo electrónico',
        'EDIT_EMAIL_ADDRESS' => 'Editá tu dirección de correo electrónico',
        'MY_SETTINGS' => 'Mis configuraciones',
        'ABOUT_ME' => 'Acerca de mí',
        'SELECT' => 'Seleccionar...',
        'CITY' => 'Ciudad',
        'COUNTRY' => 'País',
        'DATE_OF_BIRTH' => 'Fecha de nacimiento',
        'DO_NOT_DISPLAY' => 'No mostrar',
        'GENDER' => 'Sexo',
        'CREATE_YOUR_PROFILE' => 'Creá tu perfil',
        'SYSTEM_REQUIREMENTS' => 'Requisitos del sistema',
        'WE_SUPPORT_INTERNET_EXPLORER' => 'Admitimos Internet Explorer 6 & 7, Firefox 2.0, y Safari 2.0. Si tu explorador (tal vez el que te ofrece tu proveedor de servicios de internet) no figura en esta lista, puede no ser compatible.',
        'MAKE_SURE_COOKIES' => 'Asegurate de que JavaScript y las cookies estén habilitados en tu explorador.',
        'WHAT_IS_MY_EMAIL' => '¿Cuál es mi dirección de correo electrónico?',
        'IF_JOINED_BEFORE_OCTOBER' => 'Si vos te uniste antes del 6 de Octubre del 2007, te podemos haber pedido que uses un "Ning ID". Ahora te pedimos que uses la dirección de correo electrónico que usaste para registrarte, sin embargo todavía podes ingresar tu Ning ID en este campo.',
        'CLICK_HERE_TO_RESET_PASSWORD' => 'Hacé clic acá para restablecer tu contraseña.',
        'STILL_HAVING_PROBLEMS' => '¿Todavía tenés problemas?',
        'VISIT_NING_HELP_CENTER' => 'Visitá el <a %s>Ning Help Center</a> para mas información y soporte.',
        'PROBLEMS_SIGNING_UP_OR_SIGNING_IN' => 'Problemas para registrarse o para iniciar sesión',
        'WE_SENT_YOU_EMAIL' => 'Te enviamos un mensaje de correo electrónico con un vínculo para cambiar tu contraseña.',
        'RESET_PASSWORD_EMAIL_SUBJECT' => 'Restablecer contraseña',
        'RESET_PASSWORD_EMAIL_BODY' => '%1$s,

recibimos un pedido de cambio de contraseña en %2$s.

Hacé clic en el vínculo ubicado más abajo para establecer una nueva contraseña:

#{URL}

Si no querés cambiar la contraseña, ignorá este mensaje.

Gracias,
El equipo de "%2$s"

-----
%2$s usa la ID de Ning para autenticación.',
        'SET_PASSWORD' => 'Cambiar contraseña',
        'NEW_PASSWORD' => 'Nueva contraseña',
        'CREATE_NEW_PASSWORD' => 'Crear nueva contraseña',
        'SET_NEW_PASSWORD' => 'Creá una nueva contraseña para tu cuenta de Ning ID.',
        'CHOOSE_NEW_PASSWORD' => 'Por favor elegí una nueva contraseña',
        'HELLO_USERNAME_SIGN_OUT' => '<strong>Hola, %s</strong> (<a %s>Cerrar sesión</a>)',
        'NO_ACCOUNT_WITH_EMAIL_X' => 'No hay una cuenta con la dirección de correo electrónico %s',
        'PLEASE_ENTER_CODE' => 'Por favor ingresá el codigo que aparece a la derecha.',
        'PROBLEMS_SIGNING_UP' => '¿Problemas para registrarte?',
        'BY_SIGNING_UP_YOU_AGREE' => 'Al registrarte, estás aceptando las <a %s>Condiciones del servicio</a> y la <a %s>Política de&nbsp;privacidad</a>.',
        'FEEDBACK' => 'Comentarios',
        'TERMS_OF_SERVICE' => 'Términos del servicio',
        'PROBLEM_SIGNING_UP' => 'Hubo un problema al registrarte',
        'ALREADY_MEMBER_SIGN_IN' => '¿Ya sos miembro? <a %s>Hacé clic acá para iniciar sesión</a>.',
        'MEMBERSHIP_TO_APPNAME_BY_INVITATION_ONLY' => 'Membresía a %s es sólo por invitación',
        'SORRY_BUT_ADMINISTRATOR_REQUIRES_INVITATION' => 'El administrador ha elegido pedir una invitación para unirte a %s. Si tenés una invitación, hacé clic en el vínculo en el mensaje de correo electrónico para unirte.',
        'PROBLEM_SIGNING_IN' => 'Hubo un problema al ingresar',
        'WE_USE_NING_ID' => 'Usamos Ning ID para autenticación. <a %s>¿Qué es un Ning ID?</a>',
        'PROBLEMS_SIGNING_IN' => '¿Problemas al iniciar sesión?',
        'SIGN_IN_OR_SIGN_UP' => '<input %s value="Iniciar sesión" /> &#160;or&#160; <strong><a %s>Registrarse</a></strong>',
        'SIGN_IN_TO_APPNAME' => 'Ingresar a %s',
        'WHAT_IS_A_NING_ID' => '¿Qué es un Ning ID?',
        'LARR_BACK' => '← <a %s>Volver</a>',
        'NING_ID_LETS_YOU_CHOOSE' => 'El sistema de autenticación mediante la ID de Ning te permite elegir una dirección de correo electrónico y una contraseña una sola vez y usarlas para unirte a cualquier red social que emplee la ID de Ning o para iniciar sesión en ella.',
        'WHEN_YOU_CREATE_NING_ID' => 'Al crear una ID de Ning, también podés agregar un conjunto de detalles básicos y tu foto a la cuenta con tu ID de Ning. Posteriormente, estos datos aparecen completos cuando te unís a una nueva red social que emplee la ID de Ning para autenticación. También te permite hacer un seguimiento de tus amigos y de los mensajes  de todas las redes sociales que acepten esta identificación.',
        'SIGN_IN_WITH_NING_ID_WHENEVER' => 'Podés iniciar sesión con la dirección de correo electrónico y contraseña de la ID de Ning cada vez que veas este símbolo: %s',
        'HELLO_USER' => 'Hola, %s',
        'TEXT_FOR_HEADER_TAB' => 'Este texto es para una ficha de encabezado.',
        'BASED_ON' => 'Basado en',
        'ARE_YOU_SURE_DELETE_LANGUAGE' => '¿Estás seguro de que querés eliminar este idioma?',
        'DELETE_LANGUAGE' => 'Eliminar idioma',
        'TEXT_RESET_TO_ORIGINAL_VERSION' => 'El texto volvió a quedar como en su versión original.',
        'UPLOAD_LANGUAGE_FILE' => 'Subir archivo de idioma.',
        'ADD_TO_LANGUAGE' => 'Agregar a idioma:',
        'IF_YOU_CREATED_TRANSLATION' => 'Si creaste una nueva traducción en otra red social de Ning, podés importar tu trabajo acá. Los contenidos del archivo se agregarán al idioma que elijas. ¿El idioma que querés no figura en la lista ? <a %s>Es fácil agregar uno nuevo</a>.',
        'EXAMPLES_SWEDISH_FINLAND' => 'Ejemplos: sueco (Finlandia), filipino, español (Puerto Rico)',
        'START_FROM_SCRATCH_CREATE' => '¡Empezá de cero! Creá una nueva traducción para tu red ingresando el nombre del idioma, luego eligiendo un idioma ya existente para usar como punto de referencia.',
        'KEY_MISSING_TEXT' => 'Clave: <span %s>Texto que falta</span> <span %s>Texto cambiado</span>',
        'SHOW_ALL_TEXT' => 'Mostrar todo el texto',
        'SHOW_MISSING_TEXT' => 'Mostrar el texto que falta',
        'SHOW_CHANGED_TEXT' => 'Mostrar el texto cambiado',
        'EXAMPLES_TABS_MEMBERS_FRIENDS' => 'Ejemplos: Fichas, Miembros, Amigos',
        'RESET_TEXT_TO_ORIGINAL_VERSION' => 'Volver a ver el texto como en la versión original',
        'ORIGINAL_TEXT_X' => 'Texto original - %s',
        'EDIT_LANGUAGE_ON_NETWORK' => 'Edita el texto de tu red',
        'CUSTOMIZE_TEXT_ON_NETWORK_INCLUDING' => 'Cambiá el texto de tu red, incluyendo los nombre de las fichas, el pie de página de los mensajes de correo electrónico, los mensajes de error, y más.',
        'ACTIVE_LANGUAGE_IS_X' => '<em>El idioma activo en tu red es %1$s</em>. <a %2$s>Cambiar idioma activo</a>',
        'CURRENT_LANGUAGE_OPTIONS' => 'Opciones actuales de idioma',
        'ACTIVE' => 'Activo',
        'MY_LANGUAGES' => 'Mis idiomas',
        'CREATE_NEW_TRANSLATION' => 'Crear una nueva traduccíón',
        'DONT_SEE_LANGUAGE_LISTED_CREATE' => '¿No ves tu idioma en la lista? <strong><a %s>Creá una nueva traducción para tu red</a></strong>.',
        'ADVANCED_IMPORT' => 'Importar (Avanzado)',
        'IF_YOU_TRANSLATED_A_LANGUAGE' => 'Si tradujiste un idioma en una red social existente, podés <strong><a %s>importar esa traducción</a></strong> y usarla en esta red.',
        'LANGUAGE_EDITOR' => 'Editor de idiomas',
        'PUBLIC' => 'Público',
        'GRANDFATHERED_PRIVACY_SETTING' => 'Tu preferencia actual de privacidad (una red pública donde quienes no son miembros pueden ver sólo ver la página de ingreso) ya no se encuentra disponible. Tu preferencia de privacidad no ha cambiado, pero si hacés cambios acá no podrás volver a la configuración actual. Sin embargo, para lograr el mismo efecto, simplemente podés seleccionar como tu preferencia una Red privada donde cualquiera puede ingresar para hacerse miembro.',
        'NO_MISSING_ITEMS' => 'No faltan elementos: esta traducción está 100%% completa. <a %s>Ver todos los elementos.</a>',
        'NO_CHANGED_ITEMS' => 'No hubo cambios.',
        'COULD_NOT_FIND_ITEMS_MATCHING' => 'Disculpá. No pudimos encontrar elementos que coincidan con <em>%s</em>. <a %s>Ver todos los elementos.</a>',
        'FILE_N' => 'Archivo %s',
        'TRANSLATION_FILE_HAS_FILENAME_LIKE' => 'Un archivo de traducción de Ning tiene un nombre de archivo como <code>en_US.txt</code>. <a %s>Más información.</a>',
        'SELECT_TRANSLATION_FILE' => 'Elegir archivo de traducción:',
        'USE_THIS_TRANSLATION' => 'Usar esta traducción',
        'FOLLOWING_ARE_MISSING_FROM_RULES' => 'Tené en cuenta que lo siguiente falta de las reglas indicadas a continuación: %s',
        'ALL' => 'Todos',
        'MISSING' => 'Faltan',
        'VIEW' => 'Vista',
        'TRANSLATION_CHANGES_SAVED' => 'Tus cambios se guardaron. Esta traducción está %s%% completa.',
        'TRANSLATION_CHANGES_SAVED_MAKE_CURRENT' => 'Tus cambios se guardaron. Esta traducción está %s%% completa. ¿Querés usar este como el idioma actual de tu red?',
        'TRANSLATION_UPLOAD_SUCCESSFUL' => 'La operación fue un éxito. Esta traducción está %s%% completa.',
        'TRANSLATION_UPLOAD_SUCCESSFUL_MAKE_CURRENT' => 'La operación fue un éxito. Esta traducción está %s%% completa. ¿Querés usar este como el idioma actual de tu red?',
        'X_IS_CURRENT_LANGUAGE' => '%s es la nueva traducción en uso en tu red.',
        'SAVE_PAGE' => 'Guardar cambios',
        'LANGUAGE_NAME_TAKEN' => 'Ese nombre ya existe. Por favor, elegí otro.',
        'ENTER_NAME_FOR_TRANSLATION' => 'Ingresá un nombre para tu nueva traducción, por ej., portugués (Portugal)',
        'CREATE' => 'Crear',
        'LANGUAGE_NAME' => 'Nombre del idioma',
        'SAVE_ITEMS_ON_PAGE' => 'Guardar los elementos de esta página',
        'NEW_TRANSLATION' => 'Nueva traducción',
        'MISMATCHED_CURLY_BRACKETS' => 'Los paréntesis en forma de llave no coinciden.',
        'MISMATCHED_SQUARE_BRACKETS' => 'Los corchetes no coinciden',
        'MISMATCHED_PARENTHESES' => 'Los parentesis no coinciden',
        'ERROR_PROCESSING_SPECIAL_RULES' => 'Se produjo un error al procesar el código de reglas especiales.',
        'ERROR_PROCESSING_TAB_NAMES' => 'Se produjo un error al procesar el código de nombres de fichas.',
        'SPECIAL_RULES' => 'Reglas especiales',
        'TAB_NAMES' => 'Nombres de fichas',
        'SOURCE' => 'Original',
        'LANGUAGE_EDITOR_X' => 'Editor de idiomas: %s',
        'BACK_TO_LANGUAGE_EDITOR' => '← Volver al editor de idiomas',
        'CUSTOMIZE_YOUR_NETWORKS_TEXT' => 'Modificá el texto y los mensajes de tu red, o creá un nuevo idioma.',
        'STOPWORDS' => 'a | acerca de | un | son | como | en | ser | por | com | de | en | para | de | cómo | yo | sos | es | eso | la | de | sobre | o | aquello | el | esto | hacia | era | qué | cuándo | dónde | quién | va a | con | y | el | www | acerca | de | un | la | el | los | las | te',
        'STOPWORDS_ARE' => '<a %s>Stopwords</a> son una lista opcional de palabras para filtrar de la descripción de la red cuando se crea la meta etiqueta en la parte superior de la página para los buscadores de internet. (Opcional)',
        'I_AM_MEMBER' => 'Soy miembro de:',
        'VIEW_PAGE_ON_APPNAME' => 'Ver mi página en <em>%s</em>',
        'VISIT_APPNAME' => 'Andá a <em>%s</em>',
        'JOIN_US' => 'Unite',
        'CREATED_BY_COLON' => 'Creada por:',
        'GET_MORE_BADGES' => 'Más insignias',
        'SHOW_LOGO' => 'Mostrar logotipo',
        'GALLERY' => 'Galería',
        'BADGES' => 'Insignias',
        'MEMBER_BADGE' => 'Insignia de miembro',
        'WEAR_IT_WITH_PRIDE' => '¡Usala con orgullo! Conseguí una insignia de miembro de %s que podrás mostrar en tu sitio web o en la página de MySpace.',
        'NETWORK_BADGE_LARGE' => 'Insignia de red (Grande)',
        'SPREAD_THE_WORD_NETWORK_BADGE_LARGE' => '¡Contale a todo el mundo! Conseguí una insignia de %s que se actualiza en forma dinámica con los miembros más populares, y agregala a tu sitio web o a tu página MySpace.',
        'NETWORK_BADGE_SMALL' => 'Insignia de red (Chica)',
        'SPREAD_THE_WORD_NETWORK_BADGE_SMALL' => '¡Contale a todo el mundo! Conseguí una insignia de %s que podés agregar a tu sitio web o a tu página MySpace.',
        'PHOTO_SLIDESHOW_PROPER' => 'Presentación de fotos',
        'DISPLAY_SELECTION_OF_PHOTOS' => 'Mostrá una selección de tus fotos en un sitio web o página de MySpace con nuestro reproductor de fotos.',
        'MUSIC_PLAYER' => 'Reproductor de música',
        'PLAY_MUSIC_ON_WEBSITE' => 'Poné tu música en tu sitio web o en tu página MySpace.',
        'ADD_A_VIDEO_MORE_OPTIONS' => 'Agregá un video a tu sitio web o a tu página MySpace. ¿Querés más opciones? <a href="%s">Ver todos los videos</a> en %s.',
        'LARGE_N_PIXELS_WIDE' => 'Grande - %d píxeles de ancho',
        'MEDIUM_N_PIXELS_WIDE' => 'Mediano - %d píxeles de ancho',
        'SMALL_N_PIXELS_WIDE' => 'Chico - %d píxeles de ancho',
        'MY_MOST_RECENT' => 'Mis más recientes',
        'APP_ICON' => 'Icono de aplicación',
        'MEMBERSHIP_TO_X_IS_BY_INVITATION' => 'La membresía a %s es sólo por invitación',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK' => '%s hizo el siguiente comentario:',
        'X_PROVIDED_FEEDBACK_ON_Y_ELLIPSIS' => '%1$s hizo un comentario sobre %2$s...',
        'THANK_YOU_YOUR_MESSAGE_HAS_BEEN_SENT' => 'Gracias.  Tu mensaje se envió.',
        'X_WOULD_LIKE_TO_JOIN_X' => '%s quiere unirse a %s!',
        'X_HAS_REQUESTED_AN_INVITATION' => '%s pidió una invitación a %s',
        'YOUR_REQUEST_HAS_BEEN_SENT' => 'Tu pedido se envió al creador de la red.',
        'TO_UNBAN_USERNAME_GO_TO' => 'Para admitir %s, entrá en:',
        'SEND_REQUEST' => 'Enviar pedido',
        'SEARCH' => 'Buscar',
        'SEARCH_AGAIN' => 'Buscar de nuevo',
        'SEND_BROADCAST_MESSAGE' => 'Mandar un mensaje a todos los miembros',
        'VERIFICATION_IMAGE' => 'Imagen de verificación',
        'UNDER_CONSTRUCTION' => 'En construcción',
        'PROFILE_INFORMATION_SAVED' => 'Información del perfil guardada',
        'YOUR_SITES_DIRECTORY_PROFILE' => 'La información del directorio de perfiles de tu red social se guardó.',
        'NO_ACCOUNT_WITH_EMAIL' => 'No hay ninguna cuenta con esa dirección de correo electrónico.',
        'INVALID_PASSWORD_CHECK_CAPS_LOCK' => 'Contraseña incorrecta. ¿Estás escribiendo en mayúsculas?',
        'OOPS_THAT' => '¡Qué pena! Eso no funcionó.',
        'OOPS_THAT_DID_NOT_WORK' => '¡Qué pena! Eso no funcionó. ¿Querés intentar de nuevo?',
        'OOPS_THAT_DID_NOT_WORK_ERROR_CODE' => '¡Qué pena! Eso no funcionó (%s).',
        'NOT_FOUND' => 'No se encontró',
        'YOUR_SITES_FEATURE_LIST' => 'Se guardó el listado de las aplicaciones de tu red.',
        'ONE_LINE_ANSWER' => 'Respuesta de una linea',
        'LONGER_ANSWER' => 'Respuesta más larga',
        'MULTIPLE_CHOICE' => 'Multiple choice',
        'DATE' => 'Fecha',
        'WEBSITE_ADDRESS' => 'Dirección de sitio web',
        'EVERYTHING' => 'Todo',
        'JUST_THE_HOMEPAGE' => 'Sólo la página principal',
        'JUST_THE_SIGN_UP_PAGE' => 'Sólo la página de inicio de sesión',
        'YOUR_CHANGES_HAVE_BEEN_SAVED' => 'Se guardaron tus cambios.',
        'JOIN_ME_ON_X' => 'Unite a mí en %s!',
        'NOT_ALLOWED' => 'No está permitido',
        'COME_JOIN_ME_ON_X' => 'Vení y uníte a %s!',
        'COME_JOIN_ME_ON_X_ELLIPSIS' => 'Nos vemos en %s.',
        'X_NOT_VALID_EMAIL' => '%s no es una dirección de correo electrónico ni un Ning ID válido',
        'USER_BANNED_FROM_NETWORK' => '%1$s tiene prohibido acceder a esta red. <a %2$s>Enviale un mensaje a %1$s</a>',
        'USER_ALREADY_NETWORK_MEMBER' => '%1$s Ya es un miembro de esta red. <a %2$s>Enviale un mensaje a %1$s</a>',
        'YOU_CAN_SEND_AT_MOST_X' => 'Podés enviar como máximo %s al mismo tiempo.',
        'PLEASE_ENTER_YOUR_FRIENDS' => 'Por favor ingresá las direcciones de correo electrónico de tus amigos o sus ID',
        'THERE_HAS_BEEN_AN_ERROR' => 'Se produjo un error',
        'INVITATIONS_HAVE_BEEN_SENT' => 'Tu invitación se envió.',
        'SEARCH_RESULTS' => 'Resultados de la búsqueda',
        'INVITE_YOUR_FRIENDS' => 'Invitá a tus amigos',
        'SEND_INVITATIONS_FOR_FRIENDS' => '¡Enviá invitaciones a tus amigos para que se unan a',
        'INVITATION' => 'Invitación',
        'ADD_FROM_ADDRESS' => 'Agregar desde una libreta de direcciones',
        'TO' => 'Para:',
        'SEND_TO' => 'Enviado a',
        'SUBJECT' => 'Asunto',
        'YOUR_MESSAGE' => 'Tu mensaje',
        'SEND' => 'Enviar',
        'REPORT_AN_ISSUE' => 'Informar acerca de un problema',
        'TYPE_OF_ISSUE' => 'Tipo de problema',
        'ADULT' => 'Adulto',
        'ABUSIVE' => 'Abusivo',
        'BUG' => 'Error',
        'FRAUD' => 'Fraude',
        'SPAM' => 'Spam',
        'OTHER' => 'Otros',
        'DESCRIBE_YOUR_ISSUE' => 'Describí tu problema',
        'SEND_REPORT' => 'Enviar un informe',
        'ADDED_BY_X_AT_X' => 'Agregado por <a %s>%s</a> a %s en %s',
        'ADDED_BY_USER_TO_GROUP_AT_DATE' => 'Agregado por <a %s>%s</a> a %s en %s en la fecha %s',
        'G_IA' => 'g:ia',
        'F_JS_Y' => 'F jS, Y',
        'CLICK_TO_VIEW' => 'Hacé clic para ver',
        'COMMENT_FOR' => 'Comentario para:',
        'COMMENT_ON' => 'Comentario en:',
        'ACTION_BUTTON_FEATURE' => 'Publicación',
        'FEATURE_THIS_ON_YOUR' => 'Publicá esto en tu página principal',
        'ACTION_BUTTON_REMOVE' => 'Eliminar',
        'REMOVE' => 'Eliminar',
        'REMOVE_THIS_FROM_YOUR' => 'Sacar esto de la página principal',
        'FEATURE_ON_HOME' => 'Publicá esto en la página principal',
        'REMOVE_FROM_HOME' => 'Sacar de la página principal',
        'ITEM_WILL_APPEAR' => 'Este elemento ahora aparecerá en los módulos seleccionados de la página principal',
        'ITEM_WILL_NO_LONGER_APPEAR' => 'Este elemento no aparecerá más en los módulos seleccionados de la página principal',
        'ADD_CONTENT' => 'Agregar contenido',
        'BROUGHT_TO_YOU_BY' => '%s © %s te ofrece %s',
        'GIVE_US_YOUR_FEEDBACK' => 'Envianos tus comentarios',
        'FOR_ADDITIONAL_QUESTIONS_OR_TO_CONTACT_NING_PLEASE_CLICK_HERE' => 'Si tenés más preguntas o si querés comunicarte con Ning, hacé clic acá:',
        'SEND_FEEDBACK' => 'Enviar comentarios',
        'SIGN_OUT' => 'cerrar sesión',
        'SIGN_OUT_TITLE' => 'Cerrar sesión',
        'EDIT_MY_PROFILE' => 'Editar Mi perfil',
        'INVITE_MORE' => 'Invitar más',
        'USE_THIS_FORM_TO_SEND_FEEDBACK_TO_NC' => 'Usá este formulario para enviar comentarios a <a %s>%s</a>, el creador de <a %s>%s</a>.',
        'YOUR_FEEDBACK' => 'Tus comentarios',
        'NETWORK_INFORMATION' => 'Información de la red',
        'ABOUT_YOUR_SITE' => 'Acerca de tu red',
        'WELCOME_TO_YOUR_SITE' => '¡Bienvenido a tu red social!',
        'EDIT_YOUR_NETWORKS_INFO' => 'Editá el nombre de tu red, la descripción, y otra información.',
        'TAGLINE' => 'Tagline',
        'APPEARS_IN_HEADER' => 'Aparece en el encabezado de tu red',
        'APPEARS_IN_EMAILS' => 'Aparece en los mensajes de correo electrónico  y en todos lados',
        'NETWORK_NAME' => 'Nombre de la red',
        'DESCRIPTION' => 'Descripción',
        'KEYWORDS' => 'Palabras clave',
        'LANGUAGE' => 'Idioma',
        'SEPARATE_EACH_KEYWORD' => 'Separar cada palabra clave con una coma',
        'ICON' => 'Icono',
        'UPLOAD_A_PHOTO_WHICH_WILL_BE_RESIZED' => 'Podés subir una foto (GIF, JPG o PNG), que será modificada para entrar en un cuadrado (si es que esto no está hecho aún). ¡Tardará unos minutos antes de que se vea tu nueva foto!',
        'SAVE_SETTINGS' => 'Guardar configuración',
        'SUCCESS_EXCLAMATION' => 'Operación exitosa',
        'FEATURES' => 'Características',
        'ADD_FEATURES' => 'Agregá aplicaciones a tu red',
        'ORGANIZE_FEATURES' => 'Organizá tu página principal moviendo las aplicaciones de la lista hacia el área que representa la página, y moviéndolas hasta que queden en la ubicación deseada.',
        'SKIP_FEATURES' => 'Hacé clic en <a href="%s">Saltear este paso</a> para continuar con la organización y aplicaciones predeterminadas.',
        'FEATURES_FOR_ALL_PAGES' => 'Las aplicaciones agregadas en este recuadro aparecerán en todas las páginas de la red.',
        'CUSTOMIZE_SITE_BY_ADDING' => 'Personalizá tu red social agregándole nuevas aplicaciones o sacando las existentes.',
        'ADJUST_YOUR_SITES_COLORS' => 'Ajustá los colores, las imágenes y el estilo en general de tu red social.',
        'APPEARANCE' => 'Apariencia',
        'PROFILE_QUESTIONS' => 'Preguntas del perfil',
        'EDIT_QUESTIONS_THAT_MEMBERS_ANSWER' => 'Editá las preguntas que los miembros responden sobre sí mismos.',
        'MESSAGE_SENT' => '¡Mensaje enviado!',
        'YOUR_MESSAGE_HAS_BEEN_SENT' => 'Tu mensaje se envió a todos los miembros de tu red.',
        'YOUR_MESSAGE_HAS_BEEN_SENT_GROUP' => 'Tu mensaje se envió a todos los miembros de tu grupo.',
        'YOUR_MESSAGE_IS_BEING_SENT' => 'Tu mensaje se está enviando. Por favor esperá, esto puede tardar unos minutos.',
        'BROADCAST_MESSAGE' => 'Mensaje de difusión',
        'TRACK_VISITORS_AND_TRENDS' => 'Sabé quienes son los visitantes y cuáles son las tendencias de tu red social.',
        'EDIT_SOURCE_CODE' => 'Editar el código fuente',
        'TAKE_FULL_CONTROL' => 'Controlá totalmente la funcionalidad de tu red editando el código fuente.',
        'DELETE_THIS_SITE' => 'Eliminar tu red social',
        'MAIN_PAGE' => 'Página principal',
        'MAIN' => 'Principal',
        'MAIN_TAB_TEXT' => 'Principal',
        'MANAGE' => 'Administrar',
        'MANAGE_TAB_TEXT' => 'Administrar',
        'PAGE_TITLE' => 'Título de la página',
        'LOREM_IPSUM_1' => 'Lorem <span %s>ipsum dolor</span> sit amet, consectetuer adipiscing elit. Nunc scelerisque blandit dolor. Vestibulum ante ipsum primis in faucibus orci luctus.',
        'LOREM_IPSUM_2' => 'Lorem ipsum dolor sit amet, consectetuer adipiscing',
        'LOREM_IPSUM_3' => 'Lorem ipsum dolor sit amet, <span class="preview_link">consectetuer</span> adipiscing',
        'EDIT_THE_APPEARANCE' => 'Editá la apariencia de tu página',
        'CHOOSE_A_THEME' => 'Elegí un tema para tu red social',
        'NOW_CUSTOMIZE_SITE' => 'Ahora personalizá tu red social...',
        'THEME_SETTINGS' => 'Configuración de tema',
        'ADVANCED' => 'Avanzado',
        'TOP_BAR_AND_FOOTER' => 'Encabezado y pie de página',
        'HEADER_AND_NAVIGATION' => 'Encabezado y navegación',
        'ADD_A_LOGO' => 'Agregá un logotipo',
        'THIS_IMAGE_WILL_REPLACE' => 'Esta Imagen reemplazará el texto con el nombre de la red',
        'TABS' => 'Fichas',
        'TAB' => 'Ficha',
        'SITE' => 'Red',
        'SIDES' => 'Laterales',
        'BODY' => 'Cuerpo',
        'SHOW_NING_LOGO' => '¿Mostrar el logotipo de Ning?',
        'LAUNCH' => '¡INICIAR!',
        'NING_ID' => 'Ning ID',
        'PASSWORD' => 'Contraseña',
        'RETYPE_PASSWORD' => 'Volvé a escribir la contraseña',
        'TYPE_CODE_ON_RIGHT' => 'Escribí el código<br />que aparece a la derecha',
        'JOIN_X' => 'Unite a %s',
        'SIGN_UP_FOR_X' => 'Registrate para %s',
        'HAS_INVITED_YOU_TO_X' => 'te invitó a que te unas a la %s.',
        'CONTENT_AWAITING_APPROVAL' => 'Contenido que espera aprobación',
        'NEW_MEMBER' => '¿Nuevo miembro?',
        'JOIN_X_NOW' => '¡Unite a %s ahora!',
        'HIDE_THIS_MESSAGE' => 'Ocultar este mensaje',
        'PAGE_NOT_FOUND' => 'No se encontró la pagina',
        'THIS_PAGE_WAS_NOT_FOUND' => 'Disculpá: esta página no se pudo encontrar',
        'FOLLOW_THESE_LINKS_TO' => 'Seguís estos vínculos a algunas cosas que sabemos que están disponibles:',
        'ALTERNATIVELY_YOU_CAN_SEARCH' => 'Como alternativa, podés buscar en esta red social:',
        'IF_YOU_GET_THIS_MESSAGE' => 'Si te aparece este mensaje nuevamente, <a %s>por favor avisanos.</a>',
        'GROUP_MEMBERS' => 'Miembros del grupo',
        'VIDEOS' => 'Videos',
        'BLOG' => 'Blog',
        'ACCOUNT' => 'Cuenta',
        'WE_ARE_SORRY_WE_ARE_HAVING' => 'Disculpá, tenemos un problema con esta página.',
        'FOLLOW_LINK_TO_HOMEPAGE' => 'Seguí <a %s>este vínculo</a> a la página principal.',
        'REQUEST_AN_INVITATION' => 'Pedir una invitación',
        'NAME' => 'Nombre',
        'EMAIL_ADDRESS' => 'Dirección de correo electrónico',
        'MESSAGE_OPTIONAL' => 'Mensaje (Opcional)',
        'SORRY_HOWEVER_ITS_EASY' => '<strong>¡Disculpá!</strong>  De todas maneras, es fácil comenzar tu propia red social.',
        'GET_YOUR_OWN_BAZEL' => '¡Crea tu propia red social!',
        'SITE_IS_NOT_READY' => '¡Esta red social todavía no está lista!',
        'BAZEL_IS_BEING_SET_UP' => '¡Esta red social todavía se está configurando!',
        'SIGN_IN' => 'Iniciar sesión',
        'FORGOT_YOUR_PASSWORD' => '¿Olvidaste tu contraseña?',
        'FORGOT_YOUR_PASSWORD_TITLE' => '¿Olvidaste tu contraseña?',
        'ENTER_EMAIL_AND_CLICK_RESET_PASSWORD' => 'Ingresá tu dirección de correo electrónico y hacé clic en \'Pedir cambio de contraseña\'. Recibirás un mensaje de correo electrónico con un vínculo para cambiarla.',
        'RESET_PASSWORD' => 'Pedir cambio de contraseña',
        'EXPLORE' => 'Explorá',
        'SIGN_UP' => 'Unite',
        'CONFIRM_PASSWORD' => 'Confirmar contraseña',
        'VERIFICATION' => 'Demostranos que no sos <br />un robot',
        'YOUR_PHOTO' => 'Tu foto',
        'SUMMARY' => 'Resumen',
        'YOUR_SITE_IS_READY' => '¡Tu red social está lista para iniciarse! La configuración básica será usada para los pasos que te salteaste. Volvé atrás para hacer cambios, o hacé clic en  \'¡Iniciar!\' para iniciar tu red.',
        'WHEN_YOU_ARE_FINISHED' => '¡Cuando termines, hacé clic en \'Ver diseño\' para ver los resultados!',
        'COMPLETE' => 'completo',
        'INCOMPLETE' => 'incompleto',
        'VIEW_LAYOUT' => 'Ver diseño',
        'CLEAR_CONTENTS' => 'Borrar contenido',
        'ADD_MODULE' => 'Agregar módulo...',
        'ADD_COLUMNS' => 'Agregar columnas...',
        'PUBLIC_ANYBODY_CAN_JOIN' => '<strong>Pública</strong>: cualquiera puede unirse',
        'PRIVATE_ONLY_INVITED' => '<strong>Privada</strong>: solamente las personas que han sido invitadas pueden unirse',
        'INVITATIONS' => 'Invitaciones',
        'MEMBERS_CAN_INVITE' => 'Los miembros pueden invitar a otros a unirse.',
        'QUESTION_TITLE' => 'Título de la pregunta',
        'ANSWER_TYPE' => 'Tipo de respuesta',
        'REQUIRED' => '¿Obligatorio?',
        'PRIVATE' => 'Número privado',
        'CHOICES' => 'Opciones',
        'SEPARATE_EACH_CHOICE' => 'Separá cada elección con una coma',
        'CAN_PICK_MORE' => 'Podés elegir más de una',
        'ADD_ANOTHER_QUESTION' => 'Agregá otra pregunta',
        'WHAT_INFORMATION' => '¿Que preguntas te gustaría que los miembros respondieran cuando se unan a tu red? Podés reordenar las preguntas. Simplemente parate sobre la pregunta, y arrastrala a donde querés que aparezca.',
        'IF_YOU_SELECT_REQUIRED_MEMBERS_WILL' => 'Si elegís "Obligatorias," los miembros tendrán que contestar las preguntas para unirse. Si elegís "Privada," la respuesta sólo será visible para vos y otros administradores.',
        'WE_COULD_NOT_FIND_ANYTHING' => 'No pudimos encontrar nada que coincida con "%s". ¿Por qué no buscas otra cosa?',
        'GET_CUSTOM_URL' => 'Usá tu propia URL personalizada, agregá espacio en disco y ancho de banda, o usá tus propios anuncios.',
        'TRACK_STATISTICS' => 'Mantener estadísticas',
        'TRACKING_CODE' => 'Código de seguimiento',
        'ANY_JAVASCRIPT_CODE' => 'Cualquier código Javascript que pegues aquí se inserta al final de cada página de tu red. Esto se puede usar para sistemas de seguimiento externos, como Google Analytics.',
        'ANALYTICS_LEARN_MORE' => 'Para saber más sobre Google Analytics, <a %s>hacé clic acá</a>.',
        'RESOURCES' => 'Recursos',
        'LINKS' => 'Vínculos',
        'PAGE' => 'Páginas',
        'BACKGROUND' => 'Fondo',
        'TEXT' => 'Texto',
        'HEADING_TEXT' => 'Texto de encabezado',
        'FONT' => 'Fuente',
        'AABBCC' => 'AaBbCc',
        'COLOR' => 'Color',
        'LINK_COLOR' => 'Color de los vínculos',
        'BODY_TEXT' => 'Texto del cuerpo',
        'MIDDLE' => 'Centro',
        'FEATURE_BOXES' => 'Recuadros destacados',
        'TITLEBAR_TEXT_COLOR' => 'Color del texto del encabezado',
        'TITLEBAR_BACKGROUND' => 'Fondo del encabezado',
        'UPLOADING_CONTENT' => 'Subiendo contenido...',
        'WHEN_UPLOADING_IS_COMPLETE' => 'Cuando la carga se complete, podrás echarle un vistazo a la red.',
        'FINISH' => 'Finalizar',
        'FLICKR_IMPORT_SETUP' => 'Instalación para importar de Flickr',
        'FLICKR_API_KEY' => 'Tu clave',
        'FLICKR_SECRET' => 'Tu secreto',
        'FLICKR_KEY_ERROR' => 'Hubo un problema con la clave o el secreto de Flickr que ingresaste. ¿Podés corroborarlos y tratar de ingresar de nuevo?',
        'FLICKR_INTRO' => '¿Querés dejar que los miembros importen sus fotos de Flickr? Llegaste al lugar correcto. Si ya tenes una clave y un secreto en Flickr, podés  <a %s>saltear este paso</a>. ¿No estás muy seguro de lo que esto significa? Sólo seguí los pasos a continuación y en un par de minutos estarás listo.',
        'FLICKR_GET_ACCOUNT' => 'Si no tenés una cuenta de Flickr, creala <a %s>acá</a>.',
        'FLICKR_STEP1_TITLE' => 'Paso 1: Conseguir una clave Flickr API',
        'FLICKR_STEP1_APPLY_SCREEN' => 'Página en Flickr para obtener la clave  API',
        'FLICKR_STEP1_API_SCREEN' => 'Página en Flickr para pedir una clave API',
        'FLICKR_STEP1_INTRO' => 'Ingresá a Flickr y <a %s>pedí una nueva clave API </a> (el vínculo abre una nueva ventana).',
        'FLICKR_STEP1_A' => 'Completá <strong>Tu nombre</strong> y <strong>Dirección de correo electrónico</strong>.',
        'FLICKR_STEP1_B' => 'En el campo <strong>Esta clave es para&hellip;</strong> elegí la opción <em>uso no comercial</em>.',
        'FLICKR_STEP1_C' => 'Describí tu red social en el campo <strong>Describí la aplicación que tenés pensado armar</strong>.',
        'FLICKR_STEP1_D' => 'Marcá ambos tildes para aceptar los términos de uso.',
        'FLICKR_STEP1_APPLY' => 'Cuando termines, hacé clic en el botón <strong>Apply</strong>.',
        'FLICKR_STEP1_E' => 'Llegarás a una página que muestra tu clave API. Hacé clic en el vínculo <strong>Hacer clic acá</strong> para configurar la autenticación para esta clave.',
        'FLICKR_STEP2_TITLE' => 'Paso 2: Configurá tu clave',
        'FLICKR_STEP2_SETUP_SCREEN' => 'Página en Flickr de Instalación de la autenticación de la clave API',
        'FLICKR_STEP2_F' => 'Pegá la siguiente dirección web en el campo <strong>URL de devolución de llamada</strong>:',
        'FLICKR_STEP2_SAVE_CHANGES' => 'Cuando termines, hacé clic en el botón <strong>Guardar cambios</strong>.',
        'FLICKR_STEP3_TITLE' => 'Paso 3: Ingresá tu información',
        'FLICKR_STEP3_KEYS_SCREEN' => 'Página en Flickr: Información de clave API',
        'FLICKR_STEP3_CONGRATULATIONS' => 'Tu configuración de Flickr está lista.',
        'FLICKR_STEP3_COMPLETE' => 'Para completar la configuración en tu red %s, copiá y pegá tu clave API y tu secreto en los siguientes campos:',
        'COMPLETE_SETUP' => 'Instalación completa',
        'SETUP_YOUR_SITE_TO' => 'Instalá tu red social para importar fotos desde Flickr.',
        'FLICKR_IMPORTING' => 'Importar desde Flickr',
        'YOU_NEED_TO_SET_UP_FLICKR' => 'Tenés que configurar tu red social para que la gente pueda importar sus fotos desde Flickr. Sólo te llevará unos minutos, así que ¿por qué <a %s> no lo hacés ahora?</a>',
        'DONT_SHOW_THIS_AGAIN_FLICKR' => 'Por favor no volver a mostrarme esto.',
        'YOUVE_SIGNED_OUT_OF_X' => 'Cerraste la sesión de %s sin problemas. ¡Volvé a reunirte con nosotros pronto!',
        'CREATED_THIS_SOCIAL_NETWORK' => 'creó una red social en <a href=\'http://www.ning.com\'>Ning</a>.',
        'CREATE_YOUR_OWN' => '¡Creá tu propia red social en Ning gratis!',
        'DRAG_HERE_TO_REMOVE_FEATURE' => 'Arrastrar aquí para eliminar la aplicación',
        'LAYOUT' => 'Organización',
        'DRAG' => 'Arrastrá',
        'HERE' => 'Acá',
        'YOU' => 'Tu',
        'ADS' => 'Avisos',
        'MEMBERS' => 'Miembros',
        'HELLO_USERNAME' => 'Hola, usuario',
        'CREATED_BY' => 'Creada por',
        'SAVE_FEATURES' => 'Guardar aplicaciones',
        'FORUM' => 'Foro',
        'CATEGORIES' => 'Categorías',
        'FORUM_CATEGORIES' => 'Categorías de foros',
        'A_THREADED_DISCUSSION_FORUM' => 'Un foro de discusión',
        'ALLOW_MEMBERS_TO_CREATE_GROUPS' => 'Permite que los miembros creen sus propios grupos de interés en tu red',
        'FEATURE_POSTS_FROM_YOUR_BLOG' => 'Marcá publicaciones como destacadas en tu blog o en los blogs de otros miembros',
        'TEXT_BOX' => 'Cuadro de texto',
        'PUT_ANY_TEXT_WIDGET_OR_HTML' => 'Poné cualquier texto o código HTML o widget en la página principal',
        'A_LIST_OF_MEMBERS' => 'Una lista de los miembros más populares de tu red social',
        'ALLOW_USERS_PHOTOS' => 'Permitiles a las personas que suban y compartan fotos',
        'ADD_FEEDS_FROM_ACROSS_THE_WEB' => 'Agregá noticias de otros sitios de Internet',
        'INFORMATION_ABOUT_THE_USER' => 'Información sobre las personas que se encuentran conectadas en este momento',
        'ALLOW_USERS_VIDEOS' => 'Permití que las personas agreguen y compartan videos',
        'SHOW_NETWORK_DESCRIPTION' => 'Mostrá la descripción de tu red',
        'PROMOTE_NETWORK_WITH_BADGES' => 'Promové tu red a través de Internet con Insignias y Widgets',
        'MONETIZE_WITH_ADS' => 'Hacé dinero en tu red publicando avisos',
        'LET_MEMBERS_KNOW_WHO_CREATED_NETWORK' => 'Dejá que los miembros sepan quién creó esta red',
        'FOLLOW_LATEST_ACTIVITY' => 'Seguí la actividad más reciente en tu red',
        'FAQ_FOR_NETWORK_CREATORS' => 'Preguntas frecuentes para creadores de redes',
        'ANSWERS_TO_FAQS' => 'Respuestas a preguntas frecuentes para modificar tu red social.',
        'MEET_OTHER_LIKEMINDED' => 'Conocé a otros creadores de redes como vos, compartí ideas y obtené soporte técnico del grupo de Ning.',
        'CUSTOMIZE_THE_APPEARANCE_NETWORK' => 'Modificá la apariencia de tu red social agregando tu propio estilo de hojas de estilo en cascada (CSS) en el campo de la izquierda. (<a href="%s">¿Qué es una CSS?</a>)',
        'CUSTOMIZE_THE_APPEARANCE_PAGE' => 'Personalizá el aspecto de tu página agregando tus propias hojas de estilos en cascada (CSS) en el campo de la izquierda. (<a href="%s">¿Qué es una CSS?</a>)',
        'CSS_ON_YOUR_SOCIAL_NETWORK' => 'CSS en tu red social',
        'CSS_ON_YOUR_PAGE' => 'CSS en tu página',
        'ADDING_YOUR_OWN_CSS_NETWORK' => 'Agregar tu propia CSS te dará un control total de las fuentes, los colores, el espaciado y el estilo general de tu red.',
        'ADDING_YOUR_OWN_CSS_PAGE' => 'Agregarle a tu página tu propia CSS te permite un control absoluto sobre las fuentes, los colores, el espaciado y el estilo de la página en general.',
        'CSS_STYLES_WILL_OVERRIDE' => 'El estilo de CSS que agregues acá eliminará cualquier estilo de CSS que hayas elegido anteriormente.',
        'NEED_HELP_FIGURING_OUT_CSS' => 'Necesitás ayuda para saber cuál es la clase específica de CSS en tu red? Te recomendamos la característica "Inspect" de la extensión <a href="%s">Firebug</a> gratuita (para el explorador Firefox ).',
        'WANT_TO_LEARN_MORE' => '¿Querés aprender más? Mirá nuestra sección de <a href="%s">Personalización avanzada</a> .',
        'APPLY_XS_THEME' => 'Aplicar el tema de %s',
        'X_ALREADY_REGISTERED_Y_TO_RESET' => 'El Ning ID registrado con la dirección de correo electrónico %s ya existe. Utilizá este formulario para acceder con tu Ning ID o tu correo electrónico. Si olvidaste tu clave, <a href="%s">hacé clic acá para recibir una nueva</a>.',
        'INVITED' => 'Invitado',
        'REQUESTED_INVITE' => 'Pidió invitación',
        'BAN_FROM_NETWORK' => 'No admitir en la red',
        'REMOVE_BAN' => 'Admitir nuevamente',
        'CANCEL_INVITATION' => 'Cancelar invitación',
        'IGNORE' => 'Rechazar',
        'PROMOTE_TO_ADMINISTRATOR' => 'Dar privilegios de administrador',
        'DEMOTE_FROM_ADMINISTRATOR' => 'Quitar privilegios de administrador',
        'STATUS' => 'Estado',
        'DATE_JOINED' => 'Fecha en que se unió',
        'DATE_INVITED' => 'Fecha en que fue invitado',
        'DATE_REQUESTED' => 'Fecha de pedido',
        'DATE_APPLIED' => 'Fecha de aplicación',
        'NETWORK_CREATOR' => 'Creador de la red',
        'NETWORK_ADMINISTRATOR' => 'Administrador',
        'ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Los administradores tienen un nivel similar de control al creador de la red.',
        'DOWNLOAD_ALL_MEMBER_DATA' => 'Exportar datos de todos los miembros (.CSV)',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Los datos de los miembros se exportaron.  Hacé clic con el botón secundario del mouse en <a %s>este enlace</a> y elegí \'Guardar como\' para poder guardarlos en tu escritorio.',
        'CLICK_GO_TO_START_EXPORT' => 'Hacé clic en Ir a para comenzar la exportación.  Si tenés muchos miembros, el proceso puede tardar unos minutos.',
        'MEMBER' => 'Miembro',
        'INVITED_BY_X' => 'Invitado por %s',
        'DONE' => 'Listo',
        'YOU_HAVE_BEEN_BANNED_FROM_APPNAME' => 'No puedes acceder a %s',
        'MESSAGE_TO_ADMINISTRATOR' => 'Mensaje al administrador',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS_IF_YOU_THINK' => 'Lamentablemente, no estás admitido para ingresar en %s. Si pensás que esto es un error, ponete en contacto con el administrador.',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS' => 'Lamentablemente, no estás admitido para ingresar en %s.',
        'SORRY_USERNAME' => 'Hubo un problema, %s',
        'PENDING' => 'Pendiente',
        'ACCEPT' => 'Aceptar',
        'PENDING_APPROVAL' => 'Aprobación pendiente',
        'ACCEPT_MEMBERSHIP' => 'Aceptar membresía',
        'DECLINE_MEMBERSHIP' => 'Negar membresía',
        'NO_PAGE_YET' => 'Todavía no hay página',
        'YOUR_MEMBERSHIP_TO_X_IS_PENDING_APPROVAL' => 'Tu membresía a %s debe ser aprobada por los administradores.',
        'MEMBERSHIP_PENDING_APPROVAL' => 'Membresía pendiente de aprobación',
        'YOUR_PROFILE_IS_PENDING_APPROVAL' => 'Tu Membresía esta pendiente',
        'YOUR_PROFILE_DETAILS_MUST_BE_APPROVED_ON_X' => 'Los detalles de tu perfil deben ser aprobados por el administrador para que puedas ser miembro de %s. Recibirás un mensaje cuando esto suceda.',
        'CONTINUE_ARROW' => 'Continuar →',
        'LARR_BACK_TO_PENDING_MEMBERS' => '← Volver a miembros pendientes',
        'X_IS_AWAITING_APPROVAL_TO_BECOME_MEMBER_OF_Y' => '%s está esperando aprobación para convertirse en un miembro de %s.',
        'VIEW_PAGE' => 'Ver página',
        'MESSAGE' => 'Mensaje',
        'SEND_MESSAGE' => 'Enviar mensaje',
        'MANAGE_FORUM_CATEGORIES' => 'Administrar categorías de foros',
        'START_DISCUSSIONS' => 'Empezar discusiones',
        'WELCOME_TO_YOUR_NEW_SOCIAL_NETWORK' => 'Bienvenido a tu nueva red social',
        'NOW_ALL_YOU_NEED_TO_DO_IS_INVITE_YOUR_FRIENDS' => 'Ahora lo único que tenés que hacer es <a %s>invitar a tus amigos</a>.',
        'CONTRIBUTE' => 'Colaborar.',
        'CUSTOMIZE_APPEARANCE_BADGES' => '<strong>Personalizar.</strong> Ajustar el<a %1$s>aspecto de la red</a> y diseñar <a %2$s>insignias y widgets</a>.',
        'CONTROL_MANAGE_PAGE' => '<strong>Control.</strong>  La página <a %s>administrar</a> incluye diversas opciones de configuración.',
        'CREATE_GROUPS' => 'Crear grupos',
        'INVITE_MORE_PEOPLE' => 'Invitá a más gente…',
        'VIEW_THREAD' => 'Ver conversación',
        'COMMENT_THREAD' => 'Lista de comentarios',
        'COMMENT_BACK' => 'Responder al comentario',
        'HELLO_YOU_NEED_TO_ENABLE_JAVASCRIPT' => 'Hola, necesitás tener Javascript habilitado para usar esta red.',
        'PLEASE_CHECK_YOUR_BROWSER_SETTINGS' => 'Por favor verificá la configuración de tu explorador o contactá al administrador de tu sistema.',
        'MANAGE_MEMBERS_ADMINS_INVITED' => 'Administrá miembros, administradores, personas invitadas y personas no admitidas.',
        'MANAGE_MEMBERS' => 'Administrar miembros',
        'MANAGE_INVITED_PEOPLE' => 'Administrar invitaciones',
        'NETWORK_SETTINGS' => 'Configuración de la red',
        'PROMOTE_YOUR_NETWORK' => 'Promové tu red',
        'NING_RESOURCES' => 'Recursos de Ning',
        'ADD_PREMIUM_SERVICES' => 'Agregar servicios premium',
        'REQUEST_SOURCE_CODE' => 'Pedir acceso al código fuente',
        'REQUEST_A_COPY_OF_THE_SOURCE_CODE' => 'Programadores: pedir acceso al código fuente detrás de la red.',
        'JOIN_NETWORK_CREATORS' => 'Unite a los creadores de redes',
        'SEND_MESSAGE_TO_ALL_THIS' => 'Enviá un mensaje a todos los miembros de esta red.',
        'CREATE_ANOTHER_NETWORK' => 'Creá otra red',
        'HAVE_ANOTHER_GREAT_IDEA' => '¿Tenés otra buena idea para una red social?',
        'ALLOW_FACEBOOK_USERS_TO' => 'Permití que los usuarios de Facebook pongan tus widgets en sus páginas de perfil.',
        'BADGES_AND_WIDGETS' => 'Insignias y Widgets',
        'CUSTOMIZE_WIDGETS_AND_BADGES' => 'Configurá la apariencia de las insignias y widgets de tu red.',
        'GET_BADGES' => 'Conseguir insignias',
        'CUSTOM_TEXT' => 'Mensaje personal',
        'IM_A_MEMBER_OF' => 'Soy miembro de:',
        'DONT_DISPLAY_ANY_BRANDING' => 'No mostrar marcas',
        'WATERMARK_OR_LOGO_IMAGE' => 'Marca de agua o logotipo:',
        'NETWORK_BRANDING_BADGES' => 'Marca de la red: Insignias',
        'NETWORK_BRANDING_WIDGETS' => 'Marca de la red: Widgets',
        'LOGO_IMAGE' => 'Logotipo',
        'SMALL_NETWORK_BADGE' => 'Insignia de red (chica)',
        'LARGE_NETWORK_BADGE' => 'Insignia de red (grande)',
        'REFRESH' => 'Actualizar',
        'HTML_EMBED_CODE' => 'Código HTML:',
        'CUSTOMIZE' => 'Personalizar',
        'SHARE_TITLE' => 'Compartir \'%s\'',
        'SHARE_TYPE' => 'Compartir %s',
        'YOUR_MESSAGE_SENT' => 'Tu mensaje se envió con éxito.',
        'YOUR_MESSAGES_SENT' => 'Tus mensajes se enviaron con éxito.',
        'YOU_CAN_SHARE_TYPE_TWO_WAYS' => 'Podés compartir este %s de dos maneras&#8230;',
        'CHECK_OUT_THIS_TYPE_TITLE' => 'Mirá este %s: "%s"',
        'CHECK_OUT_THIS_TYPE' => 'Mirá este %s',
        'PHOTO_ALBUM' => 'álbum de fotos',
        'CUSTOMIZE_YOUR_BADGES_AND_WIDGETS' => 'Configurá tus insignias y widgets con tu propio color y opciones de imágenes. Tus cambios pueden tardar hasta 4 horas en aparecer en otros sitios web.',
        'BACKGROUND_IMAGE_AND_COLOR' => 'Imagen de fondo y color',
        'USE_THIS_FORM_TO_REPORT_ISSUE_TO_NC' => 'Usá este formulario para informar acerca de un problema a <a %s>%s</a>, el creador de <a %s>%s</a>.',
        'SORRY_NCS_CANNOT_CHANGE_EMAIL' => 'Los creadores de red no pueden cambiar su dirección de correo electrónico en redes que no les pertenecen.',
        'SORRY_NCS_CANNOT_CHANGE_PASSWORD' => 'Los creadores de red no pueden cambiar su contraseña en redes que no les pertenecen.',
        'GO' => 'Ir a',
        'LARGE_THUMBNAILS' => 'Miniaturas grandes',
        'SMALL_THUMBNAILS' => 'Miniaturas chicas',
        'RECENTLY_JOINED' => 'Los más recientes',
        'MOST_POPULAR_MEMBERS' => 'Los más populares',
        'NO_MEMBERS_TO_DISPLAY' => 'No estás mostrando miembros en este momento',
        'BOX_WILL_NOT_SHOW_MEMBERS' => 'Este área no aparecerá para otros visitantes si no elegís por lo menos una fila.',
        'DETAIL_VIEW' => 'Vista de detalles',
        'TITLES_ONLY' => 'Sólo títulos',
        'RECENTLY_ADDED_POSTS' => 'Agregado recientemente',
        'POPULAR_POSTS' => 'Más comentarios',
        'PROMOTED_POSTS' => 'Destacados',
        'BOX_WILL_NOT_SHOW_BLOG_POST' => 'Este área no aparecerá para otros visitantes si no elegís por lo menos una publicación.',
        'KEEP_WINDOW_OPEN_UPLOAD' => 'Por favor dejá esta ventana del explorador abierta mientras el archivo se termina de cargar.',
        'CANCEL_UPLOAD' => 'Cancelar la carga',
        'YOU_DO_NOT_HAVE_POSTS' => 'Todavía no escribiste ninguna publicación.',
        'YOU_DO_NOT_HAVE_COMMENTS' => 'No tenés ningún comentario para aprobar.',
        'REQUIRED_FIELD' => '(Campo obligatorio)',
        'BLOG_POST_BY_X' => 'Publicación del blog escrito por %s',
        'HELLO' => 'Hola,',
        'ADDED_BY_X' => 'Agregado por %s',
        'CLICK_TO_ADD_A_TITLE' => 'Hacer clic en para agregarle un título',
        'DELETE_BLOG_POST' => 'Eliminar publicación',
        'DELETE_THIS_BLOG_POST_Q' => '¿Eliminar esta publicación de blog?',
        'ARE_YOU_SURE_DELETE_THIS_BLOG_POST' => '¿Está seguro? Este proceso puede tardar unos minutos.',
        'SPINNER' => 'Spinner',
        'PLEASE_ENTER_SOMETHING_FOR_X' => 'Por favor ingresá algo para: %s',
        'PLEASE_SELECT_OPTION_FOR_X' => 'Por favor seleccioná una opción para: %s',
        'PLEASE_PROVIDE_VALID_DATE_FOR_X' => 'Por favor proveé una fecha válida para: %s',
        'PLEASE_PROVIDE_DATE_FOR_X' => 'Por favor proveé una fecha para: %s',
        'XS_BLOG_POSTS_FOR_M_Y' => 'Las publicaciones de blog de %s para %s %s',
        'FEATURED_BLOG_POSTS_FOR_M_Y' => 'Publicaciones de blog destacadas para %s %s',
        'BLOG_POSTS_FOR_M_Y' => 'Publicaciones de blog para %s %s',
        'FEATURED_BLOG_POSTS' => 'Publicaciones de blog destacadas',
        'EVERYONES_POSTS' => 'Las publicaciones de blog de todos',
        'PUBLISHED_N_OF_N' => '%d publicados de %d',
        'DOWNLOAD_X' => 'Descargar %s',
        'UPLOAD_DID_NOT_WORK' => 'Disculpá, no se pudo realizar la carga',
        'F_J_Y' => 'F j, Y',
        'M_J_Y' => 'j. M, Y',
        'XS_POSTS' => 'Las publicaciones de %s',
        'USERNAMES_COMMENTS' => 'Comentarios de %s',
        'ADD_COMMENT' => 'Agregar comentario',
        'XS_PAGE' => 'Página de %s',
        'XS_BLOG' => 'El blog de %s',
        'XS_FRIENDS' => 'Los amigos de %s',
        'VIEW_XS_ELLIPSIS' => 'Ver %s...',
        'DRAFT_BRACKETS' => '[ Borrador ]',
        'FEATURED' => 'Destacados',
        'MY_POSTS' => 'Mis publicaciones',
        'MY_POSTS_ONLY' => 'Sólo mis publicaciones',
        'OWNER_POSTS_ONLY' => 'Sólo las publicaciones del creador',
        'JANUARY' => 'Enero',
        'FEBRUARY' => 'Febrero',
        'MARCH' => 'Marzo',
        'APRIL' => 'Abril',
        'MAY' => 'Mayo',
        'JUNE' => 'Junio',
        'JULY' => 'Julio',
        'AUGUST' => 'Agosto',
        'SEPTEMBER' => 'Septiembre',
        'OCTOBER' => 'Octubre',
        'NOVEMBER' => 'Noviembre',
        'DECEMBER' => 'Diciembre',
        'MY_COMMENTS' => 'Mis comentarios',
        'AM' => 'AM',
        'PM' => 'PM',
        'MY_PAGE' => 'Mi página',
        'MY_PAGE_TAB_TEXT' => 'Mi página',
        'BLOG_POSTS' => 'Publicaciones de blog',
        'MY_BLOG' => 'Mi blog',
        'MONTH' => 'Mes',
        'DAY' => 'Día',
        'PICK_VALID_DEFAULT_VISIBILITY' => 'Por favor elegí una opción válida para la visibilidad predeterminada',
        'PICK_VALID_WHO_CAN_COMMENT' => 'Por favor elegí una opción válida para quién puede comentar',
        'PICK_VALID_BLOG_COMMENT_MODERATION' => 'Por favor elegí una opción válida para la moderación de los comentarios del blog',
        'PICK_VALID_ACTIVITY_NOTIFICATION' => 'Por favor elegí una opción válida para las notificaciones de actividad',
        'PICK_VALID_MODERATION_NOTIFICATION' => 'Por favor elegí una opción válida para las notificaciones de moderación',
        'PICK_VALID_APPROVAL_NOTIFICATION' => 'Por favor elegí una opción válida para las notificaciones de aprobación',
        'PICK_VALID_INVITEE_NOTIFICATION' => 'Por favor elegí una opción válida para las notificaciones de invitaciones para unirse al grupo',
        'PICK_VALID_NEVER_NOTIFICATION' => 'Por favor elegí una opción válida para no recibir nunca notificaciones',
        'PICK_VALID_FRIEND_REQUEST_NOTIFICATION' => 'Por favor elegí una opción válida para las notificaciones de pedidos de amigos',
        'PICK_VALID_NEW_MESSAGE_NOTIFICATION' => 'Por favor elegí una opción válida para las notificaciones de nuevos mensajes',
        'APPROVE_COMMENT' => 'Aprobar comentario',
        'MANAGE_BLOG' => 'Administrar blog',
        'COMMENTS_POSTED_ON_BLOG' => 'Comentarios publicados en mi blog',
        'COMMENT' => 'Comentario',
        'COMMENTER' => '¿Quién comentó?',
        'POST' => 'PUBLICACIÓN',
        'M_J_Y_G_IA' => 'j M, Y, g:ia',
        'POST_HAS_BEEN_DELETED' => 'Se eliminó la publicación',
        'COMMENTS_ARE_CLOSED' => 'Los comentarios para esta publicación están cerrados',
        'NO_COMMENTS' => 'No hay comentarios',
        'FLAG' => 'Marcador',
        'POST_TITLE' => 'Título de la publicación',
        'DRAFT_PARENTHESES' => '(Borrador)',
        'SCHEDULED_TO_PUBLISH_ON' => 'Programado para ser publicado el: %s',
        'EDIT_2' => 'editar',
        'NONE' => 'Ninguno',
        'N_NEW' => 'Nuevo %s',
        'NO_POSTS' => 'No hay publicaciones',
        'ADD_NEW_BLOG_POST' => 'Agregar una nueva publicación de blog',
        'HAPPY' => 'Feliz',
        'SAD' => 'Triste',
        'COOL' => 'Tranquilo',
        'EVIL' => 'Diabólico',
        'MAD' => 'Loco',
        'ENVIOUS' => 'Envidioso',
        'ENTRY' => 'Entrada',
        'WHAT_DATE_FOR_YOUR_POST' => '¿Que fecha te gustaría ponerle a tu publicación?',
        'NOW' => 'Ahora',
        'CHOOSE_DATE_AND_TIME' => 'Elegí una fecha y hora (si elegís una fecha futura, tu publicación se publicará en ese momento)',
        'PRIVACY_AND_COMMENTS' => 'Privacidad y comentarios',
        'WHO_CAN_VIEW_POST' => '¿Quién puede ver esta publicación?',
        'EVERYONE' => 'Para todas las edades',
        'ALLOW_COMMENTS' => '¿Permitir comentarios en esta publicación?',
        'YES' => 'Sí',
        'NO' => 'No',
        'COMMENT_MODERATION' => 'Moderación de comentarios',
        'YOU_ARE_MODERATING_BLOG_COMMENTS' => 'Estás moderando comentarios del blog en este momento.',
        'YOU_ARE_NOT_MODERATING_BLOG_COMMENTS' => 'No estás moderando comentarios del blog en este momento.',
        'SAVE_AS_DRAFT' => 'Guardar como borrador',
        'PREVIEW' => 'Vista previa',
        'PUBLISH_POST' => 'Publicar',
        'THIS_IS_PREVIEW_OF_BLOG_POST' => 'Esta es una vista previa de como se verá tu publicación cuando la publiques. ¡Hacé clic en "Atrás" para editarla de nuevo, o en "Publicar" si ya está lista!',
        'BACK' => 'Atrás',
        'PUBLISH' => '¡Publicar!',
        'BLOG_POST' => 'Publicación de blog',
        'PROFILE' => 'Perfil',
        'THIS_IS_UNPUBLISHED_DRAFT' => 'Este es un borrador que aún no ha sido publicado',
        'WILL_BE_PUBLISHED_ON_X' => 'Será publicado en  %s <small>%s</small>',
        'POSTED_ON_X' => 'Publicado en %s <small>%s</small>',
        'POSTED_ON_X_BY' => 'Publicado <strong>%s</strong> <small>%s</small> por:',
        'ABOUT_THIS_POST' => 'Acerca de esta publicación',
        'ABOUT_YOUR_POST' => 'Acerca de tu publicación',
        'ADDED_BY' => 'Agregada por:',
        'JUST_FRIENDS' => 'Sólo amigos',
        'RECENT_POSTS' => 'Publicaciones recientes',
        'THERE_ARE_NO_RECENT_POSTS' => 'No hay publicaciones recientes.',
        'YOUR_COMMENT_HAS_BEEN_ADDED_BUT' => 'Tu comentario se agregó pero tiene que ser aprobado antes de que todos puedan verlo.',
        'AT_TIME_ON_DATE_USERNAME_SAID' => 'A las %s del %s, %s dijo...',
        'X_DOES_NOT_HAVE_ANY_FRIENDS' => '%s todavía no tiene amigos en esta red social.',
        'YOU_DO_NOT_HAVE_ANY_FRIENDS' => 'Todavía no tenés amigos en esta red social.',
        'EDIT_PAGE_APPEARANCE' => 'Editar la apariencia de la página',
        'VIEW_PAGE_AS_OTHERS' => 'Ver la página como la ven los demás',
        'ADD_BLOG_POST' => 'Agregar una publicación de blog',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED_2' => 'Por favor mantené esta ventana del explorador abierta mientras todo el comentario de %s se elimina. Este proceso podría tardar unos minutos.',
        'BAN_MEMBER_FROM_NETWORK' => 'No admitir en la red',
        'BAN_USERNAME' => 'No admitir a %s?',
        'BLOCK' => 'bloquear',
        'CREATE_NEW_BLOG_POST' => '¡Crear una nueva publicación de blog!',
        'EDIT_POST' => 'Editar publicación',
        'EDIT_POST_COLON' => 'Editar publicación:',
        'CONTINUE_READING' => 'Seguir leyendo...',
        'POSTED_BY_ME_LINK_ON_X_AT_X' => 'Publicado por <a %s>mí</a> el %s a las %s —',
        'POSTED_BY_X_ON_X_AT_X' => 'Publicado por %s el %s a las %s —',
        'POSTED_BY_ME_ON_X_AT_X' => 'Publicado por mí el %s a las %s —',
        'ADD' => 'Agregar',
        'SUBSCRIBE' => 'Subscribite',
        'VIEW_ARCHIVES' => 'Ver archivos',
        'YOUR_SETTINGS_HAVE_BEEN_SAVED' => 'Se guardó tu configuración',
        'PLEASE_CORRECT_THE_FOLLOWING' => 'Por favor corregí lo siguiente:',
        'PRIVACY' => 'Privacidad',
        'NETWORK_PRIVACY' => 'Privacidad de la red',
        'THIS_NETWORK_VISIBLE_TO_EVERYONE' => 'Esta red es <strong>visible a todos</strong>.',
        'ANYONE_CAN_SIGN_UP_VISITORS_CAN' => 'Cualquiera puede registrarse para ser miembro. Los visitantes pueden...',
        'SEE_EVERYTHING' => 'Ver todo',
        'SEE_JUST_THE_MAIN_PAGE' => 'Sólo la página principal',
        'SEE_JUST_THE_SIGN_UP_PAGE' => 'Sólo la página para registrarse',
        'THIS_NETWORK_VISIBLE_MEMBERS_ONLY' => 'Esta red es <strong>sólo visible para miembros</strong>.',
        'WHO_CAN_SIGN_UP' => '¿Quién puede ser miembro?',
        'MODERATION' => 'Moderación',
        'APPROVE_MEMBERS_BEFORE_JOIN' => 'Aprobar a los nuevos miembros antes de que se unan a la red',
        'APPROVE_PHOTOS_VIDEOS' => 'Aprobar fotos y videos antes de que aparezcan',
        'SHOW_LATEST_ACTIVITY_ON_YOUR_NETWORK' => '¡Mostrar las actividades recientes en tu red!',
        'PUT_A_CONSTANTLY_UPDATED_STREAM' => 'Poné actualizaciones constantes de la actividad en tu red en la página principal.',
        'CLICK_HERE_TO_ADD_LATEST_ACTIVITY' => 'Hacé clic acá para agregar Actividades recientes a tu red.',
        'THESE_OPTIONS_ARE_DISABLED_ACTIVITY' => 'Estas opciones están desactivadas dado que no tenés Actividades recientes activadas en tu red.',
        'ACTIVITY' => 'Actividad',
        'DISPLAY_PREFERENCES' => 'Mostrar preferencias',
        'NEW_CONTENT' => 'Nuevo contenido',
        'NEW_COMMENTS' => 'Nuevos comentarios',
        'NEW_MEMBERS' => 'Nuevos miembros',
        'MEMBER_UPDATES' => 'Actualizaciones de miembros',
        'WHAT_DISPLAYS_LATEST_ACTIVITY' => '¿Qué aparece en la Actividades<br />recientes de tu red?',
        'LATEST_ACTIVITY' => 'Actividades recientes',
        'X_COMMENTED_ON_POST_TITLE' => '%1$s contestó al tema %2$s',
        'X_LINK_COMMENTED_ON_POST_LINK_TITLE' => '%1$s <a %2$s>contestó</a> al tema <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_POST_LINK_TITLE' => 'Vos <a %1$s>contestaste</a> al tema <a %2$s>%3$s</a>',
        'X_COMMENTED_ON_BLOG_POST_TITLE' => '%1$s hizo un comentario sobre la publicación de blog %2$s',
        'X_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '%1$s <a %2$s>hizo un comentario</a> sobre la publicación de blog <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '<a %1$s>Hiciste un comentario</a> sobre la publicación de blog <a %2$s>%3$s</a>',
        'X_STARTED_A_DISCUSSION_Y' => '%s comenzó un tema %s',
        'YOU_STARTED_A_DISCUSSION_Y' => 'Comenzaste el tema %s',
        'X_ADDED_THE_BLOG_POST_Y' => '%s agregó la publicación de blog \'%s\'',
        'YOU_ADDED_THE_BLOG_POST_Y' => 'Vos agregaste la publicación de blog \'%s\'',
        'X_JOINED_THE_GROUP_Y' => '%s se unió al grupo %s',
        'YOU_JOINED_THE_GROUP_X' => 'Te uniste al grupo %s',
        'X_JOINED_Y_GROUPS' => '%s se unió a %s grupos',
        'YOU_JOINED_X_GROUPS' => 'Te uniste a %s grupos',
        'X_JOINED_APPNAME' => '%s se unió a %s',
        'WELCOME_MEMBER_N_OF_APPNAME' => '¡Bienvenido, %1$s! Sos miembro #%2$s de %3$s.',
        'WELCOME_MEMBER_N_OF_APPNAME_FIND' => '¡Bienvenido, %1$s! Sos el miembro #%2$s de %3$s. <a %4$s>Buscá amigos ahora</a>.',
        'X_IS_MEMBER_N_OF_APPNAME' => '%1$s es miembro #%2$s de %3$s.',
        'XS_PROFILE_CHANGED' => 'El perfil de %s se actualizó',
        'YOUR_PROFILE_CHANGED' => 'Actualizaste tu perfil',
        'X_LEFT_A_COMMENT_FOR_Y' => '%s dejó un comentario para %s',
        'YOU_LEFT_A_COMMENT_FOR_X' => 'Dejaste un comentario para %s',
        'X_LEFT_A_COMMENT_FOR_YOU' => '%s dejó un comentario para vos',
        'X_CREATED_A_GROUP_Y' => '%s creó un grupo llamado %s',
        'YOU_CREATED_A_GROUP_Y' => 'Creaste un grupo llamado %s',
        'X_CREATED_Y_NEW_GROUPS' => '%s creó %s nuevos grupos',
        'X_STARTED_Y_FORUM_POSTS' => '%s empezó %s nuevos temas de discusión',
        'YOU_STARTED_Y_FORUM_POSTS' => 'Empezaste %s nuevos temas de discusión',
        'X_ADDED_Y_BLOG_POSTS' => '%s agregó %s nuevas publicaciones de blog',
        'YOU_ADDED_Y_BLOG_POSTS' => 'Agregaste %s nuevas publicaciones de blog',
        'VIEW_XS_BLOG_POSTS' => 'Ver las publicaciones de blog de %s',
        'VIEW_YOUR_BLOG_POSTS' => 'Ver tus publicaciones de blog',
        'APPNAME_HAS_NEW_PROFILE_QUESTIONS' => '%s tiene <a %s>nuevas preguntas de perfil</a>',
        'APPNAME_NOW_HAS_MUSIC' => '%s instaló un reproductor de música',
        'APPNAME_NOW_HAS_GROUPS' => '%s ahora tiene <a %s>grupos</a>',
        'APPNAME_NOW_HAS_VIDEO' => '%s ahora tiene <a %s>videos</a>',
        'APPNAME_NOW_HAS_FORUM' => '%s ahora tiene <a %s>foros</a>',
        'APPNAME_NOW_HAS_PHOTO' => '%s ahora tiene <a %s>fotos</a>',
        'DID_YOU_KNOW' => 'Sabías que',
        'ANNOUNCEMENT' => 'Anuncio',
        'CONGRATULATIONS' => 'Felicitaciones',
        'YOU_CREATED_APPNAME' => 'Creaste la red %s.',
        'USER_CREATED_APPNAME' => '%s creó la red %s.',
        'ADD_MESSAGES_ACTIVITY_FEED' => 'Agregá mensajes y elegí qué aparece en las Actividades recientes de tu red.',
        'WHICH_OF_YOUR_ACTIONS_DISPLAY_ACTIVITY' => '¿Qué acciones aparecen en Actividades recientes?',
        'NEW_CONTENT_I_ADD' => 'Nuevo contenido que agregué',
        'NEW_COMMENTS_I_ADD' => 'Nuevos comentarios que agregué',
        'WHEN_I_UPDATE_MY_PROFILE' => 'Cuando actualizo mi perfil',
        'THE_LATEST_ACTIVITY_WILL_NEVER' => 'Las actividades recientes nunca van a mostrar los mensajes que envíes, las páginas o los miembros que visites, las invitaciones que rechaces, las personas que quites de la lista de amigos o que rechaces o las cosas que elimines.',
        'YOU_HAVENT_DONE_ANYTHING_RECENTLY' => 'No tenés actividades recientes. ¿Porqué no empezás algo?',
        'YOUVE_TURNED_OFF_THE_ACTIVITY_DISPLAY_CLICK' => 'Desactivaste mostrar todas tus actividades. <a %s>Hacé clic acá para reactivarlo.</a>',
        'THE_NETWORK_CREATOR_HAS_TURNED_OFF_THE_ACTIVITY' => 'El creador de la red ha desactivado Actividades recientes.',
        'NO_ACTIVITY_TO_DISPLAY' => 'En este momento no estás mostrando actividades recientes.',
        'BOX_WILL_NOT_SHOW_ACTIVITY' => 'Este recuadro no aparecerá para otra gente a menos que selecciones un elemento de actividad.',
        'NOTHING_IS_HAPPENING_ON_YOUR_NETWORK' => 'No hay actividades recientes. ¿Por qué no empezás algo?',
        'MY_ACTIVITY_PREFERENCES' => 'Preferencias de actividad',
        'DELETE_ACTIVITY_ITEM' => 'Eliminar mensaje de actividad',
        'DELETE_THIS_ACTIVITY_MESSAGE_Q' => '¿Eliminar este mensaje de actividad?',
        'THIS_WILL_PREVENT_ACTIVITY' => 'Nadie podrá ver este mensaje de actividad',
        'X_HAS_POSTED_THE_MOST_PHOTOS' => '%1$s subió la mayor cantidad de %2$sfotos%3$s',
        'X_IS_THE_MOST_POPULAR_PHOTO' => '%s es la foto más popular hasta la fecha',
        'X_HAS_POSTED_THE_MOST_VIDEOS' => '%1$s subió la mayor cantidad de %2$svideos%3$s',
        'X_IS_THE_MOST_POPULAR_VIDEO' => '%s es el video más popular hasta la fecha',
        'X_HAS_POSTED_THE_MOST_MUSIC' => '%s subió la mayor cantidad de canciones',
        'X_IS_THE_MOST_POPULAR_MUSIC' => '%s es la canción más popular hasta la fecha',
        'X_IS_THE_MOST_POPULAR_TOPIC' => '%s es el tema más popular hasta la fecha',
        'X_IS_THE_MOST_POPULAR_BLOG_POST' => '%s es la publicación de blog más popular hasta la fecha',
        'XS_LATEST_ACTIVITY_ON_APPNAME' => 'Las Actividades recientes de %s en %s',
        'LATEST_ACTIVITY_ON_APPNAME' => 'Actividades recientes en %s',
        'ADD_MESSAGE_TO_LATEST_ACTIVITY' => 'Agregar mensaje a Actividades recientes',
        'ADD_FACTS_ABOUT_THE_NETWORK_ELLIPSIS' => 'Agregar datos acerca de la red...',
        'ADD_MESSAGE' => 'Agregar mensaje',
        'ELLIPSIS_OR_WRITE_YOUR_OWN_MESSAGE' => '... o escribir tu propio mensaje',
        'NETWORK' => 'Red',
        'WHO_CAN_VIEW_YOUR_PHOTOS_VIDEOS' => '¿Quién puede ver mis fotos, videos, <br/> y publicaciones de manera predeterminada?',
        'YOU_CAN_OVERRIDE_WHEN_YOU_ADD' => '(Podés cambiar esta configuración para una foto, video o publicación cuando lo agregues.)',
        'MODERATE_COMMENTS_ON_BLOG' => '¿Querés aprobar comentarios <br /> antes de que aparezcan en tu blog?',
        'YES_LET_ME_APPROVE' => 'Sí: quiero aprobar los comentarios para su publicación',
        'NO_PUBLISH_COMMENTS' => 'No: publicar los comentarios inmediatamente',
        'WHO_CAN_COMMENT_ON_PHOTOS_VIDEOS' => '¿Quién puede comentar mis fotos,<br/> videos y blog?',
        'SAVE' => 'Guardar',
        'EMAIL' => 'Correo electrónico',
        'YOUR_PRIVACY_IS_IMPORTANT' => 'Tu privacidad es importante para nosotros. Si tenés alguna pregunta sobre tus notificaciones por correo electrónico, envianos una nota a través del <a href="http://help.ning.com/?page_id=27">Centro de ayuda</a>.',
        'ADD_PHOTOS_AND_VIDEOS_TO_X_BY_SENDING' => 'Agregar fotos y videos a %s enviándolos a esta dirección de correo electrónico:',
        'ADD_PHOTOS_AND_VIDEOS_TO_APPNAME_FROM_PHONE' => 'Agregar fotos y videos a %s desde tu teléfono, enviándolos a esta dirección de correo electrónico:',
        'GENERATE_NEW_EMAIL_ADDRESS' => 'Generar una nueva dirección de correo electrónico',
        'SUPPORTS_TEXT_EMBEDDED' => 'Admite texto, videos incrustados, fotos y  widgets',
        'POST_COMMENT' => 'Publicar comentario',
        'YOU_NEED_TO_BE_MEMBER_COMMENTS' => '¡Tenés que ser un miembro de %s para agregar comentarios!',
        'MONTHLY_ARCHIVES' => 'Archivos mensuales',
        'NO_FRIENDS_ON_SITE' => 'No hay amigos en esta red social todavía.',
        'NO_FRIENDS_ON_SITE_THAT_MATCH' => 'No hay amigos en esta red social que concuerden con tu búsqueda.',
        'MEMBERS_TAB_TEXT' => 'Miembros',
        'SITE_HAS_NO_MEMBERS' => '¡Esta red social todavía no tiene miembros!',
        'SITE_HAS_NO_MEMBERS_THAT_MATCH' => 'Esta red social no tiene miembros que coincidan con su búsqueda.',
        'NO_COMMENTS_YET' => '¡Todavía no hay comentarios!',
        'VIEW_ALL_COMMENTS' => 'Ver todos los comentarios',
        'YOU_HAVE_NOT_ADDED_BLOG_POSTS' => '¡Todavía no agregaste ninguna publicación en tu blog!',
        'YOU_CAN_WRITE_ABOUT_ANYTHING' => 'Podés escribir sobre lo que quieras, hablar de lo que quieras y pegar tus videos, fotos y música favoritos.',
        'WRITE_YOUR_FIRST_ENTRY' => '¡Escribí tu primera entrada!',
        'THERE_ARE_NO_BLOG_POSTS' => 'No hay publicaciones en el blog de tu red social en este momento.',
        'THERE_ARE_NO_FEATURED_X' => 'No hay %s destacados en tu red social.',
        'THERE_ARE_NO_X_THAT_MATCH_SETTINGS' => 'No hay %s que coincidan con la configuración que seleccionaste.',
        'START_FEATURING_X_CLICK_Y' => 'Empezá a marcar como destacado %s donde veas la opción de Marcar como destacado. Para aprender más sobre la manera de marcar como destacado, <a %s>Hacé clic acá</a>.',
        'THIS_BOX_WILL_NOT_SHOW_BLOG_POSTS' => 'Este recuadro no se mostrará a otras personas hasta que existan publicaciones para mostrar. ¿Por qué no agregás una?',
        'YOUR_FRIEND' => 'Tu amigo',
        'REQUEST_SENT' => '¡Pedido enviado!',
        'BLOCKED' => 'Bloqueado',
        'BANNED' => 'No admitido',
        'ADD_YOUR_FIRST_BLOG_POST' => 'Agregá tu primera publicación de blog',
        'MY_FIRST_BLOG_POST' => '¡My primera publicación en mi blog!',
        'TELL_THE_PEOPLE_ON' => 'Contales más sobre vos a los miembros de %s. Las preguntas marcadas con un <span %s>candado</span> son privadas y solamente los administradores pueden verlas.',
        'CHOOSE_A_THEME_FOR_PAGE' => 'Elegí un tema para tu página',
        'NOW_CUSTOMIZE_PAGE' => 'Ahora personalizá tu página...',
        'NO_POSTS_TO_DISPLAY' => 'No hay publicaciones para mostrar.',
        'YOU_ARE_DISPLAYING_NO_POSTS' => 'No estás mostrando publicaciones.',
        'DATE_COLON' => 'Fecha:',
        'TIME_COLON' => 'Hora:',
        'CHANGE' => 'Cambiar',
        'UPLOAD_A_PHOTO' => 'Subir una foto',
        'OPTIONS' => 'Opciones',
        'PIXELS' => 'Píxeles',
        'CANCEL' => 'Cancelar',
        'UPLOAD_A_FILE' => 'Subir un archivo:',
        'TO_INSERT_A_FILE' => 'Para insertar un archivo, hacé clic en el botón "Examinar" o "Elegir" para encontrar el archivo en tu PC.',
        'UPLOADING' => 'Subiendo...',
        'OK' => 'OK',
        'POPULAR_MEMBERS' => 'Miembros populares',
        'INVITE_FRIENDS' => 'Invitar amigos',
        'VIEW_ALL' => 'Ver todos',
        'REMOVE_X' => 'Eliminar %s',
        'ARE_YOU_SURE_BAN_X_AND_CONTENT' => '¿Estás seguro de que no querés admitir a %1$s en tu red social y de que querés eliminar todo el contenido que %1$s haya agregado? Este proceso puede tardar unos minutos.',
        'REMOVING_X' => 'Sacando %s',
        'ARE_YOU_SURE_BAN_MEMBERS_AND_CONTENT' => '¿Estás seguro de que no querés admitir a los miembro(s) seleccionados en tu red social y de que querés eliminar todo el contenido que agregaron? Este proceso puede tardar unos minutos.',
        'ARE_YOU_SURE_BAN_MEMBERS' => '¿Estás seguro de que no querés admitir a los miembro(s) seleccionados en tu red social? Este proceso puede tardar unos minutos.',
        'BAN' => 'No admitir',
        'REMOVING_MEMBERS' => 'Eliminando miembros',
        'FEMALE' => 'Mujer',
        'MALE' => 'Hombre',
        'UNITED_STATES' => 'Estados Unidos',
        'AND' => 'y',
        'FROM' => 'de',
        'GENDER_M' => 'Hombre',
        'GENDER_F' => 'Mujer',
        'XS_PAGE_ON_Y' => 'La página de %s en %s',
        'SEARCH_MEMBERS' => 'Buscar miembros',
        'SOMEBODY_COMMENTED_BLOGPOST_ADDED_TO_X' => 'alguien hizo un comentario sobre una publicación de blog que agregaste a %s',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE' => 'Tenés un comentario nuevo en tu página.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X' => 'Tenés un comentario nuevo en tu página sobre %s.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X_ELLIPSIS' => 'Tenés un comentario nuevo en tu página sobre %s...',
        'A_BLOG_POST' => 'Una publicación de blog',
        'NOW_THAT_YOU_JOINED_INVITE' => 'Ahora que te uniste, <strong><a %s>invitá a tus amigos</a></strong>...',
        'THIS_IS_YOUR_PROFILE' => 'Este es tu perfil:',
        'START_BY_CUSTOMIZING_ITS_APPEARANCE' => 'Empezá por <a %s>personalizar la apariencia</a>.',
        'USE_IT_TO_KEEP_A_BLOG_AND_DISPLAY_YOUR_PROFILE_ANSWERS' => 'Usalo para <a %1$s>llevar un blog</a> y mostrar <a %2$s>las respuestas de tu perfil</a>.',
        'START_CONTRIBUTING' => 'Empezar a colaborar:',
        'UPLOAD_VIDEOS' => 'Subir videos',
        'CONTRIBUTE_TO_DISCUSSIONS' => 'Participar en discusiones',
        'JOIN_GROUPS' => 'Unirte a grupos',
        'ADD_A_BLOG_POST' => 'Agregá una publicación en tu blog',
        'CLICK_TO_ACCEPT_FRIENDS' => 'Hacé clic acá para ver los pedidos de amigos.',
        'LEAVE_X' => 'Salir de %s',
        'LEAVE_X_Q' => '¿Salir de %s?',
        'ARE_YOU_SURE_LEAVE_X' => '¿Estás seguro de que querés salir de %s y eliminar todo el contenido? Este proceso puede tardar unos minutos.',
        'BACK_TO_USERNAMES_PAGE' => '&#8592; Volver a la página de %s',
        'BACK_TO_MY_PAGE' => '&#8592; Volver a mi página',
        'COMMENT_WALL' => 'Comentarios',
        'ONLINE' => 'Conectado',
        'MEMBER_IS_ONLINE' => 'Miembro esta conectado',
        'ONLINE_NOW' => 'Conectado ahora',
        'CHOOSE_WHO_CAN_SEE_JOIN_AND_CONTRIBUTE' => 'Elegí quién puede ver, unirse, y contribuir a tu red.',
        'EMAIL_NOTIFICATIONS' => 'Notificaciones por correo electrónico',
        'WHAT_NETWORK_ACTIVITY_EMAIL_FOR' => '¿Qué actividades de la red querés que generen una notificación por correo electrónico?',
        'NETWORK_MESSAGES' => 'Mensajes de la red',
        'MEMBER_ACTIVITY' => 'Actividad de miembros',
        'APPROVAL' => 'Aprobación',
        'FRIEND_REQUESTS' => 'Pedidos de amigos',
        'PEOPLE_IVE_INVITED_JOIN' => 'Gente que invité a unirse a esta red',
        'MESSAGES_SENT_TO_ME' => 'Mensajes que me enviaron',
        'MESSAGES_SENT_TO_GROUPS' => 'Mensajes enviados a grupos a los que pertenezco',
        'MESSAGES_SENT_TO_NETWORK' => 'Mensajes enviados a toda la red',
        'I_HAVE_NEW_COMMENTS' => 'Tengo nuevos comentarios para aprobar',
        'I_HAVE_NEW_NETWORK_CONTENT' => 'Tengo nuevo contenido de red para aprobar',
        'CONTENT_ACTIVITY' => 'Actividad de contenido',
        'ACTIVITY_ON_THINGS_IVE_ADDED' => 'Actividad en mi contenido',
        'AUTO_FOLLOW_DISCUSSIONS_I_REPLY_TO' => 'Seguir discusiones a las que respondí automáticamente',
        'THINGS_IVE_ADDED_APPROVED' => 'Cosas que agregué que han sido aprobadas',
        'NOTIFICATIONS' => 'Notificaciones',
        'EMAIL_ME_WHEN_PEOPLE_REPLY' => 'Recibir mensaje de correo electrónico cuando la gente contesta',
        'DO_NOT_EMAIL_ME_WHEN_PEOPLE_REPLY' => 'No recibir mensaje de correo electrónico cuando la gente contesta',
        'TO_STOP_FOLLOWING_THIS_X_CLICK_Y' => 'Para dejar de seguir este %s, <a %s>hacé clic acá</a>.',
        'YOU_ARE_NO_LONGER_FOLLOWING_THIS_X' => 'Ya no estás siguiendo este %s.',
        'NOTIFY' => 'Notificar',
        'STOP_NOTIFYING' => 'Dejar de notificar',
        'EMAIL_WHEN_NEW_DISCUSSIONS' => 'Recibir mensaje de correo electrónico cuando hay nuevos temas de discusión',
        'DO_NOT_EMAIL_WHEN_NEW_DISCUSSIONS' => 'No recibir mensaje de correo electrónico para nuevos temas de discusión',
        'STOP_FOLLOWING_ALL' => 'Dejar de seguir todas las discusiones y comentarios en blogs',
        'CHANGE_MY_PHOTO' => 'Cambiar mi foto',
        'COUNTRY_AF' => 'Afganistán',
        'COUNTRY_AX' => 'Islas Aland',
        'COUNTRY_AL' => 'Albania',
        'COUNTRY_DZ' => 'Argelia',
        'COUNTRY_AS' => 'Samoa Americana',
        'COUNTRY_AD' => 'Andorra',
        'COUNTRY_AO' => 'Angola',
        'COUNTRY_AI' => 'Anguila',
        'COUNTRY_AQ' => 'Antártida',
        'COUNTRY_AG' => 'Antigua y Barbuda',
        'COUNTRY_AR' => 'Argentina',
        'COUNTRY_AM' => 'Armenia',
        'COUNTRY_AW' => 'Aruba',
        'COUNTRY_AU' => 'Australia',
        'COUNTRY_AT' => 'Austria',
        'COUNTRY_AZ' => 'Azerbaiyán',
        'COUNTRY_BS' => 'Bahamas',
        'COUNTRY_BH' => 'Bahréin',
        'COUNTRY_BD' => 'Bangladesh',
        'COUNTRY_BB' => 'Barbados',
        'COUNTRY_BY' => 'Bielorrusia',
        'COUNTRY_BE' => 'Bélgica',
        'COUNTRY_BZ' => 'Belice',
        'COUNTRY_BJ' => 'Benín',
        'COUNTRY_BM' => 'Bermudas',
        'COUNTRY_BT' => 'Bután',
        'COUNTRY_BO' => 'Bolivia',
        'COUNTRY_BA' => 'Bosnia-Herzegovina',
        'COUNTRY_BW' => 'Botsuana',
        'COUNTRY_BV' => 'Isla Bouvet',
        'COUNTRY_BR' => 'Brasil',
        'COUNTRY_IO' => 'Territorio Británico del Océano Índico',
        'COUNTRY_BN' => 'Brunéi Darussalam, Sultanato de',
        'COUNTRY_BG' => 'Bulgaria',
        'COUNTRY_BF' => 'Burkina Faso',
        'COUNTRY_BI' => 'Burundi',
        'COUNTRY_KH' => 'Camboya',
        'COUNTRY_CM' => 'Camerún',
        'COUNTRY_CA' => 'Canadá',
        'COUNTRY_CV' => 'Cabo Verde',
        'COUNTRY_KY' => 'Islas Caimán',
        'COUNTRY_CF' => 'República Centroafricana',
        'COUNTRY_TD' => 'Chad',
        'COUNTRY_CL' => 'Chile',
        'COUNTRY_CN' => 'China continental',
        'COUNTRY_CX' => 'Isla Christmas',
        'COUNTRY_CC' => 'Islas Cocos (Keeling)',
        'COUNTRY_CO' => 'Colombia',
        'COUNTRY_KM' => 'Comoras',
        'COUNTRY_CG' => 'Congo, República del',
        'COUNTRY_CD' => 'Congo, República Democrática del',
        'COUNTRY_CK' => 'Islas Cook',
        'COUNTRY_CR' => 'Costa Rica',
        'COUNTRY_CI' => 'Costa de Marfil',
        'COUNTRY_HR' => 'Croacia',
        'COUNTRY_CU' => 'Cuba',
        'COUNTRY_CY' => 'Chipre',
        'COUNTRY_CZ' => 'República Checa',
        'COUNTRY_DK' => 'Dinamarca',
        'COUNTRY_DJ' => 'Yibuti',
        'COUNTRY_DM' => 'Dominica',
        'COUNTRY_DO' => 'República Dominicana',
        'COUNTRY_EC' => 'Ecuador',
        'COUNTRY_EG' => 'Egipto',
        'COUNTRY_SV' => 'El Salvador',
        'COUNTRY_GQ' => 'Guinea Ecuatorial',
        'COUNTRY_ER' => 'Eritrea',
        'COUNTRY_EE' => 'Estonia',
        'COUNTRY_ET' => 'Etiopía',
        'COUNTRY_EU' => 'Unión Europea',
        'COUNTRY_FK' => 'Islas Malvinas (Falkland Islands)',
        'COUNTRY_FO' => 'Islas Feroe',
        'COUNTRY_FJ' => 'Fiyi',
        'COUNTRY_FI' => 'Finlandia',
        'COUNTRY_FR' => 'Francia',
        'COUNTRY_GF' => 'Guayana Francesa',
        'COUNTRY_PF' => 'Polinesia Francesa',
        'COUNTRY_TF' => 'Territorios franceses del Sur',
        'COUNTRY_GA' => 'Gabón',
        'COUNTRY_GM' => 'Gambia',
        'COUNTRY_GE' => 'Georgia',
        'COUNTRY_DE' => 'Alemania',
        'COUNTRY_GH' => 'Ghana',
        'COUNTRY_GI' => 'Gibraltar',
        'COUNTRY_GR' => 'Grecia',
        'COUNTRY_GL' => 'Groenlandia',
        'COUNTRY_GD' => 'Granada',
        'COUNTRY_GP' => 'Guadalupe',
        'COUNTRY_GU' => 'Guam',
        'COUNTRY_GT' => 'Guatemala',
        'COUNTRY_GN' => 'Guinea',
        'COUNTRY_GW' => 'Guinea-Bissau',
        'COUNTRY_GY' => 'Guyana',
        'COUNTRY_HT' => 'Haití',
        'COUNTRY_HM' => 'Islas Heard y McDonald',
        'COUNTRY_HN' => 'Honduras',
        'COUNTRY_HK' => 'Hong Kong',
        'COUNTRY_HU' => 'Hungría',
        'COUNTRY_IS' => 'Islandia',
        'COUNTRY_IN' => 'India',
        'COUNTRY_ID' => 'Indonesia',
        'COUNTRY_IR' => 'Irán, República Islámica de',
        'COUNTRY_IQ' => 'Iraq',
        'COUNTRY_IE' => 'Irlanda',
        'COUNTRY_IL' => 'Israel',
        'COUNTRY_IT' => 'Italia',
        'COUNTRY_JM' => 'Jamaica',
        'COUNTRY_JP' => 'Japón',
        'COUNTRY_JO' => 'Jordania',
        'COUNTRY_KZ' => 'Kazajistán',
        'COUNTRY_KE' => 'Kenia',
        'COUNTRY_KI' => 'Kiribati',
        'COUNTRY_KP' => 'Corea, República Popular Democrática de',
        'COUNTRY_KR' => 'Corea, República de',
        'COUNTRY_KW' => 'Kuwait',
        'COUNTRY_KG' => 'Kirguistán',
        'COUNTRY_LA' => 'Laos, República Popular Democrática de',
        'COUNTRY_LV' => 'Letonia',
        'COUNTRY_LB' => 'Líbano',
        'COUNTRY_LS' => 'Lesoto',
        'COUNTRY_LR' => 'Liberia',
        'COUNTRY_LY' => 'Libia,  Jamahiriya Árabe',
        'COUNTRY_LI' => 'Liechtenstein',
        'COUNTRY_LT' => 'Lituania',
        'COUNTRY_LU' => 'Luxemburgo',
        'COUNTRY_MO' => 'Macao',
        'COUNTRY_MK' => 'Macedonia, ex República Yugoslava de',
        'COUNTRY_MG' => 'Madagascar',
        'COUNTRY_MW' => 'Malawi',
        'COUNTRY_MY' => 'Malasia',
        'COUNTRY_MV' => 'Maldivas',
        'COUNTRY_ML' => 'Malí',
        'COUNTRY_MT' => 'Malta',
        'COUNTRY_MH' => 'Islas Marshall',
        'COUNTRY_MQ' => 'Martinica',
        'COUNTRY_MR' => 'Mauritania',
        'COUNTRY_MU' => 'Mauricio',
        'COUNTRY_YT' => 'Mayotte',
        'COUNTRY_MX' => 'México',
        'COUNTRY_FM' => 'Micronesia, Estados Federados de',
        'COUNTRY_MD' => 'Moldavia, República de',
        'COUNTRY_MC' => 'Mónaco',
        'COUNTRY_MN' => 'Mongolia',
        'COUNTRY_MS' => 'Montserrat',
        'COUNTRY_MA' => 'Marruecos',
        'COUNTRY_MZ' => 'Mozambique',
        'COUNTRY_MM' => 'Myanmar',
        'COUNTRY_NA' => 'Namibia',
        'COUNTRY_NR' => 'Nauru',
        'COUNTRY_NP' => 'Nepal',
        'COUNTRY_NL' => 'Países Bajos',
        'COUNTRY_AN' => 'Antillas Holandesas',
        'COUNTRY_NC' => 'Nueva Caledonia',
        'COUNTRY_NZ' => 'Nueva Zelanda',
        'COUNTRY_NI' => 'Nicaragua',
        'COUNTRY_NE' => 'Níger',
        'COUNTRY_NG' => 'Nigeria',
        'COUNTRY_NU' => 'Niue',
        'COUNTRY_NF' => 'Isla Norfolk',
        'COUNTRY_MP' => 'Islas Marianas del Norte',
        'COUNTRY_NO' => 'Noruega',
        'COUNTRY_OM' => 'Omán',
        'COUNTRY_PK' => 'Pakistán',
        'COUNTRY_PW' => 'Palaos',
        'COUNTRY_PS' => 'Territorios Ocupados Palestinos',
        'COUNTRY_PA' => 'Panamá',
        'COUNTRY_PG' => 'Papúa Nueva Guinea',
        'COUNTRY_PY' => 'Paraguay',
        'COUNTRY_PE' => 'Perú',
        'COUNTRY_PH' => 'Filipinas',
        'COUNTRY_PN' => 'Pitcairn',
        'COUNTRY_PL' => 'Polonia',
        'COUNTRY_PT' => 'Portugal',
        'COUNTRY_PR' => 'Puerto Rico',
        'COUNTRY_QA' => 'Qatar',
        'COUNTRY_RE' => 'Reunión',
        'COUNTRY_RO' => 'Rumania',
        'COUNTRY_RU' => 'Federación Rusa',
        'COUNTRY_RW' => 'Ruanda',
        'COUNTRY_SH' => 'Santa Helena',
        'COUNTRY_KN' => 'San Cristóbal y Nieves',
        'COUNTRY_LC' => 'Santa Lucía',
        'COUNTRY_PM' => 'San Pedro y Miguelón',
        'COUNTRY_VC' => 'San Vicente y las Granadinas',
        'COUNTRY_WS' => 'Samoa',
        'COUNTRY_SM' => 'San Marino',
        'COUNTRY_ST' => 'Santo Tomé y Príncipe',
        'COUNTRY_SA' => 'Arabia Saudí',
        'COUNTRY_SN' => 'Senegal',
        'COUNTRY_CS' => 'Serbia y Montenegro',
        'COUNTRY_SC' => 'Seychelles',
        'COUNTRY_SL' => 'Sierra Leona',
        'COUNTRY_SG' => 'Singapur',
        'COUNTRY_SK' => 'Eslovaquia',
        'COUNTRY_SI' => 'Eslovenia',
        'COUNTRY_SB' => 'Islas Salomón',
        'COUNTRY_SO' => 'Somalía',
        'COUNTRY_ZA' => 'Sudáfrica',
        'COUNTRY_GS' => 'Islas Georgias del Sur y Sándwich del Sur',
        'COUNTRY_ES' => 'España',
        'COUNTRY_LK' => 'Sri Lanka',
        'COUNTRY_SD' => 'Sudán',
        'COUNTRY_SR' => 'Surinam',
        'COUNTRY_SJ' => 'Svalbard y Jan Mayen',
        'COUNTRY_SZ' => 'Suazilandia',
        'COUNTRY_SE' => 'Suecia',
        'COUNTRY_CH' => 'Suiza',
        'COUNTRY_SY' => 'República Árabe Siria',
        'COUNTRY_TW' => 'Taiwán',
        'COUNTRY_TJ' => 'Tajikistán',
        'COUNTRY_TZ' => 'Tanzania, República Unida de',
        'COUNTRY_TH' => 'Tailandia',
        'COUNTRY_TL' => 'Timor Oriental',
        'COUNTRY_TG' => 'Togo',
        'COUNTRY_TK' => 'Tokelau',
        'COUNTRY_TO' => 'Tonga',
        'COUNTRY_TT' => 'Trinidad y Tobago',
        'COUNTRY_TN' => 'Túnez',
        'COUNTRY_TR' => 'Turquía',
        'COUNTRY_TM' => 'Turkmenistán',
        'COUNTRY_TC' => 'Islas Turcos y Caicos',
        'COUNTRY_TV' => 'Tuvalu',
        'COUNTRY_UG' => 'Uganda',
        'COUNTRY_UA' => 'Ucrania',
        'COUNTRY_AE' => 'Emiratos Árabes Unidos',
        'COUNTRY_GB' => 'Reino Unido',
        'COUNTRY_US' => 'Estados Unidos',
        'COUNTRY_UM' => 'Islas menores alejadas de los Estados Unidos',
        'COUNTRY_UY' => 'Uruguay',
        'COUNTRY_UZ' => 'Uzbekistán',
        'COUNTRY_VU' => 'Vanuatu',
        'COUNTRY_VA' => 'Vatican City State',
        'COUNTRY_VE' => 'Venezuela',
        'COUNTRY_VN' => 'Vietnam',
        'COUNTRY_VG' => 'Islas Vírgenes, Británicas',
        'COUNTRY_VI' => 'Islas Vírgenes, EE. UU.',
        'COUNTRY_WF' => 'Wallis y Futuna',
        'COUNTRY_EH' => 'Sahara Occidental',
        'COUNTRY_YE' => 'Yemen',
        'COUNTRY_ZM' => 'Zambia',
        'COUNTRY_ZW' => 'Zimbabwe',
        'ERROR_LOG' => 'Registro de errores',
        'CANNOT_READ_ERROR_LOG' => 'No se puede leer el registro de errores',
        'CANNOT_OPEN_ERROR_LOG' => 'No se puede abrir el registro de errores',
        'CANNOT_SCAN_ERROR_LOG' => 'No se puede digitalizar el registro de errores',
        'MODELS_RESET' => 'Modelos restablecidos:',
        'NO_MODELS_RESET' => 'No hay modelos restablecidos.',
        'NO_FEED_TO_DISPLAY' => 'No estás mostrando elementos en este momento.',
        'BOX_WILL_NOT_SHOW_FEED' => 'Este área no aparecerá para otros a menos que elijas por lo menos un elemento.',
        'CLICK_EDIT_TO_SPECIFY_FEED' => 'Hacé clic en Editar para especificar la fuente RSS para este área.',
        'PROBLEM_OCCURRED_RETRIEVING_FEED' => 'Hubo un problema al tratar de obtener esta fuente RSS.',
        'MORE_ELLIPSIS' => 'Más...',
        'RSS' => 'RSS',
        'WE_ARE_SORRY_SITE_HAS_ISSUE' => 'Disculpá, este sitio tiene un problema en este momento.',
        'PLEASE_TRY_REFRESHING' => 'Por favor, tratá de cargar nuevamente la página en 30 segundos, o <a %s>avisanos</a> si ves este mensaje de nuevo.',
        'NO_DISCUSSIONS_TAGGED_X' => 'No hay discusiones con etiqueta "%1$s".',
        'PAGE_TITLE_COLON' => 'Título de página:',
        'PAGE_CONTENT' => 'Contenido:',
        'CREATE_PAGE' => 'Crear página',
        'CREATE_NEW_PAGE' => 'Crear una nueva página',
        'YOUR_COMMENT' => 'Tu comentario',
        'ADD_YOUR_COMMENT' => 'Agregar comentario',
        'DELETE_PAGE' => 'Eliminar esta página',
        'DELETE_THIS_PAGE_Q' => '¿Eliminar esta página?',
        'ARE_YOU_SURE_DELETE_THIS_PAGE' => '¿Estás seguro de que querés eliminar esta página, incluyendo todos los comentarios? Este proceso puede tardar unos minutos.',
        'SEARCH_PAGES' => 'Buscar en páginas',
        'ALL_PAGES' => 'Todas las páginas',
        'SUBSCRIBE_TO_PAGES' => 'Suscribite a estas páginas',
        'NOBODY_HAS_ADDED_PAGES' => 'Todavía no se agregaron páginas!',
        'ADD_PAGES_CALL_TO_ACTION' => 'Crear una página para comenzar.',
        'CREATE_A_PAGE' => 'Crear una página',
        'PLEASE_ENTER_PAGE_CONTENT' => 'Ingresa el contenido de la página',
        'SEARCH_RESULTS_FOR_X' => 'Resultados para <em>%s</em>',
        'EDIT_YOUR_PAGE' => 'Editar tu página',
        'UPDATE_PAGE' => 'Actualizar página',
        'CLOSE_DISCUSSION' => 'Cerrar discusión',
        'REOPEN_DISCUSSION' => 'Re-abrir discusión',
        'CLOSING_DISCUSSION_PREVENTS' => 'Cerrar una discusión evita que se agreguen más respuestas',
        'NO_DISCUSSION_TO_DISPLAY' => 'No estás mostrando discusiónes en este momento.',
        'BOX_WILL_NOT_SHOW_DISCUSSION' => 'Este área no aparecerá para otros hasta que elijas por lo menos una discusión.',
        'NEWEST_DISCUSSIONS' => 'Discusiones recientes',
        'LATEST_REPLIES' => 'Respuestas recientes',
        'REPLIES_CLOSED_FOR_DISCUSSION' => 'Esta discusión se cerró.',
        'SORRY_DISCUSSION_CLOSED' => 'Esta discusión se acaba de cerrar para nuevas respuestas.',
        'MOST_REPLIES' => 'Con más respuestas',
        'OWNER_DISCUSSIONS_ONLY' => 'Sólo discusiones del creador de la red',
        'MY_DISCUSSIONS_ONLY' => 'Sólo mis discusiones',
        'DISCUSSION_DELETED' => 'Discusión eliminada',
        'DISCUSSION_HAS_BEEN_DELETED' => 'Esta discusión ya no está disponible.',
        'REPLY_DELETED' => 'Respuesta eliminada',
        'REPLY_HAS_BEEN_DELETED' => 'Esta respuesta se eliminó. <a %s>Volver a la discusión.</a>',
        'VIEW_ALL_DISCUSSIONS' => 'Ver todas las discusiones',
        'ADD_CATEGORIES' => 'Agregar categorías',
        'CATEGORY' => 'Categoría:',
        'NO_DISCUSSIONS_IN_CATEGORY' => 'No hay discusiones en esta categoría.',
        'ADD_MANAGE_CATEGORIES' => 'Agregar/Administrar categorías',
        'VIEW_ALL_N_CATEGORIES' => 'Ver todas las categorías de %s',
        'UNTITLED_CATEGORY' => 'Categoría sin título',
        'SAMPLE_TITLE' => 'Título ejemplo',
        'UNCATEGORIZED' => 'Sin categoría',
        'EXISTING_DISCUSSIONS' => 'Discusiones existentes que no tienen una categoría asignada.',
        'YOU_HAVE_NOT_ADDED_CATEGORIES' => 'No hay categorías. ¡Agregá una para comenzar!',
        'ADD_A_CATEGORY' => 'Agregar categoría',
        'ADD_ANOTHER_CATEGORY' => 'Agregar otra categoría',
        'MANAGE_CATEGORIES' => 'Administrar categorías',
        'CATEGORY_TITLE' => 'Titulo de categoría',
        'ALLOW_MEMBERS_TO_START_DISCUSSIONS' => 'Permitir que los miembros empiecen discusiones en esta categoría',
        'ONLY_I_CAN_START_DISCUSSIONS' => 'Sólo yo puedo empezar discusiones en esta categoría',
        'ALLOW_MEMBERS_TO_REPLY' => 'Permitir que los miembros respondan',
        'SUGGESTIONS' => 'Sugerencias:',
        'TRY_DIFFERENT_KEYWORDS' => 'Probá otras palabras claves, o términos más generales.',
        'VIEW_DISCUSSIONS_OR_START_DISCUSSION' => '<a %s>Ver todas las discusiones</a> o <a %s>Empezar una nueva discusión</a>',
        'MAKE_SURE_WORDS_SPELLED' => 'Asegurate de que las palabras estén bien escritas.',
        'REPLY_WAS_DELETED' => 'Esta respuesta se eliminó',
        'TAGS_X' => '<strong>Etiquetas:</strong> %s',
        'SEND_PRIVATE_MESSAGE' => 'Enviar mensaje privado',
        'PERMALINK_TO_REPLY' => 'Permalink a esta respuesta',
        'PERMALINK' => 'Permalink',
        'WE_COULD_NOT_FIND_ANY_DISCUSSIONS' => 'No pudimos encontrar discusiones con esa información.',
        'DISCUSSIONS_MATCHING_X' => 'Discusiones que incluyen <em>\'%s\'</em>',
        'SEARCH_DISCUSSIONS' => 'Buscar en foros',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS_2' => '¡No agregaste temas de discusión!',
        'ADD_DISCUSSIONS_AND_SHARE' => '¡Agrega discusiones y compartilas con tus amigos, con tu familia, y con el resto del mundo!',
        'DISCUSSION' => 'Discusión',
        'DISCUSSIONS' => 'Discusiones',
        'KEEP_PAGE_OPEN_FORUM' => 'Por favor, mantené abierta esta página para que podamos terminar de cargar tus archivos al foro.',
        'MEANWHILE_FEEL_FREE_FORUM' => 'Mientras tanto, podés <a %s>abrir una nueva ventana del explorador</a> y seguí usando %s.',
        'START_A_NEW_DISCUSSION' => 'Comenzar una nueva discusión',
        'DISCUSSION_TITLE' => 'Título de la discusión:',
        'FIRST_POST' => 'Publicación:',
        'UPLOAD_FILES' => 'Agregar archivos(s):',
        'START_DISCUSSION' => 'Comenzar discusión',
        'EDIT_DISCUSSION' => 'Editar discusión',
        'START_A_DISCUSSION' => 'Comenzar una discusión',
        'ALL_DISCUSSIONS' => 'Todas las discusiones',
        'CONTRIBUTORS' => 'Colaboradores',
        'MY_DISCUSSIONS' => 'Mis discusiones',
        'READ_MORE' => 'Leer más',
        'STARTED_T_BY' => 'Comenzada <strong>%s</strong> por:',
        'ADDED_BY_X_T' => 'Agregado por %s %s',
        'STARTED_BY_X_T' => 'Comenzada por %s %s',
        'REPLY_BY_X_T' => 'Respuesta de <strong>%s</strong> %s',
        'STARTED_BY_X_LAST_REPLY_LINK_BY_X_T' => 'Comenzada por %s. Última <a %s>respuesta</a> por %s %s.',
        'STARTED_DISCUSSION_LAST_REPLY_LINK_BY_X_T' => '<strong>Comenzo esta discusión.</strong> Última <a %s>respuesta</a> por %s %s.',
        'STARTED_DISCUSSION_T' => '<strong>Comenzó esta discusión</strong> %s',
        'ADDED_REPLY_T' => '<strong>Agregó una respuesta</strong> %s',
        'ADDED_POST_T' => '<strong>Agregó una publicación</strong> %s',
        'STARTED_BY_X_ON' => 'Comenzada por %s en %s',
        'STARTED_DISCUSSION_ON' => '<strong>Comenzó esta discusión</strong> %s',
        'STARTED_ON' => '<strong>Comenzada</strong> %s',
        'ADDED_REPLY_ON' => '<strong>Agregó una respuesta</strong> %s',
        'ADDED_POST_ON' => '<strong>Agregó una publicación</strong> %s',
        'XS_DISCUSSIONS' => 'Discusiones de %s',
        'XS_DISCUSSIONS_LOWERCASE' => 'Discusiones de %s',
        'VIEW_XS_DISCUSSIONS' => 'Ver las discusiones de %s',
        'VIEW_YOUR_DISCUSSIONS' => 'Ver tus temas de discusión',
        'TAGGED_X' => 'Etiquetadas: %s',
        'SUBSCRIBE_TO_DISCUSSIONS' => 'Subscribirse a estas discusiones',
        'SUBSCRIBE_TO_DISCUSSION' => 'Subscribirse a esta discusión',
        'SUBSCRIBE_TO_XS_DISCUSSIONS' => 'Subscribirse a las discusiones de %s',
        'ALL_DISCUSSIONS_TAGGED_X' => 'Todas las discusiones etiquetadas <em>\'%s\'</em>',
        'SUBSCRIBE_TO_DISCUSSIONS_TAGGED_X' => 'Subscribirse a las discusiones etiquetadas \'%s\'',
        'N_KB' => '%s KB',
        'N_MB' => '%s MB',
        'UPLOADING_FILES' => 'Subir archivos',
        'ATTACHMENTS' => 'Datos adjuntos',
        'YOUR_POST' => 'Tu publicación:',
        'YOUR_REPLY' => 'Tu respuesta:',
        'WOULD_YOU_LIKE_TO_UPLOAD_FILES' => '¿Querés subir archivos?',
        'ADD_YOUR_REPLY' => 'Agregá tu respuesta',
        'REPLIES_TO_THIS_DISCUSSION' => 'Respuestas a esta discusión',
        'POSTED_BY_X_ON' => 'Agregado por %s %s',
        'PLEASE_ENTER_TITLE' => 'Título',
        'PLEASE_ENTER_FIRST_POST' => 'Agrega la primera publicación para esta discusión.',
        'REPLY_TO_THIS' => 'Responder a esto',
        'DELETE_ATTACHMENT' => 'Eliminar datos adjuntos',
        'DELETE_ATTACHMENT_Q' => '¿Eliminar estos datos adjuntos?',
        'DELETE_REPLY' => 'Eliminar respuesta',
        'DELETE_THIS_DISCUSSION_Q' => '¿Eliminar esta discusión?',
        'ARE_YOU_SURE_DELETE_THIS_DISCUSSION' => 'Estás seguro de que querés borrar esta discusión (incluyendo respuestas)? Este proceso puede tardar unos minutos.',
        'DELETE_DISCUSSION' => 'Eliminar esta discusión',
        'NOBODY_HAS_ADDED_DISCUSSIONS' => 'Todavía no se agregaron discusiones.',
        'NOBODY_HAS_ADDED_DISCUSSIONS_ADD' => '¡Todavía no se agregaron discusiones! Agregá una.',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS' => 'Todavía no agregaste discusiones. ¡Agregá una!',
        'YOU_HAVE_NOT_STARTED_DISCUSSIONS' => 'Todavía no agregaste discusiones.',
        'YOU_HAVE_NOT_ADDED_TO_DISCUSSIONS' => 'Todavía no agregaste respuestas a discusiones.',
        'X_HAS_NOT_ADDED_DISCUSSIONS' => '%s no agregó discusiones.',
        'X_HAS_NOT_STARTED_DISCUSSIONS' => '%s no empezó discusiones.',
        'X_HAS_NOT_ADDED_TO_DISCUSSIONS' => '%s no agregó respuestas a discusiones.',
        'VIEW_DISCUSSIONS' => 'Ver discusiones',
        'VIEW_ALL_PEOPLE_ON_X' => 'Ver a toda la gente en %s',
        'THERE_ARE_NO_DISCUSSIONS' => 'No hay discusiones en tu red.',
        'GROUP_HAS_NO_DISCUSSIONS' => 'Este grupo no tiene discusiones.',
        'VIEW_DISCUSSIONS_IN_GROUP_FORUM' => 'Ver discusiones en el <a %s>foro de %s</a>!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT_ADD' => 'No hay discusiones con etiquetas "%1$s". Buscá <a %2$s>fotos con etiqueta "%1$s"</a> o <a %3$s>videos con etiqueta "%1$s"</a>. O agregá y etiquetá tus propias discusiones!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT' => 'No hay discusiones con etiquetas "%1$s". Buscá <a %2$s>fotos con etiqueta "%1$s"</a> o <a %3$s>videos con etiqueta "%1$s"</a>.',
        'THIS_BOX_WILL_NOT_SHOW_DISCUSSIONS' => 'Este área no aparecerá para otros hasta que haya discusiones para mostrar. ¿Por qué no creás una?',
        'DISCUSSIONS_I_STARTED' => 'Discusiones que yo empecé',
        'DISCUSSIONS_X_STARTED' => 'Discusiones empezadas por %s',
        'DISCUSSIONS_I_REPLIED_TO' => 'Discusiones a las que respondí',
        'DISCUSSIONS_X_REPLIED_TO' => 'Discusiones a las que %s respondió',
        'PLEASE_WRITE_SOMETHING_FOR_POST' => 'Escribí algo para tu publicación.',
        'PLEASE_WRITE_SOMETHING_FOR_REPLY' => 'Escribí algo para tu respuesta.',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION_X' => 'Hay un nuevo comentario en tu discusión "%s" en %s',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION' => 'Hay un nuevo comentario en una de tus discusiones en %s',
        'SOMEBODY_COMMENTED_DISCUSSION_ADDED_TO_X' => 'alguien hizo un comentario sobre una discusión que vos empezaste acerca de %s',
        'ABOUT_YOUR_DISCUSSION' => 'Acerca de tu discusión',
        'ABOUT_THIS_DISCUSSION' => 'Acerca de esta discusión',
        'USER_REPLIED_TO_A_DISCUSSION_ON_Y' => '%s contestó a una discusión en %s',
        'USER_REPLIED_TO_DISCUSSION_TITLE_ON_APPNAME' => '%s contestó a la discusión "%s" en %s',
        'PROBLEM_WITH_ICON' => 'Hubo un problema con el archivo de iconos',
        'GROUP_ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Los administradores del grupo tienen un nivel de control similar al del creador del grupo.',
        'CREATE_NEW_GROUP' => 'Crear nuevo grupo',
        'CREATE_A_NEW_GROUP' => 'Crear un nuevo grupo',
        'CREATE_A_GROUP' => 'Crear un grupo',
        'VIEW_GROUPS' => 'Ver grupos',
        'CREATE_GROUP' => 'Crear grupo',
        'PLEASE_ENTER_NAME_FOR_GROUP' => 'Elegí un nombre para tu grupo.',
        'PLEASE_ENTER_URL_FOR_GROUP' => 'Elegí una dirección web para tu grupo.',
        'URL_CAN_CONTAIN_ONLY_LETTERS' => 'La dirección  web puede incluir sólo letras y números (no espacios).',
        'NAME_TAKEN' => 'Ese nombre ya existe. Por favor, elegí otro.',
        'URL_TAKEN' => 'Esa dirección ya existe. Por favor elegí otra.',
        'GROUP_INFORMATION' => 'Información del grupo',
        'EXTERNAL_WEBSITE' => 'Sitio web externo',
        'DO_YOU_HAVE_EXISTING_WEBSITE' => '¿Tenés un sitio para el grupo en otro lugar?',
        'URL' => 'URL',
        'GROUPS' => 'Grupos',
        'SEARCH_GROUPS' => 'Buscar en grupos:',
        'NOBODY_HAS_CREATED_GROUPS' => 'Todavía no se crearon grupos.',
        'NOBODY_HAS_CREATED_GROUPS_ADD' => '¡Todavía nadie creó grupos! Creá uno para empezar.',
        'MY_GROUPS' => 'Mis grupos',
        'FEATURED_GROUPS' => 'Grupos elegidos',
        'YOU_CAN_CREATE_GROUP' => 'Podés <a %s>crear un nuevo grupo</a> en %s!',
        'GROUP_FORUM' => 'Foros de %s',
        'USER_CREATED_GROUP' => '%s creó este grupo en %s.',
        'GROUP_MEMBERS_COUNT' => 'Miembros de %s (%d)',
        'WE_ARE_SORRY_NOT_ALLOWED_JOIN_GROUP' => 'Acceso a este grupo es limitado.',
        'JOIN_GROUP_NOW' => '¡Unite a %s ahora!',
        'USER_HAS_INVITED_YOU_TO_JOIN_GROUP' => '%s te invitó a %s',
        'DECLINE' => 'No gracias',
        'WELCOME_TO_GROUP' => 'Bienvenido a %s',
        'YOU_CAN_PARTICIPATE_IN_GROUP' => 'Ahora podés participar en el foro %s.',
        'SEND_MESSAGE_TO_GROUP' => 'Enviar mensaje al grupo',
        'LEAVE_THIS_GROUP' => 'Abandonar este grupo',
        'EDIT_GROUP_INFO' => 'Editar la información de este grupo',
        'EDIT_GROUP_INFORMATION' => 'Editar la información de este grupo',
        'MANAGE_GROUP_MEMBERS' => 'Administrar los miembros del grupo',
        'GROUP_HAS_NO_MEMBERS' => '¡Este grupo todavía no tiene miembros!',
        'GROUP_HAS_NO_MEMBERS_THAT_MATCH' => 'Este grupo no tiene miembros que coincidan con tu búsqueda.',
        'USERS_GROUPS' => 'Grupos de %s',
        'YOU_HAVE_NOT_CREATED_GROUPS' => 'Todavía no creaste ningún grupo.',
        'USER_HAS_NOT_CREATED_GROUPS' => '%s todavía no creaste ningún grupo.',
        'THERE_ARE_NO_FEATURED_GROUPS' => 'No hay grupos elegidos en tu red social.',
        'START_FEATURING_GROUPS' => 'Elige grupos cuando veas la opción. Para saber más, <a %s>hace clic acá</a>.',
        'NO_GROUPS_TO_DISPLAY' => 'No estás mostrando ningún grupo en este momento.',
        'BOX_WILL_NOT_SHOW_GROUPS' => 'Este área no aparecerá para otros hasta que elijas por lo menos un grupo.',
        'YOU_HAVE_NOT_CREATED_GROUPS_2' => '¡Todavía no creaste ningún grupo!',
        'CREATE_GROUPS_AND_SHARE' => '¡Crea grupos y compartilos con tus amigos, con tu familia, y con el resto del mundo!',
        'THERE_ARE_NO_GROUPS' => 'No hay grupos en tu red en este momento.',
        'THIS_BOX_WILL_NOT_SHOW_GROUPS' => 'Este área no aparecerá para otros hasta que haya grupos para mostrar. ¿Por qué no creás uno?',
        'GROUPS_MATCHING_SEARCH_TERM' => 'Grupos que coinciden con <em>\'%s\'</em>',
        'WE_COULD_NOT_FIND_ANY_GROUPS' => 'No pudimos encontrar grupos que coincidan con los términos de tu búsqueda.',
        'VIEW_GROUPS_OR_CREATE_GROUP' => '<a %s>Ver todos los grupos</a> o <a %s>Crear un nuevo grupo</a>',
        'VIEW_ALL_GROUPS' => 'Ver todos los grupos',
        'DELETE_GROUP' => 'Eliminar grupo',
        'DELETE_GROUP_Q' => '¿Eliminar este grupo?',
        'GROUP_INVITATIONS' => 'Invitaciones al grupo',
        'YOU_HAVE_BEEN_INVITED_TO_JOIN' => 'Te invitaron a unirte a:',
        'VISIT' => 'Visita',
        'WHO_CAN_JOIN_GROUP' => '¿Quién puede unirse a este grupo?',
        'PRIVACY_CANNOT_BE_CHANGED' => 'La privacidad no puede cambiar una vez que se creó el grupo.',
        'ONLY_INVITED_PEOPLE' => 'Sólo personas invitadas',
        'ALLOW_PEOPLE_TO_REQUEST' => 'Permitir a la gente pedir invitaciones',
        'ANYONE_CAN_JOIN_GROUP' => 'Todos pueden unirse a este grupo',
        'ONLY_INVITED_PEOPLE_CAN_JOIN_GROUP' => 'Sólo gente invitada puede unirse a este grupo',
        'WHY_NOT_CREATE_GROUP' => '¿Por qué no <a %s>creás tu propio grupo</a>?',
        'PLEASE_ENTER_NAME' => 'Nombre',
        'PLEASE_ENTER_EMAIL_ADDRESS' => 'Dirección de correo electrónico',
        'PLEASE_ENTER_PAGE_ADDRESS' => 'Ingresá una nueva dirección de página.',
        'PLEASE_ENTER_PASSWORD' => 'Por favor ingresá la contraseña.',
        'CREATE_ACCOUNT_OR_SIGN_IN' => '<a %s>Hacé clic acá para crear una cuenta</a> o tratá de ingresar de nuevo usando el formulario a continuación.',
        'CREATE_ACCOUNT_OR_JOIN' => '<a %s>Hacé clic acá para crear una cuenta</a> intentá otra vez entrer con tu ID de Ning ID a continuación.',
        'CHOOSE_SHORTER_PASSWORD' => 'Por favor elegí una contraseña más corta.',
        'CHOOSE_SHORTER_NAME' => 'Por favor elegí un nombre más corto.',
        'ENTER_SHORTER_CITY_NAME' => 'Por favor elegí un nombre de ciudad más corto.',
        'PLEASE_ENTER_PASSWORD_AGAIN' => 'Ingresá tu contraseña otra vez en ek recuadro "Volver a ingresar contraseña".',
        'PLEASE_ENTER_CURRENT_PASSWORD' => 'Por favor ingresá tu contraseña actual.',
        'PLEASE_ENTER_NEW_PASSWORD' => 'Por favor ingresá tu nueva contraseña.',
        'PLEASE_ENTER_NEW_PASSWORD_AGAIN' => 'Por favor ingresá tu nueva contraseña otra vez en el recuadro "Confirmar contraseña".',
        'CURRENT_PASSWORD' => 'Contraseña actual',
        'PASSWORDS_DO_NOT_MATCH' => 'Las contraseñas son diferentes.',
        'NEW_AND_CONFIRMATION_PASSWORDS' => 'La nueva contraseña y la contraseña de confirmación no son iguales.',
        'YOUR_REQUEST_HAS_BEEN_SENT_TO_GROUP_CREATOR' => 'Tu pedido se envió al creador del grupo.',
        'X_IS_NOT_VALID_EMAIL_ADDRESS' => '%s no es una dirección de correo electrónico válida',
        'COME_JOIN_ME_ON_GROUP' => 'Vení y uníte a %s!',
        'INVITE_PEOPLE_TO_GROUP' => 'Invitar gente a %s',
        'INVITE_FRIENDS_TO_GROUP' => 'Invitar amigos a %s',
        'SEND_INVITATIONS_TO_JOIN_GROUP' => 'Envia invitaciones para unirse a %s.',
        'GROUPNAME_MEMBERS' => 'Miembros de %s',
        'GROUP_CREATOR' => 'Creador del grupo',
        'GROUP_ADMINISTRATOR' => 'Administrador del grupo',
        'DATE_BANNED' => 'Fecha de no admisión',
        'BAN_FROM_GROUP' => 'No admitir en el grupo',
        'ARE_YOU_SURE_BAN_MEMBER_FROM_GROUP' => 'Estás seguro de que no querés admitir a los miembros elegidos? Este proceso puede tardar unos minutos.',
        'ALSO_DELETE_FORUM_POSTINGS' => 'Eliminar también sus respuestas y discusiones.',
        'GROUP_WEB_ADDRESS' => 'Dirección Web del grupo',
        'GROUP' => 'Grupo',
        'BACK_TO_GROUP' => '← Volver a %s',
        'USER_BANNED_FROM_GROUP' => '%1$s no está admitido en este grupo. <a %2$s>Enviale un mensaje a %1$s</a>',
        'USER_ALREADY_GROUP_MEMBER' => '%1$s ya es un miembro de este grupo. <a %2$s>Enviale un mensaje a %1$s</a>',
        'GROUP_ADMIN_DISCUSSIONS' => 'Administrar discusiones del grupo',
        'BACK_TO_NETWORK_GROUPS' => 'Volver a grupos de %s',
        'MOST_MEMBERS' => 'Con más miembros',
        'THIS_SETS_URL_OF_GROUP' => 'Esto define la URL para tu grupo:<br />http://%s/<strong>groupwebaddress</strong>',
        'LIKE_WHAT_YOU_SEE' => '¿Te gusta lo que ves en %s? ¡Unite!',
        'LIKE_WHAT_YOU_SEE_GROUP' => '¿Te gusta lo que ves en %s? ¡Unite!',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => 'Creaste el grupo %1$s. Podés participar del foro %1$s o invitar a más personas a unirse.',
        'YOU_ARE_MEMBER_OF_GROUP_AND_CAN_INVITE' => 'Ya sos miembro de %1$s. Podés participar en el foro %1$s o invitar a más personas a unirse.',
        'NETWORK_DOES_NOT_HAVE_MUSIC' => 'Esta red todavía no tiene música.',
        'PERSON_DOES_NOT_HAVE_MUSIC' => 'Esta persona todavía no tiene música',
        'FIND_MORE_MUSIC_LIKE_THIS' => 'Buscá más música como esta en <em>%s</em>',
        'TRACKS' => 'Pistas',
        'ADD_MUSIC_TRACKS' => 'Agregar música',
        'CHOOSE_MUSIC_TRACKS' => 'Elegí canciones para agregar',
        'YOU_CAN_ADD_UP_TO_MP3' => 'Podés agregar hasta 4 MP3s por vez.',
        'UPLOAD_TRACKS' => 'Subir canciones',
        'ADD_TRACKS' => 'Agregar canciones',
        'ENTER_THE_URL_MP3_TO_ADD' => 'Ingresa la URL de cada MP3 que querés agregar:',
        'EACH_MP3_FILE_MAY_BE_UP_TO' => '¡Podés subir hasta 100 MP3s! Cada MP3 puede ser de hasta 20 MB, pero los archivos más chicos suben más rápido.',
        'BE_NICE' => 'Derechos de autor',
        'PLEASE_UPLOAD_ONLY_TRACKS' => 'Por favor, sólo subí canciones si tenés permiso del artista o de quien controla los derechos de autor.',
        'PLEASE_LINK_ONLY_TRACKS' => 'Por favor agregá vínculos a música que haya sido autorizada para distribución por Internet.',
        'MORE_WAY_TO_ADD_MUSIC' => 'Más formas de agregar música...',
        'ELLIP_FROM_ANOTHER_WEBSITE' => '...desde otro sitio web',
        'ADD_MUSIC_FROM_ANY_WEBSITE' => 'Agregá música de cualquier sitio web usando el vínculo al MP3.',
        'KEEP_PAGE_OPEN_MUSIC' => 'Mantené esta página abierta para completar la transferencia de canciones. ¡Te avisamos cuando hayan sido aprobadas!',
        'MEANWHILE_FEEL_FREE_MUSIC' => 'Mientras tanto, podés <a %s>abrir una nueva ventana del explorador</a> y continuar usando %s. Cuando termine la transferencia podrás agregar títulos y descripciones a tus canciones en esta ventana.',
        'TRACKS_EXCEEDED_LIMIT' => 'Las canciones sobrepasaron el límite de 10 MB por canción.',
        'EDIT_TRACK_INFORMATION' => 'Editar información de la pista',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_1' => 'Agregar un título, una descripción u otra información a las canciones que acabás de subir.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_2' => 'Agregarle un título, una descripción y otra información a esta canción.',
        'CANCEL_AND_RETURN_TO_PLAYLIST' => '« Cancelar y volver a la lista de reproducción',
        'TRACK_TITLE' => 'Canción',
        'TRACK_ARTIST' => 'Artista',
        'TRACK_ALBUM' => 'Álbum',
        'ENABLE_DOWNLOAD_LINK' => 'Habilitar un vínculo para descargas',
        'ALLOW_PEOPLE_TO_ADD_TRACK_TO_PROFILE' => 'Permitir a usuarios poner esta canción en sus páginas',
        'TRACK_ARTWORK' => 'Arte',
        'EDIT_PLAYLIST' => 'Editar lista de reproducción',
        'DRAG_TO_CHANGE_ORDER_PLAYLIST' => 'Para reorganizar tu lista de reproducción, hacé clic en la canción y arrastrala a la ubicación deseada en la lista.',
        'ADD_MUSIC_ELLIPSIS' => 'Agregar música...',
        'ELLIPSIS_FROM_YOUR_COMPUTER' => 'desde tu PC',
        'UPLOAD_MP3_FROM_YOUR_COMPUTER' => 'Subir MP3s de tu PC.',
        'DELETE_THIS_TRACK_Q' => '¿Eliminar esta canción?',
        'DELETE_TRACK' => 'Eliminar canción',
        'ARE_YOU_SURE_DELETE_THIS_TRACK' => '¿Estás seguro de que querés eliminar esta canción?',
        'PLAY' => 'reproducir',
        'GENRE' => 'Género',
        'YEAR' => 'Año',
        'LABEL' => 'Distribuidora',
        'EXPLICIT_LYRICS' => 'Letra explícita',
        'ARTIST_SITE' => 'Sitio del artista',
        'HOSTING_SITE' => 'Sitio de hosting',
        'LABEL_SITE' => 'Sitio de la distribuidora',
        'LICENSE' => 'Licencia',
        'SELECT_LICENSE' => '— Seleccionar licencia —',
        'LICENSE_NAME' => 'Nombre de la licencia',
        'LICENSE_URL' => 'URL de la licencia',
        'MUSIC' => 'Música',
        'ALLOW_PEOPLE_TO_UPLOAD_AND_SHARE_AUDIO' => 'Permitir que los usuarios suban y compartan audio',
        'PLAYLIST' => 'Lista de reproducción',
        'PODCAST' => 'Podcast',
        'MOST_RECENT_TRACKS' => 'Los más recientes',
        'FEATURED_TRACKS' => 'Destacados',
        'HIGHEST_RATED_TRACKS' => 'Los que tienen la calificación más alta',
        'NO_TRACKS_TO_PLAY' => 'No hay música en tu red social en este momento.',
        'BOX_WILL_NOT_SHOW_TRACKS' => 'Este área no aparecerá para otros hasta que haya canciones o podcasts. ¿Por qué no agregás una?',
        'NO_TRACKS_ON_PLAYLIST' => 'No hay canciones en esta lista en este momento.',
        'PLAYER_WILL_NOT_SHOW_TRACKS' => 'Este reproductor no aparecerá para otros hasta que haya canciones o podcasts. ¿Por qué no agregás una?',
        'NO_FEATURED_TRACKS' => 'No hay canciones destacadas en tu red.',
        'START_FEATURING_TRACKS' => 'Marcá como destacadas las canciones que escuchás y que querés que aparezcan en la página principal.',
        'VIEW_MUSICPLAYER' => 'Ver reproductor de música',
        'MY_PLAYLIST' => 'Mi lista de reproducción',
        'NETWORK_PLAYLIST' => 'Lista de reproducción de la red',
        'COPYRIGHT' => '© Todos los derechos reservados',
        'CC_BY_X' => 'Atribuciones creativas comunes  de %s',
        'CC_BY_SA_X' => 'Atribuciones creativas comunes compartir similares de %s',
        'CC_BY_ND_X' => 'Atribuciones creativas comunes sin derivaciones%s',
        'CC_BY_NC_X' => 'Atribuciones creativas comunes no comerciales %s',
        'CC_BY_NC_SA_X' => 'Atribuciones creativas comunes no comerciales compartir similares de %s',
        'CC_BY_NC_ND_X' => 'Atribuciones creativas comunes no comerciales compartir similares %s',
        'PUBLICDOMAIN' => 'Dominio público',
        'FACEBOOK_CONFIRM_DISABLE' => '¿Estás seguro?',
        'FACEBOOK_PLAYER_DISABLE' => 'Deshabilitar',
        'FACEBOOK_MUSIC_PLAYER_TITLE' => 'Reproductor de música',
        'FACEBOOK_MUSIC_PLAYER_DESC' => 'Permite a todos agregar una aplicación que usa tu selección de música a su página de Facebook.',
        'FACEBOOK_MUSIC_BUTTON' => 'Crear aplicación de Música &raquo;',
        'FACEBOOK_MUSIC_PLAYER_ENABLED' => 'El reproductor de música de Facebook ya está habilitado.',
        'FACEBOOK_VIDEO_PLAYER_TITLE' => 'Reproductor de video',
        'FACEBOOK_VIDEO_PLAYER_DESC' => 'Permite a los usuarios agregar una aplicación que usa un video tuyo a su página de Facebook.',
        'FACEBOOK_VIDEO_BUTTON' => 'Crear aplicación de video &raquo;',
        'FACEBOOK_VIDEO_PLAYER_ENABLED' => 'El reproductor de video de Facebook ya está habilitado.',
        'FACEBOOK_SLIDESHOW_PLAYER_TITLE' => 'Presentación de fotos',
        'FACEBOOK_SLIDESHOW_PLAYER_DESC' => 'Permite a los usuarios agregar una aplicación que usa tu presentación de fotos a su página de Facebook.',
        'FACEBOOK_SLIDESHOW_BUTTON' => 'Crear aplicación de fotos &raquo;',
        'FACEBOOK_SLIDESHOW_PLAYER_ENABLED' => 'El reproductor de fotos de Facebook ya está habilitado.',
        'FACEBOOK_PLATFORM_LOGO' => 'Logotipo de la plataforma Facebook',
        'FACEBOOK_QUICK_INTRO_1' => 'Facebook es una red popular que permite a desarrolladores crear aplicaciones que se pueden agregar a las páginas de los miembros de Facebook. Además de proveer funcionalidad, estas aplicaciones ayudan a llevar tráfico a tu sitio.',
        'FACEBOOK_QUICK_INTRO_2' => 'Con Ning, no tenés que ser un desarrollador de software para lograr esto. Elegí de las opciones en esta página y tu red social estará integrada en Facebook en segundos.',
        'FACEBOOK_ADD_DEVELOPER_BUTTON' => 'Botón Agregar desarrollador',
        'FACEBOOK_SETUP_NEW_APP_BUTTON' => 'Botón Configurar nueva aplicación',
        'FACEBOOK_YOUR_APPLICATIONS' => 'Tus aplicaciones de Facebook',
        'FACEBOOK_EMBEDDING' => 'Promoción Facebook',
        'FACEBOOK_SETUP' => 'Promoción Facebook',
        'FACEBOOK_PROMOTING' => 'Promoción de aplicaciones en Facebook',
        'FACEBOOK_VIEW_APP' => 'Ver aplicación',
        'FACEBOOK_ADD_THE' => 'Agregar los',
        'FACEBOOK_RECENT' => 'Los más recientes',
        'FACEBOOK_RECENTLY_FEATURED' => 'Destacados más recientes',
        'FACEBOOK_RECENTLY_ADDED' => 'Agregados más recientes',
        'FACEBOOK_PROMOTED' => 'Destacados',
        'FACEBOOK_RATED' => 'Los que tienen la calificación más alta',
        'FACEBOOK_POPULAR' => 'Populares',
        'FACEBOOK_MUSIC_WIDGET' => 'Widget de música',
        'FACEBOOK_VIDEO_WIDGET' => 'Widget de videos',
        'FACEBOOK_PHOTO_WIDGET' => 'Widget de fotos',
        'FACEBOOK_INSTR_FIRST_STEPS' => 'Primeros pasos',
        'FACEBOOK_INSTR_CLICK_HERE_TO_GO_TO_FACEBOOK' => 'Hacé clic acá para ir a Facebook y empezar a crear tu aplicación.',
        'FACEBOOK_INSTR_OPEN_FACEBOOK_IN_NEW_WINDOW' => 'Esto abrirá Facebook en una nueva ventana del explorador. Tendrás que ingresar a Facebook si todavía no lo hiciste.',
        'FACEBOOK_INSTR_FIRST_STEPS_1' => 'Si todavía no creaste una aplicación en Facebook, primero tendrás que agregar la aplicación Facebook Developer. Cuando hagas esto, Facebook dirá "No tenés aplicaciones." Hacé clic en <strong>Crear una</strong>.',
        'FACEBOOK_INSTR_FIRST_STEPS_2' => 'Si ya creaste una aplicación en Facebook, llegarás a la aplicación de Facebook Developer. Hacé clic en el botón <strong>Set Up New Application</strong>.',
        'FACEBOOK_INSTR_FIRST_STEPS_NEXT' => 'Próximo paso: Instrucciones acerca de la manera de preparar tu aplicación de %s para Facebook.',
        'FACEBOOK_INSTR_SETUP' => 'Instrucciones de configuración',
        'FACEBOOK_INSTR_SETUP_1' => '¡Bien! Ahora, los detalles. Facebook necesita alguna información básica para aceptar tu aplicación. Seguí los pasos a continuación.',
        'FACEBOOK_INSTR_SETUP_REQ_FIELDS' => 'Campos obligatorios',
        'FACEBOOK_INSTR_SETUP_2' => 'Elegí un nombre de aplicación: <strong>Application Name</strong>.',
        'FACEBOOK_INSTR_SETUP_3' => 'Aceptá los terminos de uso de Facebook.',
        'FACEBOOK_INSTR_SETUP_4' => 'Abrí la sección de campos opcionales -- <em>Optional Fields</em>.',
        'FACEBOOK_INSTR_SETUP_BASE_OPT' => 'Opciones básicas',
        'FACEBOOK_INSTR_SETUP_5' => 'Ingresa tu dirección de correo electrónico en el campo <strong>Support E-Mail</strong>.',
        'FACEBOOK_INSTR_SETUP_6' => 'Pegá la siguiente dirección web en el campo <strong>URL de devolución de llamada</strong>:',
        'FACEBOOK_INSTR_SETUP_7_EXAMPLE_X' => 'Elegí un nombre de URL para tu aplicación: <strong>Canvas Page URL</strong> (por ej. <em>%s</em>).',
        'FACEBOOK_INSTR_SETUP_8' => 'Elegí <strong>Yes</strong> para <em>Can your application be added on Facebook</em>.',
        'FACEBOOK_INSTR_SETUP_INST_OPT' => 'Opciones de instalación',
        'FACEBOOK_INSTR_SETUP_APP_DESC' => 'Escribí una descripción de la aplicación en <strong>Application Description</strong>.',
        'FACEBOOK_INSTR_SETUP_9' => 'Pegá el siguiente código en el campo <strong>Default FBML</strong>:',
        'FACEBOOK_INSTR_SETUP_9B_WIDE' => 'Para <strong>Default Profile Box Column</strong>, elegí <strong>Wide</strong>.',
        'FACEBOOK_INSTR_SETUP_9B_NARROW' => 'Para <strong>Default Profile Box Column</strong>, elegí <strong>Narrow</strong>.',
        'FACEBOOK_INSTR_SETUP_10' => 'En el campo <strong>Side Nav URL</strong> ingresá tu <em>Canvas Page URL</em> (creado en el paso &#8216;f&#8217; anteriormente). Asegurate de incluir la porción de la URL que dice http://apps.facebook.com/.',
        'FACEBOOK_INSTR_SETUP_11' => 'Escribí texto para el <strong>Attachment action</strong>. Esto es lo que aparecerá cuando envíes a alguien un mensaje en Facebook que incluya tu aplicación. Por ejemplo, si tu aplicación es de fotos, podrías ingresar "Fotos de mi red".',
        'FACEBOOK_INSTR_SETUP_12' => 'Pegá la siguiente dirección web en el campo <strong>URL de devolución de llamada</strong>:',
        'FACEBOOK_INSTR_APPLICATION_SETUP_PAGE' => 'Página de configuración de aplicación de Facebook',
        'FACEBOOK_INSTR_SETUP_DONE' => 'Cuando hayas terminado, hacé clic en el botón <strong>Submit</strong>.',
        'FACEBOOK_INSTR_SETUP_NEXT' => 'Próximo paso: Obtené tu Clave API y tu Secreto.',
        'FACEBOOK_API_INFO_TITLE' => 'Información de Facebook API',
        'FACEBOOK_API_INFO_DESC' => 'Para terminar, tenés que ingresar tu clave API y tu Secreto, y el Application URL, en los campos a continuación.',
        'FACEBOOK_API_INFO_FIND_KEY' => 'Podés encontrar la clave API y tu Secreto en tu página <a %s>My Applications</a> en Facebook (abrí una nueva ventana) bajo el título de la aplicación que acabás de crear.',
        'FACEBOOK_API_INFO_MY_APPLICATIONS_PAGE' => 'Página My Applications (resaltando la  ubicación del campo API information)',
        'FACEBOOK_API_INFO_KEY' => 'Clave API',
        'FACEBOOK_API_INFO_SECRET' => 'Secreto API',
        'FACEBOOK_URL_INFO_TITLE' => 'URL de aplicación de Facebook',
        'FACEBOOK_URL_INFO_DESC' => 'El URL de aplicación es el mismo que el <strong>Canvas Page URL</strong> que definiste antes (en el paso &#8216;f&#8217;).',
        'FACEBOOK_MUSIC_SHOULD_PLAY_FROM' => 'Las aplicaciones de música de Facebook usarán:',
        'FACEBOOK_VIDEO_SHOULD_PLAY_FROM' => 'Las aplicaciones de video de Facebook usarán el video que es:',
        'FACEBOOK_PHOTO_SHOULD_PLAY_FROM' => 'Las aplicaciones de fotos de Facebook usarán fotos de:',
        'FACEBOOK_PROMOTING_ON' => 'Promoción en Facebook',
        'FACEBOOK_SETUP_INSTR' => 'Instrucciones de configuración',
        'FACEBOOK_API_INFO' => 'Información de API',
        'FACEBOOK_DISABLE' => '¿Deshabilitar esta aplicación?',
        'FACEBOOK_TO_YOUR_FACEBOOK_PROFILE' => 'a tu perfil en Facebook',
        'FACEBOOK_BACK_TO_EMBEDDING' => 'Volver a Promoción en Facebook',
        'FACEBOOK_EMBEDDING_DESC' => 'Dejá que usuarios de Facebook pongan tus widgets e insignias en sus páginas de perfil.',
        'FACEBOOK_PROMOTE' => 'Para mejorar las posibilidades de conseguir usuarios, te recomendamos los siguientes pasos. Se puede acceder a estas opciones desde la página de Facebook <strong><a %s>My Applications</a></strong> (el vínculo abre una nueva ventana).',
        'FACEBOOK_PROMOTE_TITLE_ABOUT_PAGE' => 'Proveer una página Acerca de',
        'FACEBOOK_PROMOTE_TEXT_ABOUT_PAGE' => 'Le permite a los usuarios de Facebook saber qué hace tu aplicación. Para esto, usá el vínculo  <strong>Edit About Page</strong> junto al nombre de la aplicación que estás modificando.',
        'FACEBOOK_PROMOTE_TITLE_SUBMIT' => 'Presentá la aplicación en el directorio de Facebook',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_1' => 'Contále a todo el mundo sobre tu nueva aplicación usando el directorio Facebook de aplicaciones.',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_2' => 'Hacé clic en el vínculo <strong>Enviar aplicación</strong> junto al nombre de la aplicación que estás modificando. En la página siguiente podrás editar la descripción de la aplicación y además agregarle un logotipo.',
        'FACEBOOK_PROMOTE_TITLE_PROFILE' => 'Agregá la aplicación a tu perfil de Facebook',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_1' => 'Mostrá tu aplicación, agregándola a tu página de perfil de Facebook, después relajate y mirá como tus amigos hacen lo mismo.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_2' => 'Hacé clic en el vínculo <strong>Ver página acerca de</strong> de la aplicación que querés agregar a tu perfil, después elegí el botón Agregar aplicación en la página siguiente.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_3' => '¡Tu aplicación ahora está en la parte de abajo de tu página de perfil de Facebook!',
        'FACEBOOK_PROMOTE_MY_APPLICATIONS_PAGE' => 'Página de mis aplicaciones en Facebook',
        'FACEBOOK_MY_APPS' => 'Mis aplicaciones',
        'FORUM_TAB_TEXT' => 'Foro',
        'VIDEOS_TAB_TEXT' => 'Videos',
        'PHOTOS_TAB_TEXT' => 'Fotos',
        'GROUPS_TAB_TEXT' => 'Grupos',
        'YOUR_VIDEO_UPLOAD_TO_X_DID_NOT_COMPLETE_DUE_TO_A_CONVERSION_ERROR' => 'No se completó la carga del video en %s debido a un error de conversión.',
        'TO_HELP_TROUBLESHOOT_PROVIDE_THIS_VIDEO_ID_X' => 'Para encontrar la solución del problema, introducí la ID de este video: %s',
        'YOUR_VIDEO_WAS_SUCCESSFULLY_UPLOADED_TO_X' => 'Tu video se cargó con éxito en %s.',
        'TO_VIEW_THE_VIDEO_VISIT' => 'Para ver el video, andá a:',
        'YOUR_VIDEO_X_ON_Y_HAS_A_NEW_COMMENT' => 'Hay un nuevo comentario sobre tu video "%1$s" en %2$s.',
        'YOUR_VIDEO_ON_X_HAS_A_NEW_COMMENT' => 'Hay un nuevo comentario sobre tu video en %s.',
        'YOUR_PHOTO_X_HAS_A_NEW_COMMENT_ON_Y' => 'Hay un nuevo comentario de tu foto "%1$s" en %2$s.',
        'YOUR_PHOTO_HAS_A_NEW_COMMENT_ON_X' => 'Hay un nuevo comentario de tu foto en %s.',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y_ELLIPSIS' => 'Hay un nuevo %1$s que espera tu aprobación en %2$s…',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y' => 'Hay un nuevo %1$s que espera tu aprobación en %2$s.',
        'YOU_HAVE_A_NEW_X_TITLE_TO_APPROVE_ON_Y' => 'Hay un nuevo "%2$s" de %1$s que espera tu aprobación en %3$s.',
        'TO_APPROVE_THIS_X_VISIT' => 'Para aprobarlo %s, andá a:',
        'YOUR_X_ON_Y_HAS_BEEN_APPROVED_ELLIPSIS' => 'Se aprobó tu %1$s en %2$s…',
        'YOUR_TYPE_ON_X_HAS_A_NEW_COMMENT_ELLIPSIS' => 'Hay un nuevo comentario de tu %1$s en %2$s…',
        'CLICK_HERE_TO_JOIN' => 'Hacé clic acá para unirte:',
        'X_WANTS_YOU_TO_CHECK_OUT_Y_ON_Z' => '¡%1$s quiere que mires "%2$s" en %3$s!',
        'YOUR_X_HAS_BEEN_APPROVED_ON_Y' => 'Tu %s se aprobó en %s.',
        'YOUR_X_Y_HAS_BEEN_APPROVED_ON_Z' => 'Se aprobaron tus "%2$s" de %1$s en %3$s.',
        'TO_VIEW_YOUR_X_VISIT' => 'Para ver tus %s, andá a:',
        'TO_VIEW_THIS_X_VISIT' => 'Para ver este %s, andá a:',
        'TO_VIEW_IT_VISIT' => 'Para verlo, andá a:',
        'X_REPORTED_THE_FOLLOWING_ISSUE_ON_Y_ELLIPSIS' => '%1$s informó acerca del siguiente problema en %2$s…',
        'USER_HAS_SENT_YOU_A_MESSAGE_ON_X' => '%1$s te envió un mensaje en %2$s.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X' => '%1$s pidió ser miembro de %2$s en %3$s.',
        'TO_APPROVE_OR_DENY_USER_REQUEST' => 'Para aprobar o rechazar el pedido de %s, andá a:',
        'X_ADDED_A_COMMENT_TO_THE_BLOG_POST_Y_ON_Z' => '%1$s agregó un comentario a la publicación de blog "%2$s" en %3$s.',
        'X_ADDED_A_COMMENT_TO_A_BLOG_POST_ON_Y_ELLIPSIS' => '%1$s agregó un comentario a una publicación de blog en %2$s…',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X' => 'Hay un nuevo miembro que espera tu aprobación en %s.',
        'WELCOME_TO_THE_GROUP_X_ON_Y' => 'Bienvenido al grupo "%1$s" en %2$s',
        'LOADING_YOUR_FRIENDS' => 'Estamos cargando tus amigos…',
        'YOUR_MESSAGE_HAS_BEEN_SENT_TITLE_CASE' => 'Se envió tu mensaje',
        'TO_SEND_ANOTHER_MESSAGE' => 'Para enviar otro mensaje, escribí el texto acá abajo.',
        'PLEASE_CHOOSE_FRIENDS' => 'Seleccioná a algún amigo antes de enviar el mensaje.',
        'THESE_FRIENDS' => 'Estos amigos:',
        'ALL_FRIENDS' => 'Todos mis amigos',
        'ALL_FRIENDS_ON_APPNAME' => 'Todos mis amigos en %s',
        'SHARE_WITH_FRIENDS' => 'Compartir con amigos',
        'SHARE_THIS_WITH_FRIENDS' => 'Compartí este elemento con tus amigos',
        'COMPOSE_MESSAGE' => 'Crear mensaje',
        'INVITATION_LINK_ONLY_VISIBLE' => 'Este enlace de invitación solamente se encuentra visible para el Creador de la red y los Administradores. Los miembros que se unan a través de este enlace pasarán a ser amigos del Creador de la red en forma automática.',
        'WE_ARE_LOADING_ADDRESSES' => 'Estamos cargando tus direcciones…',
        'SELECT_ALL_NONE' => 'Seleccionar todos/ninguno',
        'INVITE_TO_APPNAME' => 'Invitar a \'%s\'',
        'INVITE_YOUR_FRIENDS_TO_APPNAME' => 'Invitá a tus amigos a \'%s\'',
        'ALREADY_MEMBER_OF_NETWORK' => '(Ya es miembro de esta red)',
        'OR_SHARE_THIS_INVITATION_LINK' => 'O compartí este enlace de invitación:',
        'CLICK_TO_MAIL' => '<a %s>Hacé clic acá para enviar el correo ahora</a>.',
        'MESSAGE_HAS_BEEN_SENT' => 'Se envió tu mensaje',
        'YOU_CAN_SHARE_THIS' => 'Podés compartirlo con más de las personas que aparecen a continuación o <a %s>volver a la página anterior</a>.',
        'VCARD_IMPORT_UNAVAILABLE' => 'El servicio de importación de vCard no está disponible en este momento.',
        'CSV_IMPORT_UNAVAILABLE' => 'El servicio de importación de CSV no está disponible en este momento.',
        'ERROR_OCCURRED' => 'Disculpá, hubo un error.',
        'IMPORT_FAILED' => 'Disculpá, no se pudo realizar la importación.',
        'LOGIN_FAILED' => 'Disculpá, no se pudo iniciar sesión.',
        'UNABLE_TO_FIND_EMAIL' => 'Disculpá, pero no encontramos el campo de correo electrónico.',
        'CANNOT_READ_VCARDS' => 'Disculpá, pero no podemos leer estas vCards.',
        'NO_ADDRESSES_FOUND' => 'No se encuentran las direcciones',
        'WE_DID_NOT_FIND_ADDRESSES' => 'No pudimos encontrar direcciones en la Libreta de direcciones que importamos.',
        'IMPORT_FROM_WEB_ADDRESS_BOOK' => 'Importar desde Libreta de direcciones en la Web',
        'IMPORT_FROM_ADDRESS_BOOK_APPLICATION' => 'Importar desde la aplicación Libreta de direcciones',
        'PRIVACY_POLICY' => 'Política de privacidad',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK_ON_Y' => '%1$s hizo el siguiente comentario sobre %2$s:',
        'CHECK_OUT_X_ON_Y_ELLIPSIS' => 'Mirá "%1$s" en %2$s…',
        'CHECK_OUT_THIS_X_ON_Y_ELLIPSIS' => 'Mirá este %1$s en %2$s…',
        'SEND_MESSAGE_TO_FRIENDS' => 'Enviar el mensaje a amigos',
        'PICK_VALID_ALL_FRIENDS_NOTIFICATION' => 'Por favor, elegí una opción válida para las notificaciones de los mensajes enviados a todos tus amigos',
        'WELCOME_MEMBER_N_OF_APPNAME_INVITE' => '¡Bienvenido, %1$s! Sos el miembro #%2$s de %3$s. <a %4$s>Invitá a amigos ahora</a>.',
        'YOU_COMMENTED_ON_PHOTO_TITLE' => 'Hiciste un comentario de la foto <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_PHOTO_TITLE' => '%s hizo un comentario de la foto <a %s>%s</a>',
        'YOU_COMMENTED_ON_VIDEO_TITLE' => 'Hiciste un comentario del video <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_VIDEO_TITLE' => '%s hizo un comentario del video <a %s>%s</a>',
        'THIS_IS_YOUR_PAGE' => 'Esta es tu página:',
        'MESSAGES_SENT_TO_ALL_FRIENDS' => 'Mensajes enviados a todos tus amigos',
        'TO_STOP_FOLLOWING_THIS_X_GO_TO' => 'Para dejar de seguir este %s, andá a:',
        'CHOOSE_GADGETS' => 'Elegí alguno de estos fantásticos gadgets  OpenSocial para agregar a tu página de perfil. Podés <a %s>ver y calificar los gadgets acá</a> o <a %s>saber más acerca de OpenSocial acá</a>.',
        'GADGETS_UNAVAILABLE' => 'Gadgets no disponibles por el momento',
        'APOLOGIES_GADGETS_UNAVAILABLE' => 'Disculpá. Los gadgets no están disponibles por el momento.',
        'BOX_WILL_NOT_SHOW_GADGET' => 'Esta área no aparecerá para otros visitantes si no elegís un Gadget.',
        'CLICK_EDIT_TO_SPECIFY_GADGET_OR_VISIT_GADGET_GALLERY' => 'Hacé clic en Editar para especificar la URL del Gadget para esta área o andá a  <a %s>Directorio de Gadgets</a>.',
        'PROBLEM_OCCURRED_RETRIEVING_GADGET' => 'Hubo un problema al tratar de obtener el feed de URL de este Gadget.',
        'ADD_GADGET_TO_YOUR_PAGE' => 'Agregar este gadget a tu perfil',
        'GADGETS_BETA' => 'Gadgets (Beta)',
        'TRY_OUT_OPENSOCIAL_GADGETS_WARNING_EXPERIMENTAL' => 'Probá los gadgets OpenSocial. Advertencia: esta  función es de prueba.',
        'ADD_TO_MY_PAGE' => 'Agregar a Mi página',
        'GADGETS' => 'Gadgets',
        'GADGETS_TAB_TEXT' => 'Gadgets',
        'GADGET' => 'Gadget',
        'GADGETS_IS_IN_BETA' => 'Los gadgets están en versión Beta.',
        'SORRY_GADGET_UNAVAILABLE' => 'Disculpá, este gadget no está disponible. Verificá que la dirección URL sea correcta. Si seguís teniendo problemas, <a %s>no dejes de avisarnos</a>.',
        'ALREADY_MEMBER_OF_GROUP' => '(Ya es miembro de este grupo)',
        'INVITE_YOUR_FRIENDS_TO_GROUPNAME' => 'Invitá a tus amigos a \'%s\'',
        'COME_JOIN_ME_ON_X_ON_Y' => 'Vení y unite a %1$s en %2$s.',
        'COME_JOIN_ME_ON_X_ON_Y_ELLIPSIS' => 'Vení y unite a %1$s en %2$s…',
        'INVITE_TO_GROUP' => 'Invitar a \'%s\'',

        'EACH_VIDEO_MAY_BE_100MB' => 'Los vídeos sólo pueden tener un tamaño de 100MB. Admitimos vídeos en formato .mov, .mp4, .mpg, .avi, .wmv y 3gp. ',
        'I_HAVE_RIGHT_TO_UPLOAD_VIDEO' => 'Tengo derecho a cargar este vídeo según los <a %s>Términos de servicio</a>. ',
        'VIDEO_UPLOADER_REQUIRES_JAVA' => 'El nuevo programa para cargar vídeos necesita una versión más reciente de Java. <strong><a %s>Haz clic aquí para instalar Java</a></strong>, o <strong><a %s>volver al cargador sencillo</a></strong>. ',
        'UPLOAD_A_VIDEO_FROM_YOUR_COMPUTER' => 'Cargar un vídeo desde tu ordenador ',
        'HAVE_LOT_OF_VIDEOS' => '¿Tienes muchos vídeos que compartir? ',
        'TRY_BULK_VIDEO_UPLOADER' => 'Prueba el nuevo cargador de vídeos ',
        'VIDEOS_SUCCESSFULLY_UPLOADED' => 'Tus vídeos se han cargado con éxito. ',
        'VIDEOS_UPLOADED_AWAITING' => 'Tus vídeos se han cargado con éxito, ahora el creador de %s\ tiene que aprobarlos. ',
        'ADD_VIDEOS_OR_PHOTOS_TO_APPNAME' => 'Añade vídeos o fotos directamente a % desde tu teléfono mandándolos a una dirección de correo electrónico única. ',
        'GRAB_HTML_EMBED' => 'Copia el código HTML \'embed\' de cualquier sitio de vídeos y añade ese vídeo a tu red social. ',
        'GOOGLE' => 'Google ',
        'YOUTUBE' => 'YouTube ',
        'HAVING_PROBLEMS_WITH_VIDEO_UPLOADER' => '¿Tienes problemas con el nuevo cargador de vídeos?  <strong><a %s>Vuelve al cargador de vídeos sencillo.</a></strong>. ',
        'ADD_VIDEOS_FROM_YOUTUBE' => 'Añade vídeos de YouTube o Google ',
        'TAGS_NO_COLON' => 'Etiquetas ',
        'NO_VIDEOS_TAGGED_X_CHECK' => 'No hay vídeos con etiqueta "%1$s". Puedes ver <a %2$s>discusiones con etiqueta "%1$s"</a>, <a %4$s>post de blog con etiqueta "%1$s"</a> o<a %3$s>fotos con etiqueta "%1$s"</a>. También puedes añadir y etiquetar tus propios vídeos. ',
        'UPLOAD_VIDEOS_FROM' => 'Carga vídeos desde tu ordenador ',
        'ADD_VIDEOS_BY_PHONE_OR' => 'Añade vídeos por teléfono o e-mail. ',
        //music player
        'FEATURING_ELLIPSIS' => 'Destacando...',
        'NOW_FEATURED_ON_MAIN' => 'Ahora está en el menú principal ',
         'OPEN_POPUP_WINDOW' => 'Abrir ventana emergente',
        'DONT_FEATURE' => 'No ponerlo ',
        'UNFEATURING_ELLIPSIS' => 'Quitarlo del menú principal... ',
        'REMOVED_FROM_MAIN' => 'Quitado del menú principal ',
        'ADDED_EXCLAMATION' => '¡Añadido! ',
        'ERROR' => 'Error ',
        'ADDING_ELLIPSIS' => 'Añadiendo... ',
        'TRACK_COULD_NOT_BE_LOADED' => 'No se ha podido cargar la canción ',
        'INVALID_URL' => 'URL inválida ',
        'NORMAL_PLAYBACK_ON' => 'Play-back normal: encendido ',
        'REPEAT_PLAYBACK_ON' => 'Repetir play-back: encendido ',
        'SHUFFLE_PLAYBACK_ON' => 'Mezclar play-back: encendido ',
        'LOADING_PLAYLIST_ELLIPSIS' => 'Cargar lista de canciones... ',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Se han exportado tus datos de los miembros. Haz clic <a %s>en este enlace</a> para guardarlos en tu escritorio. ',
        'SET_NEW_PASSWORD' => 'Configura una contraseña nueva para tu cuenta. ',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Haz clic en \'Editar\' para añadir texto, HTML, vídeos, fotos o  <a %1$s>Widgets externos</a> a esta caja ',
        'EACH_PHOTO_MAY_BE_UP_TO_10MB' => 'Las fotos no deben tener un tamaño superior a 100MB. Admitimos fotos en formato .jpg, .gif y .png. ',
        'I_HAVE_RIGHT_TO_UPLOAD_PHOTOS' => 'Tengo derecho a cargar estas fotos según los <a %s>Términos de servicio</a>. ',
        'PHOTO_UPLOADER_REQUIRES_JAVA' => 'El nuevo cargador de fotos necesita una versión más reciente de Java. <strong><a %s>Haz clic aquí para instalar Java</a></strong> o <strong><a %s>volver al cargador sencillo</a></strong>. ',
        'TRY_BULK_PHOTO_UPLOADER' => 'Prueba el nuevo cargador de fotos ',
        'HAVE_LOT_OF_PHOTOS' => '¿Tienes muchas fotos que compartir? ',
        'PHOTOS_SUCCESSFULLY_UPLOADED' => 'Tus fotos se han cargado con éxito. ',
        'PHOTOS_UPLOADED_AWAITING' => 'Tus fotos se han cargado con éxito, ahora el creador de %s tiene que aprobarlas. ',
        'FLICKR' => 'Flickr ',
        'ADD_PHOTOS_FROM_FLICKR' => 'Añade fotos de Flickr ',
        'ADD_PHOTOS_OR_VIDEOS_TO_APPNAME' => 'Añade fotos o vídeos a %s directamente desde tu teléfono mandándolas a través de una dirección de correo electrónico única. ',
        'HAVING_PROBLEMS_WITH_PHOTO_UPLOADER' => '¿Tienes problemas con el nuevo cargador de fotos?  <strong><a %s>Vuelve al cargador sencillo </a></strong>. ',
        'VIEW_SLIDESHOW' => 'Ver exposición de fotos ',
        'NO_PHOTOS_TAGGED_X_CHECK' => 'No hay ninguna foto con etiqueta "%1$s". Puedes ver <a %2$s>discusiones con etiqueta "%1$s"</a>, <a %4$s>noticias de blog con etiqueta "%1$s"</a> o <a %3$s>vídeos con etiqueta "%1$s"</a>. También puedes añadir y etiquetar tus propias fotos. ',
        'PHOTO_MAY_BE_10MB' => 'Las fotos pueden tener 10MB como máximo, pero las fotos más pequeñas se cargarán más rápido. Admitimos fotos en formato .jpg, .gif, .png. ',
        'UPLOAD_PHOTOS_FROM_YOUR_COMPUTER' => 'Cargar fotos desde tu ordenador ',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Haz clic en \'Editar\' para añadir texto, HTML, vídeos, fotos o  <a %1$s>Widgets externos</a> a esta caja ',
        'PLEASE_SELECT_A_MEMBER' => 'Por favor elige uno o más miembros ',
        'RESEND_INVITATION' => 'Reenviar invitación ',
        'CHOOSE_FRIENDS' => 'Elige amigos... ',
        'SORRY_WE_DO_NOT_SUPPORT' => 'Lo sentimos, no admitimos la libreta de dirección de esta Web. Intenta hacer clic en  \'aplicación de email\' que está abajo para usar las direcciones de tu ordenador. ',
        'WANT_TO_INVITE_MORE_FRIENDS' => '¿Quieres invitar a más amigos? Invita a más amigos importando contactos de la libreta de direcciones de tu Web o tu aplicación de email. ',
        'MICROSOFT_OUTLOOK_APPLE_ADDRESS_BOOK' => 'Microsoft Outlook, Apple Mail, .CSV, etc. ',
        'SET_NEW_PASSWORD' => 'Configura una contraseña nueva para tu cuenta. ',
        'APPLY_FOR_MEMBERSHIP_SIGN_IN' => ' Pide la membresía ahora. ¿Ya eres miembro? <a %s>Haz clic aquí para iniciar la sesión</a>. ',
        'FEATURED_MEMBERS' => 'Miembros que se muestran ',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Se han exportado tus datos de los miembros. Haz clic <a %s>en este enlace</a> para guardarlos en tu escritorio. ',
        'SORRY_NO_MEMBERS_MATCHING_X_WERE_FOUND' => 'Lo sentimos, no se han encontrado miembros  que coincidan con "%s". ',
        'WHO_CAN_COMMENT_ON_POST' => '¿Quién puede comentar en este post? ',
        'PREVIOUS_POST' => '←Post anterior ',
        'NEXT_POST' => 'Siguiente post  → ',
        'PREVIOUS_POSTS' => '←Posts anteriores ',
        'NEXT_POSTS' => 'Siguientes posts  → ',
        'NO_BLOG_POSTS_TAGGED_X_CHECK' => 'No hay post con etiqueta "%1$s". Puedes ver <a %2$s>discusiones con etiqueta "%1$s"</a>, <a %4$s>fotos con etiqueta "%1$s"</a> or <a %3$s>vídeos con etiqueta "%1$s"</a>. También puedes añadir y etiquetar tus propios posts. ',
        'ALL_POSTS_TAGGED_X_FOR_M_Y' => 'Todos los posts están etiquetados <em>\'%s\'</em> para %s %s ',
        'ALL_POSTS_TAGGED_X' => 'Todos los posts están etiquetados <em>\'%s\'</em> ',
        'MY_BLOG_POSTS_FOR_M_Y' => 'Mis post de blog para %s %s ',
        'MY_BLOG_POSTS' => 'Mis posts de blog ',
        'PRIVACY_CONTENT_CONTROL' => 'Privacidad y control de contenidos ',
        'MODERATION' => 'Control de contenidos ',
        'ENABLE_MUSIC_DOWNLOAD_LINKS' => 'Enlaces de descarga para habilitar el reproductor de música ',
        'NOTIFY_BLOG_PING_SERVICES' => '¿Quieres activar los servicios de rastreo de otros amigos cuando añadas un post nuevo? ',
        'YES_NOTIFY_BLOG_SERVICES' => 'Sí —  notificar <a %s>servicios de actualización del sitio</a> cuando añado un post nuevo ',
        'THERE_ARE_NO_FEATURED_MEMBERS' => 'No hay miembros publicados en tu red social. ',
        'START_FEATURING_MEMBERS_CLICK_Y' => 'Comienza a promocionar miembros cuando veas la opción de Promocionar. Para saber más sobre Promocionar, <a %s>Haz clic aquí</a>. ',
        'SHOW_ALL' => 'Mostrar todos ',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_ADD' => 'No hay discusiones etiquetadas "%1$s". Puedes ver <a %2$s>fotos etiquetadas "%1$s"</a>, <a %4$s>post de blog etiquetados "%1$s"</a> o <a %3$s>vídeos etiquetados"%1$s"</a>. También puedes añadir y etiquetar tus propias discusiones. ',
        'NO_DISCUSSIONS_TAGGED_X_CHECK' => 'No hay discusiones con etiqueta "%1$s". Puedes ver <a %2$s>fotos con etiqueta "%1$s"</a>, <a %4$s>post de blog con etiqueta "%1$s"</a> o <a %3$s>vídeos con etiqueta "%1$s"</a>. ',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => 'Has creado el grupo %1$s. Puedes iniciar una discusión en el foro %1$s o invitar a más gente para que se una. ',
        'YOU_CAN_ADD_100_SONGS' => 'Puedes añadir un total de 100 canciones, ninguna de más de 20MB de tamaño. Admitimos canciones con formato .mp3. ',
        'I_HAVE_RIGHT_TO_UPLOAD_SONGS' => 'Tengo derecho a cargar canciones según los <a %s">Términos de servicio</a>. ',
        'MUSIC_UPLOADER_REQUIRES_JAVA' => 'El nuevo cargador de canciones requiere una versión más reciente de Java. <strong><a %s>Haz clic aquí para instalar Java</a></strong>, o <strong><a %s>volver al cargador sencillo</a></strong>. ',
        'HAVE_LOT_OF_MUSIC' => '¿Tienes mucha música que compartir? ',
        'TRY_BULK_MUSIC_UPLOADER' => 'Prueba el nuevo cargador de música ',
        'SONGS_SUCCESSFULLY_UPLOADED' => 'Tus canciones se han cargado con éxito. ',
        'SORRY_YOU_CAN_ONLY_HAVE_N_TRACKS' => 'Lo sentimos, sólo puedes añadir %s canciones más en tu lista de canciones. Por favor borra canciones antes de añadir más. ',
        'ADD_MUSIC_FROM_WEBSITE' => 'Añadir música desde otro sitio Web ',
        'HAVING_PROBLEMS_WITH_MUSIC_UPLOADER' => '¿Tienes problemas con este cargador de música?  <strong><a %s>Vuelve al cargador sencillo</a></strong>. ',
        'UPLOAD_MUSIC_FROM_YOUR_COMPUTER' => 'Carga música desde tu ordenador ',
        'ADD_MUSIC' => 'Añadir música ',
        'FACEBOOK_INSTR_SETUP_APP_PERMISSION' => 'Elige <strong>usuarios</strong> y<strong>todas las páginas</strong>. ',

    );

    /**
     * If the given widget title is the default English title for the widget,
     * translate it into the current language.
     *
     * @param $widgetTitle string  The title of the widget
     * @return string  A translated title if the title is the English default; otherwise, the title unchanged
     */
    public static function translateDefaultWidgetTitle($widgetTitle) {

        return $widgetTitle;
    }

}