<?php

XG_App::includeFileOnce('/lib/XG_AbstractMessageCatalog.php');

/**
 * Texts for the English (Great Britain) locale.
 */
class XG_MessageCatalog_en_GB extends XG_AbstractMessageCatalog {


    /**
     * Returns a localized version of a string. The first argument is the message name, e.g., 'ADD_A_PHOTO'.
     * Subsequent arguments are substitution values (if the message contains sprintf format elements).
     *
     * @param $args array the message name, plus optional substitution values
     * @return string the localized string
     * @see xg_html()
     */
    public static function text($args) {
        $s = $args[0];
        static $a = array();
        if (! $a) {
            $a['N_SECONDS_AGO']['1'] = '1 second ago ';
            $a['N_SECONDS_AGO']['n'] = '%s seconds ago ';
            $a['N_MINUTES_AGO']['1'] = '1 minute ago ';
            $a['N_MINUTES_AGO']['n'] = '%s minutes ago ';
            $a['N_HOURS_AGO']['1'] = '1 hour ago ';
            $a['N_HOURS_AGO']['n'] = '%s hours ago ';
            $a['N_VIDEOS']['1'] = '<strong>1</strong> Video ';
            $a['N_VIDEOS']['n'] = '<strong>%s</strong> Videos ';
            $a['N_VIEWS']['1'] = '1 view ';
            $a['N_VIEWS']['n'] = '%s views ';
            $a['N_COMMENTS']['1'] = '<span class="comment-count">1</span> Comment ';
            $a['N_COMMENTS']['n'] = '<span class="comment-count">%s</span> Comments ';
            $a['VIDEO_IS_FAVORITE_OF']['1'] = 'This video is a <strong>favorite</strong> of <strong>1 person</strong>. ';
            $a['VIDEO_IS_FAVORITE_OF']['n'] = 'This video is a <strong>favorite</strong> of <strong>%s people</strong>. ';
            $a['Y_ADDED_X_VIDEOS']['1'] = '%2$s added a video: ';
            $a['Y_ADDED_X_VIDEOS']['n'] = '%2$s added %s videos. ';
            $a['YOU_ADDED_X_VIDEOS']['1'] = 'You added a video: ';
            $a['YOU_ADDED_X_VIDEOS']['n'] = 'You added %s videos. ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['1'] = 'There is 1 video on %2$s ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['n'] = 'There are %1$s videos on %2$s ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['1'] = 'There is 1 <a href="%3$s">video</a> on %2$s ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['n'] = 'There are %1$s <a href="%3$s">videos</a> on %2$s ';
            $a['N_PHOTOS_FROM_ALBUM']['1'] = '1 photo from this album has been deleted or made private, so it can\'t be displayed. ';
            $a['N_PHOTOS_FROM_ALBUM']['n'] = '%s photos from this album have been deleted or made private, so they can\'t be displayed. ';
            $a['N_PHOTOS']['1'] = '<strong>1</strong> Photo ';
            $a['N_PHOTOS']['n'] = '<strong>%s</strong> Photos ';
            $a['N_PHOTOS_2']['1'] = '1 photo ';
            $a['N_PHOTOS_2']['n'] = '%s photos ';
            $a['PROBLEM_UPLOADING_FILES']['1'] = 'There was a problem uploading the following file: ';
            $a['PROBLEM_UPLOADING_FILES']['n'] = 'There was a problem uploading the following files: ';
            $a['PHOTO_IS_FAVORITE_OF']['1'] = 'This photo is a <strong>favorite</strong> of <strong>1 person</strong>. ';
            $a['PHOTO_IS_FAVORITE_OF']['n'] = 'This photo is a <strong>favorite</strong> of <strong>%s people</strong>. ';
            $a['RATING_Y_AFTER_X_VOTES']['1'] = '<strong>Rating:</strong> %2$s after 1 vote ';
            $a['RATING_Y_AFTER_X_VOTES']['n'] = '<strong>Rating:</strong> %2$s after %s votes ';
            $a['Y_AFTER_X_VOTES']['1'] = '%2$s after 1 vote ';
            $a['Y_AFTER_X_VOTES']['n'] = '%2$s after %s votes ';
            $a['N_PEOPLE']['1'] = '1 person ';
            $a['N_PEOPLE']['n'] = '%s people ';
            $a['N_OF_5_STARS']['1'] = '1/5 star ';
            $a['N_OF_5_STARS']['n'] = '%s/5 stars ';
            $a['YOUR_RATING_X_STARS']['1'] = 'Your rating: 1 star ';
            $a['YOUR_RATING_X_STARS']['n'] = 'Your rating: %s stars ';
            $a['Y_ADDED_X_PHOTOS']['1'] = '%2$s added a photo: ';
            $a['Y_ADDED_X_PHOTOS']['n'] = '%2$s added %s photos. ';
            $a['YOU_ADDED_X_PHOTOS']['1'] = 'You added a photo: ';
            $a['YOU_ADDED_X_PHOTOS']['n'] = 'You added %s photos. ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['1'] = 'There is 1 photo on %2$s ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['n'] = 'There are %1$s photos on %2$s ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['1'] = 'There is %1$s <a href="%3$s">photo</a> on %2$s ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['n'] = 'There are %1$s <a href="%3$s">photos</a> on %2$s ';
            $a['N_INVITATIONS_RESENT']['1'] = '1 invitation has been re-sent. ';
            $a['N_INVITATIONS_RESENT']['n'] = '%s invitations have been re-sent. ';
            $a['AND_X_OTHER_PEOPLE']['1'] = 'and 1 other person ';
            $a['AND_X_OTHER_PEOPLE']['n'] = 'and %s other people ';
            $a['N_COMMENTS_ON_PAGE']['1'] = '<strong>1</strong> Profile Comment ';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s</strong> Profile Comments ';
            $a['N_BLOG_COMMENTS']['1'] = '<strong>1</strong> Blog Comment ';
            $a['N_BLOG_COMMENTS']['n'] = '<strong>%s</strong> Blog Comments ';
            $a['N_YEARS_OLD']['1'] = '1 year old ';
            $a['N_YEARS_OLD']['n'] = '%s years old ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['1'] = 'You have 1 friend request! ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['n'] = 'You have %s friend requests! ';
            $a['COMMENT_WALL_N_COMMENTS']['1'] = 'Comment Wall (1 comment) ';
            $a['COMMENT_WALL_N_COMMENTS']['n'] = 'Comment Wall (%s comments) ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['1'] = '1 new member joined during the past week ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['n'] = '%s new members joined during the past week ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['1'] = '1 <a href="%2$s">new member</a> joined during the past week ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['n'] = '%1$s <a href="%2$s">new members</a> joined during the past week ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['1'] = 'There is 1 member on %2$s ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['n'] = 'There are %1$s members on %2$s ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['1'] = 'There is 1 <a href="%3$s">member</a> on %2$s ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['n'] = 'There are %1$s <a href="%3$s">members</a> on %2$s ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['1'] = 'There is 1 blog post on %2$s ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['n'] = 'There are %1$s blog posts on %2$s ';
            $a['N_NEW_MEMBERS']['1'] = '<strong>1</strong> New Member ';
            $a['N_NEW_MEMBERS']['n'] = '<strong>%s</strong> New Members ';
            $a['N_REPLIES']['1'] = '1 Reply ';
            $a['N_REPLIES']['n'] = '%s Replies ';
            $a['N_MINUTES']['1'] = '1 minute left to edit your comment. ';
            $a['N_MINUTES']['n'] = '%s minutes left to edit your comment. ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['1'] = 'There is 1 forum topic on %2$s ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['n'] = 'There are %1$s forum topics on %2$s ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['1'] = 'There is 1 <a href="%3$s">forum topic</a> on %2$s ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['n'] = 'There are %1$s <a href="%3$s">forum topics</a> on %2$s ';
            $a['N_INVITES']['1'] = '%s invite ';
            $a['N_INVITES']['n'] = '%s invites ';
            $a['N_MEMBERS']['1'] = '1 member ';
            $a['N_MEMBERS']['n'] = '%s members ';
            $a['N_MEMBERS_PARENTHESIZED']['1'] = '(1 member) ';
            $a['N_MEMBERS_PARENTHESIZED']['n'] = '(%s members) ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['1'] = 'There is 1 group on %2$s ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['n'] = 'There are %1$s groups on %2$s ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['1'] = 'There is %1$s <a href="%3$s">group</a> on %2$s ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['n'] = 'There are %1$s <a href="%3$s">groups</a> on %2$s ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['1'] = '1 song from this playlist can\'t be displayed because it has been deleted or is no longer shared. ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['n'] = '%s songs from this playlist can\'t be displayed because they have been deleted or are no longer shared. ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['1'] = 'A new song has been added to %2$s ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['n'] = '%1$s new songs have been added to %2$s ';
            $a['Y_ADDED_X_SONGS']['1'] = '%2$s added a song: ';
            $a['Y_ADDED_X_SONGS']['n'] = '%2$s added %s songs. ';
            $a['YOU_ADDED_X_SONGS']['1'] = 'You added a song: ';
            $a['YOU_ADDED_X_SONGS']['n'] = 'You added %s songs. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['1'] = '1 song added to this playlist. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['n'] = '%s songs added to this playlist. ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['1'] = 'There is 1 song on %2$s ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['n'] = 'There are %1$s songs on %2$s ';
            }
        if ($a[$args[0]]) {
            $args[0] = $a[$args[0]][$args[1]] ? $a[$args[0]][$args[1]] : $a[$args[0]]['n'];
            return @call_user_func_array('sprintf', $args);
        }
        $text = self::$messages[$s];
        if ($text) { $args[0] = $text; }
        return @call_user_func_array('sprintf', $args);
    }

    /**
     * Message names and texts. Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;
     */
    private static $messages = array(
        'BROWSING' => 'Browsing',
        'MORE_VIDEOS' => 'More Videos',
        'NETWORK_DOES_NOT_HAVE_VIDEOS' => 'This network doesn\'t have any videos yet.',
        'NETWORK_DOES_NOT_HAVE_FEATURED_VIDEOS' => 'This network doesn\'t have any featured videos yet.',
        'PERSON_DOES_NOT_HAVE_VIDEOS' => 'This person doesn\'t have any videos yet.',
        'COPY_TO_CLIPBOARD'								=> 'Copy to Clipboard',
        'COPIED_TO_CLIPBOARD'							=> 'Copied to Clipboard!',
        'NO_VIDEOS_TO_DISPLAY'							=> 'You are currently displaying no videos.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_VIDEO'			=> 'This box won\'t show up for other people unless you select at least one video. ',
        'WATERMARK_LOGO'								=> 'Watermark Logo',
        'CHOOSE_HEADER_OR_WATERMARK'					=> 'You can choose either a header or watermark logo for your video player.',
        'CUSTOMIZE_EMBED_INSTRUCTIONS'					=> 'The logo appears at the top of your %s. If you don\'t add a logo, the network name will be displayed instead. Your logo should be in .jpg, .gif or .png format. Logos taller than 20 pixels will be resized to fit.',
        'CUSTOMIZE_WATERMARK_INSTRUCTIONS'				=> 'The watermark logo appears above the bottom right corner of the video clip.',
        'HEADER_LOGO'									=> 'Header Logo',
        'WATERMARK'										=> 'Watermark',
        'CUSTOMIZE_YOUR_VIDEO_PLAYER'					=> 'Customise Your Video Player!',
        'VIDEO_PLAYER'									=> 'Video Player',
        'HEADER'										=> 'Header',
        'SAVE_CHANGES'									=> 'Save Changes',
        'THUMBNAIL'										=> 'Thumbnail',
        'CONVERSION_FAILED'								=> 'Conversion Failed',
        'CONVERSION_IN_PROGRESS'						=> 'Conversion in Progress',
        'MAP'											=> 'Map',
        'WHAT_IS_THIS'									=> 'What\'s This?',
        'EDIT_VIDEO_INFORMATION'						=> 'Edit Video Information',
        'ALL_VIDEOS'									=> 'All Videos',
        'VIDEOS_HOME'									=> 'Videos Home',
        'MY_VIDEOS'										=> 'My Videos',
        'MY_FRIENDS_VIDEOS'								=> 'My Friends\' Videos',
        'MY_FAVORITES'									=> 'My Favourites',
        'XS_FAVORITES'									=> '%s\'s Favourites',
        'ADD_A_VIDEO'									=> 'Add a Video',
        'JUST_NOW'										=> 'just now',
        '1_DAY_AGO'										=> '1 day ago',
        'M_J'											=> 'j M',
        'ME'											=> 'Me',
        'X_SAID'										=> '%s said…',
        'DELETE_COMMENT'								=> 'Delete Comment',
        'YOU_HAVE_NOT_ADDED_VIDEOS'						=> 'You haven\'t added any videos yet!',
        'ADD_VIDEOS_AND_SHARE'							=> 'Add videos and share them with your friends, family or the rest of the world!',
        'THERE_ARE_NO_VIDEOS'							=> 'There are currently no videos on your social network.',
        'THIS_BOX_WILL_NOT_SHOW'						=> 'This box won\'t show up for other people until there are videos to show. Why not add one?',
        'ADD_VIDEOS'									=> 'Add Videos',
        'VIEW_VIDEOS'									=> 'View Videos',
        'YIKES'											=> 'Whoops!',
        'A_PROBLEM_SEEMS'								=> 'A problem seems to have occurred.',
        'FOR_FURTHER_ASSISTANCE'						=> 'For further assistance, please <a %s>contact us</a>.',
        'OR_YOU_CAN_GO'									=> 'Or you can go back to the <a %s>%s main page</a> or browse <a %s>other Ning Social Networks</a>',
        'TAGS'											=> 'Tags:',
        'POPULAR_TAGS'									=> 'Popular Tags',
        'MY_FRIENDS'									=> 'My Friends',
        'VIEW_ALL_MY_FRIENDS'							=> 'View All My Friends',
        'VIEW_ALL_XS_FRIENDS'							=> 'View All %s\'s Friends',
        'WE_COULD_NOT_FIND_ANYONE_MATCHING' => 'Sorry - we couldn\'t find anyone matching your search.',
        'VIEW_POPULAR_CONTRIBUTORS'						=> 'View Popular Contributors',
        'POPULAR_CONTRIBUTORS'							=> 'Popular Contributors',
        'VIEW_MORE_CONTRIBUTORS'						=> 'View More Contributors',
        'ADD_AS_FRIEND'									=> 'Add as friend',
        'SEND_A_MESSAGE'								=> 'Send a Message',
        'IS_YOUR_FRIEND'								=> 'Is Your Friend',
        'IS_BLOCKED'									=> 'Is Blocked',
        'SORT_BY'										=> 'Sort by:',
        'CLOSE'											=> 'Close',
        'USER_COUNT'									=> '(%d)',
        'NOBODY_HAS_ADDED_VIDEOS'						=> 'Nobody has added videos yet! Add some videos to get started.',
        'SEARCH_PEOPLE'									=> 'Search People:',
        'INVITE_YOUR_FRIENDS_TO'						=> 'Invite your friends to %s.',
        'INVITE'										=> 'Invite',
        'INVITE_TAB_TEXT' => 'Invite',
        'YOU_HAVE_NOT_ADDED_FRIENDS'					=> 'You haven\'t added any friends on %s yet.',
        'SEARCH_FRIENDS'								=> 'Search Friends:',
        'ADD_YOUR_FIRST_VIDEO'							=> 'Add Your First Video',
        'USE_HTML_EMBED_CODE'							=> 'Use HTML Embed Code',
        'UPLOAD_A_VIDEO_FROM' => 'Upload a video from your computer. We accept all the popular formats!',
        'WE_SUPPORT_MOV' => 'We support .mov, .mpg, .avi, .3gp and .wmv file formats. Files must be 100MB or smaller.',
        'NEED_HELP_HERE_ARE'							=> 'Need help? Here are instructions for <a %s>YouTube</a> and <a %s>Google Video</a>.',
        'ADD_TITLE_AND_DESCRIPTION'						=> 'Add a title and description',
        'DESCRIPTION_COLON'								=> 'Description:',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_1'	=> 'Add a title, description, and other information to the video you just uploaded.',
        'EVERYTHING_IS_OPTIONAL'						=> 'Everything is optional; if you don\'t want to add anything, just click "Skip this step" on the right.',
        'SKIP_THIS_STEP'								=> 'Skip this step',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_2'	=> 'Add a title, description, and other information for this video.',
        'CANCEL_AND_RETURN_TO_VIDEO'					=> 'Cancel and return to video',
        'TITLE'											=> 'Title:',
        'TAGS_ARE_SHORT_DESCRIPTIONS'					=> 'Tags are short descriptions that let you find your videos. Separate tags with commas or put multiple-word tags in quotes, such as "San Francisco".',
        'WHO_CAN_VIEW_VIDEO'							=> 'Who can view this video?',
        'MOST_POPULAR'									=> 'Most Popular',
        'HIGHEST_RATED'									=> 'Highest Rated',
        'MOST_RECENT'									=> 'Most Recent',
        'MOST_FAVORITED' => 'Most Favourite',
        'MOST_POPULAR_VIDEOS'							=> 'Most Popular Videos',
        'HIGHEST_RATED_VIDEOS'							=> 'Highest Rated Videos',
        'MOST_RECENT_VIDEOS'							=> 'Most Recent Videos',
        'MOST_FAVORITED_VIDEOS' => 'Most Favourite Videos',
        'ANYONE'										=> 'Anyone',
        'JUST_MY_FRIENDS'								=> 'Just My Friends',
        'JUST_ME'										=> 'Just Me',
        'VIEWABLE_BY_FRIENDS'							=> 'Viewable by <strong>Friends</strong>',
        'PRIVATE_VIDEO'									=> '<strong>Private</strong> video',
        'VIEWABLE_BY_EVERYONE'							=> 'Viewable by <strong>Everyone</strong>',
        'LOCATION'										=> 'Location:',
        'NO_LOCATION'									=> 'No location',
        'CLICK_ON_LOCATION'								=> 'Click on a location on the map:',
        'FIND_AN_ADDRESS'								=> 'Find address:',
        'LOCATE'										=> 'Locate',
        'YOU_CAN_ADD_YOUR_OWN_VIDEO'					=> 'You can <a %s>add your own video</a> to %s!',
        'ADD_PLAYER_LOGO_OR_WATERMARK'					=> 'Add a logo or watermark image to your network\'s video player. <a %s>Set it up now!</a>',
        'APPROVE'										=> 'Approve',
        'DELETE'										=> 'Delete',
        'APPLY_TO_VIDEOS_ADDED_BY'						=> 'Apply to all Videos added by %s',
        'NO_TITLE'										=> 'No Title',
        'ADDED_BY_STRONG_X'								=> 'Added by <strong>%s</strong>',
        'NO_DESCRIPTION'								=> 'No Description',
        'BY_X'											=> 'by %s',
        'YOU_HAVE_FINISHED_MODERATING'					=> 'You\'ve Finished Moderating',
        'NO_VIDEOS_AWAITING_APPROVAL'					=> 'There are currently no videos awaiting approval. If you\'re looking for something to do, why not check out the <a %s>latest videos</a>?',
        'NO_ONE_HAS_ADDED_ANY_VIDEOS'					=> 'No one has added videos to your social network. Be the first to add a video!',
        'ADDED_ON_DATE_BY_X'							=> 'Added %s by %s.',
        'REMOVE_FROM_FAVORITES'							=> 'Remove from Favourites',
        'REMOVE_VIDEO_FROM_FAVORITES'					=> 'Remove this video from your favourites?',
        'COLLECTED_BY_X'								=> 'Collected by %s',
        'ADD_FAVORITES'									=> 'Add Favourites',
        'YOU_CAN_MARK_VIDEO'							=> 'You can mark any video as a favourite. Just click the "Add To Favourites" icon when you see it on a video.',
        'VIEW_RECENT_VIDEOS'							=> 'View Recent Videos',
        'X_HAS_NOT_ADDED_FAVORITES'						=> '%s hasn\'t added any favourites yet.',
        'APPROVE_VIDEOS'								=> 'Approve Videos',
        'YOUR_SITE_REQUIRES_YOU'						=> 'You have asked to moderate photos and videos on your social network before they are posted. To change this option, go to the <a %s>Network Information</a> section of Manage Your Network and set Content Moderation to \'No\'.',
        'YOUR_SITE_ALLOWS_USERS'						=> 'You have asked not to moderate photos and videos on your social network before they are posted. To change this option, go to the <a %s>Network Information</a> section of Manage Your Network and set Content Moderation to \'Yes\'.',
        'APPROVE_ALL_VIDEOS'							=> 'Approve All Videos?',
        'ARE_YOU_SURE_APPROVE_ALL_VIDEOS'				=> 'Are you sure you want to approve all videos? This may take a few minutes.',
        'APPROVING'										=> 'Approving…',
        'APPROVE_ALL'									=> 'Approve All',
        'DELETE_ALL_VIDEOS'								=> 'Delete All Videos?',
        'ARE_YOU_SURE_DELETE_ALL_VIDEOS'				=> 'Are you sure you want to delete all unapproved videos? This may take a few minutes.',
        'DELETING'										=> 'Deleting…',
        'DELETE_ALL'									=> 'Delete All',
        'XS_VIDEOS'										=> '%s\'s Videos',
        'DELETE_ALL_XS_VIDEOS_Q'						=> 'Delete All %s\'s Videos?',
        'DELETE_ALL_XS_VIDEOS'							=> 'Delete All %s\'s Videos',
        'ARE_YOU_SURE_DELETE_ALL_XS_VIDEOS'				=> 'Are you sure you want to delete all videos by %s? This process may take a few minutes.',
        'DELETE_THIS_VIDEO_Q'							=> 'Delete This Video?',
        'ARE_YOU_SURE_DELETE_THIS_VIDEO'				=> 'Are you sure you want to delete this video? This process may take a few minutes.',
        'YOU_HAVE_NOT_ADDED_VIDEOS_2'					=> 'You haven\'t added any videos yet. Add some videos to get started!',
        'X_HAS_NOT_ADDED_VIDEOS'						=> '%s hasn\'t added any videos yet.',
        'YOUR_FRIENDS_DO_NOT_HAVE_VIDEOS'				=> 'Your friends don\'t have any videos yet.',
        'ALL_VIDEOS_TAGGED_X'							=> 'All Videos Tagged \'%s\'',
        'ALL_VIDEOS_TAGGED_X_2'							=> 'All Videos Tagged <em>\'%s\'</em>',
        'NO_VIDEOS_TAGGED_X_CHECK_OUT'					=> 'There aren\'t any videos tagged "%1$s". Check out <a %2$s>discussions tagged "%1$s"</a> or <a %3$s>photos tagged "%1$s"</a>. Or add and tag your own videos!',
        'FILES_MUST_BE_100MB'							=> 'Files must be 100MB or smaller. We support .mov, .mpg, .avi, .3gp and .wmv file formats.',
        'NEED_HELP'										=> 'Need help?',
        'HERE_ARE_INSTRUCTIONS'							=> 'Here are instructions for <a %s>YouTube</a> and <a %s>Google Video</a>.',
        'PERSON_IN_CHARGE'								=> 'The person in charge of %s wants to see your handiwork before showing it to the world.',
        'LEAVE_WINDOW_OPEN'								=> 'Please leave this window open while the uploading process completes.',
        'KEEP_PAGE_OPEN'								=> 'Please keep this page open so we can finish uploading your video and we\'ll let you know when it\'s been approved!',
        'MEANWHILE_FEEL_FREE'							=> 'Meanwhile, feel free to <a %s>open a new browser window</a> and continue using %s. When uploading is complete, you\'ll be able to add a title and description to your video in this window.',
        'VIDEO_IS_WAITING_FOR_APPROVAL'					=> 'This video is <strong>waiting for approval</strong> from %s\'s creator.',
        'LOADING'										=> 'Loading…',
        'EDIT_VIDEO'									=> 'Edit Video',
        'DELETE_VIDEO'									=> 'Delete Video',
        'YOU_NEED_TO_BE_MEMBER'							=> 'You need to be a member of %s to add comments!',
        'SIGN_UP_OR_SIGN_IN'							=> '<a %s>Join this network</a>',
        'ADD_A_COMMENT'									=> 'Add a Comment',
        'LEAVE_A_COMMENT_FOR_USERNAME'					=> 'Leave a Comment for %s',
        'MORE'											=> 'More',
        'PREVIOUS'										=> 'Previous',
        'NEXT'											=> 'Next',
        'ABOUT_THIS_VIDEO'								=> 'About This Video',
        'ABOUT_YOUR_VIDEO'								=> 'About This Video',
        'ADDED_ON_DATE_BY'								=> 'Added <strong>%s</strong> by:',
        'VIEWS'											=> 'Views:',
        'COMMENTS'										=> 'Comments',
        'COMMENTS_COLON'										=> 'Comments:',
        'LOCATION_OF_VIDEO'								=> 'Location of this video:',
        'RELATED_VIDEOS'								=> 'Related Videos',
        'ALL_VIDEOS_TAGGED_X_X'							=> 'All Videos Tagged %s (%s)',
        'XS_VIDEOS_X'									=> '%s\'s Videos (%s)',
        'XS_FAVORITES_X'								=> '%s\'s Favourites (%s)',
        'VIDEO_DETAILS'									=> 'Video Details',
        'NEITHER_FILE_NOR_EMBED_CODE'					=> 'Neither a file nor embed code was specified.',
        'VIDEO_UPLOADED_ON_X'							=> 'Video uploaded on %s',
        'PROBLEM_OCCURRED_CONVERTING_VIDEO'				=> 'A problem occurred while converting the video to Flash format: %s',
        'STATUS_N'										=> 'Status %s',
        'YOUR_VIDEO_TITLED_X_COULD_NOT'					=> 'Your video titled "%s" could not be added to %s',
        'YOUR_VIDEO_COULD_NOT_BE_ADDED'					=> 'Your video could not be added to %s',
        'YOU_JUST_TRIED_TO_SEND_VIDEO' => 'You just tried to send a video in to %s. Unfortunately, you\'re not a member of %s and we can\'t deliver this video.',
        'VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'Your video upload on %s did not complete',
        'YOUR_VIDEO_UPLOAD_DID_NOT_COMPLETE'			=> 'your video upload did not complete on %s.',
        'YOUR_VIDEO_ENCOUNTERED_A_PROBLEM'				=> 'Your video encountered a problem while being uploaded to %s',
        'THE_PROBLEM_WAS_X'								=> 'The problem was: %s',
        'FOR_FURTHER_ASSISTANCE_2' => 'For further assistance, visit:',
        'ID'											=> 'ID:',
        'VIDEO_TRANSCODING_FAILED_FOR_X'				=> 'Video transcoding failed for video %s in %s',
        'X_UPLOADED_A_VIDEO_THAT_FAILED'				=> '%s uploaded a video that failed transcoding.',
        'ERROR_MESSAGE'									=> 'Error message:',
        'APPLICATION_NAME'								=> 'Application name:',
        'APPLICATION_ID'								=> 'Application ID:',
        'VIDEO_ID'										=> 'Video ID:',
        'VIDEO_UPLOAD_COMPLETE_ON_X' => 'Your video upload on %s is complete',
        'YOUR_VIDEO_UPLOAD_COMPLETE_ON_X'				=> 'your video upload completed on %s',
        'YOUR_VIDEO_WAS_UPLOADED'						=> 'Your video was successfully uploaded to %s!',
        'THAT_VIDEO_IS_AWAITING_APPROVAL'				=> 'That video is awaiting approval.',
        'THIS_VIDEO_IS_BEING_PROCESSED'					=> 'This video is still being processed.',
        'ADD_VIDEO'										=> 'Add Video',
        'VIDEO_BY_X'									=> 'Video by %s',
        'THERE_IS_NEW_COMMENT_ON_VIDEO_X' => 'There is a new comment on your video "%s" on %s',
        'THERE_IS_NEW_COMMENT_ON_VIDEO' => 'There is a new comment on one of your videos on %s',
        'SOMEBODY_COMMENTED_VIDEO_ADDED_TO_X' => 'somebody commented on a video you\'ve added to %s',
        'SOMEBODY_UPLOADED_VIDEO_TO_X'					=> 'somebody has uploaded a video to %s',
        'MORE_WAYS_TO_ADD_VIDEOS'						=> 'More ways to add videos…',
        'FROM_YOUTUBE_OR_GOOGLE'						=> '…from YouTube or Google',
        'GRAB_THE_HTML_EMBED_CODE'						=> 'Grab the HTML \'embed\' code from any popular video site and add that video to this social network.',
        'ADD_A_VIDEO_FROM_YOUTUBE'						=> 'Add a video from YouTube or Google',
        'PASTE_IN_EMBED'								=> 'Paste the \'embed\' code for the video here:',
        'ADD_VIDEOS_BY_PHONE_OR_EMAIL'					=> 'Add video by phone or email',
        'VIDEO'											=> 'video',
        'THERE_ARE_NO_VIDEOS_THAT_MATCH'				=> 'There are no videos that match the settings you have selected.',
        'CLICK_EDIT_AND_CHANGE_SETTINGS'				=> 'Click \'Edit\' and change settings if you would like this box to show up for other people.',
        'PLAY_AGAIN'									=> 'Play Again',
        'SHARE'											=> 'Share',
        'EMBED'											=> 'Embed',
        'REWIND'										=> 'Rewind',
        'CHANGE_SIZE'									=> 'Change Size',
        'FULLSCREEN' => 'Full Screen',
        'EXIT_FULLSCREEN' => 'Exit Full Screen',
        'HIDE'											=> 'Close',
        'COPY_AND_PASTE_LINK' => 'Copy and paste this link into an e-mail or instant message:',
        'FIND_MORE_VIDEOS_LIKE_THIS'					=> 'Find more videos like this on <em>%s</em>',
        'SEE_VIDEO_ON_NETWORK'							=> 'See this video on %s',
        'GET_EMBED_CODE'								=> 'Get embed code',
        'MORE_PHOTOS' => 'More Photos',
        'THIS_ALBUM' => 'This Album',
        'NETWORK_DOES_NOT_HAVE_PHOTOS' => 'This network doesn\'t have any photos yet.',
        'PERSON_DOES_NOT_HAVE_PHOTOS' => 'This person doesn\'t have any photos yet.',
        'ALBUM_DOES_NOT_HAVE_PHOTOS' => 'This album doesn\'t have any photos yet.',
        'FIND_MORE_PHOTOS_LIKE_THIS'					=> 'Find more photos like this on <em>%s</em>',
        'NO_PHOTOS_AVAILABLE'							=> 'There are currently no photos available in this album. <a %s>Click here to see all albums</a>.',
        'ALBUM_PHOTOS_NOT_VISIBLE_TO_OTHERS'			=> 'This album is not visible to other people on the network because its photos are only visible to you or have yet to be approved.',
        'CUSTOMIZE_YOUR_SLIDESHOW_PLAYER' => 'Customize Your Slideshow Player!',
        'ADD_SLIDESHOW_LOGO'							=> 'Add a logo to your social network\'s slideshow. <a %s>Set it up now!</a>',
        'PHOTO_BY_X'									=> 'Photo by %s',
        'UPLOAD_PHOTOS'									=> 'Upload Photos',
        'PLAYER_COLOR'									=> 'Player Colour',
        'SLIDESHOW_PLAYER'								=> 'slideshow player',
        'SLIDESHOW'										=> 'slideshow',
        'FILTER'										=> 'Filter',
        'SAVE_ALBUM'									=> 'Save Album',
        'APPLY_THIS_INFO_TO_PHOTOS'						=> 'Apply this info to the following photos',
        'CLICK_TO_ADD_A_DESCRIPTION'					=> 'click to add a description',
        'CHECK'											=> 'Check',
        'YOU_NEED_TO_BE_X'								=> 'You need to be %s to do that.',
        'ALL_PHOTOS'									=> 'All Photos',
        'POPULAR_PHOTOS' => 'Popular Photos',
        'FEATURED_PHOTOS' => 'Featured Photos',
        'PHOTOS_HOME'									=> 'Photos Home',
        'ALL_ALBUMS'									=> 'All Albums',
        'MY_PHOTOS'										=> 'My Photos',
        'MY_ALBUMS'										=> 'My Albums',
        'ADD_PHOTOS'									=> 'Add Photos',
        'ADD_PHOTOS_SENTENCE_CASE' => 'Add photos',
        'EDIT'											=> 'Edit',
        'CHOOSE_PHOTOS'									=> 'Choose Photos',
        'ADD_PHOTOS_BY_DRAGGING'						=> '<strong>Add photos by dragging them</strong> to your album on the right. Remove them by dragging them back.',
        'TITLE_YOUR_ALBUM'								=> '<strong>Title your album.</strong> Give it a cover and description.',
        'SAVE_YOUR_ALBUM'								=> 'Save your album!',
        'CHOOSE_FROM'									=> 'Choose from:',
        'EVERYONES_PHOTOS'								=> 'Everyone\'s Photos',
        'TAGGED'										=> 'Tagged:',
        'OLDER_PHOTOS'									=> 'Older Photos',
        'MORE_RECENT_PHOTOS'							=> 'More Recent Photos',
        'YOUR_ALBUM'									=> 'Your Album',
        'DRAG_ALBUM_COVER_HERE'							=> 'Drag album cover here',
        'ALBUM_TITLE'									=> 'Album Title:',
        'ALBUM'											=> 'album',
        'DRAG_PHOTOS_HERE'								=> 'Drag Your Photos Here',
        'PREVIOUS_ALBUM_PAGE'							=> 'Previous Album Page',
        'NEXT_ALBUM_PAGE'								=> 'Next Album Page',
        'ADDED_ON_DATE'									=> 'Added %s',
        'VIEW_AS_SLIDESHOW'								=> 'View as Slideshow',
        'CREATED_BY_ME'									=> 'Created by <a %s>Me</a>',
        'CREATED_BY_X'									=> 'Created by %s',
        'OUR_APOLOGIES' => 'Sorry',
        'ADD_PHOTOS_TO_ALBUM'							=> 'Add more photos to this album by choosing from the options below.',
        'YOU_CAN_ADD_PHOTOS'							=> 'You can <a %s>add photos to this album now</a>.',
        'SITE_IS_GETTING_STARTED'						=> 'This social network is just getting started!',
        'NO_ONE_CREATED_ALBUMS'							=> 'It doesn\'t look like anyone has created any albums yet. You can <a %s>create an album now</a>.',
        'EDIT_YOUR_ALBUM'								=> 'Edit Your Album',
        'ALBUMS_WITH_THIS_PHOTO'						=> 'All Albums with This Photo',
        'ALBUMS_WITH_X'									=> 'All Albums With \'%s\'',
        'ALBUMS_WITH_X_2'								=> 'All Albums With <em>\'%s\'</em>',
        'NO_ALBUMS_CONTAINING_PHOTO'					=> 'There aren\'t any albums containing this photo. You can <a %s>create a new album</a>.',
        'XS_ALBUMS'										=> '%s\'s Albums',
        'CREATE_AN_ALBUM'								=> 'Create an Album',
        'YOU_HAVE_NOT_CREATED_ALBUMS'					=> 'You haven\'t created any photo albums yet. You can <a %s>create an album now</a>.',
        'X_HAS_NOT_CREATED_ALBUMS'						=> '%s hasn\'t created any photo albums yet.',
        'MAKE_AN_ALBUM'									=> 'Make an Album',
        'ABOUT_THIS_ALBUM'								=> 'About This Album',
        'ABOUT_YOUR_ALBUM'								=> 'About Your Album',
        'EDIT_ALBUM'									=> 'Edit Album',
        'DELETE_THIS_ALBUM'								=> 'Delete this album?',
        'DELETE_ALBUM'									=> 'Delete Album',
        'START_SLIDESHOW'								=> 'Start Slideshow',
        'ALBUM_IS_NOW_EMPTY'							=> 'This album is now empty.',
        'YOU_ARE_GETTING_STARTED'						=> 'You\'re just getting started!',
        'YOU_HAVE_NOT_ADDED_PHOTOS'						=> 'You haven\'t added any photos yet!',
        'ADD_PHOTOS_AND_SHARE'							=> 'Add photos and share them with your friends, family or the rest of the world!',
        'ADD_A_PHOTO'									=> 'Add a Photo',
        'NO_PHOTOS_ON_SITE'								=> 'There are currently no photos on your social network.',
        'BOX_WILL_NOT_SHOW_PHOTOS'						=> 'This box won\'t show up for other people until there are photos to show. Why not add one?',
        'VIEW_EMBED_CODE'								=> 'View embed code',
        'VIEW_SLIDESHOW' => 'View Slideshow',
        'VIEW_PHOTOS'									=> 'View Photos',
        'ADD_YOUR_FIRST_PHOTOS'							=> 'Add Your First Photos',
        'YOU_CAN_ADD_YOUR_OWN_PHOTOS'					=> 'You can <a %s>add your own photos</a> to %s!',
        'UPLOAD_PHOTOS_FROM'							=> 'Upload photos from your computer:',
        'ADD_TITLE_AND_DESCRIPTION_FOR_PHOTOS'			=> 'Add a title and description for your photos',
        'EDIT_PHOTO_INFORMATION'						=> 'Edit Photo Information',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_1'	=> 'Add a title, description, and other information to the photos you just uploaded.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_2'	=> 'Add a title, description, and other information for this photo.',
        'CANCEL_AND_RETURN_TO_PHOTO'					=> 'Cancel and return to photo',
        'WHO_CAN_VIEW_PHOTO'							=> 'Who can view this photo?',
        'CAN_BE_VIEWED_BY'								=> 'Can be viewed by:',
        'BY_ME'											=> 'by <a %s>Me</a>',
        'RSS_FEED_LABEL' => '<a %s>RSS Feed</a> – %s',
        'NO_PHOTOS_AWAITING_APPROVAL'					=> 'There are currently no photos awaiting approval. If you\'re looking for something to do, why not check out the <a %s>latest photos</a>?',
        'APPROVE_ALL_PHOTOS'							=> 'Approve All Photos?',
        'ARE_YOU_SURE_APPROVE_ALL_PHOTOS'				=> 'Are you sure you want to approve all photos? This may take a few minutes.',
        'DELETE_ALL_PHOTOS'								=> 'Delete All Photos?',
        'ARE_YOU_SURE_DELETE_ALL_PHOTOS'				=> 'Are you sure you want to delete all unapproved photos? This may take a few minutes.',
        'KEEP_WINDOW_OPEN_PHOTOS_APPROVED'				=> 'Please keep this browser window open while photos are being approved. This process may take a few minutes.',
        'KEEP_WINDOW_OPEN_PHOTOS_DELETED'				=> 'Please keep this browser window open while photos are being deleted. This process may take a few minutes.',
        'APPLY_TO_PHOTOS_ADDED_BY'						=> 'Apply to all Photos added by %s',
        'NO_ONE_HAS_ADDED_ANY_PHOTOS'					=> 'No one has added any photos to your social network. You can be the first to <a %s>add photos.</a>',
        'UNTITLED'										=> 'Untitled',
        'A_PROBLEM_OCCURRED'							=> 'A problem occurred',
        'PHOTOS_EXCEEDED_LIMIT'							=> 'The photo(s) seem to have exceeded the limit of 10 MB per photo.',
        'GET_A_SLIDESHOW_OF'							=> 'Get a Slideshow of  %s',
        'GET_A_SLIDESHOW'								=> 'Get a Slideshow!',
        'GET_SLIDESHOW_OF_PHOTOS'						=> 'Get a slideshow of these photos',
        'COPY_AND_PASTE_SLIDESHOW'						=> 'Copy and paste the code below to put a slideshow of these photos on your website, MySpace page or other Ning networks.',
        'COPY_AND_PASTE_SLIDESHOW_OF_ALBUM'				=> 'Copy and paste the code below to put a slideshow of this album on your website, MySpace page or other Ning networks.',
        'LARGE_VERSION'									=> 'Large Version',
        'SMALL_VERSION'									=> 'Small Version',
        'VIEW_SLIDESHOW_FULL_SIZE'						=> 'View this slideshow full size',
        'PHOTOS'										=> 'Photos',
        'XS_PHOTOS'										=> '%s\'s Photos',
        'XS_PHOTO'										=> '%s\'s Photo',
        'YOU_CAN_MARK_PHOTO'							=> 'You can mark any photo as a favourite. Just click the "Add To Favourites" icon when you see it on a photo.',
        'VIEW_RECENT_PHOTOS'							=> 'View Recent Photos',
        'APPROVE_PHOTOS'								=> 'Approve Photos',
        'DELETE_ALL_XS_PHOTOS_Q'						=> 'Delete All %s\'s Photos?',
        'ARE_YOU_SURE_DELETE_ALL_XS_PHOTOS'				=> 'Are you sure you want to delete all photos by %s? This process may take a few minutes.',
        'REMOVE_X_AND_ALL_CONTENT'						=> 'Remove %1$s and all %1$s\'s content from your social network',
        'SUCCESS'										=> 'Success.',
        'DELETING_CONTENT'								=> 'Deleting Content…',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED'				=> 'Please keep this browser window open while content is deleted. This process may take a few minutes.',
        'KEEP_WINDOW_OPEN_MEMBERS_DELETED' => 'Please keep this browser window open while members are deleted. This process may take a few minutes.',
        'DELETE_ALL_XS_PHOTOS'							=> 'Delete All %s\'s Photos',
        'CREATE_A_NEW_ALBUM'							=> 'Create a New Album',
        'VIEW_ALL_XS_ALBUMS'							=> 'View All %s\'s Albums',
        'YOU_HAVE_NOT_ADDED_PHOTOS_2'					=> 'You haven\'t added any photos yet. Add some photos to get started!',
        'X_HAS_NOT_ADDED_PHOTOS'						=> '%s hasn\'t added any photos yet.',
        'MY_FRIENDS_PHOTOS'								=> 'My Friends\' Photos',
        'VIEW_PHOTOS_IN_SLIDESHOW'						=> 'View these photos in a slideshow!',
        'YOUR_FRIENDS_DO_NOT_HAVE_PHOTOS'				=> 'Your friends don\'t have any photos yet',
        'ALL_PHOTOS_TAGGED_X'							=> 'All Photos Tagged \'%s\'',
        'ALL_PHOTOS_TAGGED_X_2'							=> 'All Photos Tagged <em>\'%s\'</em>',
        'NO_PHOTOS_TAGGED_X_CHECK_OUT'					=> 'There aren\'t any photos tagged "%1$s". Check out <a %2$s>discussions tagged "%1$s"</a> or <a %3$s>videos tagged "%1$s"</a>. Or add and tag your own photos!',
        'SELECT_YOUR_PHOTOS'							=> 'Select Your Photos',
        'PHOTO_MAY_BE_10MB' => 'Each photo may be up to 10MB in size, but smaller photos will upload faster. We support photos in the .jpg, .gif and .png file formats.',
        'KEEP_PAGE_OPEN_PHOTOS'							=> 'Please keep this page open so we can finish uploading your photos and we\'ll let you know when they\'ve been approved!',
        'MEANWHILE_FEEL_FREE_PHOTOS'					=> 'Meanwhile, feel free to <a %s>open a new browser window</a> and continue using %s. When uploading is complete, you\'ll be able to add titles and descriptions to your photos in this window.',
        'PHOTO_IS_WAITING_FOR_APPROVAL'					=> 'This photo is <strong>waiting for approval</strong> from %s\'s creator.',
        'ADD_TO_FAVORITES'								=> 'Add to Favourites',
        'EDIT_PHOTO'									=> 'Edit Photo',
        'DELETE_PHOTO'									=> 'Delete Photo',
        'ABOUT_THIS_PHOTO'								=> 'About This Photo',
        'LOCATION_OF_PHOTO'								=> 'Location of this photo:',
        'ALBUMS_FEATURING_PHOTO'						=> 'Albums Featuring This Photo',
        'VIEW_ALBUMS_WITH_PHOTO'						=> 'View All Albums with This Photo',
        'RETURN_TO_X'									=> 'Return to %s',
        'RETURN_TO_PHOTOS_HOME' => 'Return to Photos Home',
        'WE_COULD_NOT_FIND_ANYONE' => 'Sorry - we couldn\'t find anyone',
        'NOBODY_HAS_ADDED_PHOTOS'						=> 'Nobody has added photos yet! Add some photos to get started.',
        'DEFAULT_TITLE'									=> 'Title',
        'DEFAULT_DESCRIPTION'							=> 'Description',
        'UPLOAD_LIMIT_EXCEEDED'							=> 'The upload file size limit was exceeded.',
        'SLOW_DOWN_THERE_CHIEF' => 'Sorry',
        'I_DO_NOT_KNOW_USER'							=> 'Sorry, I don\'t know this person.',
        'I_DO_NOT_HAVE_PHOTO'							=> 'Sorry, I don\'t have this photo.',
        'I_DO_NOT_HAVE_ALBUM'							=> 'Sorry, I don\'t have this album.',
        'ALBUM_BY_X_ON_X'								=> 'Album by %s on %s',
        'SENT'											=> 'Sent!',
        'I_HAVE_RECENTLY_ADDED'							=> 'I\'ve Recently Added',
        'FROM_THE_BAZEL'								=> 'From This Network',
        'RECENTLY_ADDED'								=> 'Recently Added',
        'RECENT_PUBLIC_PHOTOS_ON_X'						=> 'Recent public photos on %s',
        'X_ALL_PHOTOS'									=> '%s - All Photos',
        'NO_TAG_WAS_SPECIFIED'							=> 'No tag was specified',
        'PUBLIC_PHOTOS_TAGGED_WITH_X'					=> 'Public photos tagged with %s on %s',
        'XS_PUBLIC_PHOTOS_ON_X'							=> '%s\'s public photos on %s',
        'WE_DO_NOT_KNOW_USER'							=> 'We don\'t know this person.',
        'XS_FRIENDS_PHOTOS'								=> '%s\'s Friends\' Photos',
        'XS_FAVORITE_PHOTOS_ON_X'						=> '%s\'s favourite photos on %s',
        'PHOTO_UPLOADED_ON_X'							=> 'Photo uploaded on %s',
        'FILE_EXCEEDED_MAXIMUM_SIZE'					=> 'The file exceeded the maximum size',
        'PART_OF_FILE_WAS_UPLOADED'						=> 'Only part of the file was uploaded',
        'NO_FILE_WAS_UPLOADED'							=> 'The upload failed; the filename may have been incorrect',
        'PROBLEM_OCCURRED_DURING_UPLOAD'				=> 'A problem occurred during the upload.',
        'ALPHABETICAL'									=> 'Alphabetical',
        'MOST_VIEWS'									=> 'Most Views',
        'RATING_NOT_RATED_YET'							=> '<strong>Rating:</strong> Not rated yet',
        'NOT_RATED_YET'									=> 'Not rated yet',
        'HMM_SOMETHING_WENT_AWRY' => 'Hmm…something went wrong',
        'YOUR_PHOTO_TITLED_X_COULD_NOT'					=> 'Your photo titled "%s" could not be added to %s',
        'YOUR_PHOTO_COULD_NOT_BE_ADDED'					=> 'Your photo could not be added to %s',
        'YOU_JUST_TRIED_TO_SEND' => 'You just tried to send a photo in to %s. Unfortunately, you\'re not a member of %s and we can\'t deliver this photo.',
        'ONLY_MY_FRIENDS'								=> 'Only My Friends',
        'ANYBODY'										=> 'Anybody',
        'ONLY_MY_FRIENDS_CAN_SEE_PHOTO'					=> 'Only my friends can see this photo',
        'ONLY_XS_FRIENDS_CAN_SEE_PHOTO'					=> 'Only %s\'s friends can see this photo',
        'ONLY_I_CAN_SEE_PHOTO'							=> 'Only  I can see this photo',
        'ONLY_X_CAN_SEE_PHOTO'							=> 'Only %s can see this photo',
        'EVERYONE_CAN_SEE_PHOTO'						=> 'Everyone can see this photo',
        'PRIVATE_PHOTO'									=> '<strong>Private</strong> photo',
        'HOWDY_STRANGER' => 'Hello, stranger!',
        'YOU_NEED_TO_BE_SIGNED_IN'						=> 'You need to be signed into Ning before you can do that.',
        'JUST_CLICK_ON_SIGN_IN'							=> 'Just click on "Sign In" above, or if you don\'t yet have a Ning account, click "Sign Up".',
        'YOU_NEED_TO_BE_'								=> 'You need to be %s to do that.',
        'YOU_NEED_TO_BE_OWNER'							=> 'You need to be the network creator to do that.',
        'THAT_PHOTO_IS_AWAITING_APPROVAL'				=> 'That photo is awaiting approval.',
        'YOU_NEED_TO_BE_A_FRIEND'						=> 'You need to be a friend of %s to do that.',
        'MOST_ACTIVE'									=> 'Most Active',
        'HOW_IT_WORKS'									=> 'How it works',
        'MORE_WAYS_TO_ADD_PHOTOS'						=> 'More ways to add photos…',
        'BY_PHONE_OR_EMAIL' => '…by phone or e-mail',
        'FROM_FLICKR'									=> '…from Flickr',
        'FROM_YOUR_COMPUTER'							=> '…from your computer',
        'ADD_PHOTOS_FROM_YOUR_FLICKR'					=> 'Add photos from your Flickr account.',
        'MORE_INFORMATION'								=> 'More Information',
        'ADD_PHOTOS_BY_PHONE_OR_EMAIL' => 'Add photos by phone or e-mail',
        'SEND_ONE_PHOTO_OR_VIDEO' => 'Send one photo or video per e-mail. The subject of the e-mail becomes the title of the photo or video, and the body becomes the description.',
        'CLICK_HERE_TO_GET_A_NEW_UNIQUE' => 'Click here to get a new e-mail address',
        'UPLOAD_PHOTOS_FROM_YOUR'						=> 'Upload photos from your computer.',
        'PHOTO'											=> 'photo',
        'YOUVE_SET_THE_NUMBER_OF_PHOTOS'				=> 'You are currently displaying no photos.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_PHOTO'			=> 'This box won\'t show up for other people unless you select at least one photo.',
        'THERE_IS_NEW_COMMENT_ON_PHOTO_X'				=> 'There is a new comment on your photo "%s" on %s',
        'THERE_IS_NEW_COMMENT_ON_PHOTO'					=> 'There is a new comment on one of your photos on %s',
        'SOMEBODY_COMMENTED_PHOTO_ADDED_TO_X'			=> 'somebody commented on a photo you\'ve added to %s',
        'SOMEBODY_UPLOADED_PHOTO_TO_X'					=> 'somebody has uploaded a photo to %s',
        'ADD_PHOTOS_OR_VIDEOS_TO_X' => 'Add photos or videos to %s directly from your phone by sending them to an e-mail address.',
        'DO_YOU_REALLY_WANT_TO_REMOVE'					=> 'Do you really want to remove this item from your favourites?',
        'DELETE_THIS_PHOTO_Q'							=> 'Delete This Photo?',
        'ARE_YOU_SURE_DELETE_THIS_PHOTO'				=> 'Are you sure you want to delete this photo? This process may take a few minutes.',
        'PHOTO_SLIDESHOW'								=> 'Slideshow',
        'THUMBNAILS'									=> 'Thumbnails',
        'DETAIL'										=> 'Detail',
        'TAG'											=> 'Tag',
        'RATE'											=> 'Rate',
        'ALL_SIZES'										=> 'All Sizes',
        'ADD_TO_ALBUM'									=> 'Add to Album',
        'ROTATE_PHOTO'									=> 'Rotate Photo',
        'ABOUT_YOUR_PHOTO'								=> 'About Your Photo',
        'SEE_PHOTOS_ON_NETWORK' => 'See these photos on %s',
        'EMBED_CODE' => 'Embed Code',
        'IMPORT_PHOTOS_FLICKR'							=> 'Get Your Photos from Flickr',
        'CLICK_HERE_TO_CONTINUE_TO_FLICKR'				=> 'Click here to continue to Flickr',
        'TO_GET_YOUR_PHOTOS_FROM_FLICKR'				=> 'To get your photos from Flickr, you first need to allow %S to link to your Flickr account.',
        'IMPORT_PHOTOS'									=> 'Import Photos',
        'GET_MY'										=> 'Get my',
        'GET_PHOTOS'									=> 'Get Photos',
        'MOST_RECENT_PHOTOS'							=> 'most recent photos',
        'GET_ALL_MY_FLICKR'								=> 'Get all of my photos from Flickr (may take a while)',
        'GET_ALL_MY_TAGGED'								=> 'Get all of my photos tagged',
        'GET_PHOTOS_FROM_SET'							=> 'Get photos from a set:',
        'GET_STARTED_BY_IMPORT'							=> 'We\'ll automatically get your titles, tags and any mapping information you have.<br/>How long will it take?</p> <p><ul style="padding-top:10px;"><li>10 Photos: <em>less than 30 seconds</em>.</li><li>50 Photos: <em>about 2 minutes</em>.</li><li>200 Photos: <em>about 6 minutes</em>.</li><li>500 photos: <em>about 15 minutes</em>.</li></ul>',
        'IF_YOURE_NOT_SIGNED_IN'						=> 'If you\'re not signed in to Flickr, you will be asked to sign in. Once you\'re signed in, click the button that says "OK, I\'ll allow it".',
        'GET_MY_FLICKR_PHOTOS_DESCRIPTIONS'				=> 'Get descriptions too (this will double the time it takes).',
        'PLEASE_KEEP_THIS_PAGE_OPEN_WHILE_IMPORT'		=> 'Please keep this page open so we can finish importing your photos.',
        'GET_MY_FLICKR_PHOTOS_ORIGINALS'				=> 'Get the full-size version of each photo (this will increase import time significantly and we don\'t recommend it for more than 20 photos).',
        'MAKE_YOUR_X_PAGE_YOUR_OWN'						=> 'Click "edit" to add text, videos, photos, or any widget to this box. It\'s another way you can make your %s page your own.',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Click \'Edit\' to add text, HTML, videos, photos, or any <a %1$s>third-party widgets</a> to this box.',
        'BOX_WILL_NOT_SHOW_UNTIL_UPDATE_CONTENT'		=> 'This box won\'t show up for other people until you update its content.',
        'YOUR_X_BOX'									=> 'Your %s Box',
        'ABOUT_WIDGETS'									=> 'About Widgets',
        'HELP'											=> 'Help',
        'WIDGETS'										=> 'Widgets',
        'LOOKING_TO_ADD_FUNCTIONALITY'					=> 'Looking to add more functionality to your social network? Perhaps a calendar, local weather report, event countdown or webcam? With widgets, it\'s easy to add additional features to any Text Box on your network.',
        'GETTING_STARTED'								=> 'Getting Started',
        'BELOW_IS_LIST_OF_WIDGET'						=> 'Below is a <a %s>list of widget providers</a> you may want to check out. We\'ve selected a few widgets from <a %s>yourminis.com</a> to get you started. Just set up a widget below, copy the embed code and paste it directly into the Text Box. Go for it!',
        'CALENDAR'										=> 'Calendar',
        'CALENDAR_WIDGET_ALLOWS_SEARCH'					=> 'The Calendar widget not only displays the date, but also allows you to search for and add iCal format events (used by Google Calendar and many other online calendar providers).',
        'USE_EDIT_WIDGET_BUTTON_CALENDAR'				=> 'Use the &#8220;edit widget&#8221; button to select &#8220;search for events&#8221;, then enter a search term (try holidays, a sports team, etc.). Then just select a search result to have those events added to your calendar. You can also manually enter the address of any existing iCal feed.',
        'CUSTOMIZATION' => 'Customization',
        'YOU_CAN_CUSTOMIZE_WIDGET' => 'You can customize the appearance of the widget by moving the mouse over the widget, then clicking the colour picker icon to change the background, widget style and transparency level. When you\'re done, click the &#8220;copy to web&#8221; link, then the &#8220;copy embed code&#8221; button. Once the code is copied, just return to any Text Box on your network, paste the code in and save your changes. All set!',
        'GET_MORE_WIDGETS_FROM_YOURMINIS' => 'Get more widgets from yourminis.com »',
        'WEATHER'										=> 'Weather',
        'WEATHER_WIDGET_DISPLAYS'						=> 'The Weather widget displays local weather forecasts from the Weather Channel.',
        'USE_EDIT_WIDGET_BUTTON_WEATHER'				=> 'Use the &#8220;edit widget&#8221; button to select your location and choose Fahrenheit or Celsius. You can choose to display weather for just the current day, or expand it to a five-day forecast.',
        'COUNTDOWN'										=> 'Countdown',
        'COUNTDOWN_WIDGET_LETS_YOU'						=> 'The Countdown widget lets you create a countdown to a specific event. By clicking the &#8220;edit widget&#8221; button, you can enter the date, time and title or image of an event to count down to.',
        'WEBCAM'										=> 'Webcam',
        'WEBCAM_WIDGET_ALLOWS_YOU'						=> 'The Webcam widget allows you to actively monitor any publicly-available webcams. Use the &#8220;edit widget&#8221; button to select from a list of pre-defined webcams, or manually enter any webcam\'s URL.',
        'MORE_WIDGETS'									=> 'More Widgets',
        'NEED_MORE_OPTIONS'								=> 'Need more options? We recommend any of the following sites to quench your widget thirst:',
        'MODERATION_DENIED_ON_X'						=> 'Moderation denied on %s on %s',
        'MODERATION_DENIED_ON_A_X'						=> 'Moderation denied on a %s of yours on %s',
        'YOU_HAVE_NEW_X_TO_MODERATE'					=> 'You\'ve got a new %s to moderate on %s',
        'NEW_X_TO_MODERATE'								=> 'There is a new %s for you to moderate.',
        'MODERATION_APPROVED_ON_X'						=> 'Moderation approved on %s on %s',
        'MODERATION_APPROVED_ON_A_X'					=> 'Moderation approved on a %s of yours on %s',
        'JOIN'											=> 'Join',
        'WELCOME'										=> 'Welcome',
        'WELCOME_TO_X'									=> 'Welcome to %s',
        'WELCOME_TO_X_ELLIPSIS' => 'Welcome to %s…',
        'RSS_LINK'										=> '<a %s>RSS</a>',
        'NEW_FEATURES_GROUPS_MUSIC'						=> '<h3 style="margin-top:0">New Features!</h3>
            <ul><li><strong>Groups</strong> &ndash; Let your members create groups on your network</li>
                <li><strong>Music Player</strong> &ndash; Add music and podcasts to your network</li></ul>
            <p><a href="%s" class="desc add">Click here to add features</a></p>',
        'NEW_FEATURES_ACTIVITY_BADGES' => '<h3 style="margin-top:0">New Features!</h3>
            <ul><li><strong>Latest Activity</strong> &ndash; Follow the latest member activity on your network</li>
                <li><strong>Badges & Widgets</strong> &ndash; Promote your network across the web with custom badges and widgets</li></ul>
            <p><a href="%s" class="desc add">Click here to add/edit features</a></p>',
        'YOUR_TYPE_NAME_HAS_NEW_COMMENT_APPNAME' => 'Your %2$s, %1$s, has a new comment added to it by someone on %3$s!',
        'YOUR_TYPE_HAS_NEW_COMMENT_APPNAME' => 'Your %1$s has a new comment added to it by someone on %2$s!',
        'HERE_IS_LINK' => 'Here\'s the link to join: <a %s>%s</a>',
        'THANKS_VALEDICTION' => 'Thanks,',
        'THANKS' => 'Thanks!',
        'YOU_CHANGED_YOUR_EMAIL_ON_X' => 'You changed your e-mail address on %s.',
        'YOU_CHANGED_YOUR_EMAIL_ON_X_ELLIPSIS' => 'You changed your e-mail address on %s…',
        'CLICK_HERE_TO_SIGN_IN_WITH_YOUR_NEW_EMAIL_ADDRESS' => 'Click here to sign in with your new e-mail address:',
        'IF_DID_NOT_CHANGE_EMAIL_ADDRESS' => 'If you did not change your e-mail address, click here:',
        'TO_STOP_BEING_NOTIFIED_OF_NEW_DISCUSSIONS_GO_TO' => 'To stop being notified of new discussions, go to:',
        'X_STARTED_DISCUSSION_ON_APPNAME_ELLIPSIS' => '%1$s started a new discussion on %2$s…',
        'X_STARTED_THE_DISCUSSION_Y' => '%1$s started the discussion "%2$s".',
        'TO_VIEW_THIS_DISCUSSION_GO_TO' => 'To view this discussion, go to:',
        'X_HAS_INVITED_YOU_TO_JOIN_Y'					=> '%s has invited you to join %s!',
        'X_WANTS_YOU_TO_CHECK_OUT_Y'					=> '%s wants you to check out "%s" on %s!',
        'CHECK_OUT_TITLE_ON_APPNAME' => 'Check out "%s" on %s!',
        'ABOUT_X'										=> 'About %s',
        'YOU_HAVE_RECEIVED_BECAUSE_X' => 'You have received this e-mail because %s',
        'IF_YOU_NO_LONGER_WISH_FROM_X_CLICK_Y'			=> 'If you no longer wish to receive notification emails from %s, <a %s>please click here</a>.',
        'CLICK_HERE'									=> 'Click Here',
        'YOU_CAN_CONTACT_US'							=> 'You can contact us with any questions or concerns regarding your privacy at http://help.ning.com/?page_id=27.',
        'MESSAGE_TO_ALL_MEMBERS_OF_X'					=> 'A message to all members of %s',
        'CLICK_TO_CHECK_OUT'							=> 'Click here to check it out!',
        'CLICK_TO_APPROVE_X'							=> 'Click here to approve/delete this %s',
        'YOUR_X_HAS_BEEN_APPROVED'						=> 'Your %s has been approved on %s!',
        'YOUR_X_WAS_NOT_APPROVED'						=> 'Your %s was not approved on %s.',
        'CLICK_TO_VIEW_X'								=> 'Click here to view this %s!',
        'CLICK_TO_VIEW_IT'								=> 'Click here to view it!',
        'TO_VIEW_USER_PROFILE_VISIT' => 'To view %s\'s profile, visit:',
        'YOU_ADDED_CONTENT'								=> 'you added content to %s, a moderated social network',
        'X_REPORTED_AN_ISSUE_ON_Y_ELLIPSIS' => '%1$s has reported an issue on %2$s...',
        'X_REPORTED_THE_FOLLOWING_ISSUE' => '%s reported the following issue.',
        'URL_REPORTED_COLON' => 'URL Reported:',
        'ISSUE_COLON' => 'Issue:',
        'ADDITIONAL_INFORMATION_COLON' => 'Additional Information:',
        'SEND_AN_INVITATION_TO_X'						=> 'Send an invitation to %s',
        'SOMEBODY_REQUESTED_JOIN_X'						=> 'somebody has requested to join %s',
        'WANT_TO_ADD_A_WELCOME_MESSAGE_FOR_X_ON_THEIR_PROFILE_GO_TO' => 'Want to add a welcome message for %s on their profile?  Go to:',
        'USER_HAS_SENT_YOU_A_MESSAGE' => '%s has sent you a message.',
        'TO_READ_THIS_MESSAGE_VISIT' => 'To read this message, visit:',
        'X_HAS_SENT_YOU_A_MESSAGE_ON_Y_ELLIPSIS' => '%s has sent you a message on %s…',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ELLIPSIS' => '%s has added you as a friend…',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ON_Y' => '%s has added you as a friend on %s...',
        'X_HAS_ACCEPTED_YOUR_FRIEND_REQUEST'			=> '%s has accepted your friend request on %s!',
        'TO_ACCEPT_THIS_FRIEND_REQUEST_VISIT' => 'To accept this friend request, visit:',
        'VIEW_XS_PAGE_ON_Y'								=> 'View %s\'s page on %s',
        'MEMBER_OF_X_ACCEPTED'							=> 'a member of %s accepted your friend request',
        'IF_NO_LONGER_WISH_FRIEND_NOTIFICATION_EMAIL_FROM_X_CLICK_Y'=> 'If you no longer wish to receive friend request notification emails from %s, <a %s>please click here</a>.',
        'YOU_RECEIVED_INVITATION_FROM_X' => 'You received this invitation from a member of %1$s. If you do not wish to receive invitations from %1$s, please contact us at http://help.ning.com/?page_id=27 .',
        'ON_X_COLON'									=> 'On %s:',
        'ON_X'											=> 'on %s',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP' => '%s has requested membership of %s.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X_ELLIPSIS' => '%1$s has requested to join %2$s on %3$s...',
        'USER_HAS_INVITED_YOU_TO_JOIN_THE_GROUP_X' => '%1$s has invited you to join the Group "%2$s"',
        'VISIT_GROUP_AT' => 'Visit %s at:',
        'ABOUT_GROUP'									=> 'About %s',
        'A_MESSAGE_FROM_USERNAME_TO_GROUPNAME_ON_APPNAME'	=> 'A message from %s to all members of %s on %s!',
        'YOU_CAN_SIGN_IN_USING_EMAIL_HERE' => 'You can sign in using your e-mail address here:',
        'USERNAME_COMMENTED_ON_BLOG_POST_TITLE_APPNAME' => '%s commented on the blog post \'%s\' on %s',
        'SEND_X_A_MESSAGE_HERE' => 'Send %s a message here:',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X_ELLIPSIS' => 'You have a new member to approve on %s…',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE' => 'You have a new member to approve.',
        'TO_APPROVE_XS_PROFILE_VISIT' => 'To approve %s\'s profile, visit:',
        'CANT_CLICK_CUT_AND_PASTE' => 'Can\'t click the link above? Simply copy and paste the URL into your web browser.',
        'CLICK_HERE_TO_JOIN_COLON' => 'Click here to join:',
        'CLICK_HERE_TO_JOIN_BANG' => 'Click here to join!',
        'YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED_ELLIPSIS' => 'Your %s membership has been approved…',
        'CONGRATULATIONS_BANG_YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED' => 'Congratulations!  Your %s membership has been approved.',
        'YOU_CAN_NOW_SIGN_IN_USING_YOUR_EMAIL_ADDRESS_HERE' => 'You can now sign in using your e-mail address here:',
        'VISIT_X_AT_Y' => 'Visit %1$s at: %2$s',
        'TO_CONTROL_WHICH_EMAILS_YOUR_RECEIVE_ON_X_GO_TO' => 'To control which e-mails you receive on %1$s, go to:',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_ELLIPSIS' => 'A banned member has sent you a message on %s…',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_USERNAME_WRITES' => 'A banned member has sent you a message on %1$s.  %2$s writes:',
        'WELCOME_TO_THE_GROUP_X' => 'Welcome to the Group "%s"',
        'WELCOME_TO_GROUP_X_ON_Y_ELLIPSIS' => 'Welcome to %1$s on %2$s…',
        'TO_VIEW_THIS_GROUP_VISIT' => 'To view this group visit:',
        'X_INVITES_YOU_TO_JOIN_Y' => '%1$s invites you to join %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y' => '%1$s is now a member of %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y_ELLIPSIS' => '%1$s is now a member of %2$s…',
        'SOMEBODY' => 'Somebody',
        'TO_VIEW_YOUR_NEW_COMMENT_VISIT' => 'To view your new comment, visit:',
        'TO_VIEW_THE_NEW_COMMENT_VISIT' => 'To view the new comment, visit:',
        'TO_VIEW_THE_NEW_REPLY_VISIT' => 'To view the new reply, visit:',
        'WELCOME_TO_X_THANK_YOU_FOR_JOINING' => 'Welcome to %s! Thank you for joining.',
        'NAME_COLON' => 'Name:',
        'EMAIL_COLON' => 'E-mail:',
        'AGE_COLON' => 'Age:',
        'GENDER_COLON' => 'Gender:',
        'LOCATION_COLON' => 'Location:',
        'COUNTRY_COLON' => 'Country:',
        'GET_NETWORK_BADGE' => '%s Badge',
        'SPREAD_WORD_GET_BADGE' => 'Spread the word. Get your own %s badge for your website or MySpace page. (<a %s>Get Code</a>)',
        'SPREAD_WORD_GET_BADGE_SHORT' => 'Spread the word. <a href="%s">Get your own %s badge</a>',
        'SHOW_ALLEGIANCE_GET_BADGE' => 'Show your allegiance. Get your own %s badge to put on your website or MySpace page. (<a %s>Get Code</a>)',
        'USER_COMMENTED_ON_A_TYPE_ON_APPNAME' => '%1$s commented on the %2$s "%4$s" on %3$s',
        'UNABLE_TO_EXTRACT_EMAIL_ADDRESSES' => 'Sorry “ We were unable to extract any email addresses from the file.',
        'ADMINISTRATORS' => 'Administrators',
        'YOUR_INVITATION_HAS_EXPIRED' => 'Your Invitation Has Expired',
        'SORRY_INVITATION_EXPIRED' => 'We\'re sorry, the invitation you\'ve used has expired.  You will need a new invitation to join %s.',
        'DISABLE_INVITATION_LINK' => 'Disable Invitation Link?',
        'CREATING_LINK_WILL_DISABLE' => 'Creating a new invitation link will disable the current link. Are you sure you want to create a new link?',
        'SHARE_LINK_WITH_PEOPLE' => 'Share this link with people you want to join this network:',
        'CREATE_INVITATION_LINK' => 'Create New Invitation Link',
        'PLEASE_SELECT_SECOND_PART' => 'Please select the second part of your e-mail address, e.g., gmail.com.',
        'AT_SYMBOL_NOT_ALLOWED' => 'Please ensure that the @ symbol is not in the first part of the e-mail address.',
        'SORRY_WE_DONT_SUPPORT' => 'Sorry, we don\'t support the web address book for your e-mail address. Try clicking \'E-mail Application\' below to use addresses from your computer.',
        'PLEASE_ENTER_PASSWORD_FOR_EMAIL' => 'Please enter your password for %s.',
        'IMPORTING_ADDRESS_BOOK' => 'Importing Address Book',
        'LEAVE_WINDOW_WHILE_GET' => '<strong>Please leave this window open</strong> while we get your friends\' e-mail addresses. When we\'ve finished, you can choose which friends to invite.',
        'SHARE_THIS_LINK' => 'Share this link:',
        'SEND_WITH_EMAIL_PROGRAM' => 'Send it with your computer\'s e-mail program:',
        'EMAIL_THIS' => 'E-mail this',
        'IS_YOUR_FRIEND_PARENTHESIZED' => '(is your friend)',
        'CLEAR' => 'Clear',
        'SEARCH_FRIENDS_TO_INVITE' => 'Search Friends to Invite:',
        'YOUR_INVITATIONS_HAVE_BEEN_SENT' => 'Your Invitations Have Been Sent',
        'WANT_TO_INVITE_MORE' => 'Want to invite more friends? Invite more friends by importing contacts from your web address book or e-mail application.',
        'MESSAGE_TOO_LONG' => 'Your message is too long. Please use less than %s characters.',
        'FOLLOWING_DO_NOT_SEEM_VALID' => 'The following do not seem to be valid e-mail addresses. The invitations were not sent. Please correct the e-mail addresses and try again.',
        'PLEASE_ENTER_EMAIL_ADDRESSES' => 'Please enter one or more e-mail addresses.',
        'ENTER_EMAIL_ADDRESSES' => 'Enter E-mail Addresses',
        'SEPARATE_MULTIPLE_ADDRESSES' => 'Separate multiple addresses with commas',
        'YOUR_MESSAGE_OPTIONAL' => '<label>Your Message</label> (Optional)',
        'SEND_INVITATIONS' => 'Send Invitations',
        'WEB_ADDRESS_BOOK' => 'Web Address Book',
        'YAHOO_MAIL_HOTMAIL' => 'Yahoo Mail, Hotmail, GMail or AOL Mail',
        'YOUR_EMAIL_ADDRESS' => 'Your E-mail Address',
        'IMPORT_ADDRESS_BOOK' => 'Import Address Book',
        'DONT_WORRY_WE_WONT_SAVE' => 'Don\'t worry, we won\'t save your password and you\'ll get a chance to choose which friends to e-mail.',
        'EMAIL_APPLICATION' => 'E-mail Application',
        'MICROSOFT_OUTLOOK_APPLE_MAIL' => 'Microsoft Outlook, Apple Mail, .CSV, etc.',
        'UPLOAD_CSV_OR_VCF' => 'Upload a .csv or .vcf file exported from Microsoft Outlook or Apple Address Book.',
        'BROWSE_FOR_FILE' => 'Browse For File',
        'UPLOAD' => 'Upload',
        'SELECT_ELLIPSIS' => 'select...',
        'OTHER_ELLIPSIS' => 'other...',
        'DONT_WORRY_YOULL_GET_CHANCE' => 'Don\'t worry, you\'ll get a chance to choose which friends to e-mail.',
        'MEMBERSHIP_BY_INVITATION_ONLY' => 'Membership by Invitation Only',
        'IF_YOU_ARE_ADMIN' => 'If you are an administrator, <a %s>click here to sign in</a>.',
        'NAME_MUST_BE_SHORTER' => 'Name has to be shorter than %s characters',
        'CITY_NAME_MUST_BE_SHORTER' => 'City name has to be shorter than %s characters',
        'EMAIL_ALREADY_REGISTERED' => 'The e-mail address has already been registered. Please choose another.',
        'EMAIL_NOT_VALID' => 'The e-mail address does not seem to be valid.',
        'USERNAME_INVITED_YOU_TO_APPNAME' => '%s invited you to %s',
        'YOU_ARE_SIGNING_UP_WITH' => 'You are signing up with your Ning ID.',
        'NOW_ENTER_PASSWORD' => 'Now just enter your password to continue.',
        'OR_SIGN_IN' => 'or <a %s>Sign In</a>',
        'CHANGE_ADDRESS' => 'Change Address',
        'CHANGE_PAGE_ADDRESS' => 'Change Page Address',
        'PAGE_ADDRESS_TAKEN' => 'Our apologies - that address has already been taken. Please choose another.',
        'PAGE_ADDRESS_NOT_VALID' => 'You may only use the letters A-Z, numbers and underscores (_) in your address.',
        'ADD_BY_PHONE' => 'Add By Phone',
        'PAGE_ADDRESS' => 'Page Address',
        'PHOTO_MUST_BE_TYPE' => 'Your photo must be a .jpg, .gif or .png file.',
        'USEFUL_ADDRESSES' => 'Useful Addresses',
        'MY_DETAILS' => 'My Details',
        'NONE_I_DO_NOT_WANT' => 'None: I don\'t want to receive e-mails from %s',
        'CHANGE_PASSWORD' => 'Change Password',
        'PROFILE_SAVED' => 'Your changes were saved successfully.',
        'UPDATE_EMAIL_ADDRESS' => 'Update E-mail Address',
        'EDIT_EMAIL_ADDRESS' => 'Edit Your E-mail Address',
        'MY_SETTINGS' => 'My Settings',
        'ABOUT_ME' => 'About Me',
        'SELECT' => 'Select…',
        'CITY' => 'City',
        'COUNTRY' => 'Country',
        'DATE_OF_BIRTH' => 'Date of Birth',
        'DO_NOT_DISPLAY' => 'Don\'t Display',
        'GENDER' => 'Gender',
        'CREATE_YOUR_PROFILE' => 'Create Your Profile',
        'SYSTEM_REQUIREMENTS' => 'System Requirements',
        'WE_SUPPORT_INTERNET_EXPLORER' => 'We support Internet Explorer 6 & 7, Firefox 2.0 and Safari 2.0. If you\'re using a different browser (perhaps one provided by your internet service provider) it might not be compatible.',
        'MAKE_SURE_COOKIES' => 'Make sure cookies and JavaScript are enabled on your browser.',
        'WHAT_IS_MY_EMAIL' => 'What is my E-mail Address?',
        'IF_JOINED_BEFORE_OCTOBER' => 'If you joined before October 5th 2007, you may previously have been prompted for a \'Ning ID\'. We now ask for you to sign in with the e-mail address you registered with, however you can still enter your Ning ID in this field.',
        'CLICK_HERE_TO_RESET_PASSWORD' => 'Click here to reset your password.',
        'STILL_HAVING_PROBLEMS' => 'Still having problems?',
        'VISIT_NING_HELP_CENTER' => 'Visit the <a %s>Ning Help Center</a> for more troubleshooting information and support.',
        'PROBLEMS_SIGNING_UP_OR_SIGNING_IN' => 'Problems Signing Up or Signing In',
        'WE_SENT_YOU_EMAIL' => 'We\'ve sent you an e-mail with a link to reset your password.',
        'RESET_PASSWORD_EMAIL_SUBJECT' => 'Password Reset',
        'RESET_PASSWORD_EMAIL_BODY' => '%1$s,

We received a request to change your password on %2$s.

Click the link below to set a new password:

#{URL}

If you don\'t want to change your password, you can ignore this e-mail.

Thanks,
The "%2$s" Team

-----
%2$s uses the Ning ID for authentication.',
        'SET_PASSWORD' => 'Set Password',
        'NEW_PASSWORD' => 'New Password',
        'CREATE_NEW_PASSWORD' => 'Create a New Password',
        'SET_NEW_PASSWORD' => 'Set a new password for your account.',
        'CHOOSE_NEW_PASSWORD' => 'Please choose a new password',
        'HELLO_USERNAME_SIGN_OUT' => '<strong>Hello, %s</strong> (<a %s>Sign Out</a>)',
        'NO_ACCOUNT_WITH_EMAIL_X' => 'There is no account with the e-mail address %s',
        'PLEASE_ENTER_CODE' => 'Please enter the code that appears on the right-hand side.',
        'PROBLEMS_SIGNING_UP' => 'Problems signing up?',
        'BY_SIGNING_UP_YOU_AGREE' => 'By signing up, you agree to the <a %s>Terms of Service</a> and <a %s>Privacy&nbsp;Policy</a>.',
        'FEEDBACK' => 'Feedback',
        'TERMS_OF_SERVICE' => 'Terms of Service',
        'PROBLEM_SIGNING_UP' => 'There was a problem signing up',
        'ALREADY_MEMBER_SIGN_IN' => 'Already a member? <a %s>Click here to sign in</a>.',
        'MEMBERSHIP_TO_APPNAME_BY_INVITATION_ONLY' => 'Membership to %s is By Invitation Only',
        'SORRY_BUT_ADMINISTRATOR_REQUIRES_INVITATION' => 'We\'re sorry, but the administrator has chosen to require an invitation to join %s. If you have an invitation, click the link in the e-mail to join.',
        'PROBLEM_SIGNING_IN' => 'There was a problem signing in',
        'WE_USE_NING_ID' => 'We use Ning ID for authentication. <a %s>What is a Ning ID?</a>',
        'PROBLEMS_SIGNING_IN' => 'Problems signing in?',
        'SIGN_IN_OR_SIGN_UP' => '<input %s value="Sign In" /> &#160;or&#160; <strong><a %s>Sign Up</a></strong>',
        'SIGN_IN_TO_APPNAME' => 'Sign in to %s',
        'WHAT_IS_A_NING_ID' => 'What is a Ning ID?',
        'LARR_BACK' => '← <a %s>Back</a>',
        'NING_ID_LETS_YOU_CHOOSE' => 'The Ning ID authentication system lets you choose an e-mail address and password once and use it to join or sign into any social network that uses the Ning ID.',
        'WHEN_YOU_CREATE_NING_ID' => 'When you create a Ning ID, you can also add a set of basic details and your photo to your Ning ID account. These details are then pre-populated whenever you join a new social network that uses the Ning ID for authentication. It also enables you to keep track of your friends and messages across all the social networks that use it.',
        'SIGN_IN_WITH_NING_ID_WHENEVER' => 'You can sign in with your Ning ID e-mail address and password whenever you see this symbol: %s',
        'HELLO_USER' => 'Hello, %s',
        'TEXT_FOR_HEADER_TAB' => 'This text is for a header tab',
        'BASED_ON' => 'Based on',
        'ARE_YOU_SURE_DELETE_LANGUAGE' => 'Are you sure you want to delete this language?',
        'DELETE_LANGUAGE' => 'Delete Language',
        'TEXT_RESET_TO_ORIGINAL_VERSION' => 'The text has been reset to the original version.',
        'UPLOAD_LANGUAGE_FILE' => 'Upload Language File',
        'ADD_TO_LANGUAGE' => 'Add to Language:',
        'IF_YOU_CREATED_TRANSLATION' => 'If you\'ve created a new translation on another Ning social network, you can import your work here. The contents of the file will be added to the language of your choice. Don\'t see your language listed? <a %s>It\'s easy to add a new one</a>.',
        'EXAMPLES_SWEDISH_FINLAND' => 'Examples: Swedish (Finland), Filipino, Spanish (Puerto Rico)',
        'START_FROM_SCRATCH_CREATE' => 'Start from scratch! Create a new translation for your network by entering a name for the new language, then picking an existing language as a reference point.',
        'KEY_MISSING_TEXT' => 'Key: <span %s>Missing Text</span> <span %s>Changed Text</span>',
        'SHOW_ALL_TEXT' => 'Show All Text',
        'SHOW_MISSING_TEXT' => 'Show Missing Text',
        'SHOW_CHANGED_TEXT' => 'Show Changed Text',
        'EXAMPLES_TABS_MEMBERS_FRIENDS' => 'Examples: Tabs, Members, Friends',
        'RESET_TEXT_TO_ORIGINAL_VERSION' => 'Reset Text to Original Version',
        'ORIGINAL_TEXT_X' => 'Original Text – %s',
        'EDIT_LANGUAGE_ON_NETWORK' => 'Edit the Language on Your Network',
        'CUSTOMIZE_TEXT_ON_NETWORK_INCLUDING' => 'Customize any of the text on your network, including tab names, e-mail footers, error messages and more.',
        'ACTIVE_LANGUAGE_IS_X' => '<em>The active language for your network is %1$s</em>. <a %2$s>Change Active Language</a>',
        'CURRENT_LANGUAGE_OPTIONS' => 'Current Language Options',
        'ACTIVE' => 'Active',
        'MY_LANGUAGES' => 'My Languages',
        'CREATE_NEW_TRANSLATION' => 'Create a New Translation',
        'DONT_SEE_LANGUAGE_LISTED_CREATE' => 'Don\'t see your language listed above? <strong><a %s>Create a new translation for your network</a></strong>.',
        'ADVANCED_IMPORT' => 'Advanced Import',
        'IF_YOU_TRANSLATED_A_LANGUAGE' => 'If you\'ve translated a language on an existing social network, you can <strong><a %s>import your language file</a></strong> and use it on this network.',
        'LANGUAGE_EDITOR' => 'Language Editor',
        'PUBLIC' => 'Public',
        'GRANDFATHERED_PRIVACY_SETTING' => 'Your current privacy setting, a public network where non-members can only view the login screen, is no longer available.  Your privacy setting has not been changed, but if you make any changes here, you will not be able to return.  The current equivalent is a private network that anyone can sign up to become a member.',
        'NO_MISSING_ITEMS' => 'There are no missing items – this translation is 100%% complete. <a %s>View all items.</a>',
        'NO_CHANGED_ITEMS' => 'There are no changed items.',
        'COULD_NOT_FIND_ITEMS_MATCHING' => 'Our apologies – we couldn\'t find any items matching <em>%s</em>. <a %s>View all items.</a>',
        'FILE_N' => 'File %s',
        'TRANSLATION_FILE_HAS_FILENAME_LIKE' => 'A Ning translation file has a filename like <code>en_US.txt</code>. <a %s>Learn more here.</a>',
        'SELECT_TRANSLATION_FILE' => 'Select Translation File:',
        'USE_THIS_TRANSLATION' => 'Use This Translation',
        'FOLLOWING_ARE_MISSING_FROM_RULES' => 'Note that the following are missing from the rules below: %s',
        'ALL' => 'All',
        'MISSING' => 'Missing',
        'VIEW' => 'View',
        'TRANSLATION_CHANGES_SAVED' => 'Your changes have been saved. This translation is %s%% complete.',
        'TRANSLATION_CHANGES_SAVED_MAKE_CURRENT' => 'Your changes have been saved. This translation is %s%% complete. Would you like to use this as the current language for your network?',
        'TRANSLATION_UPLOAD_SUCCESSFUL' => 'Your upload was successful. This translation is %s%% complete.',
        'TRANSLATION_UPLOAD_SUCCESSFUL_MAKE_CURRENT' => 'Your upload was successful. This translation is %s%% complete. Would you like to use this as the current language for your network?',
        'X_IS_CURRENT_LANGUAGE' => '%s is now the language of your network.',
        'SAVE_PAGE' => 'Save Page',
        'LANGUAGE_NAME_TAKEN' => 'Sorry - that name has already been taken. Please choose another name.',
        'ENTER_NAME_FOR_TRANSLATION' => 'Please enter a name for your new translation, e.g., Portuguese (Portugal)',
        'CREATE' => 'Create',
        'LANGUAGE_NAME' => 'Language Name',
        'SAVE_ITEMS_ON_PAGE' => 'Save the items on this page',
        'NEW_TRANSLATION' => 'New Translation',
        'MISMATCHED_CURLY_BRACKETS' => 'Mismatched curly brackets',
        'MISMATCHED_SQUARE_BRACKETS' => 'Mismatched square brackets',
        'MISMATCHED_PARENTHESES' => 'Mismatched parentheses',
        'ERROR_PROCESSING_SPECIAL_RULES' => 'An error occurred while processing the Special Rules code.',
        'ERROR_PROCESSING_TAB_NAMES' => 'An error occurred while processing the Tab Names code.',
        'SPECIAL_RULES' => 'Special Rules',
        'TAB_NAMES' => 'Tab Names',
        'SOURCE' => 'Source',
        'LANGUAGE_EDITOR_X' => 'Language Editor: %s',
        'BACK_TO_LANGUAGE_EDITOR' => '← Back to Language Editor',
        'CUSTOMIZE_YOUR_NETWORKS_TEXT' => 'Customize your network\'s text and messages or create a new language.',
        'STOPWORDS' => 'a | about | an | are | as | at | be | by | com | de | en | for | from | how | i | in | is | it | la | of | on | or | that | the | this | to | was | what | when | where | who | will | with | und | the | www',
        'STOPWORDS_ARE' => '<a %s>Stopwords</a> are an optional list of words to filter out of the network description when creating the meta tag at the top of each page. Optional.',
        'I_AM_MEMBER'									=> 'I\'m a member of:',
        'VIEW_PAGE_ON_APPNAME' => 'View my page on <em>%s</em>',
        'VISIT_APPNAME' => 'Visit <em>%s</em>',
        'JOIN_US'										=> 'Join Us',
        'CREATED_BY_COLON'									=> 'Created By:',
        'GET_MORE_BADGES'								=> 'Get More Badges',
        'SHOW_LOGO'										=> 'Show logo',
        'GALLERY'										=> 'Gallery',
        'BADGES'										=> 'Badges',
        'MEMBER_BADGE' => 'Member Badge',
        'WEAR_IT_WITH_PRIDE' => 'Wear it with pride! Get a %s member badge that you can display on your website or MySpace page.',
        'NETWORK_BADGE_LARGE'							=> 'Network Badge (Large)',
        'SPREAD_THE_WORD_NETWORK_BADGE_LARGE'			=> 'Spread the word! Get a %s badge that dynamically updates with the networks most popular members. Add it to your website or MySpace page.',
        'NETWORK_BADGE_SMALL'							=> 'Network Badge (Small)',
        'SPREAD_THE_WORD_NETWORK_BADGE_SMALL'			=> 'Spread the word! Get a %s badge that you can display on your website or MySpace page.',
        'PHOTO_SLIDESHOW_PROPER'						=> 'Photo Slideshow',
        'DISPLAY_SELECTION_OF_PHOTOS'					=> 'Display a selection of your photos on a website or MySpace page with our stylish photo slideshow player.',
        'MUSIC_PLAYER'									=> 'Music Player',
        'PLAY_MUSIC_ON_WEBSITE'							=> 'Play your music on a website or MySpace page with our stylish photo slideshow player.',
        'ADD_A_VIDEO_MORE_OPTIONS'						=> 'Add a video to your website or MySpace page. Looking for more options? <a href="%s">View all videos</a> on %s.',
        'LARGE_N_PIXELS_WIDE'							=> 'Large - %d pixels wide',
        'MEDIUM_N_PIXELS_WIDE'							=> 'Medium - %d pixels wide',
        'SMALL_N_PIXELS_WIDE'							=> 'Small - %d pixels wide',
        'MY_MOST_RECENT'								=> 'My Most Recent',
        'APP_ICON'										=> 'App Icon',
        'MEMBERSHIP_TO_X_IS_BY_INVITATION' => 'Membership to %s is by invitation only',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK' => '%s provided the following feedback:',
        'X_PROVIDED_FEEDBACK_ON_Y_ELLIPSIS' => '%1$s provided feedback on %2$s…',
        'THANK_YOU_YOUR_MESSAGE_HAS_BEEN_SENT'			=> 'Thank you. Your message has been sent.',
        'X_WOULD_LIKE_TO_JOIN_X'						=> '%s would like to join %s!',
        'X_HAS_REQUESTED_AN_INVITATION'					=> '%s has requested an invitation to %s',
        'YOUR_REQUEST_HAS_BEEN_SENT'					=> 'Your request has been sent to the network creator.',
        'TO_UNBAN_USERNAME_GO_TO' => 'To lift the ban %s, go to:',
        'SEND_REQUEST'									=> 'Send Request',
        'SEARCH'										=> 'Search',
        'SEARCH_AGAIN'									=> 'Search Again',
        'SEND_BROADCAST_MESSAGE'						=> 'Send Broadcast Message',
        'VERIFICATION_IMAGE'							=> 'Verification Image',
        'UNDER_CONSTRUCTION'							=> 'Under Construction',
        'PROFILE_INFORMATION_SAVED'						=> 'Profile Information Saved',
        'YOUR_SITES_DIRECTORY_PROFILE'					=> 'Your Network\'s directory profile information has been saved.',
        'NO_ACCOUNT_WITH_EMAIL' => 'There is no account with that email address.',
        'INVALID_PASSWORD_CHECK_CAPS_LOCK' => 'Wrong password.  Is Caps Lock on?',
        'OOPS_THAT' => 'Oops – that didn\'t work.',
        'OOPS_THAT_DID_NOT_WORK' => 'Oops – that didn\'t work.  Try again?',
        'OOPS_THAT_DID_NOT_WORK_ERROR_CODE' => 'Oops – that didn\'t work (%s).',
        'NOT_FOUND'										=> 'Not Found',
        'YOUR_SITES_FEATURE_LIST'						=> 'Your Network\'s feature list has been saved.',
        'ONE_LINE_ANSWER'								=> 'One Line Answer',
        'LONGER_ANSWER'									=> 'Longer Answer',
        'MULTIPLE_CHOICE'								=> 'Multiple Choice',
        'DATE'											=> 'Date',
        'WEBSITE_ADDRESS'								=> 'Website Address',
        'EVERYTHING'									=> 'Everything',
        'JUST_THE_HOMEPAGE'								=> 'Just the main page',
        'JUST_THE_SIGN_UP_PAGE'							=> 'Just the sign-up page',
        'YOUR_CHANGES_HAVE_BEEN_SAVED'					=> 'Your changes have been saved.',
        'JOIN_ME_ON_X'									=> 'Join me on %s!',
        'NOT_ALLOWED'									=> 'Not Allowed',
        'COME_JOIN_ME_ON_X' => 'Come join me on %s.',
        'COME_JOIN_ME_ON_X_ELLIPSIS' => 'Come join me on %s…',
        'X_NOT_VALID_EMAIL' => '%s is not a valid e-mail address or Ning ID',
        'USER_BANNED_FROM_NETWORK'						=> '%1$s has been banned from this network. <a %2$s>Send %1$s a message</a>',
        'USER_ALREADY_NETWORK_MEMBER'					=> '%1$s is already a member of this network. <a %2$s>Send %1$s a message</a>',
        'YOU_CAN_SEND_AT_MOST_X'						=> 'You can send at most %s at once.',
        'PLEASE_ENTER_YOUR_FRIENDS' => 'Please enter your friends\' e-mail addresses or Ning IDs',
        'THERE_HAS_BEEN_AN_ERROR'						=> 'There has been an error',
        'INVITATIONS_HAVE_BEEN_SENT'					=> 'Your invitations have been sent.',
        'SEARCH_RESULTS'								=> 'Search Results',
        'INVITE_YOUR_FRIENDS'							=> 'Invite Your Friends',
        'SEND_INVITATIONS_FOR_FRIENDS'					=> 'Send invitations for your friends to join',
        'INVITATION'									=> 'Invitation',
        'ADD_FROM_ADDRESS'								=> 'Add from Address Book',
        'TO'											=> 'To:',
        'SEND_TO'										=> 'Send To',
        'SUBJECT'										=> 'Subject',
        'YOUR_MESSAGE'									=> 'Your Message',
        'SEND'											=> 'Send',
        'REPORT_AN_ISSUE'								=> 'Report an Issue',
        'TYPE_OF_ISSUE'									=> 'Type of Issue',
        'ADULT'											=> 'Adult',
        'ABUSIVE'										=> 'Abusive',
        'BUG'											=> 'Bug',
        'FRAUD'											=> 'Fraud',
        'SPAM'											=> 'Spam',
        'OTHER'											=> 'Other',
        'DESCRIBE_YOUR_ISSUE'							=> 'Describe Your Issue',
        'SEND_REPORT'									=> 'Send Report',
        'ADDED_BY_X_AT_X'								=> 'Added by <a %s>%s</a> at %s on %s',
        'ADDED_BY_USER_TO_GROUP_AT_DATE'				=> 'Added by <a %s>%s</a> to %s at %s on %s',
        'G_IA'											=> 'g:ia',
        'F_JS_Y'										=> 'jS F Y',
        'CLICK_TO_VIEW'									=> 'Click to View',
        'COMMENT_FOR'									=> 'Comment for:',
        'COMMENT_ON'									=> 'Comment on:',
        'ACTION_BUTTON_FEATURE'							=> 'Feature',
        'FEATURE_THIS_ON_YOUR'							=> 'Feature this on the main page',
        'ACTION_BUTTON_REMOVE'							=> 'Remove',
        'REMOVE'										=> 'Remove',
        'REMOVE_THIS_FROM_YOUR'							=> 'Remove this from the main page',
        'FEATURE_ON_HOME'								=> 'Feature on Main',
        'REMOVE_FROM_HOME'								=> 'Remove from Main',
        'ITEM_WILL_APPEAR'								=> 'This item will now appear on selected modules on the main page',
        'ITEM_WILL_NO_LONGER_APPEAR'					=> 'This item will no longer appear on selected modules on the main page',
        'ADD_CONTENT'									=> 'Add Content',
        'BROUGHT_TO_YOU_BY' => '%s brought to you by %s © %s',
        'GIVE_US_YOUR_FEEDBACK'							=> 'Give Us Your Feedback',
        'FOR_ADDITIONAL_QUESTIONS_OR_TO_CONTACT_NING_PLEASE_CLICK_HERE' => 'For additional questions or to contact Ning, please click here:',
        'SEND_FEEDBACK'									=> 'Send Feedback',
        'SIGN_OUT'										=> 'sign out',
        'SIGN_OUT_TITLE' => 'Sign Out',
        'EDIT_MY_PROFILE'								=> 'Edit My Profile',
        'INVITE_MORE'									=> 'Invite More',
        'USE_THIS_FORM_TO_SEND_FEEDBACK_TO_NC' => 'Use this form to send feedback to <a %s>%s</a>, the creator of <a %s>%s</a>.',
        'YOUR_FEEDBACK'									=> 'Your Feedback',
        'NETWORK_INFORMATION'							=> 'Network Information',
        'ABOUT_YOUR_SITE'								=> 'About Your Network',
        'WELCOME_TO_YOUR_SITE'							=> 'Welcome to Your Social Network!',
        'EDIT_YOUR_NETWORKS_INFO' => 'Edit your network\'s name, description and other information.',
        'TAGLINE'										=> 'Tagline',
        'APPEARS_IN_HEADER'								=> 'Appears in the header of your network',
        'APPEARS_IN_EMAILS' => 'Appears in e-mails and elsewhere',
        'NETWORK_NAME'									=> 'Network Name',
        'DESCRIPTION'									=> 'Description',
        'KEYWORDS'										=> 'Keywords',
        'LANGUAGE'										=> 'Language',
        'SEPARATE_EACH_KEYWORD'							=> 'Separate each keyword with a comma',
        'ICON'											=> 'Icon',
        'UPLOAD_A_PHOTO_WHICH_WILL_BE_RESIZED'			=> 'Upload a photo (GIF, JPG or PNG), which will be resized to a square. It may take a few minutes for this photo to appear.',
        'SAVE_SETTINGS'									=> 'Save Settings',
        'SUCCESS_EXCLAMATION'							=> 'Success!',
        'FEATURES'										=> 'Features',
        'ADD_FEATURES' => 'Add Features to Your Network',
        'ORGANIZE_FEATURES' => 'Organize your main page by dragging in features from the list below, then arranging them any way you\'d like.',
        'SKIP_FEATURES' => 'Click <a href="%s">Skip This Step</a> to continue with the default layout and features.',
        'FEATURES_FOR_ALL_PAGES' => 'Features added to this box will appear on all pages of your network.',
        'CUSTOMIZE_SITE_BY_ADDING' => 'Customize your social network by adding new features or removing existing ones.',
        'ADJUST_YOUR_SITES_COLORS'						=> 'Adjust your network\'s colours, images and overall style.',
        'APPEARANCE'									=> 'Appearance',
        'PROFILE_QUESTIONS'								=> 'Profile Questions',
        'EDIT_QUESTIONS_THAT_MEMBERS_ANSWER' => 'Edit the questions that members answer about themselves.',
        'MESSAGE_SENT'									=> 'Message Sent!',
        'YOUR_MESSAGE_HAS_BEEN_SENT'					=> 'Your message has been sent to all the members of your network.',
        'YOUR_MESSAGE_HAS_BEEN_SENT_GROUP'				=> 'Your message has been sent to all the members of your group.',
        'YOUR_MESSAGE_IS_BEING_SENT'					=> 'Your message is being sent. Please wait, as it may take a few minutes.',
        'BROADCAST_MESSAGE'								=> 'Broadcast Message',
        'TRACK_VISITORS_AND_TRENDS'						=> 'Track visitors and trends on your social network.',
        'EDIT_SOURCE_CODE'								=> 'Edit Source Code',
        'TAKE_FULL_CONTROL'								=> 'Take full control of your network\'s functionality by editing the source code.',
        'DELETE_THIS_SITE'								=> 'Delete Your Social Network',
        'MAIN_PAGE'										=> 'Main Page',
        'MAIN'											=> 'Main',
        'MAIN_TAB_TEXT' => 'Main',
        'MANAGE'										=> 'Manage',
        'MANAGE_TAB_TEXT' => 'Manage',
        'PAGE_TITLE'									=> 'Page Title',
        'LOREM_IPSUM_1'									=> 'Lorem <span %s>ipsum dolor</span> sit amet, consectetuer adipiscing elit. Nunc scelerisque blandit dolor. Vestibulum ante ipsum primis in faucibus orci luctus.',
        'LOREM_IPSUM_2'									=> 'Lorem ipsum dolor sit amet, consectetuer adipiscing',
        'LOREM_IPSUM_3'									=> 'Lorem ipsum dolor sit amet, <span class="preview_link">consectetuer</span> adipiscing',
        'EDIT_THE_APPEARANCE'							=> 'Edit the Appearance of Your Page',
        'CHOOSE_A_THEME'								=> 'Choose a Theme for Your Social Network',
        'NOW_CUSTOMIZE_SITE' => 'Now Customize Your Social Network…',
        'THEME_SETTINGS'								=> 'Theme Settings',
        'ADVANCED'										=> 'Advanced',
        'TOP_BAR_AND_FOOTER'							=> 'Top Bar & Footer',
        'HEADER_AND_NAVIGATION'							=> 'Header & Navigation',
        'ADD_A_LOGO'									=> 'Add a Logo',
        'THIS_IMAGE_WILL_REPLACE'						=> 'This image will replace the network name text',
        'TABS'											=> 'Tabs',
        'TAB' => 'Tab',
        'SITE'											=> 'Network',
        'SIDES'											=> 'Sides',
        'BODY'											=> 'Body',
        'SHOW_NING_LOGO'								=> 'Show Ning Logo?',
        'LAUNCH'										=> 'LAUNCH!',
        'NING_ID'										=> 'Ning ID',
        'PASSWORD'										=> 'Password',
        'RETYPE_PASSWORD' => 'Retype Password',
        'TYPE_CODE_ON_RIGHT' => 'Type the Code<br />on the Right',
        'JOIN_X'										=> 'Join %s',
        'SIGN_UP_FOR_X' => 'Sign Up for %s',
        'HAS_INVITED_YOU_TO_X'							=> 'has invited you to join %s.',
        'CONTENT_AWAITING_APPROVAL'						=> 'Content Awaiting Approval',
        'NEW_MEMBER'									=> 'New Member?',
        'JOIN_X_NOW'									=> 'Join %s Now!',
        'HIDE_THIS_MESSAGE'								=> 'Hide this message',
        'PAGE_NOT_FOUND'								=> 'Page Not Found',
        'THIS_PAGE_WAS_NOT_FOUND'						=> 'Our apologies – this page was not found',
        'FOLLOW_THESE_LINKS_TO'							=> 'Follow these links to a few things we know are available:',
        'ALTERNATIVELY_YOU_CAN_SEARCH'					=> 'Alternatively, you can search this social network:',
        'IF_YOU_GET_THIS_MESSAGE'						=> 'If you get this message again, <a %s>please let us know.</a>',
        'GROUP_MEMBERS'									=> 'Group Members',
        'VIDEOS'										=> 'Videos',
        'BLOG'											=> 'Blog',
        'ACCOUNT'										=> 'Account',
        'WE_ARE_SORRY_WE_ARE_HAVING'					=> 'We\'re sorry, we are having an issue with this page.',
        'FOLLOW_LINK_TO_HOMEPAGE'						=> 'Follow <a %s>this link</a> to the main page.',
        'REQUEST_AN_INVITATION'							=> 'Request an Invitation',
        'NAME'											=> 'Name',
        'EMAIL_ADDRESS' => 'E-mail Address',
        'MESSAGE_OPTIONAL'								=> 'Message (Optional)',
        'SORRY_HOWEVER_ITS_EASY'						=> '<strong>Sorry!</strong>  However, it\'s easy to start your own social network.',
        'GET_YOUR_OWN_BAZEL'							=> 'Create Your Own Social Network!',
        'SITE_IS_NOT_READY'								=> 'This social network\'s not ready yet!',
        'BAZEL_IS_BEING_SET_UP'							=> 'This social network is still being set up!',
        'SIGN_IN'										=> 'Sign In',
        'FORGOT_YOUR_PASSWORD'							=> 'Forgot your password?',
        'FORGOT_YOUR_PASSWORD_TITLE' => 'Forgot Your Password?',
        'ENTER_EMAIL_AND_CLICK_RESET_PASSWORD' => 'Enter your e-mail address and click \'Reset Password\'. You will get an e-mail with a link to reset your password.',
        'RESET_PASSWORD' => 'Reset Password',
        'EXPLORE'										=> 'Explore',
        'SIGN_UP'										=> 'Sign Up',
        'CONFIRM_PASSWORD'								=> 'Confirm Password',
        'VERIFICATION'									=> 'Let us know you\'re <br />a person',
        'YOUR_PHOTO' => 'Your Photo',
        'SUMMARY'										=> 'Summary',
        'YOUR_SITE_IS_READY'							=> 'Your social network is ready to launch!  Default settings will be used for any steps that you skipped. Go back to make changes, or click \'Launch!\' to launch your network.',
        'WHEN_YOU_ARE_FINISHED'							=> 'When you are finished, click \'View Layout\' to see your handiwork!',
        'COMPLETE'										=> 'complete',
        'INCOMPLETE'									=> 'incomplete',
        'VIEW_LAYOUT'									=> 'View Layout',
        'CLEAR_CONTENTS'								=> 'Clear Contents',
        'ADD_MODULE'									=> 'Add Module…',
        'ADD_COLUMNS'									=> 'Add Columns…',
        'PUBLIC_ANYBODY_CAN_JOIN'						=> '<strong>Public</strong> – Anybody can join',
        'PRIVATE_ONLY_INVITED'							=> '<strong>Private</strong> – Only invited people can view and join it',
        'INVITATIONS'									=> 'Invitations',
        'MEMBERS_CAN_INVITE' => 'Members can invite other people to join.',
        'QUESTION_TITLE'								=> 'Question Title',
        'ANSWER_TYPE'									=> 'Answer Type',
        'REQUIRED'										=> 'Required?',
        'PRIVATE' => 'Private',
        'CHOICES'										=> 'Choices',
        'SEPARATE_EACH_CHOICE'							=> 'Separate each choice with a comma',
        'CAN_PICK_MORE'									=> 'Can pick more than one',
        'ADD_ANOTHER_QUESTION'							=> 'Add Another Question',
        'WHAT_INFORMATION'								=> 'What questions would you like your members to answer when they join your network? You can re-order the questions below. Simply click on the question and drag it to where you want it to appear.',
        'IF_YOU_SELECT_REQUIRED_MEMBERS_WILL' => 'If you select "Required," members will have to answer the question to join. If you select "Private," the answer will only be visible to you and other administrators.',
        'WE_COULD_NOT_FIND_ANYTHING'					=> 'We couldn\'t find anything that matches "%s". Why not search for something else?',
        'GET_CUSTOM_URL'								=> 'Get your own custom URL, add storage and bandwidth, or run your own ads.',
        'VIEW_STATISTICS' => 'View Statistics',
        'ADD_TRACKING_CODE' => '<a %s>Add your own tracking code</a>.',
        'TRACKING_CODE' => 'Tracking Code',
        'ANY_JAVASCRIPT_CODE' => 'Any JavaScript code you paste here is inserted at the bottom of every page of your network. You can use this for external site-tracking systems, such as Google Analytics.',
        'ANALYTICS_LEARN_MORE' => 'To learn more about Google Analytics and set up your own account, <a %s>click here</a>.',
        'RESOURCES' => 'Resources',
        'LINKS'											=> 'Links',
        'PAGE'											=> 'Page',
        'BACKGROUND'									=> 'Background',
        'TEXT'											=> 'Text',
        'HEADING_TEXT'									=> 'Heading Text',
        'FONT'											=> 'Font',
        'AABBCC'										=> 'AaBbCc',
        'COLOR'											=> 'Colour',
        'LINK_COLOR'									=> 'Link Colour',
        'BODY_TEXT'										=> 'Body Text',
        'MIDDLE'										=> 'Middle',
        'FEATURE_BOXES'									=> 'Feature Boxes',
        'TITLEBAR_TEXT_COLOR'							=> 'Titlebar Text Colour',
        'TITLEBAR_BACKGROUND'							=> 'Titlebar Background',
        'UPLOADING_CONTENT'								=> 'Uploading Content…',
        'WHEN_UPLOADING_IS_COMPLETE'					=> 'When uploading is complete, you can check out the network.',
        'FINISH'										=> 'Finish',
        'FLICKR_IMPORT_SETUP'							=> 'Flickr Import Setup',
        'FLICKR_API_KEY'								=> 'Your Key',
        'FLICKR_SECRET'									=> 'Your Secret',
        'FLICKR_KEY_ERROR'								=> 'There was a problem with the Flickr key or secret that you entered.  Can you check them and try entering them again?',
        'FLICKR_INTRO'									=> 'Want to let your members import their photos from Flickr? You\'ve come to the right place. If you already have a Flickr API Key and Secret, you can <a %s>skip ahead</a>. Not sure what that means? Just follow the steps below and you\'ll be up and running in just a few minutes.',
        'FLICKR_GET_ACCOUNT'							=> 'If you don\'t already have a Flickr account, get one <a %s>here</a>.',
        'FLICKR_STEP1_TITLE'							=> 'Step 1: Get a Flickr API Key',
        'FLICKR_STEP1_APPLY_SCREEN'						=> 'Apply for your API Key screen on Flickr',
        'FLICKR_STEP1_API_SCREEN'						=> 'API Key screen on Flickr',
        'FLICKR_STEP1_INTRO'							=> 'Log in to Flickr and <a %s>apply for a new API key</a> (opens in a new window).',
        'FLICKR_STEP1_A' => 'Fill in <strong>Your Name</strong> and <strong>E-mail Address</strong>.',
        'FLICKR_STEP1_B'								=> 'Under <strong>This key is for&hellip;</strong> choose the <em>non-commercial use</em> option.',
        'FLICKR_STEP1_C'								=> 'Describe your social network in the <strong>Describe the application are you planning to build</strong> box.',
        'FLICKR_STEP1_D'								=> 'Check both acceptance boxes.',
        'FLICKR_STEP1_APPLY'							=> 'When you are done click the <strong>Apply</strong> button.',
        'FLICKR_STEP1_E'								=> 'You will land on a screen displaying your new API key. Click the <strong>Click here</strong> link to configure user authentication for this key.',
        'FLICKR_STEP2_TITLE'							=> 'Step 2: Setup Your Key',
        'FLICKR_STEP2_SETUP_SCREEN'						=> 'API Key Authentication Setup screen on Flickr',
        'FLICKR_STEP2_F'								=> 'Paste the following web address into the <strong>Callback URL</strong> field:',
        'FLICKR_STEP2_SAVE_CHANGES'						=> 'When you are done click the <strong>Save Changes</strong> button.',
        'FLICKR_STEP3_TITLE'							=> 'Step 3: Enter Your Information',
        'FLICKR_STEP3_KEYS_SCREEN'						=> 'API Key information screen on Flickr',
        'FLICKR_STEP3_CONGRATULATIONS'					=> 'Congratulations! You\'re now set up on Flickr.',
        'FLICKR_STEP3_COMPLETE'							=> 'To complete setup on %s, simply copy and paste your key and secret into the following fields:',
        'COMPLETE_SETUP'								=> 'Complete Setup',
        'SETUP_YOUR_SITE_TO'							=> 'Set up your social network to import photos from Flickr.',
        'FLICKR_IMPORTING'								=> 'Flickr Importing',
        'YOU_NEED_TO_SET_UP_FLICKR'						=> 'You need to set up your social network to let people import their photos from Flickr. It only takes a few minutes so why not <a %s>set it up now?</a>',
        'DONT_SHOW_THIS_AGAIN_FLICKR'					=> 'Please don\'t show me this again.',
        'YOUVE_SIGNED_OUT_OF_X'							=> 'You\'ve successfully signed out of %s. Please come back and join us again soon!',
        'CREATED_THIS_SOCIAL_NETWORK'					=> 'created this social network on <a href="http://www.ning.com">Ning</a>.',
        'CREATE_YOUR_OWN'								=> 'Create your own social network on Ning for free!',
        'DRAG_HERE_TO_REMOVE_FEATURE'					=> 'Drag Here to Remove Feature',
        'LAYOUT' => 'Layout',
        'DRAG'											=> 'Drag',
        'HERE'											=> 'Here',
        'YOU'											=> 'You',
        'ADS'											=> 'Ads',
        'MEMBERS' => 'Members',
        'HELLO_USERNAME' => 'Hello, Username',
        'CREATED_BY' => 'Created By',
        'SAVE_FEATURES'									=> 'Save Features',
        'FORUM'											=> 'Forum',
        'CATEGORIES' => 'Categories',
        'FORUM_CATEGORIES' => 'Forum Categories',
        'A_THREADED_DISCUSSION_FORUM'					=> 'A threaded discussion forum',
        'ALLOW_MEMBERS_TO_CREATE_GROUPS'				=> 'Allow members to create their own interest groups within your network',
        'FEATURE_POSTS_FROM_YOUR_BLOG'					=> 'Feature posts from your blog or other members\' blogs',
        'TEXT_BOX'										=> 'Text Box',
        'PUT_ANY_TEXT_WIDGET_OR_HTML' => 'Put any text, widget or HTML on the main page',
        'A_LIST_OF_MEMBERS' => 'A list of your social network\'s members',
        'ALLOW_USERS_PHOTOS'							=> 'Allow people to upload and share photos',
        'ADD_FEEDS_FROM_ACROSS_THE_WEB' => 'Add feeds from across the web',
        'INFORMATION_ABOUT_THE_USER'					=> 'Information about the person currently signed in',
        'ALLOW_USERS_VIDEOS'							=> 'Allow people to add and share videos',
        'SHOW_NETWORK_DESCRIPTION' => 'Show your network description',
        'PROMOTE_NETWORK_WITH_BADGES' => 'Promote your network across the web with custom badges and widgets',
        'MONETIZE_WITH_ADS' => 'Monetize your network with advertising',
        'LET_MEMBERS_KNOW_WHO_CREATED_NETWORK' => 'Let your members know who created this network',
        'FOLLOW_LATEST_ACTIVITY' => 'Follow the latest member activity on your network',
        'FAQ_FOR_NETWORK_CREATORS'						=> 'FAQ for Network Creators',
        'ANSWERS_TO_FAQS' => 'Answers to frequently asked questions about customizing your Social Network.',
        'MEET_OTHER_LIKEMINDED'							=> 'Meet other like-minded network creators, share ideas and get support from the Ning team.',
        'CUSTOMIZE_THE_APPEARANCE_NETWORK' => 'Customize the appearance of your social network by adding your own Cascading Style Sheets (CSS) in the field on the left. (<a href="%s">What is CSS?</a>)',
        'CUSTOMIZE_THE_APPEARANCE_PAGE' => 'Customize the appearance of your page by adding your own Cascading Style Sheets (CSS) in the field on the left. (<a href="%s">What is CSS?</a>)',
        'CSS_ON_YOUR_SOCIAL_NETWORK'					=> 'CSS on your Social Network',
        'CSS_ON_YOUR_PAGE' => 'CSS on your page',
        'ADDING_YOUR_OWN_CSS_NETWORK'					=> 'Adding your own CSS gives you full control over the fonts, colour, spacing, and general style of your network.',
        'ADDING_YOUR_OWN_CSS_PAGE' => 'Adding your own CSS to your page gives you full control over the fonts, color, spacing, and general style of your page.',
        'CSS_STYLES_WILL_OVERRIDE'						=> 'The CSS styles you add here will override any existing CSS styles you may have chosen earlier.',
        'NEED_HELP_FIGURING_OUT_CSS'					=> 'Need help figuring out the name of a specific CSS class on your network? We recommend the "Inspect" feature of the free <a href="%s">Firebug</a> extension (for the Firefox browser).',
        'WANT_TO_LEARN_MORE' => 'Want to learn more? Check out our <a href="%s">Advanced Customization</a> section.',
        'APPLY_XS_THEME'								=> 'Apply %s\'s theme',
        'X_ALREADY_REGISTERED_Y_TO_RESET' => 'There is already a Ning ID registered with the e-mail address %s. Please sign in below with your Ning ID or e-mail address. If you\'ve forgotten your password, <a href="%s">click here to reset your password</a>.',
        'INVITED'										=> 'Invited',
        'REQUESTED_INVITE'								=> 'Requested Invite',
        'BAN_FROM_NETWORK'								=> 'Ban from Network',
        'REMOVE_BAN'									=> 'Remove Ban',
        'CANCEL_INVITATION'								=> 'Cancel Invitation',
        'IGNORE'										=> 'Ignore',
        'PROMOTE_TO_ADMINISTRATOR'						=> 'Promote to Administrator',
        'DEMOTE_FROM_ADMINISTRATOR'						=> 'Demote from Administrator',
        'STATUS'										=> 'Status',
        'DATE_JOINED'									=> 'Date Joined',
        'DATE_INVITED'									=> 'Date Invited',
        'DATE_REQUESTED'								=> 'Date Requested',
        'DATE_APPLIED' => 'Date Applied',
        'NETWORK_CREATOR'								=> 'Network Creator',
        'NETWORK_ADMINISTRATOR' => 'Administrator',
        'ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL'			=> 'Administrators have a similar level of control to the Network Creator.',
        'DOWNLOAD_ALL_MEMBER_DATA' => 'Export All Member Data (.CSV)',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Your Member Data has been exported.  Click <a %s>this link</a> in order to save it to your desktop.',
        'CLICK_GO_TO_START_EXPORT' => 'Click Go to start the export.  If you have a lot of members, the process might take a few minutes.',
        'MEMBER'										=> 'Member',
        'INVITED_BY_X'									=> 'Invited by %s',
        'DONE'											=> 'Done',
        'YOU_HAVE_BEEN_BANNED_FROM_APPNAME'				=> 'You have been banned from %s',
        'MESSAGE_TO_ADMINISTRATOR' => 'Message to the Administrator',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS_IF_YOU_THINK' => 'Sorry, %s, you can not access %s as you have been banned. If you think you\'ve been banned in error, you can contact the administrator.',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS' => 'Sorry, %s, you can not access %s as you have been banned.',
        'SORRY_USERNAME'								=> 'Sorry, %s',
        'PENDING' => 'Pending',
        'ACCEPT' => 'Accept',
        'PENDING_APPROVAL' => 'Content Pending Approval',
        'ACCEPT_MEMBERSHIP' => 'Accept Membership',
        'DECLINE_MEMBERSHIP' => 'Decline Membership',
        'NO_PAGE_YET' => 'No Page Yet',
        'YOUR_MEMBERSHIP_TO_X_IS_PENDING_APPROVAL' => 'Your membership to %s is pending approval from the administrators.',
        'MEMBERSHIP_PENDING_APPROVAL' => 'Membership Pending Approval',
        'YOUR_PROFILE_IS_PENDING_APPROVAL' => 'Your Profile is Pending Approval',
        'YOUR_PROFILE_DETAILS_MUST_BE_APPROVED_ON_X' => 'Your profile details must be approved by the Administrator before you can become a member of %s. You will receive an e-mail once your profile is approved.',
        'CONTINUE_ARROW' => 'Continue →',
        'LARR_BACK_TO_PENDING_MEMBERS' => '← Back to Pending Members',
        'X_IS_AWAITING_APPROVAL_TO_BECOME_MEMBER_OF_Y' => '%s is awaiting approval to become a member of %s.',
        'VIEW_PAGE' => 'View Page',
        'MESSAGE'										=> 'Message',
        'SEND_MESSAGE'									=> 'Send Message',
        'MANAGE_FORUM_CATEGORIES' => 'Manage forum categories',
        'START_DISCUSSIONS' => 'Start discussions',
        'WELCOME_TO_YOUR_NEW_SOCIAL_NETWORK' => 'Welcome to your new social network',
        'NOW_ALL_YOU_NEED_TO_DO_IS_INVITE_YOUR_FRIENDS' => 'Now all you need to do is <a %s>invite your friends</a>!',
        'CONTRIBUTE' => 'Contribute.',
        'CUSTOMIZE_APPEARANCE_BADGES' => '<strong>Customize.</strong> Adjust <a %1$s>network appearance</a> and design <a %2$s>badges and widgets</a>.',
        'CONTROL_MANAGE_PAGE' => '<strong>Control.</strong>  The <a %s>manage</a> page is home to a host of configuration options.',
        'CREATE_GROUPS' => 'Create groups',
        'INVITE_MORE_PEOPLE'							=> 'Invite More People',
        'VIEW_THREAD'									=> 'View Thread',
        'COMMENT_THREAD'								=> 'Comment Thread',
        'COMMENT_BACK'									=> 'Comment Back',
        'HELLO_YOU_NEED_TO_ENABLE_JAVASCRIPT'			=> 'Hello, you need to enable JavaScript to use this network.',
        'PLEASE_CHECK_YOUR_BROWSER_SETTINGS'			=> 'Please check your browser settings or contact your system administrator.',
        'MANAGE_MEMBERS_ADMINS_INVITED' => 'Manage members, Administrators, invited people and banned people.',
        'MANAGE_MEMBERS'								=> 'Manage Members',
        'MANAGE_INVITED_PEOPLE'							=> 'Manage Invited People',
        'NETWORK_SETTINGS'								=> 'Network Settings',
        'PROMOTE_YOUR_NETWORK'							=> 'Promote Your Network',
        'NING_RESOURCES'								=> 'Ning Resources',
        'ADD_PREMIUM_SERVICES'							=> 'Add Premium Services',
        'REQUEST_SOURCE_CODE'							=> 'Request Source Code',
        'REQUEST_A_COPY_OF_THE_SOURCE_CODE'				=> 'Request a copy of the source code running your network.',
        'JOIN_NETWORK_CREATORS'							=> 'Join Network Creators',
        'SEND_MESSAGE_TO_ALL_THIS'						=> 'Send a message to all the members of this network.',
        'CREATE_ANOTHER_NETWORK'						=> 'Create Another Network',
        'HAVE_ANOTHER_GREAT_IDEA'						=> 'Have another great idea for a Social Network?',
        'ALLOW_FACEBOOK_USERS_TO'						=> 'Allow Facebook users to put your network\'s widgets on their profile pages.',
        'BADGES_AND_WIDGETS'							=> 'Badges & Widgets',
        'CUSTOMIZE_WIDGETS_AND_BADGES' => 'Customize the look of your network\'s widgets and badges.',
        'GET_BADGES'									=> 'Get Badges',
        'CUSTOM_TEXT'									=> 'Custom Text',
        'IM_A_MEMBER_OF'								=> 'I\'m a member of:',
        'DONT_DISPLAY_ANY_BRANDING'						=> 'Don\'t Display Any Branding',
        'WATERMARK_OR_LOGO_IMAGE'						=> 'Watermark or Logo Image:',
        'NETWORK_BRANDING_BADGES'						=> 'Network Branding: Badges',
        'NETWORK_BRANDING_WIDGETS'						=> 'Network Branding: Widgets',
        'LOGO_IMAGE'									=> 'Logo Image',
        'SMALL_NETWORK_BADGE'							=> 'Small Network Badge',
        'LARGE_NETWORK_BADGE'							=> 'Large Network Badge',
        'REFRESH'										=> 'Refresh',
        'HTML_EMBED_CODE'								=> 'HTML Embed Code:',
        'CUSTOMIZE' => 'Customize',
        'SHARE_TITLE'									=> 'Share \'%s\'',
        'SHARE_TYPE'									=> 'Share %s',
        'YOUR_MESSAGE_SENT'								=> 'Your message has been sent successfully.',
        'YOUR_MESSAGES_SENT'							=> 'Your messages have been sent successfully.',
        'YOU_CAN_SHARE_TYPE_TWO_WAYS' => 'You can share this %s in two ways&#8230;',
        'CHECK_OUT_THIS_TYPE_TITLE'						=> 'Check out this %s: "%s"',
        'CHECK_OUT_THIS_TYPE'							=> 'Check out this %s',
        'PHOTO_ALBUM'									=> 'photo album',
        'CUSTOMIZE_YOUR_BADGES_AND_WIDGETS' => 'Customize your badges and widgets with your own colour and image choices. Your changes may take up to 4 hours to be reflected on other websites.',
        'BACKGROUND_IMAGE_AND_COLOR'					=> 'Background Image & Colour',
        'USE_THIS_FORM_TO_REPORT_ISSUE_TO_NC' => 'Use this form to report an issue to <a %s>%s</a>, the creator of <a %s>%s</a>.',
        'SORRY_NCS_CANNOT_CHANGE_EMAIL' => 'Sorry, Network Creators cannot change their e-mail addresses through networks they don\'t own.',
        'SORRY_NCS_CANNOT_CHANGE_PASSWORD' => 'Sorry, Network Creators cannot change their passwords through networks they don\'t own.',
        'GO' => 'Go',
        'LARGE_THUMBNAILS'								=> 'Large Thumbnails',
        'SMALL_THUMBNAILS'								=> 'Small Thumbnails',
        'RECENTLY_JOINED'								=> 'Newest',
        'MOST_POPULAR_MEMBERS'							=> 'Most Popular',
        'NO_MEMBERS_TO_DISPLAY'							=> 'You are currently displaying no members',
        'BOX_WILL_NOT_SHOW_MEMBERS'						=> 'This box won\'t show up for other people unless you select at least one row.',
        'DETAIL_VIEW'									=> 'Detail View',
        'TITLES_ONLY'									=> 'Titles Only',
        'RECENTLY_ADDED_POSTS'							=> 'Recently Added',
        'POPULAR_POSTS'									=> 'Most Comments',
        'PROMOTED_POSTS'								=> 'Featured ',
        'BOX_WILL_NOT_SHOW_BLOG_POST'					=> 'This box won\'t show up for other people unless you select at least one post.',
        'KEEP_WINDOW_OPEN_UPLOAD'						=> 'Please keep this browser window open while upload continues.',
        'CANCEL_UPLOAD'									=> 'Cancel Upload',
        'YOU_DO_NOT_HAVE_POSTS'							=> 'You haven\'t written any posts yet.',
        'YOU_DO_NOT_HAVE_COMMENTS'						=> 'You don\'t have any comments to approve.',
        'REQUIRED_FIELD'								=> '(Required field)',
        'BLOG_POST_BY_X'								=> 'Blog Post by %s',
        'HELLO'											=> 'Hello,',
        'ADDED_BY_X'									=> 'Added by %s',
        'CLICK_TO_ADD_A_TITLE'							=> 'click to add a title',
        'DELETE_BLOG_POST'								=> 'Delete Post',
        'DELETE_THIS_BLOG_POST_Q'						=> 'Delete This Blog Post?',
        'ARE_YOU_SURE_DELETE_THIS_BLOG_POST'			=> 'Are you sure you want to delete this blog post? This process may take a few minutes.',
        'SPINNER'										=> 'Spinner',
        'PLEASE_ENTER_SOMETHING_FOR_X'					=> 'Please enter something for: %s',
        'PLEASE_SELECT_OPTION_FOR_X'					=> 'Please select an option for: %s',
        'PLEASE_PROVIDE_VALID_DATE_FOR_X'				=> 'Please provide a valid date for: %s',
        'PLEASE_PROVIDE_DATE_FOR_X'						=> 'Please provide a date for: %s',
        'XS_BLOG_POSTS_FOR_M_Y'							=> '%s\'s Blog Posts for %s %s',
        'FEATURED_BLOG_POSTS_FOR_M_Y'					=> 'Featured Blog Posts for %s %s',
        'BLOG_POSTS_FOR_M_Y'							=> 'Blog Posts for %s %s',
        'FEATURED_BLOG_POSTS'							=> 'Featured Blog Posts',
        'EVERYONES_POSTS'								=> 'Everyone\'s Blog Posts',
        'PUBLISHED_N_OF_N'								=> 'Published %d of %d',
        'DOWNLOAD_X'									=> 'Download %s',
        'UPLOAD_DID_NOT_WORK'							=> 'Sorry, that upload didn\'t work',
        'F_J_Y'											=> 'j F Y',
        'M_J_Y' => 'j M Y',
        'XS_POSTS'										=> '%s\'s Posts',
        'USERNAMES_COMMENTS'							=> '%s\'s Comments',
        'ADD_COMMENT'									=> 'Add Comment',
        'XS_PAGE'										=> '%s\'s Page',
        'XS_BLOG'										=> '%s\'s Blog',
        'XS_FRIENDS'									=> '%s\'s Friends',
        'VIEW_XS_ELLIPSIS'								=> 'View %s\'s…',
        'DRAFT_BRACKETS'								=> '[ Draft ]',
        'FEATURED'										=> 'Featured',
        'MY_POSTS'										=> 'My Posts',
        'MY_POSTS_ONLY'									=> 'My Posts Only',
        'OWNER_POSTS_ONLY'								=> 'Creator Posts Only',
        'JANUARY'										=> 'January',
        'FEBRUARY'										=> 'February',
        'MARCH'											=> 'March',
        'APRIL'											=> 'April',
        'MAY'											=> 'May',
        'JUNE'											=> 'June',
        'JULY'											=> 'July',
        'AUGUST'										=> 'August',
        'SEPTEMBER'										=> 'September',
        'OCTOBER'										=> 'October',
        'NOVEMBER'										=> 'November',
        'DECEMBER'										=> 'December',
        'MY_COMMENTS'									=> 'My Comments',
        'AM'											=> 'AM',
        'PM'											=> 'PM',
        'MY_PAGE'										=> 'My Page',
        'MY_PAGE_TAB_TEXT' => 'My Page',
        'BLOG_POSTS'									=> 'Blog Posts',
        'MY_BLOG'										=> 'My Blog',
        'MONTH'											=> 'Month',
        'DAY' => 'Day',
        'PICK_VALID_DEFAULT_VISIBILITY'					=> 'Please pick a valid choice for default visibility',
        'PICK_VALID_WHO_CAN_COMMENT'					=> 'Please pick a valid choice for who can comment',
        'PICK_VALID_BLOG_COMMENT_MODERATION'			=> 'Please pick a valid choice for blog comment moderation',
        'PICK_VALID_ACTIVITY_NOTIFICATION'				=> 'Please pick a valid choice for activity notification',
        'PICK_VALID_MODERATION_NOTIFICATION'			=> 'Please pick a valid choice for moderation notification',
        'PICK_VALID_APPROVAL_NOTIFICATION'				=> 'Please pick a valid choice for approval notification',
        'PICK_VALID_INVITEE_NOTIFICATION'				=> 'Please pick a valid choice for invitee joining notification',
        'PICK_VALID_NEVER_NOTIFICATION'					=> 'Please pick a valid choice for never receiving notifications',
        'PICK_VALID_FRIEND_REQUEST_NOTIFICATION'		=> 'Please pick a valid choice for friend request notifications',
        'PICK_VALID_NEW_MESSAGE_NOTIFICATION'			=> 'Please pick a valid choice for new message notifications',
        'APPROVE_COMMENT'								=> 'Approve Comment',
        'MANAGE_BLOG'									=> 'Manage Blog',
        'COMMENTS_POSTED_ON_BLOG'						=> 'Comments posted on my blog',
        'COMMENT'										=> 'Comment',
        'COMMENTER'										=> 'Commenter',
        'POST'											=> 'POST',
        'M_J_Y_G_IA'									=> 'j M Y, g:ia',
        'POST_HAS_BEEN_DELETED'							=> 'Post has been deleted',
        'COMMENTS_ARE_CLOSED'							=> 'Comments are closed for this blog post',
        'NO_COMMENTS'									=> 'No Comments',
        'FLAG'											=> 'Flag',
        'POST_TITLE'									=> 'Post Title',
        'DRAFT_PARENTHESES'								=> '(Draft)',
        'SCHEDULED_TO_PUBLISH_ON'						=> 'Scheduled to publish on: %s',
        'EDIT_2'										=> 'edit',
        'NONE'											=> 'None',
        'N_NEW'											=> '%s New',
        'NO_POSTS'										=> 'No Posts',
        'ADD_NEW_BLOG_POST'								=> 'Add a New Blog Post',
        'HAPPY'											=> 'Happy',
        'SAD'											=> 'Sad',
        'COOL'											=> 'Cool',
        'EVIL'											=> 'Evil',
        'MAD'											=> 'Mad',
        'ENVIOUS'										=> 'Envious',
        'ENTRY'											=> 'Entry',
        'WHAT_DATE_FOR_YOUR_POST'						=> 'What date would you like for your post?',
        'NOW'											=> 'Now',
        'CHOOSE_DATE_AND_TIME'							=> 'Choose a date and time (if you choose a future date, your post will publish at that time)',
        'PRIVACY_AND_COMMENTS'							=> 'Privacy & Comments',
        'WHO_CAN_VIEW_POST'								=> 'Who can view this post?',
        'EVERYONE'										=> 'Everyone',
        'ALLOW_COMMENTS'								=> 'Allow comments on this post?',
        'YES'											=> 'Yes',
        'NO'											=> 'No',
        'COMMENT_MODERATION'							=> 'Comment Moderation',
        'YOU_ARE_MODERATING_BLOG_COMMENTS'				=> 'You are currently moderating blog comments.',
        'YOU_ARE_NOT_MODERATING_BLOG_COMMENTS'			=> 'You are not currently moderating blog comments.',
        'SAVE_AS_DRAFT'									=> 'Save as Draft',
        'PREVIEW'										=> 'Preview',
        'PUBLISH_POST'									=> 'Publish Post',
        'THIS_IS_PREVIEW_OF_BLOG_POST'					=> 'This is a preview of what your blog post will look like when you publish it. Click Back to edit the post, or Publish if it\'s ready!',
        'BACK'											=> 'Back',
        'PUBLISH'										=> 'Publish!',
        'BLOG_POST'										=> 'Blog Post',
        'PROFILE'										=> 'Profile',
        'THIS_IS_UNPUBLISHED_DRAFT'						=> 'This is an unpublished draft',
        'WILL_BE_PUBLISHED_ON_X'						=> 'Will be published on %s <small>%s</small>',
        'POSTED_ON_X'									=> 'Posted <strong>%s</strong> <small>%s</small>',
        'POSTED_ON_X_BY'								=> 'Posted <strong>%s</strong> <small>%s</small> by:',
        'ABOUT_THIS_POST'								=> 'About This Post',
        'ABOUT_YOUR_POST'								=> 'About Your Post',
        'ADDED_BY'										=> 'Added by:',
        'JUST_FRIENDS'									=> 'Just Friends',
        'RECENT_POSTS'									=> 'Recent Posts',
        'THERE_ARE_NO_RECENT_POSTS'						=> 'There are no recent posts.',
        'YOUR_COMMENT_HAS_BEEN_ADDED_BUT'				=> 'Your comment has been added but needs to be approved before everyone can see it.',
        'AT_TIME_ON_DATE_USERNAME_SAID'					=> 'At %s on %s, %s said…',
        'X_DOES_NOT_HAVE_ANY_FRIENDS'					=> '%s doesn\'t have any friends on this social network yet.',
        'YOU_DO_NOT_HAVE_ANY_FRIENDS' => 'You don\'t have any friends on this social network yet.',
        'EDIT_PAGE_APPEARANCE'							=> 'Edit Page Appearance',
        'VIEW_PAGE_AS_OTHERS'							=> 'View Page As Others See It',
        'ADD_BLOG_POST'									=> 'Add Blog Post',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED_2'			=> 'Please keep this browser window open while all of %s\'s content is deleted. This process may take a few minutes.',
        'BAN_MEMBER_FROM_NETWORK'						=> 'Ban Member from Network',
        'BAN_USERNAME'									=> 'Ban %s?',
        'BLOCK'											=> 'block',
        'CREATE_NEW_BLOG_POST'							=> 'Create a new blog post!',
        'EDIT_POST'										=> 'Edit Post',
        'EDIT_POST_COLON'								=> 'Edit Post: ',
        'CONTINUE_READING'								=> 'Continue Reading…',
        'POSTED_BY_ME_LINK_ON_X_AT_X'					=> 'Posted by <a %s>me</a> on %s at %s —',
        'POSTED_BY_X_ON_X_AT_X'							=> 'Posted by %s on %s at %s —',
        'POSTED_BY_ME_ON_X_AT_X'						=> 'Posted by me on %s at %s —',
        'ADD'											=> 'Add',
        'SUBSCRIBE'										=> 'Subscribe',
        'VIEW_ARCHIVES'									=> 'View Archives',
        'YOUR_SETTINGS_HAVE_BEEN_SAVED'					=> 'Your settings have been saved.',
        'PLEASE_CORRECT_THE_FOLLOWING'					=> 'Please correct the following:',
        'PRIVACY'										=> 'Privacy',
        'NETWORK_PRIVACY' => 'Network Privacy',
        'THIS_NETWORK_VISIBLE_TO_EVERYONE' => 'This network is <strong>visible to everyone</strong>.',
        'ANYONE_CAN_SIGN_UP_VISITORS_CAN' => 'Anyone can sign up to become a member. Visitors can…',
        'SEE_EVERYTHING' => 'See everything',
        'SEE_JUST_THE_MAIN_PAGE' => 'See just the main page',
        'SEE_JUST_THE_SIGN_UP_PAGE' => 'See just the sign up page',
        'THIS_NETWORK_VISIBLE_MEMBERS_ONLY' => 'This network is <strong>visible to members only</strong>.',
        'WHO_CAN_SIGN_UP' => 'Who can sign up to become a member?',
        'MODERATION' => 'Content Control',
        'APPROVE_MEMBERS_BEFORE_JOIN' => 'Approve new members before they can join',
        'APPROVE_PHOTOS_VIDEOS' => 'Approve photos and videos before they appear',
        'SHOW_LATEST_ACTIVITY_ON_YOUR_NETWORK' => 'Show Latest Activity on Your Network!',
        'PUT_A_CONSTANTLY_UPDATED_STREAM' => 'Put a constantly updated stream of recent activity on your network\'s main page.',
        'CLICK_HERE_TO_ADD_LATEST_ACTIVITY' => 'Click here to add Latest Activity to your network.',
        'THESE_OPTIONS_ARE_DISABLED_ACTIVITY' => 'These options are disabled since you don\'t have Latest Activity on your network.',
        'ACTIVITY' => 'Activity',
        'DISPLAY_PREFERENCES' => 'Display Preferences',
        'NEW_CONTENT' => 'New content',
        'NEW_COMMENTS' => 'New comments',
        'NEW_MEMBERS' => 'New members',
        'MEMBER_UPDATES' => 'Member updates',
        'WHAT_DISPLAYS_LATEST_ACTIVITY' => 'What displays in your network\'s<br />Latest Activity?',
        'LATEST_ACTIVITY' => 'Latest Activity',
        'X_COMMENTED_ON_POST_TITLE' => '%1$s replied to the discussion %2$s',
        'X_LINK_COMMENTED_ON_POST_LINK_TITLE' => '%1$s <a %2$s>replied</a> to the discussion <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_POST_LINK_TITLE' => 'You <a %1$s>replied</a> to the discussion <a %2$s>%3$s</a>',
        'X_COMMENTED_ON_BLOG_POST_TITLE' => '%1$s commented on the blog post %2$s',
        'X_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '%1$s <a %2$s>commented</a> on the blog post <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => 'You <a %1$s>commented</a> on the blog post <a %2$s>%3$s</a>',
        'X_STARTED_A_DISCUSSION_Y' => '%s started a discussion called %s',
        'YOU_STARTED_A_DISCUSSION_Y' => 'You started a discussion called %s',
        'X_ADDED_THE_BLOG_POST_Y' => '%s added the blog post \'%s\'',
        'YOU_ADDED_THE_BLOG_POST_Y' => 'You added the blog post \'%s\'',
        'X_JOINED_THE_GROUP_Y' => '%s joined the group %s',
        'YOU_JOINED_THE_GROUP_X' => 'You joined the group %s',
        'X_JOINED_Y_GROUPS' => '%s joined %s groups',
        'YOU_JOINED_X_GROUPS' => 'You joined %s groups',
        'X_JOINED_APPNAME' => '%s joined %s. <a %s>Leave a Comment</a> for %s.',
        'WELCOME_MEMBER_N_OF_APPNAME' => 'Welcome, %1$s! You are member #%2$s of %3$s.',
        'WELCOME_MEMBER_N_OF_APPNAME_FIND' => 'Welcome, %1$s! You are member #%2$s of %3$s. <a %4$s>Find friends now</a>.',
        'X_IS_MEMBER_N_OF_APPNAME' => '%1$s is member #%2$s of %3$s.',
        'XS_PROFILE_CHANGED' => '%s\'s profile changed',
        'YOUR_PROFILE_CHANGED' => 'Your profile changed',
        'X_LEFT_A_COMMENT_FOR_Y' => '%s left a comment for %s',
        'YOU_LEFT_A_COMMENT_FOR_X' => 'You left a comment for %s',
        'X_LEFT_A_COMMENT_FOR_YOU' => '%s left a comment for you',
        'X_CREATED_A_GROUP_Y' => '%s created a group called %s',
        'YOU_CREATED_A_GROUP_Y' => 'You created a group called %s',
        'X_CREATED_Y_NEW_GROUPS' => '%s created %s new groups',
        'X_STARTED_Y_FORUM_POSTS' => '%s started %s new forum discussions',
        'YOU_STARTED_Y_FORUM_POSTS' => 'You started %s new forum discussions',
        'X_ADDED_Y_BLOG_POSTS' => '%s added %s new blog posts',
        'YOU_ADDED_Y_BLOG_POSTS' => 'You added %s new blog posts',
        'VIEW_XS_BLOG_POSTS' => 'View %s\'s blog posts',
        'VIEW_YOUR_BLOG_POSTS' => 'View your blog posts',
        'APPNAME_HAS_NEW_PROFILE_QUESTIONS' => '%s has <a %s>new profile questions</a>',
        'APPNAME_NOW_HAS_MUSIC' => '%s now has a music player',
        'APPNAME_NOW_HAS_GROUPS' => '%s now has <a %s>groups</a>',
        'APPNAME_NOW_HAS_VIDEO' => '%s now has <a %s>videos</a>',
        'APPNAME_NOW_HAS_FORUM' => '%s now has a <a %s>forum</a>',
        'APPNAME_NOW_HAS_PHOTO' => '%s now has <a %s>photos</a>',
        'DID_YOU_KNOW' => 'Did you know',
        'ANNOUNCEMENT' => 'Announcement',
        'CONGRATULATIONS' => 'Congratulations',
        'YOU_CREATED_APPNAME' => 'You created the %s network.',
        'USER_CREATED_APPNAME' => '%s created the %s network.',
        'ADD_MESSAGES_ACTIVITY_FEED' => 'Add messages and choose what\'s displayed in your network\'s activity feed.',
        'WHICH_OF_YOUR_ACTIONS_DISPLAY_ACTIVITY' => 'Which of your actions should display<br />on Latest Activity?',
        'NEW_CONTENT_I_ADD' => 'New content I add',
        'NEW_COMMENTS_I_ADD' => 'New comments I add',
        'WHEN_I_UPDATE_MY_PROFILE' => 'When I update my profile',
        'THE_LATEST_ACTIVITY_WILL_NEVER' => 'Latest Activity will never display messages you send, pages or members you view, invitations you decline, people you de-friend or decline, or things you delete.',
        'YOU_HAVENT_DONE_ANYTHING_RECENTLY' => 'You have no recent activity. Why not start something?',
        'YOUVE_TURNED_OFF_THE_ACTIVITY_DISPLAY_CLICK' => 'You\'ve turned off the display of your activity. <a %s>Click here to turn it back on.</a>',
        'THE_NETWORK_CREATOR_HAS_TURNED_OFF_THE_ACTIVITY' => 'The network creator has turned off the display of all activity.',
        'NO_ACTIVITY_TO_DISPLAY' => 'You are currently displaying no activity.',
        'BOX_WILL_NOT_SHOW_ACTIVITY' => 'This box won\'t show up for other people unless you select at least one activity item.',
        'NOTHING_IS_HAPPENING_ON_YOUR_NETWORK' => 'There is no recent activity. Why not start something?',
        'MY_ACTIVITY_PREFERENCES' => 'My Activity Preferences',
        'DELETE_ACTIVITY_ITEM' => 'Remove Activity Message',
        'DELETE_THIS_ACTIVITY_MESSAGE_Q' => 'Remove this activity message?',
        'THIS_WILL_PREVENT_ACTIVITY' => 'This will prevent anyone from seeing this activity message',
        'X_HAS_POSTED_THE_MOST_PHOTOS' => '%1$s has posted the most %2$sphotos%3$s',
        'X_IS_THE_MOST_POPULAR_PHOTO' => '%s is the most popular photo to date',
        'X_HAS_POSTED_THE_MOST_VIDEOS' => '%1$s has posted the most %2$svideos%3$s',
        'X_IS_THE_MOST_POPULAR_VIDEO' => '%s is the most popular video to date',
        'X_HAS_POSTED_THE_MOST_MUSIC' => '%s has posted the most songs',
        'X_IS_THE_MOST_POPULAR_MUSIC' => '%s is the most popular song to date',
        'X_IS_THE_MOST_POPULAR_TOPIC' => '%s is the most popular forum post to date',
        'X_IS_THE_MOST_POPULAR_BLOG_POST' => '%s is the most popular blog post to date',
        'XS_LATEST_ACTIVITY_ON_APPNAME' => '%s\'s Latest Activity on %s',
        'LATEST_ACTIVITY_ON_APPNAME' => 'Latest Activity on  %s',
        'ADD_MESSAGE_TO_LATEST_ACTIVITY' => 'Add Message to Latest Activity',
        'ADD_FACTS_ABOUT_THE_NETWORK_ELLIPSIS' => 'Add facts about the network…',
        'ADD_MESSAGE' => 'Add Message',
        'ELLIPSIS_OR_WRITE_YOUR_OWN_MESSAGE' => '…or write your own message',
        'NETWORK' => 'Network',
        'WHO_CAN_VIEW_YOUR_PHOTOS_VIDEOS'				=> 'Who can view my photos, videos,<br/> and blog posts by default?',
        'YOU_CAN_OVERRIDE_WHEN_YOU_ADD'					=> '(You can override this setting for a photo, video, or blog post when you add it.)',
        'MODERATE_COMMENTS_ON_BLOG'						=> 'Do you want to approve comments<br />before they appear on your blog?',
        'YES_LET_ME_APPROVE'							=> 'Yes – Let me approve comments first',
        'NO_PUBLISH_COMMENTS'							=> 'No – Publish comments immediately',
        'WHO_CAN_COMMENT_ON_PHOTOS_VIDEOS'				=> 'Who can comment on my photos,<br/> videos and blog?',
        'SAVE'											=> 'Save',
        'EMAIL' => 'E-mail',
        'YOUR_PRIVACY_IS_IMPORTANT' => 'Your privacy is important to us. If you have any questions on your e-mail notifications, please send us a note via the <a href="http://help.ning.com/?page_id=27">Help Center</a>.',
        'ADD_PHOTOS_AND_VIDEOS_TO_X_BY_SENDING' => 'Add photos and videos to %s by sending them to this e-mail address:',
        'ADD_PHOTOS_AND_VIDEOS_TO_APPNAME_FROM_PHONE' => 'Add photos and videos to %s from your phone by sending them to this e-mail address:',
        'GENERATE_NEW_EMAIL_ADDRESS' => 'Generate New E-mail Address',
        'SUPPORTS_TEXT_EMBEDDED'						=> 'Supports text, embedded videos, photos, and widgets',
        'POST_COMMENT'									=> 'Post Comment',
        'YOU_NEED_TO_BE_MEMBER_COMMENTS'				=> 'You need to be a member of %s to add comments!',
        'MONTHLY_ARCHIVES'								=> 'Monthly Archives',
        'NO_FRIENDS_ON_SITE'							=> 'No friends on this social network yet.',
        'NO_FRIENDS_ON_SITE_THAT_MATCH'					=> 'No friends on this social network that match your search.',
        'MEMBERS_TAB_TEXT' => 'Members',
        'SITE_HAS_NO_MEMBERS'							=> 'This social network doesn\'t have any members yet!',
        'SITE_HAS_NO_MEMBERS_THAT_MATCH'				=> 'This social network doesn\'t have any members that match your search.',
        'NO_COMMENTS_YET'								=> 'No comments yet!',
        'VIEW_ALL_COMMENTS'								=> 'View All Comments',
        'YOU_HAVE_NOT_ADDED_BLOG_POSTS'					=> 'You haven\'t added any blog posts yet!',
        'YOU_CAN_WRITE_ABOUT_ANYTHING'					=> 'You can write about anything you want, talk about and embed your favourite videos, photos and music.',
        'WRITE_YOUR_FIRST_ENTRY'						=> 'Write your first entry!',
        'THERE_ARE_NO_BLOG_POSTS'						=> 'There are currently no blog posts on your social network.',
        'THERE_ARE_NO_FEATURED_X'						=> 'There are no featured %s on your social network.',
        'THERE_ARE_NO_X_THAT_MATCH_SETTINGS'			=> 'There are no %s that match the settings you have selected.',
        'START_FEATURING_X_CLICK_Y'						=> 'Start featuring %s where you see the Feature option. To learn more about featuring, <a %s>click here</a>.',
        'THIS_BOX_WILL_NOT_SHOW_BLOG_POSTS'				=> 'This box won\'t show up for other people until there are blog posts to show. Why not add one?',
        'YOUR_FRIEND'									=> 'Your Friend',
        'REQUEST_SENT'									=> 'Request Sent!',
        'BLOCKED'										=> 'Blocked',
        'BANNED'										=> 'Banned',
        'ADD_YOUR_FIRST_BLOG_POST'						=> 'Add Your First Blog Post',
        'MY_FIRST_BLOG_POST'							=> 'My first blog post!',
        'TELL_THE_PEOPLE_ON' => 'Tell the people on %s more about yourself. Questions marked with a <span %s>lock</span> are private and only visible to Administrators.',
        'CHOOSE_A_THEME_FOR_PAGE'						=> 'Choose a Theme for Your Page',
        'NOW_CUSTOMIZE_PAGE' => 'Now Customize Your Page…',
        'NO_POSTS_TO_DISPLAY'							=> 'No posts to display.',
        'YOU_ARE_DISPLAYING_NO_POSTS'					=> 'You are currently displaying no posts.',
        'DATE_COLON'									=> 'Date:',
        'TIME_COLON'									=> 'Time:',
        'CHANGE'										=> 'Change',
        'UPLOAD_A_PHOTO'								=> 'Upload a Photo',
        'OPTIONS'										=> 'Options',
        'PIXELS'										=> 'Pixels',
        'CANCEL'										=> 'Cancel',
        'UPLOAD_A_FILE'									=> 'Upload a file:',
        'TO_INSERT_A_FILE'								=> 'To insert a file, click the "Browse" or "Choose" button above to locate the file on your computer.',
        'UPLOADING'										=> 'Uploading…',
        'OK'											=> 'OK',
        'POPULAR_MEMBERS'								=> 'Popular Members',
        'INVITE_FRIENDS'								=> 'Invite Friends',
        'VIEW_ALL'										=> 'View All',
        'REMOVE_X'										=> 'Remove %s',
        'ARE_YOU_SURE_BAN_X_AND_CONTENT'				=> 'Are you sure you want to ban %1$s from your social network and delete all content %1$s has added? This process may take a few minutes.',
        'REMOVING_X'									=> 'Removing %s',
        'ARE_YOU_SURE_BAN_MEMBERS_AND_CONTENT'			=> 'Are you sure you want to ban the selected member(s) from your social network and delete all content they have added? This process may take a few minutes.',
        'ARE_YOU_SURE_BAN_MEMBERS' => 'Are you sure you want to ban the selected member(s) from your social network? This process may take a few minutes.',
        'BAN'											=> 'Ban',
        'REMOVING_MEMBERS'								=> 'Removing Members',
        'FEMALE'										=> 'Female',
        'MALE'											=> 'Male',
        'UNITED_STATES'									=> 'United States',
        'AND'											=> 'and',
        'FROM'											=> 'from',
        'GENDER_M'										=> 'Male',
        'GENDER_F'										=> 'Female',
        'XS_PAGE_ON_Y'									=> '%s\'s Page on %s',
        'SEARCH_MEMBERS'								=> 'Search Members',
        'SOMEBODY_COMMENTED_BLOGPOST_ADDED_TO_X'		=> 'somebody commented on a blog post you\'ve added to %s',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE' => 'You have a new comment on your page.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X' => 'You have a new comment on your page on %s.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X_ELLIPSIS' => 'You have a new comment on your page on %s…',
        'A_BLOG_POST'									=> 'a blog post',
        'NOW_THAT_YOU_JOINED_INVITE' => 'Now that you\'ve joined, <strong><a %s>invite your friends</a></strong>!',
        'THIS_IS_YOUR_PROFILE' => 'This is Your Profile:',
        'START_BY_CUSTOMIZING_ITS_APPEARANCE' => 'Start by <a %s>customizing its appearance</a>.',
        'USE_IT_TO_KEEP_A_BLOG_AND_DISPLAY_YOUR_PROFILE_ANSWERS' => 'Use it to <a %1$s>keep a blog</a>, and display <a %2$s>your profile answers</a>.',
        'START_CONTRIBUTING' => 'Start contributing:',
        'UPLOAD_VIDEOS' => 'Upload videos',
        'CONTRIBUTE_TO_DISCUSSIONS' => 'Contribute to discussions',
        'JOIN_GROUPS' => 'Join groups',
        'ADD_A_BLOG_POST'								=> 'Add a blog post',
        'CLICK_TO_ACCEPT_FRIENDS'						=> 'Click here to view your friend requests.',
        'LEAVE_X' => 'Leave %s',
        'LEAVE_X_Q' => 'Leave %s?',
        'ARE_YOU_SURE_LEAVE_X' => 'Are you sure you want to leave %s and delete all your content? This process may take a few minutes.',
        'BACK_TO_USERNAMES_PAGE'						=> '&#8592; Back to %s\'s Page',
        'BACK_TO_MY_PAGE'								=> '&#8592; Back to My Page',
        'COMMENT_WALL'									=> 'Comment Wall',
        'ONLINE' => 'Online',
        'MEMBER_IS_ONLINE' => 'Member is Online',
        'ONLINE_NOW' => 'Online Now',
        'CHOOSE_WHO_CAN_SEE_JOIN_AND_CONTRIBUTE' => 'Choose who can see, join and contribute to your network.',
        'EMAIL_NOTIFICATIONS' => 'E-mail Notifications',
        'WHAT_NETWORK_ACTIVITY_EMAIL_FOR' => 'What network activity do you want to receive an e-mail notification for?',
        'NETWORK_MESSAGES' => 'Network Messages',
        'MEMBER_ACTIVITY' => 'Member Activity',
        'APPROVAL' => 'Approval',
        'FRIEND_REQUESTS' => 'Friend requests',
        'PEOPLE_IVE_INVITED_JOIN' => 'People that I\'ve invited to join this network',
        'MESSAGES_SENT_TO_ME' => 'Messages sent to me',
        'MESSAGES_SENT_TO_GROUPS' => 'Messages sent to groups I belong to',
        'MESSAGES_SENT_TO_NETWORK' => 'Messages sent to the whole network',
        'I_HAVE_NEW_COMMENTS' => 'I have new comments to approve',
        'I_HAVE_NEW_NETWORK_CONTENT' => 'I have new network content to approve',
        'CONTENT_ACTIVITY' => 'Content Activity',
        'ACTIVITY_ON_THINGS_IVE_ADDED' => 'Activity on things I\'ve added',
        'AUTO_FOLLOW_DISCUSSIONS_I_REPLY_TO' => 'Automatically follow discussions I reply to',
        'THINGS_IVE_ADDED_APPROVED' => 'Things I\'ve added have been approved',
        'NOTIFICATIONS' => 'Notifications',
        'EMAIL_ME_WHEN_PEOPLE_REPLY' => 'E-mail me when people reply',
        'DO_NOT_EMAIL_ME_WHEN_PEOPLE_REPLY' => 'Don\'t e-mail me when people reply',
        'TO_STOP_FOLLOWING_THIS_X_CLICK_Y' => 'To stop following this %s, <a %s>click here</a>.',
        'YOU_ARE_NO_LONGER_FOLLOWING_THIS_X' => 'You are no longer following this %s.',
        'NOTIFY' => 'Notify',
        'STOP_NOTIFYING' => 'Stop Notifying',
        'EMAIL_WHEN_NEW_DISCUSSIONS' => 'E-mail me when there are new discussions',
        'DO_NOT_EMAIL_WHEN_NEW_DISCUSSIONS' => 'Don\'t e-mail me when there are new discussions',
        'STOP_FOLLOWING_ALL' => 'Stop following all discussions and blog comments',
        'CHANGE_MY_PHOTO' => 'Change My Photo',
        'COUNTRY_AF'									=> 'Afghanistan',
        'COUNTRY_AX'									=> 'Aland Islands',
        'COUNTRY_AL'									=> 'Albania',
        'COUNTRY_DZ'									=> 'Algeria',
        'COUNTRY_AS'									=> 'American Samoa',
        'COUNTRY_AD'									=> 'Andorra',
        'COUNTRY_AO'									=> 'Angola',
        'COUNTRY_AI'									=> 'Anguilla',
        'COUNTRY_AQ'									=> 'Antarctica',
        'COUNTRY_AG'									=> 'Antigua and Barbuda',
        'COUNTRY_AR'									=> 'Argentina',
        'COUNTRY_AM'									=> 'Armenia',
        'COUNTRY_AW'									=> 'Aruba',
        'COUNTRY_AU'									=> 'Australia',
        'COUNTRY_AT'									=> 'Austria',
        'COUNTRY_AZ'									=> 'Azerbaijan',
        'COUNTRY_BS'									=> 'Bahamas',
        'COUNTRY_BH'									=> 'Bahrain',
        'COUNTRY_BD'									=> 'Bangladesh',
        'COUNTRY_BB'									=> 'Barbados',
        'COUNTRY_BY'									=> 'Belarus',
        'COUNTRY_BE'									=> 'Belgium',
        'COUNTRY_BZ'									=> 'Belize',
        'COUNTRY_BJ'									=> 'Benin',
        'COUNTRY_BM'									=> 'Bermuda',
        'COUNTRY_BT'									=> 'Bhutan',
        'COUNTRY_BO'									=> 'Bolivia',
        'COUNTRY_BA'									=> 'Bosnia and Herzegovina',
        'COUNTRY_BW'									=> 'Botswana',
        'COUNTRY_BV'									=> 'Bouvet Island',
        'COUNTRY_BR'									=> 'Brazil',
        'COUNTRY_IO'									=> 'British Indian Ocean Territory',
        'COUNTRY_BN'									=> 'Brunei Darussalam',
        'COUNTRY_BG'									=> 'Bulgaria',
        'COUNTRY_BF'									=> 'Burkina Faso',
        'COUNTRY_BI'									=> 'Burundi',
        'COUNTRY_KH'									=> 'Cambodia',
        'COUNTRY_CM'									=> 'Cameroon',
        'COUNTRY_CA'									=> 'Canada',
        'COUNTRY_CV'									=> 'Cape Verde',
        'COUNTRY_KY'									=> 'Cayman Islands',
        'COUNTRY_CF'									=> 'Central African Republic',
        'COUNTRY_TD'									=> 'Chad',
        'COUNTRY_CL'									=> 'Chile',
        'COUNTRY_CN'									=> 'China, mainland',
        'COUNTRY_CX'									=> 'Christmas Island',
        'COUNTRY_CC'									=> 'Cocos (Keeling) Islands',
        'COUNTRY_CO'									=> 'Colombia',
        'COUNTRY_KM'									=> 'Comoros',
        'COUNTRY_CG'									=> 'Congo, Republic of the',
        'COUNTRY_CD'									=> 'Congo, The Democratic Republic Of The',
        'COUNTRY_CK'									=> 'Cook Islands',
        'COUNTRY_CR'									=> 'Costa Rica',
        'COUNTRY_CI'									=> 'Cote d Ivoire',
        'COUNTRY_HR'									=> 'Croatia',
        'COUNTRY_CU'									=> 'Cuba',
        'COUNTRY_CY'									=> 'Cyprus',
        'COUNTRY_CZ'									=> 'Czech Republic',
        'COUNTRY_DK'									=> 'Denmark',
        'COUNTRY_DJ'									=> 'Djibouti',
        'COUNTRY_DM'									=> 'Dominica',
        'COUNTRY_DO'									=> 'Dominican Republic',
        'COUNTRY_EC'									=> 'Ecuador',
        'COUNTRY_EG'									=> 'Egypt',
        'COUNTRY_SV'									=> 'El Salvador',
        'COUNTRY_GQ'									=> 'Equatorial Guinea',
        'COUNTRY_ER'									=> 'Eritrea',
        'COUNTRY_EE'									=> 'Estonia',
        'COUNTRY_ET'									=> 'Ethiopia',
        'COUNTRY_EU'									=> 'European Union',
        'COUNTRY_FK'									=> 'Falkland Islands',
        'COUNTRY_FO'									=> 'Faroe Islands',
        'COUNTRY_FJ'									=> 'Fiji',
        'COUNTRY_FI'									=> 'Finland',
        'COUNTRY_FR'									=> 'France',
        'COUNTRY_GF'									=> 'French Guiana',
        'COUNTRY_PF'									=> 'French Polynesia',
        'COUNTRY_TF'									=> 'French Southern Territories',
        'COUNTRY_GA'									=> 'Gabon',
        'COUNTRY_GM'									=> 'Gambia',
        'COUNTRY_GE'									=> 'Georgia',
        'COUNTRY_DE'									=> 'Germany',
        'COUNTRY_GH'									=> 'Ghana',
        'COUNTRY_GI'									=> 'Gibraltar',
        'COUNTRY_GR'									=> 'Greece',
        'COUNTRY_GL'									=> 'Greenland',
        'COUNTRY_GD'									=> 'Grenada',
        'COUNTRY_GP'									=> 'Guadeloupe',
        'COUNTRY_GU'									=> 'Guam',
        'COUNTRY_GT'									=> 'Guatemala',
        'COUNTRY_GN'									=> 'Guinea',
        'COUNTRY_GW'									=> 'Guinea-Bissau',
        'COUNTRY_GY'									=> 'Guyana',
        'COUNTRY_HT'									=> 'Haiti',
        'COUNTRY_HM'									=> 'Heard Island and McDonald Islands',
        'COUNTRY_HN'									=> 'Honduras',
        'COUNTRY_HK'									=> 'Hong Kong',
        'COUNTRY_HU'									=> 'Hungary',
        'COUNTRY_IS'									=> 'Iceland',
        'COUNTRY_IN'									=> 'India',
        'COUNTRY_ID'									=> 'Indonesia',
        'COUNTRY_IR'									=> 'Iran, Islamic Republic of',
        'COUNTRY_IQ'									=> 'Iraq',
        'COUNTRY_IE'									=> 'Ireland',
        'COUNTRY_IL'									=> 'Israel',
        'COUNTRY_IT'									=> 'Italy',
        'COUNTRY_JM'									=> 'Jamaica',
        'COUNTRY_JP'									=> 'Japan',
        'COUNTRY_JO'									=> 'Jordan',
        'COUNTRY_KZ'									=> 'Kazakhstan',
        'COUNTRY_KE'									=> 'Kenya',
        'COUNTRY_KI'									=> 'Kiribati',
        'COUNTRY_KP'									=> 'Korea, Democratic Peoples Republic of',
        'COUNTRY_KR'									=> 'Korea, Republic of',
        'COUNTRY_KW'									=> 'Kuwait',
        'COUNTRY_KG'									=> 'Kyrgyzstan',
        'COUNTRY_LA'									=> 'Lao Peoples Democratic Republic',
        'COUNTRY_LV'									=> 'Latvia',
        'COUNTRY_LB'									=> 'Lebanon',
        'COUNTRY_LS'									=> 'Lesotho',
        'COUNTRY_LR'									=> 'Liberia',
        'COUNTRY_LY'									=> 'Libyan Arab Jamahiriya',
        'COUNTRY_LI'									=> 'Liechtenstein',
        'COUNTRY_LT'									=> 'Lithuania',
        'COUNTRY_LU'									=> 'Luxembourg',
        'COUNTRY_MO'									=> 'Macao',
        'COUNTRY_MK'									=> 'Macedonia, The Former Yugoslav Republic of',
        'COUNTRY_MG'									=> 'Madagascar',
        'COUNTRY_MW'									=> 'Malawi',
        'COUNTRY_MY'									=> 'Malaysia',
        'COUNTRY_MV'									=> 'Maldives',
        'COUNTRY_ML'									=> 'Mali',
        'COUNTRY_MT'									=> 'Malta',
        'COUNTRY_MH'									=> 'Marshall Islands',
        'COUNTRY_MQ'									=> 'Martinique',
        'COUNTRY_MR'									=> 'Mauritania',
        'COUNTRY_MU'									=> 'Mauritius',
        'COUNTRY_YT'									=> 'Mayotte',
        'COUNTRY_MX'									=> 'Mexico',
        'COUNTRY_FM'									=> 'Micronesia, Federated States of',
        'COUNTRY_MD'									=> 'Moldova, Republic of',
        'COUNTRY_MC'									=> 'Monaco',
        'COUNTRY_MN'									=> 'Mongolia',
        'COUNTRY_MS'									=> 'Montserrat',
        'COUNTRY_MA'									=> 'Morocco',
        'COUNTRY_MZ'									=> 'Mozambique',
        'COUNTRY_MM'									=> 'Myanmar',
        'COUNTRY_NA'									=> 'Namibia',
        'COUNTRY_NR'									=> 'Nauru',
        'COUNTRY_NP'									=> 'Nepal',
        'COUNTRY_NL'									=> 'Netherlands',
        'COUNTRY_AN'									=> 'Netherlands Antilles',
        'COUNTRY_NC'									=> 'New Caledonia',
        'COUNTRY_NZ'									=> 'New Zealand',
        'COUNTRY_NI'									=> 'Nicaragua',
        'COUNTRY_NE'									=> 'Niger',
        'COUNTRY_NG'									=> 'Nigeria',
        'COUNTRY_NU'									=> 'Niue',
        'COUNTRY_NF'									=> 'Norfolk Island',
        'COUNTRY_MP'									=> 'Northern Mariana Islands',
        'COUNTRY_NO'									=> 'Norway',
        'COUNTRY_OM'									=> 'Oman',
        'COUNTRY_PK'									=> 'Pakistan',
        'COUNTRY_PW'									=> 'Palau',
        'COUNTRY_PS'									=> 'Palestinian Territory, Occupied',
        'COUNTRY_PA'									=> 'Panama',
        'COUNTRY_PG'									=> 'Papua New Guinea',
        'COUNTRY_PY'									=> 'Paraguay',
        'COUNTRY_PE'									=> 'Peru',
        'COUNTRY_PH'									=> 'Philippines',
        'COUNTRY_PN'									=> 'Pitcairn',
        'COUNTRY_PL'									=> 'Poland',
        'COUNTRY_PT'									=> 'Portugal',
        'COUNTRY_PR'									=> 'Puerto Rico',
        'COUNTRY_QA'									=> 'Qatar',
        'COUNTRY_RE'									=> 'Reunion',
        'COUNTRY_RO'									=> 'Romania',
        'COUNTRY_RU'									=> 'Russian Federation',
        'COUNTRY_RW'									=> 'Rwanda',
        'COUNTRY_SH'									=> 'Saint Helena',
        'COUNTRY_KN'									=> 'Saint Kitts and Nevis',
        'COUNTRY_LC'									=> 'Saint Lucia',
        'COUNTRY_PM'									=> 'Saint-Pierre and Miquelon',
        'COUNTRY_VC'									=> 'Saint Vincent and the Grenadines',
        'COUNTRY_WS'									=> 'Samoa',
        'COUNTRY_SM'									=> 'San Marino',
        'COUNTRY_ST'									=> 'Sao Tome and Principe',
        'COUNTRY_SA'									=> 'Saudi Arabia',
        'COUNTRY_SN'									=> 'Senegal',
        'COUNTRY_CS'									=> 'Serbia and Montenegro',
        'COUNTRY_SC'									=> 'Seychelles',
        'COUNTRY_SL'									=> 'Sierra Leone',
        'COUNTRY_SG'									=> 'Singapore',
        'COUNTRY_SK'									=> 'Slovakia',
        'COUNTRY_SI'									=> 'Slovenia',
        'COUNTRY_SB'									=> 'Solomon Islands',
        'COUNTRY_SO'									=> 'Somalia',
        'COUNTRY_ZA'									=> 'South Africa',
        'COUNTRY_GS'									=> 'South Georgia and the South Sandwich Islands',
        'COUNTRY_ES'									=> 'Spain',
        'COUNTRY_LK'									=> 'Sri Lanka',
        'COUNTRY_SD'									=> 'Sudan',
        'COUNTRY_SR'									=> 'Suriname',
        'COUNTRY_SJ'									=> 'Svalbard and Jan Mayen',
        'COUNTRY_SZ'									=> 'Swaziland',
        'COUNTRY_SE'									=> 'Sweden',
        'COUNTRY_CH'									=> 'Switzerland',
        'COUNTRY_SY'									=> 'Syrian Arab Republic',
        'COUNTRY_TW'									=> 'Taiwan',
        'COUNTRY_TJ'									=> 'Tajikistan',
        'COUNTRY_TZ'									=> 'Tanzania, United Republic Of',
        'COUNTRY_TH'									=> 'Thailand',
        'COUNTRY_TL'									=> 'Timor-Leste',
        'COUNTRY_TG'									=> 'Togo',
        'COUNTRY_TK'									=> 'Tokelau',
        'COUNTRY_TO'									=> 'Tonga',
        'COUNTRY_TT'									=> 'Trinidad and Tobago',
        'COUNTRY_TN'									=> 'Tunisia',
        'COUNTRY_TR'									=> 'Turkey',
        'COUNTRY_TM'									=> 'Turkmenistan',
        'COUNTRY_TC'									=> 'Turks and Caicos Islands',
        'COUNTRY_TV'									=> 'Tuvalu',
        'COUNTRY_UG'									=> 'Uganda',
        'COUNTRY_UA'									=> 'Ukraine',
        'COUNTRY_AE'									=> 'United Arab Emirates',
        'COUNTRY_GB'									=> 'United Kingdom',
        'COUNTRY_US'									=> 'United States',
        'COUNTRY_UM'									=> 'United States Minor Outlying Islands',
        'COUNTRY_UY'									=> 'Uruguay',
        'COUNTRY_UZ'									=> 'Uzbekistan',
        'COUNTRY_VU'									=> 'Vanuatu',
        'COUNTRY_VA'									=> 'Vatican City State',
        'COUNTRY_VE'									=> 'Venezuela',
        'COUNTRY_VN' => 'Vietnam',
        'COUNTRY_VG'									=> 'Virgin Islands, British',
        'COUNTRY_VI'									=> 'Virgin Islands, U.S.',
        'COUNTRY_WF'									=> 'Wallis and Futuna',
        'COUNTRY_EH'									=> 'Western Sahara',
        'COUNTRY_YE'									=> 'Yemen',
        'COUNTRY_ZM'									=> 'Zambia',
        'COUNTRY_ZW'									=> 'Zimbabwe',
        'ERROR_LOG'										=> 'Error Log',
        'CANNOT_READ_ERROR_LOG'							=> 'Can\'t read error log',
        'CANNOT_OPEN_ERROR_LOG'							=> 'Can\'t open error log',
        'CANNOT_SCAN_ERROR_LOG'							=> 'Can\'t scan error log',
        'MODELS_RESET' => 'Models reset:',
        'NO_MODELS_RESET' => 'No models reset.',
        'NO_FEED_TO_DISPLAY'							=> 'You are currently displaying no items.',
        'BOX_WILL_NOT_SHOW_FEED'						=> 'This box won\'t show up for other people unless you select at least one item.',
        'CLICK_EDIT_TO_SPECIFY_FEED'					=> 'Please click Edit to specify the RSS feed for this box.',
        'PROBLEM_OCCURRED_RETRIEVING_FEED'				=> 'A problem occurred retrieving this RSS feed.',
        'MORE_ELLIPSIS'									=> 'More…',
        'RSS'											=> 'RSS',
        'WE_ARE_SORRY_SITE_HAS_ISSUE'					=> 'We\'re sorry, this site has an issue.',
        'PLEASE_TRY_REFRESHING'							=> 'Please try refreshing the page in 30 seconds, or <a %s>let us know</a> if you get this message again.',
        'NO_DISCUSSIONS_TAGGED_X'						=> 'There aren\'t any discussions tagged "%1$s".',
        'PAGE_TITLE_COLON'								=> 'Page Title:',
        'PAGE_CONTENT'									=> 'Content:',
        'CREATE_PAGE'									=> 'Create Page',
        'CREATE_NEW_PAGE'								=> 'Create a New Page',
        'YOUR_COMMENT'									=> 'Your Comment',
        'ADD_YOUR_COMMENT'								=> 'Add Your Comment',
        'DELETE_PAGE'									=> 'Delete this Page',
        'DELETE_THIS_PAGE_Q'							=> 'Delete This Page?',
        'ARE_YOU_SURE_DELETE_THIS_PAGE'					=> 'Are you sure you want to delete this page (including all comments)? This process may take a few minutes.',
        'SEARCH_PAGES'									=> 'Search Pages',
        'ALL_PAGES'										=> 'All Pages',
        'SUBSCRIBE_TO_PAGES'							=> 'Subscribe to these pages',
        'NOBODY_HAS_ADDED_PAGES'						=> 'Nobody has added any pages yet!',
        'ADD_PAGES_CALL_TO_ACTION'						=> 'Create a Page to get started.',
        'CREATE_A_PAGE'									=> 'Create a Page',
        'PLEASE_ENTER_PAGE_CONTENT'						=> 'Please enter the page content',
        'SEARCH_RESULTS_FOR_X'							=> 'Search Results for <em>%s</em>',
        'EDIT_YOUR_PAGE'								=> 'Edit Your Page',
        'UPDATE_PAGE'									=> 'Update Page',
        'CLOSE_DISCUSSION' => 'Close Discussion',
        'REOPEN_DISCUSSION' => 'Re-open Discussion',
        'CLOSING_DISCUSSION_PREVENTS' => 'Closing a discussion prevents any further replies',
        'NO_DISCUSSION_TO_DISPLAY'						=> 'You are currently displaying no discussions.',
        'BOX_WILL_NOT_SHOW_DISCUSSION'					=> 'This box won\'t show up for other people unless you select at least one discussion.',
        'NEWEST_DISCUSSIONS'							=> 'Newest Discussions',
        'LATEST_REPLIES'								=> 'Latest Replies',
        'REPLIES_CLOSED_FOR_DISCUSSION' => 'Replies are closed for this discussion.',
        'SORRY_DISCUSSION_CLOSED' => 'We\'re sorry, but this discussion has just been closed to further replies.',
        'MOST_REPLIES'									=> 'Most Replies',
        'OWNER_DISCUSSIONS_ONLY'						=> 'Creator Discussions Only',
        'MY_DISCUSSIONS_ONLY'							=> 'My Discussions Only',
        'DISCUSSION_DELETED'							=> 'Discussion Deleted',
        'DISCUSSION_HAS_BEEN_DELETED'					=> 'This discussion has been deleted.',
        'REPLY_DELETED'									=> 'Reply Deleted',
        'REPLY_HAS_BEEN_DELETED'						=> 'This reply has been deleted. <a %s>Return to the discussion.</a>',
        'VIEW_ALL_DISCUSSIONS'							=> 'View All Discussions',
        'ADD_CATEGORIES'								=> 'Add Categories',
        'CATEGORY'										=> 'Category:',
        'NO_DISCUSSIONS_IN_CATEGORY'					=> 'There are no discussions in this category yet.',
        'ADD_MANAGE_CATEGORIES'							=> 'Add/Manage Categories',
        'VIEW_ALL_N_CATEGORIES' => 'View All %s Categories',
        'UNTITLED_CATEGORY'								=> 'Untitled Category',
        'SAMPLE_TITLE'									=> 'Sample Title',
        'UNCATEGORIZED' => 'Uncategorized',
        'EXISTING_DISCUSSIONS'							=> 'Existing discussions that have not been assigned a category.',
        'YOU_HAVE_NOT_ADDED_CATEGORIES'					=> 'There aren\'t any categories at the moment. Add a category to get started!',
        'ADD_A_CATEGORY'								=> 'Add a Category',
        'ADD_ANOTHER_CATEGORY'							=> 'Add Another Category',
        'MANAGE_CATEGORIES'								=> 'Manage Categories',
        'CATEGORY_TITLE'								=> 'Category Title',
        'ALLOW_MEMBERS_TO_START_DISCUSSIONS'			=> 'Allow members to start discussions in this category',
        'ONLY_I_CAN_START_DISCUSSIONS'					=> 'Only I can start discussions in this category',
        'ALLOW_MEMBERS_TO_REPLY'						=> 'Allow members to reply',
        'SUGGESTIONS'									=> 'Suggestions:',
        'TRY_DIFFERENT_KEYWORDS'						=> 'Try different or more general keywords',
        'VIEW_DISCUSSIONS_OR_START_DISCUSSION'			=> '<a %s>View All Discussions</a> or <a %s>Start a New Discussion</a>',
        'MAKE_SURE_WORDS_SPELLED'						=> 'Make sure all words are spelled correctly',
        'REPLY_WAS_DELETED'								=> 'This reply was deleted',
        'TAGS_X'										=> '<strong>Tags:</strong> %s',
        'SEND_PRIVATE_MESSAGE'							=> 'Send Private Message',
        'PERMALINK_TO_REPLY'							=> 'Permalink to this Reply',
        'PERMALINK'										=> 'Permalink',
        'WE_COULD_NOT_FIND_ANY_DISCUSSIONS'				=> 'Our apologies - we couldn\'t find any discussions matching your search.',
        'DISCUSSIONS_MATCHING_X'						=> 'Discussions matching <em>\'%s\'</em>',
        'SEARCH_DISCUSSIONS'							=> 'Search Discussions',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS_2'				=> 'You haven\'t added any discussions yet!',
        'ADD_DISCUSSIONS_AND_SHARE'						=> 'Add discussions and share them with your friends, family or the rest of the world!',
        'DISCUSSION'									=> 'Discussion',
        'DISCUSSIONS'									=> 'Discussions',
        'KEEP_PAGE_OPEN_FORUM'							=> 'Please keep this page open so we can finish uploading your files to the forum.',
        'MEANWHILE_FEEL_FREE_FORUM'						=> 'Meanwhile, feel free to <a %s>open a new browser window</a> and continue using %s.',
        'START_A_NEW_DISCUSSION'						=> 'Start a New Discussion',
        'DISCUSSION_TITLE'								=> 'Discussion Title:',
        'FIRST_POST'									=> 'Post:',
        'UPLOAD_FILES'									=> 'Attach File(s):',
        'START_DISCUSSION'								=> 'Start Discussion',
        'EDIT_DISCUSSION'								=> 'Edit Discussion',
        'START_A_DISCUSSION'							=> 'Start a Discussion',
        'ALL_DISCUSSIONS'								=> 'Forum Home',
        'CONTRIBUTORS'									=> 'Contributors',
        'MY_DISCUSSIONS'								=> 'My Discussions',
        'READ_MORE'										=> 'Read More',
        'STARTED_T_BY'									=> 'Started <strong>%s</strong> by:',
        'ADDED_BY_X_T'									=> 'Added by %s %s',
        'STARTED_BY_X_T'								=> 'Started by %s %s',
        'REPLY_BY_X_T'									=> 'Reply by <strong>%s</strong> %s',
        'STARTED_BY_X_LAST_REPLY_LINK_BY_X_T'			=> 'Started by %s. Last <a %s>reply</a> by %s %s.',
        'STARTED_DISCUSSION_LAST_REPLY_LINK_BY_X_T'		=> '<strong>Started this discussion.</strong> Last <a %s>reply</a> by %s %s.',
        'STARTED_DISCUSSION_T'							=> '<strong>Started this discussion</strong> %s',
        'ADDED_REPLY_T'									=> '<strong>Added a reply</strong> %s',
        'ADDED_POST_T'									=> '<strong>Added a post</strong> %s',
        'STARTED_BY_X_ON'								=> 'Started by %s on %s',
        'STARTED_DISCUSSION_ON'							=> '<strong>Started this discussion</strong> %s',
        'STARTED_ON'									=> '<strong>Started</strong> %s',
        'ADDED_REPLY_ON'								=> '<strong>Added a reply</strong> %s',
        'ADDED_POST_ON'									=> '<strong>Added a post</strong> %s',
        'XS_DISCUSSIONS'								=> '%s\'s discussions',
        'XS_DISCUSSIONS_LOWERCASE'						=> '%s\'s discussions',
        'VIEW_XS_DISCUSSIONS' => 'View %s\'s discussions',
        'VIEW_YOUR_DISCUSSIONS' => 'View your discussions',
        'TAGGED_X'										=> 'Tagged: %s',
        'SUBSCRIBE_TO_DISCUSSIONS'						=> 'Subscribe to these discussions',
        'SUBSCRIBE_TO_DISCUSSION'						=> 'Subscribe to this discussion',
        'SUBSCRIBE_TO_XS_DISCUSSIONS'					=> 'Subscribe to %s\'s discussions',
        'ALL_DISCUSSIONS_TAGGED_X'						=> 'All Discussions Tagged <em>\'%s\'</em>',
        'SUBSCRIBE_TO_DISCUSSIONS_TAGGED_X'				=> 'Subscribe to Discussions Tagged \'%s\'',
        'N_KB'											=> '%s KB',
        'N_MB'											=> '%s MB',
        'UPLOADING_FILES'								=> 'Uploading Files',
        'ATTACHMENTS'									=> 'Attachments',
        'YOUR_POST'										=> 'Your Post:',
        'YOUR_REPLY'									=> 'Your Reply:',
        'WOULD_YOU_LIKE_TO_UPLOAD_FILES'				=> 'Would You Like to Upload Files?',
        'ADD_YOUR_REPLY'								=> 'Add Your Reply',
        'REPLIES_TO_THIS_DISCUSSION'					=> 'Replies to This Discussion',
        'POSTED_BY_X_ON'								=> 'Posted by %s %s',
        'PLEASE_ENTER_TITLE'							=> 'Please enter a title for the discussion',
        'PLEASE_ENTER_FIRST_POST'						=> 'Please write the first post for the discussion.',
        'REPLY_TO_THIS'									=> 'Reply to This',
        'DELETE_ATTACHMENT'								=> 'Delete Attachment',
        'DELETE_ATTACHMENT_Q'							=> 'Delete this attachment?',
        'DELETE_REPLY'									=> 'Delete Reply',
        'DELETE_THIS_DISCUSSION_Q'						=> 'Delete This Discussion?',
        'ARE_YOU_SURE_DELETE_THIS_DISCUSSION'			=> 'Are you sure you want to delete this discussion (including all replies)? This process may take a few minutes.',
        'DELETE_DISCUSSION'								=> 'Delete Discussion',
        'NOBODY_HAS_ADDED_DISCUSSIONS'					=> 'Nobody has added any discussions yet.',
        'NOBODY_HAS_ADDED_DISCUSSIONS_ADD'				=> 'Nobody has added any discussions yet! Add a discussion to get started.',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS'				=> 'You haven\'t added any discussions yet. Add a discussion to get started!',
        'YOU_HAVE_NOT_STARTED_DISCUSSIONS' 				=> 'You haven\'t started any discussions yet.',
        'YOU_HAVE_NOT_ADDED_TO_DISCUSSIONS' 			=> 'You haven\'t added to any discussions yet.',
        'X_HAS_NOT_ADDED_DISCUSSIONS'					=> '%s hasn\'t added any discussions yet.',
        'X_HAS_NOT_STARTED_DISCUSSIONS'					=> '%s hasn\'t started any discussions yet.',
        'X_HAS_NOT_ADDED_TO_DISCUSSIONS'				=> '%s hasn\'t added to any discussions yet.',
        'VIEW_DISCUSSIONS'								=> 'View Discussions',
        'VIEW_ALL_PEOPLE_ON_X'							=> 'View All People on %s',
        'THERE_ARE_NO_DISCUSSIONS'						=> 'There are currently no discussions on your network.',
        'GROUP_HAS_NO_DISCUSSIONS'						=> 'This group does not have any discussions yet.',
        'VIEW_DISCUSSIONS_IN_GROUP_FORUM'				=> 'View discussions in the <a %s>%s forum</a>!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT_ADD'			=> 'There aren\'t any discussions tagged "%1$s". Check out <a %2$s>photos tagged "%1$s"</a> or <a %3$s>videos tagged "%1$s"</a>. Or add and tag your own discussions!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT'				=> 'There aren\'t any discussions tagged "%1$s". Check out <a %2$s>photos tagged "%1$s"</a> or <a %3$s>videos tagged "%1$s"</a>.',
        'THIS_BOX_WILL_NOT_SHOW_DISCUSSIONS'			=> 'This box won\'t show up for other people until there are discussions to show. Why not start one?',
        'DISCUSSIONS_I_STARTED'							=> 'Discussions I Started',
        'DISCUSSIONS_X_STARTED'							=> 'Discussions %s Started',
        'DISCUSSIONS_I_REPLIED_TO'						=> 'Discussions I Replied To',
        'DISCUSSIONS_X_REPLIED_TO'						=> 'Discussions %s Replied To',
        'PLEASE_WRITE_SOMETHING_FOR_POST'				=> 'Please write something for your post.',
        'PLEASE_WRITE_SOMETHING_FOR_REPLY'				=> 'Please write something for your reply.',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION_X'			=> 'There is a new comment on your discussion "%s" on %s',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION' => 'There is a new comment on one of your discussions on %s',
        'SOMEBODY_COMMENTED_DISCUSSION_ADDED_TO_X'		=> 'somebody commented on a discussion you started on %s',
        'ABOUT_YOUR_DISCUSSION'							=> 'About Your Discussion',
        'ABOUT_THIS_DISCUSSION'							=> 'About This Discussion',
        'USER_REPLIED_TO_A_DISCUSSION_ON_Y' => '%s replied to a discussion on %s',
        'USER_REPLIED_TO_DISCUSSION_TITLE_ON_APPNAME' => '%s replied to the discussion "%s" on %s',
        'PROBLEM_WITH_ICON'								=> 'There was a problem with the icon file',
        'GROUP_ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL'		=> 'Group Administrators have a similar level of control to the Group Creator.',
        'CREATE_NEW_GROUP'								=> 'Create New Group',
        'CREATE_A_NEW_GROUP'							=> 'Create a New Group',
        'CREATE_A_GROUP'								=> 'Create a Group',
        'VIEW_GROUPS' => 'View Groups',
        'CREATE_GROUP'									=> 'Create Group',
        'PLEASE_ENTER_NAME_FOR_GROUP'					=> 'Please choose a name for your group.',
        'PLEASE_ENTER_URL_FOR_GROUP'					=> 'Please choose a web address for your group.',
        'URL_CAN_CONTAIN_ONLY_LETTERS'					=> 'The web address can contain only letters and numbers (no spaces).',
        'NAME_TAKEN' => 'Sorry - that name has already been taken. Please choose another name.',
        'URL_TAKEN' => 'Sorry - that web address has already been taken. Please choose another web address.',
        'GROUP_INFORMATION'								=> 'Group Information',
        'EXTERNAL_WEBSITE'								=> 'External Website',
        'DO_YOU_HAVE_EXISTING_WEBSITE'					=> 'Do you have an existing group website somewhere else?',
        'URL'											=> 'URL',
        'GROUPS'										=> 'Groups',
        'SEARCH_GROUPS'									=> 'Search Groups',
        'NOBODY_HAS_CREATED_GROUPS'						=> 'Nobody has created any groups yet.',
        'NOBODY_HAS_CREATED_GROUPS_ADD'					=> 'Nobody has created any groups yet! Create a group to get started.',
        'MY_GROUPS'										=> 'My Groups',
        'FEATURED_GROUPS'								=> 'Featured Groups',
        'YOU_CAN_CREATE_GROUP'							=> 'You can <a %s>create a new group</a> on %s!',
        'GROUP_FORUM'									=> '%s Forum',
        'USER_CREATED_GROUP'							=> '%s created this group on %s.',
        'GROUP_MEMBERS_COUNT'							=> '%s Members (%d)',
        'WE_ARE_SORRY_NOT_ALLOWED_JOIN_GROUP'			=> 'We\'re sorry, you are not allowed to join this group.',
        'JOIN_GROUP_NOW'								=> 'Join %s Now!',
        'USER_HAS_INVITED_YOU_TO_JOIN_GROUP'			=> '%s has invited you to join %s',
        'DECLINE'										=> 'Decline',
        'WELCOME_TO_GROUP'								=> 'Welcome to %s',
        'YOU_CAN_PARTICIPATE_IN_GROUP'					=> 'You can now participate in the %s forum.',
        'SEND_MESSAGE_TO_GROUP'							=> 'Send Message to Group',
        'LEAVE_THIS_GROUP'								=> 'Leave Group',
        'EDIT_GROUP_INFO'								=> 'Edit This Group\'s Info',
        'EDIT_GROUP_INFORMATION'						=> 'Edit Group Information',
        'MANAGE_GROUP_MEMBERS'							=> 'Manage Group Members',
        'GROUP_HAS_NO_MEMBERS'							=> 'This group doesn\'t have any members yet!',
        'GROUP_HAS_NO_MEMBERS_THAT_MATCH'				=> 'This group doesn\'t have any members that match your search.',
        'USERS_GROUPS'									=> '%s\'s Groups',
        'YOU_HAVE_NOT_CREATED_GROUPS' 					=> 'You haven\'t created any groups yet.',
        'USER_HAS_NOT_CREATED_GROUPS'					=> '%s hasn\'t created any groups yet.',
        'THERE_ARE_NO_FEATURED_GROUPS'					=> 'There are no featured groups on your social network.',
        'START_FEATURING_GROUPS'						=> 'Start featuring groups where you see the Feature option. To learn more about featuring, <a %s>click here</a>.',
        'NO_GROUPS_TO_DISPLAY'							=> 'You are currently displaying no groups.',
        'BOX_WILL_NOT_SHOW_GROUPS'						=> 'This box won\'t show up for other people unless you select at least one group.',
        'YOU_HAVE_NOT_CREATED_GROUPS_2'					=> 'You haven\'t created any groups yet!',
        'CREATE_GROUPS_AND_SHARE'						=> 'Create groups and share them with your friends, family or the rest of the world!',
        'THERE_ARE_NO_GROUPS'							=> 'There are currently no groups on your network.',
        'THIS_BOX_WILL_NOT_SHOW_GROUPS'					=> 'This box won\'t show up for other people until there are groups to show. Why not create one?',
        'GROUPS_MATCHING_SEARCH_TERM'					=> 'Groups matching <em>\'%s\'</em>',
        'WE_COULD_NOT_FIND_ANY_GROUPS'					=> 'Our apologies - we couldn\'t find any groups matching your search.',
        'VIEW_GROUPS_OR_CREATE_GROUP'					=> '<a %s>View All Groups</a> or <a %s>Create a New Group</a>',
        'VIEW_ALL_GROUPS'								=> 'View All Groups',
        'DELETE_GROUP'									=> 'Delete Group',
        'DELETE_GROUP_Q'								=> 'Are you sure you wish to delete this group?',
        'GROUP_INVITATIONS'								=> 'Group Invitations',
        'YOU_HAVE_BEEN_INVITED_TO_JOIN'					=> 'You\'ve been invited to join:',
        'VISIT'											=> 'Visit',
        'WHO_CAN_JOIN_GROUP'							=> 'Who can join this group?',
        'PRIVACY_CANNOT_BE_CHANGED'						=> 'Privacy can\'t be changed after the group is created.',
        'ONLY_INVITED_PEOPLE'							=> 'Only Invited People',
        'ALLOW_PEOPLE_TO_REQUEST'						=> 'Allow people to request an invitation',
        'ANYONE_CAN_JOIN_GROUP'							=> 'Anyone can join this group',
        'ONLY_INVITED_PEOPLE_CAN_JOIN_GROUP'			=> 'Only invited people can join this group',
        'WHY_NOT_CREATE_GROUP'							=> 'Why not <a %s>create your own group</a>?',
        'GROUP_IS_ACCEPTING_MEMBERS'					=> '%s is accepting new members. If you would like to join, <a %s>click here to request an invitation</a> from the Group Creator.',
        'PLEASE_ENTER_NAME'								=> 'Please enter your name',
        'PLEASE_ENTER_EMAIL_ADDRESS' => 'Please enter your e-mail address',
        'PLEASE_ENTER_PAGE_ADDRESS' => 'Please enter a new page address.',
        'PLEASE_ENTER_PASSWORD' => 'Please enter your password.',
        'CREATE_ACCOUNT_OR_SIGN_IN' => '<a %s>Click here to create an account</a> or try to sign in again below.',
        'CREATE_ACCOUNT_OR_JOIN' => '<a %s>Click here to create an account</a> or try to join with your Ning ID again below.',
        'CHOOSE_SHORTER_PASSWORD' => 'Please choose a shorter password.',
        'CHOOSE_SHORTER_NAME' => 'Please choose a shorter name.',
        'ENTER_SHORTER_CITY_NAME' => 'Please enter a shorter city name.',
        'PLEASE_ENTER_PASSWORD_AGAIN' => 'Please enter your password again in the "Retype Password" box.',
        'PLEASE_ENTER_CURRENT_PASSWORD' => 'Please enter your current password.',
        'PLEASE_ENTER_NEW_PASSWORD' => 'Please enter your new password.',
        'PLEASE_ENTER_NEW_PASSWORD_AGAIN' => 'Please enter your new password again in the "Confirm Password" box.',
        'CURRENT_PASSWORD' => 'Current Password',
        'PASSWORDS_DO_NOT_MATCH' => 'The two passwords do not match.',
        'NEW_AND_CONFIRMATION_PASSWORDS' => 'The new password and the confirmation password do not match.',
        'YOUR_REQUEST_HAS_BEEN_SENT_TO_GROUP_CREATOR'	=> 'Your request has been sent to the group creator.',
        'X_IS_NOT_VALID_EMAIL_ADDRESS' => '%s is not a valid e-mail address',
        'COME_JOIN_ME_ON_GROUP'							=> 'Come join me on %s!',
        'INVITE_PEOPLE_TO_GROUP'						=> 'Invite People to %s',
        'INVITE_FRIENDS_TO_GROUP' => 'Invite Friends to %s',
        'SEND_INVITATIONS_TO_JOIN_GROUP'				=> 'Send invitations to other people to join %s.',
        'GROUPNAME_MEMBERS'								=> '%s Members',
        'GROUP_CREATOR'									=> 'Group Creator',
        'GROUP_ADMINISTRATOR'							=> 'Group Administrator',
        'DATE_BANNED'									=> 'Date Banned',
        'BAN_FROM_GROUP'								=> 'Ban from Group',
        'ARE_YOU_SURE_BAN_MEMBER_FROM_GROUP'			=> 'Are you sure you want to ban the selected member(s) from your group? This process may take a few minutes.',
        'ALSO_DELETE_FORUM_POSTINGS'					=> 'Also delete their forum postings and replies.',
        'GROUP_WEB_ADDRESS'								=> 'Group Web Address',
        'GROUP'											=> 'Group',
        'BACK_TO_GROUP'									=> '← Back to %s',
        'USER_BANNED_FROM_GROUP'						=> '%1$s has been banned from this group. <a %2$s>Send %1$s a message</a>',
        'USER_ALREADY_GROUP_MEMBER'						=> '%1$s is already a member of this group. <a %2$s>Send %1$s a message</a>',
        'GROUP_ADMIN_DISCUSSIONS'						=> 'Group Admin Discussions',
        'BACK_TO_NETWORK_GROUPS'						=> 'Back to %s Groups',
        'MOST_MEMBERS'									=> 'Most Members',
        'THIS_SETS_URL_OF_GROUP'						=> 'This sets the URL of your group:<br />http://%s/<strong>groupwebaddress</strong>',
        'LIKE_WHAT_YOU_SEE' => 'Like what you see on %s? Join Now!',
        'LIKE_WHAT_YOU_SEE_GROUP' => 'Like what you see in %s? Join Now!',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' 		=> 'You have created the group %1$s. You can start a discussion in the %1$s forum or invite more people to join.',
        'YOU_ARE_MEMBER_OF_GROUP_AND_CAN_INVITE'		=> 'You are now a member of %1$s. You can participate in the %1$s forum or invite more people to join. ',
        'NETWORK_DOES_NOT_HAVE_MUSIC' => 'This network doesn\'t have any music yet.',
        'PERSON_DOES_NOT_HAVE_MUSIC' => 'This person doesn\'t have any music yet.',
        'FIND_MORE_MUSIC_LIKE_THIS'						=> 'Find more music like this on <em>%s</em>',
        'TRACKS'										=> 'Tracks',
        'ADD_MUSIC_TRACKS'                             	=> 'Add Music',
        'CHOOSE_MUSIC_TRACKS'                          	=> 'Choose Songs to Add',
        'YOU_CAN_ADD_UP_TO_MP3'                        	=> 'You can add up to 4 MP3s at a time.',
        'UPLOAD_TRACKS'                                	=> 'Upload Songs',
        'ADD_TRACKS'                                   	=> 'Add Songs',
        'ENTER_THE_URL_MP3_TO_ADD'                     	=> 'Enter the URL to each MP3 you\'d like to add:',
        'EACH_MP3_FILE_MAY_BE_UP_TO'                   	=> 'You can upload up to 100 MP3s! Each MP3 file may be up to 20MB in size, but smaller files will upload more quickly.',
        'BE_NICE'                                      	=> 'Be nice',
        'PLEASE_UPLOAD_ONLY_TRACKS'                    	=> 'Please only upload songs if you have permission to do so from the artist or copyright holder.',
        'PLEASE_LINK_ONLY_TRACKS' => 'Please link only to music which has been authorized for distribution on the web.',
        'MORE_WAY_TO_ADD_MUSIC'                        	=> 'More ways to add music…',
        'ELLIP_FROM_ANOTHER_WEBSITE'                   	=> '…from another website',
        'ADD_MUSIC_FROM_ANY_WEBSITE'                   	=> 'Add music from any website by pasting in a link to the MP3.',
        'KEEP_PAGE_OPEN_MUSIC'                         	=> 'Please keep this page open so we can finish uploading your songs and we\'ll let you know when they\'ve been approved!',
        'MEANWHILE_FEEL_FREE_MUSIC'                    	=> 'Meanwhile, feel free to <a %s>open a new browser window</a> and continue using %s. When uploading is complete, you\'ll be able to add titles and descriptions to your songs in this window.',
        'TRACKS_EXCEEDED_LIMIT'                        	=> 'The track(s) seem to have exceeded the limit of 10 MB per song.',
        'EDIT_TRACK_INFORMATION'                       	=> 'Edit Song Information',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_1'   	=> 'Add a title, description, and other information to the songs you just uploaded.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_2'   	=> 'Add a title, description, and other information for this song.',
        'CANCEL_AND_RETURN_TO_PLAYLIST' => '« Cancel and return to playlist',
        'TRACK_TITLE'                                  	=> 'Song Title',
        'TRACK_ARTIST'                                 	=> 'Artist',
        'TRACK_ALBUM'                                  	=> 'Album',
        'ENABLE_DOWNLOAD_LINK'                         	=> 'Enable download link',
        'ALLOW_PEOPLE_TO_ADD_TRACK_TO_PROFILE'         	=> 'Allow people to put this song on their pages',
        'TRACK_ARTWORK'                                	=> 'Artwork',
        'EDIT_PLAYLIST'                                	=> 'Edit Playlist',
        'DRAG_TO_CHANGE_ORDER_PLAYLIST'                	=> 'To re-order your playlist, click on the song and drag it to where you want it to play.',
        'ADD_MUSIC_ELLIPSIS'                           	=> 'Add music…',
        'ELLIPSIS_FROM_YOUR_COMPUTER'                  	=> '…from your computer',
        'UPLOAD_MP3_FROM_YOUR_COMPUTER'                	=> 'Upload MP3s from your computer.',
        'DELETE_THIS_TRACK_Q'                          	=> 'Delete This Song?',
        'DELETE_TRACK'                                 	=> 'Delete Song',
        'ARE_YOU_SURE_DELETE_THIS_TRACK'               	=> 'Are you sure you want to delete this song?',
        'PLAY'                                         	=> 'play',
        'GENRE'                                        	=> 'Genre',
        'YEAR'                                         	=> 'Year',
        'LABEL'                                        	=> 'Label',
        'EXPLICIT_LYRICS'                              	=> 'Explicit Lyrics',
        'ARTIST_SITE'                                  	=> 'Artist Site',
        'HOSTING_SITE'                                 	=> 'Hosting Site',
        'LABEL_SITE'                                   	=> 'Label Site',
        'LICENSE' => 'Licence',
        'SELECT_LICENSE' => '— Select licence —',
        'LICENSE_NAME'                                 	=> 'License Name',
        'LICENSE_URL'                                  	=> 'License URL',
        'MUSIC'                                        	=> 'Music',
        'ALLOW_PEOPLE_TO_UPLOAD_AND_SHARE_AUDIO'       	=> 'Allow people to upload and share audio',
        'PLAYLIST'                                     	=> 'Playlist',
        'PODCAST'                                      	=> 'Podcast',
        'MOST_RECENT_TRACKS'                           	=> 'Most Recent',
        'FEATURED_TRACKS'                              	=> 'Featured',
        'HIGHEST_RATED_TRACKS'                         	=> 'Highest Rated',
        'NO_TRACKS_TO_PLAY'                            	=> 'There is currently no music on your network.',
        'BOX_WILL_NOT_SHOW_TRACKS' => 'This box won\'t show up for anyone else until there is a song or podcast to play. Why not add one?',
        'NO_TRACKS_ON_PLAYLIST'                        	=> 'There are currently no songs in this playlist.',
        'PLAYER_WILL_NOT_SHOW_TRACKS'                  	=> 'This player won\'t show up for other people until there is a song or podcast to play. Why not add one? ',
        'NO_FEATURED_TRACKS'                           	=> 'There are no featured songs on your network.',
        'START_FEATURING_TRACKS'                       	=> 'Start featuring songs when you hear one you would like to appear on the Main page.',
        'VIEW_MUSICPLAYER'                             	=> 'View music player',
        'MY_PLAYLIST'                                  	=> 'My Playlist',
        'NETWORK_PLAYLIST'                             	=> 'Network Playlist',
        'COPYRIGHT' => '© All Rights Reserved',
        'CC_BY_X'                                      	=> 'Creative Commons Attribution %s',
        'CC_BY_SA_X'                                   	=> 'Creative Commons Attribution Share Alike %s',
        'CC_BY_ND_X'                                   	=> 'Creative Commons Attribution No Derivatives %s',
        'CC_BY_NC_X'                                   	=> 'Creative Commons Attribution Non-commercial %s',
        'CC_BY_NC_SA_X'                                	=> 'Creative Commons Attribution Non-commercial Share Alike %s',
        'CC_BY_NC_ND_X'                                	=> 'Creative Commons Attribution Non-commercial No Derivatives %s',
        'PUBLICDOMAIN'                                 	=> 'Public Domain',
        'FACEBOOK_CONFIRM_DISABLE' 						=> 'Are you sure?',
        'FACEBOOK_PLAYER_DISABLE' 						=> 'Disable',
        'FACEBOOK_MUSIC_PLAYER_TITLE' 					=> 'Music Player',
        'FACEBOOK_MUSIC_PLAYER_DESC' 					=> 'Allow anyone to add an application to their Facebook profile pages that plays your music selection.',
        'FACEBOOK_MUSIC_BUTTON' 						=> 'Create Music Application &raquo;',
        'FACEBOOK_MUSIC_PLAYER_ENABLED' 				=> 'Facebook Music Player already enabled.',
        'FACEBOOK_VIDEO_PLAYER_TITLE' 					=> 'Video Player',
        'FACEBOOK_VIDEO_PLAYER_DESC' 					=> 'Allow anyone to add an application to their Facebook profile pages that plays a video from your network.',
        'FACEBOOK_VIDEO_BUTTON' 						=> 'Create Video Application &raquo;',
        'FACEBOOK_VIDEO_PLAYER_ENABLED' 				=> 'Facebook Video Player already enabled.',
        'FACEBOOK_SLIDESHOW_PLAYER_TITLE' 				=> 'Photo Slideshow',
        'FACEBOOK_SLIDESHOW_PLAYER_DESC'				=> 'Allow anyone to add an application to their Facebook profile pages that plays a slideshow of photos from your network.',
        'FACEBOOK_SLIDESHOW_BUTTON' 					=> 'Create Photo Slideshow Application &raquo;',
        'FACEBOOK_SLIDESHOW_PLAYER_ENABLED' 			=> 'Facebook Photo Slideshow already enabled.',
        'FACEBOOK_PLATFORM_LOGO'						=> 'Facebook Platform logo',
        'FACEBOOK_QUICK_INTRO_1' 						=> 'Facebook, a popular social networking site, allows third-party developers to create applications that can be added to Facebook member profile pages. In addition to providing added profile page functionality, these applications can be used to drive Facebook users to other web destinations.',
        'FACEBOOK_QUICK_INTRO_2' => 'With Ning, you don\'t need to be a developer to promote your social network on Facebook. We\'ve done all the heavy lifting, and your network comes pre-built with Facebook application integration. Just choose from the options below, and your social network will be integrated with Facebook in seconds.',
        'FACEBOOK_ADD_DEVELOPER_BUTTON'					=> 'Add Developer button',
        'FACEBOOK_SETUP_NEW_APP_BUTTON'					=> 'Set up New Application button',
        'FACEBOOK_YOUR_APPLICATIONS'					=> 'Your Facebook Applications',
        'FACEBOOK_EMBEDDING' 							=> 'Facebook Promotion',
        'FACEBOOK_SETUP' 								=> 'Facebook Promotion',
        'FACEBOOK_PROMOTING' 							=> 'Promoting Applications on Facebook',
        'FACEBOOK_VIEW_APP' 							=> 'View Application',
        'FACEBOOK_ADD_THE' 								=> 'Add the',
        'FACEBOOK_RECENT' 								=> 'Most Recent',
        'FACEBOOK_RECENTLY_FEATURED' 					=> 'Most Recently Featured',
        'FACEBOOK_RECENTLY_ADDED' 						=> 'Most Recently Added',
        'FACEBOOK_PROMOTED' 							=> 'Featured',
        'FACEBOOK_RATED'								=> 'Highest Rated',
        'FACEBOOK_POPULAR' 								=> 'Popular',
        'FACEBOOK_MUSIC_WIDGET' 						=> 'Music Widget',
        'FACEBOOK_VIDEO_WIDGET' 						=> 'Videos Widget',
        'FACEBOOK_PHOTO_WIDGET' 						=> 'Photos Widget',
        'FACEBOOK_INSTR_FIRST_STEPS' 					=> 'First Steps',
        'FACEBOOK_INSTR_CLICK_HERE_TO_GO_TO_FACEBOOK'	=> 'Click here to go to Facebook and start creating your application.',
        'FACEBOOK_INSTR_OPEN_FACEBOOK_IN_NEW_WINDOW'	=> 'This will open Facebook in a new window. If you\'re not already logged in to Facebook, you will need to log in now.',
        'FACEBOOK_INSTR_FIRST_STEPS_1' 					=> 'If you haven\'t created an application on Facebook, you\'ll be asked to add Facebook\'s Developer application. Once you\'ve done that, it says "You have no applications." Click <strong>Create one</strong>.',
        'FACEBOOK_INSTR_FIRST_STEPS_2' 					=> 'If you have already created an application on Facebook, you\'ll land on Facebook\'s Developer application. Click the <strong>Set Up New Application</strong> button.',
        'FACEBOOK_INSTR_FIRST_STEPS_NEXT' 				=> 'Next: Instructions on how to setup your %s application for it to work on Facebook.',
        'FACEBOOK_INSTR_SETUP' 							=> 'Setup Instructions',
        'FACEBOOK_INSTR_SETUP_1' 						=> 'Great! Now for the details. Facebook needs to know some basic information to get your application off the ground. Just follow the steps below.',
        'FACEBOOK_INSTR_SETUP_REQ_FIELDS' 				=> 'Required Fields',
        'FACEBOOK_INSTR_SETUP_2' 						=> 'Choose an <strong>Application Name</strong>.',
        'FACEBOOK_INSTR_SETUP_3' 						=> 'Check to indicate that you\'ve read the Facebook terms document.',
        'FACEBOOK_INSTR_SETUP_4' 						=> 'Open the <em>Optional Fields</em> section.',
        'FACEBOOK_INSTR_SETUP_BASE_OPT' 				=> 'Base Options',
        'FACEBOOK_INSTR_SETUP_5' => 'Put your e-mail address in the <strong>Support E-Mail</strong> field.',
        'FACEBOOK_INSTR_SETUP_6' 						=> 'Paste the following web address into the <strong>Callback URL</strong> field:',
        'FACEBOOK_INSTR_SETUP_7_EXAMPLE_X' => 'Choose a <strong>Canvas Page URL</strong> (e.g. <em>%s</em>).',
        'FACEBOOK_INSTR_SETUP_8' 						=> 'Select <strong>Yes</strong> for <em>Can your application be added on Facebook</em>.',
        'FACEBOOK_INSTR_SETUP_INST_OPT' 				=> 'Installation Options',
        'FACEBOOK_INSTR_SETUP_APP_DESC' 				=> 'Write an <strong>Application Description</strong>.',
        'FACEBOOK_INSTR_SETUP_9' 						=> 'Paste the following code into the <strong>Default FBML</strong> field:',
        'FACEBOOK_INSTR_SETUP_9B_WIDE'					=> 'For <strong>Default Profile Box Column</strong>, select <strong>Wide</strong>.',
        'FACEBOOK_INSTR_SETUP_9B_NARROW'				=> 'For <strong>Default Profile Box Column</strong>, select <strong>Narrow</strong>.',
        'FACEBOOK_INSTR_SETUP_10' 						=> 'In the <strong>Side Nav URL</strong> field, enter your <em>Canvas Page URL</em> (as created in step &#8216;f&#8217; above). Be sure to include the http://apps.facebook.com/ portion of the URL.',
        'FACEBOOK_INSTR_SETUP_11' => 'Write text for the <strong>Attachment action</strong>. This is what will appear if you\'re sending someone a message on Facebook and want to include one of your applications. If your application is a Photo Slideshow, you might enter Photos from Network Name. If your application is a Video Player, you might enter Videos from Network Name.',
        'FACEBOOK_INSTR_SETUP_12' 						=> 'Paste the following web address into the <strong>Callback URL</strong> field:',
        'FACEBOOK_INSTR_APPLICATION_SETUP_PAGE'			=> 'Facebook application setup page',
        'FACEBOOK_INSTR_SETUP_DONE' 					=> 'When you are done, click the <strong>Submit</strong> button.',
        'FACEBOOK_INSTR_SETUP_NEXT' 					=> 'Next: Retrieving your API Key and Secret.',
        'FACEBOOK_API_INFO_TITLE' 						=> 'Facebook API Information',
        'FACEBOOK_API_INFO_DESC' 						=> 'In order to complete setup, you need to enter your API Key and Secret, and your Application URL in the fields below.',
        'FACEBOOK_API_INFO_FIND_KEY' 					=> 'You can find the API Key and Secret on your <a %s>My Applications page on Facebook</a> (opens in new window) under the title of the application you have just created.',
        'FACEBOOK_API_INFO_MY_APPLICATIONS_PAGE'		=> 'My Applications page (highlighting location of API information)',
        'FACEBOOK_API_INFO_KEY' 						=> 'API Key',
        'FACEBOOK_API_INFO_SECRET' 						=> 'API Secret',
        'FACEBOOK_URL_INFO_TITLE' 						=> 'Facebook Application URL',
        'FACEBOOK_URL_INFO_DESC' 						=> 'The Application URL is the same as the <strong>Canvas Page URL</strong> that you defined on the previous page (in step &#8216;f&#8217;).',
        'FACEBOOK_MUSIC_SHOULD_PLAY_FROM' 				=> 'Facebook music applications should play:',
        'FACEBOOK_VIDEO_SHOULD_PLAY_FROM' 				=> 'Facebook video applications should play the video that is:',
        'FACEBOOK_PHOTO_SHOULD_PLAY_FROM' 				=> 'Facebook slideshow applications should play photos from:',
        'FACEBOOK_PROMOTING_ON' 						=> 'Promoting on Facebook',
        'FACEBOOK_SETUP_INSTR' 							=> 'Setup Instructions',
        'FACEBOOK_API_INFO' 							=> 'API Information',
        'FACEBOOK_DISABLE' 								=> 'Disable this Application',
        'FACEBOOK_TO_YOUR_FACEBOOK_PROFILE' 			=> 'to your Facebook profile',
        'FACEBOOK_BACK_TO_EMBEDDING' 					=> 'Back to Facebook Promotion',
        'FACEBOOK_EMBEDDING_DESC' 						=> 'Allow Facebook users to put your network\'s widgets and badges on their profile pages.',
        'FACEBOOK_PROMOTE' => 'To get the best return when it comes to promoting your new application, we recommend taking the following steps. These options can all be accessed from Facebook\'s <strong><a %s>My Applications</a></strong> page (link opens in new window).',
        'FACEBOOK_PROMOTE_TITLE_ABOUT_PAGE' 			=> 'Provide an About Page',
        'FACEBOOK_PROMOTE_TEXT_ABOUT_PAGE' 				=> 'Let Facebook users know what your application is all about by providing a clear description. To edit this information, click the <strong>Edit About Page</strong> link next to the application you\'re modifying.',
        'FACEBOOK_PROMOTE_TITLE_SUBMIT' 				=> 'Submit the Application to the Facebook Directory',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_1' 				=> 'Spread the word about your new application by adding it to the Facebook directory.',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_2' 				=> 'To submit your application, click on the <strong>Submit Application</strong> link next to the application you\'re modifying. On the following page you can edit the Application Description and also add a logo for your App.',
        'FACEBOOK_PROMOTE_TITLE_PROFILE' 				=> 'Add the Application to your Facebook Profile',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_1' 				=> 'Show off your application by adding it to your Facebook profile page, then sit back and watch your friends do the same.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_2' 				=> 'Just click the <strong>View About Page</strong> link next to the application you want to add to your profile, then choose the Add Application button on the next page.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_3' 				=> 'Your application is now on the bottom of your Facebook profile page!',
        'FACEBOOK_PROMOTE_MY_APPLICATIONS_PAGE' => 'My Applications page on Facebook',
        'FACEBOOK_MY_APPS' => 'My Applications',
        'FORUM_TAB_TEXT' => 'Forum',
        'VIDEOS_TAB_TEXT' => 'Videos',
        'PHOTOS_TAB_TEXT' => 'Photos',
        'GROUPS_TAB_TEXT' => 'Groups',
        'EACH_VIDEO_MAY_BE_100MB' => 'Each video may be up to 100MB in size. We support videos in the .mov, .mpg, .avi, .wmv and .3gp file formats.',
        'I_HAVE_RIGHT_TO_UPLOAD_VIDEO' => 'I have the right to upload this video under the <a %s>Terms of Service</a>.',
        'VIDEO_UPLOADER_REQUIRES_JAVA' => 'The bulk video uploader requires a recent version of Java. <strong><a %s>Click here to get Java</a></strong>, or <strong><a %s>return to the simple uploader</a></strong>.',
        'UPLOAD_A_VIDEO_FROM_YOUR_COMPUTER' => 'Upload a Video From Your Computer',
        'HAVE_LOT_OF_VIDEOS' => 'Have a lot of videos you want to share?',
        'TRY_BULK_VIDEO_UPLOADER' => 'Try the bulk video uploader',
        'VIDEOS_SUCCESSFULLY_UPLOADED' => 'Your videos were successfully uploaded.',
        'VIDEOS_UPLOADED_AWAITING' => 'Your videos were successfully uploaded and are awaiting approval from %s\'s creator.',
        'ADD_VIDEOS_OR_PHOTOS_TO_APPNAME' => 'Add videos or photos to %s directly from your phone by sending them to a unique e-mail address.',
        'GRAB_HTML_EMBED' => 'Grab the HTML \'embed\' code from any popular video site and add that video to this network.',
        'GOOGLE' => 'Google',
        'YOUTUBE' => 'YouTube',
        'HAVING_PROBLEMS_WITH_VIDEO_UPLOADER' => 'Having problems with the bulk video uploader?  <strong><a %s>Return to our simple uploader</a></strong>.',
        'ADD_VIDEOS_FROM_YOUTUBE' => 'Add videos from YouTube or Google',
        'TAGS_NO_COLON' => 'Tags',
        'NO_VIDEOS_TAGGED_X_CHECK' => 'There aren\'t any videos tagged "%1$s". Check out <a %2$s>discussions tagged "%1$s"</a>, <a %4$s>blog posts tagged "%1$s"</a> or <a %3$s>photos tagged "%1$s"</a>. Or add and tag your own videos!',
        'UPLOAD_VIDEOS_FROM' => 'Upload Videos From Your Computer',
        'YOUR_VIDEO_UPLOAD_TO_X_DID_NOT_COMPLETE_DUE_TO_A_CONVERSION_ERROR' => 'Your video upload on %s did not complete due to a conversion error.',
        'TO_HELP_TROUBLESHOOT_PROVIDE_THIS_VIDEO_ID_X' => 'To help troubleshoot, provide this video ID: %s',
        'YOUR_VIDEO_WAS_SUCCESSFULLY_UPLOADED_TO_X' => 'Your video was successfully uploaded to %s.',
        'TO_VIEW_THE_VIDEO_VISIT' => 'To view the video visit:',
        'YOUR_VIDEO_X_ON_Y_HAS_A_NEW_COMMENT' => 'Your video "%1$s" on %2$s has a new comment.',
        'YOUR_VIDEO_ON_X_HAS_A_NEW_COMMENT' => 'Your video on %s has a new comment.',
        'ADD_VIDEOS_BY_PHONE_OR' => 'Add videos by phone or e-mail',
        'FEATURING_ELLIPSIS' => 'Featuring…',
        'NOW_FEATURED_ON_MAIN' => 'Now Featured on Main',
        'DONT_FEATURE' => 'Don\'t Feature',
        'UNFEATURING_ELLIPSIS' => 'Removing from Main...',
        'REMOVED_FROM_MAIN' => 'Removed from Main',
        'ADDED_EXCLAMATION' => 'Added!',
        'ERROR' => 'Error',
        'ADDING_ELLIPSIS' => 'Adding...',
        'TRACK_COULD_NOT_BE_LOADED' => 'Song could not be loaded',
        'INVALID_URL' => 'Invalid URL',
        'NORMAL_PLAYBACK_ON' => 'Normal Playback: On',
        'REPEAT_PLAYBACK_ON' => 'Repeat Playback: On',
        'SHUFFLE_PLAYBACK_ON' => 'Shuffle Playback: On',
        'OPEN_POPUP_WINDOW' => 'Open Pop-up Window',
        'LOADING_PLAYLIST_ELLIPSIS' => 'Loading Playlist...',
        'EACH_PHOTO_MAY_BE_UP_TO_10MB' => 'Each photo may be up to 10MB in size. We support photos in the .jpg, .gif and .png file formats.',
        'I_HAVE_RIGHT_TO_UPLOAD_PHOTOS' => 'I have the right to upload these photos under the <a %s>Terms of Service</a>.',
        'PHOTO_UPLOADER_REQUIRES_JAVA' => 'The bulk photo uploader requires a recent version of Java. <strong><a %s>Click here to get Java</a></strong>, or <strong><a %s>return to the simple uploader</a></strong>.',
        'TRY_BULK_PHOTO_UPLOADER' => 'Try the bulk photo uploader',
        'HAVE_LOT_OF_PHOTOS' => 'Have a lot of photos you want to share?',
        'PHOTOS_SUCCESSFULLY_UPLOADED' => 'Your photos were successfully uploaded.',
        'PHOTOS_UPLOADED_AWAITING' => 'Your photos were successfully uploaded and are awaiting approval from %s\'s creator.',
        'FLICKR' => 'Flickr',
        'ADD_PHOTOS_FROM_FLICKR' => 'Add photos from Flickr',
        'ADD_PHOTOS_OR_VIDEOS_TO_APPNAME' => 'Add photos or videos to %s directly from your phone by sending them to a unique e-mail address.',
        'HAVING_PROBLEMS_WITH_PHOTO_UPLOADER' => 'Having problems with the bulk photo uploader?  <strong><a %s>Return to our simple uploader</a></strong>.',
        'NO_PHOTOS_TAGGED_X_CHECK' => 'There aren\'t any photos tagged "%1$s". Check out <a %2$s>discussions tagged "%1$s"</a>, <a %4$s>blog posts tagged "%1$s"</a> or <a %3$s>videos tagged "%1$s"</a>. Or add and tag your own photos!',
        'UPLOAD_PHOTOS_FROM_YOUR_COMPUTER' => 'Upload Photos From Your Computer',
        'YOUR_PHOTO_X_HAS_A_NEW_COMMENT_ON_Y' => 'Your photo "%1$s" has a new comment on %2$s.',
        'YOUR_PHOTO_HAS_A_NEW_COMMENT_ON_X' => 'Your photo has a new comment on %s.',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y_ELLIPSIS' => 'You have a new %1$s to approve on %2$s...',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y' => 'You have a new %1$s to approve on %2$s.',
        'YOU_HAVE_A_NEW_X_TITLE_TO_APPROVE_ON_Y' => 'You have a new %1$s "%2$s" to approve on %3$s.',
        'TO_APPROVE_THIS_X_VISIT' => 'To approve this %s, visit:',
        'YOUR_X_ON_Y_HAS_BEEN_APPROVED_ELLIPSIS' => 'Your %1$s on %2$s has been approved...',
        'YOUR_TYPE_ON_X_HAS_A_NEW_COMMENT_ELLIPSIS' => 'Your %1$s on %2$s has a new comment...',
        'CLICK_HERE_TO_JOIN' => 'Click here to join:',
        'X_WANTS_YOU_TO_CHECK_OUT_Y_ON_Z' => '%1$s wants you to check out "%2$s" on %3$s!',
        'YOUR_X_HAS_BEEN_APPROVED_ON_Y' => 'Your %s has been approved on %s.',
        'YOUR_X_Y_HAS_BEEN_APPROVED_ON_Z' => 'Your %1$s "%2$s" has been approved on %3$s.',
        'TO_VIEW_YOUR_X_VISIT' => 'To view your %s, visit:',
        'TO_VIEW_THIS_X_VISIT' => 'To view this %s, visit:',
        'TO_VIEW_IT_VISIT' => 'To view it, visit:',
        'X_REPORTED_THE_FOLLOWING_ISSUE_ON_Y_ELLIPSIS' => '%1$s reported the following issue on %2$s...',
        'USER_HAS_SENT_YOU_A_MESSAGE_ON_X' => '%1$s has sent you a message on %2$s.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X' => '%1$s has requested to join %2$s on %3$s.',
        'TO_APPROVE_OR_DENY_USER_REQUEST' => 'To approve or deny %s\'s request, visit:',
        'X_ADDED_A_COMMENT_TO_THE_BLOG_POST_Y_ON_Z' => '%1$s added a comment to the blog post "%2$s" on %3$s.',
        'X_ADDED_A_COMMENT_TO_A_BLOG_POST_ON_Y_ELLIPSIS' => '%1$s added a comment to a blog post on %2$s...',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X' => 'You have a new member to approve on %s.',
        'WELCOME_TO_THE_GROUP_X_ON_Y' => 'Welcome to the Group "%1$s" on %2$s',
        'PLEASE_SELECT_A_MEMBER' => 'Please select one or more members',
        'LOADING_YOUR_FRIENDS' => 'We\'re loading your friends...',
        'YOUR_MESSAGE_HAS_BEEN_SENT_TITLE_CASE' => 'Your Message Has Been Sent',
        'TO_SEND_ANOTHER_MESSAGE' => 'To send another message, please enter your text below.',
        'PLEASE_CHOOSE_FRIENDS' => 'Please select some friends before sending your message.',
        'RESEND_INVITATION' => 'Re-send Invitation',
        'CHOOSE_FRIENDS' => 'Choose Friends...',
        'ALL_FRIENDS' => 'All Friends',
        'ALL_FRIENDS_ON_APPNAME' => 'All Friends on %s',
        'SHARE_WITH_FRIENDS' => 'Share with Friends',
        'SHARE_THIS_WITH_FRIENDS' => 'Share This Item With Your Friends',
        'COMPOSE_MESSAGE' => 'Compose Message',
        'INVITATION_LINK_ONLY_VISIBLE' => 'This invitation link is only visible to the Network Creator and Administrators. Members who join with this link will automatically become friends with the Network Creator.',
        'WE_ARE_LOADING_ADDRESSES' => 'We\'re loading your addresses...',
        'SELECT_ALL_NONE' => 'Select All/None',
        'INVITE_TO_APPNAME' => 'Invite to \'%s\'',
        'INVITE_YOUR_FRIENDS_TO_APPNAME' => 'Invite Your Friends to \'%s\'',
        'ALREADY_MEMBER_OF_NETWORK' => '(Already a member of this network)',
        'OR_SHARE_THIS_INVITATION_LINK' => 'Or share this invitation link:',
        'CLICK_TO_MAIL' => '<a %s>Click here to mail now</a>.',
        'MESSAGE_HAS_BEEN_SENT' => 'Your Message Has Been Sent',
        'YOU_CAN_SHARE_THIS' => 'You can share with more people below or <a % s>go back to the previous page</a>.',
        'VCARD_IMPORT_UNAVAILABLE' => 'We\'re sorry, but the vCard import service is currently unavailable.',
        'CSV_IMPORT_UNAVAILABLE' => 'We\'re sorry, but the CSV import service is currently unavailable.',
        'ERROR_OCCURRED' => 'We\'re sorry, but an error has occurred.',
        'IMPORT_FAILED' => 'We\'re sorry, but the import failed.',
        'LOGIN_FAILED' => 'We\'re sorry, but the login failed.',
        'UNABLE_TO_FIND_EMAIL' => 'We\'re sorry, but we\'re unable to find the e-mail field.',
        'CANNOT_READ_VCARDS' => 'We\'re sorry, but we can\'t read these vCards.',
        'SORRY_WE_DO_NOT_SUPPORT' => 'Sorry, we don\'t support the web address book for your e-mail address. Try clicking \'Address Book Application\' below to use addresses from your computer.',
        'NO_ADDRESSES_FOUND' => 'No Addresses Found',
        'WE_DID_NOT_FIND_ADDRESSES' => 'We didn\'t find any addresses in the address book we imported.',
        'WANT_TO_INVITE_MORE_FRIENDS' => 'Want to invite more friends? Import contacts from your web or desktop address book application.',
        'IMPORT_FROM_WEB_ADDRESS_BOOK' => 'Import from Web Address Book',
        'IMPORT_FROM_ADDRESS_BOOK_APPLICATION' => 'Import from Address Book Application',
        'MICROSOFT_OUTLOOK_APPLE_ADDRESS_BOOK' => 'Microsoft Outlook, Apple Address Book, .CSV, etc.',
        'PRIVACY_POLICY' => 'Privacy Policy',
        'APPLY_FOR_MEMBERSHIP_SIGN_IN' => 'Apply for membership now. Already a member? <a %s>Click here to sign in</a>.',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK_ON_Y' => '%1$s provided the following feedback on %2$s:',
        'TRACK_STATISTICS' => 'Track Statistics',
        'FEATURED_MEMBERS' => 'Featured Members',
        'CHECK_OUT_X_ON_Y_ELLIPSIS' => 'Check out "%1$s" on %2$s...',
        'CHECK_OUT_THIS_X_ON_Y_ELLIPSIS' => 'Check out this %1$s on %2$s...',
        'SORRY_NO_MEMBERS_MATCHING_X_WERE_FOUND' => 'Sorry, no members matching "%s" were found.',
        'WHO_CAN_COMMENT_ON_POST' => 'Who can comment on this post?',
        'SEND_MESSAGE_TO_FRIENDS' => 'Send Message to Friends',
        'PREVIOUS_POST' => '← Previous Post',
        'NEXT_POST' => 'Next Post →',
        'PREVIOUS_POSTS' => '←  Previous Posts',
        'NEXT_POSTS' => 'Next Posts →',
        'NO_BLOG_POSTS_TAGGED_X_CHECK' => 'There aren\'t any blog posts tagged "%1$s". Check out <a %2$s>discussions tagged "%1$s"</a>, <a %4$s>photos tagged "%1$s"</a> or <a %3$s>videos tagged "%1$s"</a>. Or add and tag your own blog posts!',
        'ALL_POSTS_TAGGED_X_FOR_M_Y' => 'All Posts Tagged <em>\'%s\'</em> for %s %s',
        'ALL_POSTS_TAGGED_X' => 'All Posts Tagged <em>\'%s\'</em>',
        'MY_BLOG_POSTS_FOR_M_Y' => 'My Blog Posts for %s %s',
        'MY_BLOG_POSTS' => 'My Blog Posts',
        'PICK_VALID_ALL_FRIENDS_NOTIFICATION' => 'Please pick a valid choice for notifications of messages sent to all friends',
        'PRIVACY_CONTENT_CONTROL' => 'Privacy & Content Control',
        'ENABLE_MUSIC_DOWNLOAD_LINKS' => 'Enable Music Player download links',
        'WELCOME_MEMBER_N_OF_APPNAME_INVITE' => 'Welcome, %1$s! You are member #%2$s of %3$s. <a %4$s>Invite friends now</a>.',
        'YOU_COMMENTED_ON_PHOTO_TITLE' => 'You commented on the photo <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_PHOTO_TITLE' => '%s commented on the photo <a %s>%s</a>',
        'YOU_COMMENTED_ON_VIDEO_TITLE' => 'You commented on the video <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_VIDEO_TITLE' => '%s commented on the video <a %s>%s</a>',
        'NOTIFY_BLOG_PING_SERVICES' => 'Do you want to notify 3rd-party blog tracking services when you add a new post?',
        'YES_NOTIFY_BLOG_SERVICES' => 'Yes -- Notify <a %s>site update services</a> when I add a new blog post',
        'THERE_ARE_NO_FEATURED_MEMBERS' => 'There are no Featured Members on your social network.',
        'START_FEATURING_MEMBERS_CLICK_Y' => 'Start featuring Members where you see the Feature option. To learn more about featuring, <a %s>click here</a>.',
        'THIS_IS_YOUR_PAGE' => 'This is Your Page:',
        'MESSAGES_SENT_TO_ALL_FRIENDS' => 'Messages sent to all friends',
        'TO_STOP_FOLLOWING_THIS_X_GO_TO' => 'To stop following this %s, go to:',
        'SHOW_ALL' => 'Show All',
        'CHOOSE_GADGETS' => 'Choose one of these great OpenSocial gadgets to add to your profile page! You can <a %s>view and rate gadgets here</a>, or <a %s>learn more about OpenSocial here</a>.',
        'GADGETS_UNAVAILABLE' => 'Gadgets temporarily unavailable',
        'APOLOGIES_GADGETS_UNAVAILABLE' => 'Our apologies - gadgets are temporarily unavailable.',
        'BOX_WILL_NOT_SHOW_GADGET' => 'This box won\'t show up for other people unless you select a Gadget.',
        'CLICK_EDIT_TO_SPECIFY_GADGET_OR_VISIT_GADGET_GALLERY' => 'Please click Edit to specify the Gadget URL for this box or visit the <a %s>Gadget Directory</a>.',
        'PROBLEM_OCCURRED_RETRIEVING_GADGET' => 'A problem occurred retrieving this Gadget URL feed.',
        'ADD_GADGET_TO_YOUR_PAGE' => 'Add this gadget to your profile',
        'GADGETS_BETA' => 'Gadgets (Beta)',
        'TRY_OUT_OPENSOCIAL_GADGETS_WARNING_EXPERIMENTAL' => 'Try out OpenSocial Gadgets.  Warning: this feature is experimental.',
        'ADD_TO_MY_PAGE' => 'Add to My Page',
        'GADGETS' => 'Gadgets',
        'GADGETS_TAB_TEXT' => 'Gadgets',
        'GADGET' => 'Gadget',
        'GADGETS_IS_IN_BETA' => 'Gadgets is in Beta.',
        'SORRY_GADGET_UNAVAILABLE' => 'We\'re sorry, but this Gadget is unavailable. Please check to ensure that you have the right URL. If you are still having issues, <a %s>please let us know</a>.',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_ADD' => 'There aren\'t any discussions tagged "%1$s". Check out <a %2$s>photos tagged "%1$s"</a>, <a %4$s>blog posts tagged "%1$s"</a> or <a %3$s>videos tagged "%1$s"</a>. Or add and tag your own discussions!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK' => 'There aren\'t any discussions tagged "%1$s". Check out <a %2$s>photos tagged "%1$s"</a>, <a %4$s>blog posts tagged "%1$s"</a> or <a %3$s>videos tagged "%1$s"</a>.',
        'ALREADY_MEMBER_OF_GROUP' => '(Already a member of this group)',
        'INVITE_YOUR_FRIENDS_TO_GROUPNAME' => 'Invite Your Friends to \'%s\'',
        'COME_JOIN_ME_ON_X_ON_Y' => 'Come join me on %1$s on %2$s.',
        'COME_JOIN_ME_ON_X_ON_Y_ELLIPSIS' => 'Come join me on %1$s on %2$s...',
        'INVITE_TO_GROUP' => 'Invite to \'%s\'',
        'YOU_CAN_ADD_100_SONGS' => 'You can add 100 total songs, and each may be up to 20MB in size. We support songs in the .mp3 file format.',
        'I_HAVE_RIGHT_TO_UPLOAD_SONGS' => 'I have the right to upload these songs under the <a %s">Terms of Service</a>.',
        'MUSIC_UPLOADER_REQUIRES_JAVA' => 'The bulk music uploader requires a recent version of Java. <strong><a %s>Click here to get Java</a></strong>, or <strong><a %s>return to the simple uploader</a></strong>.',
        'HAVE_LOT_OF_MUSIC' => 'Have a lot of music you want to share?',
        'TRY_BULK_MUSIC_UPLOADER' => 'Try the bulk music uploader',
        'SONGS_SUCCESSFULLY_UPLOADED' => 'Your songs were successfully uploaded.',
        'SORRY_YOU_CAN_ONLY_HAVE_N_TRACKS' => 'Sorry, you can only have %s songs in your playlist. Please remove some existing songs before adding more.',
        'ADD_MUSIC_FROM_WEBSITE' => 'Add music from another website',
        'HAVING_PROBLEMS_WITH_MUSIC_UPLOADER' => 'Having problems with this music uploader?  <strong><a %s>Return to our simple uploader</a></strong>.',
        'UPLOAD_MUSIC_FROM_YOUR_COMPUTER' => 'Upload Music From Your Computer',
        'ADD_MUSIC' => 'Add Music',
        'FACEBOOK_INSTR_SETUP_APP_PERMISSION' => 'Select <strong>Users</strong> and <strong>All Pages</strong>.',
    );

  /**
   * If the given widget title is the default English title for the widget,
   * translate it into the current language.
   *
   * @param $widgetTitle string  The title of the widget
   * @return string  A translated title if the title is the English default; otherwise, the title unchanged
   */
  public static function translateDefaultWidgetTitle($widgetTitle) {

      return $widgetTitle;
  }

}
