<?php

XG_App::includeFileOnce('/lib/XG_AbstractMessageCatalog.php');

/**
 * Texts for the de_DE locale.
 */
class XG_MessageCatalog_de_DE extends XG_AbstractMessageCatalog {

    /**
     * Returns a localized version of a string. The first argument is the message name, e.g., 'ADD_A_PHOTO'.
     * Subsequent arguments are substitution values (if the message contains sprintf format elements).
     *
     * @param $args array the message name, plus optional substitution values
     * @return string the localized string
     * @see xg_html()
     */
    public static function text($args) {
        $s = $args[0];
        static $a = array();
        if (! $a) {
            $a['N_INVITATIONS_RESENT']['1'] = '1 Einladung wurde nochmal verschickt.';
            $a['N_INVITATIONS_RESENT']['n'] = '%s Einladungen wurden nochmal verschickt.';
            $a['N_SECONDS_AGO']['1'] = 'Vor 1 Sekunde';
            $a['N_SECONDS_AGO']['n'] = 'Vor %s Sekunden';
            $a['N_MINUTES_AGO']['1'] = 'Vor 1 Minute';
            $a['N_MINUTES_AGO']['n'] = 'Vor %s Minuten';
            $a['N_HOURS_AGO']['1'] = 'Vor 1 Stunde';
            $a['N_HOURS_AGO']['n'] = 'Vor %s Stunden';
            $a['N_VIDEOS']['1'] = '<strong>1</strong> Video';
            $a['N_VIDEOS']['n'] = '<strong>%s</strong> Videos';
            $a['N_VIEWS']['1'] = '1 Ansicht';
            $a['N_VIEWS']['n'] = '%s Ansichten';
            $a['N_COMMENTS']['1'] = '<span class="comment-count">1</span> Kommentar';
            $a['N_COMMENTS']['n'] = '<span class="comment-count">%s</span> Kommentare';
            $a['VIDEO_IS_FAVORITE_OF']['1'] = 'Dieses Video gehört zu den <strong>Lieblingsvideos</strong> von <strong>1 Person</strong>.';
            $a['VIDEO_IS_FAVORITE_OF']['n'] = 'Dieses Video gehört zu den <strong>Lieblingsvideos</strong> von <strong>%s Personen</strong>.';
            $a['Y_ADDED_X_VIDEOS']['1'] = '%2$s hat ein Video hinzugefügt:';
            $a['Y_ADDED_X_VIDEOS']['n'] = '%2$s hat %s Videos hinzugefügt.';
            $a['YOU_ADDED_X_VIDEOS']['1'] = 'Sie haben ein Video hinzugefügt:';
            $a['YOU_ADDED_X_VIDEOS']['n'] = 'Sie haben %s Videos hinzugefügt.';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['1'] = 'Es gibt 1 Video auf %2$s';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['n'] = 'Es gibt %1$s Videos auf %2$s';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['1'] = 'Es gibt 1 <a href="%3$s">Video</a> auf %2$s';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['n'] = 'Es gibt %1$s <a href="%3$s">Videos</a> auf %2$s';
            $a['N_PHOTOS_FROM_ALBUM']['1'] = '1 Foto dieses Albums wurde gelöscht oder als privat markiert und kann daher nicht angezeigt werden.';
            $a['N_PHOTOS_FROM_ALBUM']['n'] = '%s Fotos dieses Albums wurden gelöscht oder als privat markiert und können daher nicht angezeigt werden.';
            $a['N_PHOTOS']['1'] = '<strong>1</strong> Foto';
            $a['N_PHOTOS']['n'] = '<strong>%s</strong> Fotos';
            $a['N_PHOTOS_2']['1'] = '1 Foto';
            $a['N_PHOTOS_2']['n'] = '%s Fotos';
            $a['AND_X_OTHER_PEOPLE']['1'] = 'und 1 andere Person';
            $a['AND_X_OTHER_PEOPLE']['n'] = 'und %s andere Personen';
            $a['PROBLEM_UPLOADING_FILES']['1'] = 'Beim Hochladen der folgenden Datei gab es ein Problem:';
            $a['PROBLEM_UPLOADING_FILES']['n'] = 'Beim Hochladen der folgenden Dateien gab es ein Problem:';
            $a['PHOTO_IS_FAVORITE_OF']['1'] = 'Dieses Foto gehört zu den <strong>Lieblingsfotos</strong> von <strong>1 Person</strong>.';
            $a['PHOTO_IS_FAVORITE_OF']['n'] = 'Dieses Foto gehört zu den <strong>Lieblingsfotos</strong> von <strong>%s Personen</strong>.';
            $a['RATING_Y_AFTER_X_VOTES']['1'] = '<strong>Bewertung:</strong> %2$s nach 1 Stimmabgabe';
            $a['RATING_Y_AFTER_X_VOTES']['n'] = '<strong>Bewertung:</strong> %2$s nach %s Stimmabgaben';
            $a['Y_AFTER_X_VOTES']['1'] = '%2$s nach 1 Stimmabgabe';
            $a['Y_AFTER_X_VOTES']['n'] = '%2$s nach %s Stimmabgaben';
            $a['N_PEOPLE']['1'] = '1 Person';
            $a['N_PEOPLE']['n'] = '%s Personen';
            $a['N_OF_5_STARS']['1'] = '1 von 5 Sterne';
            $a['N_OF_5_STARS']['n'] = '%s von 5 Sterne';
            $a['YOUR_RATING_X_STARS']['1'] = 'Ihre Bewertung: 1 Stern';
            $a['YOUR_RATING_X_STARS']['n'] = 'Ihre Bewertung: %s Sterne';
            $a['Y_ADDED_X_PHOTOS']['1'] = '%2$s hat ein Foto hinzugefügt:';
            $a['Y_ADDED_X_PHOTOS']['n'] = '%2$s hat %s Fotos hinzugefügt.';
            $a['YOU_ADDED_X_PHOTOS']['1'] = 'Sie haben ein Foto hinzugefügt:';
            $a['YOU_ADDED_X_PHOTOS']['n'] = 'Sie haben %s Fotos hinzugefügt.';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['1'] = 'Es gibt 1 Foto auf %2$s';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['n'] = 'Es gibt %1$s Fotos auf %2$s';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['1'] = 'Es gibt %1$s <a href="%3$s">Foto</a> auf %2$s';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['n'] = 'Es gibt %1$s <a href="%3$s">Fotos</a> auf %2$s';
            $a['N_COMMENTS_ON_PAGE']['1'] = '<strong>1</strong> Kommentar auf Ihrer persönlichen Seite';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s</strong> Kommentare auf Ihrer persönlichen Seite';
            $a['N_BLOG_COMMENTS']['1'] = '<strong>1</strong> Blog Kommentar';
            $a['N_BLOG_COMMENTS']['n'] = '<strong>%s</strong> Blog Kommentare';
            $a['N_YEARS_OLD']['1'] = '1 Jahr alt';
            $a['N_YEARS_OLD']['n'] = '%s Jahre alt';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['1'] = 'Sie haben 1 Freundschaftsanfrage!';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['n'] = 'Sie haben %s Freundschaftsanfragen!';
            $a['COMMENT_WALL_N_COMMENTS']['1'] = 'Kommentarwand (1 Kommentar)';
            $a['COMMENT_WALL_N_COMMENTS']['n'] = 'Kommentarwand (%s Kommentare)';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['1'] = '1 neues Mitglied in der letzten Woche.';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['n'] = '%s neue Mitglieder in der letzten Woche.';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['1'] = '1 <a href="%2$s">neues Mitglied</a> in der letzten Woche.';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['n'] = '%1$s <a href="%2$s">neue Mitglieder</a> in der letzten Woche.';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['1'] = 'Es gibt 1 Mitglied auf %2$s';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['n'] = 'Es gibt %1$s Mitglieder auf %2$s';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['1'] = 'Es gibt 1 <a href="%3$s">Mitglied</a> auf %2$s';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['n'] = 'Es gibt %1$s <a href="%3$s">Mitglieder</a> auf %2$s';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['1'] = 'Es gibt 1 Blog-Beitrag auf %2$s';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['n'] = 'Es gibt %1$s Blog-Beiträge auf %2$s';
            $a['N_NEW_MEMBERS']['1'] = '<strong>1</strong> neues Mitglied';
            $a['N_NEW_MEMBERS']['n'] = '<strong>%s</strong> neue Mitglieder';
            $a['N_REPLIES']['1'] = '1 Antwort';
            $a['N_REPLIES']['n'] = '%s Antworten';
            $a['N_MINUTES']['1'] = 'Sie haben noch 1 Minute Zeit, um Ihren Kommentar zu bearbeiten.';
            $a['N_MINUTES']['n'] = 'Sie haben noch %s Minuten Zeit, um Ihren Kommentar zu bearbeiten.';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['1'] = 'Es gibt 1 Diskussionsthema auf %2$s';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['n'] = 'Es gibt %1$s Diskussionsthemen auf %2$s';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['1'] = 'Es gibt 1 <a href="%3$s">Diskussionsthema</a> auf %2$s';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['n'] = 'Es gibt %1$s <a href="%3$s">Diskussionsthemen</a> auf %2$s';
            $a['N_INVITES']['1'] = '%s Einladung';
            $a['N_INVITES']['n'] = '%s Einladungen';
            $a['N_MEMBERS']['1'] = '1 Mitglied';
            $a['N_MEMBERS']['n'] = '%s Mitglieder';
            $a['N_MEMBERS_PARENTHESIZED']['1'] = '(1 Mitglied)';
            $a['N_MEMBERS_PARENTHESIZED']['n'] = '(%s Mitglieder)';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['1'] = 'Es gibt 1 Gruppe auf %2$s';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['n'] = 'Es gibt %1$s Gruppen auf %2$s';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['1'] = 'Es gibt 1 <a href="%3$s">Gruppe</a> auf %2$s';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['n'] = 'Es gibt %1$s <a href="%3$s">Gruppen</a> auf %2$s';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['1'] = '1 Song dieser Wiedergabeliste kann nicht abgespielt werden, da er gelöscht wurde oder nicht mehr freigegeben ist.';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['n'] = '%s Songs dieser Wiedergabeliste können nicht abgespielt werden, da sie gelöscht wurden oder nicht mehr freigegeben sind.';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['1'] = 'Ein neuer Songs wurden zu %2$s hinzugefügt';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['n'] = '%1$s neue Songs wurden zu %2$s hinzugefügt';
            $a['Y_ADDED_X_SONGS']['1'] = '%2$s hat einen Song hinzugefügt:';
            $a['Y_ADDED_X_SONGS']['n'] = '%2$s hat %s Songs hinzugefügt.';
            $a['YOU_ADDED_X_SONGS']['1'] = 'Sie haben einen Song hinzugefügt:';
            $a['YOU_ADDED_X_SONGS']['n'] = 'Sie haben %s Songs hinzugefügt.';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['1'] = '1 Song zur Wiedergabeliste hinzugefügt.';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['n'] = '%s Songs zur Wiedergabeliste hinzugefügt.';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['1'] = 'Es gibt 1 Song auf %2$s';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['n'] = 'Es gibt %1$s Songs auf %2$s';
            }
        if ($a[$args[0]]) {
            $args[0] = $a[$args[0]][$args[1]] ? $a[$args[0]][$args[1]] : $a[$args[0]]['n'];
            return @call_user_func_array('sprintf', $args);
        }
        $text = self::$messages[$s];
        if ($text) { $args[0] = $text; }
        return @call_user_func_array('sprintf', $args);
    }

    /**
     * Message names and texts. Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;
     */
    private static $messages = array(

        '1_DAY_AGO' => 'Vor einem Tag',
        'AABBCC' => 'AaBbCc',
        'ABOUT_ME' => 'über mich',
        'ABOUT_THIS_ALBUM' => 'über dieses Album',
        'ABOUT_THIS_DISCUSSION' => 'über diese Diskussion',
        'ABOUT_THIS_PHOTO' => 'über dieses Foto',
        'ABOUT_THIS_POST' => 'über diesen Beitrag',
        'ABOUT_THIS_VIDEO' => 'über dieses Video',
        'ABOUT_WIDGETS' => 'über Widgets',
        'ABOUT_X' => 'über %s',
        'ABOUT_YOUR_ALBUM' => 'über Ihr Album',
        'ABOUT_YOUR_DISCUSSION' => 'über Ihre Diskussion',
        'ABOUT_YOUR_PHOTO' => 'über Ihr Foto',
        'ABOUT_YOUR_POST' => 'über Ihren Beitrag',
        'ABOUT_YOUR_SITE' => 'über Ihr Netzwerk',
        'ABOUT_YOUR_VIDEO' => 'über dieses Video',
        'ABUSIVE' => 'Beleidigend',
        'ACCEPT' => 'Akzeptieren',
        'ACCEPT_MEMBERSHIP' => 'Mitgliedschaft akzeptieren',
        'ACCOUNT' => 'Benutzerkonto',
        'ACTION_BUTTON_FEATURE' => 'Auf der Startseite vorstellen',
        'ACTION_BUTTON_REMOVE' => 'Entfernen',
        'ACTIVE' => 'Aktiv',
        'ACTIVE_LANGUAGE_IS_X' => '<em>Die aktive Sprache in Ihrem Netzwerk ist %1$s</em>. <a %2$s>Aktive Sprache ändern</a>',
        'ACTIVITY' => 'Aktivität',
        'ACTIVITY_ON_THINGS_IVE_ADDED' => 'Aktivität bei Dingen, die ich hinzugefügt habe',
        'ADD' => 'Hinzufügen',
        'ADDED_BY' => 'Hinzugefügt von:',
        'ADDED_BY_STRONG_X' => 'Hinzugefügt von <strong>%s</strong>',
        'ADDED_BY_USER_TO_GROUP_AT_DATE' => 'Von <a %s>%s</a> zu %s um %s am %s hinzugefügt',
        'ADDED_BY_X' => 'Von %s hinzugefügt',
        'ADDED_BY_X_AT_X' => 'Von <a %s>%s</a> um %s am %s hinzugefügt',
        'ADDED_BY_X_T' => 'Hinzugefügt von %s %s',
        'ADDED_EXCLAMATION' => 'Hinzugefügt!',
        'ADDED_ON_DATE' => '%s hinzugefügt',
        'ADDED_ON_DATE_BY' => '<strong>%s</strong> hinzugefügt von:',
        'ADDED_ON_DATE_BY_X' => '%s hinzugefügt von %s.',
        'ADDED_POST_ON' => '<strong>Hat einen Beitrag hinzugefügt</strong> %s',
        'ADDED_POST_T' => '<strong>Hat einen Beitrag hinzugefügt</strong> %s',
        'ADDED_REPLY_ON' => '<strong>Hat geantwortet</strong> %s',
        'ADDED_REPLY_T' => '<strong>Hat geantwortet</strong> %s',
        'ADDING_ELLIPSIS' => 'Wird hinzugefügt‚…',
        'ADDING_YOUR_OWN_CSS_NETWORK' => 'Das Hinzufügen eigenen CSS gibt Ihnen vollständige Kontrolle über Schriftarten, Farben, Abstände und das allgemeine Erscheinungsbild Ihres Netzwerks.',
        'ADDING_YOUR_OWN_CSS_PAGE' => 'Das Hinzufügen eigenen CSS gibt Ihnen vollständige Kontrolle über Schriftarten, Farben, Abstände und das allgemeine Erscheinungsbild Ihrer persönlichen Seite.',
        'ADDITIONAL_INFORMATION_COLON' => 'Zusätzliche Informationen:',
        'ADD_ANOTHER_CATEGORY' => 'Eine weitere Kategorie hinzufügen',
        'ADD_ANOTHER_QUESTION' => 'Eine weitere Frage hinzufügen',
        'ADD_AS_FRIEND' => 'Als Freund/in hinzufügen',
        'ADD_A_BLOG_POST' => 'Einen Blog-Beitrag hinzufügen',
        'ADD_A_CATEGORY' => 'Eine Kategorie hinzufügen',
        'ADD_A_COMMENT' => 'Kommentieren',
        'ADD_A_LOGO' => 'Ein Logo hinzufügen',
        'ADD_A_PHOTO' => 'Ein Foto hinzufügen',
        'ADD_A_VIDEO' => 'Ein Video hinzufügen',
        'ADD_A_VIDEO_FROM_YOUTUBE' => 'Ein Video von YouTube oder Google hinzufügen',
        'ADD_A_VIDEO_MORE_OPTIONS' => 'Fügen ein Video zu Ihrer Website oder MySpace-Seite hinzu. Noch mehr Möglichkeiten hier: <a href="%s">Alle Videos anzeigen</a> auf %s.',
        'ADD_BLOG_POST' => 'Einen Blog-Beitrag hinzufügen',
        'ADD_BY_PHONE' => 'Per Mobiltelefon hinzufügen',
        'ADD_CATEGORIES' => 'Kategorien hinzufügen',
        'ADD_COLUMNS' => 'Spalten hinzufügen…',
        'ADD_COMMENT' => 'Kommentar hinzufügen',
        'ADD_CONTENT' => 'Inhalt hinzufügen',
        'ADD_DISCUSSIONS_AND_SHARE' => 'Fügen Sie Diskussionen hinzu und lassen Sie Freunde, Familienmitglieder und den Rest der Welt daran teilhaben!',
        'ADD_FACTS_ABOUT_THE_NETWORK_ELLIPSIS' => 'Informationen über das Netzwerk hinzufügen…',
        'ADD_FAVORITES' => 'Favoriten hinzufügen',
        'ADD_FEATURES' => 'Funktionen zu Ihrem Netzwerk hinzufügen.',
        'ADD_FEEDS_FROM_ACROSS_THE_WEB' => 'Fügen Sie RSS/Atom Feeds aus dem Internet hinzu.',
        'ADD_FROM_ADDRESS' => 'Aus dem Adressbuch hinzufügen',
        'ADD_GADGET_TO_YOUR_PAGE' => 'Dieses Gadget zu Ihrem Profil hinzufügen',
        'ADD_MANAGE_CATEGORIES' => 'Kategorien hinzufügen/verwalten',
        'ADD_MESSAGE' => 'Nachricht hinzufügen',
        'ADD_MESSAGES_ACTIVITY_FEED' => 'Fügen Sie Nachrichten hinzu, und wählen Sie, was im Aktivitäten-Feed Ihres Netzwerks angezeigt wird.',
        'ADD_MESSAGE_TO_LATEST_ACTIVITY' => 'Eine Nachricht zur letzten Aktivität hinzufügen',
        'ADD_MODULE' => 'Modul hinzufügen…',
        'ADD_MUSIC' => 'Musik hinzufügen',
        'ADD_MUSIC_ELLIPSIS' => 'Musik hinzufügen…',
        'ADD_MUSIC_FROM_ANY_WEBSITE' => 'Fügen Sie Musik aus dem Internet via Links zu MP3 Dateien hinzu.',
        'ADD_MUSIC_FROM_WEBSITE' => 'Musik von einer anderen Webseite hinzufügen',
        'ADD_MUSIC_TRACKS' => 'Musik hinzufügen',
        'ADD_NEW_BLOG_POST' => 'Einen neuen Blog-Beitrag hinzufügen',
        'ADD_PAGES_CALL_TO_ACTION' => 'Den Anfang machen mit einer neuen Seite.',
        'ADD_PHOTOS' => 'Fotos hinzufügen',
        'ADD_PHOTOS_AND_SHARE' => 'Fügen Sie Fotos hinzu und erzählen Sie es Freunden, Familie oder dem Rest der Welt!',
        'ADD_PHOTOS_AND_VIDEOS_TO_APPNAME_FROM_PHONE' => 'Fügen Sie Fotos und Videos zu %s von Ihrem Mobiltelefon hinzu, indem Sie sie an diese E-Mail-Adresse senden:',
        'ADD_PHOTOS_AND_VIDEOS_TO_X_BY_SENDING' => 'Fügen Sie Fotos und Videos zu %s hinzu, indem Sie sie an diese E-Mail-Adresse senden:',
        'ADD_PHOTOS_BY_DRAGGING' => '<strong>Sie können Fotos hinzufügen</strong>, indem Sie diese rechts in Ihr Album ziehen. Durch Zurückziehen können Sie die Fotos wieder entfernen.',
        'ADD_PHOTOS_BY_PHONE_OR_EMAIL' => 'Fotos per Mobiltelefon oder E-Mail hinzufügen',
        'ADD_PHOTOS_FROM_FLICKR' => 'Fotos von Flickr hinzufügen',
        'ADD_PHOTOS_FROM_YOUR_FLICKR' => 'Fügen Sie Fotos aus Ihrem Flickr-Account hinzu.',
        'ADD_PHOTOS_OR_VIDEOS_TO_APPNAME' => 'Fügen Sie Fotos oder Videos zu %s direkt von Ihrem Mobiltelefon hinzu, indem Sie sie an eine spezielle E-Mail-Adresse senden.',
        'ADD_PHOTOS_OR_VIDEOS_TO_X' => 'Fügen Sie Fotos oder Videos zu %s direkt von Ihrem Mobiltelefon hinzu, indem Sie sie an eine spezielle E-Mail-Adresse senden.',
        'ADD_PHOTOS_SENTENCE_CASE' => 'Fotos hinzufügen',
        'ADD_PHOTOS_TO_ALBUM' => 'Wählen Sie eine der unten stehenden Möglichkeiten, um weitere Fotos zum Album hinzuzufügen.',
        'ADD_PLAYER_LOGO_OR_WATERMARK' => 'Fügen Sie ein Logo oder Wasserzeichen zum Video-Player Ihres Netzwerks hinzu. <a %s>Jetzt einrichten!</a>',
        'ADD_PREMIUM_SERVICES' => 'Premiumdienste hinzufügen',
        'ADD_SLIDESHOW_LOGO' => 'Fügen Sie ein Logo zur Diashow Ihres sozialen Netzwerks hinzu. <a %s>Jetzt einrichten!</a>',
        'ADD_TITLE_AND_DESCRIPTION' => 'Titel und Beschreibung hinzufügen',
        'ADD_TITLE_AND_DESCRIPTION_FOR_PHOTOS' => 'Titel und Beschreibung zu Ihren Fotos hinzufügen',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_1' => 'Fügen Sie Titel, Beschreibungen und andere Informationen zu den soeben hochgeladenen Fotos hinzu.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_2' => 'Fügen Sie Titel, Beschreibung und andere Informationen zu diesem Foto hinzu.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_1' => 'Fügen Sie Titel, Beschreibungen und andere Informationen zu den soeben hochgeladenen Songs hinzu.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_2' => 'Fügen Sie Titel, Beschreibung und andere Informationen zu diesem Song hinzu.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_1' => 'Fügen Sie Titel, Beschreibung und andere Informationen zu dem soeben hochgeladenen Video hinzu.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_2' => 'Fügen Sie Titel, Beschreibung und andere Informationen zu diesem Video hinzu.',
        'ADD_TO_ALBUM' => 'Zu Album hinzufügen',
        'ADD_TO_FAVORITES' => 'Zu Favoriten hinzufügen',
        'ADD_TO_LANGUAGE' => 'Zur Sprache hinzufügen:',
        'ADD_TO_MY_PAGE' => 'Zu persönlichen Seite hinzufügen',
        'ADD_TRACKS' => 'Songs hinzufügen',
        'ADD_VIDEO' => 'Video hinzufügen',
        'ADD_VIDEOS' => 'Videos hinzufügen',
        'ADD_VIDEOS_AND_SHARE' => 'Fügen Sie Videos hinzu und erzählen Sie es Freunden, Familie oder dem Rest der Welt!',
        'ADD_VIDEOS_BY_PHONE_OR' => 'Video per Mobiltelefon oder E-Mail hinzufügen',
        'ADD_VIDEOS_BY_PHONE_OR_EMAIL' => 'Video per Mobiltelefon oder E-Mail hinzufügen',
        'ADD_VIDEOS_FROM_YOUTUBE' => 'Videos von YouTube oder Google hinzufügen',
        'ADD_VIDEOS_OR_PHOTOS_TO_APPNAME' => 'Fügen Sie Videos oder Photos zu %s direkt mittels Ihres Mobiltelefons hinzu, indem Sie sie an eine spezielle E-Mail Addresse senden.',
        'ADD_YOUR_COMMENT' => 'Ihren Kommentar hinzufügen',
        'ADD_YOUR_FIRST_BLOG_POST' => 'Fügen Sie Ihren ersten Blog-Beitrag hinzu',
        'ADD_YOUR_FIRST_PHOTOS' => 'Fügen Sie Ihre ersten Fotos hinzu',
        'ADD_YOUR_FIRST_VIDEO' => 'Fügen Sie Ihr erstes Video hinzu',
        'ADD_YOUR_REPLY' => 'Ihre Antwort hinzufügen',
        'ADJUST_YOUR_SITES_COLORS' => 'Passen Sie die Farben, Bilder und das generelle Erscheinungsbild Ihres Netzwerks an.',
        'ADMINISTRATORS' => 'Administratoren',
        'ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Administratoren haben in einem ähnlichen Maße Kontrolle über das Netzwerk wie der Gründer des Netzwerkes.',
        'ADS' => 'Werbung',
        'ADULT' => 'Nicht jugendfrei',
        'ADVANCED' => 'Erweitert',
        'ADVANCED_IMPORT' => 'Erweiterter Import',
        'ALBUM' => 'Album',
        'ALBUMS_FEATURING_PHOTO' => 'Alben, die dieses Foto enthalten',
        'ALBUMS_WITH_THIS_PHOTO' => 'Alle Alben mit diesem Foto',
        'ALBUMS_WITH_X' => 'Alle Alben mit \'%s\'',
        'ALBUMS_WITH_X_2' => 'Alle Alben mit <em>\'%s\'</em>',
        'ALBUM_BY_X_ON_X' => 'Album von %s auf %s',
        'ALBUM_DOES_NOT_HAVE_PHOTOS' => 'Dieses Album enthält noch keine Fotos.',
        'ALBUM_IS_NOW_EMPTY' => 'Dieses Album ist jetzt leer.',
        'ALBUM_PHOTOS_NOT_VISIBLE_TO_OTHERS' => 'Dieses Album ist für andere Personen nicht sichtbar, da die Fotos in ihm entweder nur für Sie sichtbar sind oder noch akzeptiert werden müssen.',
        'ALBUM_TITLE' => 'Albumtitel:',
        'ALL' => 'Alle',
        'ALLOW_FACEBOOK_USERS_TO' => 'Erlauben Sie Facebook-Benutzern, Widgets Ihres Netzwerks zu ihren Profilseiten hinzuzufügen.',
        'ALLOW_MEMBERS_TO_CREATE_GROUPS' => 'Erlauben Sie Mitgliedern, eigene Interessengruppen innerhalb Ihres Netzwerks zu erstellen.',
        'ALLOW_MEMBERS_TO_REPLY' => 'Erlauben Sie Mitgliedern, zu antworten',
        'ALLOW_MEMBERS_TO_START_DISCUSSIONS' => 'Erlauben Sie Mitgliedern, in dieser Kategorie Diskussionen zu starten',
        'ALLOW_PEOPLE_TO_ADD_TRACK_TO_PROFILE' => 'Erlauben Sie anderen das Einfügen dieses Songs auf deren persönlichen Seiten',
        'ALLOW_PEOPLE_TO_REQUEST' => 'Erlauben Sie anderen, eine Einladung in Ihr Netzwerk anzufordern',
        'ALLOW_PEOPLE_TO_UPLOAD_AND_SHARE_AUDIO' => 'Erlauben Sie Mitgliedern, Songs hochzuladen und mit anderen zu teilen',
        'ALLOW_USERS_PHOTOS' => 'Ermöglichen Sie Mitgliedern, Fotos hochzuladen und mit anderen zu teilen',
        'ALLOW_USERS_VIDEOS' => 'Ermöglichen Sie Mitgliedern, Videos hochzuladen und mit anderen zu teilen',
        'ALL_ALBUMS' => 'Alle Alben',
        'ALL_DISCUSSIONS' => 'Forum Hauptseite',
        'ALL_DISCUSSIONS_TAGGED_X' => 'Alle Diskussionen mit den Schlagworten <em>\'%s\'</em>',
        'ALL_FRIENDS' => 'Alle Freunde',
        'ALL_FRIENDS_ON_APPNAME' => 'Alle Freunde auf %s',
        'ALL_PAGES' => 'Alle Seiten',
        'ALL_PHOTOS' => 'Alle Fotos',
        'ALL_PHOTOS_TAGGED_X' => 'Alle Fotos mit den Schlagworten \'%s\'',
        'ALL_PHOTOS_TAGGED_X_2' => 'Alle Fotos mit den Schlagworten <em>\'%s\'</em>',
        'ALL_POSTS_TAGGED_X' => 'Alle Beiträge mit den Schlagworten <em>\'%s\'</em>',
        'ALL_POSTS_TAGGED_X_FOR_M_Y' => 'Alle Beiträge mit den Schlagworten <em>\'%s\'</em> für %s %s',
        'ALL_SIZES' => 'Alle Größen',
        'ALL_VIDEOS' => 'Alle Videos',
        'ALL_VIDEOS_TAGGED_X' => 'Alle Videos mit den Schlagworten \'%s\'',
        'ALL_VIDEOS_TAGGED_X_2' => 'Alle Videos mit den Schlagworten <em>\'%s\'</em>',
        'ALL_VIDEOS_TAGGED_X_X' => 'Alle Videos mit den Schlagworten %s (%s)',
        'ALPHABETICAL' => 'Alphabetisch',
        'ALREADY_MEMBER_OF_GROUP' => '(Bereits Mitglied dieser Gruppe)',
        'ALREADY_MEMBER_OF_NETWORK' => '(Bereits Mitglied dieses Netzwerks)',
        'ALREADY_MEMBER_SIGN_IN' => 'Sind Sie schon Mitglied? <a %s>Hier anmelden.</a>.',
        'ALSO_DELETE_FORUM_POSTINGS' => 'Auch ihre Diskussionsbeiträge und Antworten löschen.',
        'ALTERNATIVELY_YOU_CAN_SEARCH' => 'Alternativ können Sie in diesem Netzwerk suchen:',
        'AM' => 'AM',
        'ANALYTICS_LEARN_MORE' => 'Um mehr über Google Analytics zu erfahren und Ihr eigenes Konto einzurichten, <a %s>klicken Sie hier</a>.',
        'AND' => 'und',
        'ANNOUNCEMENT' => 'Ankündigung',
        'ANSWERS_TO_FAQS' => 'Antworten auf häufig gestellte Fragen zur individuellen Anpassung Ihres Netzwerks',
        'ANSWER_TYPE' => 'Art der Antwort',
        'ANYBODY' => 'Jeder',
        'ANYONE' => 'Jeder',
        'ANYONE_CAN_JOIN_GROUP' => 'Jeder kann dieser Gruppe beitreten',
        'ANYONE_CAN_SIGN_UP_VISITORS_CAN' => 'Jeder kann Mitglied werden. Besucher können…',
        'ANY_JAVASCRIPT_CODE' => 'Der hier eingefügte JavaScript-Code wird am Ende jeder Seite Ihres Netzwerks eingebunden. Sie können dies z.B. für externe Web Analyse Software wie etwa Google Analytics verwenden.',
        'APOLOGIES_GADGETS_UNAVAILABLE' => 'Leider sind die Gadgets vorübergehend nicht verfügbar.',
        'APPEARANCE' => 'Erscheinungsbild',
        'APPEARS_IN_EMAILS' => 'Erscheint u.a. in E-Mails',
        'APPEARS_IN_HEADER' => 'Erscheint in der Kopfzeile Ihres Netzwerks',
        'APPLICATION_ID' => 'Anwendungs-ID:',
        'APPLICATION_NAME' => 'Anwendungsname:',
        'APPLY_FOR_MEMBERSHIP_SIGN_IN' => ' Werden Sie jetzt Mitglied. Sie sind schon Mitglied? <a %s>Klicken Sie hier um sich anzumelden</a>.',
        'APPLY_THIS_INFO_TO_PHOTOS' => 'Diese Werte für alle folgenden Fotos verwenden',
        'APPLY_TO_PHOTOS_ADDED_BY' => 'Auf alle von %s hinzugefügte Fotos anwenden',
        'APPLY_TO_VIDEOS_ADDED_BY' => 'Auf alle von %s hinzugefügten Videos anwenden',
        'APPLY_XS_THEME' => 'Design von %s anwenden',
        'APPNAME_HAS_NEW_PROFILE_QUESTIONS' => '%s hat <a %s>neue Profil-Fragen</a>',
        'APPNAME_NOW_HAS_FORUM' => '%s hat jetzt ein <a %s>Forum</a>',
        'APPNAME_NOW_HAS_GROUPS' => '%s hat jetzt <a %s>Gruppen</a>',
        'APPNAME_NOW_HAS_MUSIC' => '%s hat jetzt einen Musik-Player',
        'APPNAME_NOW_HAS_PHOTO' => '%s hat jetzt <a %s>Fotos</a>',
        'APPNAME_NOW_HAS_VIDEO' => '%s hat jetzt <a %s>Videos</a>',
        'APPROVAL' => 'Kontrolle',
        'APPROVE' => 'Erlauben',
        'APPROVE_ALL' => 'Alle erlauben',
        'APPROVE_ALL_PHOTOS' => 'Alle Fotos erlauben?',
        'APPROVE_ALL_VIDEOS' => 'Alle Videos erlauben?',
        'APPROVE_COMMENT' => 'Kommentar erlauben',
        'APPROVE_MEMBERS_BEFORE_JOIN' => 'Kontrollieren wer neues Mitglied wird',
        'APPROVE_PHOTOS' => 'Fotos erlauben',
        'APPROVE_PHOTOS_VIDEOS' => 'Fotos und Videos vor dem Anzeigen kontrollieren',
        'APPROVE_VIDEOS' => 'Videos erlauben',
        'APPROVING' => 'Wird angewendet…',
        'APP_ICON' => 'Netzwerk Icon',
        'APRIL' => 'April',
        'ARE_YOU_SURE_APPROVE_ALL_PHOTOS' => 'Möchten Sie wirklich alle Fotos erlauben? Das kann einige Minuten dauern.',
        'ARE_YOU_SURE_APPROVE_ALL_VIDEOS' => 'Möchten Sie wirklich alle Videos erlauben? Das kann einige Minuten dauern.',
        'ARE_YOU_SURE_BAN_MEMBERS' => 'Möchten Sie die ausgewählten Mitglieder wirklich aus Ihrem Netzwerk ausschließen? Das kann einige Minuten dauern.',
        'ARE_YOU_SURE_BAN_MEMBERS_AND_CONTENT' => 'Möchten Sie die ausgewählten Mitglieder wirklich aus Ihrem Netzwerk ausschließen und deren hinzugefügte Inhalte löschen? Das kann einige Minuten dauern.',
        'ARE_YOU_SURE_BAN_MEMBER_FROM_GROUP' => 'Möchten Sie die ausgewählten Mitglieder wirklich aus Ihrer Gruppe ausschließen ? Das kann einige Minuten dauern.',
        'ARE_YOU_SURE_BAN_X_AND_CONTENT' => 'Möchten Sie %1$s wirklich aus Ihrem Netzwerk ausschließen und alle von %1$s hinzugefügten Inhalte löschen? Das kann einige Minuten dauern.',
        'ARE_YOU_SURE_DELETE_ALL_PHOTOS' => 'Möchten Sie wirklich alle nicht erlaubten Fotos löschen? Das kann einige Minuten dauern.',
        'ARE_YOU_SURE_DELETE_ALL_VIDEOS' => 'Möchten Sie wirklich alle nicht erlaubten Videos löschen? Das kann einige Minuten dauern.',
        'ARE_YOU_SURE_DELETE_ALL_XS_VIDEOS' => 'Möchten Sie wirklich alle Videos von %s löschen? Das kann einige Minuten dauern.',
        'ARE_YOU_SURE_DELETE_LANGUAGE' => 'Möchten Sie wirklich diese Sprache löschen?',
        'ARE_YOU_SURE_DELETE_THIS_BLOG_POST' => 'Möchten Sie diesen Blog-Beitrag wirklich löschen? Das kann einige Minuten dauern.',
        'ARE_YOU_SURE_DELETE_THIS_DISCUSSION' => 'Möchten Sie diese Diskussion (einschließlich aller Antworten) wirklich löschen? Das kann einige Minuten dauern.',
        'ARE_YOU_SURE_DELETE_THIS_PAGE' => 'Möchten Sie diese Seite (einschließlich aller Kommentare) wirklich löschen ? Das kann einige Minuten dauern.',
        'ARE_YOU_SURE_DELETE_THIS_PHOTO' => 'Möchten Sie dieses Foto wirklich löschen? Das kann einige Minuten dauern.',
        'ARE_YOU_SURE_DELETE_THIS_TRACK' => 'Möchten Sie diesen Song wirklich löschen ? Das kann einige Minuten dauern.',
        'ARE_YOU_SURE_DELETE_THIS_VIDEO' => 'Möchten Sie dieses Video wirklich löschen? Das kann einige Minuten dauern.',
        'ARE_YOU_SURE_LEAVE_X' => 'Möchten Sie %s wirklich verlassen und alle Ihre Inhalte löschen? Das kann einige Minuten dauern.',
        'ARTIST_SITE' => 'Website des Künstlers',
        'ATTACHMENTS' => 'Anlagen',
        'AT_SYMBOL_NOT_ALLOWED' => 'Bitte vergewissern Sie sich, dass das @-Symbol nicht der Anfang Ihrer E-Mail-Adresse ist.',
        'AT_TIME_ON_DATE_USERNAME_SAID' => 'Um %s am %s sagte %s…',
        'AUGUST' => 'August',
        'AUTO_FOLLOW_DISCUSSIONS_I_REPLY_TO' => 'Automatisch Diskussionen verfolgen, zu denen ich beigetragen habe',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_ELLIPSIS' => 'Ein gesperrtes Mitglied hat Ihnen eine Nachricht auf %s gesendet.',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_USERNAME_WRITES' => 'Ein gesperrtes Mitglied hat Ihnen eine Nachricht auf %1$ gesendet. %2$s schreibt:',
        'A_BLOG_POST' => 'Ein Blog-Beitrag',
        'A_LIST_OF_MEMBERS' => 'Eine Liste der Mitglieder Ihres Netzwerks',
        'A_MESSAGE_FROM_USERNAME_TO_GROUPNAME_ON_APPNAME' => 'Eine Nachricht von %s an alle Mitglieder von %s auf %s!',
        'A_PROBLEM_OCCURRED' => 'Ein Problem ist aufgetreten.',
        'A_PROBLEM_SEEMS' => 'Es scheint ein Problem zu geben.',
        'A_THREADED_DISCUSSION_FORUM' => 'Forum mit Diskussionsfäden',
        'BACK' => 'Zurück',
        'BACKGROUND' => 'Hintergrund',
        'BACKGROUND_IMAGE_AND_COLOR' => 'Hintergrundbild & -farbe',
        'BACK_TO_GROUP' => '←Zurück zu %s',
        'BACK_TO_LANGUAGE_EDITOR' => '? Zurück zum Sprach-Editor',
        'BACK_TO_MY_PAGE' => '&#8592; Zurück zur persönlichen Seite',
        'BACK_TO_NETWORK_GROUPS' => 'Zurück zu %s Gruppen',
        'BACK_TO_USERNAMES_PAGE' => '&#8592; Zurück zur persönlichen Seite von %s',
        'BADGES' => 'Abzeichen',
        'BADGES_AND_WIDGETS' => 'Abzeichen & Widgets',
        'BAN' => 'Ausschließen',
        'BANNED' => 'Ausgeschlossen',
        'BAN_FROM_GROUP' => 'Von der Gruppe ausschließen',
        'BAN_FROM_NETWORK' => 'Vom Netzwerk ausschließen',
        'BAN_MEMBER_FROM_NETWORK' => 'Mitglied vom Netzwerk ausschließen',
        'BAN_USERNAME' => '%s ausschließen?',
        'BASED_ON' => 'Basierend auf',
        'BAZEL_IS_BEING_SET_UP' => 'Dieses Netzwerk befindet sich noch im Aufbau!',
        'BELOW_IS_LIST_OF_WIDGET' => 'Unten finden Sie eine <a %s>Liste von Widget-Anbietern</a>. Für den Anfang haben wir einige Widgets von <a %s>yourminis.com</a> ausgesucht. Konfigurieren Sie einfach eines der Widgets, kopieren Sie den Einbettungscode und fügen Sie ihn direkt in das Textfeld ein.',
        'BE_NICE' => 'Copyright',
        'BLOCK' => 'blockieren',
        'BLOCKED' => 'Blockiert',
        'BLOG' => 'Blog',
        'BLOG_POST' => 'Blog-Beitrag',
        'BLOG_POSTS' => 'Blog-Beiträge',
        'BLOG_POSTS_FOR_M_Y' => 'Blog-Beiträge für %s %s',
        'BLOG_POST_BY_X' => 'Blog-Beitrag von %s',
        'BODY' => 'Textkörper',
        'BODY_TEXT' => 'Text auf der Seite',
        'BOX_WILL_NOT_SHOW_ACTIVITY' => 'Dieses Feld ist für andere erst sichtbar, wenn Sie mindestens ein Aktitivätselement ausgewählt haben.',
        'BOX_WILL_NOT_SHOW_BLOG_POST' => 'Dieses Feld ist für andere erst sichtbar, wenn Sie mindestens einen Blog-Beitrag ausgewählt haben.',
        'BOX_WILL_NOT_SHOW_DISCUSSION' => 'Dieses Feld ist für andere erst sichtbar, wenn Sie mindestens eine Diskussion ausgewählt haben.',
        'BOX_WILL_NOT_SHOW_FEED' => 'Dieses Feld ist für andere erst sichtbar, wenn mindestens ein Element ausgewählt haben.',
        'BOX_WILL_NOT_SHOW_GADGET' => 'Dieses Feld ist für andere erst sichtbar, wenn Sie ein Gadget ausgewählt haben.',
        'BOX_WILL_NOT_SHOW_GROUPS' => 'Dieses Feld ist für andere erst sichtbar, wenn Sie mindestens eine Gruppe ausgewählt haben.',
        'BOX_WILL_NOT_SHOW_MEMBERS' => 'Dieses Feld ist für andere erst sichtbar, wenn Sie mindestens eine Zeile gewählt haben.',
        'BOX_WILL_NOT_SHOW_TRACKS' => 'Dieses Feld ist für andere erst sichtbar, wenn ein Song oder Podcast zur Wiedergabe vorhanden ist.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_PHOTO' => 'Dieser Bereich ist für andere erst sichtbar, wenn Sie mindestens ein Foto ausgewählt haben.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_VIDEO' => 'Dieser Bereich ist für andere erst sichtbar, wenn Sie mindestens ein Video ausgewählt haben.',
        'BOX_WILL_NOT_SHOW_UNTIL_UPDATE_CONTENT' => 'Dieser Bereich ist für andere erst sichtbar, wenn Sie eigenen Inhalt eingefügt haben.',
        'BROADCAST_MESSAGE' => 'Nachricht an alle Mitglieder',
        'BROUGHT_TO_YOU_BY' => '%s erstellt von %s © %s',
        'BROWSE_FOR_FILE' => 'Nach Datei suchen',
        'BROWSING' => 'Blättern',
        'BUG' => 'Fehler',
        'BY_ME' => 'Von <a %s>Mir</a>',
        'BY_PHONE_OR_EMAIL' => '…per Mobiltelefon oder E-Mail',
        'BY_SIGNING_UP_YOU_AGREE' => 'Mit Ihrer Registrierung erklären Sie sich einverstanden mit den <a %s>AGBs</a> und der <a %s>Datenschutzrichtlinie</a>.',
        'BY_X' => 'von %s',
        'CALENDAR' => 'Kalender',
        'CALENDAR_WIDGET_ALLOWS_SEARCH' => 'Das Kalender-Widget zeigt nicht nur das Datum an, sondern erlaubt auch die Suche nach und das Hinzufügen von Ereignissen im iCal-Format (wird vom Google Kalender und vielen anderen Anbietern von Online-Kalendern verwendet).',
        'CANCEL' => 'Abbrechen',
        'CANCEL_AND_RETURN_TO_PHOTO' => 'Abbrechen und zum Foto zurückkehren',
        'CANCEL_AND_RETURN_TO_PLAYLIST' => '« Abbrechen und zur Wiedergabeliste zurückkehren',
        'CANCEL_AND_RETURN_TO_VIDEO' => 'Abbrechen und zum Video zurückkehren',
        'CANCEL_INVITATION' => 'Einladung widerrufen',
        'CANNOT_OPEN_ERROR_LOG' => 'Fehlerprotokoll kann nicht geöffnet werden',
        'CANNOT_READ_ERROR_LOG' => 'Fehlerprotokoll kann nicht gelesen werden',
        'CANNOT_READ_VCARDS' => 'Leider konnten diese vCards nicht gelesen werden.',
        'CANNOT_SCAN_ERROR_LOG' => 'Fehlerprotokoll kann nicht durchsucht werden',
        'CAN_BE_VIEWED_BY' => 'Foto ist sichtbar für:',
        'CAN_PICK_MORE' => 'Mehr als eine Antwort möglich',
        'CATEGORIES' => 'Kategorien',
        'CATEGORY' => 'Kategorie:',
        'CATEGORY_TITLE' => 'Titel der Kategorie',
        'CC_BY_NC_ND_X' => 'Creative Commons Namensnennung, Keine kommerzielle Nutzung, Keine Bearbeitung %s',
        'CC_BY_NC_SA_X' => 'Creative Commons Namensnennung Keine kommerzielle Nutzung, Weitergabe unter gleichen Bedingungen %s',
        'CC_BY_NC_X' => 'Creative Commons: Namensnennung, Keine kommerzielle Nutzung %s',
        'CC_BY_ND_X' => 'Creative Commons: Namensnennung, Keine Bearbeitung %s',
        'CC_BY_SA_X' => 'Creative Commons Namensnennung, Weitergabe unter gleichen Bedingungen %s',
        'CC_BY_X' => 'Creative Commons: Namensnennung %s',
        'CHANGE' => 'ändern',
        'CHANGE_ADDRESS' => 'Adresse ändern',
        'CHANGE_MY_PHOTO' => 'Mein Foto ändern',
        'CHANGE_PAGE_ADDRESS' => 'Adresse der Seite ändern',
        'CHANGE_PASSWORD' => 'Passwort ändern',
        'CHANGE_SIZE' => 'Größe ändern',
        'CHECK' => 'Wählen',
        'CHECK_OUT_THIS_X_ON_Y_ELLIPSIS' => 'Werfen Sie doch mal einen Blick auf diese(s) %1$s auf %2$s an…',
        'CHECK_OUT_TITLE_ON_APPNAME' => 'Werfen Sie doch mal einen Blick auf "%s" auf %s!',
        'CHECK_OUT_X_ON_Y_ELLIPSIS' => 'Werfen Sie doch mal einen Blick auf "%1$s" auf %2$s …',
        'CHOICES' => 'Auswahlmöglichkeiten',
        'CHOOSE_A_THEME' => 'Wählen Sie ein Design für Ihr Netzwerk',
        'CHOOSE_A_THEME_FOR_PAGE' => 'Wählen Sie ein Design für Ihre persönliche Seite',
        'CHOOSE_DATE_AND_TIME' => 'Wählen Sie Datum und Uhrzeit (liegt der Zeitpunkt in der Zukunft, dann wird Ihr Beitrag erst zu diesem Zeitpunkt veröffentlicht).',
        'CHOOSE_FRIENDS' => 'Freunde auswählen‚…',
        'CHOOSE_FROM' => 'Auswählen aus:',
        'CHOOSE_GADGETS' => 'Wählen Sie eines dieser großartigen OpenSocial Gadgets, und fügen Sie es zu Ihrer persönlichen Seite hinzu! Sie können <a %s>Gadgets hier ansehen und bewerten</a> und <a %s>hier mehr über OpenSocial erfahren</a>.',
        'CHOOSE_HEADER_OR_WATERMARK' => 'Sie können einen Titel oder ein Wasserzeichen für Ihren Video-Player wählen.',
        'CHOOSE_MUSIC_TRACKS' => 'Songs zum Hinzuzufügen auswählen',
        'CHOOSE_NEW_PASSWORD' => 'Bitte wählen Sie ein neues Passwort.',
        'CHOOSE_PHOTOS' => 'Fotos auswählen',
        'CHOOSE_SHORTER_NAME' => 'Bitte wählen Sie einen kürzeren Namen.',
        'CHOOSE_SHORTER_PASSWORD' => 'Bitte wählen Sie ein kürzeres Passwort.',
        'CHOOSE_WHO_CAN_SEE_JOIN_AND_CONTRIBUTE' => 'Bestimmen Sie, wer Ihr Netzwerk ansehen, ihm beitreten und an ihm mitarbeiten kann.',
        'CITY' => 'Ort',
        'CITY_NAME_MUST_BE_SHORTER' => 'Der Ortsname muss kürzer als %s Buchstaben sein',
        'CLEAR' => 'Löschen',
        'CLEAR_CONTENTS' => 'Inhalte löschen',
        'CLICK_EDIT_AND_CHANGE_SETTINGS' => 'Klicken Sie auf "Bearbeiten" und ändern Sie die Einstellungen, wenn Sie möchten, dass dieses Feld für andere sichtbar ist.',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Klicken Sie auf "Bearbeiten", um Text, HTML, Videos, Fotos oder <a %1$s>Widgets von Drittanbietern</a> zu diesem Feld hinzuzufügen.',
        'CLICK_EDIT_TO_SPECIFY_FEED' => 'Bitte klicken Sie auf "Bearbeiten", um den RSS-Feed für dieses Feld festzulegen.',
        'CLICK_EDIT_TO_SPECIFY_GADGET_OR_VISIT_GADGET_GALLERY' => 'Klicken Sie auf "Bearbeiten", um die URL für das Gadget für dieses Feld festzulegen, oder besuchen Sie das <a %s>Gadget-Verzeichnis</a>.',
        'CLICK_GO_TO_START_EXPORT' => 'Klicken Sie auf "Start", um den Export zu starten. Falls Ihr Netzwerk viele Mitglieder hat, kann der Export einige Minuten dauern.',
        'CLICK_HERE' => 'Hier klicken',
        'CLICK_HERE_TO_ADD_LATEST_ACTIVITY' => 'Klicken Sie hier, um letzte Aktivitäten zu Ihrem Netzwerk hinzuzufügen.',
        'CLICK_HERE_TO_CONTINUE_TO_FLICKR' => 'Klicken Sie hier, um zu Flickr weitergeleitet zu werden',
        'CLICK_HERE_TO_GET_A_NEW_UNIQUE' => 'Klicken Sie hier, um eine neue E-Mail-Adresse zu erhalten',
        'CLICK_HERE_TO_JOIN' => 'Klicken Sie hier, um Mitglied zu werden:',
        'CLICK_HERE_TO_JOIN_BANG' => 'Klicken Sie hier, um Mitglied zu werden!',
        'CLICK_HERE_TO_JOIN_COLON' => 'Klicken Sie hier, um Mitglied zu werden:',
        'CLICK_HERE_TO_RESET_PASSWORD' => 'Klicken Sie hier, um Ihr Passwort zurückzusetzen.',
        'CLICK_HERE_TO_SIGN_IN_WITH_YOUR_NEW_EMAIL_ADDRESS' => 'Klicken Sie hier, um sich mit Ihrer neuen E-Mail-Adresse anzumelden:',
        'CLICK_ON_LOCATION' => 'Wählen Sie einen Ort auf der Karte:',
        'CLICK_TO_ACCEPT_FRIENDS' => 'Klicken Sie hier, um Ihre Freund-Anfragen zu sehen.',
        'CLICK_TO_ADD_A_DESCRIPTION' => 'Klicken Sie hier, um eine Beschreibung hinzufügen',
        'CLICK_TO_ADD_A_TITLE' => 'Klicken Sie hier, um einen Titel hinzuzufügen.',
        'CLICK_TO_MAIL' => '<a %s>Zum Senden der E-Mail hier klicken</a>.',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Die Mitgliederdaten Ihres Netzwerks wurden exportiert. Klicken Sie mit der rechten Maustaste auf <a %s>diesen Link</a> und wählen Sie "Speichern unter", um die Daten auf Ihrem Desktop zu speichern.',
        'CLICK_TO_VIEW' => 'Zum Ansehen hier klicken',
        'CLOSE' => 'Schließen',
        'CLOSE_DISCUSSION' => 'Diskussion schließen',
        'CLOSING_DISCUSSION_PREVENTS' => 'Das Schließen von Diskussionen verhindert weitere Antworten',
        'COLLECTED_BY_X' => 'Gesammelt von %s',
        'COLOR' => 'Farbe',
        'COME_JOIN_ME_ON_X' => 'Schließen Sie sich uns doch an auf %s.',
        'COME_JOIN_ME_ON_X_ELLIPSIS' => 'Schließen Sie sich uns doch an auf %s…',
        'COME_JOIN_ME_ON_X_ON_Y' => 'Schließen Sie sich uns doch an in %1$s auf %2$s.',
        'COME_JOIN_ME_ON_X_ON_Y_ELLIPSIS' => 'Schließen Sie sich uns doch an in %1$s auf %2$s…',
        'COMMENT' => 'Kommentar',
        'COMMENTER' => 'Kommentiert von',
        'COMMENTS' => 'Kommentare',
        'COMMENTS_ARE_CLOSED' => 'Kommentare für diesen Blog-Beitrag sind geschlossen',
        'COMMENTS_COLON' => 'Kommentare:',
        'COMMENTS_POSTED_ON_BLOG' => 'Kommentare in meinem Blog',
        'COMMENT_BACK' => 'Zurück kommentieren',
        'COMMENT_FOR' => 'Kommentar für:',
        'COMMENT_MODERATION' => 'Moderation der Kommentare',
        'COMMENT_ON' => 'Kommentar zu:',
        'COMMENT_THREAD' => 'Kommentare',
        'COMMENT_WALL' => 'Kommentare',
        'COMPLETE' => 'fertig',
        'COMPLETE_SETUP' => 'Einrichtung fertigstellen',
        'COMPOSE_MESSAGE' => 'Nachricht verfassen',
        'CONFIRM_PASSWORD' => 'Passwort bestätigen',
        'CONGRATULATIONS' => 'Glückwunsch',
        'CONGRATULATIONS_BANG_YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED' => 'Glückwunsch! Sie wurden als neues Mitglied in %s aufgenommen.',
        'CONTENT_ACTIVITY' => 'Aktivität bei Inhalten',
        'CONTENT_AWAITING_APPROVAL' => 'Zu kontrollieren',
        'CONTINUE_ARROW' => 'Weiter →',
        'CONTINUE_READING' => 'Weiterlesen…',
        'CONTRIBUTE' => 'Machen Sie mit.',
        'CONTRIBUTE_TO_DISCUSSIONS' => 'An Diskussionen teilnehmen',
        'CONTRIBUTORS' => 'Mitwirkende',
        'CONTROL_MANAGE_PAGE' => '<strong>Kontrolle.</strong> Die <a %s>Verwaltungsseite</a> beinhaltet eine Vielzahl von Konfigurationsoptionen.',
        'CONVERSION_FAILED' => 'Konvertierung fehlgeschlagen',
        'CONVERSION_IN_PROGRESS' => 'Konvertierung läuft',
        'COOL' => 'Cool',
        'COPIED_TO_CLIPBOARD' => 'In die Zwischenablage kopiert!',
        'COPYRIGHT' => '© Alle Rechte vorbehalten',
        'COPY_AND_PASTE_LINK' => 'Kopieren Sie diesen Link und fügen Sie ihn in eine E-Mail oder Sofortnachricht ein:',
        'COPY_AND_PASTE_SLIDESHOW' => 'Kopieren Sie den unten stehenden Einbettungscode für eine Diashow dieser Fotos, und fügen Sie ihn auf Ihrer Website, MySpace-Seite oder anderen Ning-Netzwerken ein.',
        'COPY_AND_PASTE_SLIDESHOW_OF_ALBUM' => 'Kopieren Sie den unten stehenden Einbettungscode für eine Diashow dieses Albums, und fügen Sie ihn auf Ihrer Website, MySpace-Seite oder anderen Ning-Netzwerken ein.',
        'COPY_TO_CLIPBOARD' => 'In die Zwischenablage kopieren',
        'COULD_NOT_FIND_ITEMS_MATCHING' => 'Wir bitten um Entschuldigung - wir konnten keine zu <em>%s</em> passenden Elemente finden. <a %s>Alle Elemente anzeigen.</a>',
        'COUNTDOWN' => 'Countdown',
        'COUNTDOWN_WIDGET_LETS_YOU' => 'Das Countdown-Widget ermöglicht die Erstellung eines Countdowns für ein bestimmtes Ereignis. Klicken Sie auf &#8220;Widget bearbeiten&#8221;, um Datum und Zeit, Titel oder Bild eines Ereignisses einzugeben.',
        'COUNTRY' => 'Land',
        'COUNTRY_AD' => 'Andorra',
        'COUNTRY_AE' => 'Vereinigte Arabische Emirate',
        'COUNTRY_AF' => 'Afghanistan',
        'COUNTRY_AG' => 'Antigua und Barbuda',
        'COUNTRY_AI' => 'Anguilla',
        'COUNTRY_AL' => 'Albanien',
        'COUNTRY_AM' => 'Armenien',
        'COUNTRY_AN' => 'Niederländische Antillen',
        'COUNTRY_AO' => 'Angola',
        'COUNTRY_AQ' => 'Antarktis',
        'COUNTRY_AR' => 'Argentinien',
        'COUNTRY_AS' => 'Amerikanisch-Samoa',
        'COUNTRY_AT' => 'Österreich',
        'COUNTRY_AU' => 'Australien',
        'COUNTRY_AW' => 'Aruba',
        'COUNTRY_AX' => 'Aland Inseln',
        'COUNTRY_AZ' => 'Aserbaidschan',
        'COUNTRY_BA' => 'Bosnien-Herzegowina',
        'COUNTRY_BB' => 'Barbados',
        'COUNTRY_BD' => 'Bangladesh',
        'COUNTRY_BE' => 'Belgien',
        'COUNTRY_BF' => 'Burkina Faso',
        'COUNTRY_BG' => 'Bulgarien',
        'COUNTRY_BH' => 'Bahrain',
        'COUNTRY_BI' => 'Burundi',
        'COUNTRY_BJ' => 'Benin',
        'COUNTRY_BM' => 'Bermuda',
        'COUNTRY_BN' => 'Brunei Darussalam',
        'COUNTRY_BO' => 'Bolivien',
        'COUNTRY_BR' => 'Brasilien',
        'COUNTRY_BS' => 'Bahamas',
        'COUNTRY_BT' => 'Bhutan',
        'COUNTRY_BV' => 'Bouvetinsel',
        'COUNTRY_BW' => 'Botswana',
        'COUNTRY_BY' => 'Weißrussland',
        'COUNTRY_BZ' => 'Belize',
        'COUNTRY_CA' => 'Kanada',
        'COUNTRY_CC' => 'Kokosinseln',
        'COUNTRY_CD' => 'Kongo, Demokratische Republik',
        'COUNTRY_CF' => 'Zentralafrikanische Republik',
        'COUNTRY_CG' => 'Kongo, Republik',
        'COUNTRY_CH' => 'Schweiz',
        'COUNTRY_CI' => 'Elfenbeinküste',
        'COUNTRY_CK' => 'Cook Inseln',
        'COUNTRY_CL' => 'Chile',
        'COUNTRY_CM' => 'Kamerun',
        'COUNTRY_CN' => 'China',
        'COUNTRY_CO' => 'Kolumbien',
        'COUNTRY_COLON' => 'Land:',
        'COUNTRY_CR' => 'Costa Rica',
        'COUNTRY_CS' => 'Serbien und Montenegro',
        'COUNTRY_CU' => 'Kuba',
        'COUNTRY_CV' => 'Kap Verde',
        'COUNTRY_CX' => 'Weihnachtsinsel',
        'COUNTRY_CY' => 'Zypern',
        'COUNTRY_CZ' => 'Tschechische Republik',
        'COUNTRY_DE' => 'Deutschland',
        'COUNTRY_DJ' => 'Dschibuti',
        'COUNTRY_DK' => 'Dänemark',
        'COUNTRY_DM' => 'Dominica',
        'COUNTRY_DO' => 'Dominikanische Republik',
        'COUNTRY_DZ' => 'Algerien',
        'COUNTRY_EC' => 'Ecuador',
        'COUNTRY_EE' => 'Estland',
        'COUNTRY_EG' => 'Ägypten',
        'COUNTRY_EH' => 'West-Sahara',
        'COUNTRY_ER' => 'Eritrea',
        'COUNTRY_ES' => 'Spanien',
        'COUNTRY_ET' => 'Äthiopien',
        'COUNTRY_EU' => 'Europäische Union',
        'COUNTRY_FI' => 'Finnland',
        'COUNTRY_FJ' => 'Fidschi',
        'COUNTRY_FK' => 'Falklandinseln',
        'COUNTRY_FM' => 'Mikronesien, Föderierte Staaten von',
        'COUNTRY_FO' => 'Färöer',
        'COUNTRY_FR' => 'Frankreich',
        'COUNTRY_GA' => 'Gabun',
        'COUNTRY_GB' => 'Vereinigtes Königreich',
        'COUNTRY_GD' => 'Grenada',
        'COUNTRY_GE' => 'Georgien',
        'COUNTRY_GF' => 'Französisch-Guayana',
        'COUNTRY_GH' => 'Ghana',
        'COUNTRY_GI' => 'Gibraltar',
        'COUNTRY_GL' => 'Grönland',
        'COUNTRY_GM' => 'Gambia',
        'COUNTRY_GN' => 'Guinea',
        'COUNTRY_GP' => 'Guadeloupe',
        'COUNTRY_GQ' => 'Äquatorialguinea',
        'COUNTRY_GR' => 'Griechenland',
        'COUNTRY_GS' => 'Südgeorgien und die Südlichen Sandwichinseln',
        'COUNTRY_GT' => 'Guatemala',
        'COUNTRY_GU' => 'Guam',
        'COUNTRY_GW' => 'Guinea-Bissau',
        'COUNTRY_GY' => 'Guyana',
        'COUNTRY_HK' => 'Hongkong',
        'COUNTRY_HM' => 'Heard und McDonaldinseln',
        'COUNTRY_HN' => 'Honduras',
        'COUNTRY_HR' => 'Kroatien',
        'COUNTRY_HT' => 'Haiti',
        'COUNTRY_HU' => 'Ungarn',
        'COUNTRY_ID' => 'Indonesien',
        'COUNTRY_IE' => 'Irland',
        'COUNTRY_IL' => 'Israel',
        'COUNTRY_IN' => 'Indien',
        'COUNTRY_IO' => 'Britisches Territorium im Indischen Ozean',
        'COUNTRY_IQ' => 'Irak',
        'COUNTRY_IR' => 'Iran, Islamische Republik',
        'COUNTRY_IS' => 'Island',
        'COUNTRY_IT' => 'Italien',
        'COUNTRY_JM' => 'Jamaika',
        'COUNTRY_JO' => 'Jordanien',
        'COUNTRY_JP' => 'Japan',
        'COUNTRY_KE' => 'Kenia',
        'COUNTRY_KG' => 'Kirgisistan',
        'COUNTRY_KH' => 'Kambodscha',
        'COUNTRY_KI' => 'Kiribati',
        'COUNTRY_KM' => 'Komoren',
        'COUNTRY_KN' => 'St. Kitts und Nevis',
        'COUNTRY_KP' => 'Korea, Demokratische Volksrepublik',
        'COUNTRY_KR' => 'Korea, Republik',
        'COUNTRY_KW' => 'Kuwait',
        'COUNTRY_KY' => 'Kaiman-Inseln',
        'COUNTRY_KZ' => 'Kasachstan',
        'COUNTRY_LA' => 'Laos, Demokratische Volksrepublik',
        'COUNTRY_LB' => 'Libanon',
        'COUNTRY_LC' => 'St. Lucia',
        'COUNTRY_LI' => 'Liechtenstein',
        'COUNTRY_LK' => 'Sri Lanka',
        'COUNTRY_LR' => 'Liberia',
        'COUNTRY_LS' => 'Lesotho',
        'COUNTRY_LT' => 'Litauen',
        'COUNTRY_LU' => 'Luxemburg',
        'COUNTRY_LV' => 'Lettland',
        'COUNTRY_LY' => 'Libysch-Arabische Dschamahirija',
        'COUNTRY_MA' => 'Marokko',
        'COUNTRY_MC' => 'Monaco',
        'COUNTRY_MD' => 'Moldau, Republik',
        'COUNTRY_MG' => 'Madagaskar',
        'COUNTRY_MH' => 'Marshallinseln, Republik',
        'COUNTRY_MK' => 'Mazedonien, Ehemalige Jugoslawische Republik',
        'COUNTRY_ML' => 'Mali',
        'COUNTRY_MM' => 'Myanmar',
        'COUNTRY_MN' => 'Mongolei',
        'COUNTRY_MO' => 'Macao',
        'COUNTRY_MP' => 'Nördliche Marianen',
        'COUNTRY_MQ' => 'Martinique',
        'COUNTRY_MR' => 'Mauretanien',
        'COUNTRY_MS' => 'Montserrat',
        'COUNTRY_MT' => 'Malta',
        'COUNTRY_MU' => 'Mauritius',
        'COUNTRY_MV' => 'Malediven',
        'COUNTRY_MW' => 'Malawi',
        'COUNTRY_MX' => 'Mexiko',
        'COUNTRY_MY' => 'Malaysien',
        'COUNTRY_MZ' => 'Mosambik',
        'COUNTRY_NA' => 'Namibia',
        'COUNTRY_NC' => 'Neukaledonien',
        'COUNTRY_NE' => 'Niger',
        'COUNTRY_NF' => 'Norfolkinsel',
        'COUNTRY_NG' => 'Nigeria',
        'COUNTRY_NI' => 'Nicaragua',
        'COUNTRY_NL' => 'Niederlande',
        'COUNTRY_NO' => 'Norwegen',
        'COUNTRY_NP' => 'Nepal',
        'COUNTRY_NR' => 'Nauru',
        'COUNTRY_NU' => 'Niue',
        'COUNTRY_NZ' => 'Neuseeland',
        'COUNTRY_OM' => 'Oman',
        'COUNTRY_PA' => 'Panama',
        'COUNTRY_PE' => 'Peru',
        'COUNTRY_PF' => 'Französisch-Polynesien',
        'COUNTRY_PG' => 'Papua-Neuguinea',
        'COUNTRY_PH' => 'Philippinen',
        'COUNTRY_PK' => 'Pakistan',
        'COUNTRY_PL' => 'Polen',
        'COUNTRY_PM' => 'Saint-Pierre und Miquelon',
        'COUNTRY_PN' => 'Pitcairn',
        'COUNTRY_PR' => 'Puerto Rico',
        'COUNTRY_PS' => 'Palästinensische Autonomiegebiete',
        'COUNTRY_PT' => 'Portugal',
        'COUNTRY_PW' => 'Palau',
        'COUNTRY_PY' => 'Paraguay',
        'COUNTRY_QA' => 'Katar',
        'COUNTRY_RE' => 'Réunion',
        'COUNTRY_RO' => 'Rumänien',
        'COUNTRY_RU' => 'Russische Föderation',
        'COUNTRY_RW' => 'Ruanda',
        'COUNTRY_SA' => 'Saudi-Arabien',
        'COUNTRY_SB' => 'Salomonen',
        'COUNTRY_SC' => 'Seychellen',
        'COUNTRY_SD' => 'Sudan',
        'COUNTRY_SE' => 'Schweden',
        'COUNTRY_SG' => 'Singapur',
        'COUNTRY_SH' => 'St. Helena',
        'COUNTRY_SI' => 'Slowenien',
        'COUNTRY_SJ' => 'Svalbard und Jan Mayen',
        'COUNTRY_SK' => 'Slowakei',
        'COUNTRY_SL' => 'Sierra Leone',
        'COUNTRY_SM' => 'San Marino',
        'COUNTRY_SN' => 'Senegal',
        'COUNTRY_SO' => 'Somalia',
        'COUNTRY_SR' => 'Suriname',
        'COUNTRY_ST' => 'Sao Tome und Principe',
        'COUNTRY_SV' => 'El Salvador',
        'COUNTRY_SY' => 'Syrien, Arabische Republik',
        'COUNTRY_SZ' => 'Swasiland',
        'COUNTRY_TC' => 'Turks- und Caicosinseln',
        'COUNTRY_TD' => 'Tschad',
        'COUNTRY_TF' => 'Französische Gebiete im südlichen Indischen Ozean',
        'COUNTRY_TG' => 'Togo',
        'COUNTRY_TH' => 'Thailand',
        'COUNTRY_TJ' => 'Tadschikistan',
        'COUNTRY_TK' => 'Tokelau',
        'COUNTRY_TL' => 'Osttimor',
        'COUNTRY_TM' => 'Turkmenistan',
        'COUNTRY_TN' => 'Tunesien',
        'COUNTRY_TO' => 'Tonga, Königreich',
        'COUNTRY_TR' => 'Türkei',
        'COUNTRY_TT' => 'Trinidad und Tobago',
        'COUNTRY_TV' => 'Tuvalu',
        'COUNTRY_TW' => 'Taiwan',
        'COUNTRY_TZ' => 'Tansania, Vereinigte Republik',
        'COUNTRY_UA' => 'Ukraine',
        'COUNTRY_UG' => 'Uganda',
        'COUNTRY_UM' => 'Kleinere Inselbesitzungen der Vereinigten Staaten',
        'COUNTRY_US' => 'Vereinigte Staaten',
        'COUNTRY_UY' => 'Uruguay',
        'COUNTRY_UZ' => 'Usbekistan',
        'COUNTRY_VA' => 'Vatikanstadt',
        'COUNTRY_VC' => 'St. Vincent und die Grenadinen',
        'COUNTRY_VE' => 'Venezuela',
        'COUNTRY_VG' => 'Britische Jungferninseln',
        'COUNTRY_VI' => 'Amerikanische Jungferninseln',
        'COUNTRY_VN' => 'Vietnam',
        'COUNTRY_VU' => 'Vanuatu',
        'COUNTRY_WF' => 'Wallis und Futuna',
        'COUNTRY_WS' => 'Samoa',
        'COUNTRY_YE' => 'Jemen',
        'COUNTRY_YT' => 'Mayotte',
        'COUNTRY_ZA' => 'Südafrika',
        'COUNTRY_ZM' => 'Sambia',
        'COUNTRY_ZW' => 'Simbabwe',
        'CREATE' => 'Erstellen',
        'CREATED_BY' => 'Erstellt von',
        'CREATED_BY_COLON' => 'Erstellt von:',
        'CREATED_BY_ME' => 'Erstellt von <a %s>mir</a>',
        'CREATED_BY_X' => 'Erstellt von %s',
        'CREATED_THIS_SOCIAL_NETWORK' => 'hat dieses soziale Netzwerk auf <a href="http://www.ning.com">Ning</a> ins Leben gerufen.',
        'CREATE_ACCOUNT_OR_JOIN' => '<a %s> Klicken Sie hier, um ein neues Benutzerkonto zu erstellen </a>oder melden Sie sich unten mit Ihrer Ning-ID an.',
        'CREATE_ACCOUNT_OR_SIGN_IN' => '<a %s>Klicken Sie hier, um ein neues Benutzerkonto zu erstellen</a> oder melden Sie sich unten an.',
        'CREATE_ANOTHER_NETWORK' => 'Ein weiteres Netzwerk erstellen',
        'CREATE_AN_ALBUM' => 'Ein Album erstellen',
        'CREATE_A_GROUP' => 'Eine Gruppe erstellen',
        'CREATE_A_NEW_GROUP' => 'Eine neue Gruppe erstellen',
        'CREATE_A_PAGE' => 'Eine Seite erstellen',
        'CREATE_GROUP' => 'Gruppe erstellen',
        'CREATE_GROUPS' => 'Gruppen erstellen',
        'CREATE_GROUPS_AND_SHARE' => 'Erstellen Sie Gruppen und lassen Sie Freunde, Familie und den Rest der Welt daran teilhaben!',
        'CREATE_INVITATION_LINK' => 'Neuen Einladungs-Link erstellen',
        'CREATE_NEW_BLOG_POST' => 'Neuen Blog-Beitrag erstellen!',
        'CREATE_NEW_GROUP' => 'Neue Gruppe erstellen',
        'CREATE_NEW_PAGE' => 'Neue Seite erstellen',
        'CREATE_NEW_PASSWORD' => 'Neues Passwort erstellen',
        'CREATE_NEW_TRANSLATION' => 'Neue Übersetzung erstellen',
        'CREATE_PAGE' => 'Seite erstellen',
        'CREATE_YOUR_OWN' => 'Gründen Sie Ihr eigenes soziales Netzwerk auf Ning!',
        'CREATE_YOUR_PROFILE' => 'Profil erstellen',
        'CREATING_LINK_WILL_DISABLE' => 'Durch Erstellen eines neuen Einladungs-Links wird der derzeitige Link deaktiviert. Möchten Sie wirklich einen neuen Link erstellen?',
        'CSS_ON_YOUR_PAGE' => 'CSS auf Ihrer persönlichen Seite',
        'CSS_ON_YOUR_SOCIAL_NETWORK' => 'CSS in Ihrem Netzwerk',
        'CSS_STYLES_WILL_OVERRIDE' => 'Die CSS-Formatvorlagen, die Sie hier hinzufügen, überschreiben die CSS-Formatvorlagen, die Sie eventuell zuvor gewählt hatten.',
        'CSV_IMPORT_UNAVAILABLE' => 'Leider ist der CSV-Import gegenwärtig nicht verfügbar.',
        'CURRENT_LANGUAGE_OPTIONS' => 'Verfügbare Sprachen',
        'CURRENT_PASSWORD' => 'Aktuelles Passwort',
        'CUSTOMIZATION' => 'Anpassung',
        'CUSTOMIZE' => 'Anpassen',
        'CUSTOMIZE_APPEARANCE_BADGES' => '<strong>Anpassen.</strong> ändern Sie das <a %1$s>Erscheinungsbild des Netzwerks</a>, und entwerfen Sie <a %2$s>Abzeichen und Widgets</a>.',
        'CUSTOMIZE_EMBED_INSTRUCTIONS' => 'Das Logo erscheint oben auf Ihrem %s. Wenn Sie kein Logo hinzufügen, wird stattdessen der Name des Netzwerks angezeigt. Ihr Logo sollte im .jpg, .gif oder .png Format sein. Logos, die größer als 20 Pixel sind, werden automatisch verkleinert.',
        'CUSTOMIZE_SITE_BY_ADDING' => 'Passen Sie Ihr Netzwerk an durch Hinzufügen von neuen Funktionen oder Entfernen bestehender Funktionen.',
        'CUSTOMIZE_TEXT_ON_NETWORK_INCLUDING' => 'Passen Sie den Text Ihres Netzwerks an, einschließlich der Namen der Reiter, E-Mail-Fußzeilen, Fehlermeldungen u.a.',
        'CUSTOMIZE_THE_APPEARANCE_NETWORK' => 'Passen Sie das Erscheinungsbild Ihres Netzwerks an, indem Sie Ihre eigenen CSS-Formatvorlage im Feld links hinzufügen. (<a href="%s">Was ist CSS?</a>)',
        'CUSTOMIZE_THE_APPEARANCE_PAGE' => 'Passen Sie das Erscheinungsbild Ihrer persönlichen Seite an, indem Sie Ihre eigenen CSS-Formatvorlage im Feld links hinzufügen. (<a href="%s">Was ist CSS?</a>)',
        'CUSTOMIZE_WATERMARK_INSTRUCTIONS' => 'Das Wasserzeichen erscheint oberhalb der rechten unteren Ecke des Videos.',
        'CUSTOMIZE_WIDGETS_AND_BADGES' => 'Ändern Sie das Aussehen der Widgets und des Abzeichens Ihres Netzwerks.',
        'CUSTOMIZE_YOUR_BADGES_AND_WIDGETS' => 'Ändern Sie die Farben und Bilder Ihrer Abzeichen und Widgets. Es kann bis zu 4 Stunden dauern, bis Ihre Änderungen auf anderen Websites sichtbar sind.',
        'CUSTOMIZE_YOUR_NETWORKS_TEXT' => 'Ändern Sie Text und Nachrichten Ihres Netzwerks oder erstellen Sie eine neue Übersetzung.',
        'CUSTOMIZE_YOUR_SLIDESHOW_PLAYER' => 'Passen Sie Ihren Diashow-Player an!',
        'CUSTOMIZE_YOUR_VIDEO_PLAYER' => 'Passen Sie Ihren Video-Player an!',
        'CUSTOM_TEXT' => 'Eigener Text',
        'DATE' => 'Datum',
        'DATE_APPLIED' => 'Mitgliedschaft beantragt am',
        'DATE_BANNED' => 'Gesperrt am',
        'DATE_COLON' => 'Datum:',
        'DATE_INVITED' => 'Eingeladen am',
        'DATE_JOINED' => 'Mitglied seit',
        'DATE_OF_BIRTH' => 'Geburtsdatum',
        'DATE_REQUESTED' => 'Mitgliedschaft beantragt am',
        'DAY' => 'Tag',
        'DECEMBER' => 'Dezember',
        'DECLINE' => 'Ablehnen',
        'DECLINE_MEMBERSHIP' => 'Mitgliedschaft ablehnen',
        'DEFAULT_DESCRIPTION' => 'Beschreibung',
        'DEFAULT_TITLE' => 'Titel',
        'DELETE' => 'Löschen',
        'DELETE_ACTIVITY_ITEM' => 'Aktivitätsnachricht entfernen',
        'DELETE_ALBUM' => 'Album löschen',
        'DELETE_ALL' => 'Alle löschen',
        'DELETE_ALL_PHOTOS' => 'Alle Fotos löschen?',
        'DELETE_ALL_VIDEOS' => 'Alle Videos löschen?',
        'DELETE_ALL_XS_VIDEOS' => 'Alle Videos von %s löschen',
        'DELETE_ALL_XS_VIDEOS_Q' => 'Alle Videos von %s löschen?',
        'DELETE_ATTACHMENT' => 'Anlage löschen',
        'DELETE_ATTACHMENT_Q' => 'Diese Anlage löschen?',
        'DELETE_BLOG_POST' => 'Beitrag löschen',
        'DELETE_COMMENT' => 'Kommentar löschen',
        'DELETE_DISCUSSION' => 'Diskussion löschen',
        'DELETE_GROUP' => 'Gruppe löschen',
        'DELETE_GROUP_Q' => 'Möchten Sie diese Gruppe wirklich löschen?',
        'DELETE_LANGUAGE' => 'Sprache löschen',
        'DELETE_PAGE' => 'Seite löschen',
        'DELETE_PHOTO' => 'Foto löschen',
        'DELETE_REPLY' => 'Antwort löschen',
        'DELETE_THIS_ACTIVITY_MESSAGE_Q' => 'Diese Aktivitätsnachricht entfernen?',
        'DELETE_THIS_ALBUM' => 'Dieses Album löschen?',
        'DELETE_THIS_BLOG_POST_Q' => 'Diesen Blog-Beitrag löschen?',
        'DELETE_THIS_DISCUSSION_Q' => 'Diese Diskussion löschen?',
        'DELETE_THIS_PAGE_Q' => 'Diese Seite löschen?',
        'DELETE_THIS_PHOTO_Q' => 'Dieses Foto löschen?',
        'DELETE_THIS_SITE' => 'Ihr Netzwerk löschen',
        'DELETE_THIS_TRACK_Q' => 'Diesen Song löschen?',
        'DELETE_THIS_VIDEO_Q' => 'Dieses Video löschen?',
        'DELETE_TRACK' => 'Song löschen',
        'DELETE_VIDEO' => 'Video löschen',
        'DELETING' => 'Löschen…',
        'DELETING_CONTENT' => 'Inhalt wird gelöscht…',
        'DEMOTE_FROM_ADMINISTRATOR' => 'Administrator-Rechte zurückziehen',
        'DESCRIBE_YOUR_ISSUE' => 'Beschreiben Sie das Problem',
        'DESCRIPTION' => 'Beschreibung',
        'DESCRIPTION_COLON' => 'Beschreibung:',
        'DETAIL' => 'Detail',
        'DETAIL_VIEW' => 'Detailansicht',
        'DID_YOU_KNOW' => 'Wussten Sie schon',
        'DISABLE_INVITATION_LINK' => 'Einladungs-Link deaktivieren?',
        'DISCUSSION' => 'Diskussion',
        'DISCUSSIONS' => 'Diskussionen',
        'DISCUSSIONS_I_REPLIED_TO' => 'Diskussionen, an denen ich teilgenommen habe',
        'DISCUSSIONS_I_STARTED' => 'Diskussionen, die ich gestartet habe',
        'DISCUSSIONS_MATCHING_X' => 'Diskussionen, die zu <em>\'%s\'</em> passen',
        'DISCUSSIONS_X_REPLIED_TO' => 'Diskussionen, auf denen %s teilgenommen hat',
        'DISCUSSIONS_X_STARTED' => 'Diskussionen, die %s gestartet hat',
        'DISCUSSION_DELETED' => 'Diskussion gelöscht',
        'DISCUSSION_HAS_BEEN_DELETED' => 'Diese Diskussion wurde gelöscht.',
        'DISCUSSION_TITLE' => 'Titel der Diskussion:',
        'DISPLAY_PREFERENCES' => 'Einstellungen anzeigen',
        'DISPLAY_SELECTION_OF_PHOTOS' => 'Zeigen Sie eine Auswahl Ihrer Fotos auf einer Website oder MySpace-Seite mit unserem schicken Diashow-Player.',
        'DONE' => 'Fertig',
        'DONT_DISPLAY_ANY_BRANDING' => 'Keine Titel oder Wasserzeichen anzeigen',
        'DONT_FEATURE' => 'Nicht vorstellen',
        'DONT_SEE_LANGUAGE_LISTED_CREATE' => 'Ist Ihre Sprache nicht aufgeführt? <strong><a %s>Erstellen Sie eine neue Übersetzung für Ihr Netzwerk</a></strong>.',
        'DONT_SHOW_THIS_AGAIN_FLICKR' => 'Bitte dies nicht mehr anzeigen.',
        'DONT_WORRY_WE_WONT_SAVE' => 'Keine Sorge, wir speichern Ihr Passwort nicht, und Sie bekommen auch die Gelegenheit zu entscheiden, welche Ihrer Freunde eine E-Mail bekommen sollen.',
        'DONT_WORRY_YOULL_GET_CHANCE' => 'Keine Sorge, Sie bekommen die Gelegenheit zu entscheiden, welche Ihrer Freunde eine E-Mail bekommen sollen.',
        'DOWNLOAD_ALL_MEMBER_DATA' => 'Alle Mitgliederdaten exportieren (. CSV)',
        'DOWNLOAD_X' => '%s herunterladen',
        'DO_NOT_DISPLAY' => 'Nicht anzeigen',
        'DO_NOT_EMAIL_ME_WHEN_PEOPLE_REPLY' => 'Keine E-Mail an mich senden, wenn jemand antwortet',
        'DO_NOT_EMAIL_WHEN_NEW_DISCUSSIONS' => 'Keine E-Mail an mich senden, wenn eine neuen Diskussionen gestartet wurde',
        'DO_YOU_HAVE_EXISTING_WEBSITE' => 'Haben Sie bereits woanders eine Gruppen-Website?',
        'DO_YOU_REALLY_WANT_TO_REMOVE' => 'Möchten Sie dies wirklich aus Ihren Favoriten entfernen?',
        'DRAFT_BRACKETS' => '[ Entwurf ]',
        'DRAFT_PARENTHESES' => '(Entwurf)',
        'DRAG' => 'Ziehen',
        'DRAG_ALBUM_COVER_HERE' => 'Albumcover hierher ziehen',
        'DRAG_HERE_TO_REMOVE_FEATURE' => 'Hierher ziehen, um diese Funktion zu entfernen',
        'DRAG_PHOTOS_HERE' => 'Fotos hierher ziehen',
        'DRAG_TO_CHANGE_ORDER_PLAYLIST' => 'Um Ihre Wiedergabeliste neu zu ordnen, klicken Sie auf den Song und ziehen Sie ihn an die gewünschte Stelle in der Wiedergabeliste.',
        'EACH_MP3_FILE_MAY_BE_UP_TO' => 'Sie können bis zu 100 MP3s hochladen! Jede MP3-Datei kann bis zu 20 MB groß sein, kleinere werden jedoch Dateien schneller hochgeladen.',
        'EACH_PHOTO_MAY_BE_UP_TO_10MB' => 'Jedes Foto darf bis zu 10 MB groß sein. Wir unterstūtzen Fotos in den Formaten .jpg, .gif und .png.',
        'EACH_VIDEO_MAY_BE_100MB' => 'Jedes Video darf bis zu 100 MB groß sein. Wir unterstūtzen Videos in den Formaten .mov, .mpg, .avi, .wmv und .3gp.',
        'EDIT' => 'Bearbeiten',
        'EDIT_2' => 'Bearbeiten',
        'EDIT_ALBUM' => 'Album bearbeiten',
        'EDIT_DISCUSSION' => 'Diskussion bearbeiten',
        'EDIT_EMAIL_ADDRESS' => 'E-Mail-Adresse bearbeiten',
        'EDIT_GROUP_INFO' => 'Informationen dieser Gruppe bearbeiten',
        'EDIT_GROUP_INFORMATION' => 'Gruppeninformationen bearbeiten',
        'EDIT_LANGUAGE_ON_NETWORK' => 'Die Sprache Ihres Netzwerks bearbeiten',
        'EDIT_PAGE_APPEARANCE' => 'Erscheinungsbild der Seite bearbeiten',
        'EDIT_PHOTO' => 'Foto bearbeiten',
        'EDIT_PHOTO_INFORMATION' => 'Fotoinformationen bearbeiten',
        'EDIT_PLAYLIST' => 'Wiedergabeliste bearbeiten',
        'EDIT_POST' => 'Beitrag bearbeiten',
        'EDIT_POST_COLON' => 'Beitrag bearbeiten:',
        'EDIT_QUESTIONS_THAT_MEMBERS_ANSWER' => 'Die persönlichen Fragen an die Mitglieder bearbeiten.',
        'EDIT_SOURCE_CODE' => 'Quellcode bearbeiten',
        'EDIT_THE_APPEARANCE' => 'Das Erscheinungsbild Ihrer persönlichen Seite bearbeiten',
        'EDIT_TRACK_INFORMATION' => 'Song-Informationen bearbeiten',
        'EDIT_VIDEO' => 'Video bearbeiten',
        'EDIT_VIDEO_INFORMATION' => 'Videoinformationen bearbeiten',
        'EDIT_YOUR_ALBUM' => 'Ihr Album bearbeiten',
        'EDIT_YOUR_NETWORKS_INFO' => 'Bearbeiten Sie den Name, die Beschreibung und andere Informationen Ihres Netzwerks.',
        'EDIT_YOUR_PAGE' => 'Ihre persönliche Seite bearbeiten',
        'ELLIPSIS_FROM_YOUR_COMPUTER' => '… von Ihrem Computer',
        'ELLIPSIS_OR_WRITE_YOUR_OWN_MESSAGE' => '… oder verfassen Sie Ihre eigene Nachricht',
        'ELLIP_FROM_ANOTHER_WEBSITE' => '… von einer anderen Website',
        'EMAIL' => 'E-Mail',
        'EMAIL_ADDRESS' => 'E-Mail-Adresse',
        'EMAIL_ALREADY_REGISTERED' => 'Diese E-Mail-Adresse ist schon registriert. Bitte benutzen Sie eine andere.',
        'EMAIL_COLON' => 'E-Mail:',
        'EMAIL_ME_WHEN_PEOPLE_REPLY' => 'E-Mail an mich senden, wenn jemand antwortet',
        'EMAIL_NOTIFICATIONS' => 'E-Mail Benachrichtigungen',
        'EMAIL_NOT_VALID' => 'Diese E-Mail-Adresse scheint ungültig zu sein.',
        'EMAIL_THIS' => 'Per E-Mail senden',
        'EMAIL_WHEN_NEW_DISCUSSIONS' => 'E-Mail an mich senden, wenn eine neuen Diskussionen gestartet wurde',
        'EMBED' => 'Einbetten',
        'EMBED_CODE' => 'Einbettungscode',
        'ENABLE_DOWNLOAD_LINK' => 'Download-Link aktivieren',
        'ENABLE_MUSIC_DOWNLOAD_LINKS' => 'Den Download-Link im Musik Player aktivieren',
        'ENTER_EMAIL_ADDRESSES' => 'E-Mail-Adressen eingeben',
        'ENTER_EMAIL_AND_CLICK_RESET_PASSWORD' => 'Geben Sie Ihre E-Mail-Adresse ein und klicken Sie auf "Passwort zurücksetzen". Sie erhalten dann eine E-Mail mit einem Link, mit dem Sie Ihr Passwort zurücksetzen können.',
        'ENTER_NAME_FOR_TRANSLATION' => 'Bitte geben Sie einen Namen für Ihre neue Übersetzung ein, z.B. Portugiesisch (Portugal)',
        'ENTER_SHORTER_CITY_NAME' => 'Bitte wählen Sie einen kürzeren Namen für die Stadt.',
        'ENTER_THE_URL_MP3_TO_ADD' => 'Geben Sie die URL für jede MP3 Datei, die Sie hinzufügen möchten, ein:',
        'ENTRY' => 'Eintrag',
        'ENVIOUS' => 'Neidisch',
        'ERROR' => 'Fehler',
        'ERROR_LOG' => 'Fehlerprotokoll',
        'ERROR_MESSAGE' => 'Fehlermeldung:',
        'ERROR_OCCURRED' => 'Leider ist ein Fehler aufgetreten.',
        'ERROR_PROCESSING_SPECIAL_RULES' => 'Beim Verarbeiten der Sonderregeln der Sprache ist ein Fehler aufgetreten.',
        'ERROR_PROCESSING_TAB_NAMES' => 'Beim Verarbeiten des Namen für die Reiter in der Sprache ist ein Fehler aufgetreten.',
        'EVERYONE' => 'Jeder',
        'EVERYONES_PHOTOS' => 'Alle Fotos',
        'EVERYONES_POSTS' => 'Alle Blog-Beiträge',
        'EVERYONE_CAN_SEE_PHOTO' => 'Jeder darf dieses Foto sehen.',
        'EVERYTHING' => 'Alles',
        'EVERYTHING_IS_OPTIONAL' => 'Diese Eingaben sind optional; wenn Sie nichts hinzufügen möchten, klicken Sie einfach rechts auf "Diesen Schritt überspringen".',
        'EVIL' => 'Böse',
        'EXAMPLES_SWEDISH_FINLAND' => 'Beispiele: Schwedisch (Finnland), Philippinisch, Spanisch (Puerto Rico)',
        'EXAMPLES_TABS_MEMBERS_FRIENDS' => 'Beispiele: Reiter, Mitglieder, Freunde',
        'EXISTING_DISCUSSIONS' => 'Bestehende Diskussionen, die noch nicht einer Kategorie zugeordnet wurden.',
        'EXIT_FULLSCREEN' => 'Vollbildmodus verlassen',
        'EXPLICIT_LYRICS' => 'Eindeutige Songtexte',
        'EXPLORE' => 'Erkunden',
        'EXTERNAL_WEBSITE' => 'Externe Website',
        'FACEBOOK_ADD_DEVELOPER_BUTTON' => 'Schaltfläche für Entwickler hinzufügen',
        'FACEBOOK_ADD_THE' => 'Hinzufügen des',
        'FACEBOOK_API_INFO' => 'API Informationen',
        'FACEBOOK_API_INFO_DESC' => 'Um die Einrichtung abzuschließen, müssen Sie Ihren Facebook API-Schlüssel und die geheime Phrase sowie die URL Ihrer Facebook Applikation in die Felder unten eingeben.',
        'FACEBOOK_API_INFO_FIND_KEY' => 'Sie können den API-Schlüssel und die geheime Phrase auf der <a %s>Seite "My Applications" in Facebook finden</a> (der Link wird in einem neuen Fenster geöffnet) unter dem Titel der Facebook Applikation, die Sie gerade erstellt haben.',
        'FACEBOOK_API_INFO_KEY' => 'API-Schlüssel',
        'FACEBOOK_API_INFO_MY_APPLICATIONS_PAGE' => 'Seite "My Applications" (die Positionen der relevanten Informationen ist hervorgehoben)',
        'FACEBOOK_API_INFO_SECRET' => 'Geheime Phrase',
        'FACEBOOK_API_INFO_TITLE' => 'Facebook API Informationen',
        'FACEBOOK_BACK_TO_EMBEDDING' => 'Zurück zur Facebook-Integration Startseite',
        'FACEBOOK_CONFIRM_DISABLE' => 'Sind Sie sicher?',
        'FACEBOOK_DISABLE' => 'Diese Applikation deaktivieren',
        'FACEBOOK_EMBEDDING' => 'Facebook-Integration',
        'FACEBOOK_EMBEDDING_DESC' => 'Erlauben Sie Facebook-Benutzern, Widgets und das Abzeichen Ihres Netzwerks zu ihren Profilseiten hinzuzufügen.',
        'FACEBOOK_INSTR_APPLICATION_SETUP_PAGE' => 'Konfigurationsseite für die Facebook-Applikation',
        'FACEBOOK_INSTR_CLICK_HERE_TO_GO_TO_FACEBOOK' => 'Klicken Sie hier, um zu Facebook weitergeleitet zu werden und mit dem Erstellen Ihrer Applikation zu beginnen.',
        'FACEBOOK_INSTR_FIRST_STEPS' => 'Erste Schritte',
        'FACEBOOK_INSTR_FIRST_STEPS_1' => 'Falls Sie noch keine Applikationen auf Facebook erstellt haben, werden Sie dazu aufgefordert, die Facebook Entwickler-Anwendung "Developer" hinzuzufügen. Sobald Sie dies getan haben, wird Ihnen mitgeteilt, dass Sie keine Anwendungen haben ("You have no applications"). Klicken Sie auf <strong>"Create one" (Eine Applikation erstellen)</strong>.',
        'FACEBOOK_INSTR_FIRST_STEPS_2' => 'Falls Sie schon eine Applikation auf Facebook erstellt haben, werden Sie zur Facebook Entwickler-Anwendung weitergeleitet. Klicken Sie auf <strong>"Set Up New Application" (Neue Anwendung einrichten)</strong.',
        'FACEBOOK_INSTR_FIRST_STEPS_NEXT' => 'Nächster Schritt: Wie Sie Ihre %s Applikation so konfigurieren, dass sie reibungslos auf Facebook funktioniert.',
        'FACEBOOK_INSTR_OPEN_FACEBOOK_IN_NEW_WINDOW' => 'Hiermit wird Facebook in einem neuen Fenster geöffnet. Falls Sie noch nicht bei Facebook angemeldet sind, werden Sie dazu aufgefordert werden.',
        'FACEBOOK_INSTR_SETUP' => 'Konfigurationsanleitung',
        'FACEBOOK_INSTR_SETUP_1' => 'Sehr gut! Nun zu den Details. Facebook benötigt einige grundlegende Informationen, um Ihre Applikation einzurichten. Folgen Sie einfach den Schritten unten.',
        'FACEBOOK_INSTR_SETUP_10' => 'Geben Sie Ihre <em>Canvas-Seiten-URL</em> (wie in Schritt &#8216; f&#8217; oben erstellt) im Feld <strong>Side Nav URL (URL für das Seitenmenü)</strong> ein. Vergewissern Sie sich, dass der "http://apps.facebook.com/"-Teil der URL vorhanden ist.',
        'FACEBOOK_INSTR_SETUP_11' => 'Geben Sie Text für die <strong>Attachment action (Aktion für Anlagen)</strong> ein. Dieser Text wird angezeigt, wenn Sie jemandem eine Nachricht auf Facebook senden, die eine Ihrer Applikation enthalten soll. Handelt es sich um eine Diashow, können Sie z.B. "Fotos von &#8216;Netzwerkname&#8217;" eingeben. Analog könnten sie für einen Video-Player "Videos von &#8216;Netzwerkname&#8217;" verwenden.',
        'FACEBOOK_INSTR_SETUP_12' => 'Fügen Sie die folgende Webadresse in das Feld <strong>Callback URL</strong> ein:',
        'FACEBOOK_INSTR_SETUP_2' => 'Wählen Sie einen Namen für Ihre neue Applikation und geben Sie ihn in das Feld <strong>Application Name</strong> ein.',
        'FACEBOOK_INSTR_SETUP_3' => 'Selektieren Sie das Kästchen unterhalb des Feldes <strong>Application Name</strong>, um anzugeben, dass Sie die Nutzungsbedingungen von Facebook gelesen haben.',
        'FACEBOOK_INSTR_SETUP_4' => 'öffnen Sie den Abschnitt <em>Optional Fields (Optionale Felder)</em>.',
        'FACEBOOK_INSTR_SETUP_5' => 'Geben Sie Ihre E-Mail-Adresse im Feld <strong>Support-E-Mail</strong> ein.',
        'FACEBOOK_INSTR_SETUP_6' => 'Fügen Sie folgende Webadresse in das Feld <strong>Callback URL</strong> ein:',
        'FACEBOOK_INSTR_SETUP_7_EXAMPLE_X' => 'Geben Sie eine <strong>Canvas-Seiten-URL</strong> ein, z.B. <em>%s</em>.',
        'FACEBOOK_INSTR_SETUP_8' => 'Wählen Sie <strong>Yes</strong> auf die Frage <em>"Can your application be added on Facebook" (kann Ihre Applikation zu Facebook hinzugefügt werden)</em>.',
        'FACEBOOK_INSTR_SETUP_9' => 'Kopieren Sie den folgenden Text und fügen Sie in das Feld <strong>Default FBML</strong> ein:',
        'FACEBOOK_INSTR_SETUP_9B_NARROW' => 'Wählen Sie für <strong>Default Profile Box Column</strong> die Möglichkeit <strong>Narrow</strong>.',
        'FACEBOOK_INSTR_SETUP_9B_WIDE' => 'Wählen Sie für <strong>Default Profile Box Column</strong> die Möglichkeit <strong>Wide</strong>.',
        'FACEBOOK_INSTR_SETUP_APP_DESC' => 'Schreiben Sie eine <strong>Beschreibung der Applikation</strong>.',
        'FACEBOOK_INSTR_SETUP_APP_PERMISSION' => 'Wählen Sie <strong>Users</strong> und <strong>All Pages</strong>.',
        'FACEBOOK_INSTR_SETUP_BASE_OPT' => 'Grundlegende Einstellungen',
        'FACEBOOK_INSTR_SETUP_DONE' => 'Zum Schluss klicken Sie auf <strong>Submit</strong.',
        'FACEBOOK_INSTR_SETUP_INST_OPT' => 'Installationsoptionen',
        'FACEBOOK_INSTR_SETUP_NEXT' => 'Nächster Schritt: Ermitteln des Facebook API-Schlüssels und der geheimen Phrase.',
        'FACEBOOK_INSTR_SETUP_REQ_FIELDS' => 'Notwendige Felder',
        'FACEBOOK_MUSIC_BUTTON' => 'Musik Applikation erstellen &raquo;',
        'FACEBOOK_MUSIC_PLAYER_DESC' => 'Ermöglicht es Facebook Benutzern, einen Musik-Player für Musik von Ihrem Netzwerk als Applikation in die Profilseite einzubinden.',
        'FACEBOOK_MUSIC_PLAYER_ENABLED' => 'Der Facebook Musik Applikation ist bereits aktiviert.',
        'FACEBOOK_MUSIC_PLAYER_TITLE' => 'Musik-Player',
        'FACEBOOK_MUSIC_SHOULD_PLAY_FROM' => 'Die Facebook Musik Applikationen sollten diese Songs wiedergeben:',
        'FACEBOOK_MUSIC_WIDGET' => 'Musik-Widget',
        'FACEBOOK_MY_APPS' => 'Meine Applikationen',
        'FACEBOOK_PHOTO_SHOULD_PLAY_FROM' => 'Die Facebook Diashow Applikationen sollten diese Fotos zeigen:',
        'FACEBOOK_PHOTO_WIDGET' => 'Foto-Widget',
        'FACEBOOK_PLATFORM_LOGO' => 'Facebook Plattform Logo',
        'FACEBOOK_PLAYER_DISABLE' => 'Deaktivieren',
        'FACEBOOK_POPULAR' => 'beliebteste',
        'FACEBOOK_PROMOTE' => 'Um Ihre neue Applikation am effektivsten zu bewerben, empfehlen wir die folgenden Schritte. Alle diese Optionen sind zugänglich über die Facebook-Seite <strong><a %s>My Applications</a></strong> (Link öffnet in einem neues Fenster).',
        'FACEBOOK_PROMOTED' => 'beworbene',
        'FACEBOOK_PROMOTE_MY_APPLICATIONS_PAGE' => 'Facebook-Seite <strong><a %s>My Applications</a></strong>',
        'FACEBOOK_PROMOTE_TEXT_ABOUT_PAGE' => 'Lassen Sie die Facebook-Benutzer wissen, worum es bei Ihrer Applikation geht, indem Sie eine klare Beschreibung für Ihre Applikation verfassen. Um die Beschreibung zu editieren, klicken Sie auf den Link <strong>Edit About Page</strong>, den Sie neben der Applikation, die Sie gerade bearbeiten, finden können.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_1' => 'Zeigen Sie anderen Ihre Applikation, indem Sie sie zu Ihrer Facebook-Profilseite hinzufügen. Ihre Freunde werden schon bald dasselbe tun und so Ihre Applikation weiterverbreiten.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_2' => 'Klicken Sie einfach auf den Link <strong>View About Page</strong> neben der Applikation, die Sie zu Ihrer Profilseite hinzufügen möchten, und klicken Sie dann auf der nächsten Seite auf "Add Application".',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_3' => 'Sie finden Ihre Applikation jetzt unten auf Ihrer Facebook Profilseite!',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_1' => 'Machen Sie Ihre neue Applikation bekannt, indem Sie sie zum Facebook Verzeichnis hinzufügen.',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_2' => 'Um Ihre Anwendung zum Facebook Verzeichnis hinzuzufügen, klicken Sie auf den Link <strong>Submit Application</strong>, den Sie neben der Applikation, die Sie gerade bearbeiten, finden können. Auf der nächsten Seite können Sie die Beschreibung der Applikation bearbeiten und auch ein Logo hinzufügen.',
        'FACEBOOK_PROMOTE_TITLE_ABOUT_PAGE' => 'Geben Sie der Applikation eine Beschreibung',
        'FACEBOOK_PROMOTE_TITLE_PROFILE' => 'Fügen Sie die Applikation zu Ihrer Facebook Profilseite hinzu',
        'FACEBOOK_PROMOTE_TITLE_SUBMIT' => 'Fügen Sie die Applikation zum Facebook-Verzeichnis hinzu',
        'FACEBOOK_PROMOTING' => 'Für Ihre Applikationen auf Facebook werben',
        'FACEBOOK_PROMOTING_ON' => 'Auf Facebook bewerben',
        'FACEBOOK_QUICK_INTRO_1' => 'Facebook, ein populäres soziales Netzwerk, erlaubt es Drittentwicklern, Applikationen zu erstellen, die zu Facebook Profilseiten hinzugefügt werden können. Diese Applikationen bieten nicht nur zusätzlichen Funktionalität für die Profilseite, sie können Facebook Benutzer auch auf andere Websites führen.',
        'FACEBOOK_QUICK_INTRO_2' => 'Mit Ning müssen Sie kein Entwickler sein, um für Ihr Netzwerk auf Facebook zu werben. Wir haben den schwierigen Teil bereits für Sie erledigt: Ihr Netzwerk bietet von Anfang an Integration mit Facebook via Applikationen. Wählen Sie einfach aus den Optionen unten aus, und Ihr soziales Netzwerk wird innerhalb weniger Sekunden in Facebook verfügbar sein.',
        'FACEBOOK_RATED' => 'am höchsten bewertete',
        'FACEBOOK_RECENT' => 'neueste',
        'FACEBOOK_RECENTLY_ADDED' => 'Neu hinzugefügt',
        'FACEBOOK_RECENTLY_FEATURED' => 'kürzlich vorgestellte',
        'FACEBOOK_SETUP' => 'Facebook-Integration',
        'FACEBOOK_SETUP_INSTR' => 'Anleitung für die Einrichtung',
        'FACEBOOK_SETUP_NEW_APP_BUTTON' => 'Schaltfläche "Set Up New Application (Neue Applikation einrichten)"',
        'FACEBOOK_SLIDESHOW_BUTTON' => 'Diashow Applikation erstellen &raquo;',
        'FACEBOOK_SLIDESHOW_PLAYER_DESC' => 'Erlaubt es Facebook Benutzern, eine Diashow mit Fotos von Ihrem Netzwerk als Applikation in die Profilseite einzubinden.',
        'FACEBOOK_SLIDESHOW_PLAYER_ENABLED' => 'Die Facebook Diashow Applikation ist bereits aktiviert.',
        'FACEBOOK_SLIDESHOW_PLAYER_TITLE' => 'Diashow',
        'FACEBOOK_TO_YOUR_FACEBOOK_PROFILE' => 'zu Ihrer Facebook Profilseite',
        'FACEBOOK_URL_INFO_DESC' => 'Die Applikations-URL ist die <strong>Canvas Page URL</strong>, die Sie auf der vorherigen Seite definiert haben (in Schritt &#8216; f&#8217; ).',
        'FACEBOOK_URL_INFO_TITLE' => 'Facebook Applikations-URL',
        'FACEBOOK_VIDEO_BUTTON' => 'Video Applikation erstellen &raquo;',
        'FACEBOOK_VIDEO_PLAYER_DESC' => 'Erlaubt es Facebook Benutzern, einen Video Player für Videos von Ihrem Netzwerk als Applikation in die Profilseite einzubinden.',
        'FACEBOOK_VIDEO_PLAYER_ENABLED' => 'Die Facebook Video Applikation ist bereits aktiviert.',
        'FACEBOOK_VIDEO_PLAYER_TITLE' => 'Videoplayer',
        'FACEBOOK_VIDEO_SHOULD_PLAY_FROM' => 'Die Facebook Video Applikationen sollten diese Video wiedergeben:',
        'FACEBOOK_VIDEO_WIDGET' => 'Video-Widget',
        'FACEBOOK_VIEW_APP' => 'Applikation anzeigen',
        'FACEBOOK_YOUR_APPLICATIONS' => 'Ihre Facebook Applikationen',
        'FAQ_FOR_NETWORK_CREATORS' => 'Fragen und Antworten für Netzwerkgründer',
        'FEATURED' => 'Ausgewählte',
        'FEATURED_BLOG_POSTS' => 'Ausgewählte Blog-Beiträge',
        'FEATURED_BLOG_POSTS_FOR_M_Y' => 'Ausgewählte Blog-Beiträge für %s %s',
        'FEATURED_GROUPS' => 'Ausgewählte Gruppen',
        'FEATURED_MEMBERS' => 'Ausgewählte Mitglieder',
        'FEATURED_PHOTOS' => 'Ausgewählte Fotos',
        'FEATURED_TRACKS' => 'Ausgewählte Songs',
        'FEATURES' => 'Funktionen',
        'FEATURES_FOR_ALL_PAGES' => 'Funktionen, die zu diesem Feld hinzugefügt werden, erscheinen auf allen Seiten Ihres Netzwerks.',
        'FEATURE_BOXES' => 'Bereiche der einzelnen Funktionen',
        'FEATURE_ON_HOME' => 'Auf der Hauptseite vorstellen',
        'FEATURE_POSTS_FROM_YOUR_BLOG' => 'Stellen Sie Beiträge aus Ihrem Blog oder den Blogs von Mitgliedern Ihres Netzwerks auf der Startseite vor.',
        'FEATURE_THIS_ON_YOUR' => 'Auf der Hauptseite vorstellen',
        'FEATURING_ELLIPSIS' => 'Ausgewählt…',
        'FEBRUARY' => 'Februar',
        'FEEDBACK' => 'Feedback',
        'FEMALE' => 'Weiblich',
        'FILES_MUST_BE_100MB' => 'Dateien dürfen nicht größer als 100 MB sein. Wir unterstützen die Dateiformate .mov, .mpg, .avi, .3gp und .wmv.',
        'FILE_EXCEEDED_MAXIMUM_SIZE' => 'Die Datei ist größer als die maximale zulässige Dateigröße.',
        'FILE_N' => 'Datei %s',
        'FILTER' => 'Filtern',
        'FIND_AN_ADDRESS' => 'Adresse suchen:',
        'FIND_MORE_MUSIC_LIKE_THIS' => 'Sie können mehr Musik wie diese finden auf <em>%s</em>',
        'FIND_MORE_PHOTOS_LIKE_THIS' => 'Sie können mehr Fotos wie diese finden auf <em>%s</em>.',
        'FIND_MORE_VIDEOS_LIKE_THIS' => 'Sie können mehr Videos wie diese finden auf <em>%s</em>.',
        'FINISH' => 'Fertigstellen',
        'FIRST_POST' => 'Beitrag:',
        'FLAG' => 'Kennzeichen',
        'FLICKR' => 'Flickr',
        'FLICKR_API_KEY' => 'Ihr Flickr API-Schlüssel',
        'FLICKR_GET_ACCOUNT' => 'Falls Sie noch kein Flickr Account besitzen, können Sie <a %s>hier</a> einen neuen Account einrichten.',
        'FLICKR_IMPORTING' => 'Flickr Import',
        'FLICKR_IMPORT_SETUP' => 'Flickr Import Konfiguration',
        'FLICKR_INTRO' => 'Wenn Sie den Mitgliedern Ihres Netzwerks erlauben wollen, ihre Fotos von Flickr in Ihr Netzwerk zu importieren, dann sind Sie hier richtig. Wenn Sie bereits einen Flickr API-Schlüssel und Geheimen Schlüssel besitzen, dann können Sie die Konfiguration <a %s>hier fortsetzen</a>. Wenn Sie sich nicht sicher sind, was das bedeutet, dann folgen Sie einfach diesen Schritten, und in ein wenigen Minuten haben Sie alles notwendige konfiguriert.',
        'FLICKR_KEY_ERROR' => 'Es ist ein Problem mit dem Flickr API-Schlüssel oder Geheimen Schlüssel aufgetreten. Bitte überprüfen Sie Ihre Eingaben für diese Schlüssel und versuchen Sie es erneut.',
        'FLICKR_SECRET' => 'Ihr Geheimer Schlüssel',
        'FLICKR_STEP1_A' => 'Geben Sie Ihren <strong>Namen</strong> und <strong>E-Mail Adresse</strong> ein.',
        'FLICKR_STEP1_API_SCREEN' => 'API-Schlüssel Seite auf Flickr',
        'FLICKR_STEP1_APPLY' => 'Wenn Sie fertig sind, klicken Sie auf <strong>Übernehmen</strong>.',
        'FLICKR_STEP1_APPLY_SCREEN' => 'Die Flickr Seite zum Beantragen eines API-Schlüssels',
        'FLICKR_STEP1_B' => 'Unter <strong>Dieser Schlüssel ist für die:</strong> wählen Sie die <em>Nicht kommerzielle Nutzung</em>.',
        'FLICKR_STEP1_C' => 'Beschreiben Sie Ihr Netzwerk im Feld <strong>Beschreiben Sie die Anwendung, die Sie entwickeln möchten:</strong>.',
        'FLICKR_STEP1_D' => 'Markieren Sie die beiden Kästchen zur Einverständniserklärung.',
        'FLICKR_STEP1_E' => 'Sie gelangen dann auf eine Seite, der Ihren neuen API-Schlüssel anzeigt. Klicken Sie auf den Link <strong>Klicken Sie hier</strong>, um die Benutzerauthentifizierung für diesen Schlüssel zu konfigurieren.',
        'FLICKR_STEP1_INTRO' => 'Melden Sie sich bei Flickr an, und <a %s>beantragen Sie dann einen neuen API-Schlüssel</a> (wird in einem neuen Fenster geöffnet).',
        'FLICKR_STEP1_TITLE' => 'Schritt 1: Einen Flickr API-Schlüssel beantragen',
        'FLICKR_STEP2_F' => 'Fügen Sie die folgende Webadresse in das Feld <strong>Rückruf-URL</strong> ein:',
        'FLICKR_STEP2_SAVE_CHANGES' => 'Wenn Sie fertig sind, klicken Sie auf <strong>Änderungen speichern</strong>.',
        'FLICKR_STEP2_SETUP_SCREEN' => 'Die Flickr Seite zur Konfiguration der Authentifizierung für einen API-Schlüssel',
        'FLICKR_STEP2_TITLE' => 'Schritt 2: Den API-Schlüssel einrichten',
        'FLICKR_STEP3_COMPLETE' => 'Um die Einrichtung der Flickr-Integration auf %s fertig zu stellen, kopieren Sie den API-Schlüssel und den Geheimen Schlüssel und fügen sie in die folgenden Felder ein:',
        'FLICKR_STEP3_CONGRATULATIONS' => 'Glückwunsch! Ihr Netzwerk ist nun mit Flickr integriert.',
        'FLICKR_STEP3_KEYS_SCREEN' => 'Die Flickr Seite mit den API-Schlüssel Informationen',
        'FLICKR_STEP3_TITLE' => 'Schritt 3: Eingabe der Flickr Daten',
        'FOLLOWING_ARE_MISSING_FROM_RULES' => 'Bitte beachten Sie, das die folgenden Regeln nicht in den unten stehenden Regeln enthalten sind: %s',
        'FOLLOWING_DO_NOT_SEEM_VALID' => 'Die folgenden E-Mail-Adressen scheinen nicht gültig zu sein, und daher wurden die Einladungen nicht gesendet. Bitte korrigieren Sie die E-Mail-Adressen und versuchen es erneut.',
        'FOLLOW_LATEST_ACTIVITY' => 'Verfolgen Sie die Aktivitäten der Mitglieder Ihres Netzwerk',
        'FOLLOW_LINK_TO_HOMEPAGE' => '<a %s>Dieser Link</a> führt zurück zur Hauptseite.',
        'FOLLOW_THESE_LINKS_TO' => 'Diese Links führen zu einigen Bereichen des Netzwerks, von denen wir wissen, das sie vorhanden sind:',
        'FONT' => 'Schriftart',
        'FORGOT_YOUR_PASSWORD' => 'Passwort vergessen?',
        'FORGOT_YOUR_PASSWORD_TITLE' => 'Passwort vergessen?',
        'FORUM' => 'Forum',
        'FORUM_CATEGORIES' => 'Forumskategorien',
        'FORUM_TAB_TEXT' => 'Forum',
        'FOR_ADDITIONAL_QUESTIONS_OR_TO_CONTACT_NING_PLEASE_CLICK_HERE' => 'Falls Sie weitere Fragen haben, oder Ning kontaktieren möchten, klicken Sie bitte hier:',
        'FOR_FURTHER_ASSISTANCE' => 'Für weitere Hilfe <a %s>setzen Sie sich mit uns in Verbindung</a>.',
        'FOR_FURTHER_ASSISTANCE_2' => 'Weitere Hilfe finden Sie hier:',
        'FRAUD' => 'Betrug',
        'FRIEND_REQUESTS' => 'Freundschaftsanfragen',
        'FROM' => 'von',
        'FROM_FLICKR' => '…von Flickr',
        'FROM_THE_BAZEL' => 'Von diesem Netzwerk',
        'FROM_YOUR_COMPUTER' => '…von Ihrem Computer',
        'FROM_YOUTUBE_OR_GOOGLE' => '…von YouTube oder Google',
        'FULLSCREEN' => 'Vollbild',
        'F_JS_Y' => 'j. F Y',
        'F_J_Y' => 'j. F Y',
        'GADGET' => 'Gadget',
        'GADGETS' => 'Gadgets',
        'GADGETS_BETA' => 'Gadgets (Beta)',
        'GADGETS_IS_IN_BETA' => 'Gadgets befinden sich zurzeit in der Beta-Phase.',
        'GADGETS_TAB_TEXT' => 'Gadgets',
        'GADGETS_UNAVAILABLE' => 'Gadgets sind vorübergehend nicht verfügbar',
        'GALLERY' => 'Galerie',
        'GENDER' => 'Geschlecht',
        'GENDER_COLON' => 'Geschlecht:',
        'GENDER_F' => 'Weiblich',
        'GENDER_M' => 'Männlich',
        'GENERATE_NEW_EMAIL_ADDRESS' => 'Neue E-Mail Adresse erzeugen',
        'GENRE' => 'Genre',
        'GETTING_STARTED' => 'Erste Schritte',
        'GET_ALL_MY_FLICKR' => 'Alle meine Fotos von Flickr importieren (dies kann einige Zeit dauern)',
        'GET_ALL_MY_TAGGED' => 'Alle meine Fotos mit den folgenden Schlagworten importieren',
        'GET_A_SLIDESHOW' => 'Eine Diashow erstellen!',
        'GET_A_SLIDESHOW_OF' => 'Eine Diashow aus %s erstellen',
        'GET_BADGES' => 'Abzeichen',
        'GET_CUSTOM_URL' => 'Verwenden Sie Ihre eigene Domäne, erweitern Sie den Speicher und Bandbreite, der Ihrem Netzwerk zur Verfügung steht, oder verwenden Sie Ihre eigene Werbung.',
        'GET_EMBED_CODE' => 'Einbettungscode',
        'GET_MORE_BADGES' => 'Weitere Abzeichen',
        'GET_MORE_WIDGETS_FROM_YOURMINIS' => 'Holen Sie sich weitere Widgets von yourminis.com »',
        'GET_MY' => 'Importieren meiner',
        'GET_MY_FLICKR_PHOTOS_DESCRIPTIONS' => 'Die Beschreibungen ebenfalls importieren (das verdoppelt die Zeit, die der Import benötigt).',
        'GET_MY_FLICKR_PHOTOS_ORIGINALS' => 'Die Fotos in ihrer Originalgröße importieren (dies erhöht die Zeit, die der Import benötigt, erheblich. Nicht empfohlen für mehr als 20 Fotos).',
        'GET_NETWORK_BADGE' => 'Abzeichen für %s',
        'GET_PHOTOS' => 'Fotos importieren',
        'GET_PHOTOS_FROM_SET' => 'Die Fotos eines Albums importieren:',
        'GET_STARTED_BY_IMPORT' => 'Wir importieren automatisch alle Titel, Schlagworte und Informationen über die Orte, an denen die Fotos aufgenommen wurden. <br/>Wie lange das dauern wird?</p><p><ul style="padding-top:10px;"><li>10 Fotos: <em>weniger als 30 Sekunden</em>.</li><li>50 Fotos: <em>ca. 2 Minuten</em>.</li><li>200 Fotos: <em>ca. 6 Minuten</em>.</li><li>500 Fotos: <em>ca. 15 Minuten</em>.</li></ul>',
        'GET_YOUR_OWN_BAZEL' => 'Gründen Sie Ihr eigenes Netzwerk!',
        'GIVE_US_YOUR_FEEDBACK' => 'Teilen Sie uns Ihre Meinung mit',
        'GO' => 'Los',
        'GOOGLE' => 'Google',
        'GRAB_HTML_EMBED' => 'Kopieren Sie den HTML Einbettungscode von einem der bekannten Videoportale, und fügen Sie mit ihm das Video zu diesem Netzwerk hinzu.',
        'GRAB_THE_HTML_EMBED_CODE' => 'Kopieren Sie den HTML Einbettungscode von einem der bekannten Videoportale, und fügen Sie mit ihm das Video zu diesem Netzwerk hinzu.',
        'GRANDFATHERED_PRIVACY_SETTING' => 'Ihre aktuelle Einstellung zur Privatsphäre "ein öffentliches Netzwerk, in dem Nicht-Mitglieder nur die Anmeldeseite sehen können" ist nicht mehr verfügbar. Ihre Einstellung wurde nicht geändert, wenn Sie hier jedoch Änderungen vornehmen, können Sie nicht mehr zu dieser Einstellung zurückkehren. Das derzeitige Äquivalent zu dieser Einstellung ist: ein privates Netzwerk, bei dem Jeder Mitglied werden kann.',
        'GROUP' => 'Gruppe',
        'GROUPNAME_MEMBERS' => 'Mitglieder von %s',
        'GROUPS' => 'Gruppen',
        'GROUPS_MATCHING_SEARCH_TERM' => 'Zu <em>\'%s\'</em> passende Gruppen',
        'GROUPS_TAB_TEXT' => 'Gruppen',
        'GROUP_ADMINISTRATOR' => 'Gruppenadministrator',
        'GROUP_ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Gruppenadministratoren haben in einem ähnlichen Maße Kontrolle über die Gruppe wie der Gründer des Gruppe.',
        'GROUP_ADMIN_DISCUSSIONS' => 'Diskussionen der Gruppenadministratoren',
        'GROUP_CREATOR' => 'Gründer der Gruppe',
        'GROUP_FORUM' => '%s-Forum',
        'GROUP_HAS_NO_DISCUSSIONS' => 'Diese Gruppe hat noch keine Diskussionen.',
        'GROUP_HAS_NO_MEMBERS' => 'Diese Gruppe hat noch keine Mitglieder!',
        'GROUP_HAS_NO_MEMBERS_THAT_MATCH' => 'Diese Gruppe hat keine Mitglieder, auf die Ihre Suche passt.',
        'GROUP_INFORMATION' => 'Gruppeninformationen',
        'GROUP_INVITATIONS' => 'Einladungen für die Gruppe',
        'GROUP_MEMBERS' => 'Gruppenmitglieder',
        'GROUP_MEMBERS_COUNT' => '%s Mitglieder (%d)',
        'GROUP_WEB_ADDRESS' => 'Webadresse der Gruppe',
        'G_IA' => 'G:ia',
        'HAPPY' => 'Fröhlich',
        'HAS_INVITED_YOU_TO_X' => 'hat Sie eingeladen, Mitglied bei %s zu werden.',
        'HAVE_ANOTHER_GREAT_IDEA' => 'Sie haben eine weitere gute Idee für ein Soziales Netzwerk?',
        'HAVE_LOT_OF_MUSIC' => 'Sie haben eine Menge Musik, die Sie mit anderen teilen möchten?',
        'HAVE_LOT_OF_PHOTOS' => 'Sie haben eine Menge Fotos, die Sie mit anderen teilen möchten?',
        'HAVE_LOT_OF_VIDEOS' => 'Sie haben eine Menge Videos, die Sie mit anderen teilen möchten?',
        'HAVING_PROBLEMS_WITH_MUSIC_UPLOADER' => 'Haben Sie Probleme mit diesem Musik Hochladetool? <strong><a %s>Wechseln Sie zu unserem einfachen Hochladeformular</a></strong>.',
        'HAVING_PROBLEMS_WITH_PHOTO_UPLOADER' => 'Haben Sie Probleme mit diesem Foto Hochladetool?  <strong><a %s>Wechseln Sie zu unserem einfachen Hochladeformular</a></strong>.',
        'HAVING_PROBLEMS_WITH_VIDEO_UPLOADER' => 'Haben Sie Probleme mit diesem Video Hochladetool?  <strong><a %s>Wechseln Sie zu unserem einfachen Hochladeformular</a></strong>.',
        'HEADER' => 'Titel',
        'HEADER_AND_NAVIGATION' => 'Kopfzeile & Navigation',
        'HEADER_LOGO' => 'Titelbild',
        'HEADING_TEXT' => 'Text der Überschrift',
        'HELLO' => 'Hallo,',
        'HELLO_USER' => 'Hallo, %s',
        'HELLO_USERNAME' => 'Hallo Benutzername',
        'HELLO_USERNAME_SIGN_OUT' => '<strong>Hallo %s</strong> (<a %s>Abmelden</a>)',
        'HELLO_YOU_NEED_TO_ENABLE_JAVASCRIPT' => 'Hallo, Sie müssen JavaScript aktivieren, um dieses Netzwerk benutzen zu können.',
        'HELP' => 'Hilfe',
        'HERE' => 'Hier',
        'HERE_ARE_INSTRUCTIONS' => 'Hier sind Anleitungen für <a %s>YouTube</a> und <a %s>Google Videos</a>.',
        'HIDE' => 'Schließen',
        'HIDE_THIS_MESSAGE' => 'Diese Nachricht ausblenden',
        'HIGHEST_RATED' => 'Am höchsten bewertet',
        'HIGHEST_RATED_TRACKS' => 'Am höchsten bewertet',
        'HIGHEST_RATED_VIDEOS' => 'Am höchsten bewertete Videos',
        'HMM_SOMETHING_WENT_AWRY' => 'Mhmm… Irgendwas ist schief gelaufen.',
        'HOSTING_SITE' => 'Hosting Seite',
        'HOWDY_STRANGER' => 'Hallo Fremde/r!',
        'HOW_IT_WORKS' => 'So funktioniert\'s',
        'HTML_EMBED_CODE' => 'HTML Einbettungscode:',
        'ICON' => 'Icon',
        'IF_DID_NOT_CHANGE_EMAIL_ADDRESS' => 'Falls Sie Ihre E-Mail-Adresse nicht geändert haben, klicken Sie bitte hier:',
        'IF_JOINED_BEFORE_OCTOBER' => 'Wenn Sie vor dem 5. Oktober 2007 Mitglied wurden, wurden Sie möglicherweise zuvor um Ihre Ning ID gebeten. Mittlerweile verwenden wir anstelle der Ning ID die E-Mail-Adresse, mit der Sie sich registriert haben. Sie können jedoch immer noch Ihre Ning ID in dieses Feld eingeben.',
        'IF_NO_LONGER_WISH_FRIEND_NOTIFICATION_EMAIL_FROM_X_CLICK_Y' => 'Falls Sie keine E-Mails mehr für Freundschaftsanfragen von %s erhalten möchten, <a %s>klicken Sie hier</a>.',
        'IF_YOURE_NOT_SIGNED_IN' => 'Falls Sie noch nicht bei Flickr angemeldet sind, werden Sie dazu aufgefordert. Klicken Sie nach dem Anmelden auf "Ok, ich erlaube".',
        'IF_YOU_ARE_ADMIN' => 'Falls Sie ein Administrator sind, <a %s>klicken Sie bitte hier, um sich anzumelden</a>.',
        'IF_YOU_CREATED_TRANSLATION' => 'Sie haben eine Übersetzung in einem anderen Netzwerk auf Ning erstellt? Hier können Sie Ihre Übersetzung in dieses Netzwerk importieren. Die übersetzten Wörter und Phrasen werden der Sprache Ihrer Wahl hinzugefügt. Ist Ihre Sprache nicht aufgelistet? <a %s>Das Erstellen einer neuen Übersetzung ist einfach.</a>.',
        'IF_YOU_GET_THIS_MESSAGE' => 'Falls Sie diese Nachricht ein weiteres Mal sehen, <a %s>lassen Sie es uns bitte wissen.</a>',
        'IF_YOU_NO_LONGER_WISH_FROM_X_CLICK_Y' => 'Wenn Sie keine E-Mail-Benachrichtigungen mehr von %s erhalten möchten, <a %s>klicken Sie hier</a>.',
        'IF_YOU_SELECT_REQUIRED_MEMBERS_WILL' => 'Wenn Sie "Erforderlich" wählen, dann müssen potentielle Mitglieder die Frage beantworten, bevor sie Mitglied werden können. Falls Sie "Privat" wählen, ist die Antwort nur für Sie und andere Administratoren sichtbar.',
        'IF_YOU_TRANSLATED_A_LANGUAGE' => 'Wenn Sie bereits ein Netzwerk auf Ning übersetzt haben, <strong><a %s>dann können Sie Ihre Übersetzung importieren</a></strong> und in diesem Netzwerk verwenden.',
        'IGNORE' => 'Ignorieren',
        'IMPORTING_ADDRESS_BOOK' => 'Adressbuch wird importiert',
        'IMPORT_ADDRESS_BOOK' => 'Adressbuch importieren',
        'IMPORT_FAILED' => 'Leider ist der Import fehlgeschlagen.',
        'IMPORT_FROM_ADDRESS_BOOK_APPLICATION' => 'Aus dem Adressbuch-Programm importieren',
        'IMPORT_FROM_WEB_ADDRESS_BOOK' => 'Aus Web Adressbuch importieren',
        'IMPORT_PHOTOS' => 'Fotos importieren',
        'IMPORT_PHOTOS_FLICKR' => 'Importieren Sie Ihre Fotos von Flickr.',
        'IM_A_MEMBER_OF' => 'Ich bin Mitglied von:',
        'INCOMPLETE' => 'unvollständig',
        'INFORMATION_ABOUT_THE_USER' => 'Informationen zur derzeit angemeldeten Person',
        'INVALID_PASSWORD_CHECK_CAPS_LOCK' => 'Falsches Passwort. Vielleicht ist die Feststelltaste aktiviert?',
        'INVALID_URL' => 'Ungültige URL',
        'INVITATION' => 'Einladung',
        'INVITATIONS' => 'Einladungen',
        'INVITATIONS_HAVE_BEEN_SENT' => 'Ihre Einladungen wurden gesendet.',
        'INVITATION_LINK_ONLY_VISIBLE' => 'Dieser Einladungslink ist nur für den Netzwerkgründer und für Administratoren sichtbar. Personen, die mittels dieses Links Mitglied werden, werden automatisch Freunde des Netzwerkgründers.',
        'INVITE' => 'Einladen',
        'INVITED' => 'Eingeladen',
        'INVITED_BY_X' => 'Eingeladen von %s',
        'INVITE_FRIENDS' => 'Freunde einladen',
        'INVITE_MORE' => 'Weitere einladen',
        'INVITE_MORE_PEOPLE' => 'Weitere Personen einladen',
        'INVITE_PEOPLE_TO_GROUP' => 'Personen zu %s einladen',
        'INVITE_TAB_TEXT' => 'Einladen',
        'INVITE_TO_APPNAME' => 'Einladen zu \'%s\'',
        'INVITE_TO_GROUP' => 'Einladen zu \'%s\'',
        'INVITE_YOUR_FRIENDS' => 'Laden Sie Ihre Freunde ein',
        'INVITE_YOUR_FRIENDS_TO' => 'Ihre Freunde zu %s einladen.',
        'INVITE_YOUR_FRIENDS_TO_APPNAME' => 'Ihre Freunde einladen zu \'%s\'',
        'INVITE_YOUR_FRIENDS_TO_GROUPNAME' => 'Ihre Freunde einladen zu \'%s\'',
        'ISSUE_COLON' => 'Problem:',
        'IS_BLOCKED' => 'Gesperrt',
        'IS_YOUR_FRIEND' => 'Ist Ihr/e Freund/in',
        'ITEM_WILL_APPEAR' => 'Dieses Element wird nun in ausgewählten Bereichen der Hauptseite angezeigt.',
        'ITEM_WILL_NO_LONGER_APPEAR' => 'Dieses Element wird nicht mehr in ausgewählten Bereichen der Hauptseite angezeigt.',
        'I_AM_MEMBER' => 'Ich bin Mitglied von:',
        'I_DO_NOT_HAVE_ALBUM' => 'Leider habe ich dieses Album nicht.',
        'I_DO_NOT_HAVE_PHOTO' => 'Leider habe ich dieses Foto nicht.',
        'I_DO_NOT_KNOW_USER' => 'Leider kenne ich diese Person nicht.',
        'I_HAVE_NEW_COMMENTS' => 'Es gibt neue Kommentare zur Kontrolle',
        'I_HAVE_NEW_NETWORK_CONTENT' => 'Es gibt neue Netzwerkinhalte zur Kontrolle',
        'I_HAVE_RECENTLY_ADDED' => 'Neu von mir hinzugefügt:',
        'I_HAVE_RIGHT_TO_UPLOAD_PHOTOS' => 'Ich habe das Recht, diese Fotos innerhalb der <a %s>AGBs</a> hochzuladen.',
        'I_HAVE_RIGHT_TO_UPLOAD_SONGS' => 'Ich habe das Recht, diese Songs innerhalb der <a %s>AGBs</a> hochzuladen.',
        'I_HAVE_RIGHT_TO_UPLOAD_VIDEO' => 'Ich habe das Recht, dieses Video innerhalb der <a %s>AGBs</a> hochzuladen.',
        'JANUARY' => 'Januar',
        'JOIN' => 'Mitglied werden',
        'JOIN_GROUPS' => 'Gruppen beitreten',
        'JOIN_GROUP_NOW' => 'Jetzt %s beitreten!',
        'JOIN_ME_ON_X' => 'Werde auch Mitglied bei %s!',
        'JOIN_NETWORK_CREATORS' => 'Bei Network Creators Mitglied werden',
        'JOIN_US' => 'Werden Sie Mitglied',
        'JOIN_X' => 'Mitglied bei %s werden',
        'JOIN_X_NOW' => 'Jetzt Mitglied bei %s werden!',
        'JULY' => 'Juli',
        'JUNE' => 'Juni',
        'JUST_CLICK_ON_SIGN_IN' => 'Klicken Sie oben auf "Anmelden", oder, falls Sie noch nicht bei Ning angemeldet sind, klicken Sie auf "Registrieren".',
        'JUST_FRIENDS' => 'Nur Freunde',
        'JUST_ME' => 'Nur ich',
        'JUST_MY_FRIENDS' => 'Nur meine Freunde',
        'JUST_NOW' => 'Gerade eben',
        'JUST_THE_HOMEPAGE' => 'Nur die Hauptseite',
        'JUST_THE_SIGN_UP_PAGE' => 'Nur die Registrierungsseite',
        'KEEP_PAGE_OPEN' => 'Bitte lassen Sie diese Seite geöffnet, damit Ihr Video hochgeladen werden kann. Wir benachrichtigen Sie, sobald das Video akzeptiert wurde!',
        'KEEP_PAGE_OPEN_FORUM' => 'Bitte lassen Sie diese Seite geöffnet, damit Ihre Dateien in das Forum hochgeladen werden können.',
        'KEEP_PAGE_OPEN_MUSIC' => 'Bitte lassen Sie diese Seite geöffnet, damit Ihre Songs hochgeladen werden können. Wir benachrichtigen Sie, sobald die Songs akzeptiert wurden!',
        'KEEP_PAGE_OPEN_PHOTOS' => 'Bitte lassen Sie diese Seite geöffnet, damit Ihre Fotos hochgeladen werden können. Wir benachrichtigen Sie, sobald die Fotos akzeptiert wurden.',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED' => 'Bitte lassen Sie diese Seite geöffnet, während der Inhalt gelöscht wird. Dieser Vorgang kann einige Minuten dauern.',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED_2' => 'Bitte lassen Sie diese Seite geöffnet, während der gesamte Inhalt von %s gelöscht wird. Dieser Vorgang kann einige Minuten dauern.',
        'KEEP_WINDOW_OPEN_MEMBERS_DELETED' => 'Bitte lassen Sie diese Seite geöffnet, während die Mitglieder gelöscht werden. Dieser Vorgang kann einige Minuten dauern.',
        'KEEP_WINDOW_OPEN_PHOTOS_APPROVED' => 'Bitte lassen Sie diese Seite geöffnet, während die Erlaubnis für die Fotos erteilt wird. Dieser Vorgang kann einige Minuten dauern.',
        'KEEP_WINDOW_OPEN_PHOTOS_DELETED' => 'Bitte lassen Sie diese Seite geöffnet, während die Fotos gelöscht werden. Dieser Vorgang kann einige Minuten dauern.',
        'KEYWORDS' => 'Schlüsselwörter',
        'KEY_MISSING_TEXT' => 'Schlüssel: <span %s>Fehlender Text</span> <span %s>Geänderter Text</span>',
        'LABEL' => 'Plattenlabel',
        'LABEL_SITE' => 'Webseite des Plattenlabels',
        'LANGUAGE' => 'Sprache',
        'LANGUAGE_EDITOR' => 'Spracheditor',
        'LANGUAGE_EDITOR_X' => 'Spracheditor: %s',
        'LANGUAGE_NAME' => 'Name der Sprache',
        'LANGUAGE_NAME_TAKEN' => 'Dieser Name wird bereits verwendet. Bitte wählen Sie einen anderen Namen.',
        'LARGE_NETWORK_BADGE' => 'Großes Netzwerk-Abzeichen',
        'LARGE_N_PIXELS_WIDE' => 'Groß - %d Pixel breit',
        'LARGE_THUMBNAILS' => 'Große Vorschaubilder',
        'LARGE_VERSION' => 'Große Version',
        'LARR_BACK' => '← <a %s>Zurück</a>',
        'LARR_BACK_TO_PENDING_MEMBERS' => '← Zurück zur Liste der potentiellen Mitglieder',
        'LATEST_ACTIVITY' => 'Letzte Aktivität',
        'LATEST_ACTIVITY_ON_APPNAME' => 'Letzte Aktivität auf %s',
        'LATEST_REPLIES' => 'Letzten Antworten',
        'LAUNCH' => 'Start!',
        'LAYOUT' => 'Layout',
        'LEAVE_A_COMMENT_FOR_USERNAME' => 'Einen Kommentar für %s hinterlassen',
        'LEAVE_THIS_GROUP' => 'Gruppe verlassen',
        'LEAVE_WINDOW_OPEN' => 'Bitte lassen Sie diese Seite während des Hochladens geöffnet.',
        'LEAVE_WINDOW_WHILE_GET' => '<strong>Bitte lassen Sie diese Seite geöffnet,</strong> während die E-Mail-Adressen Ihrer Freunde importiert werden. Anschließend können Sie die Personen auswählen, die Sie in das Netzwerk einladen möchten.',
        'LEAVE_X' => '%s verlassen',
        'LEAVE_X_Q' => '%s verlassen?',
        'LET_MEMBERS_KNOW_WHO_CREATED_NETWORK' => 'Lassen Sie Ihre Mitglieder wissen, wer dieses Netzwerk gegründet hat',
        'LICENSE' => 'Lizenz',
        'LICENSE_NAME' => 'Name der Lizenz',
        'LICENSE_URL' => 'URL der Lizenz',
        'LIKE_WHAT_YOU_SEE' => 'Gefällt Ihnen, was Sie auf %s sehen? Werden Sie Mitglied!',
        'LIKE_WHAT_YOU_SEE_GROUP' => 'Gefällt Ihnen, was Sie in %s sehen? Werden Sie Mitglied!',
        'LINKS' => 'Links',
        'LINK_COLOR' => 'Link-Farbe',
        'LOADING' => 'Wird geladen…',
        'LOADING_PLAYLIST_ELLIPSIS' => 'Lade Wiedergabeliste…',
        'LOADING_YOUR_FRIENDS' => 'Ihre Freunde werden geladen…',
        'LOCATE' => 'Suchen',
        'LOCATION' => 'Ort:',
        'LOCATION_OF_PHOTO' => 'Ort des Fotos:',
        'LOCATION_OF_VIDEO' => 'Ort dieses Videos:',
        'LOGIN_FAILED' => 'Leider ist die Anmeldung fehlgeschlagen.',
        'LOGO_IMAGE' => 'Logo Bild',
        'LONGER_ANSWER' => 'Längere Antwort',
        'LOOKING_TO_ADD_FUNCTIONALITY' => 'Möchten Sie Ihrem Netzwerk weitere Funktionen hinzufügen? Vielleicht einen Kalender, regionale Wetterberichte, Event-Countdowns oder eine Webcam? Mit Widgets können Sie diese und andere neue Funktionen in jedes Textfeld in Ihrem Netzwerks einbinden.',
        'LOREM_IPSUM_1' => 'Lorem <span %s>ipsum dolor</span> sit amet, consectetuer adipiscing elit. Nunc scelerisque blandit dolor. Vestibulum ante ipsum primis in faucibus orci luctus.',
        'LOREM_IPSUM_2' => 'Lorem ipsum dolor sit amet, consectetuer adipiscing',
        'LOREM_IPSUM_3' => 'Lorem ipsum dolor sit amet, <span class="preview_link">consectetuer</span> adipiscing',
        'MAD' => 'Verärgert',
        'MAIN' => 'Hauptseite',
        'MAIN_PAGE' => 'Hauptseite',
        'MAIN_TAB_TEXT' => 'Hauptseite',
        'MAKE_AN_ALBUM' => 'Ein Album erstellen',
        'MAKE_SURE_COOKIES' => 'Stellen Sie sicher, das dass Cookies und JavaScript in Ihrem Browser aktiviert sind.',
        'MAKE_SURE_WORDS_SPELLED' => 'Vergewissern Sie sich, dass alle Wörter korrekt geschrieben sind',
        'MAKE_YOUR_X_PAGE_YOUR_OWN' => 'Klicken Sie auf "Bearbeiten", um Text, Videos, Fotos oder Widgets zu diesem Feld hinzuzufügen. Dies gibt Ihnen eine weitere Möglichkeit, Ihre %s Seite individuell nach Ihren Wünschen zu gestalten.',
        'MALE' => 'Männlich',
        'MANAGE' => 'Verwalten',
        'MANAGE_BLOG' => 'Blog verwalten',
        'MANAGE_CATEGORIES' => 'Kategorien verwalten',
        'MANAGE_FORUM_CATEGORIES' => 'Forumskategorien verwalten',
        'MANAGE_GROUP_MEMBERS' => 'Gruppenmitglieder verwalten',
        'MANAGE_INVITED_PEOPLE' => 'Einladungen verwalten',
        'MANAGE_MEMBERS' => 'Mitglieder verwalten',
        'MANAGE_MEMBERS_ADMINS_INVITED' => 'Verwalten Sie Mitglieder, Administratoren, Einladungen und Sperrungen.',
        'MANAGE_TAB_TEXT' => 'Verwalten',
        'MAP' => 'Karte',
        'MARCH' => 'März',
        'MAY' => 'Mai',
        'ME' => 'Mir',
        'MEANWHILE_FEEL_FREE' => 'In der Zwischenzeit können Sie <a %s>ein neues Browser-Fenster öffnen</a> und weiterhin %s nutzen. Sobald das Video komplett hochgeladen wurde, können Sie Ihrem Video in diesem Fenster Titel und Beschreibung hinzufügen.',
        'MEANWHILE_FEEL_FREE_FORUM' => 'Sie können in der Zwischenzeit <a %s>ein neues Browser-Fenster öffnen</a> und weiterhin %s nutzen.',
        'MEANWHILE_FEEL_FREE_MUSIC' => 'Sie können in der Zwischenzeit <a %s>ein neues Browser-Fenster öffnen</a> und weiterhin %s nutzen. Wenn das Hochladen beendet ist, können Sie in diesem Fenster Titel und Beschreibungen für die Songs eingeben.',
        'MEANWHILE_FEEL_FREE_PHOTOS' => 'Sie können in der Zwischenzeit <a %s>ein neues Browser-Fenster öffnen</a> und weiterhin %s nutzen. Wenn das Hochladen beendet ist, können Sie in diesem Fenster Titel und Beschreibungen für die Fotos eingeben.',
        'MEDIUM_N_PIXELS_WIDE' => 'Mittel - %d Pixel breit',
        'MEET_OTHER_LIKEMINDED' => 'Treffen Sie gleichgesinnte Netzwerkgründer, tauschen Sie Ideen aus, und erhalten Sie Support vom Ning-Team.',
        'MEMBER' => 'Mitglied',
        'MEMBERS' => 'Mitglieder',
        'MEMBERSHIP_BY_INVITATION_ONLY' => 'Mitgliedschaft nur auf Einladung',
        'MEMBERSHIP_PENDING_APPROVAL' => 'Mitgliedschaft muss noch genehmigt werden',
        'MEMBERSHIP_TO_APPNAME_BY_INVITATION_ONLY' => 'Die Mitgliedschaft bei %s ist nur auf Einladung möglich',
        'MEMBERSHIP_TO_X_IS_BY_INVITATION' => 'Die Mitgliedschaft bei %s ist nur auf Einladung möglich',
        'MEMBERS_CAN_INVITE' => 'Mitglieder können andere in das Netzwerk einladen.',
        'MEMBERS_TAB_TEXT' => 'Mitglieder',
        'MEMBER_ACTIVITY' => 'Mitgliederaktivität',
        'MEMBER_BADGE' => 'Mitgliedsabzeichen',
        'MEMBER_IS_ONLINE' => 'Mitglied ist online',
        'MEMBER_OF_X_ACCEPTED' => 'ein Mitglied von %s hat Ihren Freundschaftsantrag angenommen hat',
        'MEMBER_UPDATES' => 'Änderungen in den Profilen von Mitgliedern',
        'MESSAGE' => 'Nachricht',
        'MESSAGES_SENT_TO_ALL_FRIENDS' => 'Nachrichten, die an alle Freunde gesendet wurden',
        'MESSAGES_SENT_TO_GROUPS' => 'Nachrichten, die an Gruppen gesendet wurden, bei denen ich Mitglied bin',
        'MESSAGES_SENT_TO_ME' => 'Nachrichten, die an mich gesendet wurden',
        'MESSAGES_SENT_TO_NETWORK' => 'Nachrichten, die an das gesamte Netzwerk gesendet wurden',
        'MESSAGE_HAS_BEEN_SENT' => 'Ihre Nachricht wurde gesendet',
        'MESSAGE_OPTIONAL' => 'Nachricht (optional)',
        'MESSAGE_SENT' => 'Nachricht gesendet!',
        'MESSAGE_TOO_LONG' => 'Ihre Nachricht ist zu lang. Bitte verwenden Sie weniger als %s Zeichen.',
        'MESSAGE_TO_ADMINISTRATOR' => 'Nachricht an den Administrator',
        'MESSAGE_TO_ALL_MEMBERS_OF_X' => 'Eine Nachricht an alle Mitglieder von %s',
        'MICROSOFT_OUTLOOK_APPLE_ADDRESS_BOOK' => 'Microsoft Outlook, Apple Addressbuch, .CSV, etc.',
        'MIDDLE' => 'Mitte',
        'MISMATCHED_CURLY_BRACKETS' => 'Nicht die gleiche Anzahl von öffnenden und schließenden geschweiften Klammern',
        'MISMATCHED_PARENTHESES' => 'Nicht die gleiche Anzahl von öffnenden und schließenden runden Klammern',
        'MISMATCHED_SQUARE_BRACKETS' => 'Nicht die gleiche Anzahl von öffnenden und schließenden eckigen Klammern',
        'MISSING' => 'Fehlend',
        'MODELS_RESET' => 'Modelle zurückgesetzt',
        'MODERATE_COMMENTS_ON_BLOG' => 'Möchten Sie Kommentare moderieren,<br/>bevor sie in Ihrem Blog erscheinen?',
        'MODERATION' => 'Moderation',
        'MONETIZE_WITH_ADS' => 'Verdienen Sie Geld mit Werbung in Ihrem Netzwerk',
        'MONTH' => 'Monat',
        'MONTHLY_ARCHIVES' => 'Monatsarchive',
        'MORE' => 'Mehr',
        'MORE_ELLIPSIS' => 'Mehr…',
        'MORE_INFORMATION' => 'Weitere Informationen',
        'MORE_PHOTOS' => 'Weitere Photos',
        'MORE_RECENT_PHOTOS' => 'Neuere Fotos',
        'MORE_VIDEOS' => 'Weitere Videos',
        'MORE_WAYS_TO_ADD_PHOTOS' => 'Weitere Möglichkeiten, Fotos hinzuzufügen…',
        'MORE_WAYS_TO_ADD_VIDEOS' => 'Weitere Möglichkeiten, Videos hinzuzufügen…',
        'MORE_WAY_TO_ADD_MUSIC' => 'Weitere Möglichkeiten, Songs hinzuzufügen…',
        'MORE_WIDGETS' => 'Weitere Widgets',
        'MOST_ACTIVE' => 'Am aktivsten',
        'MOST_FAVORITED' => 'Am meisten favorisiert',
        'MOST_FAVORITED_VIDEOS' => 'Am meisten favorisierte Videos',
        'MOST_MEMBERS' => 'Die meisten Mitglieder',
        'MOST_POPULAR' => 'Am populärsten',
        'MOST_POPULAR_MEMBERS' => 'Populärste Mitglieder',
        'MOST_POPULAR_VIDEOS' => 'Populärste Videos',
        'MOST_RECENT' => 'Am aktuellsten',
        'MOST_RECENT_PHOTOS' => 'Aktuellste Fotos',
        'MOST_RECENT_TRACKS' => 'Aktuellste Songs',
        'MOST_RECENT_VIDEOS' => 'Aktuellste Videos',
        'MOST_REPLIES' => 'Die meisten Antworten',
        'MOST_VIEWS' => 'Am meisten angesehen',
        'MULTIPLE_CHOICE' => 'Multiple Choice',
        'MUSIC' => 'Musik',
        'MUSIC_PLAYER' => 'Musik Player',
        'MUSIC_UPLOADER_REQUIRES_JAVA' => 'Das Musik Hochladetool benötigt eine aktuelle Java Version. <strong><a %s>Klicken Sie hier um Java herunterzuladen</a></strong>, oder <strong><a %s>wechseln Sie zum einfachen Hochladeformular</a></strong>.',
        'MY_ACTIVITY_PREFERENCES' => 'Meine Aktivitätseinstellungen',
        'MY_ALBUMS' => 'Meine Alben',
        'MY_BLOG' => 'Mein Blog',
        'MY_BLOG_POSTS' => 'Meine Blog Beiträge',
        'MY_BLOG_POSTS_FOR_M_Y' => 'Meine Blog Beiträge für %s %s',
        'MY_COMMENTS' => 'Meine Kommentare',
        'MY_DETAILS' => 'Meine persönlichen Angaben',
        'MY_DISCUSSIONS' => 'Meine Diskussionen',
        'MY_DISCUSSIONS_ONLY' => 'Nur meine Diskussionen',
        'MY_FAVORITES' => 'Meine Favoriten',
        'MY_FIRST_BLOG_POST' => 'Mein erster Blog-Beitrag!',
        'MY_FRIENDS' => 'Meine Freunde',
        'MY_FRIENDS_PHOTOS' => 'Fotos meiner Freunde',
        'MY_FRIENDS_VIDEOS' => 'Videos meiner Freunde',
        'MY_GROUPS' => 'Meine Gruppen',
        'MY_LANGUAGES' => 'Meine Sprachen',
        'MY_MOST_RECENT' => 'Meine aktuellsten',
        'MY_PAGE' => 'Meine persönliche Seite',
        'MY_PAGE_TAB_TEXT' => 'Meine Seite',
        'MY_PHOTOS' => 'Meine Fotos',
        'MY_PLAYLIST' => 'Meine Wiedergabeliste',
        'MY_POSTS' => 'Meine Beiträge',
        'MY_POSTS_ONLY' => 'Nur meine Beiträge',
        'MY_SETTINGS' => 'Meine Einstellungen',
        'MY_VIDEOS' => 'Meine Videos',
        'M_J' => 'j. M',
        'M_J_Y' => 'j.n.Y',
        'M_J_Y_G_IA' => 'j. M Y G:i',
        'NAME' => 'Name',
        'NAME_COLON' => 'Name:',
        'NAME_MUST_BE_SHORTER' => 'Der Name darf höchstens %s Zeichen lang sein.',
        'NAME_TAKEN' => 'Dieser Name ist leider schon vergeben. Bitte wählen Sie einen anderen Namen.',
        'NEED_HELP' => 'Benötigen Sie Hilfe?',
        'NEED_HELP_FIGURING_OUT_CSS' => 'Benötigen Sie Hilfe dabei, den Namen einer bestimmten CSS-Klasse in Ihrem Netzwerk herauszufinden? Wir empfehlen die "Inspect" Funktion der kostenlosen <a href="%s">Firebug</a> Erweiterung (für den Firefox Browser).',
        'NEED_HELP_HERE_ARE' => 'Benötigen Sie Hilfe?  Anleitungen für <a %s>YouTube</a> und <a %s>Google Videos</a>.',
        'NEED_MORE_OPTIONS' => 'Mehr Optionen gewünscht? Auf diesen Webseiten erhalten Sie noch mehr Widgets:',
        'NEITHER_FILE_NOR_EMBED_CODE' => 'Weder eine Datei noch ein HTML Einbettungscode wurden eingegeben.',
        'NETWORK' => 'Netzwerk',
        'NETWORK_ADMINISTRATOR' => 'Administrator',
        'NETWORK_BADGE_LARGE' => 'Netzwerk Abzeichen (Groß)',
        'NETWORK_BADGE_SMALL' => 'Netzwerk Abzeichen (Klein)',
        'NETWORK_BRANDING_BADGES' => 'Individualisierung des Netzwerks: Abzeichen',
        'NETWORK_BRANDING_WIDGETS' => 'Individualisierung des Netzwerks: Widgets',
        'NETWORK_CREATOR' => 'Netzwerkgründer',
        'NETWORK_DOES_NOT_HAVE_FEATURED_VIDEOS' => 'In diesem Netzwerk werden noch keine Videos vorgestellt.',
        'NETWORK_DOES_NOT_HAVE_MUSIC' => 'Dieses Netzwerk hat noch keine Musik.',
        'NETWORK_DOES_NOT_HAVE_PHOTOS' => 'Dieses Netzwerk hat noch keine Fotos.',
        'NETWORK_DOES_NOT_HAVE_VIDEOS' => 'Dieses Netzwerk hat noch keine Videos.',
        'NETWORK_INFORMATION' => 'Netzwerkinformationen',
        'NETWORK_MESSAGES' => 'Netzwerknachrichten',
        'NETWORK_NAME' => 'Netzwerkname',
        'NETWORK_PLAYLIST' => 'Netzwerk Wiedergabeliste',
        'NETWORK_PRIVACY' => 'Netzwerk Datenschutz',
        'NETWORK_SETTINGS' => 'Netzwerkeinstellungen',
        'NEWEST_DISCUSSIONS' => 'Neuste Diskussionen',
        'NEW_AND_CONFIRMATION_PASSWORDS' => 'Das neue Passwort stimmt nicht mit der dem zur Bestätigung Eingegebenen überein.',
        'NEW_COMMENTS' => 'Neue Kommentare',
        'NEW_COMMENTS_I_ADD' => 'Neue, von mir hinzugefügte Kommentare',
        'NEW_CONTENT' => 'Neuer Inhalt',
        'NEW_CONTENT_I_ADD' => 'Neuer, von mir hinzugefügter Inhalt',
        'NEW_FEATURES_ACTIVITY_BADGES' => '<h3 style="margin-top:0">Neue Funktionen! </h3>
            <ul><li><strong>Neueste Aktivitäten</strong> &ndash; Verfolgen Sie die neuesten Aktivitäten der Mitglieder in Ihrem Netzwerk</li>
                <li><strong>Abzeichen & Widgets</strong> &ndash; Bewerben Sie Ihr Netzwerk im Internet mit maßgeschneiderten Abzeichen und Widgets</li></ul>
            <p><a href="%s" class="desc add">Klicken Sie hier, um Funktionen hinzuzufügen oder zu bearbeiten</a></p>',
        'NEW_FEATURES_GROUPS_MUSIC' => '<h3 style="margin-top:0">Neue Funktionen! </h3>
            <ul><li><strong>Gruppen</strong> &ndash; Die Mitglieder in Ihrem Netzwerk können nun Gruppen erstellen</li>
                <li><strong>Musik Player</strong> &ndash; Fügen Sie Musik und Podcasts zu Ihrem Netzwerk hinzu</li></ul>
            <p><a href="%s" class="desc add">Klicken Sie hier, um Funktionen hinzuzufügen oder zu bearbeiten</a></p>',
        'NEW_MEMBER' => 'Neues Mitglied?',
        'NEW_MEMBERS' => 'Neue Mitglieder',
        'NEW_PASSWORD' => 'Neues Passwort',
        'NEW_TRANSLATION' => 'Neue Übersetzung',
        'NEXT' => 'Nächste',
        'NEXT_ALBUM_PAGE' => 'Nächste Albumseite',
        'NEXT_POST' => 'Nächster Beitrag →',
        'NEXT_POSTS' => 'Nächste Beiträge →',
        'NING_ID' => 'Ning ID',
        'NING_ID_LETS_YOU_CHOOSE' => 'Das Ning ID Authentifizierungssystem erlaubt es Ihnen, sich mittels einer E-Mail Adresse und einem Passwort zu registrieren. Damit können Sie sich dann bei allen Netzwerken auf Ning registrieren und Mitglied des Netzwerkes werden.',
        'NING_RESOURCES' => 'Ning Ressourcen',
        'NO' => 'Nein',
        'NOBODY_HAS_ADDED_DISCUSSIONS' => 'Es gibt noch keine Diskussionen in diesem Netzwerk.',
        'NOBODY_HAS_ADDED_DISCUSSIONS_ADD' => 'Es gibt noch keine Diskussionen in diesem Netzwerk! Legen Sie los und starten Sie eine Diskussion.',
        'NOBODY_HAS_ADDED_PAGES' => 'Es gibt noch keine Seiten in diesem Netzwerk!',
        'NOBODY_HAS_ADDED_PHOTOS' => 'Es gibt noch keine Fotos in diesem Netzwerk! Legen Sie los und fügen Sie ein paar Fotos hinzu.',
        'NOBODY_HAS_ADDED_VIDEOS' => 'Es gibt noch keine Videos in diesem Netzwerk! Legen Sie los und fügen Sie ein paar Videos hinzu.',
        'NOBODY_HAS_CREATED_GROUPS' => 'Es gibt noch keine Gruppen in diesem Netzwerk.',
        'NOBODY_HAS_CREATED_GROUPS_ADD' => 'Es gibt noch keine Gruppen in diesem Netzwerk! Legen Sie los und gründen Sie eine Gruppe.',
        'NONE' => 'Keine',
        'NONE_I_DO_NOT_WANT' => 'Keine: Ich möchte keine E-Mails von %s erhalten',
        'NORMAL_PLAYBACK_ON' => 'Normale Wiedergabe: An',
        'NOTHING_IS_HAPPENING_ON_YOUR_NETWORK' => 'Es gibt keine neuen Aktivitäten. Warum starten Sie nicht etwas?',
        'NOTIFICATIONS' => 'Benachrichtigungen',
        'NOTIFY' => 'Benachrichtigen',
        'NOTIFY_BLOG_PING_SERVICES' => 'Möchten Sie Benachrichtigungen an externe Blogverfolgungsdienste schicken, wenn Sie einen neuen Beitrag verfassen?',
        'NOT_ALLOWED' => 'Nicht erlaubt',
        'NOT_FOUND' => 'Nicht gefunden',
        'NOT_RATED_YET' => 'Noch nicht bewertet',
        'NOVEMBER' => 'November',
        'NOW' => 'Jetzt',
        'NOW_ALL_YOU_NEED_TO_DO_IS_INVITE_YOUR_FRIENDS' => 'Jetzt müssen Sie nur noch <a %s>Ihre Freunde einladen</a>!',
        'NOW_CUSTOMIZE_PAGE' => 'Passen Sie jetzt Ihre persönliche Seite nach ihren Wünschen an…',
        'NOW_CUSTOMIZE_SITE' => 'Passen Sie jetzt Ihr Netzwerk nach ihren Wünschen an…',
        'NOW_ENTER_PASSWORD' => 'Geben Sie jetzt Ihr Passwort ein, um fortzufahren.',
        'NOW_FEATURED_ON_MAIN' => 'Wird jetzt auf der Hauptseite vorgestellt',
        'NOW_THAT_YOU_JOINED_INVITE' => 'Jetzt wo Sie Mitglied sind, <strong><a %s>laden Sie Ihre Freunde ein</a></strong>!',
        'NO_ACCOUNT_WITH_EMAIL' => 'Es gibt kein Benutzerkonto mit dieser E-Mail Adresse.',
        'NO_ACCOUNT_WITH_EMAIL_X' => 'Es gibt kein Benutzerkonto mit der E-Mail Adresse %s',
        'NO_ACTIVITY_TO_DISPLAY' => 'Es wird derzeit keine Aktivität angezeigt.',
        'NO_ADDRESSES_FOUND' => 'Keine Adressen gefunden',
        'NO_ALBUMS_CONTAINING_PHOTO' => 'Kein Album enthält dieses Foto. Sie können <a %s>ein neues Album erstellen</a>.',
        'NO_BLOG_POSTS_TAGGED_X_CHECK' => 'Es gibt keine Blog Beiträge mit dem Schlagwort "%1$s". Sehen Sie sich <a %2$s>Diskussionen</a>, <a %4$s>Fotos</a> oder <a %3$s>Videos</a> mit dem Schlagwort "%1$s" an. Oder schreiben Sie Ihre eigenen Blog Beiträge und ordnen ihnen Schlagworte zu!',
        'NO_CHANGED_ITEMS' => 'Es gibt keine geänderten Elemente.',
        'NO_COMMENTS' => 'Keine Kommentare',
        'NO_COMMENTS_YET' => 'Noch keine Kommentare!',
        'NO_DESCRIPTION' => 'Ohne Beschreibung',
        'NO_DISCUSSIONS_IN_CATEGORY' => 'Es gibt noch keine Diskussionen in dieser Kategorie.',
        'NO_DISCUSSIONS_TAGGED_X' => 'Es gibt keine Diskussionen mit dem Schlagwort "%1$s".',
        'NO_DISCUSSIONS_TAGGED_X_CHECK' => 'Es gibt keine Diskussionen mit dem Schlagwort "%1$s". Sehen Sie sich <a %2$s>Fotos</a>, <a %4$s>Blog-Beiträge</a> oder <a %2$s>Videos</a> mit dem Schlagwort "%1$s" an.',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_ADD' => 'Es gibt keine Diskussionen mit dem Schlagwort "%1$s". Sehen Sie sich <a %2$s>Fotos</a>, <a %4$s>Blog-Beiträge</a> oder <a %2$s>Videos</a> mit dem Schlagwort "%1$s" an. Oder starten Sie Ihre eigenen Diskussionen hinzu und geben Sie ihnen Schlagworte!',
        'NO_DISCUSSION_TO_DISPLAY' => 'Es werden derzeit keine Diskussionen angezeigt.',
        'NO_FEATURED_TRACKS' => 'In diesem Netzwerk werden derzeit keine Songs vorgestellt.',
        'NO_FEED_TO_DISPLAY' => 'Es werden derzeit keine Elemente angezeigt.',
        'NO_FILE_WAS_UPLOADED' => 'Das Hochladen ist fehlgeschlagen; eventuell war der Dateiname fehlerhaft.',
        'NO_FRIENDS_ON_SITE' => 'Noch keine Freunde in diesem Netzwerk.',
        'NO_FRIENDS_ON_SITE_THAT_MATCH' => 'Keine Freunde in diesem Netzwerk, auf die Ihre Suche passt.',
        'NO_GROUPS_TO_DISPLAY' => 'Es werden derzeit keine Gruppen angezeigt.',
        'NO_LOCATION' => 'Kein Ort',
        'NO_MEMBERS_TO_DISPLAY' => 'Es werden derzeit keine Mitglieder angezeigt.',
        'NO_MISSING_ITEMS' => 'Es gibt keine fehlenden Elemente – diese Übersetzung ist 100%% vollständig. <a %s>Alle Elemente anzeigen. </a>',
        'NO_MODELS_RESET' => 'Keine Modelle zurückgesetzt.',
        'NO_ONE_CREATED_ALBUMS' => 'Anscheinend hat noch niemand ein Album erstellt. Sie können <a %s>hier ein Album erstellen</a>.',
        'NO_ONE_HAS_ADDED_ANY_PHOTOS' => 'Es wurden noch keine Fotos zu Ihrem Netzwerk hinzugefügt. Seien Sie der Erste, der <a %s>Fotos hinzufügt!</a>',
        'NO_ONE_HAS_ADDED_ANY_VIDEOS' => 'Es wurden noch keine Videos zu Ihrem Netzwerk hinzugefügt.  Seien Sie der Erste, der ein Video hinzufügt!',
        'NO_PAGE_YET' => 'Noch keine Seite',
        'NO_PHOTOS_AVAILABLE' => 'Das Album beinhaltet derzeit keine Fotos. <a %s>Klicken Sie hier um alle Alben zu sehen</a>.',
        'NO_PHOTOS_AWAITING_APPROVAL' => 'Es gibt derzeit keine Fotos, die kontrolliert werden müssen. Warum werfen Sie nicht mal einen Blick auf die <a %s>neusten Fotos</a>?',
        'NO_PHOTOS_TAGGED_X_CHECK' => 'Es gibt keine Fotos mit dem Schlagwort "%1$s". Sehen Sie sich <a %2$s>Diskussionen</a>, <a %4$s>Blog-Beiträge</a> oder <a %2$s>Videos</a> mit dem Schlagwort "%1$s" an. Oder fügen Sie Ihre eigenen Fotos hinzu und geben Sie ihnen Schlagworte!',
        'NO_POSTS' => 'Keine Beiträge',
        'NO_POSTS_TO_DISPLAY' => 'Keine anzuzeigenden Beiträge.',
        'NO_PUBLISH_COMMENTS' => 'Nein – Kommentare sofort veröffentlichen',
        'NO_TAG_WAS_SPECIFIED' => 'Es wurde kein Schlagwort angegeben.',
        'NO_TITLE' => 'Ohne Titel',
        'NO_TRACKS_TO_PLAY' => 'Es gibt derzeit keine Musik in Ihrem Netzwerk.',
        'NO_VIDEOS_AWAITING_APPROVAL' => 'Es gibt derzeit keine Videos, die kontrolliert werden müssen. Warum werfen Sie nicht mal einen Blick auf die <a %s>neusten Videos</a>?',
        'NO_VIDEOS_TAGGED_X_CHECK' => 'Es gibt keine Videos mit dem Schlagwort "%1$s". Sehen Sie sich <a %2$s>Diskussionen</a>, <a %4$s>Blog-Beiträge</a> oder <a %2$s>Fotos</a> mit dem Schlagwort "%1$s" an. Oder fügen Sie Ihre eigenen Videos hinzu und geben Sie ihnen Schlagworte!',
        'NO_VIDEOS_TO_DISPLAY' => 'Es werden derzeit keine Videos angezeigt.',
        'N_KB' => '%s KB',
        'N_MB' => '%s MB',
        'N_NEW' => '%s neue',
        'OCTOBER' => 'Oktober',
        'OK' => 'OK',
        'OLDER_PHOTOS' => 'Ältere Fotos',
        'ONE_LINE_ANSWER' => 'Einzeilige Antwort',
        'ONLINE' => 'Online',
        'ONLINE_NOW' => 'Jetzt online',
        'ONLY_INVITED_PEOPLE' => 'Nur eingeladene Personen',
        'ONLY_INVITED_PEOPLE_CAN_JOIN_GROUP' => 'Nur eingeladene Personen können dieser Gruppe beitreten',
        'ONLY_I_CAN_SEE_PHOTO' => 'Nur ich darf dieses Foto sehen',
        'ONLY_I_CAN_START_DISCUSSIONS' => 'Nur ich darf Diskussionen in dieser Kategorie starten',
        'ONLY_MY_FRIENDS' => 'Nur meine Freunde',
        'ONLY_MY_FRIENDS_CAN_SEE_PHOTO' => 'Nur meine Freunde dürfen dieses Foto sehen',
        'ONLY_XS_FRIENDS_CAN_SEE_PHOTO' => 'Nur die Freunde von %s dürfen dieses Foto sehen',
        'ONLY_X_CAN_SEE_PHOTO' => 'Nur %s darf dieses Foto sehen',
        'ON_X' => 'auf %s',
        'ON_X_COLON' => 'Auf %s:',
        'OOPS_THAT' => 'Ups – Das hat leider nicht funktioniert.',
        'OOPS_THAT_DID_NOT_WORK' => 'Ups – Das hat leider nicht funktioniert. Nochmal versuchen?',
        'OOPS_THAT_DID_NOT_WORK_ERROR_CODE' => 'Ups – Das hat leider nicht funktioniert (%s).',
        'OPEN_POPUP_WINDOW' => 'Popup Fenster öffnen',
        'OPTIONS' => 'Optionen',
        'ORGANIZE_FEATURES' => 'Organisieren Sie Ihre Hauptseite, indem Sie Funktionen aus der Liste unten ziehen und nach Ihren Wünschen anordnen.',
        'ORIGINAL_TEXT_X' => 'Originaltext – %s',
        'OR_SHARE_THIS_INVITATION_LINK' => 'Oder versenden Sie diesen Einladungslink:',
        'OR_SIGN_IN' => 'oder <a %s> Anmelden </a>',
        'OR_YOU_CAN_GO' => 'Alternativ können Sie zur <a %s>%s Hauptseite</a> zurückkehren oder <a %s>andere soziale Netzwerke auf Ning</a> ansehen.',
        'OTHER' => 'andere',
        'OTHER_ELLIPSIS' => 'andere…',
        'OUR_APOLOGIES' => 'Wir bitten um Entschuldigung.',
        'OWNER_DISCUSSIONS_ONLY' => 'Nur Diskussionen des Netzwerkgründers',
        'OWNER_POSTS_ONLY' => 'Nur Beiträge des Netzwerkgründers',
        'PAGE' => 'Seite',
        'PAGE_ADDRESS' => 'Seitenadresse',
        'PAGE_ADDRESS_NOT_VALID' => 'Die Seitenadresse darf nur die Buchstaben A bis Z, Zahlen und den Unterstrich (_) enthalten.',
        'PAGE_ADDRESS_TAKEN' => 'Wir bitten um Entschuldigung - diese Adresse ist leider schon vergeben. Bitte wählen Sie eine andere aus.',
        'PAGE_CONTENT' => 'Inhalt:',
        'PAGE_NOT_FOUND' => 'Seite nicht gefunden',
        'PAGE_TITLE' => 'Seitentitel',
        'PAGE_TITLE_COLON' => 'Seitentitel:',
        'PART_OF_FILE_WAS_UPLOADED' => 'Nur ein Teil der Datei konnte hochgeladen werden.',
        'PASSWORD' => 'Passwort',
        'PASSWORDS_DO_NOT_MATCH' => 'Die beiden Passwörter stimmen nicht überein.',
        'PASTE_IN_EMBED' => 'Fügen Sie hier den Einbettungscode des Videos ein:',
        'PENDING' => 'Ausstehend',
        'PENDING_APPROVAL' => 'Muss noch akzeptiert werden',
        'PEOPLE_IVE_INVITED_JOIN' => 'Die Personen, die ich in dieses Netzwerk eingeladen habe',
        'PERMALINK' => 'Permanenter Link',
        'PERMALINK_TO_REPLY' => 'Permanenter Link zu dieser Antwort',
        'PERSON_DOES_NOT_HAVE_MUSIC' => 'Diese Person hat noch keine Musik.',
        'PERSON_DOES_NOT_HAVE_PHOTOS' => 'Diese Person hat noch keine Fotos.',
        'PERSON_DOES_NOT_HAVE_VIDEOS' => 'Diese Person hat noch keine Videos.',
        'PERSON_IN_CHARGE' => 'Die für %s verantwortliche Person möchte einen Blick auf Ihr Werk werfen, bevor es der ganzen Welt gezeigt wird.',
        'PHOTO' => 'Foto',
        'PHOTOS' => 'Fotos',
        'PHOTOS_EXCEEDED_LIMIT' => 'Die Foto(s) scheinen die maximale Größe von 10 MB pro Foto überschritten zu haben.',
        'PHOTOS_HOME' => 'Fotos Startseite',
        'PHOTOS_SUCCESSFULLY_UPLOADED' => 'Ihre Fotos wurden erfolgreich hochgeladen.',
        'PHOTOS_TAB_TEXT' => 'Fotos',
        'PHOTOS_UPLOADED_AWAITING' => 'Ihre Fotos wurden erfolgreich hochgeladen und müssen jetzt nur noch vom Gründer von %s akzeptiert werden.',
        'PHOTO_ALBUM' => 'Fotoalbum',
        'PHOTO_BY_X' => 'Foto von %s',
        'PHOTO_IS_WAITING_FOR_APPROVAL' => 'Dieses Foto <strong>muss noch</strong> vom Besitzer von %s <strong>akzeptiert</strong> werden.',
        'PHOTO_MAY_BE_10MB' => 'Fotos dürfen jeweils bis zu 10 MB groß sein, kleinere Fotos werden aber schneller hochgeladen.',
        'PHOTO_MUST_BE_TYPE' => 'Ihr Photo muss eine .jpg-, .gif- oder .png-Datei sein.',
        'PHOTO_SLIDESHOW' => 'Diashow',
        'PHOTO_SLIDESHOW_PROPER' => 'Foto-Diashow',
        'PHOTO_UPLOADED_ON_X' => 'Foto auf %s hochgeladen',
        'PHOTO_UPLOADER_REQUIRES_JAVA' => 'Das Foto Hochladetool benötigt eine aktuelle Java Version. <strong><a %s>Klicken Sie hier um Java herunterzuladen</a></strong>, oder <strong><a %s>wechseln Sie zum einfachen Hochladeformular</a></strong>.',
        'PICK_VALID_ACTIVITY_NOTIFICATION' => 'Bitte treffen Sie eine gültige Auswahl für Benachrichtigungen bei Aktivitäten.',
        'PICK_VALID_ALL_FRIENDS_NOTIFICATION' => 'Bitte treffen Sie eine gültige Auswahl für Benachrichtigungen über Nachrichten, die an alle Freunde gesendet wurden.',
        'PICK_VALID_APPROVAL_NOTIFICATION' => 'Bitte treffen Sie eine gültige Auswahl für Benachrichtigungen über zu kontrollierende Inhalte.',
        'PICK_VALID_BLOG_COMMENT_MODERATION' => 'Bitte treffen Sie eine gültige Auswahl für die Moderation von Blog-Kommentaren.',
        'PICK_VALID_DEFAULT_VISIBILITY' => 'Bitte treffen Sie eine gültige Auswahl für die Standardeinstellung zur Sichtbarkeit.',
        'PICK_VALID_FRIEND_REQUEST_NOTIFICATION' => 'Bitte treffen Sie eine gültige Auswahl für Benachrichtigungen über Freundschaftsanfragen.',
        'PICK_VALID_INVITEE_NOTIFICATION' => 'Bitte treffen Sie eine gültige Auswahl für Benachrichtigungen, das eingeladene Personen Mitglied geworden sind.',
        'PICK_VALID_MODERATION_NOTIFICATION' => 'Bitte treffen Sie eine gültige Auswahl für Benachrichtigungen über zu moderierende Inhalte.',
        'PICK_VALID_NEVER_NOTIFICATION' => 'Bitte treffen Sie eine gültige Auswahl, wenn Sie keinerlei Benachrichtigungen erhalten möchten.',
        'PICK_VALID_NEW_MESSAGE_NOTIFICATION' => 'Bitte treffen Sie eine gültige Auswahl für Benachrichtigungen über neue Nachrichten.',
        'PICK_VALID_WHO_CAN_COMMENT' => 'Bitte treffen Sie eine gültige Auswahl zur Frage wer Kommentare abgeben darf.',
        'PIXELS' => 'Pixel',
        'PLAY' => 'Abspielen',
        'PLAYER_COLOR' => 'Farbe des Players',
        'PLAYLIST' => 'Wiedergabeliste',
        'PLAY_AGAIN' => 'Nochmal abspielen',
        'PLAY_MUSIC_ON_WEBSITE' => 'Spielen Sie Ihre Musik mit unserem eleganten Musik-Player auf einer Website oder MySpace-Seite.',
        'PLEASE_CHECK_YOUR_BROWSER_SETTINGS' => 'Bitte überprüfen Sie Ihre Browser-Einstellungen oder kontaktieren Sie Ihren Systemadministrator.',
        'PLEASE_CHOOSE_FRIENDS' => 'Bitte wählen Sie die Freunde aus, an die Sie Nachricht versenden wollen.',
        'PLEASE_CORRECT_THE_FOLLOWING' => 'Bitte korrigieren Sie dies:',
        'PLEASE_ENTER_CODE' => 'Bitte geben Sie den Code ein, der rechts angezeigt wird.',
        'PLEASE_ENTER_CURRENT_PASSWORD' => 'Bitte geben Sie Ihr aktuelles Passwort ein.',
        'PLEASE_ENTER_EMAIL_ADDRESS' => 'Bitte geben Sie Ihre E-Mail Adresse an.',
        'PLEASE_ENTER_EMAIL_ADDRESSES' => 'Bitte geben Sie eine oder mehrere E-Mail Adressen ein.',
        'PLEASE_ENTER_FIRST_POST' => 'Bitte verfassen Sie den ersten Beitrag für die Diskussion.',
        'PLEASE_ENTER_NAME' => 'Bitte geben Sie Ihren Namen ein',
        'PLEASE_ENTER_NAME_FOR_GROUP' => 'Bitte wählen Sie einen Namen für Ihre Gruppe.',
        'PLEASE_ENTER_NEW_PASSWORD' => 'Bitte geben Sie Ihr neues Passwort ein.',
        'PLEASE_ENTER_NEW_PASSWORD_AGAIN' => 'Bitte geben Sie Ihr neues Passwort noch einmal im Feld "Passwort bestätigen" ein.',
        'PLEASE_ENTER_PAGE_ADDRESS' => 'Bitte geben Sie eine neue Seitenadresse ein.',
        'PLEASE_ENTER_PAGE_CONTENT' => 'Bitte geben Sie den Inhalt der Seite ein.',
        'PLEASE_ENTER_PASSWORD' => 'Bitte geben Sie Ihr Passwort ein.',
        'PLEASE_ENTER_PASSWORD_AGAIN' => 'Bitte geben Sie Ihr Passwort noch einmal im Feld "Passwort bestätigen" ein.',
        'PLEASE_ENTER_PASSWORD_FOR_EMAIL' => 'Bitte geben Sie Ihr Passwort für %s ein.',
        'PLEASE_ENTER_SOMETHING_FOR_X' => 'Bitte geben Sie etwas ein für: %s',
        'PLEASE_ENTER_TITLE' => 'Bitte geben Sie der Diskussion einen Titel',
        'PLEASE_ENTER_URL_FOR_GROUP' => 'Bitte wählen Sie eine Webadresse für Ihre Gruppe.',
        'PLEASE_ENTER_YOUR_FRIENDS' => 'Bitte geben Sie die E-Mail Adressen oder Ning IDs Ihrer Freunde ein',
        'PLEASE_KEEP_THIS_PAGE_OPEN_WHILE_IMPORT' => 'Bitte lassen Sie diese Seite geöffnet, damit der Import Ihrer Fotos abgeschlossen werden kann.',
        'PLEASE_LINK_ONLY_TRACKS' => 'Bitte verlinken Sie nur Musik, die für die Verbreitung im Internet freigegeben ist.',
        'PLEASE_PROVIDE_DATE_FOR_X' => 'Bitte geben Sie ein Datum an für: %s',
        'PLEASE_PROVIDE_VALID_DATE_FOR_X' => 'Bitte geben Sie ein gültiges Datum an für: %s',
        'PLEASE_SELECT_A_MEMBER' => 'Bitte wählen Sie einen oder mehrere Mitglieder aus',
        'PLEASE_SELECT_OPTION_FOR_X' => 'Bitte wählen Sie eine Option aus für: %s',
        'PLEASE_SELECT_SECOND_PART' => 'Bitte wählen Sie den zweiten Teil Ihrer E-Mail Adresse, z.B. gmail.com.',
        'PLEASE_TRY_REFRESHING' => 'Bitte laden Sie die Seite in 30 Sekunden noch einmal, oder <a %s>informieren Sie uns</a>, falls Sie diese Nachricht erneut erhalten.',
        'PLEASE_UPLOAD_ONLY_TRACKS' => 'Bitte laden Sie nur Songs hoch, für die Sie die Genehmigung des Künstlers oder des Copyright-Besitzers haben.',
        'PLEASE_WRITE_SOMETHING_FOR_POST' => 'Bitte geben Sie Text für Ihren Beitrag ein.',
        'PLEASE_WRITE_SOMETHING_FOR_REPLY' => 'Bitte geben Sie Text für Ihre Antwort ein.',
        'PM' => 'PM',
        'PODCAST' => 'Podcast',
        'POPULAR_CONTRIBUTORS' => 'Aktive Mitwirkende',
        'POPULAR_MEMBERS' => 'Aktive Mitglieder',
        'POPULAR_PHOTOS' => 'Populäre Fotos',
        'POPULAR_POSTS' => 'Die meisten Kommentare',
        'POPULAR_TAGS' => 'Populäre Schlagworte',
        'POST' => 'Beitrag',
        'POSTED_BY_ME_LINK_ON_X_AT_X' => 'Geschrieben von <a %s>mir</a> am %s um %s —',
        'POSTED_BY_ME_ON_X_AT_X' => 'Geschrieben von mir am %s um %s —',
        'POSTED_BY_X_ON' => 'Geschrieben von %s am %s',
        'POSTED_BY_X_ON_X_AT_X' => 'Geschrieben von %s auf %s um %s —',
        'POSTED_ON_X' => 'Geschrieben am <strong>%s</strong> um <small>%s</small>',
        'POSTED_ON_X_BY' => 'Geschrieben am <strong>%s</strong> um <small>%s</small> von:',
        'POST_COMMENT' => 'Kommentar SCHREIBEN',
        'POST_HAS_BEEN_DELETED' => 'Der Beitrag wurde gelöscht',
        'POST_TITLE' => 'Titel des Beitrags',
        'PREVIEW' => 'Vorschau',
        'PREVIOUS' => 'Vorherige',
        'PREVIOUS_ALBUM_PAGE' => 'Vorherige Albumseite',
        'PREVIOUS_POST' => '← Vorheriger Beitrag',
        'PREVIOUS_POSTS' => '← Vorheriger Beiträge',
        'PRIVACY' => 'Privatsphäre',
        'PRIVACY_AND_COMMENTS' => 'Privatsphäre & Kommentare',
        'PRIVACY_CANNOT_BE_CHANGED' => 'Die Einstellungen zur Privatsphäre können nicht mehr verändert werden, nachdem die Gruppe erstellt wurde.',
        'PRIVACY_CONTENT_CONTROL' => 'Privatsphäre & Inhaltskontrolle',
        'PRIVACY_POLICY' => 'Datenschutzrichtlinie',
        'PRIVATE' => 'Privat',
        'PRIVATE_ONLY_INVITED' => '<strong>Privat</strong> – Nur eingeladene Personen können das Netzwerk sehen und Mitglied werden',
        'PRIVATE_PHOTO' => '<strong>Privates</strong> Foto',
        'PRIVATE_VIDEO' => '<strong>Privates</strong> Video',
        'PROBLEMS_SIGNING_IN' => 'Probleme beim Anmelden?',
        'PROBLEMS_SIGNING_UP' => 'Probleme beim Registrieren?',
        'PROBLEMS_SIGNING_UP_OR_SIGNING_IN' => 'Probleme beim Registrieren oder Anmelden',
        'PROBLEM_OCCURRED_CONVERTING_VIDEO' => 'Ein Problem trat bei der Konvertierung des Videos in das Flash Format auf: %s',
        'PROBLEM_OCCURRED_DURING_UPLOAD' => 'Ein Problem trat während des Hochladens auf.',
        'PROBLEM_OCCURRED_RETRIEVING_FEED' => 'Bei Laden des RSS-Feeds ist ein Problem aufgetreten.',
        'PROBLEM_OCCURRED_RETRIEVING_GADGET' => 'Bei laden der URL des Gadgets ist ein Problem aufgetreten.',
        'PROBLEM_SIGNING_IN' => 'Es gab ein Problem bei der Anmeldung',
        'PROBLEM_SIGNING_UP' => 'Es gab ein Problem bei der Registrierung',
        'PROBLEM_WITH_ICON' => 'Es gab ein Problem mit der Bilddatei für die Gruppe.',
        'PROFILE' => 'Profil',
        'PROFILE_INFORMATION_SAVED' => 'Profilinformationen gespeichert',
        'PROFILE_QUESTIONS' => 'Profilfragen',
        'PROFILE_SAVED' => 'Ihre Änderungen wurden erfolgreich gespeichert.',
        'PROMOTED_POSTS' => 'Vorgestellte Beiträge',
        'PROMOTE_NETWORK_WITH_BADGES' => 'Bewerben Sie Ihr Netzwerk im Internet mit Abzeichen und Widgets',
        'PROMOTE_TO_ADMINISTRATOR' => 'Zu einem Administrator machen',
        'PROMOTE_YOUR_NETWORK' => 'Bewerben Sie Ihr Netzwerk',
        'PUBLIC' => 'Öffentlich',
        'PUBLICDOMAIN' => 'Lizenzfrei',
        'PUBLIC_ANYBODY_CAN_JOIN' => '<strong>Öffentlich</strong> – Jeder kann Mitglied werden',
        'PUBLIC_PHOTOS_TAGGED_WITH_X' => 'Öffentliche Fotos auf %2$s mit dem Schlagwort %1$s',
        'PUBLISH' => 'Veröffentlichen!',
        'PUBLISHED_N_OF_N' => '%d von %d veröffentlicht',
        'PUBLISH_POST' => 'Beitrag veröffentlichen',
        'PUT_ANY_TEXT_WIDGET_OR_HTML' => 'Plazieren Sie beliebigen Text, Widgets oder HTML auf der Hauptseite.',
        'PUT_A_CONSTANTLY_UPDATED_STREAM' => 'Plazieren Sie einen fortwährend aktualisierten Strom von Aktivitäten in Ihrem Netzwerk auf der Hauptseite.',
        'QUESTION_TITLE' => 'Titel der Frage',
        'RATE' => 'Bewerten',
        'RATING_NOT_RATED_YET' => '<strong>Bewertung:</strong> Noch nicht bewertet',
        'READ_MORE' => 'Weiterlesen',
        'RECENTLY_ADDED' => 'Kürzlich hinzugefügt',
        'RECENTLY_ADDED_POSTS' => 'Kürzlich hinzugefügt',
        'RECENTLY_JOINED' => 'Neue Mitglieder',
        'RECENT_POSTS' => 'Neue Beiträge',
        'RECENT_PUBLIC_PHOTOS_ON_X' => 'Neue öffentliche Fotos auf %s',
        'REFRESH' => 'Aktualisieren',
        'RELATED_VIDEOS' => 'Ähnliche Videos',
        'REMOVE' => 'Entfernen',
        'REMOVED_FROM_MAIN' => 'Von der Hauptseite entfernt',
        'REMOVE_BAN' => 'Ausschluss widerrufen',
        'REMOVE_FROM_FAVORITES' => 'Aus Favoriten entfernen',
        'REMOVE_FROM_HOME' => 'Von der Hauptseite entfernen',
        'REMOVE_THIS_FROM_YOUR' => 'Von der Hauptseite entfernen',
        'REMOVE_VIDEO_FROM_FAVORITES' => 'Dieses Video aus Ihren Favoriten entfernen?',
        'REMOVE_X' => '%s entfernen',
        'REMOVE_X_AND_ALL_CONTENT' => '%1$s und ihre/seine gesamten Daten aus Ihrem Netzwerk entfernen.',
        'REMOVING_MEMBERS' => 'Mitglieder werden entfernt',
        'REMOVING_X' => '%s wird entfernt',
        'REOPEN_DISCUSSION' => 'Diskussion wieder öffnen',
        'REPEAT_PLAYBACK_ON' => 'Wiederholte Wiedergabe: An',
        'REPLIES_CLOSED_FOR_DISCUSSION' => 'Die Diskussion ist für weitere Antworten geschlossen.',
        'REPLIES_TO_THIS_DISCUSSION' => 'Antworten zu dieser Diskussion',
        'REPLY_BY_X_T' => 'Antwort von <strong>%s</strong> %s',
        'REPLY_DELETED' => 'Antwort gelöscht',
        'REPLY_HAS_BEEN_DELETED' => 'Diese Antwort wurde gelöscht. <a %s>Zurück zur Diskussion.</a>',
        'REPLY_TO_THIS' => 'Darauf antworten',
        'REPLY_WAS_DELETED' => 'Diese Antwort wurde gelöscht',
        'REPORT_AN_ISSUE' => 'Ein Problem melden',
        'REQUESTED_INVITE' => 'Einladung angefragt',
        'REQUEST_AN_INVITATION' => 'Einladung erfragen',
        'REQUEST_A_COPY_OF_THE_SOURCE_CODE' => 'Entwickler: Fragen Sie nach Quellcode für Ihr Netzwerk.',
        'REQUEST_SENT' => 'Anfrage gesendet!',
        'REQUEST_SOURCE_CODE' => 'Nach dem Quellcode fragen',
        'REQUIRED' => 'Erforderlich',
        'REQUIRED_FIELD' => '(Erforderliches Feld)',
        'RESEND_INVITATION' => 'Einladung nochmal senden',
        'RESET_PASSWORD' => 'Passwort zurücksetzen',
        'RESET_PASSWORD_EMAIL_BODY' => '%1$s,

        Wir haben eine Anfrage erhalten, Ihr Passwort für %2$s zu ändern.

        Klicken Sie auf den folgenden Link, um ein neues Passwort festzulegen:

        #{URL}

        Bitte ignorieren Sie diese E-Mail, wenn Sie Ihr Passwort nicht ändern möchten.

        Vielen Dank,
        Ihr "%2$s"-Team

        -----
        %2$s verwendet die Ning ID zur Authentifizierung.',
        'RESET_PASSWORD_EMAIL_SUBJECT' => 'Passwort zurücksetzen',
        'RESET_TEXT_TO_ORIGINAL_VERSION' => 'Text zur Originalversion zurücksetzen',
        'RESOURCES' => 'Ressourcen',
        'RETURN_TO_PHOTOS_HOME' => 'Zur Foto Startseite zurückkehren',
        'RETURN_TO_X' => 'Zu %s zurückkehren',
        'RETYPE_PASSWORD' => 'Passwort wiederholen',
        'REWIND' => 'Zurückspulen',
        'ROTATE_PHOTO' => 'Foto drehen',
        'RSS' => 'RSS',
        'RSS_FEED_LABEL' => '<a %s>RSS Feed</a> – %s',
        'RSS_LINK' => '<a %s>RSS</a>',
        'SAD' => 'Traurig',
        'SAMPLE_TITLE' => 'Beispieltitel',
        'SAVE' => 'Speichern',
        'SAVE_ALBUM' => 'Album speichern',
        'SAVE_AS_DRAFT' => 'Als Entwurf speichern',
        'SAVE_CHANGES' => 'Änderungen speichern',
        'SAVE_FEATURES' => 'Funktionsauswahl speichern',
        'SAVE_ITEMS_ON_PAGE' => 'Elemente auf dieser Seite speichern',
        'SAVE_PAGE' => 'Seite speichern',
        'SAVE_SETTINGS' => 'Einstellungen speichern',
        'SAVE_YOUR_ALBUM' => 'Speichern Sie Ihr Album!',
        'SCHEDULED_TO_PUBLISH_ON' => 'Wird veröffentlicht am: %s',
        'SEARCH' => 'Suche',
        'SEARCH_AGAIN' => 'Nochmal suchen',
        'SEARCH_DISCUSSIONS' => 'Nach Diskussionen suchen',
        'SEARCH_FRIENDS' => 'Nach Freunden suchen:',
        'SEARCH_FRIENDS_TO_INVITE' => 'Nach Freunde zum Einladen suchen:',
        'SEARCH_GROUPS' => 'Nach Gruppen suchen',
        'SEARCH_MEMBERS' => 'Nach Mitgliedern suchen',
        'SEARCH_PAGES' => 'Seiten durchsuchen',
        'SEARCH_PEOPLE' => 'Nach Personen suchen:',
        'SEARCH_RESULTS' => 'Suchergebnisse',
        'SEARCH_RESULTS_FOR_X' => 'Suchergebnisse für <em>%s</em>',
        'SEE_EVERYTHING' => 'Alles sichtbar',
        'SEE_JUST_THE_MAIN_PAGE' => 'Nur die Hauptseite sichtbar',
        'SEE_JUST_THE_SIGN_UP_PAGE' => 'Nur die Anmeldungsseite sichtbar',
        'SEE_PHOTOS_ON_NETWORK' => 'Diese Fotos auf %s ansehen',
        'SEE_VIDEO_ON_NETWORK' => 'Dieses Video auf %s ansehen',
        'SELECT' => 'Auswählen…',
        'SELECT_ALL_NONE' => 'Alle/Keine auswählen',
        'SELECT_ELLIPSIS' => 'Auswählen…',
        'SELECT_LICENSE' => '— Lizenz auswählen —',
        'SELECT_TRANSLATION_FILE' => 'Übersetzungsdatei auswählen:',
        'SEND' => 'Senden',
        'SEND_AN_INVITATION_TO_X' => 'Einladung an %s senden',
        'SEND_A_MESSAGE' => 'Nachricht senden',
        'SEND_BROADCAST_MESSAGE' => 'Nachricht an alle Mitglieder senden',
        'SEND_FEEDBACK' => 'Feedback senden',
        'SEND_INVITATIONS' => 'Einladungen senden',
        'SEND_INVITATIONS_FOR_FRIENDS' => 'Senden Sie Einladungen an Ihre Freunde',
        'SEND_INVITATIONS_TO_JOIN_GROUP' => 'Laden Sie andere Personen zu %s ein.',
        'SEND_MESSAGE' => 'Nachricht senden',
        'SEND_MESSAGE_TO_ALL_THIS' => 'Senden Sie eine Nachricht an alle Mitglieder dieses Netzwerks.',
        'SEND_MESSAGE_TO_FRIENDS' => 'Nachricht an Freunde senden',
        'SEND_MESSAGE_TO_GROUP' => 'Nachricht an Gruppe senden',
        'SEND_ONE_PHOTO_OR_VIDEO' => 'Senden Sie ein Foto oder Video per E-Mail. Der E-Mail-Betreff wird als Titel des Fotos oder Videos verwendet, der Text der E-Mail als Beschreibung.',
        'SEND_PRIVATE_MESSAGE' => 'Private Nachricht senden',
        'SEND_REPORT' => 'Problembericht senden',
        'SEND_REQUEST' => 'Anfrage senden',
        'SEND_TO' => 'Senden an',
        'SEND_WITH_EMAIL_PROGRAM' => 'Senden Sie es mit einem E-Mail Programm von Ihrem Computer:',
        'SEND_X_A_MESSAGE_HERE' => 'Senden Sie hier eine Nachricht an %s:',
        'SENT' => 'Abgeschickt!',
        'SEPARATE_EACH_CHOICE' => 'Trennen Sie die Antwortmöglichkeiten durch Kommas',
        'SEPARATE_EACH_KEYWORD' => 'Trennen Sie mehrere Schlüsselwörter durch Kommas',
        'SEPARATE_MULTIPLE_ADDRESSES' => 'Trennen Sie mehrere E-Mail Adressen durch Kommas',
        'SEPTEMBER' => 'September',
        'SETUP_YOUR_SITE_TO' => 'Konfigurieren Sie Ihr Netzwerk für den Import von Fotos von Flickr.',
        'SET_NEW_PASSWORD' => 'Setzen Sie ein neues Passwort für Ihr Ning ID Benutzerkonto.',
        'SET_PASSWORD' => 'Passwort setzen',
        'SHARE' => 'Mit anderen teilen',
        'SHARE_LINK_WITH_PEOPLE' => 'Teilen Sie diesen Link mit anderen, die Sie gern in diesem Netzwerk als Mitglied sehen möchten.',
        'SHARE_THIS_LINK' => 'Diesen Link weitergeben:',
        'SHARE_THIS_WITH_FRIENDS' => 'Mit Ihren Freunden teilen',
        'SHARE_TITLE' => '\'%s\' mit anderen teilen',
        'SHARE_TYPE' => '%s mit anderen teilen',
        'SHARE_WITH_FRIENDS' => 'Mit Freunden teilen',
        'SHOW_ALL' => 'Alle anzeigen',
        'SHOW_ALLEGIANCE_GET_BADGE' => 'Zeigen Sie Ihre Verbundenheit. Holen Sie sich Ihr eigenes %s Abzeichen und binden Sie es in Ihre Website oder MySpace-Seite ein. (<a %s>Einbettungscode anfordern</a>)',
        'SHOW_ALL_TEXT' => 'Den gesamten Text anzeigen',
        'SHOW_CHANGED_TEXT' => 'Den geänderten Text anzeigen',
        'SHOW_LATEST_ACTIVITY_ON_YOUR_NETWORK' => 'Aktuelle Aktivitäten in Ihrem Netzwerk anzeigen!',
        'SHOW_LOGO' => 'Logo anzeigen',
        'SHOW_MISSING_TEXT' => 'Den fehlenden Text anzeigen',
        'SHOW_NETWORK_DESCRIPTION' => 'Die Beschreibung des Netzwerks anzeigen',
        'SHOW_NING_LOGO' => 'Das Ning Logo anzeigen?',
        'SHUFFLE_PLAYBACK_ON' => 'Zufallswiedergabe: An',
        'SIDES' => 'Seiten',
        'SIGN_IN' => 'Anmelden',
        'SIGN_IN_OR_SIGN_UP' => '<input %s value="Anmelden" /> &#160; oder&#160;  <strong><a %s>Registrieren</a></strong>',
        'SIGN_IN_TO_APPNAME' => 'Anmelden bei %s',
        'SIGN_IN_WITH_NING_ID_WHENEVER' => 'Wenn Sie dieses Symbol sehen, dann können Sie sich mit der E-Mail-Adresse und dem Passwort Ihrer Ning ID anmelden: %s',
        'SIGN_OUT' => 'Abmelden',
        'SIGN_OUT_TITLE' => 'Abmelden',
        'SIGN_UP' => 'Registrieren',
        'SIGN_UP_FOR_X' => 'Bei %s Mitglied werden',
        'SIGN_UP_OR_SIGN_IN' => '<a %s>Bei diesem Netzwerk Mitglied werden</a>',
        'SITE' => 'Netzwerk',
        'SITE_HAS_NO_MEMBERS' => 'Dieses Netzwerk hat noch keine Mitglieder!',
        'SITE_HAS_NO_MEMBERS_THAT_MATCH' => 'Kein Mitglied in diesem Netzwerk gefunden, auf das Ihre Suche passt.',
        'SITE_IS_GETTING_STARTED' => 'Dieses soziale Netzwerk befindet sich noch im Aufbau!',
        'SITE_IS_NOT_READY' => 'Dieses soziale Netzwerk ist noch nicht fertiggestellt!',
        'SKIP_FEATURES' => 'Klicken Sie auf <a href="%s">Diesen Schritt überspringen</a>, um das Standard-Layout und die Standardfunktionen zu verwenden.',
        'SKIP_THIS_STEP' => 'Diesen Schritt überspringen',
        'SLIDESHOW' => 'Diashow',
        'SLIDESHOW_PLAYER' => 'Diashow Player',
        'SLOW_DOWN_THERE_CHIEF' => 'Wir bitten um Entschuldigung',
        'SMALL_NETWORK_BADGE' => 'Kleines Netzwerkabzeichen',
        'SMALL_N_PIXELS_WIDE' => 'Klein - %d Pixel breit',
        'SMALL_THUMBNAILS' => 'Kleine Vorschaubilder',
        'SMALL_VERSION' => 'Kleine Version',
        'SOMEBODY' => 'Jemand',
        'SOMEBODY_COMMENTED_BLOGPOST_ADDED_TO_X' => 'Jemand hat einen Kommentar zu einem Ihrer Blog-Beiträge auf %s abgegeben.',
        'SOMEBODY_COMMENTED_DISCUSSION_ADDED_TO_X' => 'Jemand hat einen Kommentar zu einer Ihrer Diskussionen auf %s abgegeben.',
        'SOMEBODY_COMMENTED_PHOTO_ADDED_TO_X' => 'Jemand hat einen Kommentar zu einem Ihrer Fotos auf %s abgegeben.',
        'SOMEBODY_COMMENTED_VIDEO_ADDED_TO_X' => 'Jemand hat einen Kommentar zu einem Ihrer Videos auf %s abgegeben.',
        'SOMEBODY_REQUESTED_JOIN_X' => 'Jemand hat darum gebeten, Mitglied von %s werden zu können',
        'SOMEBODY_UPLOADED_PHOTO_TO_X' => 'Jemand hat ein Foto auf %s hochgeladen.',
        'SOMEBODY_UPLOADED_VIDEO_TO_X' => 'Jemand hat ein Video auf %s hochgeladen.',
        'SONGS_SUCCESSFULLY_UPLOADED' => 'Ihre Songs wurden erfolgreich hochgeladen.',
        'SORRY_BUT_ADMINISTRATOR_REQUIRES_INVITATION' => 'Wir bitten um Entschuldigung, aber der Administrator hat verlangt, dass Sie eine Einladung haben, um Mitglied bei %s zu werden. Falls Sie eine Einladung haben, klicken Sie auf den Link in der E-Mail, um Mitglied zu werden.',
        'SORRY_DISCUSSION_CLOSED' => 'Wir bitten um Entschuldigung, aber diese Diskussion ist für Antworten geschlossen.',
        'SORRY_GADGET_UNAVAILABLE' => 'Wir bitten um Entschuldigung, aber dieses Gadget ist nicht verfügbar. Bitte überprüfen Sie die URL. Wenn Sie weiterhin Probleme haben, <a %s>dann teilen Sie uns dies bitte mit</a>.',
        'SORRY_HOWEVER_ITS_EASY' => '<strong>Tut uns leid!</strong> Es ist aber ganz leicht, Ihr eigenes soziales Netzwerk zu starten.',
        'SORRY_INVITATION_EXPIRED' => 'Wir bitten um Entschuldigung, aber Ihre Einladung ist leider abgelaufen. Um Mitglied bei %s zu werden, benötigen Sie eine neue Einladung.',
        'SORRY_NCS_CANNOT_CHANGE_EMAIL' => 'Netzwerkgründer können ihre E-Mail Adresse nur in Netzwerken ändern, die sie gegründet haben.',
        'SORRY_NCS_CANNOT_CHANGE_PASSWORD' => 'Netzwerkgründer können ihr Passwort nur in Netzwerken ändern, die sie gegründet haben.',
        'SORRY_NO_MEMBERS_MATCHING_X_WERE_FOUND' => 'Es tut uns leid, aber es konnten keine Mitglieder gefunden werden, auf die Ihre Suche nach "%s" passt.',
        'SORRY_USERNAME' => 'Tut uns Leid, %s',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS' => 'Es tut uns leid, %s, aber Ihr Zugriff auf %s wurde gesperrt.',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS_IF_YOU_THINK' => 'Es tut uns leid, %s, aber Ihr Zugriff auf %s wurde gesperrt. Wenn Sie glauben, dass ein Irrtum vorliegt, wenden Sie sich bitte an den Administrator des Netzwerks.',
        'SORRY_WE_DO_NOT_SUPPORT' => 'Es tut uns leid, aber wir unterstützen das Web Adressbuch für Ihre E-Mail Adresse nicht. Sie können aber durch Klicken von \'Adressbuchanwendung\' unten Adressen von Ihrem Computer importieren.',
        'SORRY_YOU_CAN_ONLY_HAVE_N_TRACKS' => 'Es tut uns leid, aber Sie können nur maximal %s Songs in Ihrer Wiedergabeliste haben. Bitte entfernen Sie Songs aus der Wiedergabeliste, bevor Sie weitere hinzufügen.',
        'SORT_BY' => 'Sortieren nach:',
        'SOURCE' => 'Quelle',
        'SPAM' => 'Spam',
        'SPECIAL_RULES' => 'Sonderregeln',
        'SPINNER' => 'Spinner',
        'SPREAD_THE_WORD_NETWORK_BADGE_LARGE' => 'Erzählen Sie es weiter! Holen Sie sich das Abzeichen für %s, das dynamisch die beliebtesten Mitglieder des Netzwerks zeigt, und zeigen Sie es auf Ihrer Website oder MySpace-Seite.',
        'SPREAD_THE_WORD_NETWORK_BADGE_SMALL' => 'Erzählen Sie es weiter! Holen Sie sich das Abzeichen für Ihre Website oder MySpace-Seite.',
        'SPREAD_WORD_GET_BADGE' => 'Erzählen Sie es weiter. Holen Sie sich Ihr eigenes Abzeichen für %s für Ihre Website oder MySpace-Seite. (<a %s>Einbettungscode anfordern</a>)',
        'SPREAD_WORD_GET_BADGE_SHORT' => 'Erzählen Sie es weiter. <a href="%s">Holen Sie sich Ihr eigenes Abzeichen für %s</a>',
        'STARTED_BY_X_LAST_REPLY_LINK_BY_X_T' => 'Gestartet von %s. Letzte <a %s>Antwort</a> von %s %s.',
        'STARTED_BY_X_ON' => 'Gestartet von %s am %s',
        'STARTED_BY_X_T' => 'Gestartet von %s um %s',
        'STARTED_DISCUSSION_LAST_REPLY_LINK_BY_X_T' => '<strong>Hat diese Diskussion gestartet.</strong> Letzte <a %s>Antwort</a> von %s %s.',
        'STARTED_DISCUSSION_ON' => '<strong>Hat diese Diskussion gestartet am</strong> %s',
        'STARTED_DISCUSSION_T' => '<strong>Hat diese Diskussion gestartet am: </strong> %s',
        'STARTED_ON' => '<strong>Gestartet</strong> am %s',
        'STARTED_T_BY' => 'Gestartet <strong>%s</strong> von:',
        'START_A_DISCUSSION' => 'Eine Diskussion starten',
        'START_A_NEW_DISCUSSION' => 'Eine neue Diskussion starten',
        'START_BY_CUSTOMIZING_ITS_APPEARANCE' => 'Beginnen Sie mit der <a %s>Anpassung des Erscheinungsbilds</a>.',
        'START_CONTRIBUTING' => 'Machen Sie mit:',
        'START_DISCUSSION' => 'Diskussion starten',
        'START_DISCUSSIONS' => 'Diskussionen starten',
        'START_FEATURING_GROUPS' => 'Stellen Sie Gruppen auf der Hauptseite vor, wenn Sie die Option "Auf der Hauptseite vorstellen" sehen. Um mehr über darüber zu erfahren, <a %s>klicken Sie hier</a>.',
        'START_FEATURING_MEMBERS_CLICK_Y' => 'Stellen Sie Mitglieder auf der Hauptseite vor, wenn Sie die Option "Auf der Hauptseite vorstellen" sehen. Um mehr über darüber zu erfahren, <a %s>klicken Sie hier</a>.',
        'START_FEATURING_TRACKS' => 'Wenn Ihnen Lieder gefallen, dann stellen Sie sie auf der Hauptseite vor.',
        'START_FEATURING_X_CLICK_Y' => 'Stellen Sie %s auf der Hauptseite vor, wenn Sie die Option "Auf der Hauptseite vorstellen" sehen. Um mehr über darüber zu erfahren, <a %s>klicken Sie hier</a>.',
        'START_FROM_SCRATCH_CREATE' => 'Erstellen Sie eine neue Übersetzung indem Sie einen Namen für die neue Sprache eingeben und eine bestehende Sprache als Basis wählen.',
        'START_SLIDESHOW' => 'Diashow starten',
        'STATUS' => 'Status',
        'STATUS_N' => 'Status %s',
        'STILL_HAVING_PROBLEMS' => 'Haben Sie immer noch Probleme?',
        'STOPWORDS' => 'ein | eine | eines | über | sind | als | wie | bei | sein | von | com | de | für | von | wie | ich | in | ist | es | auf | oder | der | die | das | dies | diese | dieses | zu | war | was | wann | wo | wer | wird | mit | und  | www',
        'STOPWORDS_ARE' => '<a %s>Stopwörter</a> sind Wörter, die bei der Erstellung von Meta-Tags innerhalb jeder Seite automatisch aus der Netzwerkbeschreibung gefiltert werden. Die Angabe ist optional.',
        'STOP_FOLLOWING_ALL' => 'Diskussionen und Blog-Beiträge nicht mehr folgen',
        'STOP_NOTIFYING' => 'Keine Benachrichtigungen mehr senden',
        'SUBJECT' => 'Betreff',
        'SUBSCRIBE' => 'Abonnieren',
        'SUBSCRIBE_TO_DISCUSSION' => 'Diese Diskussion abonnieren',
        'SUBSCRIBE_TO_DISCUSSIONS' => 'Diese Diskussionen abonnieren',
        'SUBSCRIBE_TO_DISCUSSIONS_TAGGED_X' => 'Diskussionen mit dem Schlagwort \'%s\' abonnieren',
        'SUBSCRIBE_TO_PAGES' => 'Diese Seiten abonnieren',
        'SUBSCRIBE_TO_XS_DISCUSSIONS' => 'Diskussionen von %s abonnieren',
        'SUCCESS' => 'Erfolgreich.',
        'SUCCESS_EXCLAMATION' => 'Erfolgreich!',
        'SUGGESTIONS' => 'Vorschläge:',
        'SUMMARY' => 'Zusammenfassung',
        'SUPPORTS_TEXT_EMBEDDED' => 'Unterstützt Text, eingebettete Videos, Fotos und Widgets',
        'SYSTEM_REQUIREMENTS' => 'Systemanforderungen',
        'TAB' => 'Reiter',
        'TABS' => 'Reiter',
        'TAB_NAMES' => 'Reiternamen',
        'TAG' => 'Schlagwort',
        'TAGGED' => 'Schlagworte:',
        'TAGGED_X' => 'Schlagworte: %s',
        'TAGLINE' => 'Slogan',
        'TAGS' => 'Schlagworte:',
        'TAGS_ARE_SHORT_DESCRIPTIONS' => 'Benutzen Sie Schlagworte, um die Suche nach Ihren Videos zu erleichtern. Trennen Sie mehrere Schlagworte durch Kommas, und setzen Sie Schlagworte aus mehreren Wörtern in Anführungszeichen, z.B. "San Francisco".',
        'TAGS_NO_COLON' => 'Schlagworte',
        'TAGS_X' => '<strong>Schlagworte:</strong> %s',
        'TAKE_FULL_CONTROL' => 'Sie erhalten vollständige Kontrolle über die Funktionalität Ihres Netzwerks durch Bearbeitung des Quellcodes.',
        'TELL_THE_PEOPLE_ON' => 'Erzählen Sie den Leuten auf %s mehr über sich. Die mit einem <span %s>Schloss-Symbol</span> gekennzeichnete Fragen sind privat und nur für Administratoren sichtbar.',
        'TERMS_OF_SERVICE' => 'AGBs',
        'TEXT' => 'Text',
        'TEXT_BOX' => 'Textfeld',
        'TEXT_FOR_HEADER_TAB' => 'Dieser Text ist für einen Reiter bestimmt.',
        'TEXT_RESET_TO_ORIGINAL_VERSION' => 'Der Text wurde auf die Originalversion zurückgesetzt.',
        'THANKS' => 'Vielen Dank!',
        'THANKS_VALEDICTION' => 'Vielen Dank,',
        'THANK_YOU_YOUR_MESSAGE_HAS_BEEN_SENT' => 'Vielen Dank. Ihre Nachricht wurde gesendet.',
        'THAT_PHOTO_IS_AWAITING_APPROVAL' => 'Dieses Foto muss noch akzeptiert werden.',
        'THAT_VIDEO_IS_AWAITING_APPROVAL' => 'Dieses Video muss noch akzeptiert werden.',
        'THEME_SETTINGS' => 'Designeinstellungen',
        'THERE_ARE_NO_DISCUSSIONS' => 'Es gibt derzeit keine Diskussionen in Ihrem Netzwerk.',
        'THERE_ARE_NO_FEATURED_GROUPS' => 'Es werden derzeit keine Gruppen in Ihrem Netzwerk vorgestellt.',
        'THERE_ARE_NO_FEATURED_MEMBERS' => 'Es werden derzeit keine Mitglieder in Ihrem Netzwerk vorgestellt.',
        'THERE_ARE_NO_FEATURED_X' => 'Es werden derzeit keine %s in Ihrem Netzwerk vorgestellt.',
        'THERE_ARE_NO_RECENT_POSTS' => 'Es gibt keine aktuellen Beiträge.',
        'THERE_ARE_NO_VIDEOS_THAT_MATCH' => 'Keine Videos in diesem Netzwerk, auf die Ihre Suche passt.',
        'THERE_ARE_NO_X_THAT_MATCH_SETTINGS' => 'Es gibt keine zu Ihren Einstellungen passenden %s.',
        'THERE_HAS_BEEN_AN_ERROR' => 'Ein Fehler ist aufgetreten',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION' => 'Es gibt einen neuen Kommentar in einer Ihrer Diskussionen auf %s.',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION_X' => 'Es gibt einen neuen Kommentar in Ihrer Diskussion "%s" auf %s.',
        'THESE_OPTIONS_ARE_DISABLED_ACTIVITY' => 'Diese Optionen sind deaktiviert, da Sie "Letzte Aktivitäten" nicht in Ihrem Netzwerk aktiviert sind.',
        'THE_LATEST_ACTIVITY_WILL_NEVER' => 'Unter "Letzte Aktivitäten" werden niemals von Ihnen gesendete Nachrichten, die Seiten oder Mitglieder, die Sie sich angesehen haben, Einladungen, die Sie abgelehnt haben, Personen, die Sie nicht mehr als Freund haben, oder deren Freundschaftsanfragen Sie ablehnten, oder Dinge, die Sie löschen, angezeigt.',
        'THE_NETWORK_CREATOR_HAS_TURNED_OFF_THE_ACTIVITY' => 'Der Netzwerkgründer hat die Anzeige von Aktivitäten ausgeschaltet.',
        'THINGS_IVE_ADDED_APPROVED' => 'Von mir hinzugefügte Objekte wurden akzeptiert',
        'THIS_ALBUM' => 'Dieses Album',
        'THIS_BOX_WILL_NOT_SHOW_DISCUSSIONS' => 'Dieses Feld ist für andere erst sichtbar, wenn Diskussionen zum Anzeigen vorhanden sind. Warum starten Sie nicht eine?',
        'THIS_IMAGE_WILL_REPLACE' => 'Dieses Bild ersetzt den Namenstext des Netzwerks',
        'THIS_IS_PREVIEW_OF_BLOG_POST' => 'Diese Vorschau zeigt Ihnen, wie Ihr Blog-Beitrag nach der Veröffentlichung aussehen wird. Klicken Sie auf "Zurück", um den Beitrag weiter zu bearbeiten, oder auf "Veröffentlichen", wenn der Beitrag fertig ist!',
        'THIS_IS_UNPUBLISHED_DRAFT' => 'Dies ist ein unveröffentlichter Entwurf',
        'THIS_IS_YOUR_PAGE' => 'Dies ist Ihre persönliche Seite:',
        'THIS_NETWORK_VISIBLE_MEMBERS_ONLY' => 'Dieses Netzwerk ist <strong>nur für Mitglieder sichtbar</strong>.',
        'THIS_NETWORK_VISIBLE_TO_EVERYONE' => 'Dieses Netzwerk ist <strong>für jeden sichtbar</strong>.',
        'THIS_PAGE_WAS_NOT_FOUND' => 'Es tut uns leid, aber leider konnte diese Seite nicht gefunden werden.',
        'THIS_SETS_URL_OF_GROUP' => 'Das setzt die URL für Ihre Gruppe:<br />http://%s/<strong>Gruppen-Webadresse</strong>',
        'THIS_VIDEO_IS_BEING_PROCESSED' => 'Dieses Video wird derzeit verarbeitet.',
        'THIS_WILL_PREVENT_ACTIVITY' => 'Dies wird verhindern, dass jemand diese Aktivitätsnachricht sieht',
        'THUMBNAIL' => 'Vorschaubild',
        'THUMBNAILS' => 'Vorschaubilder',
        'TIME_COLON' => 'Zeit:',
        'TITLE' => 'Titel:',
        'TITLEBAR_BACKGROUND' => 'Hintergrund der Titelzeile',
        'TITLEBAR_TEXT_COLOR' => 'Textfarbe der Titelzeile',
        'TITLES_ONLY' => 'Nur Titel',
        'TITLE_YOUR_ALBUM' => '<strong>Geben Sie Ihrem Album einen Titel.</strong> Fügen Sie ein Albumcover und eine Beschreibung hinzu.',
        'TO' => 'An:',
        'TOP_BAR_AND_FOOTER' => 'Leiste am oberen und unteren Ende der Seite',
        'TO_ACCEPT_THIS_FRIEND_REQUEST_VISIT' => 'Um diese Freundschaftsanfrage zu akzeptieren, besuchen Sie:',
        'TO_APPROVE_OR_DENY_USER_REQUEST' => 'Um die Anfrage von %s zu akzeptieren oder abzulehnen, besuchen Sie:',
        'TO_APPROVE_THIS_X_VISIT' => 'Zum Erlauben des %ss besuchen Sie:',
        'TO_APPROVE_XS_PROFILE_VISIT' => 'Um das Profil von %s zu genehmigen, besuchen Sie:',
        'TO_CONTROL_WHICH_EMAILS_YOUR_RECEIVE_ON_X_GO_TO' => 'Sie können hier einstellen, welche E-Mails Sie auf %1$s erhalten:',
        'TO_GET_YOUR_PHOTOS_FROM_FLICKR' => 'Um Ihre Fotos von Flickr zu importieren, müssen Sie %s zunächst gestatten, eine Verbindung zu Ihren Flickr-Account herstellen zu dürfen.',
        'TO_HELP_TROUBLESHOOT_PROVIDE_THIS_VIDEO_ID_X' => 'Bitte unterstützen Sie uns bei der Fehlerbehebung, indem Sie die folgende Video ID angeben: %s',
        'TO_READ_THIS_MESSAGE_VISIT' => 'Um diese Nachricht zu lesen, besuchen Sie:',
        'TO_SEND_ANOTHER_MESSAGE' => 'Um eine weitere Nachricht zu senden, geben Sie bitte unten Ihren Text ein.',
        'TO_STOP_BEING_NOTIFIED_OF_NEW_DISCUSSIONS_GO_TO' => 'Um nicht mehr über neue Diskussionen benachrichtigt zu werden, besuchen Sie:',
        'TO_STOP_FOLLOWING_THIS_X_GO_TO' => 'Um diese %s nicht mehr zu verfolgen, besuchen Sie:',
        'TO_UNBAN_USERNAME_GO_TO' => 'Um die Sperre von %s wieder aufzuheben, besuchen Sie:',
        'TO_VIEW_IT_VISIT' => 'Sie können es sich hier ansehen:',
        'TO_VIEW_THE_NEW_COMMENT_VISIT' => 'Sie können sich den neuen Kommentar hier ansehen:',
        'TO_VIEW_THE_NEW_REPLY_VISIT' => 'Sie können sich die neue Antwort hier ansehen:',
        'TO_VIEW_THE_VIDEO_VISIT' => 'Sie können sich das Video hier ansehen:',
        'TO_VIEW_THIS_DISCUSSION_GO_TO' => 'Sie können sich diese Diskussion hier ansehen:',
        'TO_VIEW_THIS_GROUP_VISIT' => 'Sie können sich diese Gruppe hier ansehen:',
        'TO_VIEW_THIS_X_VISIT' => 'Sie können sich dieses %s hier ansehen:',
        'TO_VIEW_YOUR_NEW_COMMENT_VISIT' => 'Sie können Sich Ihren neuen Kommentar hier ansehen:',
        'TO_VIEW_YOUR_X_VISIT' => 'Sie können sich Ihr %s hier ansehen:',
        'TRACKING_CODE' => 'Nachverfolgungscode',
        'TRACKS' => 'Songs',
        'TRACKS_EXCEEDED_LIMIT' => 'Ein oder mehrere Songs scheinen größer als das Limit von 10 MB zu sein.',
        'TRACK_ALBUM' => 'Album',
        'TRACK_ARTIST' => 'Interpret',
        'TRACK_ARTWORK' => 'Artwork',
        'TRACK_COULD_NOT_BE_LOADED' => 'Der Song konnte nicht geladen werden',
        'TRACK_STATISTICS' => 'Statistische Daten erfassen',
        'TRACK_TITLE' => 'Songtitel',
        'TRACK_VISITORS_AND_TRENDS' => 'Verfolgen Sie Besucher und Trends in Ihrem Netzwerk.',
        'TRANSLATION_CHANGES_SAVED' => 'Ihre Änderungen wurden gespeichert. Diese Übersetzung ist zu %s%% vollständig.',
        'TRANSLATION_CHANGES_SAVED_MAKE_CURRENT' => 'Ihre Änderungen wurden gespeichert. Diese Übersetzung ist zu %s%% vollständig. Möchten Sie diese Sprache zur aktuellen Sprache Ihres Netzwerks machen?',
        'TRANSLATION_FILE_HAS_FILENAME_LIKE' => 'Übersetzungsdateien für Netzwerke auf Ning haben Namen wie <code>en_US.txt</code>. <a %s>Weitere Informationen finden Sie hier. </a>',
        'TRANSLATION_UPLOAD_SUCCESSFUL' => 'Das Hochladen war erfolgreich. Diese Übersetzung ist zu %s%% vollständig.',
        'TRANSLATION_UPLOAD_SUCCESSFUL_MAKE_CURRENT' => 'Das Hochladen war erfolgreich. Diese Übersetzung ist zu %s%% vollständig. Möchten Sie diese Sprache zur aktuellen Sprache Ihres Netzwerks machen?',
        'TRY_BULK_MUSIC_UPLOADER' => 'Probieren Sie das Musik Hochladetool aus',
        'TRY_BULK_PHOTO_UPLOADER' => 'Probieren Sie das Foto Hochladetool aus',
        'TRY_BULK_VIDEO_UPLOADER' => 'Probieren Sie das Video Hochladetool aus',
        'TRY_DIFFERENT_KEYWORDS' => 'Versuchen Sie andere oder allgemeinere Schlüsselwörter',
        'TRY_OUT_OPENSOCIAL_GADGETS_WARNING_EXPERIMENTAL' => 'Testen Sie OpenSocial-Gadgets. Achtung: Diese Funktion befindet sich noch in der Testphase.',
        'TYPE_CODE_ON_RIGHT' => 'Geben Sie den rechts <br/>angezeigten Text ein',
        'TYPE_OF_ISSUE' => 'Art des Problems',
        'UNABLE_TO_FIND_EMAIL' => 'Leider konnte in den Daten keine E-Mail Adresse gefunden werden.',
        'UNCATEGORIZED' => 'Nicht kategorisiert',
        'UNDER_CONSTRUCTION' => 'Noch im Aufbau',
        'UNFEATURING_ELLIPSIS' => 'Nicht mehr auf der Hauptseite vorstellen…',
        'UNITED_STATES' => 'Vereinigte Staaten',
        'UNTITLED' => 'Ohne Titel',
        'UNTITLED_CATEGORY' => 'Unbenannte Kategorie',
        'UPDATE_EMAIL_ADDRESS' => 'E-Mail-Adresse aktualisieren',
        'UPDATE_PAGE' => 'Seite aktualisieren',
        'UPLOAD' => 'Hochladen',
        'UPLOADING' => 'Wird hochgeladen…',
        'UPLOADING_CONTENT' => 'Inhalt wird hochladen…',
        'UPLOADING_FILES' => 'Dateien werden hochgeladen',
        'UPLOAD_A_PHOTO' => 'Ein Foto hochladen',
        'UPLOAD_A_PHOTO_WHICH_WILL_BE_RESIZED' => 'Laden Sie ein Foto (GIF, JPG oder PNG) hoch; es wird automatisch zu einem Quadrat angepasst. Es kann einige Minuten dauern, bis das Foto angezeigt wird.',
        'UPLOAD_A_VIDEO_FROM' => 'Laden Sie ein Video von Ihrem Computer hoch. Alle gängigen Formate werden akzeptiert!',
        'UPLOAD_A_VIDEO_FROM_YOUR_COMPUTER' => 'Laden Sie ein Video von Ihrem Computer hoch',
        'UPLOAD_CSV_OR_VCF' => 'Laden Sie eine .csv- oder .vcf-Datei hoch, die Sie aus Microsoft Outlook oder dem Apple Adressbuch exportiert haben.',
        'UPLOAD_DID_NOT_WORK' => 'Es tut uns leid, aber das Hochladen hat leider nicht funktioniert',
        'UPLOAD_FILES' => 'Datei(en) anhängen:',
        'UPLOAD_LANGUAGE_FILE' => 'Übersetzungsdatei hochladen',
        'UPLOAD_LIMIT_EXCEEDED' => 'Die hochgeladene Datei überschreitet die maximale Dateigröße.',
        'UPLOAD_MP3_FROM_YOUR_COMPUTER' => 'Laden Sie MP3 Dateien von Ihrem Computer hoch.',
        'UPLOAD_MUSIC_FROM_YOUR_COMPUTER' => 'Laden Sie Musik von Ihrem Computer hoch',
        'UPLOAD_PHOTOS' => 'Fotos hochladen',
        'UPLOAD_PHOTOS_FROM' => 'Laden Sie Fotos von Ihrem Computer hoch:',
        'UPLOAD_PHOTOS_FROM_YOUR' => 'Laden Sie Fotos von Ihrem Computer hoch.',
        'UPLOAD_PHOTOS_FROM_YOUR_COMPUTER' => 'Laden Sie Fotos von Ihrem Computer hoch',
        'UPLOAD_TRACKS' => 'Songs hochladen',
        'UPLOAD_VIDEOS' => 'Videos hochladen',
        'UPLOAD_VIDEOS_FROM' => 'Laden Sie Videos von Ihrem Computer hoch',
        'URL' => 'URL',
        'URL_CAN_CONTAIN_ONLY_LETTERS' => 'Die Internetadresse darf nur Buchstaben und Zahlen enthalten (keine Leerzeichen).',
        'URL_REPORTED_COLON' => 'Gemeldete URL:',
        'URL_TAKEN' => 'Es tut uns leid, aber diese Internetadresse ist leider schon vergeben. Bitte wählen Sie eine andere Internetadresse.',
        'USEFUL_ADDRESSES' => 'Nützliche Adressen im Netzwerk',
        'USERNAMES_COMMENTS' => 'Kommentare von %s',
        'USERNAME_INVITED_YOU_TO_APPNAME' => '%s hat Sie zu %s eingeladen.',
        'USERS_GROUPS' => 'Gruppen von %s',
        'USER_ALREADY_GROUP_MEMBER' => '%1$s ist bereits Mitglied dieser Gruppe. <a %2$s>Eine Nachricht an %1$s senden</a>',
        'USER_ALREADY_NETWORK_MEMBER' => '%1$s ist bereits Mitglied dieses Netzwerks. <a %2$s>Eine Nachricht an %1$s senden</a>',
        'USER_BANNED_FROM_GROUP' => '%1$s wurde aus dieser Gruppe ausgeschlossen. <a %2$s>Eine Nachricht an %1$s senden</a>',
        'USER_BANNED_FROM_NETWORK' => '%1$s wurde aus dem Netzwerk ausgeschlossen. <a %2$s>Eine Nachricht an %1$s senden</a>',
        'USER_COMMENTED_ON_A_TYPE_ON_APPNAME' => '%1$s hat einen Kommentar zum %2$s "%4$s" auf %3$s abgegeben',
        'USER_COUNT' => '(%d)',
        'USER_CREATED_APPNAME' => '%s hat das Netzwerk %s gegründet.',
        'USER_CREATED_GROUP' => '%s hat diese Gruppe auf %s gegründet.',
        'USER_HAS_INVITED_YOU_TO_JOIN_GROUP' => '%s hat Sie in die Gruppe %s eingeladen',
        'USER_HAS_NOT_CREATED_GROUPS' => '%s hat noch keine Gruppen erstellt.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X' => '%1$s hat um Mitgliedschaft bei %2$s auf %3$s gebeten.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X_ELLIPSIS' => '%1$s hat um Mitgliedschaft bei %2$s auf %3$s gebeten…',
        'USER_HAS_SENT_YOU_A_MESSAGE_ON_X' => '%1$s hat Ihnen eine Nachricht auf %2$s gesendet.',
        'USER_REPLIED_TO_A_DISCUSSION_ON_Y' => '%s hat in einer Diskussion auf %s geantwortet.',
        'USER_REPLIED_TO_DISCUSSION_TITLE_ON_APPNAME' => '%s hat in der Diskussion "%s" auf %s geantwortet.',
        'USE_EDIT_WIDGET_BUTTON_CALENDAR' => 'Klicken Sie auf &#8220;Edit Me&#8221; und wählen Sie dann &#8220;Search For Events&#8221;. Geben Sie dann einen Suchbegriff ein (z.B. Feiertage oder den Namen einer Sportmannschaft). Durch Klicken auf ein Suchergebnis fügen Sie es zu Ihrem Kalender hinzu. Sie können auch direkt die Adresse eines iCal Feeds eingeben.',
        'USE_EDIT_WIDGET_BUTTON_WEATHER' => 'Klicken Sie auf &#8220;Edit Me&#8221; und wählen Sie dann &#8220;Search For Events&#8221;. Geben Sie nun Ihren Standort ein und wählen Sie die Einheit der Temperaturangabe (Fahrenheit oder Celsius) aus. Sie können auch zwischen dem jeweiligen Tageswetter und der Wetterprognose der nächsten 5 Tage wählen.',
        'USE_HTML_EMBED_CODE' => 'HTML Einbettungscode verwenden',
        'USE_IT_TO_KEEP_A_BLOG_AND_DISPLAY_YOUR_PROFILE_ANSWERS' => 'Benutzen Sie sie, um <a %1$s>Ihr Blog</a> und Ihre <a %2$s>Profilantworten</a> zu zeigen.',
        'USE_THIS_FORM_TO_REPORT_ISSUE_TO_NC' => 'Benutzen Sie dieses Formular, um <a %s>%s</a>, dem Gründer von<a %s>%s</a>, ein Problem zu melden.',
        'USE_THIS_FORM_TO_SEND_FEEDBACK_TO_NC' => 'Benutzen Sie dieses Formular, um <a %s>%s</a>, Feedback an den Gründer von<a %s>%s</a> zu senden.',
        'USE_THIS_TRANSLATION' => 'Diese Übersetzung verwenden',
        'VCARD_IMPORT_UNAVAILABLE' => 'Es tut uns leid, aber leider ist der Import von vCard Visitenkarten derzeit nicht verfügbar.',
        'VERIFICATION' => 'Lassen Sie uns wissen, dass Sie <br />eine echte Person sind.',
        'VERIFICATION_IMAGE' => 'Captcha Testbild',
        'VIDEO' => 'Video',
        'VIDEOS' => 'Videos',
        'VIDEOS_HOME' => 'Videos Startseite',
        'VIDEOS_SUCCESSFULLY_UPLOADED' => 'Ihre Videos wurden erfolgreich hochgeladen.',
        'VIDEOS_TAB_TEXT' => 'Videos',
        'VIDEOS_UPLOADED_AWAITING' => 'Ihre Videos wurden erfolgreich hochgeladen und müssen jetzt nur noch vom Gründer von %s akzeptiert werden.',
        'VIDEO_BY_X' => 'Video von %s',
        'VIDEO_DETAILS' => 'Videodetails',
        'VIDEO_ID' => 'Video ID:',
        'VIDEO_IS_WAITING_FOR_APPROVAL' => 'Dieses Video <strong>muss noch</strong> vom Besitzer von %s <strong>akzeptiert</strong> werden.',
        'VIDEO_PLAYER' => 'Videoplayer',
        'VIDEO_TRANSCODING_FAILED_FOR_X' => 'Die Konvertierung des Videos %s in %s ist fehlgeschlagen.',
        'VIDEO_UPLOADED_ON_X' => 'Video auf %s hochgeladen',
        'VIDEO_UPLOADER_REQUIRES_JAVA' => 'Das Video Hochladetool benötigt eine aktuelle Java Version. <strong><a %s>Klicken Sie hier um Java herunterzuladen</a></strong>, oder <strong><a %s>wechseln Sie zum einfachen Hochladeformular</a></strong>.',
        'VIDEO_UPLOAD_COMPLETE_ON_X' => 'Ihr Video wurde erfolgreich auf %s hochgeladen.',
        'VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'Ihr Video wurde leider nicht erfolgreich auf %s hochgeladen.',
        'VIEW' => 'Ansehen',
        'VIEWABLE_BY_EVERYONE' => 'Darf von <strong>jedem</strong> angesehen werden',
        'VIEWABLE_BY_FRIENDS' => 'Darf von <strong>Freunden</strong> angesehen werden',
        'VIEWS' => 'Ansichten:',
        'VIEW_ALBUMS_WITH_PHOTO' => 'Alle Alben mit diesem Foto ansehen',
        'VIEW_ALL' => 'Alle anzeigen',
        'VIEW_ALL_COMMENTS' => 'Alle Kommentare anzeigen',
        'VIEW_ALL_DISCUSSIONS' => 'Alle Diskussionen anzeigen',
        'VIEW_ALL_GROUPS' => 'Alle Gruppen anzeigen',
        'VIEW_ALL_MY_FRIENDS' => 'Alle meine Freunde anzeigen',
        'VIEW_ALL_N_CATEGORIES' => 'Alle %s Kategorien anzeigen',
        'VIEW_ALL_PEOPLE_ON_X' => 'Alle Mitglieder von %s anzeigen',
        'VIEW_ALL_XS_FRIENDS' => 'Alle Freunde von %s anzeigen',
        'VIEW_ARCHIVES' => 'Archiv anzeigen',
        'VIEW_AS_SLIDESHOW' => 'Als Diashow anzeigen',
        'VIEW_DISCUSSIONS' => 'Diskussionen anzeigen',
        'VIEW_DISCUSSIONS_IN_GROUP_FORUM' => 'Alle Diskussionen des <a %s>%s Forums</a> anzeigen!',
        'VIEW_DISCUSSIONS_OR_START_DISCUSSION' => '<a %s>Alle Diskussionen anzeigen</a> oder <a %s>eine neue Diskussion starten</a>',
        'VIEW_GROUPS' => 'Gruppen anzeigen',
        'VIEW_GROUPS_OR_CREATE_GROUP' => '<a %s>Alle Gruppen anzeigen</a> oder <a %s>eine neue Gruppe erstellen</a>',
        'VIEW_LAYOUT' => 'Layout anzeigen',
        'VIEW_MORE_CONTRIBUTORS' => 'Weitere Mitwirkende anzeigen',
        'VIEW_PAGE' => 'Seite anzeigen',
        'VIEW_PAGE_AS_OTHERS' => 'Diese Seite so anzeigen, wie sie von anderen gesehen wird',
        'VIEW_PAGE_ON_APPNAME' => 'Meine persönliche Seite auf <em>%s</em> anzeigen',
        'VIEW_PHOTOS' => 'Fotos anzeigen',
        'VIEW_PHOTOS_IN_SLIDESHOW' => 'Diese Fotos als Diashow ansehen',
        'VIEW_POPULAR_CONTRIBUTORS' => 'Aktiv Mitwirkende anzeigen',
        'VIEW_RECENT_PHOTOS' => 'Neue Fotos ansehen',
        'VIEW_RECENT_VIDEOS' => 'Neue Videos ansehen',
        'VIEW_SLIDESHOW' => 'Diashow anzeigen',
        'VIEW_SLIDESHOW_FULL_SIZE' => 'Diese Diashow in der vollen Größe anzeigen',
        'VIEW_THREAD' => 'Diskussionsfaden anzeigen',
        'VIEW_VIDEOS' => 'Videos anzeigen',
        'VIEW_XS_BLOG_POSTS' => 'Blog-Beiträge von %s anzeigen',
        'VIEW_XS_DISCUSSIONS' => 'Diskussionen von %s anzeigen',
        'VIEW_XS_ELLIPSIS' => 'Zeige %s\' …',
        'VIEW_XS_PAGE_ON_Y' => 'Die persönliche Seite von %s auf %s anzeigen',
        'VIEW_YOUR_BLOG_POSTS' => 'Ihre Blog-Beiträge anzeigen',
        'VIEW_YOUR_DISCUSSIONS' => 'Ihre Diskussionen anzeigen',
        'VISIT' => 'Besuchen',
        'VISIT_APPNAME' => '<em>%s</em> besuchen',
        'VISIT_GROUP_AT' => 'Besuchen Sie %s hier:',
        'VISIT_NING_HELP_CENTER' => 'Besuchen Sie das <a %s>Ning Hilfezentrum</a>, um mehr Informationen zur Fehlerbehebung und weitere Unterstützung zu erhalten.',
        'VISIT_X_AT_Y' => 'Besuchen Sie %1$s hier: %2$s',
        'WANT_TO_ADD_A_WELCOME_MESSAGE_FOR_X_ON_THEIR_PROFILE_GO_TO' => 'Hier können Sie eine Willkommensnachricht auf der Profilseite von %s hinterlassen:',
        'WANT_TO_INVITE_MORE_FRIENDS' => 'Möchten Sie mehr Freunde einladen? Importieren Sie Ihre Kontakte aus Ihrem Web- oder Computer-Adressbuch.',
        'WANT_TO_LEARN_MORE' => 'Möchten Sie mehr erfahren? Schauen Sie sich den Bereich zur <a href="%s">Erweiterte Anpassung</a> an.',
        'WATERMARK' => 'Wasserzeichen',
        'WATERMARK_LOGO' => 'Wasserzeichen',
        'WATERMARK_OR_LOGO_IMAGE' => 'Wasserzeichen oder Logo:',
        'WEAR_IT_WITH_PRIDE' => 'Tragen Sie es mit Stolz! Holen Sie sich das %s Abzeichen für Ihre Website oder MySpace-Seite.',
        'WEATHER' => 'Wetter',
        'WEATHER_WIDGET_DISPLAYS' => 'Das Wetter-Widget zeigt die regionale Wettervorhersage des Weather Channel an.',
        'WEBCAM' => 'Webcam',
        'WEBCAM_WIDGET_ALLOWS_YOU' => 'Mit dem Webcam-Widget können Sie die Bilder jeder öffentliche Webcam anzeigen. Klicken Sie auf &#8220;Edit Me&#8221;, um eine Webcam aus einer Liste bekannter Webcams auszuwählen. Sie können auch direkt die URL einer Webcam einzugeben.',
        'WEBSITE_ADDRESS' => 'Adresse einer Webseite',
        'WELCOME' => 'Willkommen',
        'WELCOME_MEMBER_N_OF_APPNAME' => 'Willkommen, %1$s! Sie sind Mitglied Nr. %2$s von %3$s.',
        'WELCOME_MEMBER_N_OF_APPNAME_INVITE' => 'Willkommen, %1$s! Sie sind Mitglied Nr. %2$s von %3$s. <a %4$s>Laden Sie Freunde ein</a>.',
        'WELCOME_TO_GROUP' => 'Willkommen bei %s',
        'WELCOME_TO_GROUP_X_ON_Y_ELLIPSIS' => 'Willkommen bei %1$s auf %2$s…',
        'WELCOME_TO_THE_GROUP_X_ON_Y' => 'Willkommen in der Gruppe "%1$s" auf %2$s',
        'WELCOME_TO_X' => 'Willkommen bei %s',
        'WELCOME_TO_X_ELLIPSIS' => 'Willkommen bei %s…',
        'WELCOME_TO_X_THANK_YOU_FOR_JOINING' => 'Willkommen bei %s! Danke, das Sie bei uns mitmachen.',
        'WELCOME_TO_YOUR_NEW_SOCIAL_NETWORK' => 'Willkommen in Ihrem neuen sozialen Netzwerk.',
        'WELCOME_TO_YOUR_SITE' => 'Willkommen in Ihrem sozialen Netzwerk!',
        'WE_ARE_LOADING_ADDRESSES' => 'Ihre Adressen werden geladen…',
        'WE_ARE_SORRY_NOT_ALLOWED_JOIN_GROUP' => 'Es tut uns leid, aber leider ist es Ihnen nicht gestattet, dieser Gruppe beizutreten.',
        'WE_ARE_SORRY_SITE_HAS_ISSUE' => 'Es tut uns leid, leider gibt es ein Problem mit dieser Website .',
        'WE_ARE_SORRY_WE_ARE_HAVING' => 'Leider ist ein Problem mit dieser Seite aufgetreten.',
        'WE_COULD_NOT_FIND_ANYONE' => 'Es tut uns leid, aber wir konnten niemanden finden',
        'WE_COULD_NOT_FIND_ANYONE_MATCHING' => 'Es tut uns leid, aber wir konnten niemanden finden, der zu Ihrer Suche passt.',
        'WE_COULD_NOT_FIND_ANYTHING' => 'Wir konnten leider nichts finden, auf das Ihre Suche nach "%s" passt. Suchen Sie doch nach etwas anderem?',
        'WE_COULD_NOT_FIND_ANY_DISCUSSIONS' => 'Leider konnten wir keine Diskussionen finden, auf die Ihre Suche passt.',
        'WE_COULD_NOT_FIND_ANY_GROUPS' => 'Leider konnten wir keine Gruppen finden, auf die Ihre Suche passt.',
        'WE_DID_NOT_FIND_ADDRESSES' => 'Das importierte Adressbuch enthielt leider keine Adressen.',
        'WE_DO_NOT_KNOW_USER' => 'Wir kennen diese Person nicht.',
        'WE_SENT_YOU_EMAIL' => 'Wir haben Ihnen eine E-Mail mit einem Link gesendet, mit dem Sie Ihr Passwort zurücksetzen können.',
        'WE_SUPPORT_INTERNET_EXPLORER' => 'Wir unterstützen Internet Explorer 6 & 7, Firefox 2.0 und Safari 2.0. Wenn Sie einen anderen Browser verwenden (vielleicht einen Ihres Internetdienstanbieters), könnten Kompatibilitätsprobleme auftreten.',
        'WE_SUPPORT_MOV' => 'Wir unterstützen Dateien im .mov-, .mpg-, .mp4-, .avi-, .3gp- und .wmv-Format. Die Dateien dürfen nicht größer als 100 MB sein.',
        'WE_USE_NING_ID' => 'Wir benutzen Ning ID zur Authentifizierung. <a %s>Was ist die Ning ID? </a>',
        'WHAT_DATE_FOR_YOUR_POST' => 'Wann soll Ihr Beitrag veröffentlicht werden?',
        'WHAT_DISPLAYS_LATEST_ACTIVITY' => 'Was soll als <br />letzte Aktivität in Ihrem Netzwerk angezeigt werden?',
        'WHAT_INFORMATION' => 'Welche Fragen möchten Sie an neue Mitglieder Ihres Netzwerks stellen? Sie können die Fragen unten beliebig anordnen. Klicken Sie einfach auf die Frage und ziehen Sie an die gewünschte Position.',
        'WHAT_IS_A_NING_ID' => 'Was ist eine Ning ID?',
        'WHAT_IS_MY_EMAIL' => 'Wie lautet meine E-Mail Adresse?',
        'WHAT_IS_THIS' => 'Was ist das?',
        'WHAT_NETWORK_ACTIVITY_EMAIL_FOR' => 'Für welche Netzwerkaktivitäten möchten Sie Nachrichten per E-Mail bekommen?',
        'WHEN_I_UPDATE_MY_PROFILE' => 'Wenn ich mein Profil ändere',
        'WHEN_UPLOADING_IS_COMPLETE' => 'Wenn das Hochladen abgeschlossen ist, können Sie sich das Netzwerk ansehen.',
        'WHEN_YOU_ARE_FINISHED' => 'Wenn Sie fertig sind, klicken Sie auf "Layout anzeigen", um Ihr Werk zu betrachten!',
        'WHEN_YOU_CREATE_NING_ID' => 'Wenn Sie eine Ning ID erstellen, können Sie auch einige Informationen und ein Foto hinzufügen. Wenn Sie dann in einem Netzwerk Mitglied werden, das die Ning ID verwendet, dann werden diese Informationen automatisch im Profil des Netzwerks verwendet. Die Ning ID erlaubt Ihnen auch, die Übersicht zu behalten über Ihre Freunde und Nachrichten in allen sozialen Netzwerke, die die Ning-ID benutzen.',
        'WHICH_OF_YOUR_ACTIONS_DISPLAY_ACTIVITY' => 'Welche Ihrer Aktionen sollte <br />unter "Letzte Aktivitäten" angezeigt werden?',
        'WHO_CAN_COMMENT_ON_PHOTOS_VIDEOS' => 'Wer darf Kommentare zu Ihren Fotos,<br/>Videos und Blog-Beiträgen abgeben?',
        'WHO_CAN_COMMENT_ON_POST' => 'Wer darf Kommentare zu diesem Blog-Beitrag abgeben?',
        'WHO_CAN_JOIN_GROUP' => 'Wer darf dieser Gruppe beitreten?',
        'WHO_CAN_SIGN_UP' => 'Wer darf Mitglied werden?',
        'WHO_CAN_VIEW_PHOTO' => 'Wer darf dieses Foto ansehen?',
        'WHO_CAN_VIEW_POST' => 'Wer darf diesen Blog-Beitrag ansehen?',
        'WHO_CAN_VIEW_VIDEO' => 'Wer darf dieses Video ansehen?',
        'WHO_CAN_VIEW_YOUR_PHOTOS_VIDEOS' => 'Wer darf normalerweise Ihre Fotos, Videos<br/> und Blog-Beiträge ansehen?',
        'WHY_NOT_CREATE_GROUP' => 'Warum starten Sie nicht <a %s>Ihre eigene Gruppe</a>?',
        'WIDGETS' => 'Widgets',
        'WILL_BE_PUBLISHED_ON_X' => 'Wird am %s <small>%s</small> veröffentlicht',
        'WOULD_YOU_LIKE_TO_UPLOAD_FILES' => 'Möchten Sie Dateien hochladen?',
        'WRITE_YOUR_FIRST_ENTRY' => 'Schreiben Sie Ihren ersten Beitrag!',
        'XS_ALBUMS' => 'Alben von %s',
        'XS_BLOG' => 'Blog von %s',
        'XS_BLOG_POSTS_FOR_M_Y' => 'Blog-Beiträge von %s für %s %s',
        'XS_DISCUSSIONS' => 'Diskussionen von %s',
        'XS_DISCUSSIONS_LOWERCASE' => 'Diskussionen von %s',
        'XS_FAVORITES' => 'Favoriten von %s',
        'XS_FAVORITES_X' => 'Favoriten von %s (%s)',
        'XS_FAVORITE_PHOTOS_ON_X' => 'Lieblingsfotos von %s auf %s',
        'XS_FRIENDS' => 'Freunde von %s',
        'XS_FRIENDS_PHOTOS' => 'Fotos von Freunden von %s',
        'XS_LATEST_ACTIVITY_ON_APPNAME' => 'Letzte Aktivität von %s auf %s',
        'XS_PAGE' => 'Persönliche Seite von %s',
        'XS_PAGE_ON_Y' => 'Persönliche Seite von %s auf %s',
        'XS_PHOTO' => 'Foto von %s',
        'XS_PHOTOS' => 'Fotos von %s',
        'XS_POSTS' => 'Beiträge von %s',
        'XS_PROFILE_CHANGED' => 'Das Profil von %s hat sich geändert.',
        'XS_PUBLIC_PHOTOS_ON_X' => 'öffentliche Fotos von %s auf %s',
        'XS_VIDEOS' => 'Videos von %s',
        'XS_VIDEOS_X' => 'Videos von %s (%s)',
        'X_ADDED_A_COMMENT_TO_A_BLOG_POST_ON_Y_ELLIPSIS' => '%1$s hat einen Blog-Beitrag auf %2$s kommentiert…',
        'X_ADDED_A_COMMENT_TO_THE_BLOG_POST_Y_ON_Z' => '%1$s hat den Blog-Beitrag "%2$s" auf %3$s kommentiert.',
        'X_ADDED_THE_BLOG_POST_Y' => '%s hat den Blog-Beitrag "%s" hinzugefügt',
        'X_ADDED_Y_BLOG_POSTS' => '%s hat %s neue Blog-Beiträge hinzugefügt',
        'X_ALL_PHOTOS' => '%s - Alle Fotos',
        'X_ALREADY_REGISTERED_Y_TO_RESET' => 'Es ist bereits eine Ning ID mit der E-Mail Adresse %s registriert. Bitte melden Sie sich unten mit Ihrer Ning ID oder E-Mail Adresse an. Falls Sie Ihr Passwort vergessen haben, <a href="%s">klicken Sie hier, um es zurückzusetzen</a>.',
        'X_COMMENTED_ON_BLOG_POST_TITLE' => '%1$s hat den Blog-Beitrag %2$s kommentiert',
        'X_COMMENTED_ON_POST_TITLE' => '%1$s hat auf die Diskussion %2$s geantwortet',
        'X_CREATED_A_GROUP_Y' => '%s hat die Gruppe %s gegründet.',
        'X_CREATED_Y_NEW_GROUPS' => '%s hat %s neue Gruppen gegründet.',
        'X_DOES_NOT_HAVE_ANY_FRIENDS' => '%s hat noch keine Freunde in diesem Netzwerk.',
        'X_HAS_ACCEPTED_YOUR_FRIEND_REQUEST' => '%s hat Ihre Freundschaftsanfrage auf %s angenommen.',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ON_Y' => '%s hat Sie als Freund/in auf %s hinzugefügt…',
        'X_HAS_INVITED_YOU_TO_JOIN_Y' => '%s lädt Sie ein, Mitglied bei %s zu werden!',
        'X_HAS_NOT_ADDED_DISCUSSIONS' => '%s hat noch keine Diskussionen gestartet.',
        'X_HAS_NOT_ADDED_FAVORITES' => '%s hat noch keine Favoriten.',
        'X_HAS_NOT_ADDED_PHOTOS' => '%s hat noch keine Fotos hinzugefügt.',
        'X_HAS_NOT_ADDED_TO_DISCUSSIONS' => '%s hat noch an keinen Diskussionen teilgenommen.',
        'X_HAS_NOT_ADDED_VIDEOS' => '%s hat noch keine Videos hinzugefügt.',
        'X_HAS_NOT_CREATED_ALBUMS' => '%s hat noch keine Alben erstellt.',
        'X_HAS_NOT_STARTED_DISCUSSIONS' => '%s hat noch keine Diskussionen gestartet.',
        'X_HAS_POSTED_THE_MOST_MUSIC' => '%s hat die meisten Songs hinzugefügt',
        'X_HAS_POSTED_THE_MOST_PHOTOS' => '%1$s hat die meisten %2$sFotos%3$s hinzugefügt',
        'X_HAS_POSTED_THE_MOST_VIDEOS' => '%1$s hat die meisten %2$sVideos%3$s hinzugefügt',
        'X_HAS_REQUESTED_AN_INVITATION' => '%s hat nach einer Einladung für %s gefragt.',
        'X_HAS_SENT_YOU_A_MESSAGE_ON_Y_ELLIPSIS' => '%s hat Ihnen eine Nachricht auf %s gesendet…',
        'X_IS_AWAITING_APPROVAL_TO_BECOME_MEMBER_OF_Y' => '%s wartet darauf, als Mitglied in %s aufgenommen zu werden.',
        'X_IS_CURRENT_LANGUAGE' => '%s ist nun die Sprache Ihres Netzwerks.',
        'X_IS_MEMBER_N_OF_APPNAME' => '%1$s ist Mitglied Nr. %2$s von %3$s.',
        'X_IS_NOT_VALID_EMAIL_ADDRESS' => '%s ist keine gültige E-Mail Adresse',
        'X_IS_NOW_A_MEMBER_OF_Y' => '%1$s ist nun Mitglied von %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y_ELLIPSIS' => '%1$s ist nun Mitglied von %2$s…',
        'X_IS_THE_MOST_POPULAR_BLOG_POST' => '%s ist derzeit der beliebteste Blog-Beitrag',
        'X_IS_THE_MOST_POPULAR_MUSIC' => '%s ist derzeit der beliebteste Song',
        'X_IS_THE_MOST_POPULAR_PHOTO' => '%s ist derzeit das beliebteste Foto',
        'X_IS_THE_MOST_POPULAR_TOPIC' => '%s ist derzeit der beliebteste Diskussionsbeitrag',
        'X_IS_THE_MOST_POPULAR_VIDEO' => '%s ist derzeit das beliebteste Video',
        'X_JOINED_APPNAME' => '%s ist nun ein Mitglied von %s. <a %s>Hinterlassen Sie einen Kommentar</a> für %s.',
        'X_JOINED_THE_GROUP_Y' => '%s ist der Gruppe %s beigetreten',
        'X_JOINED_Y_GROUPS' => '%s ist %s Gruppen beigetreten',
        'X_LEFT_A_COMMENT_FOR_Y' => '%s hat einen Kommentar für %s hinterlassen',
        'X_LEFT_A_COMMENT_FOR_YOU' => '%s hat einen Kommentar für Sie hinterlassen.',
        'X_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '%1$s hat den Blog-Beitrag <a %3$s>%4$s</a> <a %2$s>kommentiert</a>',
        'X_LINK_COMMENTED_ON_PHOTO_TITLE' => '%s hat das Foto <a %s>%s</a> kommentiert',
        'X_LINK_COMMENTED_ON_POST_LINK_TITLE' => '%1$s hat auf die Diskussion <a %3$s>%4$s</a> <a %2$s>geantwortet</a>',
        'X_LINK_COMMENTED_ON_VIDEO_TITLE' => '%s hat das Video <a %s>%s</a> kommentiert',
        'X_NOT_VALID_EMAIL' => '%s ist keine gültige E-Mail Adresse oder Ning ID',
        'X_PROVIDED_FEEDBACK_ON_Y_ELLIPSIS' => '%1$s hat Feedback über %2$s abgegeben…',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK_ON_Y' => '%1$s hat das folgende Feedback auf %2$s abgegeben:',
        'X_REPORTED_AN_ISSUE_ON_Y_ELLIPSIS' => '%1$s hat ein Problem auf %2$s gemeldet…',
        'X_REPORTED_THE_FOLLOWING_ISSUE_ON_Y_ELLIPSIS' => '%1$s hat das folgende Problem auf %2$s gemeldet…',
        'X_SAID' => '%s sagte…',
        'X_STARTED_A_DISCUSSION_Y' => '%s hat die Diskussion %s gestartet',
        'X_STARTED_DISCUSSION_ON_APPNAME_ELLIPSIS' => '%1$s hat eine neue Diskussion auf %2$s gestartet…',
        'X_STARTED_THE_DISCUSSION_Y' => '%1$s hat die Diskussion "%2$s" gestartet.',
        'X_STARTED_Y_FORUM_POSTS' => '%s hat %s neue Diskussionen gestartet',
        'X_UPLOADED_A_VIDEO_THAT_FAILED' => '%s hat ein Video hochgeladen, dessen Konvertierung fehlgeschlagen ist.',
        'X_WANTS_YOU_TO_CHECK_OUT_Y_ON_Z' => '%1$s möchte, dass Sie sich "%2$s" auf %3$s ansehen!',
        'X_WOULD_LIKE_TO_JOIN_X' => '%s würde gerne bei %s Mitglied werden!',
        'YAHOO_MAIL_HOTMAIL' => 'Yahoo Mail, Hotmail, Google Mail oder AOL Mail',
        'YEAR' => 'Jahr',
        'YES' => 'Ja',
        'YES_LET_ME_APPROVE' => 'Ja – Ich möchte Kommentare vor der Veröffentlichung kontrollieren',
        'YES_NOTIFY_BLOG_SERVICES' => 'Yes – <a %s>Externe Blogverfolgungsdienste</a> sollen benachrichtigt werden, wenn Ich einen neuen Beitrag verfasse',
        'YIKES' => 'Ups!',
        'YOU' => 'Sie',
        'YOUR_ALBUM' => 'Ihr Album',
        'YOUR_CHANGES_HAVE_BEEN_SAVED' => 'Ihre Änderungen wurden gespeichert.',
        'YOUR_COMMENT' => 'Ihr Kommentar:',
        'YOUR_COMMENT_HAS_BEEN_ADDED_BUT' => 'Ihr Kommentar wurde gespeichert, aber er muss erst akzeptiert werden, bevor er veröffentlicht wird.',
        'YOUR_EMAIL_ADDRESS' => 'Ihre E-Mail Adresse',
        'YOUR_FEEDBACK' => 'Ihr Feedback',
        'YOUR_FRIEND' => 'Ihr/e Freund/in',
        'YOUR_FRIENDS_DO_NOT_HAVE_PHOTOS' => 'Ihre Freunde haben noch keine Fotos',
        'YOUR_FRIENDS_DO_NOT_HAVE_VIDEOS' => 'Ihre Freunde haben noch keine Videos',
        'YOUR_INVITATIONS_HAVE_BEEN_SENT' => 'Ihre Einladungen wurden verschickt',
        'YOUR_INVITATION_HAS_EXPIRED' => 'Ihre Einladung ist leider abgelaufen',
        'YOUR_MEMBERSHIP_TO_X_IS_PENDING_APPROVAL' => 'Ihre Mitgliedschaft bei %s muss noch von den Administratoren akzeptiert werden.',
        'YOUR_MESSAGE' => 'Ihre Nachricht',
        'YOUR_MESSAGES_SENT' => 'Ihre Nachrichten wurden erfolgreich gesendet.',
        'YOUR_MESSAGE_HAS_BEEN_SENT' => 'Ihre Nachricht wurde an alle Mitglieder Ihres Netzwerks gesendet.',
        'YOUR_MESSAGE_HAS_BEEN_SENT_GROUP' => 'Ihre Nachricht wurde an alle Mitglieder Ihrer Gruppe gesendet.',
        'YOUR_MESSAGE_HAS_BEEN_SENT_TITLE_CASE' => 'Ihre Nachricht wurde gesendet.',
        'YOUR_MESSAGE_IS_BEING_SENT' => 'Ihre Nachricht wird gesendet. Bitte haben Sie etwas Geduld, dies kann einige Minuten dauern.',
        'YOUR_MESSAGE_OPTIONAL' => '<label>Ihre Nachricht</label> (optional)',
        'YOUR_MESSAGE_SENT' => 'Ihre Nachricht wurde erfolgreich gesendet.',
        'YOUR_PHOTO' => 'Ihr Foto',
        'YOUR_PHOTO_COULD_NOT_BE_ADDED' => 'Ihr Foto konnte nicht zu %s hinzugefügt werden',
        'YOUR_PHOTO_HAS_A_NEW_COMMENT_ON_X' => 'Ihr Foto auf %s hat einen neuen Kommentar.',
        'YOUR_PHOTO_TITLED_X_COULD_NOT' => 'Ihr Foto "%s" konnte nicht zu %s hinzugefügt werden.',
        'YOUR_PHOTO_X_HAS_A_NEW_COMMENT_ON_Y' => 'Ihr Foto "%1$s" auf %2$s hat einen neuen Kommentar.',
        'YOUR_POST' => 'Ihr Beitrag:',
        'YOUR_PRIVACY_IS_IMPORTANT' => 'Ihre Privatsphäre ist uns wichtig. Sollten Sie Fragen zu den E-Mail Benachrichtigungen haben, schicken Sie uns eine Nachricht über das<a href="http://help.ning.com/?page_id=27">Hilfezentrum</a>.',
        'YOUR_PROFILE_CHANGED' => 'Ihr Profil hat sich geändert',
        'YOUR_PROFILE_DETAILS_MUST_BE_APPROVED_ON_X' => 'Ihr Profil muss noch durch den Administrator akzeptiert werden, bevor Sie Mitglied von %s werden können. Sie erhalten eine E-Mail, sobald Ihr Profil akzeptiert wurde.',
        'YOUR_PROFILE_IS_PENDING_APPROVAL' => 'Ihr Profil muss noch akzeptiert werden.',
        'YOUR_REPLY' => 'Ihre Antwort:',
        'YOUR_REQUEST_HAS_BEEN_SENT' => 'Ihre Anfrage wurde an den Netzwerkgründer gesendet.',
        'YOUR_REQUEST_HAS_BEEN_SENT_TO_GROUP_CREATOR' => 'Ihre Anfrage wurde an den Gründer der Gruppe gesendet.',
        'YOUR_SETTINGS_HAVE_BEEN_SAVED' => 'Ihre Einstellungen wurden gespeichert.',
        'YOUR_SITES_DIRECTORY_PROFILE' => 'Die Profildaten für den Eintrag für Ihr Netzwerk im Netzwerkverzeichnis wurden gespeichert.',
        'YOUR_SITES_FEATURE_LIST' => 'Die Auswahl der Funktionen für Ihr Netzwerk wurde gespeichert.',
        'YOUR_SITE_ALLOWS_USERS' => 'Sie haben gewählt, Fotos und Videos in Ihrem Netzwerk nicht zu moderieren, bevor sie veröffentlicht werden. Um dies zu ändern klicken Sie <a %s>hier, um zu den Einstellungen für die Privatsphäre zu gelangen,</a> und aktivieren Sie dort "Fotos und Videos vor dem Anzeigen kontrollieren".',
        'YOUR_SITE_IS_READY' => 'Ihr soziales Netzwerk ist startklar! Sollten Sie Schritte übersprungen haben, dann werden die entsprechenden Standardeinstellungen verwendet. Sie können zurückgehen, um Änderungen vorzunehmen, oder klicken Sie auf "Start!", um Ihr Netzwerk zu starten.',
        'YOUR_SITE_REQUIRES_YOU' => 'Sie haben gewählt, Fotos und Videos in Ihrem Netzwerk zu moderieren, bevor sie veröffentlicht werden. Um dies zu ändern klicken Sie <a %s>hier, um zu den Einstellungen für die Privatsphäre zu gelangen,</a> und deaktivieren Sie dort "Fotos und Videos vor dem Anzeigen kontrollieren".',
        'YOUR_TYPE_ON_X_HAS_A_NEW_COMMENT_ELLIPSIS' => 'Ihr %1$s auf %2$s hat ein neuen Kommentar…',
        'YOUR_VIDEO_COULD_NOT_BE_ADDED' => 'Ihr Video konnte nicht zu %s hinzugefügt werden.',
        'YOUR_VIDEO_ON_X_HAS_A_NEW_COMMENT' => 'Ihr Video auf %s hat einen neuen Kommentar.',
        'YOUR_VIDEO_TITLED_X_COULD_NOT' => 'Ihr Video "%s" konnte nicht zu %s hinzugefügt werden',
        'YOUR_VIDEO_UPLOAD_TO_X_DID_NOT_COMPLETE_DUE_TO_A_CONVERSION_ERROR' => 'Aufgrund eines Konvertierungsfehlers konnte Ihr Videos nicht auf %s hochgeladen werden.',
        'YOUR_VIDEO_WAS_SUCCESSFULLY_UPLOADED_TO_X' => 'Ihr Video wurde erfolgreich auf %s hochgeladen.',
        'YOUR_VIDEO_X_ON_Y_HAS_A_NEW_COMMENT' => 'Ihr Video "%1$s" auf %2$s hat einen neuen Kommentar.',
        'YOUR_X_BOX' => 'Ihr %s-Feld',
        'YOUR_X_HAS_BEEN_APPROVED_ON_Y' => 'Ihr %s wurde auf %s akzeptiert.',
        'YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED_ELLIPSIS' => 'Sie wurden als Mitgliedschaft in %s aufgenommen…',
        'YOUR_X_ON_Y_HAS_BEEN_APPROVED_ELLIPSIS' => 'Ihr %s wurde auf %s akzeptiert…',
        'YOUR_X_Y_HAS_BEEN_APPROVED_ON_Z' => 'Ihr %1$s "%2$s" wurde auf %3$s akzeptiert.',
        'YOUTUBE' => 'YouTube',
        'YOUVE_SET_THE_NUMBER_OF_PHOTOS' => 'Sie zeigen derzeit keine Fotos an.',
        'YOUVE_SIGNED_OUT_OF_X' => 'Sie haben sich erfolgreich bei %s abgemeldet. Bitte besuchen Sie uns bald wieder!',
        'YOUVE_TURNED_OFF_THE_ACTIVITY_DISPLAY_CLICK' => 'Sie haben die Anzeige Ihrer Aktivitäten deaktiviert. <a %s>Klicken Sie hier, um sie wieder zu aktivieren. </a>',
        'YOU_ADDED_THE_BLOG_POST_Y' => 'Sie haben den Blog-Beitrag "%s" hinzugefügt',
        'YOU_ADDED_Y_BLOG_POSTS' => 'Sie haben %s neue Blog-Beiträge hinzugefügt',
        'YOU_ARE_DISPLAYING_NO_POSTS' => 'Sie zeigen derzeit keine Blog-Beiträge an.',
        'YOU_ARE_GETTING_STARTED' => 'Sie fangen gerade erst an!',
        'YOU_ARE_MEMBER_OF_GROUP_AND_CAN_INVITE' => 'Sie sind jetzt Mitglied von %1$s. Sie können am Forum von %1$s teilnehmen oder auch weitere Personen in die Gruppe einladen.',
        'YOU_ARE_MODERATING_BLOG_COMMENTS' => 'Die Moderation von Kommentaren zu Blog-Beiträgen ist aktiviert.',
        'YOU_ARE_NOT_MODERATING_BLOG_COMMENTS' => 'Die Moderation von Kommentaren zu Blog-Beiträgen ist nicht aktiviert.',
        'YOU_ARE_NO_LONGER_FOLLOWING_THIS_X' => 'Sie verfolgen Änderungen hier nicht mehr länger.',
        'YOU_ARE_SIGNING_UP_WITH' => 'Sie melden sich mit Ihrer Ning ID an.',
        'YOU_CAN_ADD_100_SONGS' => 'Sie können insgesamt 100 Songs hnzufügen, und jeder Song darf bis zu 20 MB groß sein. Wir unterstützen Songs im .mp3 Dateiformat. ',
        'YOU_CAN_ADD_PHOTOS' => 'Sie können jetzt <a %s>Fotos zu diesem Album hinzufügen</a>.',
        'YOU_CAN_ADD_YOUR_OWN_PHOTOS' => 'Sie können <a %s>Ihre eigenen Fotos</a> zu %s hinzufügen!',
        'YOU_CAN_ADD_YOUR_OWN_VIDEO' => 'Sie können <a %s>Ihr eigenes Video</a> zu %s hinzufügen!',
        'YOU_CAN_CREATE_GROUP' => 'Sie können <a %s>eine neue Gruppe</a> auf %s gründen!',
        'YOU_CAN_CUSTOMIZE_WIDGET' => 'Sie können das Erscheinungsbild des Widgets verändern, indem Sie mit der Maus über das Widget fahren, und dort auf das Icon zur Farbauswahl klicken. Der erscheinende Dialog erlaubt es Ihnen, die Hintergrundfarbe, den Transparenzgrad sowie den generellen Stil des Widgets zu wählen. Sobald Sie das Widget nach Ihren Wünschen konfiguriert haben, klicken Sie auf die &#8220;Copy Me&#8221; Schaltfläche und dann auf die &#8220;Copy Embed Code (+)&#8221; Schaltfläche. Nachdem Sie den Einbettungscode kopiert haben, können Sie ihn in einem beliebigen Textfeld in Ihrem Netzwerk einfügen.',
        'YOU_CAN_MARK_PHOTO' => 'Sie können jedes beliebige Foto zu Ihren Favoriten hinzufügen. Klicken Sie einfach auf den Link "Zu Favoriten hinzufügen" unterhalb des Fotos.',
        'YOU_CAN_MARK_VIDEO' => 'Sie können jedes beliebige Video zu Ihren Favoriten hinzufügen. Klicken Sie einfach auf den Link "Zu Favoriten hinzufügen" unterhalb des Videos',
        'YOU_CAN_NOW_SIGN_IN_USING_YOUR_EMAIL_ADDRESS_HERE' => 'Sie können sich jetzt mit Ihrer E-Mail Adresse hier anmelden:',
        'YOU_CAN_OVERRIDE_WHEN_YOU_ADD' => '(Sie können diese Einstellung für einzelne Fotos, Videos oder Blog-Beiträge ändern, wenn Sie sie hinzufügen.)',
        'YOU_CAN_PARTICIPATE_IN_GROUP' => 'Sie können jetzt am %s Forum teilnehmen.',
        'YOU_CAN_SEND_AT_MOST_X' => 'Sie können höchstens %s auf einmal senden.',
        'YOU_CAN_SHARE_THIS' => 'Sie können dies unten an weiteren Personen senden, oder <a %s>klicken Sie hier, um zurückzukehren</a>.',
        'YOU_CAN_SHARE_TYPE_TWO_WAYS' => 'Sie können diese(s) %s auf zwei Arten &#8230; freigeben',
        'YOU_CAN_SIGN_IN_USING_EMAIL_HERE' => 'Sie können sich hier mit Ihrer E-Mail Adresse anmelden:',
        'YOU_CAN_WRITE_ABOUT_ANYTHING' => 'Sie können über alles Mögliche schreiben, und Ihre Lieblingsvideos, Fotos und Musik einbetten.',
        'YOU_CHANGED_YOUR_EMAIL_ON_X' => 'Sie haben Ihre E-Mail Adresse auf %s geändert.',
        'YOU_CHANGED_YOUR_EMAIL_ON_X_ELLIPSIS' => 'Sie haben Ihre E-Mail Adresse auf %s geändert…',
        'YOU_COMMENTED_ON_PHOTO_TITLE' => 'Sie haben das Foto <a %s>%s</a> kommentiert.',
        'YOU_COMMENTED_ON_VIDEO_TITLE' => 'Sie haben das Video <a %s>%s</a> kommentiert.',
        'YOU_CREATED_APPNAME' => 'Sie haben das Netzwerk %s gegründet.',
        'YOU_CREATED_A_GROUP_Y' => 'Sie haben die Gruppe %s gegründet.',
        'YOU_DO_NOT_HAVE_ANY_FRIENDS' => 'Sie haben noch keine Freunde in diesem Netzwerk.',
        'YOU_DO_NOT_HAVE_COMMENTS' => 'Es gibt derzeit keine zu moderierenden Kommentare.',
        'YOU_DO_NOT_HAVE_POSTS' => 'Sie haben noch keine Beiträge verfasst.',
        'YOU_HAVENT_DONE_ANYTHING_RECENTLY' => 'Es gibt keine aktuellen Aktivitäten. Starten Sie doch was!',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X' => 'Sie haben einen neuen Kommentar auf Ihrer persönlichen Seite auf %s.',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X' => 'Die Aufnahme eines neues Mitglieds auf %s wartet auf Ihre Zustimmung.',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X_ELLIPSIS' => 'Die Aufnahme eines neues Mitglieds auf %s wartet auf Ihre Zustimmung…',
        'YOU_HAVE_A_NEW_X_TITLE_TO_APPROVE_ON_Y' => 'Ein %1$s "%2$s" wartet auf Ihre Zustimmung auf %3$s.',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y' => 'Ein %1$s wartet auf Ihre Zustimmung auf %2$s.',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y_ELLIPSIS' => 'Ein %1$s wartet auf Ihre Zustimmung auf %2$s…',
        'YOU_HAVE_BEEN_BANNED_FROM_APPNAME' => 'Sie wurden von %s ausgeschlossen.',
        'YOU_HAVE_BEEN_INVITED_TO_JOIN' => 'Sie wurden eingeladen, Mitglied zu werden von:',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => 'Sie haben die neue Gruppe %1$s gegründet. Sie können jetzt eine Diskussion im %1$s Forum starten, oder auch weitere Personen zur Teilnahme einladen.',
        'YOU_HAVE_FINISHED_MODERATING' => 'Moderation abgeschlossen.',
        'YOU_HAVE_NOT_ADDED_BLOG_POSTS' => 'Sie haben noch keine Blog-Beiträge hinzugefügt!',
        'YOU_HAVE_NOT_ADDED_CATEGORIES' => 'Es gibt derzeit keine Kategorien. Erstellen Sie doch die erste Kategorie!',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS' => 'Sie haben noch keine Diskussionen gestartet. Fangen Sie doch Ihre erste Diskussion an!',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS_2' => 'Sie haben noch keine Diskussionen gestartet!',
        'YOU_HAVE_NOT_ADDED_FRIENDS' => 'Sie haben auf %s noch keine Freunde hinzugefügt.',
        'YOU_HAVE_NOT_ADDED_PHOTOS' => 'Sie haben noch keine Fotos hinzugefügt!',
        'YOU_HAVE_NOT_ADDED_PHOTOS_2' => 'Sie haben noch keine Fotos hinzugefügt. Laden Sie doch ein paar Fotos hoch!',
        'YOU_HAVE_NOT_ADDED_TO_DISCUSSIONS' => 'Sie haben noch an keinen Diskussionen teilgenommen.',
        'YOU_HAVE_NOT_ADDED_VIDEOS' => 'Sie haben noch keine Videos hinzugefügt!',
        'YOU_HAVE_NOT_ADDED_VIDEOS_2' => 'Sie haben noch keine Videos hinzugefügt. Laden Sie doch ein paar Videos hoch!',
        'YOU_HAVE_NOT_CREATED_ALBUMS' => 'Sie haben noch kein Album erstellt. Sie können <a %s>hier ein neues Album erstellen</a>.',
        'YOU_HAVE_NOT_CREATED_GROUPS' => 'Sie haben noch keine Gruppen gegründet.',
        'YOU_HAVE_NOT_CREATED_GROUPS_2' => 'Sie haben noch keine Gruppen gegründet!',
        'YOU_HAVE_NOT_STARTED_DISCUSSIONS' => 'Sie haben noch keine Diskussionen gestartet.',
        'YOU_HAVE_RECEIVED_BECAUSE_X' => 'Sie haben diese E-Mail aus diesem Grund erhalten: %s',
        'YOU_JOINED_THE_GROUP_X' => 'Sie sind Mitglied der Gruppe %s geworden.',
        'YOU_JOINED_X_GROUPS' => 'Sie sind Mitglied von %s Gruppen geworden.',
        'YOU_JUST_TRIED_TO_SEND' => 'Sie haben gerade versucht, ein Foto an %1$s zu senden. Leider sind Sie kein Mitglied von %1$s, und daher können wir dieses Foto nicht übermitteln.',
        'YOU_JUST_TRIED_TO_SEND_VIDEO' => 'Sie haben gerade versucht, ein Video an %1$s zu senden. Leider sind Sie kein Mitglied von %1$s, und daher können wir dieses Video nicht übermitteln.',
        'YOU_LEFT_A_COMMENT_FOR_X' => 'Sie haben einen Kommentar für %s hinterlassen.',
        'YOU_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => 'Sie haben den Blog-Beitrag <a %2$s>%3$s</a> <a %1$s>kommentiert</a>',
        'YOU_LINK_COMMENTED_ON_POST_LINK_TITLE' => 'Sie haben auf die Diskussion <a %2$s>%3$s</a> <a %1$s>geantwortet</a>',
        'YOU_NEED_TO_BE_' => 'Sie müssen %s sein, um dies zu tun.',
        'YOU_NEED_TO_BE_A_FRIEND' => 'Sie müssen mit %s befreundet sein, um dies zu tun.',
        'YOU_NEED_TO_BE_MEMBER' => 'Sie müssen Mitglied von %s sein, um Kommentare hinzufügen zu dürfen!',
        'YOU_NEED_TO_BE_MEMBER_COMMENTS' => 'Sie müssen Mitglied von %s sein, um Kommentare hinzufügen zu dürfen!',
        'YOU_NEED_TO_BE_OWNER' => 'Sie müssen der Gründer des Netzwerks sein, um dies zu tun.',
        'YOU_NEED_TO_BE_SIGNED_IN' => 'Sie müssen angemeldet sein, um dies zu tun.',
        'YOU_NEED_TO_BE_X' => 'Sie müssen %s sein, um dies zu tun',
        'YOU_NEED_TO_SET_UP_FLICKR' => 'Sie müssen Ihr Netzwerk erst für den Import von Fotos von Flickr konfigurieren. Die Konfiguration ist einfach, warum also nicht <a %s>gleich einrichten?</a>',
        'YOU_STARTED_A_DISCUSSION_Y' => 'Sie haben eine Diskussion mit dem Titel %s gestartet.',
        'YOU_STARTED_Y_FORUM_POSTS' => 'Sie haben %s neue Diskussionen gestartet.',
    );

    /**
     * Returns a locale-dependent version of a url. The first argument is the url name, e.g., 'FLICKR_SUMMARY_SCREENSHOT'.
     * Subsequent arguments are substitution values (if the url contains sprintf format elements).
     *
     * @param $args array the url name, plus optional substitution values
     * @return string the url for this catalog
     */
    public static function url($args) {
        $text = self::$urls[$args[0]];
        if ($text) {
            $args[0] = $text;
        }

        return @call_user_func_array('sprintf', $args);
    }

    /**
     * Default URLs that might be different depending on the locale. Please note that URLs are required to be properly
     * xhtml encoded. I.e. if they contain parameters then they should look like:
     *
     * /foo/bar?x=y&amp;y=z
     */
    private static $urls = array(
        'FLICKR_SCREENSHOT_GETKEY' => '/xn_resources/widgets/index/gfx/flickr/getkey_de_DE.png',
        'FLICKR_SCREENSHOT_KEY' => '/xn_resources/widgets/index/gfx/flickr/key_de_DE.png',
        'FLICKR_SCREENSHOT_KEYINFO' => '/xn_resources/widgets/index/gfx/flickr/keyinfo_de_DE.png',
        'FLICKR_SCREENSHOT_SETUPKEY' => '/xn_resources/widgets/index/gfx/flickr/setupkey_de_DE.png'
    );

    /**
     * If the given widget title is the default English title for the widget,
     * translate it into the current language.
     *
     * @param $widgetTitle string  The title of the widget
     * @return string  A translated title if the title is the English default; otherwise, the title unchanged
     */
    public static function translateDefaultWidgetTitle($widgetTitle) {

        return $widgetTitle;
    }

}
