<?php

XG_App::includeFileOnce('/lib/XG_AbstractMessageCatalog.php');

/**
 * Texts for the cs_CZ
 */
class XG_MessageCatalog_cs_CZ extends XG_AbstractMessageCatalog {



    /**
     * Returns a localized version of a string. The first argument is the message name, e.g., 'ADD_A_PHOTO'.
     * Subsequent arguments are substitution values (if the message contains sprintf format elements).
     *
     * @param array $args the message name, plus optional substitution values
     * @return string the localized string
     * @see xg_html()
     */
    public static function text($args) {
        $s = $args[0];
        static $a = array();
        if (! $a) {
            $a['N_INVITATIONS_RESENT']['1'] = '1 pozvánka byla zaslána znovu. ';
            $a['N_INVITATIONS_RESENT']['n'] = '%s pozvánky (pozvánek) bylo zasláno znovu. ';
            $a['N_SECONDS_AGO']['1'] = 'před 1 sekundou ';
            $a['N_SECONDS_AGO']['n'] = 'před %s sekundami ';
            $a['N_MINUTES_AGO']['1'] = 'před 1 minutou ';
            $a['N_MINUTES_AGO']['n'] = 'před %s minutami ';
            $a['N_HOURS_AGO']['1'] = 'před 1 hodinou ';
            $a['N_HOURS_AGO']['n'] = 'před %s hodinami ';
            $a['N_VIDEOS']['1'] = '<strong>1</strong> videoklip ';
            $a['N_VIDEOS']['n'] = '<strong>%s</strong> videoklipů ';
            $a['N_VIEWS']['1'] = '1 prohlédnutí ';
            $a['N_VIEWS']['n'] = '%s prohlédnutí ';
            $a['N_COMMENTS']['1'] = '<span class="comment-count">1</span> komentář ';
            $a['N_COMMENTS']['n'] = '<span class="comment-count">%s</span> komentářů ';
            $a['VIDEO_IS_FAVORITE_OF']['1'] = 'Tento videoklip je zařazen mezi <strong>oblíbené</strong> u <strong>1 osoby</strong>. ';
            $a['VIDEO_IS_FAVORITE_OF']['n'] = 'Tento videoklip je zařazen mezi <strong>oblíbené</strong> u <strong>%s osob</strong>. ';
            $a['Y_ADDED_X_VIDEOS']['1'] = '%2$s přidal(a) videoklip: ';
            $a['Y_ADDED_X_VIDEOS']['n'] = '%2$s přidal(a) více videoklipů (%s). ';
            $a['YOU_ADDED_X_VIDEOS']['1'] = 'Přidali jste videoklip: ';
            $a['YOU_ADDED_X_VIDEOS']['n'] = 'Přidali jste více videoklipů (%s). ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['1'] = 'Na serveru %2$s je 1 videoklip ';
            $a['THERE_ARE_X_VIDEOS_ON_APPNAME']['n'] = 'Na serveru %2$s je více videoklipů (%1$s) ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['1'] = 'Na serveru %2$s je 1 <a href="%3$s">videoklip</a> ';
            $a['THERE_ARE_X_LINK_VIDEOS_ON_APPNAME']['n'] = 'Na serveru %2$s je více <a href="%3$s">videoklipů</a> (%1$s) ';
            $a['N_PHOTOS_FROM_ALBUM']['1'] = '1 snímek z tohoto alba byl odstraněn nebo změněn na soukromý, takže jej nelze zobrazit. ';
            $a['N_PHOTOS_FROM_ALBUM']['n'] = '%s snímků z tohoto alba bylo odstraněno nebo změněno na soukromé, takže je nelze zobrazit. ';
            $a['N_PHOTOS']['1'] = '<strong>1</strong> snímek ';
            $a['N_PHOTOS']['n'] = '<strong>%s </strong>snímků ';
            $a['N_PHOTOS_2']['1'] = '1 snímek ';
            $a['N_PHOTOS_2']['n'] = 'snímků: %s ';
            $a['AND_X_OTHER_PEOPLE']['1'] = 'a 1 další osobě ';
            $a['AND_X_OTHER_PEOPLE']['n'] = 'a %s dalším osobám ';
            $a['PROBLEM_UPLOADING_FILES']['1'] = 'Došlo k problémům s uploadem následujícího souboru: ';
            $a['PROBLEM_UPLOADING_FILES']['n'] = 'Došlo k problémům s uploadem následujících souborů: ';
            $a['PHOTO_IS_FAVORITE_OF']['1'] = 'Tento snímek je zařazen mezi <strong>oblíbené</strong> u <strong>1 osoby</strong>. ';
            $a['PHOTO_IS_FAVORITE_OF']['n'] = 'Tento snímek je zařazen mezi <strong>oblíbené</strong> u <strong>%s osob</strong>. ';
            $a['RATING_Y_AFTER_X_VOTES']['1'] = '<strong>Hodnocení:</strong> %2$s po 1 odevzdaném hlasu ';
            $a['RATING_Y_AFTER_X_VOTES']['n'] = '<strong>Hodnocení:</strong> %2$s po %s odevzdaných hlasech ';
            $a['Y_AFTER_X_VOTES']['1'] = '%2$s po 1 odevzdaném hlasu ';
            $a['Y_AFTER_X_VOTES']['n'] = '%2$s po %s odevzdaných hlasech ';
            $a['N_PEOPLE']['1'] = '1 osoba ';
            $a['N_PEOPLE']['n'] = '%s osob ';
            $a['N_OF_5_STARS']['1'] = '1/5 hvězdiček ';
            $a['N_OF_5_STARS']['n'] = '%s/5 hvězdiček ';
            $a['YOUR_RATING_X_STARS']['1'] = 'Vaše hodnocení: 1 hvězdička ';
            $a['YOUR_RATING_X_STARS']['n'] = 'Vaše hodnocení: %s hvězdiček ';
            $a['Y_ADDED_X_PHOTOS']['1'] = '%2$s přidal(a) snímek: ';
            $a['Y_ADDED_X_PHOTOS']['n'] = '%2$s přidal(a) více snímků (%s). ';
            $a['YOU_ADDED_X_PHOTOS']['1'] = 'Přidali jste snímek: ';
            $a['YOU_ADDED_X_PHOTOS']['n'] = 'Přidali jste více snímků (%s). ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['1'] = 'Na serveru %2$s je 1 snímek ';
            $a['THERE_ARE_X_PHOTOS_ON_APPNAME']['n'] = 'Na serveru %2$s je více snímků (%1$s) ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['1'] = 'Na serveru %2$s je více <a href="%3$s">snímků</a> (%1$s) ';
            $a['THERE_ARE_X_LINK_PHOTOS_ON_APPNAME']['n'] = 'Na serveru %2$s je více <a href="%3$s">snímků </a>(%1$s) ';
            $a['N_COMMENTS_ON_PAGE']['1'] = '<strong>1</strong> komentář k profilu ';
            $a['N_COMMENTS_ON_PAGE']['n'] = '<strong>%s</strong> komentáře (komentářů) k profilu ';
            $a['N_BLOG_COMMENTS']['1'] = '<strong>1</strong> komentář v blogu ';
            $a['N_BLOG_COMMENTS']['n'] = '<strong>%s</strong> komentářů v blogu ';
            $a['N_YEARS_OLD']['1'] = '1 rok staré ';
            $a['N_YEARS_OLD']['n'] = '%s let staré ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['1'] = 'Máte 1 žádost o zařazení mezi přátele. ';
            $a['YOU_HAVE_N_FRIEND_REQUESTS']['n'] = 'Máte žádost od %s přátel. ';
            $a['COMMENT_WALL_N_COMMENTS']['1'] = 'Nástěnka (1 komentář) ';
            $a['COMMENT_WALL_N_COMMENTS']['n'] = 'Nástěnka (%s komentářů) ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['1'] = 'Za minulý týden vstoupil 1 nový člen ';
            $a['X_NEW_MEMBERS_JOINED_PAST_WEEK']['n'] = 'Za minulý týden vstoupilo nových členů: %s ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['1'] = 'Za minulý týden vstoupil 1 <a href="%2$s">nový člen</a> ';
            $a['X_NEW_LINK_MEMBERS_JOINED_PAST_WEEK']['n'] = 'Za minulý týden vstoupilo <a href="%2$s">nových členů</a>: %1$s ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['1'] = 'Na serveru %2$s je připojen 1 člen ';
            $a['THERE_ARE_X_MEMBERS_ON_APPNAME']['n'] = 'Na serveru %2$s je připojeno členů: %1$s ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['1'] = 'Na serveru %2$s je připojen 1 <a href="%3$s">člen</a> ';
            $a['THERE_ARE_X_LINK_MEMBERS_ON_APPNAME']['n'] = 'Na serveru %2$s je připojeno <a href="%3$s">členů</a>: %1$s ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['1'] = 'Na serveru %2$s je 1 blogový příspěvek ';
            $a['THERE_ARE_X_BLOG_POST_ON_APPNAME']['n'] = 'Na serveru %2$s je blogových příspěvků: %1$s ';
            $a['N_NEW_MEMBERS']['1'] = '<strong>1</strong> nový člen ';
            $a['N_NEW_MEMBERS']['n'] = '<strong>%s</strong> nových členů ';
            $a['N_REPLIES']['1'] = '1 odpověď ';
            $a['N_REPLIES']['n'] = '%s odpovědí ';
            $a['N_MINUTES']['1'] = 'Komentář můžete ještě upravovat 1 min. ';
            $a['N_MINUTES']['n'] = 'Komentář můžete ještě upravovat %s min. ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['1'] = 'Na serveru %2$s je 1 téma fóra ';
            $a['THERE_ARE_X_FORUM_TOPIC_ON_APPNAME']['n'] = 'Na serveru %2$s je témat fóra: %1$s ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['1'] = 'Na serveru %2$s je 1 <a href="%3$s">téma fóra</a> ';
            $a['THERE_ARE_X_LINK_FORUM_TOPIC_ON_APPNAME']['n'] = 'Na serveru %2$s je <a href="%3$s">témat fóra</a>: %1$s ';
            $a['N_INVITES']['1'] = '%s pozvaný ';
            $a['N_INVITES']['n'] = 'pozvaných: %s ';
            $a['N_MEMBERS']['1'] = '1 člen ';
            $a['N_MEMBERS']['n'] = '%s členů ';
            $a['N_MEMBERS_PARENTHESIZED']['1'] = '(1 člen) ';
            $a['N_MEMBERS_PARENTHESIZED']['n'] = '(%s členů) ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['1'] = 'Na serveru %2$s je 1 skupina ';
            $a['THERE_ARE_X_GROUPS_ON_APPNAME']['n'] = 'Na serveru %2$s je skupin: %1$s ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['1'] = 'Na serveru %2$s je <a href="%3$s">skupin</a>: %1$s ';
            $a['THERE_ARE_X_LINK_GROUPS_ON_APPNAME']['n'] = 'Na serveru %2$s je <a href="%3$s">skupin</a>: %1$s ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['1'] = '1 skladbu z tohoto playlistu nelze zobrazit, protože byla odstraněna nebo už není sdíleny. ';
            $a['N_TRACKS_REMOVED_FROM_PLAYLIST']['n'] = 'Více skladeb (%s ) z tohoto playlistu nelze zobrazit, protože byly odstraněny nebo už nejsou sdíleny. ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['1'] = 'Na server %2$s byla přidána nová skladba ';
            $a['X_NEW_SONGS_ADDED_TO_APPNAME']['n'] = 'Na server %2$s byly přidány nové skladby v počtu %1$s ';
            $a['Y_ADDED_X_SONGS']['1'] = '%2$s přidal(a) skladbu: ';
            $a['Y_ADDED_X_SONGS']['n'] = '%2$s přidal(a) více skladeb (%s). ';
            $a['YOU_ADDED_X_SONGS']['1'] = 'Přidali jste skladbu: ';
            $a['YOU_ADDED_X_SONGS']['n'] = 'Přidali jste více skladeb (%s). ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['1'] = '1 skladba přidána na tento playlist. ';
            $a['N_TRACKS_ADDED_TO_PLAYLIST']['n'] = 'Na tento playlist bylo přidáno více skladeb (%s). ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['1'] = 'Na serveru %2$s je 1 skladba. ';
            $a['THERE_ARE_X_SONGS_ON_APPNAME']['n'] = 'Na serveru %2$s je více skladeb (%1$s) ';
        }
        if ($a[$args[0]]) {
            $args[0] = $a[$args[0]][$args[1]] ? $a[$args[0]][$args[1]] : $a[$args[0]]['n'];
            return @call_user_func_array('sprintf', $args);
        }
        $text = self::$messages[$s];
        if ($text) { $args[0] = $text; }
        return @call_user_func_array('sprintf', $args);
    }

    /**
     * Message names and texts. Use UTF-8 byte sequences instead of HTML entities, e.g., & instead of &amp;, … instead of &hellip;
     */
    private static $messages = array(
        'EACH_VIDEO_MAY_BE_100MB' => 'Každý videoklip může mít velikost až 100 MB. Podporujeme videoklipy ve formátech .mov, .mpg, .avi, .wmv a .3gp.',
        'I_HAVE_RIGHT_TO_UPLOAD_VIDEO' => 'Tyto videoklipy mám právo uploadovat v souladu s <a %s>Podmínkami služby</a>.',
        'VIDEO_UPLOADER_REQUIRES_JAVA' => 'Hromadný upload videoklipů vyžaduje novější verzi Javy. <strong><a %s>Klepněte sem, chcete-li si Javu stáhnout,</a></strong> nebo <strong><a %s> se vraťte k uploadu jednotlivých souborů</a></strong>.',
        'UPLOAD_A_VIDEO_FROM_YOUR_COMPUTER' => 'Uploadovat videoklip z počítače',
        'HAVE_LOT_OF_VIDEOS' => 'Chcete se podělit o spoustu videoklipů?',
        'TRY_BULK_VIDEO_UPLOADER' => 'Zkuste hromadný upload videoklipů',
        'VIDEOS_SUCCESSFULLY_UPLOADED' => 'Videoklipy byly úspěšně odeslány.',
        'VIDEOS_UPLOADED_AWAITING' => 'Videoklipy byly úspěšně odeslány a čekají na schválení zakladatelem skupiny/komunity %s.',
        'ADD_VIDEOS_OR_PHOTOS_TO_APPNAME' => 'Přidejte snímky nebo videoklipy na %s přímo po telefonu nebo zasláním emailem na speciální adresu.',
        'GRAB_HTML_EMBED' => 'Extrahujte vložený HTML kód z jakéhokoli populárního serveru s videoklipy a přidejte videoklip do této komunity.',
        'GOOGLE' => 'Google',
        'YOUTUBE' => 'YouTube',
        'HAVING_PROBLEMS_WITH_VIDEO_UPLOADER' => 'Máte problém s hromadným uploadem videoklipů? <strong><a %s>Vraťte se k uploadu jednotlivých souborů</a></strong>.',
        'ADD_VIDEOS_FROM_YOUTUBE' => 'Přidat videoklip z YouTube nebo Google',
        'BROWSING' => 'Procházení',
        'MORE_VIDEOS' => 'Další videoklipy',
        'NETWORK_DOES_NOT_HAVE_VIDEOS' => 'Tato komunita nemá zatím žádné videoklipy',
        'NETWORK_DOES_NOT_HAVE_FEATURED_VIDEOS' => 'Tato komunita nemá zatím žádné videoklipy vystavené jako Zajímavé.',
        'PERSON_DOES_NOT_HAVE_VIDEOS' => 'Tato osoba nemá zatím žádné videoklipy',
        'COPY_TO_CLIPBOARD' => 'Kopírovat do schránky',
        'COPIED_TO_CLIPBOARD' => 'Zkopírováno do schránky!',
        'NO_VIDEOS_TO_DISPLAY' => 'V současné době nenabízíte žádné videoklipy.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_VIDEO' => 'Tento rámeček se jiným osobám nezobrazí, dokud nevyberete aspoň jeden videoklip.',
        'WATERMARK_LOGO' => 'Logo ve formě vodoznaku',
        'CHOOSE_HEADER_OR_WATERMARK' => 'Na svém videopřehrávači si můžete nastavit hlavičku nebo logo ve formě vodoznaku.',
        'CUSTOMIZE_EMBED_INSTRUCTIONS' => 'Logo se zobrazí v horní části položky: %s.  Pokud nepřidáte logo, bude místo něj zobrazen název sítě.  Logo musí být ve formátu . jpg, . gif nebo . png  U loga vyššího než 20 pixelů bude upravena velikost.',
        'CUSTOMIZE_WATERMARK_INSTRUCTIONS' => 'Vodoznak se zobrazí v pravé dolní části videoklipu.',
        'HEADER_LOGO' => 'Logo v hlavičce',
        'WATERMARK' => 'Vodoznak',
        'CUSTOMIZE_YOUR_VIDEO_PLAYER' => 'Upravte si videopřehrávač na míru!',
        'VIDEO_PLAYER' => 'Videopřehrávač',
        'HEADER' => 'Hlavička',
        'SAVE_CHANGES' => 'Uložit změny',
        'THUMBNAIL' => 'Náhled',
        'CONVERSION_FAILED' => 'Konverze se nezdařila',
        'CONVERSION_IN_PROGRESS' => 'Probíhá konverze',
        'MAP' => 'Mapa',
        'WHAT_IS_THIS' => 'Co je to?',
        'EDIT_VIDEO_INFORMATION' => 'Upravit informace o videoklipu',
        'ALL_VIDEOS' => 'Všechny videoklipy',
        'VIDEOS_HOME' => 'Hlavní nabídka videoklipů',
        'MY_VIDEOS' => 'Moje videoklipy',
        'MY_FRIENDS_VIDEOS' => 'Videoklipy přátel',
        'MY_FAVORITES' => 'Oblíbené',
        'XS_FAVORITES' => 'Oblíbené člena: %s',
        'ADD_A_VIDEO' => 'Přidat videoklip',
        'JUST_NOW' => 'teď',
        '1_DAY_AGO' => 'včera',
        'M_J' => 'M j',
        'ME' => 'Já',
        'X_SAID' => '%s řekl(a)…',
        'DELETE_COMMENT' => 'Odstranit komentář',
        'YOU_HAVE_NOT_ADDED_VIDEOS' => 'Zatím jste nepřidali žádný videoklip!',
        'ADD_VIDEOS_AND_SHARE' => 'Přidejte videoklipy a podělte se o ně přáteli, rodinou nebo celým světem!',
        'ADD_VIDEOS' => 'Přidat videoklipy',
        'VIEW_VIDEOS' => 'Zobrazit videoklipy',
        'YIKES' => 'Jejda!',
        'A_PROBLEM_SEEMS' => 'Zřejmě došlo k nějakému problému.',
        'FOR_FURTHER_ASSISTANCE' => 'Pokud potřebujete pomoci, <a %s>kontaktujte nás prosím</a>.',
        'OR_YOU_CAN_GO' => 'Můžete se také vrátit na hlavní stránku: <a %s>%s</a> <a %s>nebo se rozhlédnout po jiných komunitách na serveru Ning</a>',
        'TAGS' => 'Popisky:',
        'TAGS_NO_COLON' => 'Popisky',
        'POPULAR_TAGS' => 'Populární popisky',
        'MY_FRIENDS' => 'Moji přátelé',
        'VIEW_ALL_MY_FRIENDS' => 'Zobrazit všechny přátele',
        'VIEW_ALL_XS_FRIENDS' => 'Zobrazit všechny přátele člena: %s',
        'WE_COULD_NOT_FIND_ANYONE_MATCHING' => 'Omlouváme se - hledání se zadanými parametry bylo bezvýsledné.',
        'VIEW_POPULAR_CONTRIBUTORS' => 'Zobrazit populární přispěvatele',
        'POPULAR_CONTRIBUTORS' => 'Populární přispěvatelé',
        'VIEW_MORE_CONTRIBUTORS' => 'Zobrazit více přispěvatelů',
        'ADD_AS_FRIEND' => 'Přidat jako přítele',
        'SEND_A_MESSAGE' => 'Odeslat zprávu',
        'IS_YOUR_FRIEND' => 'je váš přítel',
        'IS_BLOCKED' => 'je blokován(a)',
        'SORT_BY' => 'Seřadit podle:',
        'CLOSE' => 'Zavřít',
        'USER_COUNT' => '(%d)',
        'NOBODY_HAS_ADDED_VIDEOS' => 'Nikdo zatím nepřidal žádné videoklipy!  Přidejte nějaké videoklipy do začátku.',
        'SEARCH_PEOPLE' => 'Vyhledat osoby:',
        'INVITE_YOUR_FRIENDS_TO' => 'Pozvěte přátele do komunity %s.',
        'INVITE' => 'Pozvat',
        'INVITE_TAB_TEXT' => 'Pozvat',
        'YOU_HAVE_NOT_ADDED_FRIENDS' => 'Zatím jste žádné přátele do: %s nepozvali.',
        'SEARCH_FRIENDS' => 'Vyhledat přátele:',
        'ADD_YOUR_FIRST_VIDEO' => 'Přidat první videoklip',
        'USE_HTML_EMBED_CODE' => 'Použít vložený HTML kód',
        'UPLOAD_A_VIDEO_FROM' => 'Uploadujte videoklip z počítače. Přijímáme všechny běžné formáty!',
        'WE_SUPPORT_MOV' => 'Podporujeme soubory ve formátech .mov, .mpg, .avi, .3gp a .wmv. Soubory mohou být velké max. 100 MB.',
        'NEED_HELP_HERE_ARE' => 'Potřebujete pomoci?  Zde jsou pokyny pro videoklipy z <a %s>YouTube</a> a <a %s>Google Video</a>.',
        'ADD_TITLE_AND_DESCRIPTION' => 'Přidejte název a popis',
        'DESCRIPTION_COLON' => 'Popis:',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_1' => 'Přidejte název, popis a další informace o nově přidaném videoklipu.',
        'EVERYTHING_IS_OPTIONAL' => 'Nic z toho není povinné;  pokud nechcete přidávat nic, klepněte na volbu "Přeskočit tento krok" napravo.',
        'SKIP_THIS_STEP' => 'Přeskočit tento krok',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_VIDEO_2' => 'Přidejte název, popis a další informace o tomto videoklipu.',
        'CANCEL_AND_RETURN_TO_VIDEO' => 'Zrušit a vrátit se k videoklipu',
        'TITLE' => 'Název:',
        'TAGS_ARE_SHORT_DESCRIPTIONS' => 'Popisek je krátký text, který vám usnadní hledání videoklipů.  Zadáváte-li více popisků, oddělte je čárkami, a víceslovné uzavřete do uvozovek, např. "San Francisco".',
        'WHO_CAN_VIEW_VIDEO' => 'Kdo si tento videoklip smí prohlédnout?',
        'MOST_POPULAR' => 'Nejpopulárnější',
        'HIGHEST_RATED' => 'Nejlépe hodnocené',
        'MOST_RECENT' => 'Nejnovější',
        'MOST_FAVORITED' => 'Nejfrekventovanější oblíbené',
        'MOST_POPULAR_VIDEOS' => 'Nejpopulárnější videoklipy',
        'HIGHEST_RATED_VIDEOS' => 'Nejlépe hodnocené videoklipy',
        'MOST_RECENT_VIDEOS' => 'Nejnovější videoklipy',
        'MOST_FAVORITED_VIDEOS' => 'Nejfrekventovanější oblíbené videoklipy',
        'ANYONE' => 'Kdokoli',
        'JUST_MY_FRIENDS' => 'Jen přátelé',
        'JUST_ME' => 'Jen já',
        'VIEWABLE_BY_FRIENDS' => 'Mohou vidět:<strong> přátelé</strong>',
        'PRIVATE_VIDEO' => '<strong>Soukromý</strong> videoklip',
        'VIEWABLE_BY_EVERYONE' => 'Může vidět:<strong>každý</strong>',
        'LOCATION' => 'Místo pořízení:',
        'NO_LOCATION' => 'Místo neurčeno',
        'CLICK_ON_LOCATION' => 'Klepněte na místo pořízení na mapě:',
        'FIND_AN_ADDRESS' => 'Najít adresu:',
        'LOCATE' => 'Vyhledat',
        'YOU_CAN_ADD_YOUR_OWN_VIDEO' => 'Můžete <a %s>přidat vlastní videoklip</a> na stránky %s!',
        'ADD_PLAYER_LOGO_OR_WATERMARK' => 'Přidejte na videopřehrávač vaší komunity logo nebo vodoznak.  <a %s>Udělejte to hned! </a>',
        'APPROVE' => 'Schválit',
        'DELETE' => 'Odstranit',
        'APPLY_TO_VIDEOS_ADDED_BY' => 'Použít u všech videoklipů, které přidal(a) %s',
        'NO_TITLE' => 'Bez názvu',
        'ADDED_BY_STRONG_X' => 'Přidal(a) <strong>%s</strong>',
        'NO_DESCRIPTION' => 'Bez popisu',
        'BY_X' => 'připravil(a) %s',
        'YOU_HAVE_FINISHED_MODERATING' => 'Schvalování je hotovo.',
        'NO_VIDEOS_AWAITING_APPROVAL' => 'Žádné videoklipy nečekají na schválení.  Pokud hledáte nějakou zajímavou činnost, co se takhle podívat na <a %s>nové videoklipy</a>?',
        'NO_ONE_HAS_ADDED_ANY_VIDEOS' => 'Ve vaší komunitě nikdo nepřidal videoklipy.  Přidejte videoklip jako první!',
        'ADDED_ON_DATE_BY_X' => 'Přidáno: %s. Přidal(a) %s.',
        'REMOVE_FROM_FAVORITES' => 'Odebrat z oblíbených',
        'REMOVE_VIDEO_FROM_FAVORITES' => 'Odebrat videoklip z oblíbených?',
        'COLLECTED_BY_X' => 'Shromáždil(a) %s',
        'ADD_FAVORITES' => 'Přidat do oblíbených',
        'YOU_CAN_MARK_VIDEO' => 'Jakýkoli videoklip si můžete označit jako oblíbený.  Stačí klepnout na ikonu "Přidat k oblíbeným", jakmile se u videoklipu objeví.',
        'VIEW_RECENT_VIDEOS' => 'Zobrazit nejnovější videoklipy',
        'X_HAS_NOT_ADDED_FAVORITES' => '%s zatím nemá žádné oblíbené.',
        'APPROVE_VIDEOS' => 'Schválit videoklipy',
        'YOUR_SITE_REQUIRES_YOU' => 'Vyžádali jste si právo schvalovat snímky a videoklipy před jejich zveřejněním.  Chcete-li toto nastavení změnit, <a %s>klepněte sem a přejděte na stránku Soukromí</a>. Tam pak zrušte volbu "Schvalovat nové snímky a videoklipy".',
        'YOUR_SITE_ALLOWS_USERS' => 'Nevyžádali jste si právo schvalovat snímky a videoklipy před jejich zveřejněním.  Chcete-li toto nastavení změnit, <a %s>klepněte sem a přejděte na stránku Soukromí</a>. Tam pak aktivujte volbu "Schvalovat nové snímky a videoklipy".',
        'APPROVE_ALL_VIDEOS' => 'Schválit všechny videoklipy?',
        'ARE_YOU_SURE_APPROVE_ALL_VIDEOS' => 'Opravdu chcete schválit všechny videoklipy?  Operace může trvat několik minut.',
        'APPROVING' => 'Schvalování…',
        'APPROVE_ALL' => 'Schválit vše',
        'DELETE_ALL_VIDEOS' => 'Odstranit všechny videoklipy?',
        'ARE_YOU_SURE_DELETE_ALL_VIDEOS' => 'Opravdu chcete odstranit všechny videoklipy?  Operace může trvat několik minut.',
        'DELETING' => 'Odstraňování…',
        'DELETE_ALL' => 'Odstranit vše',
        'XS_VIDEOS' => 'Videoklipy, které přidal(a) %s',
        'DELETE_ALL_XS_VIDEOS_Q' => 'Odstranit všechny videoklipy, které přidal(a) %s?',
        'DELETE_ALL_XS_VIDEOS' => 'Odstranit všechny videoklipy, které přidal(a) %s',
        'ARE_YOU_SURE_DELETE_ALL_XS_VIDEOS' => 'Opravdu chcete odstranit všechny videoklipy, které přidal(a) %s?  Operace může trvat několik minut.',
        'DELETE_THIS_VIDEO_Q' => 'Odstranit tento videoklip?',
        'ARE_YOU_SURE_DELETE_THIS_VIDEO' => 'Opravdu chcete tento videoklip odstranit?  Operace může trvat několik minut.',
        'YOU_HAVE_NOT_ADDED_VIDEOS_2' => 'Zatím jste nepřidali žádný videoklip.  Přidejte nějaké videoklipy do začátku!',
        'X_HAS_NOT_ADDED_VIDEOS' => '%s zatím nepřidal(a) žádné videoklipy.',
        'YOUR_FRIENDS_DO_NOT_HAVE_VIDEOS' => 'Vaši přátelé zatím nemají žádné videoklipy',
        'ALL_VIDEOS_TAGGED_X' => 'Všechny videoklipy označené popiskem %s',
        'ALL_VIDEOS_TAGGED_X_2' => 'Všechny videoklipy označené popiskem <em>%s</em>',
        'NO_VIDEOS_TAGGED_X_CHECK' => 'Žádné videoklipy nejsou označené popiskem "%1$s". Prohlédněte si diskuse (<a %2$s>) s označením "%1$s"</a>, blogové příspěvky (<a %4$s>) s označením "%1$s"</a> nebo snímky (<a %3$s>) s označením "%1$s"</a>. Nebo přidejte vlastní videoklipy a doplňte k nim popisky.',
        'FILES_MUST_BE_100MB' => 'Soubory mohou být velké max. 100 MB.  Podporujeme soubory ve formátech . mov, . mpg, . avi, . 3gp a . wmv.',
        'NEED_HELP' => 'Potřebujete pomoci?',
        'HERE_ARE_INSTRUCTIONS' => 'Zde jsou pokyny pro videoklipy z <a %s>YouTube</a> a <a %s>Google Video</a>.',
        'PERSON_IN_CHARGE' => 'Moderátor skupiny %s by rád váš výtvor před zveřejněním viděl.',
        'LEAVE_WINDOW_OPEN' => 'Probíhá upload - než skončí, nechte toto okno otevřené.',
        'KEEP_PAGE_OPEN' => 'Tuto stránku nechte otevřenou, než bude videoklip přenesen. Dáme vám vědět, až bude schválen.',
        'MEANWHILE_FEEL_FREE' => 'Mezitím si můžete <a %s>otevřít nové okno prohlížeče</a> a dále pracovat s komunitou %s.  Jakmile bude přenos dokončen, budete v tomto okně moci k videoklipu přidat název a popis.',
        'VIDEO_IS_WAITING_FOR_APPROVAL' => 'Tento videoklip <strong>čeká na schválení</strong> zakladatelem komunity %s.',
        'LOADING' => 'Načítání…',
        'EDIT_VIDEO' => 'Upravit videoklip',
        'DELETE_VIDEO' => 'Odstranit videoklip',
        'YOU_NEED_TO_BE_MEMBER' => 'Chcete-li přidat komentář, musíte být členem komunity %s!',
        'SIGN_UP_OR_SIGN_IN' => '<a %s>Staňte se členem této komunity</a>',
        'ADD_A_COMMENT' => 'Přidat komentář',
        'LEAVE_A_COMMENT_FOR_USERNAME' => 'Zanechat komentář pro: %s',
        'MORE' => 'Podrobnosti',
        'PREVIOUS' => 'Předcházející',
        'NEXT' => 'Další',
        'ABOUT_THIS_VIDEO' => 'O tomto videoklipu...',
        'ABOUT_YOUR_VIDEO' => 'O tomto videoklipu...',
        'ADDED_ON_DATE_BY' => 'Přidáno: <strong>%s</strong>. Přidal(a):',
        'VIEWS' => 'Prohlédnutí:',
        'COMMENTS' => 'Komentář',
        'COMMENTS_COLON' => 'Komentář:',
        'LOCATION_OF_VIDEO' => 'Místo pořízení videoklipu:',
        'RELATED_VIDEOS' => 'Související videoklipy',
        'ALL_VIDEOS_TAGGED_X_X' => 'Všechny videoklipy označené popiskem %s (%s)',
        'XS_VIDEOS_X' => 'Videoklipy, které přidal(a) %s (%s)',
        'XS_FAVORITES_X' => 'Oblíbené člena: %s (%s)',
        'VIDEO_DETAILS' => 'Podrobnosti o videoklipu',
        'UPLOAD_VIDEOS_FROM' => 'Uploadujte videoklipy z počítače',
        'NEITHER_FILE_NOR_EMBED_CODE' => 'Nebyl zadán soubor ani vložený kód.',
        'VIDEO_UPLOADED_ON_X' => 'Videoklip byl odeslán na %s',
        'PROBLEM_OCCURRED_CONVERTING_VIDEO' => 'Při převodu videoklipu do formátu Flash došlo k problému: %s',
        'STATUS_N' => 'Stav - %s',
        'YOUR_VIDEO_TITLED_X_COULD_NOT' => 'Váš videoklip s názvem "%s" nelze přidat na %s',
        'YOUR_VIDEO_COULD_NOT_BE_ADDED' => 'Váš videoklip nelze přidat na %s',
        'YOUR_VIDEO_UPLOAD_TO_X_DID_NOT_COMPLETE_DUE_TO_A_CONVERSION_ERROR' => 'Upload videoklipů na %s nebyl dokončen kvůli chybě při konverzi.',
        'YOU_JUST_TRIED_TO_SEND_VIDEO' => 'Právě jste se pokusili odeslat videoklip do: %s.  Bohužel nejste členem %s, takže videoklip nelze doručit na místo určení.',
        'VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'Upload videoklipů na: %s nebyl dokončen.',
        'FOR_FURTHER_ASSISTANCE_2' => 'Pokud potřebujete pomoci, kontaktujte nás prosím:',
        'TO_HELP_TROUBLESHOOT_PROVIDE_THIS_VIDEO_ID_X' => 'Ke snazšímu vyřešení uveďte tento identifikátor videoklipu: %s',
        'YOUR_VIDEO_WAS_SUCCESSFULLY_UPLOADED_TO_X' => 'Videoklip byl úspěšně uploadován na: %s.',
        'YOUR_VIDEO_UPLOAD_DID_NOT_COMPLETE' => 'Upload vašeho videoklipu na: %s nebyl dokončen.',
        'YOUR_VIDEO_ENCOUNTERED_A_PROBLEM' => 'Při přenosu videoklipu na: %s došlo k problému.',
        'THE_PROBLEM_WAS_X' => 'Popis problému: %s',
        'ID' => 'ID:',
        'VIDEO_TRANSCODING_FAILED_FOR_X' => 'Překódování videoklipu %s v: %s se nezdařilo.',
        'X_UPLOADED_A_VIDEO_THAT_FAILED' => '%s přidal(a) videoklip, u nějž se nezdařilo překódování.',
        'ERROR_MESSAGE' => 'Chybová zpráva:',
        'APPLICATION_NAME' => 'Název aplikace:',
        'APPLICATION_ID' => 'ID aplikace:',
        'VIDEO_ID' => 'ID videoklipu:',
        'TO_VIEW_THE_VIDEO_VISIT' => 'Videoklip si můžete prohlédnout na adrese:',
        'VIDEO_UPLOAD_COMPLETE_ON_X' => 'Upload videoklipů na: %s byl dokončen.',
        'YOUR_VIDEO_UPLOAD_COMPLETE_ON_X' => 'Upload vašeho videoklipu na: %s byl dokončen.',
        'YOUR_VIDEO_WAS_UPLOADED' => 'Videoklip byl úspěšně přidán do: %s.',
        'THAT_VIDEO_IS_AWAITING_APPROVAL' => 'Tento videoklip čeká na schválení.',
        'THIS_VIDEO_IS_BEING_PROCESSED' => 'Tento videoklip je stále zpracováván.',
        'ADD_VIDEO' => 'Přidat videoklip',
        'VIDEO_BY_X' => 'Videoklip, přidal(a) %s',
        'YOUR_VIDEO_X_ON_Y_HAS_A_NEW_COMMENT' => 'Váš videoklip "%1$s" na: %2$s obdržel nový komentář.',
        'YOUR_VIDEO_ON_X_HAS_A_NEW_COMMENT' => 'Váš videoklip na %s obdržel nový komentář.',
        'THERE_IS_NEW_COMMENT_ON_VIDEO_X' => 'U vašeho videoklipu "%s" na %s je nový komentář.',
        'THERE_IS_NEW_COMMENT_ON_VIDEO' => 'U jednoho z vašich videoklipů na %s je nový komentář.',
        'SOMEBODY_COMMENTED_VIDEO_ADDED_TO_X' => 'Uživatel přidal(a) komentář k videoklipu, který jste přidali na: %s',
        'SOMEBODY_UPLOADED_VIDEO_TO_X' => 'Uživatel přidal videoklip do: %s',
        'MORE_WAYS_TO_ADD_VIDEOS' => 'Další způsoby, jak přidat videoklip…',
        'FROM_YOUTUBE_OR_GOOGLE' => '…z YouTube nebo Google',
        'GRAB_THE_HTML_EMBED_CODE' => 'Extrahujte vložený HTML kód z jakéhokoli populárního serveru s videoklipy a přidejte videoklip do této komunity.',
        'ADD_A_VIDEO_FROM_YOUTUBE' => 'Přidat videoklip z YouTube nebo Google',
        'PASTE_IN_EMBED' => 'Vložte ”embed” kód videoklipu sem:',
        'ADD_VIDEOS_BY_PHONE_OR_EMAIL' => 'Přidat videoklip po telefonu nebo emailem',
        'ADD_VIDEOS_BY_PHONE_OR' => 'Přidejte videoklipy po telefonu nebo emailem',
        'VIDEO' => 'videoklip',
        'THERE_ARE_NO_VIDEOS_THAT_MATCH' => 'Zvoleným parametrům neodpovídají žádné videoklipy.',
        'CLICK_EDIT_AND_CHANGE_SETTINGS' => 'Pokud se má tento dialog zobrazit i jiným osobám, klepněte na volbu Upravit a změňte nastavení.',
        'PLAY_AGAIN' => 'Přehrát znovu',
        'SHARE' => 'Sdílet',
        'EMBED' => 'Zasadit',
        'REWIND' => 'Převinout zpět',
        'CHANGE_SIZE' => 'Změnit velikost',
        'FULLSCREEN' => 'Celá obrazovka',
        'EXIT_FULLSCREEN' => 'Ukončit režim celé obrazovky',
        'HIDE' => 'Zavřít',
        'COPY_AND_PASTE_LINK' => 'Tento odkaz zkopírujte a vložte do emailu nebo okna messagingového programu:',
        'FIND_MORE_VIDEOS_LIKE_THIS' => 'Vyhledat další podobné videoklipy na <em>%s</em>',
        'SEE_VIDEO_ON_NETWORK' => 'Přehrát tento videoklip na: %s',
        'GET_EMBED_CODE' => 'Zajistit vložený kód HTML:',
        'FEATURING_ELLIPSIS' => 'Představování položky jako Zajímavé',
        'NOW_FEATURED_ON_MAIN' => 'Položka je představena jako Zajímavá na hlavní stránce',
        'DONT_FEATURE' => 'Nepředstavovat jako Zajímavé',
        'UNFEATURING_ELLIPSIS' => 'Odebírání z hlavní stránky...',
        'REMOVED_FROM_MAIN' => 'Odebráno z hlavní stránky',
        'ADDED_EXCLAMATION' => 'Přidáno!',
        'ERROR' => 'Chyba',
        'ADDING_ELLIPSIS' => 'Přidávání...',
        'TRACK_COULD_NOT_BE_LOADED' => 'Skladbu nelze načíst',
        'INVALID_URL' => 'Neplatná adresa URL:',
        'NORMAL_PLAYBACK_ON' => 'Normální přehrávání: zapnuto',
        'REPEAT_PLAYBACK_ON' => 'Opakovat přehrávání: zapnuto',
        'SHUFFLE_PLAYBACK_ON' => 'Náhodné přehrávání: zapnuto',
        'OPEN_POPUP_WINDOW' => 'Otevřené vyskakovací okno',
        'LOADING_PLAYLIST_ELLIPSIS' => 'Načítání playlistu...',
        'EACH_PHOTO_MAY_BE_UP_TO_10MB' => 'Každý snímek může mít velikost až 10 MB. Podporujeme snímky ve formátech .jpg, .gif a .png.',
        'I_HAVE_RIGHT_TO_UPLOAD_PHOTOS' => 'Tyto snímky mám právo uploadovat v souladu s <a %s>Podmínkami služby</a>.',
        'PHOTO_UPLOADER_REQUIRES_JAVA' => 'Hromadný upload snímků vyžaduje novější verzi Javy. <strong><a %s>Klepněte sem, chcete-li si Javu stáhnout,</a></strong> nebo <strong><a %s> se vraťte k uploadu jednotlivých souborů</a></strong>.',
        'TRY_BULK_PHOTO_UPLOADER' => 'Zkuste hromadný upload snímků',
        'HAVE_LOT_OF_PHOTOS' => 'Chcete se podělit o spoustu snímků?',
        'PHOTOS_SUCCESSFULLY_UPLOADED' => 'Snímky byly úspěšně odeslány.',
        'PHOTOS_UPLOADED_AWAITING' => 'Snímky byly úspěšně odeslány a čekají na schválení zakladatelem skupiny/komunity %s.',
        'FLICKR' => 'Flickr',
        'ADD_PHOTOS_FROM_FLICKR' => 'Přidejte snímky z Flickru',
        'ADD_PHOTOS_OR_VIDEOS_TO_APPNAME' => 'Přidejte snímky nebo videoklipy na %s přímo po telefonu nebo zasláním emailem na speciální adresu.',
        'HAVING_PROBLEMS_WITH_PHOTO_UPLOADER' => 'Máte problém s hromadným uploadem snímků? <strong><a %s>Vraťte se k uploadu jednotlivých souborů</a></strong>.',
        'MORE_PHOTOS' => 'Další snímky',
        'THIS_ALBUM' => 'Toto album',
        'NETWORK_DOES_NOT_HAVE_PHOTOS' => 'Tato komunita nemá zatím uloženy žádné snímky.',
        'PERSON_DOES_NOT_HAVE_PHOTOS' => 'Tato osoba nemá zatím uloženy žádné snímky.',
        'ALBUM_DOES_NOT_HAVE_PHOTOS' => 'Toto album neobsahuje zatím žádné snímky.',
        'FIND_MORE_PHOTOS_LIKE_THIS' => 'Vyhledat další podobné snímky na: <em>%s</em>',
        'NO_PHOTOS_AVAILABLE' => 'V albu nejsou k dispozici žádné snímky.  <a %s>Klepněte sem, chcete-li zobrazit všechna alba</a>.',
        'ALBUM_PHOTOS_NOT_VISIBLE_TO_OTHERS' => 'Toto album není viditelné pro jiné osoby v komunitě; snímky jsou dostupné pouze vám nebo zatím nejsou schváleny.',
        'CUSTOMIZE_YOUR_SLIDESHOW_PLAYER' => 'Upravte si přehrávač prezentací na míru!',
        'ADD_SLIDESHOW_LOGO' => 'Doplňte logo k prezentaci vaší komunity.  <a %s>Udělejte to hned! </a>',
        'PHOTO_BY_X' => 'Snímek poskytl(a) %s',
        'UPLOAD_PHOTOS' => 'Uploadovat snímky',
        'PLAYER_COLOR' => 'Barva přehrávače',
        'SLIDESHOW_PLAYER' => 'přehrávač prezentací',
        'SLIDESHOW' => 'prezentace',
        'FILTER' => 'Filtr',
        'SAVE_ALBUM' => 'Uložit album',
        'APPLY_THIS_INFO_TO_PHOTOS' => 'Použít tyto informace u následujících snímků',
        'CLICK_TO_ADD_A_DESCRIPTION' => 'klepnutím přidáte popis',
        'CHECK' => 'Kontrola',
        'YOU_NEED_TO_BE_X' => 'K této operaci musíte být %s.',
        'ALL_PHOTOS' => 'Všechny snímky',
        'POPULAR_PHOTOS' => 'Populární snímky',
        'FEATURED_PHOTOS' => 'Zajímavé snímky',
        'PHOTOS_HOME' => 'Hlavní nabídka - snímky',
        'ALL_ALBUMS' => 'Všechna alba',
        'MY_PHOTOS' => 'Moje snímky',
        'MY_ALBUMS' => 'Moje alba',
        'ADD_PHOTOS' => 'Přidat snímky',
        'ADD_PHOTOS_SENTENCE_CASE' => 'Přidat snímky',
        'EDIT' => 'Edit',
        'CHOOSE_PHOTOS' => 'Zvolte snímky',
        'ADD_PHOTOS_BY_DRAGGING' => '<strong>Přidejte snímky přetažením myší </strong>do alba napravo.  Chcete-li je odebrat, přetáhněte je myší zpět.',
        'TITLE_YOUR_ALBUM' => '<strong>Pojmenujte album. </strong>Přidejte obal a popis',
        'SAVE_YOUR_ALBUM' => 'Album uložte!',
        'CHOOSE_FROM' => 'Vyberte si z různých zdrojů:',
        'EVERYONES_PHOTOS' => 'Snímky všech',
        'TAGGED' => 'Označené popiskem:',
        'OLDER_PHOTOS' => 'Starší snímky',
        'MORE_RECENT_PHOTOS' => 'Novější snímky',
        'YOUR_ALBUM' => 'Vaše album',
        'DRAG_ALBUM_COVER_HERE' => 'Přetáhněte obal alba sem',
        'ALBUM_TITLE' => 'Název alba:',
        'ALBUM' => 'album',
        'DRAG_PHOTOS_HERE' => 'Přetáhněte snímky sem',
        'PREVIOUS_ALBUM_PAGE' => 'Předcházející stránka alba',
        'NEXT_ALBUM_PAGE' => 'Další stránka alba',
        'ADDED_ON_DATE' => 'Přidáno: %s',
        'VIEW_AS_SLIDESHOW' => 'Zobrazit jako prezentaci',
        'VIEW_SLIDESHOW' => 'Zobrazit prezentaci',
        'CREATED_BY_ME' => 'Vytvořil: <a %s>já</a>',
        'CREATED_BY_X' => 'Vytvořil: %s',
        'OUR_APOLOGIES' => 'Omlouváme se',
        'ADD_PHOTOS_TO_ALBUM' => 'Přidejte další snímky do alba ze zdrojů uvedených dole.',
        'YOU_CAN_ADD_PHOTOS' => 'Do tohoto alba můžete <a %s>přidat snímky hned</a>.',
        'SITE_IS_GETTING_STARTED' => 'Tato komunita právě zahajuje provoz!',
        'NO_ONE_CREATED_ALBUMS' => 'Žádné album zřejmě ještě nikdo nevytvořil.  Můžete ale <a %s>vytvořit album teď</a>.',
        'EDIT_YOUR_ALBUM' => 'Upravit album',
        'ALBUMS_WITH_THIS_PHOTO' => 'Všechna alba obsahující tento snímek',
        'ALBUMS_WITH_X' => 'Všechna alba obsahující %s',
        'ALBUMS_WITH_X_2' => 'Všechna alba obsahující <em>%s</em>',
        'NO_ALBUMS_CONTAINING_PHOTO' => 'Tento snímek žádná alba neobsahují.  Můžete ale <a %s>vytvořit nové album</a>.',
        'XS_ALBUMS' => 'Alba, jejichž majitelem je %s',
        'CREATE_AN_ALBUM' => 'Vytvořit album',
        'YOU_HAVE_NOT_CREATED_ALBUMS' => 'Zatím jste žádné album nevytvořili.  Můžete ale <a %s>vytvořit album teď</a>.',
        'X_HAS_NOT_CREATED_ALBUMS' => '%s zatím žádné album nevytvořil(a).',
        'MAKE_AN_ALBUM' => 'Vytvořit album',
        'ABOUT_THIS_ALBUM' => 'O tomto albu',
        'ABOUT_YOUR_ALBUM' => 'O vašem albu',
        'EDIT_ALBUM' => 'Upravit album',
        'DELETE_THIS_ALBUM' => 'Odstranit album?',
        'DELETE_ALBUM' => 'Odstranit album',
        'START_SLIDESHOW' => 'Spustit prezentaci',
        'ALBUM_IS_NOW_EMPTY' => 'Album je prázdné.',
        'YOU_ARE_GETTING_STARTED' => 'Jste teprve na začátku!',
        'YOU_HAVE_NOT_ADDED_PHOTOS' => 'Ještě jste žádné snímky nepřidali!',
        'ADD_PHOTOS_AND_SHARE' => 'Přidejte snímky a podělte se o ně přáteli, rodinou nebo celým světem!',
        'ADD_A_PHOTO' => 'Přidat snímek',
        'NO_PHOTOS_ON_SITE' => 'Ve vaší komunitě v současné době nejsou žádné snímky.',
        'BOX_WILL_NOT_SHOW_PHOTOS' => 'Tento rámeček se jiným osobám nezobrazí, dokud nebudou k dispozici nějaké snímky.  Co kdybyste nějaký přidali?',
        'VIEW_EMBED_CODE' => 'Zobrazit vložený kód HTML',
        'VIEW_PHOTOS' => 'Zobrazit snímky',
        'ADD_YOUR_FIRST_PHOTOS' => 'Přidat první snímky',
        'YOU_CAN_ADD_YOUR_OWN_PHOTOS' => 'Na stránky %2$s můžete <a %1$s>přidat vlastní snímky</a>!',
        'UPLOAD_PHOTOS_FROM' => 'Uploadujte snímky z počítače:',
        'ADD_TITLE_AND_DESCRIPTION_FOR_PHOTOS' => 'Přidejte název a popis snímků',
        'EDIT_PHOTO_INFORMATION' => 'Upravit informace o snímcích',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_1' => 'Přidejte název, popis a další informace o nově přidaných snímcích.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_PHOTO_2' => 'Přidejte název, popis a další informace o tomto snímku.',
        'CANCEL_AND_RETURN_TO_PHOTO' => 'Zrušit a vrátit se ke snímku',
        'WHO_CAN_VIEW_PHOTO' => 'Kdo si tento snímek smí prohlédnout?',
        'CAN_BE_VIEWED_BY' => 'Smí si ho prohlížet:',
        'BY_ME' => '<a %s>Já</a>',
        'RSS_FEED_LABEL' => '<a %s>Kanál RSS </a> - %s',
        'NO_PHOTOS_AWAITING_APPROVAL' => 'Žádné snímky nečekají na schválení.  Pokud hledáte nějakou zajímavou činnost, co se takhle podívat na <a %s>nejnovější snímky</a>?',
        'APPROVE_ALL_PHOTOS' => 'Schválit všechny snímky?',
        'ARE_YOU_SURE_APPROVE_ALL_PHOTOS' => 'Opravdu chcete schválit všechny snímky?  Operace může trvat několik minut.',
        'DELETE_ALL_PHOTOS' => 'Odstranit všechny snímky?',
        'ARE_YOU_SURE_DELETE_ALL_PHOTOS' => 'Opravdu chcete odstranit všechny neschválené snímky?  Operace může trvat několik minut.',
        'KEEP_WINDOW_OPEN_PHOTOS_APPROVED' => 'Schvalování snímků - nechte toto okno prohlížeče otevřené.  Operace může trvat několik minut.',
        'KEEP_WINDOW_OPEN_PHOTOS_DELETED' => 'Odstraňování snímků - nechte toto okno prohlížeče otevřené.  Operace může trvat několik minut.',
        'APPLY_TO_PHOTOS_ADDED_BY' => 'Použít u všech snímků, které přidal(a) %s',
        'NO_ONE_HAS_ADDED_ANY_PHOTOS' => 'Ve vaší komunitě nikdo nepřidal snímky.  Buďte první!<a %s> </a>',
        'UNTITLED' => 'Bez názvu',
        'A_PROBLEM_OCCURRED' => 'Došlo k problému.',
        'PHOTOS_EXCEEDED_LIMIT' => 'Snímky zřejmě překročily limit 10 MB na snímek.',
        'GET_A_SLIDESHOW_OF' => 'Zajistěte si prezentaci pomocí: %s',
        'GET_A_SLIDESHOW' => 'Vytvořte si prezentaci!',
        'GET_SLIDESHOW_OF_PHOTOS' => 'Vytvořte si prezentaci z těchto snímků',
        'COPY_AND_PASTE_SLIDESHOW' => 'Zkopírujte a vložte dole uvedený kód a umístěte tak prezentace z těchto snímků na vaše webové stránky, stránku MySpace nebo do jiných komunit serveru Ning.',
        'COPY_AND_PASTE_SLIDESHOW_OF_ALBUM' => 'Zkopírujte a vložte dole uvedený kód a umístěte tak prezentaci z tohoto alba na vaše webové stránky, stránku MySpace nebo do jiných komunit serveru Ning.',
        'LARGE_VERSION' => 'Velká verze',
        'SMALL_VERSION' => 'Malá verze',
        'VIEW_SLIDESHOW_FULL_SIZE' => 'Zobrazit prezentaci v plné velikosti',
        'PHOTOS' => 'Snímky',
        'XS_PHOTOS' => 'Snímky, jejichž majitelem je %s',
        'XS_PHOTO' => 'Snímek osoby: %s',
        'YOU_CAN_MARK_PHOTO' => 'Jakýkoli snímek si můžete označit jako oblíbený.  Stačí klepnout na ikonu "Přidat k oblíbeným", jakmile se u snímku objeví.',
        'VIEW_RECENT_PHOTOS' => 'Zobrazit novější snímky',
        'APPROVE_PHOTOS' => 'Schválit snímky',
        'DELETE_ALL_XS_PHOTOS_Q' => 'Odstranit všechny snímky, jejichž majitelem je %s?',
        'ARE_YOU_SURE_DELETE_ALL_XS_PHOTOS' => 'Opravdu chcete odstranit všechny snímky, které přidal(a) %s?  Operace může trvat několik minut.',
        'REMOVE_X_AND_ALL_CONTENT' => 'Odebrat člena %1$s a všechny materiály, které %1$s přidal, z komunity',
        'SUCCESS' => 'Operace se zdařila.',
        'DELETING_CONTENT' => 'Odstraňování materiálu…',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED' => 'Odstraňování materiálu - nechte prosím toto okno prohlížeče otevřené.  Operace může trvat několik minut.',
        'KEEP_WINDOW_OPEN_MEMBERS_DELETED' => 'Odstraňování členů - nechte prosím toto okno prohlížeče otevřené.  Operace může trvat několik minut.',
        'DELETE_ALL_XS_PHOTOS' => 'Odstranit všechny snímky, jejichž majitelem je %s?',
        'CREATE_A_NEW_ALBUM' => 'Vytvořit nové album',
        'VIEW_ALL_XS_ALBUMS' => 'Zobrazit všechna Alba člena: %s',
        'YOU_HAVE_NOT_ADDED_PHOTOS_2' => 'Ještě jste žádné snímky nepřidali.  Přidejte nějaké snímky do začátku.',
        'X_HAS_NOT_ADDED_PHOTOS' => '%s zatím žádné snímky ne přidal(a).',
        'MY_FRIENDS_PHOTOS' => 'Snímky mých přátel',
        'VIEW_PHOTOS_IN_SLIDESHOW' => 'Zobrazit tyto snímky jako prezentaci!',
        'YOUR_FRIENDS_DO_NOT_HAVE_PHOTOS' => 'Vaši přátelé zatím nemají žádné snímky',
        'ALL_PHOTOS_TAGGED_X' => 'Všechny snímky označené popiskem %s',
        'ALL_PHOTOS_TAGGED_X_2' => 'Všechny snímky označené popiskem <em>%s</em>',
        'NO_PHOTOS_TAGGED_X_CHECK' => 'Žádné snímky nejsou označené popiskem "%1$s". Prohlédněte si diskuse (<a %2$s>) s označením "%1$s"</a>, blogové příspěvky (<a %4$s>) s označením "%1$s"</a> nebo videoklipy (<a %3$s>) s označením "%1$s"</a>. Nebo přidejte vlastní snímky a doplňte k nim popisky.',
        'SELECT_YOUR_PHOTOS' => 'Vyberte snímky',
        'PHOTO_MAY_BE_10MB' => 'Každý snímek může mít velikost až 10 MB, ale menší snímky budou přeneseny rychleji. Podporujeme snímky ve formátech .jpg, .gif a .png.',
        'KEEP_PAGE_OPEN_PHOTOS' => 'Tuto stránku nechte prosím otevřenou, než budou snímky přeneseny. Dáme potom vědět, až budou schváleny.',
        'MEANWHILE_FEEL_FREE_PHOTOS' => 'Mezitím si můžete <a %s>otevřít nové okno prohlížeče</a> a dále pracovat s komunitou %s.  Jakmile bude přenos dokončen, budete v tomto okně moci ke snímkům přidat název a popis.',
        'PHOTO_IS_WAITING_FOR_APPROVAL' => 'Tento snímek <strong>čeká na schválení</strong> zakladatelem komunity %s.',
        'ADD_TO_FAVORITES' => 'Přidat k oblíbeným',
        'EDIT_PHOTO' => 'Upravit snímek',
        'DELETE_PHOTO' => 'Odstranit snímek',
        'ABOUT_THIS_PHOTO' => 'O tomto snímku',
        'LOCATION_OF_PHOTO' => 'Místo pořízení snímku:',
        'ALBUMS_FEATURING_PHOTO' => 'Alba obsahující tento snímek',
        'VIEW_ALBUMS_WITH_PHOTO' => 'Zobrazit všechna alba obsahující tento snímek',
        'RETURN_TO_X' => 'Návrat do: %s',
        'RETURN_TO_PHOTOS_HOME' => 'Vrátit se do hlavní nabídky snímků',
        'WE_COULD_NOT_FIND_ANYONE' => 'Omlouváme se - nikoho se nepodařilo najít',
        'NOBODY_HAS_ADDED_PHOTOS' => 'Nikdo zatím nepřidal žádné snímky!  Přidejte nějaké snímky do začátku.',
        'DEFAULT_TITLE' => 'Název',
        'DEFAULT_DESCRIPTION' => 'Popis',
        'UPLOAD_LIMIT_EXCEEDED' => 'Limit velikosti pro odesílané soubory byl překročen.',
        'SLOW_DOWN_THERE_CHIEF' => 'Omlouváme se',
        'I_DO_NOT_KNOW_USER' => 'Bohužel, tuto osobu neznám.',
        'I_DO_NOT_HAVE_PHOTO' => 'Bohužel, tento snímek nemám.',
        'I_DO_NOT_HAVE_ALBUM' => 'Bohužel, toto album nemám.',
        'ALBUM_BY_X_ON_X' => 'Album připravil(a) %s a je na: %s',
        'SENT' => 'Odesláno!',
        'I_HAVE_RECENTLY_ADDED' => 'Moje - nedávno přidané',
        'FROM_THE_BAZEL' => 'Z této komunity',
        'RECENTLY_ADDED' => 'Nedávno přidané',
        'RECENT_PUBLIC_PHOTOS_ON_X' => 'Nejnovější veřejné snímky na: %s',
        'X_ALL_PHOTOS' => '%s - všechny snímky',
        'NO_TAG_WAS_SPECIFIED' => 'Žádný popisek nebyl zadán',
        'PUBLIC_PHOTOS_TAGGED_WITH_X' => 'Veřejné snímky označené popiskem: s %s na: %s',
        'XS_PUBLIC_PHOTOS_ON_X' => 'Veřejné snímky uživatele: %s',
        'WE_DO_NOT_KNOW_USER' => 'Bohužel, tuto osobu neznáme.',
        'XS_FRIENDS_PHOTOS' => 'Snímky přátel uživatele %s',
        'XS_FAVORITE_PHOTOS_ON_X' => 'Oblíbené snímky uživatele %s na: %s',
        'PHOTO_UPLOADED_ON_X' => 'Snímky byly odeslány na %s',
        'FILE_EXCEEDED_MAXIMUM_SIZE' => 'Velikost souboru překročila limit',
        'PART_OF_FILE_WAS_UPLOADED' => 'Pouze část souboru byla odeslána',
        'NO_FILE_WAS_UPLOADED' => 'Odeslání se nezdařilo;  název souboru může být nesprávný',
        'PROBLEM_OCCURRED_DURING_UPLOAD' => 'Během odesílání došlo k chybě.',
        'ALPHABETICAL' => 'Abecedně',
        'MOST_VIEWS' => 'Většina prohlédnutí',
        'RATING_NOT_RATED_YET' => '<strong>Hodnocení:</strong> Zatím nehodnoceno',
        'NOT_RATED_YET' => 'Zatím nehodnoceno',
        'HMM_SOMETHING_WENT_AWRY' => 'Hmm… něco se nepovedlo.',
        'YOUR_PHOTO_TITLED_X_COULD_NOT' => 'Snímek s názvem "%s" nelze přidat do: %s',
        'YOUR_PHOTO_COULD_NOT_BE_ADDED' => 'Váš snímek nelze přidat do: %s',
        'YOU_JUST_TRIED_TO_SEND' => 'Právě jste se pokusili odeslat snímek do: %s.  Bohužel nejste členem %s, takže snímek nelze doručit na místo určení.',
        'ONLY_MY_FRIENDS' => 'Pouze moji přátelé',
        'ANYBODY' => 'Kdokoli',
        'ONLY_MY_FRIENDS_CAN_SEE_PHOTO' => 'Tento snímek smějí vidět pouze moji přátelé',
        'ONLY_XS_FRIENDS_CAN_SEE_PHOTO' => 'Tento snímek smějí vidět pouze přátelé uživatele: %s',
        'ONLY_I_CAN_SEE_PHOTO' => 'Tento snímek smím vidět pouze já',
        'ONLY_X_CAN_SEE_PHOTO' => 'Tento snímek smí vidět pouze %s',
        'EVERYONE_CAN_SEE_PHOTO' => 'Tento snímek smí vidět každý',
        'PRIVATE_PHOTO' => '<strong>Soukromý</strong> snímek',
        'HOWDY_STRANGER' => 'Vítáme vás, neznámý!',
        'YOU_NEED_TO_BE_SIGNED_IN' => 'Než smíte tuto operaci provést, budete se muset přihlásit ke službě Ning.',
        'JUST_CLICK_ON_SIGN_IN' => 'Jen klepněte na volbu "Přihlásit se" nahoře, nebo, pokud zatím nemáte u Ningu účet, klepněte na "Zaregistrovat se".',
        'YOU_NEED_TO_BE_' => 'K této operaci musíte být %s.',
        'YOU_NEED_TO_BE_OWNER' => 'K této operaci musíte být zakladatel komunity.',
        'THAT_PHOTO_IS_AWAITING_APPROVAL' => 'Tento snímek čeká na schválení.',
        'YOU_NEED_TO_BE_A_FRIEND' => 'K této operaci musíte být přítel uživatele %s.',
        'MOST_ACTIVE' => 'Nejaktivnější',
        'HOW_IT_WORKS' => 'Jak to funguje',
        'MORE_WAYS_TO_ADD_PHOTOS' => 'Další způsoby, jak přidat snímky…',
        'BY_PHONE_OR_EMAIL' => '…po telefonu nebo emailem',
        'FROM_FLICKR' => '…z Flickru',
        'FROM_YOUR_COMPUTER' => '…z počítače',
        'ADD_PHOTOS_FROM_YOUR_FLICKR' => 'Přidejte snímky ze svého účtu na Flickru.',
        'MORE_INFORMATION' => 'Další informace',
        'ADD_PHOTOS_BY_PHONE_OR_EMAIL' => 'Přidejte snímky po telefonu nebo emailem',
        'SEND_ONE_PHOTO_OR_VIDEO' => 'Zasílejte jeden snímek nebo videoklip na emailovou zprávu.  Předmět emailu bude použit jako název snímku nebo videoklipu, a text zprávy jako jeho popis.',
        'CLICK_HERE_TO_GET_A_NEW_UNIQUE' => 'Klepnutím sem získáte novou emailovou adresu',
        'UPLOAD_PHOTOS_FROM_YOUR_COMPUTER' => 'Uploadujte snímky z počítače',
        'UPLOAD_PHOTOS_FROM_YOUR' => 'Uploadujte snímky z počítače:',
        'PHOTO' => 'snímek',
        'YOUVE_SET_THE_NUMBER_OF_PHOTOS' => 'V současné době nemáte zveřejněny žádné snímky.',
        'BOX_WILL_NOT_SHOW_UNTIL_SELECT_PHOTO' => 'Tento rámeček se jiným osobám nezobrazí, dokud nevyberete aspoň jeden snímek.',
        'YOUR_PHOTO_X_HAS_A_NEW_COMMENT_ON_Y' => 'Váš snímek "%1$s" obdržel na: %2$s nový komentář.',
        'YOUR_PHOTO_HAS_A_NEW_COMMENT_ON_X' => 'Váš snímek  obdržel na %s nový komentář.',
        'THERE_IS_NEW_COMMENT_ON_PHOTO_X' => 'U vašeho snímku "%s" na %s je nový komentář.',
        'THERE_IS_NEW_COMMENT_ON_PHOTO' => 'U jednoho z vašich snímků na %s je nový komentář.',
        'SOMEBODY_COMMENTED_PHOTO_ADDED_TO_X' => 'Uživatel přidal(a) komentář k snímku, který jste přidali na: %s',
        'SOMEBODY_UPLOADED_PHOTO_TO_X' => 'Uživatel přidal snímek do: %s',
        'ADD_PHOTOS_OR_VIDEOS_TO_X' => 'Přidejte snímky nebo videoklipy na %s přímo po telefonu nebo zasláním emailem.',
        'DO_YOU_REALLY_WANT_TO_REMOVE' => 'Opravdu chcete tuto položku odebrat z oblíbených?',
        'DELETE_THIS_PHOTO_Q' => 'Odstranit tento snímek?',
        'ARE_YOU_SURE_DELETE_THIS_PHOTO' => 'Opravdu chcete tento snímek odstranit?  Operace může trvat několik minut.',
        'PHOTO_SLIDESHOW' => 'Prezentace',
        'THUMBNAILS' => 'Náhledy',
        'DETAIL' => 'Detail',
        'TAG' => 'Popisek',
        'RATE' => 'Hodnocení',
        'ALL_SIZES' => 'Všechny velikosti',
        'ADD_TO_ALBUM' => 'Přidat do alba',
        'ROTATE_PHOTO' => 'Otočit snímek',
        'ABOUT_YOUR_PHOTO' => 'O vašem snímku',
        'SEE_PHOTOS_ON_NETWORK' => 'Prohlédněte si tyto snímky na: %s',
        'EMBED_CODE' => 'Vložený kód',
        'IMPORT_PHOTOS_FLICKR' => 'Přidejte snímky z Flickru',
        'CLICK_HERE_TO_CONTINUE_TO_FLICKR' => 'Klepněte sem, chcete-li přejít na Flickr',
        'TO_GET_YOUR_PHOTOS_FROM_FLICKR' => 'Chcete-li přenést snímky z Flickru, nejprve musíte povolit propojení %S k vašemu účtu na Flickru.',
        'IMPORT_PHOTOS' => 'Importovat snímky',
        'GET_MY' => 'Zajistit mé',
        'GET_PHOTOS' => 'Zajistit snímky',
        'MOST_RECENT_PHOTOS' => 'nejnovější snímky',
        'GET_ALL_MY_FLICKR' => 'Přenést všechny moje snímky z Flickru (operace může trvat delší dobu)',
        'GET_ALL_MY_TAGGED' => 'Označit všechny snímky popiskem',
        'GET_PHOTOS_FROM_SET' => 'Přenést snímky z kolekce:',
        'GET_STARTED_BY_IMPORT' => 'My automaticky zajistíme vaše názvy, popisky a případné zeměpisné informace. <br/>Jak dlouho to bude trvat? </p> <p><ul style="padding-top:10px; "><li>10 snímků: <em>méně než 30 s</em>. </li><li>50 snímků: <em>asi 2 minuty</em>. </li><li>200 snímků: <em>asi 6 minut</em>. </li><li>500 snímků: <em>asi 15 minut</em>. </li></ul>',
        'IF_YOURE_NOT_SIGNED_IN' => 'Pokud nejste přihlášeni na Flickru, budete vyzváni k přihlášení.  Po přihlášení klepněte na tlačítko s popisem "OK, I_ allow it".',
        'GET_MY_FLICKR_PHOTOS_DESCRIPTIONS' => 'Přenést i popisy (tím se zdvojnásobí doba operace).',
        'PLEASE_KEEP_THIS_PAGE_OPEN_WHILE_IMPORT' => 'Tuto stránku nechte prosím otevřenou, než budou snímky importovány.',
        'GET_MY_FLICKR_PHOTOS_ORIGINALS' => 'Přenést snímky v plné velikosti (tím se výrazně prodlouží importování; nedoporučujeme použít u více než 20 snímků).',
        'MAKE_YOUR_X_PAGE_YOUR_OWN' => 'Klepněte na volbu "Upravit", chcete-li do tohoto rámečku přidat text, videoklipy, snímky nebo jakékoli miniaplikace.  I tak si můžete svou stránku na %s uzpůsobit podle svého.',
        'CLICK_EDIT_TO_ADD_TEXT' => 'Klepněte na volbu "Upravit", chcete-li do tohoto rámečku přidat text, videoklipy, snímky nebo jakékoli <a %1$s>miniaplikace jiných dodavatelů</a>.',
        'BOX_WILL_NOT_SHOW_UNTIL_UPDATE_CONTENT' => 'Tento rámeček se jiným osobám nezobrazí, dokud jeho obsah neupravíte.',
        'YOUR_X_BOX' => 'O rámečku komunity %s',
        'ABOUT_WIDGETS' => 'O miniaplikacích',
        'HELP' => 'Nápověda',
        'WIDGETS' => 'Miniaplikace',
        'LOOKING_TO_ADD_FUNCTIONALITY' => 'Hledáte nové funkce pro své stránky v komunitě?  Třeba by se vám hodil kalendář, místní předpověď počasí, odpočítávání dní do významné události nebo webová kamera?  S miniaplikacemi je přidání takových funkcí snadné - lze je vložit do každého textového rámečku ve vaší komunitě.',
        'GETTING_STARTED' => 'Začínáme',
        'BELOW_IS_LIST_OF_WIDGET' => 'Dále uvádíme <a %s>seznam poskytovatelů miniaplikací</a>, které vás mohou zajímat.  Do začátku jsme vám vybrali pár miniaplikací ze stránek <a %s>yourminis. com</a>.  Stačí nastavit některou z následujících miniaplikací, zkopírovat vložený kód vložit jej přímo do textového rámečku.  Tak do toho!',
        'CALENDAR' => 'Kalendář',
        'CALENDAR_WIDGET_ALLOWS_SEARCH' => 'Miniaplikace Kalendář nejenže zobrazuje datum, ale také s ní lze vyhledat a přidat do ní události ve formátu iCal (ten používá Google Calendar a mnoho dalších webových poskytovatelů této služby).',
        'USE_EDIT_WIDGET_BUTTON_CALENDAR' => 'Použijte tlačítko &#8220; Upravit miniaplikaci&#8221;   a klepněte na volbu &#8220; Vyhledat události&#8221; , poté zadejte hledaný výraz (zkuste dovolená, nějaký sportovní tým atd. ). Poté jen vyberte výsledek hledání a událost bude přidána do vašeho kalendáře.  Můžete také ručně zadat adresu libovolného zdroje událostí iCal.',
        'CUSTOMIZATION' => 'Individuální úpravy',
        'YOU_CAN_CUSTOMIZE_WIDGET' => 'Vzhled miniaplikace můžete upravit tím, že přes ni přejedete myší, a poté klepnete na ikonu vzorníku barev a změníte pozadí, styl a průhlednost miniaplikace.  Jakmile budete hotovi, klepněte na odkaz &#8220; Zkopírovat na web&#8221;   a potom na tlačítko &#8220; Zkopírovat vložený kód&#8221;  tlačítko.  Jakmile je kód zkopírován, vraťte se do libovolného textového rámečku v komunitě, zkopírujte do něj kód a uložte změny.  Hotovo!',
        'GET_MORE_WIDGETS_FROM_YOURMINIS' => 'Další miniaplikace ze stránek yourminis. com »',
        'WEATHER' => 'Počasí',
        'WEATHER_WIDGET_DISPLAYS' => 'Miniaplikace počasí zobrazuje místní předpověď počasí z kanálu Weather Channel.',
        'USE_EDIT_WIDGET_BUTTON_WEATHER' => 'Použijte tlačítko &#8220; Upravit miniaplikaci&#8221;  , vyberte své bydliště a nastavte správnou teplotní stupnici (Celsius).  Můžete si zobrazit počasí na aktuální den nebo pětidenní předpověď.',
        'COUNTDOWN' => 'Odpočítávání',
        'COUNTDOWN_WIDGET_LETS_YOU' => 'Miniaplikace Odpočítávání umožňuje odpočítávat čas do konkrétní události.  Klepnutím na tlačítko &#8220; Upravit miniaplikaci&#8221;   můžete zadat datum, čas a název nebo obrázek dané události.',
        'WEBCAM' => 'Webová kamera',
        'WEBCAM_WIDGET_ALLOWS_YOU' => 'Miniaplikace Webová kamera umožňuje aktivně monitorovat jakékoli veřejné webové kamery.  Použijte tlačítko &#8220; Upravit miniaplikaci&#8221;  vyberte ze seznamu webových kamer nebo ručně zadejte webovou adresu jiné.',
        'MORE_WIDGETS' => 'Další miniaplikace',
        'NEED_MORE_OPTIONS' => 'Potřebujete další možnosti?  Pokud vám předešlý výčet nestačí, doporučujeme porozhlédnout se po následujících webových stránkách:',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y_ELLIPSIS' => 'Nový (nová) %1$s čeká na vaše schválení na: %2$s...',
        'YOU_HAVE_A_NEW_X_TO_APPROVE_ON_Y' => 'Nový (nová) %1$s čeká na vaše schválení na: %2$s.',
        'YOU_HAVE_A_NEW_X_TITLE_TO_APPROVE_ON_Y' => 'Nový (nová) %1$s "%2$s" čeká na vaše schválení na: %3$s.',
        'TO_APPROVE_THIS_X_VISIT' => 'Schválení: %s můžete provést na adrese:',
        'YOUR_X_ON_Y_HAS_BEEN_APPROVED_ELLIPSIS' => 'Vaše %1$s v: %2$s bylo schváleno...',
        'JOIN' => 'Přidat se',
        'WELCOME' => 'Vítejte',
        'WELCOME_TO_X' => 'Vítá vás %s',
        'WELCOME_TO_X_ELLIPSIS' => 'Vítá vás %s …',
        'RSS_LINK' => '<a %s>RSS</a>',
        'NEW_FEATURES_GROUPS_MUSIC' => '<h3 style="margin-top:0">Nové funkce! </h3>
            <ul><li><strong>Skupiny</strong> &ndash;  Umožněte členům vaší komunity zakládat skupiny</li>
            <li><strong>audiopřehrávač</strong> &ndash;  Přidejte do komunity hudbu a podcasty</li></ul>
            <p><a href="%s" class="desc add">Klepněte sem, chcete-li přidat další funkce:</a></p>',
        'NEW_FEATURES_ACTIVITY_BADGES' => '<h3 style="margin-top:0">Nové funkce! </h3>
            <ul><li><strong>Nejnovější aktivita</strong> &ndash;  Sledujte nejnovější aktivity členů vaší komunity</li>
                <li><strong>Odznaky a miniaplikace</strong> &ndash;  Propagujte svou komunitu na webu vlastními členskými odznaky a miniaplikacemi</li></ul>
            <p><a href="%s" class="desc add">Klepněte sem, chcete-li upravit funkce nebo přidat další</a></p>',
        'YOUR_TYPE_NAME_HAS_NEW_COMMENT_APPNAME' => 'Vaše %2$s, %1$s, má nový komentář, který přidal uživatel na: %3$s!',
        'YOUR_TYPE_ON_X_HAS_A_NEW_COMMENT_ELLIPSIS' => 'Váš příspěvek: %1$s na: %2$s obdržel nový komentář...',
        'YOUR_TYPE_HAS_NEW_COMMENT_APPNAME' => 'Vaše %1$s, má nový komentář, který přidal uživatel na: %2$s!',
        'HERE_IS_LINK' => 'Zapojit se můžete klepnutím na tento odkaz: <a %s>%s</a>',
        'CLICK_HERE_TO_JOIN' => 'Chcete-li se stát členem, klepněte sem:',
        'THANKS_VALEDICTION' => 'S díky,',
        'X_WANTS_YOU_TO_CHECK_OUT_Y_ON_Z' => '%1$s vám doporučuje podívat se na "%2$s" na serveru %3$s!',
        'THANKS' => 'Díky!',
        'YOU_CHANGED_YOUR_EMAIL_ON_X' => 'Změnili jste emailovou adresu na %s.',
        'YOU_CHANGED_YOUR_EMAIL_ON_X_ELLIPSIS' => 'Změnili jste emailovou adresu na %s…',
        'CLICK_HERE_TO_SIGN_IN_WITH_YOUR_NEW_EMAIL_ADDRESS' => 'Klepnutím sem se přihlásíte s novou emailovou adresou',
        'IF_DID_NOT_CHANGE_EMAIL_ADDRESS' => 'Pokud jste emailovou adresu nezměnili, klepněte sem:',
        'TO_STOP_BEING_NOTIFIED_OF_NEW_DISCUSSIONS_GO_TO' => 'Pokud už nechcete být informováni o nových diskusích, otevřete stránku:',
        'X_STARTED_DISCUSSION_ON_APPNAME_ELLIPSIS' => '%1$s zahájil(a) novou diskusi na: %2$s…',
        'X_STARTED_THE_DISCUSSION_Y' => '%1$s zahájil(a) diskusi na téma %2$s...',
        'TO_VIEW_THIS_DISCUSSION_GO_TO' => 'Tuto diskusi najdete na adrese:',
        'X_HAS_INVITED_YOU_TO_JOIN_Y' => '%s vás zve, abyste se stali členem: %s!',
        'X_WANTS_YOU_TO_CHECK_OUT_Y' => '%s vám doporučuje podívat se na "%s" na serveru %s.',
        'CHECK_OUT_TITLE_ON_APPNAME' => 'Podívejte se na "%s" na %s!',
        'ABOUT_X' => 'O položce %s',
        'YOU_HAVE_RECEIVED_BECAUSE_X' => 'Tento email jste obdrželi, protože %s',
        'IF_YOU_NO_LONGER_WISH_FROM_X_CLICK_Y' => 'Pokud už nechcete dostávat informace z: %s, <a %s>klepněte prosím sem</a>.',
        'CLICK_HERE' => 'Klepněte sem',
        'YOU_CAN_CONTACT_US' => 'S jakýmikoli otázkami nebo připomínkami ohledně ochrany vašeho soukromí nás můžete kontaktovat na adrese http://help.ning.com/?page_id=27.',
        'MESSAGE_TO_ALL_MEMBERS_OF_X' => 'Zpráva pro všechny členy komunity %s',
        'CLICK_TO_CHECK_OUT' => 'Zaujalo vás to? Klepněte sem!',
        'CLICK_TO_APPROVE_X' => 'Klepněte sem, chcete-li tento příspěvek (%s) schválit nebo odstranit.',
        'YOUR_X_HAS_BEEN_APPROVED' => 'Váš příspěvek (%s) do komunity %s byl schválen!',
        'YOUR_X_WAS_NOT_APPROVED' => 'Váš příspěvek (%s) do komunity %s nebyl schválen.',
        'CLICK_TO_VIEW_X' => 'Klepněte sem, chcete-li si %s prohlédnout.',
        'CLICK_TO_VIEW_IT' => 'Klepněte sem, chcete-li se podívat!',
        'TO_VIEW_USER_PROFILE_VISIT' => 'Profil člena %s najdete na adrese:',
        'YOU_ADDED_CONTENT' => 'Přidali jste příspěvek do moderované komunity %s.',
        'X_REPORTED_AN_ISSUE_ON_Y_ELLIPSIS' => '%1$s ohlásil(a) problém na: %2$s...',
        'YOUR_X_HAS_BEEN_APPROVED_ON_Y' => 'Váš příspěvek (%s) do komunity %s byl schválen.',
        'YOUR_X_Y_HAS_BEEN_APPROVED_ON_Z' => 'Váš příspěvek (%1$s"%2$s") do komunity %3$s byl schválen.',
        'TO_VIEW_YOUR_X_VISIT' => '%s si můžete prohlédnout na adrese:',
        'TO_VIEW_THIS_X_VISIT' => '%s si můžete prohlédnout na adrese:',
        'TO_VIEW_IT_VISIT' => 'Můžete si jej (ji) prohlédnout na adrese:',
        'X_REPORTED_THE_FOLLOWING_ISSUE_ON_Y_ELLIPSIS' => '%1$s ohlásil(a) následující problém na: %2$s...',
        'USER_HAS_SENT_YOU_A_MESSAGE_ON_X' => '%1$s vám zaslal(a) zprávu na: %2$s.',
        'X_REPORTED_THE_FOLLOWING_ISSUE' => '%s ohlásil(a) následující problém.',
        'URL_REPORTED_COLON' => 'Hlášená URL:',
        'ISSUE_COLON' => 'Problém:',
        'ADDITIONAL_INFORMATION_COLON' => 'Další informace:',
        'SEND_AN_INVITATION_TO_X' => 'Zašlete pozvánku osobě: %s',
        'SOMEBODY_REQUESTED_JOIN_X' => 'cizí osoba požádala o členství v: %s',
        'WANT_TO_ADD_A_WELCOME_MESSAGE_FOR_X_ON_THEIR_PROFILE_GO_TO' => 'Chcete přidat uvítání do profilu %s?   Přejděte na:',
        'USER_HAS_SENT_YOU_A_MESSAGE' => '%s vám zaslal(a) zprávu.',
        'TO_READ_THIS_MESSAGE_VISIT' => 'Zprávu si lze přečíst na adrese:',
        'X_HAS_SENT_YOU_A_MESSAGE_ON_Y_ELLIPSIS' => '%s vám zaslal(a) zprávu o %s…',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ELLIPSIS' => '%s vás přidal(a) mezi své přátele…',
        'X_HAS_ADDED_YOU_AS_A_FRIEND_ON_Y' => '%s vás přidal(a) mezi své přátele na: %s...',
        'X_HAS_ACCEPTED_YOUR_FRIEND_REQUEST' => '%s přijal(a) vaši žádost o zařazení mezi přátele na: %s.',
        'TO_ACCEPT_THIS_FRIEND_REQUEST_VISIT' => 'Chcete-li přijmout tuto žádost o zařazení, klepněte na adresu:',
        'VIEW_XS_PAGE_ON_Y' => 'Prohlédněte si stránku uživatele %s na: %s',
        'MEMBER_OF_X_ACCEPTED' => 'člen komunity %s přijal vaši žádost o zařazení mezi přátele',
        'IF_NO_LONGER_WISH_FRIEND_NOTIFICATION_EMAIL_FROM_X_CLICK_Y' => 'Pokud už nechcete dostávat žádosti o zařazení mezi přátele od: %s, <a %s>klepněte prosím sem</a>.',
        'YOU_RECEIVED_INVITATION_FROM_X' => 'Tuto pozvánku vám zaslal člen komunity %1$s.  Pokud nemáte zájem o další pozvánky z komunity %1$s, kontaktujte nás prosím na http://help.ning.com/?page_id=27 .',
        'ON_X_COLON' => 'Na %s:',
        'ON_X' => 'na %s',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X' => '%1$s požádal(a) o členství v: %2$s na serveru %3$s.',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP_ON_X_ELLIPSIS' => '%1$s požádal(a) o členství v: %2$s na %3$s…',
        'TO_APPROVE_OR_DENY_USER_REQUEST' => 'Schválit žádost kandidáta %s můžete na adrese:',
        'USER_HAS_REQUESTED_MEMBERSHIP_OF_GROUP' => '%s požádal(a) o členství v: %s',
        'USER_HAS_INVITED_YOU_TO_JOIN_THE_GROUP_X' => '%1$s vás zve, abyste se stali členem skupiny "%2$s"',
        'VISIT_GROUP_AT' => '%s čeká na vaši návštěvu na adrese:',
        'ABOUT_GROUP' => 'O položce %s',
        'A_MESSAGE_FROM_USERNAME_TO_GROUPNAME_ON_APPNAME' => '%s zaslal(a) zprávu všem členům komunity %s na %s!',
        'YOU_CAN_SIGN_IN_USING_EMAIL_HERE' => 'Můžete se přihlásit zadáním emailové adresy zde:',
        'USERNAME_COMMENTED_ON_BLOG_POST_TITLE_APPNAME' => '%s přidal(a) komentář k blogovému příspěvku %s na %s',
        'SEND_X_A_MESSAGE_HERE' => 'Zašlete zprávu uživateli %s zde:',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X_ELLIPSIS' => 'Nový člen čeká na vaše schválení na %s…',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE' => 'Nový člen čeká na vaše schválení.',
        'TO_APPROVE_XS_PROFILE_VISIT' => 'Schválit profil člena %s můžete na adrese:',
        'CANT_CLICK_CUT_AND_PASTE' => 'Předchozí odkaz nefunguje?  Jednoduše URL zkopírujte a vložte do webového prohlížeče.',
        'CLICK_HERE_TO_JOIN_COLON' => 'Chcete-li se stát členem, klepněte sem:',
        'CLICK_HERE_TO_JOIN_BANG' => 'Chcete-li se stát členem, klepněte sem.',
        'YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED_ELLIPSIS' => 'Vaše členství v komunitě %s bylo schváleno…',
        'CONGRATULATIONS_BANG_YOUR_X_MEMBERSHIP_HAS_BEEN_APPROVED' => 'Gratulujeme!   Vaše členství v komunitě %s bylo schváleno...',
        'YOU_CAN_NOW_SIGN_IN_USING_YOUR_EMAIL_ADDRESS_HERE' => 'Můžete se přihlásit zadáním emailové adresy zde:',
        'VISIT_X_AT_Y' => '%1$s čeká na vaši návštěvu na adrese: %2$s',
        'TO_CONTROL_WHICH_EMAILS_YOUR_RECEIVE_ON_X_GO_TO' => 'Typy zpráv, které vám %1$s zasílá, si můžete nastavit na adrese:',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_ELLIPSIS' => 'Vykázaný člen vám zaslal(a) zprávu na %s…',
        'A_BANNED_MEMBER_HAS_SENT_YOU_A_MESSAGE_ON_X_USERNAME_WRITES' => 'Vykázaný člen vám zaslal(a) zprávu na %1$s.   %2$s píše:',
        'WELCOME_TO_THE_GROUP_X' => 'Vítejte ve skupině "%s"',
        'WELCOME_TO_GROUP_X_ON_Y_ELLIPSIS' => 'Vítá vás %1$s na %2$s…',
        'TO_VIEW_THIS_GROUP_VISIT' => 'Tuto skupinu si můžete prohlédnout na adrese:',
        'X_INVITES_YOU_TO_JOIN_Y' => '%1$s vás zve, abyste se stali členem: %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y' => '%1$s se stal(a) členem: %2$s.',
        'X_IS_NOW_A_MEMBER_OF_Y_ELLIPSIS' => '%1$s se stal(a) členem: %2$s…',
        'SOMEBODY' => 'Někdo',
        'TO_VIEW_YOUR_NEW_COMMENT_VISIT' => 'Svůj nový komentář si můžete prohlédnout na adrese:',
        'TO_VIEW_THE_NEW_COMMENT_VISIT' => 'Nový komentář si můžete prohlédnout na adrese:',
        'TO_VIEW_THE_NEW_REPLY_VISIT' => 'Novou odpověď si můžete prohlédnout na adrese:',
        'WELCOME_TO_X_THANK_YOU_FOR_JOINING' => 'Vítá vás %s!  Děkujeme, že jste se rozhodli k nám vstoupit.',
        'NAME_COLON' => 'Jméno:',
        'EMAIL_COLON' => 'Email:',
        'AGE_COLON' => 'Věk:',
        'GENDER_COLON' => 'Pohlaví:',
        'LOCATION_COLON' => 'Místo pořízení:',
        'COUNTRY_COLON' => 'Země:',
        'PLEASE_SELECT_A_MEMBER' => 'Vyberte alespoň jednoho člena.',
        'LOADING_YOUR_FRIENDS' => 'Načítání vašich přátel...',
        'YOUR_MESSAGE_HAS_BEEN_SENT_TITLE_CASE' => 'Zpráva byla odeslána',
        'TO_SEND_ANOTHER_MESSAGE' => 'Chcete-li odeslat další zprávu, napište text do následujícího pole.',
        'PLEASE_CHOOSE_FRIENDS' => 'Před zasláním zprávy vyberte adresáty.',
        'RESEND_INVITATION' => 'Zaslat pozvánku znovu',
        'CHOOSE_FRIENDS' => 'Zvolte přátele...',
        'ALL_FRIENDS' => 'Všichni přátelé',
        'ALL_FRIENDS_ON_APPNAME' => 'Všichni přátelé na: %s',
        'SHARE_WITH_FRIENDS' => 'Sdílet s přáteli',
        'SHARE_THIS_WITH_FRIENDS' => 'Sdílet s přáteli',
        'COMPOSE_MESSAGE' => 'Napsat zprávu',
        'INVITATION_LINK_ONLY_VISIBLE' => 'Tento odkaz na pozvánku je viditelný pouze pro zakladatele komunity a správce. Členové, kteří se stanou členy s využitím tohoto odkazu, budou automaticky přidáni mezi přátele zakladatele komunity.',
        'WE_ARE_LOADING_ADDRESSES' => 'Načítání vašich adres...',
        'SELECT_ALL_NONE' => 'Vybrat vše/nic',
        'INVITE_TO_APPNAME' => 'Pozvání do komunity "%s"',
        'INVITE_YOUR_FRIENDS_TO_APPNAME' => 'Pozvěte přátele do komunity "%s"',
        'ALREADY_MEMBER_OF_NETWORK' => '(už je členem této komunity)',
        'OR_SHARE_THIS_INVITATION_LINK' => 'Nebo nabídněte tento odkaz:',
        'CLICK_TO_MAIL' => '<a %s>Zprávu můžete zaslat klepnutím sem</a>.',
        'MESSAGE_HAS_BEEN_SENT' => 'Zpráva byla odeslána',
        'YOU_CAN_SHARE_THIS' => 'Můžete odkaz nabídnout dalším lidem uvedeným dole, nebo <a %s>se můžete vrátit na předchozí stránku</a>.',
        'VCARD_IMPORT_UNAVAILABLE' => 'Bohužel - import vizitek vCard v současné době není k dispozici..',
        'CSV_IMPORT_UNAVAILABLE' => 'Bohužel - import souborů .csv v současné době není k dispozici..',
        'ERROR_OCCURRED' => 'Bohužel došlo k chybě.',
        'IMPORT_FAILED' => 'Import se bohužel nezdařil.',
        'LOGIN_FAILED' => 'Přihlášení se bohužel nezdařilo.',
        'UNABLE_TO_FIND_EMAIL' => 'Bohužel, uvedené pole v emailu nelze najít.',
        'CANNOT_READ_VCARDS' => 'Server bohužel nedokáže tyto vizitky vCard přečíst.',
        'GET_NETWORK_BADGE' => 'Členský odznak komunity %s',
        'SPREAD_WORD_GET_BADGE' => 'Propagujte se.  Zajistěte si členský odznak komunity %s, který můžete umístit na své soukromé webové stránky nebo na MySpace.  (<a %s>Získat kód</a>)',
        'SPREAD_WORD_GET_BADGE_SHORT' => 'Propagujte se.  <a href="%s">Zajistěte si členský odznak %s</a>',
        'SHOW_ALLEGIANCE_GET_BADGE' => 'Ukažte, ke komu patříte.  Zajistěte si členský odznak komunity %s, který můžete umístit na své soukromé webové stránky nebo na MySpace.  (<a %s>Získat kód</a>)',
        'USER_COMMENTED_ON_A_TYPE_ON_APPNAME' => '%1$s přidal(a) komentář k: %2$s "%4$s" na: %3$s',
        'UNABLE_TO_EXTRACT_EMAIL_ADDRESSES' => 'Omlouváme se - ze souboru nebylo možné extrahovat žádné emailové adresy.',
        'ADMINISTRATORS' => 'Správci',
        'YOUR_INVITATION_HAS_EXPIRED' => 'Platnost vaší pozvánky vypršela',
        'SORRY_INVITATION_EXPIRED' => 'Bohužel, platnost použité pozvánky už vypršela.   Chcete-li se stát členem %s, budete potřebovat novou pozvánku.',
        'DISABLE_INVITATION_LINK' => 'Deaktivovat odkaz pozvánky?',
        'CREATING_LINK_WILL_DISABLE' => 'Vytvořením nového odkazu pozvání deaktivujete odkaz původní.  Opravdu chcete vytvořit nový odkaz?',
        'SHARE_LINK_WITH_PEOPLE' => 'Tento odkaz zašlete osobám, které chcete pozvat do této komunity:',
        'CREATE_INVITATION_LINK' => 'Vytvořit nový odkaz pozvánky',
        'PLEASE_SELECT_SECOND_PART' => 'Vyberte doménovou část své adresy, např. gmail. com.',
        'AT_SYMBOL_NOT_ALLOWED' => 'Zkontrolujte, zda symbol @ není v první části adresy.',
        'SORRY_WE_DO_NOT_SUPPORT' => 'Bohužel, server nepodporuje vyhledání emailových adres z webového adresáře. Klepněte na volbu "Prohledat adresář" a využijte adresy z počítače.',
        'PLEASE_ENTER_PASSWORD_FOR_EMAIL' => 'Zadejte heslo pro: %s.',
        'IMPORTING_ADDRESS_BOOK' => 'Importování emailového adresáře',
        'LEAVE_WINDOW_WHILE_GET' => '<strong>Nechte prosím toto okno otevřené</strong> - importujeme adresy vašich přátel.  Jakmile operaci dokončíme, můžete se rozhodnout, které přátele pozvete.',
        'SHARE_THIS_LINK' => 'Předejte jim tento odkaz:',
        'SEND_WITH_EMAIL_PROGRAM' => 'Zašlete jej emailem:',
        'EMAIL_THIS' => 'Odeslat emailem',
        'IS_YOUR_FRIEND_PARENTHESIZED' => '(je váš přítel)',
        'CLEAR' => 'Vymazat',
        'SEARCH_FRIENDS_TO_INVITE' => 'Vyhledejte přátele, které pozvete:',
        'NO_ADDRESSES_FOUND' => 'Žádné adresy nebyly nalezeny',
        'WE_DID_NOT_FIND_ADDRESSES' => 'V importovaném adresáři nebyly nalezeny žádné adresy.',
        'WANT_TO_INVITE_MORE_FRIENDS' => 'Chcete pozvat další přátele? Naimportujte kontakty z adresáře na webu nebo v počítači.',
        'MESSAGE_TOO_LONG' => 'Zpráva je příliš dlouhá.  Zkraťte ji o %s znaků a postup opakujte.',
        'IMPORT_FROM_WEB_ADDRESS_BOOK' => 'Import z webového adresáře',
        'IMPORT_FROM_ADDRESS_BOOK_APPLICATION' => 'Import z adresáře v počítači',
        'MICROSOFT_OUTLOOK_APPLE_ADDRESS_BOOK' => 'Microsoft Outlook, adresář Apple, soubory .csv atd.',
        'YOUR_INVITATIONS_HAVE_BEEN_SENT' => 'Pozvánky byly odeslány',
        'WANT_TO_INVITE_MORE' => 'Chcete pozvat další přátele?  Importujte kontakty z webového adresáře nebo emailového programu.',
        'FOLLOWING_DO_NOT_SEEM_VALID' => 'Následující adresy zřejmě nejsou platné.  Pozvánky nebyly odeslány.  Opravte adresy a postup opakujte.',
        'PLEASE_ENTER_EMAIL_ADDRESSES' => 'Zadejte jednu či více emailových adres.',
        'ENTER_EMAIL_ADDRESSES' => 'Zadejte emailové adresy',
        'SEPARATE_MULTIPLE_ADDRESSES' => 'Zadáváte-li více adres, oddělte je čárkami',
        'YOUR_MESSAGE_OPTIONAL' => '<label>Vaše zpráva</label> (volitelné)',
        'SEND_INVITATIONS' => 'Odeslat pozvánky',
        'WEB_ADDRESS_BOOK' => 'Webový adresář',
        'YAHOO_MAIL_HOTMAIL' => 'Yahoo Mail, Hotmail, GMail nebo AOL Mail',
        'YOUR_EMAIL_ADDRESS' => 'Vaše emailová adresa',
        'IMPORT_ADDRESS_BOOK' => 'Importovat adresář',
        'DONT_WORRY_WE_WONT_SAVE' => 'Nebojte se, neuložíme si vaše heslo, a budete si moci zvolit, kterým přátelům email pošlete.',
        'EMAIL_APPLICATION' => 'Emailový program',
        'MICROSOFT_OUTLOOK_APPLE_MAIL' => 'Microsoft Outlook, Apple Mail, soubory . csv atd.',
        'UPLOAD_CSV_OR_VCF' => 'Uploadujte soubor . csv nebo . vcf exportovaný z adresářů Microsoft Outlook nebo Apple.',
        'BROWSE_FOR_FILE' => 'Vyhledat soubor',
        'UPLOAD' => 'Uploadovat',
        'SELECT_ELLIPSIS' => 'vyberte…',
        'OTHER_ELLIPSIS' => 'jiné…',
        'DONT_WORRY_YOULL_GET_CHANCE' => 'Nebojte se, budete si moci zvolit, kterým přátelům email pošlete.',
        'MEMBERSHIP_BY_INVITATION_ONLY' => 'Členství pouze pro pozvané',
        'IF_YOU_ARE_ADMIN' => 'Pokud jste správcem, <a %s>přihlaste se klepnutím sem</a>.',
        'NAME_MUST_BE_SHORTER' => 'Název musí být kratší než %s znaků.',
        'CITY_NAME_MUST_BE_SHORTER' => 'Název města musí být kratší než %s znaků.',
        'EMAIL_ALREADY_REGISTERED' => 'Emailová adresa už byla zaregistrována.  Zvolte jinou.',
        'EMAIL_NOT_VALID' => 'Emailová adresa zřejmě není platná.',
        'USERNAME_INVITED_YOU_TO_APPNAME' => '%s vás zve do: %s',
        'YOU_ARE_SIGNING_UP_WITH' => 'Registrujete se pomocí uživatelského jména (Ning ID).',
        'NOW_ENTER_PASSWORD' => 'K pokračování stačí jen zadat heslo.',
        'OR_SIGN_IN' => 'nebo <a %s>se přihlaste</a>',
        'CHANGE_ADDRESS' => 'Změnit adresu',
        'CHANGE_PAGE_ADDRESS' => 'Stránka Změna adresy',
        'PAGE_ADDRESS_TAKEN' => 'Omlouváme se – tato adresa už je obsazena.  Zvolte jinou.',
        'PAGE_ADDRESS_NOT_VALID' => 'V adrese můžete použít pouze písmena A-Z bez háčku a čárek, čísla a podtržítko (_).',
        'ADD_BY_PHONE' => 'Přidat telefonicky',
        'PAGE_ADDRESS' => 'Stránka Adresa',
        'PHOTO_MUST_BE_TYPE' => 'Fotografie musí být ve formátu . jpg, . gif nebo . png.',
        'USEFUL_ADDRESSES' => 'Užitečné adresy',
        'MY_DETAILS' => 'Informace o mně',
        'NONE_I_DO_NOT_WANT' => 'Žádné: Nechci dostávat emaily z/od: %s',
        'CHANGE_PASSWORD' => 'Změna hesla',
        'PROFILE_SAVED' => 'Změny byly úspěšně uloženy.',
        'UPDATE_EMAIL_ADDRESS' => 'Aktualizovat email',
        'EDIT_EMAIL_ADDRESS' => 'Upravit emailovou adresu',
        'MY_SETTINGS' => 'Mé nastavení',
        'ABOUT_ME' => 'Informace o mně',
        'SELECT' => 'Vyberte…',
        'CITY' => 'Město',
        'COUNTRY' => 'Země',
        'DATE_OF_BIRTH' => 'Datum narození',
        'DO_NOT_DISPLAY' => 'Nezobrazovat',
        'GENDER' => 'Pohlaví',
        'CREATE_YOUR_PROFILE' => 'Vytvořit profil',
        'SYSTEM_REQUIREMENTS' => 'Požadavky na systém',
        'WE_SUPPORT_INTERNET_EXPLORER' => 'Systém podporuje prohlížeče Internet Explorer 6 a 7, Firefox 2.0 a Safari 2.0. Pokud používáte jiný prohlížeč (možná program poskytnutý vaším poskytovatelem internetového připojení), nemusí být kompatibilní.',
        'MAKE_SURE_COOKIES' => 'Zkontrolujte, zda jsou v prohlížeči povoleny soubory cookie a kód JavaScript.',
        'WHAT_IS_MY_EMAIL' => 'Co je to moje registrovaná emailová adresa?',
        'IF_JOINED_BEFORE_OCTOBER' => 'Pokud jste se do naší komunity vstoupili před 5.10. 2007, možná po vás server žádal "Ning ID" (uživatelské jméno).  Dnes je lépe přihlašovat se zaregistrovanou emailovou adresou, ale do tohoto pole můžete i zadávat uživatelské jméno (Ning ID).',
        'CLICK_HERE_TO_RESET_PASSWORD' => 'Klepněte sem, chcete-li resetovat heslo.',
        'STILL_HAVING_PROBLEMS' => 'Stále máte problémy?',
        'VISIT_NING_HELP_CENTER' => 'Navštivte <a %s>Centrum nápovědy serveru Ning</a>, kde najdete další rady k řešení problémů, i podporu.',
        'PROBLEMS_SIGNING_UP_OR_SIGNING_IN' => 'Máte problém s přihlášením nebo registrací?',
        'WE_SENT_YOU_EMAIL' => 'Zaslali jsme vám email s odkazem, jehož pomocí lze heslo resetovat.',
        'RESET_PASSWORD_EMAIL_SUBJECT' => 'Změna hesla',
        'RESET_PASSWORD_EMAIL_BODY' => '%1$s,

Obdrželi jsme žádost o změnu hesla u služby %2$s.

Chcete-li nastavit nové heslo naší služby, klepněte na následující odkaz.

#{URL}

Pokud heslo změnit nechcete, tento email můžete ignorovat.

Zdraví,
pracovníci služby "%2$s"

-----
%2$s využívá k ověření uživatelské jméno (Ning ID).',
        'SET_PASSWORD' => 'Nastavit heslo',
        'NEW_PASSWORD' => 'Nové heslo',
        'CREATE_NEW_PASSWORD' => 'Vytvořit nové heslo',
        'SET_NEW_PASSWORD' => 'Nastavte si nové heslo účtu.',
        'CHOOSE_NEW_PASSWORD' => 'Zvolte nové heslo.',
        'HELLO_USERNAME_SIGN_OUT' => '<strong>Zdravím vás, uživateli %s</strong> (<a %s>Odhlásit se</a>)',
        'NO_ACCOUNT_WITH_EMAIL_X' => 'Účet s emailovou adresou %s neexistuje.',
        'PLEASE_ENTER_CODE' => 'Zadejte prosím kód zobrazený napravo.',
        'PROBLEMS_SIGNING_UP' => 'Máte problémy s registrací?',
        'BY_SIGNING_UP_YOU_AGREE' => 'Registrací projevujete svůj souhlas s našimi <a %s>Podmínkami služby</a> a zásadami ochrany osobních údajů &nbsp; na serveru <a %s> </a>',
        'FEEDBACK' => 'Váš názor',
        'TERMS_OF_SERVICE' => 'Podmínky služby',
        'PRIVACY_POLICY' => 'Ochrana osobních údajů',
        'APPLY_FOR_MEMBERSHIP_SIGN_IN' => 'Požádat o přijetí za člena. Jste už členem? <a %s>Přihlaste se klepnutím sem</a>.',
        'PROBLEM_SIGNING_UP' => 'Při registraci došlo k problému',
        'ALREADY_MEMBER_SIGN_IN' => 'Jste už členem?  <a %s>Přihlaste se klepnutím sem</a>.',
        'MEMBERSHIP_TO_APPNAME_BY_INVITATION_ONLY' => 'Členství v komunitě %s je pouze pro pozvané',
        'SORRY_BUT_ADMINISTRATOR_REQUIRES_INVITATION' => 'Bohužel - správce komunity %s požaduje k členství pozvánku.  Pokud jste dostali emailem pozvánku, klepněte na odkaz v ní.',
        'PROBLEM_SIGNING_IN' => 'Při přihlašování došlo k problému',
        'WE_USE_NING_ID' => 'Využíváme k ověření uživatelské jméno (Ning ID).  <a %s>Co je to uživatelské jméno - Ning ID? </a>',
        'PROBLEMS_SIGNING_IN' => 'Máte problémy s přihlášením?',
        'SIGN_IN_OR_SIGN_UP' => '<input %s value="Sign In" /> &#160; nebo&#160;  <strong><a %s>Registrace</a></strong>',
        'SIGN_IN_TO_APPNAME' => 'Přihlásit se do: %s',
        'WHAT_IS_A_NING_ID' => 'Co je to uživatelské jméno - Ning ID?',
        'LARR_BACK' => '← <a %s>Zpět</a>',
        'NING_ID_LETS_YOU_CHOOSE' => 'Ověřovací systém Ning vám umožní jednorázově nastavit emailovou adresu a heslo a pak je používat při vstupu mezi členy nebo přihlašování do jakékoli komunity, která využívá uživatelské jméno (Ning ID).',
        'WHEN_YOU_CREATE_NING_ID' => 'Jakmile si vytvoříte uživatelské jméno, můžete do svého účtu přidat i pár základních informací o sobě a svou fotografii.  Tyto informace pak budou serverem doplněny pokaždé, až se budete stávat členem další komunity, která k ověření využívá uživatelské jméno.  Díky tomu také můžete být v kontaktu s přáteli ve všech komunitách, které tento systém používají.',
        'SIGN_IN_WITH_NING_ID_WHENEVER' => 'S uživatelským jménem resp. emailovou adresou a heslem se můžete přihlásit, kdykoli uvidíte tento symbol: %s',
        'HELLO_USER' => 'Zdravím vás, uživateli: %s',
        'TEXT_FOR_HEADER_TAB' => 'Tento text je určen pro kartu v záhlaví',
        'BASED_ON' => 'Na základě',
        'ARE_YOU_SURE_DELETE_LANGUAGE' => 'Opravdu chcete tento jazyk odstranit?',
        'DELETE_LANGUAGE' => 'Odstranit jazyk',
        'TEXT_RESET_TO_ORIGINAL_VERSION' => 'Text byl nastaven na výchozí verzi.',
        'UPLOAD_LANGUAGE_FILE' => 'Uploadovat jazykový soubor',
        'ADD_TO_LANGUAGE' => 'Přidat k jazyku:',
        'IF_YOU_CREATED_TRANSLATION' => 'Pokud jste vytvořili nový překlad jiné komunity Ning, můžete svou práci importovat sem.  Obsah tohoto souboru bude přidán k jazyku podle vašeho výběru.  Nevidíte váš jazyk na seznamu?  <a %s>Není problém jej přidat</a>.',
        'EXAMPLES_SWEDISH_FINLAND' => 'Příklady: švédština (Finsko), španělština (Portoriko)',
        'START_FROM_SCRATCH_CREATE' => 'Začněte od začátku!  Vytvořte nový překlad vaší komunity - zadejte název nového jazyka, a poté vyberte některý stávající jazyk jako referenční bod.',
        'KEY_MISSING_TEXT' => 'Klíč: <span %s>Chybí text</span> <span %s>Změněný text</span>',
        'SHOW_ALL_TEXT' => 'Zobrazit veškerý text',
        'SHOW_MISSING_TEXT' => 'Zobrazit chybějící text',
        'SHOW_CHANGED_TEXT' => 'Zobrazit změněný text',
        'EXAMPLES_TABS_MEMBERS_FRIENDS' => 'Příklady: Karty, Členové, Přátelé',
        'RESET_TEXT_TO_ORIGINAL_VERSION' => 'Obnovit původní verzi textu',
        'ORIGINAL_TEXT_X' => 'Původní text - %s',
        'EDIT_LANGUAGE_ON_NETWORK' => 'Upravte jazyk v komunitě',
        'CUSTOMIZE_TEXT_ON_NETWORK_INCLUDING' => 'Upravte si podle potřeb jakýkoli text v komunitě - názvy karet, patky emailových zpráv, chybové zprávy atd.',
        'ACTIVE_LANGUAGE_IS_X' => '<em>Aktivní jazyk vaší komunity je %1$s</em>.  <a %2$s>Změnit aktivní jazyk</a>',
        'CURRENT_LANGUAGE_OPTIONS' => 'Možnosti pro aktuální jazyk',
        'ACTIVE' => 'Aktivní',
        'MY_LANGUAGES' => 'Moje jazyky',
        'CREATE_NEW_TRANSLATION' => 'Vytvořte si nový překlad',
        'DONT_SEE_LANGUAGE_LISTED_CREATE' => 'Nevidíte váš jazyk na předchozím seznamu?  <strong><a %s>Vytvořte si nový překlad textů v komunitě</a></strong>.',
        'ADVANCED_IMPORT' => 'Import - pokročilý',
        'IF_YOU_TRANSLATED_A_LANGUAGE' => 'Pokud jste přeložili některé texty stávající komunity do jiného jazyka, můžete <strong><a %s>naimportovat soubory s překladem</a></strong> a použít je v rámci komunity.',
        'LANGUAGE_EDITOR' => 'Editor jazyka',
        'PUBLIC' => 'Veřejné',
        'GRANDFATHERED_PRIVACY_SETTING' => 'Vaše současné nastavení úrovně soukromí, tj. veřejná komunita, kde nečlenové uvidí pouze přihlašovací obrazovku, nelze použít.   Vaše nastavení se nezměnilo, ale pokud zde provedete jakékoli změny, nebudete se sem moci vrátit.   Aktuálně je nastavena soukromá komunita, do níž se může kdokoli zaregistrovat a stát se členem.',
        'NO_MISSING_ITEMS' => 'Žádné části nechybí - tento překlad je 100%% hotov.  <a %s>Zobrazit všechny položky. </a>',
        'NO_CHANGED_ITEMS' => 'Žádné položky se nezměnily.',
        'COULD_NOT_FIND_ITEMS_MATCHING' => 'Omlouváme se - nepodařilo se najít žádné odpovídající položky <em>%s</em>.  <a %s>Zobrazit všechny položky. </a>',
        'FILE_N' => 'Soubor %s',
        'TRANSLATION_FILE_HAS_FILENAME_LIKE' => 'Překladový soubor serveru Ning má název např. <code>en_US. txt</code>  <a %s>Další informace najdete zde. </a>',
        'SELECT_TRANSLATION_FILE' => 'Vyberte překladový soubor:',
        'USE_THIS_TRANSLATION' => 'Použít tento překlad',
        'FOLLOWING_ARE_MISSING_FROM_RULES' => 'Pozor, následující položky chybí (viz pravidla dole): %s',
        'ALL' => 'Všechny',
        'MISSING' => 'Chybí',
        'VIEW' => 'Zobrazit',
        'TRANSLATION_CHANGES_SAVED' => 'Provedené změny byly uloženy.  Tento překlad je přeložen z %s%%.',
        'TRANSLATION_CHANGES_SAVED_MAKE_CURRENT' => 'Provedené změny byly uloženy.  Tento překlad je přeložen z %s%%.  Chcete jej použít jako platný jazyk komunity?',
        'TRANSLATION_UPLOAD_SUCCESSFUL' => 'Upload proběhl úspěšně.  Tento překlad je přeložen z %s%%.',
        'TRANSLATION_UPLOAD_SUCCESSFUL_MAKE_CURRENT' => 'Upload proběhl úspěšně.  Tento překlad je přeložen z %s%%.  Chcete jej použít jako platný jazyk komunity?',
        'X_IS_CURRENT_LANGUAGE' => 'Aktuálním jazykem komunity je %s.',
        'SAVE_PAGE' => 'Uložit stranu',
        'LANGUAGE_NAME_TAKEN' => 'Omlouváme se - toto jméno už je obsazeno.  Zvolte jiný název.',
        'ENTER_NAME_FOR_TRANSLATION' => 'Zadejte název nového překladu, např. Portugalština (Portugalsko).',
        'CREATE' => 'Vytvořit',
        'LANGUAGE_NAME' => 'Název jazyka',
        'SAVE_ITEMS_ON_PAGE' => 'Uložit tyto položky na této stránce',
        'NEW_TRANSLATION' => 'Nový překlad',
        'MISMATCHED_CURLY_BRACKETS' => 'Některé složené závorky chybí',
        'MISMATCHED_SQUARE_BRACKETS' => 'Některé hranaté závorky chybí',
        'MISMATCHED_PARENTHESES' => 'Některé kulaté závorky chybí',
        'ERROR_PROCESSING_SPECIAL_RULES' => 'Došlo k chybě při kontrole dodržení zvláštních pravidel.',
        'ERROR_PROCESSING_TAB_NAMES' => 'Došlo k chybě při kontrole dodržení pravidel pro názvy karet.',
        'SPECIAL_RULES' => 'Zvláštní pravidla',
        'TAB_NAMES' => 'Názvy karet',
        'SOURCE' => 'Zdroj',
        'LANGUAGE_EDITOR_X' => 'Editor jazyka: %s',
        'BACK_TO_LANGUAGE_EDITOR' => '← Zpět na Editor jazyka',
        'CUSTOMIZE_YOUR_NETWORKS_TEXT' => 'Upravte si text a zprávy komunity nebo pro ni vytvořte nový jazyk.',
        'STOPWORDS' => 'a | nebo | i | s | k | v | z | od | za | o | to | jak | kde | kdy | proč | kdo | co | za | na | pod | on | or | that | the | this | to | was | what | when | where | who | will | with | und | the | www',
        'STOPWORDS_ARE' => '<a %s>Stop slova</a> jsou slova na volitelném seznamu, která jsou v popisu komunity ignorována, když server vytváří meta značky v horní části každé stránky.  Volitelné.',
        'I_AM_MEMBER' => 'Jsem členem komunity:',
        'VIEW_PAGE_ON_APPNAME' => 'Prohlédněte si mou stránku na serveru <em>%s</em>',
        'VISIT_APPNAME' => '<em>%s čeká na vaši návštěvu</em>',
        'JOIN_US' => 'Staňte se naším členem',
        'CREATED_BY_COLON' => 'Vytvořil(a):',
        'GET_MORE_BADGES' => 'Další odznaky',
        'SHOW_LOGO' => 'Zobrazit logo',
        'GALLERY' => 'Galerie',
        'BADGES' => 'Odznaky',
        'MEMBER_BADGE' => 'Členský odznak',
        'WEAR_IT_WITH_PRIDE' => 'Ukažte jej světu!  Zajistěte si členský odznak komunity %s, který můžete umístit na své webové stránky nebo na MySpace.',
        'NETWORK_BADGE_LARGE' => 'Odznak komunity (velký)',
        'SPREAD_THE_WORD_NETWORK_BADGE_LARGE' => 'Propagujte se!  Zajistěte si členský odznak komunity %s, který se dynamicky upravuje podle jejích nejpopulárnějších členů.  Můžete jej umístit na své soukromé webové stránky nebo na MySpace.',
        'NETWORK_BADGE_SMALL' => 'Odznak komunity (malý)',
        'SPREAD_THE_WORD_NETWORK_BADGE_SMALL' => 'Propagujte se!  Zajistěte si členský odznak komunity %s, který můžete umístit na své soukromé webové stránky nebo na MySpace.',
        'PHOTO_SLIDESHOW_PROPER' => 'Prezentace ze snímků',
        'DISPLAY_SELECTION_OF_PHOTOS' => 'Vystavte si vybrané snímky na svých soukromých webových stránkách nebo na MySpace, a to s naším stylovým přehrávačem prezentací.',
        'MUSIC_PLAYER' => 'Audiopřehrávač',
        'PLAY_MUSIC_ON_WEBSITE' => 'Pouštějte si hudbu na svých soukromých webových stránkách nebo na MySpace, a to v našem stylovém audiopřehrávači.',
        'ADD_A_VIDEO_MORE_OPTIONS' => 'Vystavte si na své soukromé webové stránky nebo na MySpace nějaký videoklip.  Hledáte další možnosti?  <a href="%s">Zobrazit všechny videoklipy na: </a>%s.',
        'LARGE_N_PIXELS_WIDE' => 'Velké - široké %d pixelů',
        'MEDIUM_N_PIXELS_WIDE' => 'Střední - široké %d pixelů',
        'SMALL_N_PIXELS_WIDE' => 'Malé - široké %d pixelů',
        'MY_MOST_RECENT' => 'Mé nejnovější',
        'APP_ICON' => 'Ikona apl.',
        'MEMBERSHIP_TO_X_IS_BY_INVITATION' => 'Členství v komunitě %s je pouze pro pozvané',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK' => '%s poskytl(a) následující názor:',
        'X_PROVIDED_THE_FOLLOWING_FEEDBACK_ON_Y' => '%1$s poskytl(a) na: %2$s následující názor:',
        'X_PROVIDED_FEEDBACK_ON_Y_ELLIPSIS' => '%1$s poskytl(a) názor na %2$s…',
        'THANK_YOU_YOUR_MESSAGE_HAS_BEEN_SENT' => 'Děkujeme.   Zpráva byla odeslána.',
        'X_WOULD_LIKE_TO_JOIN_X' => '%s se chce stát se členem komunity %s!',
        'X_HAS_REQUESTED_AN_INVITATION' => '%s požádal(a) o pozvánku do: %s',
        'YOUR_REQUEST_HAS_BEEN_SENT' => 'Vaše žádost byla odeslána zakladateli komunity.',
        'TO_UNBAN_USERNAME_GO_TO' => 'Chcete-li zákaz uživatele %s zrušit, klepněte na:',
        'SEND_REQUEST' => 'Odeslat žádost',
        'SEARCH' => 'Hledat',
        'SEARCH_AGAIN' => 'Hledat znovu',
        'SEND_BROADCAST_MESSAGE' => 'Odeslat hromadnou zprávu',
        'VERIFICATION_IMAGE' => 'Kontrolní obrázek',
        'UNDER_CONSTRUCTION' => 'Na stránkách se pracuje',
        'PROFILE_INFORMATION_SAVED' => 'Informace profilu byly uloženy',
        'YOUR_SITES_DIRECTORY_PROFILE' => 'Profilové informace o adresáři vaší komunity byly uloženy.',
        'NO_ACCOUNT_WITH_EMAIL' => 'Účet pro zadanou emailovou adresu neexistuje.',
        'INVALID_PASSWORD_CHECK_CAPS_LOCK' => 'Nesprávné heslo.   Nemáte aktivní klávesu Caps Lock?',
        'OOPS_THAT' => 'Bohužel - tohle se nepovedlo.',
        'OOPS_THAT_DID_NOT_WORK' => 'Bohužel - tohle se nepovedlo.   Zkusíte to znovu?',
        'OOPS_THAT_DID_NOT_WORK_ERROR_CODE' => 'Bohužel - tohle se nepovedlo (%s).',
        'NOT_FOUND' => 'Nenalezeno',
        'YOUR_SITES_FEATURE_LIST' => 'Seznam funkcí aktivních u vaší komunity byl uložen.',
        'ONE_LINE_ANSWER' => 'Stručná odpověď',
        'LONGER_ANSWER' => 'Delší odpověď',
        'MULTIPLE_CHOICE' => 'Více možností',
        'DATE' => 'Datum',
        'WEBSITE_ADDRESS' => 'Adresa webových stránek',
        'EVERYTHING' => 'Všechno',
        'JUST_THE_HOMEPAGE' => 'Jen hlavní stránka',
        'JUST_THE_SIGN_UP_PAGE' => 'Jen stránka registrace',
        'YOUR_CHANGES_HAVE_BEEN_SAVED' => 'Provedené změny byly uloženy.',
        'JOIN_ME_ON_X' => 'Přidejte se k nám, do komunity %s!',
        'NOT_ALLOWED' => 'Není povoleno',
        'COME_JOIN_ME_ON_X' => 'Pojďte a přidejte se k nám, do komunity %s.',
        'X_ADDED_A_COMMENT_TO_THE_BLOG_POST_Y_ON_Z' => '%1$s přidal(a) komentář k blogovému příspěvku: "%2$s" na: %3$s.',
        'X_ADDED_A_COMMENT_TO_A_BLOG_POST_ON_Y_ELLIPSIS' => '%1$s přidal(a) komentář k některému blogovému příspěvku na serveru: %2$s...',
        'YOU_HAVE_A_NEW_MEMBER_TO_APPROVE_ON_X' => 'Nový člen čeká na vaše schválení na %s.',
        'WELCOME_TO_THE_GROUP_X_ON_Y' => 'Vítejte ve skupině "%1$s" na: %2$s',
        'COME_JOIN_ME_ON_X_ELLIPSIS' => 'Pojďte a přidejte se k nám, do komunity %s…',
        'X_NOT_VALID_EMAIL' => '%s není platnou emailovou adresou nebo uživatelským jménem (Ning ID)',
        'USER_BANNED_FROM_NETWORK' => '%1$s byl(a) z této komunity vykázán(a).  <a %2$s>Odeslat zprávu uživateli %1$s</a>',
        'USER_ALREADY_NETWORK_MEMBER' => '%1$s už je členem této komunity.  <a %2$s>Odeslat zprávu uživateli %1$s</a>',
        'YOU_CAN_SEND_AT_MOST_X' => 'Můžete zaslat maximálně %s zpráv najednou.',
        'PLEASE_ENTER_YOUR_FRIENDS' => 'Zadejte adresy přátel nebo jejich uživatelská jména (Ning ID)',
        'THERE_HAS_BEEN_AN_ERROR' => 'Došlo k chybě',
        'INVITATIONS_HAVE_BEEN_SENT' => 'Pozvánky byly odeslány.',
        'SEARCH_RESULTS' => 'Výsledky hledání',
        'INVITE_YOUR_FRIENDS' => 'Pozvěte přátele',
        'SEND_INVITATIONS_FOR_FRIENDS' => 'Pošlete pozvánky ke vstupu do komunity přátelům',
        'INVITATION' => 'Pozvánka',
        'ADD_FROM_ADDRESS' => 'Přidat z adresáře',
        'TO' => 'Komu:',
        'SEND_TO' => 'Komu:',
        'SUBJECT' => 'Předmět',
        'YOUR_MESSAGE' => 'Text zprávy',
        'SEND' => 'Odeslat',
        'REPORT_AN_ISSUE' => 'Oznámit problém',
        'TYPE_OF_ISSUE' => 'Typ problému',
        'ADULT' => 'Sexuální narážky',
        'ABUSIVE' => 'Hanlivé příspěvky',
        'BUG' => 'Závada na systému',
        'FRAUD' => 'Podvod',
        'SPAM' => 'Spam',
        'OTHER' => 'Jiný',
        'DESCRIBE_YOUR_ISSUE' => 'Popište problém',
        'SEND_REPORT' => 'Odeslat zprávu',
        'ADDED_BY_X_AT_X' => 'Přidal(a) <a %s>%s</a> z %s na %s',
        'ADDED_BY_USER_TO_GROUP_AT_DATE' => 'Přidal(a) <a %s>%s</a> do %s na %s',
        'G_IA' => 'g:ia',
        'F_JS_Y' => 'F jS, Y',
        'CLICK_TO_VIEW' => 'Zobrazíte klepnutím',
        'COMMENT_FOR' => 'Adresát komentáře:',
        'COMMENT_ON' => 'Téma komentáře:',
        'ACTION_BUTTON_FEATURE' => 'Zajímavé',
        'FEATURE_THIS_ON_YOUR' => 'Představit tento materiál na hlavní stránce',
        'ACTION_BUTTON_REMOVE' => 'Odebrat',
        'REMOVE' => 'Odebrat',
        'REMOVE_THIS_FROM_YOUR' => 'Odebrat položku z hlavní stránky',
        'FEATURE_ON_HOME' => 'Představit jako Zajímavé na hlavní',
        'REMOVE_FROM_HOME' => 'Odebrat z hlavní',
        'ITEM_WILL_APPEAR' => 'Tato položka se objeví ve vybraných modulech na hlavní stránce',
        'ITEM_WILL_NO_LONGER_APPEAR' => 'Tato položka se už neobjeví ve vybraných modulech na hlavní stránce',
        'ADD_CONTENT' => 'Přidat materiál',
        'BROUGHT_TO_YOU_BY' => '%s pro vás připravil(a) %s © %s',
        'GIVE_US_YOUR_FEEDBACK' => 'Sdělte nám svůj názor',
        'FOR_ADDITIONAL_QUESTIONS_OR_TO_CONTACT_NING_PLEASE_CLICK_HERE' => 'Pokud máte další otázky nebo chcete kontaktovat Ning, klepněte sem:',
        'SEND_FEEDBACK' => 'Odeslat názor',
        'SIGN_OUT' => 'odhlásit se',
        'SIGN_OUT_TITLE' => 'Odhlásit se',
        'EDIT_MY_PROFILE' => 'Upravit odpovědi v profilu',
        'INVITE_MORE' => 'Pozvat další',
        'USE_THIS_FORM_TO_SEND_FEEDBACK_TO_NC' => 'Pošlete svůj názor na tomto formuláři uživateli: <a %s>%s</a>, zakladateli komunity <a %s>%s</a>.',
        'YOUR_FEEDBACK' => 'Váš názor',
        'NETWORK_INFORMATION' => 'Informace o síti',
        'ABOUT_YOUR_SITE' => 'Info o vaší komunitě',
        'WELCOME_TO_YOUR_SITE' => 'Vítejte ve své komunitě!',
        'EDIT_YOUR_NETWORKS_INFO' => 'Zadejte název komunity, popis a další informace.',
        'TAGLINE' => 'Motto',
        'APPEARS_IN_HEADER' => 'Zobrazí se v záhlaví se jménem komunity',
        'APPEARS_IN_EMAILS' => 'Zobrazí se v emailových zprávách i jinde',
        'NETWORK_NAME' => 'Název komunity',
        'DESCRIPTION' => 'Popis',
        'KEYWORDS' => 'Klíčová slova',
        'LANGUAGE' => 'Jazyk',
        'SEPARATE_EACH_KEYWORD' => 'Oddělte klíčová slova čárkami',
        'ICON' => 'Ikona',
        'UPLOAD_A_PHOTO_WHICH_WILL_BE_RESIZED' => 'Uploadujte snímek (formát *.GIF;, *.JPG nebo *.PNG) - bude serverem upraven na čtvercový formát.  Zobrazení tohoto snímku může nějakou dobu trvat..',
        'SAVE_SETTINGS' => 'Uložit nastavení',
        'SUCCESS_EXCLAMATION' => 'Operace se zdařila',
        'FEATURES' => 'Funkce',
        'ADD_FEATURES' => 'Přidejte funkce do stránek své komunity',
        'ORGANIZE_FEATURES' => 'Uspořádejte si hlavní stránku. Nejprve funkce přetáhněte na stránku myší z následujícího seznamu, a poté je podle libosti uspořádejte.',
        'SKIP_FEATURES' => 'Pokud vám stačí výchozí rozvržení stránky a funkce, klepněte na volbu <a href="%s">Přeskočit tento krok</a>.',
        'FEATURES_FOR_ALL_PAGES' => 'Vlastnosti přidané do tohoto rámečku se objeví na všech stránkách komunity.',
        'CUSTOMIZE_SITE_BY_ADDING' => 'Upravte si stránky komunity na míru přidáním nových funkcí nebo odebráním stávajících.',
        'ADJUST_YOUR_SITES_COLORS' => 'Upravte barvy, obrázky a celkový styl komunity.',
        'APPEARANCE' => 'Vzhled',
        'PROFILE_QUESTIONS' => 'Otázky k vyplnění profilu',
        'EDIT_QUESTIONS_THAT_MEMBERS_ANSWER' => 'Upravte otázky, na které členové budou odpovídat sami o sobě.',
        'MESSAGE_SENT' => 'Zpráva odeslána!',
        'YOUR_MESSAGE_HAS_BEEN_SENT' => 'Vaše zpráva byla odeslána všem členům komunity.',
        'YOUR_MESSAGE_HAS_BEEN_SENT_GROUP' => 'Vaše zpráva byla odeslána všem členům skupiny.',
        'YOUR_MESSAGE_IS_BEING_SENT' => 'Zpráva je odesílána.  Počkejte prosím, operace může nějakou dobu trvat.',
        'BROADCAST_MESSAGE' => 'Odeslat hromadnou zprávu',
        'TRACK_VISITORS_AND_TRENDS' => 'Sledujte pohyb návštěvníků a trendy ve vaší komunitě.',
        'EDIT_SOURCE_CODE' => 'Upravit zdrojový kód',
        'TAKE_FULL_CONTROL' => 'Vezměte kontrolu nad komunitou plně do svých rukou - upravte zdrojový kód.',
        'DELETE_THIS_SITE' => 'Odstranit komunitu',
        'MAIN_PAGE' => 'Hlavní stránka',
        'MAIN' => 'Hlavní',
        'MAIN_TAB_TEXT' => 'Hlavní',
        'MANAGE' => 'Spravovat',
        'MANAGE_TAB_TEXT' => 'Spravovat',
        'PAGE_TITLE' => 'Název stránky',
        'LOREM_IPSUM_1' => 'Lorem <span %s>ipsum dolor</span> sit amet, consectetuer adipiscing elit.  Nunc scelerisque blandit dolor.  Vestibulum ante ipsum primis in faucibus orci luctus.',
        'LOREM_IPSUM_2' => 'Lorem ipsum dolor sit amet, consectetuer adipiscing',
        'LOREM_IPSUM_3' => 'Lorem ipsum dolor sit amet, <span class="preview_link">consectetuer</span> adipiscing',
        'EDIT_THE_APPEARANCE' => 'Upravte si vzhled své stránky',
        'CHOOSE_A_THEME' => 'Zvolte motiv pro stránky komunity',
        'NOW_CUSTOMIZE_SITE' => 'A teď si stránky komunity upravte podle svého…',
        'THEME_SETTINGS' => 'Nastavení motivu',
        'ADVANCED' => 'Rozšířené volby',
        'TOP_BAR_AND_FOOTER' => 'Horní pruh a patka',
        'HEADER_AND_NAVIGATION' => 'Hlavička a navigační prvky',
        'ADD_A_LOGO' => 'Přidat logo',
        'THIS_IMAGE_WILL_REPLACE' => 'Tento obrázek nahradí název komunity (jeho text)',
        'TABS' => 'Karty',
        'TAB' => 'Karta',
        'SITE' => 'Komunita',
        'SIDES' => 'Strany',
        'BODY' => 'Text zprávy:',
        'SHOW_NING_LOGO' => 'Zobrazit logo Ning?',
        'LAUNCH' => 'AKTIVOVAT!',
        'NING_ID' => 'Uživatelské jméno',
        'PASSWORD' => 'Heslo',
        'RETYPE_PASSWORD' => 'Zadejte heslo znovu',
        'TYPE_CODE_ON_RIGHT' => 'Opište kód<br />vpravo',
        'JOIN_X' => 'Staňte se členem %s',
        'SIGN_UP_FOR_X' => 'Registrujete se do: %s',
        'HAS_INVITED_YOU_TO_X' => 'vás zve, abyste se stali členem: %s.',
        'CONTENT_AWAITING_APPROVAL' => 'Čekáme na schválení',
        'NEW_MEMBER' => 'Jste nový člen?',
        'JOIN_X_NOW' => 'Staňte se členem komunity %s!',
        'HIDE_THIS_MESSAGE' => 'Skrýt tuto zprávu',
        'PAGE_NOT_FOUND' => 'Stránka nebyla nalezena',
        'THIS_PAGE_WAS_NOT_FOUND' => 'Omlouváme se - tato stránka nebyla nalezena',
        'FOLLOW_THESE_LINKS_TO' => 'Zkuste něco jiného a použijte tyto odkazy - víme, že jsou dostupné:',
        'ALTERNATIVELY_YOU_CAN_SEARCH' => 'Alternativně můžete prohledat tuto komunitu:',
        'IF_YOU_GET_THIS_MESSAGE' => 'Pokud tuto zprávu obdržíte znovu, <a %s>informujte nás prosím... </a>',
        'GROUP_MEMBERS' => 'Členové skupiny',
        'VIDEOS' => 'Videoklipy',
        'BLOG' => 'Blog',
        'ACCOUNT' => 'Účet',
        'WE_ARE_SORRY_WE_ARE_HAVING' => 'Bohužel, na této stránce došlo k problému.',
        'FOLLOW_LINK_TO_HOMEPAGE' => 'Klepnutím <a %s>sem</a> se vrátíte na hlavní stránku.',
        'REQUEST_AN_INVITATION' => 'Vyžádání pozvánky',
        'NAME' => 'Název',
        'EMAIL_ADDRESS' => 'Email',
        'MESSAGE_OPTIONAL' => 'Zpráva (volitelné)',
        'SORRY_HOWEVER_ITS_EASY' => '<strong>Bohužel! </strong>  Není však problém si založit vlastní komunitu.',
        'GET_YOUR_OWN_BAZEL' => 'Založte si vlastní komunitu!',
        'SITE_IS_NOT_READY' => 'Tato komunita ještě není hotová!',
        'BAZEL_IS_BEING_SET_UP' => 'Tato komunita se stále připravuje!',
        'SIGN_IN' => 'Přihlásit',
        'FORGOT_YOUR_PASSWORD' => 'Zapomněli jste heslo?',
        'FORGOT_YOUR_PASSWORD_TITLE' => 'Zapomněli jste heslo?',
        'ENTER_EMAIL_AND_CLICK_RESET_PASSWORD' => 'Zadejte svou emailovou adresu a klepněte na volbu Vymazat heslo.  Dostanete email s odkazem, jehož pomocí lze staré heslo vymazat.',
        'RESET_PASSWORD' => 'Vymazat heslo',
        'EXPLORE' => 'Prozkoumat',
        'SIGN_UP' => 'Registrace',
        'CONFIRM_PASSWORD' => 'Potvrďte heslo',
        'VERIFICATION' => 'Slouží k eliminaci webových robotů.<br />',
        'YOUR_PHOTO' => 'Vaše fotografie',
        'SUMMARY' => 'Souhrn',
        'YOUR_SITE_IS_READY' => 'Vaše komunita je připravena k aktivaci!   U všech přeskočených kroků bude využito výchozí nastavení.  Vraťte se zpět, chcete-li provést dodatečné změny, nebo klepněte na tlačítko AKTIVOVAT! ‘ a uveďte tak komunitu do provozu.',
        'WHEN_YOU_ARE_FINISHED' => 'Jakmile budete hotovi, klepněte na volbu Zobrazit rozvržení a prohlédněte si výsledek!',
        'COMPLETE' => 'dokončeno',
        'INCOMPLETE' => 'neúplné',
        'VIEW_LAYOUT' => 'Zobrazit rozvržení',
        'CLEAR_CONTENTS' => 'Vymazat obsah',
        'ADD_MODULE' => 'Přidat modul…',
        'ADD_COLUMNS' => 'Přidat sloupce…',
        'PUBLIC_ANYBODY_CAN_JOIN' => '<strong>Veřejná</strong> - stát členem se může kdokoli',
        'PRIVATE_ONLY_INVITED' => '<strong>Soukromá</strong> - stát členem a prohlédnut si komunitu mohou pouze pozvané osoby',
        'INVITATIONS' => 'Pozvánky',
        'MEMBERS_CAN_INVITE' => 'Členové mohou ke členství pozvat další osoby.',
        'QUESTION_TITLE' => 'Otázka',
        'ANSWER_TYPE' => 'Typ odpovědi',
        'REQUIRED' => 'Povinné',
        'PRIVATE' => 'Soukromé',
        'CHOICES' => 'Možnosti',
        'SEPARATE_EACH_CHOICE' => 'Oddělte jednotlivé možnosti čárkami',
        'CAN_PICK_MORE' => 'Lze zvolit více položek',
        'ADD_ANOTHER_QUESTION' => 'Přidat další otázku',
        'WHAT_INFORMATION' => 'Jaké otázky mají nováčci zodpovědět, než budou přijati do komunity?  Pořadí otázek můžete změnit.  Jednoduše klepněte na zvolenou otázku a přetáhněte ji na vhodné místo.',
        'IF_YOU_SELECT_REQUIRED_MEMBERS_WILL' => 'Pokud zaškrtnete políčko "Povinné", nováčci musí na tuto otázku odpovědět, jinak nebudou přijati.  Pokud zaškrtnete políčko "Soukromé," daná odpověď bude viditelná pouze vám a jiným správcům.',
        'WE_COULD_NOT_FIND_ANYTHING' => 'Zadanému výrazu "%s" nic neodpovídá.  Ale co kdybyste zkusili hledat něco jiného?',
        'GET_CUSTOM_URL' => 'Můžete si vymyslet vlastní adresu URL, rozšířit úložný prostor a šířku přenosového pásma, nebo používat vlastní reklamu.',
        'TRACK_STATISTICS' => 'Sledovat statistické parametry',
        'ADD_TRACKING_CODE' => '<a %s>Přidejte si vlastní sledovací kód</a>.',
        'TRACKING_CODE' => 'Kód ke sledování provozu na stránkách',
        'ANY_JAVASCRIPT_CODE' => 'Libovolný kód JavaScript, který sem zkopírujete, se objeví na konci každé stránky komunity.  Sledování můžete propojit s externími monitorovacími službami jako např. Google Analytics.',
        'ANALYTICS_LEARN_MORE' => 'Chcete-li další informace o Google Analytics či si u této služby založit účet, <a %s>klepněte sem</a>.',
        'RESOURCES' => 'Další zdroje',
        'LINKS' => 'Odkazy',
        'PAGE' => 'Strana',
        'BACKGROUND' => 'Pozadí',
        'TEXT' => 'Text',
        'HEADING_TEXT' => 'Text nadpisu',
        'FONT' => 'Písmo',
        'AABBCC' => 'AaBbCc',
        'COLOR' => 'Barva',
        'LINK_COLOR' => 'Barva odkazů',
        'BODY_TEXT' => 'Text zprávy či stránky',
        'MIDDLE' => 'Střed',
        'FEATURE_BOXES' => 'Rámečky funkcí',
        'TITLEBAR_TEXT_COLOR' => 'Barva textu v záhlaví okna',
        'TITLEBAR_BACKGROUND' => 'Pozadí záhlaví okna',
        'UPLOADING_CONTENT' => 'Uploadování materiálů…',
        'WHEN_UPLOADING_IS_COMPLETE' => 'Jakmile je upload dokončen, můžete komunitu zkontrolovat.',
        'FINISH' => 'Dokončit',
        'FLICKR_IMPORT_SETUP' => 'Import z Flickru',
        'FLICKR_API_KEY' => 'Váš klíč',
        'FLICKR_SECRET' => 'Vaše "tajná informace"',
        'FLICKR_KEY_ERROR' => 'Při použití vašeho klíče nebo tajné informace pro Flickr došlo k problémům.   Můžete zkontrolovat uvedené údaje a zadat je znovu?',
        'FLICKR_INTRO' => 'Chcete, aby členové komunity mohli importovat své snímky z Flickru?  Pak jste na správném místě.  Pokud už máte klíč API z Flickru a "tajnou informaci", můžete <a %s>následující kroky přeskočit</a>.  Nevíte, co tato slova znamenají?  Pak postupujte podle následujících pokynů a za pár minut vše poběží.',
        'FLICKR_GET_ACCOUNT' => 'Pokud ještě nemáte účet na Flickru, získáte ho klepnutím <a %s>sem</a>.',
        'FLICKR_STEP1_TITLE' => 'Krok 1: Zajistěte si API klíč z Flickru',
        'FLICKR_STEP1_APPLY_SCREEN' => 'Požádejte o vydání klíče API na Flickru',
        'FLICKR_STEP1_API_SCREEN' => 'Obrazovka s klíčem API na Flickru',
        'FLICKR_STEP1_INTRO' => 'Přihlašte se na Flickr a <a %s>požádejte o nový klíč API </a>(otevře se v novém okně).',
        'FLICKR_STEP1_A' => 'Zadejte <strong>Jméno</strong> a <strong>emailovou adresu</strong>.',
        'FLICKR_STEP1_B' => 'U bodu <strong>This key is for&hellip; (klíč je určen k:) </strong> zvolte nekomerční použití - možnost <em>Non-commercial use</em>.',
        'FLICKR_STEP1_C' => 'Popište svou komunitu v poli <strong>Describe the application are you planning to build</strong>.',
        'FLICKR_STEP1_D' => 'Zaškrtněte obě políčka souhlasu s podmínkami.',
        'FLICKR_STEP1_APPLY' => 'Jakmile budete hotovi, klepněte na tlačítko <strong>Apply</strong>.',
        'FLICKR_STEP1_E' => 'Na další obrazovce bude zobrazen nový klíč API.  Klepněte na odkaz <strong>Click here</strong> a ověřte tak uživatele pro tento klíč.',
        'FLICKR_STEP2_TITLE' => 'Krok 2: Nastavení klíče',
        'FLICKR_STEP2_SETUP_SCREEN' => 'Obrazovka ověření a nastavení klíče API na Flickru',
        'FLICKR_STEP2_F' => 'Do pole<strong>Callback URL</strong> vložte následující webovou adresu:',
        'FLICKR_STEP2_SAVE_CHANGES' => 'Jakmile budete hotovi, klepněte na tlačítko <strong>SAVE CHANGES</strong>.',
        'FLICKR_STEP3_TITLE' => 'Krok 3: Zadejte potřebné informace',
        'FLICKR_STEP3_KEYS_SCREEN' => 'Obrazovka s informacemi o klíči API na Flickru',
        'FLICKR_STEP3_CONGRATULATIONS' => 'Gratulujeme!  Systém na Flickru je nastaven.',
        'FLICKR_STEP3_COMPLETE' => 'K dokončení nastavení na: %s jednoduše zkopírujte a vložte váš klíč a tajnou informaci do následujícího pole:',
        'COMPLETE_SETUP' => 'Dokončení instalace',
        'SETUP_YOUR_SITE_TO' => 'Vaše komunita je nastavena a bude importovat snímky z Flickru.',
        'FLICKR_IMPORTING' => 'Importování z Flickru',
        'YOU_NEED_TO_SET_UP_FLICKR' => 'Chcete-li, aby členové mohli do komunity přenášet své snímky z Flickru, budete muset komunitu nastavit.  Zabere to jen pár minut, tak proč to <a %s>neudělat hned? </a>',
        'DONT_SHOW_THIS_AGAIN_FLICKR' => 'Tuto zprávu již nezobrazovat.',
        'YOUVE_SIGNED_OUT_OF_X' => 'Úspěšně jste se odhlásili z: %s.  Vraťte se k nám brzy!',
        'CREATED_THIS_SOCIAL_NETWORK' => 'založil(a) tuto komunitu na serveru <a href=\'http://www.ning.com\'>Ning</a>.',
        'CREATE_YOUR_OWN' => 'Založte si na Ningu svou vlastní komunitu - je to zdarma!',
        'DRAG_HERE_TO_REMOVE_FEATURE' => 'Funkci odeberete přetažením sem',
        'LAYOUT' => 'Rozvržení',
        'DRAG' => 'Přetáhněte',
        'HERE' => 'sem',
        'YOU' => 'Vy',
        'ADS' => 'Reklama',
        'MEMBERS' => 'Členové',
        'FEATURED_MEMBERS' => 'Zajímaví členové',
        'HELLO_USERNAME' => 'Dobrý den, uživateli',
        'CREATED_BY' => 'Vytvořil(a)',
        'SAVE_FEATURES' => 'Uložit funkce',
        'FORUM' => 'Fórum',
        'CATEGORIES' => 'Kategorie',
        'FORUM_CATEGORIES' => 'Kategorie fóra',
        'A_THREADED_DISCUSSION_FORUM' => 'Fórum podporující vlákna diskusí',
        'ALLOW_MEMBERS_TO_CREATE_GROUPS' => 'Umožněte členům, aby v rámci komunity zakládali své vlastní zájmové skupiny.',
        'FEATURE_POSTS_FROM_YOUR_BLOG' => 'Zveřejněte na hlavních stránkách příspěvky z blogu vašeho nebo jiných členů',
        'TEXT_BOX' => 'Textový rámeček',
        'PUT_ANY_TEXT_WIDGET_OR_HTML' => 'Vložte jakýkoli text, miniaplikaci nebo kód HTML na hlavní stránku',
        'A_LIST_OF_MEMBERS' => 'Seznam členů vaší komunity',
        'ALLOW_USERS_PHOTOS' => 'Povolte ostatním uploadovat a sdílet snímky',
        'ADD_FEEDS_FROM_ACROSS_THE_WEB' => 'Přidejte kanály z celého webu',
        'INFORMATION_ABOUT_THE_USER' => 'Informace o aktuálně přihlášené osobě',
        'ALLOW_USERS_VIDEOS' => 'Povolte ostatním uploadovat a sdílet videoklipy',
        'SHOW_NETWORK_DESCRIPTION' => 'Zobrazte popis komunity',
        'PROMOTE_NETWORK_WITH_BADGES' => 'Propagujte svou komunitu na webu vlastními členskými odznaky a miniaplikacemi',
        'MONETIZE_WITH_ADS' => 'Vydělejte na komunitě s reklamou',
        'LET_MEMBERS_KNOW_WHO_CREATED_NETWORK' => 'Ukažte členům vaší komunity, kdo ji založil',
        'FOLLOW_LATEST_ACTIVITY' => 'Sledujte nejnovější aktivity členů vaší komunity',
        'FAQ_FOR_NETWORK_CREATORS' => 'Časté otázky (FAQ) pro zakladatele komunit',
        'ANSWERS_TO_FAQS' => 'Odpovědi na časté otázky o tom, jak komunity upravovat.',
        'MEET_OTHER_LIKEMINDED' => 'Seznamte se se spřízněnými dušemi - jinými zakladateli komunit. Můžete si s nimi vyměňovat nápady a žádat o podporu od pracovníků Ningu.',
        'CUSTOMIZE_THE_APPEARANCE_NETWORK' => 'Upravte si vzhled komunity přidáním vlastních šablon stylů (CSS) do pole vlevo.  (<a href="%s">Co je to CSS? </a>)',
        'CUSTOMIZE_THE_APPEARANCE_PAGE' => 'Upravte si vzhled vaší stránky přidáním vlastních šablon stylů (CSS) do pole vlevo.  (<a href="%s">Co je to CSS? </a>)',
        'CSS_ON_YOUR_SOCIAL_NETWORK' => 'CSS ve vaší komunitě',
        'CSS_ON_YOUR_PAGE' => 'CSS na vaší stránce',
        'ADDING_YOUR_OWN_CSS_NETWORK' => 'Přidáním vlastní šablony CSS získáte plnou kontrolu nad písmem, barvami, odsazením a celkovým vzhledem stránek vaší komunity.',
        'ADDING_YOUR_OWN_CSS_PAGE' => 'Přidáním vlastní šablony CSS do vašich stránek získáte plnou kontrolu nad písmem, barvami, odsazením a celkovým vzhledem stránky.',
        'CSS_STYLES_WILL_OVERRIDE' => 'Styly CSS, které zde můžete přidat, zruší účinek jakýchkoli stávajících stylů, které jste možná zvolili dříve.',
        'NEED_HELP_FIGURING_OUT_CSS' => 'Potřebujete zjistit název konkrétní třídy CSS vaší komunity?  Doporučujeme použít funkci "Inspect" v bezplatném rozšíření <a href="%s">Firebug</a> (určeno pro prohlížeč Firefox).',
        'WANT_TO_LEARN_MORE' => 'Potřebujete další informace?  Podívejte se do naší sekce <a href="%s">Rozšířené individuální úpravy</a> (Advanced Customization).',
        'APPLY_XS_THEME' => 'Použít motiv z/od: %s',
        'X_ALREADY_REGISTERED_Y_TO_RESET' => 'K této emailové adrese je už zaregistrováno uživatelské jméno (Ning ID).  Přihlaste se v poli dole pomocí uživatelského jména nebo emailu.  Pokud jste zapomněli heslo, <a href="%s">klepněte sem a resetujte jej</a>.',
        'INVITED' => 'Pozván(a)',
        'REQUESTED_INVITE' => 'Požádal(a) o pozvání',
        'BAN_FROM_NETWORK' => 'Vykázán(a) z komunity',
        'REMOVE_BAN' => 'Zrušit vykázání',
        'CANCEL_INVITATION' => 'Zrušit pozvánku',
        'IGNORE' => 'Ignorovat',
        'PROMOTE_TO_ADMINISTRATOR' => 'Povýšit na správce',
        'DEMOTE_FROM_ADMINISTRATOR' => 'Odebrat funkci správce',
        'STATUS' => 'Stav',
        'DATE_JOINED' => 'Datum vstupu',
        'DATE_INVITED' => 'Datum pozvání',
        'DATE_REQUESTED' => 'Datum žádosti',
        'DATE_APPLIED' => 'Datum zaslání žádosti',
        'NETWORK_CREATOR' => 'Zakladatel komunity',
        'NETWORK_ADMINISTRATOR' => 'Správce',
        'ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Správci mají v komunitě podobná práva jako její zakladatelé.',
        'DOWNLOAD_ALL_MEMBER_DATA' => 'Exportovat data všech členů (formát . csv)',
        'CLICK_TO_SEE_MEMBER_DATA' => 'Vaše členská data byla exportována.  Chcete-li je uložit do počítače, klepněte na <a %s>tento odkaz</a>.',
        'CLICK_GO_TO_START_EXPORT' => 'Export spustíte klepnutím na tlačítko Spustit.   Pokud máte hodně členů, operace může trvat několik minut.',
        'MEMBER' => 'Člen',
        'INVITED_BY_X' => 'Pozván(a) uživatelem: %s',
        'DONE' => 'Hotovo',
        'YOU_HAVE_BEEN_BANNED_FROM_APPNAME' => 'Byl(a) jste vykázán(a) z komunity %s',
        'MESSAGE_TO_ADMINISTRATOR' => 'Zpráva správci',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS_IF_YOU_THINK' => 'Uživateli %s: nemáte bohužel přístup do komunity %s, protože jste z ní byl(a) vykázán(a). Pokud máte dojem, že jste byl(a) vykázán(a) omylem, můžete kontaktovat správce komunity.',
        'SORRY_USERNAME_YOU_CANNOT_ACCESS' => 'Uživateli %s: nemáte bohužel přístup do komunity %s, protože jste z ní byl(a) vykázán(a).',
        'SORRY_USERNAME' => 'Uživateli %s - omlouváme se.',
        'PENDING' => 'Čeká na vyřízení',
        'ACCEPT' => 'Přijmout',
        'PENDING_APPROVAL' => 'Čeká na schválení',
        'ACCEPT_MEMBERSHIP' => 'Přijmout členství',
        'DECLINE_MEMBERSHIP' => 'Odmítnout členství',
        'NO_PAGE_YET' => 'Žádná stránka zatím není k dispozici',
        'YOUR_MEMBERSHIP_TO_X_IS_PENDING_APPROVAL' => 'Vaše žádost o členství v komunitě %s čeká na schválení správce.',
        'MEMBERSHIP_PENDING_APPROVAL' => 'Vaše členství čeká na schválení',
        'YOUR_PROFILE_IS_PENDING_APPROVAL' => 'Váš profil čeká na schválení',
        'YOUR_PROFILE_DETAILS_MUST_BE_APPROVED_ON_X' => 'Informace ve vašem profilu musí být schváleny správcem dřív, než se stanete členem komunity %s.  Jakmile bude profil schválen, budete informováni emailem.',
        'CONTINUE_ARROW' => 'Continue →',
        'LARR_BACK_TO_PENDING_MEMBERS' => '← Zpět ke kandidátům čekajícím na vyřízení členství',
        'X_IS_AWAITING_APPROVAL_TO_BECOME_MEMBER_OF_Y' => '%s čeká na schválení svého členství v komunitě %s.',
        'VIEW_PAGE' => 'Zobrazit stránku',
        'MESSAGE' => 'Zpráva',
        'SEND_MESSAGE' => 'Odeslat zprávu',
        'MANAGE_FORUM_CATEGORIES' => 'Spravovat kategorie fóra',
        'START_DISCUSSIONS' => 'Zahajte diskuse',
        'WELCOME_TO_YOUR_NEW_SOCIAL_NETWORK' => 'Vítejte ve své nové komunitě',
        'NOW_ALL_YOU_NEED_TO_DO_IS_INVITE_YOUR_FRIENDS' => 'Teď už stačí jen <a %s>pozvat přátele</a>!',
        'CONTRIBUTE' => 'Posílejte příspěvky',
        'CUSTOMIZE_APPEARANCE_BADGES' => '<strong>Upravte si stránky podle svého. </strong> Upravte <a %1$s>vzhled komunity</a> a připravte <a %2$s>odznaky a miniaplikace</a>.',
        'CONTROL_MANAGE_PAGE' => '<strong>Kontrolujte běh komunity. </strong>  Stránka <a %s>správy</a> je místem, kde najdete celou řadu možností konfigurace.',
        'CREATE_GROUPS' => 'Vytvořte skupiny',
        'INVITE_MORE_PEOPLE' => 'Pozvěte další lidi',
        'VIEW_THREAD' => 'Zobrazit vlákno',
        'COMMENT_THREAD' => 'Přidat komentář k vláknu',
        'COMMENT_BACK' => 'Odpovědět na komentář',
        'HELLO_YOU_NEED_TO_ENABLE_JAVASCRIPT' => 'K práci s touto komunitou musíte v prohlížeči povolit JavaScript.',
        'PLEASE_CHECK_YOUR_BROWSER_SETTINGS' => 'Přihlaste se jako správce nebo se obraťte na správce systému.',
        'MANAGE_MEMBERS_ADMINS_INVITED' => 'Organizujte členy, správce a pozvané i vykázané osoby.',
        'MANAGE_MEMBERS' => 'Řídit členy',
        'MANAGE_INVITED_PEOPLE' => 'Řídit pozvané',
        'NETWORK_SETTINGS' => 'Nastavení komunity',
        'PROMOTE_YOUR_NETWORK' => 'Propagace komunity',
        'NING_RESOURCES' => 'Zdroje na Ningu',
        'ADD_PREMIUM_SERVICES' => 'Přidat exkluzivní služby',
        'REQUEST_SOURCE_CODE' => 'Požádat o přístup ke zdrojovému kódu',
        'REQUEST_A_COPY_OF_THE_SOURCE_CODE' => 'Programátoři: vyžádejte si přístup ke zdrojovému kódu, na kterém funguje vaše komunita.',
        'JOIN_NETWORK_CREATORS' => 'Přidejte se k zakladatelům komunit',
        'SEND_MESSAGE_TO_ALL_THIS' => 'Zašlete zprávu všem členům této komunity.',
        'CREATE_ANOTHER_NETWORK' => 'Založte jinou komunitu',
        'HAVE_ANOTHER_GREAT_IDEA' => 'Máte jiný skvělý nápad na komunitu?',
        'ALLOW_FACEBOOK_USERS_TO' => 'Umožněte uživatelům serveru Facebook, aby si umístili miniaplikace vaší komunity na stránky svých profilů.',
        'BADGES_AND_WIDGETS' => 'Odznaky a miniaplikace',
        'CUSTOMIZE_WIDGETS_AND_BADGES' => 'Upravte vzhled miniaplikací a odznaků komunity.',
        'GET_BADGES' => 'Zajistit odznaky',
        'CUSTOM_TEXT' => 'Vlastní text',
        'IM_A_MEMBER_OF' => 'Jsem členem komunity:',
        'DONT_DISPLAY_ANY_BRANDING' => 'Nezobrazovat žádné značky',
        'WATERMARK_OR_LOGO_IMAGE' => 'Vodoznak nebo logo:',
        'NETWORK_BRANDING_BADGES' => 'Značka komunity: odznaky',
        'NETWORK_BRANDING_WIDGETS' => 'Označení komunity: miniaplikace',
        'LOGO_IMAGE' => 'Logo',
        'SMALL_NETWORK_BADGE' => 'Malý odznak komunity',
        'LARGE_NETWORK_BADGE' => 'Velký odznak komunity',
        'REFRESH' => 'Aktualizovat',
        'HTML_EMBED_CODE' => 'Vložený HTML kód:',
        'CUSTOMIZE' => 'Upravte si stránky podle svého',
        'SHARE_TITLE' => 'Sdílet %s',
        'SHARE_TYPE' => 'Sdílet %s',
        'YOUR_MESSAGE_SENT' => 'Zpráva byla úspěšně odeslána.',
        'YOUR_MESSAGES_SENT' => 'Zprávy byly úspěšně odeslány.',
        'YOU_CAN_SHARE_TYPE_TWO_WAYS' => 'Tuto položku (%s) můžete ostatním nabídnout dvěma způsoby#8230;',
        'CHECK_OUT_THIS_TYPE_TITLE' => 'Chci vám něco ukázat - %s: "%s"',
        'CHECK_OUT_THIS_TYPE' => 'Chci vám něco ukázat - %s',
        'PHOTO_ALBUM' => 'fotoalbum',
        'CUSTOMIZE_YOUR_BADGES_AND_WIDGETS' => 'Upravte si odznaky a miniaplikace barvami a obrázky podle svého.  Zobrazení změn na jiných webových serverech může trvat až 4 hodiny.',
        'BACKGROUND_IMAGE_AND_COLOR' => 'Obrázek a barva pozadí',
        'USE_THIS_FORM_TO_REPORT_ISSUE_TO_NC' => 'Na tomto formuláři můžete nahlásit případný problém uživateli: <a %s>%s</a>, zakladateli komunity <a %s>%s</a>.',
        'SORRY_NCS_CANNOT_CHANGE_EMAIL' => 'Bohužel, zakladatelé komunit nemohou změnit své emailové adresy prostřednictvím komunit, které nezaložili.',
        'SORRY_NCS_CANNOT_CHANGE_PASSWORD' => 'Bohužel, zakladatelé komunit nemohou změnit svá hesla prostřednictvím komunit, které nezaložili.',
        'GO' => 'Spustit',
        'LARGE_THUMBNAILS' => 'Velké náhledy',
        'SMALL_THUMBNAILS' => 'Malé náhledy',
        'RECENTLY_JOINED' => 'Nejnovější',
        'MOST_POPULAR_MEMBERS' => 'Nejpopulárnější',
        'NO_MEMBERS_TO_DISPLAY' => 'V současné době nemáte zveřejněny žádné členy.',
        'BOX_WILL_NOT_SHOW_MEMBERS' => 'Tento rámeček se jiným osobám nezobrazí, dokud nevyberete aspoň jeden řádek.',
        'DETAIL_VIEW' => 'Detailní pohled',
        'TITLES_ONLY' => 'Pouze názvy',
        'RECENTLY_ADDED_POSTS' => 'Nedávno přidané',
        'POPULAR_POSTS' => 'Nejvíce komentářů',
        'PROMOTED_POSTS' => 'Zajímavé',
        'BOX_WILL_NOT_SHOW_BLOG_POST' => 'Tento rámeček se jiným osobám nezobrazí, dokud nevyberete aspoň jeden příspěvek.',
        'KEEP_WINDOW_OPEN_UPLOAD' => 'Probíhá upload - nechte toto okno prohlížeče otevřené.',
        'CANCEL_UPLOAD' => 'Zrušit upload',
        'YOU_DO_NOT_HAVE_POSTS' => 'Zatím jste nenapsali žádné příspěvky.',
        'YOU_DO_NOT_HAVE_COMMENTS' => 'Nemáte žádné komentáře ke schválení.',
        'REQUIRED_FIELD' => '(povinné pole)',
        'BLOG_POST_BY_X' => 'Blogový příspěvek, napsal(a) %s',
        'HELLO' => 'Dobrý den,',
        'ADDED_BY_X' => 'Přidal(a) %s',
        'CLICK_TO_ADD_A_TITLE' => 'klepnutím přidáte název',
        'DELETE_BLOG_POST' => 'Odstranit příspěvek',
        'DELETE_THIS_BLOG_POST_Q' => 'Odstranit tento blogový příspěvek?',
        'ARE_YOU_SURE_DELETE_THIS_BLOG_POST' => 'Opravdu chcete tento blogový příspěvekek odstranit?  Operace může trvat několik minut.',
        'SPINNER' => 'Spinner',
        'PLEASE_ENTER_SOMETHING_FOR_X' => 'Zadejte nějaký text pro: %s',
        'PLEASE_SELECT_OPTION_FOR_X' => 'Vyberte možnost pro: %s',
        'PLEASE_PROVIDE_VALID_DATE_FOR_X' => 'Zadejte platné datum pro: %s',
        'PLEASE_PROVIDE_DATE_FOR_X' => 'Zadejte datum pro: %s',
        'XS_BLOG_POSTS_FOR_M_Y' => 'Blogové příspěvky uživatele %s pro: %s %s',
        'FEATURED_BLOG_POSTS_FOR_M_Y' => 'Zajímavé blogové příspěvky uživatele: %s %s',
        'BLOG_POSTS_FOR_M_Y' => 'Blogové příspěvky pro: %s %s',
        'FEATURED_BLOG_POSTS' => 'Zajímavé blogové příspěvky',
        'EVERYONES_POSTS' => 'Blogové příspěvky všech',
        'PUBLISHED_N_OF_N' => 'Publikováno: %d z %d',
        'DOWNLOAD_X' => 'Stáhnout: %s',
        'UPLOAD_DID_NOT_WORK' => 'Bohužel, upload se nezdařil',
        'F_J_Y' => 'F j, Y',
        'M_J_Y' => 'M. j, Y',
        'XS_POSTS' => 'Příspěvky uživatele %s',
        'USERNAMES_COMMENTS' => 'Komentáře uživatele %s',
        'ADD_COMMENT' => 'Přidat komentář',
        'XS_PAGE' => 'Stránka uživatele %s',
        'XS_BLOG' => 'Blog uživatele %s',
        'XS_FRIENDS' => 'Přátelé uživatele %s',
        'VIEW_XS_ELLIPSIS' => 'Zobrazit položky uživatele %s…',
        'DRAFT_BRACKETS' => '[ Draft ]',
        'FEATURED' => 'Zajímavé',
        'MY_POSTS' => 'Moje příspěvky',
        'MY_POSTS_ONLY' => 'Pouze moje příspěvky',
        'OWNER_POSTS_ONLY' => 'Pouze příspěvky zakladatele',
        'JANUARY' => 'Leden',
        'FEBRUARY' => 'Únor',
        'MARCH' => 'Březen',
        'APRIL' => 'Duben',
        'MAY' => 'V',
        'JUNE' => 'Červen',
        'JULY' => 'Červenec',
        'AUGUST' => 'Srpen',
        'SEPTEMBER' => 'Září',
        'OCTOBER' => 'Říjen',
        'NOVEMBER' => 'Listopad',
        'DECEMBER' => 'Prosinec',
        'MY_COMMENTS' => 'Moje komentáře',
        'AM' => 'dop.',
        'PM' => 'odp.',
        'MY_PAGE' => 'Moje stránka',
        'MY_PAGE_TAB_TEXT' => 'Moje stránka',
        'BLOG_POSTS' => 'Blogové příspěvky',
        'MY_BLOG' => 'Můj blog',
        'MONTH' => 'Měsíc',
        'DAY' => 'Den',
        'PICK_VALID_DEFAULT_VISIBILITY' => 'Vyberte platnou možnost pro výchozí viditelnost',
        'PICK_VALID_WHO_CAN_COMMENT' => 'Vyberte platnou možnost pro osoby, které smějí přidat komentář',
        'PICK_VALID_BLOG_COMMENT_MODERATION' => 'Vyberte platnou možnost pro moderování komentářů do blogů',
        'PICK_VALID_ACTIVITY_NOTIFICATION' => 'Vyberte platnou možnost pro upozorňování na aktivity',
        'PICK_VALID_MODERATION_NOTIFICATION' => 'Vyberte platnou možnost pro zasílání informací o moderování',
        'PICK_VALID_APPROVAL_NOTIFICATION' => 'Vyberte platnou možnost pro zasílání informací o schvalování',
        'PICK_VALID_INVITEE_NOTIFICATION' => 'Vyberte platnou možnost pro upozorňování na vstupující pozvané nováčky',
        'PICK_VALID_NEVER_NOTIFICATION' => 'Vyberte platnou možnost pro zákaz dalších upozorňování',
        'PICK_VALID_FRIEND_REQUEST_NOTIFICATION' => 'Vyberte platnou možnost pro upozorňování na žádosti o zařazení mezi přátele',
        'PICK_VALID_NEW_MESSAGE_NOTIFICATION' => 'Vyberte platnou možnost pro upozorňování na zprávy',
        'APPROVE_COMMENT' => 'Schválit komentář',
        'MANAGE_BLOG' => 'Spravovat blog',
        'COMMENTS_POSTED_ON_BLOG' => 'Komentáře přidané do mého blogu',
        'COMMENT' => 'Komentář',
        'COMMENTER' => 'Komentář přidal(a)',
        'POST' => 'ODESLAT',
        'M_J_Y_G_IA' => 'M j, Y, g:ia',
        'POST_HAS_BEEN_DELETED' => 'Příspěvek byl odstraněn',
        'COMMENTS_ARE_CLOSED' => 'K tomuto příspěvku už nelze přidávat komentáře',
        'NO_COMMENTS' => 'Žádné komentáře',
        'FLAG' => 'Označit',
        'POST_TITLE' => 'Název příspěvku',
        'DRAFT_PARENTHESES' => '(Koncept)',
        'SCHEDULED_TO_PUBLISH_ON' => 'Zveřejnění naplánováno na: %s',
        'EDIT_2' => 'upravit',
        'NONE' => 'Není',
        'N_NEW' => 'Nové: %s',
        'NO_POSTS' => 'Žádné příspěvky',
        'ADD_NEW_BLOG_POST' => 'Přidat nový blogový příspěvek',
        'HAPPY' => 'Spokojenost',
        'SAD' => 'Smutek',
        'COOL' => 'Paráda',
        'EVIL' => 'Padouch',
        'MAD' => 'Zuřím',
        'ENVIOUS' => 'Závidím',
        'ENTRY' => 'Položka',
        'WHAT_DATE_FOR_YOUR_POST' => 'Jakým datem chcete příspěvek opatřit?',
        'NOW' => 'Ihned',
        'CHOOSE_DATE_AND_TIME' => 'Zvolte datum a čas (pokud zvolíte datum v budoucnu, příspěvek bude k danému datu zveřejněn)',
        'PRIVACY_AND_COMMENTS' => 'Ochrana soukromí a komentáře',
        'WHO_CAN_VIEW_POST' => 'Kdo si tento příspěvek smí prohlédnout?',
        'EVERYONE' => 'Kdokoliv',
        'ALLOW_COMMENTS' => 'Povolit komentáře k tomuto příspěvku?',
        'YES' => 'Ano',
        'NO' => 'Ne',
        'COMMENT_MODERATION' => 'Schvalování komentářů',
        'YOU_ARE_MODERATING_BLOG_COMMENTS' => 'Komentáře k blogu v současné době vyžadují vaše schválení.',
        'YOU_ARE_NOT_MODERATING_BLOG_COMMENTS' => 'Komentáře k blogu v současné době nevyžadují vaše schválení.',
        'SAVE_AS_DRAFT' => 'Uložit jako koncept',
        'PREVIEW' => 'Ukázka',
        'PUBLISH_POST' => 'Publikovat příspěvek',
        'THIS_IS_PREVIEW_OF_BLOG_POST' => 'Takto bude blogový příspěvek po zveřejnění vypadat.  Pokud chcete příspěvek upravit, klepněte na volbu Zpět. Pokud je hotov, klepněte na Zveřejnit!',
        'BACK' => 'Zpět',
        'PUBLISH' => 'Zveřejnit!',
        'BLOG_POST' => 'Blogový příspěvek',
        'PROFILE' => 'Profil',
        'THIS_IS_UNPUBLISHED_DRAFT' => 'Toto je nepublikovaný koncept',
        'WILL_BE_PUBLISHED_ON_X' => 'Bude zveřejněn: %s <small>%s</small>',
        'POSTED_ON_X' => 'Zveřejněno <strong>%s</strong> <small>%s</small>',
        'POSTED_ON_X_BY' => 'Zveřejněno <strong>%s</strong> <small>%s</small>, přidal(a):',
        'ABOUT_THIS_POST' => 'O tomto příspěvku',
        'ABOUT_YOUR_POST' => 'O vašem příspěvku',
        'ADDED_BY' => 'Přidal(a):',
        'JUST_FRIENDS' => 'Jen přátelé',
        'RECENT_POSTS' => 'Poslední příspěvky',
        'THERE_ARE_NO_RECENT_POSTS' => 'Žádné poslední příspěvky nejsou.',
        'YOUR_COMMENT_HAS_BEEN_ADDED_BUT' => 'Váš komentář byl přidán, ale musí být před zveřejněním schválen.',
        'AT_TIME_ON_DATE_USERNAME_SAID' => 'V %s dne %s, %s řekl(a)…',
        'X_DOES_NOT_HAVE_ANY_FRIENDS' => '%s nemá v této komunitě zatím žádné přátele.',
        'YOU_DO_NOT_HAVE_ANY_FRIENDS' => 'V této komunitě zatím nemáte žádné přátele.',
        'EDIT_PAGE_APPEARANCE' => 'Upravit vzhled stránky',
        'VIEW_PAGE_AS_OTHERS' => 'Zobrazit stránku, jak ji vidí ostatní',
        'ADD_BLOG_POST' => 'Přidat blogový příspěvek',
        'KEEP_WINDOW_OPEN_CONTENT_DELETED_2' => 'Odstraňování materiálu uživatele %s - nechte prosím toto okno prohlížeče otevřené.  Operace může trvat několik minut.',
        'BAN_MEMBER_FROM_NETWORK' => 'Vykázat člena z komunity',
        'BAN_USERNAME' => 'Vykázat člena %s?',
        'BLOCK' => 'blokovat',
        'CREATE_NEW_BLOG_POST' => 'Vytvořit nový blogový příspěvek',
        'EDIT_POST' => 'Upravit příspěvek',
        'EDIT_POST_COLON' => 'Upravit příspěvek:',
        'CONTINUE_READING' => 'Probíhá stále načítání…',
        'POSTED_BY_ME_LINK_ON_X_AT_X' => 'Přidal(a)  <a %s>Já</a> na %s z %s -',
        'POSTED_BY_X_ON_X_AT_X' => 'Přidal(a) %s na %s z %s -',
        'POSTED_BY_ME_ON_X_AT_X' => 'Přidal(a)  me on %s z %s -',
        'ADD' => 'Přidat',
        'SUBSCRIBE' => 'Odebírat',
        'VIEW_ARCHIVES' => 'Zobrazit archivy',
        'YOUR_SETTINGS_HAVE_BEEN_SAVED' => 'Nastavení bylo uloženo.',
        'PLEASE_CORRECT_THE_FOLLOWING' => 'Opravte následující:',
        'PRIVACY' => 'Soukromí',
        'NETWORK_PRIVACY' => 'Úroveň soukromí komunity',
        'THIS_NETWORK_VISIBLE_TO_EVERYONE' => 'Tato komunita je <strong>viditelná pro každého</strong>.',
        'ANYONE_CAN_SIGN_UP_VISITORS_CAN' => 'Kdokoli se může zaregistrovat a stát se jejím členem.  Návštěvníci…',
        'SEE_EVERYTHING' => 'uvidí všechno',
        'SEE_JUST_THE_MAIN_PAGE' => 'uvidí jen hlavní stránku',
        'SEE_JUST_THE_SIGN_UP_PAGE' => 'uvidí jen stránku registrace',
        'THIS_NETWORK_VISIBLE_MEMBERS_ONLY' => 'Tato komunita je <strong>viditelná pouze pro její členy</strong>.',
        'WHO_CAN_SIGN_UP' => 'Kdo se může zaregistrovat a stát se jejím členem?',
        'MODERATION' => 'Kontrola obsahu materiálů',
        'APPROVE_MEMBERS_BEFORE_JOIN' => 'Schvalovat kandidáty na nové členy',
        'APPROVE_PHOTOS_VIDEOS' => 'Schvalovat snímky a videoklipy před zveřejněním',
        'SHOW_LATEST_ACTIVITY_ON_YOUR_NETWORK' => 'Nenechte si ujít nejnovější aktivity v komunitě!',
        'PUT_A_CONSTANTLY_UPDATED_STREAM' => 'Umístěte neustále aktualizovaný přehled aktivit na hlavní stránku komunity.',
        'CLICK_HERE_TO_ADD_LATEST_ACTIVITY' => 'Pole Nejnovější aktivity přidáte na stránky komunity klepnutím sem.',
        'THESE_OPTIONS_ARE_DISABLED_ACTIVITY' => 'Tyto volby nefungují, protože nejnovější aktivity nejsou pro komunitu zapnuty.',
        'ACTIVITY' => 'Aktivita',
        'DISPLAY_PREFERENCES' => 'Zobrazit předvolby',
        'NEW_CONTENT' => 'Nový materiál',
        'NEW_COMMENTS' => 'Nový komentář',
        'NEW_MEMBERS' => 'Noví členové',
        'MEMBER_UPDATES' => 'Novinky o členech',
        'WHAT_DISPLAYS_LATEST_ACTIVITY' => 'Co se nachází v okně <br />Nejnovější aktivity komunity?',
        'LATEST_ACTIVITY' => 'Nejnovější aktivity',
        'X_COMMENTED_ON_POST_TITLE' => '%1$s přispěl(a) do diskuse: %2$s',
        'X_LINK_COMMENTED_ON_POST_LINK_TITLE' => '%1$s <a %2$s>přispěl(a)</a> do diskuse: <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_POST_LINK_TITLE' => '<a %1$s>Přispěli</a> jste do diskuse: <a %2$s>%3$s</a>',
        'X_COMMENTED_ON_BLOG_POST_TITLE' => '%1$s přidal(a) komentář k blogovému příspěvku %2$s',
        'X_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '%1$s <a %2$s>přidal(a) komentář</a> k blogovému příspěvku <a %3$s>%4$s</a>',
        'YOU_LINK_COMMENTED_ON_BLOG_POST_LINK_TITLE' => '<a %1$s>Přidali jste komentář</a> k blogovému příspěvku <a %2$s>%3$s </a>',
        'X_STARTED_A_DISCUSSION_Y' => '%s zahájil(a) diskusi na téma: %s',
        'YOU_STARTED_A_DISCUSSION_Y' => 'Zahájili jste diskusi na téma: %s',
        'X_ADDED_THE_BLOG_POST_Y' => '%s přidal(a) komentář k blogovému příspěvku: %s',
        'YOU_ADDED_THE_BLOG_POST_Y' => 'Přidali jste komentář k blogovému příspěvku %s',
        'X_JOINED_THE_GROUP_Y' => '%s se stal(a) členem skupiny %s',
        'YOU_JOINED_THE_GROUP_X' => 'Stali jste se členem skupiny %s',
        'X_JOINED_Y_GROUPS' => '%s se stal(a) členem skupin: %s',
        'YOU_JOINED_X_GROUPS' => 'Stali jste se členem skupin: %s',
        'X_JOINED_APPNAME' => '%s se stal(a) členem: %s. <a %s>Zanechat komentář</a> pro: %s.',
        'WELCOME_MEMBER_N_OF_APPNAME' => 'Vítáme uživatele %1$s!  Jste členem komunity #%2$s na serveru %3$s.',
        'WELCOME_MEMBER_N_OF_APPNAME_FIND' => 'Vítáme uživatele %1$s!  Jste členem komunity #%2$s na serveru %3$s.  <a %4$s>Podívejte se po svých přátelích</a>.',
        'WELCOME_MEMBER_N_OF_APPNAME_INVITE' => 'Vítejte, uživateli: %1$s! Jste členem č. %2$s z %3$s. <a %4$s>Pozvěte své přátele</a>.',
        'CHECK_OUT_X_ON_Y_ELLIPSIS' => 'Podívejte se na "%1$s" na: %2$s ...',
        'CHECK_OUT_THIS_X_ON_Y_ELLIPSIS' => 'Chci vám něco ukázat - %1$s na: %2$s...',
        'SORRY_NO_MEMBERS_MATCHING_X_WERE_FOUND' => 'Bohužel, členové odpovídající kritériu: "%s" nebyli nalezeni.',
        'WHO_CAN_COMMENT_ON_POST' => 'Kdo smí tento příspěvek komentovat?',
        'SEND_MESSAGE_TO_FRIENDS' => 'Zaslat zprávu přátelům',
        'PREVIOUS_POST' => '← Předcházející příspěvek',
        'NEXT_POST' => 'Další příspěvek →',
        'PREVIOUS_POSTS' => '← Předcházející příspěvky',
        'NEXT_POSTS' => 'Další příspěvky →',
        'NO_BLOG_POSTS_TAGGED_X_CHECK' => 'Žádné blogové příspěvky nejsou označené popiskem "%1$s". Prohlédněte si diskuse (<a %2$s>) s označením "%1$s"</a>, snímky (<a %4$s>) s označením "%1$s"</a> nebo videoklipy (<a %3$s>) s označením "%1$s"</a>. Nebo přidejte vlastní blogové příspěvky a doplňte k nim popisky.',
        'ALL_POSTS_TAGGED_X_FOR_M_Y' => 'Všechny příspěvky označené popiskem: <em>"%s"</em> pro: %s %s',
        'ALL_POSTS_TAGGED_X' => 'Všechny příspěvky označené popiskem <em>"%s"</em>',
        'MY_BLOG_POSTS_FOR_M_Y' => 'Moje blogové příspěvky pro: %s %s',
        'MY_BLOG_POSTS' => 'Moje blogové příspěvky',
        'PICK_VALID_ALL_FRIENDS_NOTIFICATION' => 'Zvolte platné parametry pro upozornění na zprávy odesílané všem přátelům',
        'PRIVACY_CONTENT_CONTROL' => 'Kontrola ochrany soukromí a obsahu materiálů',
        'ENABLE_MUSIC_DOWNLOAD_LINKS' => 'Povolit odkazy ke stažení přehrávače hudby',
        'X_IS_MEMBER_N_OF_APPNAME' => '%1$s je členem komunity #%2$s na serveru %3$s.',
        'XS_PROFILE_CHANGED' => 'Profil uživatele %s se změnil.',
        'YOUR_PROFILE_CHANGED' => 'Váš profil se změnil',
        'X_LEFT_A_COMMENT_FOR_Y' => '%s zanechal(a) komentář pro uživatele %s',
        'YOU_LEFT_A_COMMENT_FOR_X' => 'Zanechali jste komentář pro uživatele %s',
        'X_LEFT_A_COMMENT_FOR_YOU' => '%s vám zanechal(a) komentář',
        'X_CREATED_A_GROUP_Y' => '%s založil(a) skupinu s názvem %s',
        'YOU_CREATED_A_GROUP_Y' => 'Založili jste skupinu s názvem %s',
        'X_CREATED_Y_NEW_GROUPS' => '%s založil(a) nové skupiny (%s)',
        'X_STARTED_Y_FORUM_POSTS' => '%s zahájil(a) na fóru nové diskuse (%s)',
        'YOU_STARTED_Y_FORUM_POSTS' => 'Zahájili jste na fóru nové diskuse (%s)',
        'X_ADDED_Y_BLOG_POSTS' => '%s přidal(a) nové blogové příspěvky (%s)',
        'YOU_ADDED_Y_BLOG_POSTS' => 'Přidali jste nové blogové příspěvky (%s)',
        'VIEW_XS_BLOG_POSTS' => 'Zobrazit blogové příspěvky uživatele %s',
        'VIEW_YOUR_BLOG_POSTS' => 'Zobrazit vlastní blogové příspěvky',
        'APPNAME_HAS_NEW_PROFILE_QUESTIONS' => '%s poskytl(a) <a %s>nové odpovědi na otázky v profilu</a>',
        'APPNAME_NOW_HAS_MUSIC' => '%s už má audiopřehrávač',
        'APPNAME_NOW_HAS_GROUPS' => '%s už má <a %s>skupiny</a>',
        'APPNAME_NOW_HAS_VIDEO' => '%s už má <a %s>videoklipy</a>',
        'APPNAME_NOW_HAS_FORUM' => '%s už má <a %s>fórum</a>',
        'APPNAME_NOW_HAS_PHOTO' => '%s už má <a %s>snímky</a>',
        'DID_YOU_KNOW' => 'Víte, že...',
        'ANNOUNCEMENT' => 'Oznámení',
        'CONGRATULATIONS' => 'Gratulujeme!',
        'YOU_CREATED_APPNAME' => 'Založili jste komunitu: %s.',
        'USER_CREATED_APPNAME' => '%s založil(a) komunitu: %s.',
        'ADD_MESSAGES_ACTIVITY_FEED' => 'Přidejte zprávy a určete, co má být zobrazeno v sekci aktivit komunity.',
        'WHICH_OF_YOUR_ACTIONS_DISPLAY_ACTIVITY' => 'Která z vašich aktivit se má zobrazovat<br />v sekci Nejnovější aktivity?',
        'NEW_CONTENT_I_ADD' => 'Mnou přidaný nový materiál',
        'NEW_COMMENTS_I_ADD' => 'Mnou přidané komentáře',
        'WHEN_I_UPDATE_MY_PROFILE' => 'Změny v mém profilu',
        'THE_LATEST_ACTIVITY_WILL_NEVER' => 'V sekci Nejnovější aktivity nebudou nikdy zobrazeny vámi odeslané zprávy, prohlédnuté stránky ani členové, vámi odmítnuté pozvánky, žádosti o přátelství ani zrušená přátelství, ani vámi odstraněné materiály.',
        'YOU_HAVENT_DONE_ANYTHING_RECENTLY' => 'Nevykázali jste žádné nové aktivity.  Co takhle se do něčeho pustit?',
        'YOUVE_TURNED_OFF_THE_ACTIVITY_DISPLAY_CLICK' => 'Zrušili jste zobrazování svých aktivit.  <a %s>Chcete-li je znovu aktivovat, klepněte sem. </a>',
        'THE_NETWORK_CREATOR_HAS_TURNED_OFF_THE_ACTIVITY' => 'Zakladatel komunity zrušil zobrazování všech aktivit.',
        'NO_ACTIVITY_TO_DISPLAY' => 'V současné době nemáte veřejně zobrazeny žádné aktivity.',
        'BOX_WILL_NOT_SHOW_ACTIVITY' => 'Tento rámeček se jiným osobám nezobrazí, dokud nevyberete aspoň jeden typ aktivit.',
        'NOTHING_IS_HAPPENING_ON_YOUR_NETWORK' => 'Žádné nové aktivity nejsou.  Co takhle se do něčeho pustit?',
        'MY_ACTIVITY_PREFERENCES' => 'Předvolby pro mé aktivity',
        'DELETE_ACTIVITY_ITEM' => 'Odebrat tuto zprávu o aktivitě',
        'DELETE_THIS_ACTIVITY_MESSAGE_Q' => 'Odebrat tuto zprávu o aktivitě?',
        'THIS_WILL_PREVENT_ACTIVITY' => 'Tuto zprávu pak nikdo neuvidí.',
        'X_HAS_POSTED_THE_MOST_PHOTOS' => '%1$s přidal(a) nejvíce %2$ssnímků%3$s',
        'X_IS_THE_MOST_POPULAR_PHOTO' => 'Zatím nejpopulárnějším snímkem je %s.',
        'X_HAS_POSTED_THE_MOST_VIDEOS' => '%1$s přidal(a) nejvíce %2$svideoklipů%3$s',
        'X_IS_THE_MOST_POPULAR_VIDEO' => 'Zatím nejpopulárnějším videoklipem je %s.',
        'X_HAS_POSTED_THE_MOST_MUSIC' => '%s přidal(a) nejvíce skladeb',
        'X_IS_THE_MOST_POPULAR_MUSIC' => 'Zatím nejpopulárnější skladbou je %s.',
        'X_IS_THE_MOST_POPULAR_TOPIC' => 'Zatím nejpopulárnějším příspěvkem ve fóru je %s.',
        'X_IS_THE_MOST_POPULAR_BLOG_POST' => 'Zatím nejpopulárnějším příspěvkem v blogu je %s.',
        'XS_LATEST_ACTIVITY_ON_APPNAME' => 'Nejnovější aktivity uživatele %s na: %s',
        'LATEST_ACTIVITY_ON_APPNAME' => 'Nejnovější aktivity na: %s',
        'ADD_MESSAGE_TO_LATEST_ACTIVITY' => 'Přidat zprávu do Nejnovějších aktivit',
        'ADD_FACTS_ABOUT_THE_NETWORK_ELLIPSIS' => 'Přidat informace o komunitě…',
        'ADD_MESSAGE' => 'Přidat zprávu',
        'ELLIPSIS_OR_WRITE_YOUR_OWN_MESSAGE' => '…nebo napište vlastní zprávu',
        'NETWORK' => 'Komunita',
        'WHO_CAN_VIEW_YOUR_PHOTOS_VIDEOS' => 'Kdo si ve výchozím nastavení smí<br/> prohlížet vaše snímky, videoklipy a blogové příspěvky?',
        'YOU_CAN_OVERRIDE_WHEN_YOU_ADD' => '(Pro konkrétní snímek, videoklip nebo blogový příspěvek můžete toto nastavení změnit po jeho přidání.)',
        'MODERATE_COMMENTS_ON_BLOG' => 'Chcete schvalovat komentáře,<br /> než se ve vašem blogu objeví?',
        'YES_LET_ME_APPROVE' => 'Ano - komentáře musí být nejprve schváleny',
        'NO_PUBLISH_COMMENTS' => 'Ne - komentáře budou zveřejněny okamžitě',
        'WHO_CAN_COMMENT_ON_PHOTOS_VIDEOS' => 'Kdo smí přidávat komentáře k vašim <br/>snímkům, videoklipům a blogovým příspěvkům?',
        'SAVE' => 'Uložit',
        'EMAIL' => 'Email',
        'YOUR_PRIVACY_IS_IMPORTANT' => 'Ochrana vašeho soukromí je pro nás velmi důležitá.  Máte-li jakékoli otázky ohledně upozornění zasílaných emailem, pošlete nám vzkaz z <a href="http://help.ning.com/?page_id=27">Centra nápovědy</a>.',
        'ADD_PHOTOS_AND_VIDEOS_TO_X_BY_SENDING' => 'Přidejte snímky nebo videoklipy do komunity %s zasláním emailem na adresu:',
        'ADD_PHOTOS_AND_VIDEOS_TO_APPNAME_FROM_PHONE' => 'Přidejte snímky nebo videoklipy do komunity %s telefonem nebo emailem na:',
        'GENERATE_NEW_EMAIL_ADDRESS' => 'Vytvořit novou emailovou adresu',
        'SUPPORTS_TEXT_EMBEDDED' => 'Podporuje text, vložené videoklipy, snímky a miniaplikace',
        'POST_COMMENT' => 'Zveřejnit komentář',
        'YOU_NEED_TO_BE_MEMBER_COMMENTS' => 'Chcete-li přidat komentář, musíte být členem komunity %s!',
        'MONTHLY_ARCHIVES' => 'Měsíční archivy',
        'NO_FRIENDS_ON_SITE' => 'V této komunitě zatím nemáte žádné přátele.',
        'NO_FRIENDS_ON_SITE_THAT_MATCH' => 'V této komunitě nemáte přátele odpovídající zadaným parametrům.',
        'MEMBERS_TAB_TEXT' => 'Členové',
        'SITE_HAS_NO_MEMBERS' => 'Tato komunita nemá zatím žádné členy!',
        'SITE_HAS_NO_MEMBERS_THAT_MATCH' => 'Tato komunita nemá žádné členy odpovídající zadaným parametrům.',
        'NO_COMMENTS_YET' => 'Zatím žádné komentáře!',
        'VIEW_ALL_COMMENTS' => 'Zobrazit všechny komentáře',
        'YOU_HAVE_NOT_ADDED_BLOG_POSTS' => 'Ještě jste žádné blogové příspěvky nepřidali!',
        'YOU_CAN_WRITE_ABOUT_ANYTHING' => 'Můžete psát, o čem chcete, a přidávat své oblíbené videoklipy, snímky a hudbu.',
        'WRITE_YOUR_FIRST_ENTRY' => 'Napište první příspěvek!',
        'THERE_ARE_NO_BLOG_POSTS' => 'Ve vaší komunitě v současné době nejsou blogové příspěvky.',
        'THERE_ARE_NO_FEATURED_X' => 'Ve vaší komunitě v současné době není žádný materiál (%s) v rubrice Zajímavé.',
        'THERE_ARE_NO_X_THAT_MATCH_SETTINGS' => 'Zvoleným parametrům neodpovídají žádné položky (%s).',
        'START_FEATURING_X_CLICK_Y' => 'Nastavte materiály (%s) jako Zajímavé, jakmile uvidíte volbu Zajímavé.  Další informace o Zajímavých materiálech a jejich nastavení získáte <a %s>klepnutím sem</a>.',
        'THIS_BOX_WILL_NOT_SHOW_BLOG_POSTS' => 'Tento rámeček se jiným osobám nezobrazí, dokud nebudou k dispozici nějaké blogové příspěvky.  Co kdybyste nějaký přidali?',
        'YOUR_FRIEND' => 'Váš přítel',
        'REQUEST_SENT' => 'Žádost odeslána!',
        'BLOCKED' => 'Blokován(a)',
        'BANNED' => 'Vykázán(a)',
        'ADD_YOUR_FIRST_BLOG_POST' => 'Napište svůj první příspěvek do blogu',
        'MY_FIRST_BLOG_POST' => 'Můj první příspěvek do blogu!',
        'TELL_THE_PEOPLE_ON' => 'Povězte ostatním na serveru %s něco o sobě.  Otázky označené <span %s>zámkem</span> jsou soukromé a viditelné pouze správci.',
        'CHOOSE_A_THEME_FOR_PAGE' => 'Zvolte motiv pro svou stránku',
        'NOW_CUSTOMIZE_PAGE' => 'A teď si stránku upravte podle svého…',
        'NO_POSTS_TO_DISPLAY' => 'Žádné příspěvky k zobrazení.',
        'YOU_ARE_DISPLAYING_NO_POSTS' => 'V současné době nemáte zveřejněny žádné příspěvky.',
        'DATE_COLON' => 'Datum:',
        'TIME_COLON' => 'Čas:',
        'CHANGE' => 'Změnit',
        'UPLOAD_A_PHOTO' => 'Uploadovat snímek',
        'OPTIONS' => 'Možnosti',
        'PIXELS' => 'Pixelů',
        'CANCEL' => 'Storno',
        'UPLOAD_A_FILE' => 'Uploadujte soubor:',
        'TO_INSERT_A_FILE' => 'Chcete-li vložit soubor, klepněte na tlačítko "Procházet" nebo "Vybrat" nahoře a vyhledejte soubor v počítači.',
        'UPLOADING' => 'Probíhá upload…',
        'OK' => 'OK',
        'POPULAR_MEMBERS' => 'Populární členové',
        'INVITE_FRIENDS' => 'Pozvat přátele',
        'VIEW_ALL' => 'Zobrazit vše',
        'REMOVE_X' => 'Odebrat: %s',
        'ARE_YOU_SURE_BAN_X_AND_CONTENT' => 'Opravdu chcete vykázat člena %1$s z komunity a odstranit všechny materiály, které %1$s přidal(a)?  Operace může trvat několik minut.',
        'REMOVING_X' => 'Odebírání: %s',
        'ARE_YOU_SURE_BAN_MEMBERS_AND_CONTENT' => 'Opravdu chcete vykázat zvoleného člena či členy z komunity a odstranit všechny materiály, které přidali?  Operace může trvat několik minut.',
        'ARE_YOU_SURE_BAN_MEMBERS' => 'Opravdu chcete vykázat zvoleného člena či členy z komunity?  Operace může trvat několik minut.',
        'BAN' => 'Vykázat',
        'REMOVING_MEMBERS' => 'Odebírání členů',
        'FEMALE' => 'žena',
        'MALE' => 'muž',
        'UNITED_STATES' => 'Spojené státy',
        'AND' => 'a',
        'FROM' => 'od:',
        'GENDER_M' => 'muž',
        'GENDER_F' => 'žena',
        'XS_PAGE_ON_Y' => 'Stránka uživatele %s na serveru %s',
        'SEARCH_MEMBERS' => 'Hledání členů',
        'SOMEBODY_COMMENTED_BLOGPOST_ADDED_TO_X' => 'Uživatel přidal(a) komentář k blogovému příspěvku, který jste přidali do: %s',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE' => 'Na své stránce máte nový komentář.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X' => 'Na své stránce na: %s máte nový komentář.',
        'YOU_HAVE_A_NEW_COMMENT_ON_YOUR_PAGE_ON_X_ELLIPSIS' => 'Na své stránce na: %s máte nový komentář…',
        'A_BLOG_POST' => 'blogový příspěvek',
        'NOW_THAT_YOU_JOINED_INVITE' => 'Výborně, jste členem. Teď už stačí jen <strong><a %s>pozvat přátele</a></strong>!',
        'THIS_IS_YOUR_PROFILE' => 'Zde je váš profil:',
        'START_BY_CUSTOMIZING_ITS_APPEARANCE' => 'Začněte <a %s>upravením jeho vzhledu</a>.',
        'USE_IT_TO_KEEP_A_BLOG_AND_DISPLAY_YOUR_PROFILE_ANSWERS' => 'Využijte ji k vedení<a %1$s> blogu</a>, a ke zveřejnění <a %2$s>odpovědí na profilové otázky</a>.',
        'START_CONTRIBUTING' => 'Začněte posílat příspěvky:',
        'UPLOAD_VIDEOS' => 'Přidejte na server videoklipy',
        'CONTRIBUTE_TO_DISCUSSIONS' => 'Posílejte příspěvky do diskusí',
        'JOIN_GROUPS' => 'Staňte se členem skupin',
        'ADD_A_BLOG_POST' => 'Přidat blogový příspěvek',
        'CLICK_TO_ACCEPT_FRIENDS' => 'Klepněte sem, chcete-li zobrazit žádosti o zařazení mezi přátele.',
        'LEAVE_X' => 'Zrušit členství v komunitě %s',
        'LEAVE_X_Q' => 'Zrušit členství v komunitě?',
        'ARE_YOU_SURE_LEAVE_X' => 'Opravdu chcete vystoupit a odstranit všechny své materiály?  Operace může trvat několik minut.',
        'BACK_TO_USERNAMES_PAGE' => '&#8592;  Zpět na stránku uživatele %s',
        'BACK_TO_MY_PAGE' => '&#8592;  Zpět na mou stránku',
        'COMMENT_WALL' => 'Nástěnka',
        'ONLINE' => 'Online',
        'MEMBER_IS_ONLINE' => 'Člen je online',
        'ONLINE_NOW' => 'Momentálně online',
        'CHOOSE_WHO_CAN_SEE_JOIN_AND_CONTRIBUTE' => 'Určete, kdo vaši komunitu smí vidět, stát se jejím členem a posílat do ní příspěvky.',
        'EMAIL_NOTIFICATIONS' => 'Upozornění emailem',
        'WHAT_NETWORK_ACTIVITY_EMAIL_FOR' => 'O jakých aktivitách v komunitě chcete být informováni emailem?',
        'NETWORK_MESSAGES' => 'Zprávy v komunitě',
        'MEMBER_ACTIVITY' => 'Aktivity členů',
        'APPROVAL' => 'Schvalování',
        'FRIEND_REQUESTS' => 'Žádosti o zařazení mezi přátele',
        'PEOPLE_IVE_INVITED_JOIN' => 'Osoby, které jsem pozval(a) ke vstupu do této komunity',
        'MESSAGES_SENT_TO_ME' => 'Zprávy pro mne',
        'MESSAGES_SENT_TO_GROUPS' => 'Zprávy ve skupinách, jichž jsem členem',
        'MESSAGES_SENT_TO_NETWORK' => 'Zprávy určené celé komunitě',
        'I_HAVE_NEW_COMMENTS' => 'Mám komentáře ke schválení',
        'I_HAVE_NEW_NETWORK_CONTENT' => 'Mám nový materiál ke schválení',
        'CONTENT_ACTIVITY' => 'Změny v obsahu a přidaných materiálech',
        'ACTIVITY_ON_THINGS_IVE_ADDED' => 'Aktivity u mnou přidaných materiálů',
        'AUTO_FOLLOW_DISCUSSIONS_I_REPLY_TO' => 'Automaticky sledovat diskuse, na něž reaguji',
        'THINGS_IVE_ADDED_APPROVED' => 'Schválení mnou přidaných materiálů',
        'NOTIFICATIONS' => 'Upozornění',
        'EMAIL_ME_WHEN_PEOPLE_REPLY' => 'Poslat email, pokud mi někdo odpoví',
        'DO_NOT_EMAIL_ME_WHEN_PEOPLE_REPLY' => 'Neposílat email, pokud mi někdo odpoví',
        'TO_STOP_FOLLOWING_THIS_X_CLICK_Y' => 'Pokud už dál nechcete sledovat tuto záležitost (%s), <a %s>klepněte sem</a>.',
        'YOU_ARE_NO_LONGER_FOLLOWING_THIS_X' => '%s už není sledován(a).',
        'NOTIFY' => 'Upozorňovat',
        'STOP_NOTIFYING' => 'Neupozorňovat',
        'EMAIL_WHEN_NEW_DISCUSSIONS' => 'Poslat email, pokud se objeví nové diskuse',
        'DO_NOT_EMAIL_WHEN_NEW_DISCUSSIONS' => 'Neposílat email, pokud se objeví nové diskuse',
        'STOP_FOLLOWING_ALL' => 'Zastavit sledování všech diskusí a blogových komentářů',
        'CHANGE_MY_PHOTO' => 'Změnit mou fotografii',
        'COUNTRY_AF' => 'Afghánistán',
        'COUNTRY_AX' => 'Alandské ostrovy',
        'COUNTRY_AL' => 'Albánie',
        'COUNTRY_DZ' => 'Alžírsko',
        'COUNTRY_AS' => 'Americká Samoa',
        'COUNTRY_AD' => 'Andorra',
        'COUNTRY_AO' => 'Angola',
        'COUNTRY_AI' => 'Anguilla',
        'COUNTRY_AQ' => 'Antarktida',
        'COUNTRY_AG' => 'Antigua a Barbuda',
        'COUNTRY_AR' => 'Argentina',
        'COUNTRY_AM' => 'Arménie',
        'COUNTRY_AW' => 'Aruba',
        'COUNTRY_AU' => 'Austrálie',
        'COUNTRY_AT' => 'Rakousko',
        'COUNTRY_AZ' => 'Ázerbájdžán',
        'COUNTRY_BS' => 'Bahamy',
        'COUNTRY_BH' => 'Bahrajn',
        'COUNTRY_BD' => 'Bangladéš',
        'COUNTRY_BB' => 'Barbados',
        'COUNTRY_BY' => 'Bělorusko',
        'COUNTRY_BE' => 'Belgie',
        'COUNTRY_BZ' => 'Belize',
        'COUNTRY_BJ' => 'Benin',
        'COUNTRY_BM' => 'Bermudy',
        'COUNTRY_BT' => 'Bhútán',
        'COUNTRY_BO' => 'Bolívie',
        'COUNTRY_BA' => 'Bosna a Hercegovina',
        'COUNTRY_BW' => 'Botswana',
        'COUNTRY_BV' => 'Bouvet',
        'COUNTRY_BR' => 'Brazílie',
        'COUNTRY_IO' => 'Britské území v Indickém oceánu',
        'COUNTRY_BN' => 'Brunej',
        'COUNTRY_BG' => 'Bulharsko',
        'COUNTRY_BF' => 'Burkina Faso',
        'COUNTRY_BI' => 'Burundi',
        'COUNTRY_KH' => 'Kambodža',
        'COUNTRY_CM' => 'Kamerun',
        'COUNTRY_CA' => 'Kanada',
        'COUNTRY_CV' => 'Kapverdy',
        'COUNTRY_KY' => 'Kajmanské ostrovy',
        'COUNTRY_CF' => 'Středoafrická republika',
        'COUNTRY_TD' => 'Čad',
        'COUNTRY_CL' => 'Chile',
        'COUNTRY_CN' => 'Čínská lidová republika',
        'COUNTRY_CX' => 'Vánoční ostrov',
        'COUNTRY_CC' => 'Kokosové a Keelingovy ostrovy',
        'COUNTRY_CO' => 'Kolumbie',
        'COUNTRY_KM' => 'Komory',
        'COUNTRY_CG' => 'Kongo, republika',
        'COUNTRY_CD' => 'Konžská demokratická republika',
        'COUNTRY_CK' => 'Cookovy ostrovy',
        'COUNTRY_CR' => 'Kostarika',
        'COUNTRY_CI' => 'Cote d Ivoire',
        'COUNTRY_HR' => 'Chorvatsko',
        'COUNTRY_CU' => 'Kuba',
        'COUNTRY_CY' => 'Kypr',
        'COUNTRY_CZ' => 'Česká republika',
        'COUNTRY_DK' => 'Dánsko',
        'COUNTRY_DJ' => 'Džibutsko',
        'COUNTRY_DM' => 'Dominika',
        'COUNTRY_DO' => 'Dominikánská republika',
        'COUNTRY_EC' => 'Ekvádor',
        'COUNTRY_EG' => 'Egypt',
        'COUNTRY_SV' => 'Salvador',
        'COUNTRY_GQ' => 'Rovníková Guinea',
        'COUNTRY_ER' => 'Eritrea',
        'COUNTRY_EE' => 'Estonsko',
        'COUNTRY_ET' => 'Etiopie',
        'COUNTRY_EU' => 'Evropská unie',
        'COUNTRY_FK' => 'Falklandské ostrovy',
        'COUNTRY_FO' => 'Faerské ostrovy',
        'COUNTRY_FJ' => 'Fidži',
        'COUNTRY_FI' => 'Finsko',
        'COUNTRY_FR' => 'Francie',
        'COUNTRY_GF' => 'Francouzská Guyana',
        'COUNTRY_PF' => 'Francouzská Polynésie',
        'COUNTRY_TF' => 'Francouzská jižní území',
        'COUNTRY_GA' => 'Gabon',
        'COUNTRY_GM' => 'Gambie',
        'COUNTRY_GE' => 'Gruzie',
        'COUNTRY_DE' => 'Německo',
        'COUNTRY_GH' => 'Ghana',
        'COUNTRY_GI' => 'Gibraltar',
        'COUNTRY_GR' => 'Řecko',
        'COUNTRY_GL' => 'Grónsko',
        'COUNTRY_GD' => 'Grenada',
        'COUNTRY_GP' => 'Guadeloupe',
        'COUNTRY_GU' => 'Guam',
        'COUNTRY_GT' => 'Guatemala',
        'COUNTRY_GN' => 'Guinea',
        'COUNTRY_GW' => 'Guinea-Bissau',
        'COUNTRY_GY' => 'Guyana',
        'COUNTRY_HT' => 'Haiti',
        'COUNTRY_HM' => 'Heardův ostrov a McDonaldovy ostrovy',
        'COUNTRY_HN' => 'Honduras',
        'COUNTRY_HK' => 'Hongkong',
        'COUNTRY_HU' => 'Maďarsko',
        'COUNTRY_IS' => 'Island',
        'COUNTRY_IN' => 'Indie',
        'COUNTRY_ID' => 'Indonésie',
        'COUNTRY_IR' => 'Írán, islámská republika',
        'COUNTRY_IQ' => 'Irák',
        'COUNTRY_IE' => 'Irsko',
        'COUNTRY_IL' => 'Izrael',
        'COUNTRY_IT' => 'Itálie',
        'COUNTRY_JM' => 'Jamajka',
        'COUNTRY_JP' => 'Japonsko',
        'COUNTRY_JO' => 'Jordánsko',
        'COUNTRY_KZ' => 'Kazachstán',
        'COUNTRY_KE' => 'Keňa',
        'COUNTRY_KI' => 'Kiribati',
        'COUNTRY_KP' => 'Korejská lidově demokratická republika',
        'COUNTRY_KR' => 'Korea, Jižní',
        'COUNTRY_KW' => 'Kuvajt',
        'COUNTRY_KG' => 'Kyrgyzstán',
        'COUNTRY_LA' => 'Laoská lidově demokratická republika',
        'COUNTRY_LV' => 'Lotyšsko',
        'COUNTRY_LB' => 'Libanon',
        'COUNTRY_LS' => 'Lesotho',
        'COUNTRY_LR' => 'Libérie',
        'COUNTRY_LY' => 'Libyjská arabská džamáhiríje',
        'COUNTRY_LI' => 'Lichtenštejnsko',
        'COUNTRY_LT' => 'Litva',
        'COUNTRY_LU' => 'Lucembursko',
        'COUNTRY_MO' => 'Macao',
        'COUNTRY_MK' => 'Makedonie, bývalá jugoslávská republika',
        'COUNTRY_MG' => 'Madagaskar',
        'COUNTRY_MW' => 'Malawi',
        'COUNTRY_MY' => 'Malajsie',
        'COUNTRY_MV' => 'Maledivy',
        'COUNTRY_ML' => 'Mali',
        'COUNTRY_MT' => 'Malta',
        'COUNTRY_MH' => 'Marshallovy ostrovy',
        'COUNTRY_MQ' => 'Martinik',
        'COUNTRY_MR' => 'Mauritánie',
        'COUNTRY_MU' => 'Mauricius',
        'COUNTRY_YT' => 'Mayotte',
        'COUNTRY_MX' => 'Mexiko',
        'COUNTRY_FM' => 'Micronesia, Federated States of',
        'COUNTRY_MD' => 'Moldova, Republic of',
        'COUNTRY_MC' => 'Monako',
        'COUNTRY_MN' => 'Mongolia',
        'COUNTRY_MS' => 'Montserrat',
        'COUNTRY_MA' => 'Maroko',
        'COUNTRY_MZ' => 'Mosambik',
        'COUNTRY_MM' => 'barmština',
        'COUNTRY_NA' => 'Namibie',
        'COUNTRY_NR' => 'Nauru',
        'COUNTRY_NP' => 'Nepál',
        'COUNTRY_NL' => 'Nizozemsko',
        'COUNTRY_AN' => 'Nizozemské Antily',
        'COUNTRY_NC' => 'Nová Kaledonie',
        'COUNTRY_NZ' => 'Nový Zéland',
        'COUNTRY_NI' => 'Nikaragua',
        'COUNTRY_NE' => 'Niger',
        'COUNTRY_NG' => 'Nigérie',
        'COUNTRY_NU' => 'Niue',
        'COUNTRY_NF' => 'Norfolk',
        'COUNTRY_MP' => 'Severní Mariany',
        'COUNTRY_NO' => 'Norsko',
        'COUNTRY_OM' => 'Omán',
        'COUNTRY_PK' => 'Pákistán',
        'COUNTRY_PW' => 'Palau',
        'COUNTRY_PS' => 'Palenstinská území, okupovaná',
        'COUNTRY_PA' => 'Panama',
        'COUNTRY_PG' => 'Papua - Nová Guinea',
        'COUNTRY_PY' => 'Paraguay',
        'COUNTRY_PE' => 'Peru',
        'COUNTRY_PH' => 'Philippines',
        'COUNTRY_PN' => 'Pitcairn',
        'COUNTRY_PL' => 'Polsko',
        'COUNTRY_PT' => 'Portugalsko',
        'COUNTRY_PR' => 'Portoriko',
        'COUNTRY_QA' => 'Katar',
        'COUNTRY_RE' => 'Réunion',
        'COUNTRY_RO' => 'Rumunsko',
        'COUNTRY_RU' => 'Rusko',
        'COUNTRY_RW' => 'Rwanda',
        'COUNTRY_SH' => 'Svatá Helena',
        'COUNTRY_KN' => 'Svatý Kryštof a Nevis',
        'COUNTRY_LC' => 'Svatá Lucie',
        'COUNTRY_PM' => 'St. Pierre a Miguelon',
        'COUNTRY_VC' => 'Sv. Vincent a Grenadiny',
        'COUNTRY_WS' => 'Samoa',
        'COUNTRY_SM' => 'San Marino',
        'COUNTRY_ST' => 'Svatý Tomáš a Princův ostrov',
        'COUNTRY_SA' => 'Saúdská Arábie',
        'COUNTRY_SN' => 'Senegal',
        'COUNTRY_CS' => 'Srbsko a Černá hora',
        'COUNTRY_SC' => 'Seychely',
        'COUNTRY_SL' => 'Sierra Leone',
        'COUNTRY_SG' => 'Singapur',
        'COUNTRY_SK' => 'Slovensko',
        'COUNTRY_SI' => 'Slovinsko',
        'COUNTRY_SB' => 'Šalamounovy ostrovy',
        'COUNTRY_SO' => 'Somálsko',
        'COUNTRY_ZA' => 'Jižní Afrika',
        'COUNTRY_GS' => 'Jižní Georgie a Jižní Sandwichovy ostrovy',
        'COUNTRY_ES' => 'Španělsko',
        'COUNTRY_LK' => '"Srí Lanka, Šrí Lanka"',
        'COUNTRY_SD' => 'Súdán',
        'COUNTRY_SR' => 'Surinam',
        'COUNTRY_SJ' => 'Svalbard a Jan Mayen',
        'COUNTRY_SZ' => 'Svazijsko',
        'COUNTRY_SE' => 'Švédsko',
        'COUNTRY_CH' => 'Switzerland',
        'COUNTRY_SY' => 'Syrská arabská republika',
        'COUNTRY_TW' => 'Tchajwan',
        'COUNTRY_TJ' => 'Tádžikistán',
        'COUNTRY_TZ' => 'Tanzanie, sjednocená republika',
        'COUNTRY_TH' => 'Thajsko',
        'COUNTRY_TL' => 'Východní Timor',
        'COUNTRY_TG' => 'Togo',
        'COUNTRY_TK' => 'Tokelau',
        'COUNTRY_TO' => 'Tonga',
        'COUNTRY_TT' => 'Trinidad a Tobago',
        'COUNTRY_TN' => 'Tunis',
        'COUNTRY_TR' => 'Turecko',
        'COUNTRY_TM' => 'Turkmenistán',
        'COUNTRY_TC' => 'Ostrovy Turks a Caicos',
        'COUNTRY_TV' => 'Tuvalu',
        'COUNTRY_UG' => 'Uganda',
        'COUNTRY_UA' => 'Ukrajina',
        'COUNTRY_AE' => 'Spojené arabské emiráty',
        'COUNTRY_GB' => 'Velká Británie',
        'COUNTRY_US' => 'Spojené státy',
        'COUNTRY_UM' => 'Americké menší zámořské ostrovy',
        'COUNTRY_UY' => 'Uruguay',
        'COUNTRY_UZ' => 'Uzbekistán',
        'COUNTRY_VU' => 'Vanuatu',
        'COUNTRY_VA' => 'Vatikán',
        'COUNTRY_VE' => 'Venezuela',
        'COUNTRY_VN' => 'Vietnam',
        'COUNTRY_VG' => 'Panenské ostrovy (britské)',
        'COUNTRY_VI' => 'Panenské ostrovy (USA)',
        'COUNTRY_WF' => 'Wallis a Futuna',
        'COUNTRY_EH' => 'Západní Sahara',
        'COUNTRY_YE' => 'Jemen',
        'COUNTRY_ZM' => 'Zambie',
        'COUNTRY_ZW' => 'Zimbabwe',
        'ERROR_LOG' => 'Chyba deníku',
        'CANNOT_READ_ERROR_LOG' => 'Nelze načíst protokol chyb',
        'CANNOT_OPEN_ERROR_LOG' => 'Nelze otevřít protokol chyb',
        'CANNOT_SCAN_ERROR_LOG' => 'Nelze prohledat protokol chyb',
        'MODELS_RESET' => 'Resetované modely:',
        'NO_MODELS_RESET' => 'Žádné resetované modely.',
        'NO_FEED_TO_DISPLAY' => 'V současné době nemáte zveřejněny žádné materiály.',
        'BOX_WILL_NOT_SHOW_FEED' => 'Tento rámeček se jiným osobám nezobrazí, dokud nevyberete aspoň jeden materiál.',
        'CLICK_EDIT_TO_SPECIFY_FEED' => 'Klepněte na volbu Upravit a zadejte kanál RSS pro tento rámeček.',
        'PROBLEM_OCCURRED_RETRIEVING_FEED' => 'Při načítání RSS kanálu došlo k problému.',
        'MORE_ELLIPSIS' => 'Podrobnosti…',
        'RSS' => 'Technologie RSS',
        'WE_ARE_SORRY_SITE_HAS_ISSUE' => 'Bohužel, na serveru došlo k problému.',
        'PLEASE_TRY_REFRESHING' => 'Zkuste stránku za 30 s obnovit, a <a %s>informujte nás,</a> pokud se tato zpráva objeví znovu.',
        'NO_DISCUSSIONS_TAGGED_X' => 'Žádné diskuse označené "%1$s" nejsou".',
        'PAGE_TITLE_COLON' => 'Název stránky:',
        'PAGE_CONTENT' => 'Obsah:',
        'CREATE_PAGE' => 'Vytvoření stránky',
        'CREATE_NEW_PAGE' => 'Vytvořit novou stránku',
        'YOUR_COMMENT' => 'Komentář',
        'ADD_YOUR_COMMENT' => 'Přidat komentář',
        'DELETE_PAGE' => 'Odstranit stránku',
        'DELETE_THIS_PAGE_Q' => 'Odstranit tuto stránku?',
        'ARE_YOU_SURE_DELETE_THIS_PAGE' => 'Opravdu chcete tuto stránku včetně všech komentářů odstranit?  Operace může trvat několik minut.',
        'SEARCH_PAGES' => 'Hledání stránek',
        'ALL_PAGES' => 'Všechny stránky',
        'SUBSCRIBE_TO_PAGES' => 'Přihlašte se k odběru informací o těchto stránkách',
        'NOBODY_HAS_ADDED_PAGES' => 'Nikdo zatím žádné stránky nepřidal!',
        'ADD_PAGES_CALL_TO_ACTION' => 'Vytvořte nějakou stránku do začátku.',
        'CREATE_A_PAGE' => 'Vytvoření stránky',
        'PLEASE_ENTER_PAGE_CONTENT' => 'Zadejte obsah stránky',
        'SEARCH_RESULTS_FOR_X' => 'Výsledky hledání pro <em>%s</em>',
        'EDIT_YOUR_PAGE' => 'Upravte si svou stránku',
        'UPDATE_PAGE' => 'Aktualizovat stránku',
        'CLOSE_DISCUSSION' => 'Uzavřít diskusi',
        'REOPEN_DISCUSSION' => 'Znovu otevřít diskusi',
        'CLOSING_DISCUSSION_PREVENTS' => 'Uzavřením diskuse zabráníte v přidávání dalších odpovědí',
        'NO_DISCUSSION_TO_DISPLAY' => 'V současné době nemáte zveřejněny žádné diskuse.',
        'BOX_WILL_NOT_SHOW_DISCUSSION' => 'Tento rámeček se jiným osobám nezobrazí, dokud nevyberete aspoň jednu diskusi.',
        'NEWEST_DISCUSSIONS' => 'Nejnovější diskuse',
        'LATEST_REPLIES' => 'Nejnovější odpovědi',
        'REPLIES_CLOSED_FOR_DISCUSSION' => 'K této diskusi už nelze přidávat odpovědi.',
        'SORRY_DISCUSSION_CLOSED' => 'Bohužel - tato diskuse už byla uzavřena, odpovědi se nepřijímají.',
        'MOST_REPLIES' => 'Většina odpovědí',
        'OWNER_DISCUSSIONS_ONLY' => 'Pouze diskuse zakladatele',
        'MY_DISCUSSIONS_ONLY' => 'Pouze mé diskuse',
        'DISCUSSION_DELETED' => 'Diskuse byla odstraněna',
        'DISCUSSION_HAS_BEEN_DELETED' => 'Tato diskuse už není k dispozici.',
        'REPLY_DELETED' => 'Odpověď odstraněna',
        'REPLY_HAS_BEEN_DELETED' => 'Tato odpověď byla odstraněna.  <a %s>Návrat do diskuse. </a>',
        'VIEW_ALL_DISCUSSIONS' => 'Zobrazit všechny diskuse',
        'ADD_CATEGORIES' => 'Přidat kategorie',
        'CATEGORY' => 'Kategorie:',
        'NO_DISCUSSIONS_IN_CATEGORY' => 'V této kategorii zatím nejsou žádné diskuse.',
        'ADD_MANAGE_CATEGORIES' => 'Přidat a spravovat kategorie',
        'VIEW_ALL_N_CATEGORIES' => 'Zobrazit všechny kategorie člena %s',
        'UNTITLED_CATEGORY' => 'Kategorie bez názvu',
        'SAMPLE_TITLE' => 'Příklad názvu',
        'UNCATEGORIZED' => 'Nezařazeno',
        'EXISTING_DISCUSSIONS' => 'Diskuse, které nebyly zařazeny do kategorie.',
        'YOU_HAVE_NOT_ADDED_CATEGORIES' => 'Žádné kategorie zatím nejsou.  Přidejte nějakou kategorii do začátku.',
        'ADD_A_CATEGORY' => 'Přidat kategorii',
        'ADD_ANOTHER_CATEGORY' => 'Přidat další kategorii',
        'MANAGE_CATEGORIES' => 'Spravovat kategorie',
        'CATEGORY_TITLE' => 'Název kategorie',
        'ALLOW_MEMBERS_TO_START_DISCUSSIONS' => 'V této kategorii mohou diskusi zahájit členové',
        'ONLY_I_CAN_START_DISCUSSIONS' => 'V této kategorii mohu diskusi zahájit jenom já',
        'ALLOW_MEMBERS_TO_REPLY' => 'Povolit členům odpovídat',
        'SUGGESTIONS' => 'Tip:',
        'TRY_DIFFERENT_KEYWORDS' => 'Zkuste jiná nebo obecnější klíčová slova',
        'VIEW_DISCUSSIONS_OR_START_DISCUSSION' => '<a %s>Zobrazit všechny diskuse</a> nebo <a %s>Zahájit novou diskusi</a>',
        'MAKE_SURE_WORDS_SPELLED' => 'Zkontrolujte, zda nemáte ve slovech překlepy',
        'REPLY_WAS_DELETED' => 'Tato odpověď byla odstraněna',
        'TAGS_X' => '<strong>Popisky:</strong> %s',
        'SEND_PRIVATE_MESSAGE' => 'Odeslat soukromou zprávu',
        'PERMALINK_TO_REPLY' => 'Vytvořit trvalý odkaz na tuto odpověď',
        'PERMALINK' => 'Trvalý odkaz',
        'WE_COULD_NOT_FIND_ANY_DISCUSSIONS' => 'Omlouváme se - na zadané parametry se nepodařilo najít žádnou diskusi.',
        'DISCUSSIONS_MATCHING_X' => 'Diskuse odpovídající zadání - <em>‘%s</em>',
        'SEARCH_DISCUSSIONS' => 'Hledat v diskusích',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS_2' => 'Ještě jste žádnou diskusi nepřidali!',
        'ADD_DISCUSSIONS_AND_SHARE' => 'Přidejte diskuse a podělte se o ně přáteli, rodinou nebo celým světem!',
        'DISCUSSION' => 'Diskuse',
        'DISCUSSIONS' => 'Diskuse',
        'KEEP_PAGE_OPEN_FORUM' => 'Tuto stránku nechte prosím otevřenou, než budou soubory odeslány do fóra.',
        'MEANWHILE_FEEL_FREE_FORUM' => 'Mezitím si můžete <a %s>otevřít nové okno prohlížeče</a> a dále pracovat s komunitou %s.',
        'START_A_NEW_DISCUSSION' => 'Zahájit novou diskusi',
        'DISCUSSION_TITLE' => 'Název diskuse:',
        'FIRST_POST' => 'Odeslat:',
        'UPLOAD_FILES' => 'Připojit soubor(y):',
        'START_DISCUSSION' => 'Zahájit diskusi',
        'EDIT_DISCUSSION' => 'Upravit diskusi',
        'START_A_DISCUSSION' => 'Zahájit diskusi',
        'ALL_DISCUSSIONS' => 'Fórum - hlavní stránka',
        'CONTRIBUTORS' => 'Přispěvatelé',
        'MY_DISCUSSIONS' => 'Moje diskuse',
        'READ_MORE' => 'Další informace',
        'STARTED_T_BY' => 'Zahájeno: <strong>%s</strong> přidal(a):',
        'ADDED_BY_X_T' => 'Přidal(a) %s',
        'STARTED_BY_X_T' => 'Zahájil(a) %s',
        'REPLY_BY_X_T' => 'Odpověď přidal(a) <strong>%s</strong> %s',
        'STARTED_BY_X_LAST_REPLY_LINK_BY_X_T' => 'Zahájil(a) %s.  Poslední <a %s>odpověď</a> přidal(a) %s %.',
        'STARTED_DISCUSSION_LAST_REPLY_LINK_BY_X_T' => '<strong>Zahájil(a) tuto diskusi. </strong> Poslední <a %s>odpověď</a> přidal(a) %s.',
        'STARTED_DISCUSSION_T' => '<strong>Zahájil(a) tuto diskusi: </strong>%s',
        'ADDED_REPLY_T' => '<strong>Přidal(a) odpověď</strong> %s',
        'ADDED_POST_T' => '<strong>Přidal(a) příspěvek</strong> %s',
        'STARTED_BY_X_ON' => 'Zahájil(a) %s na %s',
        'STARTED_DISCUSSION_ON' => '<strong>Zahájil(a) tuto diskusi: </strong>%s',
        'STARTED_ON' => '<strong>Zahájeno:</strong>%s',
        'ADDED_REPLY_ON' => '<strong>Přidal(a) odpověď</strong> %s',
        'ADDED_POST_ON' => '<strong>Přidal(a) příspěvek</strong> %s',
        'XS_DISCUSSIONS' => 'Diskuse uživatele %s',
        'XS_DISCUSSIONS_LOWERCASE' => 'Diskuse uživatele %s',
        'VIEW_XS_DISCUSSIONS' => 'Zobrazit diskuse uživatele %s',
        'VIEW_YOUR_DISCUSSIONS' => 'Zobrazit vlastní diskuse',
        'TAGGED_X' => 'Označené popiskem: %s',
        'SUBSCRIBE_TO_DISCUSSIONS' => 'Přihlásit se k odběru těchto diskusí',
        'SUBSCRIBE_TO_DISCUSSION' => 'Přihlásit se k odběru této diskuse',
        'SUBSCRIBE_TO_XS_DISCUSSIONS' => 'Přihlásit se k odběru diskusí uživatele %s',
        'ALL_DISCUSSIONS_TAGGED_X' => 'Všechny diskuse označené popiskem <em>%s</em>',
        'SUBSCRIBE_TO_DISCUSSIONS_TAGGED_X' => 'Přihlásit se k odběru informací z diskusí označených popiskem %s',
        'N_KB' => '%s kB',
        'N_MB' => '%s MB',
        'UPLOADING_FILES' => 'Probíhá upload souborů',
        'ATTACHMENTS' => 'Přílohy',
        'YOUR_POST' => 'Váš příspěvek:',
        'YOUR_REPLY' => 'Vaše odpověď:',
        'WOULD_YOU_LIKE_TO_UPLOAD_FILES' => 'Chcete na server odeslat soubory?',
        'ADD_YOUR_REPLY' => 'Přidat odpověď',
        'REPLIES_TO_THIS_DISCUSSION' => 'Odpovědi do této diskuse',
        'POSTED_BY_X_ON' => 'Přidal(a) %s %s',
        'PLEASE_ENTER_TITLE' => 'Zadejte název diskuse',
        'PLEASE_ENTER_FIRST_POST' => 'Napište první příspěvek do diskuse',
        'REPLY_TO_THIS' => 'Odpovědět',
        'DELETE_ATTACHMENT' => 'Odstranit přílohu',
        'DELETE_ATTACHMENT_Q' => 'Odstranit přílohu?',
        'DELETE_REPLY' => 'Odstranit odpověď',
        'DELETE_THIS_DISCUSSION_Q' => 'Odstranit diskusi?',
        'ARE_YOU_SURE_DELETE_THIS_DISCUSSION' => 'Opravdu chcete tuto diskusi - včetně všech odpovědí - odstranit?  Operace může trvat několik minut.',
        'DELETE_DISCUSSION' => 'Odstranit diskusi',
        'NOBODY_HAS_ADDED_DISCUSSIONS' => 'Nikdo zatím žádné diskuse nepřidal.',
        'NOBODY_HAS_ADDED_DISCUSSIONS_ADD' => 'Nikdo zatím žádné diskuse nepřidal!  Přidejte nějakou diskusi do začátku.',
        'YOU_HAVE_NOT_ADDED_DISCUSSIONS' => 'Ještě jste žádnou diskusi nepřidali.  Přidejte nějakou diskusi do začátku!',
        'YOU_HAVE_NOT_STARTED_DISCUSSIONS' => 'Ještě jste žádnou diskusi nezahájili.',
        'YOU_HAVE_NOT_ADDED_TO_DISCUSSIONS' => 'Ještě jste žádné diskuse nezahájili.',
        'X_HAS_NOT_ADDED_DISCUSSIONS' => '%s zatím žádné diskuse nepřidal(a).',
        'X_HAS_NOT_STARTED_DISCUSSIONS' => '%s zatím žádné diskuse nezahájili(a).',
        'X_HAS_NOT_ADDED_TO_DISCUSSIONS' => '%s zatím do žádných diskusí nepřispěl(a).',
        'VIEW_DISCUSSIONS' => 'Zobrazit diskuse',
        'VIEW_ALL_PEOPLE_ON_X' => 'Zobrazit všechny osoby na serveru %s',
        'THERE_ARE_NO_DISCUSSIONS' => 'Ve vaší komunitě v současné době nejsou žádné diskuse.',
        'GROUP_HAS_NO_DISCUSSIONS' => 'Tato skupina zatím žádné diskuse nemá.',
        'VIEW_DISCUSSIONS_IN_GROUP_FORUM' => 'Zobrazit diskuse ve <a %s>fóru %s</a>!',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT_ADD' => 'Žádné diskuse označené "%1$s" nejsou".  Podívejte se ale po <a %2$s>snímcích s označením "%1$s"</a> nebo <a %3$s>videoklipech s označením "%1$s"</a>.  Nebo přidejte vlastní diskuse a doplňte k nim popisky.',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_OUT' => 'Žádné diskuse označené "%1$s" nejsou".  Podívejte se ale po <a %2$s>snímcích s označením "%1$s"</a> nebo <a %3$s>videoklipech s označením "%1$s"</a>.',
        'THIS_BOX_WILL_NOT_SHOW_DISCUSSIONS' => 'Tento rámeček se jiným osobám nezobrazí, dokud nebudou k dispozici nějaké diskuse.  Co kdybyste nějakou přidali?',
        'DISCUSSIONS_I_STARTED' => 'Mnou zahájené diskuse',
        'DISCUSSIONS_X_STARTED' => 'Diskuse zahájené uživatelem %s',
        'DISCUSSIONS_I_REPLIED_TO' => 'Diskuse, na které jsem odpověděl(a)',
        'DISCUSSIONS_X_REPLIED_TO' => 'Diskuse, na které odpověděl(a) %s',
        'PLEASE_WRITE_SOMETHING_FOR_POST' => 'Napište text příspěvku.',
        'PLEASE_WRITE_SOMETHING_FOR_REPLY' => 'Napište text odpovědi.',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION_X' => 'U vaší diskuse "%s" na serveru %s je nový komentář.',
        'THERE_IS_NEW_COMMENT_ON_DISCUSSION' => 'U jedné z vašich diskusí je nový komentář.',
        'SOMEBODY_COMMENTED_DISCUSSION_ADDED_TO_X' => 'Uživatel přidal(a) komentář do diskuse, kterou jste zahájili na: %s',
        'ABOUT_YOUR_DISCUSSION' => 'O vaší diskusi',
        'ABOUT_THIS_DISCUSSION' => 'O této diskusi',
        'USER_REPLIED_TO_A_DISCUSSION_ON_Y' => '%s odpověděl(a) do diskuse na %s',
        'USER_REPLIED_TO_DISCUSSION_TITLE_ON_APPNAME' => '%s odpověděl(a) do diskuse %s na: %s',
        'PROBLEM_WITH_ICON' => 'Došlo k problémům se souborem ikony:',
        'GROUP_ADMINISTRATORS_HAVE_A_SIMILAR_LEVEL' => 'Správci skupin mají podobná práva jako jejich zakladatelé.',
        'CREATE_NEW_GROUP' => 'Vytvořit novou skupinu',
        'CREATE_A_NEW_GROUP' => 'Vytvořte novou skupinu',
        'CREATE_A_GROUP' => 'Vytvořit skupinu',
        'VIEW_GROUPS' => 'Zobrazit skupiny',
        'CREATE_GROUP' => 'Vytvořit skupinu',
        'PLEASE_ENTER_NAME_FOR_GROUP' => 'Zvolte název skupiny.',
        'PLEASE_ENTER_URL_FOR_GROUP' => 'Zvolte webovou adresu skupiny.',
        'URL_CAN_CONTAIN_ONLY_LETTERS' => 'Webová adresa smí obsahovat pouze písmena a čísla (ne mezery).',
        'NAME_TAKEN' => 'Omlouváme se - toto jméno už je obsazeno.  Zvolte jiný název.',
        'URL_TAKEN' => 'Omlouváme se - tato adresa už je obsazena.  Zvolte jinou adresu.',
        'GROUP_INFORMATION' => 'Informace o skupině',
        'EXTERNAL_WEBSITE' => 'Externí webové stránky',
        'DO_YOU_HAVE_EXISTING_WEBSITE' => 'Má už skupina webové stránky někde jinde?',
        'URL' => 'URL',
        'GROUPS' => 'Skupiny',
        'SEARCH_GROUPS' => 'Hledat ve skupinách',
        'NOBODY_HAS_CREATED_GROUPS' => 'Nikdo zatím žádné skupiny nezaložil.',
        'NOBODY_HAS_CREATED_GROUPS_ADD' => 'Nikdo zatím žádné skupiny nezaložil!  Založte nějakou skupinu do začátku.',
        'MY_GROUPS' => 'Moje skupiny',
        'FEATURED_GROUPS' => 'Zajímavé skupiny',
        'YOU_CAN_CREATE_GROUP' => 'Na serveru %2$s můžete <a %1$s>založit novou skupinu</a>!',
        'GROUP_FORUM' => 'Fórum %s',
        'USER_CREATED_GROUP' => '%s založil(a) tuto skupinu na serveru %s.',
        'GROUP_MEMBERS_COUNT' => '%s členů (%d)',
        'WE_ARE_SORRY_NOT_ALLOWED_JOIN_GROUP' => 'Bohužel, nemáte povoleno stát se členem této skupiny.',
        'JOIN_GROUP_NOW' => 'Staňte se členem komunity %s!',
        'USER_HAS_INVITED_YOU_TO_JOIN_GROUP' => '%s vás zve, abyste se stali členem: %s',
        'DECLINE' => 'Odmítnout',
        'WELCOME_TO_GROUP' => 'Vítá vás %s',
        'YOU_CAN_PARTICIPATE_IN_GROUP' => 'Teď se můžete do práce fóra %s zapojit.',
        'SEND_MESSAGE_TO_GROUP' => 'Odeslat zprávu skupině',
        'LEAVE_THIS_GROUP' => 'Vystoupit ze skupiny',
        'EDIT_GROUP_INFO' => 'Upravit informace o této skupině',
        'EDIT_GROUP_INFORMATION' => 'Upravit informace o skupině',
        'MANAGE_GROUP_MEMBERS' => 'Řídit členy skupiny',
        'GROUP_HAS_NO_MEMBERS' => 'Tato skupina nemá zatím žádné členy!',
        'GROUP_HAS_NO_MEMBERS_THAT_MATCH' => 'Tato skupina nemá členy odpovídající zadaným parametrům.',
        'USERS_GROUPS' => 'Skupiny uživatele %s',
        'YOU_HAVE_NOT_CREATED_GROUPS' => 'Zatím jste žádné skupiny nezaložili.',
        'USER_HAS_NOT_CREATED_GROUPS' => '%s zatím žádné skupiny nezaložil(a).',
        'THERE_ARE_NO_FEATURED_GROUPS' => 'Ve vaší komunitě nejsou Zajímavé skupiny.',
        'START_FEATURING_GROUPS' => 'Nastavte skupiny jako Zajímavé, jakmile uvidíte volbu Zajímavé.  Další informace o Zajímavých materiálech a jejich nastavení získáte <a %s>klepnutím sem</a>.',
        'NO_GROUPS_TO_DISPLAY' => 'V současné době nemáte zveřejněny žádné skupiny.',
        'BOX_WILL_NOT_SHOW_GROUPS' => 'Tento rámeček se jiným osobám nezobrazí, dokud nevyberete aspoň jednu skupinu.',
        'YOU_HAVE_NOT_CREATED_GROUPS_2' => 'Zatím jste žádné skupiny nezaložili!',
        'CREATE_GROUPS_AND_SHARE' => 'Založte skupiny a podělte se o ně přáteli, rodinou nebo celým světem!',
        'THERE_ARE_NO_GROUPS' => 'Ve vaší komunitě v současné době nejsou žádné skupiny.',
        'THIS_BOX_WILL_NOT_SHOW_GROUPS' => 'Tento rámeček se jiným osobám nezobrazí, dokud nebudou k dispozici nějaké skupiny.  Co kdybyste nějakou založili?',
        'GROUPS_MATCHING_SEARCH_TERM' => 'Skupiny odpovídající výrazu: <em>%s</em>',
        'WE_COULD_NOT_FIND_ANY_GROUPS' => 'Omlouváme se - na zadané parametry se nepodařilo žádné skupiny najít.',
        'VIEW_GROUPS_OR_CREATE_GROUP' => '<a %s>Zkuste volby Zobrazit všechny skupiny</a> nebo <a %s>Vytvořit novou skupinu</a>',
        'VIEW_ALL_GROUPS' => 'Zobrazit všechny skupiny',
        'DELETE_GROUP' => 'Odstranit skupinu',
        'DELETE_GROUP_Q' => 'Opravdu chcete tuto skupinu odstranit?',
        'GROUP_INVITATIONS' => 'Pozvánky do skupin',
        'YOU_HAVE_BEEN_INVITED_TO_JOIN' => 'Zveme vás, abyste se stali členem skupiny:',
        'VISIT' => 'Klepněte na adresu',
        'WHO_CAN_JOIN_GROUP' => 'Kdo se smí stát se členem této skupiny?',
        'PRIVACY_CANNOT_BE_CHANGED' => 'Úroveň soukromí nelze po založení skupiny změnit.',
        'ONLY_INVITED_PEOPLE' => 'Pouze pozvané osoby',
        'ALLOW_PEOPLE_TO_REQUEST' => 'Povolit lidem, aby požádali o pozvánku',
        'ANYONE_CAN_JOIN_GROUP' => 'Členem se může stát kdokoli',
        'ONLY_INVITED_PEOPLE_CAN_JOIN_GROUP' => 'Členem se mohou stát pouze pozvané osoby',
        'WHY_NOT_CREATE_GROUP' => 'Co takhle si <a %s>založit vlastní skupinu</a>?',
        'PLEASE_ENTER_NAME' => 'Zadejte prosím jméno.',
        'PLEASE_ENTER_EMAIL_ADDRESS' => 'Zadejte svou emailovou adresu.',
        'PLEASE_ENTER_PAGE_ADDRESS' => 'Zadejte adresu nové stránky.',
        'PLEASE_ENTER_PASSWORD' => 'Zadejte heslo.',
        'CREATE_ACCOUNT_OR_SIGN_IN' => '<a %s>Klepněte sem, chcete-li založit nový účet,</a> nebo se dole zkuste přihlásit znovu.',
        'CREATE_ACCOUNT_OR_JOIN' => '<a %s>Klepněte sem, chcete-li založit nový účet,</a> nebo se dole zkuste přihlásit pomocí uživatelského jména (Ning ID).',
        'CHOOSE_SHORTER_PASSWORD' => 'Zvolte kratší heslo.',
        'CHOOSE_SHORTER_NAME' => 'Zvolte kratší jméno.',
        'ENTER_SHORTER_CITY_NAME' => 'Zadejte kratší název města.',
        'PLEASE_ENTER_PASSWORD_AGAIN' => 'Potvrďte prosím heslo v poli "Zadejte heslo znovu".',
        'PLEASE_ENTER_CURRENT_PASSWORD' => 'Zadejte stávající heslo.',
        'PLEASE_ENTER_NEW_PASSWORD' => 'Zadejte nové heslo.',
        'PLEASE_ENTER_NEW_PASSWORD_AGAIN' => 'Potvrďte prosím heslo v poli "Zadejte heslo znovu".',
        'CURRENT_PASSWORD' => 'Stávající heslo',
        'PASSWORDS_DO_NOT_MATCH' => 'Zadaná hesla nejsou stejná.',
        'NEW_AND_CONFIRMATION_PASSWORDS' => 'Nové heslo neodpovídá jeho potvrzení.',
        'YOUR_REQUEST_HAS_BEEN_SENT_TO_GROUP_CREATOR' => 'Vaše žádost byla odeslána zakladateli skupiny.',
        'X_IS_NOT_VALID_EMAIL_ADDRESS' => '%s není platnou emailovou adresou',
        'COME_JOIN_ME_ON_GROUP' => 'Pojďte a přidejte se k nám, do komunity %s!',
        'INVITE_PEOPLE_TO_GROUP' => 'Pozvat osoby do komunity %s',
        'INVITE_TO_GROUP' => 'Pozvání do komunity "%s"',
        'INVITE_FRIENDS_TO_GROUP' => 'Pozvat přátele do komunity %s',
        'SEND_INVITATIONS_TO_JOIN_GROUP' => 'Poslat pozvánky ke členství v %s dalším osobám.',
        'GROUPNAME_MEMBERS' => '%s členů',
        'GROUP_CREATOR' => 'Základatel skupiny',
        'GROUP_ADMINISTRATOR' => 'Správce skupiny',
        'DATE_BANNED' => 'Datum vykázání',
        'BAN_FROM_GROUP' => 'Vykázán(a) ze skupiny',
        'ARE_YOU_SURE_BAN_MEMBER_FROM_GROUP' => 'Opravdu chcete vykázat zvoleného člena či členy ze skupiny?  Operace může trvat několik minut.',
        'ALSO_DELETE_FORUM_POSTINGS' => 'Odstranit i jejich příspěvky a odpovědi ve fóru.',
        'GROUP_WEB_ADDRESS' => 'Webová adresa skupiny',
        'GROUP' => 'Skupina',
        'BACK_TO_GROUP' => '← Zpět k: %s',
        'USER_BANNED_FROM_GROUP' => '%1$s byl(a) z této skupiny vykázán(a).  <a %2$s>Odeslat zprávu uživateli %1$s</a>',
        'USER_ALREADY_GROUP_MEMBER' => '%1$s už je členem této skupiny.  <a %2$s>Odeslat zprávu uživateli %1$s</a>',
        'GROUP_ADMIN_DISCUSSIONS' => 'Diskuse správců skupin',
        'BACK_TO_NETWORK_GROUPS' => 'Zpět na skupiny %s',
        'MOST_MEMBERS' => 'Většina členů',
        'THIS_SETS_URL_OF_GROUP' => 'Tímto adresu skupiny nastavíte na: <br />http://%s/<strong>adresaskupiny</strong>',
        'LIKE_WHAT_YOU_SEE' => 'Líbí se vám, co jste na serveru %s viděli?  Přidejte se!',
        'LIKE_WHAT_YOU_SEE_GROUP' => 'Líbí se vám, co jste v: %s viděli?  Přidejte se!',
        'YOU_HAVE_CREATED_GROUP_AND_CAN_INVITE' => 'Založili jste skupinu %1$s. Můžete zahájit diskusi na fóru %1$s nebo pozvat další osoby do komunity.',
        'YOU_ARE_MEMBER_OF_GROUP_AND_CAN_INVITE' => 'Stali jste se členy: %1$s.  Můžete se zapojit do diskusí na fóru %1$s nebo pozvat další osoby.',
        'NETWORK_DOES_NOT_HAVE_MUSIC' => 'Tato komunita nemá zatím uloženy žádné skladby.',
        'PERSON_DOES_NOT_HAVE_MUSIC' => 'Tato osoba nemá zatím uloženy žádné skladby.',
        'FIND_MORE_MUSIC_LIKE_THIS' => 'Vyhledat další skladby na: <em>%s</em>',
        'TRACKS' => 'Stopy',
        'ADD_MUSIC_TRACKS' => 'Přidat hudbu',
        'YOU_CAN_ADD_100_SONGS' => 'Můžete přidat celkem 100 skladeb, z nichž každá může mít velikost až 20 MB. Server podporuje skladby ve formátu .mp3.',
        'I_HAVE_RIGHT_TO_UPLOAD_SONGS' => 'Tyto skladby mám právo uploadovat v souladu s <a %s">Podmínkami služby</a>.',
        'MUSIC_UPLOADER_REQUIRES_JAVA' => 'Hromadný upload skladeb vyžaduje novější verzi Javy. <strong><a %s>Klepněte sem, chcete-li si Javu stáhnout,</a></strong> nebo <strong><a %s> se vraťte k uploadu jednotlivých souborů</a></strong>.',
        'HAVE_LOT_OF_MUSIC' => 'Chcete se podělit o spoustu skladeb?',
        'TRY_BULK_MUSIC_UPLOADER' => 'Zkuste hromadný upload skladeb',
        'SONGS_SUCCESSFULLY_UPLOADED' => 'Skladby byly úspěšně odeslány.',
        'SORRY_YOU_CAN_ONLY_HAVE_N_TRACKS' => 'Bohužel, na playlistu smíte mít pouze %s skladeb. Než přidáte další skladby, odeberte některé ze stávajících.',
        'ADD_MUSIC_FROM_WEBSITE' => 'Přidat hudbu z jiných webových stránek',
        'HAVING_PROBLEMS_WITH_MUSIC_UPLOADER' => 'Máte problém s hromadným uploadem skladby? <strong><a %s>Vraťte se k uploadu jednotlivých souborů</a></strong>.',
        'UPLOAD_MUSIC_FROM_YOUR_COMPUTER' => 'Uploadujte skladby z počítače',
        'ADD_MUSIC' => 'Přidat hudbu',
        'FACEBOOK_INSTR_SETUP_APP_PERMISSION' => 'Vyberte <strong>Uživatelé</strong> a <strong>Všechny stránky</strong>.',
        'CHOOSE_MUSIC_TRACKS' => 'Zvolte přidávané skladby',
        'YOU_CAN_ADD_UP_TO_MP3' => 'Můžete přidat až 4 soubory MP3 najednou.',
        'UPLOAD_TRACKS' => 'Uploadovat skladby',
        'ADD_TRACKS' => 'Přidat skladby',
        'ENTER_THE_URL_MP3_TO_ADD' => 'Zadejte URL každé MP3, kterou chcete přidat:',
        'EACH_MP3_FILE_MAY_BE_UP_TO' => 'Můžete na server nahrát až 100 skladeb MP3!  Každý soubor MP3 může mít velikost až 20 MB, ale menší soubory budou přeneseny rychleji!',
        'BE_NICE' => 'Nezapomeňte na dobré vychování!',
        'PLEASE_UPLOAD_ONLY_TRACKS' => 'Na server přidávejte pouze skladby, u nichž k tomu máte povolení od interpreta nebo majitele autorských práv.',
        'PLEASE_LINK_ONLY_TRACKS' => 'Odkazy přidávejte pouze na skladby, které mají povolení k distribuci po webu.',
        'MORE_WAY_TO_ADD_MUSIC' => 'Další způsoby, jak přidat skladby…',
        'ELLIP_FROM_ANOTHER_WEBSITE' => '…z jiných webových stránek',
        'ADD_MUSIC_FROM_ANY_WEBSITE' => 'Přidat hudbu z jiných stránek můžete zkopírováním odkazu na danou MP3.',
        'KEEP_PAGE_OPEN_MUSIC' => 'Tuto stránku nechte prosím otevřenou, než budou skladby přeneseny. Dáme vám vědět, až budou schváleny.',
        'MEANWHILE_FEEL_FREE_MUSIC' => 'Mezitím si můžete <a %s>otevřít nové okno prohlížeče</a> a dále pracovat s komunitou %s.  Jakmile bude přenos dokončen, budete v tomto okně moci ke skladbám přidat název a popis.',
        'TRACKS_EXCEEDED_LIMIT' => 'Skladby zřejmě překročily limit 10 MB na soubor.',
        'EDIT_TRACK_INFORMATION' => 'Upravit informace o skladbě',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_1' => 'Přidejte název, popis a další informace o nově přidaných skladbách.',
        'ADD_TITLE_DESCRIPTION_AND_OTHER_TO_TRACK_2' => 'Přidejte název, popis a další informace o této skladbě.',
        'CANCEL_AND_RETURN_TO_PLAYLIST' => '« Zrušit a vrátit se k playlistu',
        'TRACK_TITLE' => 'Název skladby',
        'TRACK_ARTIST' => 'Interpret',
        'TRACK_ALBUM' => 'Album',
        'ENABLE_DOWNLOAD_LINK' => 'Povolit odkaz ke stažení',
        'ALLOW_PEOPLE_TO_ADD_TRACK_TO_PROFILE' => 'Umožněte ostatním, aby si tuto skladbu přidali na své stránky',
        'TRACK_ARTWORK' => 'Grafika',
        'EDIT_PLAYLIST' => 'Upravit playlist',
        'DRAG_TO_CHANGE_ORDER_PLAYLIST' => 'Chcete-li změnit pořadí skladeb na seznamu, klepněte na zvolenou skladbu a přetáhněte ji na vhodné místo.',
        'ADD_MUSIC_ELLIPSIS' => 'Přidat hudbu…',
        'ELLIPSIS_FROM_YOUR_COMPUTER' => '…z počítače',
        'UPLOAD_MP3_FROM_YOUR_COMPUTER' => 'Uploadujte soubory MP3 z počítače:',
        'DELETE_THIS_TRACK_Q' => 'Odstranit skladbu?',
        'DELETE_TRACK' => 'Odstranit skladbu',
        'ARE_YOU_SURE_DELETE_THIS_TRACK' => 'Opravdu chcete tuto skladbu odstranit?',
        'PLAY' => 'přehrát',
        'GENRE' => 'Žánr',
        'YEAR' => 'Rok',
        'LABEL' => 'Značka',
        'EXPLICIT_LYRICS' => 'Nevhodné pro děti',
        'ARTIST_SITE' => 'Webové stránky interpreta',
        'HOSTING_SITE' => 'Webové stránky skladby',
        'LABEL_SITE' => 'Stránky nahrávací společnosti',
        'LICENSE' => 'Licence',
        'SELECT_LICENSE' => '- Select license -',
        'LICENSE_NAME' => 'Název licence',
        'LICENSE_URL' => 'URL licence:',
        'MUSIC' => 'Hudba',
        'ALLOW_PEOPLE_TO_UPLOAD_AND_SHARE_AUDIO' => 'Povolte ostatním uploadovat a sdílet zvukové soubory',
        'PLAYLIST' => 'Playlist',
        'PODCAST' => 'Podcasty',
        'MOST_RECENT_TRACKS' => 'Nejnovější',
        'FEATURED_TRACKS' => 'Zajímavé',
        'HIGHEST_RATED_TRACKS' => 'Nejlépe hodnocené',
        'NO_TRACKS_TO_PLAY' => 'Ve vaší komunitě v současné době nejsou žádné skladby.',
        'BOX_WILL_NOT_SHOW_TRACKS' => 'Tento rámeček se jiným osobám nezobrazí, dokud nebudou k dispozici nějaké skladby nebo podcasty.  Co kdybyste nějaké přidali?',
        'NO_TRACKS_ON_PLAYLIST' => 'V playlistu nejsou k dispozici žádné skladby.',
        'PLAYER_WILL_NOT_SHOW_TRACKS' => 'Tento přehrávač se jiným osobám nezobrazí, pokud nebudou k přehrávání nějaké skladby nebo podcasty.  Co kdybyste nějaké přidali?',
        'NO_FEATURED_TRACKS' => 'Ve vaší komunitě nejsou Zajímavé skladby.',
        'START_FEATURING_TRACKS' => 'Pokud uslyšíte zajímavou skladbu, můžete ji označit jako Zajímavou a bude potom uveřejněna na hlavní stránce.',
        'VIEW_MUSICPLAYER' => 'Zobrazit audiopřehrávač',
        'MY_PLAYLIST' => 'Můj playlist',
        'NETWORK_PLAYLIST' => 'Playlist komunity',
        'COPYRIGHT' => '©Všechna práva vyhrazena',
        'CC_BY_X' => 'Licence Creative Commons Attribution %s',
        'CC_BY_SA_X' => 'Licence Creative Commons Attribution Share Alike %s',
        'CC_BY_ND_X' => 'Licence Creative Commons Attribution No Derivatives %s',
        'CC_BY_NC_X' => 'Licence Creative Commons Attribution Non-commercial %s',
        'CC_BY_NC_SA_X' => 'Licence Creative Commons Attribution Non-commercial Share Alike %s',
        'CC_BY_NC_ND_X' => 'Licence Creative Commons Attribution Non-commercial No Derivatives %s',
        'PUBLICDOMAIN' => 'Veřejná doména',
        'FACEBOOK_CONFIRM_DISABLE' => 'Jste si jisti?',
        'FACEBOOK_PLAYER_DISABLE' => 'Deaktivovat',
        'FACEBOOK_MUSIC_PLAYER_TITLE' => 'Audiopřehrávač',
        'FACEBOOK_MUSIC_PLAYER_DESC' => 'Umožněte ostatním, aby si do svého profilu na Facebooku přidali aplikaci, která bude přehrávat vámi vybrané skladby.',
        'FACEBOOK_MUSIC_BUTTON' => 'Vytvořit hudební aplikaci &raquo;',
        'FACEBOOK_MUSIC_PLAYER_ENABLED' => 'Audiopřehrávač pro Facebook už je aktivován.',
        'FACEBOOK_VIDEO_PLAYER_TITLE' => 'Videopřehrávač',
        'FACEBOOK_VIDEO_PLAYER_DESC' => 'Umožněte ostatním, aby si do svého profilu na Facebooku přidali aplikaci, která bude přehrávat videoklipy z vaší komunity.',
        'FACEBOOK_VIDEO_BUTTON' => 'Vytvořit videoaplikaci &raquo;',
        'FACEBOOK_VIDEO_PLAYER_ENABLED' => 'Videopřehrávač pro Facebook už je aktivován.',
        'FACEBOOK_SLIDESHOW_PLAYER_TITLE' => 'Prezentace ze snímků',
        'FACEBOOK_SLIDESHOW_PLAYER_DESC' => 'Umožněte ostatním, aby si do svého profilu na Facebooku přidali aplikaci, která bude přehrávat prezentace z vaší komunity.',
        'FACEBOOK_SLIDESHOW_BUTTON' => 'Vytvořit prohlížeč prezentací &raquo;',
        'FACEBOOK_SLIDESHOW_PLAYER_ENABLED' => 'Prezentace ze snímků pro Facebook už je aktivována.',
        'FACEBOOK_PLATFORM_LOGO' => 'Logo platformy Facebook',
        'FACEBOOK_QUICK_INTRO_1' => 'Facebook, populární server pro webové komunity, umožňuje externím programátorům vytváření aplikací, které pak lze přidat na stránky členů.  Tyto aplikace jednak rozšiřují funkce na stránkách členů, ale lze je také použít k pozvání uživatelů Facebooku na jiné webové stránky.',
        'FACEBOOK_QUICK_INTRO_2' => 'U nás na Ningu k propagaci své komunity na Facebooku nemusíte být programátor.  Těžkou práci jsme odvedli za vás - vaše komunita má už aplikaci pro Facebook připravenou předem.  Vyberte si z následujících variant, a za pár vteřin bude mít vaše komunita zastoupení na Facebooku.',
        'FACEBOOK_ADD_DEVELOPER_BUTTON' => 'Přidat tlačítko pro programátory',
        'FACEBOOK_SETUP_NEW_APP_BUTTON' => 'Nastavit tlačítko Nová aplikace',
        'FACEBOOK_YOUR_APPLICATIONS' => 'Vaše aplikace pro Facebook',
        'FACEBOOK_EMBEDDING' => 'Propagace na Facebooku',
        'FACEBOOK_SETUP' => 'Propagace na Facebooku',
        'FACEBOOK_PROMOTING' => 'Propagace aplikací na Facebooku',
        'FACEBOOK_VIEW_APP' => 'Zobrazit aplikaci',
        'FACEBOOK_ADD_THE' => 'Přidat',
        'FACEBOOK_RECENT' => 'Nejnovější',
        'FACEBOOK_RECENTLY_FEATURED' => 'Naposledy označené jako Zajímavé',
        'FACEBOOK_RECENTLY_ADDED' => 'Nedávno přidané',
        'FACEBOOK_PROMOTED' => 'Zajímavé',
        'FACEBOOK_RATED' => 'Nejlépe hodnocené',
        'FACEBOOK_POPULAR' => 'Populární',
        'FACEBOOK_MUSIC_WIDGET' => 'Miniaplikace Hudba',
        'FACEBOOK_VIDEO_WIDGET' => 'Miniaplikace Videoklipy',
        'FACEBOOK_PHOTO_WIDGET' => 'Miniaplikace Snímky',
        'FACEBOOK_INSTR_FIRST_STEPS' => 'První kroky',
        'FACEBOOK_INSTR_CLICK_HERE_TO_GO_TO_FACEBOOK' => 'Klepnutím sem přejděte na Facebook a začněte s přípravou aplikace.',
        'FACEBOOK_INSTR_OPEN_FACEBOOK_IN_NEW_WINDOW' => 'Facebook se otevře v novém okně.  Pokud ještě nejste na Facebooku přihlášeni, budete to muset udělat teď.',
        'FACEBOOK_INSTR_FIRST_STEPS_1' => 'Pokud vytváříte aplikaci na Facebooku poprvé, budete vyzváni k přidání aplikace pro vývojáře (Developer application).  Jakmile to provedete, systém sdělí, "You have no applications. " Klepněte na volbu <strong>Create one</strong>.',
        'FACEBOOK_INSTR_FIRST_STEPS_2' => 'pokud už jste nějaké aplikace na Facebooku vytvořili, budete přesměrováni na aplikaci Facebook Developer.  Klepněte na tlačítko <strong>Set Up New Application</strong>.',
        'FACEBOOK_INSTR_FIRST_STEPS_NEXT' => 'Další krok: Pokyny k nastavení aplikace %s tak, aby fungovala na Facebooku.',
        'FACEBOOK_INSTR_SETUP' => 'Pokyny k instalaci',
        'FACEBOOK_INSTR_SETUP_1' => 'Výborně!  A teď podrobnosti.  Facebook potřebuje některé základní informace, aby mohl vaši aplikaci spustit.  Jednoduše postupujte podle níže uvedených pokynů.',
        'FACEBOOK_INSTR_SETUP_REQ_FIELDS' => 'Pole, která je nutno vyplnit',
        'FACEBOOK_INSTR_SETUP_2' => 'Zvolte název aplikace (<strong>Application Name</strong>).',
        'FACEBOOK_INSTR_SETUP_3' => 'Zaškrtněte políčko na znamení, že jste si přečetli podmínky Facebooku.',
        'FACEBOOK_INSTR_SETUP_4' => 'Otevřete sekci volitelných polí <em>Optional Fields</em>.',
        'FACEBOOK_INSTR_SETUP_BASE_OPT' => 'Základní možnosti',
        'FACEBOOK_INSTR_SETUP_5' => 'Zadejte svou emailovou adresu do pole <strong>Support E-Mail</strong>.',
        'FACEBOOK_INSTR_SETUP_6' => 'Do pole<strong>Callback URL</strong> vložte následující webovou adresu:',
        'FACEBOOK_INSTR_SETUP_7_EXAMPLE_X' => 'Zvolte adresu podkladové stránky v poli <strong>Canvas Page URL</strong> (např. <em>%s</em>).',
        'FACEBOOK_INSTR_SETUP_8' => 'Odpovězte <strong>Yes </strong> na otázku <em>Can your application be added on Facebook</em>.',
        'FACEBOOK_INSTR_SETUP_INST_OPT' => 'Možnosti instalace',
        'FACEBOOK_INSTR_SETUP_APP_DESC' => 'Napište popis aplikace do pole <strong>Application Description</strong>.',
        'FACEBOOK_INSTR_SETUP_9' => 'Do pole <strong>Default FBML</strong> vložte následující kód:',
        'FACEBOOK_INSTR_SETUP_9B_WIDE' => 'U parametru <strong>Default Profile Box Column</strong> vyberte možnost <strong>Wide</strong>.',
        'FACEBOOK_INSTR_SETUP_9B_NARROW' => 'U parametru <strong>Default Profile Box Column</strong> vyberte možnost <strong>Narrow</strong>.',
        'FACEBOOK_INSTR_SETUP_10' => 'Do pole <strong>Side Nav URL</strong> zadejte adresu uvedenou v parametru <em>Side Nav URL</em> (tak jak jste ji dříve zadali v kroku &#8216; #8217;  ).  Zkontrolujte, zda adresa obsahuje i řetězec http://apps.facebook.com/.',
        'FACEBOOK_INSTR_SETUP_11' => 'Napište text do pole <strong>Attachment Action</strong>.  Tento text se objeví, pokud pošlete zprávu některému z uživatelů Facebooku a budete chtít nabídnout některou z vašich aplikací.  Pokud instalujete Prezentaci ze snímků, můžete jako text zadat třeba "Snímky z (název komunity)".  Pokud instalujete videopřehrávač, můžete jako text zadat třeba "Videoklipy z (název komunity)".',
        'FACEBOOK_INSTR_SETUP_12' => 'Do pole<strong>Callback URL</strong> vložte následující webovou adresu:',
        'FACEBOOK_INSTR_APPLICATION_SETUP_PAGE' => 'Stránka nastavení aplikací pro Facebook',
        'FACEBOOK_INSTR_SETUP_DONE' => 'Jakmile budete hotovi, klepněte na tlačítko <strong>Submit</strong>.',
        'FACEBOOK_INSTR_SETUP_NEXT' => 'Další krok: Získání klíče API a tajné informace (Secret).',
        'FACEBOOK_API_INFO_TITLE' => 'Informace k API na Facebooku',
        'FACEBOOK_API_INFO_DESC' => 'K dokončení nastavení musíte zadat klíč API a heslo (Secret), a také adresu URL aplikace do polí dole.',
        'FACEBOOK_API_INFO_FIND_KEY' => 'Klíč API a Secret najdete na stránce vašich aplikací - <a %s>My Applications</a> na Facebooku (otevře se v novém okně), hned pod názvem právě vytvořené aplikace.',
        'FACEBOOK_API_INFO_MY_APPLICATIONS_PAGE' => 'Stránka My Applications (klíč API zvýrazněn)',
        'FACEBOOK_API_INFO_KEY' => 'Klíč API',
        'FACEBOOK_API_INFO_SECRET' => 'Heslo (API Secret)',
        'FACEBOOK_URL_INFO_TITLE' => 'URL aplikace na Facebooku:',
        'FACEBOOK_URL_INFO_DESC' => 'URL aplikace je totožná s adresou zadanou do pole <strong>Canvas Page URL</strong>, kterou jste definovali na předchozí stránce (v kroku &#8216; #8217; ).',
        'FACEBOOK_MUSIC_SHOULD_PLAY_FROM' => 'Hudební aplikace na Facebooku mají přehrávat:',
        'FACEBOOK_VIDEO_SHOULD_PLAY_FROM' => 'Videoaplikace na Facebooku mají přehrávat videoklip, který',
        'FACEBOOK_PHOTO_SHOULD_PLAY_FROM' => 'Prezentace na Facebooku mají promítat snímky z:',
        'FACEBOOK_PROMOTING_ON' => 'Propagace na Facebooku',
        'FACEBOOK_SETUP_INSTR' => 'Pokyny k instalaci',
        'FACEBOOK_API_INFO' => 'Informace k API',
        'FACEBOOK_DISABLE' => 'Deaktivovat aplikaci',
        'FACEBOOK_TO_YOUR_FACEBOOK_PROFILE' => 've vašem profilu na Facebooku',
        'FACEBOOK_BACK_TO_EMBEDDING' => 'Zpět na Propagaci na Facebooku',
        'FACEBOOK_EMBEDDING_DESC' => 'Umožněte uživatelům serveru Facebook, aby si umístili miniaplikace a odznaky vaší komunity na stránky svých profilů.',
        'FACEBOOK_PROMOTE' => 'Chcete-li maximálně využít propagační efekt nové aplikace, doporučujeme provést následující kroky.  Tyto volby lze nastavit na stránce My Applications<strong><a %s> na Facebooku </a></strong> (odkaz se otevře v novém okně).',
        'FACEBOOK_PROMOTE_TITLE_ABOUT_PAGE' => 'Přidejte stránku s informacemi o programu',
        'FACEBOOK_PROMOTE_TEXT_ABOUT_PAGE' => 'Ukažte uživatelům Facebooku, co je vaše aplikace zač - nabídněte jim jasný popis.  Chcete-li tyto informace upravit, klepněte na odkaz <strong>Edit About Page</strong> vedle upravované aplikace.',
        'FACEBOOK_PROMOTE_TITLE_SUBMIT' => 'Odešlete informace o aplikaci do adresáře Facebooku',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_1' => 'Propagujte novou aplikaci přidáním informací do adresáře Facebooku.',
        'FACEBOOK_PROMOTE_TEXT_SUBMIT_2' => 'Aplikaci odešlete klepnutím na odkaz <strong>Submit Application</strong> vedle upravované aplikace.  Na následující stránce můžete upravit popis aplikace (Application Description) a také přidat logo.',
        'FACEBOOK_PROMOTE_TITLE_PROFILE' => 'Přidejte aplikaci do svého profilu na Facebooku',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_1' => 'Pochlubte se aplikací jejím přidáním na vašI profilovou stránku na Facebooku. A pak už jen vyčkejte, až si jí přátelé všimnou.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_2' => 'Jednoduše klepněte na odkaz <strong>View About Page</strong> vedle dané aplikace, a poté na tlačítko Add Application na další straně.',
        'FACEBOOK_PROMOTE_TEXT_PROFILE_3' => 'Hotová aplikace bude od této chvíle umístěna v dolní části vaší profilové stránky na Facebooku!',
        'FACEBOOK_PROMOTE_MY_APPLICATIONS_PAGE' => 'Stránka My Applications na Facebooku',
        'FACEBOOK_MY_APPS' => 'My Applications',
        'FORUM_TAB_TEXT' => 'Fórum',
        'VIDEOS_TAB_TEXT' => 'Videoklipy',
        'PHOTOS_TAB_TEXT' => 'Snímky',
        'GROUPS_TAB_TEXT' => 'Skupiny',
        'YOU_COMMENTED_ON_PHOTO_TITLE' => 'Přidali jste komentář ke snímku <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_PHOTO_TITLE' => '%s přidal(a) komentář ke snímku <a %s>%s</a>',
        'YOU_COMMENTED_ON_VIDEO_TITLE' => 'Přidali jste komentář k videoklipu <a %s>%s</a>',
        'X_LINK_COMMENTED_ON_VIDEO_TITLE' => '%s přidal(a) komentář k videoklipu <a %s>%s</a>',
        'NOTIFY_BLOG_PING_SERVICES' => 'Chcete, aby byli o vámi přidaných příspěvcích vyrozuměni jiní uživatelé?',
        'YES_NOTIFY_BLOG_SERVICES' => 'Ano -- upozorňovat <a %s>pomocí serveru</a>, pokud přidám nový blogový příspěvek',
        'THERE_ARE_NO_FEATURED_MEMBERS' => 'Ve vaší komunitě nejsou žádní členové představeni jako Zajímaví.',
        'START_FEATURING_MEMBERS_CLICK_Y' => 'Nastavte členy jako Zajímavé, jakmile uvidíte volbu Zajímavé. Další informace o Zajímavých materiálech a osobách a jejich nastavení získáte <a %s>klepnutím sem</a>.',
        'THIS_IS_YOUR_PAGE' => 'Toto je vaše stránka:',
        'MESSAGES_SENT_TO_ALL_FRIENDS' => 'Zprávy zaslané všem přátelům',
        'TO_STOP_FOLLOWING_THIS_X_GO_TO' => 'Pokud už dál nechcete sledovat tuto záležitost (%s), přejděte na adresu:',
        'SHOW_ALL' => 'Zobrazit vše',
        'CHOOSE_GADGETS' => 'Vyberte si některou z těchto skvělých miniaplikací OpenSocial a přidejte si ji na stránku svého profilu! Zde si můžete <a %s>prohlédnout a ohodnotit miniaplikace</a>, nebo <a %s>si přečíst další informace o platformě OpenSocial</a>.',
        'GADGETS_UNAVAILABLE' => 'Miniaplikace dočasně nejsou k dispozici',
        'APOLOGIES_GADGETS_UNAVAILABLE' => 'Omlouváme se - miniaplikace dočasně nejsou k dispozici.',
        'BOX_WILL_NOT_SHOW_GADGET' => 'Tento rámeček se jiným osobám nezobrazí, dokud nevyberete některou miniaplikaci.',
        'CLICK_EDIT_TO_SPECIFY_GADGET_OR_VISIT_GADGET_GALLERY' => 'Klepněte na volbu Upravit a zadejte adresu miniaplikace pro tento rámeček nebo navštivte <a %s>Adresář miniaplikací</a>.',
        'PROBLEM_OCCURRED_RETRIEVING_GADGET' => 'Při načítání adresy kanálu miniaplikace došlo k problému.',
        'ADD_GADGET_TO_YOUR_PAGE' => 'Přidejte miniaplikaci do svého profilu',
        'GADGETS_BETA' => 'Miniaplikace (beta provoz)',
        'TRY_OUT_OPENSOCIAL_GADGETS_WARNING_EXPERIMENTAL' => 'Vyzkoušejte si miniaplikace postavené na platformě OpenSocial. Upozornění: tato funkce je experimentální.',
        'ADD_TO_MY_PAGE' => 'Přidat na mou stránku',
        'GADGETS' => 'Miniaplikace',
        'GADGETS_TAB_TEXT' => 'Miniaplikace',
        'GADGET' => 'Miniaplikace',
        'GADGETS_IS_IN_BETA' => 'Miniaplikace jsou v beta verzi.',
        'SORRY_GADGET_UNAVAILABLE' => 'Bohužel, tato miniaplikace není dostupná. Zkontrolujte správnost adresy. Pokud problémy trvají, <a %s>informujte nás prosím</a>.',
        'NO_DISCUSSIONS_TAGGED_X_CHECK_ADD' => 'Žádné diskuse nejsou označené popiskem "%1$s". Prohlédněte si snímky (<a %2$s>) s označením "%1$s"</a>, blogové příspěvky (<a %4$s>) s označením "%1$s"</a> nebo videoklipy (<a %3$s>) s označením "%1$s"</a>. Nebo přidejte vlastní diskuse a doplňte k nim popisky.',
        'NO_DISCUSSIONS_TAGGED_X_CHECK' => 'Žádné diskuse nejsou označené popiskem "%1$s". Prohlédněte si snímky (<a %2$s>) s označením "%1$s"</a>, blogové příspěvky (<a %4$s>) s označením "%1$s"</a> nebo videoklipy (<a %3$s>) s označením "%1$s"</a>.',
        'ALREADY_MEMBER_OF_GROUP' => '(už je členem této skupiny)',
        'INVITE_YOUR_FRIENDS_TO_GROUPNAME' => 'Pozvěte přátele do komunity "%s"',
        'COME_JOIN_ME_ON_X_ON_Y' => 'Pojďte a přidejte se k nám, do komunity %1$s na: %2$s.',
        'COME_JOIN_ME_ON_X_ON_Y_ELLIPSIS' => 'Pojďte a přidejte se k nám, do komunity %1$s na %2$s...',
    );

    /**
     * If the given widget title is the default English title for the widget,
     * translate it into the current language.
     *
     * @param string $widgetTitle  The title of the widget
     * @return string  A translated title if the title is the English default; otherwise, the title unchanged
     */
    public static function translateDefaultWidgetTitle($widgetTitle) {

        return $widgetTitle;
    }

}