<?php
/**
 * An invitation to a group.
 *
 * @param $fromProfile		XN_Profile 	the person sending the invitation
 * @param $url 				string		the target URL for the message
 * @param $body				string  	the message from the sender (nl2br will be applied). If empty, default is used
 * @param $members			list<W_Content> Members to include into the email
 * @param $counters			list<string>
 * @param $features			list<string>
 * @param $message			hash		Message common info
 * @param $sparse			bool		Display "sparse" view
 * @param $helper			XG_MessageHelper
 */
$username = $helper->userName($fromProfile->screenName);
$appName = $message['appName'];

if (!$body) {
	$body = xg_text('COME_JOIN_ME_ON_X_EXCL', $appName) . "\n\n" . xg_text('THANX_USERNAME',$username);
}
$helper->header();
echo xg_text('USER_HAS_INVITED_YOU_TO_JOIN_NETWORK', $username, $appName),"\n";
$helper->delimiter();
echo $body,"\n";
echo "\n";
echo xg_text('CHECK_OUT_X_COLON', $appName),"\n";
echo $url,"\n";
echo "\n";
echo xg_text('IF_YOUR_CLIENT_NOLINKS'),"\n";
if (!$sparse) {
	$helper->delimiter();
	echo xg_text('MEMBERS_ALREADY_ON_X', $appName),"\n";
	$i = 0; foreach($members as $m) {
		if ($i) { echo ", "; }
		echo $helper->userName($m->title);
		$i++;
	}
	echo "\n";
}
$helper->aboutNetwork($sparse);
$helper->delimiter();
$helper->unsubscribe();
