<?php
/**
 * An invitation to a group.
 *
 * @param $fromProfile		XN_Profile 	the person sending the invitation
 * @param $url 				string		the target URL for the message
 * @param $body				string  	the message from the sender (nl2br will be applied). If empty, default is used
 * @param $members			list<W_Content> Members to include into the email
 * @param $counters			list<string>
 * @param $features			list<string>
 * @param $message			hash		Message common info
 * @param $sparse			bool		Display "sparse" view
 * @param $helper			XG_MessageHelper
 */
$username = $helper->userName($fromProfile->screenName);
$userUrl = xnhtmlentities(xg_absolute_url(User::quickProfileUrl($fromProfile->screenName)));
$appName = xnhtmlentities($message['appName']);
$url = xnhtmlentities($url);

if (!$body) {
	$body = xg_html('COME_JOIN_ME_ON_X_EXCL', $appName) . '<br /><br />' . nl2br(xg_html('THANX_USERNAME',$username));
} else {
	$body = nl2br(xnhtmlentities($body));
}
?>
<table width="98%" border="0" cellspacing="0" cellpadding="0">
	<tr>
		<td bgcolor="#FFFFFF" width="100%">
			<%$helper->header()%>
			<table cellpadding="0" cellspacing="0" border="0" width="600">
				<tr>
					<td width="*" style="font-size:12px;padding-top:8px" valign="top">
						<table cellspacing="0" cellpadding="0" width="100%">
							<tr>
								<?php if ($enableImages) {?>
								<td width="96" valign="top" style="padding-right:16px;font-size:12px">
									<?php if ($counters && !$sparse) {?>
										<a href="<%=$userUrl%>"><img height="96" width="96" border="0" alt="<%=xnhtmlentities(xg_excerpt(xg_username($fromProfile->screenName),14))%>" src="<%=$this->addImageByUrl(xg_url(XG_UserHelper::getThumbnailUrl($fromProfile,96,96), 'xn_auth=no'))%>"></a>
										<div style="padding-bottom:6px;"><a href="<%=$userUrl%>" style="text-decoration:none"><%=xg_html('PROFILE_LINK_HAS',"href=\"$userUrl\" style=\"text-decoration:none\"", $helper->shortUserName($fromProfile->screenName))%></a></div>
										<span style="font-size:11px"><%=join('<br />',$counters)%></span>
									<?php } else {
										$helper->userUrl($fromProfile);
									}?>
								</td>
								<?php }?>
								<td width="*" valign="top" style="font-size:12px">
									<div style="font-size:14px; font-weight:bold; padding-bottom:8px"><%= xg_html('USER_HAS_INVITED_YOU_TO_JOIN_NETWORK', $username, $appName) %></div>
									<div style="font-size:12px"><%=xnhtmlentities($message['appDescription'])%></div>
									<%$helper->delimiter()%>
									<%=$body%>
									<br /><br />
									<div style="font-weight:bold;font-size:12px"><%=xg_html('CHECK_OUT_X_COLON', $appName)%></div>
									<a href="<%=$url%>"><%=$url%></a><br />
								</td>
							</tr>
						</table>
<?php if (!$sparse && $enableImages) {?>
						<%$helper->delimiter()%>
						<table cellpadding="0" cellspacing="0" border="0">
							<tr>
								<td style="padding-bottom:6px;font-size:12px;color:#000"><%=xg_html('MEMBERS_ALREADY_ON_X', $appName)%></td>
							</tr>
							<tr>
								<td>
									<table>
										<tr>
											<?php foreach($members as $m) {
												$url = xnhtmlentities(xg_absolute_url(User::quickProfileUrl($m->title)));
											?>
												<td style="text-align:center; padding-right:10px;" valign="top">
													<a href="<%=$url%>"><img height="64" width="64" border="0" alt="<%=xnhtmlentities(xg_excerpt(xg_username($m->title),14))%>" src="<%=$this->addImageByUrl(xg_url(XG_UserHelper::getThumbnailUrl($m,64,64),'xn_auth=no'))%>"></a><br />
													<a href="<%=$url%>" style="font-size:11px; text-decoration:none"><%=$helper->shortUserName($m->title)%></a>
												</td>
											<?php }?>
										</tr>
									</table>
								</td>
							</tr>
						</table>
<?php }?>
						<%$helper->aboutNetwork($sparse)%>
						<%$helper->delimiter()%>
						<%$helper->unsubscribe()%>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
