<?php
/** Message template for a notification that somebody has sent you a friend request
 *
 * @param $profile XN_Profile The profile of the friend request sender
 * @param $isMember boolean Whether or not the user is a member of the network the request is sent from
 */

$profileLink =  $_SERVER['HTTP_HOST'] . User::profileUrl($profile->screenName) . '?xgp=friend';
if (! $isMember) {
    $profileLink = $_SERVER['HTTP_HOST'] . '/?xgp=friend';
}

echo xg_text('X_HAS_ADDED_YOU_AS_A_FRIEND_ON_Y', xg_username($profile), $message['appName']) . "\n\n";

echo xg_text('TO_ACCEPT_THIS_FRIEND_REQUEST_VISIT') . "\n";
echo 'http://' . $profileLink . "\n\n";

echo "--\n";
echo xg_text('TO_CONTROL_WHICH_EMAILS_YOUR_RECEIVE_ON_X_GO_TO', $message['appName']) . "\n";
echo $message['unsubscribeUrl'];
