<?php

/**
 * Useful functions for displaying list pages, like the photo/list and video/list pages.
 */
class XG_ListTemplateHelper {

    /**
     * Displays the list page.
     *
     * If you are caching the output, you may need to explicitly
     * call XG_App::ningLoaderRequire('xg.shared.PagePicker').
     *
     * @param $cssInfix string  string to use for the middle part of the CSS classes, e.g., albums
     * @param $featuredTitleText string  plain text for the title of the Featured section
     * @param $featuredObjects array  the promoted XN_Content objects to display
     * @param $showViewAllFeaturedUrl boolean  whether to show the View All link in the Featured section
     * @param $viewAllFeaturedUrl string  URL for the View All link in the Featured section
     * @param $titleHtml string  inner HTML for the <h1>, or null to omit it.
     *         Warning: this will not be escaped, so use xnhtmlentities() on user-supplied values.
     * @param $objects array  the XN_Content objects to display
     * @param $numObjects integer  the total number of objects
     * @param $rowSize integer  number of objects per row
     * @param $pageSize integer  the number of objects per page
     * @param $sortOptions array  array of arrays, each with displayText, url, and selected; or null to hide the Sort By drop-down
     * @param $searchUrl string  URL for the search endpoint
     * @param $searchButtonText string the text that appears for the search button. Defaults to xg_text('SEARCH') optional
     * @param $extraTemplateArgs array  extra arguments to pass to the model templates.
     *         Model templates are passed $i denoting their overall position, $column denoting their
     *         position in the row, and ${type} for the object (e.g., $photo)
     * @param $feedUrl string  URL of the comment feed, or null if no such feed exists.
     *         Ignored for private networks and private groups.
     * @param $feedTitle string  title for the comment feed
     * @param $feedFormat string  "atom" or "rss"
     * @param $noObjectsSubtitle string  plain text for the subheading displayed when there are no objects
     * @param $noObjectsMessageHtml string  inner HTML for the <p> displayed when there are no objects
     * @param $noObjectsLinkUrl string  URL for the page for adding new objects
     * @param $noObjectsLinkText string  plain text for the link, e.g., Add Photos
     * @param $noObjectsLinkIcon boolean  class name for the link icon, e.g., add
     */
    public static function outputListPage($args) {
        XG_App::includeFileOnce('/lib/XG_PaginationHelper.php');
        foreach ($args as $key => $value) { ${$key} = $value; }
        if ($_GET['test_empty']) { $objects = $featuredObjects = array(); $numObjects = 0; }
        if (count($featuredObjects) && ! mb_strlen($_GET['q'])) { ?>
            <h1><%= xnhtmlentities($featuredTitleText) %></h1>
            <div class="xg_module">
                <div class="xg_module_body nopad body_<%= $cssInfix %>_feature">
                    <ul class="clist">
                        <?php
                        $i = 0;
                        foreach($featuredObjects as $object) {
                            W_Content::create($object)->render('featuredListItem', array_merge(array('column' => $i, 'i' => $i, self::lcfirst($object->type) => $object), $extraTemplateArgs));
                            $i++;
                        } ?>
                    </ul>
                </div>
                <?php
                if ($showViewAllFeaturedUrl) { ?>
                    <div class="xg_module_foot">
                        <p class="right"><a href="<%= xnhtmlentities($viewAllFeaturedUrl) %>"><%= xg_html('VIEW_ALL') %></a></p>
                    </div>
                <?php
                } ?>
            </div>
        <?php
        }
        if ($titleHtml) {
            if ($numObjects > 0 && mb_strlen($_GET['q'])) { $titleHtml = xg_html('SEARCH_RESULTS_N', $numObjects); }
            if ($numObjects == 0 && mb_strlen($_GET['q'])) { $titleHtml = xg_html('NO_RESULTS_FOR_SEARCH_TERM', xnhtmlentities($_GET['q'])); } ?>
            <h1><%= $titleHtml %></h1>
        <?php
        } ?>
        <div class="xg_module">
            <?php
            if ($numObjects == 0 && mb_strlen($_GET['q'])) { ?>
                <div class="xg_module_body">
                    <?php self::outputSearchForm($searchUrl, $searchButtonText); ?>
                </div>
                <div class="xg_module_body">
                    <p><%= xg_html('NO_RESULTS_FOUND_FOR_SEARCH_TERM', xnhtmlentities($_GET['q'])) %></p>
                </div>
            <?php
            } elseif ($numObjects == 0) { ?>
                <div class="xg_module_body">
                    <?php
                    if ($noObjectsSubtitle) { echo '<h3>' . xnhtmlentities($noObjectsSubtitle) . '</h3>'; }
                    echo '<p>' . $noObjectsMessageHtml . '</p>';
                    if ($noObjectsLinkUrl) { echo '<p><a href="' . xnhtmlentities($noObjectsLinkUrl) . '" ' . ($noObjectsLinkIcon ? 'class="bigdesc ' . $noObjectsLinkIcon . '"' : '') . '>' . xnhtmlentities($noObjectsLinkText) . '</a></p>'; } ?>
                </div>
            <?php
            } else { ?>
                <div class="xg_module_body">
                    <?php
                    self::outputSearchForm($searchUrl, $searchButtonText);
                    if ($sortOptions && count($sortOptions) > 1 && $numObjects) {
                        XG_App::ningLoaderRequire('xg.shared.PagePicker');
                        $json = new NF_JSON(); ?>
                        <p class="right" style="display:none">
                        <%= xg_html('SORT_BY') %> <select  dojoType="PagePicker" _options="<%= xnhtmlentities($json->encode($sortOptions)) %>"></select>
                        </p>
                    <?php
                    } ?>
                </div>
                <div class="xg_module_body nopad body_<%= $cssInfix %>_main">
                    <?php
                    $i = 0;
                    foreach(array_chunk($objects, $rowSize) as $row) {
                        $column = 0; ?>
                        <ul class="clist">
                            <?php
                            foreach ($row as $object) {
                                W_Content::create($object)->render('listItem', array_merge(array('column' => $column, 'i' => $i, self::lcfirst($object->type) => $object), $extraTemplateArgs));
                                $i++;
                                $column++;
                            } ?>
                        </ul>
                    <?php
                    } ?>
                    <?php XG_PaginationHelper::outputPagination($numObjects, $pageSize); ?>
                </div>
                <?php
                if (XG_App::appIsPrivate() || XG_GroupHelper::groupIsPrivate()) { $feedUrl = null; }
                if ($feedUrl) {
                    xg_autodiscovery_link($feedUrl, $feedTitle, $feedFormat); ?>
                    <div class="xg_module_foot">
                        <p class="left">
                            <a class="desc rss" href="<%= xnhtmlentities($feedUrl) %>"><%= xg_html('RSS') %></a>
                        </p>
                    </div>
                <?php
                }
            } ?>
        </div>
    <?php
    }

    /**
     * Displays the form for doing searches.
     *
     * @param $searchUrl string  URL for the search endpoint
     * @param $searchButtonText string the text that appears for the search button.  Defaults to xg_text('SEARCH')
     */
    private static function outputSearchForm($searchUrl, $searchButtonText = null) {
        if (is_null($searchButtonText)) { $searchButtonText = xg_text('SEARCH'); } ?>
        <form action="<%= xnhtmlentities($searchUrl) %>">
            <p class="left">
                <input name="q" type="text" class="textfield" size="19" value="<%= xnhtmlentities($_GET['q']) %>" /> <input type="submit" class="button" value="<%= xnhtmlentities($searchButtonText) %>" />
                <?php
                // $searchUrl's query string variables will be ignored, so add them as hidden inputs [Jon Aquino 2008-02-06]
                $urlParts = parse_url($searchUrl);
                $queryStringVariables = array();
                if (mb_strlen($urlParts['query'])) { parse_str($urlParts['query'], $queryStringVariables); }
                foreach ($queryStringVariables as $key => $value) { ?>
                    <input type="hidden" name="<%= xnhtmlentities($key) %>" value="<%= xnhtmlentities($value) %>" />
                <?php
                } ?>
            </p>
        </form>
    <?php
    }

    /**
     * Lowercases the first character in the string.
     *
     * @param $string string  the ASCII string to transform
     * @return string  the string with lower-case first character
     */
    private static function lcfirst($string) {
        // TODO: Use XG_LangHelper::lcfirst() [Jon Aquino 2008-03-12]
        $string[0] = mb_strtolower($string[0]);
        return $string;
    }

}
