<?php

/**
 * Contains helper functions to do with widget config.
 */
class XG_ConfigHelper {

    // Ordering for add features page.  Names match those in FeatureController.
    // New widgets should be added to this list with an appropriate value and
    // new and old networks will update automatically.
    protected static $ADD_FEATURES_SORT_ORDER = array(
        '_members'      => 10,
        'photo'         => 20,
        'video'         => 30,
        'forum'         => 40,
        'activity'      => 50,
        'events'        => 60,
        'html'          => 70,
        'music'         => 80,
        'groups'        => 90,
        'notes'         => 100,
        'profiles'      => 110,
        '_description'  => 120,
        '_badges'       => 130,
        'feed'          => 140,
        '_ads'          => 150,
        '_createdBy'    => 160,
        'gadgets'       => 170
    );

    /**
     * Load the current addFeaturesSortOrder configuration and add any
     * values from the canonical order that do not already appear in the
     * sort order.  Existing values, customized or not, are not affected.
     * If the sort order does not exist at all a copy of the canonical
     * sort order is added to the main widget config.
     *
     * Used to determine sort order of features on the Add Features page.
     *
     * The canonical order contained in this routine should be updated
     * with a key->value pair for the any new widget type that is added
     * to Bazel.  If it is not added the new widget will sort dead last
     * on the Add Features page.
     */
    public static function updateAddFeaturesSortOrder() {
        $widget = W_Cache::getWidget('main');
        $currentOrder = unserialize($widget->config['addFeaturesSortOrder']);
        if (! $currentOrder) { $currentOrder = array(); }
        // Pass in $currentOrder last so that we don't overwrite existing values.
        $newOrder = array_merge(self::$ADD_FEATURES_SORT_ORDER, $currentOrder);
        if ($currentOrder != $newOrder) {
            $widget->config['addFeaturesSortOrder'] = serialize($newOrder);
            $widget->saveConfig();
        }
    }
}
